
-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
CREATE TABLE IF NOT EXISTS `sections` (
  `sec_id` int NOT NULL AUTO_INCREMENT,
  `sec_key` varchar(255) NOT NULL,
  `sec_ba_key` varchar(255) NOT NULL,
  `sec_title` text NOT NULL,
  `sec_particular` text NOT NULL,
  `sec_subtitle` text NOT NULL,
  `sec_subparticular` text NOT NULL,
  `sec_data` longtext NOT NULL,
  `sec_status` tinyint NOT NULL DEFAULT '1',
  `sec_date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sec_date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`sec_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1830 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `sections`
--

INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(16, 'B62TTiXeiiZsMifHbjiuKFg8k', 'IlioTGUfdCK101s4e1C8shDks', 'Title', 'The Administrators-General Act, 1963', '', '', '{\"1\":[\"The Administrators-General Act, 1963\",\"An Act to consolidate and amend the law relating to the office and duties of Administrators-General.\\r\\n\\r\\nBE it enacted by Parliament in the Fourteenth Year of the Republic of India as follows:-\"]}', 1, '2020-11-04 10:45:28', '2020-11-04 10:45:28'),
(15, 'miQg7QCo736mCPQ8j2prsOK9e', 'nxIiiEE4gztuO9ffi2O2ye40Z', 'Title', 'The Acquired Territories (Merger) Act, 1960', '', '', '{\"1\":[\"Short title\",\"This Act may be called the Acquired Territories (Merger) Act, 1960.\"],\"2\":[\"Definitions\",\"In this Act, unless the context otherwise requires,-\\r\\n\\r\\n(a) \\\"acquired territories\\\" mean so much of the territories comprised in the Indo-Pakistan agreements and referred to in the First Schedule as are demarcated for the purpose of being acquired by India in pursuance of the said agreements;\\r\\n\\r\\n(b) \\\"appointed day\\\" means such date1 as the Central Government may, by notification in the Official Gazette, appoint for the merger of the acquired territories under section 3, after causing the territories to be so acquired demarcated for the purpose, and different dates may be appointed for the merger of such territories into different States;\\r\\n\\r\\n(c) \\\"assembly constituency\\\", \\\"council constituency\\\" and \\\"parliamentary constituency\\\" have the same meanings as in the Representation of the People Act, 1950 (43 of 1950);\\r\\n\\r\\n(d) \\\"Indo-Pakistan agreements\\\" mean the Agreements dated the 10th day of September, 1958, the 23rd day of October, 1959 and the 11th day of January, 1960 entered into between the Governments of India and Pakistan, the relevant extracts of which are set out in the Second Schedule;\\r\\n\\r\\n(e) \\\"law\\\" includes any enactment, ordinance, regulation, order, bye-law, rule, scheme, notification or other instrument having the force of law in the whole or in any part of the acquired territory;\\r\\n\\r\\n(f) \\\"sitting member\\\", in relation to either House of Parliament or of the Legislature of a State, means a person who, immediately before the appointed day, is a member of that House;\\r\\n\\r\\n(g) \\\"State concerned\\\", in relation to the acquired territories referred to in Part I, Part II and Part III of the First Schedule, means, respectively, the State of Assam, the State of Punjab and the State of West Bengal; and \\\"State Government concerned\\\" shall be construed accordingly;\\r\\n\\r\\n(h) \\\"Union purposes\\\" mean the purposes of Government relatable to any of the matters mentioned in List I of the Seventh Schedule to the Constitution.\"],\"3\":[\"Merger of acquired territories\",\"(1) As from the appointed day, the acquired territories referred to in Part I, Part II and Part III of the First Schedule shall, respectively be included in, and form part of the States of Assam, Punjab and West Bengal.\\r\\n\\r\\n(2) As from the appointed day, the State Government concerned shall, by order in the Official Gazette, provide for the administration of the acquired territories included in that State by including them or any part of them in such district, sub-division, police station or other administrative unit as may be specified in the order.\\r\\n\\r\\n1. 17th January, 1961, vide notification No. G.S.R. 74, dated 14th January, 1961, see Gazette of India, Extraordinary, Part II, sec. 3(i).\"]}', 1, '2020-11-04 10:34:18', '2020-11-04 10:41:32'),
(17, 'ZEL0ajkau48PdCyTyD6jmBY6b', 'IlioTGUfdCK101s4e1C8shDks', 'Chapter III', 'Rights, Powers and Duties of the Administrator-General', '(a)', 'Grant of letters of administration and probate', '{\"1\":[\"Jurisdiction of High Court for the whole State\",\"So far as regards the Administrator-Generalof any State, the High Court shall be deemed to be a Court of competent jurisdiction for the purpose of granting probate or letters of administration under any law for the time being in force, wheresoever within the State the estate to be administered is situate:\\r\\n\\r\\nProvided that nothing in this section shall be construed as affecting the jurisdiction of any district court\"],\"2\":[\"Administrator-General entitled to letters of administration, unless granted to next-of-kin\",\"Any letters of administration granted by the High Court shall be granted to theAdministrator-General of the State unless they are granted to the next-of-kin of the deceased.\"]}', 1, '2020-11-04 10:46:56', '2020-11-04 10:46:56'),
(20, 'wVs5Ya4qQeHcOk9Pl2ORcYCGS', 'jhzMrWnph5VEuwC7MXaUfGryI', 'Act No.30 of 1955', 'Contents', '', '', '{\"1\":[\"1.Short title and commencement.\",\"(1) This Act may be called the Abducted Persons (Recovery and Restoration) Continuance Act, 1955.\\r\\n\\r\\n(2) It shall be deemed to have come into force on the 30th day of May, 1955.\"],\"2\":[\"2. Amendment of section \",\"In sub-section (3) of section 1 of the Abducted Persons (Recovery and Restoration) Act, 1949 (45 of 1949), for the words and figures \\\"31st day of May, 1955\\\", the words and figures \\\"30th day of November, 1956\\\", shall be substituted.\"],\"3\":[\"3. Repeal of Ordinance 2 of 1955\",\"The Abducted Persons (Recovery and Restoration) Continuance Ordinance, 1955 (2 of 1955), is hereby repealed.\\r\\n\\r\\n\"]}', 1, '2020-12-09 17:23:38', '2020-12-09 17:26:22'),
(19, 'QwgRHki1zqpKfwoxHfqQIwFDA', 'r2PbGbnpXIzPXKpLrnRNkmDxB', '[Act No. 7 of 1903]', '[20th March, 1903.]', '', '', '{\"1\":[\"Title\",\"An Act to provide for imposing restrictions upon the use and enjoyment of land in the vicinity of works of defence in order that such land may be kept free from buildings and other obstructions, and for determining the amount of compensation to be made on account of such imposition. WHEREAS it is expedient to provide for imposing restrictions upon the use and enjoyment of land in the vicinity of works of defence in order that such land may be kept free from buildings and other obstructions and for determining the amount of compensation to be made on account of such imposition; It is hereby enacted as follows:-\"]}', 1, '2020-12-08 14:20:40', '2020-12-08 14:20:40'),
(22, '4kSeOxI6iRzodbSxsMmifjKro', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART I', 'THE UNION AND ITS TERRITORY', '', '', '{\"1\":[\"1 Name and territory of the Union.\",\"1(1) India, that is Bharat, shall be a Union of States.\\r\\n(2) The States and the territories thereof shall be as specified in the First Schedule.\\r\\n(3) The territory of India shall comprise\\u2014\\r\\n(a) the territories of the States;\\r\\n(b) the Union territories specified in the First Schedule; and\\r\\n(c) such other territories as may be acquired\\r\\n\"],\"2\":[\"2 Admission or establishment of new States.\",\"2. Parliament may by law admit into the Union, or establish, new States on such terms and conditions as it thinks fit.\"],\"3\":[\"3 Formation of new States and alteration of areas, boundaries or names of existing States.\",\"3. Parliament may by law\\u2014 \\r\\n(a) form a new State by separation of territory from any State or by uniting two or more States or parts of States or by uniting any territory to a part of any State; or name of any of the States, the Bill has been referred by the President to the Legislature of that State for expressing its views thereon within such period as may be specified in the reference or within such further period as the President may allow and the period so specified or allowed has expired\\r\\n(b) increase the area of any State; \\r\\n(c) diminish the area of any State; \\r\\n(d) alter the boundaries of any State; (e) alter the name of any State: \\r\\nProvided that no Bill for the purpose shall be introduced in either House of Parliament except on the recommendation of the President and unless, where the proposal contained in the Bill affects the area, boundaries or name of any of the States, the Bill has been referred by the President to the Legislature of that State for expressing its views thereon within such period as may be specified in the reference or within such further period as the President may allow and the period so specified or allowed has expired.\\r\\n\"],\"4\":[\"4. Laws made under Articles 2 and 3 to provide for the amendment of the First and the Fourth Schedules and supplemental, incidental and consequential matters\",\"(1) Any law referred to in Article 2 or Article 3 shall contain such provisions for the amendment of the First Schedule and the Fourth Schedule as may be necessary to give effect to the provisions of the law and may also contain such supplemental, incidental and consequential provisions (including provisions as to representation in Parliament and in the Legislature or Legislatures of the State or States affected by such law) as Parliament may deem necessary.\\r\\n(2) No such law as aforesaid shall be deemed to be an amendment of this Constitution for the purposes of Article 368.\\r\\n\"]}', 1, '2021-01-29 05:10:10', '2021-01-29 12:44:59'),
(37, 'L4atzXqIKd1Ofn1Cv5SefLb8Z', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part V CHAPTER 3', 'LEGISLATIVE POWERS OF THE PRESIDENT', '', '', '{\"1\":[\"123. Power of President to promulgate Ordinances during recess of Parliament\",\"(1) If at any time, except when both Houses of Parliament are in session, the President is satisfied that circumstances exist which render it necessary for him to take immediate action, he may promulgate such Ordinances as the circumstances appear to him to require.\\r\\n(2) An Ordinance promulgated under this article shall have the same force and effect as an Act of Parliament, but every such Ordinance\\u2014\\r\\n(a) shall be laid before both Houses of Parliament and shall cease to operate at the expiration of six weeks from the reassembly of Parliament, or, if before the expiration of that period resolutions disapproving it are passed by both Houses, upon the passing of the second of those resolutions; and\\r\\n(b) may be withdrawn at any time by the President.\\r\\n(3) If and so far as an Ordinance under this article makes any provision which Parliament would not under this Constitution be competent to enact, it shall be void.\"]}', 1, '2021-01-30 23:39:52', '2021-01-30 23:39:52'),
(38, '5Vp4fFpe9DYdg3opZ2q13C08n', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part V CHAPTER 4', 'THE UNION JUDICIARY', '', '', '{\"1\":[\"124. Establishment and constitution of Supreme Court\",\"(1) There shall be a Supreme Court of India consisting of a Chief Justice of India and, until Parliament by law prescribes a larger number, of not more than [thirty-three] other Judges.\\r\\n(2) Every Judge of the Supreme Court shall be appointed by the President by warrant under his hand and seal [on the recommendation of the National Judicial Appointments Commission referred to in Article 124-A] and shall hold office until he attains the age of sixty-five years\\r\\n(2-A) The age of a Judge of the Supreme Court shall be determined by such authority and in such manner as Parliament may by law provide.\\r\\n(3) A person shall not be qualified for appointment as a Judge of the Supreme Court unless he is a citizen of India and\\u2014\\r\\n(a) has been for at least five years a Judge of a High Court or of two or more such Courts in succession; or\\r\\n(b) has been for at least ten years an advocate of a High Court or of two or more such Courts in succession; or\\r\\n(c) is, in the opinion of the President, a distinguished jurist.\\r\\n(4) A Judge of the Supreme Court shall not be removed from his office except by an order of the President passed after an address by each House of Parliament supported by a majority of the total membership of that House and by a majority of not less than two-thirds of the members of that House present and voting has been presented to the President in the same session for such removal on the ground of proved misbehaviour or incapacity.\\r\\n(5) Parliament may by law regulate the procedure for the presentation of an address and for the investigation and proof of the misbehaviour or incapacity of a Judge under clause (4).\\r\\n(6) Every person appointed to be a Judge of the Supreme Court shall, before he enters upon his office, make and subscribe before the President, or some person appointed in that behalf by him, an oath or affirmation according to the form set out for the purpose in the Third Schedule.\\r\\n(7) No person who has held office as a Judge of the Supreme Court shall plead or act in any court or before any authority within the territory of India.\\r\\n\\r\\n\"],\"2\":[\"124-A. National Judicial Appointments Commission\",\"(1) There shall be a Commission to be known as the National Judicial Appointments Commission consisting of the following, namely\\u2014\\r\\n(a) the Chief Justice of India, Chairperson, ex officio;\\r\\n(b) two other senior Judges of the Supreme Court next to the Chief Justice of India \\u2014Members, ex officio;\\r\\n(c) the Union Minister in charge of Law and Justice \\u2014Member, ex officio;\\r\\n(d) two eminent persons to be nominated by the committee consisting of the Prime Minister, the Chief Justice of India and the Leader of Opposition in the House of the People or where there is no such Leader of Opposition, then, the Leader of single largest Opposition Party in the House of the People \\u2014Members:\\r\\nProvided that one of the eminent person shall be nominated from amongst the persons belonging to the Scheduled Castes, the Scheduled Tribes, Other Backward Classes, Minorities or Women:\\r\\nProvided further that an eminent person shall be nominated for a period of three years and shall not be eligible for re-nomination.\\r\\n(2) No act or proceedings of the National Judicial Appointments Commission shall be questioned or be invalidated merely on the ground of the existence of any vacancy or defect in the constitution of the Commission.\\r\\n\"],\"3\":[\"124-B. Functions of Commission\",\"It shall be the duty of the National Judicial Appointments Commission to\\u2014\\r\\n(a) recommend persons for appointment as Chief Justice of India, Judges of the Supreme Court, Chief Justices of High Courts and other Judges of High Courts;\\r\\n(b) recommend transfer of Chief Justices and other Judges of High Courts from one High Court to any other High Court; and\\r\\n(c) ensure that the person recommended is of ability and integrity\\r\\n\"],\"4\":[\"124-C. Power of Parliament to make law\",\"Parliament may, by law, regulate the procedure for the appointment of Chief Justice of India and other Judges of the Supreme Court and Chief Justices and other Judges of High Courts and empower the Commission to lay down by regulations the procedure for the discharge of its functions, the manner of selection of persons for appointment and such other matters as may be considered necessary by it\"],\"5\":[\"125. Salaries, etc., of Judges\",\"(1) There shall be paid to the Judges of the Supreme Court such salaries as may be determined by Parliament by law and, until provision in that behalf is so made, such salaries as are specified in the Second Schedule.\\r\\n(2) Every Judge shall be entitled to such privileges and allowances and to such rights in respect of leave of absence and pension as may from time to time be determined by or under law made by Parliament and, until so determined, to such privileges, allowances and rights as are specified in the Second Schedule:\\r\\nProvided that neither the privileges nor the allowances of a Judge nor his rights in respect of leave of absence or pension shall be varied to his disadvantage after his appointment\\r\\n\"],\"6\":[\"126. Appointment of acting Chief Justice\",\"When the office of Chief Justice of India is vacant or when the Chief Justice is, by reason of absence or otherwise, unable to perform the duties of his office, the duties of the office shall be performed by such one of the other Judges of the Court as the President may appoint for the purpose.\"],\"7\":[\"127. Appointment of ad hoc Judges\",\"(1) If at any time there should not be a quorum of the Judges of the Supreme Court available to hold or continue any session of the Court, 130[the National Judicial Appointments Commission on a reference made to it by the Chief Justice of India, may with the previous consent of the President] and after consultation with the Chief Justice of the High Court concerned, request in writing the attendance at the sittings of the Court, as an ad hoc Judge, for such period as may be necessary, of a Judge of a High Court duly qualified for appointment as a Judge of the Supreme Court to be designated by the Chief Justice of India.\\r\\n(2) It shall be the duty of the Judge who has been so designated, in priority to other duties of his office, to attend the sittings of the Supreme Court at the time and for the period for which his attendance is required, and while so attending he shall have all the jurisdiction, powers and privileges, and shall discharge the duties, of a Judge of the Supreme Court.\\r\\n\"],\"8\":[\"128. Attendance of retired Judges at sittings of the Supreme Court\",\"Notwithstanding anything in this Chapter, 131[the National Judicial Appointments Commission] may at any time, with the previous consent of the President, request any person who has held the office of a Judge of the Supreme Court or of the Federal Court 132[or who has held the office of a Judge of a High Court and is duly qualified for appointment as a Judge of the Supreme Court] to sit and act as a Judge of the Supreme Court, and every such person so requested shall, while so sitting and acting, be entitled to such allowances as the President may by order determine and have all the jurisdiction, powers and privileges of, but shall not otherwise be deemed to be, a Judge of that Court:\\r\\nProvided that nothing in this article shall be deemed to require any such person as aforesaid to sit and act as a Judge of that Court unless he consents so to do.\\r\\n\"],\"9\":[\"129. Supreme Court to be a court of record\",\"The Supreme Court shall be a court of record and shall have all the powers of such a court including the power to punish for contempt of itself.\"],\"10\":[\"130. Seat of Supreme Court\",\"The Supreme Court shall sit in Delhi or in such other place or places, as the Chief Justice of India may, with the approval of the President, from time to time, appoint.\"],\"11\":[\"131. Original jurisdiction of the Supreme Court\",\"Subject to the provisions of this Constitution, the Supreme Court shall, to the exclusion of any other court, have original jurisdiction in any dispute\\u2014\\r\\n(a) between the Government of India and one or more States; or\\r\\n(b) between the Government of India and any State or States on one side and one or more other States on the other; or\\r\\n(c) between two or more States,\\r\\nif and in so far as the dispute involves any question (whether of law or fact) on which the existence or extent of a legal right depends\\r\\n\"],\"12\":[\"132. Appellate jurisdiction of Supreme Court in appeals from High Courts in certain cases\",\".\\u2014(1) An appeal shall lie to the Supreme Court from any judgment, decree or final order of a High Court in the territory of India, whether in a civil, criminal or other proceeding, [if the High Court certifies under Article 134-A] that the case involves a substantial question of law as to the interpretation of this Constitution.\\r\\n(2) Where such a certificate is given,  any party in the case may appeal to the Supreme Court on the ground that any such question as aforesaid has been wrongly decided\\r\\n\"],\"13\":[\"133. Appellate jurisdiction of Supreme Court in appeals from High Courts in regard to civil matters\",\"(1) An appeal shall lie to the Supreme Court from any judgment, decree or final order in a civil proceeding of a High Court in the territory of India \\r\\n(a) that the case involves a substantial question of law of general importance; and\\r\\n(b) that in the opinion of the High Court the said question needs to be decided by the Supreme Court.\\r\\n(2) Notwithstanding anything in Article 132, any party appealing to the Supreme Court under clause (1) may urge as one of the grounds in such appeal that a substantial question of law as to the interpretation of this Constitution has been wrongly decided.\\r\\n(3) Notwithstanding anything in this article, no appeal shall, unless Parliament by law otherwise provides, lie to the Supreme Court from the judgment, decree or final order of one Judge of a High Court.\\r\\n\"],\"14\":[\"134. Appellate jurisdiction of Supreme Court in regard to criminal matters\",\". (1) An appeal shall lie to the Supreme Court from any judgment, final order or sentence in a criminal proceeding of a High Court in the territory of India if the High Court\\u2014\\r\\n(a) has on appeal reversed an order of acquittal of an accused person and sentenced him to death; or\\r\\n(b) has withdrawn for trial before itself any case from any court subordinate to its authority and has in such trial convicted the accused person and sentenced him to death; or\\r\\n(c)  certifies under Article 134-A that the case is a fit one for appeal to the Supreme Court:\\r\\nProvided that an appeal under sub-clause (c) shall lie subject to such provisions as may be made in that behalf under clause (1) of Article 145 and to such conditions as the High Court may establish or require.\\r\\n(2) Parliament may by law confer on the Supreme Court any further powers to entertain and hear appeals from any judgment, final order or sentence in a criminal proceeding of a High Court in the territory of India subject to such conditions and limitations as may be specified in such law.\\r\\n\"],\"15\":[\"134-A. Certificate for appeal to the Supreme Court\",\"Every High Court, passing or making a judgment, decree, final order, or sentence, referred to in clause (1) of Article 132 or clause (1) of Article 133, or clause (1) of Article 134,\\u2014\\r\\n(a) may, if it deems fit so to do, on its own motion; and\\r\\n(b) shall, if an oral application is made, by or on behalf of the party aggrieved, immediately after the passing or making of such judgment, decree, final order or sentence,\\r\\ndetermine, as soon as may be after such passing or making, the question whether a certificate of the nature referred to in clause (1) of Article 132, or clause (1) of Article 133 or, as the case may be, sub-clause (c) of clause (1) of Article 134, may be given in respect of that case.\\r\\n\"],\"16\":[\"135. Jurisdiction and powers of the Federal Court under existing law to be exercisable by the Supreme Court\",\". Until Parliament by law otherwise provides, the Supreme Court shall also have jurisdiction and powers with respect to any matter to which the provisions of Article 133 or Article 134 do not apply if jurisdiction and powers in relation to that matter were exercisable by the Federal Court immediately before the commencement of this Constitution under any existing law.\"],\"17\":[\"136. Special leave to appeal by the Supreme Court\",\"(1) Notwithstanding anything in this Chapter, the Supreme Court may, in its discretion, grant special leave to appeal from any judgment, decree, determination, sentence or order in any cause or matter passed or made by any court or tribunal in the territory of India.\\r\\n(2) Nothing in clause (1) shall apply to any judgment, determination, sentence or order passed or made by any court or tribunal constituted by or under any law relating to the Armed Forces.\\r\\n\"],\"18\":[\"137. Review of judgments or orders by the Supreme Court\",\"Subject to the provisions of any law made by Parliament or any rules made under Article 145, the Supreme Court shall have power to review any judgment pronounced or order made by it.\"],\"19\":[\"138. Enlargement of the jurisdiction of the Supreme Court\",\" (1) The Supreme Court shall have such further jurisdiction and powers with respect to any of the matters in the Union List as Parliament may by law confer.\\r\\n(2) The Supreme Court shall have such further jurisdiction and powers with respect to any matter as the Government of India and the Government of any State may by special agreement confer, if Parliament by law provides for the exercise of such jurisdiction and powers by the Supreme Court.\\r\\n\"],\"20\":[\"139. Conferment on the Supreme Court of powers to issue certain writs\",\"139. Conferment on the Supreme Court of powers to issue certain writs. Parliament may by law confer on the Supreme Court power to issue directions, orders or writs, including writs in the nature of habeas corpus, mandamus, prohibition, quo warranto and certiorari, or any of them, for any purposes other than those mentioned in clause (2) of Article 32.\\r\\n\"],\"21\":[\"139-A. Transfer of certain cases\",\" (1) Where cases involving the same or substantially the same questions of law are pending before the Supreme Court and one or more High Courts or before two or more High Courts and the Supreme Court is satisfied on its own motion or on an application made by the Attorney-General of India or by a party to any such case that such questions are substantial questions of general importance, the Supreme Court may withdraw the case or cases pending before the High Court or the High Courts and dispose of all the cases itself:\\r\\nProvided that the Supreme Court may after determining the said questions of law return any case so withdrawn together with a copy of its judgment on such questions to the High Court from which the case has been withdrawn, and the High Court shall on receipt thereof, proceed to dispose of the case in conformity with such judgment.\\r\\n(2) The Supreme Court may, if it deems it expedient so to do for the ends of justice, transfer any case, appeal or other proceedings pending before any High Court to any other High Court.\\r\\n\"],\"22\":[\"140. Ancillary powers of Supreme Court\",\"Parliament may by law make provision for conferring upon the Supreme Court such supplemental powers not inconsistent with any of the provisions of this Constitution as may appear to be necessary or desirable for the purpose of enabling the Court more effectively to exercise the jurisdiction conferred upon it by or under this Constitution.\"],\"23\":[\"141. Law declared by Supreme Court to be binding on all courts\",\"The law declared by the Supreme Court shall be binding on all courts within the territory of India.\"],\"24\":[\"142. Enforcement of decrees and orders of Supreme Court and orders as to discovery, etc\",\"(1) The Supreme Court in the exercise of its jurisdiction may pass such decree or make such order as is necessary for doing complete justice in any cause or matter pending before it, and any decree so passed or order so made shall be enforceable throughout the territory of India in such manner as may be prescribed by or under any law made by Parliament and, until provision in that behalf is so made, in such manner as the President may by order prescribe.\\r\\n(2) Subject to the provisions of any law made in this behalf by Parliament, the Supreme Court shall, as respects the whole of the territory of India, have all and every power to make any order for the purpose of securing the attendance of any person, the discovery or production of any documents, or the investigation or punishment of any contempt of itself.\\r\\n\"],\"25\":[\"143. Power of President to consult Supreme Court\",\"(1) If at any time it appears to the President that a question of law or fact has arisen, or is likely to arise, which is of such a nature and of such public importance that it is expedient to obtain the opinion of the Supreme Court upon it, he may refer the question to that Court for consideration and the Court may, after such hearing as it thinks fit, report to the President its opinion thereon.\\r\\n(2) The President may, notwithstanding anything in  the proviso to Article 131, refer a dispute of the kind mentioned in the [said proviso] to the Supreme Court for opinion and the Supreme Court shall, after such hearing as it thinks fit, report to the President its opinion thereon.\\r\\n\"],\"26\":[\"144. Civil and judicial authorities to act in aid of the Supreme Court\",\"All authorities, civil and judicial, in the territory of India shall act in aid of the Supreme Court.\"],\"27\":[\"145. Rules of Court, etc\",\"(1) Subject to the provisions of any law made by Parliament, the Supreme Court may from time to time, with the approval of the President, make rules for regulating generally the practice and procedure of the Court including\\u2014\\r\\n(a) rules as to the persons practising before the Court;\\r\\n(b) rules as to the procedure for hearing appeals, and other matters pertaining to appeals including the time within which appeals to the Court are to be entered;\\r\\n(c) rules as to the proceedings in the Court for the enforcement of any of the rights conferred by Part III\\r\\n(d) rules as to the entertainment of appeals under sub-clause (c) of clause (1) of Article 134;\\r\\n(e) rules as to the conditions subject to which any judgment pronounced or order made by the Court may be reviewed and the procedure for such review including the time within which applications to the Court for such review are to be entered;\\r\\n(f) rules as to the costs of and incidental to any proceedings in the Court and as to the fees to be charged in respect of proceeding therein;\\r\\n(g) rules as to the granting of bail;\\r\\n(h) rules as to stay of proceedings;\\r\\n(i) rules providing for the summary determination of any appeal which appears to the Court to be frivolous or vexatious or brought for the purpose of delay;\\r\\n(j) rules as to the procedure for inquiries referred to in clause (1) of Articles 317.\\r\\n(2) Subject to the [provisions of clause 3, rules made under this article may fix the minimum number of Judges who are to sit for any purpose, and may provide for the powers of single Judges and Division Courts.\\r\\n(3) The minimum number of Judges who are to sit for the purpose of deciding any case involving a substantial question of law as to the interpretation of this Constitution or for the purpose of hearing any reference under Article 143 shall be five:\\r\\nProvided that, where the Court hearing an appeal under any of the provisions of this Chapter other than Article 132 consists of less than five Judges and in the course of the hearing of the appeal the Court is satisfied that the appeal involves a substantial question of law as to the interpretation of this Constitution the determination of which is necessary for the disposal of the appeal, such Court shall refer the question for opinion to a Court constituted as required by this clause for the purpose of deciding any case involving such a question and shall on receipt of the opinion dispose of the appeal in conformity with such opinion.\\r\\n(4) No judgment shall be delivered by the Supreme Court save in open Court, and no report shall be made under Article 143 save in accordance with an opinion also delivered in open Court.\\r\\n(5) No judgment and no such opinion shall be delivered by the Supreme Court save with the concurrence of a majority of the Judges present at the hearing of the case, but nothing in this clause shall be deemed to prevent a Judge who does not concur from delivering a dissenting judgment or opinion.\\r\\n\\r\\n\"],\"28\":[\"146. Officers and servants and the expenses of the Supreme Court\",\"(1) Appointments of officers and servants of the Supreme Court shall be made by the Chief Justice of India or such other Judge or officer of the Court as he may direct:\\r\\nProvided that the President may by rule require that in such cases as may be specified in the rule, no person not already attached to the Court shall be appointed to any office connected with the Court, save after consultation with the Union Public Service Commission.\\r\\n(2) Subject to the provisions of any law made by Parliament, the conditions of service of officers and servants of the Supreme Court shall be such as may be prescribed by the rules made by the Chief Justice of India or by some other Judge or officer of the Court authorised by the Chief Justice of India to make rules for the purpose:\\r\\nProvided that the rules made under this clause shall, so far as they relate to salaries, allowances, leave or pensions, require the approval of the President.\\r\\n(3) The administrative expenses of the Supreme Court, including all salaries, allowances and pensions payable to or in respect of the officers and servants of the Court, shall be charged upon the Consolidated Fund of India, and any fees or other moneys taken by the Court shall form part of that Fund.\\r\\n\"],\"29\":[\"147. Interpretation\",\"In this Chapter and in Chapter V of Part VI references to any substantial question of law as to the interpretation of this Constitution shall be construed as including references to any substantial question of law as to the interpretation of the Government of India Act, 1935 (including any enactment amending or supplementing that Act), or of any Order in Council or order made thereunder, or of the Indian Independence Act, 1947, or of any order made thereunder.\"]}', 1, '2021-01-30 23:51:18', '2021-01-31 00:43:26'),
(23, 'yWco2rQWh0xU79XyqVVJCXhIX', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART II', 'CITIZENSHIP', '', '', '{\"1\":[\"5. Citizenship at the commencement of the Constitution\",\"At the commencement of this Constitution every person who has his domicile in the territory of India and\\u2014\\r\\n(a) who was born in the territory of India; or\\r\\n(b) either of whose parents was born in the territory of India; or\\r\\n(c) who has been ordinarily resident in the territory of India for not less than five years immediately preceding such commencement, shall be a citizen of India.\"],\"2\":[\"6. Rights of citizenship of certain persons who have migrated to India from Pakistan\",\"Notwithstanding anything in Article 5, a person who has migrated to the territory of India from the territory now included in Pakistan shall be deemed to be a citizen of India at the commencement of this Constitution if\\u2014\\r\\n(a) he or either of his parents or any of his grand-parents was born in India as defined in the Government of India Act, 1935 (as originally enacted); and\\r\\n(b) (i) in the case where such person has so migrated before the nineteenth day of July, 1948, he has been ordinarily resident in the territory of India since the date of his migration, or\\r\\n(ii) in the case where such person has so migrated on or after the nineteenth day of July, 1948, he has been registered as a citizen of India by an officer appointed in that behalf by the Government of the Dominion of India on an application made by him therefor to such officer before the commencement of this Constitution in the form and manner prescribed by that Government:\\r\\nProvided that no person shall be so registered unless he has been resident in the territory of India for at least six months immediately preceding the date of his application.\"],\"3\":[\"7. Rights of citizenship of certain migrants to Pakistan\",\"Notwithstanding anything in Articles 5 and 6, a person who has after the first day of March, 1947, migrated from the territory of India to the territory now included in Pakistan shall not be deemed to be a citizen of India:\\r\\nProvided that nothing in this article shall apply to a person who, after having so migrated to the territory now included in Pakistan, has returned to the territory of India under a permit for resettlement or permanent return issued by or under the authority of any law and every such person shall for the purposes of clause (b) of Article 6 be deemed to have migrated to the territory of India after the nineteenth day of July, 1948.\"],\"4\":[\"8. Rights of citizenship of certain persons of Indian origin residing outside India.\",\"Notwithstanding anything in Article 5, any person who or either of whose parents or any of whose grand-parents was born in India as defined in the Government of India Act, 1935 (as originally enacted), and who is ordinarily residing in any country outside India as so defined shall be deemed to be a citizen of India if he has been registered as a citizen of India by the diplomatic or consular representative of India in the country where he is for the time being residing on an application made by him therefor to such diplomatic or consular representative, whether before or after the commencement of this Constitution, in the form and manner prescribed by the Government of the Dominion of India or the Government of India.\"],\"5\":[\"9. Persons voluntarily acquiring citizenship of a foreign State not to be citizens\",\"No person shall be a citizen of India by virtue of Article 5, or be deemed to be a citizen of India by virtue of Article 6 or Article 8, if he has voluntarily acquired the citizenship of any foreign State.\"],\"6\":[\"10. Continuance of the rights of citizenship\",\"Every person who is or is deemed to be a citizen of India under any of the foregoing provisions of this Part shall, subject to the provisions of any law that may be made by Parliament, continue to be such citizen.\"],\"7\":[\"11. Parliament to regulate the right of citizenship by law\",\"Nothing in the foregoing provisions of this Part shall derogate from the power of Parliament to make any provision with respect to the acquisition and termination of citizenship and all other matters relating to citizenship.\"]}', 1, '2021-01-29 23:03:50', '2021-01-29 12:45:02');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(25, 'rVI4T8QjZH0tOPueZjWm52LJh', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART  III', 'FUNDAMENTAL RIGHTS', '', '', '{\"1\":[\"12. Definition\",\"In this part, unless the context otherwise requires, \\u201cthe State\\u201d includes the Government and Parliament of India and the Government and the Legislature of each of the States and all local or other authorities within the territory of India or under the control of the Government of India.\"],\"2\":[\"13. Laws inconsistent with or in derogation of the fundamental rights\",\"All laws in force in the territory of India immediately before the commencement of this Constitution, in so far as they are inconsistent with the provisions of this Part, shall, to the extent of such inconsistency, be void.\\r\\n(2) The State shall not make any law which takes away or abridges the rights conferred by this Part and any law made in contravention of this clause shall, to the extent of the contravention, be void.\\r\\n(3) In this article, unless the context otherwise requires,\\r\\n(a) \\u201claw\\u201d includes any Ordinance, order, bye-law, rule, regulation, notification, custom or usage having in the territory of India the force of law;\\r\\n(b) \\u201claws in force\\u201d includes laws passed or made by a Legislature or other competent authority in the territory of India before the commencement of this Constitution and not previously repealed, notwithstanding that any such law or any part thereof may not be then in operation either at all or in particular areas.\\r\\n\"],\"3\":[\"14. Equality before law\",\"The State shall not deny to any person equality before the law or the equal protection of the laws within the territory of India.\"],\"4\":[\"15. Prohibition of discrimination on grounds of religion, race, caste, sex or place of birth\",\"(1)\\r\\nThe State shall not discriminate against any citizen on grounds only of religion, race, caste, sex, place of birth or any of them.\\r\\n(2) No citizen shall, on grounds only of religion, race, caste, sex, place of birth or any of them, be subject to any disability, liability, restriction or condition with regard to\\u2014\\r\\n(a) access to shops, public restaurants, hotels and places of public entertainment; or\\r\\n(b) the use of wells, tanks, bathing ghats, roads and places of public resort maintained wholly or partly out of State funds or dedicated to the use of the general public.\\r\\n(3) Nothing in this article shall prevent the State from making any special provision for women and children.\\r\\n (4) Nothing in this article or in clause (2) of Article 29 shall prevent the State from making any special provision for the advancement of any socially and educationally backward classes of citizens or for the Scheduled Castes and the Scheduled Tribes.]\\r\\n [(5) Nothing in this article or in sub-clause (g) of clause (1) of Article 19 shall prevent the State from making any special provision, by law, for the advancement of any socially and educationally backward classes of citizens or for the Scheduled Castes or the Scheduled Tribes insofar as such special provisions relate to their admission to educational institutions including private educational institutions, whether aided or unaided by the State, other than the minority educational institutions referred to in clause (1) of Article 30.]  [(6) Nothing in this article or sub-clause (g) of clause (1) of Article 19 or clause (2) of Article 29 shall prevent the State from making,\\r\\n(a) any special provision for the advancement of any economically weaker sections of citizens other than the classes mentioned in clauses (4) and (5); and\\r\\n(b) any special provision for the advancement of any economically weaker sections of citizens other than the classes mentioned in clauses (4) and (5) insofar as such special provisions relate to their admission to educational institutions including private educational institutions, whether aided or unaided by the State, other than the minority educational institutions referred to in clause (1) of Article 30, which in the case of reservation would be in addition to the existing reservations and subject to a maximum of ten per cent of the total seats in each category.\\r\\n\"],\"5\":[\"16. Equality of opportunity in matters of public employment\",\"There shall be equality of opportunity for all citizens in matters relating to employment or appointment to any office under the State.\\r\\n(2) No citizen shall, on grounds only of religion, race, caste, sex, descent, place of birth, residence or any of them, be ineligible for, or discriminated against in respect of, any employment or office under the State.\\r\\n(3) Nothing in this article shall prevent Parliament from making any law prescribing, in regard to a class or classes of employment or appointment to an office [under the Government of, or any local or other authority within, a State or Union territory, any requirement as to residence within that State or Union territory]13 prior to such employment or appointment.\\r\\n(4) Nothing in this article shall prevent the State from making any provision for the reservation of appointments or posts in favour of any backward class of citizens which, in the opinion of the State, is not adequately represented in the services under the State.\\r\\n [(4-A) Nothing in this article shall prevent the State from making any provision for reservation in matters of promotion [, with consequential seniority,] to any class or classes of posts in the services under the State in favour of the Scheduled Castes and the Scheduled Tribes which, in the opinion of the State, are not adequately represented in the services under the State.]\\r\\n [(4-B) Nothing in this article shall prevent the State from considering any unfilled vacancies of a year which are reserved for being filled up in that year in accordance with any provision for reservation made under clause (4) or clause (4-A) as a separate class of vacancies to be filled up in any succeeding year or years and such class of vacancies shall not be considered together with the vacancies of the year in which they are being filled up for determining the ceiling of fifty per cent reservation on total number of vacancies of that year.]\\r\\n(5) Nothing in this article shall affect the operation of any law which provides that the incumbent of an office in connection with the affairs of any religious or denominational institution or any member of the governing body thereof shall be a person professing a particular religion or belonging to a particular denomination.\\r\\n [(6) Nothing in this article shall prevent the State from making any provision for the reservation of appointments or posts in favour of any economically weaker sections of citizens other than the classes mentioned in clause (4), in addition to the existing reservation and subject to a maximum of ten per cent of the posts in each category.]\\r\\n\"],\"6\":[\"17. Abolition of Untouchability\",\"\\u201cUntouchability\\u201d is abolished and its practice in any form is forbidden. The enforcement of any disability arising out of \\u201cUntouchability\\u201d shall be an offence punishable in accordance with law.\"],\"7\":[\"18. Abolition of titles\",\"No title, not being a military or academic distinction, shall be conferred by the State.\\r\\n(2) No citizen of India shall accept any title from any foreign State.\\r\\n(3) No person who is not a citizen of India shall, while he holds any office of profit or trust under the State, accept without the consent of the President any title from any foreign State.\\r\\n(4) No person holding any office of profit or trust under the State shall, without the consent of the President, accept any present, emolument, or office of any kind from or under any foreign State.\\r\\n\"],\"8\":[\"19. Protection of certain rights regarding freedom of speech, etc\",\"(1) All citizens shall have the right\\u2014\\r\\n(a) to freedom of speech and expression;\\r\\n(b) to assemble peaceably and without arms;\\r\\n(c) to form associations or unions 18[co-operative societies];\\r\\n(d) to move freely throughout the territory of India;\\r\\n(e) to reside and settle in any part of the territory of India; 19[and]\\r\\n(f)  [* * *]\\r\\n(g) to practise any profession, or to carry on any occupation, trade or business.\\r\\n [(2) Nothing in sub-clause (a) of clause (1) shall affect the operation of any existing law, or prevent the State from making any law, in so far as such law imposes reasonable restrictions on the exercise of the right conferred by the said sub-clause in the interests of 22[the sovereignty and integrity of India,] the security of the State, friendly relations with foreign States, public order, decency or morality or in relation to contempt of court, defamation or incitement to an offence.]\\r\\n(3) Nothing in sub-clause (b) of the said clause shall affect the operation of any existing law in so far as it imposes, or prevent the State from making any law imposing, in the interests of 23[the sovereignty and integrity of India or] public order, reasonable restrictions on the exercise of the right conferred by the said sub-clause.\\r\\n(4) Nothing in sub-clause (c) of the said clause shall affect the operation of any existing law in so far as it imposes, or prevent the State from making any law imposing, in the interests of 24[the sovereignty and integrity of India or] public order or morality, reasonable restrictions on the exercise of the right conferred by the said sub-clause.\\r\\n(5) Nothing in  [sub-clauses (d) and (e)] of the said clause shall affect the operation of any existing law in so far as it imposes, or prevent the State from making any law imposing, reasonable restrictions on the exercise of any of the rights conferred by the said sub-clauses either in the interests of the general public or for the protection of the interests of any Scheduled Tribe.\\r\\n(6) Nothing in sub-clause (g) of the said clause shall affect the operation of any existing law in so far as it imposes, or prevent the State from making any law imposing, in the interests of the general public, reasonable restrictions on the exercise of the right conferred by the said sub-clause, and, in particular, 26[nothing in the said sub-clause shall affect the operation of any existing law in so far as it relates to, or prevent the State from making any law relating to,\\r\\n(i) the professional or technical qualifications necessary for practising any profession or carrying on any occupation, trade or business, or\\r\\n(ii) the carrying on by the State, or by a corporation owned or controlled by the State, of any trade, business, industry or service, whether to the exclusion, complete or partial, of citizens or otherwise].\\r\\n\"],\"9\":[\"20. Protection in respect of conviction for offences\",\": (1) No person shall be convicted of any offence except for violation of a law in force at the time of the commission of the act charged as an offence, nor be subjected to a penalty greater than that which might have been inflicted under the law in force at the time of the commission of the offence.\\r\\n(2) No person shall be prosecuted and punished for the same offence more than once.\\r\\n(3) No person accused of any offence shall be compelled to be a witness against himself.\\r\\n\"],\"10\":[\"22. Protection against arrest and detention in certain cases\",\"(1) No person who is arrested shall be detained in custody without being informed, as soon as may be, of the grounds for such arrest nor shall he be denied the right to consult, and to be defended by, a legal practitioner of his choice.\\r\\n(2) Every person who is arrested and detained in custody shall be produced before the nearest magistrate within a period of twenty-four hours of such arrest excluding the time necessary for the journey from the place of arrest to the court of the magistrate and no such person shall be detained in custody beyond the said period without the authority of a magistrate.\\r\\n(3) Nothing in clauses (1) and (2) shall apply\\u2014\\r\\n(a) to any person who for the time being is an enemy alien; or\\r\\n(b) to any person who is arrested or detained under any law providing for preventive detention.\\r\\n(4) No law providing for preventive detention shall authorise the detention of a person for a longer period than three months unless\\u2014\\r\\n(a) an Advisory Board consisting of persons who are, or have been, or are qualified to be appointed as, Judges of a High Court has reported before the expiration of the said period of three months that there is in its opinion sufficient cause for such detention:\\r\\nProvided that nothing in this sub-clause shall authorise the detention of any person beyond the maximum period prescribed by any law made by Parliament under sub-clause (b) of clause (7); or\\r\\n(b) such person is detained in accordance with the provisions of any law made by Parliament under sub-clauses (a) and (b) of clause (7).\\r\\n(5) When any person is detained in pursuance of an order made under any law providing for preventive detention, the authority making the order shall, as soon as may be, communicate to such person the grounds on which the order has been made and shall afford him the earliest opportunity of making a representation against the order.\\r\\n(6) Nothing in clause (5) shall require the authority making any such order as is referred to in that clause to disclose facts which such authority considers to be against the public interest to disclose.\\r\\n(7) Parliament may by law prescribe\\u2014\\r\\n(a) the circumstances under which, and the class or classes of cases in which, a person may be detained for a period longer than three months under any law providing for preventive detention without obtaining the opinion of an Advisory Board in accordance with the provisions of sub-clause (a) of clause (4);\\r\\n(b) the maximum period for which any person may in any class or classes of cases be detained under any law providing for preventive detention; and\\r\\n(c) the procedure to be followed by an Advisory Board in an inquiry under sub-clause (a) of clause (4).\\r\\n[The following clause (7) to come into effect on enforcement of Section 3 of Constitution (Forty-fourth Amendment) Act, 1978]\\r\\n(7) Parliament may by law prescribe\\u2014\\r\\n29[(a)] the maximum period for which any person may in any class or classes of cases be detained under any law providing for preventive detention; and\\r\\n30[(b)] the procedure to be followed by an Advisory Board in an inquiry under 31[clause (4)].\\r\\n\"],\"11\":[\"23. Prohibition of traffic in human beings and forced labour\",\"(1) Traffic in human beings and begar and other similar forms of forced labour are prohibited and any contravention of this provision shall be an offence punishable in accordance with law.\\r\\n(2) Nothing in this article shall prevent the State from imposing compulsory service for public purposes, and in imposing such service the State shall not make any discrimination on grounds only of religion, race, caste or class or any of them.\\r\\n\"],\"12\":[\"24. Prohibition of employment of children in factories, etc\",\"No child below the age of fourteen years shall be employed to work in any factory or mine or engaged in any other hazardous employment.\"],\"13\":[\"25. Freedom of conscience and free profession, practice and propagation of religion\",\"(1) Subject to public order, morality and health and to the other provisions of this Part, all persons are equally entitled to freedom of conscience and the right freely to profess, practise and propagate religion.\\r\\n(2) Nothing in this article shall affect the operation of any existing law or prevent the State from making any law\\u2014\\r\\n(a) regulating or restricting any economic, financial, political or other secular activity which may be associated with religious practice;\\r\\n(b) providing for social welfare and reform or the throwing open of Hindu religious institutions of a public character to all classes and sections of Hindus.\\r\\n\"],\"14\":[\"26. Freedom to manage religious affairs\",\"Subject to public order, morality and health, every religious denomination or any section thereof shall have the right\\u2014\\r\\n(a) to establish and maintain institutions for religious and charitable purposes;\\r\\n(b) to manage its own affairs in matters of religion;\\r\\n(c) to own and acquire movable and immovable property; and\\r\\n(d) to administer such property in accordance with law.\\r\\n\"],\"15\":[\"27. Freedom as to payment of taxes for promotion of any particular religion\",\"No person shall be compelled to pay any taxes, the proceeds of which are specifically appropriated in payment of expenses for the promotion or maintenance of any particular religion or religious denomination.\"],\"16\":[\"28. Freedom as to attendance at religious instruction or religious worship in certain educational institutions\",\"(1) No religious instruction shall be provided in any educational institution wholly maintained out of State funds.\\r\\n(2) Nothing in clause (1) shall apply to an educational institution which is administered by the State but has been established under any endowment or trust which requires that religious instruction shall be imparted in such institution.\\r\\n(3) No person attending any educational institution recognised by the State or receiving aid out of State funds shall be required to take part in any religious instruction that may be imparted in such institution or to attend any religious worship that may be conducted in such institution or in any premises attached thereto unless such person or, if such person is a minor, his guardian has given his consent thereto\\r\\n\"],\"17\":[\"29. Protection of interests of minorities\",\"(1) Any section of the citizens residing in the territory of India or any part thereof having a distinct language, script or culture of its own shall have the right to conserve the same.\\r\\n(2) No citizen shall be denied admission into any educational institution maintained by the State or receiving aid out of State funds on grounds only of religion, race, caste, language or any of them.\\r\\n\"],\"18\":[\"30. Right of minorities to establish and administer educational institutions\",\": (1) All minorities, whether based on religion or language, shall have the right to establish and administer educational institutions of their choice.\\r\\n32[(1-A) In making any law providing for the compulsory acquisition of any property of an educational institution established and administered by a minority, referred to in clause (1), the State shall ensure that the amount fixed by or determined under such law for the acquisition of such property is such as would not restrict or abrogate the right guaranteed under that clause.]\\r\\n(2) The State shall not, in granting aid to educational institutions, discriminate against any educational institution on the ground that it is under the management of a minority, whether based on religion or language\\r\\n\"],\"19\":[\"31A, 31B, 31C\",\"31 Omitted. \\r\\n31-A. Saving of laws providing for acquisition of estates, etc.\\u201437[(1) Notwithstanding anything contained in Article 13, no law providing for\\u2014\\r\\n(a) the acquisition by the State of any estate or of any rights therein or the extinguishment or modification of any such rights, or\\r\\n(b) the taking over of the management of any property by the State for a limited period either in the public interest or in order to secure the proper management of the property, or\\r\\n(c) the amalgamation of two or more corporations either in the public interest or in order to secure the proper management of any of the corporations, or\\r\\n(d) the extinguishment or modification of any rights of managing agents, secretaries and treasurers, managing directors, directors or managers of corporations, or of any voting rights of shareholders thereof, or\\r\\n(e) the extinguishment or modification of any rights accruing by virtue of any agreement, lease or licence for the purpose of searching for, or winning, any mineral or mineral oil, or the premature termination or cancellation of any such agreement, lease or licence,\\r\\nshall be deemed to be void on the ground that it is inconsistent with, or takes away or abridges any of the rights conferred by 38[Article 14 or Article 19]:\\r\\nProvided that where such law is a law made by the Legislature of a State, the provisions of this article shall not apply thereto unless such law, having been reserved for the consideration of the President, has received his assent\\r\\n\\r\\n31-B. Validation of certain Acts and Regulations.\\u2014Without prejudice to the generality of the provisions contained in Article 31-A, none of the Acts and Regulations specified in the Ninth Schedule nor any of the provisions thereof shall be deemed to be void, or ever to have become void, on the ground that such Act, Regulation or provision is inconsistent with, or takes away or abridges any of the rights conferred by, any provisions of this Part, and notwithstanding any judgment, decree or order of any court or tribunal to the contrary, each of the said Acts and Regulations shall, subject to the power of any competent Legislature to repeal or amend it, continue in force\\r\\n\\r\\n31-C. Saving of laws giving effect to certain directive principles.\\u2014Notwithstanding anything contained in Article 13, no law giving effect to the policy of the State towards securing 45[all or any of the principles laid down in Part IV] shall be deemed to be void on the ground that it is inconsistent with, or takes away or abridges any of the rights conferred by 46[Article 14 or Article 19] 47[and no law containing a declaration that it is for giving effect to such policy shall be called in question in any court on the ground that it does not give effect to such policy\\r\\n\\r\\n31-D. Saving of laws in respect of anti-national activities [Omitted]\\r\\n\\r\\n\\r\\n\"],\"20\":[\"32. Remedies for enforcement of rights conferred by this Part\",\"(1) The right to move the Supreme Court by appropriate proceedings for the enforcement of the rights conferred by this Part is guaranteed.\\r\\n(2) The Supreme Court shall have power to issue directions or orders or writs, including writs in the nature of habeas corpus, mandamus, prohibition, quo warranto and certiorari, whichever may be appropriate, for the enforcement of any of the rights conferred by this Part.\\r\\n(3) Without prejudice to the powers conferred on the Supreme Court by clauses (1) and (2), Parliament may by law empower any other court to exercise within the local limits of its jurisdiction all or any of the powers exercisable by the Supreme Court under clause (2).\\r\\n(4) The right guaranteed by this article shall not be suspended except as otherwise provided for by this Constitution.\\r\\n\\r\\n32-A. Constitutional validity of State Laws not to be considered in proceedings under Article 32 [Omitted]\\r\\n\"],\"21\":[\"33. Power of Parliament to modify the rights conferred by this Part in their application to Forces, etc\",\"Parliament may, by law, determine to what extent any of the rights conferred by this Part shall, in their application to,\\u2014\\r\\n(a) the members of the Armed Forces; or\\r\\n(b) the members of the Forces charged with the maintenance of public order; or\\r\\n(c) persons employed in any bureau or other organisation established by the State for purposes of intelligence or counter intelligence; or\\r\\n(d) persons employed in, or in connection with, the telecommunication systems set up for the purposes of any Force, bureau or organisation referred to in clauses (a) to (c),\\r\\nbe restricted or abrogated so as to ensure the proper discharge of their duties and the maintenance of discipline among them\\r\\n\"],\"22\":[\"34. Restriction on rights conferred by this Part while martial law is in force in any area\",\"Notwithstanding anything in the foregoing provisions of this Part, Parliament may by law indemnify any person in the service of the Union or of a State or any other person in respect of any act done by him in connection with the maintenance or restoration of order in any area within the territory of India where martial law was in force or validate any sentence passed, punishment inflicted, forfeiture ordered or other act done under martial law in such area.\"],\"23\":[\"35. Legislation to give effect to the provisions of this Part\",\"Notwithstanding anything in this Constitution,\\r\\n(a) Parliament shall have, and the Legislature of a State shall not have, power to make laws\\u2014\\r\\n(i) with respect to any of the matters which under clause (3) of Article 16, clause (3) of Article 32, Article 33 and Article 34 may be provided for by law made by Parliament; and\\r\\n(ii) for prescribing punishment for those acts which are declared to be offences under this Part;\\r\\nand Parliament shall, as soon as may be after the commencement of this Constitution, make laws for prescribing punishment for the acts referred to in sub-clause (ii);\\r\\n(b) any law in force immediately before the commencement of this Constitution in the territory of India with respect to any of the matters referred to in sub-clause (i) of clause (a) or providing for punishment for any act referred to in sub-clause (ii) of that clause shall, subject to the terms thereof and to any adaptations and modifications that may be made therein under Article 372, continue in force until altered or repealed or amended by Parliament.\\r\\n\\r\\n\"]}', 1, '2021-01-29 23:53:31', '2021-01-30 03:10:17'),
(26, 'wl3gVdZLIdaMI5h7aiMoTSRw8', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART IV ', 'DIRECTIVE PRINCIPLES OF STATE POLICY', '', '', '{\"1\":[\"36. Definition\",\"In this Part, unless the context otherwise requires, \\u201cthe State\\u201d has the same meaning as in Part III.\"],\"2\":[\"37. Application of the principles contained in this Part\",\"The provisions contained in this Part shall not be enforceable by any court, but the principles therein laid down are nevertheless fundamental in the governance of the country and it shall be the duty of the State to apply these principles in making laws.\"],\"3\":[\"38. State to secure a social order for the promotion of welfare of the people\",\"(1) The State shall strive to promote the welfare of the people by securing and protecting as effectively as it may a social order in which justice, social, economic and political, shall inform all the institutions of the national life.\\r\\n (2) The State shall, in particular, strive to minimise the inequalities in income, and endeavour to eliminate inequalities in status, facilities and opportunities, not only amongst individuals but also amongst groups of people residing in different areas or engaged in different vocations.\\r\\n\"],\"4\":[\"39. Certain principles of policy to be followed by the State\",\"The State shall, in particular, direct its policy towards securing\\u2014\\r\\n(a) that the citizens, men and women equally, have the right to an adequate means to livelihood;\\r\\n(b) that the ownership and control of the material resources of the community are so distributed as best to subserve the common good;\\r\\n(c) that the operation of the economic system does not result in the concentration of wealth and means of production to the common detriment;\\r\\n(d) that there is equal pay for equal work for both men and women;\\r\\n(e) that the health and strength of workers, men and women, and the tender age of children are not abused and that citizens are not forced by economic necessity to enter avocations unsuited to their age or strength;\\r\\n(f) that children are given opportunities and facilities to develop in a healthy manner and in conditions of freedom and dignity and that childhood and youth are protected against exploitation and against moral and material abandonment.\\r\\n\"],\"5\":[\"39-A. Equal justice and free legal aid\",\"The State shall secure that the operation of the legal system promotes justice, on a basis of equal opportunity, and shall, in particular, provide free legal aid, by suitable legislation or schemes or in any other way, to ensure that opportunities for securing justice are not denied to any citizen by reason of economic or other disabilities\"],\"6\":[\"40. Organisation of village panchayats\",\"The State shall take steps to organise village panchayats and endow them with such powers and authority as may be necessary to enable them to function as units of self-government.\"],\"7\":[\"41. Right to work, to education and to public assistance in certain cases.\",\"The State shall, within the limits of its economic capacity and development, make effective provision for securing the right to work, to education and to public assistance in cases of unemployment, old age, sickness and disablement, and in other cases of undeserved want.\"],\"8\":[\"42. Provision for just and humane conditions of work and maternity relief\",\"The State shall make provision for securing just and humane conditions of work and for maternity relief.\"],\"9\":[\"43. Living wage, etc., for workers\",\"The State shall endeavour to secure, by suitable legislation or economic organisation or in any other way, to all workers, agricultural, industrial or otherwise, work, a living wage, conditions of work ensuring a decent standard of life and full enjoyment of leisure and social and cultural opportunities and, in particular, the State shall endeavour to promote cottage industries on an individual or co-operative basis in rural areas.\"],\"10\":[\"43-A. Participation of workers in management of industries\",\"The State shall take steps, by suitable legislation or in any other way, to secure the participation of workers in the management of undertakings, establishments or other organisations engaged in any industry\"],\"11\":[\"43-B. Promotion of co-operative societies\",\"The State shall endeavour to promote voluntary formation, autonomous functioning, democratic control and professional management of co-operative societies\"],\"12\":[\"44. Uniform civil code for the citizens\",\"The State shall endeavour to secure for the citizens a uniform civil code throughout the territory of India\"],\"13\":[\"45. Provision for early childhood care and education to children below the age of six years\",\"The State shall endeavour to provide early childhood care and education for all children until they complete the age of six years\"],\"14\":[\"46. Promotion of educational and economic interests of Scheduled Castes, Scheduled Tribes and other weaker sections\",\"The State shall promote with special care the educational and economic interests of the weaker sections of the people, and, in particular, of the Scheduled Castes and the Scheduled Tribes, and shall protect them from social injustice and all forms of exploitation.\"],\"15\":[\"47. Duty of the State to raise the level of nutrition and the standard of living and to improve public health\",\"The State shall regard the raising of the level of nutrition and the standard of living of its people and the improvement of public health as among its primary duties and, in particular, the State shall endeavour to bring about prohibition of the consumption, except for medicinal purposes of intoxicating drinks and of drugs which are injurious to health\"],\"16\":[\"48. Organisation of agriculture and animal husbandry\",\"The State shall endeavour to organise agriculture and animal husbandry on modern and scientific lines and shall, in particular, take steps for preserving and improving the breeds, and prohibiting the slaughter, of cows and calves and other milch and draught cattle.\"],\"17\":[\"48-A. Protection and improvement of environment and safeguarding of forests and wild life\",\"The State shall endeavour to protect and improve the environment and to safeguard the forests and wild life of the country\"],\"18\":[\"49. Protection of monuments and places and objects of national importance\",\"It shall be the obligation of the State to protect every monument or place or object of artistic or historic interest, 60[declared by or under law made by Parliament] to be of national importance, from spoliation, disfigurement, destruction, removal, disposal or export, as the case may be.\"],\"19\":[\"50. Separation of judiciary from executive\",\"The State shall take steps to separate the judiciary from the executive in the public services of the State.\"],\"20\":[\"51. Promotion of international peace and security\",\"The State shall endeavour to\\u2014\\r\\n(a) promote international peace and security;\\r\\n(b) maintain just and honourable relations between nations;\\r\\n(c) foster respect for international law and treaty obligations in the dealings of organised peoples with one another; and\\r\\n(d) encourage settlement of international disputes by arbitration.\\r\\n\"]}', 1, '2021-01-30 00:16:28', '2021-01-30 01:36:56'),
(27, 'Y1bgYWOqVH1nCm7hkVHQLEmqq', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART IV A ', 'FUNDAMENTAL DUTIES', '', '', '{\"1\":[\"51-A. Fundamental duties\",\"It shall be the duty of every citizen of India\\u2014\\r\\n(a) to abide by the Constitution and respect its ideals and institutions, the National Flag and the National Anthem;\\r\\n(b) to cherish and follow the noble ideals which inspired our national struggle for freedom;\\r\\n(c) to uphold and protect the sovereignty, unity and integrity of India;\\r\\n(d) to defend the country and render national service when called upon to do so;\\r\\n(e) to promote harmony and the spirit of common brotherhood amongst all the people of India transcending religious, linguistic and regional or sectional diversities; to renounce practices derogatory to the dignity of women;\\r\\n(f) to value and preserve the rich heritage of our composite culture;\\r\\n(g) to protect and improve the natural environment including forests, lakes, rivers and wild life, and to have compassion for living creatures;\\r\\n(h) to develop the scientific temper, humanism and the spirit of inquiry and reform;\\r\\n(i) to safeguard public property and to abjure violence;\\r\\n(j) to strive towards excellence in all spheres of individual and collective activity so that the nation constantly rises to higher levels of endeavour and achievement.]\\r\\n(k) who is a parent or guardian to provide opportunities for education to his child or, as the case may be, ward between the age of six and fourteen years\\r\\n\"]}', 1, '2021-01-30 01:39:07', '2021-01-30 01:39:07');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(28, 'i0py1UwekHfOLMPCJXsqp7vZJ', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'PART V CHAPTER 1', 'THE EXECUTIVE,  THE PRESIDENT AND VICE-PRESIDENT', '', '', '{\"1\":[\"52. The President of India\",\"There shall be a President of India\"],\"2\":[\"53. Executive power of the Union\",\"(1) The executive power of the Union shall be vested in the President and shall be exercised by him either directly or through officers subordinate to him in accordance with this Constitution.\\r\\n(2) Without prejudice to the generality of the foregoing provision, the supreme command of the Defence Forces of the Union shall be vested in the President and the exercise thereof shall be regulated by law.\\r\\n(3) Nothing in this article shall\\u2014\\r\\n(a) be deemed to transfer to the President any functions conferred by any existing law on the Government of any State or other authority; or\\r\\n(b) prevent Parliament from conferring by law functions on authorities other than the President.\\r\\n\"],\"3\":[\"54. Election of President\",\"The President shall be elected by the members of an electoral college consisting of\\u2014\\r\\n(a) the elected members of both Houses of Parliament; and\\r\\n(b) the elected members of the Legislative Assemblies of the States.\\r\\n\"],\"4\":[\"55. Manner of election of President\",\"(1) As far as practicable, there shall be uniformity in the scale of representation of the different States at the election of the President.\\r\\n(2) For the purpose of securing such uniformity among the States inter se as well as parity between the States as a whole and the Union, the number of votes which each elected member of Parliament and of the Legislative Assembly of each State is entitled to cast at such election shall be determined in the following manner:\\u2014\\r\\n(a) every elected member of the Legislative Assembly of a State shall have as many votes as there are multiples of one thousand in the quotient obtained by dividing the population of the State by the total number of the elected members of the Assembly;\\r\\n(b) if, after taking the said multiples of one thousand, the remainder is not less than five hundred, then the vote of each member referred to in sub-clause (a) shall be further increased by one;\\r\\n(c) each elected member of either House of Parliament shall have such number of votes as may be obtained by dividing the total number of votes assigned to the members of the Legislative Assemblies of the States under sub-clauses (a) and (b) by the total number of the elected members of both Houses of Parliament, fractions exceeding one-half being counted as one and other fractions being disregarded.\\r\\n(3) The election of the President shall be held in accordance with the system of proportional representation by means of the single transferable vote and the voting at such election shall be by secret ballot.\\r\\n\"],\"5\":[\"56. Term of office of President\",\"(1) The President shall hold office for a term of five years from the date on which he enters upon his office:\\r\\nProvided that\\u2014\\r\\n(a) the President may, by writing under his hand addressed to the Vice-President, resign his office;\\r\\n(b) the President may, for violation of the Constitution, be removed from office by impeachment in the manner provided in Article 61;\\r\\n(c) the President shall, notwithstanding the expiration of his term, continue to hold office until his successor enters upon his office.\\r\\n(2) Any resignation addressed to the Vice-President under clause (a) of the proviso to clause (1) shall forthwith be communicated by him to the Speaker of the House of the People.\\r\\n\"],\"6\":[\"57. Eligibility for re-election\",\"A person who holds, or who has held, office as President shall, subject to the other provisions of this Constitution, be eligible for re-election to that office.\"],\"7\":[\"58. Qualifications for election as President\",\".\\u2014(1) No person shall be eligible for election as President unless he\\u2014\\r\\n(a) is a citizen of India,\\r\\n(b) has completed the age of thirty-five years, and\\r\\n(c) is qualified for election as a member of the House of the People.\\r\\n(2) A person shall not be eligible for election as President if he holds any office of profit under the Government of India or the Government of any State or under any local or other authority subject to the control of any of the said Governments.\\r\\n\"],\"8\":[\"59. Conditions of President\'s office\",\"1) The President shall not be a member of either House of Parliament or of a House of the Legislature of any State, and if a member of either House of Parliament or of a House of the Legislature of any State be elected President, he shall be deemed to have vacated his seat in that House on the date on which he enters upon his office as President.\\r\\n(2) The President shall not hold any other office of profit.\\r\\n(3) The President shall be entitled without payment of rent to the use of his official residences and shall be also entitled to such emoluments, allowances and privileges as may be determined by Parliament by law and, until provision in that behalf is so made, such emoluments, allowances and privileges as are specified in the Second Schedule.\\r\\n(4) The emoluments and allowances of the President shall not be diminished during his term of office.\\r\\n\"],\"9\":[\"60. Oath or affirmation by the President\",\"Every President and every person acting as President or discharging the functions of the President shall, before entering upon his office, make and subscribe in the presence of the Chief Justice of India or, in his absence, the seniormost Judge of the Supreme Court available, an oath or affirmation in the following form, that is to say\\u2014\\r\\nswear in the name of God\\r\\n\\u201cI, A.B., do \\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014that I will faithfully\\r\\nsolemnly affirm\\r\\nexecute the office of President (or discharge the functions of the President) of India and will to the best of my ability preserve, protect and defend the Constitution and the law and that I will devote myself to the service and well-being of the people of India.\\r\\n\"],\"10\":[\"61. Procedure for impeachment of the President\",\"1) When a President is to be impeached for violation of the Constitution, the charge shall be preferred by either House of Parliament.\\r\\n(2) No such charge shall be preferred unless\\u2014\\r\\n(a) the proposal to prefer such charge is contained in a resolution which has been moved after at least fourteen days\\u2019 notice in writing signed by not less than one-fourth of the total number of members of the House has been given of their intention to move the resolution, and\\r\\n(b) such resolution has been passed by a majority of not less than two-thirds of the total membership of the House.\\r\\n(3) When a charge has been so preferred by either House of Parliament, the other House shall investigate the charge or cause the charge to be investigated and the President shall have the right to appear and to be represented at such investigation.\\r\\n(4) If as a result of the investigation a resolution is passed by a majority of not less than two-thirds of the total membership of the House by which the charge was investigated or caused to be investigated, declaring that the charge preferred against the President has been sustained, such resolution shall have the effect of removing the President from his office as from the date on which the resolution is so passed.\\r\\n\"],\"11\":[\"62. Time of holding election to fill vacancy in the office of President and the term of office of person elected to fill casual vacancy\",\"(1) An election to fill a vacancy caused by the expiration of the term of office of President shall be completed before the expiration of the term.\\r\\n(2) An election to fill a vacancy in the office of President occurring by reason of his death, resignation or removal, or otherwise shall be held as soon as possible after, and in no case later than six months from, the date of occurrence of the vacancy; and the person elected to fill the vacancy shall, subject to the provisions of Article 56, be entitled to hold office for the full term of five years from the date on which he enters upon his office.\\r\\n\"],\"12\":[\"63. The Vice-President of India\",\"There shall be a Vice-President of India\"],\"13\":[\"64. The Vice-President to be ex-officio Chairman of the Council of States\",\"The Vice-President shall be ex-officio Chairman of the Council of States and shall not hold any other office of profit:\\r\\nProvided that during any period when the Vice-President acts as President or discharges the functions of the President under Article 65, he shall not perform the duties of the office of Chairman of the Council of States and shall not be entitled to any salary or allowance payable to the Chairman of the Council of States under Article 97.\\r\\n\"],\"14\":[\"65. The Vice-President to act as President or to discharge his functions during casual vacancies in the office, or during the absence, of President\",\"(1) In the event of the occurrence of any vacancy in the office of the President by reason of his death, resignation or removal, or otherwise, the Vice-President shall act as President until the date on which a new President elected in accordance with the provisions of this Chapter to fill such vacancy enters upon his office.\\r\\n(2) When the President is unable to discharge his functions owing to absence, illness or any other cause, the Vice-President shall discharge his functions until the date on which the President resumes his duties.\\r\\n(3) The Vice-President shall, during, and in respect of, the period while he is so acting as, or discharging the functions of, President, have all the powers and immunities of the President and be entitled to such emoluments, allowances and privileges as may be determined by Parliament by law and, until provision in that behalf is so made, such emoluments, allowances and privileges as are specified in the Second Schedule.\\r\\n\"],\"15\":[\"66. Election of Vice-President\",\"(1) The Vice-President shall be elected by the 68[members of an electoral college consisting of the members of both Houses of Parliament] in accordance with the system of proportional representation by means of the single transferable vote and the voting at such election shall be by secret ballot.\\r\\n(2) The Vice-President shall not be a member of either House of Parliament or of a House of the Legislature of any State, and if a member of either House of Parliament or of a House of the Legislature of any State be elected Vice-President, he shall be deemed to have vacated his seat in that House on the date on which he enters upon his office as Vice-President.\\r\\n(3) No person shall be eligible for election as Vice-President unless he\\u2014\\r\\n(a) is a citizen of India;\\r\\n(b) has completed the age of thirty-five years; and\\r\\n(c) is qualified for election as a member of the Council of States.\\r\\n(4) A person shall not be eligible for election as Vice-President if he holds any office of profit under the Government of India or the Government of any State or under any local or other authority subject to the control of any of the said Governments.\\r\\n\"],\"16\":[\"67. Term of office of Vice-President\",\"The Vice-President shall hold office for a term of five years from the date on which he enters upon his office:\\r\\nProvided that\\u2014\\r\\n(a) a Vice-President may, by writing under his hand addressed to the President, resign his office;\\r\\n(b) a Vice-President may be removed from his office by a resolution of the Council of States passed by a majority of all the then members of the Council and agreed to by the House of the People; but no resolution for the purpose of this clause shall be moved unless at least fourteen days\\u2019 notice has been given of the intention to move the resolution;\\r\\n(c) a Vice-President shall, notwithstanding the expiration of his term, continue to hold office until his successor enters upon his office.\\r\\n\"],\"17\":[\"68. Time of holding election to fill vacancy in the office of Vice-President and the term of office of person elected to fill casual vacancy\",\"(1) An election to fill a vacancy caused by the expiration of the term of office of Vice-President shall be completed before the expiration of the term.\\r\\n(2) An election to fill a vacancy in the office of Vice-President occurring by reason of his death, resignation or removal, or otherwise shall be held as soon as possible after the occurrence of the vacancy, and the person elected to fill the vacancy shall, subject to the provisions of Article 67, be entitled to hold office for the full term of five years from the date on which he enters upon his office.\\r\\n\"],\"18\":[\"69. Oath or affirmation by the Vice-President\",\"Every Vice-President shall, before entering upon his office, make and subscribe before the President, or some person appointed in that behalf by him, an oath or affirmation in the following form, that is to say\\u2014\\r\\nswear in the name of God\\r\\n\\u201cI, A.B., do \\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014 that I will bear true faith\\r\\nsolemnly affirm\\r\\nand allegiance to the Constitution of India as by law established and that I will faithfully discharge the duty upon which I am about to enter.\\u201d\\r\\n\"],\"19\":[\"70. Discharge of President\'s functions in other contingencies\",\"Parliament may make such provision as it thinks fit for the discharge of the functions of the President in any contingency not provided for in this Chapter.\"],\"20\":[\"71. Matters relating to, or connected with, the election of a President or Vice-President\",\"(1) All doubts and disputes arising out of or in connection with the election of a President or Vice-President shall be inquired into and decided by the Supreme Court whose decision shall be final.\\r\\n(2) If the election of a person as President or Vice-President is declared void by the Supreme Court, acts done by him in the exercise and performance of the powers and duties of the office of President or Vice-President, as the case may be, on or before the date of the decision of the Supreme Court shall not be invalidated by reason of that declaration.\\r\\n(3) Subject to the provisions of this Constitution, Parliament may by law regulate any matter relating to or connected with the election of a President or Vice-President.\\r\\n(4) The election of a person as President or Vice-President shall not be called in question on the ground of the existence of any vacancy for whatever reason among the members of the electoral college electing him\\r\\n\"],\"21\":[\"72. Power of President to grant pardons, etc., and to suspend, remit or commute sentences in certain cases\",\"(1) The President shall have the power to grant pardons, reprieves, respites or remissions of punishment or to suspend, remit or commute the sentence of any person convicted of any offence\\u2014\\r\\n(a) in all cases where the punishment or sentence is by a Court Martial;\\r\\n(b) in all cases where the punishment or sentence is for an offence against any law relating to a matter to which the executive power of the Union extends;\\r\\n(c) in all cases where the sentence is a sentence of death.\\r\\n(2) Nothing in sub-clause (a) of clause (1) shall affect the power conferred by law on any officer of the Armed Forces of the Union to suspend, remit or commute a sentence passed by a Court Martial.\\r\\n(3) Nothing in sub-clause (c) of clause (1) shall affect the power to suspend, remit or commute a sentence of death exercisable by the Governor 71[* * *] of a State under any law for the time being in force.\\r\\n\"],\"22\":[\"73. Extent of executive power of the Union\",\"(1) Subject to the provisions of this Constitution, the executive power of the Union shall extend\\u2014\\r\\n(a) to the matters with respect to which Parliament has power to make laws; and\\r\\n(b) to the exercise of such rights, authority and jurisdiction as are exercisable by the Government of India by virtue of any treaty or agreement:\\r\\nProvided that the executive power referred to in sub-clause (a) shall not, save as expressly provided in this Constitution or in any law made by Parliament, extend in any State 72[* * *] to matters with respect to which the Legislature of the State has also power to make laws.\\r\\n(2) Until otherwise provided by Parliament, a State and any officer or authority of a State may, notwithstanding anything in this article, continue to exercise in matters with respect to which Parliament has power to make laws for that State such executive power or functions as the State or officer or authority thereof could exercise immediately before the commencement of this Constitution.\\r\\n\"],\"23\":[\"74. Council of Ministers to aid and advise President\",\"(1) There shall be a Council of Ministers with the Prime Minister at the head to aid and advise the President who shall, in the exercise of his functions, act in accordance with such advice Provided that the President may require the Council of Ministers to reconsider such advice, either generally or otherwise, and the President shall act in accordance with the advice tendered after such reconsideration\\r\\n(2) The question whether any, and if so what, advice was tendered by Ministers to the President shall not be inquired into in any court.\"],\"24\":[\"75. Other provisions as to Ministers\",\"(1) The Prime Minister shall be appointed by the President and the other Ministers shall be appointed by the President on the advice of the Prime Minister.\\r\\n(1-A) The total number of Ministers, including the Prime Minister, in the Council of Ministers shall not exceed fifteen per cent of the total number of members of the House of the People.\\r\\n(1-B) A member of either House of Parliament belonging to any political party who is disqualified for being a member of that House under Paragraph 2 of the Tenth Schedule shall also be disqualified to be appointed as a Minister under clause (1) for duration of the period commencing from the date of his disqualification till the date on which the term of his office as such member would expire or where he contests any election to either House of Parliament before the expiry of such period, till the date on which he is declared elected, whichever is earlier.\\r\\n(2) The Ministers shall hold office during the pleasure of the President.\\r\\n(3) The Council of Ministers shall be collectively responsible to the House of the People.\\r\\n(4) Before a Minister enters upon his office, the President shall administer to him the oaths of office and of secrecy according to the forms set out for the purpose in the Third Schedule.\\r\\n(5) A Minister who for any period of six consecutive months is not a member of either House of Parliament shall at the expiration of that period cease to be a Minister.\\r\\n(6) The salaries and allowances of Ministers shall be such as Parliament may from time to time by law determine and, until Parliament so determines, shall be as specified in the Second Schedule.\\r\\n\"],\"25\":[\"76. Attorney-General for India\",\"(1) The President shall appoint a person who is qualified to be appointed a Judge of the Supreme Court to be Attorney-General for India.\\r\\n(2) It shall be the duty of the Attorney-General to give advice to the Government of India upon such legal matters, and to perform such other duties of a legal character, as may from time to time be referred or assigned to him by the President, and to discharge the functions conferred on him by or under this Constitution or any other law for the time being in force.\\r\\n(3) In the performance of his duties the Attorney-General shall have right of audience in all courts in the territory of India.\\r\\n(4) The Attorney-General shall hold office during the pleasure of the President, and shall receive such remuneration as the President may determine.\\r\\n\"],\"26\":[\"77. Conduct of business of the Government of India\",\"(1) All executive action of the Government of India shall be expressed to be taken in the name of the President.\\r\\n(2) Orders and other instruments made and executed in the name of the President shall be authenticated in such manner as may be specified in rules76 to be made by the President, and the validity of an order or instrument which is so authenticated shall not be called in question on the ground that it is not an order or instrument made or executed by the President.\\r\\n(3) The President shall make rules for the more convenient transaction of the business of the Government of India, and for the allocation among Ministers of the said business.\\r\\n\"],\"27\":[\"78. Duties of Prime Minister as respects the furnishing of information to the President, etc\",\"It shall be the duty of the Prime Minister\\u2014\\r\\n(a) to communicate to the President all decisions of the Council of Ministers relating to the administration of the affairs of the Union and proposals for legislation;\\r\\n(b) to furnish such information relating to the administration of the affairs of the Union and proposals for legislation as the President may call for; and\\r\\n(c) if the President so requires, to submit for the consideration of the Council of Ministers any matter on which a decision has been taken by a Minister but which has not been considered by the Council.\\r\\n\"]}', 1, '2021-01-30 01:57:38', '2021-01-30 03:08:47');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(29, 'TMBmaOFZBGNOqlNwhbnufWCPU', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part V CHAPTER 2', 'PARLIAMENT', '', '', '{\"1\":[\"79. Constitution of Parliament\",\"There shall be a Parliament for the Union which shall consist of the President and two Houses to be known respectively as the Council of States and the House of the People.\"],\"2\":[\"80. Composition of the Council of States\",\"The Council of States] shall consist of\\u2014\\r\\n(a) twelve members to be nominated by the President in accordance with the provisions of clause (3); and\\r\\n(b) not more than two hundred and thirty-eight representatives of the States 80[and of the Union territories].\\r\\n(2) The allocation of seats in the Council of States to be filled by representatives of the States 81[and of the Union territories] shall be in accordance with the provisions in that behalf contained in the Fourth Schedule.\\r\\n(3) The members to be nominated by the President under sub-clause (a) of clause (1) shall consist of persons having special knowledge or practical experience in respect of such matters as the following, namely:\\u2014\\r\\nLiterature, science, art and social service.\\r\\n(4) The representatives of each State  in the Council of States shall be elected by the elected members of the Legislative Assembly of the State in accordance with the system of proportional representation by means of the single transferable vote.\\r\\n(5) The representatives of the [Union territories] in the Council of States shall be chosen in such manner as Parliament may by law prescribe.\\r\\n\"],\"3\":[\"81. Composition of the House of the People\",\"The House of the People shall consist of\\u2014\\r\\n(a) not more than {five hundred and thirty members} chosen by direct election from territorial constituencies in the States, and\\r\\n(b) not more than {twenty members} to represent the Union territories, chosen in such manner as Parliament may by law provide.\\r\\n(2) For the purposes of sub-clause (a) of clause (1),\\u2014\\r\\n(a) there shall be allotted to each State a number of seats in the House of the People in such manner that the ratio between that number and the population of the State is, so far as practicable, the same for all States; and\\r\\n(b) each State shall be divided into territorial constituencies in such manner that the ratio between the population of each constituency and the number of seats allotted to it is, so far as practicable, the same throughout the State\\r\\n(3) In this article, the expression \\u201cpopulation\\u201d means the population as ascertained at the last preceding census of which the relevant figures have been published\"],\"4\":[\"82. Readjustment after each census\",\"Upon the completion of each census, the allocation of seats in the House of the People to the States and the division of each State into territorial constituencies shall be readjusted by such authority and in such manner as Parliament may by law determine:\\r\\nProvided that such readjustment shall not affect representation in the House of the People until the dissolution of the then existing House\\r\\n [Provided further that such readjustment shall take effect from such date as the President may, by order, specify and until such readjustment takes effect, any election to the House may be held on the basis of the territorial constituencies existing before such readjustment:\\r\\nProvided also that until the relevant figures for the first census taken after the year {2026} have been published, it shall not be necessary to 96{readjust\\u2014\\r\\n(i) the allocation of seats in the House of the People to the States as readjusted on the basis of the 1971 census; and\\r\\n(ii) the division of each State into territorial constituencies as may be readjusted on the basis of the (2001) census, under this article.}]\\r\\n\"],\"5\":[\"83. Duration of Houses of Parliament\",\"(1) The Council of States shall not be subject to dissolution, but as nearly as possible one-third of the members thereof shall retire as soon as may be on the expiration of every second year in accordance with the provisions made in that behalf by Parliament by law.\\r\\n(2) The House of the People, unless sooner dissolved, shall continue for [five years] from the date appointed for its first meeting and no longer and the expiration of the said period of  [five years] shall operate as a dissolution of the House:\\r\\nProvided that the said period may, while a Proclamation of Emergency is in operation, be extended by Parliament by law for a period not exceeding one year at a time and not extending in any case beyond a period of six months after the Proclamation has ceased to operate.\\r\\n\"],\"6\":[\"84. Qualification for membership of Parliament\",\"A person shall not be qualified to be chosen to fill a seat in Parliament unless he\\u2014\\r\\n [(a) is a citizen of India, and makes and subscribes before some person authorized in that behalf by the Election Commission an oath or affirmation according to the form set out for the purpose in the Third Schedule;]\\r\\n(b) is, in the case of a seat in the Council of States, not less than thirty years of age and, in the case of a seat in the House of the People, not less than twenty-five years of age; and\\r\\n(c) possesses such other qualifications as may be prescribed in that behalf by or under any law made by Parliament\\r\\n\"],\"7\":[\"85. Sessions of Parliament, prorogation and dissolution\",\"(1) The President shall from time to time summon each House of Parliament to meet at such time and place as he thinks fit, but six months shall not intervene between its last sitting in one session and the date appointed for its first sitting in the next session.\\r\\n(2) The President may from time to time\\u2014\\r\\n(a) prorogue the Houses or either House;\\r\\n(b) dissolve the House of the People.\\r\\n\"],\"8\":[\"86. Right of President to address and send messages to Houses\",\"(1) The President may address either House of Parliament or both Houses assembled together, and for that purpose require the attendance of members.\\r\\n(2) The President may send messages to either House of Parliament, whether with respect to a Bill then pending in Parliament or otherwise, and a House to which any message is so sent shall with all convenient despatch consider any matter required by the message to be taken into consideration.\\r\\n\"],\"9\":[\"87. Special address by the President\",\"(1) At the commencement of [the first session after each general election to the House of the People and at the commencement of the first session of each year] the President shall address both Houses of Parliament assembled together and inform Parliament of the causes of its summons.\\r\\n(2) Provision shall be made by the rules regulating the procedure of either House for the allotment of time for discussion of the matters referred to in such address\\r\\n\"],\"10\":[\"88. Rights of Ministers and Attorney-General as respects Houses\",\"Every Minister and the Attorney-General of India shall have the right to speak in, and otherwise to take part in the proceedings of, either House, any joint sitting of the Houses, and any committee of Parliament of which he may be named a member, but shall not by virtue of this article be entitled to vote.\"],\"11\":[\"89. The Chairman and Deputy Chairman of the Council of States\",\"(1) The Vice-President of India shall be ex-officio Chairman of the Council of States.\\r\\n(2) The Council of States shall, as soon as may be, choose a member of the Council to be Deputy Chairman thereof and, so often as the office of Deputy Chairman becomes vacant, the Council shall choose another member to be Deputy Chairman thereof.\\r\\n\"],\"12\":[\"90. Vacation and resignation of, and removal from, the office of Deputy Chairman\",\"A member holding office as Deputy Chairman of the Council of States\\u2014\\r\\n(a) shall vacate his office if he ceases to be a member of the Council;\\r\\n(b) may at any time, by writing under his hand addressed to the Chairman, resign his office; and\\r\\n(c) may be removed from his office by a resolution of the Council passed by a majority of all the then members of the Council:\\r\\nProvided that no resolution for the purpose of clause (c) shall be moved unless at least fourteen days\\u2019 notice has been given of the intention to move the resolution.\\r\\n\"],\"13\":[\"91. Power of the Deputy Chairman or other person to perform the duties of the office of, or to act as, Chairman\",\"(1) While the office of Chairman is vacant, or during any period when the Vice-President is acting as, or discharging the functions of, President, the duties of the office shall be performed by the Deputy Chairman, or, if the office of Deputy Chairman is also vacant, by such member of the Council of States as the President may appoint for the purpose.\\r\\n(2) During the absence of the Chairman from any sitting of the Council of States the Deputy Chairman, or, if he is also absent, such person as may be determined by the rules of procedure of the Council, or, if no such person is present, such other person as may be determined by the Council, shall act as Chairman.\\r\\n\"],\"14\":[\"92. The Chairman or the Deputy Chairman not to preside while a resolution for his removal from office is under consideration\",\"(1) At any sitting of the Council of States, while any resolution for the removal of the Vice-President from his office is under consideration, the Chairman, or while any resolution for the removal of the Deputy Chairman from his office is under consideration, the Deputy Chairman, shall not, though he is present, preside, and the provisions of clause (2) of Article 91 shall apply in relation to every such sitting as they apply in relation to a sitting from which the Chairman, or, as the case may be, the Deputy Chairman, is absent.\\r\\n(2) The Chairman shall have the right to speak in, and otherwise to take part in the proceedings of, the Council of States while any resolution for the removal of the Vice-President from his office is under consideration in the Council, but, notwithstanding anything in Article 100, shall not be entitled to vote at all on such resolution or on any other matter during such proceedings.\\r\\n\"],\"15\":[\"93. The Speaker and Deputy Speaker of the House of the People\",\" The House of the People shall, as soon as may be, choose two members of the House to be respectively Speaker and Deputy Speaker thereof and, so often as the office of Speaker or Deputy Speaker becomes vacant, the House shall choose another member to be Speaker or Deputy Speaker, as the case may be.\"],\"16\":[\"94. Vacation and resignation of, and removal from, the offices of Speaker and Deputy Speaker\",\"A member holding office as Speaker or Deputy Speaker of the House of the People\\u2014\\r\\n(a) shall vacate his office if he ceases to be a member of the House of the People;\\r\\n(b) may at any time, by writing under his hand addressed, if such member is the Speaker, to the Deputy Speaker, and if such member is the Deputy Speaker, to the Speaker, resign his office; and\\r\\n(c) may be removed from his office by a resolution of the House of the People passed by a majority of all the then members of the House:\\r\\nProvided that no resolution for the purpose of clause (c) shall be moved unless at least fourteen days\\u2019 notice has been given of the intention to move the resolution:\\r\\nProvided further that, whenever the House of the People is dissolved, the Speaker shall not vacate his office until immediately before the first meeting of the House of the People after the dissolution.\\r\\n\"],\"17\":[\"95. Power of the Deputy Speaker or other person to perform the duties of the office of, or to act as, Speaker\",\"(1) While the office of Speaker is vacant, the duties of the office shall be performed by the Deputy Speaker or, if the office of Deputy Speaker is also vacant, by such member of the House of the People as the President may appoint for the purpose.\\r\\n(2) During the absence of the Speaker from any sitting of the House of the People the Deputy Speaker or, if he is also absent, such person as may be determined by the rules of procedure of the House, or, if no such person is present, such other person as may be determined by the House, shall act as Speaker.\\r\\n\"],\"18\":[\"96. The Speaker or the Deputy Speaker not to preside while a resolution for his removal from office is under consideration\",\"(1) At any sitting of the House of the People, while any resolution for the removal of the Speaker from his office is under consideration, the Speaker, or while any resolution for the removal of the Deputy Speaker from his office is under consideration, the Deputy Speaker, shall not, though he is present, preside, and the provisions of clause (2) of Article 95 shall apply in relation to every such sitting as they apply in relation to a sitting from which the Speaker, or, as the case may be, the Deputy Speaker, is absent.\\r\\n(2) The Speaker shall have the right to speak in, and otherwise to take part in the proceedings of, the House of the People while any resolution for his removal from office is under consideration in the House and shall, notwithstanding anything in Article 100, be entitled to vote only in the first instance on such resolution or on any other matter during such proceedings but not in the case of an equality of votes.\\r\\n\"],\"19\":[\"97. Salaries and allowances of the Chairman and Deputy Chairman and the Speaker and Deputy Speaker\",\"There shall be paid to the Chairman and the Deputy Chairman of the Council of States, and to the Speaker and the Deputy Speaker of the House of the People, such salaries and allowances as may be respectively fixed by Parliament by law and, until provision in that behalf is so made, such salaries and allowances as are specified in the Second Schedule.\"],\"20\":[\"98. Secretariat of Parliament\",\"(1) Each House of Parliament shall have a separate secretarial staff:\\r\\nProvided that nothing in this clause shall be construed as preventing the creation of posts common to both Houses of Parliament.\\r\\n(2) Parliament may by law regulate the recruitment, and the conditions of service of persons appointed, to the secretarial staff of either House of Parliament.\\r\\n(3) Until provision is made by Parliament under clause (2), the President may, after consultation with the Speaker of the House of the People or the Chairman of the Council of States, as the case may be, make rules regulating the recruitment, and the conditions of service of persons appointed, to the secretarial staff of the House of the People or the Council of States, and any rules so made shall have effect subject to the provisions of any law made under the said clause.\\r\\n\"],\"21\":[\"99. Oath or affirmation by members\",\"Every member of either House of Parliament shall, before taking his seat, make and subscribe before the President, or some person appointed in that behalf by him, an oath or affirmation according to the form set out for the purpose in the Third Schedule.\"],\"22\":[\"100. Voting in Houses, power of Houses to act notwithstanding vacancies and quorum\",\"(1) Save as otherwise provided in this Constitution, all questions at any sitting of either House or joint sitting of the Houses shall be determined by a majority of votes of the members present and voting, other than the Speaker or person acting as Chairman or Speaker.\\r\\nThe Chairman or Speaker, or person acting as such, shall not vote in the first instance, but shall have and exercise a casting vote in the case of an equality of votes.\\r\\n(2) Either House of Parliament shall have power to act notwithstanding any vacancy in the membership thereof, and any proceedings in Parliament shall be valid notwithstanding that it is discovered subsequently that some person who was not entitled so to do sat or voted or otherwise took part in the proceedings.\\r\\n104[(3) Until Parliament by law otherwise provides, the quorum to constitute a meeting of either House of Parliament shall be one-tenth of the total number of members of the House.\\r\\n(4) If at any time during a meeting of a House there is no quorum, it shall be the duty of the Chairman or Speaker, or person acting as such, either to adjourn the House or to suspend the meeting until there is a quorum.\\r\\n\"],\"23\":[\"101. Vacation of seats\",\"(1) No person shall be a member of both Houses of Parliament and provision shall be made by Parliament by law for the vacation by a person who is chosen a member of both Houses of his seat in one House or the other.\\r\\n(2) No person shall be a member both of Parliament and of a House of the Legislature of a State 105 and if a person is chosen a member both of Parliament and of a House of the Legislature of 106[a State], then, at the expiration of such period as may be specified in rules107 made by the President, that person\'s seat in Parliament shall become vacant, unless he has previously resigned his seat in the Legislature of the State.\\r\\n(3) If a member of either House of Parliament\\u2014\\r\\n(a) becomes subject to any of the disqualifications mentioned in clause (1) [or clause 108 of Article 102, or\\r\\n [(b) resigns his seat by writing under his hand addressed to the Chairman or the Speaker, as the case may be, and his resignation is accepted by the Chairman or the Speaker, as the case may be,]\\r\\nhis seat shall thereupon become vacant:\\r\\n [Provided that in the case of any resignation referred to in sub-clause (b), if from information received or otherwise and after making such inquiry as he thinks fit, the Chairman or the Speaker, as the case may be, is satisfied that such resignation is not voluntary or genuine, he shall not accept such resignation.]\\r\\n(4) If for a period of sixty days a member of either House of Parliament is without permission of the House absent from all meetings thereof, the House may declare his seat vacant:\\r\\nProvided that in computing the said period of sixty days no account shall be taken of any period during which the House is prorogued or is adjourned for more than four consecutive days.\\r\\n\"],\"24\":[\"102. Disqualifications for membership\",\"(1) A person shall be disqualified for being chosen as, and for being, a member of either House of Parliament\\u2014\\r\\n [(a) if he holds any office of profit under the Government of India or the Government of any State, other than an office declared by Parliament by law not to disqualify its holder;]\\r\\n(b) if he is of unsound mind and stands so declared by a competent court;\\r\\n(c) if he is an undischarged insolvent;\\r\\n(d) if he is not a citizen of India, or has voluntarily acquired the citizenship of a foreign State, or is under any acknowledgement of allegiance or adherence to a foreign State;\\r\\n(e) if he is so disqualified by or under any law made by Parliament.\\r\\n(2) A person shall be disqualified for being a member of either House of Parliament if he is so disqualified under the Tenth Schedule\"],\"25\":[\"103. Decision on questions as to disqualifications of members\",\"(1) If any question arises as to whether a member of either House of Parliament has become subject to any of the disqualifications mentioned in clause (1) of Article 102, the question shall be referred for the decision of the President and his decision shall be final.\\r\\n(2) Before giving any decision on any such question, the President shall obtain the opinion of the Election Commission and shall act according to such opinion\\r\\n\"],\"26\":[\"104. Penalty for sitting and voting before making oath or affirmation under Article 99 or when not qualified or when disqualified\",\"If a person sits or votes as a member of either House of Parliament before he has complied with the requirements of Article 99, or when he knows that he is not qualified or that he is disqualified for membership thereof, or that he is prohibited from so doing by the provisions of any law made by Parliament, he shall be liable in respect of each day on which he so sits or votes to a penalty of five hundred rupees to be recovered as a debt due to the Union.\\r\\n\"],\"27\":[\"105. Powers, privileges, etc., of the Houses of Parliament and of the members and committees thereof\",\"(1) Subject to the provisions of this Constitution and to the rules and standing orders regulating the procedure of Parliament, there shall be freedom of speech in Parliament.\\r\\n(2) No member of Parliament shall be liable to any proceedings in any court in respect of anything said or any vote given by him in Parliament or any committee thereof, and no person shall be so liable in respect of the publication by or under the authority of either House of Parliament of any report, paper, votes or proceedings.\\r\\n(3) In other respects, the powers, privileges and immunities of each House of Parliament, and of the members and the committees of each House, shall be such as may from time to time be defined by Parliament by law, and, until so defined, 116[shall be those of that House and of its members and committees immediately before the coming into force of Section 15 of the Constitution (Forty-fourth Amendment) Act, 1978].\\r\\n(4) The provisions of clauses (1), (2) and (3) shall apply in relation to persons who by virtue of this Constitution have the right to speak in, and otherwise to take part in the proceedings of, a House of Parliament or any committee thereof as they apply in relation to members of Parliament.\\r\\n\"],\"28\":[\"106. Salaries and allowances of members\",\"Members of either House of Parliament shall be entitled to receive such salaries and allowances as may from time to time be determined by Parliament by law and, until provision in that respect is so made, allowances at such rates and upon such conditions as were immediately before the commencement of this Constitution applicable in the case of members of the Constituent Assembly of the Dominion of India\"],\"29\":[\"107. Provisions as to introduction and passing of Bills\",\"(1) Subject to the provisions of Articles 109 and 117 with respect to Money Bills and other financial Bills, a Bill may originate in either House of Parliament.\\r\\n(2) Subject to the provisions of Article 108 and 109, a Bill shall not be deemed to have been passed by the Houses of Parliament unless it has been agreed to by both Houses, either without amendment or with such amendments only as are agreed to by both Houses.\\r\\n(3) A Bill pending in Parliament shall not lapse by reason of the prorogation of the Houses.\\r\\n(4) A Bill pending in the Council of States which has not been passed by the House of the People shall not lapse on a dissolution of the House of the People.\\r\\n(5) A Bill which is pending in the House of the People, or which having been passed by the House of the People is pending in the Council of States, shall, subject to the provisions of Article 108, lapse on a dissolution of the House of the People.\\r\\n\"],\"30\":[\"108. Joint sitting of both Houses in certain cases\",\"(1) If after a Bill has been passed by one House and transmitted to the other House\\u2014\\r\\n(a) the Bill is rejected by the other House; or\\r\\n(b) the Houses have finally disagreed as to the amendments to be made in the Bill; or\\r\\n(c) more than six months elapse from the date of the reception of the Bill by the other House without the Bill being passed by it,\\r\\nthe President may, unless the Bill has lapsed by reason of a dissolution of the House of the People, notify to the Houses by message if they are sitting or by public notification if they are not sitting, his intention to summon them to meet in a joint sitting for the purpose of deliberating and voting on the Bill:\\r\\nProvided that nothing in this clause shall apply to a Money Bill.\\r\\n(2) In reckoning any such period of six months as is referred to in clause (1), no account shall be taken of any period during which the House referred to in sub-clause (c) of that clause is prorogued or adjourned for more than four consecutive days.\\r\\n(3) Where the President has under clause (1) notified his intention of summoning the Houses to meet in a joint sitting, neither House shall proceed further with the Bill, but the President may at any time after the date of his notification summon the Houses to meet in a joint sitting for the purpose specified in the notification and, if he does so, the Houses shall meet accordingly.\\r\\n(4) If at the joint sitting of the two Houses the Bill, with such amendments, if any, as are agreed to in joint sitting, is passed by a majority of the total number of members of both Houses present and voting, it shall be deemed for the purposes of this Constitution to have been passed by both Houses:\\r\\nProvided that at a joint sitting\\u2014\\r\\n(a) if the Bill, having been passed by one House, has not been passed by the other House with amendments and returned to the House in which it originated, no amendment shall be proposed to the Bill other than such amendments (if any) as are made necessary by the delay in the passage of the Bill;\\r\\n(b) if the Bill has been so passed and returned, only such amendments as aforesaid shall be proposed to the Bill and such other amendments as are relevant to the matters with respect to which the Houses have not agreed;\\r\\nand the decision of the person presiding as to the amendments which are admissible under this clause shall be final.\\r\\n(5) A joint sitting may be held under this article and a Bill passed thereat, notwithstanding that a dissolution of the House of the People has intervened since the President notified his intention to summon the Houses to meet therein.\\r\\n\"],\"31\":[\"109. Special procedure in respect of Money Bills\",\"(1) A Money Bill shall not be introduced in the Council of States.\\r\\n(2) After a Money Bill has been passed by the House of the People it shall be transmitted to the Council of States for its recommendations and the Council of States shall within a period of fourteen days from the date of its receipt of the Bill return the Bill to the House of the People with its recommendations and the House of the People may thereupon either accept or reject all or any of the recommendations of the Council of States.\\r\\n(3) If the House of the People accepts any of the recommendations of the Council of States, the Money Bill shall be deemed to have been passed by both Houses with the amendments recommended by the Council of States and accepted by the House of the People.\\r\\n(4) If the House of the People does not accept any of the recommendations of the Council of States, the Money Bill shall be deemed to have been passed by both Houses in the form in which it was passed by the House of the People without any of the amendments recommended by the Council of States.\\r\\n(5) If a Money Bill passed by the House of the People and transmitted to the Council of States for its recommendations is not returned to the House of the People within the said period of fourteen days, it shall be deemed to have been passed by both Houses at the expiration of the said period in the form in which it was passed by the House of the People.\\r\\n\"],\"32\":[\"110. Definition of \\u201cMoney Bills\\u201d\",\"1) For the purposes of this Chapter, a Bill shall be deemed to be a Money Bill if it contains only provisions dealing with all or any of the following matters, namely\\u2014\\r\\n(a) the imposition, abolition, remission, alteration or regulation of any tax;\\r\\n(b) the regulation of the borrowing of money or the giving of any guarantee by the Government of India, or the amendment of the law with respect to any financial obligations undertaken or to be undertaken by the Government of India;\\r\\n(c) the custody of the Consolidated Fund or the Contingency Fund of India, the payment of moneys into or the withdrawal of moneys from any such Fund;\\r\\n(d) the appropriation of moneys out of the Consolidated Fund of India;\\r\\n(e) the declaring of any expenditure to be expenditure charged on the Consolidated Fund of India or the increasing of the amount of any such expenditure;\\r\\n(f) the receipt of money on account of the Consolidated Fund of India or the public account of India or the custody or issue of such money or the audit of the accounts of the Union or of a State; or\\r\\n(g) any matter incidental to any of the matters specified in sub-clauses (a) to (f).\\r\\n(2) A Bill shall not be deemed to be a Money Bill by reason only that it provides for the imposition of fines or other pecuniary penalties, or for the demand or payment of fees for licences or fees for services rendered, or by reason that it provides for the imposition, abolition, remission, alteration or regulation of any tax by any local authority or body for local purposes.\\r\\n(3) If any question arises whether a Bill is a Money Bill or not, the decision of the Speaker of the House of the People thereon shall be final.\\r\\n(4) There shall be endorsed on every Money Bill when it is transmitted to the Council of States under Article 109, and when it is presented to the President for assent under Article 111, the certificate of the Speaker of the House of the People signed by him that it is a Money Bill.\\r\\n\"],\"33\":[\"111. Assent to Bills\",\"When a Bill has been passed by the Houses of Parliament, it shall be presented to the President, and the President shall declare either that he assents to the Bill, or that he withholds assent therefrom:\\r\\nProvided that the President may, as soon as possible after the presentation to him of a Bill for assent, return the Bill if it is not a Money Bill to the Houses with a message requesting that they will reconsider the Bill or any specified provisions thereof and, in particular, will consider the desirability of introducing any such amendments as he may recommend in his message, and when a Bill is so returned, the Houses shall reconsider the Bill accordingly, and if the Bill is passed again by the Houses with or without amendment and presented to the President for assent, the President shall not withhold assent therefrom.\\r\\n\"],\"34\":[\"112. Annual financial statement\",\"(1) The President shall in respect of every financial year cause to be laid before both the Houses of Parliament a statement of the estimated receipts and expenditure of the Government of India for that year, in this Part referred to as the \\u201cannual financial statements\\u201d.\\r\\n(2) The estimates of expenditure embodied in the annual financial statement shall show separately\\u2014\\r\\n(a) the sums required to meet expenditure described by this Constitution as expenditure charged upon the Consolidated Fund of India; and\\r\\n(b) the sums required to meet other expenditure proposed to be made from the Consolidated Fund of India,\\r\\nand shall distinguish expenditure on revenue account from other expenditure.\\r\\n(3) The following expenditure shall be expenditure charged on the Consolidated Fund of India\\u2014\\r\\n(a) the emoluments and allowances of the President and other expenditure relating to his office;\\r\\n(b) the salaries and allowances of the Chairman and the Deputy Chairman of the Council of States and the Speaker and the Deputy Speaker of the House of the People;\\r\\n(c) debt charges for which the Government of India is liable including interest, sinking fund charges and redemption charges, and other expenditure relating to the raising of loans and the service and redemption of debt;\\r\\n(d)(i) the salaries, allowances and pensions payable to or in respect of Judges of the Supreme Court,\\r\\n(ii) the pensions payable to or in respect of Judges of the Federal Court,\\r\\n(iii) the pensions payable to or in respect of Judges of any High Court which exercises jurisdiction in relation to any area included in the territory of India or which at any time before the commencement of this Constitution exercised jurisdiction in relation to any area included in 117[a Governor\'s Province of the Dominion of India];\\r\\n(e) the salary, allowances and pension payable to or in respect of the Comptroller and Auditor-General of India;\\r\\n(f) any sums required to satisfy any judgment, decree or award of any Court or arbitral tribunal;\\r\\n(g) any other expenditure declared by this Constitution or by Parliament by law to be so charged.\\r\\n\"],\"35\":[\"113. Procedure in Parliament with respect to estimates\",\"(1) So much of the estimates as relates to expenditure charged upon the Consolidated Fund of India shall not be submitted to the vote of Parliament, but nothing in this clause shall be construed as preventing the discussion in either House of Parliament of any of those estimates.\\r\\n(2) So much of the said estimates as relates to other expenditure shall be submitted in the form of demands for grants to the House of the People, and, the House of the People shall have power to assent, or to refuse to assent, to any demand, or to assent to any demand subject to a reduction of the amount specified therein.\\r\\n(3) No demand for a grant shall be made except on the recommendation of the President.\\r\\n\"],\"36\":[\"114. Appropriation Bills\",\"(1) As soon as may be after the grants under Article 113 have been made by the House of the People, there shall be introduced a Bill to provide for the appropriation out of the Consolidated Fund of India of all moneys required to meet\\u2014\\r\\n(a) the grants so made by the House of the People; and\\r\\n(b) the expenditure charged on the Consolidated Fund of India but not exceeding in any case the amount shown in the statement previously laid before Parliament.\\r\\n(2) No amendment shall be proposed to any such Bill in either House of Parliament which will have the effect of varying the amount or altering the destination of any grant so made or of varying the amount of any expenditure charged on the Consolidated Fund of India, and the decision of the person presiding as to whether an amendment is inadmissible under this clause shall be final.\\r\\n(3) Subject to the provisions of Articles 115 and 116, no money shall be withdrawn from the Consolidated Fund of India except under appropriation made by law passed in accordance with the provisions of this article.\\r\\n\"],\"37\":[\"115. Supplementary, additional or excess grants\",\"(1) The President shall\\u2014\\r\\n(a) if the amount authorised by law made in accordance with the provisions of Article 114 to be expended for a particular service for the current financial year is found to be insufficient for the purposes of that year or when a need has arisen during the current financial year for supplementary or additional expenditure upon some new service not contemplated in the annual financial statement for that year, or\\r\\n(b) if any money has been spent on any service during a financial year in excess of the amount granted for that service and for that year,\\r\\ncause to be laid before both the Houses of Parliament another statement showing the estimated amount of that expenditure or cause to be presented to the House of the People a demand for such excess, as the case may be.\\r\\n(2) The provisions of Articles 112, 113 and 114 shall have effect in relation to any such statement and expenditure or demand and also to any law to be made authorising the appropriation of moneys out of the Consolidated Fund of India to meet such expenditure or the grant in respect of such demand as they have effect in relation to the annual financial statement and the expenditure mentioned therein or to a demand for a grant and the law to be made for the authorisation of appropriation of moneys out of the Consolidated Fund of India to meet such expenditure or grant.\\r\\n\"],\"38\":[\"116. Votes on account, votes of credit and exceptional grants\",\"(1) Notwithstanding anything in the foregoing provisions of this Chapter, the House of the People shall have power\\u2014\\r\\n(a) to make any grant in advance in respect of the estimated expenditure for a part of any financial year pending the completion of the procedure prescribed in Article 113 for the voting of such grant and the passing of the law in accordance with the provisions of Article 114 in relation to that expenditure;\\r\\n(b) to make a grant for meeting an unexpected demand upon the resources of India when on account of the magnitude or the indefinite character of the service the demand cannot be stated with the details ordinarily given in an annual financial statement;\\r\\n(c) to make an exceptional grant which forms no part of the current service of any financial year;\\r\\nand Parliament shall have power to authorise by law the withdrawal of moneys from the Consolidated Fund of India for the purposes for which the said grants are made.\\r\\n(2) The provisions of Articles 113 and 114 shall have effect in relation to the making of any grant under clause (1) and to any law to be made under that clause as they have effect in relation to the making of a grant with regard to any expenditure mentioned in the annual financial statement and the law to be made for the authorisation of appropriation of moneys out of the Consolidated Fund of India to meet such expenditure.\\r\\n\"],\"39\":[\"117. Special provisions as to financial Bills\",\"(1) A Bill or amendment making provision for any of the matters specified in sub-clauses (a) to (f) of clause (1) of Article 110 shall not be introduced or moved except on the recommendation of the President and a Bill making such provision shall not be introduced in the Council of States:\\r\\nProvided that no recommendation shall be required under this clause for the moving of an amendment making provision for the reduction or abolition of any tax.\\r\\n(2) A Bill or amendment shall not be deemed to make provision for any of the matters aforesaid by reason only that it provides for the imposition of fines or other pecuniary penalties, or for the demand or payment of fees for licences or fees for services rendered, or by reason that it provides for the imposition, abolition, remission, alteration or regulation of any tax by any local authority or body for local purposes.\\r\\n(3) A Bill which, if enacted and brought into operation, would involve expenditure from the Consolidated Fund of India shall not be passed by either House of Parliament unless the President has recommended to that House the consideration of the Bill.\\r\\n\"],\"40\":[\"118. Rules of procedure\",\"(1) Each House of Parliament may make rules for regulating, subject to the provisions of this Constitution, its procedure 118[* * *] and the conduct of its business.\\r\\n(2) Until rules are made under clause (1), the rules of procedure and standing orders in force immediately before the commencement of this Constitution with respect to the Legislature of the Dominion of India shall have effect in relation to Parliament subject to such modifications and adaptations as may be made therein by the Chairman of the Council of States or the Speaker of the House of the People, as the case may be.\\r\\n(3) The President, after consultation with the Chairman of the Council of States and the Speaker of the House of the People, may make rules as to the procedure with respect to joint sittings of, and communications between, the two Houses.\\r\\n(4) At a joint sitting of the two Houses the Speaker of the House of the People, or in his absence such person as may be determined by rules of procedure made under clause (3), shall preside.\\r\\n\"],\"41\":[\"119. Regulation by law of procedure in Parliament in relation to financial business\",\"Parliament may, for the purpose of the timely completion of financial business, regulate by law the procedure of, and the conduct of business in, each House of Parliament in relation to any financial matter or to any Bill for the appropriation of moneys out of the Consolidated Fund of India, and, if and so far as any provision of any law so made is inconsistent with any rule made by a House of Parliament under clause (1) of Article 118 or with any rule or standing order having effect in relation to Parliament under clause (2) of that article, such provision shall prevail.\"],\"42\":[\"120. Language to be used in Parliament.\",\"(1) Notwithstanding anything in Part XVII, but subject to the provisions of Article 348, business in Parliament shall be transacted in Hindi or in English:\\r\\nProvided that the Chairman of the Council of States or Speaker of the House of the People, or person acting as such, as the case may be, may permit any member who cannot adequately express himself in Hindi or in English to address the House in his mother tongue.\\r\\n(2) Unless Parliament by law otherwise provides, this article shall, after the expiration of a period of fifteen years from the commencement of this Constitution, have effect as if the words \\u201cor in English\\u201d were omitted therefrom.\\r\\n\"],\"43\":[\"121. Restriction on discussion in Parliament\",\"No discussion shall take place in Parliament with respect to the conduct of any Judge of the Supreme Court or of a High Court in the discharge of his duties except upon a motion for presenting an address to the President praying for the removal of the Judge as hereinafter provided.\"],\"44\":[\"122. Courts not to inquire into proceedings of Parliament\",\"(1) The validity of any proceedings in Parliament shall not be called in question on the ground of any alleged irregularity of procedure.\\r\\n(2) No officer or member of Parliament in whom powers are vested by or under this Constitution for regulating procedure or the conduct of business, or for maintaining order, in Parliament shall be subject to the jurisdiction of any court in respect of the exercise by him of those powers.\\r\\n\"]}', 1, '2021-01-30 02:50:44', '2021-01-30 03:36:58'),
(39, 'eAlnvhN6WivsY4v0Z320l9Z6g', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part V CHAPTER 5', 'COMPTROLLER AND AUDITOR-GENERAL OF INDIA', '', '', '{\"1\":[\"148. Comptroller and Auditor-General of India\",\"(1) There shall be a Comptroller and Auditor-General of India who shall be appointed by the President by warrant under his hand and seal and shall only be removed from office in like manner and on the like grounds as a Judge of the Supreme Court.\\r\\n(2) Every person appointed to be the Comptroller and Auditor-General of India shall, before he enters upon his office, make and subscribe before the President, or some person appointed in that behalf by him, an oath or affirmation according to the form set out for the purpose in the Third Schedule.\\r\\n(3) The salary and other conditions of service of the Comptroller and Auditor-General shall be such as may be determined by Parliament by law and, until they are so determined, shall be as specified in the Second Schedule:\\r\\nProvided that neither the salary of a Comptroller and Auditor-General nor his rights in respect of leave of absence, pension or age of retirement shall be varied to his disadvantage after his appointment.\\r\\n(4) The Comptroller and Auditor-General shall not be eligible for further office either under the Government of India or under the Government of any State after he has ceased to hold his office.\\r\\n(5) Subject to the provisions of this Constitution and of any law made by Parliament, the conditions of service of persons serving in the Indian Audit and Accounts Department and the administrative powers of the Comptroller and Auditor-General shall be such as may be prescribed by rules made by the President after consultation with the Comptroller and Auditor-General.\\r\\n(6) The administrative expenses of the office of the Comptroller and Auditor-General, including all salaries, allowances and pensions payable to or in respect of persons serving in that office, shall be charged upon the Consolidated Fund of India.\\r\\n\"],\"2\":[\"149. Duties and powers of the Comptroller and Auditor-General\",\"The Comptroller and Auditor-General shall perform such duties and exercise such powers in relation to the accounts of the Union and of the States and of any other authority or body as may be prescribed by or under any law made by Parliament and, until provision in that behalf is so made, shall perform such duties and exercise such powers in relation to the accounts of the Union and of the States as were conferred on or exercisable by the Auditor-General of India immediately before the commencement of this Constitution in relation to the accounts of the Dominion of India and of the Provinces respectively.\"],\"3\":[\"150. Form of accounts of the Union and of the States\",\"The accounts of the Union and of the States shall be kept in such form as the President may, on the advice of the Comptroller and Auditor-General of India, prescribe.\"],\"4\":[\"151. Audit reports\",\"(1) The reports of the Comptroller and Auditor- General of India relating to the accounts of the Union shall be submitted to the President, who shall cause them to be laid before each House of Parliament.\\r\\n(2) The reports of the Comptroller and Auditor-General of India relating to the accounts of a State shall be submitted to the Governor of the State, who shall cause them to be laid before the Legislature of the State.\\r\\n\"]}', 1, '2021-01-31 00:44:59', '2021-01-31 00:58:28'),
(40, 'co7jGYn1LxLt1BrsSk85LZxQf', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI  CHAPTER 1', 'GENERAL', '', '', '{\"1\":[\"152. Definition\",\"In this Part, unless the context otherwise requires, the expression \\u201cState\\u201d [does not include the State of Jammu and Kashmir].\"]}', 1, '2021-01-31 01:17:44', '2021-01-31 01:17:44');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(41, '382TCGzfkxdMeGRjN2k3apbiI', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI CHAPTER 2 ', 'THE EXECUTIVE', '', '', '{\"1\":[\"153. Governors of States\",\"There shall be a Governor for each State:\\r\\n [Provided that nothing in this article shall prevent the appointment of the same person as Governor for two or more States.]\\r\\n\"],\"2\":[\"154. Executive power of State\",\"(1) The executive power of the State shall be vested in the Governor and shall be exercised by him either directly or through officers subordinate to him in accordance with this Constitution.\\r\\n(2) Nothing in this article shall\\u2014\\r\\n(a) be deemed to transfer to the Governor any functions conferred by any existing law on any other authority; or\\r\\n(b) prevent Parliament or the Legislature of the State from conferring by law functions on any authority subordinate to the Governor\\r\\n\"],\"3\":[\"155. Appointment of Governor\",\"The Governor of a State shall be appointed by the President by warrant under his hand and seal.\"],\"4\":[\"156. Term of office of Governor\",\"(1) The Governor shall hold office during the pleasure of the President.\\r\\n(2) The Governor may, by writing under his hand addressed to the President, resign his office.\\r\\n(3) Subject to the foregoing provisions of this article, a Governor shall hold office for a term of five years from the date on which he enters upon his office\\r\\nProvided that a Governor shall, notwithstanding the expiration of his term, continue to hold office until his successor enters upon his office.\\r\\n\"],\"5\":[\"157. Qualifications for appointment as Governor\",\"No person shall be eligible for appointment as Governor unless he is a citizen of India and has completed the age of thirty-five years.\"],\"6\":[\"158. Conditions of Governor\'s office\",\"(1) The Governor shall not be a member of either House of Parliament or of a House of the Legislature of any State specified in the First Schedule, and if a member of either House of Parliament or of a House of the Legislature of any such State be appointed Governor, he shall be deemed to have vacated his seat in that House on the date on which he enters upon his office as Governor.\\r\\n(2) The Governor shall not hold any other office of profit.\\r\\n(3) The Governor shall be entitled without payment of rent to the use of his official residences and shall be also entitled to such emoluments, allowances and privileges as may be determined by Parliament by law and, until provision in that behalf is so made, such emoluments, allowances and privileges as are specified in the Second Schedule\\r\\n(3) The Governor shall be entitled without payment of rent to the use of his official residences and shall be also entitled to such emoluments, allowances and privileges as may be determined by Parliament by law and, until provision in that behalf is so made, such emoluments, allowances and privileges as are specified in the Second Schedule.\\r\\n(3-A) Where the same person is appointed as Governor of two or more States, the emoluments and allowances payable to the Governor shall be allocated among the States in such proportion as the President may by order determine.\\r\\n(4) The emoluments and allowances of the Governor shall not be diminished during his term of office.\\r\\n\"],\"7\":[\"159. Oath or affirmation by the Governor\",\"Every Governor and every person discharging the functions of the Governor shall, before entering upon his office, make and subscribe in the presence of the Chief Justice of the High Court exercising jurisdiction in relation to the State, or, in his absence, the seniormost Judge of that Court available, an oath or affirmation in the following form, that is to say\\u2014\\r\\nswear in the name of God\\r\\n\\u201cI, A.B., do \\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014\\u2014that I will faithfully execute the office of\\r\\nsolemnly affirm\\r\\nGovernor (or discharge the functions of the Governor) of \\u2026\\u2026\\u2026\\u2026\\u2026\\u2026\\u2026.. (name of the State) and will to the best of my ability preserve, protect and defend the Constitution and the law and that I will devote myself to the service and well-being of the people of \\u2026\\u2026\\u2026\\u2026\\u2026\\u2026. (name of the State).\\u201d\\r\\n\"],\"8\":[\"160. Discharge of the functions of the Governor in certain contingencies\",\"The President may make such provision as he thinks fit for the discharge of the functions of the Governor of a State in any contingency not provided for in this Chapter.\"],\"9\":[\"161. Power of Governor to grant pardons, etc., and to suspend, remit or commute sentences in certain cases\",\"The Governor of a State shall have the power to grant pardons, reprieves, respites or remissions of punishment or to suspend, remit or commute the sentence of any person convicted of any offence against any law relating to a matter to which the executive power of the State extends.\"],\"10\":[\"162. Extent of executive power of State\",\"Subject to the provisions of this Constitution, the executive power of a State shall extend to the matters with respect to which the Legislature of the State has power to make laws:\\r\\nProvided that in any matter with respect to which the Legislature of a State and Parliament have power to make laws, the executive power of the State shall be subject to, and limited by, the executive power expressly conferred by this Constitution or by any law made by Parliament upon the Union or authorities thereof.\\r\\n\"],\"11\":[\"163. Council of Ministers to aid and advise Governor\",\"(1) There shall be a Council of Ministers with the Chief Minister at the head to aid and advise the Governor in the exercise of his functions, except in so far as he is by or under this Constitution required to exercise his functions or any of them in his discretion.\\r\\n(2) If any question arises whether any matter is or is not a matter as respects which the Governor is by or under this Constitution required to act in his discretion, the decision of the Governor in his discretion shall be final, and the validity of anything done by the Governor shall not be called in question on the ground that he ought or ought not to have acted in his discretion.\\r\\n(3) The question whether any, and if so what, advice was tendered by Ministers to the Governor shall not be inquired into in any court.\\r\\n\"],\"12\":[\"164. Other provisions as to Ministers\",\"(1) The Chief Minister shall be appointed by the Governor and the other Ministers shall be appointed by the Governor on the advice of the Chief Minister, and the Ministers shall hold office during the pleasure of the Governor:\\r\\nProvided that in the States of Chhattisgarh, Jharkhand, Madhya Pradesh and Odisha, there shall be a Minister in charge of tribal welfare who may in addition be in charge of the welfare of the Scheduled Castes and backward classes or any other work.\\r\\n (1-A) The total number of Ministers, including the Chief Minister, in the Council of Ministers in a State shall not exceed fifteen per cent of the total number of members of the Legislative Assembly of that State:\\r\\nProvided that the number of Ministers, including the Chief Minister, in a State shall not be less than twelve:\\r\\nProvided further that where the total number of Ministers, including the Chief Minister, in the Council of Ministers in any State at the commencement of the Constitution (Ninety-first Amendment) Act, 2003 exceeds the said fifteen per cent or the number specified in the first proviso, as the case may be, then, the total number of Ministers in that State shall be brought in conformity with the provisions of this clause within six months from such date167 as the President may by public notification appoint.\\r\\n(1-B) A member of the Legislative Assembly of a State or either House of the Legislature of a State having Legislative Council belonging to any political party who is disqualified for being a member of that House under Paragraph 2 of the Tenth Schedule shall also be disqualified to be appointed as a Minister under clause (1) for duration of the period commencing from the date of his disqualification till the date on which the term of his office as such member would expire or where he contests any election to the Legislative Assembly of a State or either House of the Legislature of a State having Legislative Council, as the case may be, before the expiry of such period, till the date on which he is declared elected, whichever is earlier.]\\r\\n(2) The Council of Ministers shall be collectively responsible to the Legislative Assembly of the State.\\r\\n(3) Before a Minister enters upon his office, the Governor shall administer to him the oaths of office and of secrecy according to the forms set out for the purpose in the Third Schedule.\\r\\n(4) A Minister who for any period of six consecutive months is not a member of the Legislature of the State shall at the expiration of that period cease to be a Minister.\\r\\n(5) The salaries and allowances of Ministers shall be such as the Legislature of the State may from time to time by law determine and, until the Legislature of the State so determines, shall be as specified in the Second Schedule.\\r\\n\"],\"13\":[\"165. Advocate-General for the State\",\"(1) The Governor of each State shall appoint a person who is qualified to be appointed a Judge of a High Court to be Advocate-General for the State.\\r\\n(2) It shall be the duty of the Advocate-General to give advice to the Government of the State upon such legal matters, and to perform such other duties of a legal character, as may from time to time be referred or assigned to him by the Governor, and to discharge the functions conferred on him by or under this Constitution or any other law for the time being in force.\\r\\n(3) The Advocate-General shall hold office during the pleasure of the Governor, and shall receive such remuneration as the Governor may determine.\\r\\n\"],\"14\":[\"166. Conduct of business of the Government of a State\",\"(1) All executive action of the Government of a State shall be expressed to be taken in the name of the Governor.\\r\\n(2) Orders and other instruments made and executed in the name of the Governor shall be authenticated in such manner as may be specified in rules to be made by the Governor, and the validity of an order or instrument which is so authenticated shall not be called in question on the ground that it is not an order or instrument made or executed by the Governor.\\r\\n(3) The Governor shall make rules for the more convenient transaction of the business of the Government of the State, and for the allocation among Ministers of the said business in so far as it is not business with respect to which the Governor is by or under this Constitution required to act in his discretion.\\r\\n\"],\"15\":[\"167. Duties of Chief Minister as respects the furnishing of information to Governor, etc. \",\"It shall be the duty of the Chief Minister of each State(a) to communicate to the Governor of the State all decisions of the Council of Ministers relating to the administration of the affairs of the State and proposals for legislation;\\r\\n(b) to furnish such information relating to the administration of the affairs of the State and proposals for legislation as the Governor may call for; and\\r\\n(c) if the Governor so requires, to submit for the consideration of the Council of Ministers any matter on which a decision has been taken by a Minister but which has not been considered by the Council.\\r\\n\"]}', 1, '2021-01-31 01:20:20', '2021-01-31 01:30:26');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(42, 'Pcyh0iElvBKGlyacRml5HYSI2', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI  CHAPTER 3', 'THE STATE LEGISLATURE', '', '', '{\"1\":[\"168. Constitution of Legislatures in States\",\"(1) For every State there shall be a Legislature which shall consist of the Governor, and\\u2014\\r\\n(a) in the States of Andhra Pradesh, Bihar Madhya Pradesh , Maharashtra Karnataka],  Tamil Nadu Telangana and Uttar Pradesh, two Houses;\\r\\n(b) in other States, one House.\\r\\n(2) Where there are two Houses of the Legislature of a State, one shall be known as the Legislative Council and the other as the Legislative Assembly, and where there is only one House, it shall be known as the Legislative Assembly.\\r\\n\"],\"2\":[\"169. Abolition or creation of Legislative Councils in States\",\"(1) Notwithstanding anything in Article 168, Parliament may by law provide for the abolition of the Legislative Council of a State having such a Council or for the creation of such a Council in a State having no such Council, if the Legislative Assembly of the State passes a resolution to that effect by a majority of the total membership of the Assembly and by a majority of not less than two-thirds of the members of the Assembly present and voting.\\r\\n(2) Any law referred to in clause (1) shall contain such provisions for the amendment of this Constitution as may be necessary to give effect to the provisions of the law and may also contain such supplemental, incidental and consequential provisions as Parliament may deem necessary.\\r\\n(3) No such law as aforesaid shall be deemed to be an amendment of this Constitution for the purposes of Article 368.\\r\\n\"],\"3\":[\"170. Composition of the Legislative Assemblies\",\"(1) Subject to the provisions of Article 333, the Legislative Assembly of each State shall consist of not more than five hundred, and not less than sixty, members chosen by direct election from territorial constituencies in the State.\\r\\n(2) For the purposes of clause (1), each State shall be divided into territorial constituencies in such manner that the ratio between the population of each constituency and the number of seats allotted to it shall, so far as practicable, be the same throughout the State.\\r\\n(3) Upon the completion of each census, the total number of seats in the Legislative Assembly of each State and the division of each State into territorial constituencies shall be readjusted by such authority and in such manner as Parliament may by law determine:\\r\\nProvided that such readjustment shall not affect representation in the Legislative Assembly until the dissolution of the then existing Assembly:\\r\\nProvided further that such readjustment shall take effect from such date as the President may, by order, specify and until such readjustment takes effect, any election to the Legislative Assembly may be held on the basis of the territorial constituencies existing before such readjustment:\\r\\nProvided also that until the relevant figures for the first census taken after the year 2026 have been published, it shall not be necessary to readjust\\u2014\\r\\n(i) the total number of seats in the Legislative Assembly of each State as readjusted on the basis of the 1971 census; and\\r\\n(ii) the division of such State into territorial constituencies as may be readjusted on the basis of the 2001 census, under this clause.\\r\\n\"],\"4\":[\"171. Composition of the Legislative Councils\",\"(1) The total number of members in the Legislative Council of a State having such a Council shall not exceed 189[one-third] of the total number of members in the Legislative Assembly of that State:\\r\\nProvided that the total number of members in the Legislative Council of a State shall in no case be less than forty.\\r\\n(2) Until Parliament by law otherwise provides, the composition of the Legislative Council of a State shall be as provided in clause (3).\\r\\n(3) Of the total number of members of the Legislative Council of a State\\u2014\\r\\n(a) as nearly as may be, one-third shall be elected by electorates consisting of members of municipalities, district boards and such other local authorities in the State as Parliament may by law specify;\\r\\n(b) as nearly as may be, one-twelfth shall be elected by electorates consisting of persons residing in the State who have been for at least three years graduates of any university in the territory of India or have been for at least three years in possession of qualifications prescribed by or under any law made by Parliament as equivalent to that of a graduate of any such university;\\r\\n(c) as nearly as may be, one-twelfth shall be elected by electorates consisting of persons who have been for at least three years engaged in teaching in such educational institutions within the State, not lower in standard than that of a secondary school, as may be prescribed by or under any law made by Parliament;\\r\\n(d) as nearly as may be, one-third shall be elected by the members of the Legislative Assembly of the State from amongst persons who are not members of the Assembly;\\r\\n(e) the remainder shall be nominated by the Governor in accordance with the provisions of clause (5).\\r\\n(4) The members to be elected under sub-clauses (a), (b) and (c) of clause (3) shall be chosen in such territorial constituencies as may be prescribed by or under any law made by Parliament, and the elections under the said sub-clauses and under sub-clause (d) of the said clause shall be held in accordance with the system of proportional representation by means of the single transferable vote.\\r\\n(5) The members to be nominated by the Governor under sub-clause (e) of clause (3) shall consist of persons having special knowledge or practical experience in respect of such matters as the following, namely:\\u2014\\r\\nLiterature, science, art, co-operative movement and social service.\\r\\n\"],\"5\":[\"172. Duration of State Legislatures\",\"(1) Every Legislative Assembly of every State, unless sooner dissolved, shall continue for  five years from the date appointed for its first meeting and no longer and the expiration of the said period of five years shall operate as a dissolution of the Assembly:\\r\\nProvided that the said period may, while a Proclamation of Emergency is in operation, be extended by Parliament by law for a period not exceeding one year at a time and not extending in any case beyond a period of six months after the Proclamation has ceased to operate.\\r\\n(2) The Legislative Council of a State shall not be subject to dissolution, but as nearly as possible one-third of the members thereof shall retire as soon as may be on the expiration of every second year in accordance with the provisions made in that behalf by Parliament by law\\r\\n\"],\"6\":[\"173. Qualification for membership of the State Legislature\",\"A person shall not be qualified to be chosen to fill a seat in the Legislature of a State unless he\\u2014\\r\\n (a) is a citizen of India, and makes and subscribes before some person authorised in that behalf by the Election Commission an oath or affirmation according to the form set out for the purpose in the Third Schedule;\\r\\n(b) is, in the case of a seat in the Legislative Assembly, not less than twenty-five years of age and in the case of a seat in the Legislative Council, not less than thirty years of age; and\\r\\n(c) possesses such other qualifications as may be prescribed in that behalf by or under any law made by Parliament.\\r\\n\"],\"7\":[\"174. Sessions of the State Legislature, prorogation and dissolution\",\"(1) The Governor shall from time to time summon the House or each House of the Legislature of the State to meet at such time and place as he thinks fit, but six months shall not intervene between its last sitting in one session and the date appointed for its first sitting in the next session.\\r\\n(2) The Governor may from time to time\\u2014\\r\\n(a) prorogue the House or either House;\\r\\n(b) dissolve the Legislative Assembly.\\r\\n\"],\"8\":[\"175. Right of Governor to address and send messages to the House or Houses\",\"(1) The Governor may address the Legislative Assembly or, in the case of a State having a Legislative Council, either House of the Legislature of the State, or both Houses assembled together, and may for that purpose require the attendance of members.\\r\\n(2) The Governor may send messages to the House or Houses of the Legislature of the State, whether with respect to a Bill then pending in the Legislature or otherwise, and a House to which any message is so sent shall with all convenient despatch consider any matter required by the message to be taken into consideration.\\r\\n\"],\"9\":[\"176. Special address by the Governor\",\"(1) At the commencement of the first session after each general election to the Legislative Assembly and at the commencement of the first session of each year], the Governor shall address the Legislative Assembly or, in the case of a State having a Legislative Council, both Houses assembled together and inform the Legislature of the causes of its summons.\\r\\n(2) Provision shall be made by the rules regulating the procedure of the House or either House for the allotment of time for discussion of the matters referred to in such address \\r\\n\"],\"10\":[\"177. Rights of Ministers and Advocate-General as respects the Houses\",\"Every Minister and the Advocate-General for a State shall have the right to speak in, and otherwise to take part in the proceedings of, the Legislative Assembly of the State or, in the case of a State having a Legislative Council, both Houses, and to speak in, and otherwise to take part in the proceedings of, any committee of the Legislature of which he may be named a member, but shall not, by virtue of this article, be entitled to vote.\"],\"11\":[\"178. The Speaker and Deputy Speaker of the Legislative Assembly\",\"Every Legislative Assembly of a State shall, as soon as may be, choose two members of the Assembly to be respectively Speaker and Deputy Speaker thereof and, so often as the office of Speaker or Deputy Speaker becomes vacant, the Assembly shall choose another member to be Speaker or Deputy Speaker, as the case may be.\"],\"12\":[\"179. Vacation and resignation of, and removal from, the offices of Speaker and Deputy Speaker\",\"A member holding office as Speaker or Deputy Speaker of an Assembly\\u2014\\r\\n(a) shall vacate his office if he ceases to be a member of the Assembly;\\r\\n(b) may at any time by writing under his hand addressed, if such member is the Speaker, to the Deputy Speaker, and if such member is the Deputy Speaker, to the Speaker, resign his office; and\\r\\n(c) may be removed from his office by a resolution of the Assembly passed by a majority of all the then members of the Assembly:\\r\\nProvided that no resolution for the purpose of clause (c) shall be moved unless at least fourteen days\\u2019 notice has been given of the intention to move the resolution:\\r\\nProvided further that, whenever the Assembly is dissolved, the Speaker shall not vacate his office until immediately before the first meeting of the Assembly after the dissolution\\r\\n\"],\"13\":[\"180. Power of the Deputy Speaker or other person to perform the duties of the office of, or to act as, Speaker\",\"(1) While the office of Speaker is vacant, the duties of the office shall be performed by the Deputy Speaker or, if the office of Deputy Speaker is also vacant, by such member of the Assembly as the Governor may appoint for the purpose.\\r\\n(2) During the absence of the Speaker from any sitting of the Assembly the Deputy Speaker or, if he is also absent, such person as may be determined by the rules of procedure of the Assembly, or, if no such person is present, such other person as may be determined by the Assembly, shall act as the Speaker.\\r\\n\"],\"14\":[\"181. The Speaker or the Deputy Speaker not to preside while a resolution for his removal from office is under consideration\",\"(1) At any sitting of the Legislative Assembly, while any resolution for the removal of the Speaker from his office is under consideration, the Speaker, or while any resolution for the removal of the Deputy Speaker from his office is under consideration, the Deputy Speaker, shall not, though he is present, preside, and the provisions of clause (2) of Article 180 shall apply in relation to every such sitting as they apply in relation to a sitting from which the Speaker or, as the case may be, the Deputy Speaker, is absent.\\r\\n(2) The Speaker shall have the right to speak in, and otherwise to take part in the proceedings of, the Legislative Assembly while any resolution for his removal from office is under consideration in the Assembly and shall, notwithstanding anything in Article 189, be entitled to vote only in the first instance on such resolution or on any other matter during such proceedings but not in the case of an equality of votes.\\r\\n\"],\"15\":[\"182. The Chairman and Deputy Chairman of the Legislative Council\",\"The Legislative Council of every State having such Council shall, as soon as may be, choose two members of the Council to be respectively Chairman and Deputy Chairman thereof and, so often as the office of Chairman or Deputy Chairman becomes vacant, the Council shall choose another member to be Chairman or Deputy Chairman, as the case may be.\"],\"16\":[\"183. Vacation and resignation of, and removal from, the offices of Chairman and Deputy Chairman\",\"A member holding office as Chairman or Deputy Chairman of a Legislative Council\\u2014\\r\\n(a) shall vacate his office if he ceases to be a member of the Council;\\r\\n(b) may at any time by writing under his hand addressed, if such member is the Chairman, to the Deputy Chairman, and if such member is the Deputy Chairman, to the Chairman, resign his office; and\\r\\n(c) may be removed from his office by a resolution of the Council passed by a majority of all the then members of the Council:\\r\\nProvided that no resolution for the purpose of clause (c) shall be moved unless at least fourteen days\\u2019 notice has been given of the intention to move the resolution\\r\\n\"],\"17\":[\"184. Power of the Deputy Chairman or other person to perform the duties of the office of, or to act as, Chairman\",\"(1) While the office of Chairman is vacant, the duties of the office shall be performed by the Deputy Chairman or, if the office of Deputy Chairman is also vacant, by such member of the Council as the Governor may appoint for the purpose.\\r\\n(2) During the absence of the Chairman from any sitting of the Council the Deputy Chairman or, if he is also absent, such person as may be determined by the rules of procedure of the Council, or, if no such person is present, such other person as may be determined by the Council, shall act as Chairman.\\r\\n\"],\"18\":[\"185. The Chairman or the Deputy Chairman not to preside while a resolution for his removal from office is under consideration\",\"(1) At any sitting of the Legislative Council, while any resolution for the removal of the Chairman from his office is under consideration, the Chairman, or while any resolution for the removal of the Deputy Chairman from his office is under consideration, the Deputy Chairman, shall not, though he is present, preside, and the provisions of clause (2) of Article 184 shall apply in relation to every such sitting as they apply in relation to a sitting from which the Chairman or, as the case may be, the Deputy Chairman is absent.\\r\\n(2) The Chairman shall have the right to speak in, and otherwise to take part in the proceedings of, the Legislative Council while any resolution for his removal from office is under consideration in the Council and shall, notwithstanding anything in Article 189, be entitled to vote only in the first instance on such resolution or on any other matter during such proceedings but not in the case of an equality of votes.\\r\\n\"],\"19\":[\"186. Salaries and allowances of the Speaker and Deputy Speaker and the Chairman and Deputy Chairman\",\"There shall be paid to the Speaker and the Deputy Speaker of the Legislative Assembly, and to the Chairman and the Deputy Chairman of the Legislative Council, such salaries and allowances as may be respectively fixed by the Legislature of the State by law and, until provision in that behalf is so made, such salaries and allowances as are specified in the Second Schedule.\"],\"20\":[\"187. Secretariat of State Legislature\",\"(1) The House or each House of the Legislature of a State shall have a separate secretarial staff:\\r\\nProvided that nothing in this clause shall, in the case of the Legislature of a State having a Legislative Council, be construed as preventing the creation of posts common to both Houses of such Legislature.\\r\\n(2) The Legislature of a State may by law regulate the recruitment, and the conditions of service of persons appointed, to the secretarial staff of the House or Houses of the Legislature of the State.\\r\\n(3) Until provision is made by the Legislature of the State under clause (2), the Governor may, after consultation with the Speaker of the Legislative Assembly or the Chairman of the Legislative Council, as the case may be, make rules regulating the recruitment, and the conditions of service of persons appointed, to the secretarial staff of the Assembly or the Council, and any rules so made shall have effect subject to the provisions of any law made under the said clause.\\r\\n\"],\"21\":[\"188. Oath or affirmation by members\",\"Every member of the Legislative Assembly or the Legislative Council of a State shall, before taking his seat, make and subscribe before the Governor, or some person appointed in that behalf by him, an oath or affirmation according to the form set out for the purpose in the Third Schedule.\"],\"22\":[\"189. Voting in Houses, power of Houses to act notwithstanding vacancies and quorum\",\"(1) Save as otherwise provided in this Constitution, all questions at any sitting of a House of the Legislature of a State shall be determined by a majority of votes of the members present and voting, other than the Speaker or Chairman, or person acting as such.\\r\\nThe Speaker or Chairman, or person acting as such, shall not vote in the first instance, but shall have and exercise a casting vote in the case of an equality of votes.\\r\\n(2) A House of the Legislature of a State shall have power to act notwithstanding any vacancy in the membership thereof, and any proceedings in the Legislature of a State shall be valid notwithstanding that it is discovered subsequently that some person who was not entitled so to do sat or voted or otherwise took part in the proceedings.\\r\\n     (3) Until the Legislature of the State by law otherwise provides, the quorum to constitute a meeting of a House of the Legislature of a State shall be ten members or one-tenth of the total number of members of the House, whichever is greater.\\r\\n(4) If at any time during a meeting of the Legislative Assembly or the Legislative Council of a State there is no quorum, it shall be the duty of the Speaker or Chairman, or person acting as such, either to adjourn the House or to suspend the meeting until there is a quorum.\\r\\n\"],\"23\":[\"190. Vacation of seats\",\"(1) No person shall be a member of both Houses of the Legislature of a State and provision shall be made by the Legislature of the State by law for the vacation by a person who is chosen a member of both Houses of his seat in one House or the other.\\r\\n(2) No person shall be a member of the Legislatures of two or more States specified in the First Schedule and if a person is chosen a member of the Legislatures of two or more such States, then, at the expiration of such period as may be specified in rules198 made by the President, that person\'s seat in the Legislatures of all such States shall become vacant, unless he has previously resigned his seat in the Legislatures of all but one of the States.\\r\\n(3) If a member of a House of the Legislature of a State\\u2014\\r\\n(a) becomes subject to any of the disqualifications mentioned in clause (1) or clause (2)of Article 191; or\\r\\n(b) resigns his seat by writing under his hand addressed to the Speaker or the Chairman, as the case may be, and his resignation is accepted by the Speaker or the Chairman, as the case may be,\\r\\nhis seat shall thereupon become vacant:\\r\\n [Provided that in the case of any resignation referred to in sub-clause (b), if from information received or otherwise and after making such inquiry as he thinks fit, the Speaker or the Chairman, as the case may be, is satisfied that such resignation is not voluntary or genuine, he shall not accept such resignation.\\r\\n(4) If for a period of sixty days a member of a House of the Legislature of a State is without permission of the House absent from all meetings thereof, the House may declare his seat vacant:\\r\\nProvided that in computing the said period of sixty days no account shall be taken of any period during which the House is prorogued or is adjourned for more than four consecutive days\\r\\n\"],\"24\":[\"191. Disqualifications for membership\",\" (1) A person shall be disqualified for being chosen as, and for being, a member of the Legislative Assembly or Legislative Council of a State\\u2014\\r\\n (a) if he holds any office of profit under the Government of India or the Government of any State specified in the First Schedule, other than an office declared by the Legislature of the State by law not to disqualify its holder;\\r\\n(b) if he is of unsound mind and stands so declared by a competent court;\\r\\n(c) if he is an undischarged insolvent;\\r\\n(d) if he is not a citizen of India, or has voluntarily acquired the citizenship of a foreign State, or is under any acknowledgment of allegiance or adherence to a foreign State;\\r\\n(e) if he is so disqualified by or under any law made by Parliament.\\r\\n (2) A person shall be disqualified for being a member of the Legislative Assembly or Legislative Council of a State if he is so disqualified under the Tenth Schedule.\\r\\n\"],\"25\":[\"192. Decision on questions as to disqualifications of members\",\"(1) If any question arises as to whether a member of a House of the Legislature of a State has become subject to any of the disqualifications mentioned in clause (1) of Article 191, the question shall be referred for the decision of the Governor and his decision shall be final.\\r\\n(2) Before giving any decision on any such question, the Governor shall obtain the opinion of the Election Commission and shall act according to such opinion.\\r\\n\"],\"26\":[\"193. Penalty for sitting and voting before making oath or affirmation under Article 188 or when not qualified or when disqualified\",\"If a person sits or votes as a member of the Legislative Assembly or the Legislative Council of a State before he has complied with the requirements of Article 188, or when he knows that he is not qualified or that he is disqualified for membership thereof, or that he is prohibited from so doing by the provisions of any law made by Parliament or the Legislature of the State, he shall be liable in respect of each day on which he so sits or votes to a penalty of five hundred rupees to be recovered as a debt due to the State.\"],\"27\":[\"194. Powers, privileges, etc., of the Houses of Legislatures and of the members and committees thereof\",\"(1) Subject to the provisions of this Constitution and to the rules and standing orders regulating the procedure of the Legislature, there shall be freedom of speech in the Legislature of every State.\\r\\n(2) No member of the Legislature of a State shall be liable to any proceedings in any court in respect of anything said or any vote given by him in the Legislature or any committee thereof, and no person shall be so liable in respect of the publication by or under the authority of a House of such a Legislature of any report, paper, votes or proceedings.\\r\\n(3) In other respects, the powers, privileges and immunities of a House of the Legislature of a State, and of the members and the committees of a House of such Legislature, shall be such as may from time to time be defined by the Legislature by law, and, until so defined, 207[shall be those of that House and of its members and committees immediately before the coming into force of Section 26 of the Constitution (Forty-fourth Amendment) Act, 1978].\\r\\n(4) The provisions of clauses (1), (2) and (3) shall apply in relation to persons who by virtue of this Constitution have the right to speak in, and otherwise to take part in the proceedings of, a House of the Legislature of a State or any committee thereof as they apply in relation to members of that Legislature.\\r\\n\"],\"28\":[\"195. Salaries and allowances of members\",\"Members of the Legislative Assembly and the Legislative Council of a State shall be entitled to receive such salaries and allowances as may from time to time be determined, by the Legislature of the State by law and, until provision in that respect is so made, salaries and allowances at such rates and upon such conditions as were immediately before the commencement of this Constitution applicable in the case of members of the Legislative Assembly of the corresponding Province.\"],\"29\":[\"196. Provisions as to introduction and passing of Bills\",\"(1) Subject to the provisions of Articles 198 and 207 with respect to Money Bills and other financial Bills, a Bill may originate in either House of the Legislature of a State which has a Legislative Council.\\r\\n(2) Subject to the provisions of Articles 197 and 198, a Bill shall not be deemed to have been passed by the Houses of the Legislature of a State having a Legislative Council unless it has been agreed to by both Houses, either without amendment or with such amendments only as are agreed to by both Houses.\\r\\n(3) A Bill pending in the Legislature of a State shall not lapse by reason of the prorogation of the House or Houses thereof.\\r\\n(4) A Bill pending in the Legislative Council of a State which has not been passed by the Legislative Assembly shall not lapse on a dissolution of the Assembly.\\r\\n(5) A Bill which is pending in the Legislative Assembly of a State, or which having been passed by the Legislative Assembly is pending in the Legislative Council, shall lapse on a dissolution of the Assembly.\\r\\n\"],\"30\":[\"197. Restriction on powers of Legislative Council as to Bills other than Money Bills\",\"(1) If after a Bill has been passed by the Legislative Assembly of a State having a Legislative Council and transmitted to the Legislative Council\\u2014\\r\\n(a) the Bill is rejected by the Council; or\\r\\n(b) more than three months elapse from the date on which the Bill is laid before the Council without the Bill being passed by it; or\\r\\n(c) the Bill is passed by the Council with amendments to which the Legislative Assembly does not agree;\\r\\nthe Legislative Assembly may, subject to the rules regulating its procedure, pass the Bill again in the same or in any subsequent session with or without such amendments, if any, as have been made, suggested or agreed to by the Legislative Council and then transmit the Bill as so passed to the Legislative Council.\\r\\n(2) If after a Bill has been so passed for the second time by the Legislative Assembly and transmitted to the Legislative Council\\u2014\\r\\n(a) the Bill is rejected by the Council; or\\r\\n(b) more than one month elapses from the date on which the Bill is laid before the Council without the Bill being passed by it; or\\r\\n(c) the Bill is passed by the Council with amendments to which the Legislative Assembly does not agree;\\r\\nthe Bill shall be deemed to have been passed by the Houses of the Legislature of the State in the form in which it was passed by the Legislative Assembly for the second time with such amendments, if any, as have been made or suggested by the Legislative Council and agreed to by the Legislative Assembly.\\r\\n(3) Nothing in this article shall apply to a Money Bill.\\r\\n\"],\"31\":[\"198. Special procedure in respect of Money Bills\",\"(1) A Money Bill shall not be introduced in a Legislative Council.\\r\\n(2) After a Money Bill has been passed by the Legislative Assembly of a State having a Legislative Council, it shall be transmitted to the Legislative Council for its recommendations, and the Legislative Council shall within a period of fourteen days from the date of its receipt of the Bill return the Bill to the Legislative Assembly with its recommendations, and the Legislative Assembly may thereupon either accept or reject all or any of the recommendations of the Legislative Council.\\r\\n(3) If the Legislative Assembly accepts any of the recommendations of the Legislative Council, the Money Bill shall be deemed to have been passed by both Houses with the amendments recommended by the Legislative Council and accepted by the Legislative Assembly.\\r\\n(4) If the Legislative Assembly does not accept any of the recommendations of the Legislative Council, the Money Bill shall be deemed to have been passed by both Houses in the form in which it was passed by the Legislative Assembly without any of the amendments recommended by the Legislative Council.\\r\\n(5) If a Money Bill passed by the Legislative Assembly and transmitted to the Legislative Council for its recommendations is not returned to the Legislative Assembly within the said period of fourteen days, it shall be deemed to have been passed by both Houses at the expiration of the said period in the form in which it was passed by the Legislative Assembly.\\r\\n\"],\"32\":[\"199. Definition of \\u201cMoney Bills\\u201d\",\"(1) For the purposes of this Chapter, a Bill shall be deemed to be a Money Bill if it contains only provisions dealing with all or any of the following matters, namely:\\u2014\\r\\n(a) the imposition, abolition, remission, alteration or regulation of any tax;\\r\\n(b) the regulation of the borrowing of money or the giving of any guarantee by the State, or the amendment of the law with respect to any financial obligations undertaken or to be undertaken by the State;\\r\\n(c) the custody of the Consolidated Fund or the Contingency Fund of the State, the payment of moneys into or the withdrawal of moneys from any such Fund;\\r\\n(d) the appropriation of moneys out of the Consolidated Fund of the State;\\r\\n(e) the declaring of any expenditure to be expenditure charged on the Consolidated Fund of the State, or the increasing of the amount of any such expenditure;\\r\\n(f) the receipt of money on account of the Consolidated Fund of the State or the public account of the State or the custody or issue of such money; or\\r\\n(g) any matter incidental to any of the matters specified in sub-clauses (a) to (f).\\r\\n(2) A Bill shall not be deemed to be a Money Bill by reason only that it provides for the imposition of fines or other pecuniary penalties, or for the demand or payment of fees for licences or fees for services rendered, or by reason that it provides for the imposition, abolition, remission, alteration or regulation of any tax by any local authority or body for local purposes.\\r\\n(3) If any question arises whether a Bill introduced in the Legislature of a State which has a Legislative Council is a Money Bill or not, the decision of the Speaker of the Legislative Assembly of such State thereon shall be final.\\r\\n(4) There shall be endorsed on every Money Bill when it is transmitted to the Legislative Council under Article 198, and when it is presented to the Governor for assent under Article 200, the certificate of the Speaker of the Legislative Assembly signed by him that it is a Money Bill.\\r\\n\"],\"33\":[\"200. Assent to Bills\",\"When a Bill has been passed by the Legislative Assembly of a State or, in the case of a State having a Legislative Council, has been passed by both Houses of the Legislature of the State, it shall be presented to the Governor and the Governor shall declare either that he assents to the Bill or that he withholds assent therefrom or that he reserves the Bill for the consideration of the President:\\r\\nProvided that the Governor may, as soon as possible after the presentation to him of the Bill for assent, return the Bill if it is not a Money Bill together with a message requesting that the House or Houses will reconsider the Bill or any specified provisions thereof and, in particular, will consider the desirability of introducing any such amendments as he may recommend in his message and, when a Bill is so returned, the House or Houses shall reconsider the Bill accordingly, and if the Bill is passed again by the House or Houses with or without amendment and presented to the Governor for assent, the Governor shall not withhold assent therefrom:\\r\\nProvided further that the Governor shall not assent to, but shall reserve for the consideration of the President, any Bill which in the opinion of the Governor would, if it became law, so derogate from the powers of the High Court as to endanger the position which that Court is by this Constitution designed to fill.\\r\\n\"],\"34\":[\"201. Bills reserved for consideration\",\"When a Bill is reserved by a Governor for the consideration of the President, the President shall declare either that he assents to the Bill or that he withholds assent therefrom:\\r\\nProvided that, where the Bill is not a Money Bill, the President may direct the Governor to return the Bill to the House or, as the case may be, the Houses of the Legislature of the State together with such a message as is mentioned in the first proviso to Article 200 and, when a Bill is so returned, the House or Houses shall reconsider it accordingly within a period of six months from the date of receipt of such message and, if it is again passed by the House or Houses with or without amendment, it shall be presented again to the President for his consideration\\r\\n\"],\"35\":[\"202. Annual financial statement\",\"(1) The Governor shall in respect of every financial year cause to be laid before the House or Houses of the Legislature of the State a statement of the estimated receipts and expenditure of the State for that year, in this Part referred to as the \\u201cannual financial statement\\u201d.\\r\\n(2) The estimates of expenditure embodied in the annual financial statement shall show separately\\u2014\\r\\n(a) the sums required to meet expenditure described by this Constitution as expenditure charged upon the Consolidated Fund of the State; and\\r\\n(b) the sums required to meet other expenditure proposed to be made from the Consolidated Fund of the State;\\r\\nand shall distinguish expenditure on revenue account from other expenditure.\\r\\n(3) The following expenditure shall be expenditure charged on the Consolidated Fund of each State\\u2014\\r\\n(a) the emoluments and allowances of the Governor and other expenditure relating to his office;\\r\\n(b) the salaries and allowances of the Speaker and the Deputy Speaker of the Legislative Assembly and, in the case of a State having a Legislative Council, also of the Chairman and the Deputy Chairman of the Legislative Council;\\r\\n(c) debt charges for which the State is liable including interest, sinking fund charges and redemption charges, and other expenditure relating to the raising of loans and the service and redemption of debt;\\r\\n(d) expenditure in respect of the salaries and allowances of Judges of any High Court;\\r\\n(e) any sums required to satisfy any judgment, decree or award of any court or arbitral tribunal;\\r\\n(f) any other expenditure declared by this Constitution, or by the Legislature of the State by law, to be so charged.\\r\\n\"],\"36\":[\"203. Procedure in Legislature with respect to estimates\",\"(1) So much of the estimates as relates to expenditure charged upon the Consolidated Fund of a State shall not be submitted to the vote of the Legislative Assembly, but nothing in this clause shall be construed as preventing the discussion in the Legislature of any of those estimates.\\r\\n(2) So much of the said estimates as relates to other expenditure shall be submitted in the form of demands for grants to the Legislative Assembly, and the Legislative Assembly shall have power to assent, or to refuse to assent, to any demand, or to assent to any demand subject to a reduction of the amount specified therein.\\r\\n(3) No demand for a grant shall be made except on the recommendation of the Governor.\\r\\n\"],\"37\":[\"204. Appropriation Bills\",\"(1) As soon as may be after the grants under Article 203 have been made by the Assembly, there shall be introduced a Bill to provide for the appropriation out of the Consolidated Fund of the State of all moneys required to meet\\u2014\\r\\n(a) the grants so made by the Assembly; and\\r\\n(b) the expenditure charged on the Consolidated Fund of the State but not exceeding in any case the amount shown in the statement previously laid before the House or Houses.\\r\\n(2) No amendment shall be proposed to any such Bill in the House or either House of the Legislature of the State which will have the effect of varying the amount or altering the destination of any grant so made or of varying the amount of any expenditure charged on the Consolidated Fund of the State, and the decision of the person presiding as to whether an amendment is inadmissible under this clause shall be final.\\r\\n(3) Subject to the provisions of Articles 205 and 206, no money shall be withdrawn from the Consolidated Fund of the State except under appropriation made by law passed in accordance with the provisions of this article.\\r\\n\"],\"38\":[\"205. Supplementary, additional or excess grants\",\"(1) The Governor shall\\u2014\\r\\n(a) if the amount authorised by any law made in accordance with the provisions of Article 204 to be expended for a particular service for the current financial year is found to be insufficient for the purposes of that year or when a need has arisen during the current financial year for supplementary or additional expenditure upon some new service not contemplated in the annual financial statement for that year, or\\r\\n(b) if any money has been spent on any service during a financial year in excess of the amount granted for that service and for that year,\\r\\ncause to be laid before the House or the Houses of the Legislature of the State another statement showing the estimated amount of that expenditure or cause to be presented to the Legislative Assembly of the State a demand for such excess, as the case may be.\\r\\n(2) The provisions of Articles 202, 203 and 204 shall have effect in relation to any such statement and expenditure or demand and also to any law to be made authorising the appropriation of moneys out of the Consolidated Fund of the State to meet such expenditure or the grant in respect of such demand as they have effect in relation to the annual financial statement and the expenditure mentioned therein or to a demand for a grant and the law to be made for the authorisation of appropriation of moneys out of the Consolidated Fund of the State to meet such expenditure or grant.\\r\\n\"],\"39\":[\"206. Votes on account, votes of credit and exceptional grants\",\"(1) Notwithstanding anything in the foregoing provisions of this Chapter, the Legislative Assembly of a State shall have power\\u2014\\r\\n(a) to make any grant in advance in respect of the estimated expenditure for a part of any financial year pending the completion of the procedure prescribed in Article 203 for the voting of such grant and the passing of the law in accordance with the provisions of Article 204 in relation to that expenditure;\\r\\n(b) to make a grant for meeting an unexpected demand upon the resources of the State when on account of the magnitude or the indefinite character of the service the demand cannot be stated with the details ordinarily given in an annual financial statement;\\r\\n(c) to make an exceptional grant which forms no part of the current service of any financial year;\\r\\nand the Legislature of the State shall have power to authorise by law the withdrawal of moneys from the Consolidated Fund of the State for the purposes for which the said grants are made.\\r\\n(2) The provisions of Articles 203 and 204 shall have effect in relation to the making of any grant under clause (1) and to any law to be made under that clause as they have effect in relation to the making of a grant with regard to any expenditure mentioned in the annual financial statement and the law to be made for the authorisation of appropriation of moneys out of the Consolidated Fund of the State to meet such expenditure.\\r\\n\"],\"40\":[\"207. Special provisions as to financial Bills\",\"(1) A Bill or amendment making provision for any of the matters specified in sub-clauses (a) to (f) of clause (1) of Article 199 shall not be introduced or moved except on the recommendation of the Governor, and a Bill making such provision shall not be introduced in a Legislative Council:\\r\\nProvided that no recommendation shall be required under this clause for the moving of an amendment making provision for the reduction or abolition of any tax.\\r\\n(2) A Bill or amendment shall not be deemed to make provision for any of the matters aforesaid by reason only that it provides for the imposition of fines or other pecuniary penalties, or for the demand or payment of fees for licences or fees for services rendered, or by reason that it provides for the imposition, abolition, remission, alteration or regulation of any tax by any local authority or body for local purposes.\\r\\n(3) A Bill which, if enacted and brought into operation, would involve expenditure from the Consolidated Fund of a State shall not be passed by a House of the Legislature of the State unless the Governor has recommended to that House the consideration of the Bill.\\r\\n\"],\"41\":[\"208. Rules of procedure\",\"(1) A House of the Legislature of a State may make rules for regulating, subject to the provisions of this Constitution, its procedure 208[* * *] and the conduct of its business.\\r\\n(2) Until rules are made under clause (1), the rules of procedure and standing orders in force immediately before the commencement of this Constitution with respect to the Legislature for the corresponding Province shall have effect in relation to the Legislature of the State subject to such modifications and adaptations as may be made therein by the Speaker of the Legislative Assembly, or the Chairman of the Legislative Council, as the case may be.\\r\\n(3) In a State having a Legislative Council the Governor, after consultation with the Speaker of the Legislative Assembly and the Chairman of the Legislative Council, may make rules as to the procedure with respect to communications between the two Houses.\\r\\n\"],\"42\":[\"209. Regulation by law of procedure in the Legislature of the State in relation to financial business\",\"The Legislature of a State may, for the purpose of the timely completion of financial business, regulate by law the procedure of, and the conduct of business in, the House or Houses of the Legislature of the State in relation to any financial matter or to any Bill for the appropriation of moneys out of the Consolidated Fund of the State, and, if and so far as any provision of any law so made is inconsistent with any rule made by the House or either House of the Legislature of the State under clause (1) of Article 208 or with any rule or standing order having effect in relation to the Legislature of the State under clause (2) of that article, such provision shall prevail.\"],\"43\":[\"210. Language to be used in the Legislature\",\" (1) Notwithstanding anything in Part XVII, but subject to the provisions of Article 348, business in the Legislature of a State shall be transacted in the official language or languages of the State or in Hindi or in English:\\r\\nProvided that the Speaker of the Legislative Assembly or Chairman of the Legislative Council, or person acting as such, as the case may be, may permit any member who cannot adequately express himself in any of the languages aforesaid to address the House in his mother-tongue.\\r\\n(2) Unless the Legislature of the State by law otherwise provides, this article shall, after the expiration of a period of fifteen years from the commencement of this Constitution, have effect as if the words \\u201cor in English\\u201d were omitted therefrom:\\r\\n [Provided that in relation to the Legislatures of the States of Himachal Pradesh, Manipur, Meghalaya and Tripura this clause shall have effect as if for the words \\u201cfifteen years\\u201d occurring therein, the words \\u201ctwenty-five years\\u201d were substituted\\r\\n\"],\"44\":[\"211. Restriction on discussion in the Legislature\",\"No discussion shall take place in the Legislature of a State with respect to the conduct of any Judge of the Supreme Court or of a High Court in the discharge of his duties.\"],\"45\":[\"212. Courts not to inquire into proceedings of the Legislature\",\"(1) The validity of any proceedings in the Legislature of a State shall not be called in question on the ground of any alleged irregularity of procedure.\\r\\n(2) No officer or member of the Legislature of a State in whom powers are vested by or under this Constitution for regulating procedure or the conduct of business, or for maintaining order, in the Legislature shall be subject to the jurisdiction of any court in respect of the exercise by him of those powers.\\r\\n\"]}', 1, '2021-01-31 01:36:45', '2021-01-31 02:36:32'),
(43, 'G0EAisASeKnzAfLbo1dy250Ly', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI  CHAPTER 4', 'LEGISLATIVE POWER OF THE GOVERNOR', '', '', '{\"1\":[\"213. Power of Governor to promulgate Ordinances during recess of Legislature\",\".\\u2014(1) If at any time, except when the Legislative Assembly of a State is in session, or where there is a Legislative Council in a State, except when both Houses of the Legislature are in session, the Governor is satisfied that circumstances exist which render it necessary for him to take immediate action, he may promulgate such Ordinances as the circumstances appear to him to require:\\r\\nProvided that the Governor shall not, without instructions from the President, promulgate any such Ordinance if\\u2014\\r\\n(a) a Bill containing the same provisions would under this Constitution have required the previous sanction of the President for the introduction thereof into the Legislature; or\\r\\n(b) he would have deemed it necessary to reserve a Bill containing the same provisions for the consideration of the President; or\\r\\n(c) an Act of the Legislature of the State containing the same provisions would under this Constitution have been invalid unless, having been reserved for the consideration of the President, it had received the assent of the President.\\r\\n(2) An Ordinance promulgated under this article shall have the same force and effect as an Act of the Legislature of the State assented to by the Governor, but every such Ordinance\\u2014\\r\\n(a) shall be laid before the Legislative Assembly of the State, or where there is a Legislative Council in the State, before both the Houses, and shall cease to operate at the expiration of six weeks from the reassembly of the Legislature, or if before the expiration of that period a resolution disapproving it is passed by the Legislative Assembly and agreed to by the Legislative Council, if any, upon the passing of the resolution or, as the case may be, on the resolution being agreed to by the Council; and\\r\\n(b) may be withdrawn at any time by the Governor.\\r\\nExplanation.\\u2014Where the Houses of the Legislature of a State having a Legislative Council are summoned to reassemble on different dates, the period of six weeks shall be reckoned from the later of those dates for the purposes of this clause.\\r\\n(3) If and so far as an Ordinance under this article makes any provision which would not be valid if enacted in an Act of the Legislature of the State assented to by the Governor, it shall be void:\\r\\nProvided that, for the purposes of the provisions of this Constitution relating to the effect of an Act of the Legislature of a State which is repugnant to an Act of Parliament or an existing law with respect to a matter enumerated in the Concurrent List, an Ordinance promulgated under this article in pursuance of instructions from the President shall be deemed to be an Act of the Legislature of the State which has been reserved for the consideration of the President and assented to by him.\\r\\n\"]}', 1, '2021-01-31 02:40:06', '2021-01-31 02:40:06');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(44, 'CYZTHBi03Mpz5NbPS76WcKQyg', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI CHAPTER 5', 'THE HIGH COURTS IN THE STATES', '', '', '{\"1\":[\"214. High Courts for States\",\"There shall be a High Court for each State.\"],\"2\":[\"215. High Courts to be courts of record\",\"Every High Court shall be a court of record and shall have all the powers of such a court including the power to punish for contempt of itself\"],\"3\":[\"216. Constitution of High Courts\",\"Every High Court shall consist of a Chief Justice and such other Judges as the President may from time to time deem it necessary to appoint.\"],\"4\":[\"217. Appointment and conditions of the office of a Judge of a High Court\",\"(1) Every Judge of a High Court shall be appointed by the President by warrant under his hand and shall hold office, in the case of an additional or acting Judge, as provided in Article 224, and in any other case, until he attains the age of sixty-two years\\r\\nProvided that\\u2014\\r\\n(a) a Judge may, by writing under his hand addressed to the President, resign his office;\\r\\n(b) a Judge may be removed from his office by the President in the manner provided in clause (4) of Article 124 for the removal of a Judge of the Supreme Court;\\r\\n(c) the office of a Judge shall be vacated by his being appointed by the President to be a Judge of the Supreme Court or by his being transferred by the President to any other High Court within the territory of India.\\r\\n(2) A person shall not be qualified for appointment as a Judge of a High Court unless he is a citizen of India and\\u2014\\r\\n(a) has for at least ten years held a judicial office in the territory of India; or\\r\\n(b) has for at least ten years been an advocate of a High Court  or of two or more such Courts in succession\\r\\n\"],\"5\":[\"218. Application of certain provisions relating to Supreme Court to High Courts\",\"The provisions of clauses (4) and (5) of Article 124 shall apply in relation to a High Court as they apply in relation to the Supreme Court with the substitution of references to the High Court for references to the Supreme Court.\"],\"6\":[\"219. Oath or affirmation by Judges of High Courts\",\"Every person appointed to be a Judge of a High Court shall, before he enters upon his office, make and subscribe before the Governor of the State, or some person appointed in that behalf by him, an oath or affirmation according to the form set out for the purpose in the Third Schedule.\"],\"7\":[\"220. Restriction on practice after being a permanent Judge\",\" No person who, after the commencement of this Constitution, has held office as a permanent Judge of a High Court shall plead or act in any court or before any authority in India except the Supreme Court and the other High Courts.\"],\"8\":[\"221. Salaries etc. of Judges\",\"(1) There shall be paid to the Judges of each High Court such salaries as may be determined by Parliament by law and, until provision in that behalf is so made, such salaries as are specified in the Second Schedule.\\r\\n(2) Every Judge shall be entitled to such allowances and to such rights in respect of leave of absence and pension as may from time to time be determined by or under law made by Parliament and, until so determined, to such allowances and rights as are specified in the Second Schedule\\r\\n\"],\"9\":[\"222. Transfer of a Judge from one High Court to another\",\"(1) The President may, on the recommendation of the National Judicial Appointments Commission referred to in Article 124-A, transfer a Judge from one High Court to any other High Court \\r\\n(2) When a Judge has been or is so transferred, he shall, during the period he serves, after the commencement of the Constitution (Fifteenth Amendment) Act, 1963, as a Judge of the other High Court, be entitled to receive in addition to his salary such compensatory allowance as may be determined by Parliament by law and, until so determined, such compensatory allowance as the President may by order fix.\\r\\n\"],\"10\":[\"223. Appointment of acting Chief Justice\",\"When the office of Chief Justice of a High Court is vacant or when any such Chief Justice is, by reason of absence or otherwise, unable to perform the duties of his office, the duties of the office shall be performed by such one of the other Judges of the Court as the President may appoint for the purpose\"],\"11\":[\"224. Appointment of additional and acting Judges\",\"(1) If by reason of any temporary increase in the business of a High Court or by reason of arrears of work therein, it appears to the President that the number of the Judges of that Court should be for the time being increased, 239[the President may, in consultation with the National Judicial Appointments Commission, appoint] duly qualified persons to be additional Judges of the Court for such period not exceeding two years as he may specify.\\r\\n(2) When any Judge of a High Court other than the Chief Justice is by reason of absence or for any other reason unable to perform the duties of his office or is appointed to act temporarily as Chief Justice, the President may, in consultation with the National Judicial Appointments Commission, appoint] a duly qualified person to act as a Judge of that Court until the permanent Judge has resumed his duties.\\r\\n(3) No person appointed as an additional or acting Judge of a High Court shall hold office after attaining the age of sixty-two years\\r\\n\\r\\n\"],\"12\":[\"224-A. Appointment of retired Judges at sittings of High Courts\",\"Notwithstanding anything in this Chapter, 243[the National Judicial Appointments Commission on a reference made to it by the Chief Justice of a High Court for any State, may with the previous consent of the President], request any person who has held the office of Judge of that Court or of any other High Court to sit and act as a Judge of the High Court for that State, and every such person so requested shall, while so sitting and acting, be entitled to such allowances as the President may by order determine and have all the jurisdiction, powers and privileges of, but shall not otherwise be deemed to be, a Judge of that High Court:\\r\\nProvided that nothing in this article shall be deemed to require any such person as aforesaid to sit and act as a Judge of that High Court unless he consents so to do\\r\\n\"],\"13\":[\"225. Jurisdiction of existing High Courts\",\"Subject to the provisions of this Constitution and to the provisions of any law of the appropriate Legislature made by virtue of powers conferred on that Legislature by this Constitution, the jurisdiction of, and the law administered in, any existing High Court, and the respective powers of the Judges thereof in relation to the administration of justice in the Court, including any power to make rules of Court and to regulate the sittings of the Court and of members thereof sitting alone or in Division Courts, shall be the same as immediately before the commencement of this Constitution\"],\"14\":[\"226. Power of High Courts to issue certain writs\",\"(1) Notwithstanding anything in Article 32, every High Court shall have power, throughout the territories in relation to which it exercises jurisdiction, to issue to any person or authority, including in appropriate cases, any Government, within those territories directions, orders or writs, including writs in the nature of habeas corpus, mandamus, prohibition, quo warranto and certiorari, or any of them, for the enforcement of any of the rights conferred by Part III and for any other purpose.\\r\\n(2) The power conferred by clause (1) to issue directions, orders or writs to any Government, authority or person may also be exercised by any High Court exercising jurisdiction in relation to the territories within which the cause of action, wholly or in part, arises for the exercise of such power, notwithstanding that the seat of such Government or authority or the residence of such person is not within those territories.\\r\\n(3) Where any party against whom an interim order, whether by way of injunction or stay or in any other manner, is made on, or in any proceedings relating to, a petition under clause (1), without\\u2014\\r\\n(a) furnishing to such party copies of such petition and all documents in support of the plea for such interim order; and\\r\\n(b) giving such party an opportunity of being heard,\\r\\nmakes an application to the High Court for the vacation of such order and furnishes a copy of such application to the party in whose favour such order has been made or the counsel of such party, the High Court shall dispose of the application within a period of two weeks from the date on which it is received or from the date on which the copy of such application is so furnished, whichever is later, or where the High Court is closed on the last day of that period, before the expiry of the next day afterwards on which the High Court is open; and if the application is not so disposed of, the interim order shall, on the expiry of that period, or, as the case may be, the expiry of the said next day, stand vacated.\\r\\n(4) The power conferred on a High Court by this article shall not be in derogation of the power conferred on the Supreme Court by clause (2) of Article 32.\\r\\n\"],\"15\":[\"227. Power of superintendence over all courts by the High Court\",\"(1) Every High Court shall have superintendence over all courts and tribunals throughout the territories in relation to which it exercises jurisdiction.\\r\\n(2) Without prejudice to the generality of the foregoing provision, the High Court may\\u2014\\r\\n(a) call for returns from such courts;\\r\\n(b) make and issue general rules and prescribe forms for regulating the practice and proceedings of such courts; and\\r\\n(c) prescribe forms in which books, entries and accounts shall be kept by the officers of any such courts.\\r\\n(3) The High Court may also settle tables of fees to be allowed to the sheriff and all clerks and officers of such courts and to attorneys, advocates and pleaders practising therein:\\r\\nProvided that any rules made, forms prescribed or tables settled under clause (2) or clause (3) shall not be inconsistent with the provision of any law for the time being in force, and shall require the previous approval of the Governor.\\r\\n(4) Nothing in this article shall be deemed to confer on a High Court powers of superintendence over any court or tribunal constituted by or under any law relating to the Armed Forces.\\r\\n\"],\"16\":[\"228. Transfer of certain cases to High Court.\",\"If the High Court is satisfied that a case pending in a court subordinate to it involves a substantial question of law as to the interpretation of this Constitution the determination of which is necessary for the disposal of the case,  it shall withdraw the case and may\\u2014\\r\\n(a) either dispose of the case itself, or\\r\\n(b) determine the said question of law and return the case to the court from which the case has been so withdrawn together with a copy of its judgment on such question, and the said court shall on receipt thereof proceed to dispose of the case in conformity with such judgment.\\r\\n\"],\"17\":[\"229. Officers and servants and the expenses of High Courts\",\"(1) Appointments of officers and servants of a High Court shall be made by the Chief Justice of the Court or such other Judge or officer of the Court as he may direct:\\r\\nProvided that the Governor of the State may by rule require that in such cases as may be specified in the rule no person not already attached to the Court shall be appointed to any office connected with the Court save after consultation with the State Public Service Commission.\\r\\n(2) Subject to the provisions of any law made by the Legislature of the State, the conditions of service of officers and servants of a High Court shall be such as may be prescribed by rules made by the Chief Justice of the Court or by some other Judge or officer of the Court authorised by the Chief Justice to make rules for the purpose:\\r\\nProvided that the rules made under this clause shall, so far as they relate to salaries, allowances, leave or pensions, require the approval of the Governor of the State \\r\\n(3) The administrative expenses of a High Court, including all salaries, allowances and pensions payable to or in respect of the officers and servants of the Court, shall be charged upon the Consolidated Fund of the State, and any fees or other moneys taken by the Court shall form part of that Fund\\r\\n\"],\"18\":[\"230. Extension of jurisdiction of High Courts to Union territories\",\"(1) Parliament may by law extend the jurisdiction of a High Court to, or exclude the jurisdiction of a High Court from, any Union territory.\\r\\n(2) Where the High Court of a State exercises jurisdiction in relation to a Union territory,\\u2014\\r\\n(a) nothing in this Constitution shall be construed as empowering the Legislature of the State to increase, restrict or abolish that jurisdiction; and\\r\\n(b) the reference in Article 227 to the Governor shall, in relation to any rules, forms or tables for subordinate courts in that territory, be construed as a reference to the President.\\r\\n\"],\"19\":[\"231. Establishment of a common High Court for two or more States\",\"(1) Notwithstanding anything contained in the preceding provisions of this Chapter, Parliament may by law establish a common High Court for two or more States or for two or more States and a Union territory.\\r\\n(2) In relation to any such High Court,\\u2014\\r\\n(a) 265[* * *]\\r\\n(b) the reference in Article 227 to the Governor shall, in relation to any rules, forms or tables for subordinate courts, be construed as a reference to the Governor of the State in which the subordinate courts are situate; and\\r\\n(c) the references in Articles 219 and 229 to the State shall be construed as a reference to the State in which the High Court has its principal seat:\\r\\n\"],\"20\":[\"232. Interpretation\",\"Substituted\"]}', 1, '2021-01-31 02:41:23', '2021-01-31 19:05:05'),
(45, 'fSfzHBx7Hp3ZvAKdgcZxG7EmL', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VI CHAPTER 6', 'SUBORDINATE COURTS', '', '', '{\"1\":[\"233. Appointment of district judges\",\"(1) Appointments of persons to be, and the posting and promotion of, district judges in any State shall be made by the Governor of the State in consultation with the High Court exercising jurisdiction in relation to such State.\\r\\n(2) A person not already in the service of the Union or of the State shall only be eligible to be appointed a district judge if he has been for not less than seven years an advocate or a pleader and is recommended by the High Court for appointment\\r\\n\"],\"2\":[\"233-A. Validation of appointments of, and judgments, etc., delivered by, certain district judges\",\"Notwithstanding any judgment, decree or order of any court, \\u2014\\r\\n(a)(i) no appointment of any person already in the judicial service of a State or of any person who has been for not less than seven years an advocate or a pleader, to be a district judge in that State, and\\r\\n(ii) no posting, promotion or transfer of any such person as a district judge,\\r\\nmade at any time before the commencement of the Constitution (Twentieth Amendment) Act, 1966, otherwise than in accordance with the provisions of Article 233 or Article 235 shall be deemed to be illegal or void or ever to have become illegal or void by reason only of the fact that such appointment, posting, promotion or transfer was not made in accordance with the said provisions;\\r\\n(b) no jurisdiction exercised, no judgment, decree, sentence or order passed or made, and no other act or proceeding done or taken, before the commencement of the Constitution (Twentieth Amendment) Act, 1966 by, or before, any person appointed, posted, promoted or transferred as a district judge in any State otherwise than in accordance with the provisions of Article 233 or Article 235 shall be deemed to be illegal or invalid or ever to have become illegal or invalid by reason only of the fact that such appointment, posting, promotion or transfer was not made in accordance with the said provisions\\r\\n\"],\"3\":[\"234. Recruitment of persons other than district judges to the judicial service\",\"Appointments of persons other than district judges to the judicial service of a State shall be made by the Governor of the State in accordance with rules made by him in that behalf after consultation with the State Public Service Commission and with the High Court exercising jurisdiction in relation to such State.\"],\"4\":[\"235. Control over subordinate courts\",\"The control over district courts and courts subordinate thereto including the posting and promotion of, and the grant of leave to, persons belonging to the judicial service of a State and holding any post inferior to the post of district judge shall be vested in the High Court, but nothing in this article shall be construed as taking away from any such person any right of appeal which he may have under the law regulating the conditions of his service or as authorising the High Court to deal with him otherwise than in accordance with the conditions of his service prescribed under such law.\"],\"5\":[\"236. Interpretation\",\"In this Chapter\\u2014\\r\\n(a) the expression \\u201cdistrict judge\\u201d includes judge of a city civil court, additional district judge, joint district judge, assistant district judge, chief judge of a small cause court, chief presidency magistrate, additional chief presidency magistrate, sessions judge, additional sessions judge and assistant sessions judge;\\r\\n(b) the expression \\u201cjudicial service\\u201d means a service consisting exclusively of persons intended to fill the post of district judge and other civil judicial posts inferior to the post of district judge.\\r\\n\"],\"6\":[\"237. Application of the provisions of this Chapter to certain class or classes of magistrates\",\"The Governor may by public notification direct that the foregoing provisions of this Chapter and any rules made thereunder shall with effect from such date as may be fixed by him in that behalf apply in relation to any class or classes of magistrates in the State as they apply in relation to persons appointed to the judicial service of the State subject to such exceptions and modifications as may be specified in the notification.\"]}', 1, '2021-01-31 19:06:44', '2021-01-31 19:09:17'),
(46, 'LEjUdS9pZFuKTauNyAfkX1hei', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VII ', 'THE STATES IN PART B OF THE FIRST SCHEDULE', '', '', '{\"1\":[\"THE STATES IN PART B OF THE FIRST SCHEDULE\",\"[Rep. by the Constitution (Seventh Amendment) Act, 1956, Section 29 and Schedule268]\"]}', 1, '2021-01-31 19:11:21', '2021-01-31 19:11:21'),
(47, '6aLNENIXse0m4ynDTiU0flUVW', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part VIII ', 'THE UNION TERRITORIES', '', '', '{\"1\":[\"239. Administration of Union territories\",\"(1) Save as otherwise provided by Parliament by law, every Union territory shall be administered by the President acting, to such extent as he thinks fit, through an administrator to be appointed by him with such designation as he may specify.\\r\\n(2) Notwithstanding anything contained in Part VI, the President may appoint the Governor of a State as the administrator of an adjoining Union territory, and where a Governor is so appointed, he shall exercise his functions as such administrator independently of his Council of Ministers\\r\\n\"],\"2\":[\" 239-A. Creation of local Legislatures or Council of Ministers or both for certain Union territories\",\"(1) Parliament may by law create the Union territory of Puducherry\\r\\n(a) a body, whether elected or partly nominated and partly elected, to function as a Legislature for the Union territory, or\\r\\n(b) a Council of Ministers,\\r\\nor both with such constitution, powers and functions, in each case, as may be specified in the law.\\r\\n(2) Any such law as is referred to in clause (1) shall not be deemed to be an amendment of this Constitution for the purposes of Article 368 notwithstanding that it contains any provision which amends or has the effect of amending this Constitution.\\r\\n\"],\"3\":[\"239-AA. Special provisions with respect to Delhi\",\"(1) As from the date of commencement of the Constitution (Sixty-ninth Amendment) Act, 1991, the Union territory of Delhi shall be called the National Capital Territory of Delhi (hereafter in this Part referred to as the National Capital Territory) and the administrator thereof appointed under Article 239 shall be designated as the Lieutenant Governor.\\r\\n(2)(a) There shall be a Legislative Assembly for the National Capital Territory and the seats in such Assembly shall be filled by members chosen by direct election from territorial constituencies in the National Capital Territory.\\r\\n(b) The total number of seats in the Legislative Assembly, the number of seats reserved for Scheduled Castes, the division of the National Capital Territory into territorial constituencies (including the basis for such division) and all other matters relating to the functioning of the Legislative Assembly shall be regulated by law made by Parliament.\\r\\n(c) The provisions of Articles 324 to 327 and 329 shall apply in relation to the National Capital Territory, the Legislative Assembly of the National Capital Territory and the members thereof as they apply, in relation to a State, the Legislative Assembly of a State and the members thereof respectively; and any reference in Articles 326 and 329 to \\u2018appropriate Legislature\\u2019 shall be deemed to be a reference to Parliament.\\r\\n(3)(a) Subject to the provisions of this Constitution, the Legislative Assembly shall have power to make laws for the whole or any part of the National Capital Territory with respect to any of the matters enumerated in the State List or in the Concurrent List in so far as any such matter is applicable to Union territories except matters with respect to Entries 1, 2 and 18 of the State List and Entries 64, 65 and 66 of that List in so far as they relate to the said Entries 1, 2 and 18.\\r\\n(b) Nothing in sub-clause (a) shall derogate from the powers of Parliament under this Constitution to make laws with respect to any matter for a Union territory or any part thereof.\\r\\n(c) If any provision of a law made by the Legislative Assembly with respect to any matter is repugnant to any provision of a law made by Parliament with respect to that matter, whether passed before or after the law made by the Legislative Assembly, or of an earlier law, other than a law made by the Legislative Assembly, then, in either case, the law made by Parliament, or, as the case may be, such earlier law, shall prevail and the law made by the Legislative Assembly shall, to the extent of the repugnancy, be void:\\r\\nProvided that if any such law made by the Legislative Assembly has been reserved for the consideration of the President and has received his assent, such law shall prevail in the National Capital Territory:\\r\\nProvided further that nothing in this sub-clause shall prevent Parliament from enacting at any time any law with respect to the same matter including a law adding to, amending, varying or repealing the law so made by the Legislative Assembly.\\r\\n(4) There shall be a Council of Ministers consisting of not more than ten per cent of the total number of members in the Legislative Assembly, with the Chief Minister at the head to aid and advise the Lieutenant Governor in the exercise of his functions in relation to matters with respect to which the Legislative Assembly has power to make laws, except in so far as he is, by or under any law, required to act in his discretion:\\r\\nProvided that in the case of difference of opinion between the Lieutenant Governor and his Ministers on any matter, the Lieutenant Governor shall refer it to the President for decision and act according to the decision given thereon by the President and pending such decision it shall be competent for the Lieutenant Governor in any case where the matter, in his opinion, is so urgent that it is necessary for him to take immediate action, to take such action or to give such direction in the matter as he deems necessary.\\r\\n(5) The Chief Minister shall be appointed by the President and the other Ministers shall be appointed by the President on the advice of the Chief Minister and the Ministers shall hold office during the pleasure of the President.\\r\\n(6) The Council of Ministers shall be collectively responsible to the Legislative Assembly.\\r\\n(7) (a)Parliament may, by law, make provisions for giving effect to, or supplementing the provisions contained in the foregoing clauses and for all matters incidental or consequential thereto.\\r\\n(b) Any such law as is referred to in sub-clause (a) shall not be deemed to be an amendment of this Constitution for the purposes of Article 368 notwithstanding that it contains any provision which amends or has the effect of amending, this Constitution.\\r\\n(8) The provisions of Article 239-B shall, so far as may be, apply in relation to the National Capital Territory, the Lieutenant Governor and the Legislative Assembly, as they apply in relation to the Union territory of Puducherry, the administrator and its Legislature, respectively; and any reference in that article to \\u2018clause (1) of Article 239-A\\u2019 shall be deemed to be a reference to this article or Article 239-AB, as the case may be.\\r\\n\"],\"4\":[\"239-AB. Provision in case of failure of constitutional machinery\",\". If the President, on receipt of a report from the Lieutenant Governor or otherwise, is satisfied \\u2014\\r\\n(a) that a situation has arisen in which the administration of the National Capital Territory cannot be carried on in accordance with the provisions of Article 239-AA or of any law made in pursuance of that article; or\\r\\n(b) that for the proper administration of the National Capital Territory it is necessary or expedient so to do,\\r\\nthe President may by order suspend the operation of any provision of Article 239-AA or of all or any of the provisions of any law made in pursuance of that article for such period and subject to such conditions as may be specified in such law and make such incidental and consequential provisions as may appear to him to be necessary or expedient for administering the National Capital Territory in accordance with the provisions of Article 239 and Article 239-AA.\\r\\n\"],\"5\":[\"239-B. Power of administrator to promulgate Ordinances during recess of Legislature\",\"(1) If at any time, except when the Legislature of the Union territory of Puducherry is in session, the administrator thereof is satisfied that circumstances exist which render it necessary for him to take immediate action, he may promulgate such Ordinances as the circumstances appear to him to require:\\r\\nProvided that no such Ordinance shall be promulgated by the administrator except after obtaining instructions from the President in that behalf:\\r\\nProvided further that whenever the said Legislature is dissolved, or its functioning remains suspended on account of any action taken under any such law as is referred to in clause (1) of Article 239-A, the administrator shall not promulgate any Ordinance during the period of such dissolution or suspension.\\r\\n(2) An Ordinance promulgated under this article in pursuance of instructions from the President shall be deemed to be an Act of the Legislature of the Union territory which has been duly enacted after complying with the provisions in that behalf contained in any such law as is referred to in clause (1) of Article 239-A, but every such Ordinance\\u2014\\r\\n(a) shall be laid before the Legislature of the Union territory and shall cease to operate at the expiration of six weeks from the reassembly of the Legislature or if, before the expiration of that period, a resolution disapproving it is passed by the Legislature, upon the passing of the resolution; and\\r\\n(b) may be withdrawn at any time by the administrator after obtaining instructions from the President in that behalf.\\r\\n(3) If and so far as an Ordinance under this article makes any provision which would not be valid if enacted in an Act of the Legislature of the Union territory made after complying with the provisions in that behalf contained in any such law as is referred to in clause (1) of Article 239-A, it shall be void\\r\\n\"],\"6\":[\"240. Power of President to make regulations for certain Union territories\",\"(1) The President may make regulations for the peace, progress and good government of the Union territory of\\u2014\\r\\n(a) the Andaman and Nicobar Islands;\\r\\n(b) Lakshadweep\\r\\n(c) Dadra and Nagar Haveli and Daman and Diu\\r\\n(d)  Puducherry\\r\\n\"],\"7\":[\"241. High Courts for Union territories\",\"(1) Parliament may by law constitute a High Court for a Union territory or declare any court in any  such territory to be a High Court for all or any of the purposes of this Constitution.\\r\\n(2) The provisions of Chapter V of Part VI shall apply in relation to every High Court referred to in clause (1) as they apply in relation to a High Court referred to in Article 214 subject to such modifications or exceptions as Parliament may by law provide.\\r\\n (3) Subject to the provisions of this Constitution and to the provisions of any law of the appropriate Legislature made by virtue of powers conferred on that Legislature by or under this Constitution, every High Court exercising jurisdiction immediately before the commencement of the Constitution (Seventh Amendment) Act, 1956, in relation to any Union territory shall continue to exercise such jurisdiction in relation to that territory after such commencement.\\r\\n(4) Nothing in this article derogates from the power of Parliament to extend or exclude the jurisdiction of a High Court for a State to, or from, any Union territory or part thereof\\r\\n\"],\"8\":[\"242. [Coorg]\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, Section 29 and Schedule.\"]}', 1, '2021-01-31 19:12:36', '2021-01-31 20:36:50'),
(48, '4Z3Ns19OQXd2tm6rSfLVFeOw8', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part IX  ', 'THE PANCHAYATS', '', '', '{\"1\":[\"243. Definitions\",\"In this Part unless the context otherwise requires,\\u2014\\r\\n(a) \\u201cdistrict\\u201d means a district in a State;\\r\\n(b) \\u201cGram Sabha\\u201d means a body consisting of persons registered in the electoral rolls relating to a village comprised within the area of Panchayat at the village level;\\r\\n(c) \\u201cintermediate level\\u201d means a level between the village and district levels specified by the Governor of a State by public notification to be the intermediate level for the purposes of this Part;\\r\\n(d) \\u201cPanchayat\\u201d means an institution (by whatever name called) of self-government constituted under Article 243-B, for the rural areas;\\r\\n(e) \\u201cPanchayat area\\u201d means the territorial area of a Panchayat;\\r\\n(f) \\u201cpopulation\\u201d means the population as ascertained at the last preceding census of which the relevant figures have been published;\\r\\n(g) \\u201cvillage\\u201d means a village specified by the Governor by public notification to be a village for the purposes of this Part and includes a group of villages so specified.\\r\\n\"],\"2\":[\"243-A. Gram Sabha\",\"A Gram Sabha may exercise such powers and perform such functions at the village level as the Legislature of a State may, by law, provide\"],\"3\":[\"243-B. Constitution of Panchayats\",\"(1) There shall be constituted in every State, Panchayats at the village, intermediate and district levels in accordance with the provisions of this Part.\\r\\n(2) Notwithstanding anything in clause (1), Panchayats at the intermediate level may not be constituted in a State having a population not exceeding twenty lakhs.\\r\\n\"],\"4\":[\"243-C. Composition of Panchayats\",\"(1) Subject to the provisions of this Part, the Legislature of a State may, by law, make provisions with respect to the composition of Panchayats:\\r\\nProvided that the ratio between the population of the territorial area of a Panchayat at any level and the number of seats in such Panchayat to be filled by election shall, so far as practicable, be the same throughout the State.\\r\\n(2) All the seats in a Panchayat shall be filled by persons chosen by direct election from territorial constituencies in the Panchayat area and, for this purpose, each Panchayat area shall be divided into territorial constituencies in such manner that the ratio between the population of each constituency and the number of seats allotted to it shall, so far as practicable, be the same throughout the Panchayat area.\\r\\n(3) The Legislature of a State may, by law, provide for the representation\\u2014\\r\\n(a) of the Chairpersons of the Panchayats at the village level, in the Panchayats at the intermediate level or, in the case of a State not having Panchayats at the intermediate level, in the Panchayats at the district level;\\r\\n(b) of the Chairpersons of the Panchayats at the intermediate level, in the Panchayats at the district level;\\r\\n(c) of the members of the House of the People and the members of the Legislative Assembly of the State representing constituencies which comprise wholly or partly a Panchayat area at a level other than the village level, in such Panchayat;\\r\\n(d) of the members of the Council of States and the members of the Legislative Council of the State, where they are registered as electors within\\u2014\\r\\n(i) a Panchayat area at the intermediate level, in Panchayat at the intermediate level;\\r\\n(ii) a Panchayat area at the district level, in Panchayat at the district level.\\r\\n(4) The Chairperson of a Panchayat and other members of a Panchayat whether or not chosen by direct election from territorial constituencies in the Panchayat area shall have the right to vote in the meetings of the Panchayats.\\r\\n(5) The Chairperson of\\u2014\\r\\n(a) a Panchayat at the village level shall be elected in such manner as the Legislature of a State may, by law, provide; and\\r\\n(b) a Panchayat at the intermediate level or district level shall be elected by, and from amongst, the elected members thereof.\\r\\n\"],\"5\":[\"243-D. Reservation of seats\",\".\\u2014(1) Seats shall be reserved for\\u2014\\r\\n(a) the Scheduled Castes; and\\r\\n(b) the Scheduled Tribes,\\r\\nin every Panchayat and the number of seats so reserved shall bear, as nearly as may be, the same proportion to the total number of seats to be filled by direct election in that Panchayat as the population of the Scheduled Castes in that Panchayat area or of the Scheduled Tribes in that Panchayat area bears to the total population of that area and such seats may be allotted by rotation to different constituencies in a Panchayat.\\r\\n(2) Not less than one-third of the total number of seats reserved under clause (1) shall be reserved for women belonging to the Scheduled Castes or, as the case may be, the Scheduled Tribes.\\r\\n(3) Not less than one-third (including the number of seats reserved for women belonging to the Scheduled Castes and the Scheduled Tribes) of the total number of seats to be filled by direct election in every Panchayat shall be reserved for women and such seats may be allotted by rotation to different constituencies in a Panchayat.\\r\\n(4) The offices of the Chairpersons in the Panchayats at the village or any other level shall be reserved for the Scheduled Castes, the Scheduled Tribes and women in such manner as the Legislature of a State may, by law, provide:\\r\\nProvided that the number of offices of Chairpersons reserved for the Scheduled Castes and the Scheduled Tribes in the Panchayats at each level in any State shall bear, as nearly as may be, the same proportion to the total number of such offices in the Panchayats at each level as the population of the Scheduled Castes in the State or of the Scheduled Tribes in the State bears to the total population of the State:\\r\\nProvided further that not less than one-third of the total number of offices of Chairpersons in the Panchayats at each level shall be reserved for women:\\r\\nProvided also that the number of offices reserved under this clause shall be allotted by rotation to different Panchayats at each level.\\r\\n(5) The reservation of seats under clauses (1) and (2) and the reservation of office of Chairpersons (other than the reservation for women) under clause (4) shall cease to have effect on the expiration of the period specified in Article 334.\\r\\n(6) Nothing in this Part shall prevent the Legislature of a State from making any provision for reservation of seats in any Panchayat or offices of Chairpersons in the Panchayats at any level in favour of backward class of citizens.\\r\\n\"],\"6\":[\"243-E. Duration of Panchayats etc\",\"(1) Every Panchayat, unless sooner dissolved under any law for the time being in force, shall continue for five years from the date appointed for its first meeting and no longer.\\r\\n(2) No amendment of any law for the time being in force shall have the effect of causing dissolution of a Panchayat at any level, which is functioning immediately before such amendment, till the expiration of its duration specified in clause (1).\\r\\n(3) An election to constitute a Panchayat shall be completed\\u2014\\r\\n(a) before the expiry of its duration specified in clause (1);\\r\\n(b) before the expiration of a period of six months from the date of its dissolution:\\r\\nProvided that where the remainder of the period for which the dissolved Panchayat would have continued is less than six months, it shall not be necessary to hold any election under this clause for constituting the Panchayat for such period.\\r\\n(4) A Panchayat constituted upon the dissolution of a Panchayat before the expiration of its duration shall continue only for the remainder of the period for which the dissolved Panchayat would have continued under clause (1) had it not been so dissolved.\\r\\n\"],\"7\":[\"243-F. Disqualifications for membership\",\"(1) A person shall be disqualified for being chosen as, and for being, a member of a Panchayat\\u2014\\r\\n(a) if he is so disqualified by or under any law for the time being in force for the purposes of elections to the Legislature of the State concerned:\\r\\nProvided that no persons shall be disqualified on the ground that he is less than twenty-five years of age, if he has attained the age of twenty-one years;\\r\\n(b) if he is so disqualified by or under any law made by the Legislature of the State.\\r\\n(2) If any question arises as to whether a member of a Panchayat has become subject to any of the disqualifications mentioned in clause (1), the question shall be referred for the decision of such authority and in such manner as the Legislature of a State may, by law, provide\\r\\n\"],\"8\":[\"243-G. Powers, authority and responsibilities of Panchayats\",\"Subject to the provisions of the Constitution, the Legislature of a State may, by law, endow the Panchayats with such powers and authority as may be necessary to enable them to function as institutions of self-government and such law may contain provisions for the devolution of powers and responsibilities upon Panchayats at the appropriate level, subject to such conditions as may be specified therein, with respect to\\u2014\\r\\n(a) the preparation of plans for economic development and social justice;\\r\\n(b) the implementation of schemes for economic development and social justice as may be entrusted to them including those in relation to the matters listed in the Eleventh Schedule.\\r\\n\"],\"9\":[\"243-H. Powers to impose taxes by, and Funds of, the Panchayats\",\"The Legislature of a State may, by law,\\u2014\\r\\n(a) authorise a Panchayat to levy, collect and appropriate such taxes, duties, tolls and fees in accordance with such procedure and subject to such limits;\\r\\n(b) assign to a Panchayat such taxes, duties, tolls and fees levied and collected by the State Government for such purposes and subject to such conditions and limits;\\r\\n(c) provide for making such grants-in-aid to the Panchayats from the Consolidated Fund of the State; and\\r\\n(d) provide for constitution of such Funds for crediting all moneys received, respectively, by or on behalf of the Panchayats and also for the withdrawal of such moneys therefrom,\\r\\nas may be specified in the law.\\r\\n\"],\"10\":[\"243-I. Constitution of Finance Commission to review financial position\",\"(1) The Governor of a State shall, as soon as may be within one year from the commencement of the Constitution (Seventy-third Amendment) Act, 1992 and thereafter at the expiration of every fifth year, constitute a Finance Commission to review the financial position of the Panchayats and to make recommendations to the Governor as to\\u2014\\r\\n(a) the principles which should govern\\u2014\\r\\n(i) the distribution between the State and the Panchayats of the net proceeds of the taxes, duties, tolls and fees leviable by the State, which may be divided between them under this Part and the allocation between the Panchayats at all levels of their respective shares of such proceeds;\\r\\n(ii) the determination of the taxes, duties, tolls and fees which may be assigned to, or appropriated by, the Panchayats;\\r\\n(iii) the grants-in-aid to the Panchayats from the Consolidated Fund of the State;\\r\\n(b) the measures needed to improve the financial position of the Panchayats;\\r\\n(c) any other matter referred to the Finance Commission by the Governor in the interests of sound finance of the Panchayats.\\r\\n(2) The Legislature of a State may, by law, provide for the composition of the Commission, the qualifications which shall be requisite for appointment as members thereof and the manner in which they shall be selected.\\r\\n(3) The Commission shall determine their procedure and shall have such powers in the performance of their functions as the Legislature of the State may, by law, confer on them.\\r\\n(4) The Governor shall cause every recommendation made by the Commission under this article together with an explanatory memorandum as to the action taken thereon to be laid before the Legislature of the State.\\r\\n\"],\"11\":[\"243-J. Audit of accounts of Panchayats\",\"The Legislature of a State may, by law, make provisions with respect to the maintenance of accounts by the Panchayats and the auditing of such accounts.\"],\"12\":[\"243-K. Elections of the Panchayats\",\"1) The superintendence, direction and control of the preparation of electoral rolls for, and the conduct of, all elections to the Panchayats shall be vested in a State Election Commission consisting of a State Election Commissioner to be appointed by the Governor.\\r\\n(2) Subject to the provisions of any law made by the Legislature of a State, the conditions of service and tenure of office of the State Election Commissioner shall be such as the Governor may by rule determine:\\r\\nProvided that the State Election Commissioner shall not be removed from his office except in like manner and on the like grounds as a Judge of a High Court and the conditions of service of the State Election Commissioner shall not be varied to his disadvantage after his appointment.\\r\\n(3) The Governor of a State shall, when so requested by the State Election Commission, make available to the State Election Commission such staff as may be necessary for the discharge of the functions conferred on the State Election Commission by clause (1).\\r\\n(4) Subject to the provisions of this Constitution, the Legislature of a State may, by law, make provision with respect to all matters relating to, or in connection with, elections to the Panchayats.\\r\\n\"],\"13\":[\"243-L. Application to Union territories\",\"The provisions of this Part shall apply to the Union territories and shall, in their application to a Union territory, have effect as if the references to the Governor of a State were references to the Administrator of the Union territory appointed under Article 239 and references to the Legislature or the Legislative Assembly of a State were references, in relation to a Union territory having a Legislative Assembly, to that Legislative Assembly:\\r\\nProvided that the President may, by public notification, direct that the provisions of this Part shall apply to any Union territory or part thereof subject to such exceptions and modifications as he may specify in the notification.\\r\\n\"],\"14\":[\"243-M. Part not to apply to certain areas\",\".\\u2014(1) Nothing in this Part shall apply to the Scheduled Areas referred to in clause (1), and the tribal areas referred to in clause (2), of Article 244.\\r\\n(2) Nothing in this Part shall apply to\\u2014\\r\\n(a) the States of Nagaland, Meghalaya and Mizoram;\\r\\n(b) the hill areas in the State of Manipur for which District Councils exist under any law for the time being in force.\\r\\n(3) Nothing in this Part\\u2014\\r\\n(a) relating to Panchayats at the district level shall apply to the hill areas of the District of Darjeeling in the State of West Bengal for which Darjeeling Gorkha Hill Council exists under any law for the time being in force;\\r\\n(b) shall be construed to affect the functions and powers of the Darjeeling Gorkha Hill Council constituted under such law.\\r\\n(3-A) Nothing in Article 243-D, relating to reservation of seats for the Scheduled Castes, shall apply to the State of Arunachal Pradesh.\\r\\n(4) Notwithstanding anything in this Constitution,\\u2014\\r\\n(a) the Legislature of a State referred to in sub-clause (a) of clause (2) may, by law, extend this Part to that State, except the areas, if any, referred to in clause (1), if the Legislative Assembly of that State passes a resolution to that effect by a majority of the total membership of that House and by a majority of not less than two-thirds of the members of that House present and voting;\\r\\n(b) Parliament may, by law, extend the provisions of this Part to the Scheduled Areas and the tribal areas referred to in clause (1) subject to such exceptions and modifications as may be specified in such law, and no such law shall be deemed to be an amendment of this Constitution for the purposes of Article 368.\\r\\n\\r\\n\"],\"15\":[\"243-N. Continuance of existing laws and Panchayats\",\"Notwithstanding anything in this Part, any provision of any law relating to Panchayats in force in a State immediately before the commencement of the Constitution (Seventy-third Amendment) Act, 1992, which is inconsistent with the provisions of this Part, shall continue to be in force until amended or repealed by a competent Legislature or other competent authority or until the expiration of one year from such commencement, whichever is earlier:\\r\\nProvided that all the Panchayats existing immediately before such commencement shall continue till the expiration of their duration, unless sooner dissolved by a resolution passed to that effect by the Legislative Assembly of that State or, in the case of a State having a Legislative Council, by each House of the Legislature of that State.\\r\\n\"],\"16\":[\"243-O. Bar to interference by courts in electoral matters\",\"Notwithstanding anything in this Constitution,\\u2014\\r\\n(a) the validity of any law relating to the delimitation of constituencies or the allotment of seats to such constituencies, made or purporting to be made under Article 243-K, shall not be called in question in any court;\\r\\n(b) no election to any Panchayat shall be called in question except by an election petition presented to such authority and in such manner as is provided for by or under any law made by the Legislature of a State.\\r\\n\"]}', 1, '2021-01-31 20:38:02', '2021-01-31 20:44:32');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(49, '7tAkgZxL8vLLGB7m5IIY2XSb9', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part IX-A   ', 'THE MUNICIPALITIES', '', '', '{\"1\":[\"243-P. Definitions\",\"In this Part, unless the context otherwise requires,\\u2014\\r\\n(a) \\u201cCommittee\\u201d means a Committee constituted under Article 243-S;\\r\\n(b) \\u201cdistrict\\u201d means a district in a State;\\r\\n(c) \\u201cMetropolitan area\\u201d means an area having a population of ten lakhs or more, comprised in one or more districts and consisting of two or more Municipalities or Panchayats or other contiguous areas, specified by the Governor by public notification to be a Metropolitan area for the purposes of this Part;\\r\\n(d) \\u201cMunicipal area\\u201d means the territorial area of a Municipality as is notified by the Governor;\\r\\n(e) \\u201cMunicipality\\u201d means an institution of self-government constituted under Article 243-Q;\\r\\n(f) \\u201cPanchayat\\u201d means a Panchayat constituted under Article 243-B;\\r\\n(g) \\u201cpopulation\\u201d means the population as ascertained at the last preceding census of which the relevant figures have been published.\\r\\n\"],\"2\":[\"243-Q. Constitution of Municipalities\",\"(1) There shall be constituted in every State,\\u2014\\r\\n(a) a Nagar Panchayat (by whatever name called) for a transitional area, that is to say, an area in transition from a rural area to an urban area;\\r\\n(b) a Municipal Council for a smaller urban area; and\\r\\n(c) a Municipal Corporation for a larger urban area,\\r\\nin accordance with the provisions of this Part:\\r\\nProvided that a Municipality under this clause may not be constituted in such urban area or part thereof as the Governor may, having regard to the size of the area and the municipal services being provided or proposed to be provided by an industrial establishment in that area and such other factors as he may deem fit, by public notification, specify to be an industrial township.\\r\\n(2) In this article, \\u201ca transitional area\\u201d, \\u201ca smaller urban area\\u201d or \\u201ca larger urban area\\u201d means such area as the Governor may, having regard to the population of the area, the density of the population therein, the revenue generated for local administration, the percentage of employment in non-agricultural activities, the economic importance or such other factors as he may deem fit, specify by public notification for the purposes of this Part.\\r\\n\"],\"3\":[\"243-R. Composition of Municipalities\",\"(1) Save as provided in clause (2), all the seats in a Municipality shall be filled by persons chosen by direct election from the territorial constituencies in the Municipal area and for this purpose each Municipal area shall be divided into territorial constituencies to be known as wards.\\r\\n(2) The Legislature of a State may, by law, provide\\u2014\\r\\n(a) for the representation in a Municipality of\\u2014\\r\\n(i) persons having special knowledge or experience in Municipal administration;\\r\\n(ii) the members of the House of the People and the members of the Legislative Assembly of the State representing constituencies which comprise wholly or partly the Municipal area;\\r\\n(iii) the members of the Council of States and the members of the Legislative Council of the State registered as electors within the Municipal area;\\r\\n(iv) the Chairpersons of the Committees constituted under clause (5) of Article 243-S:\\r\\nProvided that the persons referred to in paragraph (i) shall not have the right to vote in the meetings of the Municipality;\\r\\n(b) the manner of election of the Chairperson of a Municipality.\\r\\n\"],\"4\":[\"243-S. Constitution and composition of Wards Committees, etc\",\"(1) There shall be constituted Wards Committees, consisting of one or more wards, within the territorial area of a Municipality having a population of three lakhs or more.\\r\\n(2) The Legislature of a State may, by law, make provision with respect to\\u2014\\r\\n(a) the composition and the territorial area of a Wards Committee;\\r\\n(b) the manner in which the seats in a Wards Committee shall be filled.\\r\\n(3) A member of a Municipality representing a ward within the territorial area of the Wards Committee shall be a member of that Committee.\\r\\n(4) Where a Wards Committee consists of\\u2014\\r\\n(a) one ward, the member representing that ward in the Municipality; or\\r\\n(b) two or more wards, one of the members representing such wards in the Municipality elected by the members of the Wards Committee,\\r\\nshall be the Chairperson of that Committee.\\r\\n(5) Nothing in this article shall be deemed to prevent the Legislature of a State from making any provision for the constitution of Committees in addition to the Wards Committees\\r\\n\"],\"5\":[\"243-T. Reservation of seats\",\"(1) Seats shall be reserved for the Scheduled Castes and the Scheduled Tribes in every Municipality and the number of seats so reserved shall bear, as nearly as may be, the same proportion to the total number of seats to be filled by direct election in that Municipality as the population of the Scheduled Castes in the Municipal area or of the Scheduled Tribes in the Municipal area bears to the total population of that area and such seats may be allotted by rotation to different constituencies in a Municipality.\\r\\n(2) Not less than one-third of the total number of seats reserved under clause (1) shall be reserved for women belonging to the Scheduled Castes or, as the case may be, the Scheduled Tribes.\\r\\n(3) Not less than one-third (including the number of seats reserved for women belonging to the Scheduled Castes and the Scheduled Tribes) of the total number of seats to be filled by direct election in every Municipality shall be reserved for women and such seats may be allotted by rotation to different constituencies in a Municipality.\\r\\n(4) The offices of Chairpersons in the Municipalities shall be reserved for the Scheduled Castes, the Scheduled Tribes and women in such manner as the Legislature of a State may, by law, provide.\\r\\n(5) The reservation of seats under clauses (1) and (2) and the reservation of offices of Chairpersons (other than the reservation for women) under clause (4) shall cease to have effect on the expiration of the period specified in Article 334.\\r\\n(6) Nothing in this Part shall prevent the Legislature of a State from making any provision for reservation of seats in any Municipality or offices of Chairpersons in the Municipalities in favour of backward class of citizens.\\r\\n\"],\"6\":[\"243-U. Duration of Municipalities, etc\",\"(1) Every Municipality, unless sooner dissolved under any law for the time being in force, shall continue for five years from the date appointed for its first meeting and no longer:\\r\\nProvided that a Municipality shall be given a reasonable opportunity of being heard before its dissolution.\\r\\n(2) No amendment of any law for the time being in force shall have the effect of causing dissolution of a Municipality at any level, which is functioning immediately before such amendment, till the expiration of its duration specified in clause (1).\\r\\n(3) An election to constitute a Municipality shall be completed,\\u2014\\r\\n(a) before the expiry of its duration specified in clause (1);\\r\\n(b) before the expiration of a period of six months from the date of its dissolution:\\r\\nProvided that where the remainder of the period for which the dissolved Municipality would have continued is less than six months, it shall not be necessary to hold any election under this clause for constituting the Municipality for such period.\\r\\n(4) A Municipality constituted upon the dissolution of a Municipality before the expiration of its duration shall continue only for the remainder of the period for which the dissolved Municipality would have continued under clause (1) had it not been so dissolved.\\r\\n\"],\"7\":[\"243-V. Disqualifications for membership\",\"(1) A person shall be disqualified for being chosen as, and for being, a member of a Municipality\\u2014\\r\\n(a) if he is so disqualified by or under any law for the time being in force for the purposes of elections to the Legislature of the State concerned:\\r\\nProvided that no person shall be disqualified on the ground that he is less than twenty-five years of age, if he has attained the age of twenty-one years;\\r\\n(b) if he is so disqualified by or under any law made by the Legislature of the State.\\r\\n(2) If any question arises as to whether a member of a Municipality has become subject to any of the disqualifications mentioned in clause (1), the question shall be referred for the decision of such authority and in such manner as the Legislature of a State may, by law, provide\\r\\n\"],\"8\":[\"243-W. Powers, authority and responsibilities of Municipalities, etc\",\"Subject to the provisions of this Constitution, the Legislature of a State may, by law, endow\\u2014\\r\\n(a) the Municipalities with such powers and authority as may be necessary to enable them to function as institutions of self-government and such law may contain provisions for the devolution of powers and responsibilities upon Municipalities, subject to such conditions as may be specified therein, with respect to\\u2014\\r\\n(i) the preparation of plans for economic development and social justice;\\r\\n(ii) the performance of functions and the implementation of schemes as may be entrusted to them including those in relation to the matters listed in the Twelfth Schedule;\\r\\n(b) the Committees with such powers and authority as may be necessary to enable them to carry out the responsibilities conferred upon them including those in relation to the matters listed in the Twelfth Schedule.\\r\\n\"],\"9\":[\"243-X. Power to impose taxes by, and Funds of, the Municipalities\",\"The Legislature of a State may, by law,\\u2014\\r\\n(a) authorise a Municipality to levy, collect and appropriate such taxes, duties, tolls and fees in accordance with such procedure and subject to such limits;\\r\\n(b) assign to a Municipality such taxes, duties, tolls and fees levied and collected by the State Government for such purposes and subject to such conditions and limits;\\r\\n(c) provide for making such grants-in-aid to the Municipalities from the Consolidated Fund of the State; and\\r\\n(d) provide for constitution of such Funds for crediting all moneys received, respectively, by or on behalf of the Municipalities and also for the withdrawal of such moneys therefrom,\\r\\nas may be specified in the law.\\r\\n\"],\"10\":[\"243-Y. Finance Commission\",\"(1) The Finance Commission constituted under Article 243-I shall also review the financial position of the Municipalities and make recommendations to the Governor as to\\u2014\\r\\n(a) the principles which should govern\\u2014\\r\\n(i) the distribution between the State and the Municipalities of the net proceeds of the taxes, duties, tolls and fees leviable by the State, which may be divided between them under this Part and the allocation between the Municipalities at all levels of their respective shares of such proceeds;\\r\\n(ii) the determination of the taxes, duties, tolls and fees which may be assigned to, or appropriated by, the Municipalities;\\r\\n(iii) the grants-in-aid to the Municipalities from the Consolidated Fund of the State;\\r\\n(b) the measures needed to improve the financial position of the Municipalities;\\r\\n(c) any other matter referred to the Finance Commission by the Governor in the interests of sound finance of the Municipalities.\\r\\n(2) The Governor shall cause every recommendation made by the Commission under this article together with an explanatory memorandum as to the action taken thereon to be laid before the Legislature of the State.\\r\\n\"],\"11\":[\"243-Z. Audit of accounts of Municipalities\",\"The Legislature of a State may, by law, make provisions with respect to the maintenance of accounts by the Municipalities and the auditing of such accounts.\"],\"12\":[\"243-ZA. Elections to the Municipalities\",\"(1) The superintendence, direction and control of the preparation of electoral rolls for, and the conduct of, all elections to the Municipalities shall be vested in the State Election Commission referred to in Article 243-K.\\r\\n(2) Subject to the provisions of this Constitution, the Legislature of a State may, by law, make provision with respect to all matters relating to, or in connection with, elections to the Municipalities.\\r\\n\"],\"13\":[\"243-ZB. Application to Union territories\",\"The provisions of this Part shall apply to the Union territories and shall, in their application to a Union territory, have effect as if the references to the Governor of a State were references to the Administrator of the Union territory appointed under Article 239 and references to the Legislature or the Legislative Assembly of a State were references in relation to a Union territory having a Legislative Assembly, to that Legislative Assembly:\\r\\nProvided that the President may, by public notification, direct that the provisions of this Part shall apply to any Union territory or part thereof subject to such exceptions and modifications as he may specify in the notification.\\r\\n\"],\"14\":[\"243-ZC. Part not to apply to certain areas\",\"(1) Nothing in this Part shall apply to the Scheduled Areas referred to in clause (1), and the tribal areas referred to in clause (2), of Article 244.\\r\\n(2) Nothing in this Part shall be construed to affect the functions and powers of the Darjeeling Gorkha Hill Council constituted under any law for the time being in force for the hill areas of the district of Darjeeling in the State of West Bengal.\\r\\n(3) Notwithstanding anything in this Constitution, Parliament may, by law, extend the provisions of this Part to the Scheduled Areas and the tribal areas referred to in clause (1) subject to such exceptions and modifications as may be specified in such law, and no such law shall be deemed to be an amendment of this Constitution for the purposes of Article 368.\\r\\n\"],\"15\":[\"243-ZD. Committee for district planning\",\"(1) There shall be constituted in every State at the district level a District Planning Committee to consolidate the plans prepared by the Panchayats and the Municipalities in the district and to prepare a draft development plan for the district as a whole.\\r\\n(2) The Legislature of a State may, by law, make provision with respect to\\u2014\\r\\n(a) the composition of the District Planning Committees;\\r\\n(b) the manner in which the seats in such Committees shall be filled:\\r\\nProvided that not less than four-fifths of the total number of members of such Committee shall be elected by, and from amongst, the elected members of the Panchayat at the district level and of the Municipalities in the district in proportion to the ratio between the population of the rural areas and of the urban areas in the district;\\r\\n(c) the functions relating to district planning which may be assigned to such Committees;\\r\\n(d) the manner in which the Chairpersons of such Committees shall be chosen.\\r\\n(3) Every District Planning Committee shall, in preparing the draft development plan,\\u2014\\r\\n(a) have regard to\\u2014\\r\\n(i) matters of common interest between the Panchayats and the Municipalities including spatial planning, sharing of water and other physical and natural resources, the integrated development of infrastructure and environmental conservation;\\r\\n(ii) the extent and type of available resources whether financial or otherwise;\\r\\n(b) consult such institutions and organisations as the Governor may, by order, specify.\\r\\n(4) The Chairperson of every District Planning Committee shall forward the development plan, as recommended by such Committee, to the Government of the State.\\r\\n\"],\"16\":[\"243-ZE. Committee for Metropolitan planning\",\"(1) There shall be constituted in every Metropolitan area a Metropolitan Planning Committee to prepare a draft development plan for the Metropolitan area as a whole.\\r\\n(2) The Legislature of a State may, by law, make provision with respect to\\u2014\\r\\n(a) the composition of the Metropolitan Planning Committees;\\r\\n(b) the manner in which the seats in such Committees shall be filled:\\r\\nProvided that not less than two-thirds of the members of such Committee shall be elected by, and from amongst, the elected members of the Municipalities and Chairpersons of the Panchayats in the Metropolitan area in proportion to the ratio between the population of the Municipalities and of the Panchayats in that area;\\r\\n(c) the representation in such Committees of the Government of India and the Government of the State and of such organisations and institutions as may be deemed necessary for carrying out the functions assigned to such Committees;\\r\\n(d) the functions relating to planning and coordination for the Metropolitan area which may be assigned to such Committees;\\r\\n(e) the manner in which the Chairpersons of such Committees shall be chosen.\\r\\n(3) Every Metropolitan Planning Committee shall, in preparing the draft development plan,\\u2014\\r\\n(a) have regard to\\u2014\\r\\n(i) the plans prepared by the Municipalities and the Panchayats in the Metropolitan area;\\r\\n(ii) matters of common interest between the Municipalities and the Panchayats, including co-ordinated spatial planning of the area, sharing of water and other physical and natural resources, the integrated development of infrastructure and environmental conservation;\\r\\n(iii) the overall objectives and priorities set by the Government of India and the Government of the State;\\r\\n(iv) the extent and nature of investments likely to be made in the Metropolitan area by agencies of the Government of India and of the Government of the State and other available resources whether financial or otherwise;\\r\\n(b) consult such institutions and organisations as the Governor may, by order, specify.\\r\\n(4) The Chairperson of every Metropolitan Planning Committee shall forward the development plan, as recommended by such Committee, to the Government of the State.\\r\\n\"],\"17\":[\"243-ZF. Continuance of existing laws and Municipalities\",\"Notwithstanding anything in this Part, any provision of any law relating to Municipalities in force in a State immediately before the commencement of the Constitution (Seventy-fourth Amendment) Act, 1992, which is inconsistent with the provisions of this Part, shall continue to be in force until amended or repealed by a competent Legislature or other competent authority or until the expiration of one year from such commencement, whichever is earlier:\\r\\nProvided that all the Municipalities existing immediately before such commencement shall continue till the expiration of their duration, unless sooner dissolved by a resolution passed to that effect by the Legislative Assembly of that State or, in the case of a State having a Legislative Council, by each House of the Legislature of that State.\\r\\n243-ZG. Bar to interference by courts in electoral matters.\\u2014Notwithstanding anything in this Constitution,\\u2014\\r\\n(a) the validity of any law relating to the delimitation of constituencies or the allotment of seats to such constituencies, made or purporting to be made under Article 243-ZA shall not be called in question in any court;\\r\\n(b) no election to any Municipality shall be called in question except by an election petition presented to such authority and in such manner as is provided for by or under any law made by the Legislature of a State.\\r\\n\"]}', 1, '2021-01-31 20:45:23', '2021-01-31 20:52:19'),
(50, '3VEdhJHdKae5aUU5GqtbpdQJn', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part IX-B ', 'THE CO-OPERATIVE SOCIETIES', '', '', '{\"1\":[\"243-ZH. Definitions\",\"In this Part, unless the context otherwise requires\\u2014\\r\\n(a) \\u201cauthorised person\\u201d means a person referred to as such in Article 243-ZQ;\\r\\n(b) \\u201cboard\\u201d means the board of directors or the governing body of a co-operative society, by whatever name called, to which the direction and control of the management of the affairs of a society is entrusted to;\\r\\n(c) \\u201cco-operative society\\u201d means a society registered or deemed to be registered under any law relating to co-operative societies for the time being in force in any State;\\r\\n(d) \\u201cmulti-State co-operative society\\u201d means a society with objects not confined to one State and registered or deemed to be registered under any law for the time being in force relating to such co-operatives;\\r\\n(e) \\u201cofficer bearer\\u201d means a President, Vice-President, Chairperson, Vice-Chairperson, Secretary or Treasurer of a co-operative society and includes any other person to be elected by the board of any co-operative society;\\r\\n(f) \\u201cRegistrar\\u201d means the Central Registrar appointed by the Central Government in relation to the multi-State co-operative societies and the Registrar for co-operative societies appointed by the State Government under the law made by the Legislature of a State in relation to co-operative societies;\\r\\n(g) \\u201cState Act\\u201d means any law made by the Legislature of a State;\\r\\n(h) \\u201cState level co-operative society\\u201d means a co-operative society having its area of operation extending to the whole of a State and defined as such in any law made by the Legislature of a State.\\r\\n\"],\"2\":[\"243-ZI. Incorporation of co-operative societies\",\"Subject to the provisions of this Part, the Legislature of a State may, by law, make provisions with respect to the incorporation, regulation and winding up of co-operative societies based on the principles of voluntary formation, democratic member-control, member-economic participation and autonomous functioning\"],\"3\":[\"243-ZJ. Number and term of members of board and its office bearers\",\"(1) The board shall consist of such number of directors as may be provided by the Legislature of a State, by law:\\r\\nProvided that the maximum number of directors of a co-operative society shall not exceed twenty-one:\\r\\nProvided further that the Legislature of a State shall, by law, provide for the reservation of one seat for the Scheduled Castes or the Scheduled Tribes and two seats for women on board of every co-operative society consisting of individuals as members and having members from such class or category of persons.\\r\\n(2) The term of office of elected members of the board and its office bearers shall be five years from the date of election and the term of office bearers shall be coterminous with the term of the board:\\r\\nProvided that the board may fill a casual vacancy on the board by nomination out of the same class of members in respect of which the casual vacancy has arisen, if the term of office of the board is less than half of its original term.\\r\\n(3) The Legislature of a State shall, by law, make provisions for co-option of persons to be members of the board having experience in the field of banking, management, finance or specialisation in any other field relating to the objects and activities undertaken by the co-operative society, as members of the board of such society:\\r\\nProvided that the number of such co-opted members shall not exceed two in addition to twenty-one directors specified in the first proviso to clause (1):\\r\\nProvided further that such co-opted members shall not have the right to vote in any election of the co-operative society in their capacity as such member or to be eligible to be elected as office bearers of the board:\\r\\nProvided also that the functional directors of a co-operative society shall also be the members of the board and such members shall be excluded for the purpose of counting the total number of directors specified in the first proviso to clause (1).\\r\\n\"],\"4\":[\"243-ZK. Election of members of board\",\"(1) Notwithstanding anything contained in any law made by the Legislature of a State, the election of a board shall be conducted before the expiry of the term of the board so as to ensure that the newly elected members of the board assume office immediately on the expiry of the term of the office of members of the outgoing board.\\r\\n(2) The superintendence, direction and control of the preparation of electoral rolls for, and the conduct of, all elections to a co-operative society shall vest in such an authority or body, as may be provided by the Legislature of a State, by law:\\r\\nProvided that the Legislature of a State may, by law, provide for the procedure and guidelines for the conduct of such elections.\\r\\n\"],\"5\":[\"243-ZL. Supersession and suspension of board and interim management\",\"(1) Notwithstanding anything containted in any law for the time being in force, no board shall be superseded or kept under suspension for a period exceeding six months:\\r\\nProvided that the board may be superseded or kept under suspension in case\\u2014\\r\\n(i) of its persistent default; or\\r\\n(ii) of negligence in the performance of its duties; or\\r\\n(iii) the board has committed any act prejudicial to the interests of the co-operative society or its members; or\\r\\n(iv) there is a stalement in the constitution or functions of the board; or\\r\\n(v) the authority or body as provided by the Legislature of a State, by law, under clause (2) of Article 243-ZK, has failed to conduct elections in accordance with the provisions of the State Act:\\r\\nProvided further that the board of any such co-operative society shall not be superseded or kept under suspension where there is no Government shareholding or loan or financial assistance or any guarantee by the Government:\\r\\nProvided also that in case of a co-operative society carrying on the business of banking, the provisions of the Banking Regulation Act, 1949 (10 of 1949) shall also apply:\\r\\nProvided also that in case of a co-operative society, other than a multi-State co-operative society, carrying on the business of banking, the provisions of this clause shall have the effect as if for the words \\u201csix months\\u201d, the words \\u201cone year\\u201d had been substituted.\\r\\n(2) In case of supersession of a board, the administrator appointed to manage the affairs of such co-operative society shall arrange for conduct of elections within the period specified in clause (1) and handover the management to be elected board.\\r\\n(3) The Legislature of a State may, by law, make provisions for the conditions of service of the administrator.\\r\\n\"],\"6\":[\"243-ZM. Audit of accounts of co-operative societies\",\"(1) The Legislature of a State may, by law, make provisions with respect to the maintenance of accounts by the co-operative societies and the auditing of such accounts at least once in each financial year.\\r\\n(2) The Legislature of a State shall, by law, lay down the minimum qualifications and experience of auditors and auditing firms that shall be eligible for auditing accounts of the co-operative societies.\\r\\n(3) Every co-operative society shall cause to be audited by an auditor or auditing firms referred to in clause (2) appointed by the general body of the co-operative society:\\r\\nProvided that such auditors or auditing firms shall be appointed from a panel approved by the State Government or an authority authorised by the State Government in this behalf.\\r\\n(4) The accounts of every co-operative society shall be audited within six months of the close of the financial year to which such accounts relate.\\r\\n(5) The audit report of the accounts of an apex co-operative society, as may be defined by the State Act, shall be laid before the State Legislature in the manner, as may be provided by the State Legislature, by law.\\r\\n\"],\"7\":[\"243-ZN. Convening of general body meetings\",\"The Legislature of a State may, by law, make provisions that the annual general body meeting of every co-operative society shall be convened within a period of six months of close of the financial year to transact the business as may be provided in such law.\"],\"8\":[\"243-ZO. Right of a member to get information\",\"(1) The Legislature of a State may, by law, provide for access to every member of a co-operative society to the books, information and accounts of the co-operative society kept in regular transaction of its business with such member.\\r\\n(2) The Legislature of a State may, by law, make provisions to ensure the participation of members in the management of the co-operative society providing minimum requirement of attending meetings by the members and utilising the minimum level of services as may be provided in such law.\\r\\n(3) The Legislature of a State may, by law, provide for co-operative education and training for its members.\\r\\n\"],\"9\":[\"243-ZP. Returns\",\"Every co-operative society shall file returns, within six months of the close of every financial year, to the authority designated by the State Government including the following matters, namely\\u2014\\r\\n(a) annual report of its activities;\\r\\n(b) its audited statement of accounts;\\r\\n(c) plan for surplus disposal as approved by the general body of the co-operative society;\\r\\n(d) list of amendments to the bye-laws of the co-operative society, if any;\\r\\n(e) declaration regarding date of holding of its general body meeting and conduct of elections when due; and\\r\\n(f) any other information required by the Registrar in pursuance of any of the provisions of the State Act.\\r\\n\"],\"10\":[\"243-ZQ. Offences and penalties\",\"(1) The Legislature of a State may, by law, make provisions for the offences relating to the co-operative societies and penalties for such offences.\\r\\n(2) A law made by the Legislature of a State under clause (1) shall include the commission of the following act or omission as offences, namely\\u2014\\r\\n(a) a co-operative society or an officer or member thereof wilfully makes a false return or furnishes false information, or any person wilfully not furnishes any information required from him by a person authorised in this behalf under the provisions of the State Act;\\r\\n(b) any person wilfully or without any reasonable excuse disobeys any summons, requisition or lawful written order issued under the provisions of the State Act;\\r\\n(c) any employer who, without sufficient cause, fails to pay to a co-operative society amount deducted by him from its employee within a period of fourteen days from the date on which such deduction is made;\\r\\n(d) any officer or custodian who wilfully fails to handover custody of books, accounts, documents, records, cash, security and other property belonging to a co-operative society of which he is an officer or custodian, to an authorised person; and\\r\\n(e) whoever, before, during or after the election of members of the board or office bearers, adopts any corrupt practice.\\r\\n\"],\"11\":[\"243-ZR. Application to multi-State co-operative societies\",\"The provisions of this Part shall apply to the multi-State co-operative societies subject to the modification that any reference to \\u201cLegislature of a State\\u201d, \\u201cState Act\\u201d or \\u201cState Government\\u201d shall be construed as a reference to \\u201cParliament\\u201d, \\u201cCentral Act\\u201d or \\u201cthe Central Government\\u201d respectively.\"],\"12\":[\"243-ZS. Application to Union territories\",\"The provisions of this Part shall apply to the Union territories and shall, in their application to a Union territory, having no Legislative Assembly as if the references to the Legislature of a State were a reference to the administrator thereof appointed under Article 239 and, in relation to a Union territory having a Legislative Assembly, to that Legislative Assembly:\\r\\nProvided that the President may, by notification in the Official Gazette, direct that the provisions of this Part shall not apply to any Union territory or Part thereof as he may specify in the notification.\\r\\n\"],\"13\":[\"243-ZT. Continuance of existing laws\",\"Notwithstanding anything in this Part, any provision of any law relating to co-operative societies in force in a State immediately before the commencement of the Constitution (Ninety-seventh Amendment) Act, 2011, which is inconsistent with the provisions of this Part, shall continue to be in force until amended or repealed by a competent Legislature or other competent authority or until the expiration of one year from such commencement, whichever is less\"]}', 1, '2021-01-31 20:53:23', '2021-01-31 20:59:09'),
(51, 'S3KjDFx58zUdlQraNMIKjZrGF', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part X ', 'THE SCHEDULED AND TRIBAL AREAS', '', '', '{\"1\":[\"244. Administration of Scheduled Areas and Tribal Areas\",\"(1) The provisions of the Fifth Schedule shall apply to the administration and control of the Scheduled Areas and Scheduled Tribes in any State  other than the States of Assam  Meghalaya, Tripura and Mizoram\\r\\n(2) The provisions of the Sixth Schedule shall apply to the administration of the tribal areas in the States of Assam  Meghalaya, Tripura and Mizoram\\r\\n\"],\"2\":[\"244-A. Formation of an autonomous State comprising certain tribal areas in Assam and creation of local Legislature or Council of Ministers or both therefor\",\"(1) Notwithstanding anything in this Constitution, Parliament may, by law, form within the State of Assam an autonomous State comprising (whether wholly or in part) all or any of the tribal areas specified in Part I of the table appended to paragraph 20 of the Sixth Schedule and create therefor\\u2014\\r\\n(a) a body, whether elected or partly nominated and partly elected, to function as a Legislature for the autonomous State, or\\r\\n(b) a Council of Ministers,\\r\\nor both with such constitution, powers and functions, in each case, as may be specified in the law.\\r\\n(2) Any such law as is referred to in clause (1) may, in particular,\\u2014\\r\\n(a) specify the matters enumerated in the State List or the Concurrent List with respect to which the Legislature of the autonomous State shall have power to make laws for the whole or any part thereof, whether to the exclusion of the Legislature of the State of Assam or otherwise;\\r\\n(b) define the matters with respect to which the executive power of the autonomous State shall extend;\\r\\n(c) provide that any tax levied by the State of Assam shall be assigned to the autonomous State in so far as the proceeds thereof are attributable to the autonomous State;\\r\\n(d) provide that any reference to a State in any article of this Constitution shall be construed as including a reference to the autonomous State; and\\r\\n(e) make such supplemental, incidental and consequential provisions as may be deemed necessary.\\r\\n(3) An amendment of any such law as aforesaid in so far as such amendment relates to any of the matters specified in sub-clause (a) or sub-clause (b) of clause (2) shall have no effect unless the amendment is passed in each House of Parliament by not less than two-thirds of the members present and voting.\\r\\n(4) Any such law as is referred to in this article shall not be deemed to be an amendment of this Constitution for the purposes of Article 368 notwithstanding that it contains any provision which amends or has the effect of amending this Constitution.\\r\\n\"]}', 1, '2021-01-31 21:00:56', '2021-01-31 21:02:52'),
(52, '3fvrlCOCzMrgC7QTpuCvzIy1p', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XI Chapter 1', 'LEGISLATIVE RELATIONS', '', '', '{\"1\":[\"245. Extent of laws made by Parliament and by the Legislatures of States\",\"(1) Subject to the provisions of this Constitution, Parliament may make laws for the whole or any part of the territory of India, and the Legislature of a State may make laws for the whole or any part of the State.\\r\\n(2) No law made by Parliament shall be deemed to be invalid on the ground that it would have extra-territorial operation.\\r\\n\"],\"2\":[\"246. Subject-matter of laws made by Parliament and by the Legislatures of States\",\"(1) Notwithstanding anything in clauses (2) and (3), Parliament has exclusive power to make laws with respect to any of the matters enumerated in List I in the Seventh Schedule (in this Constitution referred to as the \\u201cUnion List\\u201d).\\r\\n(2) Notwithstanding anything in clause (3), Parliament, and, subject to clause (1), the Legislature of any State also, have power to make laws with respect to any of the matters enumerated in List III in the Seventh Schedule (in this Constitution referred to as the \\u201cConcurrent List\\u201d).\\r\\n(3) Subject to clauses (1) and (2), the Legislature of any State has exclusive power to make laws for such State or any part thereof with respect to any of the matters enumerated in List II in the Seventh Schedule (in this Constitution referred to as the \\u201cState List\\u201d).\\r\\n(4) Parliament has power to make laws with respect to any matter for any part of the territory of India not included in a State notwithstanding that such matter is a matter enumerated in the State List.\\r\\n\"],\"3\":[\"246-A. Special provision with respect to goods and services tax\",\"(1) Notwithstanding anything contained in Articles 246 and 254, Parliament, and, subject to clause (2), the Legislature of every State, have power to make laws with respect to goods and services tax imposed by the Union or by such State.\\r\\n(2) Parliament has exclusive power to make laws with respect to goods and services tax where the supply of goods, or of services, or both takes place in the course of inter-State trade or commerce.\\r\\n\"],\"4\":[\"247. Power of Parliament to provide for the establishment of certain additional courts\",\"Notwithstanding anything in this Chapter, Parliament may by law provide for the establishment of any additional courts for the better administration of laws made by Parliament or of any existing laws with respect to a matter enumerated in the Union List\"],\"5\":[\"248. Residuary powers of legislation\",\"(1) Subject to Article 246-A, Parliament has exclusive power to make any law with respect to any matter not enumerated in the Concurrent List or State List.\\r\\n(2) Such power shall include the power of making any law imposing a tax not mentioned in either of those Lists.\\r\\n\"],\"6\":[\"249. Power of Parliament to legislate with respect to a matter in the State List in the national interest\",\"(1) Notwithstanding anything in the foregoing provisions of this Chapter, if the Council of States has declared by resolution supported by not less than two-thirds of the members present and voting that it is necessary or expedient in national interest that Parliament should make laws with respect to 325[goods and services tax provided under Article 246-A or] any matter enumerated in the State List specified in the resolution, it shall be lawful for Parliament to make laws for the whole or any part of the territory of India with respect to that matter while the resolution remains in force.\\r\\n(2) A resolution passed under clause (1) shall remain in force for such period not exceeding one year as may be specified therein:\\r\\nProvided that, if and so often as a resolution approving the continuance in force of any such resolution is passed in the manner provided in clause (1), such resolution shall continue in force for a further period of one year from the date on which under this clause it would otherwise have ceased to be in force.\\r\\n(3) A law made by Parliament which Parliament would not but for the passing of a resolution under clause (1) have been competent to make shall, to the extent of the incompetency, cease to have effect on the expiration of a period of six months after the resolution has ceased to be in force, except as respects things done or omitted to be done before the expiration of the said period.\\r\\n\"],\"7\":[\"250. Power of Parliament to legislate with respect to any matter in the State List if a Proclamation of Emergency is in operation\",\"(1) Notwithstanding anything in this Chapter, Parliament shall, while a Proclamation of Emergency is in operation, have power to make laws for the whole or any part of the territory of India with respect to goods and services tax provided under Article 246-A or any of the matters enumerated in the State List.\\r\\n(2) A law made by Parliament which Parliament would not but for the issue of a Proclamation of Emergency have been competent to make shall, to the extent of the incompetency, cease to have effect on the expiration of a period of six months after the Proclamation has ceased to operate, except as respects things done or omitted to be done before the expiration of the said period.\\r\\n\"],\"8\":[\"251. Inconsistency between laws made by Parliament under Articles 249 and 250 and laws made by the Legislatures of States\",\"Nothing in Articles 249 and 250 shall restrict the power of the Legislature of a State to make any law which under this Constitution it has power to make, but if any provision of a law made by the Legislature of a State is repugnant to any provision of a law made by Parliament which Parliament has under either of the said articles power to make, the law made by Parliament, whether passed before or after the law made by the Legislature of the State, shall prevail, and the law made by the Legislature of the State shall to the extent of the repugnancy, but so long only as the law made by Parliament continues to have effect, be inoperative.\"],\"9\":[\"252. Power of Parliament to legislate for two or more States by consent and adoption of such legislation by any other State\",\"1) If it appears to the Legislatures of two or more States to be desirable that any of the matters with respect to which Parliament has no power to make laws for the States except as provided in Articles 249 and 250 should be regulated in such States by Parliament by law, and if resolutions to that effect are passed by all the Houses of the Legislatures of those States, it shall be lawful for Parliament to pass an Act for regulating that matter accordingly, and any Act so passed shall apply to such States and to any other State by which it is adopted afterwards by resolution passed in that behalf by the House or, where there are two Houses, by each of the Houses of the Legislature of that State.\\r\\n(2) Any Act so passed by Parliament may be amended or repealed by an Act of Parliament passed or adopted in like manner but shall not, as respects any State to which it applies, be amended or repealed by an Act of the Legislature of that State\\r\\n\"],\"10\":[\"253. Legislation for giving effect to international agreements\",\"Notwithstanding anything in the foregoing provisions of this Chapter, Parliament has power to make any law for the whole or any part of the territory of India for implementing any treaty, agreement or convention with any other country or countries or any decision made at any international conference, association or other body.\"],\"11\":[\"254. Inconsistency between laws made by Parliament and laws made by the Legislatures of States\",\"(1) If any provision of a law made by the Legislature of a State is repugnant to any provision of a law made by Parliament which Parliament is competent to enact, or to any provision of an existing law with respect to one of the matters enumerated in the Concurrent List, then, subject to the provisions of clause (2), the law made by Parliament, whether passed before or after the law made by the Legislature of such State, or, as the case may be, the existing law, shall prevail and the law made by the Legislature of the State shall, to the extent of the repugnancy, be void.\\r\\n(2) Where a law made by the Legislature of a State 327[* * *] with respect to one of the matters enumerated in the Concurrent List contains any provision repugnant to the provisions of an earlier law made by Parliament or an existing law with respect to that matter, then, the law so made by the Legislature of such State shall, if it has been reserved for the consideration of the President and has received his assent, prevail in that State:\\r\\nProvided that nothing in this clause shall prevent Parliament from enacting at any time any law with respect to the same matter including a law adding to, amending, varying or repealing the law so made by the Legislature of the State.\\r\\n\"],\"12\":[\"255. Requirements as to recommendations and previous sanctions to be regarded as matters of procedure only\",\"No Act of Parliament or of the Legislature of a State  and no provision in any such Act, shall be invalid by reason only that some recommendation or previous sanction required by this Constitution was not given, if assent to that Act was given\\u2014\\r\\n(a) where the recommendation required was that of the Governor, either by the Governor or by the President;\\r\\n(b) where the recommendation required was that of the Rajpramukh, either by the Rajpramukh or by the President;\\r\\n(c) where the recommendation or previous sanction required was that of the President, by the President.\\r\\n\"]}', 1, '2021-01-31 21:04:22', '2021-02-01 01:02:06');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(53, 'HwSzRRRlcxU4ISV78oztnd61S', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XI CHAPTER 2', 'ADMINISTRATIVE RELATIONS', '', '', '{\"1\":[\"256. Obligation of States and the Union\",\"The executive power of every State shall be so exercised as to ensure compliance with the laws made by Parliament and any existing laws which apply in that State, and the executive power of the Union shall extend to the giving of such directions to a State as may appear to the Government of India to be necessary for that purpose.\"],\"2\":[\"257. Control of the Union over States in certain cases\",\"(1) The executive power of every State shall be so exercised as not to impede or prejudice the exercise of the executive power of the Union, and the executive power of the Union shall extend to the giving of such directions to a State as may appear to the Government of India to be necessary for that purpose.\\r\\n(2) The executive power of the Union shall also extend to the giving of directions to a State as to the construction and maintenance of means of communication declared in the direction to be of national or military importance:\\r\\nProvided that nothing in this clause shall be taken as restricting the power of Parliament to declare highways or waterways to be national highways or national waterways or the power of the Union with respect to the highways or waterways so declared or the power of the Union to construct and maintain means of communication as part of its functions with respect to naval, military and air force works.\\r\\n(3) The executive power of the Union shall also extend to the giving of directions to a State as to the measures to be taken for the protection of the railways within the State.\\r\\n(4) Where in carrying out any direction given to a State under clause (2) as to the construction or maintenance of any means of communication or under clause (3) as to the measures to be taken for the protection of any railway, costs have been incurred in excess of those which would have been incurred in the discharge of the normal duties of the State if such direction had not been given, there shall be paid by the Government of India to the State such sum as may be agreed, or, in default of agreement, as may be determined by an arbitrator appointed by the Chief Justice of India, in respect of the extra costs so incurred by the State\\r\\n\"],\"3\":[\"258. Power of the Union to confer powers, etc., on States in certain cases\",\"(1) Notwithstanding anything in this Constitution, the President may, with the consent of the Government of a State, entrust either conditionally or unconditionally to that Government or to its officers functions in relation to any matter to which the executive power of the Union extends.\\r\\n(2) A law made by Parliament which applies in any State may, notwithstanding that it relates to a matter with respect to which the Legislature of the State has no power to make laws, confer powers and impose duties, or authorise the conferring of powers and the imposition of duties, upon the State or officers and authorities thereof.\\r\\n(3) Where by virtue of this article powers and duties have been conferred or imposed upon a State or officers or authorities thereof, there shall be paid by the Government of India to the State such sum as may be agreed, or, in default of agreement, as may be determined by an arbitrator appointed by the Chief Justice of India, in respect of any extra costs of administration incurred by the State in connection with the exercise of those powers and duties.\\r\\n\"],\"4\":[\"258-A. Power of the States to entrust functions to the Union\",\"Notwithstanding anything in this Constitution, the Governor of a State may, with the consent of the Government of India, entrust either conditionally or unconditionally to that Government or to its officers functions in relation to any matter to which the executive power of the State extends\"],\"5\":[\"259. Armed Forces in States in Part B of the First Schedule\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Schedule.\"],\"6\":[\"260. Jurisdiction of the Union in relation to territories outside India\",\"The Government of India may by agreement with the Government of any territory not being part of the territory of India undertake any executive, legislative or judicial functions vested in the Government of such territory, but every such agreement shall be subject to, and governed by, any law relating to the exercise of foreign jurisdiction for the time being in force.\"],\"7\":[\"261. Public acts, records and judicial proceedings\",\"(1) Full faith and credit shall be given throughout the territory of India to public acts, records and judicial proceedings of the Union and of every State.\\r\\n(2) The manner in which and the conditions under which the acts, records and proceedings referred to in clause (1) shall be proved and the effect thereof determined shall be as provided by law made by Parliament.\\r\\n(3) Final judgments or orders delivered or passed by civil courts in any part of the territory of India shall be capable of execution anywhere within that territory according to law.\\r\\n\"],\"8\":[\"262. Adjudication of disputes relating to waters of inter-State rivers or river valleys\",\"(1) Parliament may by law provide for the adjudication of any dispute or complaint with respect to the use, distribution or control of the waters of, or in, any inter-State river or river valley.\\r\\n(2) Notwithstanding anything in this Constitution, Parliament may by law provide that neither the Supreme Court nor any other court shall exercise jurisdiction in respect of any such dispute or complaint as is referred to in clause (1).\\r\\n\"],\"9\":[\"263. Provisions with respect to an inter-State Council\",\"If at any time it appears to the President that the public interests would be served by the establishment of a Council charged with the duty of\\u2014\\r\\n(a) inquiring into and advising upon disputes which may have arisen between States;\\r\\n(b) investigating and discussing subjects in which some or all of the States, or the Union and one or more of the States, have a common interest; or\\r\\n(c) making recommendations upon any such subject and, in particular, recommendations for the better co-ordination of policy and action with respect to that subject,\\r\\nit shall be lawful for the President by order to establish such a Council, and to define the nature of the duties to be performed by it and its organisation and procedure\\r\\n\"]}', 1, '2021-02-01 01:03:15', '2021-02-01 01:07:20'),
(54, 'WhfuUGbGd4neVBgPnJgHYj8zY', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XII CHAPTER 1', 'FINANCE, PROPERTY, CONTRACTS AND SUITS', '', '', '{\"1\":[\"264. Interpretation\",\"In this Part, \\u201cFinance Commission\\u201d means a Finance Commission constituted under Article 280\"],\"2\":[\"265. Taxes not to be imposed save by authority of law\",\"No tax shall be levied or collected except by authority of law.\"],\"3\":[\"266. Consolidated Funds and public accounts of India and of the States\",\"(1) Subject to the provisions of Article 267 and to the provisions of this Chapter with respect to the assignment of the whole or part of the net proceeds of certain taxes and duties to States, all revenues received by the Government of India, all loans raised by that Government by the issue of treasury bills, loans or ways and means advances and all moneys received by that Government in repayment of loans shall form one consolidated fund to be entitled \\u201cthe Consolidated Fund of India\\u201d, and all revenues received by the Government of a State, all loans raised by that Government by the issue of treasury bills, loans or ways and means advances and all moneys received by that Government in repayment of loans shall form one consolidated fund to be entitled \\u201cthe Consolidated Fund of the State\\u201d.\\r\\n(2) All other public moneys received by or on behalf of the Government of India or the Government of a State shall be credited to the public account of India or the public account of the State, as the case may be.\\r\\n(3) No moneys out of the Consolidated Fund of India or the Consolidated Fund of a State shall be appropriated except in accordance with law and for the purposes and in the manner provided in this Constitution.\\r\\n\"],\"4\":[\"267. Contingency Fund\",\"(1) Parliament may by law establish a Contingency Fund in the nature of an imprest to be entitled \\u201cthe Contingency Fund of India\\u201d into which shall be paid from time to time such sums as may be determined by such law, and the said Fund shall be placed at the disposal of the President to enable advances to be made by him out of such Fund for the purposes of meeting unforeseen expenditure pending authorisation of such expenditure by Parliament by law under Article 115 or Article 116.\\r\\n(2) The Legislature of a State may by law establish a Contingency Fund in the nature of an imprest to be entitled \\u201cthe Contingency Fund of the State\\u201d into which shall be paid from time to time such sums as may be determined by such law, and the said Fund shall be placed at the disposal of the Governor of the State to enable advances to be made by him out of such Fund for the purposes of meeting unforeseen expenditure pending authorisation of such expenditure by the Legislature of the State by law under Article 205 or Article 206.\\r\\n\"],\"5\":[\"268. Duties levied by the Union but collected and appropriated by the States\",\"(1) Such stamp duties as are mentioned in the Union List shall be levied by the Government of India but shall be collected\\u2014\\r\\n(a) in the case where such duties are leviable within any 336[Union territory], by the Government of India, and\\r\\n(b) in other cases, by the States within which such duties are respectively leviable.\\r\\n(2) The proceeds in any financial year of any such duty leviable within any State shall not form part of the Consolidated Fund of India, but shall be assigned to that State.\\r\\n\"],\"6\":[\"269. Taxes levied and collected by the Union but assigned to the States\",\" (1) Taxes on the sale or purchase of goods and taxes on the consignment of goods except as provided in Article 269-A shall be levied and collected by the Government of India but shall be assigned and shall be deemed to have been assigned to the States on or after the 1st day of April, 1996 in the manner provided in clause (2).\\r\\n(2) The net proceeds in any financial year of any such tax, except in so far as those proceeds represent proceeds attributable to Union territories, shall not form part of the Consolidated Fund of India, but shall be assigned to the States within which that tax is leviable in that year, and shall be distributed among those States in accordance with such principles of distribution as may be formulated by Parliament by law.\\r\\n(3) Parliament may by law formulate principles for determining when a sale or purchase of or consignment of  goods takes place in the course of inter-State trade or commerce.\\r\\n\"],\"7\":[\"269-A. Levy and collection of goods and services tax in course of inter-State trade or commerce\",\"(1) Goods and services tax on supplies in the course of inter-State trade or commerce shall be levied and collected by the Government of India and such tax shall be apportioned between the Union and the States in the manner as may be provided by Parliament by law on the recommendations of the Goods and Services Tax Council.\\r\\n(2) The amount apportioned to a State under clause (1) shall not form part of the Consolidated Fund of India.\\r\\n(3) Where an amount collected as tax levied under clause (1) has been used for payment of the tax levied by a State under Article 246-A, such amount shall not form part of the Consolidated Fund of India.\\r\\n(4) Where an amount collected as tax levied by a State under Article 246-A has been used for payment of the tax levied under clause (1), such amount shall not form part of the Consolidated Fund of the State.\\r\\n(5) Parliament may, by law, formulate the principles for determining the place of supply, and when a supply of goods, or of services, or both takes place in the course of inter-State trade or commerce.\\r\\n\"],\"8\":[\"270. Taxes levied and distributed between the Union and the States\",\"(1) All taxes and duties referred to in the Union List, except the duties and taxes referred to in Articles 268, 269 and 269-A, respectively, surcharge on taxes and duties referred to in Article 271 and any cess levied for specific purposes under any law made by Parliament shall be levied and collected by the Government of India and shall be distributed between the Union and the States in the manner provided in clause (2).\\r\\n(1-A) The tax collected by the Union under clause (1) of Article 246-A shall also be distributed between the Union and the States in the manner provided in clause (2).\\r\\n(1-B) The tax levied and collected by the Union under clause (2) of Article 246-A and Article 269-A, which has been used for payment of the tax levied by the Union under clause (1) of Article 246-A, and the amount apportioned to the Union under clause (1) of Article 269-A, shall also be distributed between the Union and the States in the manner provided in clause (2).\\r\\n(2) Such percentage, as may be prescribed, of the net proceeds of any such tax or duty in any financial year shall not form part of the Consolidated Fund of India, but shall be assigned to the States within which that tax or duty is leviable in that year, and shall be distributed among those States in such manner and from such time as may be prescribed in the manner provided in clause (3).\\r\\n(3) In this article, \\u201cprescribed\\u201d means,\\u2014\\r\\n(i) until a Finance Commission has been constituted, prescribed by the President by order, and\\r\\n(ii) after a Finance Commission has been constituted, prescribed by the President by order after considering the recommendations of the Finance Commission.\\r\\n\"],\"9\":[\"271. Surcharge on certain duties and taxes for purposes of the Union\",\"Notwithstanding anything in Articles 269 and 270, Parliament may at any time increase any of the duties or taxes referred to in those articles except the goods and services tax under Article 246-A, by a surcharge for purposes of the Union and the whole proceeds of any such surcharge shall form part of the Consolidated Fund of India.\"],\"10\":[\"272. Taxes which are levied and collected by the Union and may be distributed between the Union and the States\",\"[* * *]\"],\"11\":[\"273. Grants in lieu of export duty on jute and jute products\",\"(1) There shall be charged on the Consolidated Fund of India in each year as grants-in-aid of the revenues of the States of Assam, Bihar,  Odisha and West Bengal, in lieu of assignment of any share of the net proceeds in each year of export duty on jute and jute products to those States, such sums as may be prescribed.\\r\\n(2) The sums so prescribed shall continue to be charged on the Consolidated Fund of India so long as any export duty on jute or jute products continues to be levied by the Government of India or until the expiration of ten years from the commencement of this Constitution, whichever is earlier.\\r\\n(3) In this article, the expression \\u201cprescribed\\u201d has the same meaning as in Article 270.\\r\\n\"],\"12\":[\"274. Prior recommendation of President required to Bills affecting taxation in which States are interested\",\"(1) No Bill or amendment which imposes or varies any tax or duty in which States are interested, or which varies the meaning of the expression \\u201cagricultural income\\u201d as defined for the purposes of the enactments relating to Indian income-tax, or which affects the principles on which under any of the foregoing provisions of this Chapter moneys are or may be distributable to States, or which imposes any such surcharge for the purposes of the Union as is mentioned in the foregoing provisions of this Chapter, shall be introduced or moved in either House of Parliament except on the recommendation of the President.\\r\\n(2) In this article, the expression \\u201ctax or duty in which States are interested\\u201d means\\u2014\\r\\n(a) a tax or duty the whole or part of the net proceeds whereof are assigned to any State; or\\r\\n(b) a tax or duty by reference to the net proceeds whereof sums are for the time being payable out of the Consolidated Fund of India to any State.\\r\\n\"],\"13\":[\"275. Grants from the Union to certain States\",\"(1) Such sums as Parliament may by law provide shall be charged on the Consolidated Fund of India in each year as grants-in-aid of the revenues of such States as Parliament may determine to be in need of assistance, and different sums may be fixed for different States:\\r\\nProvided that there shall be paid out of the Consolidated Fund of India as grants-in-aid of the revenues of a State such capital and recurring sums as may be necessary to enable that State to meet the costs of such schemes of development as may be undertaken by the State with the approval of the Government of India for the purpose of promoting the welfare of the Scheduled Tribes in that State or raising the level of administration of the Scheduled Areas therein to that of the administration of the rest of the areas of that State:\\r\\nProvided further that there shall be paid out of the Consolidated Fund of India as grants-in-aid of the revenues of the State of Assam sums, capital and recurring, equivalent to\\u2014\\r\\n(a) the average excess of expenditure over the revenues during the two years immediately preceding the commencement of this Constitution in respect of the administration of the tribal areas specified in Part I of the table appended to paragraph 20 of the Sixth Schedule; and\\r\\n(b) the costs of such schemes of development as may be undertaken by that State with the approval of the Government of India for the purpose of raising the level of administration of the said areas to that of the administration of the rest of the areas of that State.\\r\\n(1-A) On and from the formation of the autonomous State under Article 244-A,\\u2014\\r\\n(i) any sums payable under clause (a) of the second proviso to clause (1) shall, if the autonomous State comprises all the tribal areas referred to therein, be paid to the autonomous State, and, if the autonomous State comprises only some of those tribal areas, be apportioned between the State of Assam and the autonomous State as the President may, by order, specify;\\r\\n(ii) there shall be paid out of the Consolidated Fund of India as grants-in-aid of the revenues of the autonomous State sums, capital and recurring, equivalent to the costs of such schemes of development as may be undertaken by the autonomous State with the approval of the Government of India for the purpose of raising the level of administration of that State to that of the administration of the rest of the State of Assam.\\r\\n(2) Until provision is made by Parliament under clause (1), the powers conferred on Parliament under that clause shall be exercisable by the President by order and any order made by the President under this clause shall have effect subject to any provision so made by Parliament:\\r\\nProvided that after a Finance Commission has been constituted no order shall be made under this clause by the President except after considering the recommendations of the Finance Commission.\\r\\n\"],\"14\":[\"276. Taxes on professions, trades, callings and employments\",\"(1) Notwithstanding anything in Article 246, no law of the Legislature of a State relating to taxes for the benefit of the State or of a municipality, district board, local board or other local authority therein in respect of professions, trades, callings or employments shall be invalid on the ground that it relates to a tax on income.\\r\\n(2) The total amount payable in respect of any one person to the State or to any one municipality, district board, local board or other local authority in the State by way of taxes on professions, trades, callings and employments shall not exceed two thousand and five hundred rupees per annum:\\r\\n(3) The power of the Legislature of a State to make laws as aforesaid with respect to taxes on professions, trades, callings and employments shall not be construed as limiting in any way the power of Parliament to make laws with respect to taxes on income accruing from or arising out of professions, trades, callings and employments.\\r\\n\"],\"15\":[\"277. Savings\",\"Any taxes, duties, cesses or fees which, immediately before the commencement of this Constitution, were being lawfully levied by the Government of any State or by any municipality or other local authority or body for the purposes of the State, municipality, district or other local area may, notwithstanding that those taxes, duties, cesses or fees are mentioned in the Union List, continue to be levied and to be applied to the same purposes until provision to the contrary is made by Parliament by law\"],\"16\":[\"278. Agreement with States in Part B of the First Schedule with regard to certain financial matters\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, Section 29 and Schedule\"],\"17\":[\"279. Calculation of \\u201cnet proceeds\\u201d, etc\",\"(1) In the foregoing provisions of this Chapter, \\u201cnet proceeds\\u201d means in relation to any tax or duty the proceeds thereof reduced by the cost of collection, and for the purposes of those provisions the net proceeds of any tax or duty, or of any part of any tax or duty, in or attributable to any area shall be ascertained and certified by the Comptroller and Auditor-General of India, whose certificate shall be final.\\r\\n(2) Subject as aforesaid, and to any other express provision of this Chapter, a law made by Parliament or an order of the President may, in any case where under this Part the proceeds of any duty or tax are, or may be, assigned to any State, provide for the manner in which the proceeds are to be calculated, for the time from or at which and the manner in which any payments are to be made, for the making of adjustments between one financial year and another, and for any other incidental or ancillary matters.\\r\\n\"],\"18\":[\"279-A. Goods and Services Tax Council\",\"(1) The President shall, within sixty days from the date of commencement of the Constitution (One Hundred and First Amendment) Act, 2016, by order, constitute a Council to be called the Goods and Services Tax Council.\\r\\n(2) The Goods and Services Tax Council shall consist of the following members, namely:\\u2014\\r\\n(a)\\tthe Union Finance Minister\\t\\u2026\\tChairperson;\\r\\n(b)\\tthe Union Minister of State in charge of Revenue or Finance\\t\\u2026\\tMember;\\r\\n(c)\\tthe Minister in charge of Finance or Taxation or any other Minister nominated by each State Government\\t\\u2026\\tMembers.\\r\\n(3) The Members of the Goods and Services Tax Council referred to in sub-clause (c) of clause (2) shall, as soon as may be, choose one amongst themselves to be the Vice-Chairperson of the Council for such period as they may decide.\\r\\n(4) The Goods and Services Tax Council shall make recommendations to the Union and the States on\\u2014\\r\\n(a) the taxes, cesses and surcharges levied by the Union, the States and the local bodies which may be subsumed in the goods and services tax;\\r\\n(b) the goods and services that may be subjected to, or exempted from the goods and services tax;\\r\\n(c) model Goods and Services Tax Laws, principles of levy, apportionment of Goods and Services Tax levied on supplies in the course of inter-State trade or commerce under Article 269-A and the principles that govern the place of supply;\\r\\n(d) the threshold limit of turnover below which goods and services may be exempted from goods and services tax;\\r\\n(e) the rates including floor rates with bands of goods and services tax;\\r\\n(f) any special rate or rates for a specified period, to raise additional resources during any natural calamity or disaster;\\r\\n(g) special provision with respect to the States of Arunachal Pradesh, Assam, Jammu and Kashmir, Manipur, Meghalaya, Mizoram, Nagaland, Sikkim, Tripura, Himachal Pradesh and Uttarakhand; and\\r\\n(h) any other matter relating to the goods and services tax, as the Council may decide.\\r\\n(5) The Goods and Services Tax Council shall recommend the date on which the goods and services tax be levied on petroleum crude, high speed diesel, motor spirit (commonly known as petrol), natural gas and aviation turbine fuel.\\r\\n(6) While discharging the functions conferred by this article, the Goods and Services Tax Council shall be guided by the need for a harmonised structure of goods and services tax and for the development of a harmonised national market for goods and services.\\r\\n(7) One half of the total number of Members of the Goods and Services Tax Council shall constitute the quorum at its meetings.\\r\\n(8) The Goods and Services Tax Council shall determine the procedure in the performance of its functions.\\r\\n(9) Every decision of the Goods and Services Tax Council shall be taken at a meeting, by a majority of not less than three-fourths of the weighted votes of the members present and voting, in accordance with the following principles, namely:\\u2014\\r\\n(a) the vote of the Central Government shall have a weightage of one-third of the total votes cast, and\\r\\n(b) the votes of all the State Governments taken together shall have a weightage of two-thirds of the total votes cast,\\r\\nin that meeting.\\r\\n(10) No act or proceedings of the Goods and Services Tax Council shall be invalid merely by reason of\\u2014\\r\\n(a) any vacancy in, or any defect in, the constitution of the Council; or\\r\\n(b) any defect in the appointment of a person as a Member of the Council; or\\r\\n(c) any procedural irregularity of the Council not affecting the merits of the case.\\r\\n(11) The Goods and Services Tax Council shall establish a mechanism to adjudicate any dispute \\u2014\\r\\n(a) between the Government of India and one or more States; or\\r\\n(b) between the Government of India and any State or States on one side and one or more other States on the other side; or\\r\\n(c) between two or more States,\\r\\narising out of the recommendations of the Council or implementation thereof.\\r\\n\"],\"19\":[\"280. Finance Commission\",\"(1) The President shall, within two years from the commencement of this Constitution and thereafter at the expiration of every fifth year or at such earlier time as the President considers necessary, by order constitute a Finance Commission which shall consist of a Chairman and four other members to be appointed by the President.\\r\\n(2) Parliament may by law determine the qualifications which shall be requisite for appointment as members of the Commission and the manner in which they shall be selected.\\r\\n(3) It shall be the duty of the Commission to make recommendations to the President as to\\u2014\\r\\n(a) the distribution between the Union and the States of the net proceeds of taxes which are to be, or may be, divided between them under this Chapter and the allocation between the States of the respective shares of such proceeds\\r\\n(b) the principles which should govern the grants-in-aid of the revenues of the States out of the Consolidated Fund of India;\\r\\n(bb) the measures needed to augment the Consolidated Fund of a State to supplement the resources of the Panchayats in the State on the basis of the recommendations made by the Finance Commission of the State\\r\\n(c) the measures needed to augment the Consolidated Fund of a State to supplement the resources of the Municipalities in the State on the basis of the recommendations made by the Finance Commission of the State\\r\\n (d)] any other matter referred to the Commission by the President in the interests of sound finance.\\r\\n(4) The Commission shall determine their procedure and shall have such powers in the performance of their functions as Parliament may by law confer on them.\\r\\n\"],\"20\":[\"281. Recommendations of the Finance Commission\",\"The President shall cause every recommendation made by the Finance Commission under the provisions of this Constitution together with an explanatory memorandum as to the action taken thereon to be laid before each House of Parliament.\"],\"21\":[\"282. Expenditure defrayable by the Union or a State out of its revenues\",\"The Union or a State may make any grants for any public purpose, notwithstanding that the purpose is not one with respect to which Parliament or the Legislature of the State, as the case may be, may make laws.\"],\"22\":[\"283. Custody, etc., of Consolidated Funds, Contingency Funds and moneys credited to the public accounts\",\"(1) The custody of the Consolidated Fund of India and the Contingency Fund of India, the payment of moneys into such Funds, the withdrawal of moneys therefrom, the custody of public moneys other than those credited to such Funds received by or on behalf of the Government of India, their payment into the public account of India and the withdrawal of moneys from such account and all other matters connected with or ancillary to matters aforesaid shall be regulated by law made by Parliament, and, until provision in that behalf is so made, shall be regulated by rules made by the President.\\r\\n(2) The custody of the Consolidated Fund of a State and the Contingency Fund of a State, the payment of moneys into such Funds, the withdrawal of moneys therefrom, the custody of public moneys other than those credited to such Funds received by or on behalf of the Government of the State, their payment into the public account of the State and the withdrawal of moneys from such account and all other matters connected with or ancillary to matters aforesaid shall be regulated by law made by the Legislature of the State, and, until provision in that behalf is so made, shall be regulated by rules made by the Governor of State \\r\\n\"],\"23\":[\"284. Custody of suitors\' deposits and other moneys received by public servants and courts\",\"All moneys received by or deposited with\\u2014\\r\\n(a) any officer employed in connection with the affairs of the Union or of a State in his capacity as such, other than revenues or public moneys raised or received by the Government of India or the Government of the State, as the case may be, or\\r\\n(b) any court within the territory of India to the credit of any cause, matter, account or persons,\\r\\nshall be paid into the public account of India or the public account of the State, as the case may be.\\r\\n\"],\"24\":[\"285. Exemption of property of the Union from State taxation\",\"(1) The property of the Union shall, save in so far as Parliament may by law otherwise provide, be exempt from all taxes imposed by a State or by any authority within a State.\\r\\n(2) Nothing in clause (1) shall, until Parliament by law otherwise provides, prevent any authority within a State from levying any tax on any property of the Union to which such property was immediately before the commencement of this Constitution liable or treated as liable, so long as that tax continues to be levied in that State.\\r\\n\"],\"25\":[\"286. Restrictions as to imposition of tax on the sale or purchase of goods\",\"(1) No law of a State shall impose, or authorise the imposition of, a tax on 359[the supply of goods or of services or both, where such supply takes place]\\u2014\\r\\n(a) outside the State; or\\r\\n(b) in the course of the import of the goods or services or both into, or export of the goods or services or both out of, the territory of India.\\r\\n (2) Parliament may by law formulate principles for determining when a supply of goods or of services or both} in any of the ways mentioned in clause (1).\\r\\n\"],\"26\":[\"287. Exemption from taxes on electricity\",\"Save in so far as Parliament may by law otherwise provide, no law of a State shall impose, or authorise the imposition of, a tax on the consumption or sale of electricity (whether produced by a Government or other persons) which is\\u2014\\r\\n(a) consumed by the Government of India, or sold to the Government of India for consumption by that Government; or\\r\\n(b) consumed in the construction, maintenance or operation of any railway by the Government of India or a railway company operating that railway, or sold to that Government or any such railway company for consumption in the construction, maintenance or operation of any railway,\\r\\nand any such law imposing, or authorising the imposition of, a tax on the sale of electricity shall secure that the price of electricity sold to the Government of India for consumption by that Government, or to any such railway company as aforesaid for consumption in the construction, maintenance or operation of any railway, shall be less by the amount of the tax than the price charged to other consumers of a substantial quantity of electricity.\\r\\n\"],\"27\":[\"288. Exemption from taxation by States in respect of water or electricity in certain cases\",\"(1) Save in so far as the President may by order otherwise provide, no law of a State in force immediately before the commencement of this Constitution shall impose, or authorise the imposition of, a tax in respect of any water or electricity stored, generated, consumed, distributed or sold by any authority established by any existing law or any law made by Parliament for regulating or developing any inter-State river or river-valley.\\r\\n(2) The Legislature of a State may by law impose, or authorise the imposition of, any such tax as is mentioned in clause (1), but no such law shall have any effect unless it has, after having been reserved for the consideration of the President, received his assent; and if any such law provides for the fixation of the rates and other incidents of such tax by means of rules or orders to be made under the law by any authority, the law shall provide for the previous consent of the President being obtained to the making of any such rule or order.\\r\\n\"],\"28\":[\"289. Exemption of property and income of a State from Union taxation\",\"(1) The property and income of a State shall be exempt from Union taxation.\\r\\n(2) Nothing in clause (1) shall prevent the Union from imposing, or authorising the imposition of, any tax to such extent, if any, as Parliament may by law provide in respect of a trade or business of any kind carried on by, or on behalf of, the Government of a State, or any operations connected therewith, or any property used or occupied for the purposes of such trade or business, or any income accruing or arising in connection therewith.\\r\\n(3) Nothing in clause (2) shall apply to any trade or business, or to any class of trade or business, which Parliament may by law declare to be incidental to the ordinary functions of government.\\r\\n\"],\"29\":[\"290. Adjustment in respect of certain expenses and pensions\",\"Where under the provisions of this Constitution the expenses of any court or Commission, or the pension payable to or in respect of a person who has served before the commencement of this Constitution under the Crown in India or after such commencement in connection with the affairs of the Union or of a State, are charged on the Consolidated Fund of India or the Consolidated Fund of a State, then, if\\u2014\\r\\n(a) in the case of a charge on the Consolidated Fund of India, the court or Commission serves any of the separate needs of a State, or the person has served wholly or in part in connection with the affairs of a State; or\\r\\n(b) in the case of a charge on the Consolidated Fund of a State, the court or Commission serves any of the separate needs of the Union or another State, or the person has served wholly or in part in connection with the affairs of the Union or another State,\\r\\nthere shall be charged on and paid out of the Consolidated Fund of the State or, as the case may be, the Consolidated Fund of India or the Consolidated Fund of the other State, such contribution in respect of the expenses or pension as may be agreed, or as may in default of agreement be determined by an arbitrator to be appointed by the Chief Justice of India.\\r\\n\"],\"30\":[\"290-A. Annual payment to certain Devaswom Funds\",\"A sum of forty-six lakhs and fifty thousand rupees shall be charged on, and paid out of, the Consolidated Fund of the State of Kerala every year to the Travancore Devaswom Fund; and a sum of thirteen lakhs and fifty thousand rupees shall be charged on, and paid out of the Consolidated Fund of the State of Tamil Nadu every year to the Devaswom Fund established in that State for the maintenance of Hindu temples and shrines in the territories transferred to that State on the 1st day of November, 1956, from the State of Travancore-Cochin.\"],\"31\":[\"291. Privy purse sums of Rulers\",\"Rep. by the Constitution (Twenty-sixth Amendment) Act, 1971, Section 2.\"]}', 1, '2021-02-01 01:08:40', '2021-02-01 01:31:17'),
(55, 'NuJoYCTGiTvHHeMP63TgbFhr0', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XII CHAPTER 2', 'BORROWING', '', '', '{\"1\":[\"292. Borrowing by the Government of India\",\"The executive power of the Union extends to borrowing upon the security of the Consolidated Fund of India within such limits, if any, as may from time to time be fixed by Parliament by law and to the giving of guarantees within such limits, if any, as may be so fixed.\"],\"2\":[\"293. Borrowing by States\",\"(1) Subject to the provisions of this article, the executive power of a State extends to borrowing within the territory of India upon the security of the Consolidated Fund of the State within such limits, if any, as may from time to time be fixed by the Legislature of such State by law and to the giving of guarantees within such limits, if any, as may be so fixed.\\r\\n(2) The Government of India may, subject to such conditions as may be laid down by or under any law made by Parliament, make loans to any State or, so long as any limits fixed under Article 292 are not exceeded, give guarantees in respect of loans raised by any State, and any sums required for the purpose of making such loans shall be charged on the Consolidated Fund of India.\\r\\n(3) A State may not without the consent of the Government of India raise any loan if there is still outstanding any part of a loan which has been made to the State by the Government of India or by its predecessor Government, or in respect of which a guarantee has been given by the Government of India or by its predecessor Government.\\r\\n(4) A consent under clause (3) may be granted subject to such conditions, if any, as the Government of India may think fit to impose\\r\\n\"]}', 1, '2021-02-01 01:30:51', '2021-02-01 01:32:44'),
(56, 'uVYWyALZ7U644f6B7uhzGSsHX', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XII CHAPTER 3', 'PROPERTY, CONTRACTS, RIGHTS, LIABILITIES, OBLIGATIONS AND SUITS', '', '', '{\"1\":[\"294. Succession to property, assets, rights, liabilities and obligations in certain cases\",\"As from the commencement of this Constitution(a) all property and assets which immediately before such commencement were vested in His Majesty for the purposes of the Government of the Dominion of India and all property and assets which immediately before such commencement were vested in His Majesty for the purposes of the Government of each Governor\'s Province shall vest respectively in the Union and the corresponding State, and\\r\\n(b) all rights, liabilities and obligations of the Government of the Dominion of India and of the Government of each Governor\'s Province, whether arising out of any contract or otherwise, shall be the rights, liabilities and obligations respectively of the Government of India and the Government of each corresponding State, subject to any adjustment made or to be made by reason of the creation before the commencement of this Constitution of the Dominion of Pakistan or of the Provinces of West Bengal, East Bengal, West Punjab and East Punjab.\\r\\n\"],\"2\":[\"295. Succession to property, assets, rights, liabilities and obligations in other cases\",\"(1) As from the commencement of this Constitution\\u2014\\r\\n(a) all property and assets which immediately before such commencement were vested in any Indian State corresponding to a State specified in Part B of the First Schedule shall vest in the Union, if the purposes for which such property and assets were held immediately before such commencement will thereafter be purposes of the Union relating to any of the matters enumerated in the Union List, and\\r\\n(b) all rights, liabilities and obligations of the Government of any Indian State corresponding to a State specified in Part B of the First Schedule, whether arising out of any contract or otherwise, shall be the rights, liabilities and obligations of the Government of India, if the purposes for which such rights were acquired or liabilities or obligations were incurred before such commencement will thereafter be purposes of the Government of India relating to any of the matters enumerated in the Union List,\\r\\nsubject to any agreement entered into in that behalf by the Government of India with the Government of that State.\\r\\n(2) Subject as aforesaid, the Government of each State specified in Part B of the First Schedule shall, as from the commencement of this Constitution, be the successor of the Government of the corresponding Indian State as regards all property and assets and all rights, liabilities and obligations, whether arising out of any contract or otherwise, other than those referred to in clause (1).\\r\\n\"],\"3\":[\"296. Property accruing by escheat or lapse or as bona vacantia\",\"Subject as hereinafter provided, any property in the territory of India which, if this Constitution had not come into operation, would have accrued to His Majesty or, as the case may be, to the Ruler of an Indian State by escheat or lapse, or as bona vacantia for want of a rightful owner, shall, if it is property situate in a State, vest in such State, and shall, in any other case, vest in the Union:\\r\\nProvided that any property which at the date when it would have so accrued to His Majesty or to the Ruler of an Indian State was in the possession or under the control of the Government of India or the Government of a State shall, according as the purposes for which it was then used or held were purposes of the Union or of a State, vest in the Union or in that State\\r\\n\"],\"4\":[\"297. Things of value within territorial waters or continental shelf and resources of the exclusive economic zone to vest in the Union.\",\"(1) All lands, minerals and other things of value underlying the ocean within the territorial waters, or the continental shelf, or the exclusive economic zone, of India shall vest in the Union and be held for the purposes of the Union.\\r\\n(2) All other resources of the exclusive economic zone of India shall also vest in the Union and be held for the purposes of the Union.\\r\\n(3) The limits of the territorial waters, the continental shelf, the exclusive economic zone, and other maritime zones, of India shall be such as may be specified, from time to time, by or under any law made by Parliament.\\r\\n\"],\"5\":[\"298. Power to carry on trade, etc\",\"The executive power of the Union and of each State shall extend to the carrying on of any trade or business and to the acquisition, holding and disposal of property and the making of contracts for any purpose:\\r\\nProvided that\\u2014\\r\\n(a) the said executive power of the Union shall, in so far as such trade or business or such purpose is not one with respect to which Parliament may make laws, be subject in each State to legislation by the State; and\\r\\n(b) the said executive power of each State shall, in so far as such trade or business or such purpose is not one with respect to which the State Legislature may make laws, be subject to legislation by Parliament\\r\\n\"],\"6\":[\"299. Contracts\",\". (1) All contracts made in the exercise of the executive power of the Union or of a State shall be expressed to be made by the President, or by the Governor of the State, as the case may be, and all such contracts and all assurances of property made in the exercise of that power shall be executed on behalf of the President or the Governor by such persons and in such manner as he may direct or authorise.\\r\\n(2) Neither the President nor the Governor  shall be personally liable in respect of any contract or assurance made or executed for the purposes of this Constitution, or for the purposes of any enactment relating to the Government of India heretofore in force, nor shall any person making or executing any such contract or assurance on behalf of any of them be personally liable in respect thereof.\\r\\n\"],\"7\":[\"300. Suits and proceedings\",\"(1) The Government of India may sue or be sued by the name of the Union of India and the Government of a State may sue or be sued by the name of the State and may, subject to any provisions which may be made by an Act of Parliament or of the Legislature of such State enacted by virtue of powers conferred by this Constitution, sue or be sued in relation to their respective affairs in the like cases as the Dominion of India and the corresponding Provinces or the corresponding Indian States might have sued or been sued if this Constitution had not been enacted.\\r\\n(2) If at the commencement of this Constitution\\u2014\\r\\n(a) any legal proceedings are pending to which the Dominion of India is a party, the Union of India shall be deemed to be substituted for the Dominion in those proceedings; and\\r\\n(b) any legal proceedings are pending to which a Province or an Indian State is a party, the corresponding State shall be deemed to be substituted for the Province or the Indian State in those proceedings.\\r\\n\"]}', 1, '2021-02-01 01:36:10', '2021-02-01 01:39:45'),
(57, 'aSnd1axtMCNuG9XuC5PaYFZ47', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XII CHAPTER 4 ', 'RIGHT TO PROPERTY', '', '', '{\"1\":[\"300-A. Persons not to be deprived of property save by authority of law\",\"No person shall be deprived of his property save by authority of law.\"]}', 1, '2021-02-01 02:03:31', '2021-02-01 02:04:51');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(58, 'caHoneWyOun7NdWMcSsLlJsMD', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XIII ', 'TRADE, COMMERCE AND INTERCOURSE WITHIN THE TERRITORY OF INDIA', '', '', '{\"1\":[\"301. Freedom of trade, commerce and intercourse\",\"Subject to the other provisions of this Part, trade, commerce and intercourse throughout the territory of India shall be free\"],\"2\":[\"302. Power of Parliament to impose restrictions on trade, commerce and intercourse\",\"Parliament may by law impose such restrictions on the freedom of trade, commerce or intercourse between one State and another or within any part of the territory of India as may be required in the public interest.\"],\"3\":[\"303. Restrictions on the legislative powers of the Union and of the States with regard to trade and commerce\",\"(1) Notwithstanding anything in Article 302, neither Parliament nor the Legislature of a State shall have power to make any law giving, or authorising the giving of, any preference to one State over another, or making, or authorising the making of, any discrimination between one State and another, by virtue of any entry relating to trade and commerce in any of the Lists in the Seventh Schedule.\\r\\n(2) Nothing in clause (1) shall prevent Parliament from making any law giving, or authorising the giving of, any preference or making, or authorising the making of, any discrimination if it is declared by such law that it is necessary to do so for the purpose of dealing with a situation arising from scarcity of goods in any part of the territory of India\\r\\n\"],\"4\":[\"304. Restrictions on trade, commerce and intercourse among States\",\"Notwithstanding anything in Article 301 or Article 303, the Legislature of a State may by law\\u2014\\r\\n(a) impose on goods imported from other States 375[or the Union territories] any tax to which similar goods manufactured or produced in that State are subject, so, however, as not to discriminate between goods so imported and goods so manufactured or produced; and\\r\\n(b) impose such reasonable restrictions on the freedom of trade, commerce or intercourse with or within that State as may be required in the public interest:\\r\\nProvided that no Bill or amendment for the purposes of clause (b) shall be introduced or moved in the Legislature of a State without the previous sanction of the President.\\r\\n\"],\"5\":[\"305. Saving of existing laws and laws providing for State monopolies\",\"Nothing in Articles 301 and 303 shall affect the provisions of any existing law except in so far as the President may by order otherwise direct; and nothing in Article 301 shall affect the operation of any law made before the commencement of the Constitution (Fourth Amendment) Act, 1955, in so far as it relates to, or prevent Parliament or the Legislature of a State from making any law relating to, any such matter as is referred to in sub-clause (ii) of clause (6) of Article 19\"],\"6\":[\"306. Power of certain States in Part B of the First Schedule to impose restrictions on trade and commerce\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, Section 29 and Schedule.\"],\"7\":[\"307. Appointment of authority for carrying out the purposes of Articles 301 to 304\",\"Parliament may by law appoint such authority as it considers appropriate for carrying out the purposes of Articles 301, 302, 303 and 304, and confer on the authority so appointed such powers and such duties as it thinks necessary.\"]}', 1, '2021-02-01 02:05:48', '2021-02-01 02:08:29'),
(59, 'Dt2X6fdQwetQYvmPGzeffUxUl', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XIV CHAPTER 1', 'SERVICES UNDER THE UNION AND THE STATES', '', '', '{\"1\":[\"308. Interpretation\",\"In this Part, unless the context otherwise requires, the expression \\u201cState\\u201d does not include the State of Jammu and Kashmir\"],\"2\":[\"309. Recruitment and conditions of service of persons serving the Union or a State\",\"Subject to the provisions of this Constitution, Acts of the appropriate Legislature may regulate the recruitment, and conditions of service of persons appointed, to public services and posts in connection with the affairs of the Union or of any State:\\r\\nProvided that it shall be competent for the President or such person as he may direct in the case of services and posts in connection with the affairs of the Union, and for the Governor of a State or such person as he may direct in the case of services and posts in connection with the affairs of the State, to make rules regulating the recruitment, and the conditions of service of persons appointed, to such services and posts until provision in that behalf is made by or under an Act of the appropriate Legislature under this article, and any rules so made shall have effect subject to the provisions of any such Act.\\r\\n\"],\"3\":[\"310. Tenure of office of persons serving the Union or a State\",\"(1) Except as expressly provided by this Constitution, every person who is a member of a defence service or of a civil service of the Union or of an all-India service or holds any post connected with defence or any civil post under the Union, holds office during the pleasure of the President, and every person who is a member of a civil service of a State or holds any civil post under a State holds office during the pleasure of the Governor of the State.\\r\\n(2) Notwithstanding that a person holding a civil post under the Union or a State holds office during the pleasure of the President or, as the case may be, of the Governor of the State, any contract under which a person, not being a member of a defence service or of an all-India service or of a civil service of the Union or a State, is appointed under this Constitution to hold such a post may, if the President or the Governor as the case may be, deems it necessary in order to secure the services of a person having special qualifications, provide for the payment to him of compensation, if before the expiration of an agreed period that post is abolished or he is, for reasons not connected with any misconduct on his part, required to vacate that post.\\r\\n\"],\"4\":[\"311. Dismissal, removal or reduction in rank of persons employed in civil capacities under the Union or a State\",\"(1) No person who is a member of a civil service of the Union or an all-India service or a civil service of a State or holds a civil post under the Union or a State shall be dismissed or removed by an authority subordinate to that by which he was appointed.\\r\\n(2) No such person as aforesaid shall be dismissed or removed or reduced in rank except after an inquiry in which he has been informed of the charges against him and given a reasonable opportunity of being heard in respect of those charges \\r\\nProvided that where it is proposed after such inquiry, to impose upon him any such penalty, such penalty may be imposed on the basis of the evidence adduced during such inquiry and it shall not be necessary to give such person any opportunity of making representation on the penalty proposed:\\r\\nProvided further that this clause shall not apply\\u2014\\r\\n(a) where a person is dismissed or removed or reduced in rank on the ground of conduct which has led to his conviction on a criminal charge; or\\r\\n(b) where the authority empowered to dismiss or remove a person or to reduce him in rank is satisfied that for some reason, to be recorded by that authority in writing, it is not reasonably practicable to hold such inquiry; or\\r\\n(c) where the President or the Governor, as the case may be, is satisfied that in the interest of the security of the State it is not expedient to hold such inquiry.\\r\\n(3) If, in respect of any such person as aforesaid, a question arises whether it is reasonably practicable to hold such inquiry as is referred to in clause (2), the decision thereon of the authority empowered to dismiss or remove such person or to reduce him in rank shall be final\\r\\n\"],\"5\":[\"312. All-India services\",\"(1) Notwithstanding anything in Chapter VI of Part VI or Part XI, if the Council of States has declared by resolution supported by not less than two-thirds of the members present and voting that it is necessary or expedient in the national interest so to do, Parliament may by law provide for the creation of one or more all-India services including an all-India judicial service common to the Union and the States, and, subject to the other provisions of this Chapter, regulate the recruitment, and the conditions of service of persons appointed, to any such service.\\r\\n(2) The services known at the commencement of this Constitution as the Indian Administrative Service and the Indian Police Service shall be deemed to be services created by Parliament under this article.\\r\\n (3) The all-India judicial service referred to in clause (1) shall not include any post inferior to that of a district judge as defined in Article 236.\\r\\n(4) The law providing for the creation of the all-India judicial service aforesaid may contain such provisions for the amendment of Chapter VI of Part VI as may be necessary for giving effect to the provisions of that law and no such law shall be deemed to be an amendment of this Constitution for the purposes of Article 368.\\r\\n\"],\"6\":[\"312-A. Power of Parliament to vary or revoke conditions of service of officers of certain services\",\"(1) Parliament may by law\\u2014\\r\\n(a) vary or revoke, whether prospectively or retrospectively, the conditions of services as respects remuneration, leave and pension and the rights as respects disciplinary matters of persons who, having been appointed by the Secretary of State or Secretary of State in Council to a civil service of the Crown in India before the commencement of this Constitution, continue on and after the commencement of the Constitution (Twenty-eighth Amendment) Act, 1972, to serve under the Government of India or of a State in any service or post;\\r\\n(b) vary or revoke, whether prospectively or retrospectively, the conditions of service as respects pension of persons who, having been appointed by the Secretary of State or Secretary of State in Council to a civil service of the Crown in India before the commencement of this Constitution, retired or otherwise ceased to be in service at any time before the commencement of the Constitution (Twenty-eighth Amendment) Act, 1972:\\r\\nProvided that in the case of any such person who is holding or has held the office of the Chief Justice or other Judge of the Supreme Court or a High Court, the Comptroller and Auditor-General of India, the Chairman or other member of the Union or a State Public Service Commission or the Chief Election Commissioner, nothing in sub-clause (a) or sub-clause (b) shall be construed as empowering Parliament to vary or revoke, after his appointment to such post, the conditions of his service to his disadvantage except in so far as such conditions of service are applicable to him by reason of his being a person appointed by the Secretary of State or Secretary of State in Council to a civil service of the Crown in India.\\r\\n(2) Except to the extent provided for by Parliament by law under this article, nothing in this article shall affect the power of any legislature or other authority under any other provision of this Constitution to regulate the conditions of service of persons referred to in clause (1).\\r\\n(3) Neither the Supreme Court nor any other court shall have jurisdiction in\\u2014\\r\\n(a) any dispute arising out of any provision of, or any endorsement on, any covenant, agreement or other similar instrument which was entered into or executed by any person referred to in clause (1), or arising out of any letter issued to such person, in relation to his appointment to any civil service of the Crown in India or his continuance in service under the Government of the Dominion of India or a Province thereof;\\r\\n(b) any dispute in respect of any right, liability or obligation under Article 314 as originally enacted.\\r\\n(4) The provisions of this article shall have effect notwithstanding anything in Article 314 as originally enacted or in any other provision of this Constitution.\\r\\n\"],\"7\":[\"313. Transitional provisions\",\"Until other provision is made in this behalf under this Constitution, all the laws in force immediately before the commencement of this Constitution and applicable to any public service or any post which continues to exist after the commencement of this Constitution, as an all-India service or as service or post under the Union or a State shall continue in force so far as consistent with the provisions of this Constitution.\"],\"8\":[\"314. Provision for protection of existing officers of certain services\",\"Rep. by the Constitution (Twenty-eighth Amendment) Act, 1972, S. 3 \"]}', 1, '2021-02-01 02:09:41', '2021-02-01 02:14:06'),
(60, 'isLxZIXOe2YZXUEI08tsWKflu', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XIV CHAPTER 2', 'PUBLIC SERVICE COMMISSIONS', '', '', '{\"1\":[\"315. Public Service Commissions for the Union and for the States\",\"(1) Subject to the provisions of this article, there shall be a Public Service Commission for the Union and a Public Service Commission for each State.\\r\\n(2) Two or more States may agree that there shall be one Public Service Commission for that group of States, and if a resolution to that effect is passed by the House or, where there are two Houses, by each House of the Legislature of each of those States, Parliament may by law provide for the appointment of a Joint State Public Service Commission (referred to in this Chapter as Joint Commission) to serve the needs of those States.\\r\\n(3) Any such law as aforesaid may contain such incidental and consequential provisions as may be necessary or desirable for giving effect to the purposes of the law.\\r\\n(4) The Public Service Commission for the Union, if requested so to do by the Governor of a State, may, with the approval of the President, agree to serve all or any of the needs of the State.\\r\\n(5) References in this Constitution to the Union Public Service Commission or a State Public Service Commission shall, unless the context otherwise requires, be construed as references to the Commission serving the needs of the Union or, as the case may be, the State as respects the particular matter in question.\\r\\n\"],\"2\":[\"316. Appointment and term of office of members\",\"(1) The Chairman and other members of a Public Service Commission shall be appointed, in the case of the Union Commission or a Joint Commission, by the President, and in the case of a State Commission, by the Governor  of the State:\\r\\nProvided that as nearly as may be one-half of the members of every Public Service Commission shall be persons who at the dates of their respective appointments have held office for at least ten years either under the Government of India or under the Government of a State, and in computing the said period of ten years any period before the commencement of this Constitution during which a person has held office under the Crown in India or under the Government of an Indian State shall be included.\\r\\n(1-A) If the office of the Chairman of the Commission becomes vacant or if any such Chairman is by reason of absence or for any other reason unable to perform the duties of his office, those duties shall, until some person appointed under clause (1) to the vacant office has entered on the duties thereof or, as the case may be, until the Chairman has resumed his duties, be performed by such one of the other members of the Commission as the President, in the case of the Union Commission or a Joint Commission, and the Governor of the State in the case of a State Commission, may appoint for the purpose.\\r\\n(2) A member of a Public Service Commission shall hold office for a term of six years from the date on which he enters upon his office or until he attains, in the case of the Union Commission, the age of sixty-five years, and in the case of a State Commission or a Joint Commission, the age of  sixty-two years, whichever is earlier:\\r\\nProvided that\\u2014\\r\\n(a) a member of a Public Service Commission may, by writing under his hand addressed, in the case of the Union Commission or a Joint Commission, to the President, and in the case of a State Commission, to the Governor  of the State, resign his office;\\r\\n(b) a member of a Public Service Commission may be removed from his office in the manner provided in clause (1) or clause (3) of Article 317.\\r\\n(3) A person who holds office as a member of a Public Service Commission shall, on the expiration of his term of office, be ineligible for re-appointment to that office.\\r\\n\"],\"3\":[\"317. Removal and suspension of a member of a Public Service Commission\",\"(1) Subject to the provisions of clause (3), the Chairman or any other member of a Public Service Commission shall only be removed from his office by order of the President on the ground of misbehaviour after the Supreme Court, on reference being made to it by the President, has, on inquiry held in accordance with the procedure prescribed in that behalf under Article 145, reported that the Chairman or such other member, as the case may be, ought on any such ground to be removed.\\r\\n(2) The President, in the case of the Union Commission or a Joint Commission, and the Governor in the case of a State Commission, may suspend from office the Chairman or any other member of the Commission in respect of whom a reference has been made to the Supreme Court under clause (1) until the President has passed orders on receipt of the report of the Supreme Court on such reference.\\r\\n(3) Notwithstanding anything in clause (1), the President may by order remove from office the Chairman or any other member of a Public Service Commission if the Chairman or such other member, as the case may be,\\u2014\\r\\n(a) is adjudged an insolvent; or\\r\\n(b) engages during his term of office in any paid employment outside the duties of his office; or\\r\\n(c) is, in the opinion of the President, unfit to continue in office by reason of infirmity of mind or body.\\r\\n(4) If the Chairman or any other member of a Public Service Commission is or becomes in any way concerned or interested in any contract or agreement made by or on behalf of the Government of India or the Government of a State or participates in any way in the profit thereof or in any benefit or emolument arising therefrom otherwise than as a member and in common with the other members of an incorporated company, he shall, for the purposes of clause (1), be deemed to be guilty of misbehaviour.\\r\\n\"],\"4\":[\"318. Power to make regulations as to conditions of service of members and staff of the Commission\",\"318. Power to make regulations as to conditions of service of members and staff of the Commission.\\u2014In the case of the Union Commission or a Joint Commission, the President and, in the case of a State Commission, the Governor of the State may by regulations\\u2014\\r\\n(a) determine the number of members of the Commission and their conditions of service; and\\r\\n(b) make provision with respect to the number of members of the staff of the Commission and their conditions of service:\\r\\nProvided that the conditions of service of a member of a Public Service Commission shall not be varied to his disadvantage after his appointment.\\r\\n\"],\"5\":[\"319. Prohibition as to the holding of offices by members of Commission on ceasing to be such members\",\"On ceasing to hold office\\u2014\\r\\n(a) the Chairman of the Union Public Service Commission shall be ineligible for further employment either under the Government of India or under the Government of a State;\\r\\n(b) the Chairman of a State Public Service Commission shall be eligible for appointment as the Chairman or any other member of the Union Public Service Commission or as the Chairman of any other State Public Service Commission, but not for any other employment either under the Government of India or under the Government of a State;\\r\\n(c) a member other than the Chairman of the Union Public Service Commission shall be eligible for appointment as the Chairman of the Union Public Service Commission or as the Chairman of a State Public Service Commission, but not for any other employment either under the Government of India or under the Government of a State;\\r\\n(d) a member other than the Chairman of a State Public Service Commission shall be eligible for appointment as the Chairman or any other member of the Union Public Service Commission or as the Chairman of that or any other State Public Service Commission, but not for any other employment either under the Government of India or under the Government of a State.\\r\\n\"],\"6\":[\"320. Functions of Public Service Commissions\",\"(1) It shall be the duty of the Union and the State Public Service Commissions to conduct examinations for appointments to the services of the Union and the services of the State respectively.\\r\\n(2) It shall also be the duty of the Union Public Service Commission, if requested by any two or more States so to do, to assist those States in framing and operating schemes of joint recruitment for any services for which candidates possessing special qualifications are required.\\r\\n(3) The Union Public Service Commission or the State Public Service Commission, as the case may be, shall be consulted\\u2014\\r\\n(a) on all matters relating to methods of recruitment to civil services and for civil posts;\\r\\n(b) on the principles to be followed in making appointments to civil services and posts and in making promotions and transfers from one service to another and on the suitability of candidates for such appointments, promotions or transfers;\\r\\n(c) on all disciplinary matters affecting a person serving under the Government of India or the Government of a State in a civil capacity, including memorials or petitions relating to such matters;\\r\\n(d) on any claim by or in respect of a person who is serving or has served under the Government of India or the Government of a State or under the Crown in India or under the Government of an Indian State, in a civil capacity, that any costs incurred by him in defending legal proceedings instituted against him in respect of acts done or purporting to be done in the execution of his duty should be paid out of the Consolidated Fund of India, or, as the case may be, out of the Consolidated Fund of the State;\\r\\n(e) on any claim for the award of a pension in respect of injuries sustained by a person while serving under the Government of India or the Government of a State or under the Crown in India or under the Government of an Indian State, in a civil capacity, and any question as to the amount of any such award,\\r\\nand it shall be the duty of a Public Service Commission to advise on any matter so referred to them and on any other matter which the President, or, as the case may be, the Governor of the State, may refer to them:\\r\\nProvided that the President as respects the all-India services and also as respects other services and posts in connection with the affairs of the Union, and the Governor , as respects other services and posts in connection with the affairs of a State, may make regulations specifying the matters in which either generally, or in any particular class of case or in any particular circumstances, it shall not be necessary for a Public Service Commission to be consulted.\\r\\n(4) Nothing in clause (3) shall require a Public Service Commission to be consulted as respects the manner in which any provision referred to in clause (4) of Article 16 may be made or as respects the manner in which effect may be given to the provisions of Article 335.\\r\\n(5) All regulations made under the proviso to clause (3) by the President or the Governor of a State shall be laid for not less than fourteen days before each House of Parliament or the House or each House of the Legislature of the State, as the case may be, as soon as possible after they are made, and shall be subject to such modifications, whether by way of repeal or amendment, as both Houses of Parliament or the House or both Houses of the Legislature of the State may make during the session in which they are so laid.\\r\\n\"],\"7\":[\"321. Power to extend functions of Public Service Commissions\",\"An Act made by Parliament or, as the case may be, the Legislature of a State may provide for the exercise of additional functions by the Union Public Service Commission or the State Public Service Commission as respects the services of the Union or the State and also as respects the services of any local authority or other body corporate constituted by law or of any public institution.\"],\"8\":[\"322. Expenses of Public Service Commissions\",\"The expenses of the Union or a State Public Service Commission, including any salaries, allowances and pensions payable to or in respect of the members or staff of the Commission, shall be charged on the Consolidated Fund of India or, as the case may be, the Consolidated Fund of the State.\"],\"9\":[\"323. Reports of Public Service Commissions\",\"(1) It shall be the duty of the Union Commission to present annually to the President a report as to the work done by the Commission and on receipt of such report the President shall cause a copy thereof together with a memorandum explaining, as respects the cases, if any, where the advice of the Commission was not accepted, the reasons for such non-acceptance to be laid before each House of Parliament.\\r\\n(2) It shall be the duty of a State Commission to present annually to the Governor of the State a report as to the work done by the Commission, and it shall be the duty of a Joint Commission to present annually to the Governor of each of the States the needs of which are served by the Joint Commission a report as to the work done by the Commission in relation to that State, and in either case the Governor shall, on receipt of such report, cause a copy thereof together with a memorandum explaining, as respects the cases, if any, where the advice of the Commission was not accepted, the reasons for such non-acceptance to be laid before the Legislature of the State.\\r\\n\"]}', 1, '2021-02-01 02:15:33', '2021-02-01 02:21:06'),
(61, 'ZPbM0XpYPbw7wKyWT9uVwRS57', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XIV-A ', 'TRIBUNALS', '', '', '{\"1\":[\"323-A. Administrative tribunals\",\"(1) Parliament may, by law, provide for the adjudication or trial by administrative tribunals of disputes and complaints with respect to recruitment and conditions of service of persons appointed to public services and posts in connection with the affairs of the Union or of any State or of any local or other authority within the territory of India or under the control of the Government of India or of any corporation owned or controlled by the Government.\\r\\n(2) A law made under clause (1) may\\u2014\\r\\n(a) provide for the establishment of an administrative tribunal for the Union and a separate administrative tribunal for each State or for two or more States;\\r\\n(b) specify the jurisdiction, powers (including the power to punish for contempt) and authority which may be exercised by each of the said tribunals;\\r\\n(c) provide for the procedure (including provisions as to limitation and rules of evidence) to be followed by the said tribunals;\\r\\n(d) exclude the jurisdiction of all courts, except the jurisdiction of the Supreme Court under Article 136, with respect to the disputes or complaints referred to in clause (1);\\r\\n(e) provide for the transfer to each such administrative tribunal of any cases pending before any court or other authority immediately before the establishment of such tribunal as would have been within the jurisdiction of such tribunal if the causes of action on which such suits or proceedings are based had arisen after such establishment;\\r\\n(f) repeal or amend any order made by the President under clause (3) of Article 371-D;\\r\\n(g) contain such supplemental, incidental and consequential provisions (including provisions as to fees) as Parliament may deem necessary for the effective functioning of, and for the speedy disposal of cases by, and the enforcement of the orders of, such tribunals.\\r\\n(3) The provisions of this article shall have effect notwithstanding anything in any other provision of this Constitution or in any other law for the time being in force.\\r\\n\"],\"2\":[\"323-B. Tribunals for other matters\",\"(1) The appropriate Legislature may, by law, provide for the adjudication or trial by tribunals of any disputes, complaints, or offences with respect to all or any of the matters specified in clause (2) with respect to which such Legislature has power to make laws.\\r\\n(2) The matters referred to in clause (1) are the following, namely:\\u2014\\r\\n(a) levy, assessment, collection and enforcement of any tax;\\r\\n(b) foreign exchange, import and export across customs frontiers;\\r\\n(c) industrial and labour disputes;\\r\\n(d) land reforms by way of acquisition by the State of any estate as defined in Article 31-A or of any rights therein or the extinguishment or modification of any such rights or by way of ceiling on agricultural land or in any other way;\\r\\n(e) ceiling on urban property;\\r\\n(f) elections to either House of Parliament or the House or either House of the Legislature of a State, but excluding the matters referred to in Article 329 and Article 329-A;\\r\\n(g) production, procurement, supply and distribution of foodstuffs (including edible oilseeds and oils) and such other goods as the President may, by public notification, declare to be essential goods for the purpose of this article and control of prices of such goods;\\r\\n(h)  rent, its regulation and control and tenancy issues including the right, title and interest of landlords and tenants\\r\\n(i)  offences against laws with respect to any of the matters specified in sub-clauses (a) to {(h)}407 and fees in respect of any of those matters;\\r\\n(j)  any matter incidental to any of the matters specified in sub-clauses (a) to (i).\\r\\n(3) A law made under clause (1) may\\u2014\\r\\n(a) provide for the establishment of a hierarchy of tribunals;\\r\\n(b) specify the jurisdiction, powers (including the power to punish for contempt) and authority which may be exercised by each of the said tribunals;\\r\\n(c) provide for the procedure (including provisions as to limitation and rules of evidence) to be followed by the said tribunals;\\r\\n(d) exclude the jurisdiction of all courts except the jurisdiction of the Supreme Court under Article 136 with respect to all or any of the matters falling within the jurisdiction of the said tribunals;\\r\\n(e) provide for the transfer to each such tribunal of any cases pending before any court or any other authority immediately before the establishment of such tribunal as would have been within the jurisdiction of such tribunal if the causes of action on which such suits or proceedings are based had arisen after such establishment;\\r\\n(f) contain such supplemental, incidental and consequential provisions (including provisions as to fees) as the appropriate Legislature may deem necessary for the effective functioning of, and for the speedy disposal of cases by, and the enforcement of the orders of, such tribunals.\\r\\n(4) The provisions of this article shall have effect notwithstanding anything in any other provision of this Constitution or in any other law for the time being in force\\r\\n\"]}', 1, '2021-02-01 02:22:24', '2021-02-01 02:24:20'),
(62, 'S2Q5OezHvbHHY8dQFjfvUfCU7', '4a0AOf3PSfE5pAOfCZv1OJ4zu', ' Part XV ', 'ELECTIONS', '', '', '{\"1\":[\"324. Superintendence, direction and control of elections to be vested in an Election Commission\",\"(1) The superintendence, direction and control of the preparation of the electoral rolls for, and the conduct of, all elections to Parliament and to the Legislature of every State and of elections to the offices of President and Vice-President held under this Constitution 410[* * *] shall be vested in a Commission (referred to in this Constitution as the Election Commission).\\r\\n(2) The Election Commission shall consist of the Chief Election Commissioner and such number of other Election Commissioners, if any, as the President may from time to time fix and the appointment of the Chief Election Commissioner and other Election Commissioners shall, subject to the provisions of any law made in that behalf by Parliament, be made by the President.\\r\\n(3) When any other Election Commissioner is so appointed the Chief Election Commissioner shall act as the Chairman of the Election Commission.\\r\\n(4) Before each general election to the House of the People and to the Legislative Assembly of each State, and before the first general election and thereafter before each biennial election to the Legislative Council of each State having such Council, the President may also appoint after consultation with the Election Commission such Regional Commissioners as he may consider necessary to assist the Election Commission in the performance of the functions conferred on the Commission by clause (1).\\r\\n(5) Subject to the provisions of any law made by Parliament, the conditions of service and tenure of office of the Election Commissioners and the Regional Commissioners shall be such as the President may by rule determine:\\r\\nProvided that the Chief Election Commissioner shall not be removed from his office except in like manner and on the like grounds as a Judge of the Supreme Court and the conditions of service of the Chief Election Commissioner shall not be varied to his disadvantage after his appointment:\\r\\nProvided further that any other Election Commissioner or a Regional Commissioner shall not be removed from office except on the recommendation of the Chief Election Commissioner.\\r\\n(6) The President, or the Governor of a State, shall, when so requested by the Election Commission, make available to the Election Commission or to a Regional Commissioner such staff as may be necessary for the discharge of the functions conferred on the Election Commission by clause (1).\\r\\n\"],\"2\":[\"325. No person to be ineligible for inclusion in, or to claim to be included in a special, electoral roll on grounds of religion, race, caste or sex\",\"There shall be one general electoral roll for every territorial constituency for election to either House of Parliament or to the House or either House of the Legislature of a State and no person shall be ineligible for inclusion in any such roll or claim to be included in any special electoral roll for any such constituency on grounds only of religion, race, caste, sex or any of them.\"],\"3\":[\"326. Elections to the House of the People and to the Legislative Assemblies of States to be on the basis of adult suffrage\",\"The elections to the House of the People and to the Legislative Assembly of every State shall be on the basis of adult suffrage; that is to say, every person who is a citizen of India and who is not less than eighteen years of age on such date as may be fixed in that behalf by or under any law made by the appropriate Legislature and is not otherwise disqualified under this Constitution or any law made by the appropriate Legislature on the ground of non-residence, unsoundness of mind, crime or corrupt or illegal practice, shall be entitled to be registered as a voter at any such election\"],\"4\":[\"327. Power of Parliament to make provision with respect to elections to Legislatures\",\"Subject to the provisions of this Constitution, Parliament may from time to time by law make provision with respect to all matters relating to, or in connection with, elections to either House of Parliament or to the House or either House of the Legislature of a State including the preparation of electoral rolls, the delimitation of constituencies and all other matters necessary for securing the due constitution of such House or Houses.\"],\"5\":[\"328. Power of Legislature of a State to make provision with respect to elections to such Legislature\",\"Subject to the provisions of this Constitution and in so far as provision in that behalf is not made by Parliament, the Legislature of a State may from time to time by law make provision with respect to all matters relating to, or in connection with, the elections to the House or either House of the Legislature of the State including the preparation of electoral rolls and all other matters necessary for securing the due constitution of such House or Houses\"],\"6\":[\"329. Bar to interference by courts in electoral matters\",\"Notwithstanding anything in this Constitution \\r\\n(a) the validity of any law relating to the delimitation of constituencies or the allotment of seats to such constituencies, made or purporting to be made under Article 327 or Article 328, shall not be called in question in any court;\\r\\n(b) no election to either House of Parliament or to the House or either House of the Legislature of a State shall be called in question except by an election petition presented to such authority and in such manner as may be provided for by or under any law made by the appropriate Legislature.\\r\\n\"]}', 1, '2021-02-01 02:25:15', '2021-02-01 02:27:31');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(63, 'c2kjOr9FR83XtT4IQGifKHL0F', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVI ', 'SPECIAL PROVISIONS RELATING TO CERTAIN CLASSES', '', '', '{\"1\":[\"330. Reservation of seats for Scheduled Castes and Scheduled Tribes in the House of the People\",\"(1) Seats shall be reserved in the House of the People for\\u2014\\r\\n(a) the Scheduled Castes;\\r\\n(b) the Scheduled Tribes except the Scheduled Tribes in the autonomous districts of Assam; and\\r\\n(c) the Scheduled Tribes in the autonomous districts of Assam.\\r\\n(2) The number of seats reserved in any State or Union territory for the Scheduled Castes or the Scheduled Tribes under clause (1) shall bear, as nearly as may be, the same proportion to the total number of seats allotted to that State or Union territory in the House of the People as the population of the Scheduled Castes in the State or Union territory or of the Scheduled Tribes in the State  or Union territory or part of the State or Union territory as the case may be, in respect of which seats are so reserved, bears to the total population of the State or Union territory\\r\\n(3) Notwithstanding anything contained in clause (2), the number of seats reserved in the House of the People for the Scheduled Tribes in the autonomous districts of Assam shall bear to the total number of seats allotted to that State a proportion not less than the population of the Scheduled Tribes in the said autonomous districts bears to the total population of the State\\r\\n\"],\"2\":[\"331. Representation of the Anglo-Indian community in the House of the People\",\"Notwithstanding anything in Article 81, the President may, if he is of opinion that the Anglo-Indian community is not adequately represented in the House of the People, nominate not more than two members of that community to the House of the People.\"],\"3\":[\"332. Reservation of seats for Scheduled Castes and Scheduled Tribes in the Legislative Assemblies of the States\",\"(1) Seats shall be reserved for the Scheduled Castes and the Scheduled Tribes,  except the Scheduled Tribes in the autonomous districts of Assam, in the Legislative Assembly of every State \\r\\n(2) Seats shall be reserved also for the autonomous districts in the Legislative Assembly of the State of Assam.\\r\\n(3) The number of seats reserved for the Scheduled Castes or the Scheduled Tribes in the Legislative Assembly of any State under clause (1) shall bear, as nearly as may be, the same proportion to the total number of seats in the Assembly as the population of the Scheduled Castes in the State or of the Scheduled Tribes in the State or part of the State, as the case may be, in respect of which seats are so reserved, bears to the total population of the State.\\r\\n (3-A) Notwithstanding anything contained in clause (3), until the taking effect, under Article 170, of the re-adjustment, on the basis of the first census after the year 2026, of the number of seats in the Legislative Assemblies of the States of Arunachal Pradesh, Meghalaya, Mizoram and Nagaland, the seats which shall be reserved for the Scheduled Tribes in the Legislative Assembly of any such State shall be,\\u2014\\r\\n(a) if all the seats in the Legislative Assembly of such State in existence on the date of coming into force of the Constitution (Fifty-seventh Amendment) Act, 1987 (hereinafter in this clause referred to as the existing Assembly) are held by members of the Scheduled Tribes, all the seats except one;\\r\\n(b) in any other case, such number of seats as bears to the total number of seats, a proportion not less than the number (as on the said date) of members belonging to the Scheduled Tribes in the existing Assembly bears to the total number of seats in the existing Assembly.]\\r\\n (3-B) Notwithstanding anything contained in clause (3), until the re-adjustment, under Article 170, takes effect on the basis of the first census after the year 2026, of the number of seats in the Legislative Assembly of the State of Tripura, the seats which shall be reserved for the Scheduled Tribes in the Legislative Assembly shall be, such number of seats as bears to the total number of seats, a proportion not less than the number, as on the date of coming into force of the Constitution (Seventy-second Amendment) Act, 1992, of members belonging to the Scheduled Tribes in the Legislative Assembly in existence on the said date bears to the total number of seats in that Assembly.\\r\\n(4) The number of seats reserved for an autonomous district in the Legislative Assembly of the State of Assam shall bear to the total number of seats in that Assembly a proportion not less than the population of the district bears to the total population of the State.\\r\\n(5) The constituencies for the seats reserved for any autonomous district of Assam shall not comprise any area outside that district \\r\\n(6) No person who is not a member of a Scheduled Tribe of any autonomous district of the State of Assam shall be eligible for election to the Legislative Assembly of the State from any constituency of that district \\r\\nProvided that for elections to the Legislative Assembly of the State of Assam, the representation of the Scheduled Tribes and non-Scheduled Tribes in the constituencies included in the Bodoland Territorial Areas District, so notified, and existing prior to the constitution of the Bodoland Territorial Areas District, shall be maintained.\\r\\n\"],\"4\":[\"333. Representation of the Anglo-Indian community in the Legislative Assemblies of the States\",\"Notwithstanding anything in Article 170, the Governor  of a State may, if he is of opinion that the Anglo-Indian community needs representation in the Legislative Assembly of the State and is not adequately represented therein,  nominate one member of that community to the Assembly\"],\"5\":[\"334.  Reservation of seats and special representation to cease after certain period\",\"Notwithstanding anything in the foregoing provisions of this Part, the provisions of this Constitution relating to\\u2014\\r\\n(a) the reservation of seats for the Scheduled Castes and the Scheduled Tribes in the House of the People and in the Legislative Assemblies of the States; and\\r\\n(b) the representation of the Anglo-Indian community in the House of the People and in the Legislative Assemblies of the States by nomination,\\r\\nshall cease to have effect on the expiration of a period of eighty years in respect of clause (a) and seventy years in respect of clause (b)] from the commencement of this Constitution:\\r\\nProvided that nothing in this article shall affect any representation in the House of the People or in the Legislative Assembly of a State until the dissolution of the then existing House or Assembly, as the case may be.\\r\\n\"],\"6\":[\"335. Claims of Scheduled Castes and Scheduled Tribes to services and posts\",\"The claims of the members of the Scheduled Castes and the Scheduled Tribes shall be taken into consideration, consistently with the maintenance of efficiency of administration, in the making of appointments to services and posts in connection with the affairs of the Union or of a State:\"],\"7\":[\"336. Special provision for Anglo-Indian community in certain services\",\"(1) During the first two years after the commencement of this Constitution, appointments of members of the Anglo-Indian community to posts in the railway, customs, postal and telegraph services of the Union shall be made on the same basis as immediately before the fifteenth day of August, 1947.\\r\\nDuring every succeeding period of two years, the number of posts reserved for the members of the said community in the said services shall, as nearly as possible, be less by ten per cent than the numbers so reserved during the immediately preceding period of two years:\\r\\nProvided that at the end of ten years from the commencement of this Constitution all such reservations shall cease.\\r\\n(2) Nothing in clause (1) shall bar the appointment of members of the Anglo-Indian community to posts other than, or in addition to, those reserved for the community under that clause if such members are found qualified for appointment on merit as compared with the members of other communities.\\r\\n\"],\"8\":[\"337. Special provision with respect to educational grants for the benefit of Anglo-Indian community\",\"During the first three financial years after the commencement of this Constitution, the same grants, if any, shall be made by the Union and by each State for the benefit of the Anglo-Indian community in respect of education as were made in the financial year ending on the thirty-first day of March, 1948.\\r\\nDuring every succeeding period of three years the grants may be less by ten per cent than those for the immediately preceding period of three years:\\r\\nProvided that at the end of ten years from the commencement of this Constitution such grants, to the extent to which they are a special concession to the Anglo-Indian community, shall cease:\\r\\nProvided further that no educational institution shall be entitled to receive any grant under this article unless at least forty per cent of annual admissions therein are made available to members of communities other than the Anglo-Indian community\\r\\n\"],\"9\":[\"338.  National Commission for Scheduled Castes \",\" (1) There shall be a Commission for the Scheduled Castes to be known as the National Commission for the Scheduled Castes.\\r\\n(2) Subject to the provisions of any law made in this behalf by Parliament, the Commission shall consist of a Chairperson, Vice-Chairperson and three other Members and the conditions of service and tenure of office of the Chairperson, Vice-Chairperson and other Members so appointed shall be such as the President may by rule determine.\\r\\n(3) The Chairperson, Vice-Chairperson and other Members of the Commission shall be appointed by the President by warrant under his hand and seal.\\r\\n(4) The Commission shall have the power to regulate its own procedure.\\r\\n(5) It shall be duty of the Commission\\u2014\\r\\n(a) to investigate and monitor all matters relating to the safeguards provided for the Scheduled Castes under this Constitution or under any other law for the time being in force or under any order of the Government and to evaluate the working of such safeguards;\\r\\n(b) to inquire into specific complaints with respect to the deprivation of rights and safeguards of the Scheduled Castes \\r\\n(c) to participate and advise on the planning process of socio-economic development of the Scheduled Castes and to evaluate the progress of their development under the Union and any State;\\r\\n(d) to present to the President, annually and at such other times as the Commission may deem fit, reports upon the working of those safeguards;\\r\\n(e) to make in such report recommendations as to the measures that should be taken by the Union or any State for the effective implementation of those safeguards and other measures for the protection, welfare and socio-economic development of the Scheduled Castes and\\r\\n(f) to discharge such other functions in relation to the protection, welfare and development and advancement of the Scheduled Castes as the President may, subject to the provisions of any law made by Parliament, by rule specify.\\r\\n(6) The President shall cause all such reports to be laid before each House of Parliament along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the Union and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(7) Where any such report, or any part thereof, relates to any matter with which any State Government is concerned, a copy of such report shall be forwarded to the Governor of the State who shall cause it to be laid before the Legislature of the State along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the State and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(8) The Commission shall, while investigating any matter referred to in sub-clause (a) or inquiring into any complaint referred to in sub-clause (b) of clause (5), have all the powers of a civil court trying a suit and in particular in respect of the following matters, namely:\\u2014\\r\\n(a) summoning and enforcing the attendance of any person from any part of India and examining him on oath;\\r\\n(b) requiring the discovery and production of any document;\\r\\n(c) receiving evidence on affidavits;\\r\\n(d) requisitioning any public record or copy thereof from any court or office;\\r\\n(e) issuing commissions for the examination of witnesses and documents;\\r\\n(f) any other matter which the President may, by rule, determine.\\r\\n(9) The Union and every State Government shall consult the Commission on all major policy matters affecting Scheduled Castes \\r\\n(10) In this article references to the Scheduled Castes shall be construed as including references to the Anglo-Indian community.\\r\\n\"],\"10\":[\"338-A. National Commission for Scheduled Tribes\",\"(1) There shall be a Commission for the Scheduled Tribes to be known as the National Commission for the Scheduled Tribes.\\r\\n(2) Subject to the provisions of any law made in this behalf by Parliament, the Commission shall consist of a Chairperson, Vice-Chairperson and three other Members and the conditions of service and tenure of office of the Chairperson, Vice-Chairperson and other Members so appointed shall be such as the President may by rule determine.\\r\\n(3) The Chairperson, Vice-Chairperson and other Members of the Commission shall be appointed by the President by warrant under his hand and seal.\\r\\n(4) The Commission shall have the power to regulate its own procedure.\\r\\n(5) It shall be the duty of the Commission\\u2014\\r\\n(a) to investigate and monitor all matters relating to the safeguards provided for the Scheduled Tribes under this Constitution or under any other law for the time being in force or under any order of the Government and to evaluate the working of such safeguards;\\r\\n(b) to inquire into specific complaints with respect to the deprivation of rights and safeguards of the Scheduled Tribes;\\r\\n(c) to participate and advice on the planning process of socio-economic development of the Scheduled Tribes and to evaluate the progress of their development under the Union and any State;\\r\\n(d) to present to the President, annually and at such other times as the Commission may deem fit, reports upon the working of those safeguards;\\r\\n(e) to make in such reports recommendations as to the measures that should be taken by the Union or any State for the effective implementation of those safeguards and other measures for the protection, welfare and socio-economic development of the Scheduled Tribes; and\\r\\n(f) to discharge such other functions in relation to the protection, welfare and development and advancement of the Scheduled Tribes as the President may, subject to the provisions of any law made by Parliament, by rule specify.\\r\\n(6) The President shall cause all such reports to be laid before each House of Parliament along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the Union and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(7) Where any such report, or any part thereof, relates to any matter with which any State Government is concerned, a copy of such report shall be forwarded to the Governor of the State who shall cause it to be laid before the Legislature of the State along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the State and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(8) The Commission shall, while investigating any matter referred to in sub-clause (a) or inquiring into any complaint referred to in sub-clause (b) of clause (5), have all the powers of a civil court trying a suit and in particular in respect of the following matters, namely:\\u2014\\r\\n(a) summoning and enforcing the attendance of any person from any part of India and examining him on oath;\\r\\n(b) requiring the discovery and production of any document;\\r\\n(c) receiving evidence on affidavits;\\r\\n(d) requisitioning any public record or copy thereof from any court or office;\\r\\n(e) issuing commissions for the examination of witnesses and documents;\\r\\n(f) any other matter which the President may, by rule, determine.\\r\\n(9) The Union and every State Government shall consult the Commission on all major policy matters affecting Scheduled Tribes.\\r\\n\"],\"11\":[\"338-B. National Commission for Backward Classes\",\"(1) There shall be a Commission for the socially and educationally backward classes to be known as the National Commission for Backward Classes.\\r\\n(2) Subject to the provisions of any law made in this behalf by Parliament, the Commission shall consist of a Chairperson, Vice-Chairperson and three other Members and the conditions of service and tenure of office of the Chairperson, Vice-Chairperson and other Members so appointed shall be such as the President may by rule determine.\\r\\n(3) The Chairperson, Vice-Chairperson and other Members of the Commission shall be appointed by the President by warrant under his hand and seal.\\r\\n(4) The Commission shall have the power to regulate its own procedure.\\r\\n(5) It shall be the duty of the Commission\\u2014\\r\\n(a) to investigate and monitor all matters relating to the safeguards provided for the socially and educationally backward classes under this Constitution or under any other law for the time being in force or under any order of the Government and to evaluate the working of such safeguards;\\r\\n(b) to inquire into specific complaints with respect to the deprivation of rights and safeguards of the socially and educationally backward classes;\\r\\n(c) to participate and advise on the socio-economic development of the socially and educationally backward classes and to evaluate the progress of their development under the Union and any State;\\r\\n(d) to present to the President, annually and at such other times as the Commission may deem fit, reports upon the working of those safeguards;\\r\\n(e) to make in such reports the recommendations as to the measures that should be taken by the Union or any State for the effective implementation of those safeguards and other measures for the protection, welfare and socio-economic development of the socially and educationally backward classes; and\\r\\n(f) to discharge such other functions in relation to the protection, welfare and development and advancement of the socially and educationally backward classes as the President may, subject to the provisions of any law made by Parliament, by rule specify.\\r\\n(6) The President shall cause all such reports to be laid before each House of Parliament along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the Union and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(7) Where any such report, or any part thereof, relates to any matter with which any State Government is concerned, a copy of such report shall be forwarded to the State Government which shall cause it to be laid before the Legislature of the State along with a memorandum explaining the action taken or proposed to be taken on the recommendations relating to the State and the reasons for the non-acceptance, if any, of any of such recommendations.\\r\\n(8) The Commission shall, while investigating any matter referred to in sub-clause (a) or inquiring into any complaint referred to in sub-clause (b) of clause (5), have all the powers of a civil court trying a suit and in particular in respect of the following matters, namely\\u2014\\r\\n(a) summoning and enforcing the attendance of any person from any part of India and examining him on oath;\\r\\n(b) requiring the discovery and production of any document;\\r\\n(c) receiving evidence on affidavits;\\r\\n(d) requisitioning any public record or copy thereof from any court or office;\\r\\n(e) issuing commissions for the examination of witnesses and documents;\\r\\n(f) any other matter which the President may, by rule, determine.\\r\\n(9) The Union and every State Government shall consult the Commission on all major policy matters affecting the socially and educationally backward classes\\r\\n\"],\"12\":[\"339. Control of the Union over the administration of Scheduled Areas and the welfare of Scheduled Tribes\",\"(1) The President may at any time and shall, at the expiration of ten years from the commencement of this Constitution by order appoint a Commission to report on the administration of the Scheduled Areas and the welfare of the Scheduled Tribes in the States \\r\\nThe order may define the composition, powers and procedure of the Commission and may contain such incidental or ancillary provisions as the President may consider necessary or desirable.\\r\\n(2) The executive power of the Union shall extend to the giving of directions to a State as to the drawing up and execution of schemes specified in the direction to be essential for the welfare of the Scheduled Tribes in the State.\\r\\n\"],\"13\":[\"340. Appointment of a Commission to investigate the conditions of backward classes\",\"(1) The President may by order appoint a Commission consisting of such persons as he thinks fit to investigate the conditions of socially and educationally backward classes within the territory of India and the difficulties under which they labour and to make recommendations as to the steps that should be taken by the Union or any State to remove such difficulties and to improve their condition and as to the grants that should be made for the purpose by the Union or any State and the conditions subject to which such grants should be made, and the order appointing such Commission shall define the procedure to be followed by the Commission.\\r\\n(2) A Commission so appointed shall investigate the matters referred to them and present to the President a report setting out the facts as found by them and making such recommendations as they think proper.\\r\\n(3) The President shall cause a copy of the report so presented together with a memorandum explaining the action taken thereon to be laid before each House of Parliament.\\r\\n\"],\"14\":[\"341. Scheduled Castes\",\"(1) The President may with respect to any State or Union Territory, and where it is a State after consultation with the Governor thereof by public notification, specify the castes, races or tribes or parts of or groups within castes, races or tribes which shall for the purposes of this Constitution be deemed to be Scheduled Castes in relation to that State or Union territory, as the case may be\\r\\n(2) Parliament mayby law include in or exclude from the list of Scheduled Castes specified in a notification issued under clause (1) any caste, race or tribe or part of or group within any caste, race or tribe, but save as aforesaid a notification issued under the said clause shall not be varied by any subsequent notification.\\r\\n\"],\"15\":[\"342. Scheduled Tribes\",\"(1) The President may with respect to any State or Union territory, and where it is a State , after consultation with the Governor thereof, by public notification, specify the tribes or tribal communities or parts of or groups within tribes or tribal communities which shall for the purposes of this Constitution be deemed to be Scheduled Tribes in relation to that State or Union territory, as the case may be.\\r\\n(2) Parliament may by law include in or exclude from the list of Scheduled Tribes specified in a notification issued under clause (1) any tribe or tribal community or part of or group within any tribe or tribal community, but save as aforesaid a notification issued under the said clause shall not be varied by any subsequent notification.\\r\\n\"],\"16\":[\" 342-A. Socially and educationally backward classes\",\"(1) The President may with respect to any State or Union territory, and where it is a State, after consultation with the Governor thereof, by public notification, specify the socially and educationally backward classes which shall for the purposes of this Constitution be deemed to be socially and educationally backward classes in relation to that State or Union territory, as the case may be.\\r\\n(2) Parliament may by law include in or exclude from the Central List of socially and educationally backward classes specified in a notification issued under clause (1) any socially and educationally backward class, but save as aforesaid a notification issued under the said clause shall not be varied by any subsequent notification.\"]}', 1, '2021-02-01 02:29:57', '2021-02-01 02:45:40'),
(64, '26APRYLN99U4ZWNBTiPDKsmJD', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVII CHAPTER 1', 'OFFICIAL LANGUAGE', '', '', '{\"1\":[\"343. Official language of the Union\",\"(1) The official language of the Union shall be Hindi in Devanagari script.\\r\\nThe form of numerals to be used for the official purposes of the Union shall be the international form of Indian numerals.\\r\\n(2) Notwithstanding anything in clause (1), for a period of fifteen years from the commencement of this Constitution, the English language shall continue to be used for all the official purposes of the Union for which it was being used immediately before such commencement:\\r\\nProvided that the President may, during the said period, by order authorise the use of the Hindi language in addition to the English language and of the Devanagari form of numerals in addition to the international form of Indian numerals for any of the official purposes of the Union.\\r\\n(3) Notwithstanding anything in this article, Parliament may by law provide for the use, after the said period of fifteen years, of\\u2014\\r\\n(a) the English language, or\\r\\n(b) the Devanagari form of numerals,\\r\\nfor such purposes as may be specified in the law.\\r\\n\"],\"2\":[\"344. Commission and Committee of Parliament on official language\",\"(1) The President shall, at the expiration of five years from the commencement of this Constitution and thereafter at the expiration of ten years from such commencement, by order constitute a Commission which shall consist of a Chairman and such other members representing the different languages specified in the Eighth Schedule as the President may appoint, and the order shall define the procedure to be followed by the Commission.\\r\\n(2) It shall be the duty of the Commission to make recommendations to the President as to\\u2014\\r\\n(a) the progressive use of the Hindi language for the official purposes of the Union;\\r\\n(b) restrictions on the use of the English language for all or any of the official purposes of the Union;\\r\\n(c) the language to be used for all or any of the purposes mentioned in Article 348;\\r\\n(d) the form of numerals to be used for any one or more specified purposes of the Union;\\r\\n(e) any other matter referred to the Commission by the President as regards the official language of the Union and the language for communication between the Union and a State or between one State and another and their use.\\r\\n(3) In making their recommendations under clause (2), the Commission shall have due regard to the industrial, cultural and scientific advancement of India, and the just claims and the interests of persons belonging to the non-Hindi speaking areas in regard to the public services.\\r\\n(4) There shall be constituted a Committee consisting of thirty members, of whom twenty shall be members of the House of the People and ten shall be members of the Council of States to be elected respectively by the members of the House of the People and the members of the Council of States in accordance with the system of proportional representation by means of the single transferable vote.\\r\\n(5) It shall be the duty of the Committee to examine the recommendations of the Commission constituted under clause (1) and to report to the President their opinion thereon.\\r\\n(6) Notwithstanding anything in Article 343, the President may, after consideration of the report referred to in clause (5), issue directions in accordance with the whole or any part of that report.\\r\\n\"]}', 1, '2021-02-01 02:47:03', '2021-02-01 02:47:51'),
(65, 'slhhVCmsFseggIrnPsB1exMmI', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVII CHAPTER 2', 'REGIONAL LANGUAGES', '', '', '{\"1\":[\"345. Official language or languages of a State\",\". Subject to the provisions of Articles 346 and 347, the Legislature of a State may by law adopt any one or more of the languages in use in the State or Hindi as the language or languages to be used for all or any of the official purposes of that State:\\r\\nProvided that, until the Legislature of the State otherwise provides by law, the English language shall continue to be used for those official purposes within the State for which it was being used immediately before the commencement of this Constitution.\\r\\n\"],\"2\":[\"346. Official language for communication between one State and another or between a State and the Union\",\"The language for the time being authorised for use in the Union for official purposes shall be the official language for communication between one State and another State and between a State and the Union:\\r\\nProvided that if two or more States agree that the Hindi language should be the official language for communication between such States, that language may be used for such communication.\\r\\n\"],\"3\":[\"347. Special provision relating to language spoken by a section of the population of a State\",\"On a demand being made in that behalf the President may, if he is satisfied that a substantial proportion of the population of a State desire the use of any language spoken by them to be recognised by that State, direct that such language shall also be officially recognised throughout that State or any part thereof for such purpose as he may specify\"]}', 1, '2021-02-01 02:48:45', '2021-02-01 02:49:29'),
(66, 'LQCM776ERt9RU9edqxpddBgSs', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVII CHAPTER 3', 'LANGUAGE OF THE SUPREME COURT, HIGH COURTS, ETC.', '', '', '{\"1\":[\"348. Language to be used in the Supreme Court and in the High Courts and for Acts, Bills, etc\",\"(1) Notwithstanding anything in the foregoing provisions of this Part, until Parliament by law otherwise provides\\u2014\\r\\n(a) all proceedings in the Supreme Court and in every High Court,\\r\\n(b) the authoritative texts\\u2014\\r\\n(i) of all Bills to be introduced or amendments thereto to be moved in either House of Parliament or in the House or either House of the Legislature of a State,\\r\\n(ii) of all Acts passed by Parliament or the Legislature of a State and of all Ordinances promulgated by the President or the Governor  of a State, and\\r\\n(iii) of all orders, rules, regulations and bye-laws issued under this Constitution or under any law made by Parliament or the Legislature of a State,\\r\\nshall be in the English language.\\r\\n(2) Notwithstanding anything in sub-clause (a) of clause (1), the Governor  of a State may, with the previous consent of the President, authorise the use of the Hindi language, or any other language used for any official purposes of the State, in proceedings in the High Court having its principal seat in that State:\\r\\nProvided that nothing in this clause shall apply to any judgment, decree or order passed or made by such High Court.\\r\\n(3) Notwithstanding anything in sub-clause (b) of clause (1), where the Legislature of a State has prescribed any language other than the English language for use in Bills introduced in, or Acts passed by, the Legislature of the State or in Ordinances promulgated by the Governor  of the State or in any order, rule, regulation or bye-law referred to in paragraph (iii) of that sub-clause, a translation of the same in the English language published under the authority of the Governor of the State in the Official Gazette of that State shall be deemed to be the authoritative text thereof in the English language under this article.\\r\\n\"],\"2\":[\"349. Special procedure for enactment of certain laws relating to language\",\"During the period of fifteen years from the commencement of this Constitution, no Bill or amendment making provision for the language to be used for any of the purposes mentioned in clause (1) of Article 348 shall be introduced or moved in either House of Parliament without the previous sanction of the President, and the President shall not give his sanction to the introduction of any such Bill or the moving of any such amendment except after he has taken into consideration the recommendations of the Commission constituted under clause (1) of Article 344 and the report of the Committee constituted under clause (4) of that article.\"]}', 1, '2021-02-01 02:51:12', '2021-02-01 02:51:55'),
(67, 'ClPNQaStZTtgucik8S0MYTc9d', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVII CHAPTER 4', 'SPECIAL DIRECTIVES', '', '', '{\"1\":[\"350. Language to be used in representations for redress of grievances\",\"Every person shall be entitled to submit a representation for the redress of any grievance to any officer or authority of the Union or a State in any of the languages used in the Union or in the State, as the case may be.\"],\"2\":[\"350-A. Facilities for instruction in mother-tongue at primary stage\",\"It shall be the endeavour of every State and of every local authority within the State to provide adequate facilities for instruction in the mother-tongue at the primary stage of education to children belonging to linguistic minority groups; and the President may issue such directions to any State as he considers necessary or proper for securing the provision of such facilities.\"],\"3\":[\"350-B. Special Officer for linguistic minorities\",\"(1) There shall be a Special Officer for linguistic minorities to be appointed by the President.\\r\\n(2) It shall be the duty of the Special Officer to investigate all matters relating to the safeguards provided for linguistic minorities under this Constitution and report to the President upon those matters at such intervals as the President may direct, and the President shall cause all such reports to be laid before each House of Parliament, and sent to the Governments of the States concerned\\r\\n\"],\"4\":[\"351. Directive for development of the Hindi language\",\"It shall be the duty of the Union to promote the spread of the Hindi language, to develop it so that it may serve as a medium of expression for all the elements of the composite culture of India and to secure its enrichment by assimilating without interfering with its genius, the forms, style and expressions used in Hindustani and in the other languages of India specified in the Eighth Schedule, and by drawing, wherever necessary or desirable, for its vocabulary, primarily on Sanskrit and secondarily on other languages.\\r\\n  \\r\\n\"]}', 1, '2021-02-01 02:52:55', '2021-02-01 02:54:18');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(68, 'rIn4y16RB0UyOEIHRrf1AQ2qn', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XVIII ', ' EMERGENCY PROVISIONS', '', '', '{\"1\":[\"352. Proclamation of Emergency\",\"(1) If the President is satisfied that a grave emergency exists whereby the security of India or of any part of the territory thereof is threatened, whether by war or external aggression or armed rebellion, he may, by Proclamation, make a declaration to that effect 485[in respect of the whole of India or of such part of the territory thereof as may be specified in the Proclamation].\\r\\n(2) A Proclamation issued under clause (1) may be varied or revoked by a subsequent Proclamation.\\r\\n(3) The President shall not issue a Proclamation under clause (1) or a Proclamation varying such Proclamation unless the decision of the Union Cabinet (that is to say, the Council consisting of the Prime Minister and other Ministers of Cabinet rank under Article 75 that such a Proclamation may be issued has been communicated to him in writing.\\r\\n(4) Every Proclamation issued under this article shall be laid before each House of Parliament and shall, except where it is a Proclamation revoking a previous Proclamation, cease to operate at the expiration of one month unless before the expiration of that period it has been approved by resolutions of both Houses of Parliament:\\r\\nProvided that if any such Proclamation (not being a Proclamation revoking a previous Proclamation) is issued at a time when the House of the People has been dissolved, or the dissolution of the House of the People takes place during the period of one month referred to in this clause, and if a resolution approving the Proclamation has been passed by the Council of States, but no resolution with respect to such Proclamation has been passed by the House of the People before the expiration of that period, the Proclamation shall cease to operate at the expiration of thirty days from the date on which the House of the People first sits after its reconstitution, unless before the expiration of the said period of thirty days a resolution approving the Proclamation has been also passed by the House of the People.\\r\\n(5) A Proclamation so approved shall, unless revoked, cease to operate on the expiration of a period of six months from the date of the passing of the second of the resolutions approving the Proclamation under clause (4):\\r\\nProvided that if and so often as a resolution approving the continuance in force of such a Proclamation is passed by both Houses of Parliament the Proclamation shall, unless revoked, continue in force for a further period of six months from the date on which it would otherwise have ceased to operate under this clause:\\r\\nProvided further that if the dissolution of the House of the People takes place during any such period of six months and a resolution approving the continuance in force of such Proclamation has been passed by the Council of States but no resolution with respect to the continuance in force of such Proclamation has been passed by the House of the People during the said period, the Proclamation shall cease to operate at the expiration of thirty days from the date on which the House of the People first sits after its reconstitution unless before the expiration of the said period of thirty days, a resolution approving the continuance in force of the Proclamation has been also passed by the House of the People.\\r\\n(6) For the purposes of clauses (4) and (5), a resolution may be passed by either House of Parliament only by a majority of the total membership of that House and by a majority of not less than two-thirds of the members of that House present and voting.\\r\\n(7) Notwithstanding anything contained in the foregoing clauses, the President shall revoke a Proclamation issued under clause (1) or a Proclamation varying such Proclamation if the House of the People passes a resolution disapproving, or, as the case may be, disapproving the continuance in force of, such Proclamation.\\r\\n(8) Where a notice in writing signed by not less than one-tenth of the total number of members of the House of the People has been given, of their intention to move a resolution for disapproving, or, as the case may be, for disapproving the continuance in force of, a Proclamation issued under clause (1) or a Proclamation varying such Proclamation,\\u2014\\r\\n(a) to the Speaker, if the House is in session; or\\r\\n(b) to the President, if the House is not in session,\\r\\na special sitting of the House shall be held within fourteen days from the date on which such notice is received by the Speaker, or, as the case may be, by the President, for the purpose of considering such resolution.\\r\\n(9) The power conferred on the President by this article shall include the power to issue different Proclamations on different grounds, being war or external aggression or armed rebellion} or imminent danger of war or external aggression or armed rebellion, whether or not there is a Proclamation already issued by the President under clause (1) and such Proclamation is in operation\\r\\n\"],\"2\":[\"353. Effect of Proclamation of Emergency\",\"While a Proclamation of Emergency is in operation, then\\u2014\\r\\n(a) notwithstanding anything in this Constitution, the executive power of the Union shall extend to the giving of directions to any State as to the manner in which the executive power thereof is to be exercised;\\r\\n(b) the power of Parliament to make laws with respect to any matter shall include power to make laws conferring powers and imposing duties, or authorising the conferring of powers and the imposition of duties, upon the Union or officers and authorities of the Union as respects that matter, notwithstanding that it is one which is not enumerated in the Union List:\\r\\n\"],\"3\":[\"354. Application of provisions relating to distribution of revenues while a Proclamation of Emergency is in operation\",\"(1) The President may, while a Proclamation of Emergency is in operation, by order direct that all or any of the provisions of Articles 268 to 279 shall for such period, not extending in any case beyond the expiration of the financial year in which such Proclamation ceases to operate, as may be specified in the order, have effect subject to such exceptions or modifications as he thinks fit.\\r\\n(2) Every order made under clause (1) shall, as soon as may be after it is made, be laid before each House of Parliament.\\r\\n\"],\"4\":[\"355. Duty of the Union to protect States against external aggression and internal disturbance\",\"It shall be the duty of the Union to protect every State against external aggression and internal disturbance and to ensure that the government of every State is carried on in accordance with the provisions of this Constitution\"],\"5\":[\"356. Provisions in case of failure of constitutional machinery in States\",\" (1) If the President, on receipt of a report from the Governor  of a State or otherwise, is satisfied that a situation has arisen in which the government of the State cannot be carried on in accordance with the provisions of this Constitution, the President may by Proclamation\\u2014\\r\\n(a) assume to himself all or any of the functions of the Government of the State and all or any of the powers vested in or exercisable by the Governor or any body or authority in the State other than the Legislature of the State;\\r\\n(b) declare that the powers of the Legislature of the State shall be exercisable by or under the authority of Parliament;\\r\\n(c) make such incidental and consequential provisions as appear to the President to be necessary or desirable for giving effect to the objects of the Proclamation, including provisions for suspending in whole or in part the operation of any provisions of this Constitution relating to any body or authority in the State:\\r\\nProvided that nothing in this clause shall authorise the President to assume to himself any of the powers vested in or exercisable by a High Court, or to suspend in whole or in part the operation of any provision of this Constitution relating to High Courts.\\r\\n(2) Any such Proclamation may be revoked or varied by a subsequent Proclamation.\\r\\n(3) Every Proclamation under this article shall be laid before each House of Parliament and shall, except where it is a Proclamation revoking a previous Proclamation, cease to operate at the expiration of two months unless before the expiration of that period it has been approved by resolutions of both Houses of Parliament:\\r\\nProvided that if any such Proclamation (not being a Proclamation revoking a previous Proclamation) is issued at a time when the House of the People is dissolved or the dissolution of the House of the People takes place during the period of two months referred to in this clause, and if a resolution approving the Proclamation has been passed by the Council of States, but no resolution with respect to such Proclamation has been passed by the House of the People before the expiration of that period, the Proclamation shall cease to operate at the expiration of thirty days from the date on which the House of the People first sits after its reconstitution unless before the expiration of the said period of thirty days a resolution approving the Proclamation has been also passed by the House of the People.\\r\\n(4) A Proclamation so approved shall, unless revoked, cease to operate on the expiration of a period of six months from the date of issue of the Proclamation\\r\\n(5) Notwithstanding anything contained in clause (4), a resolution with respect to the continuance in force of a Proclamation approved under clause (3) for any period beyond the expiration of one year from the date of issue of such Proclamation shall not be passed by either House of Parliament unless\\u2014\\r\\n(a) a Proclamation of Emergency is in operation, in the whole of India or, as the case may be, in the whole or any part of the State, at the time of the passing of such resolution, and\\r\\n(b) the Election Commission certifies that the continuance in force of the Proclamation approved under clause (3) during the period specified in such resolution is necessary on account of difficulties in holding general elections to the Legislative Assembly of the State concerned:\\r\\n\"],\"6\":[\"357. Exercise of legislative powers under Proclamation issued under Article 356\",\"(1) Where by a Proclamation issued under clause (1) of Article 356, it has been declared that the powers of the Legislature of the State shall be exercisable by or under the authority of Parliament, it shall be competent\\u2014\\r\\n(a) for Parliament to confer on the President the power of the Legislature of the State to make laws, and to authorise the President to delegate, subject to such conditions as he may think fit to impose, the power so conferred to any other authority to be specified by him in that behalf;\\r\\n(b) for Parliament, or for the President or other authority in whom such power to make laws is vested under sub-clause (a), to make laws conferring powers and imposing duties, or authorising the conferring of powers and the imposition of duties, upon the Union or officers and authorities thereof:\\r\\n(c) for the President to authorise when the House of the People is not in session expenditure from the Consolidated Fund of the State pending the sanction of such expenditure by Parliament.\\r\\n(2) Any law made in exercise of the power of the Legislature of the State by Parliament or the President or other authority referred to in sub-clause (a) of clause (1) which Parliament or the President or such other authority would not, but for the issue of a Proclamation under Article 356, have been competent to make shall, after the Proclamation has ceased to operate, continue in force until altered or repealed or amended by a competent Legislature or other authority.\\r\\n\"],\"7\":[\"358. Suspension of provisions of Article 19 during emergencies\",\"(1) While a Proclamation of Emergency declaring that the security of India or any part of the territory thereof is threatened by war or by external aggression is in operation, nothing in Article 19 shall restrict the power of the State as defined in Part III to make any law or to take any executive action which the State would but for the provisions contained in that Part be competent to make or to take, but any law so made shall, to the extent of the incompetency, cease to have effect as soon as the Proclamation ceases to operate, except as respects things done or omitted to be done before the law so ceases to have effect\\r\\n(2) Nothing in clause (1) shall apply\\u2014\\r\\n(a) to any law which does not contain a recital to the effect that such law is in relation to the Proclamation of Emergency in operation when it is made; or\\r\\n(b) to any executive action taken otherwise than under a law containing such a recital\\r\\n\"],\"8\":[\"359. Suspension of the enforcement of the rights conferred by Part III during emergencies\",\"(1) Where a Proclamation of Emergency is in operation, the President may by order declare that the right to move any court for the enforcement of such of the rights conferred by Part III except Articles 20 and 21as may be mentioned in the order and all proceedings pending in any court for the enforcement of the rights so mentioned shall remain suspended for the period during which the Proclamation is in force or for such shorter period as may be specified in the order.\\r\\n(1-A) While an order made under clause (1) mentioning any of  the rights conferred by Part III except Articles 20 and 21 is in operation, nothing in that Part conferring those rights shall restrict the power of the State as defined in the said Part to make any law or to take any executive action which the State would but for the provisions contained in that Part be competent to make or to take, but any law so made shall, to the extent of the incompetency, cease to have effect as soon as the order aforesaid ceases to operate, except as respects things done or omitted to be done before the law so ceases to have effect\\r\\n(1-B) Nothing in clause (1-A) shall apply\\u2014\\r\\n(a) to any law which does not contain a recital to the effect that such law is in relation to the Proclamation of Emergency in operation when it is made; or\\r\\n(b) to any executive action taken otherwise than under a law containing such a recital.\\r\\n(2) An order made as aforesaid may extend to the whole or any part of the territory of India:\\r\\n(3) Every order made under clause (1) shall, as soon as may be after it is made, be laid before each House of Parliament\\r\\n\"],\"9\":[\"359-A. Application of this Part to the State of Punjab\",\"Repealed by the Constitution (Sixty-third Amendment) Act, 1989, S. 3 \"],\"10\":[\"360. Provisions as to financial emergency\",\"(1) If the President is satisfied that a situation has arisen whereby the financial stability or credit of India or of any part of the territory thereof is threatened, he may by a Proclamation make a declaration to that effect.\\r\\n (2) A Proclamation issued under clause (1)\\u2014\\r\\n(a) may be revoked or varied by a subsequent Proclamation;\\r\\n(b) shall be laid before each House of Parliament;\\r\\n(c) shall cease to operate at the expiration of two months, unless before the expiration of that period it has been approved by resolutions of both Houses of Parliament:\\r\\n(3) During the period any such Proclamation as is mentioned in clause (1) is in operation, the executive authority of the Union shall extend to the giving of directions to any State to observe such canons of financial propriety as may be specified in the directions, and to the giving of such other directions as the President may deem necessary and adequate for the purpose.\\r\\n(4) Notwithstanding anything in this Constitution\\u2014\\r\\n(a) any such direction may include\\u2014\\r\\n(i) a provision requiring the reduction of salaries and allowances of all or any class of persons serving in connection with the affairs of a State;\\r\\n(ii) a provision requiring all Money Bills or other Bills to which the provisions of Article 207 apply to be reserved for the consideration of the President after they are passed by the Legislature of the State;\\r\\n(b) it shall be competent for the President during the period any Proclamation issued under this article is in operation to issue directions for the reduction of salaries and allowances of all or any class of persons serving in connection with the affairs of the Union including the Judges of the Supreme Court and the High Courts.\\r\\n\"]}', 1, '2021-02-01 02:56:20', '2021-02-01 03:04:46'),
(70, 'CLZSZkmklBPdXU88QAyB8vAGF', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XIX ', 'MISCELLANEOUS', '', '', '{\"1\":[\"361. Protection of President and Governors and Rajpramukhs\",\"(1) The President, or the Governor or Rajpramukh of a State, shall not be answerable to any court for the exercise and performance of the powers and duties of his office or for any act done or purporting to be done by him in the exercise and performance of those powers and duties:\\r\\nProvided that the conduct of the President may be brought under review by any court, tribunal or body appointed or designated by either House of Parliament for the investigation of a charge under Article 61:\\r\\nProvided further that nothing in this clause shall be construed as restricting the right of any person to bring appropriate proceedings against the Government of India or the Government of a State.\\r\\n(2) No criminal proceedings whatsoever shall be instituted or continued against the President, or the Governor of a State, in any court during his term of office.\\r\\n(3) No process for the arrest or imprisonment of the President, or the Governor of a State, shall issue from any court during his term of office.\\r\\n(4) No civil proceedings in which relief is claimed against the President, or the Governor of a State, shall be instituted during his term of office in any court in respect of any act done or purporting to be done by him in his personal capacity, whether before or after he entered upon his office as President, or as Governor of such State, until the expiration of two months next after notice in writing has been delivered to the President or the Governor as the case may be, or left at his office stating the nature of the proceedings, the cause of action therefor, the name, description and place of residence of the party by whom such proceedings are to be instituted and the relief which he claims.\\r\\n\"],\"2\":[\"361-A. Protection of publication of proceedings of Parliament and State Legislatures\",\"(1) No person shall be liable to any proceedings, civil or criminal, in any court in respect of the publication in a newspaper of a substantially true report of any proceedings of either House of Parliament or the Legislative Assembly, or, as the case may be, either House of the Legislature, of a State, unless the publication is proved to have been made with malice:\\r\\nProvided that nothing in this clause shall apply to the publication of any report of the proceedings of a secret sitting of either House of Parliament or the Legislative Assembly, or, as the case may be, either House of the Legislature, of a State.\\r\\n(2) Clause (1) shall apply in relation to reports or matters broadcast by means of wireless telegraphy as part of any programme or service provided by means of a broadcasting station as it applies in relation to reports or matters published in a newspaper.\\r\\n\"],\"3\":[\"361-B. Disqualification for appointment on remunerative political post\",\"A member of a House belonging to any political party who is disqualified for being a member of the House under Paragraph 2 of the Tenth Schedule shall also be disqualified to hold any remunerative political post for duration of the period commencing from the date of his disqualification till the date on which the term of his office as such member would expire or till the date on which he contests an election to a House and is declared elected, whichever is earlier.\"],\"4\":[\"362. Rights and privileges of Rulers of Indian States\",\"Rep. by the Constitution (Twenty-sixth Amendment) Act, 1971, S. 2\"],\"5\":[\"363. Bar to interference by courts in disputes arising out of certain treaties, agreements, etc\",\"(1) Notwithstanding anything in this Constitution but subject to the provisions of Article 143, neither the Supreme Court nor any other court shall have jurisdiction in any dispute arising out of any provision of a treaty, agreement, covenant, engagement, sanad or other similar instrument which was entered into or executed before the commencement of this Constitution by any Ruler of an Indian State and to which the Government of the Dominion of India or any of its predecessor Governments was a party and which has or has been continued in operation after such commencement, or in any dispute in respect of any right accruing under or any liability or obligation arising out of any of the provisions of this Constitution relating to any such treaty, agreement, covenant, engagement, sanad or other similar instrument.\\r\\n(2) In this article\\u2014\\r\\n(a) \\u201cIndian State\\u201d means any territory recognised before the commencement of this Constitution by His Majesty or the Government of the Dominion of India as being such a State; and\\r\\n(b) \\u201cRuler\\u201d includes the Prince, Chief or other person recognised before such commencement by His Majesty or the Government of the Dominion of India as the Ruler of any Indian State.\\r\\n\"],\"6\":[\"363-A. Recognition granted to Rulers of Indian States to cease and privy purses to be abolished\",\"Notwithstanding anything in this Constitution or in any law for the time being in force\\u2014\\r\\n(a) the Prince, Chief or other person who, at any time before the commencement of the Constitution (Twenty-sixth Amendment) Act, 1971, was recognised by the President as the Ruler of an Indian State or any person who, at any time before such commencement, was recognised by the President as the successor of such Ruler shall, on and from such commencement, cease to be recognised as such Ruler or the successor of such Ruler;\\r\\n(b) on and from the commencement of the Constitution (Twenty-sixth Amendment) Act, 1971, privy purse is abolished and all rights, liabilities and obligations in respect of privy purse are extinguished and accordingly the Ruler or, as the case may be, the successor of such Ruler, referred to in clause (a) or any other person shall not be paid any sum as privy purse.\\r\\n\"],\"7\":[\"364. Special provisions as to major ports and aerodromes\",\"(1) Notwithstanding anything in this Constitution, the President may by public notification direct that as from such date as may be specified in the notification\\u2014\\r\\n(a) any law made by Parliament or by the Legislature of a State shall not apply to any major port or aerodrome or shall apply thereto subject to such exceptions or modifications as may be specified in the notification, or\\r\\n(b) any existing law shall cease to have effect in any major port or aerodrome except as respects things done or omitted to be done before the said date, or shall in its application to such port or aerodrome have effect subject to such exceptions or modifications as may be specified in the notification.\\r\\n(2) In this article\\u2014\\r\\n(a) \\u201cmajor port\\u201d means a port declared to be a major port by or under any law made by Parliament or any existing law and includes all areas for the time being included within the limits of such port;\\r\\n(b) \\u201caerodrome\\u201d means aerodrome as defined for the purposes of the enactments relating to airways, aircraft and air navigation.\\r\\n\"],\"8\":[\"365. Effect of failure to comply with, or to give effect to, directions given by the Union\",\"Where any State has failed to comply with, or to give effect to, any directions given in the exercise of the executive power of the Union under any of the provisions of this Constitution, it shall be lawful for the President to hold that a situation has arisen in which the government of the State cannot be carried on in accordance with the provisions of this Constitution\"],\"9\":[\"366. Definitions\",\"In this Constitution, unless the context otherwise requires, the following expressions have the meanings hereby respectively assigned to them, that is to say\\u2014\\r\\n(1) \\u201cagricultural income\\u201d means agricultural income as defined for the purposes of the enactments relating to Indian income tax;\\r\\n(2) \\u201can Anglo-Indian\\u201d means a person whose father or any of whose other male progenitors in the male line is or was of European descent but who is domiciled within the territory of India and is or was born within such territory of parents habitually resident therein and not established there for temporary purposes only;\\r\\n(3) \\u201carticle\\u201d means an article of this Constitution;\\r\\n(4) \\u201cborrow\\u201d includes the raising of money by the grant of annuities, and \\u201cloan\\u201d shall be construed accordingly;\\r\\n(4-A)  * *\\r\\n(5) \\u201cclause\\u201d means a clause of the article in which the expression occurs;\\r\\n(6) \\u201ccorporation tax\\u201d means any tax on income, so far as that tax is payable by companies and is a tax in the case of which the following conditions are fulfilled:\\u2014\\r\\n(a) that it is not chargeable in respect of agricultural income;\\r\\n(b) that no deduction in respect of the tax paid by companies is, by any enactments which may apply to the tax, authorised to be made from dividends payable by the companies to individuals;\\r\\n(c) that no provision exists for taking the tax so paid into account in computing for the purposes of Indian income tax the total income of individuals receiving such dividends, or in computing the Indian income tax payable by, or refundable to, such individuals;\\r\\n(7) \\u201ccorresponding Province\\u201d, \\u201ccorresponding Indian State\\u201d or \\u201ccorresponding State\\u201d means in cases of doubt such Province, Indian State or State as may be determined by the President to be the corresponding Province, the corresponding Indian State or the corresponding State, as the case may be, for the particular purpose in question;\\r\\n(8) \\u201cdebt\\u201d includes any liability in respect of any obligation to repay capital sums by way of annuities and any liability under any guarantee, and \\u201cdebt charges\\u201d shall be construed accordingly;\\r\\n(9) \\u201cestate duty\\u201d means a duty to be assessed on or by reference to the principal value, ascertained in accordance with such rules as may be prescribed by or under laws made by Parliament or the Legislature of a State relating to the duty, of all property passing upon death or deemed, under the provisions of the said laws, so to pass;\\r\\n(10) \\u201cexisting law\\u201d means any law, Ordinance, order, bye-law, rule or regulation passed or made before the commencement of this Constitution by any Legislature, authority or person having power to make such a law, Ordinance, order, bye-law, rule or regulation;\\r\\n(11) \\u201cFederal Court\\u201d means the Federal Court constituted under the Government of India Act, 1935;\\r\\n(12) \\u201cgoods\\u201d includes all materials, commodities and articles;\\r\\n (12-A) \\u201cgoods and services tax\\u201d means any tax on supply of goods, or services or both except taxes on the supply of the alcoholic liquor for human consumption\\r\\n(13) \\u201cguarantee\\u201d includes any obligation undertaken before the commencement of this Constitution to make payments in the event of the profits of an undertaking falling short of a specified amount;\\r\\n(14) \\u201cHigh Court\\u201d means any court which is deemed for the purposes of this Constitution to be a High Court for any State and includes\\u2014\\r\\n(a) any Court in the territory of India constituted or reconstituted under this Constitution as a High Court, and\\r\\n(b) any other Court in the territory of India which may be declared by Parliament by law to be a High Court for all or any of the purposes of this Constitution;\\r\\n(15) \\u201cIndian State\\u201d means any territory which the Government of the Dominion of India recognised as such a State;\\r\\n(16) \\u201cPart\\u201d means a part of this Constitution;\\r\\n(17) \\u201cpension\\u201d means a pension, whether contributory or not, of any kind whatsoever payable to or in respect of any person, and includes retired pay so payable; a gratuity so payable and any sum or sums so payable by way of the return, with or without interest thereon or any other addition thereto, of subscriptions to a provident fund;\\r\\n(18) \\u201cProclamation of Emergency\\u201d means a Proclamation issued under clause (1) of Article 352;\\r\\n(19) \\u201cpublic notification\\u201d means a notification in the Gazette of India, or, as the case may be, the Official Gazette of a State;\\r\\n(20) \\u201crailway\\u201d does not include\\u2014\\r\\n(a) a tramway wholly within a municipal area, or\\r\\n(b) any other line of communication wholly situate in one State and declared by Parliament by law not to be a railway;\\r\\n(21 [* * *]\\r\\n (22) \\u201cRuler\\u201d means the Prince, Chief or other person who, at any time before the commencement of the Constitution (Twenty-sixth Amendment) Act, 1971, was recognised by the President as the Ruler of an Indian State or any person who, at any time before such commencement, was recognised by the President as the successor of such Ruler;]\\r\\n(23) \\u201cSchedule\\u201d means a Schedule to this Constitution;\\r\\n(24) \\u201cScheduled Castes\\u201d means such castes, races or tribes or parts of or groups within such castes, races or tribes as are deemed under Article 341 to be Scheduled Castes for the purposes of this Constitution;\\r\\n(25) \\u201cScheduled Tribes\\u201d means such tribes or tribal communities or parts of or groups within such tribes or tribal communities as are deemed under Article 342 to be Scheduled Tribes for the purposes of this Constitution;\\r\\n(26) \\u201csecurities\\u201d includes stock;\\r\\n (26-A) \\u201cServices\\u201d means anything other than goods;\\r\\n(26-B) \\u201cState\\u201d with reference to Articles 246-A, 268, 269, 269-A and Article 279-A includes a Union territory with Legislature;]\\r\\n(26-C) \\u201csocially and educationally backward classes\\u201d means such backward classes as are so deemed under Article 342-A for the purposes of this Constitution;]\\r\\n(27) \\u201csub-clause\\u201d means a sub-clause of the clause in which the expression occurs;\\r\\n(28) \\u201ctaxation\\u201d includes the imposition of any tax or impost, whether general or local or special, and \\u201ctax\\u201d shall be construed accordingly;\\r\\n(29) \\u201ctax on income\\u201d includes a tax in the nature of an excess profits tax;\\r\\n(29-A) \\u201ctax on the sale or purchase of goods\\u201d includes\\u2014\\r\\n(a) a tax on the transfer, otherwise than in pursuance of a contract, of property in any goods for cash, deferred payment or other valuable consideration;\\r\\n(b) a tax on the transfer of property in goods (whether as goods or in some other form) involved in the execution of a works contract;\\r\\n(c) a tax on the delivery of goods on hire-purchase or any system of payment by instalments;\\r\\n(d) a tax on the transfer of the right to use any goods for any purpose (whether or not for a specified period) for cash, deferred payment or other valuable consideration;\\r\\n(e) a tax on the supply of goods by any unincorporated association or body of persons to a member thereof for cash, deferred payment or other valuable consideration;\\r\\n(f) a tax on the supply, by way of or as part of any service or in any other manner whatsoever, of goods, being food or any other article for human consumption or any drink (whether or not intoxicating), where such supply or service, is for cash, deferred payment or other valuable consideration,\\r\\nand such transfer, delivery or supply of any goods shall be deemed to be a sale of those goods by the person making the transfer, delivery or supply and a purchase of those goods by the person to whom such transfer, delivery or supply is made;]\\r\\n(30) \\u201cUnion Territory\\u201d means any Union Territory specified in the First Schedule and includes any other territory comprised within the territory of India but not specified in that Schedule\\r\\n\"],\"10\":[\"367. Interpretation\",\".\\u2014(1) Unless the context otherwise requires, the General Clauses Act, 1897, shall, subject to any adaptations and modifications that may be made therein under Article 372, apply for the interpretation of this Constitution as it applies for the interpretation of an Act of the Legislature of the Dominion of India.\\r\\n(2) Any reference in this Constitution to Acts or laws of, or made by, Parliament, or to Acts or laws of, or made by, the Legislature of a State shall be construed as including a reference to an Ordinance made by the President or, to an Ordinance made by a Governor as the case may be.\\r\\n(3) For the purposes of this Constitution \\u201cforeign State\\u201d means any State other than India:\\r\\nProvided that, subject to the provisions of any law made by Parliament, the President may by order declare any State not to be a foreign State for such purposes as may be specified in the order.\\r\\n (4) For the purposes of this Constitution as it applies in relation to the State of Jammu and Kashmir\\u2014\\r\\n(a) references to this Constitution or to the provisions thereof shall be construed as references to the Constitution or the provisions thereof as applied in relation to the said State;\\r\\n(b) references to the person for the time being recognized by the President on the recommendation of the Legislative Assembly of the State as the Sadar-i-Riyasat of Jammu and Kashmir, acting on the advice of the Council of Ministers of the State for the time being in office, shall be construed as references to the Governor of Jammu and Kashmir;\\r\\n(c) references to the Government of the said State shall be construed as including references to the Governor of Jammu and Kashmir acting on the advice of his Council of Ministers; and\\r\\n(d) in proviso to clause (3) of Article 370 of this Constitution, the expression \\u201cConstituent Assembly of the State referred to in clause (2)\\u201d shall read \\u201cLegislative Assembly of the State\\u201d\\r\\n\"]}', 1, '2021-02-01 03:06:16', '2021-02-01 03:16:12'),
(71, 'qyaGDKlzeTAmjrrAA3BUPu4yj', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XX ', 'AMENDMENT OF THE CONSTITUTION', '', '', '{\"1\":[\"368.  Power of Parliament to amend the Constitution and procedure therefor\",\"(1) Notwithstanding anything in this Constitution, Parliament may in exercise of its constituent power amend by way of addition, variation or repeal any provision of this Constitution in accordance with the procedure laid down in this article.]\\r\\n(2) An amendment of this Constitution may be initiated only by the introduction of a Bill for the purpose in either House of Parliament, and when the Bill is passed in each House by a majority of the total membership of that House and by a majority of not less than two-thirds of the members of that House present and voting, it shall be presented to the President who shall give his assent to the Bill and thereupon] the Constitution shall stand amended in accordance with the terms of the Bill:\\r\\n.\\r\\n(3) Nothing in Article 13 shall apply to any amendment made under this article.\\r\\n (4) No amendment of this Constitution (including the provisions of Part III) made or purporting to have been made under this article [whether before or after the commencement of Section 55 of the Constitution (Forty-second Amendment) Act, 1976 shall be called in question in any court on any ground.\\r\\n(5) For the removal of doubts, it is hereby declared that there shall be no limitation whatever on the constituent power of Parliament to amend by way of addition, variation or repeal the provisions of this Constitution under this article\\r\\n\"]}', 1, '2021-02-01 03:18:36', '2021-02-01 03:18:36');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(72, 'ajslJYUmA97d0eeRMm9xAMw6e', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XXI  ', 'TEMPORARY, TRANSITIONAL AND SPECIAL PROVISIONS', '', '', '{\"1\":[\"369. Temporary power to Parliament to make laws with respect to certain matters in the State List as if they were matters in the Concurrent List\",\"Not-withstanding anything in this Constitution, Parliament shall, during a period of five years from the commencement of this Constitution, have power to make laws with respect to the following matters as if they were enumerated in the Concurrent List, namely:\\u2014\\r\\n(a) trade and commerce within a State in, and the production, supply and distribution of, cotton and woollen textiles, raw cotton (including ginned cotton and unginned cotton or kapas), cotton seed, paper (including newsprint), foodstuffs (including edible oilseeds and oil), cattle fodder (including oil-cakes and other concentrates), coal (including coke and derivatives of coal), iron, steel and mica;\\r\\n(b) offences against laws with respect to any of the matters mentioned in clause (a), jurisdiction and powers of all courts except the Supreme Court with respect to any of those matters, and fees in respect of any of those matters but not including fees taken in any court;\\r\\nbut any law made by Parliament, which Parliament would not but for the provisions of this article have been competent to make, shall, to the extent of the incompetency, cease to have effect on the expiration of the said period, except as respects things done or omitted to be done before the expiration thereof.\\r\\n\"],\"2\":[\"370. All provisions\",\"All provisions of this Constitution, as amended from time to time, without any modifications or exceptions, shall apply to the State of Jammu and Kashmir notwithstanding anything contrary contained in Article 152 or Article 308 or any other article of this Constitution or any other provision of the Constitution of Jammu and Kashmir or any law, document, judgement, ordinance, order, by-law, rule, regulation, notification, custom or usage having the force of law in the territory of India, or any other instrument, treaty or agreement as envisaged under Article 363 or otherwise.\"],\"3\":[\"371. Special provision with respect to the States of Maharashtra and Gujarat\",\"{* * *}\\r\\n(2) Notwithstanding anything in this Constitution, the President may by order made with respect to the State of Maharashtra or Gujarat provide for any special responsibility of the Governor for\\u2014\\r\\n(a) the establishment of separate development boards for Vidarbha, Marathwada,  and the rest of Maharashtra or, as the case may be,} Saurashtra, Kutch and the rest of Gujarat with the provision that a report on the working of each of these boards will be placed each year before the State Legislative Assembly;\\r\\n(b) the equitable allocation of funds for developmental expenditure over the said areas, subject to the requirements of the State as a whole; and\\r\\n(c) an equitable arrangement providing adequate facilities for technical education and vocational training, and adequate opportunities for employment in services under the control of the State Government, in respect of all the said areas, subject to the requirements of the State as a whole.\\r\\n\"],\"4\":[\"371-A. Special provision with respect to the State of Nagaland\",\".(1) Notwithstanding anything in this Constitution,\\u2014\\r\\n(a) no Act of Parliament in respect of\\u2014\\r\\n(i) religious or social practices of the Nagas,\\r\\n(ii) Naga customary law and procedure,\\r\\n(iii) administration of civil and criminal justice involving decisions according to Naga customary law,\\r\\n(iv) ownership and transfer of land and its resources,\\r\\nshall apply to the State of Nagaland unless the Legislative Assembly of Nagaland by a resolution so decides;\\r\\n(b) the Governor of Nagaland shall have special responsibility with respect to law and order in the State of Nagaland for so long as in his opinion internal disturbances occurring in the Naga Hills-Tuensang Area immediately before the formation of that State continue therein or in any part thereof and in the discharge of his functions in relation thereto the Governor shall, after consulting the Council of Ministers, exercise his individual judgment as to the action to be taken:\\r\\nProvided that if any question arises whether any matter is or is not a matter as respects which the Governor is under this sub-clause required to act in the exercise of his individual judgment, the decision of the Governor in his discretion shall be final, and the validity of anything done by the Governor shall not be called in question on the ground that he ought or ought not to have acted in the exercise of his individual judgment:\\r\\nProvided further that if the President on receipt of a report from the Governor or otherwise is satisfied that it is no longer necessary for the Governor to have special responsibility with respect to law and order in the State of Nagaland, he may by order direct that the Governor shall cease to have such responsibility with effect from such date as may be specified in the order;\\r\\n(c) in making his recommendation with respect to any demand for a grant, the Governor of Nagaland shall ensure that any money provided by the Government of India out of the Consolidated Fund of India for any specific service or purpose is included in the demand for a grant relating to that service or purpose and not in any other demand;\\r\\n(d) as from such date as the Governor of Nagaland may by public notification in this behalf specify, there shall be established a regional council for the Tuensang district consisting of thirty-five members and the Governor shall in his discretion make rules providing for\\u2014\\r\\n(i) the composition of the regional council and the manner in which the members of the regional council shall be chosen:\\r\\nProvided that the Deputy Commissioner of the Tuensang district shall be the Chairman ex officio of the regional council and the Vice-Chairman of the regional council shall be elected by the members thereof from amongst themselves;\\r\\n(ii) the qualifications for being chosen as, and for being, members of the regional council;\\r\\n(iii) the term of office of, and the salaries and allowances, if any, to be paid to members of, the regional council;\\r\\n(iv) the procedure and conduct of business of the regional council;\\r\\n(v) the appointment of officers and staff of the regional council and their conditions of services; and\\r\\n(vi) any other matter in respect of which it is necessary to make rules for the constitution and proper functioning of the regional council.\\r\\n(2) Notwithstanding anything in this Constitution, for a period of ten years from the date of the formation of the State of Nagaland or for such further period as the Governor may, on the recommendation of the regional council, by public notification specify in this behalf,\\u2014\\r\\n(a) the administration of the Tuensang district shall be carried on by the Governor;\\r\\n(b) where any money is provided by the Government of India to the Government of Nagaland to meet the requirements of the State of Nagaland as a whole, the Governor shall in his discretion arrange for an equitable allocation of that money between the Tuensang district and the rest of the State;\\r\\n(c) no Act of the Legislature of Nagaland shall apply to the Tuensang district unless the Governor, on the recommendation of the regional council, by public notification so directs and the Governor in giving such direction with respect to any such Act may direct that the Act shall in its application to the Tuensang district or any part thereof have effect subject to such exceptions or modifications as the Governor may specify on the recommendation of the regional council:\\r\\nProvided that any direction given under this sub-clause may be given so as to have retrospective effect;\\r\\n(d) the Governor may make regulations for the peace, progress and good government of the Tuensang district and any regulations so made may repeal or amend with retrospective effect, if necessary, any Act of Parliament or any other law which is for the time being applicable to that district;\\r\\n(e) (i) one of the members representing the Tuensang district in the Legislative Assembly of Nagaland shall be appointed Minister for Tuensang affairs by the Governor on the advice of the Chief Minister and the Chief Minister in tendering his advice shall act on the recommendation of the majority of the members as aforesaid559;\\r\\n(ii) the Minister for Tuensang affairs shall deal with, and have direct access to the Governor on, all matters relating to the Tuensang district but he shall keep the Chief Minister informed about the same;\\r\\n(f) notwithstanding anything in the foregoing provisions of this clause, the final decision on all matters relating to the Tuensang district shall be made by the Governor in his discretion;\\r\\n(g) in Articles 54 and 55 and clause (4) of Article 80, references to the elected members of the Legislative Assembly of a State or to each such member shall include references to the members or member of the Legislative Assembly of Nagaland elected by the regional council established under this article;\\r\\n(h) in Article 170\\u2014\\r\\n(i) clause (1) shall, in relation to the Legislative Assembly of Nagaland, have effect as if for the word \\u201csixty\\u201d, the words \\u201cforty-six\\u201d had been substituted;\\r\\n(ii) in the said clause, the reference to direct election from territorial constituencies in the State shall include election by the members of the regional council established under this article;\\r\\n(iii) in clauses (2) and (3), references to territorial constituencies shall mean references to territorial constituencies in the Kohima and Mokokchung districts.\\r\\n(3) If any difficulty arises in giving effect to any of the foregoing provisions of this article, the President may by order do anything (including any adaptation or modification of any other article) which appears to him to be necessary for the purpose of removing that difficulty:\\r\\nProvided that no such order shall be made after the expiration of three years from the date of the formation of the State of Nagaland.\\r\\nExplanation.\\u2014In this article, the Kohima, Mokokchung and Tuensang districts shall have the same meanings as in the State of Nagaland Act, 1962\\r\\n\"],\"5\":[\"371-B. Special provision with respect to the State of Assam\",\"Notwithstanding anything in this Constitution, the President may, by order made with respect to the State of Assam, provide for the constitution and functions of a committee of the Legislative Assembly of the State consisting of members of that Assembly elected from the tribal areas specified in Part I of the table appended to Paragraph 20 of the Sixth Schedule and such number of other members of that Assembly as may be specified in the order and for the modifications to be made in the rules of procedure of that Assembly for the constitution and proper functioning of such committee\"],\"6\":[\"371-C. Special provision with respect to the State of Manipur\",\".\\u2014(1) Notwithstanding anything in this Constitution, the President may, by order made with respect to the State of Manipur, provide for the constitution and functions of a committee of the Legislative Assembly of the State consisting of members of that Assembly elected from the Hill Areas of that State, for the modifications to be made in the rules of business of the Government and in the rules of procedure of the Legislative Assembly of the State and for any special responsibility of the Governor in order to secure the proper functioning of such committee.\\r\\n(2) The Governor shall annually, or whenever so required by the President, make a report to the President regarding the administration of the Hill Areas in the State of Manipur and the executive power of the Union shall extend to the giving of directions to the State as to the administration of the said areas.\\r\\n\"],\"7\":[\"371-D. Special provisions with respect to the State of Andhra Pradesh 564 or the State of Telangana \",\"(1) The President may by order made with respect to the State of Andhra Pradesh or the State of Telangana, provide, having regard to the requirement of each State, for equitable opportunities and facilities for the people belonging to different parts of such State, in the matter of public employment and in the matter of education, and different provisions may be made for various parts of the States.}\\r\\n(2) An order made under clause (1) may, in particular,\\u2014\\r\\n(a) require the State Government to organise any class or classes of posts in a civil service of, or any class or classes of civil posts under, the State into different local cadres for different parts of the State and allot in accordance with such principles and procedure as may be specified in the order the persons holding such posts to the local cadres so organised;\\r\\n(b) specify any part or parts of the State which shall be regarded as the local area\\u2014\\r\\n(i) for direct recruitment to posts in any local cadre (whether organised in pursuance of an order under this article or constituted otherwise) under the State Government;\\r\\n(ii) for direct recruitment to posts in any cadre under any local authority within the State; and\\r\\n(iii) for the purposes of admission to any University within the State or to any other educational institution which is subject to the control of the State Government;\\r\\n(c) specify the extent to which, the manner in which and the conditions subject to which, preference or reservation shall be given or made\\u2014\\r\\n(i) in the matter of direct recruitment to posts in any such cadre referred to in sub-clause (b) as may be specified in this behalf in the order;\\r\\n(ii) in the matter of admission to any such University or other educational institution referred to in sub-clause (b) as may be specified in this behalf in the order,\\r\\nto or in favour of candidates who have resided or studied for any period specified in the order in the local area in respect of such cadre, University or other educational institution, as the case may be.\\r\\n(3) The President may, by order, provide for the constitution of an Administrative Tribunal for the State of Andhra Pradesh 566{and for the State of Telangana} to exercise such jurisdiction, powers and authority [including any jurisdiction, power and authority which immediately before the commencement of the Constitution (Thirty-second Amendment) Act, 1973, was exercisable by any court (other than the Supreme Court) or by any tribunal or other authority] as may be specified in the order with respect to the following matters, namely:\\u2014\\r\\n(a) appointment, allotment or promotion to such class or classes of posts in any civil service of the State, or to such class or classes of civil posts under the State, or to such class or classes of posts under the control of any local authority within the State, as may be specified in the order;\\r\\n(b) seniority of persons appointed, allotted or promoted to such class or classes of posts in any civil service of the State, or to such class or classes of civil posts under the State, or to such class or classes of posts under the control of any local authority within the State, as may be specified in the order;\\r\\n(c) such other conditions of service of persons appointed, allotted or promoted to such class or classes of posts in any civil service of the State or to such class or classes of civil posts under the State or to such class or classes of posts under the control of any local authority within the State, as may be specified in the order.\\r\\n(4) An order made under clause (3) may\\u2014\\r\\n(a) authorise the Administrative Tribunal to receive representations for the redress of grievances relating to any matter within its jurisdiction as the President may specify in the order and to make such orders thereon as the Administrative Tribunal deems fit;\\r\\n(b) contain such provisions with respect to the powers and authorities and procedure of the Administrative Tribunal (including provisions with respect to the powers of the Administrative Tribunal to punish for contempt of itself) as the President may deem necessary;\\r\\n(c) provide for the transfer to the Administrative Tribunal of such classes of proceedings, being proceedings relating to matters within its jurisdiction and pending before any court (other than the Supreme Court) or tribunal or other authority immediately before the commencement of such order, as may be specified in the order;\\r\\n(d) contain such supplemental, incidental and consequential provisions (including provisions as to fees and as to limitation, evidence or for the application of any law for the time being in force subject to any exceptions or modifications) as the President may deem necessary.\\r\\n(5) The order of the Administrative Tribunal finally disposing of any case shall become effective upon its confirmation by the State Government or on the expiry of three months from the date on which the order is made, whichever is earlier:\\r\\nProvided that the State Government may, by special order made in writing and for reasons to be specified therein, modify or annul any order of the Administrative Tribunal before it becomes effective and in such a case, the order of the Administrative Tribunal shall have effect only in such modified form or be of no effect, as the case may be.]\\r\\n(6) Every special order made by the State Government under the proviso to clause (5) shall be laid, as soon as may be after it is made, before both Houses of the State Legislature.\\r\\n(7) The High Court for the State shall not have any powers of superintendence over the Administrative Tribunal and no court (other than the Supreme Court) or tribunal shall exercise any jurisdiction, power or authority in respect of any matter subject to the jurisdiction, power or authority of, or in relation to, the Administrative Tribunal.\\r\\n(8) If the President is satisfied that the continued existence of the Administrative Tribunal is not necessary, the President may by order abolish the Administrative Tribunal and make such provisions in such order as he may deem fit for the transfer and disposal of cases pending before the Tribunal immediately before such abolition.\\r\\n(9) Notwithstanding any judgment, decree or order of any court, tribunal or other authority,\\u2014\\r\\n(a) no appointment, posting, promotion or transfer of any person\\u2014\\r\\n(i) made before the 1st day of November, 1956, to any post under the Government of, or any local authority within, the State of Hyderabad as it existed before that date; or\\r\\n(ii) made before the commencement of the Constitution (Thirty-second Amendment) Act, 1973, to any post under the Government of, or any local or other authority within, the State of Andhra Pradesh; and\\r\\n(b) no action taken or thing done by or before any person referred to in sub-clause (a),\\r\\nshall be deemed to be illegal or void or ever to have become illegal or void merely on the ground that the appointment, posting, promotion or transfer of such person was not made in accordance with any law, then in force, providing for any requirement as to residence within the State of Hyderabad or, as the case may be, within any part of the State of Andhra Pradesh, in respect of such appointment, posting, promotion or transfer.\\r\\n(10) The provisions of this article and of any order made by the President thereunder shall have effect notwithstanding anything in any other provision of this Constitution or in any other law for the time being in force.\\r\\n\"],\"8\":[\"371-E. Establishment of Central University in Andhra Pradesh\",\"Parliament may by law provide for the establishment of a University in the State of Andhra Pradesh\"],\"9\":[\"371-F. Special provisions with respect to the State of Sikkim\",\"Notwith- standing anything in this Constitution,\\u2014\\r\\n(a) the Legislative Assembly of the State of Sikkim shall consist of not less than thirty members;\\r\\n(b) as from the date of commencement of the Constitution (Thirty-sixth Amendment) Act, 1975 (hereafter in this article referred to as the appointed day)\\u2014\\r\\n(i) the Assembly for Sikkim formed as a result of the elections held in Sikkim in April, 1974 with thirty-two members elected in the said elections (hereinafter referred to as the sitting members) shall be deemed to be the Legislative Assembly of the State of Sikkim duly constituted under this Constitution;\\r\\n(ii) the sitting members shall be deemed to be the members of the Legislative Assembly of the State of Sikkim duly elected under this Constitution; and\\r\\n(iii) the said Legislative Assembly of the State of Sikkim shall exercise the powers and perform the functions of the Legislative Assembly of a State under this Constitution;\\r\\n(c) in the case of the Assembly deemed to be the Legislative Assembly of the State of Sikkim under clause (b), the references to the period of five years in clause (1) of Article 172 shall be construed as references to a period of four years and the said period of four years shall be deemed to commence from the appointed day;\\r\\n(d) until other provisions are made by Parliament by law, there shall be allotted to the State of Sikkim one seat in the House of the People and the State of Sikkim shall form one parliamentary constituency to be called the parliamentary constituency for Sikkim;\\r\\n(e) the representative of the State of Sikkim in the House of the People in existence on the appointed day shall be elected by the members of the Legislative Assembly of the State of Sikkim;\\r\\n(f) Parliament may, for the purpose of protecting the rights and interests of the different sections of the population of Sikkim make provision for the number of seats in the Legislative Assembly of the State of Sikkim which may be filled by candidates belonging to such sections and for the delimitation of the assembly constituencies from which candidates belonging to such sections alone may stand for election to the Legislative Assembly of the State of Sikkim;\\r\\n(g) the Governor of Sikkim shall have special responsibility for peace and for an equitable arrangement for ensuring the social and economic advancement of different sections of the population of Sikkim and in the discharge of his special responsibility under this clause, the Governor of Sikkim shall, subject to such directions as the President may, from time to time, deem fit to issue, act in his discretion;\\r\\n(h) all property and assets (whether within or outside the territories comprised in the State of Sikkim) which immediately before the appointed day were vested in the Government of Sikkim or in any other authority or in any person for the purposes of the Government of Sikkim shall, as from the appointed day, vest in the Government of the State of Sikkim;\\r\\n(i) the High Court functioning as such immediately before the appointed day in the territories comprised in the State of Sikkim shall, on and from the appointed day, be deemed to be the High Court for the State of Sikkim;\\r\\n(j) all courts of civil, criminal and revenue jurisdiction, all authorities and all officers, judicial, executive and ministerial, throughout the territory of the State of Sikkim shall continue on and from the appointed day to exercise their respective functions subject to the provisions of this Constitution;\\r\\n(k) all laws in force immediately before the appointed day in the territories comprised in the State of Sikkim or any part thereof shall continue to be in force therein until amended or repealed by a competent Legislature or other competent authority;\\r\\n(l) for the purpose of facilitating the application of any such law as is referred to in clause (k) in relation to the administration of the State of Sikkim and for the purpose of bringing the provisions of any such law into accord with the provisions of this Constitution, the President may, within two years from the appointed day, by order, make such adaptations and modifications of the law, whether by way of repeal or amendment, as may be necessary or expedient, and thereupon, every such law shall have effect subject to the adaptations and modifications so made, and any such adaptation or modification shall not be questioned in any court of law;\\r\\n(m) neither the Supreme Court nor any other court shall have jurisdiction in respect of any dispute or other matter arising out of any treaty, agreement, engagement or other similar instrument relating to Sikkim which was entered into or executed before the appointed day and to which the Government of India or any of its predecessor Governments was a party, but nothing in this clause shall be construed to derogate from the provisions of Article 143;\\r\\n(n) the President may, by public notification, extend with such restrictions or modifications as he thinks fit to the State of Sikkim any enactment which is in force in a State of India at the date of the notification;\\r\\n(o) if any difficulty arises in giving effect to any of the foregoing provisions of this article, the President may, by order, do anything (including any adaptation or modification of any other article) which appears to him to be necessary for the purpose of removing that difficulty:\\r\\nProvided that no such order shall be made after the expiry of two years from the appointed day;\\r\\n(p) all things done and all actions taken in or in relation to the State of Sikkim or the territories comprised therein during the period commencing on the appointed day and ending immediately before the date on which the Constitution (Thirty-sixth Amendment) Act, 1975, receives the assent of the President shall, in so far as they are in conformity with the provisions of this Constitution as amended by the Constitution (Thirty-sixth Amendment) Act, 1975, be deemed for all purposes to have been validly done or taken under this Constitution as so amended\\r\\n\"],\"10\":[\"371-G. Special provision with respect to the State of Mizoram\",\"Notwith- standing anything in this Constitution,\\u2014\\r\\n(a) no Act of Parliament in respect of\\u2014\\r\\n(i) religious or social practices of the Mizos,\\r\\n(ii) Mizo customary law and procedure,\\r\\n(iii) administration of civil and criminal justice involving decisions according to Mizo Customary law,\\r\\n(iv) ownership and transfer of land,\\r\\nshall apply to the State of Mizoram unless the Legislative Assembly of the State of Mizoram by a resolution so decides:\\r\\nProvided that nothing in this clause shall apply to any Central Act in force in the Union Territory of Mizoram immediately before the commencement of the Constitution (Fifty-third Amendment) Act, 1986;\\r\\n(b) the Legislative Assembly of the State of Mizoram shall consist of not less than forty members.\\r\\n\"],\"11\":[\" 371-H. Special provision with respect to the State of Arunachal Pradesh\",\"Notwithstanding anything in this Constitution,\\u2014\\r\\n(a) the Governor of Arunachal Pradesh shall have special responsibility with respect to law and order in the State of Arunachal Pradesh and in the discharge of his functions in relation thereto, the Governor shall, after consulting the Council of Ministers, exercise his individual judgment as to the action to be taken:\\r\\nProvided that if any question arises whether any matter is or is not a matter as respects which the Governor is under this clause required to act in the exercise of his individual judgment, the decision of the Governor in his discretion shall be final, and the validity of anything done by the Governor shall not be called in question on the ground that he ought or ought not to have acted in the exercise of his individual judgment:\\r\\nProvided further that if the President on receipt of a report from the Governor or otherwise is satisfied that it is no longer necessary for the Governor to have special responsibility with respect to law and order in the State of Arunachal Pradesh, he may by order direct that the Governor shall cease to have such responsibility with effect from such date as may be specified in the order;\\r\\n(b) the Legislative Assembly of the State of Arunachal Pradesh shall consist of not less than thirty members\\r\\n\"],\"12\":[\"371-I. Special provision with respect to the State of Goa\",\"Notwithstanding anything in this Constitution, the Legislative Assembly of the State of Goa shall consist of not less than thirty members.\"],\"13\":[\"371-J. Special provisions with respect to State of Karnataka\",\"(1) The President may, by order made with respect to the State of Karnataka, provide for any special responsibility of the Governor for\\u2014\\r\\n(a) establishment of a separate development board for Hyderabad-Karnataka region with the provision that a report on the working of the board will be placed each year before the State Legislative Assembly;\\r\\n(b) equitable allocation of funds for developmental expenditure over the said region, subject to the requirements of the State as a whole; and\\r\\n(c) equitable opportunities and facilities for the people belonging to the said region, in matters of public employment, education and vocational training, subject to the requirements of the State as a whole.\\r\\n(2) An order made under sub-clause (c) of clause (1) may provide for\\u2014\\r\\n(a) reservation of a proportion of seats in educational and vocational training institutions in the Hyderabad-Karnataka region for students who belong to that region by birth or by domicile; and\\r\\n(b) identification of posts or classes of posts under the State Government and in any body or organisation under the control of the State Government in the Hyderabad-Karnataka region and reservation of a proportion of such posts for persons who belong to that region by birth or by domicile and for appointment thereto by direct recruitment or by promotion or in any other manner as may be specified in the order\\r\\n\"],\"14\":[\"372. Continuance in force of existing laws and their adaptation\",\"(1) Notwithstanding the repeal by this Constitution of the enactments referred to in Article 395 but subject to the other provisions of this Constitution, all the laws in force in the territory of India immediately before the commencement of this Constitution shall continue in force therein until altered or repealed or amended by a competent Legislature or other competent authority.\\r\\n(2) For the purpose of bringing the provisions of any law in force in the territory of India into accord with the provisions of this Constitution, the President may by ordermake such adaptations and modifications of such law, whether by way of repeal or amendment, as may be necessary or expedient, and provide that the law shall, as from such date as may be specified in the order, have effect subject to the adaptations and modifications so made, and any such adaptation or modification shall not be questioned in any court of law.\\r\\n(3) Nothing in clause (2) shall be deemed\\u2014\\r\\n(a) to empower the President to make any adaptation or modification of any law after the expiration of  three years from the commencement of this Constitution; or\\r\\n(b) to prevent any competent Legislature or other competent authority from repealing or amending any law adapted or modified by the President under the said clause.\\r\\n\"],\"15\":[\"372-A. Power of the President to adapt laws\",\".\\u2014(1) For the purposes of bringing the provisions of any law in force in India or in any part thereof, immediately before the commencement of the Constitution (Seventh Amendment) Act, 1956, into accord with the provisions of this Constitution as amended by that Act, the President may by order581 made before the 1st day of November, 1957, make such adaptations and modifications of the law, whether by way of repeal or amendment, as may be necessary or expedient, and provide that the law shall, as from such date as may be specified in the order, have effect subject to the adaptations and modifications so made, and any such adaptation or modification shall not be questioned in any court of law.\\r\\n(2) Nothing in clause (1) shall be deemed to prevent a competent legislature or other competent authority from repealing or amending any law adapted or modified by the President under the said clause.\\r\\n\"],\"16\":[\"373. Power of President to make order in respect of persons under preventive detention in certain cases\",\"Until provision is made by Parliament under clause (7) of Article 22, or until the expiration of one year from the commencement of this Constitution, whichever is earlier, the said article shall have effect as if for any reference to Parliament in clauses (4) and (7) thereof there were substituted a reference to the President and for any reference to any law made by Parliament in those clauses there were substituted a reference to an order made by the President\"],\"17\":[\"374. Provisions as to Judges of the Federal Court and proceedings pending in the Federal Court or before His Majesty in Council\",\".\\u2014(1) The Judges of the Federal Court holding office immediately before the commencement of this Constitution shall, unless they have elected otherwise, become on such commencement the Judges of the Supreme Court and shall thereupon be entitled to such salaries and allowances and to such rights in respect of leave of absence and pension as are provided for under Article 125 in respect of the Judges of the Supreme Court.\\r\\n(2) All suits, appeals and proceedings, civil or criminal, pending in the Federal Court at the commencement of this Constitution shall stand removed to the Supreme Court, and the Supreme Court shall have jurisdiction to hear and determine the same, and the judgments and orders of the Federal Court delivered or made before the commencement of this Constitution shall have the same force and effect as if they had been delivered or made by the Supreme Court.\\r\\n(3) Nothing in this Constitution shall operate to invalidate the exercise of jurisdiction by His Majesty in Council to dispose of appeals and petitions from, or in respect of, any judgment, decree or order of any court within the territory of India in so far as the exercise of such jurisdiction is authorised by law, and any order of His Majesty in Council made on any such appeal or petition after the commencement of this Constitution shall for all purposes have effect as if it were an order or decree made by the Supreme Court in the exercise of the jurisdiction conferred on such Court by this Constitution.\\r\\n(4) On and from the commencement of this Constitution the jurisdiction of the authority functioning as the Privy Council in a State specified in Part B of the First Schedule to entertain and dispose of appeals and petitions from or in respect of any judgment, decree or order of any court within that State shall cease, and all appeals and other proceedings pending before the said authority at such commencement shall be transferred to, and disposed of by, the Supreme Court.\\r\\n(5) Further provision may be made by Parliament by law to give effect to the provisions of this article.\\r\\n\"],\"18\":[\"375. Courts, authorities and officers to continue to function subject to the provisions of the Constitution\",\"All courts of civil, criminal and revenue jurisdiction, all authorities and all officers, judicial, executive and ministerial, throughout the territory of India, shall continue to exercise their respective functions subject to the provisions of this Constitution.\"],\"19\":[\"376. Provisions as to Judges of High Courts\",\".\\u2014(1) Notwithstanding anything in clause (2) of Article 217, the Judges of a High Court in any Province holding office immediately before the commencement of this Constitution shall, unless they have elected otherwise, become on such commencement the Judges of the High Court in the corresponding State, and shall thereupon be entitled to such salaries and allowances and to such rights in respect of leave of absence and pension as are provided for under Article 221 in respect of the Judges of such High Court.\\r\\n(2) The Judges of a High Court in any Indian State corresponding to any State specified in Part B of the First Schedule holding office immediately before the commencement of this Constitution shall, unless they have elected otherwise, become on such commencement the Judges of the High Court in the State so specified and shall, notwithstanding anything in clauses (1) and (2) of Article 217 but subject to the proviso to clause (1) of that article, continue to hold office until the expiration of such period as the President may by order determine.\\r\\n(3) In this article, the expression \\u201cJudge\\u201d does not include an acting Judge or an additional Judge.\\r\\n\"],\"20\":[\"377. Provisions as to Comptroller and Auditor-General of India\",\"The Auditor-General of India holding office immediately before the commencement of this Constitution shall, unless he has elected otherwise, become on such commencement the Comptroller and Auditor-General of India and shall thereupon be entitled to such salaries and to such rights in respect of leave of absence and pension as are provided for under clause (3) of Article 148 in respect of the Comptroller and Auditor-General of India and be entitled to continue to hold office until the expiration of his term of office as determined under the provisions which were applicable to him immediately before such commencement.\"],\"21\":[\"378. Provisions as to Public Service Commissions\",\".\\u2014(1) The members of the Public Service Commission for the Dominion of India holding office immediately before the commencement of this Constitution shall, unless they have elected otherwise, become on such commencement the members of the Public Service Commission for the Union and shall, notwithstanding anything in clauses (1) and (2) of Article 316 but subject to the proviso to clause (2) of that article, continue to hold office until the expiration of their term of office as determined under the rules which were applicable immediately before such commencement to such members.\\r\\n(2) The members of a Public Service Commission of a Province or of a Public Service Commission serving the needs of a group of Provinces holding office immediately before the commencement of this Constitution shall, unless they have elected otherwise, become on such commencement the members of the Public Service Commission for the corresponding State or the members of the Joint State Public Service Commission serving the needs of the corresponding States, as the case may be, and shall, notwithstanding anything in clauses (1) and (2) of Article 316 but subject to the proviso to clause (2) of that article, continue to hold office until the expiration of their term of office as determined under the rules which were applicable immediately before such commencement to such members.\\r\\n\"],\"22\":[\"378-A. Special provision as to duration of Andhra Pradesh Legislative Assembly\",\"Notwithstanding anything contained in Article 172, the Legislative Assembly of the State of Andhra Pradesh as constituted under the provisions of Sections 28 and 29 of the States Reorganisation Act, 1956, shall, unless sooner dissolved, continue for a period of five years from the date referred to in the said Section 29 and no longer and the expiration of the said period shall operate as a dissolution of that Legislative Assembly\"],\"23\":[\"379. Provisions as to provisional Parliament and the Speaker and Deputy Speaker thereof\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"24\":[\"380. Provision as to President\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"25\":[\"381. Council of Ministers of the President\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"26\":[\"382. Provisions as to provisional Legislatures for States in Part A of the First Schedule\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"27\":[\"383. Provision as to Governors of Provinces\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"28\":[\"384. Council of Ministers of Governors\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch.\"],\"29\":[\"385. Provision as to provisional Legislatures in States in Part B of the First Schedule\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"30\":[\"386. Council of Ministers for States in Part B of the First Schedule\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"31\":[\"387. Special provision as to determination of population for the purposes of certain elections\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"32\":[\"388. Provisions as to the filling of casual vacancies in the provisional Parliament and provisional Legislatures of the States\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"33\":[\"389. Provision as to Bills pending in the Dominion Legislature and in the Legislatures of Provinces and Indian States\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"34\":[\"390. Moneys received or raised or expenditure incurred between the commencement of the Constitution and the 31st day of March, 1950\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"35\":[\"391. Power of the President to amend the First and Fourth Schedules in certain contingencies\",\"Rep. by the Constitution (Seventh Amendment) Act, 1956, S. 29 and Sch\"],\"36\":[\"392. Power of the President to remove difficulties\",\"(1) The President may, for the purpose of removing any difficulties, particularly in relation to the transition from the provisions of the Government of India Act, 1935, to the provisions of this Constitution, by order direct that this Constitution shall, during such period as may be specified in the order, have effect subject to such adaptations, whether by way of modification, addition or omission, as he may deem to be necessary or expedient:\\r\\nProvided that no such order shall be made after the first meeting of Parliament duly constituted under Chapter II of Part V.\\r\\n(2) Every order made under clause (1) shall be laid before Parliament.\\r\\n(3) The powers conferred on the President by this article, by Article 324, by clause (3) of Article 367 and by Article 391 shall, before the commencement of this Constitution, be exercisable by the Governor-General of the Dominion of India.\\r\\n  \\r\\n\"]}', 1, '2021-02-01 03:19:45', '2021-02-01 03:39:44'),
(73, 'EXujIxPYmo26NbwLrYWzLc5IE', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'Part XXII ', 'SHORT TITLE, COMMENCEMENT, AUTHORITATIVE TEXT IN HINDI AND REPEALS', '', '', '{\"1\":[\"393. Short title\",\"This Constitution may be called the Constitution of India.\"],\"2\":[\"394. Commencement\",\"This article and Articles 5, 6, 7, 8, 9, 60, 324, 366, 367, 379, 380, 388, 391, 392, and 393 shall come into force at once, and the remaining provisions of this Constitution shall come into force on the twenty-sixth day of January, 1950, which day is referred to in this Constitution as the commencement of this Constitution\"],\"3\":[\"394-A. Authoritative text in the Hindi language\",\"(1) The President shall cause to be published under his authority,\\u2014\\r\\n(a) the translation of this Constitution in the Hindi language, signed by the members of the Constituent Assembly, with such modifications as may be necessary to bring it in conformity with the language, style and terminology adopted in the authoritative texts of Central Acts in the Hindi language, and incorporating therein all the amendments of this Constitution made before such publication; and\\r\\n(b) the translation in the Hindi language of every amendment of this Constitution made in the English language.\\r\\n(2) The translation of this Constitution and of every amendment thereof published under clause (1) shall be construed to have the same meaning as the original thereof and if any difficulty arises in so construing any part of such translation, the President shall cause the same to be revised suitably.\\r\\n(3) The translation of this Constitution and of every amendment thereof published under this article shall be deemed to be, for all purposes, the authoritative text thereof in the Hindi language.\\r\\n\"],\"4\":[\"395. Repeals\",\"The Indian Independence Act, 1947, and the Government of India Act, 1935, together with all enactments amending or supplementing the latter Act, but not including the Abolition of Privy Council Jurisdiction Act, 1949, are hereby repealed\"]}', 1, '2021-02-01 03:41:08', '2021-02-01 03:42:36');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(74, 'NMXNaUxi83c5aVHftOUxOIwO2', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'SCHEDULE VII', 'LIST I UNION LIST ', '', '', '{\"1\":[\"UNION LIST \",\"1. Defence of India and every part thereof including preparation for defence and all such acts as may be conducive in times of war to its prosecution and after its termination to effective demobilisation.\\r\\n2. Naval, military and air forces; any other armed forces of the Union.\\r\\n818[2-A. Deployment of any armed force of the Union or any other force subject to the control of the Union or any contingent or unit thereof in any State in aid of the civil power; powers, jurisdiction, privileges and liabilities of the members of such forces while on such deployment.]\\r\\n3. Delimitation of cantonment areas, local self-government in such areas, the constitution and powers within such areas of cantonment authorities and the regulation of house accommodation (including the control of rents) in such areas.\\r\\n4. Naval, military and air force works.\\r\\n5. Arms, firearms, ammunition and explosives.\\r\\n6. Atomic energy and mineral resources necessary for its production.\\r\\n7. Industries declared by Parliament by law to be necessary for the purpose of defence or for the prosecution of war.\\r\\n8. Central Bureau of Intelligence and Investigation\\r\\n9. Preventive detention for reasons connected with Defence, Foreign Affairs, or the security of India; persons subjected to such detention.\\r\\n10. Foreign affairs; all matters which bring the Union into relation with any foreign country.\\r\\n11. Diplomatic, consular and trade representation.\\r\\n12. United Nations Organisation.\\r\\n13. Participation in international conferences, associations and other bodies and implementing of decisions made thereat.\\r\\n14. Entering into treaties and agreements with foreign countries and implementing of treaties, agreements and conventions with foreign countries.\\r\\n15. War and peace.\\r\\n16. Foreign jurisdiction.\\r\\n17. Citizenship, naturalisation and aliens.\\r\\n18. Extradition.\\r\\n19. Admission into, and emigration and expulsion from, India; passports and visas.\\r\\n20. Pilgrimages to places outside India.\\r\\n21. Piracies and crimes committed on the high seas or in the air; offences against the law of nations committed on land or the high seas or in the air.\\r\\n22. Railways.\\r\\n23. Highways declared by or under law made by Parliament to be national highways.\\r\\n24. Shipping and navigation on inland waterways, declared by Parliament by law to be national waterways, as regards mechanically propelled vessels; the rule of the road on such waterways.\\r\\n25. Maritime shipping and navigation, including shipping and navigation on tidal waters; provision of education and training for the mercantile marine and regulation of such education and training provided by States and other agencies.\\r\\n26. Lighthouses, including lightships, beacons and other provision for the safety of shipping and aircraft.\\r\\n27. Ports declared by or under law made by Parliament or existing law to be major ports, including their delimitation, and the constitution and powers of port authorities therein.\\r\\n28. Port quarantine, including hospitals connected therewith; seamen\'s and marine hospitals.\\r\\n29. Airways; aircraft and air navigation; provision of aerodromes; regulation and organisation of air traffic and of aerodromes; provision for aeronautical education and training and regulation of such education and training provided by States and other agencies.\\r\\n30. Carriage of passengers and goods by railway, sea or air, or by national waterways in mechanically propelled vessels.\\r\\n31. Posts and telegraphs; telephones, wireless, broadcasting and other like forms of communication.\\r\\n32. Property of the Union and the revenue therefrom, but as regards property situated in a State subject to legislation by the State, save in so far as Parliament by law otherwise provides.\\r\\n34. Courts of wards for the estates of Rulers of Indian States.\\r\\n35. Public debt of the Union.\\r\\n36. Currency, coinage and legal tender; foreign exchange.\\r\\n37. Foreign loans.\\r\\n38. Reserve Bank of India.\\r\\n39. Post Office Savings Bank.\\r\\n40. Lotteries organised by the Government of India or the Government of a State.\\r\\n41. Trade and commerce with foreign countries; import and export across customs frontiers; definition of customs frontiers.\\r\\n42. Inter-State trade and commerce.\\r\\n43. Incorporation, regulation and winding up of trading corporations, including banking, insurance and financial corporations but not including co-operative societies.\\r\\n44. Incorporation, regulation and winding up of corporations, whether trading or not, with objects not confined to one State, but not including universities.\\r\\n45. Banking.\\r\\n46. Bills of exchange, cheques, promissory notes and other like instruments.\\r\\n47. Insurance.\\r\\n48. Stock exchanges and future markets.\\r\\n49. Patents, inventions and designs; copyright; trade-marks and merchandise marks\\r\\n50. Establishment of standards of weight and measure.\\r\\n51. Establishment of standards of quality for goods to be exported out of India or transported from one State to another.\\r\\n52. Industries, the control of which by the Union is declared by Parliament by law to be expedient in the public interest.\\r\\n53. Regulation and development of oilfields and mineral oil resources; petroleum and petroleum products; other liquids and substances declared by Parliament by law to be dangerously inflammable.\\r\\n54. Regulation of mines and mineral development to the extent to which such regulation and development under the control of Union is declared by Parliament by law to be expedient in the public interest.\\r\\n55. Regulation of labour and safety in mines and oil-fields.\\r\\n56. Regulation and development of inter-State rivers and river valleys to the extent to which such regulation and development under the control of the Union is declared by Parliament by law to be expedient in the public interest.\\r\\n57. Fishing and fisheries beyond territorial waters.\\r\\n58. Manufacture, supply and distribution of salt by Union agencies; regulation and control of manufacture, supply and distribution of salt by other agencies.\\r\\n59. Cultivation, manufacture, and sale for export, of opium.\\r\\n60. Sanctioning of cinematograph films for exhibition.\\r\\n61. Industrial disputes concerning Union employees.\\r\\n62. The institutions known at the commencement of this Constitution as the National Library, the Indian Museum, the Imperial War Museum, the Victoria Memorial and the Indian War Memorial, and any other like institution financed by the Government of India wholly or in part and declared by Parliament by law to be an institution of national importance.\\r\\n63. The institutions known at the commencement of this Constitution as the Benares Hindu University, the Aligarh Muslim University and the 821[Delhi University; the University established in pursuance of Article 371-E;] any other institution declared by Parliament by law to be an institution of national importance.\\r\\n64. Institutions for scientific or technical education financed by the Government of India wholly or in part and declared by Parliament by law to be institutions of national importance.\\r\\n65. Union agencies and institutions for\\u2014\\r\\n(a) professional, vocational or technical training, including the training of police officers; or\\r\\n(b) the promotion of special studies or research; or\\r\\n(c) scientific or technical assistance in the investigation or detection of crime.\\r\\n66. Co-ordination and determination of standards in institutions for higher education or research and scientific and technical institutions.\\r\\n67. Ancient and historical monuments and records, and archaeological sites and remains, 822[declared by or under law made by Parliament] to be of national importance.\\r\\n68. The Survey of India, the Geological, Botanical, Zoological and Anthropological Surveys of India; Meteorological organisations.\\r\\n69. Census.\\r\\n70. Union Public Services; all-India Services; Union Public Service Commission.\\r\\n71. Union pensions, that is to say, pensions payable by the Government of India or out of the Consolidated Fund of India.\\r\\n72. Elections to Parliament, to the Legislatures of States and to the offices of President and Vice-President; the Election Commission.\\r\\n73. Salaries and allowances of members of Parliament, the Chairman and Deputy Chairman of the Council of States and the Speaker and Deputy Speaker of the House of the People.\\r\\n74. Powers, privileges and immunities of each House of Parliament and of the members and the Committees of each House; enforcement of attendance of persons for giving evidence or producing documents before committees of Parliament or commissions appointed by Parliament.\\r\\n75. Emoluments, allowances, privileges, and rights in respect of leave of absence, of the President and Governors; salaries and allowances of the Ministers for the Union; the salaries, allowances, and rights in respect of leave of absence and other conditions of service of the Comptroller and Auditor-General.\\r\\n76. Audit of the accounts of the Union and of the States.\\r\\n77. Constitution, organisation, jurisdiction and powers of the Supreme Court (including contempt of such Court), and the fees taken therein; persons entitled to practise before the Supreme Court.\\r\\n78. Constitution and organisation 823[(including vacations)] of the High Courts except provisions as to officers and servants of High Courts; persons entitled to practise before the High Courts.\\r\\n79. Extension of the jurisdiction of a High Court to, and exclusion of the jurisdiction of a High Court from, any Union territory.\\r\\n80. Extension of the powers and jurisdiction of members of a police force belonging to any State to any area outside that State, but not so as to enable the police of one State to exercise powers and jurisdiction in any area outside that State without the consent of the Government of the State in which such area is situated; extension of the powers and jurisdiction of members of a police force belonging to any State to railway areas outside that State.\\r\\n81. Inter-State migration; inter-State quarantine.\\r\\n82. Taxes on income other than agricultural income.\\r\\n83. Duties of customs including export duties.\\r\\n825[84. Duties of excise on the following goods manufactured or produced in India, namely:\\u2014\\r\\n(a) petroleum crude;\\r\\n(b) high speed diesel;\\r\\n(c) motor spirit (commonly known as petrol);\\r\\n(d) natural gas;\\r\\n(e) aviation turbine fuel; and\\r\\n(f) tobacco and tobacco products.]\\r\\n85. Corporation tax.\\r\\n86. Taxes on the capital value of the assets, exclusive of agricultural land, of individuals and companies; taxes on the capital of companies.\\r\\n87. Estate duty in respect of property other than agricultural land.\\r\\n88. Duties in respect of succession to property other than agricultural land.\\r\\n89. Terminal taxes on goods or passengers, carried by railway, sea or air; taxes on railway fares and freights.\\r\\n90. Taxes other than stamp duties on transactions in stock exchanges and futures markets.\\r\\n91. Rates of stamp duty in respect of bills of exchange, cheques, promissory notes, bills of lading, letters of credit, policies of insurance, transfer of shares, debentures, proxies and receipts.\\r\\n85. Corporation tax.\\r\\n86. Taxes on the capital value of the assets, exclusive of agricultural land, of individuals and companies; taxes on the capital of companies.\\r\\n87. Estate duty in respect of property other than agricultural land.\\r\\n88. Duties in respect of succession to property other than agricultural land.\\r\\n89. Terminal taxes on goods or passengers, carried by railway, sea or air; taxes on railway fares and freights.\\r\\n90. Taxes other than stamp duties on transactions in stock exchanges and futures markets.\\r\\n91. Rates of stamp duty in respect of bills of exchange, cheques, promissory notes, bills of lading, letters of credit, policies of insurance, transfer of shares, debentures, proxies and receipts.\\r\\n92-A. Taxes on the sale or purchase of goods other than newspapers, where such sale or purchase takes place in the course of inter-State trade or commerce.\\r\\n92-B. Taxes on the consignment of goods (whether the consignment is to the person making it or to any other person), where such consignment takes place in the course of inter-State trade or commerce.\\r\\n93. Offences against laws with respect to any of the matters in this List.\\r\\n94. Inquiries, surveys and statistics for the purpose of any of the matters in this List.\\r\\n95. Jurisdiction and powers of all courts, except the Supreme Court, with respect to any of the matters in this List; admiralty jurisdiction.\\r\\n96. Fees in respect of any of the matters in this List, but not including fees taken in any court.\\r\\n97. Any other matter not enumerated in List II or List III including any tax not mentioned in either of those Lists.\\r\\n\"]}', 1, '2021-02-01 04:16:13', '2021-02-01 04:28:16'),
(75, 'JHSlRk3KMMgK0MkKASebxlIYg', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'SCHEDULE VII', 'LIST II STATE LIST ', '', '', '{\"1\":[\"STATE LIST \",\"1. Public order (but not including the use of any naval, military or air force or any other armed force of the Union or of any other force subject to the control of the Union or of any contingent or unit thereof] in aid of the civil power).\\r\\n2. Police (including railway and village police) subject to the provisions of Entry 2A of List I.\\r\\n3.  Officers and servants of the High Court; procedure in rent and revenue courts; fees taken in all courts except the Supreme Court.\\r\\n4. Prisons, reformatories, Borstal institutions and other institutions of a like nature and persons detained therein; arrangements with other States for the use of prisons and other institutions.\\r\\n5. Local government, that is to say, the constitution and powers of municipal corporations, improvement trusts, district boards, mining settlement authorities and other local authorities for the purpose of local self-government or village administration\\r\\n7. Pilgrimages, other than pilgrimages to places outside India.\\r\\n8. Intoxicating liquors, that is to say, the production, manufacture, possession, transport, purchase and sale of intoxicating liquors.\\r\\n9. Relief of the disabled and unemployable.\\r\\n10. Burials and burial grounds; cremations and cremation grounds.\\r\\n12. Libraries, museums and other similar institutions controlled or financed by the State; ancient and historical monuments and records other than those declared by or under law made by Parliament] to be of national importance.\\r\\n13. Communications, that is to say, roads, bridges, ferries, and other means of communication not specified in List I; municipal tramways; ropeways; inland waterways and traffic thereon subject to the provisions of List I and List III with regard to such waterways; vehicles other than mechanically propelled vehicles.\\r\\n14. Agriculture, including agricultural education and research, protection against pests and prevention of plant diseases.\\r\\n15. Preservation, protection and improvement of stock and prevention of animal diseases; veterinary training and practice.\\r\\n16. Pounds and the prevention of cattle trespass.\\r\\n17. Water, that is to say, water supplies, irrigation and canals, drainage and embankments, water storage and water power subject to the provisions of Entry 56 of List I.\\r\\n18. Land, that is to say, rights in or over land, land tenures including the relation of landlord and tenant, and the collection of rents; transfer and alienation of agricultural land; land improvement and agricultural loans; colonization.\\r\\n21. Fisheries.\\r\\n22. Courts of wards subject to the provisions of Entry 34 of List I; encumbered and attached estates.\\r\\n23. Regulation of mines and mineral development subject to the provisions of List I with respect to regulation and development under the control of the Union.\\r\\n24. Industries subject to the provisions of Entries 7 and 52 of List I.\\r\\n25. Gas and gas-works.\\r\\n26. Trade and commerce within the State subject to the provisions of Entry 33 of List III.\\r\\n27. Production, supply and distribution of goods subject to the provisions of Entry 33 of List III.\\r\\n28. Markets and fairs.\\r\\n30. Money-lending and money-lenders; relief of agricultural indebtedness.\\r\\n31. Inns and inn-keepers.\\r\\n32. Incorporation, regulation and winding up of corporations, other than those specified in List I, and universities; unincorporated trading, literary, scientific, religious and other societies and associations; co-operative societies.\\r\\n33. Theatres and dramatic performances; cinemas subject to the provisions of Entry 60 of List I; sports, entertainments and amusements.\\r\\n34. Betting and gambling.\\r\\n35. Works, lands and buildings vested in or in the possession of the State.\\r\\n37. Elections to the Legislature of the State subject to the provisions of any law made by Parliament.\\r\\n38. Salaries and allowances of members of the Legislature of the State, of the Speaker and Deputy Speaker of the Legislative Assembly and, if there is a Legislative Council, of the Chairman and Deputy Chairman thereof.\\r\\n39. Powers, privileges and immunities of the Legislative Assembly and of the members and the committees thereof, and, if there is a Legislative Council, of that Council and of the members and the committees thereof; enforcement of attendance of persons for giving evidence or producing documents before committees of the Legislature of the State.\\r\\n40. Salaries and allowances of Ministers for the State.\\r\\n41. State public services; State Public Service Commission.\\r\\n42. State pensions, that is to say, pensions payable by the State or out of the Consolidated Fund of the State.\\r\\n43. Public debt of the State.\\r\\n44. Treasure trove.\\r\\n45. Land revenue, including the assessment and collection of revenue, the maintenance of land records, survey for revenue purposes and records of rights, and alienation of revenues.\\r\\n46. Taxes on agricultural income.\\r\\n47. Duties in respect of succession to agricultural land.\\r\\n48. Estate duty in respect of agricultural land.\\r\\n49. Taxes on lands and buildings.\\r\\n50. Taxes on mineral rights subject to any limitations imposed by Parliament by law relating to mineral development.\\r\\n51. Duties of excise on the following goods manufactured or produced in the State and countervailing duties at the same or lower rates on similar goods manufactured or produced elsewhere in India:\\u2014\\r\\n(a) alcoholic liquors for human consumption;\\r\\n(b) opium, Indian hemp and other narcotic drugs and narcotics;\\r\\nbut not including medicinal and toilet preparations containing alcohol or any substance included in sub-paragraph (b) of this entry.\\r\\n53. Taxes on the consumption or sale of electricity.\\r\\n54. Taxes on the sale of petroleum crude, high speed diesel, motor spirit (commonly known as petrol), natural gas, aviation turbine fuel and alcoholic liquor for human consumption, but not including sale in the course of inter-State trade or commerce or sale in the course of international trade or commerce of such goods.]\\r\\n56. Taxes on goods and passengers carried by road or on inland waterways.\\r\\n57. Taxes on vehicles, whether mechanically propelled or not, suitable for use on roads, including tram-cars subject to the provisions of Entry 35 of List III.\\r\\n58. Taxes on animals and boats.\\r\\n59. Tolls.\\r\\n60. Taxes on professions, trades, callings and employments.\\r\\n61. Capitation taxes.\\r\\n62. Taxes on entertainments and amusements to the extent levied and collected by a Panchayat or a Municipality or a Regional Council or a District Council.]\\r\\n63. Rates of stamp duty in respect of documents other than those specified in the provisions of List I with regard to rates of stamp duty.\\r\\n64. Offences against laws with respect to any of the matters in this List.\\r\\n65. Jurisdiction and powers of all courts, except the Supreme Court, with respect to any of the matters in this List.\\r\\n66. Fees in respect of any of the matters in this List, but not including fees taken in any court.\\r\\n\"]}', 1, '2021-02-01 04:21:43', '2021-02-01 04:27:50'),
(76, 'elic9Omjg3pWxHhSxJaLJi7wy', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'SCHEDULE VII', 'LIST III - CONCURRENT LIST', '', '', '{\"1\":[\"CONCURRENT LIST\",\"1. Criminal law, including all matters included in the Indian Penal Code at the commencement of this Constitution but excluding offences against laws with respect to any of the matters specified in List I or List II and excluding the use of naval, military or air forces or any other armed forces of the Union in aid of the civil power.\\r\\n2. Criminal procedure, including all matters included in the Code of Criminal Procedure at the commencement of this Constitution.\\r\\n3. Preventive detention for reasons connected with the security of a State, the maintenance of public order, or the maintenance of supplies and services essential to the community; persons subjected to such detention.\\r\\n4. Removal from one State to another State of prisoners, accused persons and persons subjected to preventive detention for reasons specified in Entry 3 of this List.\\r\\n5. Marriage and divorce; infants and minors; adoption; wills, intestacy and succession; joint family and partition; all matters in respect of which parties in judicial proceedings were immediately before the commencement of this Constitution subject to their personal law.\\r\\n6. Transfer of property other than agricultural land; registration of deeds and documents.\\r\\n7. Contracts including partnership, agency, contracts of carriage, and other special forms of contracts, but not including contracts relating to agricultural land.\\r\\n8. Actionable wrongs.\\r\\n9. Bankruptcy and insolvency.\\r\\n10. Trust and Trustees.\\r\\n11. Administrators-general and official trustees.\\r\\n11-A. Administration of justice; constitution and organisation of all courts, except the Supreme Court and High Courts.]\\r\\n12. Evidence and oaths; recognition of laws, public acts and records, and judicial proceedings.\\r\\n13. Civil procedure, including all matters included in the Code of Civil Procedure at the commencement of this Constitution, limitation and arbitration.\\r\\n14. Contempt of court, but not including contempt of the Supreme Court.\\r\\n15. Vagrancy; nomadic and migratory tribes.\\r\\n16. Lunacy and mental deficiency, including places for the reception or treatment of lunatics and mental deficients.\\r\\n17. Prevention of cruelty to animals.\\r\\n17-A. Forests.\\r\\n17-B. Protection of wild animals and birds.]\\r\\n18. Adulteration of foodstuffs and other goods.\\r\\n19. Drugs and poisons, subject to the provisions of Entry 59 of List I with respect to opium.\\r\\n20. Economic and social planning.\\r\\n845[20-A. Population control and family planning.\\r\\n21. Commercial and industrial monopolies, combines and trusts.\\r\\n22. Trade unions; industrial and labour disputes.\\r\\n23. Social security and social insurance; employment and unemployment.\\r\\n24. Welfare of labour including conditions of work, provident funds, employers\' liability, workmen\'s compensation, invalidity and old age pensions and maternity benefits.\\r\\n25. Education, including technical education, medical education and universities, subject to the provisions of Entries 63, 64, 65 and 66 of List I; vocational and technical training of labour\\r\\n26. Legal, medical and other professions.\\r\\n27. Relief and rehabilitation of persons displaced from their original place of residence by reason of the setting up of the Dominions of India and Pakistan.\\r\\n28. Charities and charitable institutions, charitable and religious endowments and religious institutions.\\r\\n29. Prevention of the extension from one State to another of infectious or contagious diseases or pests affecting men, animals or plants.\\r\\n30. Vital statistics including registration of births and deaths.\\r\\n31. Ports other than those declared by or under law made by Parliament or existing law to be major ports.\\r\\n32. Shipping and navigation on inland waterways as regards mechanically propelled vessels, and the rule of the road on such waterways, and the carriage of passengers and goods on inland waterways subject to the provisions of List I with respect to national waterways.\\r\\n847[33. Trade and commerce in, and the production, supply and distribution of,\\u2014\\r\\n(a) the products of any industry where the control of such industry by the Union is declared by Parliament by law to be expedient in the public interest, and imported goods of the same kind as such products;\\r\\n(b) foodstuffs, including edible oilseeds and oils;\\r\\n(c) cattle fodder, including oilcakes and other concentrates;\\r\\n(d) raw cotton, whether ginned or unginned, and cotton seed; and\\r\\n(e) raw jute.]\\r\\n 33-A. Weights and measures except establishment of standards.]\\r\\n34. Price control.\\r\\n35. Mechanically propelled vehicles including the principles on which taxes on such vehicles are to be levied.\\r\\n36. Factories.\\r\\n37. Boilers.\\r\\n38. Electricity.\\r\\n39. Newspapers, books and printing presses.\\r\\n40. Archaeological sites and remains other than those 849[declared by or under law made by Parliament] to be of national importance.\\r\\n41. Custody, management and disposal of property (including agricultural land) declared by law to be evacuee property.\\r\\n42. Acquisition and requisitioning of property.\\r\\n43. Recovery in a State of claims in respect of taxes and other public demands, including arrears of land-revenue and sums recoverable as such arrears, arising outside that State.\\r\\n44. Stamp duties other than duties or fees collected by means of judicial stamps, but not including rates of stamp duty.\\r\\n45. Inquiries and statistics for the purposes of any of the matters specified in List II or List III.\\r\\n46. Jurisdiction and powers of all courts, except the Supreme Court, with respect to any of the matters in this List.\\r\\n47. Fees in respect of any of the matters in this List, but not including fees taken in any court.\\r\\n\"]}', 1, '2021-02-01 04:26:59', '2021-02-01 04:26:59');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(77, 'RZC5Qb4xZO5rQU4O15HO6zJld', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'SCHEDULE IX', 'See Article 31-B', '', '', '{\"1\":[\"SCHEDULE IX\",\"1. The Bihar Land Reforms Act, 1950 (Bihar Act XXX of 1950).\\r\\n2. The Bombay Tenancy and Agricultural Lands Act, 1948 (Bombay Act LXVII of 1948).\\r\\n3. The Bombay Maleki Tenure Abolition Act, 1949 (Bombay Act LXI of 1949).\\r\\n4. The Bombay Taluqdari Tenure Abolition Act, 1949 (Bombay Act LXII of 1949).\\r\\n5. The Panch Mahals Mehwassi Tenure Abolition Act, 1949 (Bombay Act LXIII of 1949).\\r\\n6. The Bombay Khoti Abolition Act, 1950 (Bombay Act VI of 1950).\\r\\n7. The Bombay Paragana and Kulkarni Watan Abolition Act, 1950 (Bombay Act LX of 1950).\\r\\n8. The Madhya Pradesh Abolition of Proprietary Rights (Estates, Mahals Alienated Lands) Act, 1950 (Madhya Pradesh Act I of 1951).\\r\\n9. The Madras Estates (Abolition and Conversion into Ryotwari) Act, 1948 (Madras Act XXVI of 1948).\\r\\n10. The Madras Estates (Abolition and Conversion into Ryotwari) Amendment Act, 1950 (Madras Act I of 1950).\\r\\n11. The Uttar Pradesh Zamindari Abolition and Land Reforms Act, 1950 (Uttar Pradesh Act I of 1951).\\r\\n12. The Hyderabad (Abolition of Jagirs) Regulation, 1358F (No. LXIX of 1358, Fasli).\\r\\n13. The Hyderabad Jagirs (Commutation) Regulation, 1359F (No. XXV of 1359, Fasli).\\r\\n 14. The Bihar Displaced Persons Rehabilitation (Acquisition of Land) Act, 1950 (Bihar Act XXXVIII of 1950).\\r\\n15. The United Provinces Land Acquisition (Rehabilitation of Refugees) Act, 1948 (U.P. Act XXVI of 1948).\\r\\n16. The Resettlement of Displaced Persons (Land Acquisition) Act, 1948 (Act LX of 1948).\\r\\n17. Sections 52A to 52G of the Insurance Act, 1938 (Act IV of 1938), as inserted by Section 42 of the Insurance (Amendment) Act, 1950 (Act XLVII of 1950).\\r\\n18. The Railway Companies (Emergency Provisions) Act, 1951 (Act LI of 1951).\\r\\n19. Chapter III-A of the Industries (Development and Regulation) Act, 1951 (Act LXV of 1951), as inserted by Section 13 of the Industries (Development and Regulation) Amendment Act, 1953 (Act XXVI of 1953).\\r\\n20. The West Bengal Land Development and Planning Act, 1948 (West Bengal Act XXI of 1948), as amended by West Bengal Act XXIX of 1951.]\\r\\n21. The Andhra Pradesh Ceiling on Agricultural Holdings Act, 1961 (Andhra Pradesh Act X of 1961).\\r\\n22. The Andhra Pradesh (Telangana Area) Tenancy and Agricultural Lands (Validation) Act, 1961 (Andhra Pradesh Act XXI of 1961).\\r\\n23. The Andhra Pradesh (Telangana Area) Ijara and Kowli Land Cancellation of Irregular Pattas and Abolition of Concessional Assessment Act, 1961 (Andhra Pradesh Act XXXVI of 1961).\\r\\n24. The Assam State Acquisition of Lands Belonging to Religious or Charitable Institution of Public Nature Act, 1959 (Assam Act IX of 1961).\\r\\n25. The Bihar Land Reforms (Amendment) Act, 1953 (Bihar Act XX of 1954).\\r\\n26. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) Act, 1961 (Bihar Act XII of 1962), (except Section 28 of this Act).\\r\\n27. The Bombay Taluqdari Tenure Abolition (Amendment) Act, 1954 (Bombay Act I of 1955).\\r\\n28. The Bombay Taluqdari Tenure Abolition (Amendment) Act, 1957 (Bombay Act XVIII of 1958).\\r\\n29. The Bombay Inams (Kutch Area) Abolition Act, 1958 (Bombay Act XCVIII of 1958).\\r\\n30. The Bombay Tenancy and Agricultural Lands (Gujarat Amendment) Act, 1960 (Gujarat Act XVI of 1960).\\r\\n31. The Gujarat Agricultural Lands Ceiling Act, 1960 (Gujarat Act XXVII of 1961).\\r\\n32. The Sagbara and Mehwassi Estates (Proprietary Rights Abolition, etc.) Regulation, 1962 (Gujarat Regulation I of 1962).\\r\\n33. The Gujarat Surviving Alienations Abolition Act, 1963 (Gujarat Act XXXIII of 1963), except in so far as this Act relates to an alienation referred to in sub-clause (d) of clause (3) of Section 2 thereof.\\r\\n34. The Maharashtra Agricultural Lands (Ceiling on Holdings) Act, 1961 (Maharashtra Act XXVII of 1961).\\r\\n35. The Hyderabad Tenancy and Agricultural Lands (Re-enactment, Validation and Further Amendment) Act, 1961 (Maharashtra Act XLV of 1961).\\r\\n36. The Hyderabad Tenancy and Agricultural Lands Act, 1950 (Hyderabad Act XXI of 1950).\\r\\n37. The Jenmikaram Payment (Abolition) Act, 1960 (Kerala Act III of 1961).\\r\\n38. The Kerala Land Tax Act, 1961 (Kerala Act XIII of 1961).\\r\\n39. The Kerala Land Reforms Act, 1963 (Kerala Act I of 1964).\\r\\n40. The Madhya Pradesh Land Revenue Code, 1959 (Madhya Pradesh Act XX of 1959).\\r\\n41. The Madhya Pradesh Ceiling on Agricultural Holdings Act, 1960 (Madhya Pradesh Act XX of 1960).\\r\\n42. The Madras Cultivating Tenants Protection Act, 1955 (Madras Act XXV of 1955).\\r\\n43. The Madras Cultivating Tenants (Payment of Fair Rent) Act, 1956 (Madras Act XXIV of 1956).\\r\\n44. The Madras Occupants of Kudiyiruppu (Protection from Eviction) Act, 1961 (Madras Act XXXVIII of 1961).\\r\\n45. The Madras Public Trusts (Regulation of Administration of Agricultural Lands) Act, 1961 (Madras Act LVII of 1961).\\r\\n46. The Madras Land Reforms (Fixation of Ceiling on Land) Act, 1961 (Madras Act LVIII of 1961).\\r\\n47. The Mysore Tenancy Act, 1952 (Mysore Act XIII of 1952).\\r\\n48. The Coorg Tenants Act, 1957 (Mysore Act XIV of 1957).\\r\\n49. The Mysore Village Offices Abolition Act, 1961 (Mysore Act XIV of 1961).\\r\\n50. The Hyderabad Tenancy and Agricultural Lands (Validation) Act, 1961 (Mysore Act XXXVI of 1961).\\r\\n51. The Mysore Land Reforms Act, 1961 (Mysore Act X of 1962).\\r\\n52. The Orissa Land Reforms Act, 1960 (Orissa Act XVI of 1960).\\r\\n53. The Orissa Merged Territories (Village Offices Abolition) Act, 1963 (Orissa Act X of 1963).\\r\\n54. The Punjab Security of Land Tenures Act, 1953 (Punjab Act X of 1953).\\r\\n55. The Rajasthan Tenancy Act, 1955 (Rajasthan Act III of 1955).\\r\\n56. The Rajasthan Zamindari and Biswedari Abolition Act, 1959 (Rajasthan Act VIII of 1959).\\r\\n57. The Kumaun and Uttarakhand Zamindari Abolition and Land Reforms Act, 1960 (Uttar Pradesh Act XVII of 1960).\\r\\n58. The Uttar Pradesh Imposition of Ceiling on Land Holdings Act, 1960 (Uttar Pradesh Act I of 1961).\\r\\n59. The West Bengal Estates Acquisition Act, 1953 (West Bengal Act I of 1954).\\r\\n60. The West Bengal Land Reforms Act, 1955 (West Bengal Act X of 1956).\\r\\n61. The Delhi Land Reforms Act, 1954 (Delhi Act VIII of 1954).\\r\\n62. The Delhi Land Holdings (Ceiling) Act, 1960 (Central Act 24 of 1960).\\r\\n63. The Manipur Land Revenue and Land Reforms Act, 1960 (Central Act 33 of 1960).\\r\\n64. The Tripura Land Revenue and Land Reforms Act, 1960 (Central Act 43 of 1960).866]\\r\\n867[65. The Kerala Land Reforms (Amendment) Act, 1969 (Kerala Act 35 of 1969).\\r\\n66. The Kerala Land Reforms (Amendment) Act, 1971 (Kerala Act 25 of 1971).]\\r\\n868[67. The Andhra Pradesh Land Reforms (Ceiling on Agricultural Holdings) Act, 1973 (Andhra Pradesh Act I of 1973).\\r\\n68. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1972 (Bihar Act I of 1973).\\r\\n69. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1973 (Bihar Act IX of 1973).\\r\\n70. The Bihar Land Reforms (Amendment) Act, 1972 (Bihar Act V of 1972).\\r\\n71. The Gujarat Agricultural Lands Ceiling (Amendment) Act, 1972 (Gujarat Act 2 of 1974).\\r\\n72. The Haryana Ceiling on Land Holdings Act, 1972 (Haryana Act 26 of 1972).\\r\\n73. The Himachal Pradesh Ceiling on Land Holdings Act, 1972 (Himachal Pradesh Act 19 of 1973).\\r\\n74. The Kerala Land Reforms (Amendment) Act, 1972 (Kerala Act 17 of 1972).\\r\\n75. The Madhya Pradesh Ceiling on Agricultural Holdings (Amendment) Act, 1972 (Madhya Pradesh Act 12 of 1974).\\r\\n76. The Madhya Pradesh Ceiling or Agricultural Holdings (Second Amendment) Act, 1972 (Madhya Pradesh Act 13 of 1974).\\r\\n77. The Mysore Land Reforms (Amendment) Act, 1973 (Karnataka Act 1 of 1974).\\r\\n78. The Punjab Land Reforms Act, 1972 (Punjab Act 10 of 1973).\\r\\n79. The Rajasthan Imposition of Ceiling on Agricultural Holdings Act, 1973 (Rajasthan Act 11 of 1973).\\r\\n80. The Gudalur Janmam Estates (Abolition and Conversion into Ryotwari) Act, 1969 (Tamil Nadu Act 24 of 1969).\\r\\n81. The West Bengal Land Reforms (Amendment) Act, 1972 (West Bengal Act XII of 1972).\\r\\n82. The West Bengal Estates Acquisition (Amendment) Act, 1964 (West Bengal Act XXII of 1964).\\r\\n83. The West Bengal Estates Acquisition (Second Amendment) Act, 1973 (West Bengal Act XXXIII of 1973).\\r\\n84. The Bombay Tenancy and Agricultural Lands (Gujarat Amendment Act, 1972 (Gujarat Act 5 of 1973).\\r\\n85. The Orissa Land Reforms (Amendment) Act, 1974 (Orissa Act 9 of 1974).\\r\\n86. The Tripura Land Revenue and Land Reforms (Second Amendment) Act, 1974 (Tripura Act 7 of 1974).]\\r\\n869[87. 870{* * *}.]\\r\\n88. The Industries (Development and Regulation) Act, 1951 (Central Act 65 of 1951).\\r\\n89. The Requisitioning and Acquisition of Immovable Property Act, 1952 (Central Act 30 of 1952).\\r\\n90. The Mines and Minerals (Regulation and Development) Act, 1957 (Central Act 67 of 1957).\\r\\n91. The Monopolies and Restrictive Trade Practices Act, 1969 (Central Act 54 of 1969).\\r\\n92. 871[* * *].\\r\\n93. The Coking Coal Mines (Emergency Provisions) Act, 1971 (Central Act 64 of 1971).\\r\\n94. The Coking Coal Mines (Nationalisation) Act, 1972 (Central Act 36 of 1972).\\r\\n95. The General Insurance Business (Nationalisation) Act, 1972 (Central Act 57 of 1972).\\r\\n96. The Indian Copper Corporation (Acquisition of Undertaking) Act, 1972 (Central Act 58 of 1972).\\r\\n97. The Sick Textile Undertakings (Taking Over of Management) Act, 1972 (Central Act 72 of 1972).\\r\\n98. The Coal Mines (Taking Over of Management) Act, 1973 (Central Act 15 of 1973).\\r\\n99. The Coal Mines (Nationalisation) Act, 1973 (Central Act 26 of 1973).\\r\\n100. The Foreign Exchange Regulation Act, 1973 (Central Act 46 of 1973).\\r\\n101. The Alcock Ashdown Company Limited (Acquisition of Undertakings) Act, 1973 (Central Act 56 of 1973).\\r\\n102. The Coal Mines (Conservation and Development) Act, 1974 (Central Act 28 of 1974).\\r\\n103. The Additional Emoluments (Compulsory Deposit) Act, 1974 (Central Act 37 of 1974).\\r\\n104. The Conservation of Foreign Exchange and Prevention of Smuggling Activities Act, 1974 (Central Act 52 of 1974).\\r\\n105. The Sick Textile Undertakings (Nationalisation) Act, 1974 (Central Act 57 of 1974).\\r\\n106. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1964 (Maharashtra Act XVI of 1965).\\r\\n107. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1965 (Maharashtra Act XXXII of 1965).\\r\\n108. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1968 (Maharashtra Act XVI of 1968).\\r\\n109. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Second Amendment) Act, 1968 (Maharashtra Act XXXIII of 1968).\\r\\n110. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1969 (Maharashtra Act XXXVII of 1969).\\r\\n111. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Second Amendment) Act, 1969 (Maharashtra Act XXXVIII of 1969).\\r\\n112. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1970 (Maharashtra Act XXVII of 1970).\\r\\n113. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1972 (Maharashtra Act XIII of 1972).\\r\\n114. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1973 (Maharashtra Act L of 1973).\\r\\n115. The Orissa Land Reforms (Amendment) Act, 1965 (Orissa Act 13 of 1965).\\r\\n116. The Orissa Land Reforms (Amendment) Act, 1966 (Orissa Act 8 of 1967).\\r\\n117. The Orissa Land Reforms (Amendment) Act, 1967 (Orissa Act 13 of 1967).\\r\\n118. The Orissa Land Reforms (Amendment) Act, 1969 (Orissa Act 13 of 1969).\\r\\n119. The Orissa Land Reforms (Amendment) Act, 1970 (Orissa Act 18 of 1970).\\r\\n120. The Uttar Pradesh Imposition of Ceiling on Land Holdings (Amendment) Act, 1972 (Uttar Pradesh Act 18 of 1973).\\r\\n121. The Uttar Pradesh Imposition of Ceiling on Land Holdings (Amendment) Act, 1974 (Uttar Pradesh Act 2 of 1975).\\r\\n122. The Tripura Land Revenue and Land Reforms (Third Amendment) Act, 1975 (Tripura Act 3 of 1975).\\r\\n123. The Dadra and Nagar Haveli Land Reforms Regulation, 1971 (3 of 1971).\\r\\n124. The Dadra and Nagar Haveli Land Reforms (Amendment) Regulation, 1973 (5 of 1973).]\\r\\n872[125.   Section 66A and Chapter IVA of the Motor Vehicles Act, 1939* (Central Act 4 of 1939).\\r\\n126. The Essential Commodities Act, 1955 (Central Act 10 of 1955).\\r\\n127. The Smugglers and Foreign Exchange Manipulators (Forfeiture of Property) Act, 1976 (Central Act 13 of 1976).\\r\\n128. The Bonded Labour System (Abolition) Act, 1976 (Central Act 19 of 1976).\\r\\n129. The Conservation of Foreign Exchange and Prevention of Smuggling Activities (Amendment) Act, 1976 (Central Act 20 of 1976).\\r\\n130. 873[* * *]\\r\\n131. The Levy Sugar Price Equalisation Fund Act, 1976 (Central Act 31 of 1976).\\r\\n132. The Urban Land (Ceiling and Regulation) Act, 1976 (Central Act 33 of 1976).\\r\\n133. The Departmentalisation of Union Accounts (Transfer of Personnel) Act, 1976 (Central Act 59 of 1976).\\r\\n134. The Assam Fixation of Ceiling on Land Holdings Act, 1956 (Assam Act I of 1957).\\r\\n135. The Bombay Tenancy and Agricultural Lands (Vidarbha Region) Act, 1958 (Bombay Act XCIX of 1958).\\r\\n136. The Gujarat Private Forests (Acquisition) Act, 1972 (Gujarat Act 14 of 1973).\\r\\n137. The Haryana Ceiling on Land Holdings (Amendment) Act, 1976 (Haryana Act 17 of 1976).\\r\\n138. The Himachal Pradesh Tenancy and Land Reforms Act, 1972 (Himachal Pradesh Act 8 of 1974).\\r\\n139. The Himachal Pradesh Village Common Lands Vesting and Utilization Act, 1974 (Himachal Pradesh Act 18 of 1974).\\r\\n140. The Karnataka Land Reforms (Second Amendment and Miscellaneous Provisions) Act, 1974 (Karnataka Act 31 of 1974).\\r\\n141. The Karnataka Land Reforms (Second Amendment) Act, 1976 (Karnataka Act 27 of 1976).\\r\\n142. The Kerala Prevention of Eviction Act, 1966 (Kerala Act 12 of 1966).\\r\\n143. The Thiruppuvaram Payment (Abolition) Act, 1969 (Kerala Act 19 of 1969).\\r\\n144. The Sreepadam Lands Enfranchisement Act, 1969 (Kerala Act 20 of 1969).\\r\\n145. The Sree Pandaravaka Lands (Vesting and Enfranchisement) Act, 1971 (Kerala Act 20 of 1971).\\r\\n146. The Kerala Private Forests (Vesting and Assignment) Act, 1971 (Kerala Act 26 of 1971).\\r\\n147. The Kerala Agricultural Workers Act, 1974 (Kerala Act 18 of 1974).\\r\\n148. The Kerala Cashew Factories (Acquisition) Act, 1974 (Kerala Act 29 of 1974).\\r\\n149. The Kerala Chitties Act, 1975 (Kerala Act 23 of 1975).\\r\\n150. The Kerala Scheduled Tribes (Restriction on Transfer of Lands and Restoration of Alienated Lands) Act, 1975 (Kerala Act 31 of 1975).\\r\\n151. The Kerala Land Reforms (Amendment) Act, 1976 (Kerala Act 15 of 1976).\\r\\n152. The Kanam Tenancy Abolition Act, 1976 (Kerala Act 16 of 1976).\\r\\n153. The Madhya Pradesh Ceiling on Agricultural Holdings (Amendment) Act, 1974 (Madhya Pradesh Act 20 of 1974).\\r\\n154. The Madhya Pradesh Ceiling on Agricultural Holdings (Amendment) Act, 1975 (Madhya Pradesh Act 2 of 1976).\\r\\n155. The West Khandesh Mehwassi Estates (Proprietary Rights Abolition, etc.) Regulation, 1961 (Maharashtra Regulation I of 1962).\\r\\n156. The Maharashtra Restoration of Lands to Scheduled Tribes Act, 1974 (Maharashtra Act XIV of 1975).\\r\\n157. The Maharashtra Agricultural Lands (Lowering of Ceiling on Holdings) and (Amendment) Act, 1972 (Maharashtra Act XXI of 1975).\\r\\n158. The Maharashtra Private Forests (Acquisition) Act, 1975 (Maharashtra Act XXIX of 1975).\\r\\n159. The Maharashtra Agricultural Lands (Lowering of Ceiling on Holdings) and (Amendment) Amendment Act, 1975 (Maharashtra Act XLVII of 1975).\\r\\n160. The Maharashtra Agricultural Lands (Ceiling on Holdings) (Amendment) Act, 1975 (Maharashtra Act II of 1976).\\r\\n161. The Orissa Estates Abolition Act, 1951 (Orissa Act I of 1952).\\r\\n162. The Rajasthan Colonisation Act, 1954 (Rajasthan Act XXVII of 1954).\\r\\n163. The Rajasthan Land Reforms and Acquisition of Landowners\' Estates Act, 1963 (Rajasthan Act 11 of 1964).\\r\\n164. The Rajasthan Imposition of Ceiling on Agricultural Holdings (Amendment) Act, 1976 (Rajasthan Act 8 of 1976).\\r\\n165. The Rajasthan Tenancy (Amendment) Act, 1976 (Rajasthan Act 12 of 1976).\\r\\n166. The Tamil Nadu Land Reforms (Reduction of Ceiling on Land) Act, 1970 (Tamil Nadu Act 17 of 1970).\\r\\n167. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1971 (Tamil Nadu Act 41 of 1971).\\r\\n168. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1972 (Tamil Nadu Act 10 of 1972).\\r\\n169. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1972 (Tamil Nadu Act 20 of 1972).\\r\\n170. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Third Amendment Act, 1972 (Tamil Nadu Act 37 of 1972).\\r\\n171. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Fourth Amendment Act, 1972 (Tamil Nadu Act 39 of 1972).\\r\\n172. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Sixth Amendment Act, 1972 (Tamil Nadu Act 7 of 1974).\\r\\n173. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Fifth Amendment Act, 1972 (Tamil Nadu Act 10 of 1974).\\r\\n174. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1974 (Tamil Nadu Act 15 of 1974).\\r\\n175. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Third Amendment Act, 1974 (Tamil Nadu Act 30 of 1974).\\r\\n176. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1974 (Tamil Nadu Act 32 of 1974).\\r\\n177. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1975 (Tamil Nadu Act 11 of 1975).\\r\\n178. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1975 (Tamil Nadu Act 21 of 1975).\\r\\n179. Amendments made to the Uttar Pradesh Zamindari Abolition and Land Reforms Act, 1950 (Uttar Pradesh Act I of 1951) by the Uttar Pradesh Land Laws (Amendment) Act, 1971 (Uttar Pradesh Act 21 of 1971) and the Uttar Pradesh Land Laws (Amendment) Act, 1974 (Uttar Pradesh Act 34 of 1974).\\r\\n180. The Uttar Pradesh Imposition of Ceiling on Land Holdings (Amendment) Act, 1976 (Uttar Pradesh Act 20 of 1976).\\r\\n181. The West Bengal Land Reforms (Second Amendment) Act, 1972 (West Bengal Act XXVIII of 1972).\\r\\n182. The West Bengal Restoration of Alienated Land Act, 1973 (West Bengal Act XXIII of 1973).\\r\\n183. The West Bengal Land Reforms (Amendment) Act, 1974 (West Bengal Act XXXIII of 1974).\\r\\n184. The West Bengal Land Reforms (Amendment) Act, 1975 (West Bengal Act XXIII of 1975).\\r\\n185. The West Bengal Land Reforms (Amendment) Act, 1976 (West Bengal Act XII of 1976).\\r\\n186. The Delhi Land Holdings (Ceiling) Amendment Act, 1976 (Central Act 15 of 1976).\\r\\n187. The Goa, Daman and Diu Mundkars (Protection from Eviction) Act, 1975 (Goa, Daman and Diu Act I of 1976).\\r\\n188. The Pondicherry Land Reforms (Fixation of Ceiling on Land) Act, 1973 (Pondicherry Act 9 of 1974).]\\r\\n874[189. The Assam (Temporarily Settled Areas) Tenancy Act, 1971 (Assam Act XXIII of 1971).\\r\\n190. The Assam (Temporarily Settled Areas) Tenancy (Amendment) Act, 1974 (Assam Act XVIII of 1974).\\r\\n191. The Bihar Land Reforms (Fixation of Ceiling area and Acquisition of Surplus Land) (Amendment) (Amending) Act, 1974 (Bihar Act 13 of 1975).\\r\\n192. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1976 (Bihar Act 22 of 1976).\\r\\n193. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1978 (Bihar Act VII of 1978).\\r\\n194. The Land Acquisition (Bihar Amendment) Act, 1979 (Bihar Act 2 of 1980).\\r\\n195. The Haryana Ceiling on Land Holdings (Amendment) Act, 1977 (Haryana Act 14 of 1977).\\r\\n196. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1978 (Tamil Nadu Act 25 of 1978).\\r\\n197. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1979 (Tamil Nadu Act 11 of 1979).\\r\\n198. The Uttar Pradesh Zamindari Abolition Laws (Amendment) Act, 1978 (Uttar Pradesh Act 15 of 1978).\\r\\n199. The West Bengal Restoration of Alienated Land (Amendment) Act, 1978 (West Bengal Act XXIV of 1978).\\r\\n200. The West Bengal Restoration of Alienated Land (Amendment) Act, 1980 (West Bengal Act LVI of 1980).\\r\\n201. The Goa, Daman and Diu Agricultural Tenancy Act, 1964 (Goa, Daman and Diu Act 7 of 1964).\\r\\n202. The Goa, Daman and Diu Agricultural Tenancy (Fifth Amendment) Act, 1976 (Goa, Daman and Diu Act 17 of 1976).]\\r\\n875[203. The Andhra Pradesh Scheduled Areas Land Transfer Regulation, 1959 (Andhra Pradesh Regulation 1 of 1959).\\r\\n204. The Andhra Pradesh Scheduled Areas Laws (Extension and Amendment) Regulation, 1963 (Andhra Pradesh Regulation 2 of 1963).\\r\\n205. The Andhra Pradesh Scheduled Areas Land Transfer (Amendment) Regulation, 1970 (Andhra Pradesh Regulation 1 of 1970).\\r\\n206. The Andhra Pradesh Scheduled Areas Land Transfer (Amendment) Regulation, 1971 (Andhra Pradesh Regulation 1 of 1971).\\r\\n207. The Andhra Pradesh Scheduled Areas Land Transfer (Amendment) Regulation, 1978 (Andhra Pradesh Regulation 1 of 1978).\\r\\n208. The Bihar Tenancy Act, 1885 (Bihar Act 8 of 1885).\\r\\n209. The Chota Nagpur Tenancy Act, 1908 (Bengal Act 6 of 1908) (Chapter VIII Sections 46, 47, 48, 48-A and 49; Chapter X, Sections 71, 71-A and 71-B; and Chapter XVIII, Sections 240, 241 and 242).\\r\\n210. The Santhal Parganas Tenancy (Supplementary Provisions) Act, 1949 (Bihar Act 14 of 1949) except Section 53.\\r\\n211. The Bihar Scheduled Areas Regulation, 1969 (Bihar Regulation 1 of 1969).\\r\\n212. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1982 (Bihar Act 55 of 1982).\\r\\n213. The Gujarat Devasthan Inams Abolition Act, 1969 (Gujarat Act 16 of 1969).\\r\\n214. The Gujarat Tenancy Laws (Amendment) Act, 1976 (Gujarat Act 37 of 1976).\\r\\n215. The Gujarat Agricultural Lands Ceiling (Amendment) Act, 1976 (President\'s Act 43 of 1976).\\r\\n216. The Gujarat Devasthan Inams Abolition (Amendment) Act, 1977 (Gujarat Act 27 of 1977).\\r\\n217. The Gujarat Tenancy Laws (Amendment) Act, 1977 (Gujarat Act 30 of 1977).\\r\\n218. The Bombay Land Revenue (Gujarat Second Amendment) Act, 1980 (Gujarat Act 37 of 1980).\\r\\n219. The Bombay Land Revenue Code and Land Tenure Abolition Laws (Gujarat Amendment) Act, 1982 (Gujarat Act 8 of 1982).\\r\\n220. The Himachal Pradesh Transfer of Land (Regulation) Act, 1968 (Himachal Pradesh Act 15 of 1969).\\r\\n221. The Himachal Pradesh Transfer of Land (Regulation) (Amendment) Act, 1986 (Himachal Pradesh Act 16 of 1986).\\r\\n222. The Karnataka Scheduled Castes and Scheduled Tribes (Prohibition of Transfer of Certain Lands) Act, 1978 (Karnataka Act 2 of 1979).\\r\\n223. The Kerala Land Reforms (Amendment) Act, 1978 (Kerala Act 13 of 1978).\\r\\n224. The Kerala Land Reforms (Amendment) Act, 1981 (Kerala Act 19 of 1981).\\r\\n225. The Madhya Pradesh Land Revenue Code (Third Amendment) Act, 1976 (Madhya Pradesh Act 61 of 1976).\\r\\n226. The Madhya Pradesh Land Revenue Code (Amendment) Act, 1980 (Madhya Pradesh Act 15 of 1980).\\r\\n227. The Madhya Pradesh Akrishik Jot Uchchatam Seema Adhiniyam, 1981 (Madhya Pradesh Act 11 of 1981).\\r\\n228. The Madhya Pradesh Ceiling on Agricultural Holdings (Second Amendment) Act, 1976 (Madhya Pradesh Act 1 of 1984).\\r\\n229. The Madhya Pradesh Ceiling on Agricultural Holdings (Amendment) Act, 1984 (Madhya Pradesh Act 14 of 1984).\\r\\n230. The Madhya Pradesh Ceiling on Agricultural Holdings (Amendment) Act, 1989 (Madhya Pradesh Act 8 of 1989).\\r\\n231. The Maharashtra Land Revenue Code, 1966 (Maharashtra Act 41 of 1966), Sections 36, 36-A and 36-B.\\r\\n232. The Maharashtra Land Revenue Code and the Maharashtra Restoration of Lands to Scheduled Tribes (Second Amendment) Act, 1976 (Maharashtra Act 30 of 1977).\\r\\n233. The Maharashtra Abolition of Subsisting Proprietary Rights to Mines and Minerals in Certain Lands Act, 1985 (Maharashtra Act 16 of 1985).\\r\\n234. The Orissa Scheduled Areas Transfer of Immovable Property (By Scheduled Tribes) Regulation, 1956 (Orissa Regulation 2 of 1956).\\r\\n235. The Orissa Land Reforms (Second Amendment) Act, 1975 (Orissa Act 29 of 1976).\\r\\n236. The Orissa Land Reforms (Amendment) Act, 1976 (Orissa Act 30 of 1976).\\r\\n237. The Orissa Land Reforms (Second Amendment) Act, 1976 (Orissa Act 44 of 1976).\\r\\n238. The Rajasthan Colonisation (Amendment) Act, 1984 (Rajasthan Act 12 of 1984).\\r\\n239. The Rajasthan Tenancy (Amendment) Act, 1984 (Rajasthan Act 13 of 1984).\\r\\n240. The Rajasthan Tenancy (Amendment) Act, 1987 (Rajasthan Act 21 of 1987).\\r\\n241. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1979 (Tamil Nadu Act 8 of 1980).\\r\\n242. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1980 (Tamil Nadu Act 21 of 1980).\\r\\n243. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Amendment Act, 1981 (Tamil Nadu Act 59 of 1981).\\r\\n244. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1983 (Tamil Nadu Act 2 of 1984).\\r\\n245. The Uttar Pradesh Land Laws (Amendment) Act, 1982 (Uttar Pradesh Act 20 of 1982).\\r\\n246. The West Bengal Land Reforms (Amendment) Act, 1965 (West Bengal Act 18 of 1965).\\r\\n247. The West Bengal Land Reforms (Amendment) Act, 1966 (West Bengal Act 11 of 1966).\\r\\n248. The West Bengal Land Reforms (Second Amendment) Act, 1969 (West Bengal Act 23 of 1969).\\r\\n249. The West Bengal Estate Acquisition (Amendment) Act, 1977 (West Bengal Act 36 of 1977).\\r\\n250. The West Bengal Land Holding Revenue Act, 1979 (West Bengal Act 44 of 1979).\\r\\n251. The West Bengal Land Reforms (Amendment) Act, 1980 (West Bengal Act 41 of 1980).\\r\\n252. The West Bengal Land Holding Revenue (Amendment) Act, 1981 (West Bengal Act 33 of 1981).\\r\\n253. The Calcutta Thikka Tenancy (Acquisition and Regulation) Act, 1981 (West Bengal Act 37 of 1981).\\r\\n254. The West Bengal Land Holding Revenue (Amendment) Act, 1982 (West Bengal Act 23 of 1982).\\r\\n255. The Calcutta Thikka Tenancy (Acquisition and Regulation) (Amendment) Act, 1984 (West Bengal Act 41 of 1984).\\r\\n256. The Mahe Land Reforms Act, 1968 (Pondicherry Act 1 of 1968).\\r\\n257. The Mahe Land Reforms (Amendment) Act, 1980 (Pondicherry Act 1 of 1981).]\\r\\n876[257-A. The Tamil Nadu Backward Classes, Scheduled Castes and Scheduled Tribes (Reservation of Seats in Educational Institutions and of Appointments or Posts in the Services under the State) Act, 1993 (Tamil Nadu Act, 45 of 1994).]\\r\\n877[258. The Bihar Privileged Persons Homestead Tenancy Act, 1947 (Bihar Act 4 of 1948).\\r\\n259. The Bihar Consolidation of Holdings and Prevention of Fragmentation Act, 1956 (Bihar Act 22 of 1956).\\r\\n260. The Bihar Consolidation of Holdings and Prevention of Fragmentation (Amendment) Act, 1970 (Bihar Act 7 of 1970).\\r\\n261. The Bihar Privileged Persons Homestead Tenancy (Amendment) Act, 1970 (Bihar Act 9 of 1970).\\r\\n262. The Bihar Consolidation of Holdings and Prevention of Fragmentation (Amendment) Act, 1973 (Bihar Act 27 of 1975).\\r\\n263. The Bihar Consolidation of Holdings and Prevention of Fragmentation (Amendment) Act, 1981 (Bihar Act 35 of 1982).\\r\\n264. The Bihar Land Reforms (Fixation of Ceiling Area and Acquisition of Surplus Land) (Amendment) Act, 1987 (Bihar Act 21 of 1987).\\r\\n265. The Bihar Privileged Persons Homestead Tenancy (Amendment) Act, 1989 (Bihar Act 11 of 1989).\\r\\n266. The Bihar Land Reforms (Amendment) Act, 1989 (Bihar Act 11 of 1990).\\r\\n267. The Karnataka Scheduled Castes and Scheduled Tribes (Prohibition of Transfer of Certain Lands) (Amendment) Act, 1984 (Karnataka Act 3 of 1984).\\r\\n268. The Kerala Land Reforms (Amendment) Act, 1989 (Kerala Act 16 of 1989).\\r\\n269. The Kerala Land Reforms (Second Amendment) Act, 1989 (Kerala Act 2 of 1990).\\r\\n270. The Orissa Land Reforms (Amendment) Act, 1989 (Orissa Act 9 of 1990).\\r\\n271. The Rajasthan Tenancy (Amendment) Act, 1979 (Rajasthan Act 16 of 1979).\\r\\n272. The Rajasthan Colonisation (Amendment) Act, 1987 (Rajasthan Act 2 of 1987).\\r\\n273. The Rajasthan Colonisation (Amendment) Act, 1989 (Rajasthan Act 12 of 1989).\\r\\n274. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) (Amendment) Act, 1983 (Tamil Nadu Act 3 of 1984).\\r\\n275. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) (Amendment) Act, 1986 (Tamil Nadu Act 57 of 1986).\\r\\n276. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) Second Amendment Act, 1987 (Tamil Nadu Act 4 of 1988).\\r\\n277. The Tamil Nadu Land Reforms (Fixation of Ceiling on Land) (Amendment) Act, 1989 (Tamil Nadu Act 30 of 1989).\\r\\n278. The West Bengal Land Reforms (Amendment) Act, 1981 (West Bengal Act 50 of 1981).\\r\\n279. The West Bengal Land Reforms (Amendment) Act, 1986 (West Bengal Act 5 of 1986).\\r\\n280. The West Bengal Land Reforms (Second Amendment) Act, 1986 (West Bengal Act 19 of 1986).\\r\\n281. The West Bengal Land Reforms (Third Amendment) Act, 1986 (West Bengal Act 35 of 1986).\\r\\n282. The West Bengal Land Reforms (Amendment) Act, 1989 (West Bengal Act 23 of 1989).\\r\\n283. The West Bengal Land Reforms (Amendment) Act, 1990 (West Bengal Act 24 of 1990).\\r\\n284. The West Bengal Land Reforms Tribunal Act, 1991 (West Bengal Act 12 of 1991).]\\r\\n878[Explanation.\\u2014Any acquisition made under the Rajasthan Tenancy Act, 1955 (Rajasthan Act III of 1955), in contravention of the second proviso to clause (1) of Article 31-A shall, to the extent of the contravention, be void.\\r\\n\"]}', 1, '2021-02-01 04:31:34', '2021-02-01 04:31:34'),
(78, 'rDwDQ3F4obS0OPM4HG3VLK9Nq', '4a0AOf3PSfE5pAOfCZv1OJ4zu', 'SCHEDULE X', 'PROVISIONS AS TO DISQUALIFICATION ON GROUND OF DEFECTION', '', '', '{\"1\":[\"PROVISIONS AS TO DISQUALIFICATION ON GROUND OF DEFECTION\",\"1. Interpretation.\\u2014In this Schedule, unless the context otherwise requires,\\u2014\\r\\n(a) \\u201cHouse\\u201d means either House of Parliament or the Legislative Assembly or, as the case may be, either House of the Legislature of a State;\\r\\n(b) \\u201clegislature party\\u201d, in relation to a member of a House belonging to any political party in accordance with the provisions of paragraph 2 or 880{* * *}, Paragraph 4, means the group consisting of all the members of that House for the time being belonging to that political party in accordance with the said provisions;\\r\\n(c) \\u201coriginal political party\\u201d, in relation to a member of a House, means the political party to which he belongs for the purposes of sub-paragraph (1) of Paragraph 2;\\r\\n(d) \\u201cparagraph\\u201d means a paragraph of this Schedule.\\r\\n2. Disqualification on ground of defection.\\u2014(1) Subject to the provisions of paragraphs 881{* * *} 4 and 5, a member of a House belonging to any political party shall be disqualified for being a member of the House\\u2014\\r\\n(a) if he has voluntarily given up his membership of such political party; or\\r\\n(b) if he votes or abstains from voting in such House contrary to any direction issued by the political party to which he belongs or by any person or authority authorised by it in this behalf, without obtaining, in either case, the prior permission of such political party, person or authority, and such voting or abstention has not been condoned by such political party, person or authority within fifteen days from the date of such voting or abstention.\\r\\nExplanation.\\u2014 For the purposes of this sub-paragraph,\\u2014\\r\\n(a) an elected member of a House shall be deemed to belong to the political party, if any, by which he was set up as a candidate for election as such member;\\r\\n(b) a nominated member of a House shall,\\u2014\\r\\n(i) where he is a member of any political party on the date of his nomination as such member, be deemed to belong to such political party;\\r\\n(ii) in any other case, be deemed to belong to the political party of which he becomes, or, as the case may be, first becomes, a member before the expiry of six months from the date on which he takes his seat after complying with the requirements of Article 99 or, as the case may be, Article 188.\\r\\n(2) An elected member of a House who has been elected as such otherwise than as a candidate set up by any political party shall be disqualified for being a member of the House if he joins any political party after such election.\\r\\n(3) A nominated member of a House shall be disqualified for being a member of the House if he joins any political party after the expiry of six months from the date on which he takes his seat after complying with the requirements of Article 99 or, as the case may be, Article 188.\\r\\n(4) Notwithstanding anything contained in the foregoing provisions of this paragraph, a person who, on the commencement of the Constitution (Fifty-second Amendment) Act, 1985, is a member of a House (whether elected or nominated as such) shall,\\u2014\\r\\n(i) where he was a member of a political party immediately before such commencement, be deemed, for the purposes of sub-paragraph (1) of this paragraph, to have been elected as a member of such House as a candidate set up by such political party;\\r\\n(ii) in any other case, be deemed to be an elected member of the House who has been elected as such otherwise than as a candidate set up by any political party for the purposes of sub-paragraph (2) of this paragraph or, as the case may be, be deemed to be a nominated member of the House for the purposes of sub-paragraph (3) of this paragraph.\\r\\n4. Disqualification on ground of defection not to apply in case of merger.\\u2014(1) A member of a House shall not be disqualified under sub-paragraph (1) of paragraph 2 where his original political party merges with another political party and he claims that he and any other members of his original political party\\u2014\\r\\n(a) have become members of such other political party or, as the case may be, of a new political party formed by such merger; or\\r\\n(b) have not accepted the merger and opted to function as a separate group,\\r\\nand from the time of such merger, such other political party or new political party or group, as the case may be, shall be deemed to be the political party to which he belongs for the purposes of sub-paragraph (1) of paragraph 2 and to be his original political party for the purposes of this sub-paragraph.\\r\\n(2) For the purposes of sub-paragraph (1) of this paragraph, the merger of the original political party of a member of a House shall be deemed to have taken place if, and only if, not less than two-thirds of the members of the legislature party concerned have agreed to such merger.\\r\\n5. Exemption.\\u2014Notwithstanding anything contained in this Schedule, a person who has been elected to the office of the Speaker or the Deputy Speaker of the House of the People or the Deputy Chairman of the Council of States or the Chairman or the Deputy Chairman of the Legislative Council of a State or the Speaker or the Deputy Speaker of the Legislative Assembly of a State, shall not be disqualified under this Schedule,\\u2014\\r\\n(a) if he, by reason of his election to such office, voluntarily gives up the membership of the political party to which he belonged immediately before such election and does not, so long as he continues to hold such office thereafter, rejoin that political party or become a member of another political party; or\\r\\n(b) if he, having given up by reason of his election to such office his membership of the political party to which he belonged immediately before such election, rejoins such political party after he ceases to hold such office.\\r\\n6. Decision on questions as to disqualification on ground of defection.\\u2014(1) If any question arises as to whether a member of a House has become subject to disqualification under this Schedule, the question shall be referred for the decision of the Chairman or, as the case may be, the Speaker of such House and his decision shall be final:\\r\\nProvided that where the question which has arisen is as to whether the Chairman or the Speaker of a House has become subject to such disqualification, the question shall be referred for the decision of such member of the House as the House may elect in this behalf and his decision shall be final.\\r\\n(2) All proceedings under sub-paragraph (1) of this paragraph in relation to any question as to disqualification of a member of a House under this Schedule shall be deemed to be proceedings in Parliament within the meaning of Article 122 or, as the case may be, proceedings in the Legislature of a State within the meaning of Article 212.\\r\\n7. Bar of jurisdiction of courts.\\u2014Notwithstanding anything in this Constitution, no court shall have any jurisdiction in respect of any matter connected with the disqualification of a member of a House under this Schedule.\\r\\n8. Rules.\\u2014(1) Subject to the provisions of sub-paragraph (2) of this paragraph, the Chairman or the Speaker of a House may make rules for giving effect to the provisions of this Schedule, and in particular, and without prejudice to the generality of the foregoing, such rules may provide for\\u2014\\r\\n(a) the maintenance of registers or other records as to the political parties, if any, to which different members of the House belong;\\r\\n(b) the report which the leader of a legislature party in relation to a member of a House shall furnish with regard to any condonation of the nature referred to in clause (b) of sub-paragraph (1) of paragraph 2 in respect of such member, the time within which and the authority to whom such report shall be furnished;\\r\\n(c) the reports which a political party shall furnish with regard to admission to such political party of any members of the House and the officer of the House to whom such reports shall be furnished; and\\r\\n(d) the procedure for deciding any question referred to in sub-paragraph (1) of paragraph 6 including the procedure for any inquiry which may be made for the purpose of deciding such question.\\r\\n(2) The rules made by the Chairman or the Speaker of a House under sub-paragraph (1) of this paragraph shall be laid as soon as may be after they are made before the House for a total period of thirty days which may be comprised in one session or in two or more successive sessions and shall take effect upon the expiry of the said period of thirty days unless they are sooner approved with or without modifications or disapproved by the House and where they are so approved, they shall take effect on such approval in the form in which they were laid or in such modified form, as the case may be, and where they are so disapproved, they shall be of no effect.\\r\\n(3) The Chairman or the Speaker of a House may, without prejudice to the provisions of Article 105 or, as the case may be, Article 194, and to any other power which he may have under this Constitution direct that any wilful contravention by any person of the rules made under this paragraph may be dealt with in the same manner as a breach of privilege of the House.]\\r\\n\"]}', 1, '2021-02-01 04:33:57', '2021-02-01 04:33:57'),
(79, 'm8CwZbyhlHd1tynBcCy8jOWaB', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 1', 'GENERAL PROVISIONS', '', '', '{\"1\":[\"2. Definitions\",\" (1) In this Part, unless the context otherwise requires,\\u2014\\r\\n(a) \\u201carbitration\\u201d means any arbitration whether or not administered by permanent arbitral institution;\\r\\n(b) \\u201carbitration agreement\\u201d means an agreement referred to in Section 7;\\r\\n(c) \\u201carbitral award\\u201d includes an interim award;\\r\\n (ca) \\u201carbitral institution\\u201d means an arbitral institution designated by the Supreme Court or a High Court under this Act;]\\r\\n(d) \\u201carbitral tribunal\\u201d means a sole arbitrator or a panel of arbitrators;\\r\\n [(e) \\u201cCourt\\u201d means\\u2014\\r\\n(i) in the case of an arbitration other than international commercial arbitration, the principal civil court of original jurisdiction in a district, and includes the High Court in exercise of its ordinary original civil jurisdiction, having jurisdiction to decide the questions forming the subject matter of the arbitration if the same had been the subject matter of a suit, but does not include any civil court of a grade inferior to such principal civil court, or any Court of Small Causes;\\r\\n(ii) in the case of international commercial arbitration, the High Court in exercise of its ordinary original civil jurisdiction, having jurisdiction to decide the questions forming the subject matter of the arbitration if the same had been the subject matter of a suit, and in other cases, a High Court having jurisdiction to hear appeals from decrees of courts subordinate to that High Court;]\\r\\n(f) \\u201cinternational commercial arbitration\\u201d means an arbitration relating to disputes arising out of legal relationships, whether contractual or not, considered as commercial under the law in force in India and where at least one of the parties is\\u2014\\r\\n(i) an individual who is a national of, or habitually resident in, any country other than India; or\\r\\n(ii) a body corporate which is incorporated in any country other than India; or\\r\\n(iii)  an association or a body of individuals whose central management and control is exercised in any country other than India; or\\r\\n(iv) the Government of a foreign country;\\r\\n(g) \\u201clegal representative\\u201d means a person who in law represents the estate of a deceased person, and includes any person who intermeddles with the estate of the deceased, and, where a party acts in a representative character, the person on whom the estate devolves on the death of the party so acting;\\r\\n(h) \\u201cparty\\u201d means a party to an arbitration agreement.\\r\\n [(i) \\u201cprescribed\\u201d means prescribed by rules made under this Act;\\r\\n(j) \\u201cregulations\\u201d means the regulations made by the Council under this Act\\r\\n\"],\"2\":[\"2 Scope\",\"This Part shall apply where the place of arbitration is in India.\\r\\n Provided that subject to an agreement to the contrary, the provisions of Sections 9, 27 and clause (b) of sub-section (1) and sub-section (3) of Section 37 shall also apply to international commercial arbitration, even if the place of arbitration is outside India, and an arbitral award made or to be made in such place is enforceable and recognised under the provisions of Part II of this Act.\\r\\n(3) This Part shall not affect any other law for the time being in force by virtue of which certain disputes may not be submitted to arbitration.\\r\\n(4) This Part except sub-section (1) of Section 40, Sections 41 and 43 shall apply to every arbitration under any other enactment for the time being in force, as if the arbitration were pursuant to an arbitration agreement and as if that other enactment were an arbitration agreement, except in so far as the provisions of this Part are inconsistent with that other enactment or with any rules made thereunder.\\r\\n(5) Subject to the provisions of sub-section (4), and save in so far as is otherwise provided by any law for the time being in force or in any agreement in force between India and any other country or countries, this Part shall apply to all arbitrations and to all proceedings relating thereto.\\r\\n(6) Construction of references.\\u2014Where this Part, except Section 28, leaves the parties free to determine a certain issue, that freedom shall include the right of the parties to authorise any person including an institution, to determine that issue.\\r\\n(7) An arbitral award made under this Part shall be considered as a domestic award.\\r\\n(8) Where this Part\\u2014\\r\\n(a) refers to the fact that the parties have agreed or that they may agree, or\\r\\n(b) in any other way refers to an agreement of the parties, that agreement shall include any arbitration rules referred to in that agreement.\\r\\n(9) Where this Part, other than clause (a) of Section 25 or clause (a) of sub-section (2) of Section 32, refers to a claim, it shall also apply to a counter-claim, and where it refers to a defence, it shall also apply to a defence to that counter-claim.\\r\\n\"],\"3\":[\"3. Receipt of written communications\",\"(1) Unless otherwise agreed by the parties,\\u2014\\r\\n(a) any written communication is deemed to have been received if it is delivered to the addressee personally or at his place of business, habitual residence or mailing address, and\\r\\n(b) if none of the places referred to in clause (a) can be found after making a reasonable inquiry, a written communication is deemed to have been received if it is sent to the addressee\'s last known place of business, habitual residence or mailing address by registered letter or by any other means which provides a record of the attempt to deliver it.\\r\\n(2) The communication is deemed to have been received on the day it is so delivered.\\r\\n(3) This section does not apply to written communications in respect of proceedings of any judicial authority.\\r\\n4. Waiver of right to object.\\u2014A party who knows that\\u2014\\r\\n(a) any provision of this Part from which the parties may derogate, or\\r\\n(b) any requirement under the arbitration agreement, has not been complied with and yet proceeds with the arbitration without stating his objection to such non-compliance without undue delay or, if a time-limit is provided for stating that objection, within that period of time, shall be deemed to have waived his right to so object.\\r\\n5. Extent of judicial intervention.\\u2014Notwithstanding anything contained in any other law for the time being in force, in matters governed by this Part, no judicial authority shall intervene except where so provided in this Part.\\r\\n\"],\"4\":[\"4. Waiver of right to object\",\"A party who knows that\\u2014\\r\\n(a) any provision of this Part from which the parties may derogate, or\\r\\n(b) any requirement under the arbitration agreement, has not been complied with and yet proceeds with the arbitration without stating his objection to such non-compliance without undue delay or, if a time-limit is provided for stating that objection, within that period of time, shall be deemed to have waived his right to so object.\\r\\n\"],\"5\":[\"5. Extent of judicial intervention\",\"Notwithstanding anything contained in any other law for the time being in force, in matters governed by this Part, no judicial authority shall intervene except where so provided in this Part.\"],\"6\":[\"6. Administrative assistance\",\"In order to facilitate the conduct of the arbitral proceedings, the parties, or the arbitral tribunal with the consent of the parties, may arrange for administrative assistance by a suitable institution or person.\"]}', 1, '2021-02-01 18:50:57', '2021-02-01 20:37:05');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(80, 'rTVKhNEtYeNHQP5Dw4VyUmLBL', 'I1sLydS6hxk9n5H9lbJwICx5T', ' Part 1 CHAPTER 2', 'ARBITRATION AGREEMENT', '', '', '{\"1\":[\"7. Arbitration agreement\",\"(1) In this Part, \\u201carbitration agreement\\u201d means an agreement by the parties to submit to arbitration all or certain disputes which have arisen or which may arise between them in respect of a defined legal relationship, whether contractual or not.\\r\\n(2) An arbitration agreement may be in the form of an arbitration clause in a contract or in the form of a separate agreement.\\r\\n(3) An arbitration agreement shall be in writing.\\r\\n(4) An arbitration agreement is in writing if it is contained in\\u2014\\r\\n(a) a document signed by the parties;\\r\\n(b) an exchange of letters, telex, telegrams or other means of telecommunication including communication through electronic means] which provide a record of the agreement; or\\r\\n(c) an exchange of statements of claim and defence in which the existence of the agreement is alleged by one party and not denied by the other.\\r\\n(5) The reference in a contract to a document containing an arbitration clause constitutes an arbitration agreement if the contract is in writing and the reference is such as to make that arbitration clause part of the contract\\r\\n\"],\"2\":[\"8. Power to refer parties to arbitration where there is an arbitration agreement\",\"(1) A judicial authority, before which an action is brought in a matter which is the subject of an arbitration agreement shall, if a party to the arbitration agreement or any person claiming through or under him, so applies not later than the date of submitting his first statement on the substance of the dispute, then, notwithstanding any judgment, decree or order of the Supreme Court or any court, refer the parties to arbitration unless it finds that prima facie no valid arbitration agreement exists.\\r\\n(2) The application referred to in sub-section (1) shall not be entertained unless it is accompanied by the original arbitration agreement or a duly certified copy thereof.\\r\\n(3) Notwithstanding that an application has been made under sub-section (1) and that the issue is pending before the judicial authority, an arbitration may be commenced or continued and an arbitral award made.\\r\\n\"],\"3\":[\"8-A. Power of the court, seized of petitions under Sections 9 or 11 of the Act, to refer the dispute to Mediation or Conciliation (Union Territory of Jammu and Kashmir)\",\"(1) If during the pendency of petitions under Sections 9 or 11 of the Act, it appears to the court, that there exists elements of a settlement which may be acceptable to the parties, the court may, with the consent of parties, refer the parties, for resolution of their disputes, to,\\u2014\\r\\n(a) mediation; or\\r\\n(b) conciliation.\\r\\n(2) The procedure for reference of a dispute to mediation is as under\\u2014\\r\\n(a) where a dispute has been referred for resolution by recourse to mediation, the procedure framed under that Act shall apply;\\r\\n(b) in case of a successful resolution of the dispute, the Mediator shall immediately forward the mediated settlement to the referral court;\\r\\n(c) on receipt of the mediated settlement, the referral court shall independently apply its judicial mind and record a satisfaction that the mediated settlement is genuine, lawful, voluntary, entered into without coercion, undue influence, fraud or misrepresentation and that there is no other legal impediment in accepting the same;\\r\\n(d) the court shall record a statement on oath of the parties, or their authorised representatives, affirming the mediated settlement as well as a clear undertaking of the parties to abide by the terms of the settlement;\\r\\n(e) if satisfied, the court shall pass an order in terms of the settlement;\\r\\n(f) if the main petition, in which the reference was made is pending, it shall be disposed of by the referral court in terms thereof;\\r\\n(g) if the main petition, in which the reference was made stands disposed of, the mediated settlement and the matter shall be listed before the referral court, which shall pass orders in accordance with clauses (iii), (iv) and (v);\\r\\n(h) such a mediated settlement, shall have the same status and effect as an arbitral award and may be enforced in the manner specified under Section 36 of the Act.\\r\\n(3) With respect to reference of a dispute to conciliation, the provisions of Part II of this Act shall apply as if the conciliation proceedings were initiated by the parties under the relevant provision of this Act.\\r\\n\"],\"4\":[\"8-B. Power of the court, seized of matters under Sections 34 or 37 of the Act, to refer the dispute to Mediation or Conciliation  (Union Territory of Jammu and Kashmir)\",\"(1) If during the pendency of a petition under Section 34 or an appeal under Section 37 of the Act, it appears to the court, that there exists elements of a settlement which may be acceptable to the parties, the court may, with the consent of parties, refer the parties, for resolution of their disputes, to:\\u2014\\r\\n(a) mediation; or\\r\\n(b) conciliation.\\r\\n(2) The procedure for reference of a dispute to mediation is as under:\\u2014\\r\\n(a) where a dispute has been referred for resolution by recourse to mediation, the procedure framed under the Act shall apply;\\r\\n(b) in case of a successful resolution of the dispute, the Mediator shall immediately forward the mediated settlement to the referral court;\\r\\n(c) on receipt of the mediated settlement, the referral court shall independently apply its judicial mind and record a satisfaction that the mediated settlement is genuine, lawful, voluntary, entered into without coercion, undue influence, fraud or misrepresentation and that there is no other legal impediment in accepting the same;\\r\\n(d) the court shall record a statement on oath of the parties, or their authorized representatives, affirming the mediated settlement, a clear undertaking of the parties to abide by the terms of the settlement as well as statement to the above effect;\\r\\n(e) if satisfied, the court shall pass an order in terms of the settlement;\\r\\n(f) if the main petition, in which the reference was made is pending, it shall be disposed of by the referral court in terms thereof;\\r\\n(g) if the main petition, in which the reference was made stands disposed of, the mediated settlement and the matter shall be listed before the referral court, which shall pass orders in accordance with clauses (iii), (iv) and (v);\\r\\n(h) such a mediated settlement, shall have the status of a modified arbitral award and may be enforced in the manner specified under Section 36 of the Act.\\r\\n(3) With respect to reference of a dispute to conciliation, the provisions of Part III of the Act, shall apply as if the conciliation proceedings were initiated by the parties under the relevant provision of this Act.\\u201d [Vide S.O. 1123(E), dated 18-3-2020 (w.e.f. 18-3-2020)].\\r\\n\"],\"5\":[\"\\u201c8-A. Power of Court, seized of petition under Section 9 or Section 11 to refer dispute to mediation or conciliation (Union Territory of Ladakh)\",\"(1) If during the pendency of petition under Section 9 or 11, it appears to the Court, that there exists elements of a settlement which may be acceptable to the parties, the Court may, with the consent of parties, refer the parties, for resolution of their disputes, to,\\u2014\\r\\n(a) mediation; or\\r\\n(b) conciliation.\\r\\n(2) The procedure for reference of a dispute to mediation shall be as under:\\u2014\\r\\n(a) where a dispute has been referred for resolution by recourse to mediation, the procedure framed under this Act shall apply;\\r\\n(b) in case of a successful resolution of the dispute, the Mediator shall immediately forward the mediated settlement to the referral court;\\r\\n(c) on receipt of the mediated settlement, the referral court shall independently apply its judicial mind and record a satisfaction that the mediated settlement is genuine, lawful, voluntary, entered into without coercion, undue influence, fraud or misrepresentation and that there is no other legal impediment in accepting the same;\\r\\n(d) the Court shall record a statement on oath of the parties, or their authorised representatives, affirming the mediated settlement as well as a clear undertaking of the parties to abide by the terms of the settlement;\\r\\n(e) if satisfied, the Court shall pass an order in terms of the settlement;\\r\\n(f) if the main petition, in which the reference was made is pending, it shall be disposed of by the referral Court in terms thereof;\\r\\n(g) if the main petition, in which the reference was made stands disposed of, the mediated settlement and the matter shall be listed before the referral Court, which shall pass orders in accordance with clauses (c), (d) and (e); and\\r\\n(h) such a mediated settlement, shall have the same status and effect as an arbitral award and may be enforced in the manner specified under Section 36.\\r\\n(3) With respect to reference of a dispute to conciliation, the provisions of Part II of this Act shall apply as if the conciliation proceedings were initiated by the parties under the relevant provision of this Act.\\r\\n\"],\"6\":[\"8-B. Power of Court, seized of matters under Section 34 or Section 37, to refer dispute to mediation or conciliation (Union Territory of Ladakh)\",\"(1) If during the pendency of a petition under Section 34 or an appeal under section 37, it appears to the Court, that there exist elements of a settlement which may be acceptable to the parties, the court may, with the consent of parties, refer the parties, for resolution of their disputes, to\\u2014\\r\\n(a) mediation; or\\r\\n(b) conciliation.\\r\\n(2) The procedure for reference of a dispute to mediation shall be as under:\\u2014\\r\\n(a) where a dispute has been referred for resolution by recourse to mediation, the procedure framed under this Act shall apply;\\r\\n(b) in case of a successful resolution of the dispute, the Mediator shall immediately forward the mediated settlement to the referral Court;\\r\\n(c) on receipt of the mediated settlement, the referral Court shall independently apply its judicial mind and record a satisfaction that the mediated settlement is genuine, lawful, voluntary, entered into without coercion, undue influence, fraud or misrepresentation and that there is no other legal impediment in accepting the same;\\r\\n(d) the Court shall record a statement on oath of the parties, or their authorised representatives, affirming the mediated settlement as well as a clear undertaking of the parties to abide by the terms of the settlement;\\r\\n(e) if satisfied, the Court shall pass an order in terms of the settlement;\\r\\n(f) if the main petition, in which the reference was made is pending, it shall be disposed of by the referral Court in terms thereof;\\r\\n(g) if the main petition, in which the reference was made stands disposed of, the mediated settlement and the matter shall be listed before the referral Court, which shall pass orders in accordance with clauses (c), (d) and (e);\\r\\n(h) such a mediated settlement, shall have the status of a modified arbitral award and may be enforced in the manner specified under Section 36.\\r\\n(3) With respect to reference of a dispute to conciliation, the provisions of Part III of this Act, shall apply as if the conciliation proceedings were initiated by the parties under the relevant provision of this Act.\\u201d [Vide S.O. 3774(E), dated 23-10-2020].\\r\\n\"],\"7\":[\"9. Interim measures, etc. by Court\",\"(1) A party may, before or during arbitral proceedings or at any time after the making of the arbitral award but before it is enforced in accordance with Section 36, apply to a Court:\\u2014\\r\\n(i) for the appointment of a guardian for a minor or a person of unsound mind for the purposes of arbitral proceedings; or\\r\\n(ii) for an interim measure of protection in respect of any of the following matters, namely:\\u2014\\r\\n(a) the preservation, interim custody or sale of any goods which are the subject-matter of the arbitration agreement;\\r\\n(b) securing the amount in dispute in the arbitration;\\r\\n(c) the detention, preservation or inspection of any property or thing which is the subject-matter of the dispute in arbitration, or as to which any question may arise therein and authorising for any of the aforesaid purposes any person to enter upon any land or building in the possession of any party, or authorising any samples to be taken or any observation to be made, or experiment to be tried, which may be necessary or expedient for the purpose of obtaining full information or evidence;\\r\\n(d) interim injunction or the appointment of a receiver;\\r\\n(e) such other interim measure of protection as may appear to the Court to be just and convenient,\\r\\nand the Court shall have the same power for making orders as it has for the purpose of, and in relation to, any proceedings before it.\\r\\n (2) Where, before the commencement of the arbitral proceedings, a court passes an order for any interim measure of protection under sub-section (1), the arbitral proceedings shall be commenced within a period of ninety days from the date of such order or within such further time as the court may determine.\\r\\n(3) Once the arbitral tribunal has been constituted, the court shall not entertain an application under sub-section (1), unless the court finds that circumstances exist which may not render the remedy provided under Section 17 efficacious.\\r\\n\"]}', 1, '2021-02-01 18:56:58', '2021-02-01 19:04:03'),
(81, '9iKDsOd1FmfLXWd2EYl9A4xJC', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 3', 'COMPOSITION OF ARBITRAL TRIBUNAL', '', '', '{\"1\":[\"10. Number of arbitrators\",\"(1) The parties are free to determine the number of arbitrators, provided that such number shall not be an even number.\\r\\n(2) Failing the determination referred to in sub-section (1), the arbitral tribunal shall consist of a sole arbitrator.\\r\\n\"],\"2\":[\"11. Appointment of arbitrators\",\"(1) A person of any nationality may be an arbitrator, unless otherwise agreed by the parties.\\r\\n(2) Subject to sub-section (6), the parties are free to agree on a procedure for appointing the arbitrator or arbitrators.\\r\\n(3) Failing any agreement referred to in sub-section (2), in an arbitration with three arbitrators, each party shall appoint one arbitrator, and the two appointed arbitrators shall appoint the third arbitrator who shall act as the presiding arbitrator.\\r\\n (3-A) The Supreme Court and the High Court shall have the power to designate, arbitral institutions, from time to time, which have been graded by the Council under section 43-I, for the purposes of this Act:\\r\\n(4) If the appointment procedure in sub-section (3) applies and\\u2014\\r\\n(a) a party fails to appoint an arbitrator within thirty days from the receipt of a request to do so from the other party; or\\r\\n(b) the two appointed arbitrators fail to agree on the third arbitrator within thirty days from the date of their appointment,\\r\\n(5) Failing any agreement referred to in sub-section (2), in an arbitration with a sole arbitrator, if the parties fail to agree on the arbitrator within thirty days from receipt of a request by one party from the other party to so agree  the appointment shall be made on an application of the party in accordance with the provisions contained in sub-section (4).\\r\\n(6) Where, under an appointment procedure agreed upon by the parties,\\u2014\\r\\n(a) a party fails to act as required under that procedure; or\\r\\n(b) the parties, or the two appointed arbitrators, fail to reach an agreement expected of them under that procedure; or\\r\\n(c) a person, including an institution, fails to perform any function entrusted to him or it under that procedure,\\r\\n (6-B) The designation of any person or institution by the Supreme Court or, as the case may be, the High Court, for the purposes of this section shall not be regarded as a delegation of judicial power by the Supreme Court or the High Court.\\r\\n (8) The arbitral institution referred to in sub-sections (4), (5) and (6) before appointing an arbitrator, shall seek a disclosure in writing from the prospective arbitrator in terms of sub-section (1) of Section 12, and have due regard to\\u2014\\r\\n(a) any qualifications required for the arbitrator by the agreement of the parties; and\\r\\n(b) the contents of the disclosure and other considerations as are likely to secure the appointment of an independent and impartial arbitrator.\\r\\n(9) In the case of appointment of sole or third arbitrator in an international commercial arbitration, 23[the arbitral institution designated by the Supreme Court] may appoint an arbitrator of a nationality other than the nationalities of the parties where the parties belong to different nationalities.\\r\\n(11) Where more than one request has been made under sub-section (4) or sub-section (5) or sub-section (6) to different arbitral institutions, the arbitral institution to which the request has been first made under the relevant sub-section shall be competent to appoint.\\r\\n(12) Where the matter referred to in sub-sections (4), (5), (6) and (8) arise in an international commercial arbitration or any other arbitration, the reference to the arbitral institution in those sub-sections shall be construed as a reference to the arbitral institution designated under sub-section (3-A).\\r\\n(13) An application made under this section for appointment of an arbitrator or arbitrators shall be disposed of by the arbitral institution within a period of thirty days from the date of service of notice on the opposite party.\\r\\n(14) The arbitral institution shall determine the fees of the arbitral tribunal and the manner of its payment to the arbitral tribunal subject to the rates specified in the Fourth Schedule.\\r\\n\"],\"3\":[\"11-A. Power of Central Government to amend Fourth Schedule\",\"(1) If the Central Government is satisfied that it is necessary or expedient so to do, it may, by notification in the Official Gazette, amend the Fourth Schedule and thereupon the Fourth Schedule shall be deemed to have been amended accordingly.\\r\\n(2) A copy of every notification proposed to be issued under sub-section (1), shall be laid in draft before each House of Parliament, while it is in session, for a total period of thirty days which may be comprised in one session or in two or more successive sessions, and if, before the expiry of the session immediately following the session or the successive sessions aforesaid, both Houses agree in disapproving the issue of the notification or both Houses agree in making any modification in the notification, the notification shall not be issued or as the case may be, shall be issued only in such modified form as may be agreed upon by the both Houses of Parliament\\r\\n\"],\"4\":[\"12. Grounds for challenge\",\"(1) When a person is approached in connection with his possible appointment as an arbitrator, he shall disclose in writing any circumstances,\\u2014\\r\\n(a) such as the existence either direct or indirect, of any past or present relationship with or interest in any of the parties or in relation to the subject matter in dispute, whether financial, business, professional or other kind, which is likely to give rise to justifiable doubts as to his independence or impartiality; and\\r\\n(b) which are likely to affect his ability to devote sufficient time to the arbitration and in particular his ability to complete the entire arbitration within a period of twelve months.\\r\\n(2) An arbitrator, from the time of his appointment and throughout the arbitral proceedings, shall, without delay, disclose to the parties in writing any circumstances referred to in sub-section (1) unless they have already been informed of them by him.\\r\\n(3) An arbitrator may be challenged only if\\u2014\\r\\n(a) circumstances exist that give rise to justifiable doubts as to his independence or impartiality; or\\r\\n(b) he does not possess the qualifications agreed to by the parties.\\r\\n(4) A party may challenge an arbitrator appointed by him, or in whose appointment he has participated, only for reasons of which he becomes aware after the appointment has been made.\\r\\n(5) Notwithstanding any prior agreement to the contrary, any person whose relationship, with the parties or counsel or the subject matter of the dispute, falls under any of the categories specified in the Seventh Schedule shall be ineligible to be appointed as an arbitrator\\r\\n\"],\"5\":[\"13. Challenge procedure\",\"(1) Subject to sub-section (4), the parties are free to agree on a procedure for challenging an arbitrator.\\r\\n(2) Failing any agreement referred to in sub-section (1), a party who intends to challenge an arbitrator shall, within fifteen days after becoming aware of the constitution of the arbitral tribunal or after becoming aware of any circumstances referred to in sub-section (3) of Section 12, send a written statement of the reasons for the challenge to the arbitral tribunal.\\r\\n(3) Unless the arbitrator challenged under sub-section (2) withdraws from his office or the other party agrees to the challenge, the arbitral tribunal shall decide on the challenge.\\r\\n(4) If a challenge under any procedure agreed upon by the parties or under the procedure under sub-section (2) is not successful, the arbitral tribunal shall continue the arbitral proceedings and make an arbitral award.\\r\\n(5) Where an arbitral award is made under sub-section (4), the party challenging the arbitrator may make an application for setting aside such an arbitral award in accordance with Section 34.\\r\\n(6) Where an arbitral award is set aside on an application made under sub-section (5), the Court may decide as to whether the arbitrator who is challenged is entitled to any fees.\\r\\n\"],\"6\":[\"14. Failure or impossibility to act\",\"(1) The mandate of an arbitrator shall terminate and he shall be substituted by another arbitrator, if]\\u2014\\r\\n(a) he becomes de jure or de facto unable to perform his functions or for other reasons fails to act without undue delay; and\\r\\n(b) he withdraws from his office or the parties agree to the termination of his mandate.\\r\\n(2) If a controversy remains concerning any of the grounds referred to in clause (a) of sub-section (1), a party may, unless otherwise agreed by the parties, apply to the Court to decide on the termination of the mandate.\\r\\n(3) If, under this section or sub-section (3) of Section 13, an arbitrator withdraws from his office or a party agrees to the termination of the mandate of an arbitrator, it shall not imply acceptance of the validity of any ground referred to in this section or sub-section (3) of Section 12.\\r\\n\"],\"7\":[\"15. Termination of mandate and substitution of arbitrator\",\"(1) In addition to the circumstances referred to in Section 13 or Section 14, the mandate of an arbitrator shall terminate\\u2014\\r\\n(a) where he withdraws from office for any reason; or\\r\\n(b) by or pursuant to agreement of the parties.\\r\\n(2) Where the mandate of an arbitrator terminates, a substitute arbitrator shall be appointed according to the rules that were applicable to the appointment of the arbitrator being replaced.\\r\\n(3) Unless otherwise agreed by the parties, where an arbitrator is replaced under sub-section (2), any hearings previously held may be repeated at the discretion of the arbitral tribunal.\\r\\n(4) Unless otherwise agreed by the parties, an order or ruling of the arbitral tribunal made prior to the replacement of an arbitrator under this section shall not be invalid solely because there has been a change in the composition of the arbitral tribunal.\\r\\n\"]}', 1, '2021-02-01 19:07:16', '2021-02-01 19:10:30'),
(82, 'xuwbWRDrcswl3AvPJsEQlUSvl', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 4', 'JURISDICTION OF ARBITRAL TRIBUNALS', '', '', '{\"1\":[\"16. Competence of arbitral tribunal to rule on its jurisdiction\",\"(1) The arbitral tribunal may rule on its own jurisdiction, including ruling on any objections with respect to the existence or validity of the arbitration agreement, and for that purpose,\\u2014\\r\\n(a) an arbitration clause which forms part of a contract shall be treated as an agreement independent of the other terms of the contract; and\\r\\n(b) a decision by the arbitral tribunal that the contract is null and void shall not entail ipso jure the invalidity of the arbitration clause.\\r\\n(2) A plea that the arbitral tribunal does not have jurisdiction shall be raised not later than the submission of the statement of defence; however, a party shall not be precluded from raising such a plea merely because that he has appointed, or participated in the appointment of, an arbitrator.\\r\\n(3) A plea that the arbitral tribunal is exceeding the scope of its authority shall be raised as soon as the matter alleged to be beyond the scope of its authority is raised during the arbitral proceedings.\\r\\n(4) The arbitral tribunal may, in either of the cases referred to in sub-section (2) or sub-section (3), admit a later plea if it considers the delay justified.\\r\\n(5) The arbitral tribunal shall decide on a plea referred to in sub-section (2) or sub-section (3) and, where the arbitral tribunal takes a decision rejecting the plea, continue with the arbitral proceedings and make an arbitral award.\\r\\n(6) A party aggrieved by such an arbitral award may make an application for setting aside such an arbitral award in accordance with Section 34.\\r\\n\"],\"2\":[\"17. Interim measures ordered by arbitral tribunal\",\"(1) A party may, during the arbitral proceedings apply to the arbitral tribunal\\u2014\\r\\n(i) for the appointment of a guardian for a minor or person of unsound mind for the purposes of arbitral proceedings; or\\r\\n(ii) for an interim measure of protection in respect of any of the following matters, namely\\u2014\\r\\n(a) the preservation, interim custody or sale of any goods which are the subject matter of the arbitration agreement;\\r\\n(b) securing the amount in dispute in the arbitration;\\r\\n(c) the detention, preservation or inspection of any property or thing which is the subject matter of the dispute in arbitration, or as to which any question may arise therein and authorising for any of the aforesaid purposes any person to enter upon any land or building in the possession of any party, or authorising any samples to be taken, or any observation to be made, or experiment to be tried, which may be necessary or expedient for the purpose of obtaining full information or evidence;\\r\\n(d) interim injunction or the appointment of a receiver;\\r\\n(e) such other interim measure of protection as may appear to the arbitral tribunal to be just and convenient,\\r\\nand the arbitral tribunal shall have the same power for making orders, as the court has for the purpose of, and in relation to, any proceedings before it.\\r\\n(2) Subject to any orders passed in an appeal under Section 37, any order issued by the arbitral tribunal under this section shall be deemed to be an order of the court for all purposes and shall be enforceable under the Code of Civil Procedure, 1908 (5 of 1908), in the same manner as if it were an order of the court.\\r\\n\"]}', 1, '2021-02-01 19:12:04', '2021-02-01 19:13:05'),
(83, 'L3Dfj62yGqPGpfWAAMiWe2atK', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 5', 'CONDUCT OF ARBITRAL PROCEEDINGS', '', '', '{\"1\":[\"18. Equal treatment of parties\",\"The parties shall be treated with equality and each party shall be given a full opportunity to present his case.\\r\\n(i) it must be independent and impartial and must mete out equal treatment to each party. \\r\\n(ii) it must give each party a full opportunity to present its case. Sections 23 and 24 provide for the giving of such opportunity.\\r\\n\"],\"2\":[\"19. Determination of rules of procedure\",\"(1) The arbitral tribunal shall not be bound by the Code of Civil Procedure, 1908 (V of 1908) or the Indian Evidence Act, 1872 (1 of 1872).\\r\\n(2) Subject to this Part, the parties are free to agree on the procedure to be followed by the arbitral tribunal in conducting its proceedings.\\r\\n(3) Failing any agreement referred to in sub-section (2), the arbitral tribunal may, subject to this Part, conduct the proceedings in the manner it considers appropriate.\\r\\n(4) The power of the arbitral tribunal under sub-section (3) includes the power to determine the admissibility, relevance, materiality and weight of any evidence.\\r\\n\"],\"3\":[\"20. Place of arbitration\",\"(1) The parties are free to agree on the place of arbitration.\\r\\n(2) Failing any agreement referred to in sub-section (1), the place of arbitration shall be determined by the arbitral tribunal having regard to the circumstances of the case, including the convenience of the parties.\\r\\n(3) Notwithstanding sub-section (1) or sub-section (2), the arbitral tribunal may, unless otherwise agreed by the parties, meet at any place it considers appropriate for consultation among its members, for hearing witnesses, experts or the parties, or for inspection of documents, goods or other property.\\r\\n\"],\"4\":[\"21. Commencement of arbitral proceedings\",\"Unless otherwise agreed by the parties, the arbitral proceedings in respect of a particular dispute commence on the date on which a request for that dispute to be referred to arbitration is received by the respondent.\"],\"5\":[\"22. Language\",\"(1) The parties are free to agree upon the language or languages to be used in the arbitral proceedings.\\r\\n(2) Failing any agreement referred to in sub-section (1), the arbitral tribunal shall determine the language or languages to be used in the arbitral proceedings.\\r\\n(3) The agreement or determination, unless otherwise specified, shall apply to any written statement by a party, any hearing and any arbitral award, decision or other communication by the arbitral tribunal.\\r\\n(4) The arbitral tribunal may order that any documentary evidence shall be accompanied by a translation into the language or languages agreed upon by the parties or determined by the arbitral tribunal.\\r\\n\"],\"6\":[\"23. Statements of claim and defence\",\"(1) Within the period of time agreed upon by the parties or determined by the arbitral tribunal, the claimant shall state the facts supporting his claim, the points at issue and the relief or remedy sought, and the respondent shall state his defence in respect of these particulars, unless the parties have otherwise agreed as to the required elements of those statements.\\r\\n(2) The parties may submit with their statements all documents they consider to be relevant or may add a reference to the documents or other evidence they will submit.\\r\\n (2-A) The respondent, in support of his case, may also submit a counter claim or plead a set-off, which shall be adjudicated upon by the arbitral tribunal, if such counter claim or set-off falls within the scope of the arbitration agreement.\\r\\n(3) Unless otherwise agreed by the parties, either party may amend or supplement his claim or defence during the course of the arbitral proceedings, unless the arbitral tribunal considers it inappropriate to allow the amendment or supplement having regard to the delay in making it.\\r\\n (4) The statement of claim and defence under this section shall be completed within a period of six months from the date the arbitrator or all the arbitrators, as the case may be, received notice, in writing, of their appointment.\\r\\n\"],\"7\":[\"24. Hearings and written proceedings\",\"(1) Unless otherwise agreed by the parties, the arbitral tribunal shall decide whether to hold oral hearings for the presentation of evidence or for oral argument, or whether the proceedings shall be conducted on the basis of documents and other materials:\\r\\nProvided that the arbitral tribunal shall hold oral hearings, at an appropriate stage of the proceedings, on a request by a party, unless the parties have agreed that no oral hearing shall be held.\\r\\n(2) The parties shall be given sufficient advance notice of any hearing and of any meeting of the arbitral tribunal for the purposes of inspection of documents, goods or other property.\\r\\n(3) All statements, documents or other information supplied to, or applications made to the arbitral tribunal by one party shall be communicated to the other party, and any expert report or evidentiary document on which the arbitral tribunal may rely in making its decision shall be communicated to the parties.\\r\\n\"],\"8\":[\"25. Default of a party\",\"Unless, otherwise agreed by the parties, where, without showing sufficient cause,\\u2014\\r\\n(a) the claimant fails to communicate his statement of claim in accordance with sub-section (1) of Section 23, the arbitral tribunal shall terminate the proceedings;\\r\\n(b) the respondent fails to communicate his statement of defence in accordance with sub-section (1) of Section 23, the arbitral tribunal shall continue the proceedings without treating that failure in itself as an admission of the allegations by the claimant and shall have the discretion to treat the right of the respondent to file such statement of defence as having been forfeited\\r\\n(c) a party fails to appear at an oral hearing or to produce documentary evidence, the arbitral tribunal may continue the proceedings and make the arbitral award on the evidence before it.\\r\\n\"],\"9\":[\"26. Expert appointed by arbitral tribunal\",\"(1) Unless otherwise agreed by the parties, the arbitral tribunal may\\u2014\\r\\n(a) appoint one or more experts to report to it on specific issues to be determined by the arbitral tribunal; and\\r\\n(b) require a party to give the expert any relevant information or to produce, or to provide access to, any relevant documents, goods or other property for his inspection.\\r\\n(2) Unless otherwise agreed by the parties, if a party so requests or if the arbitral tribunal considers it necessary, the expert shall, after delivery of his written or oral report, participate in an oral hearing where the parties have the opportunity to put questions to him and to present expert witnesses in order to testify on the points at issue.\\r\\n(3) Unless otherwise agreed by the parties, the expert shall, on the request of a party, make available to that party for examination all documents, goods or other property in the possession of the expert with which he was provided in order to prepare his report.\\r\\n\"],\"10\":[\"27. Court assistance in taking evidence\",\"(1) The arbitral tribunal, or a party with the approval of the arbitral tribunal, may apply to the Court for assistance in taking evidence.\\r\\n(2) The application shall specify\\u2014\\r\\n(a) the names and addresses of the parties and the arbitrators;\\r\\n(b) the general nature of the claim and the relief sought;\\r\\n(c) the evidence to be obtained, in particular,\\u2014\\r\\n(i) the name and address of any person to be heard as witness or expert witness and a statement of the subject-matter of the testimony required;\\r\\n(ii) the description of any document to be produced or property to be inspected.\\r\\n(3) The Court may, within its competence and according to its rules on taking evidence, execute the request by ordering that the evidence be provided directly to the arbitral tribunal.\\r\\n(4) The Court may, while making an order under sub-section (3), issue the same processes to witnesses as it may issue in suits tried before it.\\r\\n(5) Persons failing to attend in accordance with such process, or making any other default, or refusing to give their evidence, or guilty of any contempt to the arbitral tribunal during the conduct of arbitral proceedings, shall be subject to the like disadvantages, penalties and punishments by order of the Court on the representation of the arbitral tribunal as they would incur for the like offences in suits tried before the Court.\\r\\n(6) In this section the expression \\u201cProcesses\\u201d includes summonses and commissions for the examination of witnesses and summonses to produce documents.\\r\\n\"]}', 1, '2021-02-01 19:14:35', '2021-02-01 19:19:29');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(84, 'PY9AQ9WNqXsvTyOxXq0pse2tK', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 6', 'MAKING OF ARBITRAL AWARD AND TERMINATION OF PROCEEDINGS', '', '', '{\"1\":[\"28. Rules applicable to substance of dispute\",\"(1) Where the place of arbitration is situated in India,\\u2014\\r\\n(a) in an arbitration other than an international commercial arbitration, the arbitral tribunal shall decide the dispute submitted to arbitration in accordance with the substantive law for the time being in force in India;\\r\\n(b) in international commercial arbitration,\\u2014\\r\\n(i) the arbitral tribunal shall decide the dispute in accordance with the rules of law designated by the parties as applicable to the substance of the dispute;\\r\\n(ii) any designation by the parties of the law or legal system of a given country shall be construed, unless otherwise expressed, as directly referring to the substantive law of that country and not to its conflict of laws rules;\\r\\n(iii) failing any designation of the law under sub-clause (ii) by the parties, the arbitral tribunal shall apply the rules of law it considers to be appropriate given all the circumstances surrounding the dispute.\\r\\n(2) The arbitral tribunal shall decide ex aequo et bono or as amiable compositeur only if the parties have expressly authorised it to do so.\\r\\n (3) While deciding and making an award, the arbitral tribunal shall, in all cases, take into account the terms of the contract and trade usages applicable to the transaction\\r\\n\"],\"2\":[\"29. Decision-making by panel of arbitrators\",\"(1) Unless otherwise agreed by the parties, in arbitral proceedings with more than one arbitrator, any decision of the arbitral tribunal shall be made by a majority of all its members.\\r\\n(2) Notwithstanding sub-section (1), if authorised by the parties or all the members of the arbitral tribunal, questions of procedure may be decided by the presiding arbitrator.\\r\\n\"],\"3\":[\"29-A. Time limit for arbitral award\",\"(1) The award in matters other than international commercial arbitration shall be made by the arbitral tribunal within a period of twelve months from the date of completion of pleadings under sub-section (4) of Section 23:\\r\\n(2) If the award is made within a period of six months from the date the arbitral tribunal enters upon the reference, the arbitral tribunal shall be entitled to receive such amount of additional fees as the parties may agree.\\r\\n(3) The parties may, by consent, extend the period specified in sub-section (1) for making award for a further period not exceeding six months.\\r\\n(4) If the award is not made within the period specified in sub-section (1) or the extended period specified under sub-section (3), the mandate of the arbitrator(s) shall terminate unless the court has, either prior to or after the expiry of the period so specified, extended the period:\\r\\n(5) The extension of period referred to in sub-section (4) may be on the application of any of the parties and may be granted only for sufficient cause and on such terms and conditions as may be imposed by the court.\\r\\n(6) While extending the period referred to in sub-section (4), it shall be open to the court to substitute one or all of the arbitrators and if one or all of the arbitrators are substituted, the arbitral proceedings shall continue from the stage already reached and on the basis of the evidence and material already on record, and the arbitrator(s) appointed under this section shall be deemed to have received the said evidence and material.\\r\\n(7) In the event of arbitrator(s) being appointed under this section, the arbitral tribunal thus reconstituted shall be deemed to be in continuation of the previously appointed arbitral tribunal.\\r\\n(8) It shall be open to the court to impose actual or exemplary costs upon any of the parties under this section.\\r\\n(9) An application filed under sub-section (5) shall be disposed of by the court as expeditiously as possible and endeavour shall be made to dispose of the matter within a period of sixty days from the date of service of notice on the opposite party.\\r\\n\"],\"4\":[\"29-B. Fast track procedure\",\"(1) Notwithstanding anything contained in this Act, the parties to an arbitration agreement, may, at any stage either before or at the time of appointment of the arbitral tribunal, agree in writing to have their dispute resolved by fast track procedure specified in sub-section (3).\\r\\n(2) The parties to the arbitration agreement, while agreeing for resolution of dispute by fast track procedure, may agree that the arbitral tribunal shall consist of a sole arbitrator who shall be chosen by the parties.\\r\\n(3) The arbitral tribunal shall follow the following procedure while conducting arbitration proceedings under sub-section (1):\\r\\n(a) The arbitral tribunal shall decide the dispute on the basis of written pleadings, documents and submissions filed by the parties without any oral hearing;\\r\\n(b) The arbitral tribunal shall have power to call for any further information or clarification from the parties in addition to the pleadings and documents filed by them;\\r\\n(c) An oral hearing may be held only, if, all the parties make a request or if the arbitral tribunal considers it necessary to have oral hearing for clarifying certain issues;\\r\\n(d) The arbitral tribunal may dispense with any technical formalities, if an oral hearing is held, and adopt such procedure as deemed appropriate for expeditious disposal of the case.\\r\\n(4) The award under this section shall be made within a period of six months from the date the arbitral tribunal enters upon the reference.\\r\\n(5) If the award is not made within the period specified in sub-section (4), the provisions of sub-sections (3) to (9) of Section 29-A shall apply to the proceedings.\\r\\n(6) The fees payable to the arbitrator and the manner of payment of the fees shall be such as may be agreed between the arbitrator and the parties.\\r\\n\"],\"5\":[\"30. Settlement\",\"(1) It is not incompatible with an arbitration agreement for an arbitral tribunal to encourage settlement of the dispute and, with the agreement of the parties, the arbitral tribunal may use mediation, conciliation or other procedures at any time during the arbitral proceedings to encourage settlement.\\r\\n(2) If, during arbitral proceedings, the parties settle the dispute, the arbitral tribunal shall terminate the proceedings and, if requested by the parties and not objected to by the arbitral tribunal, record the settlement in the form of an arbitral award on agreed terms.\\r\\n(3) An arbitral award on agreed terms shall be made in accordance with Section 31 and shall state that it is an arbitral award.\\r\\n(4) An arbitral award on agreed terms shall have the same status and effect as any other arbitral award on the substance of the dispute.\\r\\n\"],\"6\":[\"31. Form and contents of arbitral award\",\"(1), in arbitral proceedings with more than one arbitrator, the signatures of the majority of all the members of the arbitral tribunal shall be sufficient so long as the reason for any omitted signature is stated.\\r\\n(3) The arbitral award shall state the reasons upon which it is based, unless\\u2014\\r\\n(a) the parties have agreed that no reasons are to be given; or\\r\\n(b) the award is an arbitral award on agreed terms under Section 30.\\r\\n(4) The arbitral award shall state its date and the place of arbitration as determined in accordance with Section 20 and the award shall be deemed to have been made at that place.\\r\\n(5) After the arbitral award is made, a signed copy shall be delivered to each party.\\r\\n(6) The arbitral tribunal may, at any time during the arbitral proceedings, make an interim arbitral award on any matter with respect to which it may make a final arbitral award.\\r\\n(7)(a) Unless otherwise agreed by the parties, where and in so far as an arbitral award is for the payment of money, the arbitral tribunal may include in the sum for which the award is made interest, at such rate as it deems reasonable, on the whole or any part of the money, for the whole or any part of the period between the date on which the cause of action arose and the date on which the award is made.\\r\\n (b) A sum directed to be paid by an arbitral award shall, unless the award otherwise directs, carry interest at the rate of two per cent higher than the current rate of interest prevalent on the date of award, from the date of award to the date of payment.\\r\\n(8) The costs of an arbitration shall be fixed by the arbitral tribunal in accordance with Section 31-A.\\r\\n\"],\"7\":[\"31-A. Regime for costs\",\"(1) In relation to any arbitration proceeding or a proceeding under any of the provisions of this Act pertaining to the arbitration, the court or arbitral tribunal, notwithstanding anything contained in the Code of Civil Procedure, 1908 (5 of 1908), shall have the discretion to determine\\u2014\\r\\n(a) whether costs are payable by one party to another;\\r\\n(b) the amount of such costs; and\\r\\n(c) when such costs are to be paid.\\r\\n(2) If the court or arbitral tribunal decides to make an order as to payment of costs,\\u2014\\r\\n(a) the general rule is that the unsuccessful party will be ordered to pay the costs of the successful party; or\\r\\n(b) the court or arbitral tribunal may make a different order for reasons to be recorded in writing.\\r\\n(3) In determining the costs, the court or arbitral tribunal shall have regard to all the circumstances, including\\u2014\\r\\n(a) the conduct of all the parties;\\r\\n(b) whether a party has succeeded partly in the case;\\r\\n(c) whether the party had made a frivolous counter-claim leading to delay in the disposal of the arbitral proceedings; and\\r\\n(d) whether any reasonable offer to settle the dispute is made by a party and refused by the other party.\\r\\n(4) The court or arbitral tribunal may make any order under this section including the order that a party shall pay\\u2014\\r\\n(a) a proportion of another party\'s costs;\\r\\n(b) a stated amount in respect of another party\'s costs;\\r\\n(c) costs from or until a certain date only;\\r\\n(d) costs incurred before proceedings have begun;\\r\\n(e) costs relating to particular steps taken in the proceedings;\\r\\n(f) costs relating only to a distinct part of the proceedings; and\\r\\n(g) interest on costs from or until a certain date.\\r\\n(5) An agreement which has the effect that a party is to pay the whole or part of the costs of the arbitration in any event shall be only valid if such agreement is made after the dispute in question has arisen.\\r\\n\"],\"8\":[\"32. Termination of proceedings\",\"(1) The arbitral proceedings shall be terminated by the final arbitral award or by an order of the arbitral tribunal under sub-section (2).\\r\\n(2) The arbitral tribunal shall issue an order for the termination of the arbitral proceedings where\\u2014\\r\\n(a) the claimant withdraws his claim, unless the respondent objects to the order and the arbitral tribunal recognises a legitimate interest on his part in obtaining a final settlement of the dispute;\\r\\n(b) the parties agree on the termination of the proceedings; or\\r\\n(c) the arbitral tribunal finds that the continuation of the proceedings has for any other reason become unnecessary or impossible.\\r\\n(3) Subject to Section 33 and sub-section (4) of Section 34, the mandate of the arbitral tribunal shall terminate with the termination of the arbitral proceedings.\\r\\n\"],\"9\":[\"33. Correction and interpretation of award; additional award\",\"(1) Within thirty days from the receipt of the arbitral award, unless another period of time has been agreed upon by the parties\\u2014\\r\\n(a) a party, with notice to the other party, may request the arbitral tribunal to correct any computation errors, any clerical or typographical errors or any other errors of a similar nature occurring in the award;\\r\\n(b) if so agreed by the parties, a party, with notice to the other party, may request the arbitral tribunal to give an interpretation of a specific point or part of the award.\\r\\n(2) If the arbitral tribunal considers the request made under sub-section (1) to be justified, it shall make the correction or give the interpretation within thirty days from the receipt of the request and the interpretation shall form part of the arbitral award.\\r\\n(3) The arbitral tribunal may correct any error of the type referred to in clause (a) of sub-section (1), on its own initiative, within thirty days from the date of the arbitral award.\\r\\n(4) Unless otherwise agreed by the parties, a party with notice to the other party, may request, within thirty days from the receipt of the arbitral award, the arbitral tribunal to make an additional arbitral award as to claims presented in the arbitral proceedings but omitted from the arbitral award.\\r\\n(5) If the arbitral tribunal considers the request made under sub-section (4) to be justified, it shall make the additional arbitral award within sixty days from the receipt of such request.\\r\\n(6) The arbitral tribunal may extend, if necessary, the period of time within which it shall make a correction, give an interpretation or make an additional arbitral award under sub-section (2) or sub-section (5).\\r\\n(7) Section 31 shall apply to a correction or interpretation of the arbitral award or to an additional arbitral award made under this section.\\r\\n\"]}', 1, '2021-02-01 19:20:40', '2021-02-01 19:26:45'),
(85, 'Zt1oPrd6vr8EU7aR1b19eyHxG', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 7', 'RECOURSE AGAINST ARBITRAL AWARD', '', '', '{\"1\":[\"34. Application for setting aside arbitral award\",\"(1) Recourse to a Court against an arbitral award may be made only by an application for setting aside such award in accordance with sub-section (2) and sub-section (3).\\r\\n(2) An arbitral award may be set aside by the Court only if\\u2014\\r\\n(a) the party making the application establishes on the basis of the record of the arbitral tribunal that\\u2014\\r\\n(i) a party was under some incapacity; or\\r\\n(ii) the arbitration agreement is not valid under the law to which the parties have subjected it or, failing any indication thereon, under the law for the time being in force; or\\r\\n(iii) the party making the application was not given proper notice of the appointment of an arbitrator or of the arbitral proceedings or was otherwise unable to present his case; or\\r\\n(iv) the arbitral award deals with a dispute not contemplated by or not falling within the terms of the submission to arbitration, or it contains decisions on matters beyond the scope of the submission to arbitration:\\r\\nProvided that, if the decisions on matters submitted to arbitration can be separated from those not so submitted, only that part of the arbitral award which contains decisions on matters not submitted to arbitration may be set aside; or\\r\\n(v) the composition of the arbitral tribunal or the arbitral procedure was not in accordance with the agreement of the parties, unless such agreement was in conflict with a provision of this Part from which the parties cannot derogate, or, failing such agreement, was not in accordance with this Part; or\\r\\n(b) the Court finds that\\u2014\\r\\n(i) the subject-matter of the dispute is not capable of settlement by arbitration under the law for the time being in force, or\\r\\n(ii) the arbitral award is in conflict with the public policy of India.\\r\\n (2-A) An arbitral award arising out of arbitrations other than international commercial arbitrations, may also be set aside by the court, if the court finds that the award is vitiated by patent illegality appearing on the face of the award:\\r\\nProvided that an award shall not be set aside merely on the ground of an erroneous application of the law or by reappreciation of evidence.\\r\\n(3) An application for setting aside may not be made after three months have elapsed from the date on which the party making that application had received the arbitral award or, if a request had been made under Section 33, from the date on which that request had been disposed of by the arbitral tribunal:\\r\\nProvided that if the Court is satisfied that the applicant was prevented by sufficient cause from making the application within the said period of three months it may entertain the application within a further period of thirty days, but not thereafter.\\r\\n(4) On receipt of an application under sub-section (1), the Court may, where it is appropriate and it is so requested by a party, adjourn the proceedings for a period of time determined by it in order to give the arbitral tribunal an opportunity to resume the arbitral proceedings or to take such other action as in the opinion of arbitral tribunal will eliminate the grounds for setting aside the arbitral award.\\r\\n (5) An application under this section shall be filed by a party only after issuing a prior notice to the other party and such application shall be accompanied by an affidavit by the applicant endorsing compliance with the said requirement.\\r\\n(6) An application under this section shall be disposed of expeditiously, and in any event, within a period of one year from the date on which the notice referred to in sub-section (5) is served upon the other party\\r\\n\"]}', 1, '2021-02-01 19:28:30', '2021-02-01 19:29:02'),
(86, 'sfiHTKtLmV50CHCQynYwqK3xT', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 8', 'FINALITY AND ENFORCEMENT OF ARBITRAL AWARDS', '', '', '{\"1\":[\"35. Finality of arbitral awards\",\"Subject to this Part an arbitral award shall be final and binding on the parties and persons claiming under them respectively.\"],\"2\":[\"36. Enforcement\",\"(1) Where the time for making an application to set aside the arbitral award under Section 34 has expired, then, subject to the provisions of sub-section (2), such award shall be enforced in accordance with the provisions of the Code of Civil Procedure, 1908 (5 of 1908), in the same manner as if it were a decree of the court.\\r\\n(2) Where an application to set aside the arbitral award has been filed in the court under Section 34, the filing of such an application shall not by itself render that award unenforceable, unless the court grants an order of stay of the operation of the said arbitral award in accordance with the provisions of sub-section (3), on a separate application made for that purpose\\r\\n(3) Upon filing of an application under sub-section (2) for stay of the operation of the arbitral award, the court may, subject to such conditions as it may deem fit, grant stay of the operation of such award for reasons to be recorded in writing\"]}', 1, '2021-02-01 19:29:55', '2021-02-01 19:33:52'),
(87, 'BvwivGY8iKkqcOJl584xGowmb', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 9', 'APPEALS', '', '', '{\"1\":[\"37. Appealable orders\",\"(1) Notwithstanding anything contained in any other law for the time being in force, an appeal] shall lie from the following orders (and from no others) to the court authorised by law to hear appeals from original decrees of the Court passing the order, namely:\\u2014\\r\\n(a) refusing to refer the parties to arbitration under Section 8;\\r\\n(b) granting or refusing to grant any measure under Section 9;\\r\\n(c) setting aside or refusing to set aside an arbitral award under Section 34.\\r\\n(2) An appeal shall also lie to a court from an order of the arbitral tribunal\\u2014\\r\\n(a) accepting the plea referred to in sub-section (2) or sub-section (3) of Section 16; or\\r\\n(b) granting or refusing to grant an interim measure under Section 17.\\r\\n(3) No second appeal shall lie from an order passed in appeal under this section, but nothing in this section shall affect or take away any right to appeal to the Supreme Court.\\r\\n\"]}', 1, '2021-02-01 19:35:07', '2021-02-01 19:35:07'),
(88, 'qS5MDsjVw6sLKSDuPnPKoQIOe', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 CHAPTER 10', 'MISCELLANEOUS', '', '', '{\"1\":[\"38. Deposits\",\"(1) The arbitral tribunal may fix the amount of the deposit or supplementary deposit, as the case may be, as an advance for the costs referred to in sub-section (8) of Section 31, which it expects will be incurred in respect of the claim submitted to it:\\r\\nProvided that where, apart from the claim, a counter-claim has been submitted to the arbitral tribunal, it may fix separate amount of deposit for the claim and counter-claim.\\r\\n(2) The deposit referred to in sub-section (1) shall be payable in equal shares by the parties:\\r\\nProvided that where one party fails to pay his share of the deposit, the other party may pay that share:\\r\\nProvided further that where the other party also does not pay the aforesaid share in respect of the claim or the counter-claim, the arbitral tribunal may suspend or terminate the arbitral proceedings in respect of such claim or counter-claim, as the case may be.\\r\\n(3) Upon termination of the arbitral proceedings, the arbitral tribunal shall render an accounting to the parties of the deposits received and shall return any unexpended balance to the party or parties, as the case may be.\\r\\n\"],\"2\":[\"39. Lien on arbitral award and deposits as to costs\",\"(1) Subject to the provisions of sub-section (2) and to any provision to the contrary in the arbitration agreement, the arbitral tribunal shall have a lien on the arbitral award for any unpaid costs of the arbitration.\\r\\n(2) If in any case an arbitral tribunal refuses to deliver its award except on payment of the costs demanded by it, the Court may, on an application in this behalf, order that the arbitral tribunal shall deliver the arbitral award to the applicant on payment into Court by the applicant of the costs demanded, and shall, after such inquiry, if any, as it thinks fit, further order that out of the money so paid into court there shall be paid to the arbitral tribunal by way of costs such sum as the court may consider reasonable and that the balance of the money, if any, shall be refunded to the applicant.\\r\\n(3) An application under sub-section (2) may be made by any party unless the fees demanded have been fixed by written agreement between him and the arbitral tribunal, and the arbitral tribunal shall be entitled to appear and be heard on any such application.\\r\\n(4) The Court may make such orders as it thinks fit respecting the costs of the arbitration where any question arises respecting such costs and the arbitral award contains no sufficient provision concerning them.\\r\\n\"],\"3\":[\"40. Arbitration agreement not to be discharged by death of party thereto\",\"(1) An arbitration agreement shall not be discharged by the death of any party thereto either as respects the deceased or as respects any other party, but shall in such event be enforceable by or against the legal representative of the deceased.\\r\\n(2) The mandate of an arbitrator shall not be terminated by the death of any party by whom he was appointed.\\r\\n(3) Nothing in this section shall affect the operation of any law by virtue of which any right of action is extinguished by the death of a person.\\r\\n\"],\"4\":[\"41. Provisions in case of insolvency\",\"(1) Where it is provided by a term in a contract to which an insolvent is a party that any dispute arising thereout or in connection therewith shall be submitted to arbitration, the said term shall, if the receiver adopts the contract, be enforceable by or against him so far as it relates to any such dispute.\\r\\n(2) Where a person who has been adjudged an insolvent had, before the commencement of the insolvency proceedings, become a party to an arbitration agreement, and any matter to which the agreement applies is required to be determined in connection with, or for the purposes of, the insolvency proceedings, then, if the case is one to which sub-section (1) does not apply, any other party or the receiver may apply to the judicial authority having jurisdiction in the insolvency proceedings for an order directing that the matter in question shall be submitted to arbitration in accordance with the arbitration agreement, and the judicial authority may, if it is of opinion that, having regard to all the circumstances of the case, the matter ought to be determined by arbitration, make an order accordingly.\\r\\n(3) In this section, the expression \\u201creceiver\\u201d includes an Official Assignee.\\r\\n\"],\"5\":[\"42. Jurisdiction\",\"Notwithstanding anything contained elsewhere in this Part or in any other law for the time being in force, where with respect to an arbitration agreement any application under this Part has been made in a Court, that Court alone shall have jurisdiction over the arbitral proceedings and all subsequent applications arising out of that agreement and the arbitral proceedings shall be made in that Court and in no other Court.\"],\"6\":[\"42-A. Confidentiality of information\",\"Notwithstanding anything contained in any other law for the time being in force, the arbitrator, the arbitral institution and the parties to the arbitration agreement shall maintain confidentiality of all arbitral proceedings except award where its disclosure is necessary for the purpose of implementation and enforcement of award\"],\"7\":[\"42-B. Protection of action taken in good faith\",\"No suit or other legal proceedings shall lie against the arbitrator for anything which is in good faith done or intended to be done under this Act or the rules or regulations made thereunder\"],\"8\":[\"43. Limitations\",\"(1) The Limitation Act, 1963 (XXXVI of 1963), shall apply to arbitrations as it applies to proceedings in court.\\r\\n(2) For the purposes of this section and the Limitation Act, 1963 (XXXVI of 1963), an arbitration shall be deemed to have commenced on the date referred in Section 21.\\r\\n(3) Where an arbitration agreement to submit future disputes to arbitration provides that any claim to which the agreement applies shall be barred unless some step to commence arbitral proceedings is taken within a time fixed by the agreement, and a dispute arises to which the agreement applies, the Court, if it is of opinion that in the circumstances of the case undue hardship would otherwise be caused, and notwithstanding that the time so fixed has expired, may on such terms, if any, as the justice of the case may require, extend the time for such period as it thinks proper.\\r\\n(4) Where the Court orders that an arbitral award be set aside, the period between the commencement of the arbitration and the date of the order of the Court shall be excluded in computing the time prescribed by the Limitation Act, 1963 (XXXVI of 1963), for the commencement of the proceedings (including arbitration) with respect to the dispute so submitted.\\r\\n\"]}', 1, '2021-02-01 19:35:59', '2021-02-01 19:39:30'),
(89, 'M8rrvu01DLVw9Bz2ZCqpw4HUO', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 1 A', 'ARBITRATION COUNCIL OF INDIA', '', '', '{\"1\":[\"43-A. Definitions\",\"In this Part, unless the context otherwise requires,\\u2014\\r\\n(a) \\u201cChairperson \\u201dmeans the Chairperson of the Arbitration Council of India appointed under clause (a) of sub-section (1) of Section 43-C;\\r\\n(b) \\u201cCouncil \\u201dmeans the Arbitration Council of India established under Section 43-B;\\r\\n(c) \\u201cMember \\u201dmeans a Member of the Council and includes the Chairperson.\\r\\n\"],\"2\":[\"43-B. Establishment and incorporation of Arbitration Council of India\",\"(1) The Central Government shall, by notification in the Official Gazette, establish, for the purposes of this Act, a Council to be known as the Arbitration Council of India to perform the duties and discharge the functions under this Act.\\r\\n(2) The Council shall be a body corporate by the name aforesaid, having perpetual succession and a common seal, with power, subject to the provisions of this Act, to acquire, hold and dispose of property, both movable and immovable, and to enter into contract, and shall, by the said name, sue or be sued.\\r\\n(3) The head office of the Council shall be at Delhi.\\r\\n(4) The Council may, with the prior approval of the Central Government, establish offices at other places in India.\\r\\n\"],\"3\":[\"43-C. Composition of Council\",\"(1) The Council shall consist of the following Members, namely:\\u2014\\r\\n(a) a person, who has been, a Judge of the Supreme Court or, Chief Justice of a High Court or, a Judge of a High Court or an eminent person, having special knowledge and experience in the conduct or administration of arbitration, to be appointed by the Central Government in consultation with the Chief Justice of India\\u2014Chairperson;\\r\\n(b) an eminent arbitration practitioner having substantial knowledge and experience in institutional arbitration, both domestic and international, to be nominated by the Central Government\\u2014Member;\\r\\n(c) an eminent academician having experience in research and teaching in the field of arbitration and alternative dispute resolution laws, to be appointed by the Central Government in consultation with the Chairperson\\u2014Member;\\r\\n(d) Secretary to the Government of India in the Department of Legal Affairs, Ministry of Law and Justice or his representative not below the rank of Joint Secretary\\u2014Member, ex officio;\\r\\n(e) Secretary to the Government of India in the Department of Expenditure, Ministry of Finance or his representative not below the rank of Joint Secretary\\u2014Member, ex officio;\\r\\n(f) one representative of a recognised body of commerce and industry, chosen on rotational basis by the Central Government\\u2014Part-time Member; and\\r\\n(g) Chief Executive Officer\\u2014Member-Secretary, ex officio.\\r\\n(2) The Chairperson and Members of the Council, other than ex officio Members, shall hold office as such, for a term of three years from the date on which they enter upon their office:\\r\\nProvided that no Chairperson or Member, other than ex officio Member, shall hold office as such after he has attained the age of seventy years in the case of Chairperson and sixty-seven years in the case of Member.\\r\\n(3) The salaries, allowances and other terms and conditions of the Chairperson and Members referred to in clauses (b) and (c) of sub-section (1) shall be such as may be prescribed by the Central Government.\\r\\n(4) The Part-time Member shall be entitled to such travelling and other allowances as may be prescribed by the Central Government.\\r\\n\"],\"4\":[\"43-D. Duties and functions of Council\",\"(1) It shall be the duty of the Council to take all such measures as may be necessary to promote and encourage arbitration, mediation, conciliation or other alternative dispute resolution mechanism and for that purpose to frame policy and guidelines for the establishment, operation and maintenance of uniform professional standards in respect of all matters relating to arbitration.\\r\\n(2) For the purposes of performing the duties and discharging the functions under this Act, the Council may\\u2014\\r\\n(a) frame policies governing the grading of arbitral institutions;\\r\\n(b) recognise professional institutes providing accreditation of arbitrators;\\r\\n(c) review the grading of arbitral institutions and arbitrators;\\r\\n(d) hold training, workshops and courses in the area of arbitration in collaboration of law firms, law universities and arbitral institutes;\\r\\n(e) frame, review and update norms to ensure satisfactory level of arbitration and conciliation;\\r\\n(f) act as a forum for exchange of views and techniques to be adopted for creating a platform to make India a robust centre for domestic and international arbitration and conciliation;\\r\\n(g) make recommendations to the Central Government on various measures to be adopted to make provision for easy resolution of commercial disputes;\\r\\n(h) promote institutional arbitration by strengthening arbitral institutions;\\r\\n(i) conduct examination and training on various subjects relating to arbitration and conciliation and award certificates thereof;\\r\\n(j) establish and maintain depository of arbitral awards made in India;\\r\\n(k) make recommendations regarding personnel, training and infrastructure of arbitral institutions; and\\r\\n(l) such other functions as may be decided by the Central Government.\\r\\n\"],\"5\":[\"43-E. Vacancies, etc., not to invalidate proceedings of Council\",\"No act or proceeding of the Council shall be invalid merely by reason of\\u2014\\r\\n(a) any vacancy or any defect, in the constitution of the Council;\\r\\n(b) any defect in the appointment of a person acting as a Member of the Council; or\\r\\n(c) any irregularity in the procedure of the Council not affecting the merits of the case\\r\\n\"],\"6\":[\"43-F. Resignation of Members\",\"The Chairperson or the Full-time or Part-time Member may, by notice in writing, under his hand addressed to the Central Government, resign his office:\\r\\nProvided that the Chairperson or the Full-time Member shall, unless he is permitted by the Central Government to relinquish his office sooner, continue to hold office until the expiry of three months from the date of receipt of such notice or until a person duly appointed as his successor enters upon his office or until the expiry of his term of office, whichever is earlier\\r\\n\"],\"7\":[\"43-G. Removal of Member\",\"(1) The Central Government may, remove a Member from his office if he\\u2014\\r\\n(a) is an undischarged insolvent; or\\r\\n(b) has engaged at any time (except Part-time Member), during his term of office, in any paid employment; or\\r\\n(c) has been convicted of an offence which, in the opinion of the Central Government, involves moral turpitude; or\\r\\n(d) has acquired such financial or other interest as is likely to affect prejudicially his functions as a Member; or\\r\\n(e) has so abused his position as to render his continuance in office prejudicial to the public interest; or\\r\\n(f) has become physically or mentally incapable of acting as a Member.\\r\\n(2) Notwithstanding anything contained in sub-section (1), no Member shall be removed from his office on the grounds specified in clauses (d) and (e) of that sub-section unless the Supreme Court, on a reference being made to it in this behalf by the Central Government, has, on an inquiry, held by it in accordance with such procedure as may be prescribed in this behalf by the Supreme Court, reported that the Member, ought on such ground or grounds to be removed.\\r\\n\"],\"8\":[\"43-H. Appointment of experts and constitution of Committees thereof\",\"The Council may, appoint such experts and constitute such Committees of experts as it may consider necessary to discharge its functions on such terms and conditions as may be specified by the regulations.\"],\"9\":[\"43-I. General norms for grading of arbitral institutions\",\"The Council shall make grading of arbitral institutions on the basis of criteria relating to infrastructure, quality and calibre of arbitrators, performance and compliance of time limits for disposal of domestic or international commercial arbitrations, in such manner as may be specified by the regulations.\"],\"10\":[\"43-J. Norms for accreditation\",\"The qualifications, experience and norms for accreditation of arbitrators shall be such as specified in the Eighth Schedule:\"],\"11\":[\"43-K. Depository of awards\",\"The Council shall maintain an electronic depository of arbitral awards made in India and such other records related thereto in such manner as may be specified by the regulations.\"],\"12\":[\"43-L. Power to make regulations by Council\",\"The Council may, in consultation with the Central Government, make regulations, consistent with the provisions of this Act and the rules made thereunder, for the discharge of its functions and perform its duties under this Act.\"],\"13\":[\"43-M. Chief Executive Officer\",\"(1) There shall be a Chief Executive Officer of the Council, who shall be responsible for day-to-day administration of the Council.\\r\\n(2) The qualifications, appointment and other terms and conditions of the service of the Chief Executive Officer shall be such as may be prescribed by the Central Government.\\r\\n(3) The Chief Executive Officer shall discharge such functions and perform such duties as may be specified by the regulations.\\r\\n(4) There shall be a Secretariat to the Council consisting of such number of officers and employees as may be prescribed by the Central Government.\\r\\n(5) The qualifications, appointment and other terms and conditions of the service of the employees and other officers of the Council shall be such as may be prescribed by the Central Government.\\r\\n\"]}', 1, '2021-02-01 19:41:53', '2021-02-01 19:47:15'),
(90, 'bVha0KvsVo0hRKKAaXoZHwC8A', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 2 CHAPTER 1', 'NEW YORK CONVENTION AWARDS', '', '', '{\"1\":[\"44. Definition\",\"In this Chapter, unless the context otherwise requires, \\u201cforeign award\\u201d means an arbitral award on differences between persons arising out of legal relationships, whether contractual or not, considered as commercial under the law in force in India, made on or after the 11th day of October, 1960\\u2014\\r\\n(a) in pursuance of an agreement in writing for arbitration to which the Convention set forth in the First Schedule applies, and\\r\\n(b) in one of such territories as the Central Government, being satisfied that reciprocal provisions have been made may, by notification in the Official Gazette, declare to be territories to which the said Convention applies.\\r\\n\"],\"2\":[\"45. Power of judicial authority to refer parties to arbitration\",\"Notwithstanding anything contained in Part I or in the Code of Civil Procedure, 1908 (V of 1908), a judicial authority, when seized of an action in a matter in respect of which the parties have made an agreement referred to in Section 44, shall, at the request of one of the parties or any person claiming through or under him, refer the parties to arbitration,  unless it prima facie findsthat the said agreement is null and void, inoperative or incapable of being performed.\"],\"3\":[\"46. When foreign award binding\",\"Any foreign award which would be enforceable under this Chapter shall be treated as binding for all purposes on the persons as between whom it was made, and may accordingly be relied on by any of those persons by way of defence, set-off or otherwise in any legal proceedings in India and any references in this Chapter to enforcing a foreign award shall be construed as including references to relying on an award\"],\"4\":[\"47. Evidence\",\"(1) The party applying for the enforcement of a foreign award shall, at the time of the application, produce before the Court\\u2014\\r\\n(a) the original award or a copy thereof, duly authenticated in the manner required by the law of the country in which it was made;\\r\\n(b) the original agreement for arbitration or a duly certified copy thereof; and\\r\\n(c) such evidence as may be necessary to prove that the award is a foreign award.\\r\\n(2) If the award or agreement to be produced under sub-section (1) is in a foreign language, the party seeking to enforce the award shall produce a translation into English certified as correct by a diplomatic or consular agent of the country to which that party belongs or certified as correct in such other manner as may be sufficient according to the law in force in India.\\r\\n\"],\"5\":[\"48. Conditions for enforcement of foreign awards\",\"(1) Enforcement of a foreign award may be refused, at the request of the party against whom it is invoked, only if that party furnishes to the Court proof that\\u2014\\r\\n(a) the parties to the agreement referred to in Section 44 were, under the law applicable to them, under some incapacity, or the said agreement is not valid under the law to which the parties have subjected it or, failing any indication thereon, under the law of the country where the award was made; or\\r\\n(b) the party against whom the award is invoked was not given proper notice of the appointment of the arbitrator or of the arbitral proceedings or was otherwise unable to present his case; or\\r\\n(c) the award deals with a difference not contemplated by or not falling within the terms of the submission to arbitration, or it contains decisions on matters beyond the scope of the submission to arbitration:\\r\\nProvided that, if the decisions on matters submitted to arbitration can be separated from those not so submitted, that part of the award which contains decisions on matters submitted to arbitration may be enforced; or\\r\\n(d) the composition of the arbitral authority or the arbitral procedure was not in accordance with the agreement of the parties, or, failing such agreement, was not in accordance with the law of the country where the arbitration took place; or\\r\\n(e) the award has not yet become binding on the parties, or has been set aside or suspended by a competent authority of the country in which, or under the law of which, that award was made.\\r\\n(2) Enforcement of an arbitral award may also be refused if the Court finds that\\u2014\\r\\n(a) the subject-matter of the difference is not capable of settlement by arbitration under the law of India; or\\r\\n(b) the enforcement of the award would be contrary to the public policy of India.\\r\\n(3) If an application for the setting aside or suspension of the award has been made to a competent authority referred to in clause (e) of sub-section (1) the Court may, if it considers it proper, adjourn the decision on the enforcement of the award and may also, on the application of the party claiming enforcement of the award, order the other party to give suitable security.\\r\\n\"],\"6\":[\"49. Enforcement of foreign awards\",\"Where the Court is satisfied that the foreign award is enforceable under this Chapter, the award shall be deemed to be a decree of that Court.\"],\"7\":[\"50. Appealable orders\",\"(1) Notwithstanding anything contained in any other law for the time being in force, an appeal] shall lie from the order refusing to\\u2014\\r\\n(a) refer the parties to arbitration under Section 45;\\r\\n(b) enforce a foreign award under Section 48;\\r\\nto the Court authorised by law to hear appeals from such order.\\r\\n(2) No second appeal shall lie from an order passed in appeal under this section, but nothing in this section shall affect or take away any right to appeal to the Supreme Court.\\r\\n\"],\"8\":[\"51. Saving\",\"Nothing in this Chapter shall prejudice any rights which any person would have had of enforcing in India of any award or of availing himself in India of any award if this Chapter had not been enacted.\"],\"9\":[\"52. Chapter II not to apply\",\"Chapter II of this Part shall not apply in relation to foreign awards to which this Chapter applies.\"]}', 1, '2021-02-01 19:50:15', '2021-02-01 19:54:25');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(91, '2uTPpi3nNMgtY2Q7KbD1SVOYk', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 2 CHAPTER 2', 'GENEVA CONVENTION AWARDS', '', '', '{\"1\":[\"53. Interpretation\",\"In this Chapter \\u201cforeign award\\u201d means an arbitral award on differences relating to matters considered as commercial under the law in force in India made after the 28th day of July, 1924,\\u2014\\r\\n(a) in pursuance of an agreement for arbitration to which the Protocol set forth in the Second Schedule applies, and\\r\\n(b) between persons of whom one is subject to the jurisdiction of some one of such powers as the Central Government, being satisfied that reciprocal provisions have been made, may, by notification in the Official Gazette, declare to be parties to the Convention set forth in the Third Schedule, and of whom the other is subject to the jurisdiction of some other of the powers aforesaid, and\\r\\n(c) in one of such territories as the Central Government, being satisfied that reciprocal provisions have been made, may, by like notification, declare to be territories to which the said Convention applies,\\r\\nand for the purposes of this Chapter an award shall not be deemed to be final if any proceedings for the purpose of contesting the validity of the award are pending in the country in which it was made.\\r\\n\"],\"2\":[\"54. Power of judicial authority to refer parties to arbitration\",\"Notwithstanding anything contained in Part I or in the Code of Civil Procedure, 1908 (V of 1908), a judicial authority, on being seized of a dispute regarding a contract made between persons to whom Section 53 applies and including an arbitration agreement, whether referring to present or future differences, which is valid under that section and capable of being carried into effect, shall refer the parties on the application of either of them or any person claiming through or under him to the decision of the arbitrators and such reference shall not prejudice the competence of the judicial authority in case the agreement or the arbitration cannot proceed or becomes inoperative.\"],\"3\":[\"55. Foreign awards when binding\",\"Any foreign award which would be enforceable under this Chapter shall be treated as binding for all purposes on the persons as between whom it was made, and may accordingly be relied on by any of those persons by way of defence, set-off or otherwise in any legal proceedings in India and any references in this Chapter to enforcing a foreign award shall be construed as including references to relying on an award.\"],\"4\":[\"56. Evidence\",\"(1) The party applying for the enforcement of a foreign award shall, at the time of application produce before the Court\\u2014\\r\\n(a) the original award or a copy thereof duly authenticated in the manner required by the law of the country in which it was made;\\r\\n(b) evidence proving that the award has become final; and\\r\\n(c) such evidence as may be necessary to prove that the conditions mentioned in clauses (a) and (c) of sub-section (1) of Section 57 are satisfied.\\r\\n(2) Where any document requiring to be produced under sub-section (1) is in a foreign language, the party seeking to enforce the award shall produce a translation into English certified as correct by a diplomatic or consular agent of the country to which that party belongs or certified as correct in such other manner as may be sufficient according to the law in force in India.\\r\\n\"],\"5\":[\"57. Conditions for enforcement of foreign awards\",\" (1) In order that a foreign award may be enforceable under this Chapter, it shall be necessary that\\u2014\\r\\n(a) the award has been made in pursuance of a submission to arbitration which is valid under the law applicable thereto;\\r\\n(b) the subject-matter of the award is capable of settlement by arbitration under the law of India;\\r\\n(c) the award has been made by the arbitral tribunal provided for in the submission to arbitration or constituted in the manner agreed upon by the parties and in conformity with the law governing the arbitration procedure;\\r\\n(d) the award has become final in the country in which it has been made, in the sense that it will not be considered as such if it is open to opposition or appeal or if it is proved that any proceedings for the purpose of contesting the validity of the award are pending;\\r\\n(e) the enforcement of the award is not contrary to the public policy or the law of India.\\r\\n(2) Even if the conditions laid down in sub-section (1) are fulfilled, enforcement of the award shall be refused if the Court is satisfied that\\u2014\\r\\n(a) the award has been annulled in the country in which it was made;\\r\\n(b) the party against whom it is sought to use the award was not given notice of the arbitration proceedings in sufficient time to enable him to present his case; or that, being under a legal incapacity, he was not properly represented;\\r\\n(c) the award does not deal with the differences contemplated by or falling within the terms of the submission to arbitration or that it contains decisions on matters beyond the scope of the submission to arbitration:\\r\\nProvided that if the award has not covered all the differences submitted to the arbitral tribunal, the Court may, if it thinks fit, postpone such enforcement or grant it subject to such guarantee as the Court may decide.\\r\\n(3) If the party against whom the award has been made proves that under the law governing the arbitration procedure there is a ground, other than the grounds referred to in clauses (a) and (c) of sub-section (1) and clauses (b) and (c) of sub-section (2) entitling him to contest the validity of the award, the Court may, if it thinks fit, either refuse enforcement of the award or adjourn the consideration thereof, giving such party a reasonable time within which to have the award annulled by the competent tribunal.\\r\\n\"],\"6\":[\"58. Enforcement of foreign awards\",\"Where the Court is satisfied that the foreign award is enforceable under this Chapter, the award shall be deemed to be a decree of the Court\"],\"7\":[\"59. Appealable orders\",\"(1) An appeal shall lie from the order refusing\\u2014\\r\\n(a) to refer the parties to arbitration under Section 54; and\\r\\n(b) to enforce a foreign award under Section 57\\r\\n(2) No second appeal shall lie from an order passed in appeal under this section, but nothing in this section shall affect or take away any right to appeal to the Supreme Court.\"],\"8\":[\"60. Saving\",\"Nothing in this Chapter shall prejudice any rights which any person would have had of enforcing in India of any award or of availing himself in India of any award if this Chapter had not been enacted\"]}', 1, '2021-02-01 19:55:12', '2021-02-01 19:58:07'),
(92, 'ZpgaxFp4lQK5q6r5GM3DaeA8N', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 3', 'CONCILIATION', '', '', '{\"1\":[\"61. Application and scope\",\"(1) Save as otherwise provided by any law for the time being in force and unless the parties have otherwise agreed, this Part shall apply to conciliation of disputes arising out of legal relationship, whether contractual or not, and to all proceedings relating thereto.\\r\\n(2) This Part shall not apply where by virtue of any law for the time being in force certain disputes may not be submitted to conciliation.\\r\\n\"],\"2\":[\"62. Commencement of conciliation proceedings\",\"(1) The party initiating conciliation shall send to the other party a written invitation to conciliate under this Part, briefly identifying the subject of the dispute.\\r\\n(2) Conciliation proceedings shall commence when the other party accepts in writing the invitation to conciliate.\\r\\n(3) If the other party rejects the invitation, there will be no conciliation proceedings.\\r\\n(4) If the party initiating conciliation does not receive a reply within thirty days from the date on which he sends the invitation, or within such other period of time as specified in the invitation, he may elect to treat this as a rejection of the invitation to conciliate and if he so elects, he shall inform in writing the other party accordingly.\\r\\n\"],\"3\":[\"63. Number of conciliators\",\"(1) There shall be one conciliator unless the parties agree that there shall be two or three conciliators.\\r\\n(2) Where there is more than one conciliator, they ought, as a general rule, to act jointly.\\r\\n64. Appointment of conciliators.\\u2014(1) Subject to sub-section (2),\\u2014\\r\\n(a) in conciliation proceedings with one conciliator, the parties may agree on the name of a sole conciliator;\\r\\n(b) in conciliation proceedings with two conciliators, each party may appoint one conciliator;\\r\\n(c) in conciliation proceedings with three conciliators, each party may appoint one conciliator and the parties may agree on the name of the third conciliator who shall act as the presiding conciliator.\\r\\n(2) Parties may enlist the assistance of a suitable institution or person in connection with the appointment of conciliators, and in particular,\\u2014\\r\\n(a) a party may request such an institution or person to recommend the names of suitable individuals to act as conciliator; or\\r\\n(b) the parties may agree that the appointment of one or more conciliators be made directly by such an institution or person\\r\\n\"],\"4\":[\"64. Appointment of conciliators\",\"(1) Subject to sub-section (2),\\u2014\\r\\n(a) in conciliation proceedings with one conciliator, the parties may agree on the name of a sole conciliator;\\r\\n(b) in conciliation proceedings with two conciliators, each party may appoint one conciliator;\\r\\n(c) in conciliation proceedings with three conciliators, each party may appoint one conciliator and the parties may agree on the name of the third conciliator who shall act as the presiding conciliator.\\r\\n(2) Parties may enlist the assistance of a suitable institution or person in connection with the appointment of conciliators, and in particular,\\u2014\\r\\n(a) a party may request such an institution or person to recommend the names of suitable individuals to act as conciliator; or\\r\\n(b) the parties may agree that the appointment of one or more conciliators be made directly by such an institution or person:\\r\\n\"],\"5\":[\"65. Submission of statements to conciliator\",\"(1) The conciliator, upon his appointment, may request each party to submit to him a brief written statement describing the general nature of the dispute and the points at issue. Each party shall send a copy of such statement to the other party.\\r\\n(2) The conciliator may request each party to submit to him a further written statement of his position and the facts and grounds in support thereof, supplemented by any documents and other evidence that such party deems appropriate. The party shall send a copy of such statement, documents and other evidence to the other party.\\r\\n(3) At any stage of the conciliation proceedings, the conciliator may request a party to submit to him such additional information as he deems appropriate\\r\\n\"],\"6\":[\"66. Conciliator not bound by certain enactments\",\"The conciliator is not bound by the Code of Civil Procedure, 1908 (V of 1908), or the Indian Evidence Act, 1872 (1 of 1872).\"],\"7\":[\"67. Role of conciliator\",\"(1) The conciliator shall assist the parties in an independent and impartial manner in their attempt to reach an amicable settlement of their dispute.\\r\\n(2) The conciliator shall be guided by principles of objectivity, fairness and justice, giving consideration to, among other things, the rights and obligations of the parties, the usages of the trade concerned and the circumstances surrounding the dispute, including any previous business practices between the parties.\\r\\n(3) The conciliator may conduct the conciliation proceedings in such a manner as he considers appropriate, taking into account the circumstances of the case, the wishes the parties may express, including any request by a party that the conciliator hear oral statements, and the need for a speedy settlement of the dispute.\\r\\n(4) The conciliator may, at any stage of the conciliation proceedings, make proposals for a settlement of the dispute. Such proposals need not be in writing and need not be accompanied by a statement of the reasons therefor.\\r\\n\"],\"8\":[\"68. Administrative assistance\",\"In order to facilitate the conduct of the conciliation proceedings, the parties, or the conciliator with the consent of the parties, may arrange for administrative assistance by a suitable institution or person\"],\"9\":[\"69. Communication between conciliator and parties\",\"(1) The conciliator may invite the parties to meet him or may communicate with them orally or in writing. He may meet or communicate with the parties together or with each of them separately.\\r\\n(2) Unless the parties have agreed upon the place where meetings with the conciliator are to be held, such place shall be determined by the conciliator, after consultation with the parties, having regard to the circumstances of the conciliation proceedings.\\r\\n\"],\"10\":[\"70. Disclosure of information\",\"When the conciliator receives factual information concerning the dispute from a party, he shall disclose the substance of that information to the other party in order that the other party may have the opportunity to present any explanation which he considers appropriate:\"],\"11\":[\"71. Cooperation of parties with conciliator\",\"The parties shall in good faith cooperate with the conciliator and, in particular, shall endeavour to comply with requests by the conciliator to submit written materials, provide evidence and attend meetings.\"],\"12\":[\"72. Suggestions by parties for settlement of dispute\",\"Each party may, on his own initiative or at the invitation of the conciliator, submit to the conciliator suggestions for the settlement of the dispute.\"],\"13\":[\"73. Settlement agreement\",\"(1) When it appears to the conciliator that there exist elements of a settlement which may be acceptable to the parties, he shall formulate the terms of a possible settlement and submit them to the parties for their observations. After receiving the observations of the parties, the conciliator may reformulate the terms of a possible settlement in the light of such observations.\\r\\n(2) If the parties reach agreement on a settlement of the dispute, they may draw up and sign a written settlement agreement. If requested by the parties, the conciliator may draw up, or assist the parties in drawing up, the settlement agreement.\\r\\n(3) When the parties sign the settlement agreement, it shall be final and binding on the parties and persons claiming under them respectively.\\r\\n(4) The conciliator shall authenticate the settlement agreement and furnish a copy thereof to each of the parties.\\r\\n\"],\"14\":[\"74. Status and effect of settlement agreement\",\"The settlement agreement shall have the same status and effect as if it is an arbitral award on agreed terms on the substance of the dispute rendered by an arbitral tribunal under Section 30.\"],\"15\":[\"75. Confidentiality\",\"Notwithstanding anything contained in any other law for the time being in force, the conciliator and the parties shall keep confidential all matters relating to the conciliation proceedings. Confidentiality shall extend also to the settlement agreement, except where its disclosure is necessary for purposes of implementation and enforcement.\"],\"16\":[\"76. Termination of conciliation proceedings\",\"The conciliation proceedings shall be terminated\\u2014\\r\\n(a) by the signing of the settlement agreement by the parties, on the date of the agreement; or\\r\\n(b) by a written declaration of the conciliator, after consultation with the parties, to the effect that further efforts at conciliation are no longer justified, on the date of the declaration; or\\r\\n(c) by a written declaration of the parties addressed to the conciliator to the effect that the conciliation proceedings are terminated, on the date of the declaration; or\\r\\n(d) by a written declaration of a party to the other party and the conciliator, if appointed, to the effect that the conciliation proceedings are terminated, on the date of the declaration.\\r\\n\"],\"17\":[\"77. Resort to arbitral or judicial proceedings\",\"The parties shall not initiate, during the conciliation proceedings, any arbitral or judicial proceedings in respect of a dispute that is the subject-matter of the conciliation proceedings except that a party may initiate arbitral or judicial proceedings where, in his opinion, such proceedings are necessary for preserving his rights.\"],\"18\":[\"78. Costs\",\"(1) Upon termination of the conciliation proceedings, the conciliator shall fix the costs of the conciliation and give written notice thereof to the parties.\\r\\n(2) For the purpose of sub-section (1), \\u201ccosts\\u201d means reasonable costs relating to\\u2014\\r\\n(a) the fee and expenses of the conciliator and witnesses requested by the conciliator with the consent of the parties;\\r\\n(b) any expert advice requested by the conciliator with the consent of the parties;\\r\\n(c) any assistance provided pursuant to clause (b) of sub-section (2) of Section 64 and Section 68;\\r\\n(d) any other expenses incurred in connection with the conciliation proceedings and the settlement agreement.\\r\\n(3) The costs shall be borne equally by the parties unless the settlement agreement provides for a different apportionment. All other expenses incurred by a party shall be borne by that party.\\r\\n\"],\"19\":[\"79. Deposits\",\"(1) The conciliator may direct each party to deposit an equal amount as an advance for the costs referred to in sub-section (2) of Section 78 which he expects will be incurred.\\r\\n(2) During the course of the conciliation proceedings, the conciliator may direct supplementary deposits in an equal amount from each party.\\r\\n(3) If the required deposits under sub-sections (1) and (2) are not paid in full by both parties within thirty days, the conciliator may suspend the proceedings or may make a written declaration of termination of the proceedings to the parties, effective on the date of that declaration.\\r\\n(4) Upon termination of the conciliation proceedings, the conciliator shall render an accounting to the parties of the deposits received and shall return any unexpended balance to the parties.\\r\\n\"],\"20\":[\"80. Role of conciliator in other proceedings\",\"Unless otherwise agreed by the parties,\\u2014\\r\\n(a) the conciliator shall not act as an arbitrator or as a representative or counsel of a party in any arbitral or judicial proceeding in respect of a dispute that is the subject of the conciliation proceedings;\\r\\n(b) the conciliator shall not be presented by the parties as a witness in any arbitral or judicial proceedings.\\r\\n\"],\"21\":[\"81. Admissibility of evidence in other proceedings\",\"The parties shall not rely on or introduce as evidence in arbitral or judicial proceedings, whether or not such proceedings relate to the dispute that is the subject of the conciliation proceedings,\\u2014\\r\\n(a) views expressed or suggestions made by the other party in respect of a possible settlement of the dispute;\\r\\n(b) admissions made by the other party in the course of the conciliation proceedings;\\r\\n(c) proposals made by the conciliator;\\r\\n(d) the fact that the other party had indicated his willingness to accept a proposal for settlement made by the conciliator.\\r\\n\"]}', 1, '2021-02-01 19:58:52', '2021-02-01 20:05:57'),
(93, 'X53EqJdYxMVGOeaY79Uh0QuYY', 'I1sLydS6hxk9n5H9lbJwICx5T', 'Part 4', 'SUPPLEMENTARY PROVISIONS', '', '', '{\"1\":[\"82. Power of High Court to make rules\",\"The High Court may make rules consistent with this Act as to all proceedings before the Court under this Act.\"],\"2\":[\"83. Removal of difficulties\",\"(1) If any difficulty arises in giving effect to the provisions of this Act, the Central Government may, by order published in the Official Gazette, make such provisions, not inconsistent with the provisions of this Act as appear to it to be necessary or expedient for removing the difficulty:\\r\\nProvided that no such order shall be made after the expiry of a period of two years from the date of commencement of this Act.\\r\\n(2) Every order made under this section shall, as soon as may be after it is made, be laid before each House of Parliament.\\r\\n\"],\"3\":[\"84. Power to make rules\",\"(1) The Central Government may, by notification in the Official Gazette, make rules for carrying out the provisions of this Act.\\r\\n(2) Every rule made by the Central Government under this Act shall be laid, as soon as may be, after it is made before each House of Parliament while it is in session, for a total period of thirty days which may be comprised in one session or in two or more successive sessions, and if, before the expiry of the session immediately following the session or the successive sessions aforesaid, both Houses agree in making any modification in the rule or both Houses agree that the rule should not be made, the rule shall thereafter have effect only in such modified form or be of no effect, as the case may be; so, however, that any such modification or annulment shall be without prejudice to the validity of anything previously done under that rule.\\r\\n\"],\"4\":[\"85. Repeal and savings\",\"(1) The Arbitration (Protocol and Convention) Act, 1937 (6 of 1937), the Arbitration Act, 1940 (10 of 1940) and the Foreign Awards (Recognition and Enforcement) Act, 1961 (45 of 1961) are hereby repealed.\\r\\n(2) Notwithstanding such repeal,\\u2014\\r\\n(a) the provisions of the said enactments shall apply in relation to arbitral proceedings which commenced before this Act came into force unless otherwise agreed by the parties but this Act shall apply in relation to arbitral proceedings which commenced on or after this Act comes into force;\\r\\n(b) all rules made and notifications published, under the said enactments shall, to the extent to which they are not repugnant to this Act, be deemed respectively to have been made or issued under this Act.\\r\\n\"],\"5\":[\"86. Repeal of Ordinance 27 of 1996 and saving\",\"(1) The Arbitration and Conciliation (Third) Ordinance, 1996 (27 of 1996) is hereby repealed.\\r\\n(2) Notwithstanding such repeal, any order, rule, notification or scheme made or anything done or any action taken in pursuance of any provision of the said Ordinance shall be deemed to have been made, done or taken under the corresponding provisions of this Act.\\r\\n\"],\"6\":[\"87. Effect of arbitral and related court proceedings commenced prior to 23rd October, 2015\",\"Unless the parties otherwise agree, the amendments made to this Act by the Arbitration and Conciliation (Amendment) Act, 2015 (3 of 2016) shall\\u2014\\r\\n(a) not apply to\\u2014\\r\\n(i) arbitral proceedings commenced before the commencement of the Arbitration and Conciliation (Amendment) Act, 2015 (3 of 2016);\\r\\n(ii) court proceedings arising out of or in relation to such arbitral proceedings irrespective of whether such court proceedings are commenced prior to or after the commencement of the Arbitration and Conciliation (Amendment) Act, 2015 (3 of 2016);\\r\\n(b) apply only to arbitral proceedings commenced on or after the commencement of the Arbitration and Conciliation (Amendment) Act, 2015 (3 of 2016) and to court proceedings arising out of or in relation to such arbitral proceedings.\\r\\n\"]}', 1, '2021-02-01 20:06:53', '2021-02-01 20:09:13'),
(94, 'ZcNDTqMyZI2KMrmp3OeHdm9XE', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE FIRST SCHEDULE', 'CONVENTION ON THE RECOGNITION AND ENFORCEMENT OF FOREIGN ARBITRAL AWARDS', '', '', '{\"1\":[\"Article 1\",\"1. This Convention shall apply to the recognition and enforcement of arbitral awards made in the territory of a State other than the State where the recognition and enforcement of such awards are sought, and arising out of differences between persons, whether physical or legal. It shall also apply to arbitral awards not considered as domestic awards in the State where their recognition and enforcement are sought.\\r\\n2. The term \\u201carbitral awards\\u201d shall include not only awards made by arbitrators appointed for each case but also those made by permanent arbitral bodies to which the parties have submitted.\\r\\n3. When signing, ratifying or acceding to this Convention, or notifying extension under Article X hereof, any State may on the basis of reciprocity declare that it will apply the Convention to the recognition and enforcement of awards made only in the territory of another Contracting State. It may also declare that it will apply the Convention only to differences arising out of legal relationships, whether contractual or not, which are considered as commercial under the national law of the State making such declaration.\\r\\n\"],\"2\":[\"Article 2\",\"1. Each Contracting State shall recognise an agreement in writing under which the parties undertake to submit to arbitration all or any differences which have arisen or which may arise between them in respect of defined legal relationship, whether contractual or not, concerning a subject-matter capable of settlement by arbitration.\\r\\n2. The term \\u201cagreement in writing\\u201d shall include an arbitral clause in a contract or an arbitration agreement, signed by the parties or contained in an exchange of letters or telegrams.\\r\\n3. The court of a Contracting State, when seized of an action in a matter in respect of which the parties have made an agreement within the meaning of this Article, shall, at the request of one of the parties, refer the parties to arbitration, unless it finds that the said agreement is null and void, inoperative or incapable of being performed.\\r\\n\"],\"3\":[\"Article 3\",\"Each Contracting State shall recognize arbitral awards as binding and enforce them in accordance with the rules of procedure of the territory where the award is relied upon, under the conditions laid down in the following Articles. There shall not be imposed substantially more onerous conditions or higher fees or charges on the recognition or enforcement of arbitral awards to which this Convention applies than are imposed on the recognition or enforcement of domestic arbitral awards.\"],\"4\":[\"Article 4\",\"1. To obtain the recognition and enforcement mentioned in the preceding Article, the party applying for recognition and enforcement shall, at the time of the application, supply:\\u2014\\r\\n(a) the duly authenticated original award or a duly certified copy thereof;\\r\\n(b) the original agreement referred to in Article II or a duly certified copy thereof.\\r\\n2. If the said award or agreement is not made in an official language of the country in which the award is relied upon, the party applying for recognition and enforcement of the award shall produce a translation of these documents into such language. The translation shall be certified by an official or sworn translator or by a diplomatic or consular agent.\\r\\n\"],\"5\":[\"Article 5\",\"1. Recognition and enforcement of the award may be refused, at the request of the party against whom it is invoked, only if that party furnishes to the competent authority where the recognition and enforcement is sought, proof that\\u2014\\r\\n(a) the parties to the agreement referred to in Article II were, under the law applicable to them, under some incapacity, or the said agreement is not valid under the law to which the parties have subjected it or, failing any indication thereon, under the law of the country where the award was made; or\\r\\n(b) the party against whom the award is invoked was not given proper notice of the appointment of the arbitrator or of the arbitration proceedings or was otherwise unable to present his case; or\\r\\n(c) the award deals with a difference not contemplated by or not falling within the terms of the submission to arbitration, or it contains decisions on matters beyond the scope of the submission to arbitration: provided that, if the decisions on matters submitted to arbitration can be separated from those not so submitted, that part of the award which contains decisions on matters submitted to arbitration may be recognised and enforced; or\\r\\n(d) the composition of the arbitral authority or the arbitral procedure was not in accordance with the agreement of the parties, or, failing such agreement, was not in accordance with the law of the country where the arbitration took place; or\\r\\n(e) the award has not yet become binding on the parties, or has been set aside or suspended by a competent authority of the country in which, or under the law of which, that award was made.\\r\\n2. Recognition and enforcement of an arbitral award may also be refused if the competent authority in the country where recognition and enforcement is sought finds that\\u2014\\r\\n(a) the subject-matter of the difference is not capable of settlement by arbitration under the law of that country; or\\r\\n(b) the recognition or enforcement of the award would be contrary to the public policy of that country.\\r\\n\"],\"6\":[\"Article 6\",\"If an application for the setting aside or suspension of the award has been made to a competent authority referred to in Article V(1)(e), the authority before which the award is sought to be relied upon may, if it considers it proper, adjourn the decision on the enforcement of the award and may also, on the application of the party claiming enforcement of the award, order the other party to give suitable security.\"],\"7\":[\"Article 7\",\"1. The provisions of the present Convention shall not affect the validity of multilateral or bilateral agreements concerning the recognition and enforcement of arbitral awards entered into by the Contracting States nor deprive any interested party of any right he may have to avail himself of an arbitral award in the manner and to the extent allowed by the law or the treaties of the country where such award is sought to be relied upon.\\r\\n2. The Geneva Protocol on Arbitration Clauses of 1923 and the Geneva Convention on the Execution of Foreign Arbitral Awards of 1927 shall cease to have effect between Contracting States on their becoming bound and to the extent that they become bound by this Convention.\\r\\n\"],\"8\":[\"Article 8\",\"1. This Convention shall be open until 31st December, 1958 for signature on behalf of any Member of the United Nations and also on behalf of any other State which is or hereafter becomes member of any specialised agency of the United Nations, or which is or hereafter becomes a party to the Statute of the International Court of Justice, or any other State to which an invitation has been addressed by the General Assembly of the United Nations.\\r\\n2. This Convention shall be ratified and the instrument of ratification shall be deposited with the Secretary-General of the United Nations.\\r\\n\"],\"9\":[\"Article 9\",\"1. This Convention shall be open for accession to all States referred to in Article VIII.\"],\"10\":[\"Article 10\",\"1. Any State may, at the time of signature, ratification or accession, declare that this Convention shall extend to all or any of the territories for the international relations of which it is responsible. Such a declaration shall take effect when the Convention enters into force for the State concerned.\\r\\n2. At any time thereafter any such extension shall be made by notification addressed to the Secretary-General of the United Nations and shall take effect as from the ninetieth day after the day of receipt by the Secretary-General of the United Nations of this notification, or as from the date of entry into force of the Convention for the State concerned, whichever is the later.\\r\\n3. With respect to those territories to which this Convention is not extended at the time of signature, ratification or accession, each State concerned shall consider the possibility of taking the necessary steps in order to extend the application of this Convention to such territories, subject, where necessary for constitutional reasons, to the consent of the Governments of such territories.\\r\\n\"],\"11\":[\"Article 11\",\"In the case of a federal or non-unitary State, the following provisions shall apply:\\u2014\\r\\n(a) with respect of those Articles of this Convention that come within the legislative jurisdiction of the federal authority, the obligations of the federal Government shall to this extent be the same as those of Contracting States which are not federal States;\\r\\n(b) with respect to those Articles of this Convention that come within the legislative jurisdiction of constituent States or provinces which are not, under the constitutional system of the federation, bound to take legislative action, the federal Government shall bring such Articles with a favourable recommendation to the notice of the appropriate authorities of constituent States or provinces at the earliest possible moment;\\r\\n(c) a federal State Party to this Convention shall, at the request of any other Contracting State transmitted through the Secretary-General of the United Nations, supply a statement of the law and practice of the federation and its constituent units in regard to any particular provision of this Convention, showing the extent to which effect has been given to that provision by legislative or other action.\\r\\n\"],\"12\":[\"Article 12\",\"1. This Convention shall come into force on the ninetieth day following the date of deposit of the third instrument of ratification or accession.\\r\\n2. For each State ratifying or acceding to this Convention after the deposit of the third instrument of ratification or accession, this Convention shall enter into force on the ninetieth day after deposit by such State of its instrument of ratification or accession.\\r\\n\"],\"13\":[\"Article 13\",\"1. Any Contracting State may denounce this Convention by a written notification to the Secretary-General of the United Nations. Denunciation shall take effect one year after the date of receipt of the notification by the Secretary-General.\\r\\n2. Any State which has made a declaration or notification under Article X may, at any time thereafter, by notification to the Secretary-General of the United Nations, declare that this Convention shall cease to extend to the territory concerned one year after the date of the receipt of the notification by the Secretary-General.\\r\\n3. This Convention shall continue to be applicable to arbitral awards in respect of which recognition or enforcement proceedings have been instituted before the denunciation takes effect.\\r\\n\"],\"14\":[\"Article 14\",\"A Contracting State shall not be entitled to avail itself of the present Convention against other Contracting States except to the extent that it is itself bound to apply the Convention.\"],\"15\":[\"Article 15\",\"The Secretary-General of the United Nations shall notify the States contemplated in Article VIII of the following:\\u2014\\r\\n(a) signatures and ratifications in accordance with Article VIII;\\r\\n(b) accessions in accordance with Article IX;\\r\\n(c) declarations and notifications under Articles I, X and XI;\\r\\n(d) the date upon which this Convention enters into force in accordance with Article XII;\\r\\n(e) denunciations and notifications in accordance with Article XIII.\\r\\n\"],\"16\":[\"Article 16\",\"1. This Convention, of which the Chinese, English, French, Russian and Spanish texts shall be equally authentic, shall be deposited in the archives of the United Nations.\\r\\n2. The Secretary-General of the United Nations shall transmit a certified copy of this Convention to the States contemplated in Article XIII\\r\\n\"]}', 1, '2021-02-01 20:10:05', '2021-02-01 20:14:55'),
(95, 'WldaYt1HUiMQDJw2ChNSKQPeH', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE SECOND SCHEDULE', 'PROTOCOL ON ARBITRATION CLAUSES', '', '', '{\"1\":[\"PROTOCOL ON ARBITRATION CLAUSES 1\",\"1. Each of the Contracting States recognises the validity of an agreement whether relating to existing or future differences between parties subject respectively to the jurisdiction of different Contracting States by which the parties to a contract agree to submit to arbitration all or any differences that may arise in connection with such contract relating to commercial matters or to any other matter capable of settlement by arbitration, whether or not the arbitration is to take place in a country to whose jurisdiction none of the parties is subject.\\r\\nEach Contracting State reserves the right to limit the obligation mentioned above to contracts which are considered as commercial under its national law. Any Contracting State which avails itself of this right will notify the Secretary-General of the League of Nations in order that the other Contracting States may be so informed.\\r\\n\"],\"2\":[\"PROTOCOL ON ARBITRATION CLAUSES 2\",\"2. The arbitral procedure, including the constitution of the Arbitral Tribunal, shall be governed by the will of the parties and by the law of the country in whose territory the arbitration takes place.\\r\\nThe Contracting States agree to facilitate all steps in the procedure which require to be taken in their own territories, in accordance with the provisions of their law governing arbitral procedure applicable to existing differences.\\r\\n\"],\"3\":[\"PROTOCOL ON ARBITRATION CLAUSES 3\",\"3. Each Contracting State undertakes to ensure the execution by its authorities and in accordance with the provisions of its national laws of arbitral awards made in its own territory under the preceding Articles.\"],\"4\":[\"PROTOCOL ON ARBITRATION CLAUSES 4\\r\\n\",\"4. The Tribunals of the Contracting Parties, on being seized of a dispute regarding a contract made between persons to whom Article 1 applies and including an Arbitration Agreement whether referring to present or future differences which is valid in virtue of the said Article and capable of being carried into effect, shall refer the parties on the application of either of them to the decision of the Arbitrators.\\r\\nSuch reference shall not prejudice the competence of the judicial tribunals in case the agreement or the arbitration cannot proceed or becomes inoperative.\\r\\n\"],\"5\":[\"PROTOCOL ON ARBITRATION CLAUSES 5\",\"5. The present Protocol, which shall remain open for signature by all States, shall be ratified. The ratification shall be deposited as soon as possible with the Secretary-General of the League of Nations, who shall notify such deposit to all the Signatory States.\"],\"6\":[\"PROTOCOL ON ARBITRATION CLAUSES 6\",\"6. The present Protocol will come into force as soon as two ratifications have been deposited. Thereafter it will take effect, in the case of each Contracting State, one month after the notification by the Secretary-General of the deposit of its ratification\"],\"7\":[\"PROTOCOL ON ARBITRATION CLAUSES 7\",\"7. The present Protocol may be denounced by any Contracting State on giving one year\'s notice. Denunciation shall be effected by a notification addressed to the Secretary-General of the League of Nations, who will immediately transmit copies of such notification to all the other Signatory States and inform them of the date on which it was received. The denunciation shall take effect one year after the date on which it was notified to the Secretary-General, and shall operate only in respect of the notifying State.\"],\"8\":[\"PROTOCOL ON ARBITRATION CLAUSES 8\",\"8. The Contracting States may declare that their acceptance of the present Protocol does not include any or all of the undermentioned territories: that is to say, their colonies, overseas possessions or territories, protectorates or the territories over which they exercise a mandate.\\r\\nThe said States may subsequently adhere separately on behalf of any territory thus excluded. The Secretary-General of the League of Nations shall be informed as soon as possible of such adhesions. He shall notify such adhesions to all Signatory States. They will take effect one month after the notification by the Secretary-General to all Signatory States\\r\\nThe Contracting States may also denounce the Protocol separately on behalf of any of the territories referred to above. Article 7 applies to such denunciation.\\r\\n\"]}', 1, '2021-02-01 20:18:08', '2021-02-01 20:18:50'),
(96, 't8i3GUot4WwCivJdsj4LloZx0', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE THIRD SCHEDULE', 'CONVENTION ON THE EXECUTION OF FOREIGN ARBITRAL AWARDS', '', '', '{\"1\":[\"Article 1\",\"(1) In the territories of any High Contracting Party to which the present Convention applies, an arbitral award made in pursuance of an agreement whether relating to existing or future differences (hereinafter called \\u201ca submission to arbitration\\u201d) covered by the Protocol on Arbitration Clauses opened at Geneva on September 24th, 1923, shall be recognised as binding and shall be enforced in accordance with the rules of the procedure of the territory where the award is relied upon, provided that the said award has been made in a territory of one of the High Contracting Parties to which the present Convention applies and between persons who are subject to the jurisdiction of one of the High Contracting Parties.\\r\\n(2) To obtain such recognition or enforcement, it shall, further, be necessary:\\u2014\\r\\n(a) that the award has been made in pursuance of a submission to arbitration which is valid under the law applicable thereto;\\r\\n(b) that the subject-matter of the award is capable of settlement by arbitration under the law of the country in which the award is sought to be relied upon;\\r\\n(c) that the award has been made by the Arbitral Tribunal provided for in the submission to arbitration or constituted in the manner agreed upon by the parties and in conformity with the law governing the arbitration procedure;\\r\\n(d) that the award has become final in the country in which it has been made, in the sense that it will not be considered as such if it is open to opposition, appeal or pourvoi en cassation (in the countries where such forms of procedure exist) or if it is proved that any proceedings for the purpose of contesting the validity of the award are pending;\\r\\n(e) that the recognition or enforcement of the award is not contrary to the public policy or to the principles of the law of the country in which it is sought to be relied upon\\r\\n\"],\"2\":[\"Article 2\",\"Even if the conditions laid down in Article 1 hereof are fulfilled, recognition and enforcement of the award shall be refused if the Court is satisfied:\\u2014\\r\\n(a) that the award has been annulled in the country in which it was made;\\r\\n(b) that the party against whom it is sought to use the award was not given notice of the arbitration proceedings in sufficient time to enable him to present his case; or that, being under a legal incapacity, he was not properly represented;\\r\\n(c) that the award does not deal with the differences contemplated by or falling within the terms of the submission to arbitration or that it contains decisions on matters beyond the scope of the submission to arbitration.\\r\\nIf the award has not covered all the questions submitted to the arbitral tribunal, the competent authority of the country where recognition or enforcement of the award is sought can, if it thinks fit, postpone such recognition or enforcement or grant it subject to such guarantee as that authority may decide.\\r\\n\"],\"3\":[\"Article 3\",\"If the party against whom the award has been made proves that, under the law governing the arbitration procedure, there is a ground, other than the grounds referred to in Article 1(a) and (c), and Article 2(b) and (c), entitling him to contest the validity of the award in a Court of Law, the Court may, if it thinks fit, either refuse recognition or enforcement of the award or adjourn the consideration thereof, giving such party a reasonable time within which to have the award annulled by the competent tribunal.\"],\"4\":[\"Article 4\",\"The party relying upon an award or claiming its enforcement must supply, in particular:\\u2014\\r\\n(1) the original award or a copy thereof duly authenticated, according to the requirements of the law of the country in which it was made;\\r\\n(2) documentary or other evidence to prove that the award has become final, in the sense defined in Article 1(d), in the country in which it was made;\\r\\n(3) when necessary, documentary or other evidence to prove that the conditions laid down in Article 1, paragraph (1) and paragraph (2)(a) and (c), have been fulfilled.\\r\\nA translation of the award and of the other documents mentioned in this Article into the official language of the country where the award is sought to be relied upon may be demanded. Such translations must be certified correct by a diplomatic or consular agent of the country to which the party who seeks to rely upon the award belongs or by a sworn translator of the country where the award is sought to be relied upon.\\r\\n\"],\"5\":[\"Article 5\",\"The provisions of the above Articles shall not deprive any interested party of the right of availing himself of an arbitral award in the manner and to the extent allowed by the law or the treaties of the country where such award is sought to be relied upon.\"],\"6\":[\"Article 6\",\"The present Convention applies only to arbitral awards made after the coming into force of the Protocol on Arbitration Clauses opened at Geneva on September 24th, 1923.\"],\"7\":[\"Article 7\",\"The present Convention, which will remain open to the signature of all the signatories of the Protocol of 1923 on Arbitration Clauses, shall be ratified.\\r\\nIt may be ratified only on behalf of those Members of the League of Nations and non-Member States on whose behalf the Protocol of 1923 shall have been ratified.\\r\\nRatification shall be deposited as soon as possible with the Secretary-General of the League of Nations, who will notify such deposit to all the signatories.\\r\\n\"],\"8\":[\"Article 8\",\"The present Convention shall come into force three months after it shall have been ratified on behalf of two High Contracting Parties. Thereafter, it shall take effect, in the case of each High Contracting Party, three months after the deposit of the ratification on its behalf with the Secretary-General of the League of Nations.\"],\"9\":[\"Article 9\",\"The present Convention may be denounced on behalf of any Member of the League or non-Member State. Denunciation shall be notified in writing to the Secretary-General of the League of Nations, who will immediately send a copy thereof, certified to be in conformity with the notifications, to all the other Contracting Parties, at the same time informing them of the date on which he received it.\\r\\nThe denunciation shall come into force only in respect of the High Contracting Party which shall have notified it and one year after such notification shall have reached the Secretary-General of the League of Nations.\\r\\nThe denunciation of the Protocol on Arbitration Clauses shall entail, ipso facto, the denunciation of the present Convention.\\r\\n\"],\"10\":[\"Article 10\",\"The present Convention does not apply to the colonies, protectorates or territories under suzerainty or mandate of any High Contracting Party unless they are specially mentioned.\\r\\nThe application of this Convention to one or more of such colonies, protectorates or territories to which the Protocol on Arbitration Clauses opened at Geneva on September 24th, 1923, applies, can be effected at any time by means of a declaration addressed to the Secretary-General of the League of Nations by one of the High Contracting Parties\\r\\n\"],\"11\":[\"Article 11\",\"A certified copy of the present Convention shall be transmitted by the Secretary-General of the League of Nations to every Member of the League of Nations and to every non-Member State which signs the same.\"]}', 1, '2021-02-01 20:19:55', '2021-02-01 20:24:02'),
(97, 'b3v5Rc6wT3xdzkh1xrNWaZPZm', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE FOURTH SCHEDULE', 'See Section 11', '', '', '{\"1\":[\"THE FOURTH SCHEDULE\",\"Sl. No.\\tSum in dispute\\tModel fee\\r\\n(1)\\t(2)\\t(3)\\r\\n1.\\tUp to Rs 5,00,000\\tRs 45,000\\r\\n2.\\tAbove Rs 5,00,000 and up to Rs 20,00,000\\tRs 45,000 plus 3.5 per cent of the claim amount over and above Rs 5,00,000.\\r\\n3.\\tAbove Rs 20,00,000 and up to Rs 1,00,00,000\\tRs 97,500 plus 3 per cent of the claim amount over and above Rs 20,00,000.\\r\\n4.\\tAbove Rs 1,00,00,000 and up to Rs 10,00,00,000\\tRs 3,37,500 plus 1 per cent. of the claim amount over and above Rs 1,00,00,000.\\r\\n5.\\tAbove Rs 10,00,00,000 and up to Rs 20,00,00,000\\tRs 12,37,500 plus 0.75 per cent of the claim amount over and above Rs 10,00,00,000.\\r\\n6.\\tAbove Rs 20,00,00,000\\tRs 19,87,500 plus 0.5 per cent of the claim amount over and above Rs 20,00,00,000 with a ceiling of Rs 30,00,000.\\r\\nNote: In the event the arbitral tribunal is a sole arbitrator, he shall be entitled to an additional amount of twenty-five per cent on the fee payable as per the above.\\r\\n\"]}', 1, '2021-02-01 20:25:16', '2021-02-01 20:25:39');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(98, 'mJbK55Wuo5otdvm6t2xoLvRXO', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE FIFTH SCHEDULE', 'See Section 12', '', '', '{\"1\":[\"THE FIFTH SCHEDULE\",\"The following grounds give rise to justifiable doubts as to the independence or impartiality of arbitrators:\\r\\nArbitrator\'s relationship with the parties or counsel\\r\\n1. The arbitrator is an employee, consultant, advisor or has any other past or present business relationship with a party.\\r\\n2. The arbitrator currently represents or advises one of the parties or an affiliate of one of the parties.\\r\\n3. The arbitrator currently represents the lawyer or law firm acting as counsel for one of the parties.\\r\\n4. The arbitrator is a lawyer in the same law firm which is representing one of the parties.\\r\\n5. The arbitrator is a manager, director or part of the management, or has a similar controlling influence, in an affiliate of one of the parties if the affiliate is directly involved in the matters in dispute in the arbitration.\\r\\n6. The arbitrator\'s law firm had a previous but terminated involvement in the case without the arbitrator being involved himself or herself.\\r\\n7. The arbitrator\'s law firm currently has a significant commercial relationship with one of the parties or an affiliate of one of the parties.\\r\\n8. The arbitrator regularly advises the appointing party or an affiliate of the appointing party even though neither the arbitrator nor his or her firm derives a significant financial income therefrom.\\r\\n9. The arbitrator has a close family relationship with one of the parties and in the case of companies with the persons in the management and controlling the company.\\r\\n10. A close family member of the arbitrator has a significant financial interest in one of the parties or an affiliate of one of the parties.\\r\\n11. The arbitrator is a legal representative of an entity that is a party in the arbitration.\\r\\n12. The arbitrator is a manager, director or part of the management, or has a similar controlling influence in one of the parties.\\r\\n13. The arbitrator has a significant financial interest in one of the parties or the outcome of the case.\\r\\n14. The arbitrator regularly advises the appointing party or an affiliate of the appointing party, and the arbitrator or his or her firm derives a significant financial income therefrom.\\r\\nRelationship of the arbitrator to the dispute\\r\\n15. The arbitrator has given legal advice or provided an expert opinion on the dispute to a party or an affiliate of one of the parties.\\r\\n16. The arbitrator has previous involvement in the case.\\r\\nArbitrator\'s direct or indirect interest in the dispute\\r\\n17. The arbitrator holds shares, either directly or indirectly, in one of the parties or an affiliate of one of the parties that is privately held.\\r\\n18. A close family member of the arbitrator has a significant financial interest in the outcome of the dispute.\\r\\n19. The arbitrator or a close family member of the arbitrator has a close relationship with a third party who may be liable to recourse on the part of the unsuccessful party in the dispute.\\r\\nPrevious services for one of the parties or other involvement in the case\\r\\n20. The arbitrator has within the past three years served as counsel for one of the parties or an affiliate of one of the parties or has previously advised or been consulted by the party or an affiliate of the party making the appointment in an unrelated matter, but the arbitrator and the party or the affiliate of the party have no ongoing relationship.\\r\\n21. The arbitrator has within the past three years served as counsel against one of the parties or an affiliate of one of the parties in an unrelated matter.\\r\\n22. The arbitrator has within the past three years been appointed as arbitrator on two or more occasions by one of the parties or an affiliate of one of the parties.\\r\\n23. The arbitrator\'s law firm has within the past three years acted for one of the parties or an affiliate of one of the parties in an unrelated matter without the involvement of the arbitrator.\\r\\n24. The arbitrator currently serves, or has served within the past three years, as arbitrator in another arbitration on a related issue involving one of the parties or an affiliate of one of the parties.\\r\\nRelationship between an arbitrator and another arbitrator or counsel\\r\\n25. The arbitrator and another arbitrator are lawyers in the same law firm.\\r\\n26. The arbitrator was within the past three years a partner of, or otherwise affiliated with, another arbitrator or any of the counsel in the same arbitration.\\r\\n27. A lawyer in the arbitrator\'s law firm is an arbitrator in another dispute involving the same party or parties or an affiliate of one of the parties.\\r\\n28. A close family member of the arbitrator is a partner or employee of the law firm representing one of the parties, but is not assisting with the dispute.\\r\\n29. The arbitrator has within the past three years received more than three appointments by the same counsel or the same law firm.\\r\\nRelationship between arbitrator and party and others involved in the arbitration\\r\\n30. The arbitrator\'s law firm is currently acting adverse to one of the parties or an affiliate of one of the parties.\\r\\n31. The arbitrator had been associated within the past three years with a party or an affiliate of one of the parties in a professional capacity, such as a former employee or partner.\\r\\nOther circumstances\\r\\n32. The arbitrator holds shares, either directly or indirectly, which by reason of number or de-nomination constitute a material holding in one of the parties or an affiliate of one of the parties that is publicly listed.\\r\\n33. The arbitrator holds a position in an arbitration institution with appointing authority over the dispute.\\r\\n34. The arbitrator is a manager, director or part of the management, or has a similar controlling influence, in an affiliate of one of the parties, where the affiliate is not directly involved in the matters in dispute in the arbitration\\r\\n\"]}', 1, '2021-02-01 20:27:05', '2021-02-01 20:27:05'),
(99, 'DKZruDMMcNxrKlnL4MPROTsYG', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE SIXTH SCHEDULE', 'See Section 12 (1)(b)', '', '', '{\"1\":[\"THE SIXTH SCHEDULE\",\"Name:\\r\\nContact Details:\\r\\nPrior Experience (Including Experience with Arbitrations):\\r\\nNumber of ongoing arbitrations:\\r\\nCircumstances disclosing any past or present relationship with or interest in any of the parties or in relation to the subject matter in dispute, whether financial, business, professional or other kind, which is likely to give rise to justifiable doubts as to your independence or impartiality (list out):\\r\\nCircumstances which are likely to affect your ability to devote sufficient time to the arbitration and in particular your ability to finish the entire arbitration within twelve months (list out)\\r\\n\"]}', 1, '2021-02-01 20:29:03', '2021-02-01 20:29:03'),
(100, 'PMQJA2u17Cs5Uf57QC7FH8q9H', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE SEVENTH SCHEDULE', 'See Section 12(5)', '', '', '{\"1\":[\"THE SEVENTH SCHEDULE\",\"Arbitrator\'s relationship with the parties or counsel\\r\\n1. The arbitrator is an employee, consultant, advisor or has any other past or present business relationship with a party.\\r\\n2. The arbitrator currently represents or advises one of the parties or an affiliate of one of the parties.\\r\\n3. The arbitrator currently represents the lawyer or law firm acting as counsel for one of the parties.\\r\\n4. The arbitrator is a lawyer in the same law firm which is representing one of the parties.\\r\\n5. The arbitrator is a manager, director or part of the management, or has a similar controlling influence, in an affiliate of one of the parties if the affiliate is directly involved in the matters in dispute in the arbitration.\\r\\n6. The arbitrator\'s law firm had a previous but terminated involvement in the case without the arbitrator being involved himself or herself.\\r\\n7. The arbitrator\'s law firm currently has a significant commercial relationship with one of the parties or an affiliate of one of the parties.\\r\\n8. The arbitrator regularly advises the appointing party or an affiliate of the appointing party even though neither the arbitrator nor his or her firm derives a significant financial income therefrom.\\r\\n9. The arbitrator has a close family relationship with one of the parties and in the case of companies with the persons in the management and controlling the company.\\r\\n10. A close family member of the arbitrator has a significant financial interest in one of the parties or an affiliate of one of the parties.\\r\\n11. The arbitrator is a legal representative of an entity that is a party in the arbitration.\\r\\n12. The arbitrator is a manager, director or part of the management, or has a similar controlling influence in one of the parties.\\r\\n13. The arbitrator has a significant financial interest in one of the parties or the outcome of the case.\\r\\n14. The arbitrator regularly advises the appointing party or an affiliate of the appointing party, and the arbitrator or his or her firm derives a significant financial income therefrom.\\r\\nRelationship of the arbitrator to the dispute\\r\\n15. The arbitrator has given legal advice or provided an expert opinion on the dispute to a party or an affiliate of one of the parties.\\r\\n16. The arbitrator has previous involvement in the case.\\r\\nArbitrator\'s direct or indirect interest in the dispute\\r\\n17. The arbitrator holds shares, either directly or indirectly, in one of the parties or an affiliate of one of the parties that is privately held.\\r\\n18. A close family member of the arbitrator has a significant financial interest in the outcome of the dispute.\\r\\n19. The arbitrator or a close family member of the arbitrator has a close relationship with a third party who may be liable to recourse on the part of the unsuccessful party in the dispute.\\r\\n\"]}', 1, '2021-02-01 20:30:11', '2021-02-01 20:30:11'),
(101, 'lQRKDL4tuzmUt7TN4WH1kd10h', 'I1sLydS6hxk9n5H9lbJwICx5T', 'THE EIGHTH SCHEDULE', 'See Section 43-J', '', '', '{\"1\":[\"THE EIGHTH SCHEDULE\",\"Qualifications and Experience of Arbitrator\\r\\nA person shall not be qualified to be an arbitrator unless he\\u2014\\r\\n(i) is an advocate within the meaning of the Advocates Act, 1961 (25 of 1961) having ten years of practice experience as an advocate; or\\r\\n(ii) is a chartered accountant within the meaning of the Chartered Accountants Act, 1949 (38 of 1949) having ten years of practice experience as a chartered accountant; or\\r\\n(iii) is a cost accountant within the meaning of the Cost and Works Accountants Act, 1959 (23 of 1959) having ten years of practice experience as a cost accountant; or\\r\\n(iv) is a company secretary within the meaning of the Company Secretaries Act, 1980 (56 of 1980) having ten years of practice experience as a company secretary; or\\r\\n(v) has been an officer of the Indian Legal Service; or\\r\\n(vi) has been an officer with law degree having ten years of experience in the legal matters in the Government, Autonomous Body, Public Sector Undertaking or at a senior level managerial position in private sector; or\\r\\n(vii) has been an officer with engineering degree having ten years of experience as an engineer in the Government, Autonomous Body, Public Sector Undertaking or at a senior level managerial position in private sector or self-employed; or\\r\\n(viii) has been an officer having senior level experience of administration in the Central Government or State Government or having experience of senior level management of a Public Sector Undertaking or a Government company or a private company of repute;\\r\\n(ix) is a person, in any other case, having educational qualification at degree level with ten years of experience in scientific or technical stream in the fields of telecom, information technology, Intellectual Property Rights or other specialised areas in the Government, Autonomous Body, Public Sector Undertaking or a senior level managerial position in a private sector, as the case may be.\\r\\nGeneral norms applicable to Arbitrator\\r\\n(i) The arbitrator shall be a person of general reputation of fairness, integrity and capable to apply objectivity in arriving at settlement of disputes;\\r\\n(ii) the arbitrator must be impartial and neutral and avoid entering into any financial business or other relationship that is likely to affect impartiality or might reasonably create an appearance of partiality or bias amongst the parties;\\r\\n(iii) the arbitrator should not involve in any legal proceeding and avoid any potential conflict connected with any dispute to be arbitrated by him;\\r\\n(iv) the arbitrator should not have been convicted of an offence involving moral turpitude or economic offence;\\r\\n(v) the arbitrator shall be conversant with the Constitution of India, principles of natural justice, equity, common and customary laws, commercial laws, labour laws, law of torts, making and enforcing the arbitral awards;\\r\\n(vi) the arbitrator should possess robust understanding of the domestic and international legal system on arbitration and international best practices in regard thereto;\\r\\n(vii) the arbitrator should be able to understand key elements of contractual obligations in civil and commercial disputes and be able to apply legal principles to a situation under dispute and also to apply judicial decisions on a given matter relating to arbitration; and\\r\\n(viii) the arbitrator should be capable of suggesting, recommending or writing a reasoned and enforceable arbitral award in any dispute which comes before him for adjudication\\r\\n\"]}', 1, '2021-02-01 20:31:15', '2021-02-01 20:31:15'),
(102, 'cEwbcqoUgt880bnYLUemzpqPL', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 1', 'PRELIMINARY', '', '', '{\"1\":[\"1. Short title, local extent, saving of usages relating to hundis, etc., commencement\",\"This Act may be called the Negotiable Instruments Act, 1881. It extends to the whole of India but nothing herein contained affects the Indian Paper Currency Act, 1871 II of 1871, Section 21, or affects any local usages relating to any instrument in an oriental language: Provided that such usages may be excluded by any words in the body of the instrument which indicate an intention that the legal relations of the parties thereto shall be governed by this Act, and it shall come into force on the first day of March, 1882.\"],\"2\":[\"2. Repeal of enactments\",\"[* * *]\"],\"3\":[\"3. Interpretation clause\",\"[* * *]\"]}', 1, '2021-02-02 00:20:46', '2021-02-02 00:20:46'),
(103, '5FSRpIa6MxPJqFKKM0lGgLnQj', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 2', 'NOTES, BILLS AND CHEQUES', '', '', '{\"1\":[\"4. Promissory note\",\"A \\u201cpromissory note\\u201d is an instrument in writing (not being a bank-note or a currency-note) containing an unconditional undertaking, signed by the maker, to pay a certain sum of money only to, or to the order of, a certain person, or to the bearer of the instrument.\"],\"2\":[\"5. Bill of exchange\",\"A \\u201cbill of exchange\\u201d is an instrument in writing containing an unconditional order, signed by the maker, directing a certain person to pay a certain sum of money only to, or to the order of a certain person or to the bearer of the instrument.\\r\\nA promise or order to pay is not \\u201cconditional\\u201d within the meaning of this section and Section 4, by reason of time for payment of the amount or any instalment thereof being expressed to be on the lapse of a certain period after the occurrence of a specified event which, according to the ordinary expectation of mankind, is certain to happen, although the time of its happening may be uncertain.\\r\\nThe sum payable may be \\u201ccertain\\u201d, within the meaning of this section and Section 4, although it includes future interest or is payable at an indicated rate of exchange, or is according to the course of exchange, and although the instrument provides that on default of payment of an instalment, the balance unpaid shall become due.\\r\\nThe person to whom it is clear that the direction is given or that payment is to be made, be a \\u201ccertain person\\u201d, within the meaning of this section and Section 4, although he is mis-named or designated by description only.\\r\\n\"],\"3\":[\"6. Cheque\",\"A \\u201ccheque\\u201d is a bill of exchange drawn on a specified banker and not expressed to be payable otherwise than on demand and it includes the electronic image of a truncated cheque and a cheque in the electronic form.\"],\"4\":[\"7. Drawer, Drawee\",\"The maker of a bill of exchange or cheque is called the \\u201cdrawer\\u201d; the person thereby directed to pay is called the \\u201cdrawee\\u201d.\\r\\n\\u201cDrawee in case of need\\u201d.\\u2014When in the bill or in any endorsement thereon the name of any person is given in addition to the drawee to be resorted to in case of need, such person is called a \\u201cdrawee in case of need\\u201d.\\r\\n\\u201cAcceptor\\u201d.\\u2014After the drawee of a bill has signed his assent upon the bill, or, if there are more parts thereof than one, upon one of such parts, and delivered the same, or given notice of such signing to the holder or to some person on his behalf, he is called the \\u201cacceptor\\u201d.\\r\\n\\u201cAcceptor for honour\\u201d.\\u2014 When a bill of exchange has been noted or protested for non-acceptance or for better security, and any person accepts it supra protest for honour of the drawee or any one of the endorsers, such person is called an \\u201cacceptor for honour\\u201d.\\r\\n\\u201cPayee\\u201d.\\u2014The person named in the instrument, to whom or to whose order the money is by the instrument directed to be paid, is called the \\u201cpayee\\u201d.\\r\\n\"],\"5\":[\"8. Holder\",\"The \\u201cholder\\u201d of a promissory note, bill of exchange or cheque means any person entitled in his own name to the possession thereof and to receive or recover the amount due thereon from the parties thereto\\r\\nWhere the note, bill or cheque is lost or destroyed, its holder is the person so entitled at the time of such loss or destruction.\"],\"6\":[\"9. Holder in due course\",\"Holder in due course\\u201d means any person who for consideration became the possessor of a promissory note, bill of exchange or cheque if payable to bearer, or the payee or indorsee thereof, if 13[payable to order], before the amount mentioned in it became payable and without having sufficient cause to believe that any defect existed in the title of the person from whom he derived his title.\"],\"7\":[\"10. Payment in due course\",\"10. \\u201cPayment in due course\\u201d.\\u2014\\u201cPayment in due course\\u201d means payment in accordance with the apparent tenor of the instrument in good faith and without negligence to any person in possession thereof under circumstances which do not afford a reasonable ground for believing that he is not entitled to receive payment of the amount therein mentioned\"],\"8\":[\"11. Inland instrument\",\"A promissory note, bill of exchange or cheque drawn or made in India and made payable in, or drawn upon any person resident in India shall be deemed to be an inland instrument.\"],\"9\":[\"12. Foreign instrument\",\"Any such instrument not so drawn, made, or made payable shall be deemed to be a foreign instrument.\"],\"10\":[\"13. Negotiable instrument\",\"(1) A \\u201cnegotiable instrument\\u201d means a promissory note, bill of exchange or cheque payable either to order or to bearer.\\r\\n (2) A negotiable instrument may be payable to two or more payees jointly, or it may be made payable in the alternative to one of two, or one or some of several payees\\r\\n\"],\"11\":[\"14. Negotiation\",\"When a promissory note, bill of exchange or cheque is transferred to any person, so as to constitute that person the holder thereof, the instrument is said to be negotiated.\"],\"12\":[\"15. Indorsement\",\"When the maker or holder of a negotiable instrument signs the same, otherwise than as such maker, for the purpose of negotiation, on the back or face thereof or on a slip of paper annexed thereto, or so signs for the same purpose a stamped paper intended to be completed as a negotiable instrument, he is said to indorse the same, and is called the \\u201cindorser\\u201d.\"],\"13\":[\"16. Indorsement in blank and in full Indorsee\",\"(1) If the indorser signs his name only, the indorsement is said to be \\u201cin blank\\u201d, and if he adds a direction to pay the amount mentioned in the instrument to, or the order of, a specified person, the indorsement is said to be \\u201cin full\\u201d, and the person so specified is called the \\u201cindorsee\\u201d of the instrument.\\r\\n (2) The provisions of this Act relating to a payee shall apply with the necessary modifications to an indorsee\\r\\n\"],\"14\":[\"17. Ambiguous instruments\",\"Where an instrument may be construed either as a promissory note or bill of exchange, the holder may at his election treat it as either, and the instrument shall be thenceforward treated accordingly.\"],\"15\":[\"18. Where amount is stated differently in figures and words.\",\"If the amount undertaken or ordered to be paid is stated differently in figures and in words, the amount stated in words shall be the amount undertaken or ordered to be paid.\"],\"16\":[\"19. Instrument payable on demand\",\"A promissory note or bill of exchange, in which no time for payment is specified, and a cheque, are payable on demand.\"],\"17\":[\"20. Inchoate stamped instruments\",\"Where one person signs and delivers to another a paper stamped in accordance with the law relating to negotiable instruments then in force in 20[India] and either wholly blank or having written thereon an incomplete negotiable instrument, he thereby gives prima facie authority to the holder thereof to make or complete, as the case may be, upon it a negotiable instrument, for any amount specified therein and not exceeding the amount covered by the stamp. The person so signing shall be liable upon such instrument, in the capacity in which he signed the same, to any holder in due course for such amount:\\r\\nProvided that no person other than a holder in due course shall recover from the person delivering the instrument anything in excess of the amount intended by him to be paid thereunder.\\r\\n\"],\"18\":[\"21. At sight, On presentment , After sight\",\"In a promissory note or bill of exchange the expressions \\u201cat sight\\u201d and \\u201con presentment\\u201d mean on demand. The expression \\u201cafter sight\\u201d means, in a promissory note, after presentment for sight, and, in a bill of exchange, after acceptance, or noting for non-acceptance, or protest for non-acceptance.\"],\"19\":[\"22. Maturity\",\"The maturity of a promissory note or bill of exchange is the date at which it falls due.\\r\\nDays of grace.\\u2014Every promissory note or bill of exchange which is not expressed to be payable on demand, at sight or on presentment is at maturity on the third day after the day on which it is expressed to be payable.\\r\\n\"],\"20\":[\"23. Calculating maturity of bill or note payable so many months after date or sight\",\"In calculating the date at which a promissory note or bill of exchange, made payable a stated number of months after date or after sight, or after a certain event, is at maturity, the period stated shall be held to terminate on the day of the month which corresponds with the day on which the instrument is dated, or presented for acceptance or sight, or noted for non-acceptance, or protested for non-acceptance, or the event happens, or, where the instrument is a bill of exchange, made payable a stated number of months after sight and has been accepted for honour, with the day on which it was so accepted. If the month in which the period would terminate has no corresponding day, the period shall be held to terminate on the last day of such month.\"],\"21\":[\"24. Calculating maturity of bill or note payable so many days after date or sight\",\"In calculating the date at which a promissory note or bill of exchange made payable a certain number of days after date or after sight or after a certain event is at maturity, the day of the date, or of presentment for acceptance or sight, or of protest for non-acceptance, or on which the event happens shall be excluded.\"],\"22\":[\"25. When day of maturity is a holiday\",\"When the day on which a promissory note or bill of exchange is at maturity is a public holiday, the instrument shall be deemed to be due on the next preceding business day.\"]}', 1, '2021-02-02 00:28:19', '2021-02-02 01:01:42'),
(104, 'DSWRIHR4xIrxfsuvOL0qVFmPI', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 3', 'PARTIES TO NOTES, BILLS AND CHEQUES', '', '', '{\"1\":[\"26. Capacity to make, etc., promissory notes etc\",\"Every person capable of contracting, according to the law to which he is subject, may bind himself and be bound by the making, drawing, acceptance, indorsement, delivery and negotiation of a promissory note, bill of exchange or cheque.\\r\\nMinor.\\u2014A minor may draw, indorse, deliver and negotiate such instruments so as to bind all parties except himself.\\r\\nNothing herein contained shall be deemed to empower a corporation to make, indorse or accept such instruments except in cases in which, under the law for the time being in force, they are so empowered.\\r\\n\"],\"2\":[\"27. Agency\",\"Every person capable of binding himself or of being bound, as mentioned in Section 26, may so bind himself or be bound by a duly authorised agent acting in his name.\\r\\nA general authority to transact business and to receive and discharge debts does not confer upon an agent the power of accepting or indorsing bills of exchange so as to bind his principal.\\r\\nAn authority to draw bills of exchange does not of itself import an authority to indorse\\r\\n\"],\"3\":[\"28. Liability of agent signing\",\"An agent who signs his name to a promissory note, bill of exchange or cheque without indicating thereon that he signs as agent, or that he does not intend thereby to incur personal responsibility, is liable personally on the instrument, except to those who induced him to sign upon the belief that the principal only would be held liable\"],\"4\":[\"29. Liability of legal representative signing\",\"A legal representative of a deceased person who signs his name to a promissory note, bill of exchange or cheque is liable personally thereon unless he expressly limits his liability to the extent of the assets received by him as such.\"],\"5\":[\"30. Liability of drawer\",\"The drawer of a bill of exchange or cheque is bound, in case of dishonour by the drawee or acceptor thereof, to compensate the holder, provided due notice of dishonour has been given to, or received by, the drawer as hereinafter provided\"],\"6\":[\"31. Liability of drawee of cheque\",\"The drawee of a cheque having sufficient funds of the drawer in his hands properly applicable to the payment of such cheque must pay the cheque when duly required so to do, and, in default of such payment, must compensate the drawer for any loss or damage caused by such default.\"],\"7\":[\"32. Liability of maker of note and acceptor of bill\",\"In the absence of a contract to the contrary, the maker of a promissory note and the acceptor before maturity of a bill of exchange are bound to pay the amount thereof at maturity according to the apparent tenor of the note or acceptance respectively, and the acceptor of a bill of exchange at or after maturity is bound to pay the amount thereof to the holder on demand.\\r\\nIn default of such payment as aforesaid, such maker or acceptor is bound to compensate any party to the note or bill for any loss or damage sustained by him and caused by such default.\\r\\n\"],\"8\":[\"33. Only drawee can be acceptor except in need or for honour\",\"No person except the drawee of a bill of exchange, or all or some of several drawees, or a person named therein as a drawee in case of need, or an acceptor for honour, can bind himself by an acceptance.\"],\"9\":[\"34. Acceptance by several drawees not partners\",\"Where there are several drawees of a bill of exchange who are not partners, each of them can accept it for himself, but none of them can accept it for another without his authority.\"],\"10\":[\"35. Liability of indorser\",\"In the absence of a contract to the contrary, whoever indorses and delivers a negotiable instrument before maturity, without, in such indorsement, expressly excluding or making conditional his own liability, is bound thereby to every subsequent holder, in case of dishonour by the drawee, acceptor or maker, to compensate such holder for any loss or damage caused to him by such dishonour, provided due notice of dishonour has been given to, or received by, such indorser as hereinafter provided.\\r\\nEvery indorser after dishonour is liable as upon an instrument payable on demand\\r\\n\"],\"11\":[\"36. Liability of prior parties to holder in due course\",\"Every prior party to a negotiable instrument is liable thereon to a holder in due course until the instrument is duly satisfied.\"],\"12\":[\"37. Maker, drawer and acceptor principals\",\"The maker of a promissory note or cheque, the drawer of a bill of exchange until acceptance, and the acceptor are, in the absence of a contract to the contrary, respectively liable thereon as principal debtors, and the other parties thereto are liable thereon as sureties for the maker, drawer or acceptor, as the case may be.\"],\"13\":[\"38. Prior party a principal in respect of each subsequent party\",\"As between the parties so liable as sureties, each prior party is, in the absence of a contract to the contrary, also liable thereon as a principal debtor in respect of each subsequent party.\"],\"14\":[\"39. Suretyship\",\"When the holder of an accepted bill of exchange enters into any contract with the acceptor which, under Section 134 or 135 of the Indian Contract Act, 1872 (IX of 1872), would discharge the other parties, the holder may expressly reserve his right to charge the other parties, and in such case they are not discharged.\"],\"15\":[\"40. Discharge of indorser\'s liability\",\"Where the holder of a negotiable instrument, without the consent of the indorser, destroys or impairs the indorser\'s remedy against a prior party, the indorser is discharged from liability to the holder to the same extent as if the instrument had been paid at maturity.\"],\"16\":[\"41. Acceptor bound, although indorsement forged\",\"An acceptor of a bill of exchange already indorsed is not relieved from liability by reason that such indorsement is forged, if he knew or had reason to believe the indorsement to be forged when he accepted the bill.\"],\"17\":[\"42. Acceptance of bill drawn in fictitious name\",\"An acceptor of a bill of exchange drawn in a fictitious name and payable to the drawer\'s order is not, by reason that such name is fictitious, relieved from liability to any holder in due course claiming under an indorsement by the same hand as the drawer\'s signature, and purporting to be made by the drawer.\"],\"18\":[\"43. Negotiable instrument made, etc., without consideration\",\"A negotiable instrument made, drawn, accepted, indorsed, or transferred without consideration, or for a consideration, which fails, create no obligation of payment between the parties to the transaction. But if any such party has transferred the instrument with or without endorsement to a holder for consideration, such holder, and every subsequent holder deriving title from him may recover the amount due on such instrument from the transferor for consideration or any prior party thereto\"],\"19\":[\"44. Partial absence or failure of money-consideration\",\"When the consideration for which a person signed a promissory note, bill of exchange or cheque consisted of money, and was originally absent in part or has subsequently failed in part, the sum which a holder standing in immediate relation with such signer is entitled to receive from him is proportionally reduced.\"],\"20\":[\"45. Partial failure of consideration not consisting of money\",\"Where a part of the consideration for which a person signed a promissory note, bill of exchange or cheque, though not consisting of money, is ascertainable in money without collateral enquiry, and there has been a failure of that part, the sum which a holder standing in immediate relation with such signer is entitled to receive from him is proportionally reduced.\"],\"21\":[\" 45-A. Holder\'s right to duplicate of lost bill\",\"Where a bill of exchange has been lost before it is over-due, the person who was the holder of it may apply to the drawer to give him another bill of the same tenor, giving security to the drawer, if required, to indemnify him against all persons whatever in case the bill alleged to have been lost shall be found again.\"]}', 1, '2021-02-02 01:02:29', '2021-02-02 01:09:11'),
(105, 'eEqYP8II1kkg1IudsGsk8k3Zv', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 4', 'NEGOTIATION', '', '', '{\"1\":[\"46. Delivery\",\"The making, acceptance or indorsement of a promissory note, bill of exchange or cheque is completed by delivery, actual or constructive.\\r\\nAs between parties standing in immediate relation delivery to be effectual must be made by the party making, accepting or indorsing the instrument, or by a person authorised by him in that behalf.\\r\\nAs between such parties and any holder of the instrument other than a holder in due course, it may be shown that the instrument was delivered conditionally or for special purpose only, and not for the purpose of transferring absolutely the property therein.\\r\\nA promissory note, bill of exchange or cheque payable to bearer is negotiable by the delivery thereof.\\r\\nA promissory note, bill of exchange or cheque payable to order is negotiable by the holder by indorsement and delivery thereof\\r\\n\"],\"2\":[\"47. Negotiation by delivery\",\"Subject to the provisions of Section 58, a promissory note, bill of exchange or cheque payable to bearer is negotiable by delivery thereof.\"],\"3\":[\"48. Negotiation by indorsement\",\"Subject to the provisions of Section 58 a promissory note, bill of exchange or cheque payable to order is negotiable by the holder by indorsement and delivery thereof.\"],\"4\":[\"49. Conversion of indorsement in blank into indorsement in full\",\"The holder of negotiable instrument indorsed in blank may without signing his own name, by writing above the indorser\'s signature a direction to pay any other person as indorsee, convert the indorsement in blank into an indorsement in full; and the holder does not thereby incur the responsibility of an indorser.\"],\"5\":[\"50. Effect of indorsement\",\"The indorsement of a negotiable instrument followed by delivery transfers to the indorsee the property therein with right of further negotiation; but the indorsement may, by express words, restrict or include such right, or may merely constitute the indorsee an agent to indorse the instrument or to receive its contents for the indorser, or for some other specified person.\"],\"6\":[\"51. Who may negotiate\",\"Every sole maker, drawer, payee or indorsee, or all of several joint makers, drawers, payees or indorsees, of a negotiable instrument may, if the negotiability of such instrument has not been restricted or excluded as mentioned in Section 50, indorse and negotiate the same.\"],\"7\":[\"52. Indorser who excludes his own liability or makes it conditional\",\"The indorser of a negotiable instrument may, by express words in the indorsement, exclude his own liability thereon or make such liability or the right of the indorsee to receive the amount due thereon depend upon the happening of a specified event, although such event may never happen.\\r\\nWhere an indorser so excludes his liability and afterwards becomes the holder of the instrument, all intermediate indorsers are liable to him.\\r\\n\"],\"8\":[\"53. Holder deriving title from holder in due course\",\"A holder of a negotiable instrument who derives title from a holder in due course has the rights thereon of that holder in due course\"],\"9\":[\"54. Instrument indorsed in blank\",\"Subject to the provisions hereinafter contained as to crossed cheques, a negotiable instrument indorsed in blank is payable to the bearer thereof even although originally payable to order.\"],\"10\":[\"55. Conversion of indorsement in blank into indorsement in full\",\"If a negotiable instrument, after having been indorsed in blank, is indorsed in full, the amount of it cannot be claimed from the indorser in full, except by the person to whom it has been indorsed in full, or by one who derives title through such person.\"],\"11\":[\"56. Indorsement for part of sum due\",\"No writing on a negotiable instrument is valid for the purpose of negotiation if such writing purports to transfer only a part of the amount appearing to be due on the instrument; but where such amount has been partly paid, a note to that effect may be indorsed on the instrument, which may then be negotiated for the balance.\"],\"12\":[\"57. Legal representative cannot, by delivery only, negotiate instrument indorsed by deceased\",\"The legal representative of a deceased person cannot negotiate by delivery only, a promissory note, bill of exchange or cheque payable to order and indorsed by the deceased but not delivered.\"],\"13\":[\"58. Instrument obtained by unlawful means or for unlawful consideration\",\"When a negotiable instrument has been lost, or, has been obtained from any maker, acceptor or holder thereof by means of an offence of fraud, or for an unlawful consideration, no possessor or indorsee who claims through the person who found or so obtained the instrument is entitled to receive the amount due thereon from such maker, acceptor or holder, or from any party prior to such holder, unless such possessor or indorsee is, or some person through whom he claims was, a holder thereof in due course.\"],\"14\":[\"59. Instrument acquired after dishonour or when overdue\",\"The holder of a negotiable instrument, who has acquired it after dishonour, whether by non-acceptance or non-payment, with notice thereof, or after maturity, has only, as against the other parties, the right thereon of his transferor.\\r\\nAccommodation note or bill.\\u2014Provided that any person who, in good faith and for consideration, becomes the holder, after maturity, of a promissory note or bill of exchange made, drawn or accepted without consideration, for the purpose of enabling some party thereto to raise money thereon may recover the amount of the note or bill from any prior party.\\r\\n\"],\"15\":[\"60. Instrument negotiable till payment or satisfaction\",\"A negotiable instrument may be negotiated (except by the maker, drawee or acceptor after maturity) until payment or satisfaction thereof by the maker, drawee or acceptor at or after maturity, but not after such payment or satisfaction.\"]}', 1, '2021-02-02 01:09:52', '2021-02-02 01:21:32'),
(106, 'RRi4vvwS6v7VLw6bolNzAPN88', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 5', 'PRESENTMENT', '', '', '{\"1\":[\"61. Presentment for acceptance\",\"A bill of exchange payable after sight must, if no time or place is specified therein for presentment, be presented to the drawee thereof for acceptance, if he can, after reasonable search, be found, by a person entitled to demand acceptance, within a reasonable time after it is drawn, and in business hours on a business day. In default of such presentment, no party thereto is liable thereon to the person making such default.\\r\\nIf the drawee cannot, after reasonable search, be found, the bill is dishonoured.\\r\\nIf the bill is directed to the drawee at a particular place, it must be presented at that place; and if at the due date for presentment he cannot, after reasonable search, be found there, the bill is dishonoured.\\r\\n\"],\"2\":[\"62. Presentment of promissory note for sight\",\"A promissory note, payable at a certain period after sight, must be presented to the maker thereof for sight (if he can after reasonable search be found) by a person entitled to demand payment within a reasonable time after it is made and in business hours on a business day. In default of such presentment, no party thereto is liable thereon to the person making such default.\"],\"3\":[\"63. Drawee\'s time for deliberation\",\"The holder must, if so required by the drawee of a bill of exchange presented to him for acceptance, allow the drawee forty-eight hours (exclusive of public holidays) to consider whether he will accept it.\"],\"4\":[\"64. Presentment for payment\",\"(1) Promissory notes, bills of exchange and cheques must be presented for payment to the maker, acceptor or drawee thereof respectively, by or on behalf of the holder as hereinafter provided. In default of such presentment, the other parties thereto are not liable thereon to such holder.\\r\\n (2) Notwithstanding anything contained in Section 6, where an electronic image of a truncated cheque is presented for payment, the drawee bank is entitled to demand any further information regarding the truncated cheque from the bank holding the truncated cheque in case of any reasonable suspicion about the genuineness of the apparent tenor of instrument, and if the suspicion is that of any fraud, forgery, tampering or destruction of the instrument, it is entitled to further demand the presentment of the truncated cheque itself for verification:\\r\\n\"],\"5\":[\"65. Hours for presentment\",\"Presentment for payment must be made during the usual hours of business, and, if at a banker\'s, within banking hours\"],\"6\":[\"66. Presentment for payment of instrument payable after date or sight\",\"A promissory note or bill of exchange, made payable at a specified period after date or sight thereof, must be presented for payment at maturity.\"],\"7\":[\"67. Presentment for payment of promissory note payable by instalments\",\"A promissory note payable by instalments must be presented for payment on the third day after the date fixed for payment of each instalment; and non-payment on such presentment has the same effect as non-payment of a note at maturity\"],\"8\":[\"68. Presentment for payment of instrument payable at specified place and not elsewhere\",\"A promissory note, bill of exchange or cheque made, drawn or accepted payable at a specified place and not elsewhere must, in order to charge any party thereto, be presented for payment at that place.\"],\"9\":[\"69. Instrument payable at specified place\",\"A promissory note or bill of exchange made, drawn or accepted payable at a specified place must, in order to charge the maker or drawer thereof, be presented for payment at that place.\"],\"10\":[\"70. Presentment where no exclusive place specified\",\"A promissory note or bill of exchange, not made payable as mentioned in Sections 68 and 69, must be presented for payment at the place of business (if any), or at the usual residence, of the maker, drawee or acceptor thereof, as the case may be.\"],\"11\":[\"71. Presentment when maker, etc., has no known place of business or residence\",\"If the maker, drawee or acceptor of a negotiable instrument has no known place of business or fixed residence, and no place is specified in the instrument for presentment for acceptance or payment, such presentment may be made to him in person wherever he can be found.\"],\"12\":[\"72. Presentment of cheque to charge drawer\",\"Subject to the provisions of Section 84, a cheque must, in order to charge the drawer, be presented at the bank upon which it is drawn before the relation between the drawer and his banker has been altered to the prejudice of the drawer.\"],\"13\":[\"73. Presentment of cheque to charge any other person\",\"A cheque must, in order to charge any person except the drawer, be presented within a reasonable time after delivery by such person.\"],\"14\":[\"74. Presentment of instrument payable on demand\",\"Subject to the provisions of Section 31, a negotiable instrument payable on demand must be presented for payment within a reasonable time after it is received by the holder.\"],\"15\":[\"75. Presentment by or to agent, representative of deceased assignee of insolvent\",\"Presentment for acceptance or payment may be made to the duly authorised agent of the drawee, maker or acceptor, as the case may be, or, where the drawee, maker, or acceptor has died, to his legal representative, or, where he has been declared an insolvent, to his assignee.\"],\"16\":[\"75-A. Excuse for delay in presentment for acceptance or payment\",\"Delay in presentment for acceptance or payment is excused if the delay is caused by circumstances beyond the control of holder and not imputable to his default, misconduct or negligence. When the cause of delay ceases to operate, presentment must be made within a reasonable time\"],\"17\":[\"76. When presentment unnecessary\",\"No presentment for payment is necessary, and the instrument is dishonoured at the due date for presentment, in any of the following cases:\\r\\n(a) If the maker, drawee or acceptor intentionally presents the presentment of the instrument, or\\r\\nif the instrument being payable at his place of business, he closes such place on a business day during the usual business hours, or,\\r\\nif the instrument being payable at some other specified place, neither he nor any person authorised to pay it attends at such place during the usual business hours, or,\\r\\nif the instrument not being payable at any specified place, he cannot after due search be found;\\r\\n(b) as against any party sought to be charged therewith if he has engaged to pay notwithstanding non-presentment;\\r\\n(c) as against any party if, after maturity, with knowledge that the instrument has not been presented\\u2014\\r\\nhe makes a part payment on account of the amount due on the instrument, or promises to pay the amount due thereon in whole or in part,\\r\\nor otherwise waives his right to take advantage of any default in presentment for payment;\\r\\n(d) as against the drawer, if the drawer could not suffer damage from the want of such presentment.\\r\\n\"],\"18\":[\"77. Liability of banker for negligently dealing with bill presented for payment\",\"When a bill of exchange, accepted payable at a specified bank, has been duly presented there for payment and dishonoured, if the banker so negligently or improperly keeps, deals with or delivers back such bill as to cause loss to the holder; he must compensate the holder for such loss.\"]}', 1, '2021-02-02 01:22:38', '2021-02-02 01:29:36'),
(107, 'dVrvvacpTIvxOxqb1z5HjcKUj', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 6', 'PAYMENT AND INTEREST', '', '', '{\"1\":[\"78. To whom payment should be made\",\"Subject to the provisions of Section 82, clause (c), payment of the amount due on a promissory note, bill of exchange or cheque must, in order to discharge the maker or acceptor, be made to the holder of the instrument.\"],\"2\":[\"79. Interest when rate specified\",\"When interest at a specified rate is expressly made payable on a promissory note or bill of exchange, interest shall be calculated at the rate specified on the amount of the principal money due thereon, from the date of the instrument, until tender or realization of such amount, or until such date after the institution of a suit to recover such amount as the court directs.\"],\"3\":[\"80. Interest when no rate specified\",\"When no rate of interest is specified in the instrument, interest on the amount due thereon shall, notwithstanding any agreement relating to interest between any parties to the instruments, be calculated at the rate of eighteen per centum per annum, from the date at which the same ought to have been paid by the party charged, until tender or realisation of the amount due thereon, or, until such date after the institution of a suit to recover such amount as the court directs.\"],\"4\":[\"81. Delivery of instrument on payment, or indemnity in case of loss\",\"(1)Any person liable to pay, and called upon by the holder thereof to pay, the amount due on a promissory note, bill of exchange or cheque is before payment entitled to have it shown, and is on payment entitled to have it delivered up, to him, or, if the instrument is lost or cannot be produced, to be indemnified against any further claim thereon against him.\\r\\n (2) Where the cheque is an electronic image of a truncated cheque, even after the payment the banker who received the payment shall be entitled to retain the truncated cheque.\\r\\n(3) A certificate issued on the foot of the printout of the electronic image of a truncated cheque by the banker who paid the instrument, shall be prima facie proof of such payment\\r\\n\"]}', 1, '2021-02-02 01:30:33', '2021-02-02 01:32:01');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(108, 'BEdH9PCNKFxM1lrkrp1yt5pb6', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 7', 'DISCHARGE FROM LIABILITY, ON NOTES, BILLS AND CHEQUES', '', '', '{\"1\":[\"82. Discharge from liability\",\"The maker, acceptor or indorser respectively of a negotiable instrument is discharged from liability thereon\\u2014\\r\\n(a) by cancellation, to a holder thereof who cancels such acceptor\'s or indorser\'s name with intent to discharge him, and to all parties claiming under such holder;\\r\\n(b) by release, to a holder thereof who otherwise discharges such maker, acceptor or indorser, and to all parties deriving title under such holder after notice of such discharge;\\r\\n(c) by payment, to all parties thereto, if the instrument is payable to bearers, or has been indorsed in blank, and such maker, acceptor or indorser makes payment in due course of the amount due thereon.\\r\\n\"],\"2\":[\"83. Discharge by allowing drawee more than forty-eight hours to accept\",\"If the holder of a bill of exchange allows the drawee more than forty-eighthours, exclusive of public holidays, to consider, whether he will accept the same, all previous parties not consenting to such allowance are thereby discharged from liability to such holder.\"],\"3\":[\"84. When cheque not duly presented and drawer damaged thereby\",\"(1) Where a cheque is not presented for payment within a reasonable time of its issue, and drawer or person on whose account it is drawn had the right, at the time when presentment ought to have been made, as between himself and the banker, to have the cheque paid and suffers actual damage through the delay, he is discharged to the extent of such damage, that is to say to the extent to which such drawer or person is a creditor of the banker to a larger amount than he would have been if such cheque had been paid.\\r\\n(2) In determining what is a reasonable time, regard shall be had to the nature of the instrument, the usage of trade and of bankers, and the facts of the particular case.\\r\\n(3) The holder of the cheque as to which such drawer or person is so discharged shall be a creditor, in lieu of such drawer or person, of such banker to the extent of such discharge and entitled to recover the amount from him\\r\\n\"],\"4\":[\"85. Cheque payable to order\",\"(1) When a cheque payable to order purports to be indorsed by or on behalf of the payee, the drawee is discharged by payment in due course.\\r\\n (2) Where a cheque is originally expressed to be payable to bearer, the drawee is discharged by payment in due course to the bearer thereof, notwithstanding any endorsement whether in full or in blank appearing thereon, and notwithstanding that any such endorsement purports to restrict or exclude further negotiation.\\r\\n\"],\"5\":[\"85-A. Drafts drawn by one branch of a bank on another payable to order\",\"Where any draft, that is, an order to pay money, drawn by one office of a bank upon another office of the same bank for a sum of money payable to order on demand, purports to be endorsed by or on behalf of payee, the bank is discharged by payment in due course.\"],\"6\":[\"86. Parties not consenting discharged by qualified or limited acceptance\",\"If the holder of a bill of exchange acquiesces in a qualified acceptance, or one limited to part of the sum mentioned in the bill, or which substitutes a different place or time for payment, or which where the drawees are not partners, is not signed by all the drawees all previous parties whose consent is not obtained to such acceptance are discharged as against the holder and those claiming under him, unless on notice given by the holder they assent to such acceptance.\"],\"7\":[\"87. Effect of material alteration\",\"Any material alteration of negotiable instrument renders the same void as against any one who is a party thereto at the time of making such alteration and does not consent thereto, unless it was made in order to carry out the common intention of the original parties;\\r\\nAlteration by indorsee, And any such alteration, if made by an indorsee, discharges his indorser from all liability to him in respect of the consideration thereof.\\r\\nThe provisions of this section are subject to those of Sections 20, 49, 86 and 125\\r\\n\"],\"8\":[\"88. Acceptor or indorser bound notwithstanding previous alteration\",\"An acceptor or indorser of a negotiable instrument is bound by his acceptance or indorsement notwithstanding any previous alteration of the instrument.\"],\"9\":[\"89. Payment of instrument on which alteration is not apparent\",\"(1) Where a promissory note, bill of exchange or cheque has been materially altered but does not appear to have been so altered,\\r\\nor where a cheque is presented for payment which does not at the time of presentation appear to be crossed or to have had a crossing which has been obliterated,\\r\\npayment thereof by a person or banker liable to pay, and paying the sum according to the apparent tenor thereof at the time of payment and otherwise in due course, shall discharge such person or banker from all liability thereon; and such payment shall not be questioned by reason of the instrument having been altered, or the cheque crossed.\\r\\n (2) Where the cheque is an electronic image of a truncated cheque, any difference in apparent tenor of such electronic image and the truncated cheque shall be a material alteration and it shall be the duty of the bank or the clearing house, as the case may be, to ensure the exactness of the apparent tenor of electronic image of the truncated cheque while truncating and transmitting the same.\\r\\n(3) Any bank or a clearing house which receives a transmitted electronic image of a truncated cheque, shall verify from the party who transmitted the image to it, that the image so transmitted to it and received by it, is exactly the same\\r\\n\"],\"10\":[\"90. Extinguishment of rights of action on bill in acceptor\'s hands\",\"If a bill of exchange which has been negotiated is, at or after maturity, held by the acceptor in his own right, all rights of action thereon are extinguished.\"]}', 1, '2021-02-02 01:36:35', '2021-02-02 02:03:01'),
(109, 'A9EiprypTVDKL1vDuF9KQD9Ou', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 8', ' NOTICE OF DISHONOUR', '', '', '{\"1\":[\"91. Dishonour by non-acceptance\",\"A bill of exchange is said to be dishonoured by non-acceptance when the drawee, or one of several drawees not being partners, makes default in acceptance upon being duly required to accept the bill, or where presentment is excused and the bill is not accepted.\\r\\nWhere the drawee is incompetent to contract, or the acceptance is qualified, the bill may be treated as dishonoured.\\r\\n\"],\"2\":[\"92. Dishonour by non-payment\",\"A promissory note, bill of exchange or cheque is said to be dishonoured by non-payment when the maker of the note, acceptor of the bill or drawee of the cheque makes default in payment upon being duly required to pay the same.\"],\"3\":[\"93. By and to whom notice should be given\",\"When a promissory note, bill of exchange or cheque is dishonoured by non-acceptance or non-payment, the holder thereof, or some party thereto who remains liable thereon, must give notice that the instrument has been so dishonoured to all other parties whom the holder seeks to make severally liable thereon, and to some one of several parties whom he seeks to make jointly liable thereon.\\r\\nNothing in this section renders it necessary to give notice to the maker of the dishonoured promissory notes or the drawee or acceptor of the dishonoured bill of exchange or cheque.\\r\\n\"],\"4\":[\"94. Mode in which notice may be given\",\"Notice of dishonour may be given to a duly authorised agent of the person to whom it is required to be given, or, where he has died, to his legal representative, or where he has been declared an insolvent, his assignee; may be oral or written; may, if written, be sent by post; and may be in any form; but it must inform the party to whom it is given either in express terms or by reasonable intendment, that the instrument has been dishonoured, and in what way, and that he will be held liable thereon; and it must be given within a reasonable time after dishonour, at the place of business or (in case such party has no place of business) at the residence of the party for whom it is intended.\"],\"5\":[\"95. Party receiving must transmit notice of dishonour\",\"Any party receiving notice of dishonour must, in order to render any prior party liable to himself, give notice of dishonour to such party within a reasonable time, unless such party otherwise receives due notice as provided by Section 93.\"],\"6\":[\"96. Agent of presentment\",\"When the instrument is deposited with an agent for presentment, the agent is entitled to the same time to give notice to his principal as if he were the holder giving notice of dishonour, and the principal is entitled to a further like period to give notice of dishonour.\"],\"7\":[\"97. When party to whom notice given is dead\",\"When the party to whom notice of dishonour is despatched is dead, but the party despatching the notice is ignorant of his death, the notice is sufficient.\"],\"8\":[\"98. When notice of dishonour is unnecessary\",\"No notice of dishonour is necessary\\u2014\\r\\n(a) when it is dispensed with by the party entitled thereto;\\r\\n(b) in order to charge the drawer, when he has countermanded payment;\\r\\n(c) when the party charged could not suffer damage for want of notice;\\r\\n(d) when the party entitled to notice cannot after due search be found; or the party bound to give notice is, for any other reason, unable without any fault of his own to give it;\\r\\n(e) to charge the drawers, when the acceptor is also a drawer;\\r\\n(f) in the case of a promissory note which is not negotiable;\\r\\n(g) when the party entitled to notice, knowing the facts, promise unconditionally to pay the amount due on the instrument.\\r\\n\"]}', 1, '2021-02-02 02:13:27', '2021-02-02 02:15:58'),
(110, 'AfACqdSE6m5soFbN07eRKORii', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 9', 'NOTING AND PROTEST', '', '', '{\"1\":[\"99. Noting\",\"When a promissory note or bill of exchange has been dishonoured by non-acceptance or non-payment, the holder may cause such dishonour to be noted by a notary public upon the instrument, or upon a paper attached thereto, or partly upon each.\\r\\nSuch note must be made within a reasonable time after dishonour, and must specify the date of dishonour, the reason, if any, assigned for such dishonour, or if the instrument has not been expressly dishonoured, the reason why the holder treats it as dishonoured, and the notary\'s charges.\\r\\n\"],\"2\":[\"100. Protest\",\"When a promissory note or bill of exchange has been dishonoured by non-acceptance or non-payment, the holder may, within a reasonable time, cause such dishonour to be noted and certified by a notary public. Such certificate is called a protest.\\r\\nProtest for better security.\\u2014When the acceptor of a bill of exchange has become insolvent, or his credit has been publicly impeached before the maturity of the bill, the holder may, within a reasonable time, cause a notary public to demand better security of the acceptor, and on its being refused may, within a reasonable time, cause such facts to be noted and certified as aforesaid. Such certificate is called a protest for better security.\\r\\n\"],\"3\":[\"101. Contents of protest\",\"A protest under Section 100 must contain:\\r\\n(a) either the instrument itself, or a literal transcript of the instrument and of everything written or printed thereupon;\\r\\n(b) the name of the person for whom and against whom the instrument has been protested;\\r\\n(c) a statement that payment or acceptance or better security, as the case may be, has been demanded of such person by the notary public; the terms of his answer, if any or a statement that he gave no answer, or that he could not be found;\\r\\n(d) when the note or bill has been dishonoured, the place and time of dishonour, and, when better security has been refused, the place and time of refusal;\\r\\n(e) the subscription of the notary public making the protest;\\r\\n(f) in the event of an acceptance for honour or of a payment for honour, the name of the person by whom, of the person for whom, and the manner in which, such acceptance or payment was offered and effected.\\r\\nA notary public may make the demand mentioned in clause (c) of this section either in person or by his clerk, or, where authorised by agreement or usage, by registered letter\"],\"4\":[\"102. Notice of protest\",\"When a promissory note or bill of exchange is required by law to be protested, notice of such protest must be given instead of notice of dishonour, in the same manner and subject to the same conditions; but the notice may be given by the notary public who makes the protest.\"],\"5\":[\"103. Protest for non-payment after dishonour by non-acceptance\",\"All bills of exchange drawn payable at some other place than the place mentioned as the residence of the drawee, and which are dishonoured by non-acceptance, may, without further presentment to the drawee, be protested for non-payment, in the place specified for payment, unless paid before or at maturity.\"],\"6\":[\"104. Protest of foreign bills\",\"Foreign bills of exchange must be protested for dishonour when such protest is required by the law of the place where they are drawn\"],\"7\":[\"104-A. When noting equivalent to protest\",\"For the purposes of this Act, where a bill or note is required to be protested within a specified time or before some further proceeding is taken, it is sufficient that the bill has been noted for protest before the expiration of the specified time or the taking of the proceeding; and the formal protest may be extended at any time thereafter as of the date of the noting.\"]}', 1, '2021-02-02 02:17:01', '2021-02-02 02:19:49'),
(111, '6xJVBpuy77RaRDnQGHenBcWCN', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 10', 'REASONABLE TIME', '', '', '{\"1\":[\"105. Reasonable time\",\"In determining what is a reasonable time for presentment for acceptance or payment, for giving notice of dishonour and for noting, regard shall be had to the nature of the instrument and the usual course of dealing with respect to similar instruments; and, in calculating such time, public holidays shall be excluded.\"],\"2\":[\"106. Reasonable time of giving notice of dishonour\",\"If the holder and the party to whom notice of dishonour is given carry on business or live (as the case may be) in different places, such notice is given within a reasonable time if it is despatched by the next post or on the day next after the day of dishonour.\\r\\nIf the said parties carry on business or live in the same place, such notice is given within a reasonable time if it is despatched in time to reach its destination on the day next after the day of dishonour.\\r\\n\"],\"3\":[\"107. Reasonable time for transmitting such notice\",\"A party receiving notice of dishonour, who seeks to enforce his right against a prior party, transmits the notice within a reasonable time if he transmits it within the same time after its receipt as he would have had to give notice if he had been the holder.\"]}', 1, '2021-02-02 02:21:42', '2021-02-02 02:22:28'),
(112, 'V434MO4hKIL2sqtN5oMHXFAUK', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 11', 'ACCEPTANCE AND PAYMENT FOR HONOUR AND REFERENCE IN CASE OF NEED', '', '', '{\"1\":[\"108. Acceptance for honour\",\"When a bill of exchange has been noted or protested for non-acceptance or for better security, any person not being a party already liable thereon may, with the consent of the holder, by writing on the bill, accept the same for honour of any party thereto.\"],\"2\":[\"109. How acceptance for honour must be made\",\"A person desiring to accept for honour must,  by writing on the bill under his hand declare that he accepts under protest the protested bill for the honour of the drawer or of a particular indorser whom he names, generally for honour\"],\"3\":[\"110. Acceptance not specifying for whose honour it is made\",\"Where the acceptance does not express for whose honour it is made it shall be deemed to be made for the honour of the drawer.\"],\"4\":[\"111. Liability of acceptor for honour\",\"An acceptor for honour binds himself to all parties subsequent to the party for whose honour he accepts to pay the amount of the bill if the drawee do not; and such party and all prior parties are liable in their respective capacities to compensate the acceptor for honour for all loss or damages sustained by him in consequence for such acceptance.\\r\\nBut an acceptor for honour is not liable to the holder of the bill unless it is presented, or (in case the address given by such acceptor on the bill is a place other than the place where the bill is made payable) forwarded for presentment, not later than the day next after the day of its maturity.\"],\"5\":[\"112. When acceptor for honour may be charged\",\"Any acceptor for honour cannot be charged unless the bill has at its maturity been presented to the drawee for payment and has been dishonoured by him, and noted or protested for dishonour.\"],\"6\":[\"113. Payment for honour\",\"When a bill of exchange has been noted or protested for non-payment, any person may pay the same for the honour of any party liable to pay the same, provided that the person so paying or his agent in that behalf has previously declared before a notary public the party for whose honour he pays, and that such declaration has been recorded by such notary public.\"],\"7\":[\"114. Right of payer for honour.\",\"Any person so paying is entitled to all the rights, in respect of the bill, of the holder at the time of such payment, and may recover from the party for whose honour he pays all sums so paid, with interest thereon and with all expenses properly incurred in making such payment.\\r\\n\"],\"8\":[\"115. Drawee in case of need\",\"Where a drawee in case of need is named in a bill of exchange, or in any indorsement thereon, the bill is not dishonoured until it has been dishonoured by such drawee.\"],\"9\":[\"116. Acceptance and payment without protest\",\"A drawee in case of need may accept and pay the bill of exchange without previous protest.\"]}', 1, '2021-02-02 02:23:19', '2021-02-02 02:26:48'),
(113, 'ap74gODl86pNGfBMIRQA2lbsi', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 12', 'COMPENSATION', '', '', '{\"1\":[\"117. Rules as to compensation\",\"The compensation payable in case of dishonour of a promissory note, bill of exchange or cheque, by any party liable to the holder or any indorsee, shall be determined by the following rules:\\r\\n(a) the holder is entitled to the amount due upon the instrument, together with the expenses properly incurred in presenting, noting and protesting it;\\r\\n(b) when the person charged resides at a place different from that at which the instrument was payable, the holder is entitled to receive such sum at the current rate of exchange between the two places;\\r\\n(c) an indorser who, being liable, has paid the amount due on the same is entitled to the amount so paid with interest at eighteen per centum per annum from the date of payment until tender or realisation thereof, together with all expenses caused by the dishonour and payment;\\r\\n(d) when the person charged and such indorser resides at different places, the indorser is entitled to receive such sum at the current rate of exchange between the two places;\\r\\n(e) the party entitled to compensation may draw a bill upon the party liable to compensate him, payable at sight or on demand, for the amount due to him, together with all expenses properly incurred by him. Such bill must be accompanied by the instrument dishonoured and the protest thereof (if any). If such bill is dishonoured, the party dishonouring the same is liable to make compensation thereof in the same manner as in the case of the original bill.\\r\\n\"]}', 1, '2021-02-02 02:28:05', '2021-02-02 02:32:10'),
(114, 'ibrUOtGEvx3MPc1ooj8KjFuC9', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 13', 'SPECIAL RULES OF EVIDENCE', '', '', '{\"1\":[\"118. Presumptions as to negotiable instruments\",\"Until the contrary is proved, the following presumptions shall be made:\\r\\n(a) of consideration: that every negotiable instrument was made or drawn for consideration, and that every such instrument when it has been accepted, indorsed, negotiated or transferred, was accepted, indorsed, negotiated or transferred for consideration;\\r\\n(b) as to date: that every negotiable instrument bearing a date was made or drawn on such date;\\r\\n(c) as to time of acceptance: that every accepted bill of exchange was accepted within a reasonable time after its date and before its maturity;\\r\\n(d) as to time of transfer: that every transfer of negotiable instrument was made before its maturity;\\r\\n(e) as to order of indorsement: that the indorsements appearing upon a negotiable instrument were made in the order in which they appear thereon;\\r\\n(f) as to stamp: that a lost promissory note, bill of exchange or cheque was duly stamped;\\r\\n(g) that holder is a holder in due course: that the holder of a negotiable instrument is a holder in due course:\\r\\n\"],\"2\":[\"119. Presumption on proof of protest\",\"In a suit upon an instrument which has been dishonoured, the court shall on proof of the protest, presume the fact of dishonour, unless and until such fact is disproved.\"],\"3\":[\"120. Estoppel against denying original validity of instrument\",\"No maker of a promissory note, and no drawer of a bill of exchange or cheque, and no acceptor of a bill of exchange for the honour of the drawer shall, in a suit thereon by a holder in due course, be permitted to deny the validity of the instrument as originally made or drawn.\"],\"4\":[\"121. Estoppel against denying capacity of payee to indorse\",\"No maker of a promissory note and no acceptor of a bill of exchange payable to order shall, in a suit thereon by a holder in due course, be permitted to deny the payee\'s capacity, at the date of the note or bill, to indorse the same.\"],\"5\":[\"122. Estoppel against denying signature or capacity of prior party\",\"No indorser of a negotiable instrument shall, in a suit thereon by a subsequent holder, be permitted to deny the signature or capacity to contract of any prior party to the instrument.\"]}', 1, '2021-02-02 02:28:57', '2021-02-02 02:32:31'),
(115, 'ahGqrmzaft2uNSqlYDAPhHvnf', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 14', 'CROSSED CHEQUES', '', '', '{\"1\":[\"123. Cheque crossed generally\",\"Where a cheque bears across its face an addition of the words \\u201cand company\\u201d or any abbreviation thereof, between two parallel transverse lines, or of two parallel transverse lines simply, either with or without the words, \\u201cnot negotiable\\u201d, the addition shall be deemed a crossing, and the cheque shall be deemed to be crossed generally\"],\"2\":[\"124. Cheque crossed specially\",\"Where a cheque bears across its face an addition of the name of a banker, either with or without the words \\u201cnot negotiable\\u201d, that addition shall be deemed a crossing, and the cheque shall be deemed to be crossed specially, and to be crossed to that banker.\"],\"3\":[\"125. Crossing after issue\",\"Where a cheque is uncrossed, the holder may cross it generally or specially.\\r\\nWhere a cheque is crossed generally, the holder may cross it specially.\\r\\nWhere a cheque is crossed generally or specially, the holder may add the words \\u201cnot negotiable\\u201d.\\r\\nWhere a cheque is crossed specially, the banker to whom it is crossed may again cross it specially to another banker, his agent, for collection.\\r\\n\"],\"4\":[\"126. Payment of cheque crossed generally\",\"Where a cheque is crossed generally, the banker, on whom it is drawn shall not pay it otherwise than to a banker.\\r\\nPayment of cheque crossed specially.\\u2014Where a cheque is crossed specially the banker on whom it is drawn shall not pay it otherwise than to the banker to whom it is crossed, or his agent, for collection.\\r\\n\"],\"5\":[\"127. Payment of cheque crossed specially more than once\",\"Where a cheque is crossed specially, to more than one banker, except when crossed to an agent for the purpose of collection, the banker on whom it is drawn shall refuse payment thereof.\"],\"6\":[\"128. Payment in due course of crossed cheque\",\"Where the banker on whom a crossed cheque is drawn has paid the same in due course, the banker paying the cheque, and (in case such cheque has come to the hands of the payee) the drawer thereof, shall respectively be entitled to the same rights, and be placed in the same position in all respects, as they would respectively be entitled to and placed in if the amount of the cheque had been paid to and received by the true owner thereof.\"],\"7\":[\"129. Payment of crossed cheque out of due course\",\"Any banker paying a cheque crossed generally otherwise than to a banker, or a cheque crossed specially otherwise than to the banker to whom the same is crossed, or his agent for collection, being a banker shall be liable to the true owner of the cheque for any loss he may sustain owing to the cheque having been so paid.\"],\"8\":[\"130. Cheque bearing \\u201cnot negotiable\\u201d\",\"A person taking a cheque crossed generally or specially, bearing in either case the words \\u201cnot negotiable\\u201d, shall not have, and shall not be capable of giving a better title to the cheque than that which the person from whom he took it had.\"],\"9\":[\"131. Non-liability of banker receiving payment of cheque\",\"A banker who has in good faith and without negligence received payment for a customer of a cheque crossed generally or specially to himself shall not, in case the title to the cheque proves defective, incur any liability to the true owner of the cheque by reason only of having received such payment.\"],\"10\":[\"131-A. Application of Chapter to drafts\",\"The provisions of this Chapter shall apply to any draft, as defined in Section 85-A, as if the draft were a cheque\"]}', 1, '2021-02-02 02:33:33', '2021-02-02 02:36:43'),
(116, 'kagp5yQiji4i7HfjcHYFsEK73', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 15', 'BILLS IN SETS', '', '', '{\"1\":[\"132. Set of bills\",\"Bills of exchange may be drawn in parts, each part being numbered and containing a provision that it shall continue payable only so long as the others remain unpaid. All the parts together make a set; but the whole set constitutes only one bill, and is extinguished when one of the parts, if a separate bill would be extinguished.\"],\"2\":[\"133. Holder of first acquired part entitled to all\",\"As between holders in due course of different parts of the same set, he who first acquired title to his part is entitled to the other parts and the money represented by the bill.\"]}', 1, '2021-02-02 02:37:46', '2021-02-02 02:37:46'),
(117, 'hpUuopP18q8180qp93Zoar5aW', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 16', 'INTERNATIONAL LAW', '', '', '{\"1\":[\"134. Law governing liability of maker, acceptor or indorser of foreign instrument\",\"In the absence of a contract to the contrary, the liability of the maker or drawer of a foreign promissory note, bill of exchange or cheque is regulated in all essential matters by the law of the place where he made the instrument, and the respective liabilities of the acceptor and indorser by the law of the place where the instrument is made payable.\"],\"2\":[\"135. Law of place of payment governs dishonour\",\"Where a promissory note, bill of exchange or cheque is made payable in a different place from that in which it is made or indorsed, the law of the place where it is made payable determines what constitutes dishonour and what notice of dishonour is sufficient.\"],\"3\":[\"136. Instrument made, etc., out of India but in accordance with the law of India\",\"If a negotiable instrument is made, drawn, accepted or indorsed outside India but in accordance with the law of India, the circumstance that any agreement evidenced by such instrument is invalid according to the law of the country wherein it was entered into does not invalidate any subsequent acceptance or indorsement made thereon within India\"],\"4\":[\"137. Presumption as to foreign law\",\"The law of any foreign country regarding promissory notes, bills of exchange and cheques shall be presumed to be the same as that of India, unless and until the contrary is proved.\"]}', 1, '2021-02-02 02:38:53', '2021-02-02 02:40:30'),
(118, 'NgwXIM29CvtG0JxVgGiHpjKnS', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'CHAPTER 17', 'PENALTIES IN CASE OF DISHONOUR OF CERTAIN CHEQUES FOR INSUFFICIENCY OF FUNDS IN THE ACCOUNTS', '', '', '{\"1\":[\"138. Dishonour of cheque for insufficiency, etc., of funds in the account\",\"Where any cheque drawn by a person on an account maintained by him with a banker for payment of any amount of money to another person from out of that account for the discharge, in whole or in part, of any debt or other liability, is returned by the bank unpaid, either because of the amount of money standing to the credit of that account is insufficient to honour the cheque or that it exceeds the amount arranged to be paid from that account by an agreement made with that bank, such person shall be deemed to have committed an offence and shall, without prejudice to any other provision of this Act, be punished with imprisonment for a term which may extend to two years, or with fine which may extend to twice the amount of the cheque, or with both\\r\\n(a) the cheque has been presented to the bank within a period of six months* from the date on which it is drawn or within the period of its validity, whichever is earlier;\\r\\n(b) the payee or the holder in due course of the cheque, as the case may be, makes a demand for the payment of the said amount of money by giving a notice in writing, to the drawer of the cheque, 69[within thirty days] of the receipt of information by him from the bank regarding the return of the cheque as unpaid; and\\r\\n(c) the drawer of such cheque fails to make the payment of the said amount of money to the payee or as the case may be, to the holder in due course of the cheque within fifteen days of the receipt of the said notice.\\r\\n\"],\"2\":[\"139. Presumption in favour of holder\",\"It shall be presumed, unless the contrary is proved, that the holder of a cheque received the cheque, of the nature referred to in Section 138 for the discharge, in whole or in part, of any debt or other liability\"],\"3\":[\"140. Defence which may not be allowed in any prosecution under Section 138\",\"It shall not be a defence in a prosecution for an offence under Section 138 that the drawer had no reason to believe when he issued the cheque that the cheque may be dishonoured on presentment for the reasons stated in that section.\"],\"4\":[\"141. Offences by companies\",\"(1) If the person committing an offence under Section 138 is a company, every person who, at the time the offence was committed, was in charge of, and was responsible to the company for the conduct of the business of the company, as well as the company, shall be deemed to be guilty of the offence and shall be liable to be proceeded against and punished accordingly:\\r\\n(2) Notwithstanding anything contained in sub-section (1), where any offence under this Act has been committed by a company and it is proved that the offence has been committed with the consent or connivance of, or is attributable to, any neglect on the part of, any director, manager, secretary or other officer of the company, such director, manager, secretary or other officer shall also be deemed to be guilty of that offence and shall be liable to be proceeded against and punished accordingly.\\r\\n\"],\"5\":[\"142. Cognizance of offences\",\" (1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974),\\u2014\\r\\n(a) no court shall take cognizance of any offence punishable under Section 138 except upon a complaint, in writing, made by the payee or, as the case may be, the holder in due course of the cheque;\\r\\n(b) such complaint is made within one month of the date on which the cause of action arises under clause (c) of the proviso to Section 138:\\r\\n [Provided that the cognizance of a complaint may be taken by the court after the prescribed period, if the complainant satisfies the court that he had sufficient cause for not making a complaint within such period.\\r\\n(c) no court inferior to that of a Metropolitan Magistrate or a Judicial Magistrate of the first class shall try any offence punishable under Section 138.\\r\\n (2) The offence under Section 138 shall be inquired into and tried only by a court within whose local jurisdiction,\\u2014\\r\\n(a) if the cheque is delivered for collection through an account, the branch of the bank where the payee or holder in due course, as the case may be, maintains the account, is situated; or\\r\\n(b) if the cheque is presented for payment by the payee or holder in due course, otherwise through an account, the branch of the drawee bank where the drawer maintains the account, is situated.\\r\\n\"],\"6\":[\"142-A. Validation for transfer of pending cases\",\"(1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974) or any judgment, decree, order or direction of any court, all cases transferred to the court having jurisdiction under sub-section (2) of Section 142, as amended by the Negotiable Instruments (Amendment) Ordinance, 2015, shall be deemed to have been transferred under this Act, as if that sub-section had been in force at all material times.\\r\\n(2) Notwithstanding anything contained in sub-section (2) of Section 142 or sub-section (1), where the payee or the holder in due course, as the case may be, has filed a complaint against the drawer of a cheque in the court having jurisdiction under sub-section (2) of Section 142 or the case has been transferred to that court under sub-section (1) and such complaint is pending in that court, all subsequent complaints arising out of Section 138 against the same drawer shall be filed before the same court irrespective of whether those cheques were delivered for collection or presented for payment within the territorial jurisdiction of that court.\\r\\n(3) If, on the date of the commencement of the Negotiable Instruments (Amendment) Act, 2015, more than one prosecution filed by the same payee or holder in due course, as the case may be, against the same drawer of cheques is pending before different courts, upon the said fact having been brought to the notice of the court, such court shall transfer the case to the court having jurisdiction under sub-section (2) of Section 142, as amended by the Negotiable Instruments (Amendment) Ordinance, 2015, before which the first case was filed and is pending, as if that sub-section had been in force at all material times\\r\\n\"],\"7\":[\"143. Power of court to try cases summarily\",\"1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), all offences under this chapter shall be tried by a Judicial Magistrate of the first class or by a Metropolitan Magistrate and the provisions of Sections 262 to 265 (both inclusive) of the said Code shall, as far as may be, apply to such trials:\\r\\n(2) The trial of a case under this section shall, so far as practicable, consistently with the interests of justice, be continued from day to day until its conclusion, unless the court finds the adjournment of the trial beyond the following day to be necessary for reasons to be recorded in writing.\\r\\n(3) Every trial under this section shall be conducted as expeditiously as possible and an endeavour shall be made to conclude the trial within six months from the date of filing of the complaint.\\r\\n\"],\"8\":[\"143-A. Power to direct interim compensation\",\"(1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), the Court trying an offence under Section 138 may order the drawer of the cheque to pay interim compensation to the complainant\\u2014\\r\\n(a) in a summary trial or a summons case, where he pleads not guilty to the accusation made in the complaint; and\\r\\n(b) in any other case, upon framing of charge.\\r\\n(2) The interim compensation under sub-section (1) shall not exceed twenty per cent of the amount of the cheque.\\r\\n(3) The interim compensation shall be paid within sixty days from the date of the order under sub-section (1), or within such further period not exceeding thirty days as may be directed by the Court on sufficient cause being shown by the drawer of the cheque.\\r\\n(4) If the drawer of the cheque is acquitted, the Court shall direct the complainant to repay to the drawer the amount of interim compensation, with interest at the bank rate as published by the Reserve Bank of India, prevalent at the beginning of the relevant financial year, within sixty days from the date of the order, or within such further period not exceeding thirty days as may be directed by the Court on sufficient cause being shown by the complainant.\\r\\n(5) The interim compensation payable under this section may be recovered as if it were a fine under Section 421 of the Code of Criminal Procedure, 1973 (2 of 1974).\\r\\n(6) The amount of fine imposed under Section 138 or the amount of compensation awarded under Section 357 of the Code of Criminal Procedure, 1973 (2 of 1974), shall be reduced by the amount paid or recovered as interim compensation under this section\\r\\n\"],\"9\":[\"144. Mode of service of summons\",\"(1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), and for the purposes of this chapter, a Magistrate issuing a summons to an accused or a witness may direct a copy of summons to be served at the place where such accused or witness ordinarily resides or carries on business or personally works for gain, by speed post or by such courier services as are approved by a Court of Session.\\r\\n(2) Where an acknowledgment purporting to be signed by the accused or the witness or an endorsement purported to be made by any person authorised by the postal department or the courier services that the accused or the witness refused to take delivery of summons has been received, the court issuing the summons may declare that the summons has been duly served\\r\\n\"],\"10\":[\"145. Evidence on affidavit\",\".\\u2014(1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), the evidence of the complainant may be given by him on affidavit and may, subject to all just exceptions be read in evidence in any enquiry, trial or other proceeding under the said Code.\\r\\n(2) The court may, if it thinks fit, and shall, on the application of the prosecution or the accused, summon and examine any person giving evidence on affidavit as to the facts contained therein.\\r\\n\"],\"11\":[\"146. Bank\'s slip prima facie evidence of certain facts\",\"The court shall, in respect of every proceeding under this chapter, on production of bank\'s slip or memo having thereon the official mark denoting that the cheque has been dishonoured, presume the fact of dishonour of such cheque, unless and until such fact is disproved.\"],\"12\":[\"147. Offences to be compoundable\",\"Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), every offence punishable under this Act shall be compoundable\"],\"13\":[\"148. Power of Appellate Court to order payment pending appeal against conviction\",\".\\u2014(1) Notwithstanding anything contained in the Code of Criminal Procedure, 1973 (2 of 1974), in an appeal by the drawer against conviction under Section 138, the Appellate Court may order the appellant to deposit such sum which shall be a minimum of twenty per cent of the fine or compensation awarded by the trial Court:\\r\\n(2) The amount referred to in sub-section (1) shall be deposited within sixty days from the date of the order, or within such further period not exceeding thirty days as may be directed by the Court on sufficient cause being shown by the appellant.\\r\\n(3) The Appellate Court may direct the release of the amount deposited by the appellant to the complainant at any time during the pendency of the appeal\\r\\n\"]}', 1, '2021-02-02 02:41:36', '2021-02-02 02:59:42');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(119, 'drI8IuTjDxHRDTqNQlrpcvXsB', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'SCHEDULE', 'Enactments Repealed', '', '', '{\"1\":[\"Enactments Repealed\",\"1. For the S.O.R. see Gaz. of India, 1876, p. 1836, for the Reports of the Select Committee, see ibid., 1877, Pt. V, p. 321; 1878, Pt. V, p. 145; 1879, Pt. V, p. 75; 1881, Pt. V, p. 85; for discussions in the Council, see ibid., 1876, Supplement, p. 1081; and ibid., 1881, Supplement, p. 1409.\\r\\n2. Subs. by the A.O. 1950 for \\u201call the Provinces of India\\u201d.\\r\\n3. The words \\u201cexcept the State of Jammu and Kashmir\\u201d were omitted by the Jammu and Kashmir (Extension of Law) Act, 1956.\\r\\n4. See now the Reserve Bank of India Act, 1934 (11 of 1934).\\r\\n5. Repealed by Act 12 of 1891. Prior to repeal it read as:\\r\\n\\u201c2. Repeal of enactments.\\u2014On and from that day the enactments specified in the schedule hereto annexed shall be repealed to the extent mentioned in the third column thereof.\\u201d\\r\\n6. Definition of the word \\u201cIndia\\u201d, which was subs. by Act 3 of 1951 for the definition of the word \\u201cState\\u201d, omitted by Act 62 of 1956, S. 2 and Sch. Prior to omission it read as:\\r\\n\\u2018India.\\u2014\\u201cIndia\\u201d means the territory of India excluding the State of Jammu and Kashmir.\\u2019\\r\\n7. Subs. by S. 2 of Act 37 of 1955.\\r\\n8. Repealed by Act 53 of 1952, S. 16 (w.e.f. 14-2-1956). Prior to repeal it read as:\\r\\n\\u2018Notary public.\\u2014\\u201cNotary public\\u201d includes also any person appointed by the Governor-General in Council to perform the functions of a notary public under this Act.\\u2019\\r\\n9. Subs. by Act 55 of 2002, S. 2 (w.e.f. 6-2-2003).\\r\\n10. Subs. by Act 26 of 2015, S. 2(i) (w.r.e.f. 15-6-2015). Prior to substitution it read as:\\r\\n\\u2018(a) \\u201ca cheque in the electronic form\\u201d means a cheque which contains the exact mirror image of a paper cheque, and is generated, written and signed in a secure system ensuring the minimum safety standards with the use of digital signature (with or without biometrics signature) and asymmetric crypto system;\\u2019\\r\\n11. Ins. by Act 26 of 2015, S. 2(ii) (w.r.e.f. 15-6-2015).\\r\\n12. Subs. by Act 2 of 1885, S. 2 for \\u201cWhen acceptance is refused and the bill is protested for non-acceptance\\u201d\\r\\n13. Subs. by Act 8 of 1919, S. 2 for \\u201cpayable to, or to the order of, a payee\\u201d.\\r\\n14. Subs. by Act 36 of 1957, S. 3 and Sch. 11, for \\u201ca State\\u201d.\\r\\n15. Subs. by Act 36 of 1957, S. 3 and Sch. 11, for \\u201ca State\\u201d.\\r\\n16. Subs. by Act 8 of 1919, S. 3.\\r\\n17. Ins. by Act 5 of 1914, S. 2.\\r\\n18. Renumbered as sub-section (1) and sub-section (2) was ins. by S. 3 of Act 5 of 1914.\\r\\n19. Ins. by S. 3 of Act 5 of 1914.\\r\\n20. Subs. by Act 3 of 1951, for \\u201cthe States\\u201d.\\r\\n21. The words \\u201cNew Year\'s Day, Christmas Day, if either of such days falls on a Sunday, the next following Monday\\u201d were deleted by S. 3 of Act 37 of 1955.\\r\\n22. Subs. by the A.O. 1937, for \\u201cLocal Government\\u201d.\\r\\n23. By Govt. of India Noti. No. 20\\/25-56-Pub-1, dated June 8, 1957 the power is exercisable by the State Government.\\r\\n24. Ins. by Act 2 of 1885, S. 3.\\r\\n25. Subs. by Act 8 of 1919, S. 4, for \\u201cpayable to the order of a specified person or to specified person or order\\u201d.\\r\\n26. Ins. by Act 2 of 1885, S. 4.\\r\\n27. Subs. by Act 12 of 1921, S. 2, for \\u201ctwenty-four\\u201d.\\r\\n28. Section 64 re-numbered as sub-section (1) by Act 55 of 2002, S. 3 (w.e.f. 6-2-2003).\\r\\n29. Ins. by Act 2 of 1885, S. 4.\\r\\n30. Ins. by Act 55 of 2002, S. 3 (w.e.f. 6-2-2003).\\r\\n31. Ins. by Act 6 of 1897, S. 2.\\r\\n32. Ins. by Act 25 of 1920, S. 2.\\r\\n33. Subs. by Act 12 of 1921, S. 3, \\u201cfor payment\\u201d.\\r\\n34. This section was inserted by S. 2 of the Negotiable Instruments Act and Indian Limitation Act (Temporary Amendment) Ordinance No. 31 of 1947, promulgated under S. 42 of the Govt. of India Act, 1935. Omitted by Repealing and Amending Act, 1957 (36 of 1957). Prior to omission it read as:\\r\\n\\u201c75-B. Presentment of negotiable instruments in riot areas unnecessary.\\u2014(1) Notwithstanding anything contained in this Act or in any other law for the time being in force no, presentment for acceptance or payment of a negotiable instrument shall be necessary, and the instrument shall be deemed to be dishonoured at the due date for presentment if it is not possible for the holder thereof, being a bank, to present the instrument for acceptance or payment on account of the prevalence of riot or other disturbances in the area in which such payment is to be made.\\r\\n(2) Every bank which treats any negotiable instrument as dishonoured under sub-section (1) shall send to the Reserve Bank of India a return signed by two responsible officers of the bank in such form and manner as may be prescribed by the Reserve Bank of India.\\r\\nExplanation.\\u2014For the purpose of this section a bank shall include a company or corporation incorporated by or under any law in force in any place in or outside the Provinces of India, which transacts the business of banking in any of the Provinces of India.\\u201d\\r\\n35. Subs. by Act 30 of 1926, S. 2, for \\u201cexcept in cases provided for by the Code of Civil Procedure, S. 522\\u201d.\\r\\n36. Subs. for \\u201csix per centum\\u201d by Act 66 of 1988, S. 2 (w.e.f. 30-12-1988).\\r\\n37. Section 81 renumbered as sub-section (1) by Act 55 of 2002, S. 4 (w.e.f. 6-2-2003).\\r\\n38. Ins. by Act 55 of 2002, S. 4 (w.e.f. 6-2-2003).\\r\\n39. Subs. by Act 12 of 1921, S. 21, for \\u201ctwenty-four\\u201d.\\r\\n40. Subs. by Act 6 of 1898, S. 3.\\r\\n41. Renumbered by Act 17 of 1934, S. 2.\\r\\n42. Ins. by Act 17 of 1934, S. 2.\\r\\n43. Ins. by Act 25 of 1930, S. 2.\\r\\n44. Section 89 renumbered as sub-section (1) by Act 55 of 2002, S. 5 (w.e.f. 6-2-2003).\\r\\n45. Ins. by the Act 55 of 2002, S. 5 (w.e.f. 6-2-2003).\\r\\n46. Added by Act 2 of 1885, S. 5.\\r\\n47. Ins. by Act 2 of 1885, S. 6.\\r\\n48. Last portion was omitted by S. 7 of Act 2 of 1885. Prior to omission it read as:\\r\\n\\u201cUnless the person who intends to accept supra protest first declares, in the presence of a notary, that he does it for honour, and has such declaration duly recorded in the notarial register at the time, his acceptance shall be a nullity.\\u201d\\r\\n49. Subs. by Act 2 of 1885, S. 8, for \\u201cin the presence of a notary public subscribes the bill with his own hand and\\u201d.\\r\\n50. The words \\u201cand such declaration must be recorded by the notary in his register\\u201d repealed by Act 2 of 1885, S. 8.\\r\\n51. Ins. by Act 2 of 1885, S. 9.\\r\\n52. The words, figures and brackets \\u201c(except in cases provided for by the Code of Civil Procedure, S. 532)\\u201d were omitted by Act 30 1926, S. 3.\\r\\n53. Subs. for \\u201csix per centum\\u201d by Act 66 of 1988, S. 3 (w.e.f. 30-12-1988).\\r\\n54. Subs. by Act 8 of 1919, S. 5, for \\u201cpayable to, or to the order of, a specified person\\u201d.\\r\\n55. Added by Act 18 of 1922, S. 2.\\r\\n56. Explanation renumbered as Explanation I by Act 55 of 2002, S. 6 (w.e.f. 6-2-2003).\\r\\n57. Ins. by Act 55 of 2002, S. 6 (w.e.f. 6-2-2003).\\r\\n58. Ins. by Act 33 of 1947, S. 2.\\r\\n59. Subs. by Act 3 of 1951, for \\u201cthe States\\u201d.\\r\\n60. Subs. by Act 3 of 1951, for \\u201cthe States\\u201d.\\r\\n61. Subs. by Act 3 of 1951, for \\u201cthe States\\u201d.\\r\\n62. The words \\u201cout of British India\\u201d have been successively substituted by A.C.A.O. 1948; A.L.O., 1950 and Part B States (Laws) Act, 1951 (3 of 1951), to read as above.\\r\\n63. The words \\u201claw of British India\\u201d have been successively substituted by A.C.A.O. 1948; A.L.O., 1950 and Part B States (Laws) Act, 1951 (3 of 1951), to read as above.\\r\\n64. The words \\u201cin British India\\u201d have been successively substituted by A.C.A.O. 1948; A.L.O., 1950 and Part B States (Laws) Act, 1951 (3 of 1951), to read as above.\\r\\n65. The words \\u201cor the State of Jammu and Kashmir\\u201d omitted by Act 62 of 1956, S. 2 and Sch.\\r\\n66. The words \\u201cBritish India\\u201d have been successively substituted by A.C.A.O., 1948; A.L.O., 1950 and Part B States (Laws) Act, 1951 (3 of 1951) to read as above.\\r\\n67. Chapter XVII covering Ss. 138 to 142 ins. by Act 66 of 1988, S. 4 (w.e.f. 1-4-1989 vide S.O. 240(E), dt. 29-3-1989). Earlier Chap. XVII relating to \\u2018Notaries Public\\u2019 repealed by Act 53 of 1952.\\r\\n68. Subs. for \\u201cone\\u201d by Act 55 of 2002, S. 7 (w.e.f. 6-2-2003).\\r\\n* Ed.: The period of \\u201csix months\\u201d mentioned in S. 138 proviso (a) remains unchanged as there has been no amendment in this regard. However, RBI vide Circular RBI\\/2011-12\\/251 DBOD AML BC No. 47\\/14.01.001\\/2011-12, dated 4-11-2011, in exercise of the power under S. 35-A of the Banking Regulation Act, 1949 has changed the default period within which a cheque may be presented for payment, from a period of six months from the date of the instrument, to a period of only three months from such date, w.e.f. 1-4-2012. The operative part of the said Circular reads:\\r\\n\\u201cAccordingly, in exercise of the powers conferred by Section 35-A of the Banking Regulation Act, 1949, Reserve Bank hereby directs that w.e.f. April 1, 2012, banks should not make payment of cheques\\/drafts\\/pay orders\\/banker\'s cheques bearing that date or any subsequent date, if they are presented beyond the period of three months from the date of such instrument.\\u201d\\r\\nThe result is that the impact of the above RBI Circular is covered by the latter part of proviso (a), namely, \\u201cor within the period of its validity, whichever is earlier;\\u201d. The complete RBI circular dt. 4-11-2011 is given below at p. 42.\\r\\n69. Subs. for \\u201cwithin fifteen days\\u201d by Act 55 of 2002, S. 7 (w.e.f. 6-2-2003).\\r\\n70. Ins. by Act 55 of 2002, S, 8 (w.e.f. 6-2-2003).\\r\\n71. Renumbered by Act 26 of 2015, S. 3 (w.r.e.f. 15-6-2015).\\r\\n72. Ins. by Act 55 of 2002, S. 9 (w.e.f. 6-2-2003).\\r\\n73. Ins. by Act 26 of 2015, S. 3 (w.r.e.f. 15-6-2015).\\r\\n74. Ins. by Act 26 of 2015, S. 4 (w.r.e.f. 15-6-2015).\\r\\n75. Sections 143 to 147 inserted by Act 55 of 2002, S. 10 (w.e.f. 6-2-2003).\\r\\n76. Ins. by Act 20 of 2018, S. 2 (w.e.f. 1-9-2018).\\r\\n77. Ins. by Act 20 of 2018, S. 2 (w.e.f. 1-9-2018).\\r\\n78. Repealed by the Amending Act, 1891 (XII of 1891).\\r\\n\"]}', 1, '2021-02-02 03:02:09', '2021-02-02 03:02:09'),
(120, '4ukA9CShTjLyZghTOM2qVG275', 'EMXHdqpDCIzfmeBiU7IVAizMG', 'SCHEDULE', '(a) Statutes', '', '', '{\"1\":[\"(a) Statutes\",\"(a) Statutes\\r\\nYear and chapter\\tTitle\\tExtent of repeal\\r\\n9 Wm. III, c. 17\\tAn Act for the better payment of Inland Bills of Exchange.\\tThe whole\\r\\n3 & 4 Anne, c. 8\\tAn Act for giving like remedy upon promissory notes as is now used upon Bills of Exchange, and for the better payment of Inland Bills of Exchange.\\tThe whole\\r\\n(b) Acts of the Governor-General in Council\\r\\nNumber and year\\tTitle\\tExtent of repeal\\r\\nVI of 1840\\tAn Act for the amendment of the law concerning the negotiation of Bills of Exchange.\\tThe whole\\r\\nV of 1866\\tAn Act to amend in certain respects the Commercial Law of British India\\tSections 11, 12 and 13\\r\\nXV of 1874\\tThe Laws Local Extent Act, 1874\\tThe first schedule, so far as relates to Act VI of 1840, and Act V of 1866, Sections 11, 12 and 13.\\u201d\\r\\n\\r\\n\\u00a9 EBC Publishing Pvt.Ltd., Lucknow.\\r\\n\"]}', 1, '2021-02-02 03:03:05', '2021-02-02 03:03:05'),
(121, 'OjA6uBWJk8cv7WZW6lUPz4zxR', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 1 CHAPTER 1', 'PRELIMINARY', '', '', '{\"1\":[\"1. Short title, extent and commencement\",\"This Act may be called the Indian Evidence Act, 1872.\\r\\nIt extends to the whole of India and applies to all judicial proceedings in or before any Court, including Courts-martial, 5[other than Courts-martial convened under the Army Act (44 & 45 Vict., c. 58), the Naval Discipline Act (29 & 30 Vict., c. 109) the Indian Navy (Discipline) Act, 1934 (XXXIV of 1934) or the Air Force Act (7 Geo. 5, c. 51) but not to affidavits presented to any Court or Officer, nor to proceedings before an arbitrator;\\r\\nAnd it shall come into force on the first day of September, 1872.\\r\\n\\r\\n\\r\\n\\r\\n\"],\"2\":[\"2. Repeal of enactments\",\"[* * *]\"],\"3\":[\"3. Interpretation clause\",\"In this Act the following words and expressions are used in the following senses, unless a contrary intention appears from the context:\\r\\n\\u201cCourt\\u201d.\\u2014\\u201cCourt\\u201d includes all Judges12 and Magistrates13, and all persons, except arbitrators, legally authorised to take evidence.\\r\\n\\u201cFact\\u201d.\\u2014\\u201cFact\\u201d means and includes\\u2014\\r\\n(1) any thing, state of things, or relation of things, capable of being perceived by the senses;\\r\\n(2) any mental condition of which any person is conscious.\\r\\n\\r\\nIllustrations\\r\\n(a) That there are certain objects arranged in a certain order in a certain place, is a fact.\\r\\n(b) That a man heard or saw something, is a fact.\\r\\n(c) That a man said certain words, is a fact.\\r\\n(d) That a man holds a certain opinion, has a certain intention, acts in good faith or fraudulently, or uses a particular word in a particular sense, or is or was at a specified time conscious of a particular sensation, is a fact.\\r\\n(e) That a man has a certain reputation, is a fact.\\r\\n\\u201cRelevant\\u201d.\\u2014One fact is said to be relevant to another when the one is connected with the other in any of the ways referred to in the provisions of this Act relating to the relevancy of facts.\\r\\n\\u201cFacts in issue\\u201d.\\u2014The expression \\u201cfacts in issue\\u201d means and includes\\u2014\\r\\nany fact from which, either by itself or in connection with other facts, the existence, non-existence, nature or extent of any right, liability, or disability, asserted or denied in any suit or proceeding, necessarily follows.\\r\\nIllustrations\\r\\nA is accused of the murder of B.\\r\\nAt his trial the following facts may be in issue:\\u2014\\r\\nthat A caused B\'s death;\\r\\nthat A intended to cause B\'s death;\\r\\nthat A had received grave and sudden provocation from B;\\r\\nthat A, at the time of doing the act which caused B\'s death, was, by reason of unsoundness of mind, incapable of knowing its nature.\\r\\n\\u201cDocument\\u201d.\\u2014\\u201cDocument\\u201d means any matter expressed or described upon any substance by means of letters, figures or marks, or by more than one of those means, intended to be used, or which may be used, for the purpose of recording that matter.\\r\\nIllustrations\\r\\nA writing16 is a document;\\r\\n17Words printed, lithographed or photographed are documents;\\r\\nA map or plan is a document;\\r\\nAn inscription on a metal plate or stone is a document;\\r\\nA caricature is a document.\\r\\n\\u201cEvidence\\u201d.\\u2014\\u201cEvidence\\u201d means and includes\\u2014\\r\\n(1) all statements which the Court permits or requires to be made before it by witnesses, in relation to matters of fact under inquiry;\\r\\nsuch statements are called oral evidence;\\r\\n(2) all documents 18[including electronic records produced for the inspection of the Court;\\r\\nsuch documents are called documentary evidence.\\r\\n\\u201cProved\\u201d.\\u2014A fact is said to be proved when, after considering the matters before it, the Court either believes it to exist, or considers its existence so probable that a prudent man ought, under the circumstances of the particular case, to act upon the supposition that it exists.\\r\\n\\u201cDisproved\\u201d.\\u2014A fact is said to be disproved when, after considering the matters before it, the Court either believes that it does not exist, or considers its non-existence so probable that a prudent man ought, under the circumstances of the particular case, to act upon the supposition that it does not exist.\\r\\n\"],\"4\":[\"4. May presume\",\"Whenever it is provided by this Act that the Court may presume a fact, it may either regard such fact as proved, unless and until it is disproved, or may call for proof of it:\\r\\nShall presume.\\u2014Whenever it is directed by this Act that the Court shall presume a fact, it shall regard such fact as proved, unless and until it is disproved:\\r\\nConclusive proof.\\u2014When one fact is declared by this Act to be conclusive proof of another, the Court shall, on proof of the one fact, regard the other as proved, and shall not allow evidence to be given for the purpose of disproving it.\\r\\n\"]}', 1, '2021-02-02 21:33:14', '2021-02-02 22:21:39');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(122, 'w3rWoktJSB0ackBcUQTEJ1uF0', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 1 CHAPTER 2', 'THE RELEVANCY OF FACTS', '', '', '{\"1\":[\"5. Evidence may be given of facts in issue and relevant facts\",\"Evidence may be given in any suit or proceeding of the existence or non-existence of every fact in issue and of such other facts as are hereinafter declared to be relevant, and of no others.\\r\\n\\r\\nIllustrations\\r\\n(a) A is tried for the murder of B by beating him with a club with the intention of causing his death.\\r\\nAt A\'s trial the following facts are in issue:\\u2014\\r\\nA\'s beating B with the club;\\r\\nA\'s causing B\'s death by such beating;\\r\\nA\'s intention to cause B\'s death.\\r\\n(b) A suitor does not bring with him, and have in readiness for production at the first hearing of the case, a bond on which he relies. This section does not enable him to produce the bond or prove its contents at a subsequent stage of the proceedings, otherwise than in accordance with the conditions prescribed by the Code of Civil Procedure.\\r\\n\"],\"2\":[\"6. Relevancy of facts forming part of same transaction\",\"Facts which, though not in issue, are so connected with a fact in issue as to form part of the same transaction, are relevant, whether they occurred at the same time and place or at different times and places.\\r\\n\\r\\nIllustrations\\r\\n(a) A is accused of the murder of B by beating him. Whatever was said or done by A or B or the by-standers at the beating, or so shortly before or after it as to form part of the transaction, is a relevant fact.\\r\\n(b) A is accused of waging war against the Government of India by taking part in an armed insurrection in which property is destroyed, troops are attacked and gaols are broken open. The occurrence of these facts is relevant, as forming part of the general transaction, though A may not have been present at all of them.\\r\\n(c) A sues B for a libel contained in a letter forming part of a correspondence. Letters between the parties relating to the subject out of which the libel arose, and forming part of the correspondence in which it is contained, are relevant facts, though they do not contain the libel itself.\\r\\n(d) The question is, whether certain goods ordered from B were delivered to A. The goods were delivered to several intermediate persons successively. Each delivery is a relevant fact.\\r\\n\"],\"3\":[\"7. Facts which are the occasion, cause or effect of facts in issue\",\"Facts which are the occasion, cause or effect, immediate or otherwise, of relevant facts, or facts in issue, or which constitute the state of things under which they happened, or which afforded an opportunity for their occurrence or transaction, are relevant.\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether A robbed B.\\r\\nThe facts that, shortly before the robbery, B went to a fair with money in his possession, and that he showed it, or mentioned the fact that he had it, to third persons, are relevant.\\r\\n(b) The question is, whether A murdered B.\\r\\nMarks on the ground, produced by a struggle at or near the place where the murder was committed, are relevant facts.\\r\\n(c) The question is, whether A poisoned B.\\r\\nThe state of B\'s health before the symptoms ascribed to poison, and habits of B, known to A, which afforded an opportunity for the administration of poison, are relevant facts.\\r\\n\"],\"4\":[\"8. Motive, preparation and previous or subsequent conduct\",\"Any fact is relevant which shows or constitutes a motive or preparation for any fact in issue or relevant fact.\\r\\nThe conduct of any party, or of any agent to any party, to any suit or proceeding, in reference to such suit or proceeding, or in reference to any fact in issue therein or relevant thereto, and the conduct of any person an offence against whom is the subject of any proceeding, is relevant, if such conduct influences or is influenced by any fact in issue or relevant fact, and whether it was previous or subsequent thereto.\\r\\n\\r\\nIllustrations\\r\\n(a) A is tried for the murder of B.\\r\\nThe facts that A murdered C, that B knew that A had murdered C, and that B had tried to extort money from A by threatening to make his knowledge public, are relevant.\\r\\n(b) A sues B upon a bond for the payment of money. B denies the making of the bond.\\r\\nThe fact that, at the time when the bond was alleged to be made, B required money for a particular purpose, is relevant.\\r\\n(c) A is tried for the murder of B by poison.\\r\\nThe fact that, before the death of B, A procured poison similar to that which was administered to B, is relevant.\\r\\n(d) The question is, whether a certain document is the will of A.\\r\\nThe facts that, not long before the date of the alleged will, A made inquiry into matters to which the provisions of the alleged will relate, that he consulted vakils in reference to making the will, and that he caused drafts of other wills to be prepared, of which he did not approve, are relevant.\\r\\n(e) A is accused of a crime.\\r\\nThe facts that, either before, or at the time of, or after the alleged crime, A provided evidence which would tend to give to the facts of the case an appearance favourable to himself, or that he destroyed or concealed evidence, or prevented the presence or procured the absence of persons who might have been witnesses, or suborned persons to give false evidence respecting it, are relevant.\\r\\n(f) The question is, whether A robbed B.\\r\\nThe facts that, after B was robbed, C said in A\'s presence\\u2014\\u201cthe police are coming to look for the man who robbed B\\u201d, and that immediately afterwards A ran away, are relevant.\\r\\n(g) The question is, whether A owes B rupees 10,000.\\r\\nThe facts that A asked C to lend him money, and that D said to C in A\'s presence and hearing\\u2014\\u201cI advise you not to trust A, for he owes B 10,000 rupees,\\u201d and that A went away without making any answer, are relevant facts.\\r\\n(h) The question is, whether A committed a crime.\\r\\nThe fact that A absconded after receiving a letter warning him that inquiry was being made for the criminal, and the contents of the letter, are relevant.\\r\\n(i) A is accused of a crime.\\r\\nThe facts that, after the commission of the alleged crime, he absconded, or was in possession of property or the proceeds of property acquired by the crime, or attempted to conceal things which were or might have been used in committing it, are relevant.\\r\\n(j) The question is, whether A was ravished.\\r\\nThe facts that, shortly after the alleged rape, she made a complaint relating to the crime, the circumstances under which, and the terms in which, the complaint was made, are relevant.\\r\\nThe fact that, without making a complaint, she said that she had been ravished is, not relevant, as conduct under this section, though it may be relevant as a dying declaration under Section 32, clause (1), or as corroborative evidence under Section 157.\\r\\n(k) The question is, whether A was robbed.\\r\\nThe fact that, soon after the alleged robbery, he made a complaint relating to the offence, the circumstances under which, and the terms in which, the complaint was made, are relevant.\\r\\nThe fact that he said he had been robbed without making any complaint, is not relevant, as conduct under this section, though it may be relevant as a dying declaration under Section 32, clause (1), or as corroborative evidence under Section 157.\\r\\n\"],\"5\":[\"9. Facts necessary to explain or introduce relevant facts\",\"Facts necessary to explain or introduce a fact in issue or relevant fact, or which support or rebut an inference suggested by a fact in issue or relevant fact, or which establish the identity of any thing or person whose identity is relevant, or fix the time or place at which any fact in issue or relevant fact happened, or which show the relation of parties by whom any such fact was transacted, are relevant in so far as they are necessary for that purpose.\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether a given document is the will of A.\\r\\nThe state of A\'s property and of his family at the date of the alleged will may be relevant facts.\\r\\n(b) A sues B for a libel imputing disgraceful conduct to A; B affirms that the matter alleged to be libellous is true.\\r\\nThe position and relations of the parties at the time when the libel was published may be relevant facts as introductory to the facts in issue.\\r\\nThe particulars of a dispute between A and B about a matter unconnected with the alleged libel are irrelevant, though the fact that there was a dispute may be relevant if it affected the relations between A and B.\\r\\n(c) A is accused of a crime.\\r\\nThe fact that, soon after the commission of the crime, A absconded from his house, is relevant under Section 8, as conduct subsequent to and affected by facts in issue.\\r\\nThe fact that, at the time when he left home, he had sudden and urgent business at the place to which he went, is relevant, as tending to explain the fact that he left home suddenly.\\r\\nThe details of the business on which he left are not relevant, except in so far as they are necessary to show that the business was sudden and urgent.\\r\\n(d) A sues B for inducing C to break a contract of service made by him with A. C, on leaving A\'s service, says to A\\u2014\\u201cI am leaving you because B has made me a better offer\\u201d. This statement is a relevant fact as explanatory of C\'s conduct, which is relevant as a fact in issue.\\r\\n(e) A, accused of theft, is seen to give the stolen property to B, who is seen to give it to A\'s wife. B says as he delivers it\\u2014\\u201cA says you are to hide this\\u201d. B\'s statement is relevant as explanatory of a fact which is part of the transaction.\\r\\n(f) A is tried for a riot and is proved to have marched at the head of a mob. The cries of the mob are relevant as explanatory of the nature of the transaction.\\r\\n\"],\"6\":[\"10. Things said or done by conspirator in reference to common design\",\"Where there is reasonable ground to believe that two or more persons have conspired together to commit an offence or an actionable wrong, anything said, done or written by any one of such persons in reference to their common intention, after the time when such intention was first entertained by any one of them, is a relevant fact as against each of the persons believed to be so conspiring, as well for the purpose of proving the existence of the conspiracy as for the purpose of showing that any such person was a party to it.\\r\\n\\r\\nIllustration\\r\\nReasonable ground exists for believing that A has joined in a conspiracy to wage war against the Government of India\\r\\nThe facts that B procured arms in Europe for the purpose of the conspiracy, C collected money in Calcutta for a like object, D persuaded persons to join the conspiracy in Bombay, E published writings advocating the object in view at Agra, and F transmitted from Delhi to G at Kabul the money which C had collected at Calcutta, and the contents of a letter written by H giving an account of the conspiracy, are each relevant, both to prove the existence of the conspiracy, and to prove A\'s complicity in it, although he may have been ignorant of all of them, and although the persons by whom they were done were strangers to him, and although they may have taken place before he joined the conspiracy or after he left it.\\r\\n\"],\"7\":[\"11. When facts not otherwise relevant become relevant\",\"Facts not otherwise relevant are relevant\\u2014\\r\\n(1) if they are inconsistent with any fact in issue or relevant fact;\\r\\n(2) if by themselves or in connection with other facts they make the existence or non-existence of any fact in issue or relevant fact highly probable or improbable\\r\\n\\r\\nIllustrations\\r\\n(a) The question is whether A committed a crime at Calcutta on a certain day. The fact that, on that day, A was at Lahore is relevant.\\r\\nThe fact that, near the time when the crime was committed, A was at a distance from the place where it was committed, which would render it highly improbable, though not impossible, that he committed it, is relevant.\\r\\n(b) The question is, whether A committed a crime.\\r\\nThe circumstances are such that the crime must have been committed either by A, B, C or D. Every fact which shows that the crime could have been committed by no one else, and that it was not committed by either B, C or D, is relevant.\\r\\n\"],\"8\":[\"12. In suits for damages, facts tending to enable Court to determine amount are relevant\",\"In suits in which damages are claimed, any fact which will enable the Court to determine the amount of damages which ought to be awarded, is relevant.\"],\"9\":[\"13. Facts relevant when right or custom is in question\",\"Where the question is as to the existence of any right or custom, the following facts are relevant:\\u2014\\r\\n(a) any transaction by which the right or custom in question was created, claimed, modified, recognized, asserted or denied, or which was inconsistent with its existence;\\r\\n(b) particular instances in which the right or custom was claimed, recognized or exercised, or in which its exercise was disputed, asserted or departed from.\\r\\n\\r\\nIllustration\\r\\nThe question is whether A has a right to a fishery. A deed conferring the fishery on A\'s ancestors, a mortgage of the fishery by A\'s father, a subsequent grant of the fishery by A\'s father, irreconcilable with the mortgage, particular instances in which A\'s father exercised the right, or in which the exercise of the right was stopped by A\'s neighbours, are relevant facts.\\r\\n\"],\"10\":[\"14. Facts showing existence of state of mind, or of body, or bodily feeling\",\"Facts showing the existence of any state of mind, such as intention, knowledge, good faith, negligence, rashness, ill-will or good-will towards any particular person, or showing the existence of any state of body or bodily feeling, are relevant, when the existence of any such state of mind or body or bodily feeling is in issue or relevant\\r\\n\\r\\nIllustrations\\r\\n(a) A is accused of receiving stolen goods knowing them to be stolen. It is proved that he was in possession of a particular stolen article.\\r\\nThe fact that, at the same time, he was in possession of many other stolen articles is relevant, as tending to show he knew each and all of the articles of which he was in possession to be stolen.\\r\\n (b) A is accused of fraudulently delivering to another person a counterfeit coin which, at the time when he delivered it, he knew to be counterfeit.\\r\\nThe fact that, at the time of its delivery, A was possessed of a number of other pieces of counterfeit coin is relevant.\\r\\nThe fact that A had been previously convicted of delivering to another person as genuine a counterfeit coin knowing it to be counterfeit is relevant.\\r\\n(c) A sues B for damage done by a dog of B\'s which B knew to be ferocious.\\r\\nThe facts that the dog had previously bitten X, Y and Z, and that they had made complaints to B, are relevant.\\r\\n(d) The question is, whether A, the acceptor of a bill of exchange, knew that the name of the payee was fictitious.\\r\\nThe fact that A had accepted other bills drawn in the same manner before they could have been transmitted to him by the payee if the payee had been a real person, is relevant, as showing that A knew that the payee was a fictitious person.\\r\\n(e) A is accused of defaming B by publishing an imputation intended to harm the reputation of B.\\r\\nThe fact of previous publications by A respecting B, showing ill-will on the part of A towards B, is relevant, as proving A\'s intention to harm B\'s reputation by the particular publication in question.\\r\\nThe facts that there was no previous quarrel between A and B, and that A repeated the matter complained of as he heard it, are relevant, as showing that A did not intend to harm the reputation of B.\\r\\n(f) A is sued by B for fraudulently representing to B that C was solvent, whereby B, being induced to trust C, who was insolvent, suffered loss.\\r\\nThe fact that at the time when A represented C to be solvent, C was supposed to be solvent by his neighbours and by persons dealing with him, is relevant, as showing that A made the representation in good faith.\\r\\n(g) A is sued by B for the price of work done by B, upon a house of which A is owner, by the order of C, a contractor.\\r\\nA\'s defence is that B\'s contract was with C.\\r\\nThe fact that A paid C for the work in question is relevant, as proving that A did, in good faith, make over to C the management of the work in question, so that C was in a position to contract with B on C\'s own account, and not as agent for A.\\r\\n(h) A is accused of the dishonest misappropriation of property which he had found, and the question is whether, when he appropriated it, he believed in good faith that the real owner could not be found.\\r\\nThe fact that public notice of the loss of the property had been given in the place where A was, is relevant, as showing that A did not in good faith believe that the real owner of the property could not be found.\\r\\nThe fact that A knew, or had reason to believe, that the notice was given fraudulently by C, who had heard of the loss of the property and wished to set up a false claim to it, is relevant as showing that the fact that A knew of the notice did not disprove A\'s good faith.\\r\\n(i) A is charged with shooting at B with intent to kill him. In order to show A\'s intent, the fact of A\'s having previously shot at B may be proved.\\r\\n(j) A is charged with sending threatening letters to B. Threatening letters previously sent by A to B may be proved, as showing the intention of the letters.\\r\\n(k) The question is, whether A has been guilty of cruelty towards B, his wife.\\r\\nExpressions of their feeling towards each other shortly before or after the alleged cruelty, are relevant facts.\\r\\n(l) The question is, whether A\'s death was caused by poison.\\r\\nStatements made by A during his illness as to his symptoms, are relevant facts.\\r\\n(m) The question is, what was the state of A\'s health at the time when an assurance on his life was effected.\\r\\nStatements made by A as to the state of his health at or near the time in question, are relevant facts.\\r\\n(n) A sues B for negligence in providing him with a carriage for hire not reasonably fit for use, whereby A was injured.\\r\\nThe fact that B\'s attention was drawn on other occasions to the defect of that particular carriage, is relevant.\\r\\nThe fact that B was habitually negligent about the carriages which he let to hire, is irrelevant.\\r\\n(o) A is tried for the murder of B by intentionally shooting him dead.\\r\\nThe fact that A, on other occasions, shot at B is relevant, as showing his intention to shoot B.\\r\\nThe fact that A was in the habit of shooting at people with intent to murder them, is irrelevant.\\r\\n(p) A is tried for a crime.\\r\\nThe fact that he said something indicating an intention to commit that particular crime, is relevant.\\r\\nThe fact that he said something indicating a general disposition to commit crimes of that class, is irrelevant.\\r\\n\"],\"11\":[\"15. Facts bearing on question whether act was accidental or intentional\",\"When there is a question whether an act was accidental or intentional, or done with a particular knowledge or intention], the fact that such act formed part of a series of similar occurrences, in each of which the person doing the act was concerned, is relevant.\\r\\n\\r\\nIllustrations\\r\\n(a) A is accused of burning down his house in order to obtain money for which it is insured.\\r\\nThe facts that A lived in several houses successively, each of which he insured, in each of which fire occurred, and after each of which fires A received payment from a different insurance office, are relevant, as tending to show that fires were not accidental.\\r\\n(b) A is employed to receive money from the debtors of B. It is A\'s duty to make entries in a book showing the amounts received by him. He makes an entry showing that on a particular occasion he received less than he really did receive.\\r\\nThe question is, whether this false entry was accidental or intentional.\\r\\nThe facts that other entries made by A in the same book are false, and that the false entry is in each case in favour of A, are relevant.\\r\\n(c) A is accused of fraudulently delivering to B a counterfeit rupee. The question is, whether the delivery of the rupee was accidental.\\r\\nThe fact that, soon before or soon after the delivery to B, A delivered counterfeit rupees to C, D and E are relevant, as showing that the delivery to B was not accidental.\\r\\n\"],\"12\":[\"16. Existence of course of business when relevant\",\"When there is a question whether a particular act was done, the existence of any course of business, according to which it naturally would have been done, is a relevant fact.\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether a particular letter was despatched.\\r\\nThe facts that it was the ordinary course of business for all letters put in a certain place to be carried to the post, and that that particular letter was put in that place, are relevant.\\r\\n(b) The question is, whether a particular letter reached A. The facts that it was posted in due course, and was not returned through the Dead Letter Office, are relevant.\\r\\n\"],\"13\":[\"17. Admission defined\",\"An admission is a statement, oral or documentary or contained in electronic form, which suggests any inference as to any fact in issue or relevant fact, and which is made by any of the persons, and under the circumstances, hereinafter mentioned.\\r\\n\\r\\n\"],\"14\":[\"18. Admission by party to proceeding or his agent, by suitor in representative character; by party interested in subject-matter; by person from whom interest derived\",\"Statements made by a party to the proceeding, or by an agent to any such party, whom the Court regards, under the circumstances of the case, as expressly or impliedly authorised by him to make them, are admissions.\\r\\nStatements made by parties to suits, suing or sued in a representative character, are not admissions, unless they were made while the party making them held that character.\\r\\nStatements made by\\u2014\\r\\n(1) persons who have any proprietary or pecuniary interest in the subject-matter of the proceeding, and who make the statement in their character of persons so interested, or\\r\\n(2) persons from whom the parties to the suit have derived their interest in the subject-matter of the suit,\\r\\nare admissions, if they are made during the continuance of the interest of the persons making the statements.\\r\\n\"],\"15\":[\"19. Admissions by persons whose position must be proved as against party to suit\",\"Statements made by persons whose position or liability it is necessary to prove as against any party to the suit, are admissions, if such statements would be relevant as against such persons in relation to such position or liability in a suit brought by or against them, and if they are made whilst the person making them occupies such position or is subject to such liability.\\r\\n\\r\\nIllustration\\r\\nA undertakes to collect rents for B.\\r\\nB sues A for not collecting rent due from C to B.\\r\\nA denies that rent was due from C to B.\\r\\nA statement by C that he owed B rent is an admission, and is a relevant fact as against A, if A denies that C did owe rent to B.\\r\\n\"],\"16\":[\"20. Admissions by persons expressly referred to by party to suit\",\"Statements made by persons to whom a party to the suit has expressly referred for information in reference to a matter in dispute are admissions.\\r\\n\\r\\nIllustration\\r\\nThe question is, whether a horse sold by A to B is sound.\\r\\nA says to B\\u2014\\u201cGo and ask C, C knows all about it.\\u201d C\'s statement is an admission.\\r\\n\"],\"17\":[\"21. Proof of admissions against persons making them, and by or on their behalf\",\"Admissions are relevant and may be proved as against the person who makes them, or his representative in interest; but they cannot be proved by or on behalf of the person who makes them or by his representative in interest, except in the following cases:\\u2014\\r\\n(1) An admission may be proved by or on behalf of the person making it, when it is of such a nature that, if the person making it were dead, it would be relevant as between third persons under Section 32.\\r\\n(2) An admission may be proved by or on behalf of the person making it, when it consists of a statement of the existence of any state of mind or body, relevant or in issue, made at or about the time when such state of mind or body existed, and is accompanied by conduct rendering its falsehood improbable.\\r\\n(3) An admission may be proved by or on behalf of the person making it, if it is relevant otherwise than as an admission.\\r\\n\\r\\nIllustrations\\r\\n(a) The question between A and B is, whether a certain deed is or is not forged. A affirms that it is genuine, B that it is forged.\\r\\nA may prove a statement by B that the deed is genuine, and B may prove a statement by A that the deed is forged; but A cannot prove a statement by himself that the deed is genuine, nor can B prove a statement by himself that the deed is forged.\\r\\n(b) A, the captain of a ship, is tried for casting her away.\\r\\nEvidence is given to show that the ship was taken out of her proper course.\\r\\nA produces a book kept by him in the ordinary course of his business, showing observations alleged to have been taken by him from day to day, and indicating that the ship was not taken out of her proper course. A may prove these statements, because they would be admissible between third parties, if he were dead, under Section 32, clause (2).\\r\\n(c) A is accused of a crime committed by him at Calcutta.\\r\\nHe produces a letter written by himself and dated at Lahore on that day, and bearing the Lahore post-mark of that day.\\r\\nThe statement in the date of the letter is admissible, because if A were dead, it would be admissible under Section 32, clause (2).\\r\\n(d) A is accused of receiving stolen goods knowing them to be stolen.\\r\\nHe offers to prove that he refused to sell them below their value.\\r\\nA may prove these statements, though they are admissions, because they are explanatory of conduct influenced by facts in issue.\\r\\n(e) A is accused of fraudulently having in his possession counterfeit coin which he knew to be counterfeit.\\r\\nHe offers to prove that he asked a skilful person to examine the coin, as he doubted whether it was counterfeit or not, and that that person did examine it and told him it was genuine.\\r\\nA may prove these facts for the reasons stated in the last preceding illustration.\\r\\n\"],\"18\":[\"22. When oral admissions as to contents of documents are relevant\",\"Oral admissions as to the contents of a document are not relevant, unless and until the party proposing to prove them shows that he is entitled to give secondary evidence of the contents of such document under the rules hereinafter contained, or unless the genuineness of a document produced is in question.\"],\"19\":[\"22-A. When oral admission as to contents of electronic records are relevant\",\"Oral admissions as to the contents of electronic records are not relevant, unless the genuineness of the electronic record produced is in question.\"],\"20\":[\"23. Admissions in civil cases, when relevant\",\"In civil cases no admission is relevant, if it is made either upon an express condition that evidence of it is not to be given, or under circumstances from which the Court can infer that the parties agreed together that evidence of it should not be given.\"],\"21\":[\"24. Confession caused by inducement, threat or promise, when irrelevant in criminal proceeding\",\"A confession made by an accused person is irrelevant in a criminal proceeding, if the making of the confession appears to the Court to have been caused by any inducement, threat or promise, having reference to the charge against the accused person, proceeding from a person in authority and sufficient, in the opinion of the Court, to give the accused person grounds, which would appear to him reasonable, for supposing that by making it he would gain any advantage or avoid any evil of a temporal nature in reference to the proceedings against him.\"],\"22\":[\"25. Confession to police officer not to be proved\",\"No confession made to a police officer, shall be proved as against a person accused of any offence.\"],\"23\":[\"26. Confession by accused while in custody of police not to be proved against him\",\"No confession made by any person whilst he is in the custody of a police officer, unless it be made in the immediate presence of a Magistrate,34 shall be proved as against such person.\"],\"24\":[\"27. How much of information received from accused may be proved\",\"Provided that, when any fact is deposed to as discovered in consequence of information received from a person accused of any offence, in the custody of a police officer, so much of such information, whether it amounts to a confession or not, as relates distinctly to the fact thereby discovered, may be proved.\"],\"25\":[\"28. Confession made after removal of impression caused by inducement, threat or promise, relevant\",\"If such a confession as is referred to in Section 24 is made after the impression caused by any such inducement, threat or promise has, in the opinion of the Court, been fully removed, it is relevant.\"],\"26\":[\"29. Confession otherwise relevant not to become irrelevant because of promise of secrecy, etc\",\"If such a confession is otherwise relevant, it does not become irrelevant merely because it was made under a promise of secrecy, or in consequence of a deception practised on the accused person for the purpose of obtaining it, or when he was drunk, or because it was made in answer to questions which he need not have answered, whatever may have been the form of those questions, or because he was not warned that he was not bound to make such confession, and that evidence of it might be given against him.\"],\"27\":[\"30. Consideration of proved confession affecting person making it and others jointly under trial for same offence\",\"When more persons than one are being tried jointly for the same offence, and a confession made by one of such persons affecting himself and some other of such persons is proved, the Court may take into consideration such confession as against such other person as well as against the person who makes such confession.\\r\\n\\r\\na) A and B are jointly tried for the murder of C. It is proved that A said\\u2014\\u201cB and I murdered C\\u201d. The Court may consider the effect of this confession as against B.\\r\\n(b) A is on his trial for the murder of C. There is evidence to show that C was murdered by A and B, and that B said\\u2014\\u201cA and I murdered C\\u201d.\\r\\nThis statement may not be taken into consideration by the Court against A, as B is not being jointly tried.\\r\\n\"],\"28\":[\"31. Admissions not conclusive proof, but may estop\",\"Admissions are not conclusive proof of the matters admitted but they may operate as estoppels under the provisions hereinafter contained.\"],\"29\":[\"32. Cases in which statement of relevant fact by person who is dead or cannot be found, etc., is relevant\",\"Statements, written or verbal, of relevant facts made by a person who is dead, or who cannot be found, or who has become incapable of giving evidence, or whose attendance cannot be procured without an amount of delay or expense which under the circumstances of the case appears to the Court unreasonable, are themselves relevant facts in the following cases:\\u2014\\r\\n(1) When it relates to cause of death.\\u2014When the statement is made by a person as to the cause of his death, or as to any of the circumstances of the transaction which resulted in his death, in cases in which the cause of that person\'s death comes into question.\\r\\nSuch statements are relevant whether the person who made them was or was not, at the time when they were made, under expectation of death, and whatever may be the nature of the proceeding in which the cause of his death comes into question.\\r\\n(2) Or is made in course of business.\\u2014When the statement was made by such person in the ordinary course of business, and in particular when it consists of any entry or memorandum made by him in books kept in the ordinary course of business, or in the discharge of professional duty; or of an acknowledgment written or signed by him of the receipt of money, goods, securities or property of any kind; or of a document used in commerce written or signed by him; or of the date of a letter or other document usually dated, written or signed by him.\\r\\n(3) Or against interest of maker.\\u2014When the statement is against the pecuniary or proprietary interest of the person making it, or when, if true, it would expose him or would have exposed him to a criminal prosecution or to a suit for damages.\\r\\n(4) Or gives opinion as to public right or custom, or matters of general interest.\\u2014When the statement gives the opinion of any such person, as to the existence of any public right or custom or matter of public or general interest, of the existence of which, if it existed, he would have been likely to be aware, and when such statement was made before any controversy as to such right, custom or matter had arisen.\\r\\n(5) Or relates to existence of relationship.\\u2014When the statement relates to the existence of any relationship by blood, marriage or adoption] between persons as to whose relationship by blood, marriage or adoption the person making the statement had special means of knowledge, and when the statement was made before the question in dispute was raised.\\r\\n(6) Or is made in will or deed relating to family affairs.\\u2014When the statement relates to the existence of any relationship by blood, marriage or adoption between persons deceased, and is made in any will or deed relating to the affairs of the family to which any such deceased person belonged, or in any family pedigree, or upon any tombstone, family portrait or other thing on which such statements are usually made, and when such statement was made before the question in dispute was raised.\\r\\n(7) Or in document relating to transaction mentioned in Section 13, clause (a).\\u2014When the statement is contained in any deed, will or other document which relates to any such transaction as is mentioned in Section 13, clause (a).\\r\\n(8) Or is made by several persons and expresses feelings relevant to matter in question.\\u2014When the statement was made by a number of persons, and expressed feelings or impressions on their part relevant to the matter in question\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether A was murdered by B; or\\r\\nA dies of injuries received in a transaction in the course of which she was ravished. The question is, whether she was ravished by B; or\\r\\nThe question is, whether A was killed by B under such circumstances that a suit would lie against B by A\'s widow.\\r\\nStatements made by A as to the cause of his or her death, referring respectively to the murder, the rape and the actionable wrong under consideration, are relevant facts.\\r\\n(b) The question is as to the date of A\'s birth.\\r\\nAn entry in the diary of a deceased surgeon regularly kept in the course of business, stating that, on a given day he attended A\'s mother and delivered her of a son, is a relevant fact.\\r\\n(c) The question is, whether A was in Calcutta on a given day.\\r\\nA statement in the diary of a deceased solicitor, regularly kept in the course of business, that on a given day the solicitor attended A at a place mentioned, in Calcutta, for the purpose of conferring with him upon specified business, is a relevant fact.\\r\\n(d) The question is, whether a ship sailed from Bombay harbour on a given day.\\r\\nA letter written by a deceased member of a merchant\'s firm, by which she was chartered to their correspondents in London, to whom the cargo was consigned, stating that the ship sailed on a given day from Bombay harbour, is a relevant fact.\\r\\n(e) The question is, whether rent was paid to A for certain land.\\r\\nA letter from A\'s deceased agent to A, saying that he had received the rent on A\'s account and held it at A\'s orders, is a relevant fact.\\r\\n(f) The question is, whether A and B were legally married.\\r\\nThe statement of a deceased clergyman that he married them under such circumstances that the celebration would be a crime, is relevant.\\r\\n(g) The question is, whether A, a person who cannot be found, wrote a letter on a certain day. The fact that a letter written by him is dated on that day, is relevant.\\r\\n(h) The question is, what was the cause of the wreck of a ship.\\r\\nA protest made by the Captain, whose attendance cannot be procured, is a relevant fact.\\r\\n(i) The question is, whether a given road is a public way.\\r\\nA statement by A, a deceased headman of the village, that the road was public, is a relevant fact.\\r\\n(j) The question is, what was the price of grain on a certain day in a particular market. A statement of the price, made by a deceased banya in the ordinary course of his business, is a relevant fact.\\r\\n(k) The question is, whether A, who is dead, was the father of B.\\r\\nA statement by A that B was his son, is a relevant fact.\\r\\n(l) The question is, what was the date of birth of A.\\r\\nA letter from A\'s deceased father to a friend, announcing the birth of A on a given day, is a relevant fact.\\r\\n(m) The question is, whether, and when, A and B were married.\\r\\nAn entry in a memorandum-book by C, the deceased father of B, of his daughter\'s marriage with A on a given date, is a relevant fact.\\r\\n(n) A sues B for a libel expressed in a painted caricature exposed in a shop window. The question is as to the similarity of the caricature and its libellous character. The remarks of a crowd of spectators on these points may be proved.\\r\\n\"],\"30\":[\"33. Relevancy of certain evidence for proving, in subsequent proceeding, the truth of facts therein stated\",\"Evidence given by a witness in a judicial proceeding, or before any person authorised by law to take it, is relevant for the purpose of proving, in a subsequent judicial proceeding, or in a later stage of the same judicial proceeding, the truth of the facts which it states, when the witness is dead or cannot be found, or is incapable of giving evidence, or is kept out of the way by the adverse party, or if his presence cannot be obtained without an amount of delay or expense which, under the circumstances of the case, the Court considers unreasonable:\\r\\nProvided\\u2014\\r\\nthat the proceeding was between the same parties or their representatives in interest;\\r\\nthat the adverse party in the first proceeding had the right and opportunity to cross-examine;\\r\\nthat the questions in issue were substantially the same in the first as in the second proceeding.\\r\\n\\r\\n\\r\\n\"],\"31\":[\"34. Entries in the books of account\",\"Entries in the books of account, including those maintained in an electronic form, regularly kept in the course of business, are relevant whenever they refer to a matter into which the Court has to inquire, but such statements shall not alone be sufficient evidence to charge any person with liability.\\r\\n\\r\\nIllustration\\r\\nA sues B for Rs 1000 and shows entries in his account books showing B to be indebted to him to this amount. The entries are relevant, but are not sufficient, without other evidence to prove the debt.\\r\\n\"],\"32\":[\"35. Relevancy of entry in public record 4or an electronic record, made in performance of duty.\",\"An entry in any public or other official book, register or record or an electronic record stating a fact in issue or relevant fact, and made by a public servant in the discharge of his official duty, or by any other person in performance of a duty specially enjoined by the law of the country in which such book, register or record or an electronic record is kept, is itself a relevant fact.\"],\"33\":[\"36. Relevancy of statements in maps, charts and plans\",\"Statements of facts in issue or relevant facts, made in published maps or charts generally offered for public sale, or in maps or plans made under the authority of the Central Government or any State Government, as to matters usually represented or stated in such maps, charts or plans, are themselves relevant facts.\"],\"34\":[\"37. Relevancy of statement as to fact of public nature, contained in certain Acts or notifications\",\"When the Court has to form an opinion as to the existence of any fact of a public nature, any statement of it, made in a recital contained in any Act of Parliament of the United Kingdom or in any Central Act, Provincial Act or a State Act or in a Government notification or notification by the Crown Representative appearing in the Official Gazette or in any printed paper purporting to be the London Gazette or the Government Gazette of any Dominion, colony or possession of His Majesty is a relevant fact\"],\"35\":[\"38. Relevancy of statements as to any law contained in law books\",\"When the Court has to form an opinion as to a law of any country, any statement of such law contained in a book purporting to be printed or published under the authority of the Government of such country and to contain any such law, and any report of a ruling of the Courts of such country contained in a book purporting to be a report of such rulings, is relevant.\"],\"36\":[\"39. What evidence to be given when statement forms part of a conversation, document, electronic record, book or series of letters or papers\",\"When any statement of which evidence is given forms part of a longer statement, or of a conversation or part of an isolated document, or is contained in a document which forms part of a book, or is contained in part of electronic record or of a connected series of letters or papers, evidence shall be given of so much and no more of the statement, conversation, document, electronic record, book or series of letters or papers as the Court considers necessary in that particular case to the full understanding of the nature and effect of the statement, and of the circumstances under which it was made\"],\"37\":[\"40. Previous judgments relevant to bar a second suit or trial\",\"The existence of any judgment, order or decree which by law prevents any Court from taking cognizance of a suit or holding a trial, is a relevant fact when the question is whether such Court ought to take cognizance of such suit or to hold such trial.\"],\"38\":[\"41. Relevancy of certain judgments in probate, etc., jurisdiction\",\"A final judgment, order or decree of a competent Court, in the exercise of probate, matrimonial, admiralty or insolvency jurisdiction, which confers upon or takes away from any person any legal character, or which declares any person to be entitled to any such character, or to be entitled to any specific thing, not as against any specified person but absolutely, is relevant when the existence of any such legal character, or the title of any such person to any such thing, is relevant.\\r\\nSuch judgment, order or decree is conclusive proof\\u2014\\r\\nthat any legal character which it confers accrued at the time when such judgment, order or decree came into operation;\\r\\nthat any legal character, to which it declares any such person to be entitled, accrued to that person at the time when such judgment, order or decree declares it to have accrued to that person;\\r\\nthat any legal character which it takes away from any such person ceased at the time from which such judgment, order or decree declared that it had ceased or should cease;\\r\\nand that anything to which it declares any person to be so entitled was the property of that person at the time from which such judgment, order or decree declares that it had been or should be his property.\\r\\n\"],\"39\":[\"42. Relevancy and effect of judgments, orders or decrees, other than those mentioned in Section 41\",\"Judgments, orders or decrees other than those mentioned in Section 41, are relevant if they relate to matters of a public nature relevant to the enquiry; but such judgments, orders or decrees are not conclusive proof of that which they state.\\r\\n\\r\\nIllustration\\r\\nA sues B for trespass on his land. B alleges the existence of a public right of way over the land, which A denies.\\r\\nThe existence of a decree in favour of the defendant, in a suit by A against C for a trespass on the same land, in which C alleged the existence of the same right of way, is relevant, but it is not conclusive proof that the right of way exists.\\r\\n\"],\"40\":[\"43. Judgments, etc., other than those mentioned in Sections 40 to 42, when relevant\",\"Judgments, orders or decrees, other than those mentioned in Sections 40, 41 and 42, are irrelevant, unless the existence of such judgment, order or decree, is a fact in issue, or is relevant under some other provision of this Act.\\r\\nIllustrations\\r\\n(a) A and B separately sue C for a libel which reflects upon each of them. C in each case says that the matter alleged to be libellous is true, and the circumstances are such that it is probably true in each case, or in neither.\\r\\nA obtains a decree against C for damages on the ground that C failed to make out his justification. The fact is irrelevant as between B and C.\\r\\n(b) A prosecutes B for adultery with C, A\'s wife.\\r\\nB denies that C is A\'s wife, but the Court convicts B of adultery.\\r\\nAfterwards, C is prosecuted for bigamy in marrying B during A\'s lifetime. C says that she never was A\'s wife.\\r\\nThe judgment against B is irrelevant as against C.\\r\\n(c) A prosecutes B for stealing a cow from him. B is convicted.\\r\\nA, afterwards, sues C for the cow, which B had sold to him before his conviction. As between A and C, the judgment against B is irrelevant.\\r\\n(d) A has obtained a decree for the possession of land against B. C, B\'s son, murders A in consequence.\\r\\nThe existence of the judgment is relevant, as showing motive for a crime.\\r\\n(e) A is charged with theft and with having been previously convicted of theft. The previous conviction is relevant, as a fact-in-issue.\\r\\n(f) A is tried for the murder of B. The fact that B prosecuted A for libel and that A was convicted and sentenced is relevant under Section 8 as showing the motive for the fact-in-issue\\r\\n\"],\"41\":[\"44. Fraud or collusion in obtaining judgment, or incompetency of Court, may be proved\",\"Any party to a suit or other proceeding may show that any judgment, order or decree which is relevant under Section 40, 41 or 42, and which has been proved by the adverse party, was delivered by a Court not competent to deliver it, or was obtained by fraud or collusion.\"],\"42\":[\"45. Opinions of experts\",\"When the Court has to form an opinion upon a point of foreign law, or of science, or art, or as to identity of handwriting or finger impressions, the opinions upon that point of persons specially skilled in such foreign law, science or art,  or in questions as to identity of handwriting  or finger impressions are relevant facts.\\r\\nSuch persons are called experts.\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether the death of A was caused by poison.\\r\\nThe opinions of experts as to the symptoms produced by the poison by which A is supposed to have died, are relevant.\\r\\n(b) The question is, whether A, at the time of doing a certain act, was, by reason of unsoundness of mind, incapable of knowing the nature of the act, or that he was doing what was either wrong or contrary to law.\\r\\nThe opinions of experts upon the question whether the symptoms exhibited by A commonly show unsoundness of mind, and whether such unsoundness of mind usually renders persons incapable of knowing the nature of the acts which they do, or of knowing that what they do is either wrong or contrary to law, are relevant.\\r\\n(c) The question is, whether a certain document was written by A. Another document is produced which is proved or admitted to have been written by A.\\r\\nThe opinions of experts on the question whether the two documents were written by the same person or by different persons, are relevant.\\r\\n\"],\"43\":[\"45-A. Opinion of Examiner of Electronic Evidence\",\"When in a proceeding, the court has to form an opinion on any matter relating to any information transmitted or stored in any computer resource or any other electronic or digital form, the opinion of the Examiner of Electronic Evidence referred to in Section 79-A of the Information Technology Act, 2000 (21 of 2000), is a relevant fact.\"],\"44\":[\"46. Facts bearing upon opinions of experts\",\"Facts, not otherwise relevant, are relevant if they support or are inconsistent with the opinions of experts, when such opinions are relevant.\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether A was poisoned by a certain poison.\\r\\nThe fact that other persons, who were poisoned by that poison, exhibited certain symptoms which experts affirm or deny to be the symptoms of that poison, is relevant.\\r\\n(b) The question is, whether an obstruction to a harbour is caused by a certain sea-wall.\\r\\nThe fact that other harbours similarly situated in other respects, but where there were no such sea-walls, began to be obstructed at about the same time, is relevant.\\r\\n\"],\"45\":[\"47. Opinion as to handwriting, when relevant\",\"When the Court has to form an opinion as to the person by whom any document was written or signed, the opinion of any person acquainted with the handwriting of the person by whom it is supposed to be written or signed that it was or was not written or signed by that person, is a relevant fact.\\r\\n\\r\\nIllustration\\r\\nThe question is, whether a given letter is in the handwriting of A, a merchant in London.\\r\\nB is a merchant in Calcutta, who has written letters addressed to A and received letters purporting to be written by him. C is B\'s clerk, whose duty it was to examine and file B\'s correspondence. D is B\'s broker, to whom B habitually submitted the letters purporting to be written by A for the purpose of advising with him thereon.\\r\\nThe opinions of B, C and D on the question whether the letter is in the handwriting of A are relevant, though neither B, C nor D ever saw A write.\\r\\n\"],\"46\":[\"47-A. Opinion as to electronic signature when relevant\",\"When the Court has to form an opinion as to the electronic signature of any person, the opinion of the Certifying Authority which has issued the Electronic Signature Certificate is a relevant fact.\"],\"47\":[\"48. Opinion as to existence of right or custom, when relevant\",\"When the Court has to form an opinion as to the existence of any general custom or right, the opinions, as to the existence of such custom or right, of persons who would be likely to know of its existence if it existed, are relevant.\\r\\n\\r\\nIllustration\\r\\nThe right of the villagers of a particular village to use the water of a particular well is a general right within the meaning of this section.\\r\\n\"],\"48\":[\"49. Opinions as to usages, tenets, etc., when relevant\",\"When the Court has to form an opinion as to\\u2014\\r\\nthe usages and tenets of any body of men or family,\\r\\nthe constitution and government of any religious or charitable foundation, or\\r\\nthe meaning of words or terms used in particular districts or by particular classes of people,\\r\\nthe opinions of persons having special means of knowledge thereon, are relevant facts\\r\\n\"],\"49\":[\"50. Opinion on relationship, when relevant\",\"When the Court has to form an opinion as to the relationship of one person to another, the opinion, expressed by conduct, as to the existence of such relationship, of any person who, as a member of the family or otherwise, has special means of knowledge on the subject, is a relevant fact:\\r\\nProvided that such opinion shall not be sufficient to prove a marriage in proceedings under the Indian Divorce Act (4 of 1869), or in prosecutions under Sections 494, 495, 497 or 498 of the Indian Penal Code (45 of 1860).\\r\\n\\r\\nIllustrations\\r\\n(a) The question is, whether A and B were married.\\r\\nThe fact that they were usually received and treated by their friends as husband and wife, is relevant.\\r\\n(b) The question is, whether A was the legitimate son of B. The fact that A was always treated as such by members of the family, is relevant.\\r\\n\\r\\n\"],\"50\":[\"51. Grounds of opinion, when relevant\",\"Whenever the opinion of any living person is relevant, the grounds on which such opinion is based are also relevant.\\r\\n\\r\\nIllustration\\r\\nAn expert may give an account of experiments performed by him for the purpose of forming his opinion.\\r\\n\"],\"51\":[\"52. In civil cases character to prove conduct imputed, irrelevant\",\"In civil cases the fact that the character of any person concerned is such as to render probable or improbable any conduct imputed to him is irrelevant, except in so far as such character appears from facts otherwise relevant.\"],\"52\":[\"53. In criminal cases, previous good character relevant\",\"In criminal proceedings, the fact that the person accused is of a good character, is relevant.\"],\"53\":[\"53-A. Evidence of character or previous sexual experience not relevant in certain cases\",\"In a prosecution for an offence under Section 354, Section 354-A, Section 354-B, Section 354-C, Section 354-D, Section 376,  Section 376-A, Section 376-AB, Section 376-B, Section 376-C, Section 376-D, Section 376-DA, Section 376-DB or Section 376-E of the Indian Penal Code (45 of 1860) or for attempt to commit any such offence, where the question of consent is in issue, evidence of the character of the victim or of such person\'s previous sexual experience with any person shall not be relevant on the issue of such consent or the quality of consent.\"],\"54\":[\"54. Previous bad character not relevant, except in reply\",\"In criminal proceedings the fact that the accused person has a bad character is irrelevant, unless evidence has been given that he has a good character, in which case it becomes relevant.\"],\"55\":[\"55. Character as affecting damages\",\"In civil cases, the fact that the character of any person is such as to affect the amount of damages which he ought to receive, is relevant\"]}', 1, '2021-02-02 21:38:09', '2021-02-02 22:22:22');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(123, 'qeHM4Cr2swjqLQVNap0Zs3eLT', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 2 CHAPTER 3', 'FACTS WHICH NEED NOT BE PROVED', '', '', '{\"1\":[\"56. Fact judicially noticeable need not be proved\",\"No fact of which the Court will take judicial notice need be proved.\"],\"2\":[\"57. Facts of which Court must take judicial notice\",\"The Court shall take judicial notice of the following facts:\\r\\n (1) All laws in force in the territory of India;\\r\\n(2) All public Acts passed or hereafter to be passed by Parliament of the United Kingdom, and all local and personal Acts directed by Parliament of the United Kingdom to be judicially noticed;\\r\\n(3) Articles of War for the Indian Army, Navy or Air Force\\r\\n (4) The course of proceeding of Parliament of the United Kingdom, of the Constituent Assembly of India, of Parliament and of the legislatures established under any laws for the time being in force in a Province or in the States\\r\\n(5) The accession and the sign manual of the Sovereign for the time being of the United Kingdom of Great Britain and Ireland;\\r\\n(6) All seals of which English Courts take judicial notice: the seals of all the Courts in India and of all Courts out of India established by the authority of the Central Government or the Crown Representative: the seals of Courts of Admiralty and Maritime Jurisdiction and of Notaries Public, and all seals which any person is authorised to use by the Constitution or an Act of Parliament of the United Kingdom or an] Act or Regulation having the force of law in India;\\r\\n(7) The accession to office, names, titles, functions and signatures of the persons filling for the time being any public office in any State, if the fact of their appointment to such office is notified in any Official Gazette\\r\\n(8) The existence, title, and national flag of every State or Sovereign recognized by the Government of India:\\r\\n(9) The divisions of time, the geographical divisions of the world, and public festivals, fasts and holidays notified in the Official Gazette;\\r\\n(10) The territories under the dominion of the Government of India\\r\\n(11) The commencement, continuance and termination of hostilities between the Government of India and any other State or body of persons;\\r\\n(12) The names of the members and officers of the Court, and of their deputies and subordinate officers and assistants, and also of all officers acting in execution of its process, and of all advocates, attorneys, proctors, vakils, pleaders and other persons authorized by law to appear or act before it;\\r\\n(13) The rule of the road on land or at sea\\r\\nIn all these cases, and also on all matters of public history, literature, science or art, the Court may resort for its aid to appropriate books or documents of reference.\\r\\nIf the Court is called upon by any person to take judicial notice of any fact, it may refuse to do so unless and until such person produces any such book or document as it may consider necessary to enable it to do so.\\r\\n\"],\"3\":[\"58. Facts admitted need not be proved\",\"No fact need be proved in any proceeding which the parties thereto or their agents agree to admit at the hearing, or which, before the hearing, they agree to admit by any writing under their hands, or which by any rule of pleading in force at the time they are deemed to have admitted by their pleadings:\"]}', 1, '2021-02-02 22:30:53', '2021-02-02 22:35:30'),
(124, 'ZRGVmTZtCYtBrfryZx3s63kkZ', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 2 CHAPTER 4', 'ORAL EVIDENCE', '', '', '{\"1\":[\"59. Proof of facts by oral evidence\",\"All facts, except the contents of documents or electronic records may be proved by oral evidence.\"],\"2\":[\"60. Oral evidence must be direct\",\"Oral evidence must, in all cases whatever, be direct; that is to say\\u2014\\r\\nif it refers to a fact which could be seen, it must be the evidence of a witness who says he saw it;\\r\\nif it refers to a fact which could be heard, it must be the evidence of a witness who says he heard it;\\r\\nif it refers to a fact which could be perceived by any other sense or in any other manner, it must be the evidence of a witness who says he perceived it by that sense or in that manner;\\r\\nif it refers to an opinion or to the grounds on which that opinion is held, it must be the evidence of the person who holds that opinion on those grounds:\\r\\n\"]}', 1, '2021-02-02 22:36:45', '2021-02-02 22:37:22'),
(125, 'VHuPYWYZmNuvJwrUneB8ahK3V', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 2 CHAPTER 5', 'DOCUMENTARY EVIDENCE', '', '', '{\"1\":[\"61. Proof of contents of documents\",\"The contents of documents may be proved either by primary or by secondary evidence.\"],\"2\":[\"62. Primary evidence\",\"Primary evidence means the document itself produced for the inspection of the court.\\r\\n\\r\\nIllustration\\r\\nA person is shown to have been in possession of a number of placards, all printed at one time from one original. Any one of the placards is primary evidence of the contents of any other, but no one of them is primary evidence of the contents of the original.\\r\\n\"],\"3\":[\"63. Secondary evidence\",\"Secondary evidence means and includes\\u2014\\r\\n(1) certified copies given under the provisions hereinafter contained\\r\\n(2) copies made from the original by mechanical processes which in themselves insure the accuracy of the copy, and copies compared with such copies;\\r\\n(3) copies made from or compared with the original;\\r\\n(4) counterparts of documents as against the parties who did not execute them;\\r\\n(5) oral accounts of the contents of a document given by some person who has himself seen it.\\r\\n\\r\\nIllustrations\\r\\n(a) A photograph of an original is secondary evidence of its contents, though the two have not been compared, if it is proved that the thing photographed was the original.\\r\\n(b) A copy compared with a copy of a letter made by a copying machine is secondary evidence of the contents of the letter, if it is shown that the copy made by the copying machine was made from the original.\\r\\n(c) A copy transcribed from a copy, but afterwards compared with the original, is secondary evidence; but the copy not so compared is not secondary evidence of the original, although the copy from which it was transcribed was compared with the original.\\r\\n(d) Neither an oral account of a copy compared with the original, nor an oral account of a photograph or machine-copy of the original, is secondary evidence of the original.\\r\\n\"],\"4\":[\"64. Proof of documents by primary evidence\",\"Documents must be proved by primary evidence except in the cases hereinafter mentioned.\"],\"5\":[\"65. Cases in which secondary evidence relating to documents may be given\",\"Secondary evidence may be given of the existence, condition or contents of a document in the following cases\\u2014\\r\\n(a) when the original is shown or appears to be in the possession or power\\u2014\\r\\nof the person against whom the document is sought to be proved, or of any person out of reach of, or not subject to, the process of the Court, or\\r\\nof any person legally bound to produce it,\\r\\nand when, after the notice mentioned in Section 66, such person does not produce it;\\r\\n(b) when the existence, condition or contents of the original have been proved to be admitted in writing by the person against whom it is proved or by his representative in interest;\\r\\n(c) when the original has been destroyed or lost, or when the party offering evidence of its contents cannot, for any other reason not arising from his own default or neglect, produce it in reasonable time;\\r\\n(d) when the original is of such a nature as not to be easily movable;\\r\\n(e) when the original is a public document within the meaning of Section 74;\\r\\n(f) when the original is a document of which a certified copy is permitted by this Act, or by any other law in force in India, to be given in evidence; \\r\\n(g) when the originals consist of numerous accounts or other documents which cannot conveniently be examined in Court, and the fact to be proved is the general result of the whole collection.\\r\\nIn cases (a), (c) and (d), any secondary evidence of the contents of the document is admissible.\\r\\nIn case (b), the written admission is admissible.\\r\\nIn case (e) or (f), a certified copy of the document, but no other kind of secondary evidence, is admissible.\\r\\nIn case (g), evidence may be given as to the general result of the documents by any person who has examined them, and who is skilled in the examination of such documents\\r\\n\"],\"6\":[\"65-A. Special provisions as to evidence relating to electronic record\",\"The contents of electronic records may be proved in accordance with the provisions of Section 65-B\"],\"7\":[\"65-B. Admissibility of electronic records\",\"(1) Notwithstanding anything contained in this Act, any information contained in an electronic record which is printed on a paper, stored, recorded or copied in optical or magnetic media produced by a computer (hereinafter referred to as the computer output) shall be deemed to be also a document, if the conditions mentioned in this section are satisfied in relation to the information and computer in question and shall be admissible in any proceedings, without further proof or production of the original, as evidence of any contents of the original or of any fact stated therein of which direct evidence would be admissible.\\r\\n(2) The conditions referred to in sub-section (1) in respect of a computer output shall be the following, namely\\u2014\\r\\n(a) the computer output containing the information was produced by the computer during the period over which the computer was used regularly to store or process information for the purposes of any activities regularly carried on over that period by the person having lawful control over the use of the computer;\\r\\n(b) during the said period, information of the kind contained in the electronic record or of the kind from which the information so contained is derived was regularly fed into the computer in the ordinary course of the said activities;\\r\\n(c) throughout the material part of the said period, the computer was operating properly or, if not, then in respect of any period in which it was not operating properly or was out of operation during that part of the period, was not such as to affect the electronic record or the accuracy of its contents; and\\r\\n(d) the information contained in the electronic record reproduces or is derived from such information fed into the computer in the ordinary course of the said activities.\\r\\n(3) Where over any period, the function of storing or processing information for the purposes of any activities regularly carried on over that period as mentioned in clause (a) of sub-section (2) was regularly performed by computers, whether\\u2014\\r\\n(a) by a combination of computers operating over that period; or\\r\\n(b) by different computers operating in succession over that period; or\\r\\n(c) by different combinations of computers operating in succession over that period; or\\r\\n(d) in any other manner involving the successive operation over that period, in whatever order, of one or more computers and one or more combinations of computers,\\r\\nall the computers used for that purpose during that period shall be treated for the purposes of this section as constituting a single computer; and references in this section to a computer shall be construed accordingly.\\r\\n(4) In any proceedings where it is desired to give a statement in evidence by virtue of this section, a certificate doing any of the following things, that is to say,\\u2014\\r\\n(a) identifying the electronic record containing the statement and describing the manner in which it was produced;\\r\\n(b) giving such particulars of any device involved in the production of that electronic record as may be appropriate for the purpose of showing that the electronic record was produced by a computer;\\r\\n(c) dealing with any of the matters to which the conditions mentioned in sub-section (2) relate,\\r\\nand purporting to be signed by a person occupying a responsible official position in relation to the operation of the relevant device or the management of the relevant activities (whichever is appropriate) shall be evidence of any matter stated in the certificate; and for the purposes of this sub-section it shall be sufficient for a matter to be stated to the best of the knowledge and belief of the person stating it.\\r\\n(5) For the purposes of this section,\\u2014\\r\\n(a) information shall be taken to be supplied to a computer if it is supplied thereto in any appropriate form and whether it is so supplied directly or (with or without human intervention) by means of any appropriate equipment;\\r\\n(b) whether in the course of activities carried on by any official, information is supplied with a view to its being stored or processed for the purposes of those activities by a computer operated otherwise than in the course of those activities, that information, if duly supplied to that computer, shall be taken to be supplied to it in the course of those activities;\\r\\n(c) a computer output shall be taken to have been produced by a computer whether it was produced by it directly or (with or without human intervention) by means of any appropriate equipment.\\r\\n\"],\"8\":[\"66. Rules as to notice to produce\",\"Secondary evidence of the contents of the documents referred to in Section 65, clause (a), shall not be given unless the party proposing to give such secondary evidence has previously given to the party in whose possession or power the document is,  or to his attorney or pleader, such notice to produce it as is prescribed by law; and if no notice is prescribed by law, then such notice as the Court considers reasonable under the circumstances of the case:\\r\\nProvided that such notice shall not be required in order to render secondary evidence admissible in any of the following cases, or in any other case in which the Court thinks fit to dispense with it\\u2014\\r\\n(1) when the document to be proved is itself a notice;\\r\\n(2) when, from the nature of the case, the adverse party must know that he will be required to produce it;\\r\\n(3) when it appears or is proved that the adverse party has obtained possession of the original by fraud or force;\\r\\n(4) when the adverse party or his agent has the original in Court;\\r\\n(5) when the adverse party or his agent has admitted the loss of the document;\\r\\n(6) when the person in possession of the document is out of reach of, or not subject to, the process of the Court.\\r\\n\"],\"9\":[\"67. Proof of signature and handwriting of person alleged to have signed or written document produced\",\"If a document is alleged to be signed or to have been written wholly or in part by any person, the signature or the handwriting of so much of the document as is alleged to be in that person\'s handwriting must be proved to be in his handwriting.\"],\"10\":[\"67-A. Proof as to electronic signature\",\"Except in the case of a secure electronic signature, if the electronic signature of any subscriber is alleged to have been affixed to an electronic record the fact that such electronic signature is the electronic signature of the subscriber must be proved.\"],\"11\":[\"68. Proof of execution of document required by law to be attested\",\"If a document is required by law to be attested, it shall not be used as evidence until one attesting witness at least has been called for the purpose of proving its execution, if there be an attesting witness alive, and subject to the process of the Court and capable of giving evidence:\"],\"12\":[\"69. Proof where no attesting witness found\",\"If no such attesting witness can be found, or if the document purports to have been executed in the United Kingdom, it must be proved that the attestation of one attesting witness at least is in his handwriting, and that the signature of the person executing the document is in the handwriting of that person.\"],\"13\":[\"70. Admission of execution by party to attested document\",\"The admission of a party to an attested document of its execution by himself shall be sufficient proof of its execution as against him, though it be a document required by law to be attested.\"],\"14\":[\"71. Proof when attesting witness denies the execution\",\"If the attesting witness denies or does not recollect the execution of the document, its execution may be proved by other evidence.\"],\"15\":[\"72. Proof of document not required by law to be attested\",\"An attested document not required by law to be attested may be proved as if it was unattested.\"],\"16\":[\"73. Comparison of signature, writing or seal with others admitted or proved\",\"In order to ascertain whether a signature, writing, or seal is that of the person by whom it purports to have been written or made, any signature, writing or seal admitted or proved to the satisfaction of the Court to have been written or made by that person may be compared with the one which is to be proved, although that signature, writing, or seal has not been produced or proved for any other purpose.\\r\\nThe Court may direct any person present in Court to write any words or figures for the purpose of enabling the Court to compare the words or figures so written with any words or figures alleged to have been written by such person.\\r\\n\"],\"17\":[\"73-A. Proof as to verification of digital signature\",\"In order to ascertain whether a digital signature is that of the person by whom it purports to have been affixed, the Court may direct\\u2014\\r\\n(a) that person or the Controller or the Certifying Authority to produce the Digital Signature Certificate;\\r\\n(b) any other person to apply the public key listed in the Digital Signature Certificate and verify the digital signature purported to have been affixed by that person\\r\\n\"],\"18\":[\"74. Public documents\",\"The following documents are public documents\\u2014\\r\\n(1) documents forming the acts or records of the acts\\u2014\\r\\n(i) of the sovereign authority,\\r\\n(ii) of official bodies and tribunals, and\\r\\n(iii) of public officers, legislative, judicial and executive, of any part of India or of the Commonwealth or of a foreign country;\\r\\n(2) public records kept in any State private documents\\r\\n\"],\"19\":[\"75. Private documents\",\"All other documents are private.\"],\"20\":[\"76. Certified copies of public documents\",\"Every public officer having the custody of a public document, which any person has a right to inspect, shall give that person on demand a copy of it on payment of the legal fees therefor, together with a certificate written at the foot of such copy that it is a true copy of such document or part thereof, as the case may be, and such certificate shall be dated and subscribed by such officer with his name and his official title, and shall be sealed, whenever such officer is authorized by law to make use of a seal; and such copies so certified shall be called certified copies.\"],\"21\":[\"77. Proof of documents by production of certified copies\",\"Such certified copies may be produced in proof of the contents of the public documents or parts of the public documents of which they purport to be copies.\"],\"22\":[\"78. Proof of other official documents\",\"The following public documents may be proved as follows\\u2014\\r\\n(1) acts, orders or notifications of the Central Government in any of its departments,  or of the Crown Representative or of any State Government or any department of any State Government,\\u2014\\r\\nby the records of the departments, certified by the heads of those departments respectively,\\r\\nor by any document purporting to be printed by order of any such Government or, as the case may be, of the Crown Representative;\\r\\n(2) the proceedings of the Legislatures,\\u2014\\r\\nby the journals of those bodies respectively, or by published Acts or abstracts, or by copies purporting to be printed by order of the Government concerned;\\r\\n(3) proclamations, orders or regulations issued by Her Majesty or by the Privy Council, or by any department of Her Majesty\'s Government,\\u2014\\r\\nby copies or extracts contained in the London Gazette, or purporting to be printed by the Queen\'s Printer;\\r\\n(4) the Acts of the Executive or the proceedings of the Legislature of a foreign country,\\u2014\\r\\nby journals published by their authority, or commonly received in that country as such, or by a copy certified under the seal of the country or sovereign, or by a recognition thereof in some Central Act;\\r\\n(5) the proceedings of a municipal body in a State,\\u2014\\r\\nby a copy of such proceedings, certified by the legal keeper thereof, or by a printed book purporting to be published by the authority of such body;\\r\\n(6) public documents of any other class in a foreign country,\\u2014\\r\\nby the original, or by a copy certified by the legal keeper thereof, with a certificate under the seal of a Notary Public, or of an Indian Consul or diplomatic agent, that the copy is duly certified by the officer having the legal custody of the original, and upon proof of the character of the document according to the law of the foreign country.\\r\\n\"],\"23\":[\"78-A. Copies of public documents to be as good as original documents in certain cases\",\"Notwithstanding anything contained in this Act or any other law for the time being in force, where any public documents concerning any areas within West Bengal have been kept in Pakistan, then copies of such public documents, shall, on being authenticated in such manner as may be prescribed from time to time by the State Government by notification in the official Gazette, be deemed to have taken the place of, and to be, the original documents from which such copies were made and all references to the original documents shall be construed as including references to such copies\"],\"24\":[\"79. Presumption as to genuineness of certified copies\",\"The Court shall presume to be genuine every document purporting to be a certificate, certified copy or other document, which is by law declared to be admissible as evidence of any particular fact and which purports to be duly certified by any officer of the Central Government or of a State Government, or by any officer in the State of Jammu and Kashmir who is duly authorised thereto by the Central Government\\r\\nProvided that such document is substantially in the form and purports to be executed in the manner directed by law in that behalf.\\r\\nThe Court shall also presume that any officer by whom any such document purports to be signed or certified, held, when he signed it, the official character which he claims in such paper\\r\\n\"],\"25\":[\"80. Presumption as to documents produced as record of evidence\",\"When-ever any document is produced before any Court, purporting to be a record or memorandum of the evidence, or of any part of the evidence, given by a witness in a judicial proceeding or before any officer authorised by law to take such evidence, or to be a statement or confession by any prisoner or accused person, taken in accordance with law, and purporting to be signed by any Judge or Magistrate, or by any such officer as aforesaid, the Court shall presume\\u2014\\r\\nthat the document is genuine; that any statement as to the circumstances under which it was taken, purporting to be made by the person signing it, are true, and that such evidence, statement or confession was duly taken.\\r\\n\"],\"26\":[\"81. Presumption as to Gazettes, newspapers, private Acts of Parliament and other documents\",\"The Court shall presume the genuineness of every document purporting to be the London Gazette or any Official Gazette, or the Government Gazette of any colony, dependency or possession of the British Crown, or to be a newspaper or journal, or to be a copy of a private Act of Parliament of the United Kingdom printed by the Queen\'s Printer and of every document purporting to be a document directed by any law to be kept by any person, if such document is kept substantially in the form required by law and is produced from proper custody.\"],\"27\":[\" 81-A. Presumption as to Gazettes in electronic forms\",\"The Court shall presume the genuineness of every electronic record purporting to be the Official Gazette, or purporting to be electronic record directed by any law to be kept by any person, if such electronic record is kept substantially in the form required by law and is produced from proper custody\"],\"28\":[\"82. Presumption as to document admissible in England without proof of seal or signature\",\"When any document is produced before any Court, purporting to be a document which, by the law in force for the time being in England or Ireland, would be admissible in proof of any particular in any Court of Justice in England or Ireland, without proof of the seal or stamp or signature authenticating it, or of the judicial or official character claimed by the person by whom it purports to be signed, the Court shall presume that such seal, stamp or signature is genuine, and that the person signing it held, at the time when he signed it, the judicial or official character which he claims, and the document shall be admissible for the same purpose for which it would be admissible in England or Ireland.\\r\\n\"],\"29\":[\"83. Presumption as to maps or plans made by authority of Government\",\"The Court shall presume that maps or plans purporting to be made by the authority of the Central Government or any State Government] were so made, and are accurate; but maps or plans made for the purposes of any cause must be proved to be accurate.\"],\"30\":[\"84. Presumption as to collections of laws and reports of decisions\",\"The Court shall presume the genuineness of every book purporting to be printed or published under the authority of the Government of any country, and to contain any of the laws of that country,\\r\\nand of every book purporting to contain reports of decisions of the Courts of such country.\\r\\n\"],\"31\":[\"85. Presumption as to powers-of-attorney\",\"The Court shall presume that every document purporting to be a power-of-attorney, and to have been executed before, and authenticated by, a Notary Public, or any Court, Judge, Magistrate Indian  Consul or Vice-Consul, or representative of the Central Government, was so executed and authenticated.\"],\"32\":[\"85-A. Presumption as to electronic agreements\",\"The Court shall presume that every electronic record purporting to be an agreement containing the electronic signatures of the parties was so concluded by affixing the electronic signature of the parties\"],\"33\":[\"85-B. Presumption as to electronic records and electronic signatures\",\"1) In any proceedings involving a secure electronic record, the Court shall presume unless contrary is proved, that the secure electronic record has not been altered since the specific point of time to which the secure status relates.\\r\\n(2) In any proceedings, involving secure electronic signature, the Court shall presume unless the contrary is proved that\\u2014\\r\\n(a) the secure electronic signature is affixed by subscriber with the intention of signing or approving the electronic record;\\r\\n(b) except in the case of a secure electronic record or a secure electronic signature, nothing in this section shall create any presumption relating to authenticity and integrity of the electronic record or any electronic signature\\r\\n\"],\"34\":[\"85-C. Presumption as to Electronic Signature Certificates\",\"The Court shall presume, unless contrary is proved, that the information listed in a Electronic Signature Certificate is correct, except for information specified as subscriber information which has not been verified, if the certificate was accepted by the subscriber.\"],\"35\":[\"86. Presumption as to certified copies of foreign judicial records\",\"The Court may presume that any document purporting to be a certified copy of any judicial record of any country not forming part of India or of Her Majesty\'s dominions is genuine and accurate, if the document purports to be certified in any manner which is certified by any representative of the  Central Government in or for such country to be the manner commonly in use in that country for the certification of copies of judicial records.\"],\"36\":[\"87. Presumption as to books, maps and charts\",\"The Court may presume that any book to which it may refer for information on matters of public or general interest, and that any published map or chart, the statements of which are relevant facts and which is produced for its inspection, was written and published by the person and at the time and place, by whom or at which it purports to have been written or published.\"],\"37\":[\"88. Presumption as to telegraphic messages\",\"The Court may presume that a message, forwarded from a telegraph office to the person to whom such message purports to be addressed, corresponds with a message delivered for transmission at the office from which the message purports to be sent; but the Court shall not make any presumption as to the person by whom such message was delivered for transmission.\"],\"38\":[\"88-A. Presumption as to electronic messages\",\"The Court may presume that an electronic message forwarded by the originator through an electronic mail server to the addressee to whom the message purports to be addressed corresponds with the message as fed into his computer for transmission; but the Court shall not make any presumption as to the person by whom such message was sent.\"],\"39\":[\"89. Presumption as to due execution, etc., of documents not produced\",\"The Court shall presume that every document, called for and not produced after notice to produce, was attested, stamped and executed in the manner required by law.\"],\"40\":[\"90. Presumption as to documents thirty years old\",\"Where any document, purporting or proved to be thirty years old, is produced from any custody which the Court in the particular case considers proper, the Court may presume that the signature and every other part of such document, which purports to be in the handwriting of any particular person, is in that person\'s handwriting, and, in the case of a document executed or attested, that it was duly executed and attested by the persons by whom it purports to be executed and attested.\\r\\n\\r\\nIllustrations\\r\\n(a) A has been in possession of landed property for a long time. He produces from his custody deeds relating to the land showing his titles to it. The custody is proper.\\r\\n(b) A produces deed relating to landed property of which he is the mortgagee. The mortgagor is in possession. The custody is proper.\\r\\n(c) A, a connection of B, produces deeds relating to lands in B\'s possession which were deposited with him by B for safe custody. The custody is proper.\\r\\n\"],\"41\":[\"90-A. Presumption as to electronic records five years old\",\"Where any electronic record, purporting or proved to be five years old, is produced from any custody which the Court in the particular case considers proper, the Court may presume that the electronic signature which purports to be the electronic signature of any particular person was so affixed by him or any person authorised by him in this behalf.\\r\\n\\r\\nUttar Pradesh.\\u2014In its application to the State of Uttar Pradesh, after Section 90, add the following as a new Section 90-A:\\r\\n\\u201c90-A. (1) Where any registered document or a duly certified copy thereof or any certified copy of a document which is part of the record of a court of justice, is produced from any custody which the court in the particular case considers proper, the court may presume that the original was executed by the person by whom it purports to have been executed.\\r\\n(2) This presumption shall not be made in respect of any document which is the basis of a suit or of a defence or is relied upon in the plaint or written statement.\\r\\n\"]}', 1, '2021-02-02 22:38:29', '2021-02-02 23:05:15'),
(126, 'mIZq1nDRn39je5Qs1VYUlJcgZ', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 2 CHAPTER 6', 'THE EXCLUSION OF ORAL BY DOCUMENTARY EVIDENCE', '', '', '{\"1\":[\"91. Evidence of terms of contracts, grants and other dispositions of property reduced to form of document\",\"When the terms of a contract, or of a grant, or of any other disposition of property, have been reduced to the form of a document, and in all cases in which any matter is required by law to be reduced to the form of a document, no evidence shall be given in proof of the terms of such contract, grant or other disposition of property, or of such matter, except the document itself, or secondary evidence of its contents in cases in which secondary evidence is admissible under the provisions hereinbefore contained.\\r\\n\\r\\nIllustrations\\r\\n(a) If a contract be contained in several letters, all the letters in which it is contained must be proved.\\r\\n(b) If a contract is contained in a bill of exchange, the bill of exchange must be proved.\\r\\n(c) If a bill of exchange is drawn in a set of three, one only need be proved.\\r\\n(d) A contracts, in writing, with B, for the delivery of indigo upon certain terms. The contract mentions the fact that B had paid A the price of other indigo contracted for verbally on another occasion.\\r\\nOral evidence is offered that no payment was made for the other indigo. The evidence is admissible.\\r\\n(e) A gives B a receipt for money paid by B.\\r\\nOral evidence is offered of the payment. The evidence is admissible.\\r\\n\"],\"2\":[\"92. Exclusion of evidence of oral agreement\",\"When the terms of any such contract, grant or other disposition of property, or any matter required by law to be reduced to the form of a document, have been proved according to the last section, no evidence of any oral agreement or statement shall be admitted, as between the parties to any such instrument or their representatives in interest, for the purpose of contradicting, varying, adding to, or subtracting from, its terms:\\r\\n\\r\\nIllustrations\\r\\n(a) A policy of insurance is effected on goods \\u201cin ships from Calcutta to London\\u201d. The goods are shipped in a particular ship which is lost. The fact that that particular ship was orally excepted from the policy, cannot be proved.\\r\\n(b) A agrees absolutely in writing to pay B Rs 1000 on the 1st March, 1873. The fact that, at the same time, an oral agreement was made that the money should not be paid till the thirty-first March, cannot be proved.\\r\\n(c) An estate called \\u201cthe Rampur tea estate\\u201d is sold by a deed which contains a map of the property sold. The fact that land not included in the map had always been regarded as part of the estate and was meant to pass by the deed, cannot be proved.\\r\\n(d) A enters into a written contract with B to work certain mines, the property of B, upon certain terms. A was induced to do so by a misrepresentation of B\'s as to their value. This fact may be proved.\\r\\n(e) A institutes a suit against B for the specific performance of a contract, and also prays that the contract may be reformed as to one of its provisions, as that provision was inserted in it by mistake. A may prove that such a mistake was made as would by law entitle him to have the contract reformed.\\r\\n(f) A orders goods of B by a letter in which nothing is said as to the time of payment, and accepts the goods on delivery. B sues A for the price. A may show that the goods were supplied on credit for a term still unexpired.\\r\\n(g) A sells B a horse and verbally warrants him sound. A gives B a paper in these words \\u201cBought of A a horse for Rs 500\\u201d. B may prove the verbal warranty.\\r\\n(h) A hires lodgings of B, and gives B a card on which is written\\u2014\\u201cRooms, Rs 200 a month\\u201d. A may prove a verbal agreement that these terms were to include partial board.\\r\\nA hires lodgings of B for a year, and a regularly stamped agreement, drawn up by an attorney, is made between them. It is silent on the subject of board. A may not prove that board was included in the terms verbally.\\r\\n(i) A applies to B for a debt due to A by sending a receipt for the money. B keeps the receipt and does not send the money. In a suit for the amount, A may prove this.\\r\\n(j) A and B make a contract in writing to take effect upon the happening of a certain contingency. The writing is left with B, who sues A upon it. A may show the circumstances under which it was delivered.\\r\\n\"],\"3\":[\"93. Exclusion of evidence to explain or amend ambiguous document\",\"When the language used in a document is, on its face, ambiguous or defective, evidence may not be given of facts which would show its meaning or supply its defects.\\r\\n\\r\\nIllustrations\\r\\n(a) A agrees, in writing, to sell a horse to B for \\u201cRs 1000, or Rs 1500\\u201d.\\r\\nEvidence cannot be given to show which price was to be given.\\r\\n(b) A deed contains blanks. Evidence cannot be given of facts which would show how they were meant to be filled.\\r\\n\"],\"4\":[\"94. Exclusion of evidence against application of document to existing facts\",\"When language used in a document is plain in itself, and when it applies accurately to existing facts, evidence may not be given to show that it was not meant to apply to such facts.\\r\\n\\r\\nIllustration\\r\\nA sells to B, by deed, \\u201cmy estate at Rampur containing 100 bighas\\u201d. A has an estate at Rampur containing 100 bighas. Evidence may not be given of the fact that the estate meant to be sold was one situated at a different place and of a different size.\\r\\n\"],\"5\":[\"95. Evidence as to document in unmeaning reference to existing facts\",\"When language used in a document is plain in itself, but is unmeaning in reference to existing facts, evidence may be given to show that it was used in a peculiar sense.\\r\\n\\r\\nIllustration\\r\\nA sells to B, by deed, \\u201cmy house in Calcutta\\u201d.\\r\\nA had no house in Calcutta, but it appears that he had a house at Howrah, of which B had been in possession since the execution of the deed.\\r\\nThese facts may be proved to show that the deed related to the house at Howrah.\\r\\n\"],\"6\":[\"96. Evidence as to application of language which can apply to one only of several persons\",\"When the facts are such that the language used might have been meant to apply to any one, and could not have been meant to apply to more than one, of several persons or things, evidence may be given of facts which show which of those persons or things it was intended to apply to.\\r\\n\\r\\nIllustrations\\r\\n(a) A agrees to sell to B, for Rs 1000, \\u201cmy white horse\\u201d. A has two white horses. Evidence may be given of facts which show which of them was meant.\\r\\n(b) A agrees to accompany B to Hyderabad. Evidence may be given of facts showing whether Hyderabad in the Deccan or Hyderabad in Sind was meant.\\r\\n\"],\"7\":[\"97. Evidence as to application of language to one of two sets of facts, to neither of which the whole correctly applies\",\"When the language used applies partly to one set of existing facts, and partly to another set of existing facts, but the whole of it does not apply correctly to either, evidence may be given to show to which of the two it was meant to apply.\\r\\n\\r\\nIllustration\\r\\nA agrees to sell to B \\u201cmy land at X in the occupation of Y\\u201d. A has land at X, but not in the occupation of Y, and he has land in the occupation of Y, but it is not at X. Evidence may be given of facts showing which he meant to sell.\\r\\n\"],\"8\":[\"98. Evidence as to meaning of illegible characters, etc\",\"Evidence may be given to show the meaning of illegible or not commonly intelligible characters, of foreign, obsolete, technical, local, and provincial expressions, of abbreviations and of words used in a peculiar sense.\\r\\n\\r\\nIllustration\\r\\nA, a sculptor, agrees to sell to B, \\u201call my mods\\u201d. A has both models and modelling tools. Evidence may be given to show which he meant to sell.\\r\\n\"],\"9\":[\"99. Who may give evidence of agreement varying terms of document\",\"Persons who are not parties to a document, or their representatives in interest, may give evidence of any facts tending to show a contemporaneous agreement varying the terms of the document.\\r\\n\\r\\nIllustration\\r\\nA and B make a contract in writing that B shall sell A certain cotton, to be paid for on delivery. At the same time they make an oral agreement that three months\' credit shall be given to A. This could not be shown as between A and B, but it might be shown by C, if it affected his interests.\\r\\n\"],\"10\":[\"100. Saving of provisions of Indian Succession Act relating to wills\",\"Nothing in this Chapter contained shall be taken to affect any of the provisions of the Indian Succession Act 10 of 1865 as to the construction of wills.\"]}', 1, '2021-02-02 23:06:29', '2021-02-02 23:12:34');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(127, '8hIW8wKpms66rUj9B3sazp1Cr', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 3 CHAPTER 7', 'THE BURDEN OF PROOF', '', '', '{\"1\":[\"101. Burden of proof\",\"Whoever desires any Court to give judgment as to any legal right or liability dependent on the existence of facts which he asserts, must prove that those facts exist.\\r\\nWhen a person is bound to prove the existence of any fact, it is said that the burden of proof lies on that person.\\r\\n\\r\\nIllustrations\\r\\n(a) A desires a Court to give judgment that B shall be punished for a crime which A says B has committed.\\r\\nA must prove that B has committed the crime.\\r\\n(b) A desires a Court to give judgment that he is entitled to certain land in the possession of B, by reason of facts which he asserts, and which B denies, to be true.\\r\\nA must prove the existence of those facts.\\r\\n\"],\"2\":[\"102. On whom burden of proof lies\",\"The burden of proof in a suit or proceeding lies on that person who would fail if no evidence at all were given on either side.\\r\\n\\r\\nIllustrations\\r\\n(a) A sues B for land of which B is in possession, and which, as A asserts, was left to A by the will of C, B\'s father.\\r\\nIf no evidence were given on either side, B would be entitled to retain his possession. Therefore the burden of proof is on A.\\r\\n(b) A sues B for money due on a bond.\\r\\nThe execution of the bond is admitted, but B says that it was obtained by fraud, which A denies. If no evidence were given on either side, A would succeed, as the bond is not disputed and the fraud is not proved.\\r\\nTherefore the burden of proof is on B.\\r\\n\"],\"3\":[\"103. Burden of proof as to particular fact\",\"The burden of proof as to any particular fact lies on that person who wishes the Court to believe in its existence, unless it is provided by any law that the proof of that fact shall lie on any particular person.\\r\\nIllustration\\r\\n (a) A prosecutes B for theft, and wishes the Court to believe that B admitted the theft to C. A must prove the admission.\\r\\nB wishes the Court to believe that, at the time in question, he was elsewhere. He must prove it.\\r\\n\"],\"4\":[\"104. Burden of proving fact to be proved to make evidence admissible\",\"The burden of proving any fact necessary to be proved in order to enable any person to give evidence of any other fact is on the person who wishes to give such evidence.\\r\\n\\r\\nIllustrations\\r\\n(a) A wishes to prove a dying declaration by B. A must prove B\'s death.\\r\\n(b) A wishes to prove, by secondary evidence, the contents of a lost document. A must prove that the document has been lost.\\r\\n\"],\"5\":[\"105. Burden of proving that case of accused comes within exceptions\",\"When a person is accused of any offence, the burden of proving the existence of circumstances bringing the case within any of the General Exceptions in the Indian Penal Code (XLV of 1860), or within any special exception or proviso contained in any other part of the same Code, or in any law defining the offence, is upon him, and the Court shall presume the absence of such circumstances.\\r\\n\\r\\nIllustrations\\r\\n(a) A, accused of murder, alleges that, by reason of unsoundness of mind, he did not know the nature of the act.\\r\\nThe burden of proof is on A.\\r\\n(b) A, accused of murder, alleges that, by grave and sudden provocation, he was deprived of the power of self-control.\\r\\nThe burden of proof is on A.\\r\\n(c) Section 325 of the Indian Penal Code (XLV of 1860) provides that whoever, except in the case provided for by Section 335, voluntarily causes grievous hurt, shall be subject to certain punishments.\\r\\nA is charged with voluntarily causing grievous hurt under Section 325.\\r\\nThe burden of proving the circumstances bringing the case under Section 335 lies on A.\\r\\n\"],\"6\":[\"106. Burden of proving fact especially within knowledge\",\"When any fact is especially within the knowledge of any person, the burden of proving that fact is upon him.\\r\\nIllustrations\\r\\n(a) When a person does an act with some intention other than that which the character and circumstances of the act suggest, the burden of proving that intention is upon him.\\r\\n(b) A is charged with travelling on a railway without a ticket. The burden of proving that he had a ticket is on him.\\r\\n\"],\"7\":[\"107. Burden of proving death of person known to have been alive within thirty years\",\"When the question is whether a man is alive or dead, and it is shown that he was alive within thirty years, the burden of proving that he is dead is on the person who affirms it.\"],\"8\":[\"108. Burden of proving that person is alive who has not been heard of for seven years\",\"Provided that when the question is whether a man is alive or dead, and it is proved that he has not been heard of for seven years by those who would naturally have heard of him if he had been alive, the burden of proving that he is alive is shifted to the person who affirms it.\"],\"9\":[\"109. Burden of proof as to relationship in the cases of partners, landlord and tenant, principal and agent\",\"When the question is whether persons are partners, landlord and tenant, or principal and agent, and it has been shown that they have been acting as such, the burden of proving that they do not stand, or have ceased to stand, to each other in those relationships respectively, is on the person who affirms it.\"],\"10\":[\"110. Burden of proof as to ownership\",\"When the question is whether any person is owner of anything of which he is shown to be in possession, the burden of proving that he is not the owner is on the person who affirms that he is not the owner.\"],\"11\":[\"111. Proof of good faith in transactions where one party is in relation of active confidence\",\"Where there is a question as to the good faith of a transaction between parties, one of whom stands to the other in a position of active confidence, the burden of proving the good faith of the transaction is on the party who is in a position of active confidence.\\r\\nIllustrations\\r\\n(a) The good faith of a sale by a client to an attorney is in question in a suit brought by the client. The burden of proving the good faith of the transaction is on the attorney.\\r\\n(b) The good faith of a sale by a son just come of age to a father is in question in a suit brought by the son. The burden of proving the good faith of the transaction is on the father\\r\\n\"],\"12\":[\" 111-A. Presumption as to certain offences\",\"Where there is a question as to the good faith of a transaction between parties, one of whom stands to the other in a position of active confidence, the burden of proving the good faith of the transaction is on the party who is in a position of active confidence.\\r\\nIllustrations\\r\\n(a) The good faith of a sale by a client to an attorney is in question in a suit brought by the client. The burden of proving the good faith of the transaction is on the attorney.\\r\\n(b) The good faith of a sale by a son just come of age to a father is in question in a suit brought by the son. The burden of proving the good faith of the transaction is on the father\\r\\n\"],\"13\":[\"112. Birth during marriage, conclusive proof of legitimacy\",\"The fact that any person was born during the continuance of a valid marriage between his mother and any man, or within two hundred and eighty days after its dissolution, the mother remaining unmarried, shall be conclusive proof that he is the legitimate son of that man, unless it can be shown that the parties to the marriage had no access to each other at any time when he could have been begotten.\"],\"14\":[\"113. Proof of cession of territory\",\".\\u2014A notification in the Official Gazette that any portion of British territory has [before the commencement of Part III of the Government of India Act, 1935 (26 Geo. 5 ch. 2) been ceded to any Native State, Prince or Ruler, shall be conclusive proof that a valid cession of such territory took place at the date mentioned in such notification.\"],\"15\":[\"113-A. Presumption as to abetment of suicide by a married woman\",\"When the question is whether the commission of suicide by a woman had been abetted by her husband or any relative of her husband and it is shown that she had committed suicide within a period of seven years from the date of her marriage and that her husband or such relative of her husband had subjected her to cruelty, the court may presume, having regard to all the other circumstances of the case, that such suicide had been abetted by her husband or by such relative of her husband.\"],\"16\":[\"113-B. Presumption as to dowry death\",\"When the question is whether a person has committed the dowry death of a woman and it is shown that soon before her death such woman had been subjected by such person to cruelty or harassment for, or in connection with, any demand for dowry, the Court shall presume that such person had caused the dowry death.\"],\"17\":[\"114. Court may presume existence of certain facts\",\"The Court may presume the existence of any fact which it thinks likely to have happened, regard being had to the common course of natural events, human conduct and public and private business, in their relation to the facts of the particular case.\\r\\n\\r\\nIllustrations\\r\\nThe Court may presume\\u2014\\r\\n(a) that a man who is in the possession of stolen goods soon after the theft is either the thief or has received the goods knowing them to be stolen, unless he can account for his possession;\\r\\n(b) that an accomplice is unworthy of credit, unless he is corroborated in material particulars;\\r\\n(c) that a bill of exchange, accepted or endorsed, was accepted or endorsed for good consideration;\\r\\n(d) that a thing or state of things which has been shown to be in existence within a period shorter than that within which such things or state of things usually cease to exist, is still in existence;\\r\\n(e) that judicial and official acts have been regularly performed;\\r\\n(f) that the common course of business has been followed in particular cases;\\r\\n(g) that evidence which could be and is not produced would, if produced, be unfavourable to the person who withholds it;\\r\\n(h) that if a man refuses to answer a question which he is not compelled to answer by law, the answer, if given, would be unfavourable to him;\\r\\n(i) that when a document creating an obligation is in the hands of the obligor, the obligation has been discharged.\\r\\nBut the Court shall also have regard to such facts as the following, in considering whether such maxims do or do not apply to the particular case before it\\u2014\\r\\nas to illustration (a)\\u2014A shop-keeper has in his till a marked rupee soon after it was stolen, and cannot account for its possession specifically, but is continually receiving rupees in the course of his business;\\r\\nas to illustration (b)\\u2014A, a person of the highest character, is tried for causing a man\'s death by an act of negligence in arranging certain machinery. B, a person of equally good character, who also took part in the arrangement, describes precisely what was done, and admits and explains the common carelessness of A and himself;\\r\\nas to illustration (b)\\u2014a crime is committed by several persons. A, B and C, three of the criminals, are captured on the spot and kept apart from each other. Each gives an account of the crime implicating D, and the accounts corroborate each other in such a manner as to render previous concert highly improbable;\\r\\nas to illustration (c)\\u2014A, the drawer of a bill of exchange, was a man of business. B, the acceptor was a young and ignorant person, completely under A\'s influence.\\r\\nas to illustration (d)\\u2014it is proved that a river ran in a certain course five years ago, but it is known that there have been floods since that time which might change its course;\\r\\nas to illustration (e)\\u2014a judicial act, the regularity of which is in question, was performed under exceptional circumstances;\\r\\nas to illustration (f)\\u2014the question is whether a letter was received. It is shown to have been posted, but the usual course of the post was interrupted by disturbances;\\r\\nas to illustration (g)\\u2014a man refuses to produce a document which would bear on a contract of small importance on which he is sued, but which might also injure the feelings and reputation of his family;\\r\\nas to illustration (h)\\u2014a man refuses to answer a question which he is not compelled by law to answer, but the answer to it might cause loss to him in matters unconnected with the matter in relation to which it is asked;\\r\\nas to illustration (i)\\u2014a bond is in possession of the obligor, but the circumstances of the case are such that he may have stolen it.\\r\\n\"],\"18\":[\"114-A. Presumption as to absence of consent in certain prosecution for rape\",\"In a prosecution for rape under clause (a), clause (b), clause (c), clause (d), clause (e), clause (f), clause (g), clause (h), clause (i), clause (j), clause (k), clause (l), clause (m) or clause (n) of sub-section (2) of Section 376 of the Indian Penal Code (45 of 1860), where sexual intercourse by the accused is proved and the question is whether it was without the consent of the woman alleged to have been raped and such woman states in her evidence before the court that she did not consent, the court shall presume that she did not consent.\"],\"19\":[\"\\u201c114-B. Presumption as to offences committed under Section 354, Section 354-A, Section 354-B, Section 354-C, Section 354-D, Section 509, Section 509-A or Section 509-B of the Indian Penal Code, 1860\",\"When the question is whether a person has committed an offence under Section 354, Section 354-A, Section 354-B, Section 354-C, Section 354-D, Section 509, Section 509-A or Section 509-B of the Indian Penal Code and if the victim deposes before the court that she has been subjected to sexual harassment or her modesty was outraged or she was disrobed or she was stalked or her privacy was intruded or she was sexually harassed by any means, as the case may be, the court may, unless contrary is proved, presume that such offence has been committed by that person.\"]}', 1, '2021-02-02 23:13:45', '2021-02-02 23:57:59'),
(128, 'mqNoGlGswhFTdZpnSP5yDJ05o', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 3 CHAPTER 8', 'ESTOPPEL', '', '', '{\"1\":[\"115. Estoppel\",\"When one person has, by his declaration, act or omission, intentionally caused or permitted another person to believe a thing to be true and to act upon such belief, neither he nor his representative shall be allowed, in any suit or proceeding between himself and such person or his representative, to deny the truth of that thing.\\r\\nIllustration\\r\\nA intentionally and falsely leads B to believe that certain land belongs to A, and thereby induces B to buy and pay for it.\\r\\nThe land afterwards becomes the property of A, and A seeks to set aside the sale on the ground that, at the time of the sale, he had no title. He must not be allowed to prove his want of title.\\r\\n\"],\"2\":[\"116. Estoppel of tenant; and of licensee of person in possession\",\"No tenant of immovable property, or person claiming through such tenant, shall, during the continuance of the tenancy, be permitted to deny that the landlord of such tenant had, at the beginning of the tenancy, a title to such immovable property; and no person who came upon any immovable property by the licence of the person in possession thereof, shall be permitted to deny that such person had a title to such possession at the time when such licence was given.\"],\"3\":[\"117. Estoppel of acceptor of bill of exchange, bailee or licensee\",\"No acceptor of a bill of exchange shall be permitted to deny that the drawer had authority to draw such bill or to endorse it; nor shall any bailee or licensee be permitted to deny that his bailor or licensor had, at the time when the bailment or licence commenced, authority to make such bailment or grant such licence.\"]}', 1, '2021-02-02 23:59:05', '2021-02-03 00:00:08'),
(129, '5i7PdKHWiLLGNfe6csbmxzzWv', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 3 CHAPTER 9', 'WITNESSES', '', '', '{\"1\":[\"118. Who may testify\",\"All persons shall be competent to testify unless the Court considers that they are prevented from understanding the questions put to them, or from giving rational answers to those questions, by tender years, extreme old age, disease, whether of body or mind, or any other cause of the same kind.\"],\"2\":[\"119. Witness unable to communicate verbally\",\"A witness who is unable to speak may give his evidence in any other manner in which he can make it intelligible, as by writing or by signs; but such writing must be written and the signs made in open court, evidence so given shall be deemed to be oral evidence:\"],\"3\":[\"120. Parties to civil suit, and their wives or husbands, Husband or wife of person under criminal trial\",\"In all civil proceedings the parties to the suit, and the husband or wife of any party to the suit, shall be competent witnesses. In criminal proceedings against any person, the husband or wife of such person, respectively, shall be competent witness.\"],\"4\":[\"121. Judges and Magistrates\",\"No Judge or Magistrate shall, except upon the special order of some Court to which he is subordinate, be compelled to answer any questions as to his own conduct in Court as such Judge or Magistrate, or as to anything which came to his knowledge in Court as such Judge or Magistrate; but he may be examined as to other matters which occurred in his presence whilst he was so acting.\\r\\n\\r\\nIllustrations\\r\\n(a) A, on his trial before the Court of Session, says that a deposition was improperly taken by B, the Magistrate. B cannot be compelled to answer questions as to this, except upon the special order of a superior Court.\\r\\n(b) A is accused before the Court of Session of having given false evidence before B, a Magistrate. B cannot be asked what A said, except upon the special order of the superior Court.\\r\\n(c) A is accused before the Court of Session of attempting to murder a police-officer whilst on his trial before B, a Sessions Judge. B may be examined as to what occurred.\\r\\n\"],\"5\":[\"122. Communications during marriage\",\"No person who is or has been married, shall be compelled to disclose any communication made to him during marriage by any person to whom he is or has been married; nor shall he be permitted to disclose any such communication, unless the person who made it, or his representative in interest, consents, except in suits between married persons, or proceedings in which one married person is prosecuted for any crime committed against the other.\"],\"6\":[\"123. Evidence as to affairs of State\",\"No one shall be permitted to give any evidence derived from unpublished official records relating to any affairs of State, except with the permission of the officer at the head of the department concerned, who shall give or withhold such permission as he thinks fit.\"],\"7\":[\"124. Official communications\",\"No public officer shall be compelled to disclose communications made to him in official confidence, when he considers that the public interests would suffer by the disclosure.\"],\"8\":[\"125. Information as to commission of offences\",\"No Magistrate or police-officer, shall be compelled to say whence he got any information as to the commission of any offence, and no revenue-officer shall be compelled to say whence he got any information as to the commission of any offence against the public revenue.\"],\"9\":[\"126. Professional communications\",\"No barrister, attorney, pleader or vakil shall at any time be permitted, unless with his client\'s express consent, to disclose any communication made to him in the course and for the purpose of his employment as such barrister, pleader, attorney or vakil, by or on behalf of his client, or to state the contents or condition of any document with which he has become acquainted in the course and for the purpose of his professional employment, or to disclose any advice given by him to his client in the course and for the purpose of such employment:\\r\\nProvided that nothing in this section shall protect from disclosure\\u2014\\r\\n(1) any such communication made in furtherance of any illegal purpose;\\r\\n(2) any fact observed by any barrister, pleader, attorney or vakil, in the course of his employment as such, showing that any crime or fraud has been committed since the commencement of his employment.\\r\\nIt is immaterial whether the attention of such barrister,  pleader, attorney or vakil was or was not directed to such fact by or on behalf of his client.\\r\\n\\r\\nIllustrations\\r\\n(a) A, a client, says to B, an attorney\\u2014\\u201cI have committed forgery, and I wish you to defend me\\u201d. As the defence of a man known to be guilty is not a criminal purpose, this communication is protected from disclosure.\\r\\n(b) A, a client, says to B, an attorney\\u2014\\u201cI wish to obtain possession of property by the use of a forged deed on which I request you to sue\\u201d.\\r\\nThis communication, being made in furtherance of criminal purpose, is not protected from disclosure.\\r\\n(c) A, being charged with embezzlement, retains B, an attorney, to defend him. In the course of the proceedings, B observes that an entry has been made in A\'s account book, charging A with the sum said to have been embezzled, which entry was not in the book at the commencement of his employment.\\r\\nThis being a fact observed by B in the course of his employment, showing that a fraud has been committed since the commencement of the proceedings, it is not protected from disclosure.\\r\\n\\r\\n\"],\"10\":[\"127. Section 126 to apply to interpreters, etc\",\"The provisions of Section 126 shall apply to interpreters, and the clerks or servants of barristers, pleaders, attorneys and vakils.\"],\"11\":[\"128. Privilege not waived by volunteering evidence\",\"If any party to a suit gives evidence therein at his own instance or otherwise, he shall not be deemed to have consented thereby to such disclosure as is mentioned in Section 126; and if any party to a suit or proceeding calls any such barrister,  pleader, attorney or vakil as a witness, he shall be deemed to have consented to such disclosure only if he questions such barrister, attorney or vakil on matters which, but for such question, he would not be at liberty to disclose.\"],\"12\":[\"129. Confidential communications with legal advisers\",\"No one shall be compelled to disclose to the Court any confidential communication which has taken place between him and his legal professional adviser, unless he offers himself as a witness, in which case he may be compelled to disclose any such communications as may appear to the Court necessary to be known in order to explain any evidence which he has given, but no others\"],\"13\":[\"130. Production of title-deeds of witness not a party\",\"No witness who is not a party to a suit shall be compelled to produce his title-deeds to any property, or any document in virtue of which he holds any property as pledgee or mortgagee, or any document the production of which might tend to criminate him, unless he has agreed in writing to produce them with the person seeking the production of such deeds or some person through whom he claims.\"],\"14\":[\" 131. Production of documents or electronic records which another person, having possession, could refuse to produce\",\"No one shall be compelled to produce documents in his possession or electronic records under his control, which any other person would be entitled to refuse to produce if they were in his possession or control, unless such last-mentioned person consents to their production\"],\"15\":[\"132. Witness not excused from answering on ground that answer will criminate\",\"A witness shall not be excused from answering any question as to any matter relevant to the matter in issue in any suit or in any civil or criminal proceeding, upon the ground that the answer to such question will criminate, or may tend directly or indirectly to criminate, such witness, or that it will expose, or tend directly or indirectly to expose, such witness to a penalty or forfeiture of any kind:\"],\"16\":[\"133. Accomplice\",\"An accomplice shall be a competent witness against an accused person; and a conviction is not illegal merely because it proceeds upon the uncorroborated testimony of an accomplice.\"],\"17\":[\"134. Number of witnesses\",\"No particular number of witnesses shall in any case be required for the proof of any fact.\"]}', 1, '2021-02-03 00:00:51', '2021-02-03 00:08:58'),
(130, 'AXnYYGZVwwJbRgUFyBx9ZwbYQ', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 3 CHAPTER 10', 'THE EXAMINATION OF WITNESSES', '', '', '{\"1\":[\"135. Order of production and examination of witnesses\",\"The order in which witnesses are produced and examined shall be regulated by the law and practice for the time being relating to civil and criminal procedure respectively, and, in the absence of any such law, by the discretion of the Court.\"],\"2\":[\"136. Judge to decide as to admissibility of evidence\",\"When either party proposes to give evidence of any fact, the Judge may ask the party proposing to give the evidence in what manner the alleged fact, if proved, would be relevant; and the Judge shall admit the evidence if he thinks that the fact, if proved, would be relevant, and not otherwise.\\r\\nIf the fact proposed to be proved is one of which evidence is admissible only upon proof of some other fact, such last-mentioned fact must be proved before evidence is given of the fact first mentioned, unless the party undertakes to give proof of such fact and the Court is satisfied with such undertaking.\\r\\nIf the relevancy of one alleged fact depends upon another alleged fact being first proved, the Judge may, in his discretion, either permit evidence of the first fact to be given before the second fact is proved, or require evidence to be given of the second fact before evidence is given of the first fact.\\r\\n\\r\\nIllustrations\\r\\n(a) It is proposed to prove a statement about a relevant fact by a person alleged to be dead, which statement is relevant under Section 32.\\r\\nThe fact that the person is dead must be proved by the person proposing to prove the statement, before evidence is given of the statement.\\r\\n(b) It is proposed to prove, by a copy, the contents of a document said to be lost.\\r\\nThe fact that the original is lost must be proved by the person proposing to produce the copy, before the copy is produced.\\r\\n(c) A is accused of receiving stolen property knowing it to have been stolen.\\r\\nIt is proposed to prove that he denied the possession of the property.\\r\\nThe relevancy of the denial depends on the identity of the property. The Court may, in its discretion, either require the property to be identified before the denial of the possession is proved, or permit the denial of the possession to be proved before the property is identified.\\r\\n(d) It is proposed to prove a fact (A) which is said to have been the cause or effect of a fact in issue. There are several intermediate facts (B, C and D) which must be shown to exist before the fact (A) can be regarded as the cause or effect of the fact in issue. The Court may either permit A to be proved before B, C or D is proved, or may require proof of B, C and D before permitting proof of A.\\r\\n\"],\"3\":[\"137. Examination-in-chief\",\"The examination of a witness by the party who calls him shall be called his examination-in-chief.\\r\\nCross-examination.\\u2014The examination of a witness by the adverse party shall be called his cross-examination.\\r\\nRe-examination.\\u2014The examination of a witness, subsequent to the cross-examination by the party who called him, shall be called his re-examination.\\r\\n\"],\"4\":[\"138. Order of examinations\",\"Witnesses shall be first examined-in chief then (if the adverse party so desires) cross-examined, then (if the party calling him so desires) re-examined.\\r\\nThe examination and cross-examination must relate to relevant facts but the cross-examination need not be confined to the facts to which the witness testified on his examination-in-chief.\\r\\nDirection of re-examination.\\u2014The re-examination shall be directed to the explanation of matters referred to in cross-examination; and if new matter is, by permission of the Court, introduced in re-examination, the adverse party may further cross-examine upon that matter.\\r\\n\"],\"5\":[\"139. Cross-examination of person called to produce a document\",\"A person summoned to produce a document does not become a witness by the mere fact that he produces it, and cannot be cross-examined unless and until he is called as a witness.\"],\"6\":[\"140. Witnesses to character\",\"Witnesses to character may be cross-examined and re-examined.\"],\"7\":[\"141. Leading questions\",\"Any question suggesting the answer which the person putting it wishes or expects to receive, is called a leading question.\"],\"8\":[\"142. When they must not be asked\",\"Leading questions must not, if objected to by the adverse party, be asked in an examination-in-chief, or in a re-examination, except with the permission of the Court.\\r\\nThe Court shall permit leading questions as to matters which are introductory or undisputed, or which have, in its opinion, been already sufficiently proved.\\r\\n\"],\"9\":[\"143. When they may be asked\",\"Leading questions may be asked in cross-examination\"],\"10\":[\"144. Evidence as to matters in writing\",\"Any witness may be asked, whilst under examination, whether any contract, grant or other disposition of property, as to which he is giving evidence, was not contained in a document, and if he says that it was, or if he is about to make any statement as to the contents of any document, which, in the opinion of the Court, ought to be produced, the adverse party may object to such evidence being given until such document is produced, or until facts have been proved which entitle the party who called the witness to give secondary evidence of it.\\r\\n\\r\\nIllustration\\r\\nThe question is, whether A assaulted B.\\r\\nC deposes that he heard A say to D\\u2014\\u201cB wrote a letter accusing me of theft, and I will be revenged on him\\u201d. This statement is relevant, as showing A\'s motive for the assault, and evidence may be given of it, though no other evidence is given about the letter.\\r\\n\"],\"11\":[\"145. Cross-examination as to previous statements in writing\",\"A witness may be cross-examined as to previous statements made by him in writing or reduced into writing, and relevant to matters in question, without such writing being shown to him, or being proved; but, if it is intended to contradict him by the writing, his attention must, before the writing can be proved, be called to those parts of it which are to be used for the purpose of contradicting him\"],\"12\":[\"146. Questions lawful in cross-examination\",\"When a witness is cross-examined, he may, in addition to the questions hereinbefore referred to, be asked any questions which tend\\u2014\\r\\n(1) to test his veracity,\\r\\n(2) to discover who he is and what is his position in life, or\\r\\n(3) to shake his credit, by injuring his character, although the answer to such questions might tend directly or indirectly to criminate him, or might expose or tend directly or indirectly to expose him to a penalty or forfeiture:\\r\\n\"],\"13\":[\"148. Court to decide when question shall be asked and when witness compelled to answer\",\"If any such question relates to a matter not relevant to the suit or proceeding, except insofar as it affects the credit of the witness by injuring his character, the court shall decide whether or not the witness shall be compelled to answer it, and may, if it thinks fit, warn the witness that he is not obliged to answer it. In exercising its discretion, the Court shall have regard to the following considerations\\u2014\\r\\n(1) such questions are proper if they are of such a nature that the truth of the imputation conveyed by them would seriously affect the opinion of the Court as to the credibility of the witness on the matter to which he testifies;\\r\\n(2) such questions are improper if the imputation which they convey relates to matters so remote in time, or of such a character, that the truth of the imputation would not affect, or would affect in a slight degree, the opinion of the Court as to the credibility of the witness on the matter to which he testifies;\\r\\n(3) such questions are improper if there is a great disproportion between the importance of the imputation made against the witness\'s character and the importance of his evidence;\\r\\n(4) the Court may, if it sees fit, draw, from the witness\'s refusal to answer, the inference that the answer if given would be unfavourable.\\r\\n\"],\"14\":[\"149. Question not to be asked without reasonable grounds\",\"No such question as is referred to in Section 148 ought to be asked, unless the person asking it has reasonable grounds for thinking that the imputation which it conveys is well-founded.\\r\\n\\r\\nIllustrations\\r\\n(a) A barrister is instructed by an attorney or vakil that an important witness is a dakait. This is a reasonable ground for asking the witness whether he is a dakait.\\r\\n(b) A pleader is informed by a person in Court that an important witness is a dakait. The informant, on being questioned by the pleader, gives satisfactory reasons for his statement. This is a reasonable ground for asking the witness whether he is a dakait.\\r\\n(c) A witness, of whom nothing whatever is known, is asked at random whether he is a dakait. There are here no reasonable grounds for the question.\\r\\n(d) A witness, of whom nothing whatever is known, being questioned as to his mode of life and means of living, gives unsatisfactory answers. This may be a reasonable ground for asking him if he is a dakait.\\r\\n\"],\"15\":[\"150. Procedure of Court in case of question being asked without reasonable grounds\",\"If the Court is of opinion that any such question was asked without reasonable grounds, it may, if it was asked by any barrister, pleader, vakil or attorney, report the circumstances of the case to the High Court or other authority to which such barrister, pleader, vakil or attorney is subject in the exercise of his profession.\"],\"16\":[\"151. Indecent and scandalous questions\",\"The Court may forbid any questions or inquiries which it regards as indecent or scandalous, although such questions or inquiries may have some bearing on the questions before the Court unless they relate to facts in issue, or to matters necessary to be known in order to determine whether or not the facts in issue existed\"],\"17\":[\"152. Questions intended to insult or annoy\",\"The Court shall forbid any question which appears to it to be intended to insult or annoy, or which, though proper in itself, appears to the Court needlessly offensive in form.\"],\"18\":[\"153. Exclusion of evidence to contradict answers to questions testing veracity\",\"When a witness has been asked and has answered any question which is relevant to the inquiry only insofar as it tends to shake his credit by injuring his character, no evidence shall be given to contradict him; but if he answers falsely, he may afterwards be charged with giving \\r\\n\\r\\nIllustrations\\r\\n(a) A claim against an underwriter is resisted on the ground of fraud.\\r\\nThe claimant is asked whether, in a former transaction, he had not made a fraudulent claim. He denies it.\\r\\nEvidence is offered to show that he did make such a claim.\\r\\nThe evidence is inadmissible.\\r\\n(b) A witness is asked whether he was not dismissed from a situation for dishonesty. He denies it. Evidence is offered to show that he was dismissed for dishonesty.\\r\\nThe evidence is not admissible.\\r\\n(c) A affirms that on a certain day he saw B at Lahore.\\r\\nA is asked whether he himself was not on that day at Calcutta. He denies it.\\r\\nEvidence is offered to show that A was on that day at Calcutta.\\r\\nThe evidence is admissible, not as contradicting A on a fact which affects his credit, but as contradicting the alleged fact that B was seen on the day in question at Lahore.\\r\\nIn each of these cases the witness might, if his denial was false, be charged with giving false evidence.\\r\\n(d) A is asked whether his family has not had a blood feud with the family of B against whom he gives evidence.\\r\\nHe denies it. He may be contradicted on the ground that the question tends to impeach his impartiality.\\r\\n\"],\"19\":[\"154. Question by party to his own witness\",\"(1) The Court may, in its discretion, permit the person who calls a witness to put any questions to him which might be put in cross-examination by the adverse party.\\r\\n (2) Nothing in this section shall disentitle the person so permitted under sub-section (1), to rely on any part of the evidence of such witness\\r\\n\"],\"20\":[\"155. Impeaching credit of witness\",\"The credit of a witness may be impeached in the following ways by the adverse party, or, with the consent of the Court, by the party who calls him\\u2014\\r\\n(1) by the evidence of persons who testify that they, from their knowledge of the witness, believe him to be unworthy of credit;\\r\\n(2) by proof that the witness has been bribed, or has accepted the offer of a bribe, or has received any other corrupt inducement to give his evidence;\\r\\n(3) by proof of former statements inconsistent with any part of his evidence which is liable to be contradicted.\\r\\n\\r\\nIllustrations\\r\\n(a) A sues B for the price of goods sold and delivered to B. C says that he delivered the goods to B. Evidence is offered to show that, on a previous occasion, he said that he had not delivered the goods to B.\\r\\nThe evidence is admissible.\\r\\n(b) A is indicted for the murder of B.\\r\\nC says that B, when dying, declared that A had given B the wound of which he died.\\r\\nEvidence is offered to show that, on a previous occasion, C said that the wound was not given by A or in his presence.\\r\\nThe evidence is admissible.\\r\\n\"],\"21\":[\"156. Questions tending to corroborate evidence of relevant fact, admissible\",\"When a witness whom it is intended to corroborate gives evidence of any relevant fact, he may be questioned as to any other circumstances which he observed at or near to the time or place at which such relevant fact occurred, if the Court is of opinion that such circumstances, if proved, would corroborate the testimony of the witness as to the relevant fact which he testifies.\\r\\n\\r\\nIllustration\\r\\nA, an accomplice, gives an account of a robbery in which he took part. He describes various incidents unconnected with the robbery which occurred on his way to and from the place where it was committed.\\r\\nIndependent evidence of these facts may be given in order to corroborate his evidence as to the robbery itself.\\r\\n\"],\"22\":[\"157. Former statements of witness may be proved to corroborate later testimony as to same fact\",\"In order to corroborate the testimony of a witness, any former statement made by such witness relating to the same fact, at or about the time when the fact took place, or before any authority legally competent to investigate the fact, may be proved.\"],\"23\":[\"158. What matters may be proved in connection with proved statement relevant under Section 32 or 33\",\".\\u2014Whenever any statement, relevant under Section 32 or 33, is proved, all matters may be proved, either in order to contradict or to corroborate it, or in order to impeach or confirm the credit of the person by whom it was made, which might have been proved if that person had been called as a witness and had denied upon cross-examination the truth of the matter suggested.\"],\"24\":[\"159. Refreshing memory\",\"A witness may, while under examination, refresh his memory by referring to any writing made by himself at the time of the transaction concerning which he is questioned, or so soon afterwards that the Court considers it likely that the transaction was at that time fresh in his memory.\\r\\nThe witness may also refer to any such writing made by any other person, and read by the witness within the time aforesaid, if when he read it he knew it to be correct.\\r\\nWhen witness may use copy of document to refresh memory.\\u2014Whenever a witness may refresh his memory by reference to any document, he may, with the permission of the Court, refer to a copy of such document:\\r\\nProvided the Court be satisfied that there is sufficient reason for the non-production of the original.\\r\\nAn expert may refresh his memory by reference to professional treatises.\\r\\n\"],\"25\":[\"160. Testimony to facts stated in document mentioned in Section 159\",\"A witness may also testify to facts mentioned in any such document as is mentioned in Section 159, although he has no specific recollection of the facts themselves, if he is sure that the facts were correctly recorded in the document.\\r\\n\\r\\nIllustration\\r\\nA book-keeper may testify to facts recorded by him in books regularly kept in the course of business, if he knows that the books were correctly kept, although he has forgotten the particular transactions entered.\\r\\n\"],\"26\":[\"161. Right of adverse party as to writing used to refresh memory\",\"Any writing referred to under the provisions of the two last preceding sections must be produced and shown to the adverse party if he requires it; such party may, if he pleases, cross-examine the witness thereupon.\"],\"27\":[\"162. Production of documents\",\"A witness summoned to produce a document shall, if it is in his possession or power, bring it to the Court, notwithstanding any objection which there may be to its production or to its admissibility. The validity of any such objection shall be decided on by the Court.\\r\\nThe Court, if it sees fit, may inspect the document, unless it refers to matters of State, or take other evidence to enable it to determine on its admissibility.\\r\\n\"],\"28\":[\"163. Giving, as evidence, of document called for and produced on notice\",\"When a party calls for a document which he has given the other party notice to produce, and such document is produced and inspected by the party calling for its production, he is bound to give it as evidence if the party producing it requires him to do so.\"],\"29\":[\"164. Using, as evidence, of document, production of which was refused on notice\",\"When a party refuses to produce a document which he has had notice to produce, he cannot afterwards use the document as evidence without the consent of the other party or the order of the Court.\\r\\n\\r\\nIllustration\\r\\nA sues B on an agreement and gives B notice to produce it. At the trial, A calls for the document and B refuses to produce it. A gives secondary evidence of its contents. B seeks to produce the document itself to contradict the secondary evidence given by A, or in order to show that the agreement is not stamped. He cannot do so.\\r\\n\"],\"30\":[\"165. Judge\'s power to put questions or order production\",\"The Judge may, in order to discover or to obtain proper proof of relevant facts, ask any question he pleases, in any form, at any time, of any witness, or of the parties, about any fact relevant or irrelevant; and may order the production of any document or thing; and neither the parties nor their agents shall be entitled to make any objection to any such question or order, nor, without the leave of the Court, to cross-examine any witness upon any answer given in reply to any such question:\\r\\nProvided that the judgment must be based upon facts declared by this Act to be relevant, and duly proved:\\r\\nProvided also that this section shall not authorize any Judge to compel any witness to answer any question, or to produce any document which such witness would be entitled to refuse to answer or produce under Sections 121 to 131, both inclusive, if the question were asked or the document were called for by the adverse party; nor shall the Judge ask any question which it would be improper for any other person to ask under Section 148 or 149; nor shall he dispense with primary evidence of any document, except in the cases hereinbefore excepted.\\r\\n\"],\"31\":[\"166. Power of jury or assessors to put questions\",\"In cases tried by jury or with assessors, the jury or assessors may put any questions to the witnesses, through or by leave of the Judge, which the Judge himself might put and which he considers proper.\"]}', 1, '2021-02-03 00:12:53', '2021-02-03 00:23:55'),
(131, 'eiJJFn5PsmZfQWD1RA9hudFwR', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'Part 3 CHAPTER 11', 'IMPROPER ADMISSION AND REJECTION OF EVIDENCE', '', '', '{\"1\":[\"167. No new trial for improper admission or rejection of evidence\",\"The improper admission or rejection of evidence shall not be ground of itself for a new trial or reversal of any decision in any case, if it shall appear to the Court before which such objection is raised that, independently of the evidence objected to and admitted, there was sufficient evidence to justify the decision, or that, if the rejected evidence had been received, it ought not to have varied the decision.\"]}', 1, '2021-02-03 00:24:50', '2021-02-03 00:24:50');
INSERT INTO `sections` (`sec_id`, `sec_key`, `sec_ba_key`, `sec_title`, `sec_particular`, `sec_subtitle`, `sec_subparticular`, `sec_data`, `sec_status`, `sec_date_added`, `sec_date_updated`) VALUES
(132, 'TgxfZlcTbrwpkerGX3Hgqba4P', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'SCHEDULE', 'Enactments Repealed', '', '', '{\"1\":[\"Enactments Repealed\",\"1. For Statement of Objects and Reasons, see Gazette of India, 1868, p. 1574; for the draft or preliminary Report of the Select Committee, dated 31st March, 1871, see Gazette of India, 1871, Pt. V, p. 273 and for the Second Report of the Select Committee, dated 30th January, 1872, see Gazette of India, 1872, Pt. V, p. 34; for discussions in Council, see Gazette of India, 1868, Supplement, pp. 1060 and 1209, Gazette of India, 1871, Extra. Supplement, p. 42 and Supplement, p. 1641, and Gazette of India, 1872, pp. 136 and 230.\\r\\n2. The Act now extends to the union territories of (a) Dadra and Nagar Haveli (vide Reg. 6 of 1963)(w.e.f. 1-7-1965)(b) Goa, Daman and Diu (vide Ref. 11 of 1963)(c) Pondicherry (vide Reg. 7 of 1963)(w.e.f. 1-10-1963) and (d) Lakshdweep (vide Reg. 8 of 1965).\\r\\n3. Subs. by the A.O. 1950, for \\u201call the Provinces of India\\u201d which had been subs. by the A.O. 1948, for \\u201cthe whole of British India\\u201d.\\r\\n4. The words \\u201cexcept the State of Jammu and Kashmir\\u201d omitted by Act 34 of 2019, Ss. 95 & 96 and Sch. V (w.e.f. 31-10-2019).\\r\\n5. Ins. by Act 18 of 1919, S. 2 and Sch. I. See S. 127 of the Army Act (44 and 45 Vict., C. 58).\\r\\n6. Ins. by Act 35 of 1934, S. 2 and Sch. I.\\r\\n7. The words \\u201cthat Act as modified by\\u201d repealed by the A.O. 1950.\\r\\n8. See the Navy Act, 1957 (64 of 1957).\\r\\n9. Ins. by Act 10 of 1927, S. 2 and Sch. I.\\r\\n10. As to practice relating to affidavits, see Code of Civil Procedure, 1908 (Act 5 of 1908), S. 30(c) and Sch. I, Or. XIX, See also Code of Criminal Procedure, 1973 (Act 2 of 1974), Section 295 & 297.\\r\\n11. Repealed by the Repealing Act, 1938 (1 of 1938), S. 2 and Sch. Prior to repeal it read as:\\r\\n\\u201c2. Repeal of Enactments.\\u2014On and from that day the following laws shall be repealed:\\u2014\\r\\n(1) All rules of evidence not contained in any Statute, Act or Regulation in force in any part of British India;\\r\\n(2) All such rules, laws and regulations as have acquired the force of law under the twenty-fifth section of \\u2018The Indian Councils\\u2019 Act, 1861, in so far as they relate to any matter herein provided for; and\\r\\n(3) The enactments mentioned in the schedule hereto, to the extent specified in the third column of the said Schedule.\\r\\nBut nothing herein contained shall be deemed to affect any provision of any Statute, Act or Regulation in force in any part of British India and not hereby expressly repealed.\\u201d\\r\\n12. Cf. the Code of Civil Procedure, 1908 (Act 5 of 1908), S. 2, the Indian Penal Code (Act 45 of 1860), S. 19; and, for a definition of \\u201cDistrict Judge\\u201d, the General Clauses Act, 1897 (10 of 1897), S. 3(17).\\r\\n13. Cf. the General Clauses Act, 1897 (10 of 1897), S. 3(32) and Code of Criminal Procedure, 1973 (Act 2 of 1974).\\r\\n14. See now Code of Civil Procedure, 1908 (Act 5 of 1908); as to settlement of issues, see Sch. I, Order XIV.\\r\\n15. Cf. the Indian Penal Code (Act 45 of 1860), S. 29 and the General Clauses Act, 1897 (10 of 1897), S. 3(18).\\r\\n16. Cf. definition of \\u201cwriting\\u201d in the General Clauses Act, 1897 (10 of 1897), S. 3(65).\\r\\n17. Cf. definition of \\u201cwriting\\u201d in the General Clauses Act, 1897 (10 of 1897), S. 3(65).\\r\\n18. Ins. by Act 21 of 2000, S. 92 & Sch. H (w.e.f. 17-10-2000).\\r\\n19. Subs. by Act 3 of 1951, S. 3 and Sch., for the definition of \\u201cState\\u201d and \\u201cStates\\u201d which was inserted by the A.O. 1950.\\r\\n* Central laws now extended and applicable to the Union Territory of Jammu and Kashmir. [Vide S.O. 1123(E), dt. 18-3-2020 (w.e.f. 31-10-2019)].\\r\\n20. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n21. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n22. Subs. for \\u201cDigital Signature Certificate\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n23. See now the Code of Civil Procedure, 1908 (5 of 1908).\\r\\n24. See now the Code of Civil Procedure, 1908 (5 of 1908).\\r\\n25. Subs. for \\u201cQueen\\u201d by the A.O. 1950.\\r\\n26. Subs. for \\u201cQueen\\u201d by the A.O. 1950.\\r\\n27. Subs. by Act 3 of 1891, S. 1(1), for the original Explanation. Prior to substitution it read as:\\r\\n\\u201cExplanation.\\u2014A fact relevant as showing the existence of a relevant state of mind must show that it exists, not generally, but in reference to the particular matter in question.\\u201d\\r\\n28. Subs. by Act 3 of 1891, S. 1(2), for the original illustration (b). Prior to substitution it read as:\\r\\n\\u201c(b) A is accused of fraudulently delivering to another person a piece of counterfeit coin which, at the time when he delivered it, he knew to be counterfeit.\\r\\nThe fact that, at the time of its delivery, A was possessed of a number of other pieces of counterfeit coin is relevant.\\u201d\\r\\n29. Ins. by Act 3 of 1891, S. 2.\\r\\n30. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n31. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n32. For prohibition of such inducements, etc., see the Code of Criminal Procedure, 1973 (Act 2 of 1974), Section 316.\\r\\n33. As to statements made to a police officer investigating a case, see the Code of Criminal Procedure, 1973 (Act 2 of 1974), S. 162.\\r\\n34. A Coroner has been declared to be a Magistrate for the purposes of this section, see the Coroners Act, 1871 (1 of 1871), S. 20.\\r\\n35. Ins. by Act 3 of 1891, S. 3.\\r\\n36. The words \\u201cor in Burma\\u201d omitted by the A.O. 1937.\\r\\n37. See now the Code of Criminal Procedure, 1973 (Act 2 of 1974).\\r\\n38. Ins. by Act 3 of 1891, S. 4.\\r\\n39. Cf. the Indian Penal Code (Act 45 of 1860), Explanation 4 to Section 108.\\r\\n40. Ins. by Act 18 of 1872, S. 2.\\r\\n41. Ins. by Act 18 of 1872, S. 2.\\r\\n42. Ins. by Act 18 of 1872, S. 2.\\r\\n43. Subs. for \\u201cEntries in the books of account\\u201d by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n44. Subs. for \\u201cEntries in the books of account\\u201d by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n45. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n46. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n47. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n48. Subs. by the A.O. 1948, for \\u201cany Govt. in British India\\u201d.\\r\\n49. Subs. by the A.O. 1950, for \\u201cProvincial\\u201d.\\r\\n50. Ins. by the A.O. 1950.\\r\\n51. The original words were \\u201cAct of the Governor General of India in Council, or of the Governors in Council of Madras or Bombay, or of the Lieutenant-Governor in Council of Bengal or in a notification of the Govt. appearing in the Gazette of India, or in the Gazette of any L.G. or in any printed paper purporting to be the London Gazette or the Govt. Gazette of any colony or possession of the Queen, is a relevant fact\\u201d. This was amended first by the Repealing and Amending Act, 1914 (10 of 1914), and then by the A.O. 1937, the A.O. 1948 and the A.O. 1950 to read as above.\\r\\n52. Subs. by Act 3 of 1951, S. 3 and Sch., for \\u201can Act of the Legislature of a Part A State or a Part C State\\u201d.\\r\\n53. The last paragraph added by Act 5 of 1899, S. 2 and omitted by Act 10 of 1914, S. 3 and Sch. II.\\r\\n54. Subs. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000). Original Section 39 read as:\\r\\n\\u201c39. What evidence to be given when statement forms part of a conversation, document, book or series of letters or papers.\\u2014When any statement of which evidence is given forms part of a longer statement, or of a conversation or part of an isolated document, or is contained in a document which forms part of a book, or of a connected series of letters or papers, evidence shall be given of so much and no more of the statement, conversation, document, book or series of letters or papers as the Court considers necessary in that particular case to the full understanding of the nature and effect of the statement, and of the circumstances under which it was made.\\u201d\\r\\n55. Ins. by Act 18 of 1872, S. 3.\\r\\n56. Ins. by Act 18 of 1872, S. 3.\\r\\n57. Ins. by Act 18 of 1872, S. 3.\\r\\n58. Ins. by Act 3 of 1891, S. 5.\\r\\n59. Ins. by Act 5 of 1899, S. 3. For discussion in Council as to whether \\u201cfinger impressions\\u201d includes \\u201cthumb impression,\\u201d see Gazette of India, 1898, Part VI, p. 24\\r\\n60. Ins. by Act 18 of 1872, S. 4.\\r\\n61. Ins. by Act 5 of 1899, S. 3. For discussion in Council as to whether \\u201cfinger impressions\\u201d includes \\u201cthumb impression,\\u201d see Gazette of India, 1898, Part VI, p. 24\\r\\n62. Ins. by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n63. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n64. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n65. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n66. Subs. for \\u201cDigital Signature Certificate\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n67. Ins. by Act 13 of 2013, S. 25 (w.r.e.f. 3-2-2013).\\r\\n68. Subs. for \\u201cSection 376-A, Section 376-B, Section 376-C, Section 376-D\\u201d by Act 22 of 2018, S. 8 (w.r.e.f. 21-4-2018).\\r\\n69. Subs. by Act 3 of 1891, S. 6, for the original section. Prior to substitution it read as:\\r\\n\\u201c54. In criminal proceedings previous conviction relevant, but not previous bad character, except in reply.\\u2014In criminal proceedings the fact that the accused person has been previously convicted of any offence is relevant, but the fact that he has a bad character is irrelevant, unless evidence has been given that he has a good character, in which case it becomes relevant.\\r\\nExplanation.\\u2014This section does not apply to cases in which the bad character of any person is itself a fact in issue.\\u201d.\\r\\n70. Ins. by Act 3 of 1891, S. 7.\\r\\n71. Subs. by the A.O. 1950, for the former paragraph. Prior to substitution it read as:\\r\\n\\u201c(1) All laws or rules having the force of law now or heretofore in force, or hereafter to be in force, in any part of British India;\\u201d\\r\\n72. Ins. by the A.O. 1950.\\r\\n73. Ins. by the A.O. 1950.\\r\\n74. Subs. for \\u201cHer Majesty\'s\\u201d by the A.O. 1950.\\r\\n75. Subs. for \\u201cor Navy\\u201d by Act 10 of 1927, S. 2 and Sch. I.\\r\\n76. Subs. for the original para (4) by the A.O. 1950. Prior to substitution it read as:\\r\\n\\u201c(4) The course of proceeding of Parliament and of the Councils for the purposes of making Laws and Regulations established under the Indian Councils\' Act, or any other law for the time being relating thereto.\\r\\nExplanation.\\u2014The word \\u2018Parliament\\u2019, in clauses (2) and (4), includes\\u2014\\r\\n1. The Parliament of the United Kingdom of Great Britain and Ireland;\\r\\n2. The Parliament of Great Britain;\\r\\n3. The Parliament of England;\\r\\n4. The Parliament of Scotland, and\\r\\n5. The Parliament of Ireland.\\u201d\\r\\n77. Subs. for \\u201cCourts of British India\\u201d by the A.O. 1948.\\r\\n78. Subs. for \\u201cThe States\\u201d by Act 3 of 1951, S. 3 and Sch. I.\\r\\n79. Subs. for \\u201cThe States\\u201d by Act 3 of 1951, S. 3 and Sch. I.\\r\\n80. Subs. for \\u201cthe G.G. or any L.G. in Council\\u201d by the A.O. 1937.\\r\\n81. Subs. for \\u201cany Act of Parliament or other\\u201d by the A.O. 1950.\\r\\n82. Subs. for \\u201cThe States\\u201d by Act 3 of 1951, S. 3 and Sch. I.\\r\\n83. Subs. for \\u201cProvince\\u201d by the A.O. 1950.\\r\\n84. Subs. for \\u201cthe Gazette of India or in the Official Gazette of any L.G.\\u201d by the A.O. 1937.\\r\\n85. Subs. for \\u201cThe British Crown\\u201d by the A.O. 1950.\\r\\n86. Subs. for \\u201cThe British Crown\\u201d by the A.O. 1950.\\r\\n87. Subs. for \\u201cThe British Crown\\u201d by the A.O. 1950.\\r\\n88. Ins. by Act 18 of 1872, S. 5.\\r\\n89. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n90. See Section 76, infra.\\r\\n91. Subs. for \\u201cthe States\\u201d by Act 3 of 1951, S. 3 and Sch.\\r\\n92. Cf. the Bankers\' Books Evidence Act, 1891 (18 of 1891), S. 4.\\r\\n93. Ss. 65-A and 65-B Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n94. Ins. by Act 18 of 1872, S. 6.\\r\\n95. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n96. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n97. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n98. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n99. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n100. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n101. Ins. by Act 31 of 1926, S. 2.\\r\\n102. Ins. by Act 5 of 1899, S. 3.\\r\\n103. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n104. The original words \\u201cwhether of British India, or of any other part of Her Majesty\'s dominions\\u201d have successively been amended by the A.O. 1948 and the A.O. 1950 to read as above.\\r\\n105. Subs. for \\u201cin any Province\\u201d by the A.O. 1950.\\r\\n106. A village-officer in the Punjab has been declared for the purposes of this Act to be a public officer having the custody of a public document\\u2014see the Punjab Land Revenue Act, 1887 (17 of 1887), S. 151(2).\\r\\n107. Subs. for \\u201cthe Executive Govt. of British India\\u201d by the A.O. 1937.\\r\\n108. Ins. by the A.O. 1937.\\r\\n109. Subs. for \\u201cProvincial Government\\u201d by the A.O. 1950.\\r\\n110. Subs. for \\u201cProvincial Government\\u201d by the A.O. 1950.\\r\\n111. Ins. by the A.O. 1937.\\r\\n112. Subs. for \\u201cby order of Govt.\\u201d by the A.O. 1937.\\r\\n113. The words \\u201cHer Majesty\\u201d shall stand unmodified, vide the A.O. 1950.\\r\\n114. The words \\u201cHer Majesty\\u201d shall stand unmodified, vide the A.O. 1950.\\r\\n115. Subs. for \\u201cPublic Act of the Governor General of India in Council\\u201d by the A.O. 1937.\\r\\n116. Subs. for \\u201ca Province\\u201d by the A.O. 1950.\\r\\n117. Subs. for \\u201ca British Consul\\u201d by the A.O. 1950.\\r\\n118. Ins. by the A.O. 1948.\\r\\n119. The original words beginning from \\u201cin British India\\u201d and ending with the words \\u201cto be genuine\\u201d have been successively amended by the A.O. 1937, A.O. 1948 and A.O. 1950 to read as above.\\r\\n120. Subs. by Act 3 of 1951, S. 3 and Sch. for \\u201cin a Part B State\\u201d.\\r\\n121. Subs. for \\u201cthe Gazette of India, or the Govt. Gazette of any L.G. or\\u201d by the A.O. 1937.\\r\\n122. Ins. by the A.O. 1950.\\r\\n123. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n124. The original word \\u201cGovernment\\u201d has successively been amended by the A.O. 1937, A.O. 1948, Act 40 of 1949 and the A.O. 1950 to read as above.\\r\\n125. Subs. by the A.O. 1950 for \\u201cBritish\\u201d.\\r\\n126. The words \\u201cof Her Majesty, or\\u201d repealed by the A.O. 1950.\\r\\n127. Subs. by the A.O. 1937 for \\u201cG. of I\\u201d.\\r\\n128. Ss. 85-A to 85-C ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n129. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n130. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n131. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n132. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n133. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n134. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n135. Subs. for \\u201cdigital signatures\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n136. Subs. for \\u201cDigital Signature Certificates\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n137. Subs. for \\u201cDigital Signature Certificate\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n138. Subs. for \\u201cany country not forming part\\u201d by the A.O. 1950.\\r\\n139. The words \\u201ca Part B State or of\\u201d omitted by Act 3 of 1951, S. 3 and Sch.\\r\\n140. The words \\u201cHer Majesty or of\\u201d repealed by the A.O. 1950.\\r\\n141. Subs. by the A.O. 1937 for \\u201cG. of I\\u201d.\\r\\n142. Subs. for \\u201cresident in\\u201d by Act 3 of 1891, S. 8.\\r\\n143. Subs. for \\u201csuch Part B State or country\\u201d by the Act 3 of 1951, S. 3 and Sch.\\r\\n144. Subs. for \\u201cthat State or Country\\u201d by the by the Act 3 of 1951, S. 3 and Sch.\\r\\n145. Subs. by Act 5 of 1899, S. 4, for the para added by Act 3 of 1891, S. 3.\\r\\n146. The words \\u201ca Part B State or\\u201d which were Ins. by the A.O. 1950, omitted of Act 3 of 1951, S. 3 and Sch.\\r\\n147. Ins. by the A.O. 1950.\\r\\n148. Subs. for \\u201cclause (40)\\u201d by the A.O. 1950.\\r\\n149. Subs. for \\u201cG. of I\\u201d by the A.O. 1937.\\r\\n150. Subs. for \\u201cin and for that Part B State or country\\u201d by Act 3 of 1951, S. 3 and Sch.\\r\\n151. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n152. Ins. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000).\\r\\n153. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n154. Subs. for \\u201cdigital signature\\u201d by Act 10 of 2009, S. 52 (w.e.f. 27-10-2009).\\r\\n155. Where, however, a Criminal Court finds that a confession or other statement of an accused person has not been recorded in the manner prescribed, evidence may be taken that the recorded statement was duly made\\u2014see the Code of Criminal Procedure, 1973 (2 of 1974), S. 463.\\r\\n156. Subs. by Act 18 of 1872, S. 7, for \\u201cunder the Indian Succession Act\\u201d.\\r\\n157. Subs. by Act 3 of 1951, S. 3, and Sch., for \\u201cthe States\\u201d.\\r\\n158. Subs. for \\u201cwant of failure\\u201d by Act 18 of 1872, S. 8.\\r\\n159. See now the Indian Succession Act, 1925 (39 of 1925), Pt. VI, Ch. VI.\\r\\n160. Sic. In the Act as published in Gazette of India, 1872, Pt. IV, p. 1, there is no illustration (b).\\r\\n161. Subs. for \\u201cWhen\\u201d by Act 18 of 1872, S. 9.\\r\\n162. Subs. for \\u201con\\u201d by Act 18 of 1872, S. 9.\\r\\n163. Ins. by Act 61 of 1984, S. 20 (w.e.f. 14-7-1984).\\r\\n164. Subs. for \\u201cGazette of India\\u201d by the A.O. 1937.\\r\\n165. Ins. by the A.O. 1937 (Part III of the Govt. of India Act, 1935, came into force on 1st April, 1937).\\r\\n166. Ins. by Act 46 of 1983, S. 7.\\r\\n167. Ins. by Act 43 of 1986, S. 12 (w.e.f. 19-11-1986).\\r\\n168. Subs. by Act 13 of 2013, S. 26 (w.r.e.f. 3-2-2013). Prior to substitution it read as:\\r\\n\\u201c114-A. Presumption as to absence of consent in certain prosecutions for rape.\\u2014In a prosecution for rape under clause (a) or clause (b) or clause (c) or clause (d) or clause (e) or clause (g) of sub-section (2) of Section 376 of the Indian Penal Code (45 of 1860), where sexual intercourse by the accused is proved and the question is whether it was without the consent of the woman alleged to have been raped and she states in her evidence before the Court that she did not consent, the Court shall presume that she did not consent.\\u201d\\r\\n169. Subs. by Act 13 of 2013, S. 27 (w.r.e.f. 3-2-2013). Prior to substitution it read as:\\r\\n\\u201c119. Dumb witnesses.\\u2014A witness who is unable to speak may give his evidence in any other manner in which he can make it intelligible, as by writing or by signs; but such writing must be written and the signs made in open Court. Evidence so given shall be deemed to be oral evidence.\\u201d\\r\\n170. Subs. by Act 3 of 1887, S. 1, for the original S. 125. Prior to substitution it read as:\\r\\n\\u201c125. Information as to commission of offences.\\u2014No Magistrate or police-officer, shall be compelled to say whence he got any information as to the commission of any offence.\\u201d\\r\\n171. Subs. for \\u201ccriminal\\u201d by Act 18 of 1872, S. 10.\\r\\n172. Ins. by Act 18 of 1872, S. 10.\\r\\n173. Ins. by Act 18 of 1872, S. 10.\\r\\n174. Subs. by Act 21 of 2000, S. 92 & Sch. II (w.e.f. 17-10-2000). Prior to substitution it read as:\\r\\n\\u201c131. Production of documents which another person, having possession, could refuse to produce.\\u2014No one shall be compelled to produce documents in his possession, which any other person would be entitled to refuse to produce if they were in his possession, unless such last-mentioned person consents to their production.\\u201d.\\r\\n175. As to the application of S. 145 to police-diaries, see the Code of Criminal Procedure, 1973 (2 of 1974), S. 172.\\r\\n176. Subs. by Act 13 of 2013, S. 28 (w.r.e.f. 3-2-2013). Prior to substitution it read as:\\r\\n\\u201cProvided that in a prosecution for rape or attempt to commit rape, it shall not be permissible to put questions in the cross-examination of the prosecutrix as to her general immoral character.\\u201d\\r\\n177. Subs. for \\u201cSection 376-A, Section 376-B, Section 376-C, Section 376-D\\u201d by Act 22 of 2018, S. 9 (w.r.e.f. 21-4-2018).\\r\\n178. Renumbered as sub-section (1) by Act 2 of 2006, S. 9 (w.e.f. 16-4-2006).\\r\\n179. Ins. by Act 2 of 2006, S. 9 (w.e.f. 16-4-2006).\\r\\n180. Subs. for \\u201chad\\u201d by Act 18 of 1872, S. 11.\\r\\n181. Omitted by Act 4 of 2003, S. 3. Prior to omission clause (4) read as follows:\\r\\n\\u201c(4) when a man is prosecuted for rape or an attempt to ravish, it may be shown that the prosecutrix was of generally immoral character.\\u201d\\r\\n182. As to the application of S. 161 to police-diaries, see the Code of Criminal Procedure, 1973 (2 of 1974), S. 172.\\r\\n183. Repealed by the Repealing Act, 1938 (1 of 1938), S. 2 and Sch. Prior to repeal it read as:\\r\\n\"]}', 1, '2021-02-03 00:25:56', '2021-02-03 00:25:56'),
(133, 'yN283jlrGav26wbAVNMWPNqpD', 'KQvGdGhQhOGl4Qef8qx8n9Hxl', 'SCHEDULE', 'Enactments Repealed', '', '', '{\"1\":[\"Enactments Repealed\",\"Number and Year\\tTitle\\tExtent of repeal\\r\\nStat. 26 Geo. III, cap. 57.\\tFor the further regulation of the trial of persons accused of certain offences committed in the East Indies; for repealing so much of an Act, made in the twenty-fourth year of the reign of his present Majesty (intituled \\u2018An Act for the better regulation and management of the affairs of the East India Company, and of the British possessions in India, and for establishing a court of judicature for the more speedy and effectual trial of persons accused of offences committed in the East Indies\\u2019), as requires the servants of the East India Company to deliver inventories of their estates and effects; for rendering the laws more effectual against persons unlawfully resorting to the East Indies; and for the more easy proof, in certain cases, of deeds and writings executed in Great Britain or India.\\tSection thirty-eight so far as it relates to Courts of justice in the East Indies.\\r\\nStat. 14 & 15 Vic., cap. 99.\\tTo amend the Law of Evidence\\tSection eleven and so much of section nineteen as relates to British India.\\r\\nAct XV of 1852\\tTo amend the Law of Evidence\\tSo much as has not been heretofore repealed.\\r\\nAct XIX of 1853\\tTo amend the Law of Evidence in the Civil Courts of the East India Company in the Bengal Presidency\\tSection nineteen.\\r\\nAct II of 1855\\tFor the further improvement of the Law of Evidence\\tSo much as has not been heretofore repealed.\\r\\nAct XXV of 1861\\tFor simplifying the Procedure of the Courts of Criminal Judicature not established by Royal Charter\\tSection two hundred and thirty-seven.\\r\\nAct I of 1868\\tThe General Clauses\' Act, 1868\\tSections seven and eight.\\u201d\\r\\n\\r\\n\\u00a9 EBC Publishing Pvt.Ltd., Lucknow.\\r\\n\\r\\n\"]}', 1, '2021-02-03 00:27:02', '2021-02-03 00:27:02'),
(134, 'ylVd8kOCkSoGHYgJFleJYTZzh', 'P96rJaFer8HqOFvDJ0oFBfy3W', 'Part 1', 'PRELIMINARY', '', '', '{\"1\":[\"1. Short title, extent and commencement\",\"(1) This Act may be called the Specific Relief Act, 1963.\"],\"2\":[\"2. Definitions\",\"In this Act, unless the context otherwise requires,\\u2014\\r\\n(a) \\u201cobligation\\u201d includes every duty enforceable by law;\\r\\n(b) \\u201csettlement\\u201d means an instrument [other than a will or codicil as defined by the Indian Succession Act, 1925 (39 of 1925)] whereby the destination or devolution of successive interests in moveable or immovable property is disposed of or is agreed to be disposed of;\\r\\n(c) \\u201ctrust\\u201d has the same meaning as in Section 3 of the Indian Trusts Act, 1882 (2 of 1882), and includes an obligation in the nature of a trust within the meaning of Chapter IX of that Act;\\r\\n(d) \\u201ctrustee\\u201d includes every person holding property in trust;\\r\\n(e) all other words and expressions used herein but not defined, and defined in the Indian Contract Act, 1872 (9 of 1872), have the meanings respectively assigned to them in that Act.\\r\\n3. Savings.\\u2014Except as otherwise provided herein, nothing in this Act shall be deemed\\u2014\\r\\n(a) to deprive any person of any right to relief, other than specific performance, which he may have under any contract; or\\r\\n(b) to affect the operation of the Indian Registration Act, 1908 (16 of 1908), on documents.\\r\\n4. Specific relief to be granted only for enforcing individual civil rights and not for enforcing penal laws.\\u2014Specific relief can be granted only for the purpose of enforcing individual civil rights and not for the mere purpose of enforcing a penal law.\\r\\n\"],\"3\":[\"3. Savings\",\"Except as otherwise provided herein, nothing in this Act shall be deemed\\u2014\\r\\n(a) to deprive any person of any right to relief, other than specific performance, which he may have under any contract; or\\r\\n(b) to affect the operation of the Indian Registration Act, 1908 (16 of 1908), on documents.\\r\\n\"],\"4\":[\"4. Specific relief to be granted only for enforcing individual civil rights and not for enforcing penal laws\",\"Specific relief can be granted only for the purpose of enforcing individual civil rights and not for the mere purpose of enforcing a penal law.\"]}', 1, '2021-02-03 00:58:37', '2021-02-03 01:01:13'),
(135, 'h5zf0jFpkyJbPXgehjohzrMVM', 'P96rJaFer8HqOFvDJ0oFBfy3W', 'Part 2 CHAPTER 1', 'RECOVERING POSSESSION OF PROPERTY', '', '', '{\"1\":[\"5. Recovery of specific immovable property\",\"A person entitled to the possession of specific immovable property may recover it in the manner provided by the Code of Civil Procedure, 1908 (5 of 1908).\"],\"2\":[\"6. Suit by person dispossessed of immovable property\",\".\\u2014(1) If any person is dispossessed without his consent of immovable property otherwise than in due course of law, he or any person 4[through whom he has been in possession or any person] claiming through him may, by suit, recover possession thereof, notwithstanding any other title that may be set up in such suit.\\r\\n(2) No suit under this section shall be brought\\u2014\\r\\n(a) after the expiry of six months from the date of dispossession; or\\r\\n(b) against the Government.\\r\\n(3) No appeal shall lie from any order or decree passed in any suit instituted under this section, nor shall any review of any such order or decree be allowed.\\r\\n(4) Nothing in this section shall bar any person from suit to establish his title to such property and to recover possession thereof.\\r\\n\"],\"3\":[\"7. Recovery of specific moveable property\",\"A person entitled to the possession of specific moveable property may recover it in the manner provided by the Code of Civil Procedure, 1908 (5 of 1908).\"],\"4\":[\"8. Liability of person in possession, not as owner, to deliver to person entitled to immediate possession\",\"Any person having the possession or control of a particular article of moveable property, of which he is not the owner, may be compelled specifically to deliver it to the person entitled to its immediate possession, in any of the following cases\\u2014\\r\\n(a) when the thing claimed is held by the defendant as the agent or trustee of the plaintiff;\\r\\n(b) when compensation in money would not afford the plaintiff adequate relief for the loss of the thing claimed;\\r\\n(c) when it would be extremely difficult to ascertain the actual damage caused by its loss;\\r\\n(d) when the possession of the thing claimed has been wrongfully transferred from the plaintiff.\\r\\n\"]}', 1, '2021-02-03 01:01:59', '2021-02-03 01:10:37'),
(136, 'Do1siafV7lOMwAjoraMAYROLK', 'P96rJaFer8HqOFvDJ0oFBfy3W', 'Part 2 CHAPTER 2', 'SPECIFIC PERFORMANCE OF CONTRACTS', '', '', '{\"1\":[\"9. Defences respecting suits for relief based on contract\",\"Except as otherwise provided herein, where any relief is claimed under this Chapter in respect of a contract, the person against whom the relief is claimed may plead by way of defence any ground which is available to him under any law relating to contracts.\"],\"2\":[\"10. Specific performance in respect of contracts\",\"The specific performance of a contract shall be enforced by the court subject to the provisions contained in sub-section (2) of Section 11, Section 14 and Section 16.\"],\"3\":[\"11. Cases in which specific performance of contracts connected with trusts enforceable\",\"(1) Except as otherwise provided in this Act, specific performance of a contract shall, be enforced when the act agreed to be done is in the performance wholly or partly of a trust.\\r\\n(2) A contract made by a trustee in excess of his powers or in breach of trust cannot be specifically enforced.\\r\\n\"],\"4\":[\"12. Specific performance of part of contract\",\"(1) Except as otherwise hereinafter provided in this section, the court shall not direct the specific performance of a part of a contract.\\r\\n(2) Where a party to a contract is unable to perform the whole of his part of it, but the part which must be left unperformed bears only a small proportion to the whole in value and admits of compensation in money, the court may, at the suit of either party, direct the specific performance of so much of the contract as can be performed, and award compensation in money for the deficiency.\\r\\n(3) Where a party to a contract is unable to perform the whole of his part of it, and the part which must be left unperformed either\\u2014\\r\\n(a) forms a considerable part of the whole, though admitting of compensation in money; or\\r\\n(b) does not admit of compensation in money;\\r\\nhe is not entitled to obtain a decree for specific performance; but the court may, at the suit of the other party, direct the party in default to perform specifically so much of his part of the contract as he can perform, if the other party\\u2014\\r\\n(i) in a case falling under clause (a), pays or has paid the agreed consideration for the whole of the contract reduced by the consideration for the part which must be left unperformed and in a case falling under clause (b), 7[pays or has paid] the consideration for the whole of the contract without any abatement; and\\r\\n(ii) in either case, relinquishes all claims to the performance of the remaining part of the contract and all rights to compensation, either for the deficiency or for the loss or damage sustained by him through the default of the defendant.\\r\\n(4) When a part of a contract which, taken by itself, can and ought to be specifically performed, stands on a separate and independent footing from another part of the same contract which cannot or ought not to be specifically performed, the court may direct specific performance of the former part.\\r\\n\"],\"5\":[\"13. Rights of purchaser or lessee against person with no title or imperfect title\",\"(1) Where a person contracts to sell or let certain immovable property having no title or only an imperfect title, the purchaser or lessee (subject to the other provisions of this Chapter), has the following rights, namely,\\u2014\\r\\n(a) if the vendor or lessor has subsequently to the contract acquired any interest in the property, the purchaser or lessee may compel him to make good the contract out of such interest;\\r\\n(b) where the concurrence of other persons is necessary for validating the title, and they are bound to concur at the request of the vendor or lessor, the purchaser or lessee may compel him to procure such concurrence, and when a conveyance by other persons is necessary to validate the title and they are bound to convey at the request of the vendor or lessor, the purchaser or lessee may compel him to procure such conveyance;\\r\\n(c) where the vendor professes to sell unencumbered property, but the property is mortgaged for an amount not exceeding the purchase money and the vendor has in fact only a right to redeem it the purchaser may compel him to redeem the mortgage and to obtain a valid discharge, and, where necessary, also a conveyance from the mortgagee;\\r\\n(d) where the vendor or lessor sues for specific performance of the contract and the suit is dismissed on the ground of his want of title or imperfect title, the defendant has a right to a return of his deposit, if any, with interest thereon, to his costs of the suit, and to a lien for such deposit, interest and costs on the interest, if any, of the vendor or lessor in the property which is the subject-matter of the contract.\\r\\n(2) The provisions of sub-section (1) shall also apply, as far as may be, to contracts for the sale or hire of moveable property.\\r\\n\"],\"6\":[\"14. Contracts not specifically enforceable\",\"The following contracts cannot be specifically enforced, namely\\u2014\\r\\n(a) where a party to the contract has obtained substituted performance of contract in accordance with the provisions of Section 20;\\r\\n(b) a contract, the performance of which involves the performance of a continuous duty which the court cannot supervise;\\r\\n(c) a contract which is so dependent on the personal qualifications of the parties that the court cannot enforce specific performance of its material terms; and\\r\\n(d) a contract which is in its nature determinable.\\r\\n\"],\"7\":[\"14-A. Power of court to engage experts\",\"(1) Without prejudice to the generality of the provisions contained in the Code of Civil Procedure, 1908 (5 of 1908), in any suit under this Act, where the court considers it necessary to get expert opinion to assist it on any specific issue involved in the suit, it may engage one or more experts and direct to report to it on such issue and may secure attendance of the expert for providing evidence, including production of documents on the issue.\\r\\n(2) The court may require or direct any person to give relevant information to the expert or to produce, or to provide access to, any relevant documents, goods or other property for his inspection.\\r\\n(3) The opinion or report given by the expert shall form part of the record of the suit; and the court, or with the permission of the court any of the parties to the suit, may examine the expert personally in open court on any of the matters referred to him or mentioned in his opinion or report, or as to his opinion or report, or as to the manner in which he has made the inspection.\\r\\n(4) The expert shall be entitled to such fee, cost or expense as the court may fix, which shall be payable by the parties in such proportion, and at such time, as the court may direct\\r\\n\"],\"8\":[\"15. Who may obtain specific performance\",\"Except as otherwise provided by this Chapter, the specific performance of a contract may be obtained by\\u2014\\r\\n(a) any party thereto;\\r\\n(b) the representative-in-interest or the principal, of any party thereto:\\r\\nProvided that where the learning, skill, solvency or any personal quality of such party is a material ingredient in the contract, or where the contract provides that his interest shall not be assigned, his representative in interest or his principal shall not be entitled to specific performance of the contract, unless such party has already performed his part of the contract, or the performance thereof by his representative in interest, or his principal, has been accepted by the other party;\\r\\n(c) where the contract is a settlement on marriage, or a compromise of doubtful rights between members of the same family, any person beneficially entitled thereunder;\\r\\n(d) where the contract has been entered into by a tenant for life in due exercise of a power, the remainderman;\\r\\n(e) a reversioner in possession, where the agreement is a covenant entered into with his predecessor-in-title and the reversioner is entitled to the benefit of such covenant;\\r\\n(f) a reversioner in remainder, where the agreement is such a covenant, and the reversioner is entitled to the benefit thereof and will sustain material injury by reason of its breach;\\r\\n (fa) when a limited liability partnership has entered into a contract and subsequently becomes amalgamated with another limited liability partnership, the new limited liability partnership which arises out of the amalgamation.\\r\\n(g) when a company has entered into a contract and subsequently becomes amalgamated with another company, the new company which arises out of the amalgamation;\\r\\n(h) when the promoters of a company have, before its incorporation, entered into a contract for the purposes of the company, and such contract is warranted by the terms of the incorporation, the company:\\r\\nProvided that the company has accepted the contract and has communicated such acceptance to the other party to the contract.\\r\\n\"],\"9\":[\"16. Personal bars to relief\",\"Specific performance of a contract cannot be enforced in favour of a person\\u2014\\r\\n (a) who has obtained substituted performance of contract under Section 20; or]\\r\\n(b) who has become incapable of performing, or violates any essential term of, the contract that on his part remains to be performed, or acts in fraud of the contract, or wilfully acts at variance with, or in subversion of, the relation intended to be established by the contract; or\\r\\n(c) who fails to prove that he has performed or has always been ready and willing to perform the essential terms of the contract which are to be performed by him, other than terms the performance of which has been prevented or waived by the defendant.\\r\\n\"],\"10\":[\"17. Contract to sell or let property by one who has no title, not specifically enforceable\",\"(1) A contract to sell or let any immovable property cannot be specifically enforced in favour of a vendor or lessor\\u2014\\r\\n(a) who, knowing himself not to have any title to the property, has contracted to sell or let the property;\\r\\n(b) who, though he entered into the contract believing that he had a good title to the property, cannot at the time fixed by the parties or by the court for the completion of the sale or letting, give the purchaser or lessee a title free from reasonable doubt.\\r\\n(2) The provisions of sub-section (1) shall also apply, as far as may be, to contracts for the sale or hire of moveable property.\\r\\n\"],\"11\":[\"18. Non-enforcement except with variation\",\"Where a plaintiff seeks specific performance of a contract in writing, to which the defendant sets up a variation, the plaintiff cannot obtain the performance sought, with the variation so set up, in the following cases, namely\\u2014\\r\\n(a) where by fraud, mistake of fact or misrepresentation, the written contract of which performance is sought is in its terms or effect different from what the parties agreed to, or does not contain all the terms agreed to between the parties on the basis of which the defendant entered into the contract;\\r\\n(b) where the object of the parties was to produce a certain legal result which the contract as framed is not calculated to produce;\\r\\n(c) where the parties have, subsequently to the execution of the contract, varied its terms.\\r\\n\"],\"12\":[\"19. Relief against parties and persons claiming under them by subsequent title\",\"Except as otherwise provided by this Chapter, specific performance of a contract may be enforced against\\u2014\\r\\n(a) either party thereto;\\r\\n(b) any other person claiming under him by a title arising subsequently to the contract, except a transferee for value who has paid his money in good faith and without notice of the original contract;\\r\\n(c) any person claiming under a title which, though prior to the contract and known to the plaintiff, might have been displaced by the defendant;\\r\\n (ca) when a limited liability partnership has entered into a contract and subsequently becomes amalgamated with another limited liability partnership, the new limited liability partnership which arises out of the amalgamation.\\r\\n(d) when a company has entered into a contract and subsequently becomes amalgamated with another company, the new company which arises out of the amalgamation;\\r\\n(e) when the promoters of a company have, before its incorporation entered into a contract for the purpose of the company and such contract is warranted by the terms of the incorporation, the company:\\r\\n\"],\"13\":[\"20. Substituted performance of contract\",\"(1) Without prejudice to the generality of the provisions contained in the Indian Contract Act, 1872 (9 of 1872), and, except as otherwise agreed upon by the parties, where the contract is broken due to non-performance of promise by any party, the party who suffers by such breach shall have the option of substituted performance through a third party or by his own agency, and, recover the expenses and other costs actually incurred, spent or suffered by him, from the party committing such breach.\\r\\n(2) No substituted performance of contract under sub-section (1) shall be undertaken unless the party who suffers such breach has given a notice in writing, of not less than thirty days, to the party in breach calling upon him to perform the contract within such time as specified in the notice, and on his refusal or failure to do so, he may get the same performed by a third party or by his own agency:\\r\\nProvided that the party who suffers such breach shall not be entitled to recover the expenses and costs under sub-section (1) unless he has got the contract performed through a third party or by his own agency.\\r\\n(3) Where the party suffering breach of contract has got the contract performed through a third party or by his own agency after giving notice under sub-section (1), he shall not be entitled to claim relief of specific performance against the party in breach.\\r\\n(4) Nothing in this section shall prevent the party who has suffered breach of contract from claiming compensation from the party in breach.\\r\\n\"],\"14\":[\"20-A. Special provisions for contract relating to infrastructure project\",\"(1) No injunction shall be granted by a court in a suit under this Act involving a contract relating to an infrastructure project specified in the schedule, where granting injunction would cause impediment or delay in the progress or completion of such infrastructure project.\\r\\n(2) The Central Government may, depending upon the requirement for development of infrastructure projects, and if it considers necessary or expedient to do so, by notification in the Official Gazette, amend the schedule relating to any category of projects or Infrastructure Sub-Sectors.\\r\\n(3) Every notification issued under this Act by the Central Government shall be laid, as soon as may be after it is issued, before each House of Parliament, while it is in session, for a total period of thirty days which may be comprised in one session or in two or more successive sessions, and if, before the expiry of the session immediately following the session or the successive sessions aforesaid, both Houses agree in making any modification in the notification or both Houses agree that the notification should not be made, the notification shall thereafter have effect only in such modified form or be of no effect, as the case may be; so, however, that any such modification or annulment shall be without prejudice to the validity of anything previously done under that notification\\r\\n\"],\"15\":[\"20-B. Special Courts\",\"The State Government, in consultation with the Chief Justice of the High Court, shall designate, by notification published in the Official Gazette, one or more Civil Courts as Special Courts, within the local limits of the area to exercise jurisdiction and to try a suit under this Act in respect of contracts relating to infrastructure projects.\"],\"16\":[\"20-C. Expeditious disposal of suits\",\"Notwithstanding anything contained in the Code of Civil Procedure, 1908 (5 of 1908), a suit filed under the provisions of this Act shall be disposed of by the court within a period of twelve months from the date of service of summons to the defendant:\"],\"17\":[\"21. Power to award compensation in certain cases\",\"(1) In a suit for specific performance of a contract, the plaintiff may also claim compensation for its breach, 18[in addition to], such performance.\\r\\n(2) If, in any such suit, the court decides that specific performance ought not to be granted, but that there is a contract between the parties which has been broken by the defendant, and that the plaintiff is entitled to compensation for that breach, it shall award him such compensation accordingly.\\r\\n(3) If, in any such suit, the court decides that specific performance ought to be granted, but that it is not sufficient to satisfy the justice of the case, and that some compensation for breach of the contract should also be made to the plaintiff, it shall award him such compensation accordingly.\\r\\n(4) In determining the amount of any compensation awarded under this section, the court shall be guided by the principles specified in Section 73 of the Indian Contract Act, 1872 (9 of 1872).\\r\\n(5) No compensation shall be awarded under this section unless the plaintiff has claimed such compensation in his plaint:\\r\\n\"],\"18\":[\"22. Power to grant relief for possession, partition, refund of earnest money, etc\",\"(1) Notwithstanding anything to the contrary contained in the Code of Civil Procedure, 1908 (5 of 1908), any person suing for the specific performance of a contract for the transfer of immovable property may, in an appropriate case, ask for\\u2014\\r\\n(a) possession, or partition and separate possession, of the property, in addition to such performance; or\\r\\n(b) any other relief to which he may be entitled, including the refund of any earnest money or deposit paid or 19[made by] him, in case his claim for specific performance is refused.\\r\\n(2) 