
-- --------------------------------------------------------

--
-- Table structure for table `news`
--

DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `news_id` int NOT NULL AUTO_INCREMENT,
  `news_key` varchar(255) NOT NULL,
  `category_key` varchar(255) NOT NULL,
  `news_title` text NOT NULL,
  `news_description` text NOT NULL,
  `news_image` varchar(255) NOT NULL,
  `news_attachment` varchar(255) DEFAULT NULL,
  `news_author` varchar(255) NOT NULL,
  `news_date` varchar(255) NOT NULL,
  `news_status` tinyint NOT NULL DEFAULT '1',
  `news_date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `news_date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`news_id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `news`
--

INSERT INTO `news` (`news_id`, `news_key`, `category_key`, `news_title`, `news_description`, `news_image`, `news_attachment`, `news_author`, `news_date`, `news_status`, `news_date_added`, `news_date_updated`) VALUES
(1, 'Qo7AK849wUwf7hrQbGohoRb49', 'VhxnyUzehnWzklogQ6fbATR44', 'Daksha Legal discussion on Latest Judgement of Karnataka High Court on Hindu Law.', '&lt;p&gt;&lt;b&gt;svddvsdvvdvds&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;a href=&quot;http://dakshalegal.in/beta/&quot; target=&quot;_blank&quot;&gt;http://dakshalegal.in/beta/&lt;/a&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '3cd4f7f2cdb9bc7c47b83e5b307d8741.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-10', 0, '2020-12-03 06:28:49', '2021-01-26 07:23:27'),
(2, '0GxapPcNxpz1DSTvjlcTj1cHz', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Breaking News ... Karnataka High Court directs Government to hold elections to BBMP ', '&lt;p&gt;Breaking News ... Karnataka High Court directs Government to hold elections to BBMP&amp;nbsp;&lt;br&gt;&lt;/p&gt;', 'b11bade5d33fcdd45dd8c927aba6fcc7.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-08', 0, '2020-12-09 03:25:02', '2021-01-26 07:23:25'),
(3, '3bnwaIeqdii82Ui68UbBw59fO', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'WELCOME TO DAKSHA LEGAL - KNOWLEGE SHARING PLATFORM', '&lt;p&gt;WELCOME TO DAKSHA LEGAL - KNOWLEGE SHARING PLATFORM......&lt;br&gt;&lt;/p&gt;', '4831e7ade124bc4d74bc6fdefe5fcb38.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-01-27', 0, '2020-12-12 18:16:50', '2021-01-27 15:29:06'),
(4, '6iS3kKFxJnVii8XoIBS4rOI6b', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'High Court of Karnataka modified siting list with effect from 1 February 2021 ', '&lt;h3&gt;Sitting List High Court of Karnataka with effect from 1 February 2021&amp;nbsp; &lt;a href=&quot;https://karnatakajudiciary.kar.nic.in/sittinglists/sl-blr-mod-28012021.pdf&quot; target=&quot;_blank&quot;&gt;https://karnatakajudiciary.kar.nic.in/sittinglists/sl-blr-mod-28012021.pdf&lt;/a&gt;&lt;/h3&gt;&lt;p&gt;&lt;/p&gt;', '9c0d8dfd4fd1c1bacb990be3ed108278.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-01-27', 0, '2021-01-28 03:03:37', '2021-01-31 06:17:27'),
(5, '7aFMSEqZxfsC76mypvrmkWXtm', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Wearing of normal uniform in all courts is compulsory from tomorrow 1 February 2021', '&lt;h4 style=&quot;margin-bottom:0cm;margin-bottom:.0001pt;text-align:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njustify;line-height:normal&quot;&gt;&lt;b&gt;Kindly note.&lt;/b&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom:0cm;margin-bottom:.0001pt;text-align:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njustify;line-height:normal&quot;&gt;Wearing of normal/full uniform in all courts is compulsory from tomorrow 1 February 2021. Please refer to the SOP notification for the High Court and District Judiciary, dated 18 January 2021. Links given below&lt;br&gt;&lt;a href=&quot;https://karnatakajudiciary.kar.nic.in/noticeBoard/mod-sop-dj-18012021.pdf&quot; target=&quot;_blank&quot;&gt;https://karnatakajudiciary.kar.nic.in/noticeBoard/mod-sop-dj-18012021.pdf&lt;/a&gt;&lt;br&gt;&lt;a href=&quot;https://karnatakajudiciary.kar.nic.in/noticeBoard/mod-sop-hck-18012021.pdf&quot; target=&quot;_blank&quot;&gt;https://karnatakajudiciary.kar.nic.in/noticeBoard/mod-sop-hck-18012021.pdf&lt;/a&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom:0cm;margin-bottom:.0001pt;text-align:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njustify;line-height:normal&quot;&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom:0cm;margin-bottom:.0001pt;text-align:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njustify;line-height:normal&quot;&gt;&lt;i&gt;Regards&amp;nbsp;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom:0cm;margin-bottom:.0001pt;text-align:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njustify;line-height:normal&quot;&gt;&lt;i&gt;S.Basavaraj&lt;br&gt;Member&lt;br&gt;KSBC&lt;/i&gt;&lt;/h4&gt;', '10799f3137e059ab3f8b2193a5722d79.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-01-31', 0, '2021-01-31 17:58:10', '2021-02-05 09:23:29'),
(6, 'aJVU43mv1zsURxXCu91WPFURt', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Chief Justice of Karnataka requests Advocates not to boycott Courts. Seeks cooperation for speedy disposal of cases. ', '&lt;p&gt;Chief Justice of Karnataka requests Advocates not to boycott Courts. Seeks cooperation for speedy disposal of cases. The letter dated 3 February 2021 in this regard is enclosed.&amp;nbsp;&lt;/p&gt;', 'eba7bc98cfded72a9c09abd08496ea1b.jpg', 'f677a63a0a033e9059fedfe67302f25a.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-03', 0, '2021-02-05 20:59:29', '2021-04-25 07:33:17'),
(7, '18fbrUB5RHnhFZrgPl1LyNeXZ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka Judiciary. Laying foundation stone for new building of Bangalore Mediation Centre Karnataka Judicial Academy and Inauguration of Commercial Court Complex', '&lt;h3&gt;Karnataka Judiciary. Laying foundation stone for new building of Bangalore Mediation Centre Karnataka Judicial Academy and Inauguration of Commercial Court Complex&lt;br&gt;&lt;a href=&quot;https://youtu.be/kucxNfchEgs&quot; target=&quot;_blank&quot;&gt;https://youtu.be/kucxNfchEgs&lt;/a&gt;<br />\r\n&lt;/h3&gt;&lt;div&gt;&lt;br&gt;&lt;/div&gt;', 'd56b9278b250d1e12a163a711449fc39.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-07', 0, '2021-02-07 18:06:25', '2021-03-09 11:37:33'),
(8, '6lz7MvdwCxEt3Dm8VGy8ldD7J', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Lawyer appears in Virtual Court as Cat.. Judge tweets about precaution ', '&lt;h3&gt;Lawyer appears in Virtual Court as Cat.. Judge tweets about precaution.&lt;/h3&gt;&lt;h3&gt;&lt;font color=&quot;#ce0000&quot;&gt;Watch video by clicking &#039;Download PDF&#039;&amp;nbsp; button.&lt;/font&gt;&lt;br&gt;&lt;/h3&gt;', '0fd7dad103c2889a59708334fd088489.PNG', '4bd327c26126d18303e749e5b09c7dca.mp4', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-10', 0, '2021-02-10 16:31:35', '2021-02-11 14:43:54'),
(9, 'yRYebeMFUmuzpNJfa0ZFaPSHu', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A quick take on the Trial Strategy in M.J. Akbar vs. Priya Ramani- Ajay J Nandalike ', '&lt;h4&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/div&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: center; &quot;&gt;&lt;font color=&quot;#3c4b64&quot;&gt;&lt;b&gt;A quick take on the Trial Strategy in M.J. Akbar vs. Priya Ramani - Ajay J Nandalike&amp;nbsp;&lt;/b&gt;&lt;/font&gt;&lt;/h4&gt;&lt;h4&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;br&gt;&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The judgment in question is being lauded by many as a landmark judgment in the #MeToo movement. This article focuses only on the Trial Strategy adopted by both sides and how the Ld. Magistrate might have seen it. It is my view that the reasoning of the Ld. Magistrate which is recorded from pages 85 to 91 of the judgment is not sufficient to really discern the basis of acquittal of the Accused. Therefore, one will have to examine the detailed recording of the evidence in the judgment to understand what made an impact on the Ld. Magistrate.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The basis of the Complaint was an article published on 12.10.2017 in the VOGUE magazine titled as a &lsquo;open letter&rsquo;. The article did not name the Complainant but stated that the Accused had been asked to come to a Hotel for an interview and interviewed in the Complainant&rsquo;s hotel room wherein she was offered alcohol and old Hindi songs were sung and she was asked to sit beside him which she refused. She claimed it to be sexual harassment. Later on, way of a Tweet dated 08.10.2018, she named the person in the article as the Complainant. By another Tweet on 10.10.2018, she named 10 persons who have been sexually harassed by the Complainant.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Complainant contended that the article in conjunction with the tweets was defamatory and denied the allegations made in the tweet. The Complainant led evidence of six witnesses including himself as CW-1. He established his journalistic and other credentials and that publication of the article and subsequent tweets gravely harmed his reputation. CW-2 to CW-6 spoke to the good reputation of the Complainant and that the tweets and the article lowered his reputation. They also stated that they did not know the Accused and could not speak as to her allegations.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;In the cross-examination of CW-1, the strategy of the Accused was to destroy the statement that the Complainant had stellar reputation. This is a boilerplate strategy in defamation matters as the pre-requisite is that the defamation must adversely impact the reputation and if reputation was already bad due to various reasons, one more event could not possibly impact it adversely. Towards this end, the conviction for criminal contempt for false reporting, political ideological U turns viz. shifting from Congress Party to BJP, that while being married, he was in an extra-marital relationship were all pointed out. This seems to have had an impact as the Ld. Magistrate records that the Complainant is not a man of stellar reputation is proved through his testimony and testimony of DW-3 Ms. Ghazala Wahab.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The cross-examination of the Complainant to bring out examples of reputation had a huge impact on the finding that the Complainant did not have stellar reputation. This was because the touchstone of the case was the Complainant&rsquo;s reputation. If the Complainant had focused only on the aspect that the false allegation that he is a sexual predator harmed his reputation and his own family members had felt embarrassed by these statements, intended to lower his moral character vis-&agrave;-vis his working with women and he will never be able to work with women on account of these allegations, then one could have argued that the cross-examination of the Complainant on other issues impacting his reputation is not relevant to the facts of this case.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;CW-2 was working with the Complainant at some point in time and testified that she had not heard about the Complainant being a sexual predator from any person in the office and that he was of stellar reputation and she had heard from friends who asked about the Complainant given her long association with the complainant after the tweets came out. There is a legal requirement to show that the tweets have lowered the reputation of the Complainant in the eyes of others and to fulfil the same, it is standard practice to lead evidence of acquaintances to show the impact on the person. Maybe, to fulfil this requirement CW-2 was examined.&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Given that CW-2 had worked in the Asian Age newspaper where the Accused and DW-3 Ms. Ghazala Wahab had worked, if CW-2 had not spoken to Ms. Ghazala Wahab about the truthfulness of the allegations against the Complainant given that even Ms. Ghazala Wahab had written an article on the Complainant, then her evidence would not have sufficient probative value. This was the focus in the cross-examination wherein CW-2 admitted that she interacted professionally with Ms. Ghazala Wahab and not the others mentioned in the tweets. She also stated that she did not know the Accused. She did not confront Ms. Ghazala Wahab about the truthfulness of the allegations made by the Accused or by Ms. Ghazala Wahab.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Trial Strategy of the Complainant was to just establish the good reputation of the Complainant and leave the burden of proving the truth of the allegations to the Accused. Hence, only general statements were made by the witnesses. On account of CW-2 not carrying out sufficient inquiries into the allegations made by other persons and also Priya Ramani, the statement that it was not possible that the Complainant was capable of such conduct could not be accepted. Thus CW-2 evidence could not be given sufficient value.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;CW-3 and CW-4 also spoke to the reputation of the Complainant and that the tweets caused enormous damage to the Complainant&rsquo;s reputation. The cross-examination of CW-3 and CW-4 was also on same lines as CW-2. It becomes boilerplate evidence if all the witnesses say the same thing, but they did not bother to fully understand why more than 2 persons were making the same allegations against the Complainant. CW-3 did not know the Accused or the other women who had made similar allegations or the people who were named in the second tweet as people who knew the Complainant to be a sexual predator.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;CW-5 also spoke similarly as CW-2, 3 and 4. The cross-examination was on similar lines as CW-2 to CW-4 but additionally it was admitted that CW-5 gave a TV interview claiming the Complainant to be of good character after the Complaint was filed and after she agreed to be a witness and the Complainant&rsquo;s son worked with the CW-5. CW-6 testified only as to the print outs of the articles and the 65B Certificate and did not give any substantial evidence.&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The strategy of the Complainant through the evidence of CW-2 to CW-5 was to establish reputation and to contend that the Complainant was incapable of being a sexual predator. Unfortunately, none of the witnesses were personally able to refute the story of the Accused or that of DW-3 or had spoken to other persons named by the Accused. If any of them had spoken to any of the 10 persons named and gave evidence as to those aspects even to say that their story was unbelievable for xyz reasons, that would have strengthened the case of the Complainant. But as they gave boilerplate evidence for defamation matters regarding reputational harm, the strategy of the Accused during the cross-examination was to establish that they had not made any attempt to verify the truth of the allegations before evidence as to the Complainant&rsquo;s reputation. Also, if the Complainant witnesses had made very general statements regarding character and reputation of the Complainant. If they had cited specific events / incidents and contended that on the basis of these events / incidents they had come to believe that the Complainant was incapable of being a sexual predator, then the cross-examination would have been extremely limited on those aspects as those facts would not have been within the knowledge of the Accused. This would have also forced the Ld. Magistrate to weigh those incidents against the incident that Accused complained of to arrive at the truth of whether it could have happened i.e. to find as to whether the Complainant is indeed capable of being a sexual predator as alleged by the Accused.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Accused examined herself as DW-1, her friend who dropped her to the hotel as DW-2 and another person who was allegedly sexually harassed by the Complainant as DW-3. One of the most striking things about the evidence of all Accused witnesses was the amount of details in their story. Every event, timeline, location was matching between DW-1 and DW-2. The story of DW-3 was very much believable and corroborated with every other detail. They could not be contradicted in their cross-examination on any aspect. This shows the level of preparation of the witnesses to remember every fact that took place nearly twenty plus years ago.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Especially DW-1 remember every question that was posed, how uncomfortable she felt, and the behaviour of the Complainant. All of this was stated in the examination in chief thus leaving limited scope for cross-examination by elimination of all possible gaps. If one contrasts this with the evidence of the CW-1 who did not lead any evidence regarding the interview and in the cross-examination did not remember the interview of the Accused and various details that were put forth. So, the Accused established by the cross-examination that it was probable that the interview took place at the Oberoi Hotel.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;If the examination in chief of CW-1 had referred to the events of Oberoi Hotel and giving the Complainant&rsquo;s take on it, it would have been difficult to cross-examination him on specifics. But it was probably the Trial Strategy of the Complainant not to lead evidence on that issue. This was because the defence of the Accused was that only a portion of the article referred to the Complainant and the remaining was in general. CW-1 denied that suggestion and wanted to establish that the contents of the entire article had to be proved by the Accused against the Complainant. The evidence of the Accused on these aspects could not be contradicted. The Ld. Magistrate therefore accepted the Accused&rsquo;s contention on this aspect.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Trial Strategy of the Accused appeared to be two-fold. One to point out that there was sufficient evidence to establish that the Complainant indulged in sexual harassment by giving various examples. This would negate the strategy of the Complainant to show that he was of good character. The Ld. Magistrate records that a person may be well respected within his family and friends but can also be a sexual predator in private.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Second strategy was to establish that it could be the truth by utilizing the supporting tweets of various persons (the content of the tweets is not stated in the judgment and hence we cannot comment as to whether it was collaborative of the Accused&rsquo;s case or not). The impression that was sought to be created was that there was a pattern of harassment of junior female colleagues. It was implied that no action had been taken by the Complainant against those other persons as the allegations could be true. If that is the case, then there is a probability that the Accused&rsquo;s allegation of sexual harassment can also be true. The Complainant&rsquo;s explanation regarding this was lacklustre and did not inspire confidence in the Ld. Magistrate.&amp;nbsp;&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Complainant sought to cross-examine the Accused and DW-2 on any other contemporaneous evidence such as telephone calls, hotel reservation etc, not approaching any authority against the Complainant in the wake of such serious allegations to establish falsity. But when the Complainant himself could not remember the events of 25 years, it would be unreasonable to expect that physical evidence of the events would be preserved. Only oral collaborative testimony was available and had to be accepted.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Complainant ought to have adopted another strategy of getting witnesses who knew the Accused and who contend that the Accused never confided in them about this matter. There was only one witness who spoke as to the events inside the room viz. DW-1. If there was any challenge to the testimony by any witness, then it would have made the Ld. Magistrate&rsquo;s job more difficult.&amp;nbsp;&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The appeal memo that the Complainant will draw up may not be kind to the Ld. Magistrate as the operative portion of the judgment does not clearly record does not reflect in great detail the impression that the evidence created on the Ld. Magistrate. It will be screamed from rooftops that the Ld. Magistrate completely failed to give a finding on whether the tweet was defamatory and whether the Accused proved that she came within the First, Third or the Ninth Exception, that the Ld. Magistrate failed to give any reasons as to why it was held that the Complainant did not have stellar reputation; that the Ld. Magistrate failed to give reasons as to how the Accused proved her case within the preponderance of probability.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Ultimately a judgment in a criminal matter is not just an exercise of testing whether the legal requirements are fulfilled but also a reflection of the Ld. Magistrate&rsquo;s conscience and sense of justice. The Ld. Magistrate records the difficulties that women face in the workplace, the absence of appropriate redressal mechanisms at that time and the courage it takes for victims of sexual harassment to speak up to hold that their right to dignity must not be stifled with the threat of criminal defamation. This may not be an established legal principle, but it is a reflection of the Ld. Magistrate&rsquo;s sense of justice. In a Trial, it is possible to appeal to a Judge&rsquo;s sense of justice which goes beyond laws and touches humanity and good conscience.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;The Trial Strategy of the Accused was a combination of robust understanding of the law, forensic cross-examination of the Complainant, the Accused witnesses holding their own during the cross-examination and appeal to the conscience of the Ld. Magistrate. The Trial Strategy of the Complainant was to merely prove reputation and impose the burden on the Accused to make out their case fell within the Exceptions to the offence which is a very sound legal strategy in most situations. But in this case, the Complainant could not establish the falsity of the article and the tweets by way of cross-examination and the Ld. Magistrate held it against them. The possible reason why it happened that way was because the events in question happened in a private room. Even in offences regarding rape, the sole testimony of the victim in the absence of any other evidence is considered sufficient for conviction i.e. meeting the burden of &lsquo;beyond any reasonable doubt&rsquo;. Contrast that to the requirement of proving the defence beyond &lsquo;preponderance of probability&rsquo;, the Accused strategy worked better and it resulted in acquittal.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;{Disclaimer: I make post-facto and possibly unjustified and unwarranted assumptions and presumptions while analysing the Trial Strategy adopted by the parties in this article. This is no reflection on the lawyers who represented the parties who were brilliant and could not have possibly foreseen how the Ld. Magistrate will look into the totality of the matter. It is also possible that the Appellate Court may reverse the finding rendering my observations baseless. Therefore, please take it only as an academic take on the matter.}&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;&lt;i&gt;(Ajay J Nandalike is an advocate practicing in the High Court of Karnataka)&lt;/i&gt;&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;/h4&gt;&lt;div style=&quot;text-align: justify; &quot;&gt;&lt;br&gt;&lt;/div&gt;', '19f6a7bfdab45b5fcf1042e7afc56b76.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-19', 0, '2021-02-19 22:29:56', '2021-02-21 04:48:44'),
(10, '6EhKsSgxypN2NJlh4lGcrBeDN', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Inauguration of New Court Complex at Karkala Udupi District. 20 February 2021. ', '&lt;h2 style=&quot;text-align: center; &quot;&gt;&lt;b&gt;Inauguration of New Court Complex at Karkala Udupi District. 20 February 2021.&amp;nbsp;&lt;/b&gt;&lt;br&gt;&lt;/h2&gt;&lt;h2 style=&quot;text-align: center; &quot;&gt;&lt;b&gt;&lt;a href=&quot;https://youtu.be/1dcFB9Q60ts&quot; target=&quot;_blank&quot;&gt;https://youtu.be/1dcFB9Q60ts&lt;/a&gt;&lt;/b&gt;&lt;br&gt;&lt;/h2&gt;', 'b500e5a16614c9d19251a32811198ca3.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-20', 0, '2021-02-21 16:30:04', '2021-03-09 11:37:21'),
(11, 'ZNyent5muLVCztmOzvP5Fy2b6', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Four additional judges of the Karnataka High Court made permanent judges. ', '&lt;h4&gt;The President of India has appointed four additional judges of the Karnataka High Court as permanent Judges with effect from they assume charge of their office. The order in this regard issued on 22 February 2021 reads; &lt;i style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;(pdf of the order enclosed)&lt;/i&gt;&lt;/h4&gt;&lt;h4&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-left: 25px;&quot;&gt;&lt;i&gt;&lt;b&gt;&quot;In exercise of the power conferred by clause (1) of Article 217 of the Constitution of India, the President is pleased to appoint S/Shri Justices (1) Singapuram Raghavachar Krishna Kumar (2) Ashok Subhashchandra Kinagi (3) Suraj Govindaraj and (4) Sachin Shankar Magadum, Additional Judges of the Karnataka High Court, to be Judges of the Karnataka High Court with effect from the date they assume charge of their respective offices.&quot;&lt;/b&gt;&lt;/i&gt;&lt;/h4&gt;&lt;div style=&quot;margin-left: 25px;&quot;&gt;&lt;br&gt;&lt;/div&gt;', 'f2e18d1a432078d504163d82c140779e.PNG', '4bab0a824af1a86dd3bee1fb320f0172.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-22', 0, '2021-02-23 00:09:44', '2021-03-09 11:37:15'),
(12, 'ToTZwymIbxoAjvGikPNUfgHAi', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'UK Court calles Justice Katju  A Man with Personal Agenda. Rejects his evidence in Nirav Modi extradition case. ', '&lt;h4&gt;The United Kingdom Court called&nbsp; Justice Katju&nbsp; A Man with Personal Agenda. Rejects his evidence in Nirav Modi extradition case.&nbsp;&lt;br&gt;The Court said &quot;Despite having been a former Supreme Court judge in India until his retirement in 2011 his evidence was in my assessment less than objective and&nbsp; reliable. His evidence in Court appeared tinged with resentment towards former senior judicial colleagues It had hallmarks of an outspoken critic with his own personal agenda&rdquo;&nbsp;&lt;br&gt;The ultimate insult came when the Court said &quot;He(Katju) made bold assertions about corruption across the judiciary in India (including former Chief Justices) and that the Supreme Court had surrendered itself to the executive. Of note, despite being critical of a former Chief Justice passing a verdict in a Supreme Court case in exchange or a nomination to the upper house of Parliament in India on his retirement on a quid pro quo basis, suggesting collusion and corruption, Justice Katju himself secured appointment by the Government to Chairman of the Press Council of India following his own retirement&quot;,&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'd4c85354119c2348489512ce8510f509.jpg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-25', 0, '2021-02-26 02:45:01', '2021-03-09 11:37:10'),
(13, 'cRkORGcm995ZaLgCeZcuVc2tw', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court orders notice on the challenge to constitutional validity of the Wakf Act. ', '&lt;h4&gt;Karnataka High Court orders notice on the challenge to constitutional validity of the Wakf Act.&amp;nbsp;&lt;/h4&gt;&lt;h4&gt;The division bench consisting of Justice Aravind Kumar and Mr. Justice Pradeep Singh Yerur, after hearing Mr. S.P. Shankar, Senior Advocate ordered issuance of notice on the public interest litigation filed by Daksha Legal research assistant. The issue regarding maintainability is kept open.&amp;nbsp;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;Writ Petition pdf enclosed&amp;nbsp;&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;Grounds urged in support of the Writ Petition.&amp;nbsp;&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;1.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Secularism is declared to be the basic structure of the Constitution. The word secular used in the preamble is duly reflected in Article 25 to 30 in part III and Part IV and Articles 51A.&amp;nbsp; Complete neutrality towards&amp;nbsp; religion and&amp;nbsp; apathy for all kinds of religious teachings in institutions of the State, have&amp;nbsp;&amp;nbsp;&lt;/span&gt;hardly worked in removing misunderstandings and intolerance. Experience of the society suggest that secularism is susceptible of a positive meaning in developing understanding and respect towards different religions is essence of secularism. Non discrimination, by the State on the basis of Religious differences, is the basic feature/structure of the Constitution of India.&lt;/h4&gt;&lt;h4&gt;2. Preamble read with Articles 25 to 28 would emphasise guarantee of equality in the matter of religion, to all individuals and groups irrespective of their faith, emphasising the fact that State does not practice any religion. Concept of secularism is one facet of the right to equality woven as the central golden thread in the fabric depicting the pattern of the scheme of constitution as held in Dr. M. Ismail Frauqui And Ors. vs Union Of India And Ors. (1994) 6 SCC 360. It is held that secularism is absolute/inviolable and State may not treat religions differently on the ground that public order requires it. State shall treat all religions and religious groups equally and with equal respect without State shall not interfere with their individual right of religious faith or worship. There is no justification for interfering in someone&rsquo;s religion by any means like promoting or punishing, by the State vide Rabindra Kr. Pal @ Dara Singh vs Republic Of India (2011) 2 SCC 690.&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;3. The word &ldquo;secular&rdquo; appears in the preamble of the constitution. But it permeats and pervades through out, it embodies the quintessence of the diverse facets of secularism. Secularism is a goal as well as the process and end or means, vide Atheist Society Of India, ... vs Govt. Of Andhra Pradesh AIR 1992 AP 310.&lt;/span&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;4. Constitution of India as it stood on 26:11:1949 has been supplemented by multiple amendments and practically recast by 42nd, 43rd, and 44th Amendments, during 1976-78 42nd amendment in 1976, 43rd and 44th amendment in 1977-78. Vital aspects have undergone impermissible change. Written constitution always means limited Government, vide Basu&rsquo;s Tagore Law Lectures on Government and Judicial Review and Comparative Constitutional Law.&lt;/span&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;5. Judiciary is called and referred to as guardian of the constitution &ldquo;Government of Law and Government of Men&rdquo;- AIR 1975 SC 2299 Indira Nehru Gandhi vs Shri Raj Narain &amp;amp; Anr&lt;/span&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;6. &ldquo;Secularism&rdquo; found in the preamble is explained in Article 25-28. State should not have religion of its own, and no one could proclaim to make the State to create a theoretic State. Each person has to get the assurance from the State that he has the protection of law freely to profess, practice and propagate his own religion and freedom of conscience, State Of Karnataka And Anr vs Dr. Praveen Bhai Thogadia (2004) 4 SCC 684. &ldquo; Secularism is fundamental law and inalienable segment of basic structure of the Constitution&rdquo;&lt;/span&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;7. &ldquo;Religious tolerance. Equal treatment to all religions&rdquo; S.R. Bommai vs Union Of India AIR 1994 SC 1918, (1994) 3 SCC 1.&amp;nbsp;&lt;/span&gt;&ldquo;It is a system of Utilitarian Ethics, seeking to maximize human happiness or welfare quite independent of what may be entirely religious or the occult&rdquo; Ziyauddin Burhanuddin Bukhari vs Brijmohan Ramdass Mehra &amp;amp; Ors (1976) 2 SCC 17.&lt;/h4&gt;&lt;h4&gt;8. Secularism is a wall of separation between State and religion and religious institutions. At all events Articles 25 to 30 shall be read and understood as being subordinate to Articles 14, 19 and 21.&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;9. The Constitution of India is both a living document and a compelling &ldquo;mother law&rdquo;. Every step taken by the State shall abide by and be subordinate to Part III of the Constitution of India. Enacting Wakf Act has to pass the test of Article 13(2). Instead of observing what is prohibited in Part III of the Constitution of India State has twisted the same to accommodate the unintended purpose of promoting a Religion. Thus, Wakf Act is liable to be declared unconstitutional and struck down as being destructive of the basic structure of the Constitution of India. The above provisions of the Wakf Act 1995 do result in Constitutional aberrations, jeopardising the basic structure of the Constitution.&lt;/span&gt;&lt;br&gt;&lt;/h4&gt;&lt;div&gt;&lt;br&gt;&lt;/div&gt;', 'f308185b1918bb26aa999f25c4b0be90.PNG', 'b1556b2bf2c4af020b071ae1436d5b30.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-08', 0, '2021-03-08 18:57:16', '2021-04-25 07:33:27'),
(14, 'xjKIgPPNPo633tqFGpemjDT5V', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'BEHAVE YOURSELF - Karnataka High Court warns print and electronic media. ', '&lt;h4&gt;The High Court of Karnataka has finally come to the rescue of citizens against mindless, irresponsible and often extortion oriented reporting of news by print and electronic media. Most of the electronic media today have indulged in mudslinging.&amp;nbsp;&lt;/h4&gt;&lt;h4&gt;At no point of time in history, the electronic media had stooped to the level it has today. The recent news bombarding about Corona, fake claims, panic creation, exaggeration of innocuous events, political lobbying and the alleged extortion rackets have shown that the Electronic Media has reached a dangerous level.&lt;br&gt;The Press ie. Print Media It is regulated by Press Council of India, a mechanism for the Press to regulate itself. It is created under the Press Council Act, 1978. Section 13 says that the objects of PCI is, inter alia, to build up a code of conduct for newspapers, news agencies and journalists in accordance with high professional standards and to ensure on the part of newspapers, news agencies and journalists, the maintenance of high standards of public taste and foster a due sense of both the rights and responsibilities of citizenship.&lt;br&gt;Press Council of India has powers to take disciplinary action against journalists as can be seen from Section 14 of the Act. On receipt of a complaint made to it or otherwise, if the Council has reason to believe that a newspaper or news agency has offended against the standards or journalistic ethics or public taste or that an editor or a working journalist has committed any professional misconduct, the Council may, after giving the newspaper, or news agency, the editor or journalist concerned an opportunity of being heard, hold an inquiry in such manner as may be provided by regulations made under this Act and, if it is satisfied that it is necessary so to do, it may, for reasons to be recorded in writing, warn, admonish or censure the newspaper, the news agency, the editor or the journalist or disapprove the conduct of the editor or the journalist, as the case may be.&lt;br&gt;Press Trust of India Ltd., commonly known as PTI, is the largest news agency in India. PTI is a non-profit cooperative among more than 500 Indian newspapers in India. PTI has inbuilt guidelines.&lt;br&gt;Electronic Media. The electronic media is the most powerful media both because of its audio-visual impact, and its widest reach covering the section of the society where the print media does not reach.Today, electronic media is neither guided nor regulated in India. The Supreme Court in Cricket Broadcasting Case - Secretary, Ministry of Information and Broadcasting, Government of India v. Cricket Association of Bengal (AIR 1995 SC 1235) has said that there shall be a law controlling the electronic media. The Supreme Court held;&lt;br&gt;&quot;124(i)The airwaves or frequencies are a public property. Their use has to be controlled and regulated by a public authority in the interests of the public and to prevent the invasion of their rights. Since the electronic media involves the use of the airwaves, this factor creates an in- built restriction on its use as in the case of any other public property. [iii] The Central Government shall take immediate steps to establish an independent autonomous public authority representative of all sections and interests in the society to control and regulate the use of the airwaves.&quot;&lt;br&gt;However, no law has been enacted in this regard so far. The Cable and Television Act was meant to regulate television channels when it was on cable. Over time, since we have moved to DTH - the licensee is required to take a permission/license from the Govt of India. While applying for such licence, they undertake to abide by the Cable Act - ie Programme Code and Advertising Code found in Sections 5&amp;amp;6 read with Rules 6 &amp;amp; 7. However there is no statutory mechanism other than this. There is an Inter Ministerial Committee which looks into complaints. However, there is no statutory mechanism.&lt;br&gt;Electronic media has become the most powerful tool of news assimilation. At the same time, there is total lack of accountability, transparency and responsibility. To achieve higher Television Rating Point TRP, Most notorious often fake headlines are being flashed throughout the day and night. There are allegations of extortion, political lobbying and character assassination for a price.&lt;br&gt;Unless these Television channels, most of them private owned, are controlled and regulated, the unleashing of fake Armageddon will not stop. &lt;/h4&gt;&lt;h4&gt;On a writ petition filed by Bangalore based Advocate, Mr. Atma Hiremath, the Karnataka High Court has given interim directions. (See pdf attachment).&amp;nbsp;&amp;nbsp;&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '213a6e624c92f68c8db8268db8b7093e.jpg', 'ea6ff5f84e6e97b8405d196d0e68495f.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-06', 0, '2021-03-11 18:25:18', '2021-04-25 07:33:08'),
(16, '2aMntSiFaQ2wkIzXtZf6mxDUF', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Veerashaiva Lingyat Board. Government gives Rs. 500 crores to Board and not even Rs. 25 Crores to Advocates who suffered due to pandemic - Petitioner submits to High Court.', '&lt;h4&gt;S.Basavaraj vs State of Karnataka. Writ Petition 14426 of 2020 was taken up for hearing on 31 March 2021. &lt;b style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;i&gt;Petition Copy enclosed&amp;nbsp;&lt;/i&gt;&lt;/b&gt;&lt;/h4&gt;&lt;h4&gt;The same was adjourned to 9th April for hearing finally. Bringing to the notice of the High Court.&lt;/h4&gt;&lt;h4&gt;S.Basavaraj, petitioner submitted to the Court that the present government did not release even 25 crores to lawyers when approached and has earmareked Rs. 500 crores to the Board only with an eye on election and to get votes. &lt;/h4&gt;&lt;h4&gt;Since the pleadings are completed, the Court has fixed the matter for final hearing .&amp;nbsp;&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '51a1d395affc73d3d996dddb98b55247.PNG', '986f5887314ffe97869e3b4212e9ee84.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-31', 0, '2021-04-02 02:33:39', '2021-04-14 14:27:56'),
(17, 'f8dn4wxFlhmHAY10Jx6WJY8eV', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Make arrangements for providing vaccination to Judicial Officers, staff members and the members of the Bar -Karnataka Chief Justice directs District Judges. 1 April 2021  ', '&lt;h4&gt;April 1, 2021&nbsp;&lt;br&gt;ORDER&lt;br&gt;I am informed that from April 1, 2021, vaccination for&nbsp; COVID-19 will be available to all citizens who are aged 45 years&nbsp;&lt;br&gt;and above.&nbsp;&lt;br&gt;During the pandemic of COVID-19, the judiciary in Karnataka&nbsp; has made the best possible efforts to continue the functioning of&nbsp; all the Courts. During the past few weeks, the cases of COVID-19&nbsp; infection in the State are raising. One of the best methods to&nbsp; prevent the spread of COVID-19 is to ensure that the Judicial&nbsp; Officers, the members of the Staff and the members of the Bar&nbsp; who are eligible for receiving vaccination take the vaccination&nbsp;immediately.&nbsp;&lt;br&gt;All the Principal District and Sessions Judges/Unit Heads shall&nbsp;persuade all the Judicial Officers who are aged 45 years and above&nbsp;to take the vaccination at the earliest.&nbsp;&lt;br&gt;It is advisable to prepare a list of staff members working in&nbsp;every District and Taluka Court who have completed the age of 45&nbsp;yearsand above. The list of such staff members should be made&nbsp;available to the Senior Officials working in the respective Courts as&nbsp;well as the Judicial Officers, who will make an endeavour to&nbsp;persuade the staff members to immediately take vaccination.&nbsp;&lt;br&gt;All the Principal District and Sessions Judges/Unit Heads shall&nbsp;hold meetings with the office bearers of the Bar Associations and 2&nbsp;request them to encourage the members of the Bar who are&nbsp;eligible to receive the vaccine to immediately take the vaccine.&nbsp;&lt;br&gt;The Principal District and Sessions Judges and the senior most Judicial Officers at the Taluka places shall endeavour to make&nbsp;arrangements for providing vaccination to Judicial Officers, staff&nbsp;members and the members of the Bar by coordinating with the&nbsp;District or Taluka Administration, as the case may be.&nbsp;&lt;br&gt;All the Principal District and Sessions Judges/Unit Heads are&nbsp;requested to submit compliance reports to the Registrar&nbsp;(Infrastructure and Maintenance), High Court of Karnataka,&nbsp;incorporating the details of the Judicial Officers and staff members&nbsp;who have taken vaccination. The report be submitted by April 16,&nbsp;2021. Needless to add that the same steps shall be taken to&nbsp;ensure that the follow-up second dose of the vaccine is&nbsp;administered to all concerned as per the prescribed schedule.&nbsp;&lt;br&gt;&nbsp;&lt;br&gt;Sd/-&nbsp;&lt;br&gt;(ABHAY SHREENIWAS OKA)&nbsp;&lt;br&gt;CHIEF JUSTICE&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;i&gt;Photo courtesy, LiveLaw&lt;/i&gt;&lt;/p&gt;', '5f2e369a07e38bad25cdd6ca2102b255.jpg', 'd9acafee0d8c01f24929d70a62ee4202.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-01', 0, '2021-04-03 00:42:52', '2021-04-25 07:33:05'),
(18, 'ze1a0Ea1rA5Kg64sEHMZoJglm', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '?????? ', '&lt;p&gt;??????&amp;nbsp;&lt;br&gt;&lt;/p&gt;', '53cfe7942b52a570a111af68bff57adf.jpg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-25', 0, '2021-04-25 18:19:10', '2021-04-25 07:49:21');
INSERT INTO `news` (`news_id`, `news_key`, `category_key`, `news_title`, `news_description`, `news_image`, `news_attachment`, `news_author`, `news_date`, `news_status`, `news_date_added`, `news_date_updated`) VALUES
(19, 'lDjtpwaVHmy5hRygJQPlZ8rCz', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'The Judge who saved the sanctity of the Hampi World Heritage area - Shri. Mohan Shantanagoudar-Justice personified. ', '&lt;h4&gt;Hampi, the erstwhile capital of Vijaynagara Empire from 14th to 16th century had a glorious past. The empire reigned supremacy under the emperor Krishnadevaraya. The Vijaynagar Empire stretched over at least three states, Karnataka, Maharashtra and Andhra Pradesh.&nbsp;&lt;br&gt;Government of India announced Hampi as an international destination centre and Archeological Survey of India is protecting and preserving as many as 56 major monuments known for their rich cultural heritage and historical value.&nbsp;&lt;br&gt;Later, Hampi was declared as World Heritage Area in the year 1982 and the site was inscribed as Hampi Group of Monuments in the year 1986 by UNESCO.&nbsp;&lt;br&gt;However, growing urbanization with many illegal and unauthorized developments in and around Hampi and tourism related illegal activities in Virapapurgadde, had threatened the natural, cultural and archaeological aspects due to poor conservation plans. UNESCO World Heritage Committee observed these changes with concern and declared the Hampi World Heritage Area into the endangered list in the year 1999.&nbsp;&lt;br&gt;Government of Karnataka responded to this alarming state and set up&nbsp; Hampi World Heritage Area Management Authority (HWHAMA) by passing the Hampi World Heritage Area Management Authority Act, 2002.&nbsp;&lt;br&gt;Hampi World Heritage Area, includes 8 villages of Hospet Taluk, Bellary Dist and 2 villages of Gangavathi Taluk, Koppal. The site is divided by river Thungabhadra in two parts, the northern part of the site is located in the Gangavati Taluk of Koppal District and Southern part of the site is located in the Hospet Taluk of Bellary District.&nbsp;&lt;br&gt;Government of Karnataka under Section 19(3) of the Karnataka Ancient and Historical Monuments and Archaeological Sites and Remains Act, 1961 by Notification dated: 2:10:1988 declared 8 villages as &lsquo;Archaeological sites&rsquo;. Heritage Area includes the whole of the area comprising the core area zone, buffer zone and peripheral zone. The Planning Area in all measures about 236.46 sq. Kms and nearly 172 Sq. kms of area lies to the south of the river and 64 Sq. kms of area to the North of the river.&nbsp;&lt;br&gt;The developments in Hampi are still posing threat to the world heritage site. Hampi village is functioning as a reception centre to foreign tourists and nearly 90% of the houses in front of Virupaksha temple were running illegal guest houses. This changed the socio-economic fabric and life style of the people of this area. Unauthorized Hotels and resorts were constructed in utter disregard and violation of Act 2002.&lt;br&gt;Virapuragadde is a river island formed on the bank of Tungabhadra River and it is stated to be environmentally sensitive area and important archaeological site. However, illegal activities, such as resorts, sale of narcotic drugs, prostitution and other heinous and anti-social activities were being carried out right under the nose of authorities and the Police. The forest area was encroached by the anti-social elements to carry on illegal activities.&nbsp;&lt;br&gt;At this juncture, about 101 religious heads under the leadership of Jagadguru Dr. Sangana Basava Mahaswamyji, Shri Kotturswamy Kalyana Kendra, Hospet, Shri. Siddalingaswamiji, Suvarnagiri Viraktamath, Sindanur, Shri. Shantamalla Swamiji, Adavi Amareshwar Kshetra, Sindanur, Shri. Mari Mahanthswamiji, Oppatteshwar Math, Hospet and Shri. Mahanthaling Shivacharya Hiremath, Manvi, started a revolution to save Hampi and submitted several&nbsp; representations to the Chief Minister and other Ministers from time to time. Absolutely no action whatsoever was initiated by the Government to remove the illegal structures which forced these swamijis to approach the Karnataka High Court of Karnataka by way of public interest litigation in Writ Petition 29843/2009.&lt;br&gt;The Hon&#039;ble Court disposed the public interest litigation on 22 January 2016 directing, mainly, Hampi World Heritage Area Management Authority to take action. However, even after lapse of a year, the authority completely failed to remove the structures. The PIL petitioners initiated contempt proceedings against the authority before the High Court which is pending. I am representing the petitioners in contempt proceedings. The Hon&#039;ble Court is monitoring the situation.&nbsp;&lt;br&gt;Pursuant to the orders in PIL, when Hampi World Heritage Area Management Authority initiated action against illegal resorts in Virapuragadde river island run by drugs mafia, several writ petitions were filed before the High Court and all of them were dismissed. The matters were taken to the Supreme Court in Sakkubai and others vs State of Karnataka and others, Civil Appeal 1443-1456 of 2020.&nbsp;&lt;br&gt;The matters were listed before the bench consisting Justice Mohan M. Shantanagoudar and Justice R. Subhash Reddy. After hearing exhaustive arguments, Justice Shantanagoudar delivered the judgment on 11 February 2020 dismissing all appeals and declaring that construction of rooms, thatched roof huts, temporary structures, and buildings by the Appellants to carry on the business of hotels, restaurants, or guesthouses in Virupapura Gaddi was in violation of the 1961 Act. Further, the bench also held that the HWHAMA had the authority shall proceed with the demolition of such illegal constructions. A positive direction was issued to proceed with the demolition of the illegal structures erected in Virupapura Gaddi within a period of one month from the date of the order.&nbsp;&lt;br&gt;Pursuant to the order, the illegal resorts were completely demolished. However, few unscrupulous operators approached the High Court of Karnataka again and obtained orders against demolition. When this was brought to the notice of the bench, Justice Shantanagoudar came down heavily on such practice and ordered that no court shall grant or continue any interim order in this regard. The operative portion of the order read &ldquo;&hellip;.neither the High court nor any other court shall entertain any matter pertaining to the subject on hand for granting extension of time or any other relief in favour of the appellants.&rdquo; Needless to say, all interim orders granted by the Karnataka High Court were vacated and further demolition of structures was carried on.&nbsp;&lt;br&gt;The contempt proceedings are pending before the High Court of Karnataka in so far as the structures which exist in front of Virupaksha temple. The Hon&#039;ble Court has initiated strictest action in this regard and has issued several directions. The bench headed by Justice Arvind Kumar has been monitoring the scenario.&nbsp;&lt;br&gt;Justice Mohan M Shantanagoudar is praised for his contributions as a lawyer, prosecutor, Bar Council Chairman and as a Judge. But his biggest contribution to Karnataka is saving Hampi World Heritage, which act of kindness, the generations to come shall cherish. &lt;/h4&gt;&lt;h4&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;S.Basavaraj, Advocate, Daksha Legal, Bangalore.&nbsp;&lt;/h4&gt;&lt;div&gt;&lt;br&gt;&lt;/div&gt;', 'b443111ab6fe1ae99bd5f57484d8eb06.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-26', 0, '2021-04-26 19:16:31', '2021-06-22 05:41:32'),
(20, '1C0aKAH5SZTpFxJCwfuAFDFh3', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'The situation is scary. Consider approaching hospitals of different departments like ESI, nursing colleges, Red Cross, Armed forces, Air force and other organisations - Karnataka High Court asks the Government. ', '&lt;h4&gt;&quot;The situation appears to be very scary.&quot; Karnataka High Court directs the State Government to take immediate action&lt;br&gt;Order Link: &lt;a href=&quot;https://karnatakajudiciary.kar.nic.in/judgements/WP%206435.2020-23.4.21.pdf&quot; target=&quot;_blank&quot;&gt;https://karnatakajudiciary.kar.nic.in/judgements/WP%206435.2020-23.4.21.pdf&lt;br&gt;&lt;/a&gt;Chief Justice Abhay Shreeniwas Oka and Justice Aravind Kumar&lt;br&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;&lt;b&gt;Order dated 23.04.2021 in W.P.No.6435/2020 and connected matters&lt;/b&gt;&lt;/span&gt;&lt;br&gt;1. The learned Additional Advocate General has submitted a draft of the compliance report and states that the compliance report is not finalised.&lt;br&gt;2. During the course of the hearing, shocking facts have been revealed. The learned counsel appearing for the Bruhat Bengaluru Mahanagara Palike (for short, &quot;BBMP&quot;) in presence of the Chief Health Officer of BBMP disclosed the available beds position as of now. The situation appears to be very scary. As of now, there are only 32 HDU beds vacant in the City of Bengaluru. There are only 11 beds vacant of ICU plus ventilator and not a single ICU bed is available.&lt;br&gt;3. Yesterday, 15,244 positive cases have been reported in the City of Bengaluru. Thus, it can be safely said that there are hardly any beds available today in all the three categories which are material. Considering the manner in which the surge of COVID-19 positive cases has continued, we direct the State&nbsp;Government and BBMP to immediately step into action and ensure that additional bed facility is created possibly by using the existing COVID centres. The State Government and all the concerned authorities shall immediately identify the availability of all the three categories of beds available in the nearby districts around Bengaluru Urban District.&lt;br&gt;4. We direct the State Government to take immediate action. The reason being that if there are more COVID-19 cases reported today, tomorrow and day after tomorrow, there will be no beds available in any of the three categories.&lt;br&gt;5. On the next date, the State Government and BBMP must furnish the data of additional beds created between today and the&lt;br&gt;next date.&lt;br&gt;6. Immediate steps shall be taken to implement the direction contained in the order dated 22nd April 2021 for displaying of data about the availability of Remdesivir medicine. On the same lines, for the benefit of smaller hospitals, the State Government shall create a database of information regarding available oxygen supply in and around the City of Bengaluru. There is already a&nbsp;direction issued about the updation of data of availability of Remdesivir drug in paragraph 10 of our order dated 22nd April 2021. On the same lines, the database shall be created for the supplies of oxygen in the city.&lt;br&gt;7. We direct the State Government to set up help desks outside the COVID hospitals in the City for helping the COVID-19 patients who cannot be admitted in that particular hospital. The help desks shall also provide information regarding the availability of Remdesivir medicine in the City.&lt;br&gt;8. I.A No.2 of 2021 has been filed in Writ Petition No.8619 of 2020. We permit the learned counsel for the petitioner in the said petition to serve a notice on the proposed fourth respondent along with the copies of all the material requesting the proposed respondent to appear before the Court and assist the Court on the next date. A copy of this order will be available on 26th April&lt;br&gt;2021. A copy of the order be provided to the proposed respondent by the learned counsel for the petitioner.&nbsp;&lt;br&gt;9. The draft compliance report also records that cremation of COVID-19 patients can be allowed in six remaining crematoriums&lt;br&gt;in the Bengaluru city.&lt;br&gt;10. On the next date, the State Government will come out with clear figures of requirement of oxygen and the availability of oxygen in the State.&lt;br&gt;11. The State Government will also come out with the decision to purchase Remdesivir drug directly from the manufacturers so&lt;br&gt;that the State Government can equitably distribute the same to various hospitals as per their demands.&lt;br&gt;12. List the petition on 27th April 2021 at 11.00 a.m.&lt;br&gt;13. The learned Additional Advocate General states that there will be difficulty in creating additional beds in the COVID centres. The State Government shall consider of approaching the hospitals of the different departments, hospitals of ESI, nursing colleges, Red Cross, Armed forces, Air force and other organisations.&nbsp;&lt;br&gt;14. An exhaustive compliance report shall be filed by BBMP and the State Government by 26th April 2021 evening. Soft copies be forwarded to all the advocates appearing for the parties.&lt;br&gt;15. When we are dictating the order, the learned counsel appearing for BBMP states that there are 46 beds available in the category of HDU.&lt;br&gt;Sd/-&lt;br&gt;&nbsp;CHIEF JUSTICE&lt;br&gt;&nbsp;Sd/-&lt;br&gt;&nbsp;JUDGE&lt;br&gt;sp/AHB&nbsp;&lt;/h4&gt;', 'ae1ee37d6ed073b207299622b14ccbea.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-23', 0, '2021-04-26 19:53:54', '2021-06-22 05:41:26'),
(21, 'xPNaz82Wz3P4PDJK9mXGzpcDu', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'E-Courts Project. Digital Courts Vision and Roadmap Phase-III.  The Supreme Court e-committee calls for inputs, feedback and suggestions.  ', '&lt;h4&gt;&lt;b&gt;1. &lt;/b&gt;The Karnataka High Court website displays Digital Courts Vision &amp; Roadmap Phase III of the eCourts Project recently released by the e-committee of the Supreme Court. The draft proposal is prepared by prepared by an expert panel of the vision documents for the third phase of the e-Courts project. It highlights various key goals, including open digital hearings like live-streaming and providing transcriptions of court proceedings to lawyers and litigants. The e-panel of the top court has put the vision document for phase III on its website and invited inputs, feedback and suggestions from various stakeholders, including lawyers and the public. Inputs, feedback and suggestions on the vision document be submitted to &lt;a href=&quot;http://ecommittee@aij.gov.in&quot; target=&quot;_blank&quot;&gt;ecommittee@aij.gov.in&nbsp;&lt;/a&gt;&lt;br&gt;&lt;b&gt;2.&nbsp;&lt;/b&gt;The Supreme Court&#039;s e-committee, headed by Justice D Y Chandrachud, comprises experts including judicial, legal and information technology (IT) experts overseeing the e-Courts project conceptualised under the National Policy and Action Plan for Implementation of Information and Communication Technology in the Indian Judiciary-2005.&nbsp;&lt;br&gt;&lt;b&gt;3.&nbsp;&lt;/b&gt;The revolutionary steps can be seen from one example &ndash; &ldquo;Live-streaming or sharing recorded court proceedings can enable courts to become more open. Similarly, leveraging technology to enable transcriptions of court proceedings can enable courts to realise their full potential to become courts of record.&quot;&lt;br&gt;Under the heading &ldquo;Benefits for Stakeholders &ldquo;, the vision document enlists the following for the citizens and lawyers;&lt;br&gt;&lt;b style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;For Citizens&nbsp;&lt;/b&gt;&lt;br&gt;?Better scheduling mechanisms, online digital filings, and different mediums of hearings will provide certainty of events, increase access to courts from anywhere, and advance access to timely justice.&nbsp;&lt;br&gt;?Digital orders in multiple regional languages will significantly improve understanding of the process and access to justice.&nbsp;&lt;br&gt;?E-filings and virtual hearings will reduce legal and travel costs, thereby reducing the costs of accessing justice.&nbsp;&lt;br&gt;?Proactive alerts and information, live streaming of cases, and open data that would constantly evolve and better the system, will increase transparency and trust in the system.&nbsp;&lt;br&gt;?Case information across various courts can be uniform in structure, which will enable tracking of case status in various courts simpler.&nbsp;&lt;br&gt;&lt;b style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;For Lawyers&nbsp;&lt;br&gt;&lt;/b&gt;?Seamless filings, service of summons / prior notice to the opposite party and hearings from their cities or homes will bring time and cost efficiencies to their practice.&nbsp;&lt;br&gt;?Make available the same records of files as the courts since the digital case file available with the lawyer / litigant will be identical to the court record of the case. Further, changes being in real time, will reduce the need for inspection or regular updation of case files by the lawyer / party. This will also avoid issues arising from loss of case records or the need to reconstruct case files.&nbsp;&lt;br&gt;?Better scheduling will enable better time utilisation.&nbsp;&lt;br&gt;?Orders from different courts made available in regional languages will enable smoother transition of cases from court to court.&nbsp;&lt;br&gt;?Digital hearings and e-filings will enable the practice of law to become more inclusive for women and differently abled lawyers.&nbsp;&lt;br&gt;?Greater access to information about similar cases will support crafting legal arguments and strategies.&lt;br&gt;&lt;b&gt;4.&nbsp;&lt;/b&gt;Phase III will focus on enabling courts to deploy quality digitally enabled hearings, based on nature and type of case. This will have to be supported by efforts by the High Courts to identify classes/ types of cases where in-person hearings should be retained, and where various forms of digital hearings can be adopted. Sound analysis of stakeholder interest is vital before initiating such deployment particularly in matters of criminal justice where additional safeguards may be necessary for the rollout of digital hearings. Further High Courts must re-engineer processes and specify time limits where possible. Such process re-engineering assumes importance in relation to tasks such as marking of documents in suits and computation of damages payable in workmen compensation disputes which may be accomplished without application of judicial mind therefore eliminating the need for a traditional hearing.&lt;br&gt;&lt;b&gt;5. &lt;/b&gt;It will prioritise providing lawyers and litigants with technologically enabled transcriptions of court proceedings from audio or spoken format into a typed digital format immediately with the order.&lt;br&gt;&lt;b&gt;6.&nbsp;&lt;/b&gt;One of the biggest problem is service of notice. Phase III of the Project promises to leverage and build upon the Phase 2 E-filing module and NSTEP application to enable service process by automatically enabling service on parties via email / SMS, where possible, with built in systems for confirmation of receipt. To enable requisite action by the petitioner, it will enable the proactive disclosure of the status of service of notice to the petitioner prior to the scheduled date of hearing. Subject to requirements of law, it will also integrate the payment of process fee along with court fees to minimise delay. It can also provide alerts to necessary actors by leveraging applicable court rules to ensure compliance with specified timelines.&lt;/h4&gt;&lt;h4&gt;&lt;b&gt;S.Basavaraj, Advocate and Member, Karnataka State Bar Council, Bengaluru&lt;/b&gt;&lt;/h4&gt;&lt;h4&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 1.3125rem;&quot;&gt;&nbsp;&lt;/b&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;Photo courtesy Hofstra Law&nbsp;&lt;/span&gt;&lt;/h4&gt;', 'd093fa16befee281d7b02ab1231a8adb.jpg', 'b1d269fbf393fbd700b155142c66970f.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-29', 0, '2021-04-29 06:14:07', '2021-06-22 05:41:19'),
(22, 'LF71vweN8RxNdA7xFdpL0KAsm', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'We appreciate Government officials, officials attached to various agencies and the instrumentalities of the State including BBMP, the doctors, nurses and paramedical workers, who are rendering valuable services to the society at large.- Karnataka High Court while issuing Covid related directions. 29 April 2021', '&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Chief Justice Abhay Shreeniwas Oka and Justice Aravind Kumar&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;Order in W.P.No.6435 of 2020 dated 29 April 2021 and connected matters&lt;br&gt;ORDER&lt;br&gt;1. Before we go into the details, it is necessary for the benefit&lt;br&gt;of the State and Central Governments as well as for all the&lt;br&gt;agencies and instrumentalities of the State to remind them of their&lt;br&gt;obligations under the Constitution. In the case of DEVIKA&lt;br&gt;BISWAS vs. UNION OF INDIA AND OTHERS (2016) 10 SCC 726, the Apex Court has&lt;/h4&gt;&lt;h4&gt;reiterated that right to life under Article 21 of the Constitution of&lt;br&gt;India encompasses into it the right to live a dignified and&lt;br&gt;meaningful life which will include right to health. The Apex Court&lt;br&gt;has reiterated that right to health is an integral part under Article&lt;br&gt;21 of the Constitution of India.&lt;br&gt;2. Way back in the year 1984, in the case of BANDHUA&lt;br&gt;MUKTI MORCHA VS UNION OF INDIA &amp; OTHERS (1984) 3 SCC 161, the Apex Court&lt;/h4&gt;&lt;h4&gt;has held that protection afforded by Article 21 of the Constitution&lt;br&gt;of India is a protection to the health and strength of the workers,&lt;br&gt;men and women. The same principles have been reiterated by&lt;br&gt;the Apex Court in the case of CONSUMER EDUCATION &amp;&lt;br&gt;RESEARCH CENTRE AND OTHERS vs. UNION OF INDIA &amp;&lt;br&gt;OTHERS (1995) 3 SCC 42&lt;/h4&gt;&lt;h4&gt;RIGHT TO HEALTH UNDER ARTICLE 21 OF THE&lt;br&gt;CONSTITUTION OF INDIA&lt;br&gt;3. Today, we are dealing with the extraordinary&lt;br&gt;situation created by the second wave of COVID-19. Those who&lt;br&gt;are infected with COVID-19 are looking upon the State and its&lt;br&gt;agencies and instrumentalities to provide them the best possible&lt;br&gt;medical treatment and best possible health care. COVID-19 is&lt;br&gt;such a disease which requires specialised treatment. Therefore,&lt;br&gt;it is necessary for us to remind the State Government, the Central&lt;br&gt;Government and all the agencies and instrumentalities of the&lt;br&gt;State that as right to health is an integral part of Article 21 of the&lt;br&gt;Constitution of India, it is the obligation all the authorities to make&lt;br&gt;best possible efforts to provide medical treatment to all those who&lt;br&gt;are infected with COVID-19. Let all the authorities remember that&lt;br&gt;ultimately they are dealing with the fundamental right of the&lt;br&gt;citizens under Article 21 of right to life.&lt;br&gt;&lt;br&gt;AVAILABILITY OF COVID-19 BEDS&lt;br&gt;4. Now, we turn to the issue of availability of the beds.&lt;br&gt;The learned counsel appearing for the Bruhat Bengaluru&lt;br&gt;Mahanagara Palike (BBMP) has stated that in the City of&lt;br&gt;Bengaluru, after 27th April 2021, the bed capacity has been&lt;br&gt;increased by adding beds as under:&lt;br&gt;(i) General beds - 329&lt;br&gt;(ii) HDU beds - 425&lt;br&gt;(iii) ICU with ventilator - 21&lt;br&gt;(iv) ICU - 29&lt;br&gt;This marginal increase in two days may not be of any major relief&lt;br&gt;to the patients. He states that today at 9.30 a.m, the availability&lt;br&gt;of beds in all the categories in the city of Bengaluru was as under:&lt;br&gt;(i) HDU beds - 121&lt;br&gt;(ii) ICU with ventilator - 14&lt;br&gt;(iii) ICU - 30&lt;br&gt;This is to be considered in the context of the fact that yesterday&lt;br&gt;the figure of COVID-19 positive cases in the City has taken a&lt;br&gt;sudden jump and it has crossed 22,000.&lt;br&gt;5. The learned Standing Counsel appearing for the&lt;br&gt;Central Government states that the South Western Railways is in&nbsp;&lt;br&gt;a position to provide approximately 300 beds in Bengaluru,&lt;br&gt;Mysuru and Hubballi. He states that the beds can be made&lt;br&gt;available in railway coaches and these beds have facility of&lt;br&gt;oxygen. As far as the City of Bengaluru is concerned, we direct&lt;br&gt;BBMP and the State Government to take immediate steps to&lt;br&gt;contact the officers of the South Western Railways and take over&lt;br&gt;all the beds which can be made available by the Railways in the&lt;br&gt;City of Bengaluru. Similarly, the State Government or the&lt;br&gt;concerned Authority under the directions of the State Government&lt;br&gt;shall take immediate steps to take over the beds available with&lt;br&gt;Railways at Mysuru and Hubbali.&lt;br&gt;6. As regards the availability of beds with the Army and&lt;br&gt;Air Force in the City of Bengaluru, the learned Standing Counsel&lt;br&gt;appearing for the Central Government states that the beds which&lt;br&gt;are available in the City are occupied by the families of the Army&lt;br&gt;and Air Force personnel and they are not in a position to provide&lt;br&gt;extra beds. There is already a letter addressed by the Additional&lt;br&gt;Chief Secretary to the Health and Family Welfare Department of&lt;br&gt;the State Government to the Air Vice Marshal requesting him to&lt;br&gt;make available beds for COVID-19 patients.&lt;br&gt;7. In the situations created by the disasters, the Army,&lt;br&gt;Air Force and Navy have always responded and rendered&lt;br&gt;valuable help to the civic administration. The situation in&lt;br&gt;Bengaluru is very critical. We, therefore, direct the Senior&lt;br&gt;Officers of BBMP including Chief Commissioner and Senior&lt;br&gt;Officers of the State Government to immediately hold a meeting&lt;br&gt;with the officers of the Army and Air Force in the City. We hope&lt;br&gt;and trust that the Army and Air Force will go out of the way to&lt;br&gt;assist the civic administration by creating large number of beds&lt;br&gt;with oxygen.&lt;br&gt;8. As regards the bed strength in those districts where&lt;br&gt;there are more than 5000 active COVID-19 cases, the State&lt;br&gt;Government has placed the figures on record. The State&lt;br&gt;Government has also stated in the written submissions that within&lt;br&gt;a span of 14 months, the availability of beds in these districts has&lt;br&gt;substantially increased.&lt;br&gt;9. At this stage, we must note the principles laid down&lt;br&gt;in the Disaster Management Act, 2005 (for short, &quot;the said Act of&lt;br&gt;2005&quot;). A perusal of Sections 6(2)(i) and 18(2)(h) will show that&nbsp;&lt;br&gt;all the authorities under the said Act of 2005 are under an&lt;br&gt;obligation to be in the state of preparedness to deal with the&lt;br&gt;disaster situation.&lt;br&gt;10. In the context of the figures mentioned by the State&lt;br&gt;Government in paragraph 16 of the written submissions filed&lt;br&gt;today, the State Government will have to be in the state of&lt;br&gt;preparedness by making an estimate of beds which may be&lt;br&gt;required in the near future in Bengaluru and in all other major&lt;br&gt;cities of the State. Unless the State Government prepares the&lt;br&gt;estimate of the requirement of the beds in various categories, it&lt;br&gt;may not be possible to provide effective relief to the patients of&lt;br&gt;COVID-19. We, therefore, direct the State Government to place&lt;br&gt;on record on or before the next date, the steps taken to prepare a&lt;br&gt;broad estimation of the number of beds required in near future&lt;br&gt;and the steps taken to enhance the intake capacity of all the&lt;br&gt;COVID-19 hospitals.&lt;br&gt;11. Dr.Prasanna H.M., the President of Private Hospitals&lt;br&gt;and Nursing Homes Association (PHANA) of Karnataka is present&lt;br&gt;online. He states that within 24 hours, a portal will be launched&lt;br&gt;by the said organisation displaying the data of various categories&nbsp;&lt;br&gt;of beds available in all the categories including 50% quota&lt;br&gt;reserved for the State Government. He states that instructions&lt;br&gt;will be given to display the availability of the beds at conspicuous&lt;br&gt;places including the entry points of the private hospitals in terms&lt;br&gt;of the directions issued by this Court. He also states that&lt;br&gt;instructions will be issued to all the hospitals to ensure that&lt;br&gt;Remdesivir drug is prescribed only to those patients who need&lt;br&gt;the same immediately. We take on record, the aforesaid&lt;br&gt;assurances.&lt;br&gt;12. We have already issued directions to set up&lt;br&gt;helpdesks outside all the hospitals in the City of Bengaluru which&lt;br&gt;are COVID hospitals. The State Government shall immediately&lt;br&gt;report implementation of all the said directions as stated earlier.&lt;br&gt;The helpdesks will also deal with the grievances of the citizens&lt;br&gt;regarding the non-availability of beds.&lt;br&gt;AVAILABILITY OF REMDESIVIR&lt;br&gt;13. Now, coming to the issue of availability of Remdesivir&lt;br&gt;drug, firstly, the learned Advocate General and the learned&lt;br&gt;Additional Government Advocate stated that there is a national&nbsp;&lt;br&gt;quota of allocation of Remdesivir vials. The quota for the State of&lt;br&gt;Karnataka is of 1,22,000 vials for the period between 21st April to&lt;br&gt;30th April 2021. Dr.Prasanna makes a submission that the State&lt;br&gt;Government will need at least 10,000 vials of Remdesivir per day&lt;br&gt;in the city of Bengaluru in the present day situation.&lt;br&gt;14. As regards the supply of Remdesivir medicine to the&lt;br&gt;patients admitted on beds reserved for private hospitals, the State&lt;br&gt;Government has stated that the orders for the supply of&lt;br&gt;Remdesivir medicine are being enrouted only through the State&lt;br&gt;Government and it is the State Government which decides the&lt;br&gt;quantity of supply for each hospital. The learned Additional&lt;br&gt;Government Advocate states that whenever such requests come&lt;br&gt;from the private hospitals, the State Government is not permitting&lt;br&gt;placing of orders for the entire quantity claimed by the private&lt;br&gt;hospitals. The quantity in the orders is restricted. The State&lt;br&gt;Government must place on record the criteria applied for&lt;br&gt;restricting the demands made by the private hospitals. There has&lt;br&gt;to be a rational criteria for this purpose which will stand the test of&lt;br&gt;Article 14 of the Constitution of India.&lt;br&gt;15. As regards the supply of Remdesivir medicine to&lt;br&gt;patients admitted in public hospitals and the patients admitted in&lt;br&gt;private hospitals in 50% quota of the State Government, factual&lt;br&gt;statements have been made in paragraph 14 of the written&lt;br&gt;submissions. We may add here that Dr.Prasanna stated that as&lt;br&gt;far as the supply of Remdesivir medicine to the patients who are&lt;br&gt;admitted on 50% public quota of beds is concerned, 90% of the&lt;br&gt;requirement is being met by the State Government.&lt;br&gt;16. Paragraph 14 records the details of the orders placed&lt;br&gt;for Remdesivir drug. We direct the State Government to make an&lt;br&gt;estimate of the quantum of Remdesivir vials required in public&lt;br&gt;hospitals in the State as well as for 50% beds reserved in private&lt;br&gt;hospitals and submit a requisition to the Central Government&lt;br&gt;accordingly. We direct the State Government to submit a&lt;br&gt;representation for increasing the outer limit of the allocation fixed&lt;br&gt;by the Central Government within two days from today. We direct&lt;br&gt;the Central Government to immediately consider the requisition of&lt;br&gt;the State Government for increase in the allocation to the State of&lt;br&gt;Karnataka. Considering the seriousness of the situation in the&lt;br&gt;State of Karnataka, we direct the Central Government to take a&nbsp;&lt;br&gt;decision on the requisition submitted by the State Government&lt;br&gt;within three days from the date of receipt of the requisition.&lt;br&gt;17. The learned Advocate General as well as the learned&lt;br&gt;Additional Government Advocate stated that Remdesivir medicine&lt;br&gt;is not available in the open market and for Government hospitals&lt;br&gt;and 50% quota of Government beds in private hospitals, the State&lt;br&gt;Government is procuring the same through the Karnataka State&lt;br&gt;Medical Supplies Corporation Limited (for short, &quot;KSMSCL&quot;). The&lt;br&gt;learned Advocate General states that if the private hospitals&lt;br&gt;instruct the patients&#039; relatives to get Remdesivir vials, the relatives&lt;br&gt;can contact the Deputy Drugs Controller on the telephone&lt;br&gt;numbers mentioned in paragraph 31 of the written submissions.&lt;br&gt;We direct the State Government and BBMP to ensure that on the&lt;br&gt;helpdesks outside all COVID-19 hospitals, the details of the&lt;br&gt;phone number of the Deputy Drugs Controller and his e-mail&lt;br&gt;address shall be prominently displayed so that the relatives are&lt;br&gt;immediately able to contact the Deputy Drugs Controller for the&lt;br&gt;supply of Remdesivir medicine.&nbsp;&lt;br&gt;AVAILABILITY OF OXYGEN&lt;br&gt;18. Now coming to the availability of oxygen, today the&lt;br&gt;State Government has clarified the stand taken on the earlier&lt;br&gt;date. it is pointed out today that there is a cap of 802 metric&lt;br&gt;tonnes per day on the allocation of medical oxygen to the State.&lt;br&gt;The learned Government Advocate stated that in fact, the&lt;br&gt;production of oxygen in the State exceeds the total requirement of&lt;br&gt;the State. But in view of the cap of 802 metric tonnes per day,&lt;br&gt;the State cannot utilize the quantity in excess of 802 metric&lt;br&gt;tonnes. As noted in the last order, estimation of requirement of&lt;br&gt;oxygen in the State of Karnataka as on 30th April 2021 is of 1,471&lt;br&gt;metric tonnes per day. We direct the State Government to&lt;br&gt;immediately submit a representation to the concerned authority of&lt;br&gt;the Central Government setting out the projected requirement of&lt;br&gt;oxygen per day for at least 7 more days from tomorrow. We&lt;br&gt;direct the Government of India to take an immediate decision on&lt;br&gt;the requisition which may be submitted by the State Government.&lt;br&gt;As stated in the last order, by way of an illustration, on 30th April&lt;br&gt;2021, the State will have shortage of at least 600 metric tonnes of&nbsp;&lt;br&gt;oxygen. The Central Government shall take a note of ever rising&lt;br&gt;figure of positive cases in the city.&lt;br&gt;19. The decision of the Central Government regarding&lt;br&gt;increase in the cap on the quantity of Remsidivir and oxygen shall&lt;br&gt;be placed on record by Monday i.e., 3rd May 2021. The soft&lt;br&gt;copies of the decisions shall be supplied to all the learned&lt;br&gt;advocates appearing for the parties.&lt;br&gt;ISSUE OF FOOD SECURITY AND OTHER ISSUES&lt;br&gt;20. Due to lockdown and a huge surge in the number of&lt;br&gt;positive COVID cases in the State, the issue of food security of&lt;br&gt;the weaker sections of the society and the issue of relief to the&lt;br&gt;workers will require urgent attention. The learned Advocate&lt;br&gt;General stated that on Saturday, there will be a meeting of the&lt;br&gt;members of the Bar appearing in this group of matters to discuss&lt;br&gt;the issue. The lockdown has started 2 days back. The effect of&lt;br&gt;the lockdown on the weaker sections of the Society such as&lt;br&gt;unorganized labour, transgenders, etc will have to be assessed.&lt;br&gt;Therefore, it will be appropriate if the learned Advocate General&nbsp;&lt;br&gt;holds a meeting of various NGOs and other stakeholders working&lt;br&gt;in the field so that State Government can assess the situation&lt;br&gt;created by the impact of lockdown on these classes of the&lt;br&gt;society. Some submissions have been made in the written&lt;br&gt;submissions on these aspects. The State Government will come&lt;br&gt;out with the concrete steps, which they propose to take for&lt;br&gt;helping the weaker sections of the society by providing them&lt;br&gt;ration, etc. The response of the State shall be filed on the next&lt;br&gt;date. As stated earlier, the State Government shall consider the&lt;br&gt;views of all the stakeholders.&lt;br&gt;OTHER ISSUES&lt;br&gt;21. During the course of hearing, a concern was&lt;br&gt;expressed that even though no hospitalization was advised, there&lt;br&gt;are many COVID-19 patients who are getting admitted into&lt;br&gt;hospitals and therefore, the deserving patients are not getting&lt;br&gt;beds. Therefore, the State Government and BBMP will have to&lt;br&gt;consider of creating more and more COVID Centres for those&lt;br&gt;patients who do not require hospitalization. It is quite possible&lt;br&gt;that proper home isolation facilities are not available at all homes,&lt;br&gt;especially when more than one family member has got infected.&nbsp;&lt;br&gt;BBMP shall activate its Ward Level offices and ensure that those&lt;br&gt;who do not require hospitalization but do not have proper isolation&lt;br&gt;facilities at their homes, are shifted to the COVID Centres. The&lt;br&gt;response of BBMP shall be placed on record on the next date.&lt;br&gt;22. A report has been submitted by Karnataka State&lt;br&gt;Legal Services Authority (KSLSA) dated 27th April 2021. The&lt;br&gt;report incorporates the excellent work done by the Committee of&lt;br&gt;which two retired Hon&#039;ble Judges of this Court are a part. The&lt;br&gt;learned Advocate General assures the Court that the Hon&#039;ble&lt;br&gt;retired Judges and other members of the Committee as well as&lt;br&gt;the Secretary of KSLSA will be invited to attend the meetings. We&lt;br&gt;make it clear that when the recommendations made from time to&lt;br&gt;time by the Monitoring Committee set up by KSLSA are&lt;br&gt;forwarded to the learned Advocate General and all other stake&lt;br&gt;holders, the same shall be looked into by all the concerned&lt;br&gt;authorities. In fact, the learned Advocate General stated that&lt;br&gt;some of the suggestions already made are most welcome which&lt;br&gt;will be looked into.&nbsp;&lt;br&gt;23. Before we part this order, we must record a&lt;br&gt;clarification. We have issued stringent directions from time to&lt;br&gt;time against the State Government and the agencies and the&lt;br&gt;instrumentalities of the State. While we do so, we must clarify&lt;br&gt;that there are several Government officials, the officials attached&lt;br&gt;to various agencies and the instrumentalities of the State&lt;br&gt;including BBMP, the doctors, nurses and paramedical workers,&lt;br&gt;who are rendering valuable services to the society at large which&lt;br&gt;needs to appreciated by all. While we are passing various&lt;br&gt;directions in the context of Article 21 of Constitution of India, we&lt;br&gt;must record our appreciation to the efforts made by all the&lt;br&gt;stakeholders in the right direction.&lt;br&gt;24. In our orders, with emphasis, we have referred to the&lt;br&gt;situation in the city of Bengaluru and have issued directions. We&lt;br&gt;make it clear that directions issued by the Court in relation to the&lt;br&gt;city of Bengaluru will have to be implemented in its true letter and&lt;br&gt;spirit even in the other districts where there are large number of&lt;br&gt;COVID positive cases.&nbsp;&lt;br&gt;25. We direct that these petitions shall be listed on 5th&lt;br&gt;May 2021 at 11.00 a.m.&lt;br&gt;&nbsp;Sd/-&lt;br&gt;&nbsp;CHIEF JUSTICE&lt;br&gt;&nbsp;Sd/-&lt;br&gt;&nbsp;JUDGE&lt;br&gt;vgh*/AHB/ DR&lt;/h4&gt;', '6cbc8f10fd129e6fcb504e4569fd0e14.PNG', 'f1c475f0f8607fbf8f233ce12909fc40.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-04-29', 0, '2021-04-30 00:29:04', '2021-06-22 05:41:14'),
(23, 'nIVHIjlOJm6tFNp03d0MlbPSK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court exempts physically disabled and visually Impaired officials working in the District Judiciary in the State from attending the office during the COVID-19 lockdown period.', '&lt;h4&gt;The State Commissioner for Rights of Persons with Disabilities-Karnataka, Bengaluru, vide his letter bearing No. Am.Aa.Ni.Section.82/Others/2021-22 dated 10.05.2021 requested the High Court to exempt the Physically Disabled/Visually Impaired Officers/Officials working in the District Judiciary in the State from attending the office during the COVID-19 pandemic period as per the Government Circular No.DPAR 87 DEP 2021 dated 27.04.2021. &lt;/h4&gt;&lt;h4&gt;In response, the High Court has exempted the Physically Disabled/Visually Impaired officials working in the District Judiciary in the State from attending the office during the COVID-19 lockdown period. &lt;/h4&gt;&lt;h4&gt;&lt;b style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;Please see the attached file/circular&nbsp;&lt;/b&gt;&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'b91f7acdf1735102ce67689dd9f4405e.jpg', 'e724f581814cd4d063b812a3c0819d98.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-05-15', 0, '2021-05-15 17:52:20', '2021-06-22 05:41:07'),
(24, 'bWvmRNvDTrpDAVG1cZWPdDoP5', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Chamarajanagar Covid tragedy. State Level Monitoring Committee holds Deputy Commissioner, Chamarajnagar and Dean, Chamarajnagar Institute of Medical Sciences responsible. Makes recommentations. (Report enclosed) ', '&lt;h3&gt;&lt;span style=&quot;font-weight: bolder; background-color: rgb(255, 255, 0);&quot;&gt;Full report enclosed in PDF format&nbsp;&lt;/span&gt;&lt;/h3&gt;&lt;h4&gt;Report of State Level Monitoring Committee of Karnataka State Legal Services Authority constituted to monitor Covid 19 issues, on the incident of death of a number of in-patients in the District Hospital at Chamarajnagar that occurred on the night of 02-05-2021 and in the morning hours of 03-05-2021 is submitted to the High Court of Karnataka.&nbsp;&nbsp;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The State Level Monitoring Committee consisted of Hon&rsquo;ble&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Sri Justice A.N. Venugopala Gowda, Chairman, Hon&rsquo;ble Sri&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Justice K.N. Keshavanarayana, Addl. Member, Sri S.T. Ramesh&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;IPS(retd) and Sri B.P. Baligar IAS(retd) as other Members of the&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Committee. Sri V.P. Baligar, Hon&rsquo;ble Member, on account of his&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;spouse having been tested positive and having quarantined&nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;himself, did not participate in the proceedings of the Committee.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 1.3125rem; background-color: rgb(255, 255, 0);&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;Extract from the report&nbsp;&lt;/span&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-weight: bolder; background-color: rgb(255, 255, 0);&quot;&gt;(9) Role of the Deputy Commissioner, Mysore&lt;/span&gt;: Prior to 03-05-2021, there was no mechanism in the entire State of Karnataka regarding the allocation or supply of oxygen to the individual districts. Thus, there was no regulatory mechanism in place. No doubt, the refilling plants on which the District Hospital, Chamarajanagar was dependent for their oxygen requirements are situated in the revenue District of Mysore which comes under the jurisdiction of Deputy Commissioner, Mysore. However, on that basis, it cannot be said that the Deputy Commissioner at Mysore had any control or regulatory powers over the supply of oxygen to other districts or consumers. Supply of oxygen to district hospital, Chamarajnagar from the refilling plants at Mysore was pursuant to independent MOUs between the Dean of the CIMS and the suppliers. Mysore DC had no role to play in the matter of providing or supply of refilled cylinders to Chamarajanagar district. It was the responsibility of Chamarajanagar District Hospital Authorities to take the empty cylinders to refilling plants at Mysore and get refilled cylinders and transport them back to their destination. The only restriction imposed as per the Government Order dated 24-04-2021 was that Oxygen should not be diverted for industrial use and all oxygen should be used only for the medical purposes. Allegations made against DC, Mysore is that she had prevented the refilling agencies from refilling the cylinders of other districts by giving instructions, that only after meeting the needs of Mysore district, the needs of others should be met. In support of this allegation, we did not find any material in the records. Documents on record, indicate that DC Mysore had visited refilling plants on 01-05-2021. However, the said visit was stated to be to instruct those refillers to act in accordance with government order and not to divert for industrial purpose. In fact, a meeting was held under the Chairmanship of DC, Chamarajnagar in his capacity as Chairman of District Disaster Management Authority, on 02-05-2021 to discuss the Covid situation. Copy of the proceedings of the said meeting is as per Annexure-4.&lt;/h4&gt;&lt;h4&gt;11 (n) Deputy Commissioner, Chamarajanagar has not exhibited the dynamism and the leadership qualities expected of a district head in a dire crisis situation as mentioned above.&lt;/h4&gt;&lt;h4&gt;11 (o) As Chairman of District Disaster Management Committee, he has miserably failed to guide and supervise the crisis situation arising out of extreme demand for oxygen. On the contrary, he has indulged in an unsavory blame game accusing the DC Mysore of causing hindrance for oxygen supply without any basis.&lt;/h4&gt;&lt;h4&gt;11 (p) Cumulatively, the failure of the district administration in general and the hospital authorities in particular including the Dean of CIMS is apparent. A detailed probe alone can unearth the acts of omissions and commissions of the concerned individuals for fixing the responsibility.&lt;/h4&gt;&lt;h4&gt;11 (n) Deputy Commissioner, Chamarajanagar has not exhibited the dynamism and the leadership qualities expected of a district head in a dire crisis situation as mentioned above.&lt;br&gt;11 (o) As Chairman of District Disaster Management Committee, he has miserably failed to guide and supervise the crisis situation arising out of extreme demand for oxygen. On the contrary, he has indulged in an unsavory blame game accusing the DC Mysore of causing hindrance for oxygen supply without any basis.&lt;br&gt;11 (p) Cumulatively, the failure of the district administration in general and the hospital authorities in particular including the Dean of CIMS is apparent. A detailed probe alone can unearth the acts of omissions and commissions of the concerned individuals for fixing the responsibility.&nbsp;&lt;/h4&gt;&lt;h4&gt;The High Court of Karnataka which is monitoring the issue acknowledged the service rendered by the Committee. Same is extracted below. Writ Petition 6435 of 2020 and connected matters - Order dated 13.05.2021. Chief Justice Abhay S Oka and Justice Aravind Kumar.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;&quot;27. Before we part with today&#039;s order, we must record our appreciation for the services rendered by the Committee of KSLSA headed by a retired Hon&#039;ble Judge of this Court of which, another retired Hon&#039;ble Judge of this Court is also a part. There are other equally prominent members of the Committee. We must record our appreciation for the service rendered by all of them by submitting a report within such a short time.&quot;&lt;/h4&gt;', '93b878519cff845e0519f7a3f65f7b8b.PNG', '3b909bb77c4410297bec96e0c32ca0a1.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-05-18', 0, '2021-05-18 18:16:39', '2021-06-22 05:41:02');
INSERT INTO `news` (`news_id`, `news_key`, `category_key`, `news_title`, `news_description`, `news_image`, `news_attachment`, `news_author`, `news_date`, `news_status`, `news_date_added`, `news_date_updated`) VALUES
(25, 'Y7RI6zMXpxLMQVPvieh35RjG1', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Stung by backlash and serious objection by a former Supreme Court Judge, SCBA tries to play down its \'Supreme Court lawyers more meritorious than High Court lawyers\' comment.  ', '&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;&lt;i&gt;-Aravind Puttur Kamath, Daksha Legal&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;Last week, advocates&#039; fraternity across the country strongly protested the assertion of&amp;nbsp; SCBA that &ldquo;Supreme Court are professionally more meritorious than their colleagues at the High Court&rdquo;.&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;The letter of SCBA dated 8:6:2021, which sought elevation of lawyers practicing before the Supreme Court to High Courts, used the following words;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;&ldquo;The lawyers practicing in the Supreme Court are rarely considered for elevation by the High Court collegium they not regularly practice before the High Court and while being professionally more meritorious than their colleagues at the High Court, loose the opportunity for being considered as such.&rdquo;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;On the next day, S.Basavaraj, Member, Karnataka State Bar Council called the comments in the letter as outrageous. The content of the letter addressed to Mr. Vikas Singh reads as follows;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;&ldquo;High Courts in the country have contributed some of the best judges to the Supreme Court. These judges have built and strengthened the highest judicial institution brick-by-brick. Many lawyers started their practice at the taluka and district level and enriched High Courts with their vast knowledge and experience.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;There is no need to mention names of great lawyers who practiced before High Courts till their elevation to High Courts and then to Supreme Court. Their vast knowledge coupled with their touch with clients from villages, talukas and districts made them persons with empathy. Needless to say, this empathy factor is reflected in many of their judgments.&amp;nbsp; &amp;nbsp;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;Hence, the self-proclamation by SCBA that the lawyers practicing in Supreme Court are professionally more meritorious than their colleagues at the High Court makes a mockery of the Advocates&rsquo; fraternity.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;You are hereby called upon to forthwith withdraw the offensive portion in the letter aforesaid to avoid nationwide protest from the learned members of the bar practicing in the High Courts.&rdquo;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;On 11 June 2021, Daksha Legal, NGO founded by S.Basavaraj arranged a seminar on the topic &ldquo;Proposal to consider Supreme Court Lawyers for High Court Judgeship. Disruption of High Court Collegium System&rdquo;. Justice V. Gopala Gowda who was the speaker in the seminar severely criticised the language used by SCBA in the letter. He called the contents of the letter highly objectionable. Link to video of the seminar &lt;a href=&quot;https://www.youtube.com/watch?v=H2F5QZ3VUng&amp;amp;t=322s&quot; target=&quot;_blank&quot;&gt;https://www.youtube.com/watch?v=H2F5QZ3VUng&amp;amp;t=322s&lt;/a&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;Justice V. Gopala Gowda minced no words in terming the letter of SCBA as highly objectionable and gave strong reasons for his stand.&amp;nbsp;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;The welcome address by S.Basavaraj made scathing attack on SCBA and its conduct. The same reads thus;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;&ldquo;Justice Ratnavel Pandian who wrote the leading judgment in Supreme Court Advocates-on-Record Association vs Union of India &ldquo;Solomon&rsquo;s throne was supported by lions on both sides; let them be lions, but yet lions under the throne; being circumspect that they do not check or oppose any points of sovereignty.&rsquo;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;His lordship referred Solomon&rsquo;s throne as Judiciary and the lions on both sides as Legislature and Executive. That was the moment when the selection of judges was finally freed from the clutches of the executive thus establishing independence of judiciary as a basic structure of the Constitution.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;The collegium system evolved by the Supreme Court both at the Supreme Court and the High Court level ensured absolute transparency and independence to both the institutions.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;However, attempts are being made to disrupt the independence of collegium at the high court level. One such attempt is the recent self proclaimed proposal by the SCBA to appoint Supreme Court lawyers to High Courts.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;We could&rsquo;ve ignored the letter circulated by SCBA as another publicity stunt by the office bearers but for three disturbing factors.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;(1) The letter asserts that the supreme court lawyers are more meritorious than High Court lawyers.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;(2) It claims that the chief justice of India has agreed for the proposal and finally&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;(3) A hybrid collegium system in the form a search committee is constituted find suitable candidates.&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;The purpose of this seminar is to know the formation of collegium and their independence atleast at the initial level.&quot;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;Similar views were expressed by Calcutta, Tamilnadu and Andra Pradesh Bar Associations taking exception the letter.&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;SCBA through its President, Mr. Vikas Singh has today issued a &ldquo;clarification on the entire issue&rdquo;. SCBA through its President, Mr. Vikas Singh has today issued a &ldquo;clarification on the entire issue&rdquo;. The &lsquo;clarification&rsquo; says that;&lt;/h4&gt;&lt;h4 style=&quot;margin: 0cm 0cm 0.0001pt 25px; line-height: normal;&quot;&gt;&lt;i&gt;&quot;Reference to Supreme Court lawyers being &#039;more meritorious&#039; in my letter to the Chief Justice of India was for the limited purpose of ensuring their consideration for elevation by the High Court collegiums on equal footing basis and there was no intention whatsoever to cast any aspersion on the lawyers practicing in different High Courts,&quot;&lt;/i&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;The letter tries to mellow down the comments in the letter without expressing any remorse for the objectionable comments though.&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;&amp;nbsp;&lt;/h4&gt;&lt;h4 style=&quot;margin-top: 0cm; margin-right: 0cm; margin-bottom: 0.0001pt; line-height: normal;&quot;&gt;&amp;nbsp;&lt;/h4&gt;', '4670535fe2ab1fb015c1a8e657606931.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-06-13', 0, '2021-06-13 23:30:14', '2021-06-22 05:40:59'),
(28, 'U3YnlRDFA8tK3Gq3c2L3pFU2I', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '\'We cannot afford to have third closure of courts considering the huge arrears. Get vaccinated, wear mask continuously and maintain social distance\'. Chief Justice of Karnataka urges. ', '&lt;h4&gt;The Chief Justice of Karnataka in his speech during virtual inauguration of the newly constructed judicial quarters in Bidar on 24 June 2021, said that the third closure of Courts must be avoided. The Hon&#039;ble Chief Justice during the course of his speech said;&amp;nbsp;&lt;/h4&gt;&lt;h4 style=&quot;margin-left: 25px;&quot;&gt;&lt;i&gt;&quot;In 2020 and 2021 the Judiciary has suffered because of covid-19. Large number of working days were lost due to lockdown and due to the situation created by spread of covid-19. Considering the huge arrears, we cannot afford to have third closure of the Courts. The third closure of the courts can be avoided by ensuring three things (1) vaccination (2) continuous use of mask (3) maintaining social distancing.&amp;nbsp; Not only that the litigants have suffered because of arrears created due to closure of the courts, even the members of the bar have been considerably affected. Young members of the bar were the real victims. Their income completely stopped due to lockdown. Therefore not only for the cause of justice but also for the benefit of the bar, we have to ensure that by starting functioning of the court we don&#039;t contribute to spread of covid-19. It is the responsibility and obligation of all of us to strictly follow covid-19 norms and ensure that third wave does not result in closure of the courts.&quot;&amp;nbsp;&lt;/i&gt;&lt;/h4&gt;&lt;h4&gt;The Hon&#039;ble Chief Justice called upon the judges, lawyers and the staff to get vaccinated and to see that their family members are also vaccinated. &lt;/h4&gt;&lt;h4&gt;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Link to watch the inauguration video:&amp;nbsp;&lt;a href=&quot;https://youtu.be/TQd0lwxWtv8&quot; target=&quot;_blank&quot;&gt;https://youtu.be/TQd0lwxWtv8&lt;/a&gt;&lt;a href=&quot;https://youtu.be/TQd0lwxWtv&quot; target=&quot;_blank&quot;&gt;&lt;/a&gt;&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '44796b08a4fbcce8d7502996b0cb66e9.jpg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-06-24', 0, '2021-06-25 03:24:56', '2021-11-07 05:48:56'),
(29, 'AlDgOj9MMjeri6e6LCsEoXoUW', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Judiciary is not a villain. Father Stan Swamy is not a martyr. ', '&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;&lt;b&gt;&lt;i&gt;S.Basavaraj, Advocate, Daksha Legal&nbsp;&lt;/i&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;The kind of obnoxious comments being made on social network on the unfortunate of death Father Stan Swamy are more than mere compassion expressed over the death of an under trial prisoner.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Even the lawyers&rsquo; community are targeting judiciary forgetting for a moment that this was just another case of an accused awaiting bail plea.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Our judicial institution reached its pinnacle in protecting human rights when the highest court of the country extended midnight hearing to a terrorist and when the entire judicial system provided fairest trial a transnational terrorist from Pakistan.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;We have come a long way since the death of Rajan Pillai former biscuit baron who was denied medical attention when he was judicial custody in June 2013. This incident resulted in nationwide condemnation of how the under trial prisoners were treated. This incident brought several reformative steps by the Government.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;India is certainly in forefront in safeguarding human rights. Some of the important guaranteed rights, among others, traceable to the rights protected under the Constitution are the following:&mdash;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;a) Article 14 - Equality before law&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;b) Article 15 - Prohibition of discrimination on grounds of religion, race, caste, class or philosophy&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;c) Article 16 - Equality of opportunity without discrimination in matters of public employment&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;d) Article 17 - Abolition of Untouchability&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;e) Article 19 - Right to freedom&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;f) Article 21 - Protection of life and personal liberty&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;g) Article 22 - Protection against arrest and detention&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;h) Article 23 - Prohibition of traffic in human beings and forced labour&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;i) Article 24 - Prohibition of employment of children in factories&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;j) Articles 25 and 26 - Right to freedom of religion&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;k) Articles 29 and 30 - Cultural and Educational rights&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Some of the important human rights embodied in the International Covenants are the following:&mdash;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;a) The Universal Declaration on Human Rights, 1948&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;b) The International Covenants on Economic, Social and Cultural Rights, 1966&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;c) The International Covenant on Civil and Political Rights, 1966&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;d) The Covenant on Elimination of all forms of Discrimination among women&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;e) Covenants on Torture and against Inhuman Treatment and punishment&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;f) Covenants on Rights of Children&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;g) The International Covenant on Elimination of All Forms of Racial Discrimination, 1966&lt;/span&gt;&lt;span style=&quot;font-size: 21.3333px; font-family: var(--cui-font-sans-serif);&quot;&gt;&nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;The Geneva Conventions Act, 1960, extensively deals with medical attention to prisoners. Chapter IV, Articles 91 and 92 specifically say as follows:&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Every place of internment shall have an adequate infirmary, under the direction of a qualified doctor, where internees may have the attention they require, as well as appropriate diet. Isolation wards shall be set aside for cases of contagious or mental diseases. Maternity cases and internees suffering from serious diseases, or whose conditions require special treatment, a surgical operation or hospital care, must be admitted to any institution where adequate treatment can be given and shall receive care not inferior to that provided for the general population.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Internees shall, for preference, have the attention of medical personnel of their own nationality.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Internees may not be prevented from presenting themselves to the medical authorities for examination. The medical authorities of the Detaining Power shall, upon request, issue to every internee who has undergone treatment an official certificate showing the nature of his illness or injury, and the duration and nature of the treatment given. A duplicate of this certificate shall be forwarded to the Central Agency provided for in Article 140.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Treatment, including the provision of any apparatus necessary for the maintenance of internees in good health, particularly dentures and other artificial appliances and spectacles, shall be free of charge to the internee.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;Medical inspections.&mdash;Medical inspections of internees shall be made at least once a month. Their purpose shall be, in particular, to supervise the general state of health, nutrition and cleanliness of internees and to detect contagious diseases, especially tuberculosis, malaria, and veneral diseases. Such inspections shall include, in particular the checking of weight of each internee and, at least once a year, radioscopic examination.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;In Kharak Singh v. State of U.P. A.I.R. 1963 S.C. 1295, a Constitution Bench of the Supreme Court, held that the words, &ldquo;personal liberty&rdquo; coming in Article 21 are used as a compendious term to include within itself all the varieties of rights which go to make up &ldquo;personal rights&rdquo; of man other than those dealt with in several clauses of Article 19(1). The word &ldquo;life&rdquo; in Article 21 means not merely a right of the continuance of a person&#039;s animal existence, but a right to the possession of each of his organs - arms and legs, etc&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;In Bacchan Singh v. State of Punjab [A.I.R. 1980 S.C. 898], another Constitution Bench of the Supreme Court held that the International Covenant on Civil and Political Rights, to which India has acceded in the year 1979, require that death penalty shall not be arbitrarily be inflicted and that it shall be imposed only for the most serious crimes, in accordance with the law which shall not be an ex post facto legislation. The requirement of these clauses are substantially the same as the guarantees or provisions contained in Articles 20 and 21 of the Constitution of India. Justice Bhagawati, who rendered a minority judgment in the above case, reported in A.I.R. 1982 S.C. 1325, has held that the various provisions of the Constitution are enacted for the purpose of ensuring the dignity of the individual and providing for his material, moral and spiritual development and they would be meaningless and ineffectual unless there is a rule of law to invest them with life and force.&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px; font-family: var(--cui-font-sans-serif);&quot;&gt;In Sunil Batra v. Delhi Administration [A.I.R. 1978 S.C. 1675], a Constitution Bench of the Supreme Court has held that prisoners are entitled to Constitutional rights, including fundamental rights and that conviction for a crime does not reduce a person into a non-person.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In T.K. Basu v. State of West Bengal [A.I.R. 1997 S.C. 610], the Supreme Court has held that any form of torture or cruel, inhuman or degrading treatment falls within the inhibitions of Article 21 of the Constitution, whether it occurs during investigation, interrogation or otherwise. The Supreme Court, in that judgment, issued eleven guidelines to be followed by the police in all cases of arrest or detention till legal provisions are made in that behalf. It was further held that the requirement flows from Articles 21 and 22 of the Constitution and needs to be strictly followed.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In Prem Shankar Shukla v. Delhi Administration [(1980) 3 SCC 526], the Supreme Court has held that handcuffing of undertrial prisoners whilst on the way to and from the prison to the Court offends Articles 19 and 21 of the Constitution. In Kadara Pahdia v. State of Bihar [A.I.R. 1981 S.C. 939], the Supreme Court has held that undertrials made to await trial kept in jail and make to work outside the prison was contrary to the Prison Regulations and also contrary to the I.L.O. Convention against forced labour. In Hussainara Khatoon v. Union of India [(1980) 1 SCC 81], the Supreme Court held that undertrials are entitled for speedy trial as part of Article 21 of the Constitution.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In Francis Coralie Mullin v. The Administration, Union Territory of Delhi [(1981) 1 SCC 608], the Supreme Court held that cruel, inhuman and degrading treatment of undertrials was violative of Article 21 of the Constitution. In P.U.D.R. v. Union of India [(1982) 3 SCC 235], it has been held by the Supreme Court that employment of children is to be prohibited in every type of construction work and that would be in consonance with the I.L.O. Convention as also the Directive Principles under Article 24 of the Constitution. In Lakshmikant Pandey v. Union of India [(1984) 2 SCC 244], it was held that malpractice and trafficking in children in connection with adoption of Indian children by foreigners living abroad violates Articles 15(3) as well as 39(e) and (f) of the Constitution.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In Kishore Singh v. State of Rajasthan [A.I.R. 1981 S.C. 625], the Supreme Court has held that solitary confinement and putting fetters are to be resorted to only in the rarest of rare cases for security reasons and use of &lsquo;third degree methods&rsquo; by the police is deprecated on the underlying principles of Article 21. In Vikram Deo Singh Tomar v. State of Bihar [A.I.R. 1988 S.C. 1788], it was held that the rights guaranteed under Article 31 as well as in Article 39 requires the provision for at least the minimum conditions ensuring human dignity of the inmates of Care Homes maintained by the State. In Sheela Barse v. State of Maharashtra [A.I.R. 1983 S.C. 378], the Supreme Court held that it is the duty of the Magistrate to inform the arrested person about his right of medical examination in case he has any complaint of torture or maltreatment in police custody. It was further held in the said judgment as to how protection can be accorded to women prisoners in police lockup and seven directions were issued in reference to women prisoners in the context of Articles 14, 21 and 39A of the Constitution of India.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In C.E.S.C. Limited v. Subash Chandra Bose [(1992) 1 SCC 441], it was held that the employees are entitled to sickness benefits traceable to Articles 21 and 39-E of the Constitution. In Kishore Chand v. State of H.P. [(1991) 1 SCC 286], the Supreme Court has held that the accused are entitled to free legal aid for a fair trial, traceable to Articles 14, 19 and 21 read with Article 39-A of the Constitution. In Neelabati Behara v. State of Orissa [(1993) 2 SCC 746], it has been held that the State is obliged to provide monetary compensation for the violation of fundamental rights under Article 21 of the Constitution like wrongful arrest etc. In Kirloskar Brothers Ltd. v. E.S.I. [(1996) 2 SCC 682], it was held that the employer has a duty to ensure the health of the employee, which is the fundamental right of a workman.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;In Valsamma Paul v. Kochin University [(1996) 3 SCC 545], the Supreme Court held that human rights for women comprehends gender equality and it is also traceable to the Convention on elimination of all forms of discrimination against women and protection of Human Rights Act, 1993. It was held that human rights for women, including girl child are, therefore, inalienable, integral and an indivisible part of universal human rights. The full development of personality, fundamental freedoms and equal participation by women in political, social, economic and cultural life are held to be concomitants for national development, social and family stability and growth - cultural, social and economical. It was further held that all forms of discrimination on grounds of gender is violative of fundamental freedoms and human rights.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;It is the judiciary which has always come to rescue of the oppressed persons. Today, the State is duty bound to ensure personal liberty of individuals. When a person is legally arrested, the duty of the State actually increases to provide safety and medical care. As stated above, the Supreme Court has declared that it is the duty of the Magistrate to inform the arrested person about his right of medical examination in case he has any complaint of torture or maltreatment in police custody.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;Coming back to Father Stan Swamy&#039;s case, every effort is being made to project him as a martyr. A victim of human rights violation, this time by the judiciary itself. This is an unpardonable attempt. It is unfortunate that the man who stood for some cause, right or wrong, is dead while he was in custody. But that is no reason to brand judiciary as a villain.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;Please note this is was not the first bail application and this man was not an ordinary accused. The bail plea was already rejected and the charges are extremely serious. This can&rsquo;t another &lsquo;bail or jail&rsquo; case. The Hon&#039;ble Judges were not bent upon keeping this person in confinement just for the sake of it.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;Today the prosecutors, the NIA and the judges are blamed for the death of Stan Swamy forgetting for a moment all of them were just doing their job.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-family: var(--cui-font-sans-serif); font-size: 21.3333px;&quot;&gt;The attack on the prosecution, the NIA and the judicial system raises one question. Is there something more than what the eyes meet?? There is a clear attempt to somehow connect the episode to the Union of India. This collective conspiracy is not very difficult to fathom.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 7.5pt 0cm; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 21.3333px;&quot;&gt;&nbsp;&lt;/span&gt;&lt;/p&gt;', '326e8251242cc8c6de71bb3b2c81eca6.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-07-05', 0, '2021-07-06 01:39:37', '2021-08-02 12:42:40'),
(26, 'QGYvZw810yfBu87pQghz91gqK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Address me as \'Madam\' instead of \'My Lord\' - Justice Jyothi Mulimani, Karnataka High Court requests the Advocates.  ', '&lt;h4&gt;&lt;i&gt;S.Basavaraj, Advocate, Daksha Legal, Bangalore.&nbsp;&lt;/i&gt;&lt;/h4&gt;&lt;h4&gt;Recently,Justice Krishna Bhat of the Karnataka High Court requested lawyers appearing before his court to avoid using terms such as &quot;Lordship&quot; or &quot;My Lord&quot; to address the judges on the Bench.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Justice Jyothi Mulimani of the Karnataka High Court has now requested the members of the bar to address as &lsquo;Madam&rsquo;.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;I had an opportunity to join a meeting with late Mr. T.R.Andhyarujina, Senior Advocate, Supreme Court along with Mrs. Anitha Shenoy, now Senior Advocate, Supreme Court, in a matter pertaining to Bangalore bomb blast. On 30 April 2011, when the matter was listed before Justice Markandey Katju and Justice Gyan Sudha Misra, Mr. T.R.Andhyarujina&nbsp; addressed Justice Gyan Sudha Misra as &lsquo;My Lady&rsquo; couple of times. Justice Gyan Sudha Misra conveyed her displeasure to senior judge and Justice Katju said &ldquo;Mr. Andhyarujina, my sister has reservations about being called &lsquo;My Lady&rsquo;. Kindly avoid it&rdquo;. &lt;/h4&gt;&lt;h4&gt;Justice Katju made it worse by telling Mr. Andhyarujina &ldquo;but you can address as &lsquo;My Fair Lady&#039;!&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;On 2nd June 2017, the Punjab &amp; Haryana High Court witnessed a very interesting exchange between Justice Daya Chaudhary and Advocate General Atul Nanda.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;The discussion pertained to the use of &quot;Your Ladyship&quot; by the Advocate General to address the judge. It happened during the hearing of a case relating to the appointment of Chairperson of Punjab Human Rights Commission.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;The discussion was triggered by Nanda addressing Justice Chaudhary as &ldquo;Your Ladyship&rdquo;. According to a report in Dainik Bhaskar, Justice Chaudhary objected to the same saying that &ldquo;it is Delhi culture and won&rsquo;t work in Punjab &amp; Haryana High court.&rdquo;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;She also said that judges and advocates have no gender and they are just judges and advocates and are not to be addressed as &lsquo;lady judges or lady advocates&rsquo;.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Mr. Nanda then tried to trace some history regarding the usage of &lsquo;Your ladyship&rsquo; but Justice Chaudhary remained adamant. She reportedly cut him short saying how he would feel if a female lawyer addresses him in court as &lsquo;this man&rsquo; instead of &lsquo;my lawyer friend&rsquo;.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Justice Chaudhary also went to the extent of saying that she would not mind if lawyers did not address her as &ldquo;Your Lordship&rdquo;.&lt;br&gt;&ldquo;I won&rsquo;t mind even if you do not address me as &lsquo;Your Lordship&rdquo;.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Nanda relented and agreed to &ldquo;delete the usage from his dictionary&rdquo;.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;The use of &ldquo;Your Lordship&rsquo; to address judges has been a subject of discussion for sometime now. It is dubbed as a relic of colonial rule with demands for doing away with the same.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Justice Muralidhar&rsquo;s court of Delhi High Court has specific directions in the causelist not to address him as &ldquo;My Lord&rdquo; and &ldquo;Your Lordship&rdquo;.&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;With Justice Jyothi Mulimani requesting the Advocates to address as &ldquo;Madam&rdquo;, much of the confusion in this regard is sorted out.&nbsp;&lt;/h4&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '677f2da9895ace38c59263adf6548ea9.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-06-22', 0, '2021-06-22 17:03:25', '2021-11-07 05:49:01'),
(27, 'tMxAdhvor2Hsmaix9xwTiM2Y9', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '\'Do not cut and paste from the Judgments. Follow the rule of pleadings.\' - Chief Justice of Karnataka High Court requests the Advocates. ', '&lt;h4&gt;&lt;i&gt;S.Basavaraj, Daksha Legal, Bangalore&nbsp;&lt;/i&gt;&lt;/h4&gt;&lt;h4&gt;After going through a petition which contained 30 pages of synopsis and paragraphs after paragraphs simply reproducing paragraphs from the judgements, the Hon&#039;ble Chief Justice of Karnataka High Court requested the advocates not to simply reproduce the judgments in petitions and to strictly follow the rule of pleadings.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;It may be noted that though strict rules of pleadings under the Civil Procedure Code are not applicable to writ proceedings, many advocates draft writ petitions which contain pleadings, evidence, paragraphs from several judgments and sometimes facts involved in those judgments. Judges find it extremely difficult to fathom the real issue involved in the petition in the ocean of never ending pleadings.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Some of the earliest pleadings were cryptic, to the point and strictly in accordance with rules of pleadings. Even the judgments were short and to the point.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;The constitution bench judgement of the Supreme Court in Sankari Prasad Singh Deo v. Union of India which consisted Chief Justice Hiralal Kania, Justice M. Patanjali Sastri, Justice B.K Mukherjea, Justice Sudhi Ranjan Das, Justice Chandrasekhara Aiyar N, decided on 5 October 1951 and reported in 1952 SCR 89: AIR 1951 SC 458 contained only 16 paragraphs and less than 20 pages.! Yet it covered all the points urged by the advocates. This was one of the landmark judgments in the series of judgments that ultimately led to Keshavananda Bharati case.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;Few months ago the High Court deprecated the practice of attaching the judgments as annexures to the writ petition. If a matter is covered by an unreported judgment, one can annex it or file as list of authorities. But annexing judgements along with petitions thus making the papers bulky is really not advisable.&nbsp;&lt;br&gt;&lt;/h4&gt;&lt;h4&gt;It is hightime we understand the real meaning of pleadings and restrict the petition only to material facts and grounds, especially in writ petitions. The arguments can always be addressed later.&nbsp;&nbsp;&lt;/h4&gt;', 'd1bfffa0148cb81d1c19cd3eebad56d7.jpg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-06-23', 0, '2021-06-24 01:31:37', '2021-11-07 05:48:57');
INSERT INTO `news` (`news_id`, `news_key`, `category_key`, `news_title`, `news_description`, `news_image`, `news_attachment`, `news_author`, `news_date`, `news_status`, `news_date_added`, `news_date_updated`) VALUES
(30, 'BYhBCr3a3LNd5GHVvLyo0YjxC', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court Launches Telegram Bot Channel For Providing Information On Cause Lists, Case Status Etc ', '&lt;p&gt;&lt;b&gt;Karnataka High Court Launches Telegram Channel For Providing Information On Cause Lists, Case Status Etc. Same works as virtual enquiry counter.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Chief Justice Abhay S. Oka of the Karnataka High Court on Thursday addressed a letter to the Bar and litigants announcing the launch of a Telegram Bot channel.&amp;nbsp; The Telegram channel would facilitate the real-time delivery of various E-court services such as cause lists, case status, daily notifications, display etc.&amp;nbsp;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b style=&quot;background-color: rgb(255, 255, 0);&quot;&gt;The Link to access Karnataka High Court BoT Services &lt;a href=&quot;https://t.me/karhcbot&quot; target=&quot;_blank&quot;&gt;https://t.me/karhcbot&lt;/a&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', 'a628c6b96df583dd230e10911a04eeae.PNG', 'd949cb21b9e09dcc2e81a7b7af59b482.jpeg', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-07-08', 1, '2021-07-09 01:58:23', '2021-08-02 12:42:44'),
(31, 'ilLoVsy6krMIlumwnmwbTpDOy', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Live streaming and recording of Court proceedings in Karnataka from 1 January 2022.', '&lt;p&gt;&lt;b&gt;In exercise of the powers conferred by Article 225 and 227 of the Constitution of India and&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Section 54 of the States Reorganisation Act, 1956 (Central Act 37 of 1956) read with Sections 122&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;and 129 of the Code of Civil Procedure, 1908, and Sections 19 and 21 of the Mysore High Court Act, 1884 (I of 1884) and all other powers thereunto enabling, the High Court of Karnataka, with the&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;previous approval of the Government of Karnataka, has promulgated and issue the following Rules with&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;respect to practice and procedure to be followed to imbue greater transparency, inclusivity and foster&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;access to Justice.&amp;nbsp;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;The Rules &#039;&#039;Karnataka Rules on Live Streaming and Recording of Court&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Proceedings, 2021&#039;&#039; will come into force from 1 January 2022.&amp;nbsp;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Cameras will be installed in the courtroom covering at least five angles; one towards the&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Bench, the second and third towards the advocates engaged in the concerned matter, the fourth&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;towards the accused (where applicable) and the fifth towards the deponent or witness, as&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;required. In the event that the Court has employed an electronic evidence presentation system, an&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;additional feed shall be captured there from.&amp;nbsp; A remote-control device shall be provided to the presiding judge on the Bench to pause or stop&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;the Live-streaming at any time. Advocates, witnesses, accused, or any other person permitted by the Bench, shall use&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;appropriate microphones while addressing the Court. In so far as a Remote Location is concerned, appropriate hardware will be deployed to the&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;extent practicable, bearing in mind the provisions made in the aforementioned sub-rules. Where Proceedings are conducted through web links, including video conferencing services,&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;appropriate software and hardware will be employed, if necessary, to generate an integrated&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;feed for Live-streaming.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;The following will be excluded from Live-streaming namely,-&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(i) Matrimonial matters, including transfer petitions arising there under.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(ii) Cases concerning sexual offences, including proceedings instituted under section&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;376, Indian Penal Code, 1860.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(iii) Cases concerning gender-based violence against women.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(iv) Matters registered under or involving the Protection of Children from Sexual&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Offences Act, 2012 (POCSO) and under the Juvenile Justice (Care and Protection&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;of Children) Act, 2015.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(v) In-camera proceedings as defined under Section 327 of the Code of Criminal&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Procedure, 1973 (Cr.PC) or Section 153 B of the Code of Civil Procedure, 1908.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(vi) Matters where the Bench is of the view, for reasons to be recorded in writing that&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;publication would be antithetical to the administration of justice.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(vii)Cases, which in the opinion of the Bench, may provoke enmity amongst&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;communities likely to result in a breach of law and order.&amp;nbsp; Recording of evidence, including cross-examination.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(ix) Privileged communications between the parties and their advocates; cases where a&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;claim of privilege is accepted by the Court; and non-public discussions&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;between advocates.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;(x) Any other matter in which a specific direction is issued by the Bench or the Chief&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;Justice.&lt;/b&gt;&lt;/p&gt;&lt;p&gt;&lt;b&gt;PDF of Rules enclosed.&amp;nbsp;&amp;nbsp;&lt;/b&gt;&lt;/p&gt;', '94c0d650f629347066f7d31ec05f27c2.JPG', '592b94abd8aae0482600eaf6a964e9bd.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2022-01-01', 1, '2022-01-02 01:13:04', '2022-01-02 01:24:49'),
(37, '0sGpsmmQHab4egiyow3JDciHD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '‘The idea of queerness has been accepted as quite natural and pure in the subcontinent’ says Justice SR Krishna Kumar.', '&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Justice SR Krishna Kumar judge of the High Court of Karnataka spoke on the topic of&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&quot;Evolution of LGBTQIA+ rights&quot;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;on the occasion of&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;17th P.G.C&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Chengappa&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;Memorial Lecture&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;. He delved deep into the evolution of queer rights from&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;the epic of&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Mahabharata to the recent judgement of&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Supriyo&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;Chakrabarty.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Justice Krishna Kumar&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;also elaborated how the history of the queer community has been in the world context&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;. &lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;A&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;s alternatives to the Western male-female and heterosexual binaries, the LGBTQIA+ community has flourished for millennia and across cultures, from the lyrics of same-sex desire written by Sappho in the 7th Century BCE to youths raised as the opposite sex in cultures ranging from Albania to Afghanistan; from the &quot;female husbands&quot; of Kenya to the Native American &quot;Two-Spirit&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&quot;.&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&rsquo;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;He said.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He also elaborated on the fact that how India&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;has a long standing history of the queer community. &amp;nbsp;&lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;Many times, &quot;LGBTQIA+&quot; is dismissed as a contemporary phenomenon or an idea of urban elitism; yet, Indian mythology and history paint a very different pictur&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;e&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;.&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;R&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;enowned mythologist Devdutt Pattanaik claims that in Sanskrit and Tamil, there are more than fifty terms for non- heterosexual genders and sexualities: napunsaka, kliba, kinnara, pedi, and&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;pandaka. The&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;-webkit-text-size-adjust: 100%; line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;Vedas, Itihasa, Puranas, Kama-shastra, Natya-shastra, Ayurveda, Jain Agamas, and Buddhist Pitakas all refer to these texts&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;-webkit-text-size-adjust: 100%; line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;.&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;-webkit-text-size-adjust: 100%; line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&rsquo; Justice Kumar said.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He said &lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;In pre-colonial times, the Indian subcontinent was home to a diverse population with its own, unique understanding of sexuality, companionship, morality and love. Stories, history, myths, and cultural practices in India indicate that what we now term &lsquo;queerness&rsquo; was present in pre- colonial India. It would not be a faithful description of the times to say that queerness was &ldquo;accepted&rdquo; by the populace&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;.&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;&rsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;&ndash;&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Justice Kumar said.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Justice Krishna Kumar also analysed the representation of queer community by the Indian Media. He&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;referred to various books and movies like&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Deepa Mehta&rsquo;s movie Fire (1996), Vikram Seth&#039;s book The Golden Gate (1986) and the character of &ldquo;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Lajja&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;Shankar Pandey&rdquo; played by actor Ashutosh Rana in the film Sangharsh (1999)&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;. &amp;nbsp;There also references of web series like Hush Hush and Fame Game to show different dimensions of Indian media of the queer community.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He then further moves on to analyse the evolution of legal rights from the institution of Section 377 IPC by Lord Macaulay to its striking down by the Supreme Court in Navtej Singh&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Johar&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;. He analysed the trajectory from the judgement of Naz Foundation given by Delhi High Court to its reversal in Suresh Kumar&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Koushal&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;by the Supreme Court and then the Supreme Court reversing its own judgement of Suresh Kumar&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Koushal&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;in Navtej Singh&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Johar&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He also elaborated on the judgement of NALSA given by the Supreme Court. &lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;The Supreme Court held in the said case that the state must recognize persons who fall outside the male-female binary as &lsquo;third gender persons&rsquo; and that they are entitled to all constitutionally guaranteed rights. It also directed the Union and State Governments to grant legal recognition to the self-identified gender of transgender persons, including when they identify as male and female&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&rsquo;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;.&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Justice Kumar said.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He also took references of the autobiography of Renee Richards the &lsquo;Second Serve&rsquo;&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;a famous tennis player who competed in the women&#039;s section of 1976 US Open&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;to highlight the concept of&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Sex Re-Assignment Surgery&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;(&lt;/span&gt;&lt;span class=&quot;s9&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPS;&quot;&gt;SRS)&lt;/span&gt;&lt;span class=&quot;s10&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPS;&quot;&gt;.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;span class=&quot;s9&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPS;&quot;&gt;&lt;b&gt;He then proceeded to analyse the recent Supreme Court judgement on the same sex marriage by giving a detailed analysis of the varied opinions given by the judges on the aspect of &lsquo;fundamental right of right to marry&rsquo;, &lsquo;civil union&rsquo;, the aspects of &lsquo;Constitutionality of Special Marriage Act&rsquo;, &lsquo;right to adopt&rsquo;. He then shed some light on the international law by referring to UDHR and analysing various aspects of laws from different jurisdictions.&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s9&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPS;&quot;&gt;Justice Krishna Kumar also spoke on the unique concept of lavender marriage. &lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;The non-recognition of the right to marry a partner of choice also has an insidious secondary effect, in that it promotes the institution of &lsquo;lavender marriages&rsquo;. The term lavender marriage is used to describe a marriage between a man and a woman in which at least one party is gay, undertaken as a marriage of convenience to hide the sexual orientation of one or both partners due to the social stigma attached to those identities.&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;&rsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;He said.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;b&gt;&lt;span class=&quot;s7&quot; style=&quot;line-height: 21.6px; font-family: TimesNewRomanPSMT;&quot;&gt;Concluding the talk he said &lsquo;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;Within legal frameworks and human rights discourse, the advocacy for LGBTQIA+ rights are firmly rooted in the pursuit of equitable treatment under the law, transcending considerations of sexual orientation or gender identity. Approaching these discussions necessitates sensitivity, and acknowledging the diversity of perspectives shaped by individual beliefs, cultural contexts, and legal frameworks. Nevertheless,&amp;nbsp;&lt;/span&gt;&lt;span class=&quot;s8&quot; style=&quot;line-height: 21.6px; font-style: italic; font-family: TimesNewRomanPSMT;&quot;&gt;international human rights standards increasingly promote the notion that all individuals, regardless of their sexual orientation or gender identity, should receive equal treatment and protection of their rights.&lt;/span&gt;&lt;span style=&quot;line-height: 21.6px;&quot;&gt;&rsquo;&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;line-height: 21.6px;&quot;&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;s6&quot; style=&quot;margin-top: 5px; margin-bottom: 5px; -webkit-tap-highlight-color: rgba(26, 26, 26, 0.3); line-height: 1.8; text-align: justify; font-size: 18px;&quot;&gt;&lt;span style=&quot;line-height: 21.6px;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;/p&gt;', 'af43947e4c4127d33916c9073b348443.JPG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-12-10', 1, '2023-12-10 14:53:26', '2023-12-10 10:16:39'),
(38, '7oGgEP4tlGS9cRRXkp2I5yHCQ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '\'Woman beaten up, paraded naked after son elopes with girl\'. Karnataka High Court registers suo motu case.  ', '&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;IN THE HIGH COURT OF KARNATAKA AT BENGALURU&lt;br&gt;[HIGH COURT OF KARNATAKA VS. THE STATE OF KARNATAKA AND OTHERS]&lt;br&gt;Chief Justice Prasanna B Varale and Justice M G S Kamal&lt;br&gt;Order dated 12.12.2023&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;ORDER This Court takes suo-motu note of the news articles that have been published in Daily News Papers namely, &#039;Deccan Herald&#039;, Bengaluru edition, dated 12.12.2023 under the caption &#039;Woman beaten up, paraded naked after son elopes with girl&#039;. A similar news article published in &#039;The Hindu&#039; daily News paper, Bengaluru edition, dated 12.12.2023 publishes news under the caption &#039;Woman assaulted, tied to a pole after son elopes with girl&#039; and the other most disturbing feature comes through the publication of news in Kannada News daily, &#039;Prajavani&#039;, Bengaluru edition dated 12.12.2023 under the caption &quot;&quot;??? ??? ?????????. ????? ????????????? ????&quot;&quot; which news article carries a photograph.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;2. The caption and contents of the aforesaid news articles not only shocks our conscience but makes us to put our head down with anguish and pain in our hearts. On one hand while this Country is celebrating 76th year of Independence as &lsquo;Azadi ka Amruthotsav&rsquo;, on the other hand, in the State of Karnataka which is known for all valid reasons as a progressive State and a pioneer State of - 2 - initiation of Social justice way back even when it was a Princely State of Mysore, faces this incident.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;3. In the photographs published in the Kannada Daily &lsquo;Prajavani&rsquo; it seems that one Hon&#039;ble Minister Smt. Lakshmi Hebbalkar visited the victim and is consoling her. Though the print media has at least displayed some sensibility and sensitivity while publishing the photograph by blurring the image of the victim and her associates but the disturbing factor is the said photograph reveals that some persons apparently from the electronic media or its representatives are photographing and vediographing the victim&#039;s reaction and narration. Thus, on one hand, where there is a reflection of sensibility, on the other hand there is stark contrast wherein the media persons are seem to be acting most irresponsible and insensitive manner.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;4. In the aforesaid circumstances, if any media house or its representatives has videographed the above interview of the victim during the visit of the Hon&rsquo;ble Minister or any such interaction by the victim, this Court hereby direct not to telecast such interview or interaction on any national or regional Channel. It is further made clear that if already such interview is displayed or telecasted in the electronic media, henceforth there shall not be any display or telecast of the same.&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;5. We also make it clear that this interim direction is only with an object to ensure the dignity of the victim is maintained and her identity is not disclosed or revealed. We further make it clear that this Court by this interim order is not even remotely prohibiting the media from covering the news as this Court maintains and accepts the concept of freedom of press.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;6. We had requested the learned Advocate General to remain present in this court and accordingly learned Advocate General is personally present in this court. We apprised the learned Advocate General about the aforesaid news articles.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;7. Learned Advocate General was fair enough to promptly respond to the concern of this Court and submitted before this Court that he will also take appropriate steps immediately so as to see that there is no undue, uncalled and unwanted coverage of the incident in electronic media.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;8. We also directed the learned Advocate General to submit a status report of the incident to the Court on 14.12.2023.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;9. The Registrar General, High Court of Karnataka, is directed to initiate suo-motu proceedings and take appropriate steps.\\&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;. Authenticated copy of this order be forwarded to the Learned Advocate General.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;Sd/- CHIEF JUSTICE Sd/- JUDGE RU&amp;nbsp;&lt;/span&gt;&lt;/p&gt;', '2d4a0a515488b32d24c183de93f66d6a.jpeg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-12-13', 1, '2023-12-13 20:06:58', '2023-12-13 20:06:58'),
(39, 'y9NC8XoGQl3WHWLJFMNHjdVi6', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '‘A case to bend the arc of justice’. Karnataka High Court declares that a student pursuing multiple courses with prior permission cannot be denied membership of the Council to practice as a Chartered Accountant on technical grounds.', '&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;Nikkitha K.J Vs The Union of India and others.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;Writ Petition 10759 of 2023 decided on 7 December 2023.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;Justice M. Nagaprasanna&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;The petitioner is before this Court calling in question an order/communication dated 1-05-2023 issued by the 3rd respondent declining to accede to the request of the petitioner for membership to practice as a Chartered Accountant and has sought a consequential direction to register the petitioner as a Member of the Institute of Chartered Accountants of India.&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;3. Facts adumbrated are as follows:-&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;The petitioner is a student. In the month of May 2017, she joins B.Com degree at ASC Evening Degree College. Simultaneously, she enrolled herself for a course in CMA Foundation. After joining B.Com degree course, the petitioner completes CMA Foundation course and intermediate course as well in the month of June, 2018 and had pursued her CS-Executive Course which also gets completed in June 2018. Therefore, the petitioner had enrolled herself to several courses&amp;nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;and completed all of them except B.Com. degree course which she is pursuing.&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;4. On 27-08-2018, the petitioner joins Chartered Accountant Articleship training. She then seeks permission to continue her B.Com. degree course by submitting necessary application in Form No.112 under the Chartered Accountants Regulations, 1988 (&lsquo;the Regulations&rsquo; for short) for grant of permission to pursue additional courses. The permission was granted. The petitioner completes her B.Com degree in September, 2020. After completion of B.Com. degree, she seeks permission to write CMA final exam and the respondent permitted additional course also to be taken. The petitioner in December, 2020 completes her CMA final exam as well. After its completion, the petitioner on 30-03-2021 seeks permission to pursue additional course - CS professional again seeking permission by submitting application in Form No.112. Permission is granted. On completion of all the courses and Articleship, the petitioner then files application seeking enrollment as Member of the 2nd respondent to become a Chartered Accountant. Certain clarifications were sought from the hands of the petitioner as to how she pursued multiple&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;courses by submitting Form No.112 and later it was informed that the decision is that the petitioner would not be permitted to enroll as a Chartered Accountant for two years and would be imposed a fine of Rs.10,000/- for having pursued multiple courses on every occasion which the 2nd respondent says it was without permission. Correspondences between the petitioner and the respondents galore, clarifications are sought and replies were given by the petitioner. On 01-05-2023, the membership is categorically denied to the petitioner. It is challenging that action the student is before this Court in the subject petition.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;13. What would unmistakably emerge from the aforequoted communications and the act of the student is that on every occasion, the student has diligently sought permission from the 2nd respondent to pursue the course and on every occasion, the student has been permitted to pursue the course. Now, when time came to register her as a Member of the Council to practice as a Chartered Accountant, the 2 nd respondent wants to put the clock back by four years tinkering with the permissions that are already granted from time to time. It would have been an altogether different circumstance, if the student was not diligent in seeking permissions from time to time to pursue extra courses. It is not the allegation that forms the issue in the lis. The petitioner/student has been&amp;nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;diligent in securing permissions. The mighty respondent now wants to jeopardize the career of a student on the score that it had not properly accorded permission or permission was not properly sought by the student. This act of the 2nd respondent sans countenance.&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;14. This Court is dealing with the fervent cry of the student who sought to pursue multiple courses to develop such acumen and she has completed all those courses with the permission of the 2nd respondent. A student will not know the implications of law. A student knows only to study and ponder over the study material. She has studied and completed the courses. It is rather surprising that the 2nd respondent wants to stifle the career of a student, who has pursued multiple courses and gained such acumen to practice as a Chartered Accountant. It would be helpful to the Institute of Chartered Accountants, and the Society, if a student has extra acumen, than the chartered accountantship alone. Such acts of the 2nd respondent against a student who has only studied and done nothing else, that too after seeking permission would not behove the 2nd respondent to be a State under Article 12 of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Constitution of India. Whatever defence that the council for the 2 nd respondent seeks to project, by invoking Regulation 65 of the Regulations by contending that the permission that was granted was for final courses and not foundation courses that precedes those final courses is a contention skating on thin ice, as the foundation courses gets subsumed in the final courses, and permission is granted for pursuing final courses. Therefore, this Court repels those submissions of the learned counsel for 2 nd respondent, for the praedictus reasons, I deem it appropriate to bend the arc of justice for a student and direct grant of Membership of the petitioner to the Institute without brooking any further delay.&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;ORDER&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;(i) The petition is allowed.&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;', '0cf27ba41f1e6ddb8e88aaaea3517edd.jpeg', 'd4fda0c3d4bd9a6849517f9a86eab7a8.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-12-17', 1, '2023-12-17 15:56:20', '2024-01-18 03:17:40'),
(40, 's3YsFFULAUxsOeAU8zB5LozgM', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitrary action of the Karnataka Examination Authority in allotment of post graduate medical seat. Karnataka High Court imposes cost of Rs. 5 lakhs with a direction to allot the seat to the deserving candidate.', '&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Rajini C.K. Vs The State of Karnataka and others.&lt;o:p&gt;&lt;/o:p&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Writ Petition 24070 of 2023 decided on 19 January 2024.&lt;o:p&gt;&lt;/o:p&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Justice P.S. Dinesh Kumar and Justice T.G. Shivashankare Gowda.&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&lt;span lang=&quot;EN-US&quot;&gt;3. Brief facts of the case are, petitioner is an in-service Doctor working in Anegola Primary Health Centre, K.R.Pete Taluk, Mandya District under the Department of Health and Family Welfare3 , Government of Karnataka. On 19.08.2023, the State Government issued a notification fixing&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;20% of seats in post graduation for in-service candidates. Pursuant to the notification, the Directorate of Medical Education4 published a Seat matrix for 315 seats.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;5. Petitioner&rsquo;s case is, she opted for &lsquo;MD Radio Diagnosis&rsquo; at MRMC, Kalaburgi as her third option. According to her, on 19.09.2023, when she appeared for the second round of counselling, she was offered a seat in &lsquo;MS- Obstetrics and Gynaecology&rsquo;, which she opted. Later she learnt that on 20.10.2023, respondent No.6, who is from ESI Department was allotted the &lsquo;MD radio Diagnosis&rsquo; seat at MRMC, Kalaburgi reserved for HFW Department. Feeling aggrieved, petitioner has filed this writ petition.&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;16. KEA is an instrumentality of the State Government. Candidates desirous of obtaining seats for the undergraduation and post-graduation courses repose immense trust with the KEA. Therefore, the KEA is bound to practice a fair and transparent method of allotment of seats. We repeatedly queried the learned Advocate for the KEA as to how the seat in MD Radio Diagnosis was made available on 06.10.2023,&amp;nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;when it was already cancelled on 19.09.2023. It was sought to be explained by Shri. N.K. Ramesh that the result of second round counselling was &lsquo;already run and finalised&rsquo; pending publication.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;20. The critical analysis of the facts recorded hereinabove, clearly shows that after permitting Nagaraj to withdraw from participation in the counselling as early as on 19.09.2023, KEA continued to show the MD Radio Diagnosis seat as &ldquo;available&rdquo; even as on 06.10.2023 but made a dummy allotment in favour of Nagaraj who was not in the fray at all and that list was announced at 2:40 P.M. Obviously, for the candidates who appeared subsequently, MD Radio Diagnosis seat was not available. Petitioner was driven to a optionless situation, forced to accept whatever was available and she&amp;nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;opted for a seat in Gynaecology. This is a rule of law society. Any illegal act by anyone much less an instrumentality of the State cannot be tolerated. It is unfortunate that the KEA has dealt with a post graduate medical seat in this fashion. So far as the contention urged by the KEA and the respondent No.6 that there could be more meritorious candidates than the petitioner and therefore, she is not entitled for MD Radio Diagnosis, we may record that no other candidate has approached this Court. We are conscious of the fact that it is very difficult to get a seat in post graduation seat in any disciplines in Medicine. Therefore, during the course of the argument, we also called upon the learned Advocate for the respondent No.6 to indicate whether respondent No.6 was agreeable to inter change the seat with the petitioner and we were informed that he was not ready to accept any other seat other that MD Radio Diagnosis.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;ORDER&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;i. Writ petition is allowed with cost of Rs.5,00,000/- payable by the KEA, holding that allotment of MD Radio Diagnosis seat in favour respondent No.6 is wholly illegal and accordingly, it is set-aside.&amp;nbsp;&lt;/b&gt;&lt;/p&gt;', '5edbbe9188d29403372d75335c359712.jpeg', '36bca78546ee5d96f12f90b2a609d34f.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2024-01-25', 1, '2024-01-25 15:05:35', '2024-01-25 15:19:04');
INSERT INTO `news` (`news_id`, `news_key`, `category_key`, `news_title`, `news_description`, `news_image`, `news_attachment`, `news_author`, `news_date`, `news_status`, `news_date_added`, `news_date_updated`) VALUES
(41, 'WApfmucOdAzjztMkd9beS351d', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '\'\'Stop fighting with each other and provide accommodation/ rehabilitation to slum dwellers\'\'. Karnataka High Court orders two government wings to work together for the benefit of beggars and slum dwellers. ', '&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Central Relief Committee Vs The Deputy Commissioner and others.&lt;o:p&gt;&lt;/o:p&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Writ Petition 55797 of 2017 decided on 8 February 2024.&lt;o:p&gt;&lt;/o:p&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;Justice M. Nagaprasanna.&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;The Petitioner/Central Relief Committee constituted under the Karnataka Prohibition of Beggary Act, 1975 (hereinafter referred to as &lsquo;the Act&rsquo; for short) is calling in question an order dated 22-09-2017 passed by the 1st respondent declaring a particular&nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;area as a slum. The preliminary notification so issued on 20-10-2014 is also called in question.&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;2. The facts adumbrated are as follows:-&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;The petitioner claims to be a Committee constituted by the Social Welfare Department for the purpose of administration and management of Beggars&rsquo; Rehabilitation Centre established for rehabilitation and welfare of beggars. It is the averment in the petition that the then State of Mysore (now Karnataka) in the year 1944 had acquired 311 acres of land in several survey numbers of Sajjepalya and Srigandhakavalu Villages in Yeshwanthpur Hobli, Bangalore North Taluk and had handed them over to Beggars&rsquo; Rehabilitation Centre. Out of the said land 63.02 acres of land at Sajjepalya Village was granted on lease for 30 years to Sumanahalli Leprosy Patients&rsquo; Rehabilitation Centre by the Government in terms of an order dated 05-12-1977. It is the averment that several unauthorized persons were in occupation of the land that was granted to Beggars Rehabilitation Centre and one such encroacher i.e., Sri. K.V. Govindaraju had approached this Court claiming&nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;regularization of his unauthorized occupation in W.P.No.11714 of 1987. This Court in terms of its order dated 25-01-1996 dismissed the writ petition which went up to the Apex Court only to meet failure.&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;15. It now becomes germane to notice the provisions of the 1973 Act. Section 3 reads as follows:&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;&ldquo;3. Declaration of slum areas.- (1) Where the Government is satisfied, that,-&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(a) any area is or is likely to be a source of danger to health, safety or convenience of the public of that area or of its neighborhood, by reason of the area being low-lying, insanitary, squalid, over-crowded or otherwise; or&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(b) the buildings in any area, used or intended to be used for human habitation are,-&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(i) in any respects, unfit for human habitation; or&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(ii) by reason of dilapidation, over crowding, faulty arrangement and design of such buildings, narrowness or faulty arrangement of streets, lack of ventilation, light or sanitation facilities, or any combination of these factors, detrimental to safety, health or morals, it may, by notification, declare such area to be a slum area.&nbsp;&lt;br&gt;&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;&nbsp;&lt;br&gt;&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(2) In determining whether a building is unfit for human habitation, for the purposes of this Act regard shall be had to its condition in respect of the following matters, that is to say,-&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(i) repair,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(ii) stability,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(iii) freedom from damp,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(iv) natural light and air,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(v) water-supply,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;i&gt;&lt;b&gt;(vi) drainage and sanitary conveniences,&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&lt;i&gt;(vii) facilities for storage, preparation and cooking of food and for the disposal of waste water, and the building shall be deemed to be unfit as aforesaid, if it is so defective in one or more of the said matters that it is not reasonably suitable for occupation.&rdquo;&lt;/i&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span lang=&quot;EN-US&quot;&gt;&lt;b&gt;&nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&lt;span lang=&quot;EN-US&quot;&gt;Section 3 deals with declaration of slum areas. It is the power of the Government, if it is satisfied that any area is or is likely to be a source of danger to health, safety or convenience of the public of that area or its neighbourhood can be declared as a slum. Section&nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;11 deals with slum clearance and re-development and reads as follows:&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;i&gt;&lt;b&gt;&ldquo;11. Power to declare any slum area to be slum clearance area.- (1) Where the Government, on a report from the Board or the prescribed authority or the local authority concerned or the State Housing Board or an officer authorised by the Government for this purpose is satisfied as respects any slum area that the most satisfactory method of dealing with the conditions in the area is the clearance of such area and the demolition of all the buildings in the area, it may, by notification, declare the area to be a slum clearance area, that is to say, an area to be cleared of all buildings in accordance with the provisions of this Act:&lt;/b&gt;&lt;/i&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;i&gt;&lt;b&gt;Provided that before issuing such notification the Government shall call upon the owners of the lands and buildings in such slum area to show cause why such declaration should not be made and after considering the cause if any, shown by such owners, it may pass such orders as it may deem fit.&lt;/b&gt;&lt;/i&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;i&gt;&lt;b&gt;(2) Any part of the slum area or any building in the slum area which is not unfit for human habitation or dangerous or injurious to safety, health or morals may be excluded from the notification under sub-section (1) if the Government considers it necessary.&lt;/b&gt;&lt;/i&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&lt;i&gt;(3) The notification under sub-section (1) shall specify each of the buildings to be demolished and the area to be cleared.&rdquo;&nbsp;&lt;/i&gt;&lt;br&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;Whereupon a declaration under Section 3 the Government is empowered to clear such area, demolish the buildings therein and rehabilitate such slum dwellers. The procedure for demolition and execution of works for improvement of slum is all dealt with under&nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;the Act. Therefore, the State is statutorily empowered to declare an area as a slum. It is no doubt true that rehabilitation of beggars is imperative, but rehabilitation of slum dwellers cannot take a back seat. If what is observed in the proceedings of the Deputy Commissioner which declares 27 guntas of land for development and rehabilitation of slum, it would completely come within the power and the reason as prescribed under Section 3 of the Act. Therefore, no fault can be found with the action of the State to declare, the area of 27 acres by the impugned proceedings of the Deputy Commissioner.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;16. The other submission of the learned senior counsel for the petitioner is that issuance of preliminary notification is not found in the Act and therefore, the entire proceedings are illegal. This submission is again unacceptable. Merely because it is a preliminary notification, it would not clothe the petitioner/Central Relief Committee constituted under the Act to seek annulment of proceedings on the score that preliminary notification is erroneously issued. The State is empowered to declare an area as a slum. The assertion of the petitioner to contend that it is its own land cannot&nbsp;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;be accepted. The effective implementation of the Act would come within the Social Welfare Department. It is a wing of the State. Effective rehabilitation of slum dwellers would come within the Slum Development Board, another wing of the State. One wing of the State fighting against the other wing has led to poor slum dwellers caught in the cross-fire who have not seen the light of the day of getting the houses constructed.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;17. The learned counsel for the 3rd respondent has appended documents to his statement of objections to demonstrate that the land is being looted. The Central Relief Committee which claims to be in possession of the land has let several encroachers to encroach its land and is not pointing a finger at it, but is making hue and cry about 27 guntas of land being granted for rehabilitation of slum dwellers. It is rather surprising that one wing of the State is in squabble with the other wing of the State. It is submitted by the State that a dispute resolution mechanism is in place to resolve the dispute between any departments of the State. This could have been sorted out by the Government itself, but the Central Relief Committee chose to litigate. It is not a case where the Central&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Relief Committee is divested off the entire 63 acres that is allotted to them. What is taken away by the impugned action is barely 27 guntas, out of the 63 acres. The Central Relief Committee has kept the pot of litigation boiling for the last 7 years and no rehabilitation of the slum dwellers has taken place. If major portion of the land had been taken away, it would have been a circumstance altogether different, which is not the one in the case at hand. Therefore, the challenge is rendered unsustainable and a direction must ensue to speed up the construction in the 27 guntas of land declared to be a slum by the impugned action.&lt;/span&gt;&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;ORDER&lt;/b&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;&quot;&gt;&lt;b&gt;(i) Writ Petition stands rejected.&nbsp;&lt;/b&gt;&lt;/p&gt;', '3908184aa36ba8fe49072209932adfeb.jpeg', '014d2561ce71ee0c1d2931df51313843.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2024-02-13', 1, '2024-02-13 14:38:21', '2024-02-13 14:45:16'),
(42, 'nhsiUYG5jwU4CH1fA97M4wQDT', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Navigating the Complexities of Premium FAR in Urban Development: A Legal Perspective.', '&lt;p&gt;Prashant Mirle, Advocate, Karnataka High Court.&amp;nbsp;&lt;/p&gt;&lt;p&gt;Introduction&lt;br&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;The discourse surrounding Premium Floor Area Ratio (FAR) in Karnataka&#039;s urban planning sphere has unfolded against a backdrop of legal scrutiny and public debate. As the individual who initiated Public Interest Litigation (PIL) through Writ Petition No. 19694/2021, I approach this discussion with a profound respect for the judicial process and the law. This article aims to shed light on the complexities of implementing Premium FAR, the legal challenges that have emerged, and the implications for sustainable urban development, all while navigating the sensitivities of ongoing judicial proceedings.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Simplifying Premium FAR&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;To understand Premium FAR, let&rsquo;s use a straightforward analogy. Imagine you own a plot of land where the rules state you can only build a house that covers half of the plot, ensuring there&rsquo;s space for a garden, parking, etc. This rule resembles the concept of FAR, which limits how much of the land can be built upon. Now, if the government allows you to build over more than half your plot in exchange for a fee, granting what is known as &quot;Premium FAR,&quot; you essentially get permission to expand your construction beyond standard limits for a price. This fee then contributes to funding public amenities like parks and schools.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;For instance, owning a 1,000 square feet plot in Bengaluru typically allows you to construct a building of 2,000 square feet under standard FAR regulations. With Premium FAR, for a certain fee, you might be permitted to build up to 3,000 square feet, enhancing the density and potentially the profitability of your development on the same plot.&lt;/p&gt;&lt;p&gt;The Essence of Legal Challenges.&lt;br&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;The crux of the challenge to Premium FAR implementation lies in its potential to reshape urban development in ways that may not align with sustainable and equitable growth principles. The introduction of Premium FAR, particularly through the contested sections of the Karnataka Town and Country Planning (Fourth Amendment) Act 2020[1], has raised questions about the fairness and transparency of urban planning processes.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;In initiating Writ Petition No. 19694/2021, the aim was not merely to contest a specific legislative action but to advocate for a planning framework that ensures the holistic development of our urban spaces[2]. This legal action reflects a commitment to safeguarding the public interest against arbitrary and potentially exclusionary development practices.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Ongoing Legislative Efforts and Judicial Proceedings.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;As the state government moves forward with further amendments, such as those proposed in the Karnataka Town and Country Planning (Amendment) Bill 2024[3], it is crucial to remain cognizant of the broader legal and ethical implications. The pursuit of amendments amidst ongoing legal challenges underscores the dynamic and often contentious nature of urban planning legislation.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;It is with the utmost respect for the judicial proceedings that I highlight these issues, understanding that the courts play an indispensable role in mediating between legislative intent and the public good. The legal challenges, including the notable cases such as Writ Petition No. 6193/2022 and Contempt Case No. CCC 901/2022[4], serve as critical junctures for reflecting on our urban development policies and practices.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;Conclusion&lt;br&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;The dialogue on Premium FAR and its implications for Karnataka&#039;s urban development is a testament to the intricate balance between growth, sustainability, and equity. As we navigate these challenges, both in the courts and in public discourse, it is imperative to approach these discussions with a sense of responsibility and reverence for the legal process. The path forward must be charted with a deep commitment to the principles of justice, ensuring that our urban landscapes evolve in a manner that benefits all members of society.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;Endnotes&lt;br&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;1. Karnataka Town and Country Planning (Fourth Amendment) Act 2020, Section 18-B.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;2.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Writ Petition No. 19694/2021.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;3.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Karnataka Town and Country Planning (Amendment) Bill 2024, passed on February 20, 2024.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;4.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;Writ Petition No. 6193/2022 [LB-BMP] and Contempt Case No. CCC 901/2022.&lt;/span&gt;&lt;/p&gt;&lt;div&gt;&lt;span style=&quot;font-family: var(--bs-font-sans-serif); font-size: 1rem;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;', '5f8c09e1f5fad2892541bb4bc6628ebc.jpeg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2024-02-22', 1, '2024-02-22 19:18:52', '2024-10-07 05:48:49'),
(44, 'fa80d66634c2b858fd5efac9', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Test', '&lt;p&gt;Test text&amp;nbsp;&lt;/p&gt;', '1728280246_d7de078b21cb08d7f0d6.tif', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2024-10-07', 1, '2024-10-07 05:50:46', '2024-10-07 05:50:46'),
(47, '9681568e95986e7a6c925910', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'suppppppp', '&lt;p&gt;suppppppppp&lt;/p&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;&lt;hr&gt;&lt;p&gt;&lt;br&gt;&lt;/p&gt;', '1728368619_fd89b373f179af95b197.jpeg', '1728368619_27c934ff88e4ee1c97b5.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2024-10-08', 1, '2024-10-08 06:23:39', '2024-10-08 06:23:39');
