
-- --------------------------------------------------------

--
-- Table structure for table `judgements`
--

DROP TABLE IF EXISTS `judgements`;
CREATE TABLE IF NOT EXISTS `judgements` (
  `judgement_id` int NOT NULL,
  `judgement_key` varchar(255) NOT NULL,
  `judgement_category_key` varchar(255) NOT NULL,
  `judgement_title` longtext NOT NULL,
  `judgement_desc` longtext NOT NULL,
  `judgement_img` varchar(255) NOT NULL,
  `judgement_attachment` varchar(255) DEFAULT NULL,
  `judgement_author` varchar(255) NOT NULL DEFAULT 'GawtOCEN1d5N6m7YcGG3NfK6L',
  `judgement_date` varchar(100) NOT NULL,
  `judgement_status` tinyint NOT NULL DEFAULT '1',
  `judgement_bookmark` text NOT NULL,
  `judgement_like` text NOT NULL,
  `judgement_date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `judgement_date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `judgements`
--

INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(6, '3Uu01S0pzK6fe17YrGZn8YYW2', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Motor Vehicle Act. Tribunal is not bound by charge-sheet in criminal cases . Tribunal has to decide based on evidence when prima facie fraud is alleged. Karnataka High Court.', '<p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Mahadevi and others vs Shivaputra and another. Miscellaneous First Appeal 201689/2016 (MV) decided on 20 November 2020.</span></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Judgment Link:&nbsp;<a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/349819/1/MFA201689-16-20-11-2020.pdf\" rel=\"nofollow\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: var(--color-link);\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/349819/1/MFA201689-16-20-11-2020.pdf</a></span></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\">The Karnataka High Court has expressed deep concern and anguish over the increasing cases where insured vehicles are implanted just to get compensation. In many vehicular accidents, the actual vehicle that caused accident lacks insurance policy. Many cases involve ‘hit and run’ accidents. In such cases, the “unscrupulous nexus” stages false scenario in implanting a “proxy” vehicle which is covered by insurance policy. The present case is a classic example of a clear fraud.&nbsp;<span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">After 103 days of the accident, brother of the deceased produces his own insured vehicle insinuating its involvement in the accident!</span></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\">The Court noticed the earlier judgment in&nbsp;<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Sumangala and others vs Virupakshi and another MFA 30219/2011&nbsp;</em>decided on 15 June 2011. The fervent plea of the insurance company in the said case, questioning involvement of the insured vehicle as shown in the final report, was brushed aside by observing that<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">&nbsp;‘if there was any shady material which creates suspicion about the credibility of the final report, the proper course for the insurer should have been to apply to the higher authorities to get the matter investigated or at least should have challenged the final report seeking a writ of mandamus for reinvestigation”.&nbsp;</em>However, the High Court in Mahadev’s case observed as follows<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">; “”</span></em></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\"><em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">“<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">‘</em>We have, with great respect, perused the entire judgment. From a perusal of the same, we do not find any law laid down in the said judgment of universal application that in all cases where charge sheets were</em>&nbsp;<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">filed, unless Insurance Company challenges the same and obtains writ of mandamus, MACTs are required to act upon the same and proceed to come to a conclusion that the vehicles named as offending vehicles in the charge sheet, without any further proof, are to be taken as the motor vehicles involved in causing the accident, even in cases where evidence produced points to the contrary.</em></span></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\">‘<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Further, we find that in the said judgment, there is no discussion of the relevant provisions of Code of Criminal Procedure or other cognate provisions of law under which the police authorities would investigate and file charge sheets and on the probative value of the charge sheets vis-a-vis the involvement of a motor vehicle in causing the accident before the Tribunals trying the compensation cases. Experience of the recent past shows that instances of fraudulent/collusive involvement of motor vehicles duly covered by insurance</span>&nbsp;<span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">policy in accident cases are burgeoning and if the insurance companies are saddled with the burden of challenging the charge sheets filed throughout the country without there being no clear legal mandate to do so, their work would be seriously crippled and they would not be able to do their insurance business without enhancing the premium, thereby further burdening the ever suffering owners of motor vehicles. Even the most liberal reading the provisions of the Motor Vehicles Act, 1988 does not spell out such a requirement.</span></em></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">The question is one of fundamental importance – what is the standard of proof applicable in these proceedings? On whom is the initial burden of proving the accident or, as in this case, involvement of the offending motor vehicle cast? Is not still the standard of proof one of “preponderance of probabilities”? Is a mere charge’ sheet, which in this case is shown to be deficient in truth sufficient to tip the balance only on the premise that insurance company has not dipped deep into its pockets to challenge the charge sheet- what with the toxic nexus between the black sheep among the police, medical professionals and touts of every kind masquerading the field which has become a notorious fact of life. We are afraid, we would be muddling the field further for the already befuddled members of MACT by accepting the arguments of learned counsel for the appellants on this aspect’.</span></em></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">NOTE:&nbsp;</span>Fraud is a ground to question any administrative orders, quasi-judicial and even judicial verdicts. Lord Denning in one of his most celebrated judgments in Lazarus Estates Ltd v Beasley [1956] 1 Q.B. 702; [1956] 2 W.L.R. 502 held&nbsp;<em style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-weight: inherit; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">“No court in this land will allow a person to keep an advantage which he has obtained by fraud. No judgment of a court, no order of a Minister, can be allowed to stand if it has been obtained by fraud.&nbsp;<span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Fraud unravels everything.&nbsp;</span>The court is careful not to find fraud unless it is distinctly pleaded and proved; but once it is proved, it vitiates judgments, contracts and all transactions whatsoever…”</em></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\">The decision of the High Court has armed the Tribunals to independently assess involvement of insured vehicles when fraud is alleged and prima facie shown. The Tribunals are no longer shackled by the chargesheets filed in criminal cases.</p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 24px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">A path-breaking judgment in the direction of saving insurance companies from succumbing in the web of conspiracy, deceit and fraud.</span></p><p class=\"has-normal-font-size\" style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: &quot;Noto Serif&quot;, Georgia, &quot;Times New Roman&quot;, Times, serif; font-size: 17px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; outline: 0px; padding: 0px; vertical-align: initial; color: rgb(60, 67, 74); background-color: rgb(255, 255, 255);\"><span style=\"-webkit-tap-highlight-color: rgba(0, 0, 0, 0); border: 0px; font-family: inherit; font-style: inherit; font-weight: 600; margin: 0px; outline: 0px; padding: 0px; vertical-align: initial;\">Compiled and written by S. Basavaraj, Advocate, Daksha Legal.</span></p>', '4973e3782411a9f8f7a05c55bf0768f5.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '', 1, '', '', '2020-11-28 21:16:22', '2020-12-21 09:14:26'),
(5, 'FAGq1a7XaL8HxZBBspYRJG5vh', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Marriage Act. Section 13B. Parties can be represented by their partners or siblings, as GPA holders subject to the satisfaction of the court. Karnataka High Court', '<h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">Aditya Jagannath and another vs NIL . M.F.A.No.4453/2020 (FC)</span>&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">decided on 10 November 2020.<br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Judgment Link:&nbsp;<a href=\"https://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-4453-2020.pdf\" rel=\"nofollow\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\">https://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-4453-2020.pdf</a></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><a href=\"https://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-4453-2020.pdf\" rel=\"nofollow\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><br></a></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">HELD</span>:&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">26. Permission is granted to the second appellant to be represented through her Power of Attorney holder, who is none other than her father on the strength of the Special Power of Attorney executed by her.</span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\"><br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Relevant paragraphs:&nbsp;</span><b>16.</b> In recent times, we find that the parties who seek for dissolution of their marriage by a decree of divorce by mutual consent do so after long negotiation and discussion, some times they, being located at different parts of the globe, through skype, telephonically or use of other forms of technology, such as whatsapp calls, video conferencing etc. On account of the parties residing in different parts of the country or across the globe and owing to constraints of job or other constraints, such as illness etc., it may not be possible for both parties to sign and verify the pleadings and jointly present the petition for dissolution of their marriage by mutual consent before the Court of Law. This is so in the instant case. In such circumstances, one of the parties to the petition may avail of the facility of appointing a Power of Attorney/agent, in whom the party has full trust and confidence to represent her or him in a proceeding to be filed as in the instant case before the Family Court or any other Court seeking matrimonial or any other relief. Therefore, the provisions of the various enactments must be harmoniously read and interpreted, so as to make it conducive for availing or taking recourse through appointment of a Power of Attorney holder, to represent a party in a proceeding. This is particularly, as in the instant case, where parties are seeking dissolution of their marriage by a decree of divorce by mutual consent. Moreover, in such cases, a party can carefully think over the matter and appoint a person in whom the party would have full trust and confidence to be as her or his Power of Attorney holder. It is on the strength of such a document of Power of Attorney that the Power of Attorney holder would represent a party to jointly file a petition for dissolution of their marriage through mutual consent on behalf of the executor or Power of Attorney. The Family Court may insist on satisfying itself that indeed the parties have an intention that they should seek a decree of divorce by mutual consent and in order to fully satisfy itself, the Court may, apart from examining the Power of Attorney holder representing any party, also through video conferencing, (which is now widely being used on account of the Covid-19 pandemic), examine the parties including the party who is represented through the Power of Attorney holder. That merely because one of the parties would file the petition seeking dissolution of marriage by mutual consent jointly with the other party, through a Power of Attorney, one cannot ignore the fact that the Court must satisfy itself about the genuineness of the petition filed by the parties seeking dissolution of their marriage by a decree of divorce by mutual consent irrespective of whether it is filed through a Power of Attorney. In fact, the filing of such a petition is an exception to what has been stated in Section 23 of the Act. Even so, the Court ought not to be pedantic but must apply a flexible procedure which is in accordance with law and not a procedure, but not one which is incongruent in law.</h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">17.&nbsp;</span>In fact, recently, the Hon’ble Supreme Court in the case of <b>Amardeep Singh vs. Harveen Kaur [(2017) 8 SCC 746] </b>while considering Section 13B(2) of the Act, which stipulates a cooling off period of six months which is also a period of locus poenitentiae, after filing a petition of divorce under Section 13B(1) of the Act, so as to give an opportunity to the parties to rethink over the decision and thereafter, to confirm their decision six months later, has made the said provision less rigid and more pro-litigants by bearing in mind the changed circumstances and peculiarities of the case. Nevertheless, in the said case, it has been observed that the period of six months should be waived owing to the circumstances of the particular case, the exigencies of the situation and bearing in mind the interest of the parties so that justice would be subserved in the matter. In this regard, the Hon’ble Supreme Court has observed that the period mentioned in Section 13B(2) could be construed to be as directory and not mandatory and it would be open to the Court to exercise its discretion in the facts and circumstances of each case, where there are no possibilities of parties to reconcile, cohabit and there are no chances of alternative rehabilitation.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><br></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">18.&nbsp;</span>A reading of the above would clearly indicate that the Hon’ble Supreme Court has also made it flexible in the context of representation of the parties by their close relatives, partners or siblings or any other person in whom they have complete trust to be appointed as a Power of Attorney holder. In fact, as already noted, the Court can always satisfy itself about the genuineness of the intention of the parties who approach the Court either by themselves or through a Power of Attorney holder by way of video conferencing, so that any doubts about the genuineness of the petition being filed before the Court is removed.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">19.&nbsp;</span>On a perusal of the aforesaid observations of the Hon’ble Supreme Court, it is clearly permissible for the parties to be represented by their partners or siblings in a proceeding filed under Section 13B(1) of the Act or any other similar provision in any other enactment, which provides for dissolution of marriage by a decree of divorce by mutual consent.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><br></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">20…&nbsp;</span>Moreover, for the sake of satisfying and genuineness of the petition, the Family Court could always resort to video conferencing through the medium of which, both the parties could appear apart from the Power of Attorney holder of the second appellant appearing for her, so as to completely satisfy itself about the genuineness of the petition filed by the parties just as presently in this appeal, the appellants have both appeared through video conferencing, first appellant from Bengaluru and the second appellant from Toranto, Canada.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><br></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">26. Permission is granted to the second appellant to be represented through her Power of Attorney holder, who is none other than her father on the strength of the Special Power of Attorney executed by her.<br></span><br></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\">27.&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Further, in order to satisfy itself, the Family Court is at liberty to direct the parties especially the second appellant to appear through video conference or skype, before the Court and if such a direction is issued, the second appellant shall comply with the said direction.<br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\"><br></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">Judgments cited/relied on:</span>&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-weight: bolder;\">Komal S. Padukone vs. Principal Judge, Family Court [ILR 1999 KAR 2811], Harshada Bharat Deshmukh vs. Bharat Appasaheb Deshmukh [AIR 2018 Bombay 148], Sudha Ramalingam vs. Registrar General, High Court of Judicature at Madras [AIR 2015 (NOC) 266 (MAD)], Kunhi Purayil Mukundan Naveen vs. Anjalika Dinesh [AIR 2011 (KER) 186], Dasam Vijay Rama Rao vs. M.Sai Sri [ALD-2015-4-757], Amardeep Singh vs. Harveen Kaur [(2017) 8 SCC 746], Komal S. Padukone vs. Principal Judge, Family Court at Bangalore City [ILR 1999 KAR 2811], Harshada Bharat Deshmukh vs. Bharat Appasaheb Deshmukh [AIR 2018 Bombay 148], Sudha Ramalingam vs. Registrar General, High Court of Judicature at Madras [AIR 2015 (NOC) 266 (MAD.)], Dasam Vijay Rama Rao vs. M.Sai Sri [ALD-2015-4-757].<br></span></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><br></span></h1><h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(50vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: \" crimson=\"\" text\",=\"\" \"baskerville=\"\" old=\"\" face\",=\"\" garamond,=\"\" \"times=\"\" new=\"\" roman\",=\"\" serif;=\"\" font-size:=\"\" 22px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Compiled by S. Basavaraj, Advocate, Daksha Legal.</span></h1>', '844479195a6da85633fd6f8fc05f35b8.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '', 0, '', '', '2020-11-28 21:05:49', '2021-08-21 13:40:50');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(7, 'uOa9gkIt6sB3mmHTZPYrqkuiK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Order 39 Rules 1 and 2. Purpose of granting ad interim injunction is to preserve the subject matter of the suit in the status quo for the time being. Supreme Court. ', '<p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;text-align:\r\njustify;line-height:150%;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" align=\"right\" style=\"margin-top:2.0pt;margin-right:21.6pt;\r\nmargin-bottom:10.0pt;margin-left:0cm;text-align:right;mso-layout-grid-align:\r\nnone;text-autospace:none\"><b><span style=\"font-size:19.0pt;mso-bidi-font-size:14.0pt;line-height:115%;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\"\">Daksha Legal </span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:2.0pt;margin-right:21.6pt;\r\nmargin-bottom:10.0pt;margin-left:0cm;text-align:center;mso-layout-grid-align:\r\nnone;text-autospace:none\"><b><span style=\"font-size:24.0pt;mso-bidi-font-size:14.0pt;line-height:115%;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\"\">IN THE SUPREME COURT OF INDIA<o:p></o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:2.0pt;margin-right:21.6pt;\r\nmargin-bottom:10.0pt;margin-left:0cm;text-align:center;mso-layout-grid-align:\r\nnone;text-autospace:none\"><span style=\"font-size:14.0pt;line-height:115%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">(BEFORE\r\nJustice K. RMASWAMY AND Justice G.N.RAY)</span><b><span style=\"font-size:23.0pt;mso-bidi-font-size:14.0pt;line-height:\r\n115%;font-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p></o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:2.0pt;margin-right:14.4pt;\r\nmargin-bottom:0cm;margin-left:14.4pt;margin-bottom:.0001pt;text-align:center;\r\nline-height:normal;mso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:16.0pt;mso-bidi-font-size:\r\n12.0pt;font-family:\"Verdana\",\"sans-serif\";mso-bidi-font-family:Verdana\">Civil\r\nAppeal Nos. 5054-55 of 1991, decided on December 16, 1991</span></b><b><span style=\"font-size:16.0pt;mso-bidi-font-size:\r\n12.0pt;font-family:\"Times New Roman\",\"serif\"\"><o:p></o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:2.0pt;margin-right:14.4pt;\r\nmargin-bottom:0cm;margin-left:14.4pt;margin-bottom:.0001pt;text-align:center;\r\nline-height:normal;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:12.0pt;font-family:\"Times New Roman\",\"serif\"\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;line-height:normal;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><i><span style=\"font-size:\r\n23.0pt;mso-bidi-font-size:10.0pt;font-family:\"Times New Roman\",\"serif\"\">(1992)\r\n1 SCC 719</span></i></b><b><span style=\"font-size:27.0pt;mso-bidi-font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p></o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:2.0pt;margin-right:14.4pt;\r\nmargin-bottom:10.0pt;margin-left:14.4pt;text-align:center;mso-layout-grid-align:\r\nnone;text-autospace:none\"><span style=\"font-size:14.0pt;line-height:115%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p> </o:p></span></p>\r\n\r\n<table class=\"MsoTableGrid\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: none;\">\r\n <tbody><tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;line-height:\r\n  normal;mso-layout-grid-align:none;text-autospace:none\"><b><i><span style=\"font-size:23.0pt;mso-bidi-font-size:10.0pt;font-family:\"Times New Roman\",\"serif\"\">Dalpat\r\n  Kumar</span></i></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\"><o:p></o:p></span></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border:solid windowtext 1.0pt;\r\n  border-left:none;mso-border-left-alt:solid windowtext .5pt;mso-border-alt:\r\n  solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-top:3.0pt;margin-right:180.0pt;margin-bottom:\r\n  2.5pt;margin-left:18.0pt;text-indent:-18.0pt;line-height:normal;mso-layout-grid-align:\r\n  none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\">Appellant.</span><span style=\"font-size:14.0pt;\r\n  font-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p></o:p></span></p>\r\n  <p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;line-height:\r\n  normal;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\"><o:p> </o:p></span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  border-top:none;mso-border-top-alt:solid windowtext .5pt;mso-border-alt:solid windowtext .5pt;\r\n  padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;line-height:\r\n  normal;mso-layout-grid-align:none;text-autospace:none\"><i><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\">Versus <o:p></o:p></span></i></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;\r\n  mso-border-top-alt:solid windowtext .5pt;mso-border-left-alt:solid windowtext .5pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-top:3.0pt;margin-right:180.0pt;margin-bottom:\r\n  2.5pt;margin-left:18.0pt;text-indent:-18.0pt;line-height:normal;mso-layout-grid-align:\r\n  none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\"><o:p> </o:p></span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  border-top:none;mso-border-top-alt:solid windowtext .5pt;mso-border-alt:solid windowtext .5pt;\r\n  padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;line-height:\r\n  normal;mso-layout-grid-align:none;text-autospace:none\"><b><i><span style=\"font-size:23.0pt;mso-bidi-font-size:10.0pt;font-family:\"Times New Roman\",\"serif\"\">Prahlad\r\n  Singh</span></i></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\"><o:p></o:p></span></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;\r\n  mso-border-top-alt:solid windowtext .5pt;mso-border-left-alt:solid windowtext .5pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-bottom:0cm;margin-bottom:.0001pt;line-height:\r\n  normal;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana\">Respondent.<o:p></o:p></span></p>\r\n  </td>\r\n </tr>\r\n</tbody></table>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"text-align:center;line-height:normal;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><i><span style=\"font-size:\r\n24.0pt;mso-bidi-font-size:10.0pt;font-family:\"Times New Roman\",\"serif\"\"><o:p> </o:p></span></i></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">K. RAMASWAMY, J.</span></b><span style=\"font-size:14.0pt;line-height:\r\n150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">—\r\nLeave granted.</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">2.</span></b><span style=\"font-size:14.0pt;line-height:150%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">\r\nSri S.K. Jain, on his application, is discharged.</span><span style=\"font-size:\r\n14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">3.</span></b><span style=\"font-size:14.0pt;line-height:150%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">\r\nHeard the counsel on either side. This is the fourth round of litigation\r\nrelating to the same subject matter. On June 14, 1979 the first appellant\r\nclaimed to have entered into an agreement to purchase the residential house\r\nsituated in Jaipur for a consideration of Rs 51,000. He laid the suit for\r\nspecific performance and the suit was decreed ex parte. On August 10, 1983, the\r\nsale deed was executed through court. On April 28, 1984, the respondent’s wife\r\nfiled Suit No. 83 of 1984 and also sought for temporary injunction from\r\ndispossession. In May 1984, the trial court rejected the application for ad\r\ninterim injunction which was confirmed, on appeal, by the High Court on July\r\n14, 1987. Thereafter the suit was got dismissed for non-prosecution. The first\r\nappellant filed Execution Application No. 6 of 1985 in which the respondent\r\nfiled five unsuccessful objections. The first was dismissed on March 4, 1987.\r\nThe second one on </span><span style=\"font-size:14.0pt;line-height:150%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\"Times New Roman\";\r\nmso-fareast-language:EN-GB;mso-no-proof:yes\"><!--[if gte vml 1]><v:shape id=\"Picture_x0020_2\"\r\n o:spid=\"_x0000_i1027\" type=\"#_x0000_t75\" style=\'width:26.25pt;height:10.5pt;\r\n visibility:visible;mso-wrap-style:square\'>\r\n <v:imagedata src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image003.png\"\r\n  o:title=\"\"/>\r\n</v:shape><![endif]--><!--[if !vml]--><img width=\"35\" height=\"14\" src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image003.png\" v:shapes=\"Picture_x0020_2\"><!--[endif]--></span><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">December 4, 1987, which was confirmed on revision by the High Court on\r\nJanuary 20, 1988. The third one on October 4, 1987 and fourth one on January\r\n17, 1989. Even thereafter fifth objection was filed on May 23, 1989 which was\r\ndismissed on October 24, 1989. This was also confirmed by the High Court in\r\nCivil Revision No. 109 of 1990 dated August 7, 1990. The third round of\r\nlitigation was started at the behest of his sons in O.S. No. 278 of 1988\r\nclaiming to be the joint family property and for a declaration that the sale\r\ndoes not bind them and they sought for partition. They also sought for ad\r\ninterim injunction which was rejected on July 7, 1988. On appeal, the High\r\nCourt in Misc. Appeal No. 177 of 1988 confirmed it by the order dated July 26,\r\n1988. The fourth round of litigation was started by the respondent in filing\r\nthe present suit on December 7, 1988 pleading, that the first appellant being\r\nhis counsel played fraud on him, in paragraphs 9 and 10, the details of which\r\nare not material for the purpose of this case. He also sought for an interim\r\ninjunction from dispossession. In the meanwhile a part of the property, namely,\r\nshops were obtained symbolical possession by the first appellant. The trial\r\ncourt by order dated November 3, 1990 dismissed the application. On appeal, the\r\nHigh Court in Misc. Appeal Nos. 498 of 1990 and 501 of 1990 by the impugned\r\norder dated February 26, 1991 allowed the applications and granted ad interim\r\ninjunction restraining the appellants from taking possession of the residential\r\nportion.</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><u><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana;mso-bidi-font-weight:bold\">4.</span></u><u><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\"> Order 39 Rule 1(<i>c</i>) provides that temporary injunction may be\r\ngranted where, in any suit, it is proved by the affidavit or otherwise, that\r\nthe defendant threatens to dispossess the plaintiff or otherwise cause injury\r\nto the plaintiff in relation to any property in dispute in the suit, the court\r\nmay by order grant a temporary injunction to restrain such act or make such\r\nother order for the purpose of staying and preventing … or dispossession of the\r\nplaintiff or otherwise causing injury to the plaintiff in relation to any\r\nproperty in dispute in the suit as the court thinks fit until the disposal of\r\nthe suit or until further orders. Pursuant to the recommendation of the Law\r\nCommission clause (<i>c</i>) was brought on statute by Section 86(<i>i</i>)(<i>b</i>)\r\nof the Amending Act 104 of 1976 with effect from February 1, 1977. Earlier\r\nthereto there was no express power except the inherent power under Section 151\r\nCPC to grant ad interim injunction against dispossession. Rule 1 primarily\r\nconcerned with the preservation of the property in dispute till legal rights\r\nare adjudicated. Injunction is a judicial process by which a party is required\r\nto do or to refrain from doing any particular act. It is in the nature of\r\npreventive relief to a litigant to prevent future possible injury. In other\r\nwords, the court, on exercise of the power of granting ad interim injunction,\r\nis to preserve the subject matter of the suit in the status quo for the time\r\nbeing. It is settled </span></u><u><span style=\"font-size:14.0pt;line-height:\r\n150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\"Times New Roman\";\r\nmso-fareast-language:EN-GB;mso-no-proof:yes\"><!--[if gte vml 1]><v:shape id=\"Picture_x0020_1\"\r\n o:spid=\"_x0000_i1026\" type=\"#_x0000_t75\" style=\'width:26.25pt;height:10.5pt;\r\n visibility:visible;mso-wrap-style:square\'>\r\n <v:imagedata src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image004.png\"\r\n  o:title=\"\"/>\r\n</v:shape><![endif]--><!--[if !vml]--><img width=\"35\" height=\"14\" src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image004.png\" v:shapes=\"Picture_x0020_1\"><!--[endif]--></span></u><u><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">law that the grant of injunction is a discretionary relief. The\r\nexercise thereof is subject to the court satisfying that (1) there is a serious\r\ndisputed question to be tried in the suit and that an act, on the facts before\r\nthe court, there is probability of his being entitled to the relief asked for\r\nby the plaintiff/defendant; (2) the court’s interference is necessary to\r\nprotect the party from the species of injury. In other words, irreparable\r\ninjury or damage would ensue before the legal right would be established at\r\ntrial; and (3) that the comparative hardship or mischief or inconvenience which\r\nis likely to occur from withholding the injunction will be greater than that\r\nwould be likely to arise from granting it.</span></u><u><span style=\"font-size:\r\n14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></u></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\n\"Times New Roman\"\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">5.</span></b><span style=\"font-size:14.0pt;line-height:150%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">\r\nTherefore, the burden is on the plaintiff by evidence aliunde by affidavit or\r\notherwise that there is “a prima facie case” in his favour which needs\r\nadjudication at the trial. The existence of the prima facie right and\r\ninfraction of the enjoyment of his property or the right is a condition for the\r\ngrant of temporary injunction. Prima facie case is not to be confused with\r\nprima facie title which has to be established, on evidence at the trial. Only\r\nprima facie case is a substantial question raised, bona fide, which needs\r\ninvestigation and a decision on merits. Satisfaction that there is a prima\r\nfacie case by itself is not sufficient to grant injunction. The Court further\r\nhas to satisfy that non-interference by the Court would result in “irreparable\r\ninjury” to the party seeking relief and that there is no other remedy available\r\nto the party except one to grant injunction and he needs protection from the\r\nconsequences of apprehended injury or dispossession. Irreparable injury,\r\nhowever, does not mean that there must be no physical possibility of repairing\r\nthe injury, but means only that the injury must be a material one, namely one\r\nthat cannot be adequately compensated by way of damages. The third condition\r\nalso is that “the balance of convenience” must be in favour of granting\r\ninjunction. The Court while granting or refusing to grant injunction should\r\nexercise sound judicial discretion to find the amount of substantial mischief\r\nor injury which is likely to be caused to the parties, if the injunction is\r\nrefused and compare it with that which is likely to be caused to the other side\r\nif the injunction is granted. If on weighing competing possibilities or probabilities\r\nof likelihood of injury and if the Court considers that pending the suit, the\r\nsubject matter should be maintained in status quo, an injunction would be\r\nissued. Thus the Court has to exercise its sound judicial discretion in\r\ngranting or refusing the relief of ad interim injunction pending the suit.</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;text-indent:18.0pt;\r\nline-height:150%;mso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana\">6.</span></b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\"> Undoubtedly, in a suit seeking to set aside the decree, the subject\r\nmatter in the earlier suit, though became final, the Court would in an\r\nappropriate case grant ad interim injunction when the party seeks to set aside\r\nthe decree on the ground of fraud pleaded in the suit or for want of </span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\";mso-fareast-language:EN-GB;mso-no-proof:\r\nyes\"><!--[if gte vml 1]><v:shape id=\"Picture_x0020_3\" o:spid=\"_x0000_i1025\"\r\n type=\"#_x0000_t75\" style=\'width:26.25pt;height:10.5pt;visibility:visible;\r\n mso-wrap-style:square\'>\r\n <v:imagedata src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image005.png\"\r\n  o:title=\"\"/>\r\n</v:shape><![endif]--><!--[if !vml]--><img width=\"35\" height=\"14\" src=\"file:///C:\\Users\\Nitin\\AppData\\Local\\Temp\\msohtmlclip1\\01\\clip_image005.png\" v:shapes=\"Picture_x0020_3\"><!--[endif]--></span><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">jurisdiction in the Court which passed the decree. But the Court would\r\nbe circumspect before granting the injunction and look to the conduct of the\r\nparty, the probable injuries to either party and whether the plaintiff could be\r\nadequately compensated if injunction is refused. This case demonstrates (we are\r\nnot expressing any opinion on the plea of fraud or their relative merits in the\r\ncase or the validity of the decree impugned), suffice to state that the conduct\r\nof the respondent militates against the bona fides. At present there is a sale\r\ndeed executed by the Court in favour of the first appellant. If ultimately the\r\nrespondent succeeds at the trial, they can be adequately compensated by\r\nawarding damages for use and occupation from the date of dispossession till\r\ndate of restitution. Repeatedly the civil court and the High Court refused\r\ninjunction pending proceedings. For any acts of damage, if attempted to be\r\nmade, to the property, or done, appropriate direction could be taken in the\r\nsuit. If any alienation is made it would be subject to doctrine of lis pendens\r\nunder Section 52 of the Transfer of Property Act. The High Court without\r\nadverting to any of these material circumstances held that balance of\r\nconvenience lies in favour of granting injunction with the following\r\nobservations, “keeping in mind the history, various facts which have been\r\nbrought to my notice, and looking to the balance of convenience and irreparable\r\nloss, I think it will be in the interests of justice to allow these appeals and\r\ngrant temporary injunction that the appellants may not be dispossessed from the\r\nsuit property”. The phrases “prima facie case”, “balance of convenience” and\r\n“irreparable loss” are not rhetoric phrases for incantation, but words of width\r\nand elasticity, to meet myriad situations presented by men’s ingenuity in given\r\nfacts and circumstances, but always is hedged with sound exercise of judicial\r\ndiscretion to meet the ends of justice. The facts are eloquent and speak for\r\nthemselves. It is well nigh impossible to find from facts prima facie case and\r\nbalance of convenience. The respondents can be adequately compensated on their\r\nsuccess.</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:2.0pt;margin-right:0cm;margin-bottom:0cm;\r\nmargin-left:0cm;margin-bottom:.0001pt;text-align:justify;text-indent:18.0pt;\r\nline-height:150%;mso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana\">7.</span></b><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\"> In our considered view, the High Court committed manifest error of\r\nlaw in jumping to the above conclusion to allow the appeal. This appeal is,\r\naccordingly, allowed. The order of the High Court is set aside and that of the\r\ntrial court is confirmed. It is made clear that any observations made either by\r\nthe trial court or the High Court or of this Court should be taken to be not\r\nrelevant at the trial on merits. These are our only prima facie observations,\r\nsubject to adduction of evidence and proof at the trial on merits in the suit.\r\nThe parties are directed to bear their own costs.</span><span style=\"font-size:\r\n14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:3.6pt;margin-right:0cm;margin-bottom:6.0pt;\r\nmargin-left:0cm;text-align:justify;line-height:150%;mso-layout-grid-align:none;\r\ntext-autospace:none\"><span style=\"font-size:14.0pt;line-height:150%;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana\">———</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-top:5.0pt;margin-right:0cm;margin-bottom:5.0pt;\r\nmargin-left:36.0pt;text-align:justify;text-indent:-36.0pt;line-height:150%;\r\nmso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">†</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\"Times New Roman\"\">       </span><span style=\"font-size:14.0pt;\r\nline-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:\r\nVerdana\">From the Judgment and Order dated Feb. 26, 1991 of the Rajasthan High\r\nCourt in S.B. Civil Misc. Appeal Nos. 498 and 501 of 1990</span><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:\"Times New Roman\"\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;line-height:150%\"><span style=\"font-size:14.0pt;line-height:150%;font-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p> </o:p></span></p>', '7f42faec5da1618d42ed3beb05a25e6e.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-11-30 23:27:16', '2021-08-21 00:18:43');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(8, 'FAvEd3KveD4T929UOTWBrJ6wa', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Contract Act.  Power of Attorney can be revoked by the principal unless the agent’s authority is coupled with interest. Supreme Court. ', '<p class=\"MsoNormal\" align=\"center\" style=\"margin-right:21.6pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span lang=\"EN-US\" style=\"font-size:22.0pt;mso-bidi-font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-right:21.6pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size: 14pt; font-family: \"Adobe Gothic Std B\", sans-serif;\">                                                                                                                                Daksha Legal </span><b><span lang=\"EN-US\" style=\"font-size:22.0pt;mso-bidi-font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-right:21.6pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span lang=\"EN-US\" style=\"font-size:22.0pt;mso-bidi-font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\"\">IN THE SUPREME COURT OF INDIA<o:p></o:p></span></b></p>\r\n\r\n<h1 style=\"margin-right:14.4pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><span style=\"font-size:13.0pt;\r\nmso-bidi-font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">(BEFORE Justice K.\r\nJAGANNATHA SHETTY AND Justice A.M. AHMADI,<br></span></b><u><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\"><b>Civil Appeal No. 4177 of 1989 decided on October 5,\r\n1989</b></span></u></h1>\r\n\r\n\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:0cm;margin-right:14.4pt;\r\nmargin-bottom:0cm;margin-left:14.4pt;margin-bottom:.0001pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n\r\n<table class=\"MsoTableGrid\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: none;\">\r\n <tbody><tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">SOUTHERN ROADWAYS LTD.,\r\n  MADURAI,  REPRESENTED BY ITS SECRETARY<o:p></o:p></span></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border:solid windowtext 1.0pt;\r\n  border-left:none;mso-border-left-alt:solid windowtext .5pt;mso-border-alt:\r\n  solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-top:0cm;margin-right:180.0pt;margin-bottom:\r\n  0cm;margin-left:18.0pt;margin-bottom:.0001pt;text-indent:-18.0pt;mso-layout-grid-align:\r\n  none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">Appellant;</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n  <p class=\"MsoNormal\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  border-top:none;mso-border-top-alt:solid windowtext .5pt;mso-border-alt:solid windowtext .5pt;\r\n  padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\"><i><span style=\"font-size:14.0pt;font-family:\r\n  \"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;mso-ansi-language:\r\n  EN-GB\">Versus <o:p></o:p></span></i></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;\r\n  mso-border-top-alt:solid windowtext .5pt;mso-border-left-alt:solid windowtext .5pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\" style=\"margin-top:0cm;margin-right:180.0pt;margin-bottom:\r\n  0cm;margin-left:18.0pt;margin-bottom:.0001pt;text-indent:-18.0pt;mso-layout-grid-align:\r\n  none;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td width=\"294\" valign=\"top\" style=\"width:220.5pt;border:solid windowtext 1.0pt;\r\n  border-top:none;mso-border-top-alt:solid windowtext .5pt;mso-border-alt:solid windowtext .5pt;\r\n  padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">S.M. KRISHNAN<o:p></o:p></span></p>\r\n  </td>\r\n  <td width=\"344\" valign=\"top\" style=\"width:258.3pt;border-top:none;border-left:\r\n  none;border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;\r\n  mso-border-top-alt:solid windowtext .5pt;mso-border-left-alt:solid windowtext .5pt;\r\n  mso-border-alt:solid windowtext .5pt;padding:0cm 5.4pt 0cm 5.4pt\">\r\n  <p class=\"MsoNormal\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\n  mso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">Respondent.<o:p></o:p></span></p>\r\n  </td>\r\n </tr>\r\n</tbody></table>\r\n\r\n<p class=\"MsoNormal\" align=\"center\" style=\"margin-top:0cm;margin-right:14.4pt;\r\nmargin-bottom:0cm;margin-left:14.4pt;margin-bottom:.0001pt;text-align:center;\r\nmso-layout-grid-align:none;text-autospace:none\"><b><i><span lang=\"EN-US\" style=\"font-size:24.0pt;mso-bidi-font-size:10.0pt\">(1989) 4 SCC 603</span></i></b><b><span style=\"font-size:28.0pt;mso-bidi-font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;line-height:200%;mso-layout-grid-align:\r\nnone;text-autospace:none\"><b><span style=\"font-size:14.0pt;line-height:200%;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">K. JAGANNATHA SHETTY, J.</span></b><span style=\"font-size:14.0pt;line-height:200%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">— Special leave granted.</span><span style=\"font-size:14.0pt;line-height:200%;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">2.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The question raised in\r\nthis appeal is whether the agent after revocation of his authority is entitled\r\nto remain in possession of the premises of the principal and interfere with the\r\nbusiness thereof. The learned Single Judge of the Madras High Court in Original\r\nSuit CS No. 1317 of 1988 has granted temporary injunction restraining the\r\nrespondent from interfering with the appellant’s transport business. But the\r\nDivision Bench by judgment delivered on 28-3-1989, vacated that temporary injunction.\r\nThe present appeal is directed against the judgment of the Division Bench.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">3.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The facts are\r\nsubstantially undisputed. The appellant Company under the name as Southern\r\nRoadways Ltd. is engaged in the business of transport of goods and parcels to\r\ndifferent places in Southern India. It has appointed commission agents at\r\nvarious stations for the purpose of carrying on its business. S.M. Krishnan\r\nrespondent was one such agent appointed at Madras city. Clause III of the\r\nagreement by which he was appointed provides that the respondent should arrange\r\na suitable godown and engage employees. Clause XI provides for his removal from\r\nservice at any time without notice. It also provides that upon removal of the\r\nagent the company could occupy the godown. The company could also utilise the\r\nservices of employees engaged by the respondent. As per the agreement perhaps\r\nat the suggestion of the respondent, the company took on lease a godown at No.\r\n10, Srinivasan Road, T. Nagar, Madras. The godown was put in possession of the\r\nrespondent for the purpose of carrying on his agency business of the company.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">4.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> In the course of the\r\ncompany’s audit, it was discovered that the respondent had mismanaged the\r\nbusiness and misappropriated the income of the company. By letter dated 13-10-1988,\r\nthe company terminated his agency with effect from 14-10-1988. He was informed\r\nthat the company would be taking possession of the godown and carrying on the\r\nbusiness on its own. By subsequent letter, he was also intimated that the\r\ncompany has taken possession of the godown on 15-10-1988 and another agent\r\ncalled R. Sundarajan was appointed in his place. The respondent however,\r\nprevented R. Sundarajan and also the company from carrying on business at the\r\ngodown premises. The company, therefore, had to institute a suit for\r\ndeclaration of its right to carry on business in the said premises. Permanent\r\ninjunction restraining the respondent from interfering was also sought for. The\r\nsuit was based on two separate grounds. The first related to legal right of the\r\ncompany to carry on its business after termination of agency of the respondent;\r\nthe second concerned the factum of taking actual possession of the premises on\r\n15-10-1988.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">5.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> Pending suit, the\r\ncompany moved the High Court for temporary injunction. The temporary injunction\r\nwas for restraining the respondent from interfering with the possession of the\r\npremises and the business thereof. The learned Single Judge (M. Srinivasan, J.)\r\nacceded to that request. The Judge said:</span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“As pointed out already, in this case, there is no\r\ndenial of the lease arrangement between the owner of the premises and the\r\nplaintiff. The defendant does not claim to be the owner of the premises nor\r\ndoes he put forward any rival title as against the plaintiff. The only claim of\r\nthe defendant is that he is in possession and that he has been paying the rent\r\nto the owner. He does not claim that he took possession as a lessee from the\r\nowner. Though there is a specific averment in the plaint and the affidavit of\r\nthe plaintiff that there is a lease arrangement between the plaintiff and the\r\nowner, there is no denial of the same by the defendant. In these circumstances,\r\nthe defendant cannot claim that he is in possession pursuant to any right\r\nenured in him.”</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;text-indent:18.0pt;mso-layout-grid-align:\r\nnone;text-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">6.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> As to the possession of\r\nthe premises, he said:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;mso-layout-grid-align:\r\nnone;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">The claim made by the\r\nplaintiff that it took possession on 15-1-1988 is acceptable in view of the\r\nfact that the defendant was never the lessee under the owner of the premises.\r\nThe defendant was only looking after the business as an agent of the plaintiff\r\nand as such he was permitted to enter the premises and he cannot claim\r\nindependent possession.”</span><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">7.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> Finally, he concluded:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;mso-layout-grid-align:\r\nnone;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">“In the circumstances of\r\nthe case, there can be no doubt that the plaintiff has been in legal and actual\r\npossession of the premises on the date of suit. The fact that the business has\r\nbeen temporarily shifted to another place in view of the threat meted out to\r\nthe plaintiff’s agent will not disentitle the plaintiff to get injunction. The\r\nplaintiff is certainly entitled to carry on its business at No. 10, Srinivasan\r\nRoad, T. Nagar, Madras-600 017, having taken the premises on lease. It is not\r\nopen to the defendant to prevent the plaintiff from carrying on such business.”</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">8.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The respondent was thus\r\nrestrained by means of temporary injunction from interfering with the company’s\r\ntransport business in goods and parcels at the suit premises.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">9.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The respondent took up\r\nthe matter in appeal before the Division Bench of the High Court. The Division\r\nBench consisting of Sathidev and Padmini Jesudurai, JJ., accepted the appeal\r\nand vacated the temporary injunction. The conclusion of learned Judges is\r\nlargely based on the actual possession of the premises claimed by the company.\r\nThey found it hard to accept that claim and observed:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“The plaintiff will not be entitled to the relief\r\nsought for unless it establishes that its claim that possession of the property\r\nwas handed over to it on 15-10-1984 is true. The defendant has consistently\r\nbeen contending that possession was not handed over to the plaintiff on\r\n15-10-1984 and that he continues to be in actual and physical possession of the\r\nproperty even now. No material has been placed before the court to substantiate\r\nthe claim of the plaintiff that possession was taken over on 15-10-1984.”</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">10.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> They continued:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“In the face of these documents and in the absence of\r\nany material to show that possession of the suit property was taken by the\r\nplaintiff on 15-10-1988, it would be impossible for this. Court to grant the\r\nplaintiff, the relief of injunction.”</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">As to the company’s right\r\nto treat the respondent as trespasser, the Division Bench observed:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“Before the defendant could be characterised as a\r\ntrespasser, the validity of the termination of the agency and the rights of the\r\nparties, following that, have also to be determined and this could be done only\r\nduring trial.”</span><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">11.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> At the outset, we may\r\nstate that we are not so much concerned with the rival claims relating to\r\nactual possession of the suit premises. Indeed, that is quite irrelevant for\r\nthe purpose of determining the rights of the company to carry on its business.\r\nMr Venugopal, learned counsel for the appellant also discreetly did not advert\r\nto that controversy. He, however, rested his case on certain facts which are\r\nproved or agreed. They may be stated as follows:</span><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“The company was and is the tenant of the suit\r\npremises and has been paying rent to the owner. The lease in respect of the\r\npremises has been renewed up to 22-11-1993. It was the company which has\r\nexecuted the lease and not the respondent. The respondent as agent was allowed\r\nto remain in possession of the premises. It was only for the purpose of\r\ncarrying on company’s business. His agency has been terminated and his\r\nauthority to act for the company has been put an end to. These facts are indeed\r\nnot disputed. On these facts the contention of counsel is that when the agency\r\nhas been terminated, the respondent has no legal right to remain in the\r\npremises or to interfere with the business activities of the company.”</span><span style=\"font-family: \"Adobe Gothic Std B\", sans-serif; font-size: 14pt;\"> </span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">12.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The force of this\r\nargument cannot be gainsaid. Counsel, in our opinion, appears to be on terra\r\nfirma. The principal has right to carry on business as usual after the removal\r\nof his agent. The courts are rarely willing to imply a term fettering such\r\nfreedom of the principal unless there is some agreement to the contrary. The\r\nagreement between the parties in this case does not confer right on the\r\nrespondent to continue in possession of the suit premises even after\r\ntermination of agency. Nor does it preserve right for him to interfere with the\r\ncompany’s business. On the contrary, it provides that the respondent could be\r\nremoved at any time without notice and after removal the company could carry on\r\nits business as usual. The company under the terms of the agreement is,\r\ntherefore, entitled to assert and exercise its right which cannot be disputed\r\nor denied by the respondent.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><u><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB;mso-bidi-font-weight:bold\">13.</span></u><u><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> Even otherwise, under\r\nlaw revocation of agency by the principal immediately terminates the agent’s\r\nactual authority to act for the principal unless the agent’s authority is\r\ncoupled with an interest as envisaged under Section 202 of the Indian Contract\r\nAct. When agency is revoked, the agent could claim compensation if his case\r\nfalls under Section 205 or could exercise a lien on the principal’s property\r\nunder Section 221. The agent’s lien on principal’s property recognised under\r\nSection 221 could be exercised only when there is no agreement inconsistent\r\nwith the lien. In the present case the terms of the agreement by which the\r\nrespondent was appointed as agent, expressly authorises the company to occupy\r\nthe godown upon revocation of agency. Secondly, the lien in any event, in our\r\nopinion, cannot be utilised or taken advantage of to interfere with principal’s\r\nbusiness activities.</span></u></b><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">14.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> There is yet another\r\nsignificant factor to be borne in mind when we deal with the rights of an\r\nagent. An agent who receives property or money from or for his principal\r\nobtains no interest for himself in the property. When he receives any such\r\nproperty he is bound to keep it separate from his own and that of others. Long\r\nago, Lord Cottenham, L.C. in <i>Foley</i> v. <i>Hill</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">1</span></u> said:</span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“... So it is with regard to an agent dealing with\r\nproperty; he obtains no interest himself in the subject-matter beyond his\r\nremuneration; he is dealing throughout for another, and though he is not a\r\ntrustee according to the strict technical meaning of the word, he is quasi a\r\ntrustee for that particular transaction for which he is engaged.”</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">15.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> Out of this practice\r\nthere has emerged a rule, which is a normal incident of agency, that an agent\r\ncannot deny principal’s title to property nor he can convert it into any other\r\nkind or use. Fridman’s <i>Law of Agency</i> (5th Edn., p. 150) also supports\r\nthis view:</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“<i>Respect of principal’s title</i>: The agent cannot\r\ndeny the title of the principal to goods, money, or land possessed by the agent\r\non behalf of the principal. The possession of the agent is the possession of\r\nthe principal for all purposes, including the acquisition of title under\r\nstatutes of limitation, even where in fact the agent, though in ignorance of\r\nhis claim, is entitled to the land, unless the agent possesses not as agent but\r\non his own behalf, in which event his possession will be personal and not for\r\nhis principal.”</span><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">16.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> As to the nature of\r\nagent’s possession in respect of principal’s property, this Court in a recent\r\njudgment rendered in <i>Chandrakantaben</i> v. <i>Vadilal Bapalal Modi</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">2</span></u> said: (SCC pp. 643-44, para 19)</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“It is well settled that the possession of the agent\r\nis the possession of the principal and in view of the fiduciary relationship\r\nDefendant 1 cannot be permitted to claim his own possession. This aspect was\r\nwell emphasised in <i>David Lyell</i> v. <i>John Lawson Kennedy</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">3</span></u> where the agent who was collecting the rent\r\nfrom the tenants on behalf of the owner and depositing it in a separate earmarked\r\naccount continued to do so even after the death of the owner. After more than\r\n12 years of the owner’s death his heir’s assignee brought the action against\r\nthe agent for possession and the agent defendant pleaded adverse possession and\r\nlimitation. The plaintiff succeeded in the first court. But the action was\r\ndismissed by the Court of Appeal. The House of Lords reversed the decision of\r\nthe Court of Appeal and remarked: “For whom, and on whose behalf, were those\r\nrents received after Ann Duncan’s death? Not by the respondent for himself, or\r\non his own behalf, any more than during her lifetime.” Emphasising the\r\nfiduciary character of the agent his possession was likened to that of trustee,\r\na solicitor or an agent receiving the rent under a power of attorney. Another\r\nEnglish case of <i>Williams</i> v. <i>Pott</i><u><span style=\"position:relative;\r\ntop:-3.0pt;mso-text-raise:3.0pt\">4</span></u> arising out of the circumstances similar to\r\nthe present case was more interesting. The agent in that case was the real\r\nowner of the estate but he collected the rents for a considerably long period\r\nas the agent of his principal who was his mother. After the agent’s death his\r\nheir claimed the estate. The mother (the principal) had also by then died after\r\npurporting by her will to devise the disputed lands to the defendants upon\r\ncertain trusts. The claim of the plaintiff was dismissed on the plea of adverse\r\npossession. Lord Romilly, M.R., in his judgment observed that since the\r\npossession of the agent was the possession of the principal, the agent could\r\nnot have made an entry as long as he was in the position of the agent for his\r\nmother, and that he could not get into possession without first resigning his\r\nposition as her agent which he could have done by saying: “The property is\r\nmine; I claim the rents, and I shall apply the rents for my own purposes.” The\r\nagent had thus lost his title by reason of his own possession as agent of the\r\nprincipal.”</span><span style=\"font-family: \"Adobe Gothic Std B\", sans-serif; font-size: 14pt; text-indent: 18pt;\"> </span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">17.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> We wish to add that it\r\nis not every agent who is in a fiduciary position vis-</span><span style=\"font-size:14.0pt;font-family:\"MS Gothic\";mso-bidi-font-family:\"MS Gothic\";\r\nmso-ansi-language:EN-GB\">à</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;mso-ansi-language:\r\nEN-GB\">-vis his principal. For example if <i>A</i> appoints <i>B</i> to be his\r\nagent merely to sign a memorandum and places no particular trust in <i>B</i>,\r\nthe doctrine of fiduciary relations would not apply. Likewise, where the\r\nprincipal authorises an agent to do particular or specified acts, the doctrine\r\nof fiduciary relation may not arise. What we want to emphasise is, in all cases\r\nof general agency, the relation may be generally fiduciary, but in other kinds\r\nof agencies, the relation may vary with the confidence which the principal\r\nchooses to repose in the agent. It may also depend upon the power which the\r\nagent exercises over the subject-matter under the terms of the contract of\r\nagency or by virtue of the incident of law and usage of the business which the\r\nrelationship implies. Thus the fiduciary element in agency, though the key to\r\nmuch of the law governing this relation, is not the essential element in the\r\nrelation.<u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">5</span></u></span><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"><o:p> </o:p></span></b></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">18.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The crux of the matter\r\nis that an agent holds the principal’s property only on behalf of the\r\nprincipal. He acquires no interest for himself in such property. He cannot deny\r\nprincipal’s title to property. Nor he can convert it into any other kind or\r\nuse. His possession is the possession of the principal for all purposes. As the\r\nKerala High Court in <i>Narayani Amma</i> v. <i>Bhaskaran Pillai</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">6</span></u> observed: (AIR p. 217, para 6)</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:18.0pt;text-align:justify;text-indent:\r\n18.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">“The agent has no possession of his own. What is\r\ncalled a caretaker’s possession is the possession of the principal.”</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;text-indent:18.0pt;mso-layout-grid-align:\r\nnone;text-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">19.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> So much is, we think,\r\nestablished law as regards agent’s right to property belonging to the\r\nprincipal. Dr. Chitale, learned counsel for the respondent, however, cited in\r\nthis context, two decisions: (<i>i</i>) <i>Abdul Nabi Sahib</i> v. <i>Bajan\r\nSahib</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">7</span></u> and (<i>ii</i>) <i>Jemma</i> v. <i>Raghu</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:3.0pt\">8</span></u>. In the\r\nformer case of the Madras High Court, the suit was for a permanent injunction\r\nrestraining the defendant from interfering with the plaintiff’s peaceful\r\npossession and enjoyment of the suit properties and performance of the\r\nreligious services. The defendant admitted that he was agent of the plaintiff\r\nbut set up title to the property in himself as donee. He has also set up title\r\nby adverse possession. On these claims, Kunhi Raman, J., observed:</span><span style=\"font-family: \"Adobe Gothic Std B\", sans-serif; font-size: 14pt; text-indent: 18pt;\"> </span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> “Since the plaintiff had not got possession of\r\nthe property, it would not be sufficient to show that he was in constructive\r\npossession and the theory of constructive possession as between the principal\r\nand agent, cannot be relied upon by the principal for the purpose of meeting\r\nthe contention of the description raised on behalf of the defendant, who is the\r\nagent.”</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">20.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> If the defendant in the\r\nabove case, has admitted that he was the agent of the plaintiff and yet set up\r\ntitle to the property of his principal, the above observation may not be\r\nconsistent with the settled principle of law. We have already stated that the\r\nagent acquires no interest in the property of the principal and he cannot,\r\ntherefore, non-suit the principal on the possessory title as agent.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">21.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> The second case in <i>Jemma</i>\r\nv. <i>Raghu</i><u><span style=\"position:relative;top:-3.0pt;mso-text-raise:\r\n3.0pt\">8</span></u> referred to us is the\r\ndecision of the Orissa High Court. That case dealt with the general principle\r\nthat the plaintiff who is not in possession of the suit premises is not\r\nentitled to relief of injunction. The plaintiff must ask for recovery of\r\npossession. But this principle has no application with regard to dispute\r\nbetween the principal and agent in respect of principal’s property.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">22.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> In this case, the\r\nrespondent’s possession of the suit premises was on behalf of the company and\r\nnot on his own right. It is, therefore, unnecessary for the company to file a\r\nsuit for recovery of possession. The respondent has no right to remain in\r\npossession of the suit premises after termination of his agency. He has also no\r\nright to interfere with the company’s business. The case, therefore, deserves\r\nthe grant of temporary injunction. The learned Single Judge of the High Court\r\nin our judgment, was justified in issuing the injunction. The Division Bench of\r\nthe High Court was clearly in error in vacating it.</span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\">23.</span></b><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-bidi-font-family:Verdana;mso-ansi-language:EN-GB\"> In the result, we allow\r\nthe appeal with costs. In reversal of the order of the Division Bench, we\r\nrestore the temporary injunction granted by learned Single Judge of the High\r\nCourt.</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;text-indent:18.0pt;mso-layout-grid-align:\r\nnone;text-autospace:none\"><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">1</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">2 HLC 28 : 1843-60 All ER (Rep) 16, 19</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">2</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">(1989) 2 SCC 630</span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">3</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">(1889) 14 HL (E) 437</span><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">4</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">LR 12 Eq Cas 149</span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">5</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">See 17 <i>Modern Law Review</i> 31-32</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">6</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">AIR 1969 Ker 214 : 1968 Ker LJ 738</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">7</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">AIR 1944 Mad 221 : (1944) 1 MLJ 87</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">8</span><span style=\"font-size:14.0pt;font-family:\r\n\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\">         </span><span style=\"font-size:14.0pt;\r\nfont-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-bidi-font-family:Verdana;\r\nmso-ansi-language:EN-GB\">AIR 1977 Ori 12 : 42 Cut LT 940</span><span style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";\r\nmso-ansi-language:EN-GB\"><o:p></o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"margin-left:36.0pt;text-align:justify;text-indent:\r\n-36.0pt;mso-layout-grid-align:none;text-autospace:none\"><span style=\"font-size:\r\n14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\";mso-ansi-language:EN-GB\"><o:p> </o:p></span></p>\r\n\r\n<p class=\"MsoNormal\" style=\"text-align:justify;mso-layout-grid-align:none;\r\ntext-autospace:none\"><span lang=\"EN-US\" style=\"font-size:14.0pt;font-family:\"Adobe Gothic Std B\",\"sans-serif\"\"><o:p> </o:p></span></p>', 'fb4ef8ed28befdfc52b62b0f1742755a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '1989-10-05', 1, '', '', '2020-11-30 23:37:24', '2021-02-17 17:50:34');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(287, 'vsZyQ36neQftvdXwHVLMimzX0', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court deprecates the conduct of National Law School of India University for its discriminatory enforcement of minimum attendance rule. Directs promotion of the student.', '<p><b>“Affidavit borders perjury”. Karnataka High Court deprecates the conduct of National Law School of India University for its discriminatory enforcement of minimum attendance rule. Directs promotion of the student.<br>Dayan Warsi vs The Vice Chancellor NLSIU and another. Writ Petition 9749/2020 decided on 18 December 2020.<br><br>Judgment Link: <br><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/354337/1/WP9749-20-18-12-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/354337/1/WP9749-20-18-12-2020.pdf<br></a><br>Relevant paragraphs: <br></b><br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">II (b)…the subject Regulations which wear both a right situation- reason and a clear scope-criterion on their face yield reckon ability and justice; one has to bear&nbsp; in&nbsp; mind&nbsp; that&nbsp; what is being construed are the Campus&nbsp; Regulations&nbsp; and not the Cattle Trespass Act; true it is that, law speaks through language and not music; the rules which are promulgated to regulate &amp; discipline the young minds in educational institutions&nbsp; should&nbsp; sing&nbsp; justice;&nbsp; this&nbsp; happens if a purposive construction&nbsp; based&nbsp; on&nbsp; language,&nbsp; purpose and discretion, is placed on these Regulations that admit a range of possibilities; they also vest some discretion since their purpose does not point to a single, unique legal meaning regardless of myriad circumstances; respondents ought to have used discretion to formulate, as objectively as possible, the purpose at the core of the legal text;&nbsp; however, they have been unjustifiably swayed away by the Rule of Textualism, to the prejudice of the poor student.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">Regulation II (5) &amp; (6) provide for condonation of shortage of attendance on non-medical grounds upto a maximum of 20% of the total classes conducted; the condonable range of attendance shortage on medical grounds between 75% &amp; 67% is less than 20% of the total classes; the extent of condonable shortage cannot differ depending upon the varying grounds availing therefor; in other words, if a maximum condonable shortage of 20% on non-medical grounds does not compromise educational excellence, the same shortage on medical grounds too logically does not; if that be so, a&nbsp; Regulation&nbsp; prescribing less than 20%&nbsp; as the condonable limit of shortage cannot&nbsp; be treated as mandatory; it hardly needs to be stated that petitioner’s shortage of attendance by simple arithmetic works out to be far below the maximum condonable extent.</span></div><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">III (a) The precedents &amp; practice of the University show that the subject Regulations have been treated only as directory, and not mandatory; pursuant&nbsp; to&nbsp; Court’s&nbsp; direction dated 11.11.2020, the Registrar of the University has filed an affidavit admitting that in a case of one particular student, condonation has been&nbsp; granted&nbsp; even when the he had less than prescribed minimum of 67% attendance; in a serious matter like this&nbsp; involving&nbsp; the career of a student, the argument of the kind that “one sparrow makes not the summer” (Shakespeare’s) would not come to the rescue of respondents; it is more so when it is not their case that this condonation was legally&nbsp; inadmissible; for&nbsp; the same reason,&nbsp; the principle that there&nbsp; is no estoppel against law, is not invocable.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">It is noteworthy that this assertion of the petitioner on oath is not disputed by the respondents nor they have produced any record to discount its veracity; in fact, the affidavit filed on behalf of the&nbsp; respondents&nbsp; arguably borders perjury, since information relating to condonation of attendance in respect of above three more students has been withheld from the Writ Court with no justification whatsoever despite a specific direction; ideally speaking the respondent law University ought to&nbsp; have&nbsp; stated about the fact in the very beginning&nbsp; when&nbsp; it&nbsp; had&nbsp; filed its Statement of Objections; this is unjust &amp; unfair, to say the least; however, it is not desirable that on this ground per se,&nbsp; &nbsp; &nbsp; the defence of the respondents be struck off.</span></div><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">V. As already mentioned above, in several cases the University had granted condonation of shortage of attendance under the very same Regulations; however,&nbsp; in the case of the petitioner, a step-motherly treatment is&nbsp; meted out to his detriment; this is not a happy thing to happen at the hands of the University which enjoys a great academic reputation in the country; the Apex Court in PRINCIPAL, KING GEORGE’S MEDICAL COLLEGE, “16. Whether&nbsp; the&nbsp; Regulations&nbsp; contained in the Ordinance governing admission to the post-graduate course of studies are mandatory or directory is a matter which the University shall have to consider after taking all relevant factors into account like the nature of the requirement, its purpose and the&nbsp; consequences of its relaxation on educational excellence.…One thing, however, must be made&nbsp; clear that&nbsp; &nbsp;if the University considers that any provision is not mandatory, its relaxation in&nbsp; particular cases has to be governed by objective considerations. No public authority, least of all a University which is entrusted with the future of the student community, can pick and choose persons for receiving the benefit of relaxation of the Regulations. In the first place, the rigour of a rule can be relaxed provided such relaxation is permissible under the Regulations or if the rule is directory and not mandatory. …”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">In the above circumstances, this Writ Petition succeeds; a Writ of Certiorari&nbsp; issues&nbsp; quashing&nbsp; the impugned endorsements dated 31.7.2020 &amp; 17.8.2020 respectively at Annexures-H &amp; M; a Writ of Mandamus issues directing the respondents to&nbsp; promote the petitioner&nbsp; to the 4th year B.A. LL.B (Hons) for the academic year 2020-21, forthwith.</span></div><i><br><b>Compiled by S. Basavaraj, Advocate, Daksha Legal.</b></i></p>', '994b2650c10361d9dcaff7bb9650e0d9.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-18', 1, '', '', '2020-12-23 02:28:05', '2020-12-28 17:02:33'),
(11, 'D1DdibNdsPIqpXQUXY4ciytCw', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '(2015) 7 SCC 178', '<span style=\"color: rgb(228, 230, 235); font-family: \"Segoe UI Historic\", \"Segoe UI\", Helvetica, Arial, sans-serif; font-size: 15px; white-space: pre-wrap; background-color: rgb(36, 37, 38);\">(2015) 7 SCC 178. Criminal Trial. Best evidence (CCTV footage) not produced. Adverse presumption drawn. Expert evidence not relied on. Acquittal ordered.</span>', 'cf3be0ab834211fb2030cfd603002415.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 19:07:20', '2020-12-22 20:20:23'),
(10, 'XZnCQgrfqLlxTEPzSIO8jgT9f', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Clarification regarding recent Government order dated 11 November 2021 on tuition fee in private educational institutions. ', '<h5><b>The recent Government Order dated 11 November 2021 has given raise to confusion mainly because of its bad reporting and incorrect interpretation. Hence this clarification.&nbsp;</b></h5><h5><b>The earlier Government Order dated 29 January 2021 directed the educational institutions to collect only 70% of the tuition fee for the academic year 2020-2021.&nbsp;</b></h5><h5><b>This Government Order was challenged before the Karnataka High Court by several educational institutions. In Writ Petition 4818 of 2021 all these issues were dealt with and the Hon\'ble Court delivered the judgment on 16 September 2021.&nbsp;</b></h5><h5><b>The Hon\'ble Court read down the Government Order dated 20 January 2021 and&nbsp; held as follows:&nbsp;</b></h5><h5><b><i>\"(i) The petitioner-Institution (school Management of the concerned private unaided school) shall collect annual school fees from their students as fixed under the Act of 1995 for the academic year 2019-20, but by providing deduction of 15 per cent&nbsp; on that amount in lieu of unutilised facilities by the students during the relevant period of academic year 2020-21.</i></b></h5><h5><b><i>(ii) Regardless of the above, it will be open to the petitioners (concerned schools) to give further concession to their students or to evolve a different pattern for giving concession over and above those noted in clause (i) above.</i></b></h5><h5><b><i>(iii) The school Management shall not debar any student from attending either online classes or physical classes on account of non-payment of fees, arrears/outstanding fees including the installments, referred to above, and shall not withhold the results of the examinations of any student on that account.</i></b></h5><h5><b><i>(iv) If any individual request is made by the parent/ward finding it difficult to remit annual fees for the academic year 2020-21 in the above terms, the school Management to consider such representation on case-to- case basis sympathetically.</i></b></h5><h5><b><i>(v) The above arrangement will not affect collection of fees for the academic year 2021-22, as is payable by the students of the concerned school as and when it becomes due and payable.</i></b></h5><h5><b><i>(vi) The school Management shall not withhold the name of any student/candidate for the ensuing Board examinations for Classes X and XII on the ground of non-payment of fee/arrears for the academic year 2020-21, if any, on obtaining undertaking of the concerned parents/students.\"</i></b></h5><h5><b>Please note the stress is on “Karnataka Education Act” meaning thereby the Government Order was issued under the said Act.</b></h5><h5><b>The inclusion of CBSE/ICSE educational institutions within the Karnataka Education Act is challenged before the Karnataka High Court in several Writ Petitions including WP 6185/2019 and connected cases. There is an interim order to the effect that the Government will not precipitate any action against CBSE and ICSE educational institutions during the pendency of the writ petitions.&nbsp;</b></h5><h5><b>The contention of the CBSE and ICSE educational institutions&nbsp; has been that the very GO dated 29 January 2021 did not apply to them having regard to the interim order dated 7 February 2019 which reads as hereunder;</b></h5><h5><b><i>\"In these petitions is challenged the Vires of Karnataka Second Amendment at 2017 whereby Section 124-A is introduced into the Karnataka Education Act 1983 bringing into the clasp of the act on the private unaided educational institutions for certain purposes. Petitioners also have laid a challenge to the vires of Section 48 of the act and further to the validity of 2018 Amendment Rules. The challenge is mainly founded on certain observations of the Constitution Bench of the Apex court in the TMA PAI Case [(2002) 8 SCC 481] and in the P.A Inamdar Case [(2005) 6 SCC 537] which apparently recognize the autonomy of these private educational institutions inter alia in respect of determination of their own fee structure, subject of course, to the rider of non-profiteering. After service of notice, the respondent&nbsp; &nbsp;State has entered appearance through the learned Additional Advocate General, Sri Ponnanna assisted by learned AGA Smt. Pramodhini Kishan. Sri Ponnanna presses into service prima-facie three points to resist grant of any interim relief to the petitioners following points: a) The provisions of the Amendment Act and the Amendment Rules impugned in these writ petitions do not operate proprio vigor and therefore, there is no choate cause of action as understood in the light of the decision of the Apex Court in the case of Kusum Ingots and Alloys vs. Union of India [(2004) 6 SCC 254] vide paragraph Nos. 6 and 26. b) Non-inclusion of these institutions within the ambit of the 1983 Act having been found unconstitutional by a learned Single Judge of this Court, the said judgment having been stayed by the Division Bench in Writ Appeal, the State has come up with this legislative measure inter alia to prevent profiteering. c) Every legislation is presumed to be constitutionally valid in view of decision of the Apex Court in Ramakrishna Dalmia vs. Sri. Justice S R Tendulkar [AIR 1958 SC 538], ordinarily writ courts do not stay the operation of the legislations, and the quasi legislations promulgated thereunder. Learned Senior Advocates, Sriyuths M.R.Nayak and S.Basavaraj together submit that the text of the Act coupled with the Rules made thereunder leave no manner of doubt as to they being effective proprio vigor inasmuch as they prescribe certain exercise to be accomplished by the institutions within the cut off date, i.e., filing of the Audit Reports/Registers before the concerned authorities. They further submit that the Assent granted by the President of India in exercise of power under Article 254(2) of the Constitution of India to overcome the repugnancy was conditional to the advantage of the private unaided educational Institutions and that this aspect has not been adverted to, while enacting the amendment and promulgating the Rules, that are now in challenge. The matter requires deeper consideration and both the sides have agreed that the matter may be taken up for final disposal on before long. The submission of Sri. M.R.Nayak, learned Senior Advocate appearing for the petitioners that if the State intends to file Objections, a copy thereof may be served on him in advance, is noted. The assurance of the learned Additional Advocate General that till the next date of hearing, no precipitatory or coercive action would be taken against the petitioner-Institutions is placed on record.&nbsp;</i></b></h5><h5><b>Hence, when the Government Order dated 29 January 2021 was issued under the Karnataka Education Act, there was already an interim order in Writ Petition 6185/2019 and hence the very GO was not applicable to CBSE/ICSE Schools who were before the Hon\'ble Court.&nbsp;</b></h5><h5><b>Now, the present Government Order dated 11 November 2021 simply reiterates the order of the Hon\'ble Karnataka High Court. Instead of 70% as mandated under the Government Order dated 29 January 2021, the present GO mandates collection of 85% tuition fee. Please note this GO is applicable only to the academic year 2020-2021 and does not apply to subsequent academic years.&nbsp;</b></h5><h5><b>However, the present GO says the educational institutions&nbsp; cannot collect even the other charges including voluntary charges. To this effect, the order is bad. However, if such amounts are already collected, there is no need to refund the amount as the GO does not say anything about refund of these amounts.&nbsp;</b></h5><h5><b>Please note that those schools who are not parties to the writ petition before the High Court in WP 6185/2019 are bound by the present GO. They are bound to collect only 85% tuition fee for the academic year 2020-2021. They are also bound to either refund excess fee or to adjust the same for the next academic year.&nbsp;</b></h5><h5><b>Please note that there is no Order to refund or adjust the amount paid under voluntary category or any amount other than tuition fee.&nbsp;</b></h5><h5><b><br></b></h5><h5><br></h5>', '68495e444e4f76af90ea34225f9be647.JPG', '254dc143dfcfb70649c1817e4c13b50a.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 18:27:25', '2021-11-14 18:10:34'),
(12, 'cmCDDA2lz3D0eLBPkCloCZGyy', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '(2015) 8 SCC 336.', '<span style=\"color: rgb(5, 5, 5); font-family: \"Segoe UI Historic\", \"Segoe UI\", Helvetica, Arial, sans-serif; font-size: 15px; white-space: pre-wrap; background-color: rgb(255, 255, 255);\">(2015) 8 SCC 336. Hindu Marriage Act. \"Cruelty\". Wife abusing husband, calling him son of a prostitute etc are not normal acts. Cruelty established. Divorce granted.</span><br>', '9555a3c49a863f761ca8ae8dfaa4f747.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 19:09:51', '2020-12-22 20:19:56'),
(13, '3FhPySCgYCWR296COI3wyYsit', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '(2015) 4 SCC 196', '<a class=\"oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 a8c37x1j p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl gmql0nx0 p8dawk7l\" href=\"https://www.facebook.com/groups/1004611326222954/permalink/1068501186500634/\" role=\"link\" tabindex=\"0\" style=\"color: inherit; cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; display: block; padding: 0px; margin: 0px; touch-action: manipulation; background-color: rgb(255, 255, 255); -webkit-tap-highlight-color: transparent; font-family: \"Segoe UI Historic\", \"Segoe UI\", Helvetica, Arial, sans-serif; font-size: 12px; animation-name: none !important; transition-property: none !important;\"><div class=\"rq0escxv l9j0dhe7 du4w35lb j83agx80 cbu4d94t pfnyh3mw\" style=\"flex-direction: column; z-index: 0; display: flex; position: relative; flex-shrink: 0; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><div class=\"rq0escxv l9j0dhe7 du4w35lb j83agx80 cbu4d94t buofh1pr tgvbjcpo\" style=\"flex-grow: 1; flex-direction: column; z-index: 0; display: flex; position: relative; min-height: 0px; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><div class=\"rq0escxv l9j0dhe7 du4w35lb j83agx80 cbu4d94t pfnyh3mw d2edcug0\" style=\"flex-direction: column; max-width: 100%; z-index: 0; display: flex; position: relative; flex-shrink: 0; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><div class=\"rq0escxv l9j0dhe7 du4w35lb j83agx80 pfnyh3mw i1fnvgqd gs1a9yip owycx6da btwxx1t3 jb3vyjys b5q2rw42 lq239pai mysgfdmx hddg9phg\" style=\"margin: -6px; flex-flow: row nowrap; z-index: 0; align-items: stretch; justify-content: space-between; display: flex; padding-top: 0px; position: relative; flex-shrink: 0; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><div class=\"rq0escxv l9j0dhe7 du4w35lb j83agx80 cbu4d94t g5gj957u d2edcug0 hpfvmrgz rj1gh0hx buofh1pr p8fzw8mz pcp91wgn iuny7tx3 ipjc6fyt\" style=\"flex: 1 1 0px; flex-direction: column; max-width: 100%; z-index: 0; min-width: 0px; padding: 6px; display: flex; position: relative; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><span class=\"d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 a8c37x1j keod5gw0 nxhoafnm aigsh9s9 d3f4x2em fe6kdd0r mau55g9w c8b282yb iv3no6db jq4qci2q a3bd9o3v knj5qynh oo9gr5id\" dir=\"auto\" style=\"line-height: 1.3333; display: block; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit; animation-name: none !important; transition-property: none !important;\"><span class=\"a8c37x1j ni8dbmo4 stjgntxs l9j0dhe7\" style=\"display: -webkit-box; position: relative; overflow: hidden; animation-name: none !important; transition-property: none !important; font-family: inherit; -webkit-box-orient: vertical; -webkit-line-clamp: 4;\">(2015) 4 SCC 196 -Decree challenged on the ground of fraud. Evidence required. When can a decree be set aside on the ground of fraud on Court. In this case fraud on court not established. <span style=\"animation-name: none !important; transition-property: none !important; font-family: inherit;\"><span class=\"rfua0xdk pmk7jnqg stjgntxs ni8dbmo4 ay7djpcl q45zohi1\" style=\"height: 1px; overflow: hidden; position: absolute; clip: rect(0px, 0px, 0px, 0px); width: 1px; animation-name: none !important; transition-property: none !important; font-family: inherit;\"> </span><span aria-hidden=\"true\" style=\"animation-name: none !important; transition-property: none !important; font-family: inherit;\">· </span></span></span></span></div></div></div></div></div></a>', '4671f732cddaa5c6c7c4c0259c02683a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 19:19:13', '2020-12-22 20:19:41'),
(14, 'uUKAOzfOGoPN1wp0eQ9cAWrot', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '(2015) 6 SCC 287', '<br>', '03e82dbf115491bfbd659488d86fdfb5.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 19:27:32', '2020-12-22 20:19:24'),
(15, 'kGFTxqA9tnjmJWmJbmtnEZ6cZ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Trial. Consideration for the issuance of a search warrant in order to search a smartphone or computer system. Explained by the Karnataka High Court. 12 March 2021', '<h4><span style=\"font-size: 15px;\">Criminal Trial. What is the consideration for the issuance of a search warrant in order to search a smartphone or computer system.? Explained by the Karnataka High Court. 12 March 2021. Please click the following link to read the post.&nbsp;<br></span><span style=\"font-size: 15px;\"><a href=\"https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0\" target=\"_blank\">https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0</a></span></h4>', '92ae0d30768c5b965366a2f753811562.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2020-12-01 19:33:32', '2021-03-14 17:52:22'),
(575, 'QNgz3arjcTojBR2QicVhyrurJ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Succession Act 1956. Karnataka amendment to Section 6 is applicable between 30:7:1994  to 8.9.2005. The Central amendment is applicable from 9:9:2005. Karnataka High Court.  15 May 2020', '<h4><b style=\"background-color: rgb(255, 255, 0);\">NOTE: </b>Though the questions raised and answered in this case refer to the Supreme Court judgment in Prakash vs Phulvathi, the position is NOT changed after the Supreme Court Judgment in Vineeta Sharma vs Rakesh Sharma  </h4><h4>Padmavathi and another vs Jayamma and others. </h4><h4>Regular First Appeal 916 of 2014 decided on 15 May 2020. </h4><h4>Justice B.V.Nagarathna and Justice Suraj Govindaraj. </h4><h4>Judgment Link: <a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/331256/1/RFA916-14-15-05-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/331256/1/RFA916-14-15-05-2020.pdf</a><br>Relevant paragraphs: <br>19. On the basis of the above, the points to be considered by this Court would be as under:</h4><h4 style=\"margin-left: 25px;\"><i>i) Whether the limitation period prescribed with respect to the filing of cross objection in terms of Order 41 Rule 22 of CPC is to be strictly construed, even when the cross objector had taken up the very same contention in the proceedings before the Trial Court?<br>ii) What is the nature of the Suit Schedule Properties, are they Joint Family Properties or individual properties of 1st Defendant?<br>iii) Whether the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid down in Prakash vs. Phulawati (supra) and 2005 amendment is prospective and would apply from 9.09.2005 ? <br>iv) Whether the Defendants have proved that there was a marriage solemnised between the 2nd Defendant – Jagadish Kumar and Manjula and 16th and 17th Defendants are their children?<br>v) Whether under Section 16 of the Hindu Marriage Act, illegitimate children are entitled to a share in ancestral or coparcenary property along with other legitimate heirs?<br>vi) What order?</i></h4><h4>42. The Apex Court in Banarasi vs. Ram Phal reported in [(2003) 9 SCC 606] has held that even as per amended Order XLII R 22(1) of the CPC, a party, in whose favour the decree stands in its entirety is neither entitled nor obliged to prefer any cross-objections. However, insertion made in the text of Sub-rule (1) makes it permissible to file a cross objection against a finding. The Apex Court further went on to hold that the respondent may defend himself without filing any cross objection to the extent to which the decree is in his favour. However, if he proposes to attack any part of the decree, he must make cross objection. Hence, the finding of the trial Court in respect of Schedule-A property being against the interest of the cross objectors, cross objectors are entitled to challenge the same by filing separate cross-objections. The Hon’ble Apex Court in Badru vs.  NTPC  Limited  [(2019)  SCC  online  SC 859] has also held that even if the appeals were dismissed, the cross-objections had to be separately dealt with on merits notwithstanding the dismissal of the appeals.</h4><h4>43.As regards delay in filing cross objections, the Hon’ble Apex Court in Mahadev Govind Garge vs. Land Acquisition Officer [(2011) 6 SCC 321]at paragraph 34 has held as under:<br></h4><h4 style=\"margin-left: 25px;\"><i>“34. Strict construction of a procedural law is called for where there is complete extinguishment of rights, as opposed to the cases where discretion is vested in the courts to balance the equities between the parties to meet the ends of justice which would invite liberal construction. For example, under Order 41 Rule 22 of the Code, cross-objections can be filed at any subsequent time, even after expiry of statutory period of one month, as may be allowed by the court. Thus,  it  is  evidently  clear that there  is  no  complete  or  indefeasible extinguishment of right to file cross-objections  after   the   expiry   of statutory  period   of   limitation   provided under the said provision.  Cross-objections within the scheme of Order 41 Rule 22 of the Code are to be treated as separate appeal and must be disposed of on same principles in accordance with the provisions of Order 41 of the Code.”</i></h4><h4>45. <i>(after referring to other judgments)</i><span style=\"font-size: 1.3125rem; white-space: pre;\">	</span>...<span style=\"background-color: rgb(255, 255, 0);\">.<b>In view of the above Point No (i) is answered by holding that the limitation period prescribed with respect to the filing of cross objection in terms of Order 41 Rule 22 of CPC is not to be strictly construed, but a liberal view in regard thereto is to be taken moreso when the cross objector/s had taken up the very same contention in the proceedings before the trial Court. </b></span></h4><h4 style=\"\">46.14. The admissions of the parties lead to an inescapable conclusion that the Schedule B and C (C1+C2) Properties are joint family properties, there would be no requirement to refer to any of the decisions relied on by Sri.Surana. <b style=\"background-color: rgb(255, 255, 0);\">Once the parties admit that the properties are joint family properties, even though they were bought in the name of mother-1st Defendant, the protection under Section 14 would not come into operation as discussed above and the properties would have to be held to be joint family properties.</b><br><br><span style=\"background-color: rgb(255, 255, 0);\"><b>Whether the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid down in Prakash vs. Phulawati (supra) and 2005 amendment is prospective and would apply from 9.09.2005 ?</b></span> <br>60.<span style=\"white-space:pre\">	</span>The amendment by way of Karnataka Act came into force with effect from 30.07.1994, as such, any succession post 30.07.1994 in the State of Karnataka would be governed by HSA as amended by Karnataka Amendment:</h4><h4 style=\"margin-left: 25px;\"><i>6-A.Equal rights to daughter in coparcenary property.—Notwithstanding anything contained in Section 6 of this Act:—<br>(a) in a joint Hindu family governed by Mitakshara law, the daughter of a coparcener shall by birth become a coparcener in her own right in the same manner as the son and have the same rights in the coparcenary property as she would have had if she had been a son inclusive of the right to claim by survivorship and shall be subject to the same liabilities and disabilities in respect thereto as the son;<br>(b) at a partition in such joint Hindu family the coparcenary property shall be so divided as to allot to a daughter the same share as is allottable to a son:<br>Provided that the share which a predeceased son or a predeceased daughter would have got at the partition if he or she had been alive at the time of the partition, shall be allotted to the surviving child of such predeceased son or of such predeceased daughter:<br>Provided further that the share allottable to the predeceased child of the predeceased son or of a predeceased daughter, if such child had been alive at the time of the partition, shall be allotted to the child of such predeceased child of the predeceased son or of such predeceased daughter, as the case may be;<br>(c) any property to which a female Hindu becomes entitled by virtue of the provisions of clause (a) shall be held by her with the incidents of coparcenary ownership and shall be regarded, notwithstanding anything contained in this Act or any other law for the time being in force, as property capable of being disposed of by her by will or other testamentary disposition;<br>(d) nothing in clause (b) shall apply to a daughter married prior to or to a partition which had been effected before the commencement of the Hindu Succession (Karnataka Amendment) Act, 1990.</i></h4><h4 style=\"\">61. It is this amended provision which was applicable in Karnataka till the Parliament amended the HSA by 2005 Act, the said amendment coming into force in the year 2005, i.e. with effect from 9.09.2005. In view of the coming into force of the Central amendment, there was some divergence of judicial opinion as to the applicability of the State amendment, the period to which it is applicable and from the period when the Central enactment would come into force.<br>66.In view of the above discussion, we are of the opinion that there are three-time lines which would be in operation in the State of Karnataka, viz.,<br></h4><h4 style=\"margin-left: 25px;\"><b style=\"background-color: rgb(255, 255, 0);\">(i) From 1956- 29.07.1994 – when unamended Section 6 of HSA would be applicable;<br>(ii) 30.07.1994 - 8.9.2005 – When the Karnataka amendment to the HSA would be applicable; and<br>(iii)Post 9.09.2005 – subject to the conditions in Phulavati’s case (supra) being satisfied, Section 6 of the HSA Act as amended by the Central Amendment Act, would be applicable.</b></h4><h4 style=\"\">71. In view of the above we answer Point No. (iii) by holding that the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid do<span style=\"background-color: rgb(255, 255, 0);\">wn in Prakash vs. Phulawati (supra), the Central Amendment would apply from 9.09.2005, the applicability being predicated on when succession opens and availability of the property/ies for partition, i.e., they are neither partitioned or sold by way of a registered instrument.</span></h4><h4 style=\"\">76. A live-in relationship is a formal relationship between a man and woman and in recent times arises out of they not wanting to be burdened with the responsibility of a married life or enter into such relationship as a matter of convenience or they may be forced to live in without marriage, one of the reasons being the prior marriage of one of them, which was still in force and a second marriage resulting in penal consequences.<br>77. A Court of Law by being predictable though brings stability to life and society cannot be blind or ignore the happenings in the society, more so when these kinds of relationships have been increasing over the last two or three decades, hence law needs to adapt to the changing times.<br>78. Having a sexual relationship outside marriage with a married woman was considered to be adultery and punishable, the courts as also the legislature in its wisdom have now decriminalised adultery after having taken into consideration the prevalent times and circumstances, changing mores, as also the changing morality in the society. So long as a man and woman live together harmoniously, the law would not have a role to play. However, if there is disharmony in terms of domestic violence, Domestic Violence Act would apply even in respect of a relationship where there is no marriage as long as the man and woman are living together in a relationship akin to a marriage over a period of time and have held themselves out as Husband and Wife as held by the Apex court in D.Velu Samy vs. D.Patchaiammal, [(2010) 10 SCC 469] and  Indra  Sarma  vs.  V.K.V.  Sarma [(2013) 15 SCC 755], the Apex  court  in  the above decisions granted maintenance to the woman in the relationship by considering that the relationship was in the “nature of marriage”.<br>79. The complication arises when this man and woman have children, the succession rights of those children born out of the relationship which has no name. The children were earlier referred to as bastards, subsequently, to be politically correct, they were referred to as ‘illegitimate children’ and now in some jurisdictions, they are referred to as ‘non-marital children’. The decision of the man and woman to have a child out of the wedlock has grave legal and societal consequences at least insofar as the child is concerned. The basic premise of having a child being to take forward one’s lineage, thereby vesting in the children the succession rights in the properties of both the father and the mother. Insofar as the mother’s property is concerned, there is no dispute since the parentage is easily traceable and established. However, in relation to father and the relationship, the same can, unless admitted, only be adjudicated on the basis of evidence tendered by witnesses or on certain presumptions. Section 16 of the Hindu Marriage Act has recognized, the above socio- economic-legal problem was amended in the year 1976 in order to provide a right to such non-marital children to succeed to properties of the father even though the marriage between the father and the mother of such children was void, so long as there is a marriage between the father and mother.<br>80. As aforestated there are two aspects relating to such live- in relationships, one is as regards the disharmony and/or maintenance of the live in partners in the event of they falling out and separating and the other being inheritance rights of the children born out of such a relationship.<br>81. In a country like India where marriage was not compulsorily registerable, it is very difficult to prove marriage, when denied, without reference to third party evidence, both oral and documentary. In many such situations, it is not possible to have such evidence on record, hence by virtue of Section 114 of the Evidence Act, there is a presumption of marriage which could be used to recognize such relationships.<br>82. In Piers vs. Piers [(1849)2  HL  Cas  331],  it  was observed that the question of the validity of  marriage could not be tried like any other issue of fact independent of presumption. The Court held that law would presume in favour of marriage and such presumption could only be rebutted by strong and satisfactory evidence.<br>83. In Lt. C.W.Campbell  vs.  John  A.G.  Campbell  [(1867)  LR 2 HL 269], the House of Lords held that cohabitation, with the required repute, as husband and wife, was proof that the parties between themselves had mutually contracted the matrimonial relation. A relationship which may be adulterous at the beginning may become matrimonial by consent. This may be evidenced by habit and repute.<br>110. In view of the aforesaid analysis and reasoning, we answer the above points as under:<br>110.1.The defendants have proved that there was a marriage solemnised between the 2nd Defendant – Jagadish Kumar and Manjula as also that 16th and 17th Defendants are their children. <br><span style=\"background-color: rgb(255, 255, 0);\"><b>Per Justice Nagarathna J.: </b></span>(<i>After thorough discussion on legal aspects and historical antecedents) </i>50.In the circumstances, it is concluded that, when the parties are in a domestic relationship which is in the nature of marriage and it is found to be so, even in the absence of solemnisation of marriage as per Section 7 of the Act, the children born out of such a relationship also need legislative and social protection. Thus, it is for the Parliament to determine in what way such protection may be extended in the form of separate legislation or by amendment of Section 16 of the Act. This is because, the expression marriage has a specific connotation under Section 5 and 7 of the Act and therefore the same cannot be stretched or given a wider connotation by adding words to the expression marriage as it would be doing violence to the language and intendment of the said Section. Further, Courts have to be cautious and vary of interpreting such provisions in an elastic manner or with wide connotation as it may lead to confusing signals to Indian society which is already in a state of transition on account of global influences. Further, one cannot brush aside the fact that a Hindu marriage is a sacrament and has a unique place in society and a vast majority of Hindu society values the institution of marriage, legitimacy of children and rearing a family as part of ‘Samskara’ of human life, which cannot be done away with or brushed aside merely because some sections of the society may not have faith in such ideas or social institutions. Therefore, instead of Courts coming to the rescue of such innocent children, it is best left to the Parliament to consider ways and means in which they could have the protection of law.<br><br><br><br></h4>', '58a6c6bae581e66bcb62d96f5113dd57.PNG', '395ac92d67ed1dfe7be882bf5ec57fe8.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-05-15', 1, '', '', '2021-03-14 20:01:26', '2021-03-14 22:02:08'),
(16, 'tIKCoJHDWTCHw7cTEZLklKFky', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Daksha Legal Drafting - Wills. ', '<p><b>PDF document containing different form of Wills enclosed.&nbsp;</b></p>', '8cc7a6a6a66aa8a447b1ee3beb4f4873.JPG', '5bb104f69f74eb5a780e7792e87d464d.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-08-13', 1, '', '', '2020-12-01 19:40:02', '2021-08-13 18:19:58'),
(17, 'iyssbdS4rOTTw9y0U6rBFf3aF', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '(2015) 10 SCC 390', '<div class=\"kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: \"Segoe UI Historic\", \"Segoe UI\", Helvetica, Arial, sans-serif; color: rgb(5, 5, 5); font-size: 15px; background-color: rgb(255, 255, 255); animation-name: none !important; transition-property: none !important;\"><div dir=\"auto\" style=\"font-family: inherit; animation-name: none !important; transition-property: none !important;\"><br></div></div>', 'a251c03eb84ff872490a45bc5472565f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-01 19:44:30', '2020-12-22 20:18:30'),
(18, '7hDLbzYnv6Mo516zVCmz41RNa', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Law. The Court can NOT per se issue any directions to the accused to furnish the password passcode or Biometrics and direction to cooperate would not amount to a direction to furnish such details Karnataka High Court. 12 March 2021. ', '<h4 style=\"margin-top: 10px; margin-bottom: 10px; line-height: 1.9 !important;\"><font color=\"#222222\" face=\"mainFontOP\"><span style=\"font-size: 16px;\"><b>Criminal Law. The Court cannot per se issue any directions to the accused to furnish the password, passcode or Biometrics and direction to cooperate would not amount to a direction to furnish password, passcode or Biometrics. Karnataka High Court. Click the following link to read the post. </b></span></font></h4><h4 style=\"margin-top: 10px; margin-bottom: 10px; line-height: 1.9 !important;\"><font color=\"#222222\" face=\"mainFontOP\"><span style=\"font-size: 16px;\"><b><a href=\"https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0\" target=\"_blank\">https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0</a></b></span></font></h4>\r\n\r\n<p style=\"text-align:justify;line-height:18.0pt;background:white\"></p>', '7a934b15e78779f34d976268181e46be.PNG', '005947ba6fe0f9b3de5528b5dd3d71a6.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2020-12-01 21:10:52', '2021-03-14 17:37:22');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(576, 'Ug4MkJs2PofFAX3ZAdzUllxHH', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Succession Act 1956. Section 14 does NOT apply when there is admission by the woman and evidence on record that the property was purchased in her name from out of joint family funds. Karnataka High Court. 15 March 2020', '<h4><span style=\"font-size: 1.3125rem; background-color: rgb(255, 255, 0);\"><i>See paragraph 46.14</i></span></h4><h4>Padmavathi and another vs Jayamma and others.<br></h4><h4>Regular First Appeal 916 of 2014 decided on 15 May 2020.</h4><h4>Justice B.V.Nagarathna and Justice Suraj Govindaraj.</h4><h4>Judgment Link: <a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/331256/1/RFA916-14-15-05-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/331256/1/RFA916-14-15-05-2020.pdf</a></h4><h4>Relevant paragraphs:&nbsp;</h4><h4>19. On the basis of the above, the points to be considered by this Court would be as under:</h4><h4>i) Whether the limitation period prescribed with respect to the filing of cross objection in terms of Order 41 Rule 22 of CPC is to be strictly construed, even when the cross objector had taken up the very same contention in the proceedings before the Trial Court?</h4><h4>ii) What is the nature of the Suit Schedule Properties, are they Joint Family Properties or individual properties of 1st Defendant?</h4><h4>iii) Whether the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid down in Prakash vs. Phulawati (supra) and 2005 amendment is prospective and would apply from 9.09.2005 ?&nbsp;</h4><h4>iv) Whether the Defendants have proved that there was a marriage solemnised between the 2nd Defendant – Jagadish Kumar and Manjula and 16th and 17th Defendants are their children?</h4><h4>v) Whether under Section 16 of the Hindu Marriage Act, illegitimate children are entitled to a share in ancestral or coparcenary property along with other legitimate heirs?</h4><h4>vi) What order?</h4><h4>42. The Apex Court in Banarasi vs. Ram Phal reported in [(2003) 9 SCC 606] has held that even as per amended Order XLII R 22(1) of the CPC, a party, in whose favour the decree stands in its entirety is neither entitled nor obliged to prefer any cross-objections. However, insertion made in the text of Sub-rule (1) makes it permissible to file a cross objection against a finding. The Apex Court further went on to hold that the respondent may defend himself without filing any cross objection to the extent to which the decree is in his favour. However, if he proposes to attack any part of the decree, he must make cross objection. Hence, the finding of the trial Court in respect of Schedule-A property being against the interest of the cross objectors, cross objectors are entitled to challenge the same by filing separate cross-objections. The Hon’ble Apex Court in Badru vs.&nbsp; NTPC&nbsp; Limited&nbsp; [(2019)&nbsp; SCC&nbsp; online&nbsp; SC 859] has also held that even if the appeals were dismissed, the cross-objections had to be separately dealt with on merits notwithstanding the dismissal of the appeals.</h4><h4>43.As regards delay in filing cross objections, the Hon’ble Apex Court in Mahadev Govind Garge vs. Land Acquisition Officer [(2011) 6 SCC 321]at paragraph 34 has held as under:</h4><h4>“34. Strict construction of a procedural law is called for where there is complete extinguishment of rights, as opposed to the cases where discretion is vested in the courts to balance the equities between the parties to meet the ends of justice which would invite liberal construction. For example, under Order 41 Rule 22 of the Code, cross-objections can be filed at any subsequent time, even after expiry of statutory period of one month, as may be allowed by the court. Thus,&nbsp; it&nbsp; is&nbsp; evidently&nbsp; clear that there&nbsp; is&nbsp; no&nbsp; complete&nbsp; or&nbsp; indefeasible extinguishment of right to file cross-objections&nbsp; after&nbsp; &nbsp;the&nbsp; &nbsp;expiry&nbsp; &nbsp;of statutory&nbsp; period&nbsp; &nbsp;of&nbsp; &nbsp;limitation&nbsp; &nbsp;provided under the said provision.&nbsp; Cross-objections within the scheme of Order 41 Rule 22 of the Code are to be treated as separate appeal and must be disposed of on same principles in accordance with the provisions of Order 41 of the Code.”</h4><h4>45. (after referring to other judgments)<span style=\"white-space:pre\">	</span>....In view of the above Point No (i) is answered by holding that the limitation period prescribed with respect to the filing of cross objection in terms of Order 41 Rule 22 of CPC is not to be strictly construed, but a liberal view in regard thereto is to be taken moreso when the cross objector/s had taken up the very same contention in the proceedings before the trial Court.&nbsp;</h4><h4><b style=\"background-color: rgb(255, 255, 0);\">46.14. The admissions of the parties lead to an inescapable conclusion that the Schedule B and C (C1+C2) Properties are joint family properties, there would be no requirement to refer to any of the decisions relied on by Sri.Surana. Once the parties admit that the properties are joint family properties, even though they were bought in the name of mother-1st Defendant, the protection under Section 14 would not come into operation as discussed above and the properties would have to be held to be joint family properties.</b></h4><h4><br></h4><h4>Whether the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid down in Prakash vs. Phulawati (supra) and 2005 amendment is prospective and would apply from 9.09.2005 ?&nbsp;</h4><h4>60.<span style=\"white-space:pre\">	</span>The amendment by way of Karnataka Act came into force with effect from 30.07.1994, as such, any succession post 30.07.1994 in the State of Karnataka would be governed by HSA as amended by Karnataka Amendment:</h4><h4>6-A.Equal rights to daughter in coparcenary property.—Notwithstanding anything contained in Section 6 of this Act:—</h4><h4>(a) in a joint Hindu family governed by Mitakshara law, the daughter of a coparcener shall by birth become a coparcener in her own right in the same manner as the son and have the same rights in the coparcenary property as she would have had if she had been a son inclusive of the right to claim by survivorship and shall be subject to the same liabilities and disabilities in respect thereto as the son;</h4><h4>(b) at a partition in such joint Hindu family the coparcenary property shall be so divided as to allot to a daughter the same share as is allottable to a son:</h4><h4>Provided that the share which a predeceased son or a predeceased daughter would have got at the partition if he or she had been alive at the time of the partition, shall be allotted to the surviving child of such predeceased son or of such predeceased daughter:</h4><h4>Provided further that the share allottable to the predeceased child of the predeceased son or of a predeceased daughter, if such child had been alive at the time of the partition, shall be allotted to the child of such predeceased child of the predeceased son or of such predeceased daughter, as the case may be;</h4><h4>(c) any property to which a female Hindu becomes entitled by virtue of the provisions of clause (a) shall be held by her with the incidents of coparcenary ownership and shall be regarded, notwithstanding anything contained in this Act or any other law for the time being in force, as property capable of being disposed of by her by will or other testamentary disposition;</h4><h4>(d) nothing in clause (b) shall apply to a daughter married prior to or to a partition which had been effected before the commencement of the Hindu Succession (Karnataka Amendment) Act, 1990.</h4><h4>61. It is this amended provision which was applicable in Karnataka till the Parliament amended the HSA by 2005 Act, the said amendment coming into force in the year 2005, i.e. with effect from 9.09.2005. In view of the coming into force of the Central amendment, there was some divergence of judicial opinion as to the applicability of the State amendment, the period to which it is applicable and from the period when the Central enactment would come into force.</h4><h4>66.In view of the above discussion, we are of the opinion that there are three-time lines which would be in operation in the State of Karnataka, viz.,</h4><h4>(i) From 1956- 29.07.1994 – when unamended Section 6 of HSA would be applicable;</h4><h4>(ii) 30.07.1994 - 8.9.2005 – When the Karnataka amendment to the HSA would be applicable; and</h4><h4>(iii)Post 9.09.2005 – subject to the conditions in Phulavati’s case (supra) being satisfied, Section 6 of the HSA Act as amended by the Central Amendment Act, would be applicable.</h4><h4>71. In view of the above we answer Point No. (iii) by holding that the Karnataka amendment to the HSA in terms of Section 6-A, 6-C would apply from 30.07.1994 to 08.9.2005 in view of the ratio laid down in Prakash vs. Phulawati (supra), the Central Amendment would apply from 9.09.2005, the applicability being predicated on when succession opens and availability of the property/ies for partition, i.e., they are neither partitioned or sold by way of a registered instrument.</h4><h4>76. A live-in relationship is a formal relationship between a man and woman and in recent times arises out of they not wanting to be burdened with the responsibility of a married life or enter into such relationship as a matter of convenience or they may be forced to live in without marriage, one of the reasons being the prior marriage of one of them, which was still in force and a second marriage resulting in penal consequences.</h4><h4>77. A Court of Law by being predictable though brings stability to life and society cannot be blind or ignore the happenings in the society, more so when these kinds of relationships have been increasing over the last two or three decades, hence law needs to adapt to the changing times.</h4><h4>78. Having a sexual relationship outside marriage with a married woman was considered to be adultery and punishable, the courts as also the legislature in its wisdom have now decriminalised adultery after having taken into consideration the prevalent times and circumstances, changing mores, as also the changing morality in the society. So long as a man and woman live together harmoniously, the law would not have a role to play. However, if there is disharmony in terms of domestic violence, Domestic Violence Act would apply even in respect of a relationship where there is no marriage as long as the man and woman are living together in a relationship akin to a marriage over a period of time and have held themselves out as Husband and Wife as held by the Apex court in D.Velu Samy vs. D.Patchaiammal, [(2010) 10 SCC 469] and&nbsp; Indra&nbsp; Sarma&nbsp; vs.&nbsp; V.K.V.&nbsp; Sarma [(2013) 15 SCC 755], the Apex&nbsp; court&nbsp; in&nbsp; the above decisions granted maintenance to the woman in the relationship by considering that the relationship was in the “nature of marriage”.</h4><h4>79. The complication arises when this man and woman have children, the succession rights of those children born out of the relationship which has no name. The children were earlier referred to as bastards, subsequently, to be politically correct, they were referred to as ‘illegitimate children’ and now in some jurisdictions, they are referred to as ‘non-marital children’. The decision of the man and woman to have a child out of the wedlock has grave legal and societal consequences at least insofar as the child is concerned. The basic premise of having a child being to take forward one’s lineage, thereby vesting in the children the succession rights in the properties of both the father and the mother. Insofar as the mother’s property is concerned, there is no dispute since the parentage is easily traceable and established. However, in relation to father and the relationship, the same can, unless admitted, only be adjudicated on the basis of evidence tendered by witnesses or on certain presumptions. Section 16 of the Hindu Marriage Act has recognized, the above socio- economic-legal problem was amended in the year 1976 in order to provide a right to such non-marital children to succeed to properties of the father even though the marriage between the father and the mother of such children was void, so long as there is a marriage between the father and mother.</h4><h4>80. As aforestated there are two aspects relating to such live- in relationships, one is as regards the disharmony and/or maintenance of the live in partners in the event of they falling out and separating and the other being inheritance rights of the children born out of such a relationship.</h4><h4>81. In a country like India where marriage was not compulsorily registerable, it is very difficult to prove marriage, when denied, without reference to third party evidence, both oral and documentary. In many such situations, it is not possible to have such evidence on record, hence by virtue of Section 114 of the Evidence Act, there is a presumption of marriage which could be used to recognize such relationships.</h4><h4>82. In Piers vs. Piers [(1849)2&nbsp; HL&nbsp; Cas&nbsp; 331],&nbsp; it&nbsp; was observed that the question of the validity of&nbsp; marriage could not be tried like any other issue of fact independent of presumption. The Court held that law would presume in favour of marriage and such presumption could only be rebutted by strong and satisfactory evidence.</h4><h4>83. In Lt. C.W.Campbell&nbsp; vs.&nbsp; John&nbsp; A.G.&nbsp; Campbell&nbsp; [(1867)&nbsp; LR 2 HL 269], the House of Lords held that cohabitation, with the required repute, as husband and wife, was proof that the parties between themselves had mutually contracted the matrimonial relation. A relationship which may be adulterous at the beginning may become matrimonial by consent. This may be evidenced by habit and repute.</h4><h4>110. In view of the aforesaid analysis and reasoning, we answer the above points as under:</h4><h4>110.1.The defendants have proved that there was a marriage solemnised between the 2nd Defendant – Jagadish Kumar and Manjula as also that 16th and 17th Defendants are their children.&nbsp;</h4><h4>Per Justice Nagarathna J.: (After thorough discussion on legal aspects and historical antecedents) 50.In the circumstances, it is concluded that, when the parties are in a domestic relationship which is in the nature of marriage and it is found to be so, even in the absence of solemnisation of marriage as per Section 7 of the Act, the children born out of such a relationship also need legislative and social protection. Thus, it is for the Parliament to determine in what way such protection may be extended in the form of separate legislation or by amendment of Section 16 of the Act. This is because, the expression marriage has a specific connotation under Section 5 and 7 of the Act and therefore the same cannot be stretched or given a wider connotation by adding words to the expression marriage as it would be doing violence to the language and intendment of the said Section. Further, Courts have to be cautious and vary of interpreting such provisions in an elastic manner or with wide connotation as it may lead to confusing signals to Indian society which is already in a state of transition on account of global influences. Further, one cannot brush aside the fact that a Hindu marriage is a sacrament and has a unique place in society and a vast majority of Hindu society values the institution of marriage, legitimacy of children and rearing a family as part of ‘Samskara’ of human life, which cannot be done away with or brushed aside merely because some sections of the society may not have faith in such ideas or social institutions. Therefore, instead of Courts coming to the rescue of such innocent children, it is best left to the Parliament to consider ways and means in which they could have the protection of law.</h4><h4><br></h4>', 'fd87e3867c426ce03ffe9832614a5eb8.PNG', '4721ba94bc6e2a890a6b820852e21175.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-05-15', 1, '', '', '2021-03-14 22:21:18', '2021-03-14 22:24:14'),
(577, 'tDvpoVS0LXpJSHAkt8TylmTLD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'IPC. Section 193. Punishment for false evidence. Bar under Section 195 will NOT apply if offence is committed during investigation provided the agency lodges complaint prior to commencement of court proceedings. Supreme Court. 12 March 2021', '<h4>Bhima Razu Prasad vs State, rep. by Deputy Superintendent of Police. </h4><h4>(arising out of S.L.P. (Criminal) No. 5102 of 2020) decided on 12 March 2021. </h4><h4>Judgment Link: <a href=\"https://main.sci.gov.in/supremecourt/2020/14906/14906_2020_39_1501_26894_Judgement_12-Mar-2021.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2020/14906/14906_2020_39_1501_26894_Judgement_12-Mar-2021.pdf </a><span style=\"font-size: 1.3125rem;\"><a href=\"https://main.sci.gov.in/supremecourt/2020/14906/14906_2020_39_1501_26894_Judgement_12-Mar-2021.pdf\" target=\"_blank\"> </a></span></h4><h4>Justice Mohan M. Shantanagoudar and Justice Vineet Saran. </h4><h4><span style=\"background-color: rgb(255, 255, 0);\">Relevant paragraphs</span>: 6. Hence, the primary question of law that arises for our consideration in these appeals is whether Section 195(1)(b)(i), CrPC bars lodging of case by the investigating agency under Section 193, IPC, in respect of offence of giving false evidence which is committed at the stage of investigation, prior to production of such evidence before the Trial Court? This in turn, requires us to resolve the following sub­questions:</h4><h4>6.1.Whether   an   offence under Section 193, IPC committed at the stage of investigation, prior to production of the false evidence before the Trial Court by a person who is not yet party to proceedings before the Trial Court, is an offence “in relation to” a proceeding in any court under Section 195(1)(b)(i), CrPC? </h4><h4>6.2 Whether the words “stage of a judicial proceeding” under Explanation 2 to Section 193, IPC can be equated with “proceeding in any court” under Section 195(1)(b)(i), CrPC?</h4><h4><span style=\"font-size: 1.3125rem;\"><span style=\"background-color: rgb(255, 255, 0);\">Cases referred</span>: </span></h4><h4>1) Iqbal Singh Marwah and Another v. Meenakshi Marwah and Another, (2005) 4 SCC 370, </h4><h4>2) Sachida Nand Singh and Another v. State of Bihar and Another, (1998) 2 SCC 493, </h4><h4>3) Bandekar Brothers Pvt. Ltd. and Another v. Prasad Vassudev Keni and Others, AIR 2020 SC 4247, </h4><h4>4) State of Punjab v. Jasbir Singh, (2020) 12 SCC 96, </h4><h4>5) Surjit Singh and Others v. Balbir  Singh, (1996) 3 SCC 533, </h4><h4>6) Kailash Mangal v. Ramesh Chand (Dead) Through Legal Representative, (2015) 15 SCC 729, </h4><h4>7) Narendra Kumar Srivastava v. State of Bihar and Others, (2019) 3 SCC 318, </h4><h4>8) Arvindervir Singh v. State of Punjab and Another, (1998) 6 SCC 352, </h4><h4>9) Punjab   and   Haryana   High   Court Bar Association, Chandigarh Through its Secretary v. State of Punjab and Others, (1994) 1 SCC 616, </h4><h4>10) Punjab  & Haryana High  Court Bar Association v. State of Punjab and Others, (1996) 4 SCC 742, </h4><h4>11) Lalji Haridas v. State of Maharashtra, (1964) 6 SCR 700, </h4><h4>12) Babita Lila and Another v. Union of India, (2016) 9 SCC 647, </h4><h4>13) Chandrapal Singh and Others v. Maharaj Singhand  Another, (1982) 1 SCC 466, </h4><h4><span style=\"background-color: rgb(255, 255, 0);\"><b>Conclusions</b></span>: 24. The questions of law formulated in paragraph 6 (supra) are answered as follows: </h4><h4><font color=\"#ce0000\">Section 195(1)(b)(i), CrPC  will  not  bar prosecution by the investigating agency for offence punishable  under  Section  193,  IPC, which is committed during the stage of investigation. This is provided that the investigating agency has lodged complaint or registered the case under Section 193, IPC  prior to  commencement  of  proceedings  and production of such evidence before the trial court. In  such circumstance,  the   same  would  not  be considered an offence committed in, or in relation to, any proceeding in any Court for the purpose of Section 195(1)(b)(i), CrPC.</font></h4><div><br></div><h4><br></h4>', '025f00ae46d62bc63574a39e74bda61b.PNG', '056ca946f5b5f5ea275d08fb0f908cdf.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2021-03-15 00:05:33', '2021-03-15 00:18:20'),
(578, 'kHR1pTGb7Anzil9NR8ZsPCatP', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Constitution of India. Delimitation of municipal constituencies. Bar under Article 243ZG-a applies only to Courts and not to State Election Commission. SEC can countermand illegal delimitation orders. Supreme Court. 12 March 2021 ', '<h4>State of Goa and another vs Fouzia Imtiaz Shaikh and another. </h4><h4>Civil Appeal 881 of 2021 decided on 12 March 2021. </h4><h4>Justice Rohinton Fali Nariman, Justice B.R. Gavai and Justice Hrishikesh Roy. </h4><h4>Judgment Link: <a href=\"https://main.sci.gov.in/supremecourt/2021/5892/5892_2021_33_1501_26888_Judgement_12-Mar-2021.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2021/5892/5892_2021_33_1501_26888_Judgement_12-Mar-2021.pdf</a></h4><h4><b style=\"background-color: rgb(255, 255, 0);\">HELD:</b> Paragraph 63. A conspectus of the aforesaid judgments in the context of municipal elections would yield the following results. </h4><h4>I. Under Article 243 ZG(b), no election to any municipality can be called in question except by an election petition presented to a Tribunal as is provided by or under any law made by the Legislature of a State. This would mean that from the date of notification of the election till the date of the declaration of result a judicial hands-off is mandated by the non-obstante clause contained in Article 243ZG debarring the writ court under Articles 226 and 227 from interfering once the election process has begun until it is over. The constitutional bar operates only during this period. It is therefore a matter of discretion exercisable by a writ court as to whether an interference is called for when the electoral process is “imminent” i.e, the notification for elections is yet to be announced.</h4><h4>II. If, however, the assistance of a writ court is required in subserving the progress of the election and facilitating its completion, the writ court may issue orders provided that the election process, once begun, cannot be postponed or protracted in any manner.</h4><h4>III. The non-obstante clause contained in Article 243ZG does not operate as a bar after the election tribunal decides an election dispute before it. Thus, the jurisdiction of the High Courts under Articles 226 and 227 and that of the Supreme Court under Article 136 of the Constitution of India is not affected as the non-obstante clause in Article 243ZG operates only during the process of election.<br>IV. Under Article 243ZA(1), the SEC is in overall charge of the superintendence, direction and control of the preparation of electoral rolls, and the conduct of all municipal elections. If there is a constitutional or statutory infraction by any authority including the<br>State Government either before or during the election process, the SEC by virtue of its power under Article 243ZA(1) can set right such infraction. For this purpose, it can direct the State Government or other authority to follow the Constitution or legislative enactment or direct such authority to correct an order which infracts the constitutional or statutory mandate. For this purpose, it can also approach a writ court to issue necessary directions in this behalf. <b style=\"background-color: rgb(255, 255, 0);\">It is entirely upto the SEC to set the election process in motion or, in cases where a constitutional or statutory provision is not followed or infracted, to postpone the election process until such illegal action is remedied. This the SEC will do taking into account the constitutional mandate of holding elections before the term of a municipality or municipal council is over. In extraordinary cases, the SEC may conduct elections after such term is over, only for good reason.</b><br>V. Judicial review of a State Election Commission’s order is available on grounds of review of administrative orders. Here again, the writ court must adopt a hands-off policy while the election process is on and interfere either before the process commences or after such process is completed unless interfering with such order subserves and facilitates the progress of the election.<br>VI. Article 243ZA(2) makes it clear that the law made by the legislature of a State, making provision with respect to matters relating to or in connection with elections to municipalities, is subject to the provisions of the Constitution, and in particular Article 243T, which deals with reservation of seats.<br>VII. The bar contained in Article 243ZG(a) mandates that there be a judicial hands-off of the writ court or any court in questioning the validity of any law relating to delimitation of constituency or allotment of seats to such constituency made or purporting to be made under Article 243ZA. This is by virtue of the non-obstante clause contained in Article 243ZG. The statutory provisions dealing with delimitation and allotment of seats cannot therefore be questioned in any court. However, orders made under such<br>statutory provisions can be questioned in courts provided the concerned statute does not give such orders the status of a statutory provision.<br>VIII. Any challenge to orders relating to delimitation or allotment of seats including preparation of electoral rolls, not being part of the election process as delineated above, can also be challenged in the manner provided by the statutory provisions dealing with delimitation of constituencies and allotment of seats to such constituencies.<br><b style=\"background-color: rgb(255, 255, 0);\">IX. The constitutional bar of Article 243ZG(a) applies only to courts and not the State Election Commission, which is to supervise, direct and control preparation of electoral rolls and conduct elections to municipalities.<br>X. The result of this position is that it is the duty of the SEC to countermand illegal orders made by any authority including the State Government which delimit constituencies or allot seats to such constituencies, as is provided in proposition (IV) above. This may be done by the SEC either before or during the electoral process, bearing in mind its constitutional duty as delineated in the said proposition</b></h4>', 'c1d6a593e00403807235315ce13e04d6.PNG', '759e16d5d02591f68f4336787c475905.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2021-03-15 18:45:12', '2021-03-15 18:51:53'),
(579, 'jFxE6lxd02MOU0wuaH6cCOLeK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Gross abuse of power by Government officers resulting in illegal demolition and dispossession. Karnataka High Court passes strictures and imposes heavy costs on the erring officers. 15 March 2021', '<h4>Jayamma and others vs State of Karnataka and Others. </h4><h4>Writ Petition 9723 of 2020 decided on 15 March 2021. </h4><h4>Judgment Link: <a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/371547/1/WP9723-20-15-03-2021.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/371547/1/WP9723-20-15-03-2021.pdf</a></h4><h4><span style=\"background-color: rgb(255, 255, 0);\">Relevant paragraphs</span>: 24.The Assistant Commissioner and the Tahsildar have made a consorted effort, abusing their office and violating  the procedures, as noticed above, to take possession of the properties in question, proceeding to demolish the structures and buildings which were in possession of the rightful owners or tenants, with utter disregard to the provisions of law and human rights. The Assistant Commissioner and the Tahsildar are impleaded as parties eo-nomine and they have engaged learned Counsels who were unable to meet the allegations made against them. On the other hand, blame is sought to be placed against each other that the Tahsildar was required to follow the process as contemplated under Section 39 of the Karnataka Land Revenue Act, while it is contended by the Tahsildar that he followed the instructions of the Assistant Commissioner.<br>25. There can be no manner of doubt that the impugned order passed by the Assistant Commissioner is arbitrary, illegal and tainted with malice. It is therefore required to be quashed and set aside. The matter requires to be reconsidered on merits by the <br>28. Before parting with these writ petitions, it needs to be mentioned that the highhanded action on the part of the Assistant Commissioner and the Tahsildar is required to be taken note of and appropriate action is required to be initiated against them, to take things to their logical conclusion. This Court should take judicial notice of the fact that such highhanded action on the part of the respondent-authorities could not have happened if the authorities were sensitive enough about their powers and functions and the obvious disregard may have been occasioned due to the fact that postings are given to such sensitive offices, not on merits or with public interest in mind. It is obvious that the respondent-authorities are fearless of the consequences of being in conflict with the law. Such officers are emboldened by the fact that they are protected by the Government. Every now and then the citizens of this State are given to understand that ‘plum’ postings are assigned for monetary considerations. Such news and information are published in national newspapers, magazines, Television channels and social media. Allegations are levelled by the opposition leaders and social activists. Cutting across all political parties that have formed Government, allegations are levelled against Heads of the Departments, Ministers and the Chief Ministers. There cannot be two views that if an Officer shells out money to get a plum posting, he would employ every means possible to recover the money he has invested and makes every effort to make money for future needs and therefore, this forms the vicious circle of corruption. Time has come when this Court has to step in to find out the truth of the fact and direct the State to put in place regulations to check the tentacles of corruption from taking strangle hold of the society. Therefore, this Court would urge that Hon’ble the Chief Justice may take note of the observations of this Court and take up suo motu proceedings against the State Government to put an end to the pernicious practice of providing postings for monetary considerations and reasons other than public interest.<br>29.<span style=\"white-space:pre\">	</span>For the foregoing reasons, this Court proceeds to pass the following:<br>ORDER<br>1. The writ petitions are allowed with costs of Rs.10,000/- (Rupees Ten Thousand Only) each, payable by the respondent-Assistant Commissioner (Sri M.G.Shivanna), the respondent-Tahsildar (Sri Shivappa Lamani) and respondent No.8 (Sri M.Muniraju) to each of the four petitioners. The costs shall be  paid within a period of four weeks from today and an acknowledgement shall be furnished  in the office, for records. The strictures passed by this Court and costs imposed on the respondent-Assistant Commissioner and the respondent-Tahsildar shall be entered in their Service Register.<br>2. The impugned order dated 18.02.2020  passed by the respondent-Assistant Commissioner in Case No.K-SC-ST(S) 15/ 2019-2020, is hereby quashed and set aside.<br>3. The matter stands remanded to the Assistant Commissioner who shall issue notice to the petitioners herein, permit them to file objections and raise all grounds including the question of delay and laches in initiation of the proceedings under Section 5 of the Karnataka Scheduled Castes and Scheduled Tribes (Prohibition of Transfer of Certain Lands) Act, 1978.<br>4. The Additional Chief Secretary, Department of Revenue, shall initiate an enquiry against the respondent-Assistant Commissioner and the respondent-Tahsildar and if required place them under suspension immediately. At any rate, the respondent-Assistant Commissioner Sri M.G.Shivanna, shall not hear this matter.<br>5. The enquiry may be entrusted to the Hon’ble Lokayukta.<br>6. The petitioners herein shall be put back in possession of the land in question, which was resumed by virtue of the impugned order.<br>7. Liberty is granted to the petitioners to approach the competent Civil Court to seek compensation/damages at the hands of the respondent-Assistant<span style=\"white-space:pre\">	</span>Commissioner, respondent-Tahsildar, the State Government and the 8th respondent Sri. M Muniraju.<br>8. The recommendation dated 01.11.2019, made by the National Commission and the communication dated 11.01.2019, need not be acted upon.<br>A copy of this order shall be forwarded to the Chief Secretary, Additional Chief Secretary, Department of Revenue, for further action. A copy of this order shall also be placed before Hon’ble the Chief Justice of this Court. </h4><h4>It is ordered accordingly.<br>In view of the disposal of the petitions, pending IAs do not survive for consideration and are accordingly disposed of.</h4><div><br></div>', 'ce4365dd97ffa040426d94fe1341c518.jpg', '229e625fa0fbc14053e8f670cfee1df5.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-15', 1, '', '', '2021-03-16 01:20:15', '2021-03-16 01:25:48'),
(580, 'ukWXBNed0S7iA57daIsTtQq3o', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'C.P.C. Return of plaint for want of statutory notice. Revision under Section 115 is NOT maintainable. Appeal under Section 96 or under Order 43 is also NOT maintainable. Karnataka High Court. 6 March 2021', '<h4><span style=\"background-color: rgb(255, 255, 0);\">NOTE</span>: In view of this judgement, against return of plaint on technical grounds, the only remedy is to file a writ petition under Article 227 of the Constitution of India.&nbsp; &nbsp;&nbsp;</h4><h4>M/s. Suvidha Realtors and Constructions Pvt Ltd vs The Hubli Taluka Agricultural Produce Co-Operative Marketing Ltd and another. </h4><h4>Civil Revision Petition 100019 of 2020 decided on 6 March 2021. </h4><h4>Judgment Link:&nbsp;<a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/371232/1/CRP100019-20-06-03-2021.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/371232/1/CRP100019-20-06-03-2021.pdf</a><br><span style=\"background-color: rgb(255, 255, 0);\">Relevant paragraphs</span>:&nbsp;In this petition filed under Section 115&nbsp; of&nbsp; the&nbsp; Code&nbsp; of&nbsp; Civil Procedure, 1908 the petitioner is calling in question the legality and validity of the order dated 31.01.2020 passed in O.S.No.51/2009 by&nbsp; the&nbsp; learned Principal Senior Civil Judge, Hubballi, returning the plaint of the plaintiff.<br></h4><h4>3. The office has raised objections regarding the maintainability of the revision petition under&nbsp; Section&nbsp; 115&nbsp; of CPC as against the impugned&nbsp; order&nbsp; dated&nbsp; 31.01.2020&nbsp; passed by the learned court below. Respondents who are&nbsp; the&nbsp; defendants before the Court below have&nbsp; also&nbsp; taken&nbsp; up&nbsp; the&nbsp; same contentions.<br></h4><h4>7. As is apparent from the above, the learned Court below has passed the impugned order returning the plaint to the plaintiff for want of compliance of statutory/mandatory notice under Section 125 of the Karnataka Co-operative Societies Act, 1959.&nbsp;<br></h4><h4>9. Sub-Section (1) of Section 115 of CPC is very clear that a revision is maintainable&nbsp; only&nbsp; when&nbsp; no&nbsp; appeal&nbsp; lies against the impugned order.<br>10. The appeal against judgment and decree passed in original suits and orders passed in such&nbsp; suits&nbsp; can&nbsp; be&nbsp; maintained under Section 96 read with Order 41 of CPC&nbsp; or under Order 43 of CPC.&nbsp;&nbsp;<br><b style=\"background-color: rgb(255, 255, 0);\">11. There is absolutely no quarrel about the fact on&nbsp; either side that since the impugned order is one&nbsp; of&nbsp; returning&nbsp; the plaint for alleged want of statutory notice, to&nbsp; defendant&nbsp; No.1, no decree has resulted therefrom and accordingly no&nbsp; appeal can be maintained as against the impugned order under Section 96 of CPC.<br></b>12. The next question which arises is as to whether an appeal can be maintained under Order 43 of CPC.&nbsp;<br><b style=\"background-color: rgb(255, 255, 0);\">13. A bare perusal of the above provision shows that the impugned order is not one of returning the plaint to be presented to a proper Court and therefore, no appeal can be maintained against the impugned order under Order 43 of the Code.<br></b>14. The only point of controversy&nbsp; between&nbsp; the&nbsp; parties on either side is, while the petitioner asserts that the impugned order comes within the proviso to sub-Section (1) of Section 115 of CPC, and the revision petition is maintainable, the assertion of the respondents is that it is not so and revision petition, therefore, is not maintainable against the impugned order.&nbsp;<br>15. A careful perusal of the proviso to sub-Section (1) of Section 115 of CPC makes it obvious that a revision petition can be maintained before the High Court and in such a revision petition, High Court can vary or reverse the order impugned before it only if the order under revision, if it had been made in favour of the revision petitioner would have finally disposed of the suit or other proceedings.&nbsp; In&nbsp; other&nbsp; words, the condition precedent for the maintainability of a revision petition under CPC is that if the&nbsp; order&nbsp; which&nbsp; is called in question in the&nbsp; revision&nbsp; petition&nbsp; had been otherwise, that is if the order were to be in favour of the revision petitioner, it ought to have had the effect of disposing of the entire suit.&nbsp; In this particular case, the learned Court below has held that the petitioner has failed to issue statutory notice under Section 125 of the Karnataka Co-operative Societies Act, 1959. In order for the High Court to entertain a revision petition,&nbsp; the&nbsp; situation&nbsp; should&nbsp; have&nbsp; been&nbsp; that&nbsp; if&nbsp; the&nbsp; Court&nbsp; had&nbsp; accepted&nbsp; the&nbsp; contention&nbsp; of&nbsp; the&nbsp; petitioner&nbsp; herein&nbsp; and held the notice issued to defendant No.2 itself was sufficient,&nbsp; the&nbsp; effect&nbsp; of&nbsp; such&nbsp; order&nbsp; should&nbsp; have&nbsp; been to finally&nbsp; dispose&nbsp; of&nbsp; the&nbsp; suit. Such a finding&nbsp; by&nbsp; the&nbsp; learned trial Court would not have had the effect of finally disposing<br>of O.S.No.51/2009 in this particular case. <b style=\"background-color: rgb(255, 255, 0);\">It is therefore quite clear that the impugned order is not revisable under Section 115 of CPC and as such, the present petition is not maintainable.</b>&nbsp;<br>16. Hence, the following : The above petition is rejected as not maintainable. However, interim order which is in operation till today, shall continue for a period of fifteen days from today, in order to enable the petitioner herein to take such steps as is advised,&nbsp; to question the impugned order.<br></h4><h4><span style=\"background-color: rgb(255, 255, 0);\">Cases referred</span>&nbsp;</h4><h4>1.W.P.No.113059/2014 – Dalawai Nagappa since deceased by LRs. And ors. Vs. P.&nbsp; Abdul Bari and others.<br>2.(1977) 4 SCC 551 – Madhu Limaye vs. The State of Maharashtra.<br>3.(2003) 6 SCC 675 – Surya Dev Rai vs. Ram Chander Rai and others.<br>4.ILR 2018 Kar. 3785 – Nazir Ahamad and ors. Vs.&nbsp; Anwarpashya&nbsp; Sayyadmeera&nbsp; Mujwar and ors.<br>5.ILR 2004 Kar. 1445 – The Arogyanagar Co- operative Housing Society Ltd. And others vs. Fakiragouda and others.<br>6.AIR 1977 SC 148 – State of Maharashtra and others vs. Chander Kant.<br>7.ILR 2018 Kar. 3785 – Nazir Ahamad and others vs. Anwarpashya Sayyadmeera Mujwar and others.<br>8.2001 (1) Kar.L.J. 36 – State and others vs. Prabhakar.<br>9.AIR 1963 SC 424 – Amar Nath Dogra vs. Union of India.<br>10.AIR 1991 Delhi 298 – The New India Assurance Co. Ltd. And ors. Vs. The Delhi Development Authority and ors.<br>11.AIR 1984 SC 1043 –&nbsp; Bihari&nbsp; Chowdhary&nbsp; and ors. Vs. State of Bihar and ors.<br>12.AIR 1965 SC 11 – State of Andhra Pradesh vs. Gundugola Venkata Suryanarayana Garu.<br>13.AIR 1969 SC 1256 –&nbsp; Beohar&nbsp; Rajendra Sinha and ors. Vs. State&nbsp; of&nbsp; Madhya Pradesh and ors.<br>14.AIR 1969 SC 674 – Raghunath Das vs. Union of India and ors.<br></h4>', '9d89a30d8c4b7a17742de8476b44b41d.jpg', '1079ac0f15694ea9ff7f22119aa15f95.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-06', 1, '', '', '2021-03-16 01:56:23', '2021-03-16 02:11:23'),
(581, 'N0K4DQvOQGmV4rHHSeGbpiOqA', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Cr.P.C. Section 319. Power to proceed against other persons appearing to be guilty of offence can be exercised even on the basis of statement in examination-in­-chief without waiting for cross ­examination of the witness. Supreme Court. 15 March 2021', '<h4>Sartaj Singh vs State of Haryana & Anr. </h4><h4>Criminal Appeal 298-299 of 2021 decided on 15 March 2021. </h4><h4>Justice Dr. Dhananjaya Y. Chandrachud and Justice M. R. Shah. </h4><h4>Judgment Link:  <a href=\"Link: https://main.sci.gov.in/supremecourt/2020/27124/27124_2020_36_1503_26964_Judgement_15-Mar-2021.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2020/27124/27124_2020_36_1503_26964_Judgement_15-Mar-2021.pdf</a></h4><h4><span style=\"font-size: 1.3125rem;\"><span style=\"background-color: rgb(255, 255, 0);\">Questions framed. </span>6.1.2 In   the   said   case,   the   following   five   questions   fell   for </span>consideration before this Court.</h4><h4>(i) What is the stage at which power under Section 319 CrPC can be exercised?</h4><h4>(ii) Whether the word “evidence” used in Section 319(1) CrPC could only mean evidence tested by cross examination or the court can exercise the power under the said provision even on the basis of the statement made   in   the   examination ­in ­chief   of   the   witness concerned?</h4><h4>(iii) Whether the word “evidence” used in Section 319(1) CrPC has been used in a comprehensive sense and includes the evidence collected during investigation or the word “evidence” is limited to the evidence recorded during trial?</h4><h4>(iv) What is the nature of the satisfaction required to invoke the power under Section 319 CrPC to arraign an accused? Whether the power under Section 319(1) CrPC can be exercised only if the court is satisfied that the accused summoned will in all likelihood be convicted?</h4><h4>(v) Does the power under Section 319 CrPC extend to persons not named in the FIR or named in the FIR but not charged or who have been discharged?”</h4><h4><span style=\"background-color: rgb(255, 255, 0);\">HELD </span>6.2 Considering   the   law   laid   down   by   this   Court   in Hardeep Singh Hardeep Singh v. State of Punjab (2014) 3 SCC 92 and the observations and findings referred to and reproduced herein above, it emerges that (i) the Court can exercise the   power   under   Section   319   CrPC   even   on   the  basis  of  the statement   made   in   the   examination ­in­ chief   of   the   witness concerned and the Court need not wait till the cross­examination of such a witness and the Court need not wait for the evidence against the   accused   proposed   to   be   summoned  to   be   tested   by   cross examination; and (ii) a person not named in the FIR or a person though named in the FIR but has not been charge­sheeted or a person who has been discharged can be summoned under Section 319 CrPC, provided from the evidence (may be on the basis of the evidence   collected   in   the   form   of   statement   made   in   the examination ­in ­chief of the witness concerned), it appears that such person can be tried along with the accused already facing trial.</h4><h4>7. Applying the law laid down by this Court in the aforesaid decisions to the case of the accused on hand, we are of the opinion that learned Trial Court was justified in summoning the private respondents herein to face the trial as accused on the basis of the deposition of the appellant – injured eye witness.  As held by this Court in the aforesaid decisions, the accused can be summoned on the basis of even examination ­in ­chief of the witness and the Court need not wait till his cross­ examination. If on the basis of the examination ­in­ chief of the witness the Court is satisfied that there is a prima facie case against the proposed accused, the Court may in exercise of powers under Section 319 CrPC array such a person as accused and summon him to face the trial.  At this stage, it is<br>required to be noted that right from the beginning the appellant herein – injured eye witness, who was the first informant, disclosed the names of private respondents herein and specifically named them in the FIR.  But on the basis of some enquiry by the DSP they were not charge­sheeted.  What will be the evidentiary value of the enquiry report submitted by the DSP is another question.   It is not that   the   investigating   officer   did   not   find   the   case   against   the private respondents herein  and  therefore they  were not  chargesheeted.  In any case, in the examination ­in ­chief of the appellantinjured eye witness, the names of the private respondents herein are   disclosed.     It   might   be   that   whatever   is   stated   in   the examination ­in­ chief is the same which was stated in the FIR. The same is bound to be there and ultimately the appellant herein – injured eye witness is the first informant and he is bound to again state what was stated in the FIR, otherwise he would be accused of contradictions   in   the   FIR   and   the  statement  before   the   Court. Therefore, as such, the learned Trial Court was justified in directing to issue summons against the private respondents herein to face the trial.</h4>', 'aabdf648d809f9f0f918718c1fa0706e.PNG', 'da1fa9a20ea07ab69da52d24af3220f9.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-15', 1, '', '', '2021-03-16 02:30:31', '2021-03-16 02:50:40');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(19, 'nm7nADQTcuSNAMeG8vNtYDuGZ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '“From Estoppel to Expectations”. Supreme Court dissects doctrines of Promissory Estoppel and Legitimate Expectation.', '<h1 style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; font-size: 0.88889em; margin: 32px auto; max-width: calc(66.6667vw - 28px); overflow-wrap: break-word; color: rgb(30, 30, 30); font-family: &quot;Crimson Text&quot;, &quot;Baskerville Old Face&quot;, Garamond, &quot;Times New Roman&quot;, serif; background-color: rgb(255, 255, 255); line-height: 1;\"><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">The State of Jharkhand and Ors vs Brahmputra Metallics Ltd., Ranchi and Anr. Civil Appeal 3860-3862/2020 decided on 1 December 2020.<br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Judgment Link:&nbsp;<a href=\"https://main.sci.gov.in/supremecourt/2020/17227/17227_2020_33_1501_24877_Judgement_01-Dec-2020.pdf\" rel=\"nofollow\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\">https://main.sci.gov.in/supremecourt/2020/17227/17227_2020_33_1501_24877_Judgement_01-Dec-2020.pdf<br></a></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">Relevant paragraphs: H.3 Promissory estoppel – origins and evolution<br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">27.&nbsp;</span>In order to analyze the contentions relating to the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>in the present case, it is necessary to discuss the origin of the doctrine and the evolution of its application. The common law recognizes various kinds of equitable estoppel, one of which is promissory estoppel. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Crabb&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Arun DC, [1976] 1 Ch 179 (Court of Appeal)</span>, Lord Denning, speaking for the Court of Appeal, traced the genesis of promissory estoppel in equity, and observed:&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">“The basis of this proprietary estoppel – as indeed of promissory estoppel – is the interposition of equity. Equity comes in, true to form, to mitigate the rigours of strict law. The early cases did not speak of it as “estoppel”. They spoke of it as “raising an equity” If I may expand that, Lord Cairns said: “It is the first principle upon which all Courts of Equity proceed”, that it will prevent a person from insisting on his legal rights – whether arising under a contract or on his title deed, or by statute – when it would be inequitable for him to do so having regard to the dealings which have taken place between the parties.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">28.&nbsp;</span>The requirements of the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>have also been formulated in Chitty on Contracts<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark13\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">14</span>&nbsp;</a>(“<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">Chitty</span>”):<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“<span style=\"box-sizing: inherit; font-weight: bolder;\">4.086.</span>&nbsp;For the equitable doctrine to operate there must be a legal relationship giving rise to rights and duties between the parties; a promise or a representation by one party that he will not enforce against the other his strict legal rights arising out of that relationship; an intention on the part of the former party that the latter will rely on the representation; and such reliance by the latter party. Even if these requirements are satisfied, the operation of the doctrine may be excluded if it is, nevertheless, not “inequitable” for the first party to go back on his promise. The doctrine most commonly applies to promises not to enforce contractual rights, but it also extends to certain other relationships.&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">4.088…..</span>The doctrine can also apply where the relationship giving rise to rights and correlative duties is non-contractual: e.g. to prevent the enforcement of a liability imposed by statute on a company director for signing a bill of exchange on which the company’s name is not correctly given; or to prevent a man from ejecting a woman, with whom he has been cohabitating, from the family home.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">Chitty&nbsp;</span>(supra) clarifies that the doctrine of&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">promissory estoppel&nbsp;</em>may be enforced even in the absence of a legal relationship. However, it is argued that this would be an incorrect application of the doctrine since it gives rise to new rights between the parties, when the intent of the doctrine is to restrict the enforcement of previously existing rights:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-weight: bolder;\">“4.089.&nbsp;</span>It has, indeed, been suggested that the doctrine can apply where, before the making of the promise or representation, there is no legal relationship giving rise to rights and duties between the parties, or where there is only a putative contract between them: e.g. where the promisee is induced to believe that a contract into which he had undoubtedly entered was between him and the promisor, when in fact it was between the promisee and another person. But it is submitted that these suggestions mistake the nature of the doctrine, which is to restrict the enforcement by the promisor of previously existing rights against the promisee. Such rights can arise only out of a legal relationship existing between these parties before the making of the promise or representation. To apply doctrine where there was no such relationship would contravene the rule (to be discussed in para.4-099 below) that the doctrine creates no new rights.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">29.&nbsp;</span>Generally speaking under English Law, judicial decisions have in the past postulated that the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>cannot be used as a ‘sword’, to give rise to a cause of action for the enforcement of a promise lacking any consideration. Its use in those decisions has been limited as a ‘shield’, where the promisor is estopped from claiming enforcement of its strict legal rights, when a representation by words or conduct has been made to suspend such rights. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Combe&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Combe</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark14\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">15</span>&nbsp;</a>(“<span style=\"box-sizing: inherit; font-weight: bolder;\">Combe</span>”), the Court of Appeal held that consideration is an essential element of the cause of action:&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">“It [promissory estoppel] may be part of a cause of action, but not a cause of action itself. The principle [promissory estoppel] never stands alone as giving a cause of action in itself, it can never do away with the necessity of consideration when that is an essential part of the cause of action. The doctrine of consideration is too firmly fixed to be overthrown by a side-wind.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">30.</span>&nbsp;Even within English Law, the application of the rule laid down in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Combe&nbsp;</span>(supra) has been noticed to be inconsistent<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark15\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">16</span></a>. The scope of the rule has also been doubted on the ground that it has been widely framed<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark16\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">17</span></a>. Hence, in the absence of a definitive pronouncement by the House of Lords holding that promissory estoppel can be a cause of action, a difficulty was expressed in stating with certainty that English Law has evolved from the traditional approach of treating promissory estoppel as a ‘shield’ instead of a ‘sword’<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark17\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">18</span></a>. By contrast, the law in the United States<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark18\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">19</span>&nbsp;</a>and Australia<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark19\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">20</span>&nbsp;</a>is less restrictive in this regard.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">31. India, as we shall explore shortly, adopted a more expansive statement of the doctrine. Comparative law enables countries which apply a doctrine from across international frontiers to have the benefit of hindsight.<br></span>This Court has given an expansive interpretation to the doctrine of&nbsp;<em style=\"box-sizing: inherit; margin-top: 0px;\">promissory estoppel&nbsp;</em>in order to remedy the injustice being done to a party who has relied on a promise. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Motilal Padampat&nbsp;</span>(supra), this Court viewed&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>as a principle in equity, which was not hampered by the doctrine of consideration as was the case under English Law. This Court, speaking through Justice P N Bhagwati (as he was then), held thus:&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">“12….having regard to the general opprobrium to which the doctrine of consideration has been subjected by eminent jurists, we need not be unduly anxious to project this doctrine against assault or erosion nor allow it to dwarf or stultify the full development of the equity of promissory estoppel or inhibit or curtail its operational efficacy as a justice device for preventing injustice…We do not see any valid reason why promissory estoppel should not be allowed to found a cause of action where, in order to satisfy the equity, it is necessary to do so.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">H.2&nbsp;From estoppel to expectations<br></span>Under English Law, the doctrine of&nbsp;<em style=\"box-sizing: inherit; margin-top: 0px;\">promissory estoppel&nbsp;</em>has developed parallel to the doctrine of legitimate expectations. The doctrine of legitimate expectations is founded on the principles of fairness in government dealings. It comes into play if a public body leads an individual to believe that they will be a recipient of a substantive benefit. The doctrine of substantive legitimate expectation has been explained in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">R&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">North and East Devon Health Authority, ex p Coughlan</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark20\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">21</span>&nbsp;</a>in the following terms:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-weight: bolder;\">“55….&nbsp;</span>But what was their legitimate expectation?” Where there is a dispute as to this, the dispute has to be determined by the court, as happened in In re Findlay. This can involve a detailed examination of the precise terms of the promise or representation made, the circumstances in which the promise was made and the nature of the statutory or other discretion.<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-weight: bolder;\">56….</span>Where the court considers that a lawful promise or practice has induced a legitimate expectation of a benefit which is substantive, not simply procedural, authority now establishes that here too the court will in a proper case decide whether to frustrate the expectation is so unfair that to take a new and different course will amount to an abuse of power. Here, once the legitimacy of the expectation is established, the court will have the task of weighing the requirements of fairness against any overriding interest relied upon for the change of policy.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">33.</span>&nbsp;Under English Law, the doctrine of legitimate expectation initially developed in the context of public law as an analogy to the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>found in private law. However, since then, English Law has distinguished between the doctrines of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>and legitimate expectation as distinct remedies under private law and public law, respectively.&nbsp;<em style=\"box-sizing: inherit;\">De Smith’s Judicial Review</em><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark21\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">22</span>&nbsp;</a>notes the contrast between the public law approach of the doctrine of legitimate expectation and the private law approach of the doctrine of&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">promissory estoppel&nbsp;</em>:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“[d]espite dicta to the contrary [Rootkin v Kent CC, (1981) 1 WLR 1186 (CA); R v Jockey Club Ex p RAM Racecourses Ltd, [1993] AC 380 (HL); R v IRC Ex p Camacq Corp, (1990) 1 WLR 191 (CA)], it is not normally necessary for a person to have changed his position or to have acted to his detriment in order to qualify as the holder of a legitimate expectation [R v Ministry for Agriculture, Fisheries and Foods Ex p Hamble Fisheries (Offshore) Ltd, (1995) 2 All ER 714 (QB)]. . . Private law analogies from the field of estoppel are, we have seen, of limited relevance where a public law principle requires public officials to honour their undertakings and respect legal certainty, irrespective of whether the loss has been incurred by the individual concerned [Simon Atrill, ‘The End of Estoppel in Public Law?’ (2003) 62 Cambridge Law Journal 3].”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">34.&nbsp;</span>Another difference between the doctrines of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>and legitimate expectation under English Law is that the latter can constitute a cause of action<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark22\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">23</span></a>. The scope of the doctrine of legitimate expectation is wider than promissory estoppel because it not only takes into consideration a promise made by a public body but also official practice, as well. Further, under the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel</em>, there may be a requirement to show a detriment suffered by a party due to the reliance placed on the promise. Although typically it is sufficient to show that the promisee has altered its position by placing reliance on the promise, the fact that no prejudice has been caused to the promisee may be relevant to hold that it would not be “inequitable” for the promisor to go back on their promise.<a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark23\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">24</span>&nbsp;</a>However, no such requirement is present under the doctrine of legitimate expectation. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Regina (Bibi)&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Newham London Borough Council</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark24\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">25</span></a>, the Court of Appeal held:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“55 The present case is one of reliance without concrete detriment. We use this phrase because there is moral detriment, which should not be dismissed lightly, in the prolonged disappointment which has ensued; and potential detriment in the deflection of the possibility, for a refugee family, of seeking at the start to settle somewhere in the United Kingdom where secure housing was less hard to come by. In our view these things matter in public law, even though they might not found an estoppel or actionable misrepresentation in private law, because they go to fairness and through fairness to possible abuse of power.&nbsp; To disregard the legitimate expectation because no concrete detriment can be shown would be to place the weakest in society at a particular disadvantage. It would mean that those who have a choice and the means to exercise it in reliance on some official practice or promise would gain a legal toehold inaccessible to those who, lacking any means of escape, are compelled simply to place their trust in what has been represented to them.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">35.</span>&nbsp;Consequently, while the basis of the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>in private law is a promise made between two parties, the basis of the doctrine of legitimate expectation in public law is premised on the principles of fairness and non-arbitrariness surrounding the conduct of public authorities. This is not to suggest that the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>has no application in circumstances when a State entity has entered into a private contract with another private party. Rather, in English law, it is inapplicable in circumstances when the State has made representation to a private party, in furtherance of its&nbsp;<em style=\"box-sizing: inherit;\">public functions</em><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark25\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">26</span></a>.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">H.5&nbsp; Indian Law and the doctrine of legitimate expectations</span>.<br><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">36.</span>Under Indian Law, there is often a conflation between the doctrines of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel&nbsp;</em>and legitimate expectation. This has been described in Jain and Jain’s well known treatise,&nbsp;<em style=\"box-sizing: inherit;\">Principles of Administrative Law</em><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark26\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><em style=\"box-sizing: inherit;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">27</span></em></a>:&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">“At times, the expressions ‘legitimate expectation’ and ‘promissory estoppel’ are used interchangeably, but that is&nbsp; not a correct usage because ‘legitimate expectation’ is a concept much broader in scope than ‘promissory estoppel’.A reading of the relevant Indian cases, however, exhibit some confusion of ideas. It seems that the judicial thinking has not as yet crystallised as regards the nature and scope of the doctrine. At times, it has been referred to as merely a procedural doctrine; at times, it has been treated interchangeably as promissory estoppel. However both these ideas are incorrect. As stated above, legitimate expectation is a substantive doctrine as well and has much broader scope than promissory estoppel.<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">In Punjab Communications Ltd. v. Union of India, the Supreme Court has observed in relation to the doctrine of legitimate expectation:<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“the doctrine of legitimate expectation in the substantive sense has been accepted as part of our law and that the decision maker can normally be compelled to give effect to his representation in regard to the expectation based on previous practice or past conduct unless some overriding public interest comes in the way Reliance must have been placed on the said representation and the representee must have thereby suffered detriment.”<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">It is suggested that this formulation of the doctrine of legitimate expectation is not correct as it makes “legitimate expectation” practically synonymous with promissory estoppel. Legitimate expectation may arise from conduct of the authority; a promise is not always necessary for the purpose.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">37.</span>&nbsp;While this doctrinal confusion has the unfortunate consequence of making the law unclear, citizens have been the victims. Representations by public authorities need to be held to scrupulous standards, since citizens continue to&nbsp; live their lives based on the trust they repose in the State. In the commercial world also, certainty and consistency are essential to planning the affairs of business. When public authorities fail to adhere to their representations without providing an adequate reason to the citizens for this failure, it violates the trust reposed by citizens in the State. The generation of a business friendly climate for investment and trade is conditioned by the faith which can be reposed in government to fulfil the expectations which it generates. Professors Jain and Deshpande characterize the consequences of this doctrinal confusion in the following terms:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“Thus, in India, the characterization of legitimate expectations is on a weaker footing, than in jurisdictions like UK where the courts are now willing to recognize the capacity of public law to absorb the moral values underlying the notion of estoppel in the light of the evolution of doctrines like LE [Legitimate Expectations] and abuse of power. If the Supreme Court of India has shown its creativity in transforming the notion of promissory estoppel from the limitations of private law, then it does not stand to reason as to why it should also not articulate and evolve the doctrine of LE for judicial review of resilement of administrative authorities from policies and long- standing practices. If such a notion of LE is adopted, then not only would the Court be able to do away with the artificial hierarchy between promissory estoppel and legitimate expectation, but, it would also be able to hold the administrative authorities to account on the footing of public law outside the zone of promises on a stronger and principled anvil. Presently, in the absence of a like doctrine to that of promissory estoppel outside the promissory zone, the administrative law adjudication of resilement of policies stands on a shaky public law foundation.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">38.&nbsp;</span>We shall therefore attempt to provide a cogent basis for the doctrine of legitimate expectation, which is not merely grounded on analogy with the doctrine of&nbsp;<em style=\"box-sizing: inherit;\">promissory estoppel</em>. The need for this doctrine to have an independent existence was articulated by Justice Frankfurter of the United State Supreme Court in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Vitarelli&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Seton</span><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-bottom: 0px;\"><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark27\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\">28<br></a></span><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">‘“An executive agency must be rigorously held to the standards by which it professes its action to be judged. Accordingly, if dismissal from employment is based on a defined procedure, even though generous beyond the requirements that bind such agency, that procedure must be scrupulously observed. This judicially evolved rule of administrative law is now firmly established and, if I may add, rightly so. He that takes the procedural sword shall perish&nbsp; with the sword.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">39.&nbsp;</span>However, before we do this, it is important to clarify the understanding of the doctrine of legitimate expectation in previous judgements of this Court. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">National Buildings Construction Corporation&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">S. Raghunathan</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark28\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">29</span>&nbsp;</a>(“<span style=\"box-sizing: inherit; font-weight: bolder;\">National</span>&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">Buildings Construction Corpn.</span>”), a three Judge bench of this Court, speaking through Justice S. Saghir Ahmad, held that:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“18. The doctrine of “legitimate expectation” has its genesis in the field of administrative law. The Government and its departments, in administering the affairs of the country, are expected to honour their statements of policy or intention and treat the citizens with full personal consideration without any iota of abuse of discretion. The policy statements cannot be disregarded unfairly or applied selectively. Unfairness in the form of unreasonableness is akin to violation of natural justice. It was in this context that the doctrine of “legitimate expectation” was evolved which has today become a source of substantive as well as procedural rights. But claims based on “legitimate expectation” have been held to require reliance on representations and resulting detriment to the claimant in the same way as claims based on promissory estoppel.”</em>.<br>However, it is important to note that this observation was made by this Court while discussing the ambit of the doctrine of legitimate expectation under English Law, as it stood then. As we have discussed earlier, there was a substantial conflation or overlap between the doctrines of legitimate expectation and&nbsp;<em style=\"box-sizing: inherit; margin-top: 0px;\">promissory estoppel&nbsp;</em>even under English Law since the former was often invoked as being analogous to the latter. However, since then and since the judgment of this Court in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">National Buildings Construction Corporation&nbsp;</span>(supra), the English Law in relation to the doctrine of legitimate expectation has evolved. More specifically, it has actively tried to separate the two doctrines and to situate the doctrine of legitimate expectations on a broader footing. In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Regina (Reprotech (Pebsham) Ltd)&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">East Sussex County Council</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark29\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">30</span></a>, the House of Lords has held thus: held thus:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“33&nbsp;&nbsp;&nbsp;In any case, I think that it is unhelpful to introduce private law concepts of estoppel into planning law. As Lord Scarman pointed out in Newbury District Council v Secretary of State for the Environment [1981] AC 578 , 616, estoppels bind individuals on the ground that it would be unconscionable for them to deny what they have represented or agreed. But these concepts of private law should not be extended into “the public law of planning control, which binds everyone”. (See also Dyson J in R v Leicester City Council, Ex p Powergen UK Ltd [2000] JPL 629 , 637.)<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">34.There is of course an analogy between a private law estoppel and the public law concept of a legitimate expectation created by a public authority, the denial of which may amount to an abuse of power… But it is no more than an analogy because remedies against public authorities also have to take into account the interests of the general public which the authority exists to promote. Public law can also&nbsp; take into account the hierarchy of individual rights which exist under the Human Rights Act 1998, so that, for example, the individual’s right to a home is accorded a high degree of protection (see Coughlan’s case, at pp 254–255) while ordinary property rights are in general far more limited by considerations of public interest: see R (Alconbury Developments Ltd) v Secretary of State for the Environment, Transport and the Regions [2001] 2 WLR 1389.<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">35. It is true that in early cases such as the Wells case [1967] 1 WLR 1000 and Lever Finance Ltd v Westminster (City) London Borough Council [1971] 1 QB 222 , Lord Denning MR used the language of estoppel in relation to planning law. At that time the public law concepts of abuse of power and legitimate expectation were very undeveloped and no doubt the analogy of estoppel seemed useful…..It seems to me that in this area, public law has already absorbed whatever is useful from the moral values which underlie the private law concept of estoppel and&nbsp; the time has come for it to stand upon its own two feet.”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">40.&nbsp;</span>In a concurring opinion in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Monnet Ispat and Energy Ltd.&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Union of India</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark30\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">31</span></a>&nbsp;(“<span style=\"box-sizing: inherit; font-weight: bolder;\">Monnet Ispat</span>”), Justice H L Gokhale highlighted the different considerations that underlie the doctrines of&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">promissory estoppel&nbsp;</em>and legitimate expectation. The learned judge held that for the application of the doctrine of promissory estoppel, there&nbsp; has to be&nbsp; a&nbsp; promise, based&nbsp; on&nbsp; which&nbsp; the promisee has acted to its prejudice. In contrast, while applying the doctrine of legitimate expectation, the primary considerations are reasonableness and fairness of the State action. He observed thus<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“Promissory Estoppel and Legitimate Expectations”<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">289. As we have seen earlier, for invoking the principle of promissory estoppel there has to be a promise, and on that basis the party concerned must have acted to its prejudice. In the instant case it was only a proposal, and it was very much made clear that it was to be approved by the Central Government, prior whereto it could not be construed as containing a promise. Besides, equity cannot be used against a statutory provision or notification.<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">290…..In any case, in the absence of any promise, the Appellants including Aadhunik cannot claim promissory estoppel in the teeth of the notifications issued under the relevant statutory powers. Alternatively, the Appellants are trying to make a case under the doctrine of legitimate expectations. The basis of this doctrine is in reasonableness and fairness. However, it can also not be invoked where the decision of the public authority is founded in a provision of law, and is in consonance with public interest.”<br></em>In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">Union of India&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Lt. Col. P.K. Choudhary</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark31\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170);\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">32</span></a>, speaking through Chief Justice T S Thakur, the Court discussed the decision in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Monnet Ispat&nbsp;</span>(supra) and noted its reliance on the judgment in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Attorney General for New South Wales&nbsp;</span>vs.&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Quinn</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark32\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">33</span></a>. It then observed:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“This Court went on to hold that if denial of legitimate expectation in a given case amounts to denial of a right that is guaranteed or is arbitrary, discriminatory, unfair or biased, gross abuse of power or in violation of principles of natural justice, the same can be questioned on the well-known grounds attracting Article 14 of the Constitution but a claim based on mere legitimate expectation without anything more cannot ipso facto give a right to invoke these principles.”<br></em>Thus, the Court held that the doctrine of legitimate expectation cannot be claimed as a right in itself, but can be used only when the denial of a legitimate expectation leads to the violation of Article 14 of the Constitution.<br>42. As regards the relationship between Article 14 and the doctrine of legitimate expectation, a three judge Bench in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">Food Corporation of India&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Kamdhenu Cattle Feed Industries</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark33\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">34</span></a>, speaking through Justice J S Verma, held thus:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“7. In contractual sphere as in all other State actions, the State and all its instrumentalities have to conform to Article 14 of the Constitution of which non-arbitrariness is a significant facet. There is no unfettered discretion in public law: A public authority possesses powers only to use them for public good. This imposes the duty to act fairly and to adopt a procedure which is ‘fairplay in action’. Due observance of this obligation as a part of good administration raises a reasonable or legitimate expectation in every citizen to be treated&nbsp; fairly in his interaction with the State and its instrumentalities, with this element forming a necessary component of the decision- making process in all State actions. To satisfy this requirement of non-arbitrariness in a State action, it is, therefore, necessary to consider and give due weight to the reasonable or legitimate expectations of the persons likely to be affected by the decision or else that unfairness in the exercise of the power may amount to an abuse or excess of power apart from affecting the bona fides of the decision in a given case. The decision so made would be exposed to challenge on the ground of arbitrariness. Rule of law does not completely eliminate discretion in the exercise of power, as it is unrealistic, but provides for control of its exercise by judicial review.<br></em><em style=\"box-sizing: inherit; margin-top: 0px;\">8. The mere reasonable or legitimate expectation of a citizen, in such a situation, may not by itself be a distinct enforceable right, but failure to consider and give due weight to it may render the decision arbitrary, and this is how the requirement of due consideration of a legitimate expectation forms part of the principle of non-arbitrariness, a necessary concomitant of the rule of law. Every legitimate expectation is a relevant factor requiring due consideration in a fair decision-making process. Whether the expectation of the claimant is reasonable or legitimate in the context is a question of fact in</em>&nbsp;each case.&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">Whenever the question arises, it is to be determined not according to the claimant’s perception but in larger public interest wherein other more important considerations may outweigh what would otherwise have been the legitimate expectation of the claimant. A bona fide decision of the public authority reached in this manner would satisfy the requirement of non-arbitrariness and withstand judicial scrutiny. The doctrine of legitimate expectation gets assimilated in the rule of law and operates in our legal system in this manner and to this extent.”<br></em>More recently, in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px;\">NOIDA Entrepreneurs Assn.&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">NOIDA</span><a href=\"https://dakshalegal.home.blog/2020/12/01/from-estoppel-to-expectations-supreme-court-dissects-doctrines-of-promissory-estoppel-and-legitimate-expectation/?fbclid=IwAR0yP2rUXJO6u0uwh22KGFDY5Ntrlh_XZ1Jzmm1c7g_4b-pKRlZl_C7Vnek#_bookmark34\" style=\"box-sizing: inherit; text-decoration-line: underline; transition: color 0.11s ease-in-out 0s; color: rgb(0, 115, 170); margin-bottom: 0px;\"><span style=\"box-sizing: inherit; font-size: 18.5625px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em;\">35</span></a>, a two-judge bench of this Court, speaking through Justice B. S. Chauhan, elaborated on this relationship in the following terms:<br><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">“39. State actions are required to be non-arbitrary and justified on the touchstone of Article 14 of the Constitution. Action of the State or its instrumentality must be in conformity with some principle which meets the test of reason and relevance. Functioning of a “democratic form of Government demands equality and absence of arbitrariness and discrimination”. The rule of law prohibits arbitrary action and commands the authority concerned to act in accordance with law. Every action of the State or its instrumentalities should neither be suggestive of discrimination, nor even apparently give an impression of bias, favouritism and nepotism. If a decision is taken without any principle or without any rule, it is unpredictable and such a decision is antithesis to the decision taken in accordance with the rule of law.<br></em><em style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px;\">41. Power vested by the State in a public authority should be viewed as a trust coupled with duty to be exercised in larger public and social interest. Power is to be exercised strictly adhering to the statutory provisions and fact situation of a case. “Public authorities cannot play fast and loose with the powers vested in them.” A decision taken in an arbitrary manner contradicts the principle of legitimate expectation. An authority is under a legal obligation to exercise the power reasonably and in good faith to effectuate the purpose for which power stood conferred. In this context, “in good faith” means “for legitimate reasons”. It must be exercised bona fide for the purpose and for none other…]”<br></em><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\">As such, we can see that the doctrine of substantive legitimate expectation is one of the ways in which the guarantee of non-arbitrariness enshrined under Article 14 finds concrete expression.<br></span><span style=\"box-sizing: inherit; font-weight: bolder; margin-top: 0px; margin-bottom: 0px;\"><em style=\"box-sizing: inherit;\">Compiled by S. Basavaraj, Advocate, Daksha Legal, Bengaluru</em>.<br></span><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">16</span>&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">Wyvern Development, Re</span>, [1974] 1 W.L.R. 1097 cited in Susan M. Morgan, “A Comparative Analysis of the Doctrine of Promissory Estoppel in Australia, Great Britain and the United States”, (1985) 15 Melbourne University Law Review 134, 139-141.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">17</span>&nbsp;In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Tungsten Electric Co Ltd.&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">Tool Metal Manufacturing Co. Ltd.,&nbsp;</span>[1955] 1 W.L.R. 761, Lord Simonds states, “I do not wish to lend the authority of this House to the statement of the principle which is to be found in Combe v. Combe and may well be far too widely stated”.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">18</span>&nbsp;In&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Baird Textiles Holdings Ltd.&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">Marks and Spencer Plc.</span>, [2002] 1 All ER (Comm) 737, Court of Appeal stated that “there is no real prospect of the claim [estoppel] succeeding unless and until law is developed, or corrected, by the House of Lords”.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">19</span>&nbsp;American Law Institute,&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">Restatement of the Law (2d), Contracts&nbsp;</em>(1981), para 90.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px; margin-bottom: 0px;\">23</span>&nbsp;Rebecca Williams, “The Multiple Doctrines of Legitimate Expectations”, (2016) 132(Oct) Law Quarterly Review 639, 645.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">24</span>&nbsp;<em style=\"box-sizing: inherit; margin-bottom: 0px;\">Supra&nbsp;</em>note 19 at para 4-095.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px; margin-bottom: 0px;\">26</span>&nbsp;Nicholas Bamforth, “Legitimate Expectation and Estoppel” (1998) 3 Jud Rev 196.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">27</span>&nbsp;M.P. Jain and S.N. Jain,&nbsp;<em style=\"box-sizing: inherit;\">Principles of Administrative Law&nbsp;</em>(7<span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-bottom: 0px;\">th</span>&nbsp;edn., EBC 2013).<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px;\">28</span>&nbsp;359 US 535 (1959); the principle espoused in this judgment has been followed by this Court in&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Amarjit Singh Ahluwalia (Dr)&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">State of Punjab</span>, (1975) 3 SCC 503,&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Sukhdev Singh&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Bhagatram Sardar Singh Raghuvanshi</span>, (1975) 1 SCC 421 (concurring opinion of Justice K K Mathew) and&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder;\">Ramana Dayaram Shetty&nbsp;</span>vs&nbsp;<span style=\"box-sizing: inherit; font-weight: bolder; margin-bottom: 0px;\">International Airport Authority of India</span>, (1979) 3 SCC 489.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px; margin-bottom: 0px;\">29</span>&nbsp;(1998) 7 SCC 66.<br><span style=\"box-sizing: inherit; font-size: 14.6667px; line-height: 0; position: relative; vertical-align: baseline; top: -0.5em; margin-top: 0px; margin-bottom: 0px;\">30</span>&nbsp;[2003] 1 WLR 348.<br>32 (2016) 4 SCC 236.<br>35. (2011) 6 SCC 508.</h1><div id=\"wordads-preview-parent\" class=\"wpcnt\" style=\"box-sizing: inherit; text-align: center; line-height: 0; margin: 32px auto; max-width: calc(66.6667vw - 28px); color: rgb(30, 30, 30); font-family: &quot;Crimson Text&quot;, &quot;Baskerville Old Face&quot;, Garamond, &quot;Times New Roman&quot;, serif; font-size: 22px; background-color: rgb(255, 255, 255);\"><div class=\"wpa\" style=\"box-sizing: inherit; position: relative; max-width: 100%; text-align: left; transform: translate3d(0px, 0px, 0px); display: inline-block !important; margin-top: 0px; margin-bottom: 0px;\"></div></div>', '046687f4771490662041f9531a55220f.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '', 1, '', '', '2020-12-02 02:44:18', '2020-12-21 09:16:26');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(20, 'WmMVkvC5Khl0ru9Ihp7uCrqpp', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Marriage Act', 'Cruelty (2015) 8 SCC 336. Hindu Marriage Act. \"Cruelty\". Wife abusing husband, calling him son of a prostitute etc are not normal acts. Cruelty established. Divorce granted.', '6d0c06c99289eaec526e6a8035e91929.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:20:44', '2020-12-22 20:17:50'),
(21, 'scVD4yRDdzg6Vu71AB58tJ7XL', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Trial. Data gathered from smartphone or email account does NOT ipso facto prove the guilt of the accused. The data has to be proved during the course of the trial. Karnataka High Court. 12 March 2021. ', '<h4>Criminal Trial. Data gathered from smartphone or email account does NOT ipso facto prove the guilt of the accused. The data has to be proved during the course of the trial. Karnataka High Court. 12 March 2021. Please click the following link to read the main post.&nbsp;&nbsp;</h4><h4><br><a href=\"https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0\" target=\"_blank\">https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0</a></h4>', '4b515a6d001ee56ba39def66b5585154.PNG', '6691d030c469643cb1aee0a5306ead5c.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2020-12-02 18:21:37', '2021-03-14 18:01:33'),
(22, 'XT3fHhbkiCtJg9FpF9EoLKWXi', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Decree challenged on the ground of fraud', 'Evidence required to set aside a decree on the ground of fraud. When can a decree be set aside on the ground of fraud on Court. In this case fraud on court not established. (2015) 4 SCC 196', '0db7477d330327c60533effff5becbd2.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:23:24', '2020-12-22 20:17:13'),
(23, 'lMroKyHO1AG6balkQlJqz2Loa', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Constitution of India. State within the meaning of Article 12', 'State\" meaning explained. Writ maintainable against an authority only if the nature & extent of duty imposed on it is public in nature.  Even then, all its decisions are not amenable to writ jurisdiction. Only those having public element therein can be judicially reviewed. (2015) 4 SCC 670', '6646a81236a7ca3b629feffcfca66680.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:24:37', '2020-12-22 20:16:55'),
(24, 'F5RWzo7EpkodmGQC5O0p0cQPB', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Specific Relief Act, 1963 - Section 28(1) - Rescission of Contract - Parameters - Sale Agreement annulled at execution stage', '<div><b>T.L. Rajagopal v. S.N. Shivakumar, 2014 SCC OnLine Kar 10072 : ILR 2014 KAR 4035 : (2014) 3 KCCR 2182 : (2014) 4 AIR Kant R 701 : (2014) 6 Kant LJ 423 : (2014) 4 ICC 275 : AIR 2015 (NOC 433) 160, at page 4052 :</b></div><div><br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">Decree for specific performance being in the nature of a preliminary decree, the Court after passing of the said decree does not become functus officio. It retains the jurisdiction to conclude the further steps to be taken in the suit. The decree holder chooses to file an execution&nbsp; petition for getting the sale deed registered through the Court when the defendant who suffered the decree fails to obey the same. Though called ‘execution proceedings’, it is nothing but continuation of the original suit. In a suit for partition, after the preliminary decree is passed, to give effect to the preliminary decree, it is necessary to initiate final decree proceedings. But in a suit for specific performance it is called as ‘execution proceedings’. Thus when the Court that passed the decree for specific performance and the Court executing the said decree are one and the same, Section 28 of the Act gives equal opportunity to the parties to the suit. If the plaintiff/decree holder for any reason is unable to deposit the balance sale consideration, he is given a right to apply to the Court that passed the decree seeking extension of time to deposit the money and the Court is vested with the power to grant such extension. At the same time when the plaintiff commits default in making payment, a right is conferred upon the defendant/judgment debtor to approach the Court under Section 28 of the Act seeking rescission of the contract. Here again the Court has the discretion to rescind the contract notwithstanding the fact that the decree has attained finality.</span></div></div><div style=\"text-align: justify;\">KUMAR, J.:— This writ petition is preferred by the defendant/judgment debtor challenging the order passed by the Executing Court dismissing his application under Section 28(1) of the Specific Relief Act, 1963 (Hereinafter referred to as ‘The Act’ for short).</div><div style=\"text-align: justify;\">2. For the purpose of convenience, the parties are referred as per their original rank in the suit.</div><div style=\"text-align: justify;\">3. The plaintiff filed a suit for a decree of specific performance of the agreement of sale dated 16.08.1997 against the defendant alleging that the defendant had agreed to sell the schedule property in his favour for Rs. 4,60,000/-. Under the said agreement a sum of Rs. 1,75,000/- was paid as advance by him. The balance sale consideration of Rs. 2,85,000/- had to be paid at the time of registration of the sale deed. He was constrained to file the suit when the defendant failed to execute the sale deed in his favour as agreed. Though duly served with the suit summons, the defendant did not contest the suit&nbsp; and therefore, the decree came to be passed on 26.03.2003 directing the defendant to receive the balance sale consideration from the plaintiff and to execute the registered sale deed failing which he was reserved the liberty of taking steps to get the sale deed executed and registered through the Court Commissioner by depositing the balance sale consideration amount after the appeal time is over.</div><div style=\"text-align: justify;\">4. After the decree, the plaintiff issued a notice to the defendant expressing his readiness to pay the balance sale consideration and called upon the defendant to receive the consideration and execute the sale deed. The defendant did not oblige. Therefore, the plaintiff filed Ex. No. 34/2003 to execute the decree.</div><div style=\"text-align: justify;\">5. The record shows that the judgment debtor/defendant, to stall the execution proceedings not only filed an application under Order XXI Rule 97 of CPC but also got filed another application under the same provision through his daughter-in-law. However these applications came to be dismissed by the Executing Court. Thereafter, the defendant/judgment Debtor filed I.A. 7 under Section 28 of the Act on 08.03.2011 for rescission of the contract and dismissal of the execution petition.</div><div style=\"text-align: justify;\">6. It is the defendant/judgment debtor’s case that the suit came to be decreed exparte on 26.03.2003 and the time to file an appeal&nbsp; against the exparte decree expired on 25.04.2003. The decree is silent as to the outer limit within which the plaintiff should deposit the balance sale consideration from 25.04.2003 and therefore the exparte decree passed in favour of the plaintiff/decree holder is a nullity being contrary to the provisions of Section 28 of the Act. Further the decree holder has not deposited the balance amount till date and therefore, the alleged contract of sale agreement needs to be rescinded and cancelled in the interest of justice and equity. The decree is not executable. The plaintiff/decree holder filed objections to I.A. 7 and sought its dismissal contending that since the defendant/Judgment Debtor failed to comply with the decree, he initiated the execution proceedings well in time and the question of depositing the amount would arise only at the time of the execution of the registered sale deed.</div><div style=\"text-align: justify;\">7. The executing Court, after considering the rival contentions and taking note of the decisions relied on by the parties, has dismissed the I.A. holding that no time limit is prescribed in the decree for depositing the balance sale consideration, by the plaintiff. After passing of the decree, the decree holder has filed the execution case only after issuing notice to the judgment debtor stating that he is ready with the balance sale consideration. The defendant did not reply to the notice nor came forward to comply with the decree. Nor has the judgment debtor filed any appeal against the exparte judgment and decree. On the other hand, he got an application filed through his son seeking&nbsp; stay of the further proceedings in the execution petition and another application through one Parvathi under Order XXI Rule 97 of CPC to stall the execution of the proceedings. The Decree holder in fact has deposited the balance sale consideration in the Court on 14.07.2011. The judgment debtor has not come to the Court with clean hands and therefore he is not entitled to the discretionary relief.</div><div style=\"text-align: justify;\">8. The present writ petition is filed against the above order passed by the executing Court.</div><div style=\"text-align: justify;\">9. Learned Counsel for the defendant/judgment Debtor assailing the impugned order argued that, under the terms of the decree, the plaintiff was expected to deposit the balance sale consideration after expiration of the time prescribed for filing an appeal and therefore, the executing Court could not have held that no time is fixed for payment of the sale consideration. Secondly, it was argued that even after filing of the execution petition, balance sale consideration was not deposited and it was deposited only after the Judgment debtor filed I.A. 7 under Section 28 of the Act. The plaintiff/decree holder had not even filed an application seeking extension of time to deposit the balance sale consideration. The decree is dated 26.03.2003 and the balance sale consideration is deposited nearly 8 years thereafter i.e., on 14.07.2011. In view of these circumstances, it was urged that the agreement entered&nbsp; into by the parties is to be rescinded in terms of Section 28 of the Act and execution petition be dismissed.</div><div style=\"text-align: justify;\">&nbsp;:&nbsp;</div><div style=\"text-align: justify;\">10. Per contra, Learned Counsel for the plaintiff/decree holder arguing in support of the impugned order submitted that, as no time is fixed in the decree, the decree holder, after passing of the decree, issued notice expressing his readiness and willingness to pay the balance sale consideration and obtain the sale deed. When this request was not acceded to, the decree holder was constrained to file the execution petition within five months, which conduct clearly demonstrates that, he was ready to perform his part of the contract. The execution petition was stalled by the judgment debtor by filing applications after applications through his daughter-in-law as well as the son for which the decree holder cannot be blamed. In fact, the decree holder has deposited the amount on 14.07.2011. I.A. 7 is not maintainable on the execution side and it ought to have been filed in the original suit itself as is clear from the provisions of Section 28 of the Act.</div><div style=\"text-align: justify;\">11. In the light of the aforesaid facts and rival contentions, the points that arise for my consideration in this writ petition are as under:—</div><div style=\"text-align: justify;\">1. Whether an application U/s. 28 of the Act is maintainable on the original side or in the execution&nbsp; proceedings initiated by the decree holder to execute the decree?</div><div style=\"text-align: justify;\">2. Whether the Judgment debtor has made out a case for rescission of the contract as provided U/s. 28 of the Act?</div><div style=\"text-align: justify;\">12. In order to answer the above questions, it is necessary to have a look at Section 28 of the Act which deals with rescission of contracts for sale or lease of immovable property in certain circumstances when already specific performance has been decreed by the Court. The said provision reads thus:—</div><div style=\"text-align: justify;\">“28. Rescission in certain circumstances of contracts for the sale or lease of immovable property, the specific performance of which has been decreed. — (1) Where in any suit a decree for specific performance of a contract for the sale or lease of immovable property has been made and the purchaser or lessee does not, within the period allowed by the decree or such further period as the court may allow, pay the purchase money or other sum which the court has ordered him to pay, the vendor or lessor may apply in the same suit&nbsp; in which the decree is made, to have the contract rescinded and on such application the court may, by order, rescind the contract either so far as regards the party in default or altogether, as the justice of the case may require.</div><div style=\"text-align: justify;\">(2) Where a contract is rescinded under subsection (1), the court:—</div><div style=\"text-align: justify;\">(a) shall direct the purchaser or the lessee, if he has obtained possession of the property under the contract, to restore such possession to the vendor or lessor, and</div><div style=\"text-align: justify;\">(b) may direct payment to the vendor or lessor of all the rents and profits which have accrued in respect of the property from the date on which possession was so obtained by the purchaser or lessee until restoration of possession to the vendor or lessor, and if the justice of the case so requires, the refund of any sum paid by the vendee or lessee as earnest money or deposit in connection with the contract.</div><div style=\"text-align: justify;\">&nbsp;(3) If the purchaser or lessee pays the purchase money or other sum which he is ordered to pay under the decree within the period referred to in sub-section (I), the court may, on application made in the same suit, award the purchaser or lessee such further relief as he may be entitled to, including in appropriate cases all or any of the following reliefs, namely:</div><div style=\"text-align: justify;\">(a) the execution of a proper conveyance or lease by the vendor or lessor;</div><div style=\"text-align: justify;\">(b) the delivery of possession, or partition and separate possession, of the property on the execution of such conveyance or lease.</div><div style=\"text-align: justify;\">(4) No separate suit in respect of any relief which may be claimed under this section shall lie at the instance of a vendor, purchaser, lessor or lessee, as the case may be.</div><div style=\"text-align: justify;\">(5) The costs of any proceedings under this section shall be in the discretion of the court.”</div><div style=\"text-align: justify;\">&nbsp;13. Therefore, to invoke the above provision, the person who has obtained a decree for specific performance ought to have failed to pay the money or other sum which the Court has ordered him to pay, within the period allowed by the decree or such further period as the Court may allow. In such an event the person who has suffered the decree has a right to apply to the Court in the same suit in which the decree was passed to have the contract rescinded. On such an application being made, the Court may by order rescind the contract either so far as regards the party in default or altogether, as the justice of the case may require. Once such an order for rescission of contract is made, the Court shall direct the purchaser or the lessee, if, he has obtained the possession of the property under the contract, to restore such possession to the vendor or lessor and also may direct payment to the vendor or lessor to pay the rents and profits which have accrued in respect of the property from the date on which the possession was obtained by the purchaser or lessee until restoration of possession to any vendor or lessor, and if the justice of the case so requires, the refund of any sum paid by the vendee or lessee or earnest money or deposit in connection with the contract.</div><div style=\"text-align: justify;\">14. The question whether an application under Section 28 of the Act is to be made in the same suit in which the decree is passed, has been the subject matter of interpretation by various High Courts&nbsp; in the country. In view of divergent opinion expressed by various High Courts, the Apex Court had an occasion to consider the same in the case of Ramankutty v. Avara1 where in para 6 it is held as under.</div><div style=\"text-align: justify;\">“6. The question then emerges is whether it should be on the original side or execution side. Section indicates that it should be “in the same suit”. It would obviously mean in the suit itself and not in the execution proceedings. It is equally settled law that after passing the decree for specific performance, the Court does not cease to have any jurisdiction. The court retains control over the decree even after the decree has been passed. It was open to the court to exercise the power under Section 28(1) of the Act either for extension of time or for rescinding the contract as claimed for. Since the execution application has been filed in the same court in which the original suit was filed, namely, the court of first instance, instead of treating the application on the execution side, it should have as well been numbered as an interlocutory application on the original side and disposed of according to law. In this view, we feel&nbsp; that the Andhra Pradesh High Court is not correct. The High Court, therefore, is not right in dismissing the application treating of transferring it on the original side for dealing with it according to law.”</div><div style=\"text-align: justify;\">15. The Apex Court in the case of V.S. Plalanichamy Chettiar Firm v. C. Alagappan2 has reiterated above position of law in para 16 of the judgment:</div><div style=\"text-align: justify;\">“16. In view of the decision of this Court in Ramankutty Guptan’s case (1994) AIR SCW 1533) when the trial Court and the executing Court are same, executing Court can entertain the application for extension of time though the application is to be treated as one filed in the main suit. On the same analogy, the vendor judgment—holder can also seek rescission of the contract of sale or take up this plea in defence to bar the execution of decree. One of the ground on which the trial Court dismissed the execution application was that the decree holder did not pay the balance of consideration as per the sale agreement and also did not pay within the time stipulated by the Court in the decree.”</div><div style=\"text-align: justify;\">&nbsp;16. Again in the case of Chanda (Dead) through LRs. v. Rattni3. at para 10 the Apex Court has held that:</div><div style=\"text-align: justify;\">“10. The decree for specific performance has been described as a preliminary decree. The power under Section 28 of the Act is discretionary and the Court cannot ordinarily annul the decree once passed by it. Although the power to annul the decree exists yet Section 28 of the Act provides for complete relief to both the parties in terms of the decree. The Court does not cease to have the power to extend the time though the trial Court had earlier directed in the decree that payment of balance price to be made by certain date and on failure suit to stand dismissed. The power exercisable under this Section is discretionary.”</div><div style=\"text-align: justify;\">17. In the light of the ratio laid down in the aforementioned judgments, the law on the point can be said to be fairly settled: A decree for specific performance being in the nature of a preliminary decree, the Court after passing of the said decree does not become functus officio. It retains the jurisdiction to conclude the further steps to be taken in the suit. The decree holder chooses to file an execution&nbsp; petition for getting the sale deed registered through the Court when the defendant who suffered the decree fails to obey the same. Though called ‘execution proceedings’, it is nothing but continuation of the original suit. In a suit for partition, after the preliminary decree is passed, to give effect to the preliminary decree, it is necessary to initiate final decree proceedings. But in a suit for specific performance it is called as ‘execution proceedings’. Thus when the Court that passed the decree for specific performance and the Court executing the said decree are one and the same, Section 28 of the Act gives equal opportunity to the parties to the suit. If the plaintiff/decree holder for any reason is unable to deposit the balance sale consideration, he is given a right to apply to the Court that passed the decree seeking extension of time to deposit the money and the Court is vested with the power to grant such extension. At the same time when the plaintiff commits default in making payment, a right is conferred upon the defendant/judgment debtor to approach the Court under Section 28 of the Act seeking rescission of the contract. Here again the Court has the discretion to rescind the contract notwithstanding the fact that the decree has attained finality.</div><div style=\"text-align: justify;\">18. Specific performance being a discretionary relief, the Court has ample power to do justice between the parties, if anyone of them were to not act in terms of the decree. As such the contention that an application under Section 28 of the Act ought to be filed in the suit and&nbsp; not in execution proceedings cannot be accepted. I.A. 7 filed under Section 28 of the Act by the defendant/judgment debtor in the execution proceedings seeking rescission of contract therefore is perfectly maintainable and it is to be treated as an interlocutory application filed in the suit for specific performance itself.</div><div style=\"text-align: justify;\">19. Admittedly, the defendant/judgment debtor was duly served with the summons in the suit for Specific Performance. He appeared through an Advocate, sought for time but did not file the written statement or participate in the proceedings. Therefore, the suit of the plaintiff/decree holder came to be decreed exparte and the operative portion of judgment of the Trial Court reads as under:—</div><div style=\"text-align: justify;\">“The suit is decreed with costs.</div><div style=\"text-align: justify;\">The defendant is directed to receive balance sale consideration of Rs. 2,85,000-00 from the plaintiff and to execute and register the sale deed in favour of the plaintiff at his costs in pursuance of the sale agreement dated 16.08.1997 with respect to suit property.</div><div style=\"text-align: justify;\">Failure on the part of the defendant to execute the sale deed the plaintiff is at liberty to take steps to get the sale deed executed and registered through the Court Commissioner by depositing the balance sale consideration amount after the appeal time is over.”</div><div style=\"text-align: justify;\">(Underlining by me)</div><div style=\"text-align: justify;\">20. What the plaintiff has to do if the defendant were to not obey the decree passed by the Court is therefore, clearly spelt out in the judgment of the Trial Court. The plaintiff was given the liberty to take steps to get the sale deed executed and registered through the Court by depositing the balance sale consideration after the time prescribed for filing the appeal expired. In other words, the plaintiff had to deposit the balance sale consideration only after expiry of the appeal period.</div><div style=\"text-align: justify;\">21. The judgment and decree was delivered on 26.03.2003 and an appeal against the said decree ought to have been filed within 30 days, but the defendant admittedly has not chosen to file any appeal. After expiry of the appeal period, without depositing the balance consideration in Court, the plaintiff issued a legal notice calling upon the defendant to receive the balance sale consideration and execute the sale deed. The defendant did not reply. Then the execution proceedings came to be initiated. The balance consideration was not deposited either before or along with the execution petition.</div><div style=\"text-align: justify;\">22. The Judgment debtor/defendant entered appearance, in the execution case. Then he filed I.A. 7 under Section 28(1) of the Act seeking rescission of the contract on the ground of non-deposit of the amount in terms of the decree. Thereafter, the balance sale consideration came to be deposited on 14.07.2011 by the decree holder. The plaintiff/decree holder was expected to file an application under Section 28(1) of the Act seeking extension of time to deposit the amount by showing sufficient cause for the lapse on his part. Till date no such application is filed by the plaintiff/decree holder.</div><div style=\"text-align: justify;\">23. If the defendant was at fault, he was not willing to obey the decree, if the plaintiff had deposited the money after the expiry of the appeal period as stipulated in the decree or at least on the day he filed the execution petition, that would have been sufficient to demonstrate his bona fides. The balance sale consideration of Rs. 2,85,000/- had to be deposited on the date of the suit or the date of the decree or at least on the date of filing of the execution petition. But the plaintiff/decree holder appears to have woken up after seeing the averments in I.A. under Section 28 of the Act and made up his mind to deposit the money on 14.07.2011 which is nearly 8 years after the passing of the decree and 14 years from the date of the agreement.</div><div style=\"text-align: justify;\">24. The subject matter of the suit is an immovable property situated in Tiptur Town. The value of the immovable properties situated in towns and cities is multiplying every year. The plaintiff/decree holder&nbsp; who had the benefit of the decree also had the benefit of having Rs. 2,85,000/- with him for 14 long years and did not even seek extension of time to deposit the said amount. Today if the Court were to direct the defendant/judgment debtor to execute the sale deed for a consideration which he should have received 14 years ago, it would cause great hardship and irreparable injury, as the said amount would be of no value at all. In that view of the matter, the contract of sale requires to be rescinded and consequently, the decree for specific performance also requires to be annulled.</div><div style=\"text-align: justify;\">25. Where a contract is rescinded under sub-Section (1) of Section 28 of the Act, if the justice of the case so requires, the Court can as provided under Section 28 (2)(b) of the Act order for refund of any sum paid by the vendee or lessee as earnest money or deposit in connection with the contract. Similarly Section 65 of the Contract Act, 1872 also casts an obligation on the person who has received an advantage under void agreement or contract that becomes void, to restore it or make compensation for it, to the person from whom he received it. Therefore the defendant/judgment debtor shall refund the advantage/earnest money received from the plaintiff/decree holder under the agreement i.e., a sum for Rs. 1,75,000/- together with interest @ 18% p.a. from the date of receipt of amount till the date of payment, if he wants the rescission of the contract.</div><div style=\"text-align: justify;\">26. In the result I pass the following:</div><div style=\"text-align: justify;\">ORDER</div><div style=\"text-align: justify;\">The writ petition is allowed. The impugned order is hereby set-aside and I.A. filed under Section 28 of the Specific Relief Act is allowed.</div><div style=\"text-align: justify;\">The agreement of sale dated 16.08.1997 is rescinded and the decree for specific performance dated 26.03.2003 is annulled subject to the condition that the defendant/judgment debtor shall refund earnest money of Rs. 1,75,000/- received under the agreement to the plaintiff/decree holder with interest @ 18% p.a. from the date of receipt of the said amount till the date of payment, within three months from this day.</div><div style=\"text-align: justify;\">In the event of the defendant/judgment debtor failing to pay the amount to the plaintiff/decree holder or deposit the same in the Court within 3 months from the date of receipt of this order, the order of this Court rescinding the agreement stands vacated and order of the executing Court on I.A. 7 stands restored.</div><div style=\"text-align: justify;\">———</div><div style=\"text-align: justify;\">1. (1994) 2 SCC 642 : AIR 1994 SC 1699</div><div style=\"text-align: justify;\">2. (1999) 4 SCC 702 : AIR 1999 SC 918</div><div style=\"text-align: justify;\">3. (2007) 14 SCC 26 : AIR 2007 SC 1514</div>', '265e9cf3dad3132d4743b748c3bd3400.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:29:15', '2021-01-22 23:26:30'),
(25, 'ZZkplcjO3Sp8U4qXbxWa3jHgU', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code. Section 302. Murder', 'Bride burning. Medical evidence preferred as against oral. Dying declaration believed. Plea of alibi discarded. \"A man will not meet his Maker with a lie in his mouth\" \"Truth sits on the lips of a dying man\" Reiterated (2015) 4 SCC 749', '571456bb5b5d9e2f2b8bdc9b3eada237.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:34:42', '2020-12-22 20:16:20'),
(26, 'KPGWvqklqjd3x31UluDFqygGp', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code. Section 302. Bride burning. When guilt is established, maximum penalty to be imposed', '<div>Inebriation when relevant. Accused knowing full well the consequences, not a mitigating factor. Subsequent act of pouring water is by guilt. Doesn\'t mitigate the crime. (2015) 7 SCC 641</div>', '900cc7e3efddc9dee300804ff782b852.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:37:30', '2020-12-22 20:16:04'),
(27, 'iMNx2dtTygBBnxZn7TGHQxu8Q', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Transfer of Property Act Suit for ejection', 'Notice asking the tenant to vacate immediately but suit filed after 6 months from the date of notice. Notice is valid & suit maintainable. (2015) 5 SCC 539 -', '1bb1e0d18059e9acc8d0d25c3bf97d90.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:41:20', '2020-12-22 20:15:46'),
(28, 'DKpK49L8dyJXEKtKrGSTThxLK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Specific Relief Act', 'Suit for specific performance. Prayer for possession not made. Court can not grant relief of possession unless prayer for delivery of possession is specifically sought or is present by necessary implication from nature of relief prayed for.  (2015) 8 SCC 219.', 'ec1b20d0a67ee544461b832e7c0f7691.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:42:35', '2020-12-22 20:15:29'),
(29, 'xvaFbB6llYKtS865XdBlBcw1W', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Constitution of India Article 226.', '<p>http://dakshalegal.com/beta/uploads/judgements/e9753bfa94d37da8eacccc991589bd80.jpghttp://dakshalegal.com/beta/uploads/judgements/e9753bfa94d37da8eacccc991589bd80.jpg<br>Writ Petition. Prayer. Relief not sought for in prayer part, but deductible from body of writ petition on basis of grounds &amp; averments made. Writ maintainable. (2015) 7 SCC 728.</p>', 'e9753bfa94d37da8eacccc991589bd80.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:43:07', '2021-01-22 23:06:22'),
(30, 'LOITqhPcjDIS8yv2EQsYombeV', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure . Section 357', 'Compensation to victims of crime. Apart from sentence & fine, compensation to be paid by accused. Reduction of sentence by High Court - not justified (2015) 5 SCC 197', '1a0fc3bee9ef82ecabbd729372882ef3.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:44:13', '2020-12-22 20:14:56'),
(31, 'U10UDITJ8M0xsr43afVpT1cLW', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code- Order 23', 'Power of counsel to enter into compromise. Principles summarised. It depends on authority conferred in vakalatnama on counsel and instructions given by client from time to time. Care & caution to be exercised by counsel. Govt advocates\' power to compromise. (2015) 5 SCC 747', '376668a2fea862aed3dd212af6499cf1.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:45:21', '2020-12-22 20:14:37'),
(32, 'oCrXRrXE867gBc5qsX9N0ygcl', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure Section 482', 'Quashing of Criminal cases. Non payment of consultancy fees to the complainant can only amount to a civil wrong. No case under Section 420 IPC made out. Proceedings quashed. Fraudulent/dishonest intention from the inception has to be proved to constitute fraud (2015) 8 SCC 293.', '3059bf56009924a99f1034fdf8af6f31.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:45:51', '2020-12-22 20:14:19'),
(33, '0yQjezBF4WUSf5jQhKsvGxQ1J', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure Section 156(3)', 'All applications under Section 156(3) seeking direction for FIR registration must be supported by an affidavit. Also see: How this man abused the process of criminal law to the hilt. (2015) 6 SCC 287.', '74e1b990123eccff0d4ef2d126de2eb7.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:46:28', '2020-12-22 20:14:00'),
(34, '170fCAl2NMclFJ6tnuKDkoU6f', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code- Amendment of CPC by Commercial Courts Act, 2015', 'The same does not apply to non-commercial suits. Filing of written statement is governed by the earlier provision only.?? Desh Raj vs Balkishan (2020) 2 SCC 708  ·', 'de4642849abf76af5871aef700f7704a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:47:20', '2020-12-22 20:13:38'),
(35, 'XZxtX64JCjweiFvCGuzbZa6pu', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Death Warrant', 'Issuance of death warrants without allowing the convicts to exhaust all legal remedies. Violative of Article 21 of the Constitution of India. Human dignity affected in such a scenario. (2015) 6 SCC 702.   ·', 'ad2eb79dd43198f5f1d41a3624cc4f04.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 18:49:02', '2020-12-22 20:13:20'),
(37, '0oTbUJiX6Dh5P2rzBHMxYpxSS', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Procedure Code. Investigation', 'Superior officer cannot meet the accused without the presence of the investigating officer. Investigations must not only be fair but must appear to have been conducted in a fair manner.  (2015) 6 SCC 332.', '0b97460252ce76c7cceffd1d30843601.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:06:00', '2020-12-22 20:12:42'),
(38, 'b7nqPsRhKvIk7lOQdsxCfsQTd', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Trial. Test Identification Parade. ', 'The evidence is not substantive evidence. Conviction cannot be based solely on the identity of the accused by the witnesses in the test identification parade. (2015) 6 SCC 623.', 'fc8079ca9a11ba623a8a19a2c2df0588.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:06:26', '2020-12-22 20:12:22'),
(39, 'cacVorBcStCeMctfqeco5z9g1', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code Dowry death', 'Conviction ordered purely on circumstantial evidence. Law on circumstantial evidence discussed  (2015) 4 SCC 281-', '92e0cb014d23000ed474db69195c7fb6.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:07:30', '2020-12-22 20:12:03'),
(40, 'qJmLB5tPnZ2L5FwMDmSGl3VLl', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Service Law Recruitment', 'Once the procedure of selection starts, there cannot be any amendment of procedural law regarding reservation in the matter of selection to posts, with retrospective effect.  · (2015) 8 SCC 410.', '6161fbde1d461991159a5fdff0240858.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:08:09', '2020-12-22 20:11:47'),
(41, 'BHjB9WgUAJhuTTAvlVi7argoo', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Service Law. Suspension', 'Prolonged suspension of an employee & renewal strongly deprecated. Suspension cannot exceed three months if within this period charge sheet is not served on the employee. If served within 3 months, reasoned order must be passed for extension of suspension. (2015) 7 SCC 291', '970797844d1ffe06f1704d83d4d56c07.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:10:22', '2020-12-22 20:11:31'),
(42, 'Ycarf6mvMF6gCVNGhYPoWgYjJ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Contract Act, 1892. Novation of contracts', 'Has to be on fulfilment of all procedural requirements. (2015) 7 SCC 728', '276c130b4369a3691518b019e8a00949.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:10:52', '2020-12-22 20:11:11'),
(43, '1fPSStZMe5BDhNr3vtIMd07B0', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Prevention of Corruption Act.', 'Ingredients. Demand & acceptance necessary. IMP: Reduction of sentence. Accused aged 74 years. Offence took place 19 years ago. Undergone mental agony. Sentence reduced from four years to to one year. (2015) 8 SCC 395.', 'acff03d1fcd96fbe3659e9793c6d568c.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:11:22', '2020-12-22 20:10:51'),
(44, 'uQPAeb3torOgLABcDdIcxS78u', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Law. Conversion', 'From Scheduled Caste to Christianity &amp; re-conversion from Christianity to Hindu religion. In such an event, Scheduled Caste is restored.&nbsp; <br><br><b>Conditions: <br></b>1. Clear cut proof that he belong to Scheduled caste <br>2. Reconversion to original religion to which parents belonged. <br>3. Acceptance by community. (2015) 4 SCC 1', '4073932d1973dded781418cf04cd9d30.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:11:53', '2021-01-22 22:45:12'),
(45, 'ddtBcLSKgDRX7tIhM6x8IdOWm', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Negotiable Instruments Act. Section 138', 'Cheque bounce case. Pro forma date on Cheque leaf of the year 1999 but transaction of the year 2007. Not fatal to complainant\'s case. Defence that the Cheque was issued in 1999 as security & was used by the Complainant in 2007 though loan was repaid not accepted. (2015) 8 SCC 378.', 'b9965eb239ebbc16a8d607d298e6d297.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:12:31', '2020-12-22 20:10:15'),
(46, 'Vq5BFWv7q0Ki0HRw3nbStnUp3', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Negotiable Instruments Act. Section 138 ', '1. Person who draws Cheque on his account alone is liable.&nbsp; <br>2. Offence by Company. If the accused is the Managing Director, no need to make averments that he was the person in charge of the affairs of the company.&nbsp; <br>3. Compensation. Twice the amount of Cheque awarded with 9% interest in this case. (2015) 9 SCC 622.', '2a227456099ee9bc6571cf7c291c0e8c.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:13:16', '2021-01-22 22:43:19'),
(47, 'XeKbua2ghdw12YGcs25drDTxF', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Specific Relief Act. Suit for declaration', 'Once the court declares the ownership, it has to necessarily decide the question of possession & removal of encroachment, demolition etc.  (2015) 5 SCC 661 -', '1478ea1dc72846f93c2409af36a5fb1c.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:13:54', '2020-12-22 20:09:37'),
(48, 'CXXMYTLuZsQrq6jiakSqxbswK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code Sections 306 & 498-A ', 'Cruelty, torture and harassment for dowry proved. However case of death was accidental even as per the dying declaration of the victim. Mother-in-law and sister-in-law acquitted under 306, IPC (abetment to commit suicide). However convicted under Section 498-A, IPC.(Husband or relative of husband of a woman subjecting her to cruelty) (2015) 10 SCC 390  -', '454a031a6afd55f946e8bdac62911c48.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:14:41', '2020-12-22 20:09:18'),
(49, 'x7ZJ31uQ6LDAspNeli1WpSv9H', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code. Self defence', 'Not available to aggressor. Law of private defence does not apply where there is no apprehension of danger. Law doesn\'t confer a right of self defence on a man when he himself was the aggressor. (2015) 6 SCC 268 -', 'aab5765369f96e591b4ce20251a69672.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:15:16', '2020-12-22 20:09:01'),
(50, 'Wy2poG5CK9TPLQvILU67BxRUh', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure Sections 227 & 319', 'A person added as accused during the trial under Section 319 CR.P.C can not seek discharge under Section 227. Discharge of an accused added under Section 319 runs contrary to the scheme itself. It\'s only after the Court is satisfied he has committed an offence, he is added as accused. Discharge of such an accused defeats the very purpose of the scheme. (2015) 9 SCC 244.', 'bb9f5d6c7a3fdb4137d38c4778e17065.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:16:21', '2020-12-22 20:08:44'),
(51, 'gdud5mlloLn6f3eoOzYHal3Ej', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure Section 156(3) and 202', 'Under Section 202, the Magistrate can seek report from Police to decide whether or not there is sufficient ground to proceed in the case. At this stage, Police have no power to arrest. Whereas under Section 156(3), Magistrate has the power to direct investigation. This power under 156(3) is to be exercised only after application of mind by Magistrate. (2015) 6 SCC 439. Ramdev Food Products P Ltd vs State of Gujarat.', 'ac990c397984e6cdbb6543d463b4d9a5.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:17:18', '2020-12-22 20:08:19'),
(52, 'TnaoKuiLa8P9RiIb3Bu3Odm9F', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Service Law. Regularisation of Casual workmen', 'In case of unfair labour practice, Government as an employee can\'t ask for a different treatment. Umadevi case (2006) 4 SCC 1 has not overridden the powers of Industrial & Labour Courts in passing appropriate orders once unfair labour practice was established. Article 14 & 16 of the Constitution have no application to private employment. (2015) 5 SCC 786', '8e5b6b33ec0e437872b2fc001903f6fa.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:17:58', '2020-12-22 20:08:00'),
(53, 'W9ksuqcH4OQHyjSUyxu9Ayqsk', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Order 6 Rule 17', '1. CPC - Fresh pleadings and evidence which are in variation to the original pleadings cannot be taken unless the fresh pleadings are incorporated by way of amendment of the pleadings  2. Contingent contract. When the contract fails.  3. Evidence Act. Mere identification of the of person who allegedly signed document does not prove contents of the document. (2015) 9 SCC 755.', 'ce697c42215de4eab517da6b96f9959f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:19:34', '2020-12-22 20:07:44'),
(54, 'ENsvLVquRsdN0s31nI3k68GNw', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Income Tax -Educational Institutions', 'Exemption from Income Tax. Dominant Charitable object necessary. Annual exercise by authorities to check whether activities of institution are charitable to remain entitled to exemption.  (2015) 8 SCC 47.', '28e9ee64e4af4026e2b11b68373ca11e.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:20:08', '2020-12-22 20:07:26'),
(55, '2m07NXLMNf4n4Jzd7mX1k3P0L', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code Rape. Section 376', 'Girl eloped with boy. Conviction can be based on sole testimony of prosecutrix even without collaboration. However delay in filing FIR, non examination of recovery witness, etc leave a mark of doubt to treat testimony of prosecutrix as natural & truthful. Conviction set aside. (2015 7 SCC 272-', 'fd6026088f04b843e71031750c84c622.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:21:17', '2020-12-22 20:07:09'),
(56, 'eZA8JDEVBiGwHH5SlhTcTcVzk', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Income Tax Act 1961. Long Term Capital Gains', 'Relevant date under Section 2(47) & 54 of the Act is the date of Agreement to sell & not the sale of the property. Agreement extinguishes the rights in the property within the meaning of Section 2(47). (2015) 5 SCC 775 -', '1ec15b222cd50509da7c45f7a12e196f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:22:08', '2020-12-22 20:06:42'),
(57, '4WUDHFcv5pPr9w61rtLNLo0Ob', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure. Section 156(3) and 202', 'Under Section 202, the Magistrate can seek report from Police to decide whether or not there is sufficient ground to proceed in the case. At this stage, Police have no power to arrest. Whereas under Section 156(3), Magistrate has the power to direct investigation. This power under 156(3) is to be exercised only after application of mind by Magistrate. (2015) 6 SCC 439. Ramdev Food Products P Ltd vs State of Gujarat.', '0faf43bb906f189ec6d978565f408774.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:23:40', '2020-12-22 20:06:22');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(58, 'OcYkBcjS1HZaF5YSWSC22ZHOI', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Supreme Court restores election petition of A. Manju against Prajwal Revanna M.P. by setting aside Karnataka High Court judgment. ', '<h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\">A. Manju vs Prajwal Revanna&nbsp;<br></font><font color=\"#222222\" face=\"mainFontOP\">Civil Appeal 1774 of 2020 decided on 13 December 2021<br></font><font color=\"#222222\" face=\"mainFontOP\">Justice Sanjay Kishan Kaul and Justice M.M. Sundresh&nbsp;<br></font><font color=\"#222222\" face=\"mainFontOP\">Judgment Link: <a href=\"https://main.sci.gov.in/supremecourt/2020/6512/6512_2020_36_1502_32086_Judgement_13-Dec-2021.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2020/6512/6512_2020_36_1502_32086_Judgement_13-Dec-2021.pdf<br></a></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">19. We must begin at the inception by stating that intrinsically, election law is technical in nature. In the present matter, an election conducted under an independent body like the Election Commission is sought to be assailed, where the mandate of the public has gone in a particular way. The allegations must strictly fall within the parameters of the manner in which such a mandate can be overturned. The primary plea taken by the appellant is largely that success in the elections was obtained by concealment of material, which would have been germane in determining the opinion of the electorate. In effect, were such material to be available with the electorate, they would have exercised another option on the basis of it. However, while the requirements to be met in the election petition may be technical in nature, they are not hypertechnical, as observed in the Ponnala Lakshmaiah16 case. We have considered the aforesaid aspect by quoting the observations made therein which have received the imprimatur of a larger Bench.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">20. In the conspectus of the aforesaid, if we examine the facts of the present case, the hyper-technical view sought to be taken of non-signing and verification of the index and the synopsis has been rightly rejected by the High Court.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">21. Thus, the real and core question before us is that in view of the allegations of the alleged non-disclosure of assets in Form-26 by respondent No.1 being cited as “corrupt practice”, would it be mandatory for the election petitioner to file an affidavit in Form-25 and what would be the consequences of not filing such an affidavit.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">22. We may take note of the Constitution Bench judgment of this Court in Murarka Radhey Shyam Ram Kumar v. Roop Singh Rathore17 which opined that the defect in verification of an affidavit cannot be a sufficient ground for dismissal of the petitioner’s petition summarily and such an affidavit can be permitted to be filed later. This Constitution Bench judgment was also referred to in G.M. Siddeshwar18 case to come to a conclusion that non-compliance with proviso to Section 83(1) of the RP Act was not fatal to the maintainability of an election petition and the defect could be remedied, i.e., even in the absence of compliance, the petition would still be called an election petition. We cannot say that the High Court fell into an error while considering the election petition as a whole to come to the conclusion that the allegations of the appellant were not confined only to Section 33A of the RP Act, but were larger in ambit as undue influence and improper acceptance of nomination of respondent No.1 were also pleaded as violation of the mandate under Sections 123 and 100 of the RP Act.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">23. However, we are not persuaded to agree with the conclusion arrived at by the High Court that the non-submission of Form 25 would lead to the dismissal of the election petition. We say so because, in our view, the observations made in Ponnala Lakshmaiah19 case which have received the imprimatur of the three Judges Bench in G.M. Siddeshwar20 case appear not to have been appreciated in the correct perspective. In fact, the G.M. Siddeshwar21 case has been cited by the learned Judge to dismiss the petition. If we look at the election petition, the prayer clause is followed by a verification. There is also a verifying affidavit in support of the election petition. Thus, factually it would not be appropriate to say that there is no affidavit in support of the petition, albeit not in Form 25. This was a curable defect and the learned Judge trying the election petition ought to have granted an opportunity to the appellant to file an affidavit in support of the petition in Form 25 in addition to the already existing affidavit filed with the election petition. In fact, a consideration of both the judgments of the Supreme Court referred to by the learned Judge, i.e. Ponnala Lakshmaiah22 as well as G.M. Siddeshwar23, ought to have resulted in a conclusion that the correct ratio in view of these facts was to permit the appellant to cure this defect by filing an affidavit in the prescribed form.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">24. The arguments of learned counsel for respondent No.1 were predicated on the distinction between the absence of an affidavit and a defective affidavit. This pre-supposes that for an opportunity of cure to be granted, there must be the submission of a Form 25 affidavit which may be defective. This would be very narrow reading of the provisions. Once there is an affidavit, albeit not in Form 25, the appropriate course would be to permit an affidavit to be filed in Form 25. We have to appreciate that the petition is at a threshold stage. It is not as if the appellant has failed to cure the defect even on being pointed out so. This is not a case where the filing of an affidavit now in Form 25 would grant an opportunity for embellishment as is sought to be urged on behalf of respondent No.1.<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">25. The appellant states the case clearly and in no uncertain terms with supporting material in the election petition. Whether the violation is made out by respondent no.1 or not would be a matter of trial but certainly not a matter to be shut out at the threshold.<br></font><font color=\"#222222\" face=\"mainFontOP\">26. The result of the aforesaid is that the impugned order of the learned single Judge dated 17.1.2020 is set aside and the application filed by respondent no.1 under Order 7 Rule 11, S. 151 of the said Code and S. 86(1) of the RP Act would stand dismissed with liberty to the appellant to file an appropriate affidavit in Form 25 within fifteen (15) days from today. The further proceedings in the election petition are required to be taken up urgently as almost two and a half years have gone on the preliminary skirmishes rather than the meat of the matter, which we are sure the learned single Judge of the High Court would so do&nbsp;<br></font></h4><h4 style=\"text-align: left; margin-right: 0px; margin-bottom: 10px; margin-left: 0px; line-height: 20px;\"><font color=\"#222222\" face=\"mainFontOP\"><br></font><font color=\"#222222\" face=\"mainFontOP\">27. The appeal is accordingly allowed leaving the parties to bear their own costs.</font></h4>', '1ac836e3f26e1dcc8c9e23fcad6fcf27.jpg', '50ce89e6ef20f8a211abbc0574bf4291.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-12-13', 1, '', '', '2020-12-02 19:24:50', '2021-12-14 05:35:30'),
(59, 'oQhAsqrXMs28Ihrt3L2WgiFcD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Doctrine of feeding the grant by estoppel', 'Operates in cases where the person acquires the right during his life time & suit can be filed against his legal representatives. But does not operate where the person dies without acquiring interest during his life time but his LRs acquire after his death. (2015) 5 SCC 691', '6658345a4a25d693848b4a554d09870a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:26:36', '2020-12-22 20:05:44'),
(60, '7My10ZFqqwpOuv8x3et3d5jQa', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Corporate criminal responsibility', '<div>When a company is the accused, it\'s directors can be roped in only if</div><div>(a). There is sufficient incriminating evidence against them coupled with criminal intent: or</div><div>(b). The statutory regime attracts attracts the doctrine of vicarious responsibility. Law on the point reiterated. (2015) 4 SCC 609 -</div>', 'b425721d369e02ee4c4e3f27dd4923ed.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:28:04', '2020-12-22 20:05:26'),
(61, 'zlTWWzala4Ja8ZTSJ9iOcTolZ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Laws. Conviction', 'Whether sentence shall run \"Concurrently\" or \"Consecutively\". It is legally obligatory upon the trial court to while awarding sentence to specify in clear terms as to whether the sentence would run concurrently or consecutively.  (2015) 4 SCC 302 -', '26b15e4498faef2dbd483bc249eaf2d0.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:28:41', '2020-12-22 20:05:06'),
(62, 'H0YghKfmXRgJnlo6tDOZpZnxv', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Motor Vehicle Act', 'Accident. Difference between Contributory and  Composite negligence. In case of composite negligence, the claimant can sue both or any one of the joint tortfeasors and to recover the entire compensation. Apportionment in case of composite negligence does not arise. (2015) 9 SCC 273.', '45d76745244c9aa79a99477e107d9181.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:29:53', '2020-12-22 20:04:47'),
(63, 'hRTxWQXJntJpbGtIXK4mxxdjO', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Service Law. Appointment', 'Right to be considered for appointment is not a vested right & is subject to minimum eligibility. Till an appointment is made, no vested right arises. Vested right - what is (2015) 8 SCC 129. .', 'f2423096251410c54aeb47f9b35e8f07.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:35:51', '2020-12-22 20:04:19'),
(64, 'z3w9GcTFGf3uukdyxXRy8rFGs', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code Section 364-A', 'Constitutional validity upheld. Courts can interfere only when the punishment prescribed is so outrageously disproportionate to the offence or so inhuman or brutal that the same cannot be accepted by any standard of decency. (2015) 9 SCC 502.', '405e64cc3468e368881d506623226536.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:36:38', '2020-12-22 20:04:00'),
(65, '2y3QpPwXbuUvYpj15VsuVFWC1', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitration and Conciliation Act, 1996- Section 9', 'Interim relief. Where the contract specifies jurisdiction of court at particular place and such court has jurisdiction to deal with the matter, then all other courts are excluded.  (2015) 12 SCC 225.', '58af8ac69ea43db6d4b8c92f1fc1c9c1.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:37:06', '2020-12-22 20:03:36'),
(66, 'ftQI6rZJ7YOf8WwgH348Mi9yD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Daksha Legal drafting.  Power of attorney formats. ', '<p><b>Daksha Legal drafting. Power of attorney formats. <span style=\"background-color: rgb(255, 255, 0);\">PDF document enclosed.&nbsp;</span></b></p>', '04a4d5006561e352c932fa5a7c302d2f.JPG', '07f95dc419dcf70572a182e5c41c4799.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-08-14', 1, '', '', '2020-12-02 19:38:09', '2021-08-15 02:26:28'),
(957, 'fvqgBtFriYEpJYsGmgkmkrsIW', 'TSUhvAg9KIuGOC5DrA7yLvekJ', '\'Mortgage by way of Conditional Sale and a Sale with Condition to Purchase\' -  Supreme Court explains legal position. ', '<p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>Bhimrao Ramchandra Khalate by lrs vs Nana Dinkar Yadav (Tanpura) and\r\nanother<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>Civil Appeal 10197 of 2020 decided on 13 August 2021<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>Justice Hemant Gupta and Justice A.S. Bopanna. <o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>Judgment Link: <a href=\"https://main.sci.gov.in/supremecourt/2007/2113/2113_2007_42_1501_29277_Judgement_13-Aug-2021.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2007/2113/2113_2007_42_1501_29277_Judgement_13-Aug-2021.pdf</a></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><b><span lang=\"EN-US\">Ratio:&nbsp;</span><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">A distinction exists between a mortgage by way of conditional sale and a sale with condition to repurchase. In the former the debt subsists and a right to redeem remains with the debtor but in case of the latter, the transaction does not evidence an arrangement of lending and borrowing, thus, right to redeem is not reserved.</span></b></p><p class=\"MsoNormal\" style=\"margin-bottom: 0cm; line-height: normal;\"><span lang=\"EN-US\"><b>Case Law referred:&nbsp;&nbsp;</b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>1. Pandit Chunchun Jha v. Sheikh Ebadat Ali &amp; Anr AIR 1954 SC 345<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>2. Shri Bhaskar Waman Joshi v. Shri Narayan Rambilas Agarwal AIR 1960\r\nSC 301<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>3. P.L. Bapuswami v. N. Pattay Gounder AIR 1966 SC 902<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>4. Umabai&amp; Anr. v. Nilkanth Dhondiba Chavan (Dead) by LRs &amp; Anr\r\n(2005) 6 SCC 243<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>5. Tulsi &amp; Ors. v. Chandrika Prasad &amp; Ors (2006) 8 SCC 322<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>6. Vithal Tukaram Kadam &amp; Anr. v. Vamanrao Sawalaram Bhosale &amp;\r\nOrs (2018) 11 SCC 172<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>7. Ganpati Babji Alamwar (Dead) by LRs Ramlu &amp; Ors. v. Digambarrao\r\nVenkatrao Bhadke &amp; Ors (2019) 8 SCC 651<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>8. Vanchalabai Raghunath Ithape (Dead) by LR v. Shankarrao Baburao\r\nBhilare (Dead) by LRs &amp; Ors (2013) 7 SCC 173<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>9. Dharmaji Shankar Shinde &amp; Ors. v. Rajaram Shripad Joshi (Dead)\r\nthrough LRs &amp; Ors (2019) 8 SCC 401<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>10. Sopan (Dead) through his LR v. Syed Nabi (2019) 7 SCC 635<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><br></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>&nbsp;</b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>&nbsp;</b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>&nbsp;</b></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>&nbsp;</b></span></p><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p><p class=\"MsoNormal\" style=\"margin-bottom:0cm;line-height:normal\"><span lang=\"EN-US\"><b>&nbsp;</b></span></p>', '1272828679cb455318d9a0b6bb2a1bcb.JPG', '2cfc6f097e6dff4734884995c4e33890.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-08-13', 1, '', '', '2021-08-15 03:58:59', '2021-08-15 04:00:44'),
(67, 'FCv9rfDxGRi3vjT3tkAzJ6Xds', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Law. Providing of password passcode or biometrics of computer or smartphone deice as per Court order does NOT amount to self-incrimination or testimonial compulsion. Karnataka High Court. 12 March 2021.  ', '<h4>Criminal Law.  Computer devices and Smart phones. By providing of password, passcode or biometrics, there is no oral statement or a written statement being made by the accused like the Petitioner herein, therefore it can not be said to be testimonial compulsion. Karnataka High Court.  <span style=\"background-color: rgb(255, 255, 0);\">Please click the following link to read the main post. </span><br><a href=\"https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0\" target=\"_blank\">https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0</a><span style=\"font-size: 0.875rem;\"><a href=\"https://dakshalegal.com/judgements/actionRead/MRdFOROIjVzZXU66DGOO7Q8Z0\" target=\"_blank\"> </a></span></h4>', '82746a86fb800bfa1f4efb7355ffbcfa.PNG', 'f395356d2ff24b0244ff64ec001942a7.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-03-12', 1, '', '', '2020-12-02 19:39:16', '2021-03-14 18:23:01'),
(68, 'dniZAdX8g929CgpGxju6h4yhW', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court stays imposition of property tax on private educational institutions under the BBMP Act, 2020.  (see details) ', '<p><b>The High Court of Karnataka today, 22 July 2021 stayed imposition of property tax on private educational institutions coming within Bruhat Bangalore Mahanagara Palike area under the BBMP Act, 2020.&nbsp;</b></p><p style=\"text-align: justify; \"><b>The first batch of Writ Petitions in WP. 12954 of 2021 were filed by Management Association of Schools Karnataka and New Horizon Educational and Cultural Trust.&nbsp;</b></p>\r\n\r\n<p class=\"MsoNoSpacing\"><b><span style=\"text-align: justify; font-family: var(--bs-font-sans-serif); font-size: 1rem;\">The main ground of attack challenging the constitutional validity of Sections 144 and 154 of the&nbsp;</span><span style=\"text-align: justify; font-family: var(--bs-font-sans-serif); font-size: 1rem;\">Bruhat Bangalore Mahanagara Palike Act 2020 is that the very same educational institutions established within Karnataka Municipal Corporations Act, 1976 are still exempted from the property tax. However, the schools established within BBMP area are liable to pay property tax.&nbsp;</span></b></p><p class=\"MsoNoSpacing\"><b><span style=\"text-align: justify; font-family: var(--bs-font-sans-serif); font-size: 1rem;\">After hearing the arguments, Honorbale Justice Sachin Shankar Magadum has stayed the Circular&nbsp;</span></b><b style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><span style=\"font-size:12.0pt;line-height:115%;font-family:\" verdana\",\"sans-serif\";=\"\" mso-fareast-font-family:\"times=\"\" new=\"\" roman\";mso-fareast-theme-font:minor-fareast;=\"\" mso-bidi-font-family:\"times=\"\" roman\";mso-bidi-theme-font:minor-bidi;=\"\" mso-ansi-language:en-gb;mso-fareast-language:en-gb;mso-bidi-language:ar-sa\"=\"\">dated 29:3:2021 bearing No. Ja.Aa(kam) PR 2607: 2020-2021 issued by BBMP imposing the property tax.&nbsp;</span></b></p><p class=\"MsoNoSpacing\"><b style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><span style=\"font-size:12.0pt;line-height:115%;font-family:\" verdana\",\"sans-serif\";=\"\" mso-fareast-font-family:\"times=\"\" new=\"\" roman\";mso-fareast-theme-font:minor-fareast;=\"\" mso-bidi-font-family:\"times=\"\" roman\";mso-bidi-theme-font:minor-bidi;=\"\" mso-ansi-language:en-gb;mso-fareast-language:en-gb;mso-bidi-language:ar-sa\"=\"\">Notice is ordered to the State of Karnataka and BBMP.&nbsp;</span></b></p><p class=\"MsoNoSpacing\"><b style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><span style=\"font-size:12.0pt;line-height:115%;font-family:\" verdana\",\"sans-serif\";=\"\" mso-fareast-font-family:\"times=\"\" new=\"\" roman\";mso-fareast-theme-font:minor-fareast;=\"\" mso-bidi-font-family:\"times=\"\" roman\";mso-bidi-theme-font:minor-bidi;=\"\" mso-ansi-language:en-gb;mso-fareast-language:en-gb;mso-bidi-language:ar-sa\"=\"\"><br></span></b></p><p class=\"MsoNoSpacing\"><br></p><p class=\"MsoNoSpacing\"><b><span style=\"text-align: justify; font-family: var(--bs-font-sans-serif); font-size: 1rem;\">&nbsp;</span></b><br></p>', '1674e2dc806eb7c6a28f7b053f13b2fc.jpeg', '77aa4b28068965a11728ac1d5d7734b5.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-07-22', 1, '', '', '2020-12-02 19:39:57', '2021-07-23 01:01:29'),
(69, 'WoO0S8X9dnlETat4SpRlr7uCC', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Order 6 Rule 17', 'Amendment of plaint to correct valuation of suit property shall be allowed even though such amendment result in transfer of suit due to change in pecuniary jurisdiction. Amendment can be refused only where the nature of the suit is changed by such amendment. (2015) 4 SCC 182 –', 'c18b319acc03766c00a2478d888c2509.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:40:46', '2020-12-22 20:02:26'),
(70, 'ezTQxmu6nloV4Y6gjR57F39hb', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure - Section 482', 'Abetment to commit suicide. CBI officer committing suicide blaming junior officers of harassment. No allegations made. No prima facie case made out. Proceeding quashed by HC upheld. (2015) 9 SCC 639.', 'be27753150c3744c27accc07f599e54f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:41:32', '2020-12-22 20:01:58'),
(71, 'OyxdcQWdGnxix0dupYosIItaG', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Prevention of Corruption Act', 'Appellant not present. High Court ought to appoint amicus curie instead of disposing the appeal on merits. Ingredients of corruption: The demand and voluntary acceptance of illegal gratification knowing it to be the bribe  (2015) 4 SCC 222 -', '065b69f19132528db87420e10119dcf0.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:42:08', '2020-12-22 20:01:35'),
(72, 'DjwmyZYP4b7xdx5Gcz7ZkDptv', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Motor Vehicles Act. Section 99', 'Formation of Scheme under Section 99 - Cancellation or modification under Section 102 is a quasi-judicial function. All the characteristics including rule against arbitrariness apply to such function. (2015) 4 SCC 515 -', 'c321e3ef7f64e819c10064d67b3f9ae4.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:42:48', '2020-12-22 20:01:18'),
(73, '5Eh2fvgZ6n1BL6z5Hq8gpiyh8', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Contract Act, 1892. Agency ', 'General Power of Attorney. Sales through General Power of Attorney executed before Suraj Lamp judgment are VALID. Judgement in Suraj Lamps (2009) 7 SCC 363 DO NOT apply to earlier transactions.   (2015) 5 SCC 588 -', '2483763e5ea55781fc53a27edf063515.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:44:05', '2020-12-22 20:00:58'),
(74, 'EWGouyDggY0CyTvpwSagMjyp2', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Negotiable Instruments Act. Section 138', 'Cheque bounce case. Company accused. Notice issued only to company & not to individual directors - enough. No need to issue separate notices to directors. Non-issuance of notice to directors will not absolve them of their liability.  (2015) 8 SCC 28.', '933c8f4655b47556e16ef44a698d3350.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:45:08', '2020-12-22 20:00:38'),
(75, 'CYUknwyz8lmTbVqeR2JdvyXdo', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Succession Act 1956. Vineet Sharma vs Rakesh Sharma and others. Supreme Court. 11 August 2020.  ', '<h4>Vineet Sharma vs Rakesh Sharma and others. </h4><h4>Civil Appeal Diary No. 32601 of 2018 decided on 11 August 2020.</h4><h4> Judgment Link:&nbsp;<a href=\"https://main.sci.gov.in/supremecourt/2018/32601/32601_2018_33_1501_23387_Judgement_11-Aug-2020.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2018/32601/32601_2018_33_1501_23387_Judgement_11-Aug-2020.pdf</a></h4><h4>Justice Arun Mishra)<br>Justice S. Abdul Nazeer)<br>Justice M.R. Shah.&nbsp;</h4><h4><span style=\"background-color: rgb(255, 255, 0);\">HELD: </span>129. Resultantly, we answer the reference as under:<br>(i) The provisions contained in substituted Section 6 of the Hindu Succession Act, 1956 confer status of coparcener on the daughter born before or after amendment in the same manner as son with same rights and liabilities.<br>(ii) The rights can be claimed by the daughter born earlier with effect from 9.9.2005 with savings as provided in Section 6(1) as to the disposition or alienation, partition or testamentary disposition which had taken place before 20th day of December, 2004.<br>(iii) Since the right in coparcenary is by birth, it is not necessary that father coparcener should be living as on 9.9.2005.<br>(iv) The statutory fiction of partition created by proviso to Section 6 of the Hindu Succession Act, 1956 as originally enacted did not bring about the actual partition or disruption of coparcenary. The fiction was only for the purpose of ascertaining share of deceased coparcener when he was survived by a female heir, of Class­I as specified in the Schedule to the Act of 1956 or male relative of such female. The provisions of the substituted Section 6 are required to be given full effect. Notwithstanding that a preliminary decree has been passed the daughters are to be given share in coparcenary equal to that of a son in pending proceedings for final decree or in an appeal.<br>(v) In view of the rigor of provisions of Explanation to Section 6(5) of the Act of 1956, a plea of oral partition cannot be accepted as the statutory recognised mode of partition effected by a deed of partition duly registered under the provisions of the Registration Act, 1908 or effected by a decree of a court.&nbsp; However, in exceptional cases where plea of oral partition is supported by public documents and partition is finally evinced in the same manner as if it had been affected by a decree of a court, it may be accepted.&nbsp; A plea of partition based on oral evidence alone cannot be accepted and to be rejected outrightly.<br>130. We understand that on this question, suits/appeals are pending before different High Courts and subordinate courts. The matters have already been delayed due to legal imbroglio caused by conflicting decisions. The daughters cannot be deprived of their right of equality conferred upon them by Section 6. Hence, we request that the pending matters be decided, as far as possible, within six months. In view of the aforesaid discussion and answer, we overrule the views to the contrary expressed in Prakash v. Phulavati&nbsp; and Mangammal v. T.B. Raju &amp; Ors.&nbsp; The opinion expressed in Danamma @ Suman Surpur &amp; Anr. v. Amar&nbsp; is partly overruled to the extent it is contrary to this decision.&nbsp;<br><br></h4>', '936f7f6bd397178fec0a63e6850e639e.jpg', 'c11b7f72cff90e50b076067dfa5c3eab.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-08-11', 1, '', '', '2020-12-02 19:45:46', '2021-03-14 22:47:43'),
(76, 'sy9wVjpN3SNS5w93xYwcUGgR2', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Contract Act, 1872. Novation of contracts', 'Has to be on fulfilment of all procedural requirements. (2015) 7 SCC 728', '32708df9fb25b3786585592d4df9ff01.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:46:51', '2020-12-22 20:00:01'),
(77, 'u1amoBckuNxZBLhaEyccaAc20', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code. Sections 306 & 498-A', 'Cruelty, torture and harassment for dowry proved. However case of death was accidental even as per the dying declaration of the victim. Mother-in-law and sister-in-law acquitted under 306, IPC (abetment to commit suicide). However convicted under Section 498-A, IPC.(Husband or relative of husband of a woman subjecting her to cruelty) (2015) 10 SCC 390  -', '85a9b08d0efc6b6f9bc282fde00a6fb7.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:49:55', '2020-12-22 19:59:44'),
(78, '0cuoSP7bMF69hwPKyK6sbqM4Y', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitration and Conciliation Act- Section 9', 'Interim relief. Where the contract specifies jurisdiction of court at particular place and such court has jurisdiction to deal with the matter, then all other courts are excluded. (2015) 12 SCC 225.', 'aba4d31b19554d7fbb87cc0b02dd7141.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:50:33', '2020-12-22 19:59:27'),
(79, 'IiUs72aAHUl8m0sJnlS4rLxNq', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka Industrial Areas Development Board Act', '<div>Allottee of the Industrial plot is not a \"person interested\" and has no right of hearing before determination of the compensation. It has NO right to challenge the award -  Peerappa Hanmantha Harijan vs State of Karnataka (2015) 10 SCC 469</div><div>Under the scheme of KIADB Act, the \"beneficiary\" is KIADB itself. After formation of industrial plots the same are allotted to the prospective industrialists who are lessees. These lessees have no right of hearing during the determination of the compensation. The concept of \"public purpose\" under the Land Acquisition Act has no application to the KIAD Act.</div>', 'c8322fc0626f9a4a9eb392ec1f12146f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:52:40', '2020-12-22 19:59:01'),
(80, 'P2rhVogqxDRGso62tSkuFx3MG', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Summary suit', 'Where the defendant has raised a triable issue or a reasonable defence, he is entitled to unconditional leave to defend. Leave is granted to defend even in cases where the defendant upon disclosing a fact, though lacks the defence but makes a positive impression that at the trial the defence would be established. (2015) 10 SCC 521.', '155ce031a49c85b380aa69d095f6c997.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:53:55', '2020-12-22 19:58:40'),
(81, '7PUxiyOJ9cwqafCgtpmPtHdd5', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Competition Laws.  Unfair Trade Practice ', 'Unfair Trade Practice Explained. The definition is not inclusive or flexible, but specific and limited in its contents.  ·(2015) 10 SCC 734.', 'bc7fcbbb13b05fd704a1b8f8d36c5b0f.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:55:46', '2020-12-22 19:58:15'),
(82, '4WxkSVdZduBYPLA8F1pLYVOmS', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Central Excise. Taxing the dead person', 'Tax laws are made by the living to tax the living. Unlike Income Tax Act, no provision in the Central Excise Act to proceed against a dead person to assess him to tax. Taxing statutes cannot be interpreted on presumptions & assumptions. \"Is\" -use of present tense. (2015) 10 SCC 770.', '5d9c7ff7f7ffc519139580b5852dff6d.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:56:49', '2020-12-22 19:57:54'),
(83, 'YO7fKPFuUhwgWgxuOzDzu0utM', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Contract Act, 1872. Privity of contract', 'Principal is not liable to pay the sub-contractor (of the main contractor) though on few occasions direct payments were made by the principal to the sub-contractor. (2015) 10 SCC 642.', '3b648434437e16c84d1f7faa55088ecc.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 19:59:00', '2020-12-22 19:57:36'),
(84, 'pBISKkZd3Jt0F4VFuH8P1UGY3', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Impleading applicant', '<div>A person who is not party to the suit and whose impleading application is still pending in the trial court, but injunction operating against him, can file an appeal against the injunction order. Appeal cannot be dismissed on the technical ground that he is yet to be imleaded in the suit. </div><div>Ghanshyam Sarda v. Shiv Shankar Trading Co., (2015) 1 SCC 298.</div>', '7ec4fd1218901fdf8899498597325bb3.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:02:30', '2020-12-22 19:57:16'),
(85, '7OdWytYGDyayHCIoCGQ1wm3HS', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Hindu Marriage Act - Section 13-  ', '<p><b>Samar Ghosh v. Jaya Ghosh, (2007) 4 SCC 511, at page 546 :&nbsp;</b></p><p><span style=\"text-align: justify;\">101. No uniform standard can ever be laid down for guidance, yet we deem it appropriate to enumerate some instances of human behaviour which may be relevant in dealing with the cases of “mental cruelty”. The instances indicated in the succeeding paragraphs are only illustrative and not exhaustive:</span><span style=\"text-align: justify; font-size: 0.875rem;\">(i) On consideration of complete matrimonial life of the parties, acute mental pain, agony and suffering as would not make possible for the parties to live with each other could come within the broad parameters of mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(ii) On comprehensive appraisal of the entire matrimonial life of the parties, it becomes abundantly clear that situation is such that the wronged party cannot reasonably be asked to put up with such conduct and continue to live with other party.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(iii) Mere coldness or lack of affection cannot amount to cruelty, frequent rudeness of language, petulance of manner, indifference and neglect may reach such a degree that it makes the married life for the other spouse absolutely intolerable.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(iv) Mental cruelty is a state of mind. The feeling of deep anguish, disappointment, frustration in one spouse caused by the conduct of other for a long time may lead to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(v) A sustained course of abusive and humiliating treatment calculated to torture, discommode or render miserable life of the spouse.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(vi) Sustained unjustifiable conduct and behaviour of one spouse actually affecting physical and mental health of the other spouse. The treatment complained of and the resultant danger or apprehension must be very grave, substantial and weighty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(vii) Sustained reprehensible conduct, studied neglect, indifference or total departure from the normal standard of conjugal kindness causing injury to mental health or deriving sadistic pleasure can also amount to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(viii) The conduct must be much more than jealousy, selfishness, possessiveness, which causes unhappiness and dissatisfaction and emotional upset may not be a ground for grant of divorce on the ground of mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(ix) Mere trivial irritations, quarrels, normal wear and tear of the married life which happens in day-to-day life would not be adequate for grant of divorce on the ground of mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(x) The married life should be reviewed as a whole and a few isolated instances over a period of years will not amount to cruelty. The ill&nbsp; conduct must be persistent for a fairly lengthy period, where the relationship has deteriorated to an extent that because of the acts and behaviour of a spouse, the wronged party finds it extremely difficult to live with the other party any longer, may amount to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(xi) If a husband submits himself for an operation of sterilisation without medical reasons and without the consent or knowledge of his wife and similarly, if the wife undergoes vasectomy or abortion without medical reason or without the consent or knowledge of her husband, such an act of the spouse may lead to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(xii) Unilateral decision of refusal to have intercourse for considerable period without there being any physical incapacity or valid reason may amount to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(xiii) Unilateral decision of either husband or wife after marriage not to have child from the marriage may amount to cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">(xiv) Where there has been a long period of continuous separation, it may fairly be concluded that the matrimonial bond is beyond repair. The marriage becomes a fiction though supported by a legal tie. By refusing to sever that tie, the law in such cases, does not serve the sanctity of marriage; on the contrary, it shows scant regard for the feelings and emotions of the parties. In such like situations, it may lead to mental cruelty.<br></span><span style=\"font-size: 0.875rem; text-align: justify;\">Ramchander v. Ananta, (2015) 11 SCC 539: (2015) 4 SCC (Civ) 791, at page 542 : The expression “cruelty” has not been defined in the Hindu Marriage Act. Cruelty for the purpose of Section 13(1)(i-a) is to be taken as a behaviour by one spouse towards the other, which causes a reasonable apprehension in the mind of the latter that it is not safe for him or her to continue the matrimonial relationship with the other. Cruelty can be physical or mental. In the present case there is no allegation of physical cruelty alleged by the plaintiff. What is alleged is mental cruelty and it is necessarily a matter of inference to be drawn from the facts and circumstances of the case. It is settled law that the instances of cruelty are not to be taken in isolation but to take the cumulative effect of the facts and circumstances emerging from the evidence on record and then draw a fair inference whether the plaintiff has been subjected to mental cruelty due to conduct of the other spouse.</span></p><p></p><p></p>', '0c51c702d4c007d5f2f3d67cb2a8bd84.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:05:42', '2021-01-22 22:13:01');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(86, 'TXIPDaZaOtAkTnAVlze3Om9ZV', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Indian Penal Code. Section 124A. Supreme Court Judgments. ', '<div class=\"kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"font-family: inherit;\"><b>\"Supreme Court of India on Sedition\" - Compilation of case law from the inception. </b></div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">124A. Sedition —Whoever, by words, either spoken or written, or by signs, or by visible representation, or otherwise, brings or attempts to bring into hatred or contempt, or excites or attempts to excite disaffection towards, the Government established by law in 1India, 1 shall be punished with 1imprisonment for life, to which fine may be added, or with imprisonment which may extend to three years, to which fine may be added, or with fine. Explanation 1— The expression \"disaffection\" includes disloyalty and all feelings of enmity. Explanation 2— Comments expressing disapprobation of the measures of the Government with a view to obtain their alteration by lawful means, without exciting or attempting to excite hatred, contempt or disaffection, do not constitute an offence under this section. Explanation 3 — Comments expressing disapprobation of the administrative or other action of the Government without exciting or attempting to excite hatred, contempt or disaffection, do not constitute an offence under this section.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">Please note both Brij Bhushan v. State of Delhi, 1950 SCR 605 and Romesh Thappar v. State of Madras, 1950 SCR 594 were before the first amendment to Article 19 of the Constitution of India. The words “the sovereignty and integrity of India” were introduced as one of the reasonable restrictions by this amendment. </div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">The Constitutional validity of Seciton 124-A was upheld in Kedar Nath Singh vs State of Bihar AIR 1962 SC 655 (quoted below) </div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">1. Brij Bhushan v. State of Delhi, 1950 SCR 605 - It is well recognized in all systems of law that the right to freedom of speech and expression or freedom of the press means that any person may write or say what he pleases so long as he does not infringe the law relating to libel or slander or to blasphemous, obscene or seditious words or writings: (see Halsbury\'s Laws of England, 2nd Edn. Vol. II, p. 391). This is practically what has been said in clause (2) of Article 19, with this difference only that instead of using the words “law relating to sedition”, the framers of the Constitution have used the words mentioned above. It is interesting to note that sedition was mentioned in the original draft of the Constitution, but subsequently that word was dropped and the words which I have quoted were inserted. I think it is not difficult to discover the reason for this change and I shall briefly state in my own words what I consider it to be. 16. The latest pronouncement by the highest Indian Tribunal as to the law of sedition is to be found in Niharendu Dutt Majumdar v. King which has been quoted again and again and in which Gwyer, C.J. laid down that public disorder, or the reasonable anticipation or likelihood of public disorder, is the gist of the offence of sedition and “the acts or words complained of must either incite to disorder or must be such as to satisfy reasonable men that is their intention or tendency”. For this view, the learned Chief Justice relied on certain observations of Fitzgerald, J. in R. v. Sullivan and he also added that he was content to adopt “the words of that learned Judge which are to be found in every book dealing with this branch of the criminal law.” There is no doubt that what Gwyer, C.J. has stated in that case represents the view of a number of Judges and authors and was also the view of Sir James Stephen in regard to whom Cave, J. in his charge to the jury in a case relating to the law of sedition R. v. Burns6 said:</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“The law upon the question of what is seditious and what is not is to be found stated very clearly in a book by Stephen, J. who has undoubtedly a greater knowledge of criminal law than any other Judge who sits upon the Bench, and what he has said upon the subject of sedition was submitted to the other Judges, who sometime back were engaged with him in drafting a criminal code, and upon their report the Commissioners say that his statement of law appears to them to be stated accurately as it exists at present”.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">17. The decision of Gwyer, C.J. held the field for several years until the Privy Council, dealing with a case under the Defence of India Rules, expressed the view in King-Emperor v. Sadhashiv Narayan Bhalerao7 that the test laid down by the learned Chief Justice was not applicable in India where the offence under Section 124-A of the Indian Penal Code should be construed with reference to the words used in that section. They also added:</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“The word ‘sedition\' does not occur either in Section 124-A or in the Rule; it is only found as a marginal note to Section 124-A, and is not an operative part of the section, but merely provides the name by which the crime defined in the section will be known. There can be no justification for restricting the contents of the section by the marginal note. In England there is no statutory definition of sedition; its meaning and content have been laid down in many decisions, some of which are referred to by the Chief Justice, but these decisions are not relevant when you have a statutory definition of that which is termed sedition as we have in the present case.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">Their Lordships are unable to find anything in the language of either Section 124-A or the Rule which could suggest that ‘the acts or words complained of must either incite to disorder or must be such as to satisfy reasonable men that this is their intention or tendency.\' ”</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">18. The framers of the Constitution must have therefore found themselves face to face with the dilemma as to whether the word “sedition” should be used in Article 19(2) and if it was to be used in what sense it was to be used. On the one hand, they must have had before their mind the very widely accepted view supported by numerous authorities that sedition was essentially an offence against public tranquillity and was connected in some way or other with public disorder; and, on the other hand, there was the pronouncement of the Judicial Committee that sedition as defined in the Indian Penal Code did not necessarily imply any intention or tendency to incite disorder. In these circumstances, it is not surprising that they decided not to use the word “sedition” in clause (2) but used the more general words which cover sedition and everything else which makes sedition such a serious offence. That sedition does undermine the security of the State is a matter which cannot admit of much doubt. That it undermines the security of the State usually through the medium of public disorder is also a matter on which eminent Judges and jurists are agreed. Therefore it is difficult to hold that public disorder or disturbance of public tranquillity are not matters which undermine the security of the State.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: \" segoe=\"\" ui=\"\" historic\",=\"\" \"segoe=\"\" ui\",=\"\" helvetica,=\"\" arial,=\"\" sans-serif;=\"\" color:=\"\" rgb(5,=\"\" 5,=\"\" 5);=\"\" font-size:=\"\" 15px;=\"\" background-color:=\"\" rgb(255,=\"\" 255,=\"\" 255);\"=\"\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">2. Romesh Thappar v. State of Madras, 1950 SCR 594 (Patanjali Sastri-J)- 19. It will not be out of place to quote here the following passage from Stephen\'s Criminal Law of England (Vol. II, pp. 242 and 243):</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“It often happens, however, that the public peace is disturbed by offences which without tending to the subversion of the existing political constitution practically subvert the authority of the Government over a greater or less local area for a longer or shorter time. The Bristol riots in 1832 and the Gordon riots in 1780 are instances of this kind. No definite line can be drawn between insurrections of this sort, ordinary riots, and unlawful assemblies. The difference between a meeting stormy enough to cause well-founded fear of a breach of the peace, and a civil war the result of which may determine the course of a nation\'s history for centuries, is a difference of degree. Unlawful assemblies, riots, insurrections, rebellions, levying of war, are offences which run into each other, and are not capable of being marked off by perfectly definite boundaries. All of them have in common one feature, namely, that the normal tranquillity of a civilised society is in each of the cases mentioned disturbed either by actual force or at least by the show and threat of it.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">Another class of offences against public tranquillity are those in which no actual force is either employed or displayed, but in which steps are taken tending to cause it. These are the formation of secret societies, seditious conspiracies, libels or words spoken.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">Under these two heads all offences against the internal public tranquillity of the State may be arranged.”</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">20. This passage brings out two matters with remarkable clarity. It shows firstly that sedition is essentially an offence against public tranquillity and secondly that broadly speaking there are two classes of offences against public tranquillity: (a) those accompanied by violence including disorders which affect tranquillity of a considerable number of persons or an extensive local area, and (b) those not accompanied by violence but tending to cause it, such as seditious utterances, seditious conspiracies, etc. Both these classes of offences are such as will undermine the security of the State or tend to overthrow it if left unchecked, and, as I have tried to point out, there is a good deal of authoritative opinion in favour of the view that the gravity ascribed to sedition is due to the fact that it tends to seriously affect the tranquillity and security of the State. In principle, then, it would not have been logical to refer to sedition in clause (2) of Article 19 and omit matters which are no less grave and which have equal potentiality for undermining the security of the State. It appears that the framers of the Constitution preferred to adopt the logical course and have used the more general and basic words which are apt to cover sedition as well as other matters which are as detrimental to the security of the State as sedition.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">9. It is also worthy of note that the word “sedition” which occurred in Article 13(2) of the Draft Constitution prepared by the Drafting Committee was deleted before the article was finally passed as Article 19(2). In this connection it may be recalled that the Federal Court had, in defining sedition in Niharendu Dutt Majumdar v. King-Emperor8 held that “the acts or words complained of must either incite to disorder or must be such as to satisfy reasonable men that that is their intention or tendency”, but the Privy Council overruled that decision and emphatically reaffirmed the view expressed in Tilak case9 to the effect that “the offence consisted in exciting or attempting to excite in others certain bad feelings towards the Government and not in exciting or attempting to excite mutiny or rebellion, or any sort of actual disturbance, great or small” — King-Emperor v. Sadashiv Narayan Bhalerao10. Deletion of the word “sedition” from the draft Article 13(2), therefore, shows that criticism of Government exciting disaffection or bad feelings towards it is not to be regarded as a justifying ground for restricting the freedom of expression and of the press, unless it is such as to undermine the security of or tend to overthrow the State. It is also significant that the corresponding Irish formula of “undermining the public order or the authority of the State” [Article 40(6)(i) of the Constitution of Eire, (1937)] did not apparently find favour with the framers of the Indian Constitution. Thus, very narrow and stringent limits have been set to permissible legislative abridgement of the right of free speech and expression, and this was doubtless due to the realisation that freedom of speech and of the press lay at the foundation of all democratic organisations, for without free political discussion no public education, so essential for the proper functioning of the processes of popular Government, is possible. A freedom of such amplitude might involve risks of abuse. But the framers of the Constitution may well have reflected, with Madison who was “the leading spirit in the preparation of the First Amendment of the Federal Constitution”, that “it is better to leave a few of its noxious branches to their luxuriant growth, than, by pruning them away, to injure the vigour of those yielding the proper fruits”. (Quoted in Near v. Minnesotta11).</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">10. We are therefore of opinion that unless a law restricting freedom of speech and expression is directed solely against the undermining of the security of the State or the overthrow of it, such law cannot fall within the reservation under clause (2) of Article 19, although the restrictions which it seeks to impose may have been conceived generally in the interests of public order. </div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">(Fazl Ali-J) It appears to me that in the ultimate analysis the real question to be decided in this case is whether “disorders involving menace to the peace and tranquillity of the Province” and affecting “public safety” will be a matter which undermines the security of the State or not. I have borrowed the words quoted within inverted commas from the preamble of the Act which shows its scope and necessity and the question raised before us attacking the validity of the Act must be formulated in the manner I have suggested. If the answer to the question is in the affirmative, as I think it must be, then the impugned law which prohibits entry into the State of Madras of “any document or class of documents” for securing public safety and maintenance of public order should satisfy the requirements laid down in Article 19(2) of the Constitution. From the trend of the arguments addressed to us, it would appear that if a document is seditious, its entry could be validly prohibited, because sedition is a matter which undermines the security of the State; but if, on the other hand, the document is calculated to disturb public tranquillity and affect public safety, its entry cannot be prohibited, because public disorder and disturbance of public tranquillity are not matters which undermine the security of the State. Speaking for myself, I cannot understand this argument. In Brij Bhushan v. State1 I have quoted good authority to show that sedition owes its gravity to its tendency to create disorders and an authority on criminal law like Sir James Stephen has classed sedition as an offence against public tranquillity. If so, how could sedition be a matter which would undermine the security of the State and public disorders and disturbance of public safety will not be such a matter? It was argued that a small riot or an affray will not undermine the security of the State, but to this line of argument there is a twofold answer: .</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><br></div><div dir=\"auto\" style=\"font-family: inherit;\"><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">3. Kedar Nath Singh v. State of Bihar, 1962 Supp (2) SCR 769 15. This offence, which is generally known as the offence of Sedition, occurs in Chapter VI of the Indian Penal Code, headed “Of Offences against the State”. This species of offence against the State was not an invention of the British Government in India, but has been known in England for centuries. Every State, whatever its form of Government, has to be armed with the power to punish those who, by their conduct, jeopardise the safety and stability of the State, or disseminate such feelings of disloyalty as have the tendency to lead to the disruption of the State or to public disorder. In England, the crime has thus been described by Stephen in his Commentaries on the Laws of England, 21st Edn., Vol. IV, at pp. 141-42, in these words: “Section IX. Sedition and Inciting to Disaffection.—We are now concerned with conduct which, on the one hand, falls short of treason, and, on the other does not involve the use of force or violence. The law has here to reconcile the right of private criticism with the necessity of securing the safety and stability of the State. Sedition may be defined as conduct which has, either as its object or as its natural consequence, the unlawful display of dissatisfaction with the Government or with the existing order of society.</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">The seditious conduct may be by words, by deed, or by writing. Five specific heads of sedition may be enumerated according to the object of the accused. This may be either</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">1. to excite disaffection against the King, Government, or Constitution, or against Parliament or the administration of justice;</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">2. to promote, by unlawful means, any alteration in Church or State;</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">3. to incite a disturbance of the peace;</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">4. to raise discontent among the King\'s subjects;</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">5. to excite class hatred.</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">It must be observed that criticism on political matters is not of itself seditious. The test is the manner in which it is made. Candid and honest discussion is permitted. The law only interferes when the discussion passes the bounds of fair criticism. More especially will this be the case when the natural consequence of the prisoner\'s conduct is to promote public disorder.”</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">16. This statement of the law is derived mainly from the address to the Jury by Fitzerald, J., in the case of Reg v. Alexander Martin Sullivan8. In the course of his address to the Jury, the learned Judge observed as follows:</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\">“Sedition is a crime against society, nearly allied to that of treason and it frequently precedes treason by a short interval. Sedition in itself is a comprehensive term, and it embraces all those practices, whether by word, deed or writing, which are calculated to disturb the tranquillity of the State, and lead ignorant persons to endeavour to subvert the Government and the laws of the empire. The objects of sedition generally are to induce discontent and insurrection, and stir up opposition to the Government, and bring the administration of justice into contempt; and the very tendency of sedition is to incite the people to insurrection and rebellion. Sedition has been described as disloyalty in action, and the law considers as sedition all those practices which have for their object to excite discontent or dissatisfaction, to create public disturbance, or to lead to civil war; to bring into hatred or contempt the Sovereign or the Government, the laws or constitution of the realm, and generally all endeavours to promote public disorder.”</div><div dir=\"auto\" style=\"text-align: justify; white-space: normal; background-color: rgb(240, 242, 245);\"><br></div><div dir=\"auto\" style=\"white-space: normal; background-color: rgb(240, 242, 245);\"><div dir=\"auto\" style=\"text-align: justify;\">17. That the law has not changed during the course of the centuries is also apparent from the following statement of the law by Coleridge, J., in the course of his summing up to the Jury in the case of Rex v. Aldred9:</div><div dir=\"auto\" style=\"text-align: justify;\">“Nothing is clearer than the law on this head — namely, that whoever by language, either written or spoken, incites or encourages others to use physical force or violence in some public matter connected with the State, is guilty of publishing a seditious libel. The word ‘sedition\' in its ordinary natural signification denotes a tumult, an insurrection, a popular commotion, or an uproar; it implies violence or lawlessness in some form…</div><div dir=\"auto\" style=\"text-align: justify;\">18. While dealing with a case arising under Rule 34(6)(e) of the Defence of India Rules under the Defence of India Act (35 of 1939), Sir Maurice Gwyer, C.J., speaking for the Federal Court, made the following observations in the case of Niharendu Dutt Majumdar v. King-Emperor2 and has pointed out that the language of Section 124-A of the Indian Penal Code, which was in pari materia with that of the Rule in question, had been adopted from the English Law, and referred with approval to the observations of Fitzerald, J., in the case quoted above; and made the following observations which are quite apposite;</div><div dir=\"auto\" style=\"text-align: justify;\">“ … generally speaking, we think that the passage accurately states the law as it is to be gathered from an examination of a great number of judicial pronouncements.</div><div dir=\"auto\" style=\"text-align: justify;\">The first and most fundamental duty of every Government is the preservation of order, since order is the condition precedent to all civilisation and the advance of human happiness. This duty has no doubt been sometimes performed in such a way as to make the remedy worse than the disease; but it does not cease to be a matter of obligation because some on whom the duty rests have performed it ill. It is to this aspect of the functions of Government that in our opinion the offence of sedition stands related. It is the answer of the State to those who, for the purpose of attacking or subverting it, seek (to borrow from the passage cited above) to disturb its tranquillity, to create public disturbance and to promote disorder, or who incite others to do so. Words, deeds or writings constitute sedition, if they have this intention or this tendency; and it is easy to see why they may also constitute sedition, if they seek, as the phrase is, to bring Government into contempt. This is not made an offence in order to minister to the wounded vanity of Government, but because where Government and the law cease to be obeyed because no respect is felt any longer for them, only anarchy can follow. Public disorder, or the reasonable anticipation or likelihood of public disorder, is thus the gist of the offence. The acts or words complained of must either incite to disorder or must be such as to satisfy reasonable men that that is their intention or tendency.”</div><div dir=\"auto\" style=\"text-align: justify;\">This statement of the law was not approved by Their Lordships of the Judicial Committee of the Privy Council in the case of King-Emperor v. Sadashiv Narayan Bhalero10. The Privy Council, after quoting the observations of the learned Chief Justice in Niharendu case2 while disapproving of the decision of the Federal Court, observed that there was no statutory definition of “sedition” in England, and the meaning and content of the crime had to be gathered from many decisions. But those were not relevant considerations when one had to construe the statutory definition of “sedition” as in the Code. The Privy Council held that the language of Section 124-A, or of the Rule aforesaid, under the Government of India Act, did not justify the statement of the law as made by the learned Chief Justice in Niharendu case. They also held that the expression “excite disaffection” did not include “excite disorder”, and that, therefore, the decision of the Federal Court in Niharendu case2 proceeded on a wrong construction of Section 124-A of the Penal Code, and of sub-para (e), sub-rule (6) of Rule 34 of the Defence of India Rules. Their Lordships approved of the dicta in the case of Bal Gangadhar Tilak and in the case of Annie Beasant v. Advocate-General of Madras11 which was a case under Section 4 of the Indian Press Act (1 of 1910), which was closely similar in language to Section 124-A of the Penal Code.</div><div dir=\"auto\" style=\"text-align: justify;\">19. The Privy Council also referred to their previous decision in Wallace-John-son v. King12 which was a case under sub-section 8 of Section 326 of the Criminal Code of the Gold Coast, which defined “seditious intention” in terms similar to the words of Section 124-A of the Penal Code. In that case, Their Lordships had laid down that incitement to violence was not a necessary ingredient of the crime of sedition as defined in that law.</div><div dir=\"auto\" style=\"text-align: justify;\"><br></div><div dir=\"auto\"><div class=\"kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">20. Thus, there is a direct conflict between the decision of the Federal Court in Niharendu case and of the Privy Council in a number of cases from India and the Gold Coast, referred to above. It is also clear that either view can be taken and can be supported on good reasons. The Federal Court decision takes into consideration, as indicated above, the pre-existing Common Law of England in respect of sedition. It does not appear from the report of the Federal Court decision that the rulings aforesaid of the Privy Council had been brought to the notice of Their Lordships of the Federal Court.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">21. So far as this Court is concerned, the question directly arising for determination in this batch of cases has not formed the subject-matter of decision previously. But certain observations made by this Court in some cases, to be presently noticed, with reference to the interrelation between freedom of speech and seditious writing or speaking have been made in the very first year of the coming into force of the Constitution. Two cases involving consideration of the fundamental right of freedom of speech and expression and certain laws enacted by some of the States imposing restrictions on that right came up for consideration before this Court. Those cases, reported in Romesh Thappar v. State of Madras13 and Brij Bhushan v. State of Delhi14 were heard by Kania, C.J., Fazl Ali, Patanjali Shastri, Mehr Chand Mahajan, Mukherjea and Das, JJ. and judgments were delivered on the same day (26-5-1950). In Romesh Thappar case13 the majority of the Court declared Section 9(1-A) of the Madras Maintenance of Public Order Act (Madras Act 33 of 1949), which had authorised imposition of restrictions on the fundamental right of freedom of speech, to be in excess of clause (2) of Article 19 of the Constitution authorising such restrictions, and, therefore, void and unconstitutional. In Brij Bhushan case14 the same majority struck down Section 7(1)(c) of the East Punjab Public Safety Act 1949, as extended to the Province of Delhi, authorising the imposition of restrictions on the freedom of speech and expression for preventing or combating any activity prejudicial to the public safety or the maintenance of public order. The Court held those provisions to be in excess of the powers conferred on the legislature by clause (2) of Article 19 of the Constitution. Mr Justice Patanjali Sastri, speaking for the majority of the Court in Romesh Thappar case made the following observations with reference to the decisions of the Federal Court and the Judicial Committee of the Privy Council as to what the law of Sedition in India was:</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“It is also worthy of note that the word ‘sedition\' which occurred in Article 13(2) of the Draft Constitution prepared by the Drafting Committee was deleted before the article was finally passed as Article 19(2). In this connection it may be recalled that the Federal Court had, in defining sedition in Niharendu Dutt Majumdar v. King-Emperor2 held that ‘the acts or words complained of must either incite to disorder or must be such as to satisfy reasonable men that that is their intention or tendency\', but the Privy Council overruled that decision and emphatically reaffirmed the view expressed in Tilak case to the effect that ‘the offence consisted in exciting or attempting to excite in others certain bad feelings towards the Government and not in exciting or attempting to excite mutiny or rebellion, or any sort of actual disturbance, great or small\' — King-Emperor v. Sadashiv Narayan Bhalerao. Deletion of the word ‘sedition\' from the draft Article 13(2), therefore, shows that criticism of Government exciting disaffection or bad feelings towards it is not to be regarded as a justifying ground for restricting the freedom of expression and of the press, unless it is such as to undermine the security of or tend to overthrow the State. It is also significant that the corresponding Irish formula of ‘undermining the public order or the authority of the State\' [Article 40(6)(i) of the Constitution of Eire, 1937] did not apparently find favour with the framers of the Indian Constitution. Thus, very narrow and stringent limits have been set to permissible legislative abridgement of the right of free speech and expression, and this was doubtless due to the realisation that freedom of speech and of the press lay at the foundation of all democratic organisations, for without free political discussion no public education, so essential for the proper functioning of the processes of popular Government, is possible. A freedom of such amplitude might involve risks of abuse. But the framers of the Constitution may well have reflected, with Madison who was ‘the leading spirit in the preparation of the First Amendment of the Federal Constitution\' that ‘it is better to leave a few of its noxious branches to their luxuriant growth, than, by pruning them away, to injure the vigour of those yielding the proper fruits: “ (quoted in Near v. Minnesotta).</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">These observations were made to bring out the difference between the “security of the State” and “public order”. As the latter expression did not find a place in Article 19(2) of the Constitution, as it stood originally, the section was struck down as unconstitutional. Fazl Ali, J., dissented from the views thus expressed by the majority and reiterated his observations in Brij Bhushan case14. In the course of his dissenting judgment, he observed as follows:</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“It appears to me that in the ultimate analysis the real question to be decided in this case is whether ‘disorders involving menace to the peace and tranquillity of the Province\' and affecting ‘public safety\'will be a matter which undermines the security of the State or not. I have borrowed the words quoted within inverted commas from the preamble of the Act which allows its scope and necessity and the question raised before us attacking the validity of the Act must be formulated in the manner I have suggested. If the answer to the question is in the affirmative, as I think it must be, then the impugned law which prohibits entry into the State of Madras of ‘any document or class of documents\' for securing public safety and maintenance of public order should satisfy the requirements laid down in Article 19(2) of the Constitution. From the trend of the arguments addressed to us, it would appear that if a document is seditious, its entry could be validly prohibited, because sedition is a matter which undermines the security of the State; but if, on the other hand, the document is calculated to disturb public tranquillity and affect public safety, its entry connot be prohibited, because public disorder and disturbance of public tranquillity are not matters which undermine the security of the State. Speaking for myself, I cannot understand this argument. In Brij Bhushan v. State14 I have quoted good authority to show that sedition owes its gravity to its tendency to create disorders and an authority on Criminal Law like Sir James Stephen has classed sedition as an offence against public tranquillity.”</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><br></div><div dir=\"auto\" style=\"font-family: inherit;\"><div class=\"kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">In Brij Bhushan case14 Fazl Ali, J., who was again the dissenting judge, gave his reasons in greater detail. He referred to the judgment of the Federal Court in Niharendu Datt Majumdar case2 and to the judgment of the Privy Council to the contrary in King-Emperor v. Sada Shiv Narayan10. After having pointed out the divergence of opinion between the Federal Court of India and the Judicial Committee of the Privy Council, the learned Judge made the following observations in order to explain why the term “sedition” was not specifically mentioned in Article 19(2) of the Constitution:</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">“The framers of the Constitution must have therefore found themselves face to face with the dilemma as to whether the word ‘sedition\' should be used in Article 19(2) and if it was to be used in what sense it was to be used. On the one hand, they must have had before their mind the very widely accepted view supported by numerous authorities that sedition was essentially an offence against public tranquillity and was connected in some way or other with public disorder; and, on the other hand, there was the pronouncement of the Judicial Committee that sedition as defined in the Indian Penal Code did not necessarily imply any intention or tendency to incite disorder. In these circumstances, it is not surprising that they decided not to use the word ‘sedition\' in clause (2) but used the more general words which cover sedition and everything else which makes sedition such a serious offence. That sedition does undermine the security of the State is a matter which cannot admit of much doubt. That it undermines the security of the State usually through the medium of public disorder is also a matter on which eminent Judges and jurists are agreed. Therefore, it is difficult to hold that public disorder or disturbance of public tranquillity are not matters which undermine the security of the State.”</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\">It has not been questioned before us that the fundamental right guaranteed by Article 19(1)(a) of the freedom of speech and expression is not an absolute right. It is common ground that the right is subject to such reasonable restrictions as would come within the purview of clause (2), which comprises (a) security of the State, (b) friendly relations with foreign States, (c) public order, (d) decency or morality, etc. etc. With reference to the constitutionality of Section 124-A or Section 505 of the Indian Penal Code, as to how far they are consistent with the requirements of clause (2) of Article 19 with particular reference to security of the State and public order, the section, it must be noted, penalises any spoken or written words or signs or visible representations, etc. which have the effect of bringing, or which attempt to bring into hatred or contempt or excites or attempts to excite disaffection towards the Government established by law. Now, the expression “the Government established by law” has to be distinguished from the persons for the time being engaged in carrying on the administration. “Government established by law” is the visible symbol of the State. The very existence of the State will be in jeopardy if the Government established by law is subverted. Hence, the continued existence of the Government established by law is an essential condition of the stability of the State. That is why “sedition”, as the offence in Section 124-A has been characterised, comes, under Chapter VI relating to offences against the State. Hence, any acts within the meaning of Section 124-A which have the effect of subverting the Government by bringing that Government into contempt or hatred, or creating disaffection against it, would be within the penal statute because the feeling of disloyalty to the Government established by law or enmity to it imports the idea of tendency to public disorder by the use of actual violence or incitement to violence. In other words, any written or spoken words, etc. which have implicit in them the idea of subverting Government by violent means, which are compendiously included in the term “revolution”, have been made penal by the section in question. But the section has taken care to indicate clearly that strong words used to express disapprobation of the measures of Government with a view to their improvement or alteration by lawful means would not come within the section. Similarly, comments, however strongly worded, expressing disapprobation of actions of the Government, without exciting those feelings which generate the inclination to cause public disorder by acts of violence, would not be penal. In other words, disloyalty to Government established by law is not the same thing as commenting in strong terms upon the measures or acts of Government, or its agencies, so as to ameliorate the condition of the people or to secure the cancellation or alteration of those acts or measures by lawful means, that is to say, without exciting those feelings of enmity and disloyalty which imply excitement to public disorder or the use of violence.</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><br></div><div dir=\"auto\" style=\"font-family: inherit;\"><div dir=\"auto\" style=\"text-align: justify;\">25. It has not been contended before us that if a speech or a writing excites people to violence or have the tendency to create public disorder, it would not come within the definition of “sedition”. What has been contended is that a person who makes a very strong speech or uses very vigorous words in a writing directed to a very strong criticism of measures of Government or acts of public officials, might also come within the ambit of the penal section. But in our opinion, such words written or spoken would be outside the scope of the section. In this connection, it is pertinent to observe that the security of the State, which depends upon the maintenance of law and order is the very basic consideration upon which legislation, with a view to punishing offences against the State, is undertaken. Such a legislation has, on the one hand, fully to protect and guarantee the freedom of speech and expression, which is the sine qua non of a democratic form of Government that our Constitution has established. This Court, as the custodian and guarantor of the fundamental rights of the citizens, has the duty cast upon it of striking down any law which unduly restricts the freedom of speech and expression with which we are concerned in this case. But the freedom has to be guarded against becoming a licence for vilification and condemnation of the Government established by law, in words which incite violence or have the tendency to create public disorder. A citizen has a right to say or write whatever he likes about the Government, or its measures, by way of criticism or comment, so long as he does not incite people to violence against the Government established by law or with the intention of creating public disorder. The Court has, therefore, the duty cast upon it of drawing a clear line of demarcation between the ambit of a citizen\'s fundamental right guaranteed under Article 19(1)(a) of the Constitution and the power of the legislature to impose reasonable restrictions on that guaranteed right in the interest of, inter alia, security of the State and public order. We have, therefore, to determine how far the Sections 124-A and 505 of the Indian Penal Code could be said to be within the justifiable limits of legislation. If it is held, in consonance with the views expressed by the Federal Court in the case of Niharendu Dutt Majumdar v. King-Emperor2 that the gist of the offence of “sedition” is incitement to violence or the tendency or the intention to create public disorder by words spoken or written, which have the tendency or the effect of bringing the Government established by law into hatred or contempt or creating disaffection in the sense of disloyalty to the State, in other words bringing the law into line with the law of sedition in England, as was the intention of the legislators when they introduced Section 124-A into the Indian Penal Code in 1870 as aforesaid, the law will be within the permissible limits laid down in clause (2) of Article 19 of the Constitution. If on the other hand we give a literal meaning to the words of the section, divorced from all the antecedent background in which the law of sedition has grown, as laid down in the several decisions of the Judicial Committee of the Privy Council, it will be true to say that the section is not only within but also very much beyond the limits laid down in clause (2) aforesaid.</div><div dir=\"auto\" style=\"text-align: justify;\">There can be no doubt that apart from the provisions of clause (2) of Article 19, Sections 124-A and 505 are clearly violative of Article 19(1)(a) of the Constitution. But then we have to see how far the saving clause, namely, clause (2) of Article 19 protects the sections aforesaid. Now, as already pointed out, in terms of the amended clause (2), quoted above, the expression “in the interest of … public order” are words of great amplitude and are much more comprehensive then the expression “for the maintenance of”, as observed by this Court in the case of Virendra v. State of Punjab16. Any law which is enacted in the interest of public order may be saved from the vice of constitutional invalidity. If, on the other hand, we were to hold that even without any tendency to disorder or intention to create disturbance of law and order, by the use of words written or spoken which merely create disaffection or feelings of enmity against the Government, the offence of sedition is complete, then such an interpretation of the sections would make them unconstitutional in view of Article 19(1)(a) read with clause (2). It is well settled that if certain provisions of law construed in one way would make them consistent with the Constitution, and another interpretation would render them unconstitutional, the Court would lean in favour of the former construction. The provisions of the sections read as a whole, along with the explanations, make it reasonably clear that the sections aim at rendering penal only such activities as would be intended, or have a tendency, to create disorder or disturbance of public peace by resort to violence. As already pointed out, the explanations appended to the main body of the section make it clear that criticism of public measures or comment on Government action, however strongly worded, would be within reasonable limits and would be consistent with the fundamental right of freedom of speech and expression. It is only when the words, written or spoken, etc. which have the pernicious tendency or intention of creating public disorder or disturbance of law and order that the law steps in to prevent such activities in the interest of public order. So construed, the section, in our opinion, strikes the correct balance between individual fundamental rights and the interest of public order. It is also well settled that in interpreting an enactment the Court should have regard not merely to the literal meaning of the words used, but also take into consideration the antecedent history of the legislation, its purpose and the mischief it seeks to suppress [vide (1) Bengal Immunity Company Limited v. State of Bihar17 and (2) R.M.D. Chamarbaugwala v. Union of India18]. Viewed in that light, we have no hesitation in so construing the provisions of the sections impugned in these cases as to limit their application to acts involving intention or tendency to create disorder, or disturbance of law and order, or incitement to violence.</div><div dir=\"auto\" style=\"text-align: justify;\"><br></div><div dir=\"auto\" style=\"text-align: justify;\"><b>4. Balwant Singh v. State of Punjab, (1995) 3 SCC 214</b>, at page 218 - A plain reading of the above section would show that its application would be attracted only when the accused brings or attempts to bring into hatred or contempt or excites or attempts to excite disaffection towards the Government established by law in India, by words either written or spoken or visible signs or representations etc. Keeping in view the prosecution evidence that the slogans as noticed above were raised a couple of times only by the appellant and that neither the slogans evoked a response from any other person of the Sikh community or reaction from people of other communities, we find it difficult to hold that upon the raising of such casual slogans a couple of times without any other act whatsoever, the charge of sedition can be founded. It is not the prosecution case that the appellants were either leading a procession or were otherwise raising the slogans with the intention to incite people to create disorder or that the slogans in fact created any law and order problem. It does not appear to us that the police should have attached much significance to the casual slogans raised by two appellants, a couple of times and read too much into them. The prosecution has admitted that no disturbance, whatsoever, was caused by the raising of the slogans by the appellants and that in spite of the fact that the appellants raised the slogans a couple of times, the people, in general, were unaffected and carried on with their normal activities. The casual raising of the slogans, once or twice by two individuals alone cannot be said to be aimed at exciting or attempting to excite hatred or disaffection towards the Government as established by law in India. Section 124-A IPC, would in the facts and circumstances of the case have no application whatsoever and would not be attracted to the facts and circumstances of the case.<br></div><div dir=\"auto\" style=\"text-align: justify;\"><br></div><div dir=\"auto\"><div class=\"kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><b>5. Ahmed Kaloo v. State of A.P., (1997) 7 SCC 431</b>, at page 437 - A mechanical order convicting a citizen for offences of such serious nature like sedition and promoting enmity and hatred etc. does harm to the cause. It is expected that the graver the offence, greater should be the care taken so that the liberty of a citizen is not lightly interfered with.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><b>6. Bilal Ahmed Kaloo v. State of A.P., (1997) 7 SCC 431, </b>at page 434 –Paragraph 6. The decisive ingredient for establishing the offence of sedition under Section 124-A IPC is the doing of certain acts which would bring to the Government established by law in India hatred or contempt etc. In this case, there is not even a suggestion that the appellant did anything against the Government of India or any other Government of the State. The charge framed against the appellant contains no averment that the appellant did anything against the Government.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><b>7. Nazir Khan v. State of Delhi, (2003) 8 SCC 461, at page 487</b> - Sedition is a crime against society nearly allied to that of treason, and it frequently precedes treason by a short interval. Sedition in itself is a comprehensive term, and it embraces all those practices, whether by word, deed, or writing, which are calculated to disturb the tranquillity of the State, and lead ignorant persons to endeavour to subvert the Government and laws of the country. The objects of sedition generally are to induce discontent and insurrection, and stir up opposition to the Government, and bring the administration of justice into contempt; and the very tendency of sedition is to incite the people to insurrection and rebellion. “Sedition” has been described as disloyalty in action, and the law considers as sedition all those practices which have for their object to excite discontent or dissatisfaction, to create public disturbance, or to lead to civil war; to bring into hatred or contempt the Sovereign or the Government, the laws or constitutions of the realm, and generally all endeavours to promote public disorder.</div></div><div class=\"o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql\" style=\"overflow-wrap: break-word; margin: 0.5em 0px 0px;\"><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><b>8. R. Balakrishna Pillai v. State of Kerala, (2003) 9 SCC 700</b>, at page 729 –Paragraph 45. Glanville Williams in Criminal Law has also stated as follows in connection with the intention accompanying the act: “The chief problems in the general part of criminal law pertain to the requirement of a criminal state of mind, mens rea; but these cannot be adequately discussed without a preliminary exploration of the nature of an actus reus.” It is further stated: “Although thoughts are free, the uttering of them is another matter. Speaking or writing is an act, and is capable of being treason, sedition, conspiracy or incitement; indeed, almost any crime can be committed by mere words, for it may be committed by the accused ordering an innocent agent (e.g. a child under eight) to do the act. But to constitute a criminal act there must be (as said already) something more than a mere mental resolution. Apparent, but not real, exceptions to this proposition are treason and conspiracy. It is treason to compass the King’s death, but the law requires an overt act manifesting the intention; and this act must be something more than a confession of the intention. It must be an act intended to further the intention; perhaps, too, it must actually do so….”</div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><br></div><div dir=\"auto\" style=\"text-align: justify; font-family: inherit;\"><b>9. Shreya Singhal v. Union of India, (2015) 5 SCC 1, at page 45 </b>- Section 124-A which is the offence relating to sedition, it seeks to penalise any action that “attempts to bring into hatred or contempt or excites or attempts to excite disaffection”, and it limits the scope of the said expressions such as “hatred” by placing an additional qualification that only when the same is directed “towards the Government established by law” that it is considered an offence.<br></div></div></div></div></div></div></div></div></div><div dir=\"auto\" style=\"white-space: normal; background-color: rgb(240, 242, 245);\"><br></div></div><div dir=\"auto\" style=\"font-family: inherit;\"><br></div><div dir=\"auto\" style=\"font-family: inherit;\"><br></div><div dir=\"auto\" style=\"font-family: inherit;\"><br></div></div>', '2259dfc0388ad445714ad4418e1ba289.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:50:52', '2021-01-22 22:05:02');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(87, 'WNjrcTAl6GwLNiQwDtlFQ4w3S', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Transfer of Property Act, 1882. Section 53. Fraudulent transfers', '<div><b>Rights of a transferee in good faith and for consideration. Such rights militate even against subsequent Court attachment of the very same property. - Karnataka High Court.</b></div><div>S.K.Gangadhara vs Ramachandra&nbsp;</div><div>Regular Second Appeal 265/2011</div><div>Decided on 13 April 2015</div><div><b>Judgment Link</b>: <a href=\"http://judgmenthck.kar.nic.in/.../1/RSA265-11-13-04-2015.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/.../1/RSA265-11-13-04-2015.pdf</a></div>', '7c4b725cf7e78c3f61ceb0a05bd52900.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:53:25', '2021-02-03 14:17:03'),
(88, '3gnfNy8EPAK9fnQOUIu98R1H0', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Bank Guarantee', '<div>Latest judgment of the Supreme Court of India - Reiterating the legal position that there can be NO injunction against revocation of unconditional bank guarantee. However, liberty given to the plaintiff to initiate appropriate proceedings in the circumstances of the case. </div><div><br></div><div>Judgment:  http://supremecourtofindia.nic.in/FileServer/2015-12-10_1449748133.pdf</div>', '2bb2c8f04ecec15f18af1409570c2001.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:53:56', '2020-12-22 19:56:06'),
(89, 'jeR7jJpFFGRpW9aC8JjilwTLI', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Impounding of Documents. Arbitration Tribunal ', '<div><b>Tribunal has the power to impound any instrument or document, if it is not duly stamped (under Section 33 of the Karnataka Stamp Act, 1957) - holds Karnataka High Court. 1 March 2016&nbsp;</b></div><div><br><b>Judgment:</b> http://karnatakajudiciary.kar.nic.in/.../wa-100191-2015.pdf</div><div><br>Every person having authority to receive evidence has the power under Section 33 of the Act to impound any instrument or document, if it is not duly stamped. It is not necessary in law that the said person should also be in-charge of a public office. ‘Person’ referred to in Section 33(1) of the Act includes an Arbitral Tribunal.</div>', '5b9448a2a0501b950f145a2782275d3e.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 20:54:42', '2021-01-22 21:59:54'),
(90, 'Big5mWCw3Jz563H6UfuNVk1UL', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Amendment of pleadings. Doctrine of relation back from the date of suit will not apply when the court allows the amendment subject to the plea of limitation thus saving the legal right that had accrued in favour of the defendant. Sup', '<h4><b>L.C. Hanumanthappa v. H.B. Shivakumar. Civil Appeal No. 6595 of 2015 decided on August 26, 2015</b><br>Justice Dr. A.K. Sikri and Justice Rohington Fali Nariman<br>Judgment LInk: <a href=\"https://main.sci.gov.in/jonew/judis/42888.pdf\" target=\"_blank\">https://main.sci.gov.in/jonew/judis/42888.pdf</a><br><b>Reported in (2016) 1 SCC 33</b>2<br><b>Relevant paragraphs: 15</b>. As early as in the year 1909, the Bombay High Court in Kisandas Rupchand v. Rachappa Vithoba Shilwant8, held as follows: (ILR p. 655)<br><i>“… All amendments ought to be allowed which satisfy the two conditions: (a) of not working injustice to the other side, and (b) of being necessary for the purpose of determining the real questions in controversy between the parties … but I refrain from citing further authorities, as, in my opinion, they all lay down precisely the same doctrine. That doctrine, as I understand it, is that amendments should be refused only where the other party cannot be placed in the same position as if the pleading had been originally correct, but the amendment would cause him an injury which could not be compensated in costs. It is merely a particular case of this general rule that where a plaintiff seeks to amend by setting up a fresh claim in respect of a cause of action which since the institution of the suit had become barred by limitation, the amendment must be refused; to allow it would be to cause the defendant an injury which could not be compensated in costs by depriving him of a good defence to the claim. The ultimate test therefore still remains the same: can the amendment be allowed without injustice to the other side, or can it not?”<br></i>16. This statement of the law was expressly approved by a three-Judge Bench of this Court in Pirgonda Hongonda Patil v. Kalgonda Shidgonda Patil9 SCR pp. 603-04.<br>17. Twenty years later, the Privy Council in Charan Das v. Amir Khan10, stated the law as follows: (IA p. 262)<br><i>“… That there was full power to make the amendment cannot be disputed, and though such a power should not as a rule be exercised where its effect is to take away from a defendant a legal right which has accrued to him by lapse of time, yet there are cases … where such considerations are outweighed by the special circumstances of the case….”</i><br>18. This statement of the law was cited with approval in L.J. Leach & Co. Ltd. v. Jardine Skinner & Co.11 SCR pp. 450-51.<br>21. Similar is the case with Pirgonda Hongonda Patil9. Here again it was held that the amendment did not really introduce a new fact at all, nor did the defendant have to meet a new claim set up for the first time after the expiry of the period of limitation.<br>22. In K. Raheja Constructions Ltd. v. Alliance Ministries12, this Court was seized with a belated application to amend a plaint filed for permanent injunction. Seven years after it was filed, an amendment application was moved seeking to amend the plaint to one for specific performance of contract. In turning down such amendment on the ground that it was time-barred, this Court held: (SCC pp. 18-19, para 4)<br>“4. It is seen that the permission for alienation is not a condition precedent to file the suit for specific performance. The decree of specific performance will always be subject to the condition to the grant of the permission by the competent authority. The petitioners having expressly admitted that the respondents have refused to abide by the terms of the contract, they should have asked for the relief for specific performance in the original suit itself. Having allowed the period of seven years to elapse from the date of filing of the suit, and the period of limitation being three years under Article 54 of the Schedule to the Limitation Act, 1963, any amendment on the grounds set out, would defeat the valuable right of limitation accruing to the respondent.”<br>24. In Siddalingamma v. Mamtha Shenoy14, this Court held while allowing an amendment of the plaint in a case of bona fide requirement of the landlord that the doctrine of relation back would apply to all amendments made under Order 6 Rule 17 of the Code of Civil Procedure, which generally governs amendment of pleadings, unless the court gives reasons to exclude the applicability of such doctrine in a given case. No question of limitation was argued on the facts in that case which would therefore be in the category of cases which would follow the line of judgments which state that costs can usually compensate for an amendment that is made belatedly but within the period of limitation, it not being an exceptional case such as those contained in the two judgments L.J. Leach & Co. Ltd.11 and Pirgonda Hongonda Patil9 cited above.<br>25. In Sampath Kumar v. Ayyakannu15, this Court was faced with an application for amendment made 11 years after the date of the institution of the suit to convert through amendment a suit for permanent prohibitory injunction into a suit for declaration of title and recovery of possession. This Court held: (SCC pp. 562-64, paras 7 & 9-11)<br>“7. In our opinion, the basic structure of the suit is not altered by the proposed amendment. What is sought to be changed is the nature of relief sought for by the plaintiff. In the opinion of the trial court, it was open to the plaintiff to file a fresh suit and that is one of the reasons which has prevailed with the trial court and with the High Court in refusing the prayer for amendment and also in dismissing the plaintiff’s revision. We fail to understand, if it is permissible for the plaintiff to file an independent suit, why the same relief which could be prayed for in a new  suit cannot be permitted to be incorporated in the pending suit. In the facts and circumstances of the present case, allowing the amendment would curtail multiplicity of legal proceedings.<br>28. In Prithi Pal Singh v. Amrik Singh17, this Court was concerned with a suit claiming pre-emption under the Punjab Pre-emption Act, 1913. An amendment was sought to the plaint claiming that the plaintiff was entitled to relief as a co-sharer of the suit property. This Court after considering some of its earlier judgments held: (SCC p. 583, para 11)<br>“11. In our opinion, there is no merit in the submissions of the learned counsel. A reading of the order18 passed by this Court shows that the application for amendment filed by Respondent 2 was allowed without any rider/condition. Therefore, it is reasonable to presume that this Court was of the view that the amendment in the plaint would relate back to the date of filing the suit. That apart, the learned Single Judge19 has independently considered the issue of limitation and rightly concluded that the amended suit was not barred by time.”<br>29. Applying the law thus laid down by this Court to the facts of this case, two things become clear. First, in the original written statement itself dated 16-5-1990, the defendant had clearly put the plaintiff on notice that it had denied the plaintiff’s title to the suit property. A reading of an isolated paragraph in the written statement, namely, Para 2 by the trial court on the facts of this case has been correctly commented upon adversely by the High Court in the judgment under appeal. The original written statement read as a whole unmistakably indicates that the defendant had not accepted the plaintiff’s title. Secondly, while allowing the amendment, the High Court in its earlier judgment dated 28-3-2002 had expressly remanded the matter to the trial court, allowing the defendant to raise the plea of limitation. There can be no doubt that on an application of Khatri Hotels (P) Ltd.3, the right to sue for declaration of title first arose on the facts of the present case on 16-5-1990 when the original written statement clearly denied the plaintiff’s title. By 16-5-1993 therefore a suit based on declaration of title would have become time-barred. It is clear that the doctrine of relation back would not apply to the facts of this case for the reason that the court which allowed the amendment expressly allowed it subject to the plea of limitation, indicating thereby that there are no special or extraordinary circumstances in the present case to warrant the doctrine of relation back applying so that a legal right that had accrued in favour of the defendant should be taken away. This being so, we find no infirmity in the impugned judgment of the High Court. The present appeal is accordingly dismissed.</h4><h4><b>Judgments referred to in this case. <br></b></h4><h4>1<span style=\"white-space:pre\">	</span>L.C. Hanumanthappa v. H.B. Shivakumar, RFA No. 415 of 1999, decided on 28-3-2002 (KAR)<br>2<span style=\"white-space:pre\">	</span>H.B. Shivakumar v. L.C. Hanumanthappa, 2015 SCC OnLine Kar 3860<br>3<span style=\"white-space:pre\">	</span>(2011) 9 SCC 126 : (2011) 4 SCC (Civ) 484<br>4<span style=\"white-space:pre\">	</span>(1929-30) 57 IA 325 : AIR 1930 PC 270 : (1930) 32 LW 338<br>5<span style=\"white-space:pre\">	</span>ILR (1930) 8 Rang 645 : (1930-31) 58 IA 1 : (1931) 33 LW 30<br>6<span style=\"white-space:pre\">	</span>(1930-31) 58 IA 125 : (1931) 33 LW 707<br>7<span style=\"white-space:pre\">	</span>AIR 1960 SC 335 : (1960) 2 SCR 253<br>8<span style=\"white-space:pre\">	</span>ILR (1909) 33 Bom 644<br>9<span style=\"white-space:pre\">	</span>1957 SCR 595 : AIR 1957 SC 363<br>10<span style=\"white-space:pre\">	</span>(1919-20) 47 IA 255 : (1921) 13 LW 49<br>11<span style=\"white-space:pre\">	</span>1957 SCR 438 : AIR 1957 SC 357<br>12<span style=\"white-space:pre\">	</span>1995 Supp (3) SCC 17<br>13<span style=\"white-space:pre\">	</span>(2001) 6 SCC 163<br>14<span style=\"white-space:pre\">	</span>(2001) 8 SCC 561<br>15<span style=\"white-space:pre\">	</span>(2002) 7 SCC 559<br>16<span style=\"white-space:pre\">	</span>(2010) 14 SCC 596 : (2012) 1 SCC (Civ) 777<br>17<span style=\"white-space:pre\">	</span>(2013) 9 SCC 576 : (2013) 4 SCC (Civ) 473<br>18<span style=\"white-space:pre\">	</span>Bakshish Singh v. Prithi Pal Singh, 1995 Supp (3) SCC 577<br>19<span style=\"white-space:pre\">	</span>Prithi Pal Singh v. Amrik Singh, 2008 SCC OnLine P&H 267 : (2008) 3 RCR (Civ) 504<br></h4><div><br></div>', '8917d82c624ff92d8e8cf3a4a608fde7.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2015-08-26', 1, '', '', '2020-12-02 20:59:28', '2021-02-03 14:41:31'),
(91, '8RD6VNHftNmOvElZ6q0bTi37d', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Extradition of a fugitive criminal', '<div><b>Comprehensive judgement of Supreme Court on extradition of a fugitive criminal&nbsp;</b><b style=\"font-size: 0.875rem;\">Verhoeven, Marie-Emmanuelle vs Union of India &amp; Ors&nbsp;</b></div><div>Law- Extradition Act, 1962</div><div>Writ Petition (Criminal) 178 of 2015</div><div>Decided on April 28, 2016</div><div>Madan B. Lokur-J</div><div>N.V. Ramana-J</div><div><b><br></b></div><div><b>Judgment</b>: http://supremecourtofindia.nic.in/FileServer/2016-04-28_1461827428.pdf</div>', '0d44ab9422f7fe3de2297589271c0cc7.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:01:15', '2021-01-22 21:58:34'),
(92, 'EDN5OC02IFTcYo0zkGQCoWo59', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Transfer of Property Act. Agreement of Sale', '<b>Intending purchaser though in possession not taking any action for specific performance of the agreement. He cannot resist the suit for possession by the Vendor. Karnataka High Court. Regular First Appeal 154/1985 decided on 20 April 1994</b>', '9237a494d0d53f9072537d17e1a82b88.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:03:58', '2021-01-22 21:56:14'),
(93, '3JqcgQe2uiefjnDOjwXmzLLB3', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Article 226 Constitution of India – Cause of action', '<div><b>Even if a part of cause of action arises outside the jurisdiction of the High Court, it would have jurisdiction to issue a writ.&nbsp;&nbsp;</b></div><div><b>Nawal Kishore Sharma v. Union of India, (2014) 9 SCC 329.&nbsp;</b></div><div><b>(Kusum Ingots &amp; Alloys Ltd. v. Union of India (2004) 6 SCC 254 followed.)&nbsp;</b><br><br></div><div><b>Paragraphs:</b><br><p style=\"text-align: justify;\"><b><span style=\"font-size: 0.875rem;\">7. The short question that falls for consideration in the facts of the present case is that as to whether the Patna High Court is correct in taking the view that it has no jurisdiction to entertain the writ petition. For answering the said question we would like to consider the provision of Article 226 of the Constitution as it stood prior to amendment. Originally, Article 226 of the Constitution reads as under:<br></span>“226. Power of High Courts to issue certain writs.—(1) Notwithstanding anything in Article 32, every High Court shall have power, throughout the territories in relation to which it exercises jurisdiction, to issue to any person or authority, including in appropriate cases, any Government, within those territories, directions, orders or writs, including&nbsp; writs in the nature of habeas corpus, mandamus, prohibition, quo warranto and certiorari, or any of them, for the enforcement of any of the rights conferred by Part III and for any other purpose.<br>(2) The power conferred on a High Court by clause (1) shall not be in derogation of the power conferred on the Supreme Court by clause (2) of Article 32.”<br>8. While interpreting the aforesaid provision, the Constitution Bench of this Court in Election Commission v. Saka Venkata Rao2, held that the writ court would not run beyond the territories subject to its jurisdiction and that the person or the authority affected by the writ must be amenable to court’s jurisdiction either by residence or location within those territories. The rule that cause of action attracts jurisdiction in suits is based on statutory enactment and cannot apply to writs issued under Article 226 of the Constitution which makes no reference to any cause of action or where it arises but insist on the presence of the person or authority within the territories in relation to which the High Court exercises jurisdiction. In another Constitution Bench judgment of this Court in K.S. Rashid and Son v. Income Tax Investigation Commission3, this Court took the similar view and held that the writ court cannot exercise its power under Article 226 beyond its territorial jurisdiction. The Court was of the view that the exercise of power conferred by Article 226 was subject to a twofold limitation viz. firstly, the power is to be exercised in relation to which it exercises jurisdiction and secondly, the person or authority on whom the High Court is empowered to issue writ must be within those territories. These two Constitution Bench judgments came for consideration before a larger Bench of seven Judges of this Court in Lt. Col. Khajoor Singh v. Union of India4. The Bench approved the aforementioned two Constitution Bench judgments and opined that unless there are clear and compelling reasons, which cannot be denied, writ court cannot exercise jurisdiction under Article 226 of the Constitution beyond its territorial jurisdiction.<br>9. The interpretation given by this Court in the aforesaid decisions resulted in undue hardship and inconvenience to the citizens to invoke writ jurisdiction. As a result, clause (1-A) was inserted in Article 226 by the Constitution (Fifteenth) Amendment Act, 1963 and subsequently renumbered as clause (2) by the Constitution (Forty-second) Amendment Act, 1976. The amended clause (2) now reads as under:<br>“226. Power of High Courts to issue certain writs.—(1) Notwithstanding anything in Article 32, every High Court shall have power, throughout the territories in relation to which it exercises jurisdiction, to issue to any person or authority, including in appropriate cases any Government, within those territories, directions, orders or writs, including writs in the nature of habeas corpus, mandamus, prohibition, quo warranto&nbsp; and certiorari, or any of them, for the enforcement of any of the rights conferred by Part III and for any other purpose<br>(2) The power conferred by clause (1) to issue directions, orders or writs to any Government, authority or person may also be exercised by any High Court exercising jurisdiction in relation to the territories within which the cause of action, wholly or in part, arises for the exercise of such power, notwithstanding that the seat of such Government or authority or the residence of such person is not within those territories.<br>On a plain reading of the amended provisions in clause (2), it is clear that now the High Court can issue a writ when the person or the authority against whom the writ is issued is located outside its territorial jurisdiction, if the cause of action wholly or partially arises within the court’s territorial jurisdiction. Cause of action for the purpose of Article 226(2) of the Constitution, for all intent and purpose must be assigned the same meaning as envisaged under Section 20(c) of the Code of Civil Procedure. The expression cause of action has not been defined either in the Code of Civil Procedure or the Constitution. Cause of action is bundle of facts which is necessary for the plaintiff to prove in the suit before he can succeed. The term “cause of action” as appearing in clause (2) came up for consideration time and again before this Court.<br>10. In State of Rajasthan v. Swaika Properties5, the fact was that the respondent Company having its registered office in Calcutta owned certain land on the outskirts of Jaipur City, was served with notice for acquisition of land under the Rajasthan Urban Improvement Act, 1959. Notice was duly served on the Company at its registered office in Calcutta. The Company, first appeared before the Special Court and finally the Calcutta High Court by filing a writ petition challenging the notification of acquisition. The matter ultimately came before this Court to answer a question as to whether the service of notice under Section 52(2) of the Act at the registered office of the respondent in Calcutta was an integral part of cause of action and was it sufficient to invest the Calcutta High Court with a jurisdiction to entertain the petition challenging the impugned notification. Answering the question this Court held: (Swaika Properties case5, SCC pp. 222-23, paras 7-8)<br>&nbsp;“7. Upon these facts, we are satisfied that the cause of action neither wholly nor in part arose within the territorial limits of the Calcutta High Court and therefore the learned Single Judge had no jurisdiction to issue a rule nisi on the petition filed by the respondents under Article 226 of the Constitution or to make the ad interim ex parte prohibitory order restraining the appellants from taking any steps to take possession of the land acquired. Under sub-section (5) of Section 52 of the Act the appellants were entitled to require the respondents to surrender or deliver possession of the lands acquired forthwith and upon their failure to do so,&nbsp; take immediate steps to secure such possession under sub-section (6) thereof.<br>8. The expression ‘cause of action’ is tersely defined in Mulla’s Code of Civil Procedure:<br>‘The “cause of action” means every fact which, if traversed, it would be necessary for the plaintiff to prove in order to support his right to a judgment of the court.’<br>In other words, it is a bundle of facts which taken with the law applicable to them gives the plaintiff a right to relief against the defendant. The mere service of notice under Section 52(2) of the Act on the respondents at their registered office at 18-B, Brabourne Road, Calcutta i.e. within the territorial limits of the State of West Bengal, could not give rise to a cause of action within that territory unless the service of such notice was an integral part of the cause of action. The entire cause of action culminating in the acquisition of the land under Section 52(1) of the Act arose within the State of Rajasthan i.e. within the territorial jurisdiction of the Rajasthan High Court at the Jaipur Bench. The answer to the question whether service of notice is an integral part of the cause of action within the meaning of Article 226(2) of the Constitution must depend upon the nature of the impugned order giving rise to a cause of action. The Notification dated 8-2-1984 issued by the State Government under Section 52(1) of the Act became effective the moment it was published in the Official Gazette as thereupon the notified land became vested in the State Government free from all encumbrances. It was not necessary for the respondents to plead the service of notice on them by the Special Officer, Town Planning Department, Jaipur under Section 52(2) for the grant of an appropriate writ, direction or order under Article 226 of the Constitution for quashing the notification issued by the State Government under Section 52(1) of the Act. If the respondents felt aggrieved by the acquisition of their lands situate at Jaipur and wanted to challenge the validity of the notification issued by the State Government of Rajasthan under Section 52(1) of the Act by a petition under Article 226 of the Constitution, the remedy of the respondents for the grant of such relief had to be sought by filing such a petition before the Rajasthan High Court, Jaipur Bench, where the cause of action wholly or in part arose.”<br>11. This provision was again considered by this Court in Oil and Natural Gas Commission v. Utpal Kumar Basu6. In this case the petitioner Oil and Natural Gas Commission (ONGC) through its consultant Engineers India Limited (EIL) issued an advertisement in the newspaper inviting tenders for setting up of Kerosene Recovery Processing Unit in Gujarat mentioning that the tenders containing offers were to be communicated to EIL, New Delhi. After the final decision was taken by the Steering Committee at New Delhi, the respondent NICCO moved the Calcutta High Court praying that ONGC be&nbsp; restrained from awarding the contract to any other party. It was pleaded in the petition that NICCO came to know of the tender from the publication in the Times of India within the jurisdiction of the Calcutta High Court. This Court by setting aside the order passed by the Calcutta High Court came to the following conclusion: (Utpal Kumar Basu case6, SCC p. 717, para 6)<br>“6. Therefore, in determining the objection of lack of territorial jurisdiction the court must take all the facts pleaded in support of the cause of action into consideration albeit without embarking upon an enquiry as to the correctness or otherwise of the said facts. In other words the question whether a High Court has territorial jurisdiction to entertain a writ petition must be answered on the basis of the averments made in the petition, the truth or otherwise whereof being immaterial. To put it differently, the question of territorial jurisdiction must be decided on the facts pleaded in the petition. Therefore, the question whether in the instant case the Calcutta High Court had jurisdiction to entertain and decide the writ petition in question even on the facts alleged must depend upon whether the averments made in paras 5, 7, 18, 22, 26 and 43 are sufficient in law to establish that a part of the cause of action had arisen within the jurisdiction of the Calcutta High Court.”<br>12. In Kusum Ingots &amp; Alloys Ltd. v. Union of India7, this Court elaborately discussed clause (2) of Article 226 of the Constitution, particularly the meaning of the word “cause of action” with reference to Section 20(c) and Section 141 of the Code of Civil Procedure and observed: (SCC p. 259, paras 9-10)<br>“9. Although in view of Section 141 of the Code of Civil Procedure the provisions thereof would not apply to writ proceedings, the phraseology used in Section 20(c) of the Code of Civil Procedure and clause (2) of Article 226, being in pari materia, the decisions of this Court rendered on interpretation of Section 20(c) CPC shall apply to the writ proceedings also. Before proceeding to discuss the matter further it may be pointed out that the entire bundle of facts pleaded need not constitute a cause of action as what is necessary to be proved before the petitioner can obtain a decree is the material facts. The expression material facts is also known as integral facts.<br>10. Keeping in view the expressions used in clause (2) of Article 226 of the Constitution of India, indisputably even if a small fraction of cause of action accrues within the jurisdiction of the Court, the Court will have jurisdiction in the matter.”<br>Their Lordships further observed as under: (Kusum Ingots &amp; Alloys Ltd. case7, SCC p. 264, paras 29-30)<br>“29. In view of clause (2) of Article 226 of the Constitution of India, now if a part of cause of action arises outside the jurisdiction of the High&nbsp; Court, it would have jurisdiction to issue a writ. The decision in Khajoor Singh4 has, thus, no application.<br>Forum conveniens<br>30. We must, however, remind ourselves that even if a small part of cause of action arises within the territorial jurisdiction of the High Court, the same by itself may not be considered to be a determinative factor compelling the High Court to decide the matter on merit. In appropriate cases, the Court may refuse to exercise its discretionary jurisdiction by invoking the doctrine of forum conveniens.”<br>13. In Union of India v. Adani Exports Ltd.8, this Court held that in order to confer jurisdiction on a High Court to entertain a writ petition it must disclose that the integral facts pleaded in support of the cause of action do constitute a cause so as to empower the Court to decide the dispute and the entire or a part of it arose within its jurisdiction. Each and every fact pleaded by the respondents in their application does not ipso facto lead to the conclusion that those facts give rise to a cause of action within the Court’s territorial jurisdiction unless those facts are such which have a nexus or relevance with the lis i.e. involved in the case. This Court observed: (SCC pp. 573-74, para 17)<br>“17. It is seen from the above that in order to confer jurisdiction on a High Court to entertain a writ petition or a special civil application as in this case, the High Court must be satisfied from the entire facts pleaded in support of the cause of action that those facts do constitute a cause so as to empower the court to decide a dispute which has, at least in part, arisen within its jurisdiction. It is clear from the above judgment that each and every fact pleaded by the respondents in their application does not ipso facto lead to the conclusion that those facts give rise to a cause of action within the court’s territorial jurisdiction unless those facts pleaded are such which have a nexus or relevance with the lis that is involved in the case. Facts which have no bearing with the lis or the dispute involved in the case, do not give rise to a cause of action so as to confer territorial jurisdiction on the court concerned. If we apply this principle then we see that none of the facts pleaded in para 16 of the petition, in our opinion, falls into the category of bundle of facts which would constitute a cause of action giving rise to a dispute which could confer territorial jurisdiction on the courts at Ahmedabad.”<br>14. In Om Prakash Srivastava v. Union of India9, answering a similar question this Court observed that on a plain reading of clause (2) of Article 226 it is manifestly clear that the High Court can exercise power to issue direction, order or writs for the enforcement of any of the fundamental rights or for any other purpose if the cause of action in relation to which it exercises jurisdiction notwithstanding that the seat of the Government or&nbsp; authority or the residence of the person against whom the direction, order or writ is issued is not within the said territory. In para 7 this Court observed: (SCC p. 210)<br>&nbsp;“7. The question whether or not cause of action wholly or in part for filing a writ petition has arisen within the territorial limits of any High Court has to be decided in the light of the nature and character of the proceedings under Article 226 of the Constitution. In order to maintain a writ petition, a writ petitioner has to establish that a legal right claimed by him has prima facie either been infringed or is threatened to be infringed by the respondent within the territorial limits of the Court’s jurisdiction and such infringement may take place by causing him actual injury or threat thereof.”<br>15. In Rajendran Chingaravelu v. CIT10, this Court while considering the scope of Article 226(2) of the Constitution, particularly the cause of action in maintaining a writ petition, held as under: (SCC p. 461, paras 9 &amp; 11)<br>“9. The first question that arises for consideration is whether the Andhra Pradesh High Court was justified in holding that as the seizure took place at Chennai (Tamil Nadu), the appellant could not maintain the writ petition before it. The High Court did not examine whether any part of cause of action arose in Andhra Pradesh. Clause (2) of Article 226 makes it clear that the High Court exercising jurisdiction in relation to the territories within which the cause of action arises wholly or in part, will have jurisdiction. This would mean that even if a small fraction of the cause of action (that bundle of facts which gives a petitioner, a right to sue) accrued within the territories of Andhra Pradesh, the High Court of that State will have jurisdiction.<br>* * *<br>11. Normally, we would have set aside the order and remitted the matter to the High Court for decision on merits. But from the persuasive submissions of the appellant, who appeared in person on various dates of hearing, two things stood out. Firstly, it was clear that the main object of the petition was to ensure that at least in future, passengers like him are not put to unnecessary harassment or undue hardship at the airports. He wants a direction for issuance of clear guidelines and instructions to the inspecting officers, and introduction of definite and efficient verification/investigation procedures. He wants changes in the present protocol where the officers are uncertain of what to do and seek instructions and indefinitely wait for clearances from higher-ups for each and every routine step, resulting in the detention of passengers for hours and hours. In short, he wants the enquiries, verifications and investigations to be efficient, passenger-friendly and courteous. Secondly, he wants the Department/officers concerned to acknowledge that he was unnecessarily harassed.”<br>&nbsp;16. Regard being had to the discussion made hereinabove, there cannot be any doubt that the question whether or not cause of action wholly or in part for filing a writ petition has arisen within the territorial limit of any High Court has to be decided in the light of the nature and character of the proceedings under Article 226 of the Constitution. In order to maintain a writ petition, the petitioner has to establish that a legal right claimed by him has been infringed by the respondents within the territorial limit of the Court’s jurisdiction.<br>17. We have perused the facts pleaded in the writ petition and the documents relied upon by the appellant. Indisputably, the appellant reported sickness on account of various ailments including difficulty in breathing. He was referred to hospital. Consequently, he was signed off for further medical treatment. Finally, the respondent permanently declared the appellant unfit for sea service due to dilated cardiomyopathy (heart muscle disease). As a result, the Shipping Department of the Government of India issued an Order on 12-4-2011 cancelling the registration of the appellant as a seaman. A copy of the letter was sent to the appellant at his native place in Bihar where he was staying after he was found medically unfit. It further appears that the appellant sent a representation from his home in the State of Bihar to the respondent claiming disability compensation. The said representation was replied by the respondent, which was addressed to him on his home address in Gaya, Bihar rejecting his claim for disability compensation. It is further evident that when the appellant was signed off and declared medically unfit, he returned back to his home in the district of Gaya, Bihar and, thereafter, he made all claims and filed representation from his home address at Gaya and those letters and representations were entertained by the respondents and replied and a decision on those representations were communicated to him on his home address in Bihar. Admittedly, the appellant was suffering from serious heart muscle disease (dilated cardiomyopathy) and breathing problem which forced him to stay in his native place, wherefrom he had been making all correspondence with regard to his disability compensation. Prima facie, therefore, considering all the facts together, a part or fraction of cause of action arose within the jurisdiction of the Patna High Court where he received a letter of refusal disentitling him from disability compensation.<br>18. Apart from that, from the counter-affidavit of the respondents and the documents annexed therewith, it reveals that after the writ petition was filed in the Patna High Court, the same was entertained and notices were issued. Pursuant to the said notice, the respondents appeared and participated in the proceedings in the High Court. It further reveals that after hearing the counsel appearing for both the parties, the High Court passed an interim order on 18-9-201211 directing the authorities of Shipping Corpn. of India to pay at least a sum of Rs 2.75 lakhs, which shall be subject to the result of the writ petition. Pursuant to the interim order, the respondent Shipping Corpn. of India remitted Rs 2,67,270 (after deduction of income tax) to the bank&nbsp; account of the appellant. However, when the writ petition was taken up for hearing, the High Court took the view that no cause of action, not even a fraction of cause of action, has arisen within its territorial jurisdiction.<br>19. Considering the entire facts of the case narrated hereinbefore including the interim order11 passed by the High Court, in our considered opinion, the writ petition ought not to have been dismissed for want of territorial jurisdiction. As noticed above, at the time when the writ petition was heard for the purpose of grant of interim relief, the respondents instead of raising any objection with regard to the territorial jurisdiction opposed the prayer on the ground that the appellant-writ petitioner was offered an amount of Rs 2.75 lakhs, but he refused to accept the same and challenged the order granting severance compensation by filing the writ petition. The impugned order, therefore, cannot be sustained in the peculiar facts and circumstances of this case.<br>20. In the aforesaid, the appeal is allowed and the impugned order1 passed by the High Court is set aside and the matter is remitted to the High Court for deciding the writ petition on merits.<br>———<br>† Arising out of SLP (C) No. 19549 of 2013. From the Judgment and Order dated 16-4-2013 in CWJC No. 3160 of 2012 passed by the High Court of Patna<br>1 Nawal Kishore Sharma v. Union of India, CWJC No. 3160 of 2012, decided on 16-4-2013 (Pat)<br>2 AIR 1953 SC 210<br>3 AIR 1954 SC 207<br>4 Lt. Col. Khajoor Singh v. Union of India, AIR 1961 SC 532<br>5 (1985) 3 SCC 217<br>6 Oil and Natural Gas Commission v. Utpal Kumar Basu, (1994) 4 SCC 711<br>7 (2004) 6 SCC 254<br>8 (2002) 1 SCC 567<br>9 (2006) 6 SCC 207 : (2006) 3 SCC (Cri) 24<br>10 (2010) 1 SCC 457 : (2010) 1 SCC (Cri) 810<br>11 Nawal Kishore Sharma v. Union of India, CWJC No. 3160 of 2012, order dated 18-9-2012 (Pat)</b></p></div>', '93e946d6f100c2e3c1db534d0b83e62a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:05:36', '2021-01-22 17:10:15'),
(94, 'wBFNR0ijXAeBOoLecnMS0mndg', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Grant of ex-parte temporary injunction.', '<div><b>Law laid down in Shiv Kumar Chadha v. Municipal Corpn. of Delhi, (1993) 3 SCC 161.&nbsp;</b></div><div><br><blockquote class=\"blockquote\"><b>Paragraphs:&nbsp;<br></b><span style=\"font-size: 0.875rem;\">Para 35. As such whenever a court considers it necessary in the facts and circumstances of a particular case to pass an order of injunction without notice to other side, it must record the reasons for doing so and should take into consideration, while passing an order of injunction, all relevant factors, including as to how the object of granting injunction itself shall be defeated if an ex parte order is not passed. But any such ex parte order should be in force up to a particular date before which the plaintiff should be required to serve the notice on the defendant concerned.&nbsp;<br></span><span style=\"font-size: 0.875rem;\">Para 36. Accordingly we direct that the application for interim injunction should be considered and disposed of in the following manner:<br></span><span style=\"font-size: 0.875rem;\">(i) The court should first direct the plaintiff to serve a copy of the application with a copy of the plaint along with relevant documents on the counsel for the Corporation or any competent authority of the Corporation and the order should be passed only after hearing the parties.<br></span><span style=\"font-size: 0.875rem;\">(ii) If the circumstances of a case so warrant and where the court is of the opinion, that the object of granting the injunction would be defeated by delay, the court should record reasons for its opinion as required by proviso to Rule 3 of Order 39 of the Code, before passing an order for injunction. The court must direct that such order shall operate only for a period of two weeks, during which notice along with copy of the application, plaint and relevant documents should be served on the competent authority or the counsel for the Corporation. Affidavit of service of notice should be filed as provided by proviso to Rule 3 of Order 39 aforesaid. If the Corporation has entered appearance, any such ex parte order of injunction should be extended only after hearing the counsel for the Corporation.<br></span><span style=\"font-size: 0.875rem;\">(iii) While passing an ex parte order of injunction the court shall direct the plaintiff to give an undertaking that he will not make any further construction upon the premises till the application for injunction is finally heard and disposed of.</span></blockquote><p></p><br><p></p></div>', '9955461be08d4f9614685869f76f2751.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:08:40', '2021-01-22 17:05:50'),
(95, 'lSHAhwec0OsVewciQHOBTO4LG', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Is a Sanyasi barred from claiming property to which he is otherwise entitled to?', '<div><b>Can a person who became ‘Sanyasi’ giving up all worldly possessions as per Shastras, but without executing a registered release deed, claim partition of the joint family properties.?&nbsp;</b></div><div><b>If someone embraces Sanyas, that may amount to civil death leading to succession of his own properties among his heirs. But whether he himself is completely barred from re-claiming the properties after embracing Sanyas or, to say, giving up Sanyas and embracing his original avtar. ?</b></div><div><br>The earliest judgment on Sanyasi is Avasarala Kondal Row And Anr. vs Iswara Sanyasi Swamulavaru Alias decided on 13 February, 1917 reported in (1917) 33 MLJ 63, from which the above passage is extracted. - The postulant for Sanyasam after learning the duties of a Sanyasi should first perform his death ceremonies,--this however is by some not considered necessary,--and the eight sradhas the last of which is his own sradha; he must then distribute his wealth to his sons and brahmins reserving enough for the homam (sacrifice in the fire) to be subsequently performed. Then he has to perform Prajapathyeshti or Agneshti and finally Viraja Homam. These are sacrifices in fire and are purificatory ceremonies. At the end of ceremonies the postulant has no property at all for even the sacrificial vessels if they are of wood must be burnt in the fire and if they are of metal must be given to the priest. After these are done he takes leave of his sons, and standing in water takes some water in his hand and drops it saying that he has given up desire for sons, wealth, world and everything (Sarva Thyagam). He makes a vow that he will not injure any living being. Finally there is the uttering of the \' Praisha Mahtram,\' The literal meaning of the. Mantram is \'have been given up by me\' (Sanyastham maya). The mantram is to be pronounced low three times, and loud twice and till the mantram is pronounced the man does not become a Sanyasi. The above is common to all Sanyasams, but there is a difference of opinion as to the discarding of the sacred thread, as to the shaving of the tuft and as to the number of sticks in the staff. This is due to certain doctrinal differences which it is unnecessary to deal with for the present purpose beyond saying this; that the discarding of the holy thread which implies the giving up of all the duties prescribed not merely for the order (Ashrama), but also for the caste (varna) including the obligatory Sandhyavandanam, is proper only to the highest kind of Sanyasi, Paramahamsa. It is to be observed that the essential feature of Sanyasam is the actually relinquishment of all property and an actual abandonment of all worldly concerns, down to even a desire for them; and it is said in the most emphatic terms that a person adopting Sanyasam, without this abandonment of all desires (vairagyam) goes to fearful narakam (Dharma Sindhu, page 364). The rule as to inheritance is explained by the commentators as applying to the staff, water pot, and sandals of a Sanyasi, which alone is permitted to him (Manu, Ch. VI, verse 41 \'Pavitropakitiah\'). Without actually relinquishing or abandoning his property a man cannot become a Sanyasi.</div><div>Pollock and Maitland\'s \' in the ‘History of English Law \' say, \"A monk or nun cannot acquire or have any proprietary rights. When a man becomes \'professed in religion\' his heir at once inherits from him any land that he has, and, if he has made a will it takes effect at once as though he were dead. If after this a kinsman of his dies leaving land which according to the ordinary rules of inheritance would descend, he is overlooked as though he were no longer in the land of the living; the inheritance misses him and passes to some more distant relative. The rule is not that what descends to him belongs to the house of which he is an inmate; nothing descends to him for he is already dead. In the eye of Ecclesiastical law the monk who became a proprietarius, the monk, that is, who arrogated to himself any proprietary rights on the separate enjoyment of any wealth, committed about as bad an offence as he could commit.\" Except that the Smriti writers and commentators had no conception of a will, the above passage accurately represents the status of a Sanyasi under the Hindu Law. It does not seem to be necessary that there should be an actual transfer to, or a relinquishment in favour of any particular person, but one about to become a Sanyasi may simply abandon his property in which case the law will vest it in his heirs. In the Dayabhaga in the very beginning where the author discusses the meaning of the word \'Daya\' and origin of right to property, he points out that not merely by gift, but by death, Sanyasam, etc., the right of the previous owner is lost, and that of the successor begins. The same principle is applied in fixing the time for partition. The author explains that the phrase \"the death of the father \" does not necessarily mean actual death, but includes Sanyasam.</div><div>But the judgment is silent on the right of ‘Sanyasi’ to claim ancestral property through partition. Is there a provision under the Hindu Succession Act.</div>', '0aa45d6705fea58150f6404325d72c55.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:09:31', '2021-01-22 16:59:30');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(96, 'xjyrFNhXYXA9UwSsyOruVD4SV', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitration and Conciliation Act, 1996. Disability of an arbitrator after 2015 amendment', '<div style=\"text-align: justify;\">The disabled arbitrator can NOT nominate another person as an arbitrator.</div><div style=\"text-align: justify;\">(Managing Director of a Govt company for example, becomes disabled after 2015 amendment to arbitrate on the disputes)</div><div style=\"text-align: justify;\">- TRF Limited vs Energo Engineering Project Limited&nbsp;</div><div style=\"text-align: justify;\">(2017) 8 SCC 377</div><div style=\"text-align: justify;\">2015 Amendment:&nbsp;</div><div style=\"text-align: justify;\">In section 12 of the principal Act,— (i) for sub-section (1), the following sub-section shall be substituted, namely:— “(1) When a person is approached in connection with his possible appointment as an arbitrator, he shall disclose in writing any circumstances,— (a) such as the existence either direct or indirect, of any past or present relationship with or interest in any of the parties or in relation to the subject-matter in dispute, whether financial, business, professional or other kind, which is likely to give rise to justifiable doubts as to his independence or impartiality; and (b) which are likely to affect his ability to devote sufficient time to the arbitration and in particular his ability to complete the entire arbitration within a period of twelve months.</div><div style=\"text-align: justify;\">Explanation 1.—The grounds stated in the Fifth Schedule shall guide in determining whether circumstances exist which give rise to justifiable doubts as to the independence or impartiality of an arbitrator.&nbsp;</div><div style=\"text-align: justify;\">Explanation 2.—The disclosure shall be made by such person in the form specified in the Sixth Schedule.”; (ii) after sub-section (4), the following sub-section shall be inserted, namely:—&nbsp;</div><div style=\"text-align: justify;\">“(5) Notwithstanding any prior agreement to the contrary, any person whose relationship, with the parties or counsel or the subject-matter of the dispute, falls under any of the categories specified in the Seventh Schedule shall be ineligible to be appointed as an arbitrator: Provided that parties may, subsequent to disputes having arisen between them, waive the applicability of this sub-section by an express agreement in writing.</div><div style=\"text-align: justify;\">THE SEVENTH SCHEDULE [See section 12 (5)] Arbitrator’s relationship with the parties or counsel&nbsp;</div><div style=\"text-align: justify;\">1. The arbitrator is an employee, consultant, advisor or has any other past or present business relationship with a party.&nbsp;</div><div style=\"text-align: justify;\">2. The arbitrator currently represents or advises one of the parties or an affiliate of one of the parties.&nbsp;</div><div style=\"text-align: justify;\">3. The arbitrator currently represents the lawyer or law firm acting as counsel for one of the parties.&nbsp;</div><div style=\"text-align: justify;\">4. The arbitrator is a lawyer in the same law firm which is representing one of the parties.&nbsp;</div><div style=\"text-align: justify;\">5. The arbitrator is a manager, director or part of the management, or has a similar controlling influence, in an affiliate of one of the parties if the affiliate is directly involved in the matters in dispute in the arbitration.&nbsp;</div><div style=\"text-align: justify;\">6. The arbitrator’s law firm had a previous but terminated involvement in the case without the arbitrator being involved himself or herself.&nbsp;</div><div style=\"text-align: justify;\">7. The arbitrator’s law firm currently has a significant commercial relationship with one of the parties or an affiliate of one of the parties.&nbsp;</div><div style=\"text-align: justify;\">8. The arbitrator regularly advises the appointing party or an affiliate of the appointing party even though neither the arbitrator nor his or her firm derives a significant financial income therefrom.&nbsp;</div><div style=\"text-align: justify;\">9. The arbitrator has a close family relationship with one of the parties and in the case of companies with the persons in the management and controlling the company.&nbsp;</div><div style=\"text-align: justify;\">10. A close family member of the arbitrator has a significant financial interest in one of the parties or an affiliate of one of the parties.&nbsp;</div><div style=\"text-align: justify;\">11. The arbitrator is a legal representative of an entity that is a party in the arbitration. 12. The arbitrator is a manager, director or part of the management, or has a similar controlling influence in one of the parties.&nbsp;</div><div style=\"text-align: justify;\">13. The arbitrator has a significant financial interest in one of the parties or the outcome of the case.&nbsp;</div><div style=\"text-align: justify;\">14. The arbitrator regularly advises the appointing party or an affiliate of the appointing party, and the arbitrator or his or her firm derives a significant financial income therefrom. Relationship of the arbitrator to the dispute&nbsp;</div><div style=\"text-align: justify;\">15. The arbitrator has given legal advice or provided an expert opinion on the dispute to a party or an affiliate of one of the parties.&nbsp;</div><div style=\"text-align: justify;\">16. The arbitrator has previous involvement in the case. Arbitrator’s direct or indirect interest in the dispute&nbsp;</div><div style=\"text-align: justify;\">17. The arbitrator holds shares, either directly or indirectly, in one of the parties or an affiliate of one of the parties that is privately held.&nbsp;</div><div style=\"text-align: justify;\">18. A close family member of the arbitrator has a significant financial interest in the outcome of the dispute. a third party who may be liable to recourse on the part of the unsuccessful party in the dispute.&nbsp;</div><div style=\"text-align: justify;\">Explanation 1.—The term “close family member” refers to a spouse, sibling, child, parent or life partner. Explanation 2.—The term “affiliate” encompasses all companies in one group of companies including the parent company.&nbsp;</div><div style=\"text-align: justify;\">Explanation 3.—For the removal of doubts, it is clarified that it may be the practice in certain specific kinds of arbitration, such as maritime or commodities arbitration, to draw arbitrators from a small, specialised pool. If in such fields it is the custom and practice for parties frequently to appoint the same arbitrator in different cases, this is a relevant fact to be taken into account while applying the rules set out above.’.</div>', 'c0e47ece612ddd8c37c5c183ac83fe63.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:11:41', '2021-01-22 16:58:05'),
(97, 'HgFGAmI1Nu7DFvfs36DNKbstd', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Law – Meaning of “Cognizance” defined', '<div><b>S.R. Sukumar v. S. Sunaad Raghuram, (2015) 9 SCC 609</b></div><div><br><div style=\"text-align: justify;\"><b style=\"font-size: 0.875rem;\">Paragraphs:<br></b><span style=\"font-size: 0.875rem; text-align: left;\"><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">8. Section 200 CrPC provides for the procedure for the Magistrate taking cognizance of an offence on complaint. The Magistrate is not bound to take cognizance of an offence merely because a complaint has been filed before him when in fact the complaint does not disclose a cause of action. The language in Section 200 CrPC</span></div></span><div><span style=\"font-size: 0.875rem;\">“A Magistrate taking cognizance of an offence on complaint shall examine upon oath the complainant and the witnesses present, if any…”</span></div><div><span style=\"font-size: 0.875rem;\">clearly suggests that for taking cognizance of an offence on complaint, the court shall examine the complainant upon oath. The object of examination of the complainant is to find out whether the complaint is justifiable or is vexatious. Merely because the complainant was examined that does not mean that the Magistrate has taken cognizance of the offence. Taking cognizance of an offence means the Magistrate must have judicially applied the mind to the contents of the complaint and indicates that the Magistrate takes judicial notice of an offence.<br></span><span style=\"font-size: 0.875rem;\">9. Mere presentation of the complaint and receipt of the same in the court does not mean that the Magistrate has taken cognizance of the offence. In Narsingh Das Tapadia v. Goverdhan Das Partani2 it was held that the mere presentation of a complaint cannot be held to mean that the Magistrate has taken the cognizance.</span></div></div><span style=\"font-size: 0.875rem;\"><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">10. In Subramanian Swamy v. Manmohan Singh3 this Court explained the meaning of the word “cognizance” holding that: (SCC p. 90, para 34)</span></div></span><span style=\"font-size: 0.875rem;\"><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">“34. … In legal parlance cognizance is ‘taking judicial notice by the court of law, possessing jurisdiction, on a cause or matter presented before it so as to decide whether there is any basis for initiating proceedings and determination of the cause or matter judicially’.”<br></span><span style=\"font-size: 0.875rem; text-align: left;\">11. Section 200 CrPC contemplates a Magistrate taking cognizance of an offence on complaint to examine the complaint and examine upon oath the complainant and the witnesses present, if any. Then normally three courses are available to the Magistrate. The Magistrate can either issue summons to the accused or order an inquiry under Section 202 CrPC or dismiss the complaint under Section 203 CrPC. Upon consideration of the statement of the complainant and the material adduced at that stage if the Magistrate is satisfied that there are sufficient grounds to proceed, he can proceed to issue process under Section 204 CrPC. Section 202 CrPC contemplates “postponement of issue of process”. It provides that the Magistrate on receipt of a complaint of an offence, of which he is authorised to take cognizance may, if he thinks fit, postpone the issue of process for compelling the attendance of the person complained against, and either inquire into the case himself, or have an inquiry made by any Magistrate subordinate to him, or an investigation made by a police officer, or by some other person for the purpose of deciding whether or not there is sufficient ground for proceeding. If the Magistrate finds no sufficient ground for proceeding, he can dismiss the complaint by recording briefly the reasons for doing so as contemplated under Section 203 CrPC. A Magistrate takes cognizance of an offence when he decides to proceed against the person accused of having committed that offence and not at the time when the Magistrate is just informed either by the complainant by filing the complaint or by the police report about the commission of an offence.</span></div></span><span style=\"font-size: 0.875rem;\">12. “Cognizance” therefore has a reference to the application of judicial mind by the Magistrate in connection with the commission of an offence and not merely to a Magistrate learning that some offence had been committed. Only upon examination of the complainant, the Magistrate will proceed to apply the judicial mind whether to take cognizance of the offence or not. Under Section 200 CrPC, when the complainant is examined, the Magistrate cannot be said to have ipso facto taken the cognizance, when the Magistrate was merely gathering the material on the basis of which he will decide whether a prima facie case is made out for taking cognizance of the offence or not. “Cognizance of offence” means taking notice of the accusations and applying the judicial mind to the contents of the complaint and the material filed therewith. It is neither practicable nor desirable to define as to what is meant by taking cognizance. Whether the Magistrate has taken cognizance of the offence or not will depend upon the facts and circumstances of the particular case.<br></span><span style=\"font-size: 0.875rem;\">13. In Chief Enforcement Officer v. Videocon International Ltd.4, considering the scope of the expression “cognizance” it was held as under: (SCC p. 499, para 19)<br></span><span style=\"font-size: 0.875rem;\">“19. The expression ‘cognizance’ has not been defined in the Code. But the word (cognizance) is of indefinite import. It has no esoteric or mystic significance in criminal law. It merely means ‘become aware of’ and when used with reference to a court or a Judge, it connotes ‘to take notice of judicially’. It indicates the point when a court or a Magistrate takes judicial notice of an offence with a view to initiating proceedings in respect of such offence said to have been committed by someone.”<br></span><span style=\"font-size: 0.875rem;\">14. A three-Judge Bench of this Court in R.R. Chari v. State of U.P.5, while considering what the phrase “taking cognizance” means, approved the decision of the Calcutta High Court in Supt. and Remembrancer of Legal Affairs v. Abani Kumar Banerjee6, wherein it was observed that: (R.R. Chari case5, AIR p. 210, para 9)<br></span><span style=\"font-size: 0.875rem;\">“9. …‘What is “taking cognizance” has not been defined in the Criminal Procedure Code and I have no desire now to attempt to define it. It seems to me clear, however, that before it can be said that any Magistrate has taken cognizance of any offence under Section 190(1)(a) of the Criminal Procedure Code, he must not only have applied his mind to the contents of the petition, but he must have done so for the purpose of proceeding in a particular way as indicated in the subsequent provisions of this Chapter—proceeding under Section 200, and thereafter sending it for enquiry and report under Section 202. When the Magistrate applies his mind not for the purpose of proceeding under the subsequent sections of this Chapter, but for taking action of some other kind e.g. ordering investigation under Section 156(3), or issuing a search warrant for the purpose of the investigation, he cannot be said to have taken cognizance of the offence.’ (Supt. and Remembrancer of Legal Affairs case6, SCC OnLine Cal, para 8)”<br></span><span style=\"font-size: 0.875rem;\">(emphasis supplied)<br></span><span style=\"font-size: 0.875rem;\">The same view was reiterated by this Court in Jamuna Singh v. Bhadai Shah7 and Nirmaljit Singh Hoon v. State of W.B.8<br></span><span style=\"font-size: 0.875rem;\">15. Elaborating upon the words of the expression “taking cognizance” of an offence by a Magistrate within the contemplation of Section 190 CrPC, in Devarapalli Lakshminarayana Reddy v. V. Narayana Reddy9 this Court held as under: (SCC p. 257, para 14)<br></span><span style=\"font-size: 0.875rem;\">“14. … But from the scheme of the Code, the content and marginal heading of Section 190 and the caption of Chapter XIV under which Sections 190 to 199 occur, it is clear that a case can be said to be instituted in a court only when the court takes cognizance of the offence alleged therein. The ways in which such cognizance can be taken are set out in clauses (a), (b) and (c) of Section 190(1). Whether the Magistrate has or has not taken cognizance of the offence will depend on the circumstances of the particular case including the mode in which the case is sought to be instituted, and the nature of the preliminary action, if any, taken by the Magistrate. Broadly speaking, when on receiving a complaint, the Magistrate applies his mind for the purposes of proceeding under Section 200 and the succeeding sections in Chapter XV to the Code of 1973, he is said to have taken cognizance of the offence within the meaning to Section 190(1)(a). If, instead of proceeding under Chapter XV, he has, in the judicial exercise of his discretion, taken action of some other kind, such as issuing a search warrant for the purpose of investigation, or ordering investigation by the police under Section 156(3), he cannot be said to have taken cognizance of any offence.”<br></span><span style=\"font-size: 0.875rem;\">16. The contention of the appellant is that the act of taking cognizance of an offence by the Magistrate precedes the examination of the complainant under Section 200 CrPC and the learned Senior Counsel for the appellant placed reliance on the decision of this Court in CREF Finance Ltd. v. Shree Shanthi Homes (P) Ltd.10 wherein this Court has held as under: (SCC p. 471, para 10)<br></span><span style=\"font-size: 0.875rem;\">“10. In the instant case, the appellant had filed a detailed complaint before the Magistrate. The record shows that the Magistrate took cognizance and fixed the matter for recording of the statement of the complainant on 1-6-2000. Even if we assume, though that is not the case, that the words ‘cognizance taken’ were not to be found in the order recorded by him on that date, in our view that would make no difference. Cognizance is taken of the offence and not of the offender and, therefore, once the court on perusal of the complaint is satisfied that the complaint discloses the commission of an offence and there is no reason to reject the complaint at that stage, and proceeds further in the matter, it must be&nbsp; held to have taken cognizance of the offence. One should not confuse taking of cognizance with issuance of process. Cognizance is taken at the initial stage when the Magistrate peruses the complaint with a view to ascertain whether the commission of any offence is disclosed. The issuance of process is at a later stage when after considering the material placed before it, the court decides to proceed against the offenders against whom a prima facie case is made out. It is possible that a complaint may be filed against several persons, but the Magistrate may choose to issue process only against some of the accused. It may also be that after taking cognizance and examining the complainant on oath, the court may come to the conclusion that no case is made out for issuance of process and it may reject the complaint.”<br></span><span style=\"font-size: 0.875rem;\">1 2012 SCC OnLine Kar 1619<br></span><span style=\"font-size: 0.875rem;\">2 (2000) 7 SCC 183 : 2000 SCC (Cri) 1326 : AIR 2000 SC 2946<br></span><span style=\"font-size: 0.875rem;\">3 (2012) 3 SCC 64 : (2012) 1 SCC (Cri) 1041 : (2012) 2 SCC (L&amp;S) 666<br></span><span style=\"font-size: 0.875rem;\">4 (2008) 2 SCC 492 : (2008) 1 SCC (Cri) 471<br></span><span style=\"font-size: 0.875rem;\">5 AIR 1951 SC 207 : (1951) 52 Cri LJ 775 : 1951 SCR 312<br></span><span style=\"font-size: 0.875rem;\">6 1950 SCC OnLine Cal 49 : AIR 1950 Cal 437<br></span><span style=\"font-size: 0.875rem;\">7 AIR 1964 SC 1541 : (1964) 2 Cri LJ 468 : (1964) 5 SCR 37<br></span><span style=\"font-size: 0.875rem;\">8 (1973) 3 SCC 753 : 1973 SCC (Cri) 521<br></span><span style=\"font-size: 0.875rem;\">9 (1976) 3 SCC 252 : 1976 SCC (Cri) 380 : AIR 1976 SC 1672<br></span><span style=\"font-size: 0.875rem;\">10 (2005) 7 SCC 467 : 2005 SCC (Cri) 1697<br></span><span style=\"font-size: 0.875rem;\">11 (1987) 3 SCC 684 : 1987 SCC (Cri) 632</span><p></p><b>Compiled by&nbsp;S.Basavaraj&nbsp;Daksha Legal</b><p></p></div>', '008d903d05df7372a57cf886116444d9.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-12', 1, '', '', '2020-12-02 21:12:28', '2021-01-22 00:30:19'),
(98, 'yFKn8THgZ5jELTDoxKrr4IIlc', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Criminal Law – Meaning of “Cognizance” defined', '<div style=\"text-align: justify;\"><b>S.R. Sukumar v. S. Sunaad Raghuram, (2015) 9 SCC 609</b></div><div><div style=\"text-align: justify;\"><br></div><b><div style=\"text-align: justify;\"><b style=\"font-size: 0.875rem;\">Paragraph 8.&nbsp;</b></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem; font-weight: 400;\">Section 200 CrPC provides for the procedure for the Magistrate taking cognizance of an offence on complaint. The Magistrate is not bound to take cognizance of an offence merely because a complaint has been filed before him when in fact the complaint does not disclose a cause of action. The language in Section 200 CrPC</span></div></b></div><div style=\"text-align: justify;\">“A Magistrate taking cognizance of an offence on complaint shall examine upon oath the complainant and the witnesses present, if any…”</div><div style=\"text-align: justify; \">clearly suggests that for taking cognizance of an offence on complaint, the court shall examine the complainant upon oath. The object of examination of the complainant is to find out whether the complaint is justifiable or is vexatious. Merely because the complainant was examined that does not mean that the Magistrate has taken cognizance of the offence. Taking cognizance of an offence means the Magistrate must have judicially applied the mind to the contents of the complaint and indicates that the Magistrate takes judicial notice of an offence.</div><div style=\"text-align: justify;\">9. Mere presentation of the complaint and receipt of the same in the court does not mean that the Magistrate has taken cognizance of the offence. In Narsingh Das Tapadia v. Goverdhan Das Partani2 it was held that the mere presentation of a complaint cannot be held to mean that the Magistrate has taken the cognizance.</div><div style=\"text-align: justify;\">10. In Subramanian Swamy v. Manmohan Singh3 this Court explained the meaning of the word “cognizance” holding that: (SCC p. 90, para 34)</div><div style=\"text-align: justify;\">“34. … In legal parlance cognizance is ‘taking judicial notice by the court of law, possessing jurisdiction, on a cause or matter presented before it so as to decide whether there is any basis for initiating proceedings and determination of the cause or matter judicially’.”</div><div style=\"text-align: justify;\">11. Section 200 CrPC contemplates a Magistrate taking cognizance of an offence on complaint to examine the complaint and examine upon oath the complainant and the witnesses present, if any. Then normally three courses are available to the Magistrate. The Magistrate can either issue summons to the accused or order an inquiry under Section 202 CrPC or dismiss the complaint under Section 203 CrPC. Upon consideration of the statement of the complainant and the material adduced at that stage if the Magistrate is satisfied that there are sufficient grounds to proceed, he can proceed to issue process under Section 204 CrPC. Section 202 CrPC contemplates “postponement of issue of process”. It provides that the Magistrate on receipt of a complaint of an offence, of which he is authorised to take cognizance may, if he thinks fit, postpone the issue of process for compelling the attendance of the person complained against, and either inquire into the case himself, or have an inquiry made by any Magistrate subordinate to him, or an investigation made by a police officer, or by some other person for the purpose of deciding whether or not there is sufficient ground for proceeding. If the Magistrate finds no sufficient ground for proceeding, he can dismiss the complaint by recording briefly the reasons for doing so as contemplated under Section 203 CrPC. A Magistrate takes cognizance of an offence when he decides to proceed against the person accused of having committed that offence and not at the time when the Magistrate is just informed either by the complainant by filing the complaint or by the police report about the commission of an offence.</div><div style=\"text-align: justify;\">12. “Cognizance” therefore has a reference to the application of judicial mind by the Magistrate in connection with the commission of an offence and not merely to a Magistrate learning that some offence had been committed. Only upon examination of the complainant, the Magistrate will proceed to apply the judicial mind whether to take cognizance of the offence or not. Under Section 200 CrPC, when the complainant is examined, the Magistrate cannot be said to have ipso facto taken the cognizance, when the Magistrate was merely gathering the material on the basis of which he will decide whether a prima facie case is made out for taking cognizance of the offence or not. “Cognizance of offence” means taking notice of the accusations and applying the judicial mind to the contents of the complaint and the material filed therewith. It is neither practicable nor desirable to define as to what is meant by taking cognizance. Whether the Magistrate has taken cognizance of the offence or not will depend upon the facts and circumstances of the particular case.</div><div style=\"text-align: justify;\">13. In Chief Enforcement Officer v. Videocon International Ltd.4, considering the scope of the expression “cognizance” it was held as under: (SCC p. 499, para 19)</div><div style=\"text-align: justify;\">“19. The expression ‘cognizance’ has not been defined in the Code. But the word (cognizance) is of indefinite import. It has no esoteric or mystic significance in criminal law. It merely means ‘become aware of’ and when used with reference to a court or a Judge, it connotes ‘to take notice of judicially’. It indicates the point when a court or a Magistrate takes judicial notice of an offence with a view to initiating proceedings in respect of such offence said to have been committed by someone.”</div><div style=\"text-align: justify;\">14. A three-Judge Bench of this Court in R.R. Chari v. State of U.P.5, while considering what the phrase “taking cognizance” means, approved the decision of the Calcutta High Court in Supt. and Remembrancer of Legal Affairs v. Abani Kumar Banerjee6, wherein it was observed that: (R.R. Chari case5, AIR p. 210, para 9)</div><div style=\"text-align: justify;\">“9. …‘What is “taking cognizance” has not been defined in the Criminal Procedure Code and I have no desire now to attempt to define it. It seems to me clear, however, that before it can be said that any Magistrate has taken cognizance of any offence under Section 190(1)(a) of the Criminal Procedure Code, he must not only have applied his mind to the contents of the petition, but he must have done so for the purpose of proceeding in a particular way as indicated in the subsequent provisions of this Chapter—proceeding under Section 200, and thereafter sending it for enquiry and report under Section 202. When the Magistrate applies his mind not for the purpose of proceeding under the subsequent sections of this Chapter, but for taking action of some other kind e.g. ordering investigation under Section 156(3), or issuing a search warrant for the purpose of the investigation, he cannot be said to have taken cognizance of the offence.’ (Supt. and Remembrancer of Legal Affairs case6, SCC OnLine Cal, para 8)”</div><div style=\"text-align: justify;\">(emphasis supplied)</div><div style=\"text-align: justify;\">The same view was reiterated by this Court in Jamuna Singh v. Bhadai Shah7 and Nirmaljit Singh Hoon v. State of W.B.8</div><div style=\"text-align: justify;\">15. Elaborating upon the words of the expression “taking cognizance” of an offence by a Magistrate within the contemplation of Section 190 CrPC, in Devarapalli Lakshminarayana Reddy v. V. Narayana Reddy9 this Court held as under: (SCC p. 257, para 14)</div><div style=\"text-align: justify;\">“14. … But from the scheme of the Code, the content and marginal heading of Section 190 and the caption of Chapter XIV under which Sections 190 to 199 occur, it is clear that a case can be said to be instituted in a court only when the court takes cognizance of the offence alleged therein. The ways in which such cognizance can be taken are set out in clauses (a), (b) and (c) of Section 190(1). Whether the Magistrate has or has not taken cognizance of the offence will depend on the circumstances of the particular case including the mode in which the case is sought to be instituted, and the nature of the preliminary action, if any, taken by the Magistrate. Broadly speaking, when on receiving a complaint, the Magistrate applies his mind for the purposes of proceeding under Section 200 and the succeeding sections in Chapter XV to the Code of 1973, he is said to have taken cognizance of the offence within the meaning to Section 190(1)(a). If, instead of proceeding under Chapter XV, he has, in the judicial exercise of his discretion, taken action of some other kind, such as issuing a search warrant for the purpose of investigation, or ordering investigation by the police under Section 156(3), he cannot be said to have taken cognizance of any offence.”</div><div style=\"text-align: justify;\">16. The contention of the appellant is that the act of taking cognizance of an offence by the Magistrate precedes the examination of the complainant under Section 200 CrPC and the learned Senior Counsel for the appellant placed reliance on the decision of this Court in CREF Finance Ltd. v. Shree Shanthi Homes (P) Ltd.10 wherein this Court has held as under: (SCC p. 471, para 10)</div><div style=\"text-align: justify;\">“10. In the instant case, the appellant had filed a detailed complaint before the Magistrate. The record shows that the Magistrate took cognizance and fixed the matter for recording of the statement of the complainant on 1-6-2000. Even if we assume, though that is not the case, that the words ‘cognizance taken’ were not to be found in the order recorded by him on that date, in our view that would make no difference. Cognizance is taken of the offence and not of the offender and, therefore, once the court on perusal of the complaint is satisfied that the complaint discloses the commission of an offence and there is no reason to reject the complaint at that stage, and proceeds further in the matter, it must be&nbsp; held to have taken cognizance of the offence. One should not confuse taking of cognizance with issuance of process. Cognizance is taken at the initial stage when the Magistrate peruses the complaint with a view to ascertain whether the commission of any offence is disclosed. The issuance of process is at a later stage when after considering the material placed before it, the court decides to proceed against the offenders against whom a prima facie case is made out. It is possible that a complaint may be filed against several persons, but the Magistrate may choose to issue process only against some of the accused. It may also be that after taking cognizance and examining the complainant on oath, the court may come to the conclusion that no case is made out for issuance of process and it may reject the complaint.”</div><div style=\"text-align: justify;\">1 2012 SCC OnLine Kar 1619</div><div style=\"text-align: justify;\">2 (2000) 7 SCC 183 : 2000 SCC (Cri) 1326 : AIR 2000 SC 2946</div><div style=\"text-align: justify;\">3 (2012) 3 SCC 64 : (2012) 1 SCC (Cri) 1041 : (2012) 2 SCC (L&amp;S) 666</div><div style=\"text-align: justify;\">4 (2008) 2 SCC 492 : (2008) 1 SCC (Cri) 471</div><div style=\"text-align: justify;\">5 AIR 1951 SC 207 : (1951) 52 Cri LJ 775 : 1951 SCR 312</div><div style=\"text-align: justify;\">6 1950 SCC OnLine Cal 49 : AIR 1950 Cal 437</div><div style=\"text-align: justify;\">7 AIR 1964 SC 1541 : (1964) 2 Cri LJ 468 : (1964) 5 SCR 37</div><div style=\"text-align: justify;\">8 (1973) 3 SCC 753 : 1973 SCC (Cri) 521</div><div style=\"text-align: justify;\">9 (1976) 3 SCC 252 : 1976 SCC (Cri) 380 : AIR 1976 SC 1672</div><div style=\"text-align: justify;\">10 (2005) 7 SCC 467 : 2005 SCC (Cri) 1697</div><div style=\"text-align: justify;\">11 (1987) 3 SCC 684 : 1987 SCC (Cri) 632</div><div style=\"text-align: justify;\">Compiled by&nbsp;</div><div style=\"text-align: justify;\">S.Basavaraj&nbsp;</div><div style=\"text-align: justify;\">Daksha Legal</div>', 'a9b7e850bc30fc94aa3431f8d12e8cb4.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:12:29', '2021-01-22 00:23:04'),
(99, '0jeOWejnMn5Hh5lvwHd2HAu7y', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Joint family nucleus and Joint family property - Tests to determine ', '<div><b>1. Karnataka High Court- Thimma v. Doddamma, 2013 SCC OnLine Kar 9987 : ILR 2014 KAR 4491 : (2014) 4 AIR Kant R 521 : (2014) 4 KCCR 3172 : AIR 2015 (NOC 441) 163.</b></div><div><b>Dr. Jawad Rahim-J</b></div><div><b>RSA No. 1181/2006</b></div><div><b>Decided on July 3, 2013</b></div><div><div style=\"text-align: justify;\"><br></div></div><p style=\"text-align: justify;\"></p><p></p><p><span style=\"font-size: 0.875rem;\">(a) In the absence of specific averments in the plaint and proof with regard to the description of joint family properties, mode and manner of acquisition, sufficient nucleus to acquire the properties, the plaintiff is not entitled for the decree of partition and separate possession.&nbsp;<br></span><span style=\"font-size: 0.875rem;\">(b) If there is a feeble attempt in the form of statement with no evidence to show there was existing nucleus of the joint family capable of generating funds to acquire anything tangible to pay the value of the asset acquired, then there is presumption in law that the person in whose name the property was purchased is the true owner and it was not purchased on behalf of joint family members.(Para 16)<br></span><span style=\"font-size: 0.875rem;\">c) In a suit for partition apart from deciding the extent of share that the plaintiff or defendant would be entitled to, there has to be a specific finding as to whether the properties sought to be divided are joint family properties, lest, individual right will certainly be impacted. There must be specific averments in the plaint, firstly with regard to the description of the properties, and secondly, mode and manner of acquisition. There must be averments and proof about the source of acquisition if they are not in the name of the original propositus, but in the name of the other parties to the suit who is shown as coparcener. In other words, if the properties subject matter of adjudication are shown to be in the name of any one of the coparcener, the burden is on the plaintiff to prove that though they are in the name of such individual, in reality it is owned by the joint family.(Para 15)<br></span><span style=\"font-size: 0.875rem;\">(d) In the case of agricultural land, such difficulty normally arises as the name of the cultivators is entered in revenue&nbsp; records as also the name of owner and khatedar, but when properties are shown to have been acquired by sale under the provisions of the Transfer of Property Act, there will be prima facie material to show acquisition or sale and the burden on the plaintiff becomes more to establish sale consideration was paid not by the person in whose name the document stands, but that payment was out of the nucleus of the joint family. Needless to emphasize primary proof to be established is existence of nucleus of joint family capable of generating necessary funds for acquisition of other properties.(Para 16)<br></span><span style=\"font-size: 0.875rem;\">2. Karnataka High Court - M.R. Rajasekharappa v. H.N. Siddananjappa, 1990 SCC OnLine Kar 179 : ILR 1990 KAR 2303 : (1990) 4 Kant LJ 421, at page 2320&nbsp; :&nbsp;<br></span><span style=\"font-size: 0.875rem;\">R.F.A. No. 132 of 1976<br></span><span style=\"font-size: 0.875rem;\">Decided on June 5, 1990<br></span><span style=\"font-size: 0.875rem;\">K.A. Swami and D.R. Vithal Rao-JJ.<br></span><span style=\"font-size: 0.875rem;\">The existence of joint estate is not essential requisite to constitute a joint family and a family which does not own any property may nevertheless be joint. The presumption of union is the greatest in the case of father and sons. The strength of presumption necessarily varies in every case. But the presumption is strong in the case of brothers (See Paras 212(2) and 233(1) of Mulla’s Hindu Law, 15th Edition).&nbsp;<br></span><span style=\"font-size: 0.875rem;\">24. Now it is settled law that the proof of existence of a joint family does not lead to the presumption that it possesses joint property. The property held by a member of a joint family cannot also be presumed to be the joint family property. In a suit for partition, a party who claims that any item of suit property is joint family property, the burden of proving that it is so, rests on the party who asserts It. However, in a case where it is established that the joint family possessed some joint property which from its nature and relative value may have formed the nucleus from which the property claimed to be the joint family property may have been acquired, the presumption arises that it was joint family property and the burden shifts to the party alleging self acquisition to establish affirmatively that the property was acquired without the aid of the joint family.<br></span><span style=\"font-size: 0.875rem;\">42.1. It is a settled position of law that when once it is established that the joint family possessed sufficient nucleus, the onus shifts on to the person who claims the property as self-acquired, to affirmatively make out that the property was acquired without any aid from the family estate (See Mudigowda v. Ramachandra1 and Appalaswami v. Suryanarayanamurti2. It is also well established that where at the date of acquisition of a particular property, the joint family had sufficient nucleus for acquiring it, the property in the name of any member of the joint family should be presumed to be acquired from out of the family funds and was to form part of the joint family property unless the contrary is shown (See K.V. Narayanaswami Iyer v. K.V. Ramakrishna Iyer)3. It is more so in the case of&nbsp; a kartha of a joint family possessing sufficient nucleus at the time of acquisition of the property in his name to prove that he acquired it independent of, and without the aid of, the joint family funds.&nbsp;<br></span><span style=\"font-size: 0.875rem;\">1.(1969) 1 SCC 386 : AIR 1969 SC 1076.<br></span><span style=\"font-size: 0.875rem;\">2.AIR 1947 PC 189.<br></span><span style=\"font-size: 0.875rem;\">3.AIR 1965 SC 289.</span></p><p></p>', 'fa5cdd2e62347aba3dc40d3beb352255.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:13:17', '2021-01-22 00:18:01'),
(100, 'BSySdQS63huR9qfRclvW1TuQK', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitration and Conciliation Act, 1996', '<div>Not commencing arbitration proceedings within three months from the date of the presentation of the Application under section 9. Interim order granted shall stand vacated without any specific order being passed by the Court to that effect.</div><div><br></div><div>Karnataka High Court. (relying on High Court of Karnataka Arbitration (Proceedings before the Courts) Rules, 2001)</div><div><br></div><div>M/s. Paton Constructions Private Ltd vs M/s. Lorven Projects Ltd and another</div><div><br></div><div>MFA 1440/2014 decided on 13 June 2017</div><div><br></div><div>Justice H.G.Ramesh&nbsp;</div><div>Justice John Michael Cunha&nbsp;</div><div><br></div><div><b>Judgment Link:</b> http://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-1440-2014-AA.pdf</div>', '3ea9799e22aa9f47860033c884108421.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:15:39', '2021-01-22 00:07:39');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(101, 'rlX6xS3ojBclqgsAYAFVIn0eJ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Dying declaration – two deaths. Dying declaration  by one victim. Effect Held', '<div><b>When one dying declaration is integral part of circumstances resulting in death of any other person, the declaration&nbsp; has relevance for death of such other person also. <br>See discussion regarding law on dying declarations. - Tejram Patil v. State of Maharashtra, (2015) 8 SCC 494</b></div><div><br><b>Paragraphs:</b><br>15…Undoubtedly, as held by the High Court relying on judgment of this Court in Laxman v. State of Maharashtra2 that even in absence of certification by the doctor as to fitness of mind of the declarant and even if the DD is recorded by the police officer, the same can be relied upon. However, the court must be satisfied that the deceased was in a fit mental condition to make the DD and that the statement was faithfully recorded and was otherwise reliable. In the present case, it is difficult to record such satisfaction. There is no material for the Court being satisfied that the deceased was in fit condition to make the declaration. The deceased was in the hospital at the time of her alleged statement but no effort was made by the PSI to ascertain her medical condition or to certify that he had satisfied himself about the fitness of the declarant. The DD does not bear the signature or thumb mark of the deceased. The deceased had sustained 100% burns and succumbed to her injuries on 29-3-1999 at 6.25 a.m. as already noted. The view taken by the High Court that in the peculiarity of facts, authenticity of DD could be accepted, in our opinion, is not sound.</div><div>16. Coming now to the second question of admissibility and reliability of DDs, Exts. 41 and 43 it will be necessary to refer to the text of Section 32(1) of the Evidence Act, which is as follows:</div><div>“32. Cases in which statement of relevant fact by person who is dead or cannot be found, etc., is relevant.—Statements, written or verbal, of relevant facts made by a person who is dead, or who cannot be found, or who has become incapable of giving evidence, or whose attendance cannot be procured without an amount of delay or expense which under the circumstances of the case appears to the court unreasonable, are themselves relevant facts in the following cases—</div><div>(1) When it relates to cause of death.—When the statement is made by a person as to the cause of his death, or as to any of the circumstances of the transaction which resulted in his death, in cases in which the cause of that person’s death comes into question.</div><div>Such statements are relevant whether the person who made them was or was not, at the time when they were made, under expectation of death, and whatever may be the nature of the proceeding in which the cause of his death comes into question.”</div><div>17. A bare perusal of the Section shows:</div><div>(i) Statement should be of a person who is dead/cannot be found/has become incapable of giving evidence, etc.;</div><div>(ii) It should relate to the relevant facts; and</div><div>(iii) It should relate to cause of “his death” or circumstances of the transaction which resulted in “his death”, in cases in which the cause of that person’s death comes into question.</div><div>In the present case, we are concerned with Point (iii) as we are concerned with the question whether statement of Prabhabai is relevant for determining cause of death of Savita. In other words, when charge is of murder of Savita, whether cause of death of Prabhabai which is integral part of the incident can also be held to be in question.</div><div>18. On a plain reading, the statement is admissible about the cause of death or the circumstances of the transaction which resulted in the death of the person making the statement. Question is what happens when two deaths have taken place in the same transaction and circumstances of the transaction resulting in one death is closely interconnected with the other death. Admittedly, the DD of Prabhabai is admissible as to cause of her death as well as the circumstances of the transaction which resulted in her death. Such statement may not by itself be admissible to determine the cause of death of anyone other than the person making the statement. However, when the circumstances of the transaction which resulted in death of the person making the statement as well as death of any other person are part of the same transaction, the same will be relevant also about the cause of death of such other person.</div><div>19. The expressions “relevant” and “facts in issue” are defined in the Evidence Act as follows:</div><div>“‘Relevant’.—One fact is said to be relevant to another when the one is connected with the other in any of the ways referred to in the provisions of this Act relating to the relevancy of facts.</div><div>‘Facts in issue’.—The expression ‘facts in issue’ means and includes—</div><div>any fact from which, either by itself or in connection with other facts, the existence, non-existence, nature or extent of any right, liability, or disability, asserted or denied in any suit or proceeding, necessarily follows.”</div><div>20. Section 6 is as follows:</div><div>“6. Relevancy of facts forming part of same transaction.—Facts which, though not in issue, are so connected with a fact in issue as to form part of the same transaction, are relevant, whether they occurred at the same time and place or at different times and places.</div><div>21. Thus, when a dying declaration relating to circumstances of the transaction which resulted in death of a person making the declaration are integral part of circumstances resulting in death of any other person, such dying declaration has relevance for death of such other person also.</div><div>22. We may now refer to the decisions dealing with the said legal issue. In Kashinath Tukaram Jadhav v. State of Maharashtra3, a Division Bench of the Bombay High Court held the same view relying upon the judgment of the Travancore-Cochin High Court, in Lukka Ulahannan v. Travancore-Cochin State4 as follows: (Kashinath Tukaram case3, Cri LJ p. 1450, para 14)</div><div>“14. … ‘The view that the statement of one dead person is not a relevant fact with respect to the question about the death of another person or with respect to the causing of hurt to a third is too narrow to be accepted. To exclude from the evidence statements made by a deceased person as to incidents which occurred during the course of the transaction which resulted in his death statements other than those relating to the cause of his death, would be to import a limitation to the words used in the section which their natural meaning does not warrant. When a limitation like that is intended, the legislature specially provides for it.’ (Lukka Ulahannan case4, AIR p. 104)”</div><div>&nbsp;In doing so, the High Court also relied upon an early Madras High Court judgment in P. Subbu Thevan, In re5 and judgment of the Rangoon High Court in Nga Hla Din v. Emperor6 but dissented from the view taken by the Allahabad High Court in Kunwarpal Singh v. Emperor7. The Bombay High Court in that case dealt with death of two persons in the same transaction. The person making the DD was stabbed while saving the other person who was stabbed. Such DD was held to be admissible for both the deaths. The DD and discussion of the Court in the said judgment are as follows: (Kashinath Tukaram case3, Cri LJ pp. 1453-54, paras 27-28)</div><div>23. In Ratan Gond v. State of Bihar8 two young girls Baisakhi and Aghani, aged 9 years and 5 years respectively were killed. They had gone to the jungle at a short distance from their village. Their mother Jatri had also gone to the jungle. When Jatri came back she found Aghani alone in the house. Aghani gave a statement to her mother about Baisakhi and since she died, the question was whether her statement was admissible about the cause of death of Baisakhi. It may be mentioned that Baisakhi had not returned to her house and her dead body was found on the next day. The question before the Court was whether the statement of Aghani was admissible about the cause of death of Baisakhi, the Court held: (AIR p. 21, para 7)</div><div>“7. … In the case before us, the statements made by Aghani do not relate to the cause of her death or to any of the circumstances relating to her death; on the contrary, the statements relate to the death of her sister. We are, therefore, of the opinion that the statements do not come within Section 32(1) of the Evidence Act and, indeed, Mr Dhebar appearing on behalf of the State, has conceded that Section 32(1) does not apply to the statements of Aghani.”</div><div>It is clear from the above judgment that it was not a case where the transaction in which the person making the statement and the other deceased died was the same as in the present case.</div><div>24. The matter was again considered in Sharad Birdhichand Sarda v. State of Maharashtra9. It was observed: (SCC pp. 133-35, paras 10-11)</div><div>“10. … Coming now to the question of interpretation of Section 32(1) of the Evidence Act, this Court in Ratan Gond v. State of Bihar8, S.K. Das, J. made the following observations: (AIR p. 21, para 7)</div><div>‘7. … The only relevant clause of Section 32 which may be said to have any bearing is clause (1) which relates to statements made by a person as to the cause of his death or as to any of the circumstances of the transaction which resulted in his death. In the case before us, the statements made by Aghani do not relate to the cause of her death or to any of the circumstances relating to her death; on the contrary, the statements relate to the death of her sister.’</div><div>In the Law of Evidence by Woodroffe and Ameer Ali, (Vol. II) the authors have collected all the cases at one place and indicated their conclusions thus:</div><div>‘To sum up, the test of the relevancy of a statement under Section 32(1), is not what the final finding in the case is but whether the cause of the death of the person making the statement comes into question in the case. The expression “any of the circumstances of the transaction which resulted in his death” is wider in scope than the expression “the cause of his death”; in other words, clause (1) of Section 32 refers to two kinds of statements: (1) statement made by a person as to the cause of his death, and (2) the statement made by a person as to any of the circumstances of the transaction which resulted in his death.</div><div>The words “resulted in his death” do not mean “caused his death”. Thus, it is well settled that declarations are admissible only insofar as they point directly to the fact constituting the res gestae of the homicide; that is to say, to the act of killing and to the circumstances immediately attendant thereon, like threats and difficulties, acts, declarations and incidents, which constitute or accompany and explain the fact or transaction in issue. They are admissible for or against either party, as forming parts of the res gestae.’ (p. 952)</div><div>11. The leading decision on this question, which has been endorsed by this Court, is the case of Pakala Narayana Swami v. King Emperor10 where Lord Atkin has laid down the following tests: (IA pp. 75-76)</div><div>‘… It has been suggested that the statement must be made after the transaction has taken place, that the person making it must be at any rate near death, that the “circumstances” can only include the acts done when and where the death was caused. Their Lordships are of opinion that the natural meaning of the words used does not convey any of these limitations. The statement may be made before the cause of death has arisen, or before the deceased has any reason to anticipate being killed. The circumstances must be circumstances of the transaction: general expressions indicating fear or suspicion whether of a particular individual or otherwise and not directly related to the occasion of the death will not be admissible. … “Circumstances of the transaction” is a phrase no doubt that conveys some limitations. It is not as broad as the analogous use in “circumstantial evidence” which includes evidence of all relevant facts. It is on the other hand narrower than “res gestae”. Circumstances must have some proximate relation to the actual occurrence….</div><div>It will be observed that “the circumstances” are of the transaction which resulted in the death of the declarant.’</div><div>These principles were followed and fully endorsed by a decision of this Court in Shiv Kumar v. State of U.P.11 where the following observations were made:</div><div>‘It is clear that if the statement of the deceased is to be admissible under this section it must be a statement relating to the circumstances of the transaction resulting in his death. The statement may be made before the cause of death has arisen, or before the deceased has any reason to anticipate being killed…. A necessary condition of admissibility under the section is that the circumstance must have some proximate relation to the actual occurrence…. The phrase “circumstances of the transaction” is a phrase that no doubt conveys some limitations. It is not as broad as the analogous use in “circumstantial evidence” which includes evidence of all relevant facts. It is on the other hand narrower than “res gestae”. (See Pakala Narayana Swami v. King Emperor10.)’”</div><div>25. It is thus clear that the DD is admissible not only in relation to the cause of death of the person making the statement and as to circumstances of the transaction which resulted in his death, if the circumstances of the said transaction relate to death of another person, the statement cannot be held to be inadmissible when circumstances of “his” death are integrally connected to the circumstances of death of such other person.</div><div>† From the Judgment and Order dated 17-11-2008 of the High Court of Judicature at Bombay, Nagpur Bench, Nagpur in Crl. A. No. 455 of 2003</div><div>1 Criminal Appeal No. 455 of 2003, decided on 17-11-2008 (Bom)</div><div>2 (2002) 6 SCC 710 : 2002 SCC (Cri) 1491</div><div>3 1984 Cri LJ 1447 (Bom)</div><div>4 AIR 1955 TC 104</div><div>5 2 Weir 750 (Mad)</div><div>6 AIR 1936 Rang 187</div><div>7 1947 SCC OnLine All 48 : AIR 1948 All 170</div><div>8 AIR 1959 SC 18 : 1959 Cri LJ 108 : 1959 SCR 1336</div><div>9 (1984) 4 SCC 116 : 1984 SCC (Cri) 487</div><div>10 (1938-39) 66 IA 66 : AIR 1939 PC 47 : 180 IC 1</div><div>11 Criminal Appeal No. 55 of 1966, decided on 29-7-1966 (SC)</div>', 'fd5a2d621f13b820e4a4e7bda87bfbfc.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:17:02', '2021-01-22 00:04:55'),
(102, 'CSTrBVFB63FvgjMw86rq6El0R', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Partition of Inam lands', '<div><b>Inherited by the family members but in possession of only one person who cultivated and obtained occupancy certificate. HELD such possession is on behalf of all others. Lands available for partition by all the members.&nbsp;</b></div><div><b>N. Padmamma v. S. Ramakrishna Reddy, (2015) 1 SCC 417&nbsp;</b></div><div><br><b>Paragraphs:</b><br>10. It is fairly well-settled principle of law that the possession of a co-heir is in law treated as possession of all the co-heirs. If one co-heir has come in possession of the properties, it is presumed to be on the basis of a joint title. A co-heir in possession cannot render its possession adverse to other co-heirs not in possession, merely by any secret hostile animus on his own part, in derogation of the title of his other co-heirs. Ouster of the other co-heirs must be evidenced by hostile title coupled by exclusive possession and enjoyment of one of them to the knowledge of the other. (See Corea v. Appuhamy4.) Reference may also be made to the decision of this Court in P. Lakshmi Reddy v. L. Lakshmi Reddy5 wherein this Court has succinctly summed up the legal position as under: (AIR p. 318, para 4)</div><div>“4. … But it is well settled that in order to establish adverse possession of one co-heir as against another it is not enough to show that one out of them is in sole possession and enjoyment of the profits of the properties. Ouster of the non-possessing co-heir by the co-heir in possession who claims his possession to be adverse, should be made out. The possession of one co-heir is considered, in law, as possession of all the co-heirs. When one co-heir is found to be in possession of the properties it is presumed to be on the basis of joint title. The co-heir in possession cannot render his possession adverse to the other co-heir not in possession merely by any secret hostile animus on his own part in derogation of the other co-heir’s title. It is a settled rule of law that as between co-heirs there must be evidence of open assertion of hostile title, coupled with exclusive possession and enjoyment by one of them to the knowledge of the other so as to constitute ouster.”</div><div>11. Relying upon the principles stated above, this Court in Bhubaneshwar Prasad Narain Singh v. Sidheswar Mukherjee6, almost in similar circumstances held: (SCC p. 561, para 10)</div><div>“10. … In this case we have to consider whether the appellants had laid a claim which a co-sharer could not put forward except by pleading ouster or any other independent ground. Even if they were in actual Khas possession within the meaning of Section 2(k) of the Act it must be held that the plaintiff who was a co-sharer was in constructive possession through the appellants as ‘under the law possession of one co-sharer is possession of all the co-sharers’. We see no reason to hold that the observations of this Court to the above effect in P. Lakshmi Reddy v. L. Lakshmi Reddy5 are not applicable to the case before us. The appellants do not claim to be trespassers on the property: neither did they claim any title to the lands adversely to the plaintiff-respondent. The deeming provision of Section 6 must therefore ensure for the benefit of all who in the eye of the law would be regarded as in actual possession. It follows that the plaintiff had not lost his share in the Bakasht lands and had a right to them though not as tenure-holder or proprietor but certainly as a Raiyat under the provisions of the Land Reforms Act. The appeal must therefore be dismissed with costs.</div><div>12. In Kalgonda Babgonda Patil v. Balgonda Kalgonda Patil7, this Court was dealing with inam lands held by the ancestors of the appellants under Vat Hukums of Kolhapur State. The ancestors of the appellant were holding the watan (inam) land in lieu of service and as they were holding in the capacity of watan or inam, they were impartible. The trial court decreed the suit for partition in regard to watan land. In an appeal before the High Court of Bombay, the Division Bench of that Court held8 that when watan (inam) rights were abolished, all rights including the right of partition also stood abolished. A three-Judge Bench of the High Court of Bombay overruled9 the view in another case holding that in view of abolition of inam, the properties enure for enjoyment of the members of the family who are entitled to claim partition. This Court held: (Kalgonda Babgonda Patil case7, SCC p. 250, para 13)</div><div>“13. … These watan lands continued to be the hereditary property of the family although according to the custom the watan was only in the name of the senior member of the family and the succession according to the custom was in accordance with rule of primogeniture. … for the first time under this Act these watans were abolished and the lands were converted into ryotwari lands and therefore it became partible.”</div><div>13. The decisions in Kalgonda case7 and Nagesh Bisto Desai case10 were followed in Shivappa Tammannappa Karaban v. Parasappa Hanammappa Kuraban11. That was a case arising under the Karnataka Village Offices Abolition Act, 1961. Re-grant was made in that case in the name of the former holder of the village office as a watandar. This Court held that just because the grant was made in the name of watandar, did not mean that the properties ceased to be joint family properties.</div><div>14. In Lokraj v. Kishan Lal12 also this Court was dealing with abolition of inam under the Andhra Pradesh (Telangana Area) Abolition of Inams Act, 1955. A suit for partition of the inam land was filed which was contested on the ground that abolition of the pre-existing right, title and interest of inamdar and grant of occupancy right to the occupant of the land disentitled anyone to claim a partition of such land. This Court while holding that the suit was not maintainable on account of abolition of pre-existing right, title and interest of the inamdar, observed: (SCC p. 293, para 4)</div><div>“4. Consequent to the abolition, the pre-existing right, title and interest of the inamdar or any person having occupation of the inam lands stood divested and vested the same in the State until re-grant is made. The inamdar, thereby lost the pre-existing right, title and interest in the land. The right to partition itself also has been lost by the statutory operation unless re-grant is made. We are not concerned with the consequences that would ensue after re-grant of this appeal. Therefore, it is not necessary for us to go into the question that may arise after the re-grant.”</div><div>15. It is evident from the above that the right of partition was held to have been lost by operation of law. Till such time the grant was made no such right could be recognised, observed this Court. This Court specifically held that it was not concerned with the consequences that would ensue after grant is made. The suit in the present case was filed after the grant of occupancy rights. The question here is whether the grant of such rights is for the benefit of one of the members of the joint family or for all the heirs left behind by Ramachandra Reddy. Our answer to that question is in favour of the appellants. In our opinion, the grant of such occupancy rights in favour of Respondent 1 was for the benefit of all the legal heirs left behind by Ramachandra Reddy. Reliance upon Lokraj case12, therefore, is of no assistance to the respondents. We are also of the view that the decision in Lokraj case12, does not correctly apply the earlier decision of this Court in Bhubaneshwar Prasad Narain Singh case6. With utmost respect to the Hon’ble Judges who delivered the decision in Lokraj case12, the law was not correctly laid down, if the same was meant to say that even in the absence of a plea of ouster, a co-heir could merely on the basis of grant of the occupancy rights in his name exclude the other co-heirs from partition of the property so granted.</div><div>4 1912 AC 230 (PC)</div><div>5 AIR 1957 SC 314</div><div>6 Bhubaneshwar Prasad Narain Singh v. Sidheswar Mukherjee, (1971) 1 SCC 556</div><div>7 Kalgonda Babgonda Patil v. Balgonda Kalgonda Patil, 1989 Supp (1) SCC 246</div><div>8 Kalgonda Babgonda Patil v. Balgonda Kalgonda Patil, (1976) 78 Bom LR 720</div><div>9 Laxmibai Sadashiv Date v. Ganesh Shankar Date, AIR 1977 Bom 350</div><div>10 Nagesh Bisto Desai v. Khando Tirmal Desai, (1982) 2 SCC 79</div><div>11 1995 Supp (1) SCC 162</div><div>12 Lokraj v. Kishan Lal, (1995) 3 SCC 291</div>', '9e8e0602b56c40f1e570b5ccaf1846d3.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-12', 1, '', '', '2020-12-02 21:17:44', '2021-01-21 23:37:15'),
(103, 'lrb3RMwkFQD9ydz30DbkrD17F', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Private Contract with Government Writ Jurisdiction- Scope explained.', '<div style=\"text-align: center;\"><b>Joshi Technologies International Inc. v. Union of India,&nbsp;</b></div><div style=\"text-align: center;\"><b>(2015) 7 SCC 728 (para 70).</b></div><div style=\"text-align: center;\"><b>Decided on 14 May 2015</b></div><div style=\"text-align: center;\"><b>Dr.A.K. Sikri-J</b></div><div style=\"text-align: center; \"><b>Rohinton nariman-J&nbsp;</b></div><div><br><p style=\"text-align: justify;\"></p><p><span style=\"font-size: 0.875rem;\">70. Further, the legal position which emerges from various judgments of this Court dealing with different situations/aspects relating to contracts entered into by the State/public authority with private parties, can be summarised as under:<br></span><span style=\"font-size: 0.875rem;\">70.1. At the stage of entering into a contract, the State acts purely in its executive capacity and is bound by the obligations of fairness.<br></span><span style=\"font-size: 0.875rem;\">70.2. State in its executive capacity, even in the contractual field, is under obligation to act fairly and cannot practise some discriminations.<br></span><span style=\"font-size: 0.875rem;\">70.3. Even in cases where question is of choice or consideration of competing claims before entering into the field of contract, facts have to be investigated and found before the question of a violation of Article 14 of the Constitution could arise. If those facts are disputed and require assessment of evidence the correctness of which can only be tested satisfactorily by taking detailed evidence, involving examination and cross-examination of witnesses, the case could not be conveniently or satisfactorily decided in proceedings under Article 226 of the Constitution. In such cases the Court can direct the aggrieved party to resort to alternate remedy of civil suit, etc.<br></span><span style=\"font-size: 0.875rem;\">70.4. Writ jurisdiction of the High Court under Article 226 of the Constitution was not intended to facilitate avoidance of obligation voluntarily incurred.<br></span><span style=\"font-size: 0.875rem;\">70.5. Writ petition was not maintainable to avoid contractual obligation. Occurrence of commercial difficulty, inconvenience or hardship in performance of the conditions agreed to in the contract can provide no justification in not complying with the terms of contract which the parties had accepted with open eyes. It cannot ever be that a licensee can work out the licence if he finds it profitable to do so: and he can challenge the conditions under which he agreed to take the licence, if he finds it commercially inexpedient to conduct his business.<br></span><span style=\"font-size: 0.875rem;\">70.6. Ordinarily, where a breach of contract is complained of, the party complaining of such breach may sue for specific performance of the contract, if contract is capable of being specifically performed. Otherwise, the party may sue for damages.<br></span><span style=\"font-size: 0.875rem;\">70.7. Writ can be issued where there is executive action unsupported by law or even in respect of a corporation there is denial of equality before law or equal protection of law or if it can be shown that action of the public authorities was without giving any hearing and violation of principles of natural justice after holding that action could not have been taken without observing principles of natural justice.<br></span><span style=\"font-size: 0.875rem;\">70.8. If the contract between private party and the State/instrumentality and/or agency of the State is under the realm of a private law and there is no element of public law, the normal course for the aggrieved party, is to invoke the remedies provided under ordinary civil law rather than approaching the High Court under Article 226 of the Constitution of India and invoking its extraordinary jurisdiction.<br></span><span style=\"font-size: 0.875rem;\">70.9. The distinction between public law and private law element in the contract with the State is getting blurred. However, it has not been totally obliterated and where the matter falls purely in private field of contract, this Court has maintained the position that writ petition is not maintainable. The dichotomy between public law and private law rights and remedies would depend on the factual matrix of each case and the distinction between the public law remedies and private law field, cannot be demarcated with precision. In fact, each case has to be examined, on its facts whether the contractual relations between the parties bear insignia of public element. Once on the facts of a particular case it is found that nature of the activity or controversy involves public law element, then the matter can be examined by the High Court in writ petitions under Article 226 of the Constitution of India to see whether action of the State and/or instrumentality or agency of the State is fair, just and equitable or that relevant factors are taken into consideration and irrelevant factors have not gone into the decision-making process or that the decision is not arbitrary.<br></span><span style=\"font-size: 0.875rem;\">70.10. Mere reasonable or legitimate expectation of a citizen, in such a situation, may not by itself be a distinct enforceable right, but failure to consider and give due weight to it may render the decision arbitrary, and this is how the requirements of due consideration of a legitimate expectation forms part of the principle of non-arbitrariness.<br></span><span style=\"font-size: 0.875rem;\">70.11. The scope of judicial review in respect of disputes falling within the domain of contractual obligations may be more limited and in doubtful cases the parties may be relegated to adjudication of their rights by resort to remedies provided for adjudication of purely contractual disputes.</span></p></div><div><p></p></div>', '979c17b0c8c12ab4d1af2b4c94fa3405.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-12', 1, '', '', '2020-12-02 21:18:18', '2021-01-21 23:34:41'),
(104, '7ikzjNwv3dq5DJqoBC6mzbgtx', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Anticipatory bail – Guidelines of the Supreme Court', '<div style=\"text-align: justify; \"><b>Bhadresh Bipinbhai Sheth v. State of Gujarat, (2016) 1 SCC 152, at page 166&nbsp; :&nbsp;</b></div><div style=\"text-align: justify; \">25.1. The complaint filed against the accused needs to be thoroughly examined, including the aspect whether the complainant has filed a false or frivolous complaint on earlier occasion. The court should also examine the fact whether there is any family dispute between the accused and the complainant and the complainant must be clearly told that if the complaint is found to be false or frivolous, then strict action will be taken against him in accordance with law. If the connivance between the complainant and the investigating officer is established then action be taken against the investigating officer in accordance with law.</div><div style=\"text-align: justify;\">25.2. The gravity of charge and the exact role of the accused must be properly comprehended. Before arrest, the arresting officer must record the valid reasons which have led to the arrest of the accused in the case diary. In exceptional cases, the reasons could be recorded immediately after the arrest, so that while dealing with the bail application, the remarks and observations of the arresting officer can also be properly evaluated by the court.</div><div style=\"text-align: justify;\">25.3. It is imperative for the courts to carefully and with meticulous precision evaluate the facts of the case. The discretion to grant bail must be exercised on the basis of the available material and the facts of the particular case. In cases where the court is of the considered view that the accused has joined the investigation and he is fully cooperating with the investigating agency and is not likely to abscond, in that event, custodial interrogation should be avoided. A great ignominy, humiliation and disgrace is attached to arrest. Arrest leads to many serious consequences not only for the accused but for the entire family and at times for the entire community. Most people do not make any distinction between arrest at a pre-conviction stage or post-conviction stage.</div><div style=\"text-align: justify;\">25.4. There is no justification for reading into Section 438 CrPC the limitations mentioned in Section 437 CrPC. The plenitude of Section 438 must be given its full play. There is no requirement that the accused must make out a “special case” for the exercise of the power to grant anticipatory bail. This virtually, reduces the salutary power conferred by Section 438 CrPC to a dead letter. A person seeking anticipatory bail is still a free man entitled to the presumption of innocence. He is willing to submit to restraints and conditions on his freedom, by the acceptance of conditions which the court may deem fit to impose, in consideration of the assurance that if arrested, he shall be enlarged on bail.</div><div style=\"text-align: justify;\">25.5. The proper course of action on an application for anticipatory bail ought to be that after evaluating the averments and accusations available on the record if the court is inclined to grant anticipatory bail then an interim bail be granted and notice be issued to the Public Prosecutor. After hearing the Public Prosecutor, the court may either reject the anticipatory bail application or confirm the initial order of granting bail. The court would certainly be entitled to impose conditions for the grant of anticipatory bail. The Public Prosecutor or the complainant would be at liberty to move the same court for cancellation or modifying the conditions of anticipatory bail at any time if liberty granted by the court is misused. The anticipatory bail granted by the court should ordinarily be continued till the trial of the case.</div><div style=\"text-align: justify;\">25.6. It is a settled legal position that the court which grants the bail also has the power to cancel it. The discretion of grant or cancellation of bail can be exercised either at the instance of the accused, the Public Prosecutor or the complainant, on finding new material or circumstances at any point of time.</div><div style=\"text-align: justify;\">25.7. In pursuance of the order of the Court of Session or the High Court, once the accused is released on anticipatory bail by the trial court, then it would be unreasonable to compel the accused to surrender before the trial court and again apply for regular bail.</div><div style=\"text-align: justify;\">25.8. Discretion vested in the court in all matters should be exercised with care and circumspection depending upon the facts and circumstances justifying its exercise. Similarly, the discretion vested with the court under Section 438 CrPC should also be exercised with caution and prudence. It is unnecessary to travel beyond it and subject the wide power and discretion conferred by the legislature to a rigorous code of self-imposed limitations.</div><div style=\"text-align: justify;\">25.9. No inflexible guidelines or straitjacket formula can be provided for grant or refusal of the anticipatory bail because all circumstances and situations of future cannot be clearly visualised for the grant or refusal of anticipatory bail. In consonance with legislative intention, the grant or refusal of anticipatory bail should necessarily depend on the facts and circumstances of each case.</div><div style=\"text-align: justify;\">25.10. We shall also reproduce para 112 of the judgment in Siddharam Satlingappa case7, wherein the Court delineated the following factors and parameters that need to be taken into consideration while dealing with anticipatory bail:</div><div style=\"text-align: justify;\">(a) The nature and gravity of the accusation and the exact role of the accused must be properly comprehended before arrest is made;</div><div style=\"text-align: justify;\">(b) The antecedents of the applicant including the fact as to whether the accused has previously undergone imprisonment on conviction by a court in respect of any cognizable offence;</div><div style=\"text-align: justify;\">(c) The possibility of the applicant to flee from justice;</div><div style=\"text-align: justify;\">(d) The possibility of the accused’s likelihood to repeat similar or other offences;</div><div style=\"text-align: justify;\">(e) Where the accusations have been made only with the object of injuring or humiliating the applicant by arresting him or her;</div><div style=\"text-align: justify;\">(f) Impact of grant of anticipatory bail particularly in cases of large magnitude affecting a very large number of people;</div><div style=\"text-align: justify;\">(g) The courts must evaluate the entire available material against the accused very carefully. The court must also clearly comprehend the exact role of the accused in the case. The cases in which the accused is implicated with the help of Sections 34 and 149 of the Penal Code, 1860 the court should consider with even greater care and caution, because over-implication in the cases is a matter of common knowledge and concern;</div><div style=\"text-align: justify;\">(h) While considering the prayer for grant of anticipatory bail, a balance has to be struck between two factors, namely, no prejudice should be caused to free, fair and full investigation, and there should be prevention of harassment, humiliation and unjustified detention of the accused;</div><div style=\"text-align: justify;\">(i) The court should consider reasonable apprehension of tampering of the witness or apprehension of threat to the complainant;</div><div style=\"text-align: justify;\">(j) Frivolity in prosecution should always be considered and it is only the element of genuineness that shall have to be considered in the matter of grant of bail and in the event of there being some doubt as to the genuineness of the prosecution, in the normal course of events, the accused is entitled to an order of bail.</div>', 'ea9e4b214f121b4cdfdb2d83b7741ee5.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:19:32', '2021-01-21 23:29:42');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(105, 'JNn3KZSZYquFMblPMUkXNQp3Y', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Negotiable Instruments Act. Post-dated cheques', '<div style=\"text-align: justify; \"><b>Post dated cheque is a well-recognised mode of payment. Proceedings under the Negotiable Instruments Act, held maintainable.&nbsp;</b></div><div style=\"text-align: justify; \"><b>Sampelly Satyanarayana Rao v. Indian Renewable Energy Development Agency Ltd., (2016) 10 SCC 458&nbsp;</b><br></div><div style=\"text-align: justify; \"><br></div><div style=\"text-align: justify; \"><b>Paragraphs:</b></div><div style=\"text-align: justify;\">8. Reference may now be made to the decision of this Court in Indus Airways (P) Ltd. v. Magnum Aviation (P) Ltd.2, on which strong reliance has been placed by the learned counsel for the appellant. The question therein was whether post-dated cheque issued by way of advance payment for a purchase order could be considered for discharge of legally enforceable debt. The cheque was issued by way of advance payment for the purchase order but the purchase order was cancelled and payment of the cheque was stopped. This Court held that while the purchaser may be liable for breach of the contract, when a contract provides that the purchaser has to pay in advance and the cheque towards advance payment is dishonoured, it will not give rise to criminal liability under Section 138 of the Act. Issuance of cheque towards advance payment could not be considered as discharge of any subsisting liability. View to this effect of the Andhra Pradesh High Court in Swastik Coaters (P) Ltd. v. Deepak Bros.3, Madras High Court in Balaji Seafoods Exports (India) Ltd. v. Mac Industries Ltd.4, Gujarat High Court in Shanku Concretes (P) Ltd. v. State of Gujarat5 and Kerala High Court in Supply House v. Ullas6 was held to be correct view as against the view of the Delhi High Court in Magnum Aviation (P) Ltd. v. State7 and Mojj Engg. Systems Ltd. v. A.B. Sugars Ltd.8 which was disapproved.</div><div style=\"text-align: justify;\">9. We have given due consideration to the submission advanced on behalf of the appellant as well as the observations of this Court in Indus Airways2 with reference to the explanation to Section 138 of the Act and the expression “for discharge of any debt or other liability” occurring in Section 138 of the Act. We are of the view that the question whether a post-dated cheque is for “discharge of debt or liability” depends on the nature of the transaction. If on the date of the cheque, liability or debt exists or the amount has become legally recoverable, the section is attracted and not otherwise.</div><div style=\"text-align: justify;\">10. Reference to the facts of the present case clearly shows that though the word “security” is used in Clause 3.1(iii) of the agreement, the said expression refers to the cheques being towards repayment of instalments. The repayment becomes due under the agreement, the moment the loan is advanced and the instalment falls due. It is undisputed that the loan was duly disbursed on 28-2-2002 which was prior to the date of the cheques. Once the loan was disbursed and instalments have fallen due on the date of the cheque as per the agreement, dishonour of such cheques would fall under Section 138 of the Act. The cheques undoubtedly represent the outstanding liability.</div><div style=\"text-align: justify;\">11. The judgment in Indus Airways2 is clearly distinguishable. As already noted, it was held therein that liability arising out of claim for breach of contract under Section 138, which arises on account of dishonour of cheque issued was not by itself on a par with criminal liability towards discharge of acknowledged and admitted debt under a loan transaction. Dishonour of cheque issued for discharge of later liability is clearly covered by the statute in question. Admittedly, on the date of the cheque there was a debt/liability in praesenti in terms of the loan agreement, as against Indus Airways2 where the purchase order had been cancelled and cheque issued towards advance payment for the purchase order was dishonoured. In that case, it was found that the cheque had not been issued for discharge of liability but as advance for the purchase order which was cancelled. Keeping in mind this fine but real distinction, the said judgment cannot be applied to a case of present nature where the cheque was for repayment of loan instalment which had fallen due though such deposit of cheques towards repayment of instalments was also described as “security” in the loan agreement. In applying the judgment in Indus Airways2, one cannot lose sight of the difference between a transaction of purchase order which is cancelled and that of a loan transaction where loan has actually been advanced and its repayment is due on the date of the cheque.</div><div style=\"text-align: justify;\">12. The crucial question to determine applicability of Section 138 of the Act is whether the cheque represents discharge of existing enforceable debt or liability or whether it represents advance payment without there being subsisting debt or liability. While approving the views of the different High Courts noted earlier, this is the underlying principle as can be discerned from discussion of the said cases in the judgment of this Court.</div><div style=\"text-align: justify;\">13. In Balaji Seafoods4, the High Court noted that the cheque was not handed over with the intention of discharging the subsisting liability or debt. There is, thus, no similarity in the facts of that case simply because in that case also loan was advanced. It was noticed specifically therein, as was the admitted case of the parties, that the cheque was issued as “security” for the advance and was not intended to be in discharge of the liability, as in the present case.</div><div style=\"text-align: justify;\">14. In HMT Watches Ltd. v. M.A. Abida9, relied upon on behalf of the respondent, this Court dealt with the contention that the proceedings under Section 138 were liable to be quashed as the cheques were given as “security” as per defence of the accused. Negativing the contention, this Court held: (SCC pp. 779-80, paras 10-12)</div><div style=\"text-align: justify;\">“10. Having heard the learned counsel for the parties, we are of the view that the accused (Respondent 1) challenged the proceedings of criminal complaint cases before the High Court, taking factual defences. Whether the cheques were given as security or not, or whether there was outstanding liability or not is a question of fact which could have been determined only by the trial court after recording evidence of the parties. In our opinion, the High Court should not have expressed its view10 on the disputed questions of fact in a petition under Section 482 of the Code of Criminal Procedure, to come to a conclusion that the offence is not made out. The High Court has erred in law in going into the factual aspects of the matter which were not admitted between the parties. The High Court further erred in observing that Section 138(b) of the NI Act stood uncomplied with, even though Respondent 1 (accused) had admitted that he replied to the notice issued by the complainant. Also, the fact, as to whether the signatory of demand notice was authorised by the complainant company or not, could not have been examined by the High Court in its jurisdiction under Section 482 of the Code of Criminal Procedure when such plea was controverted by the complainant before it.</div><div style=\"text-align: justify;\">11. In Suryalakshmi Cotton Mills Ltd. v. Rajvir Industries Ltd.11, this Court has made the following observations explaining the parameters of jurisdiction of the High Court in exercising its jurisdiction under Section 482 of the Code of Criminal Procedure: (SCC pp. 685-87, paras 17 &amp; 22)</div><div style=\"text-align: justify;\">‘17. The parameters of jurisdiction of the High Court in exercising its jurisdiction under Section 482 of the Code of Criminal Procedure is now well settled. Although it is of wide amplitude, a great deal of&nbsp; caution is also required in its exercise. What is required is application of the well-known legal principles involved in the matter.</div><div style=\"text-align: justify;\">22. Ordinarily, a defence of an accused although appears to be plausible, should not be taken into consideration for exercise of the said jurisdiction. Yet again, the High Court at that stage would not ordinarily enter into a disputed question of fact. It, however, does not mean that documents of unimpeachable character should not be taken into consideration at any cost for the purpose of finding out as to whether continuance of the criminal proceedings would amount to an abuse of process of court or that the complaint petition is filed for causing mere harassment to the accused. While we are not oblivious of the fact that although a large number of disputes should ordinarily be determined only by the civil courts, but criminal cases are filed only for achieving the ultimate goal, namely, to force the accused to pay the amount due to the complainant immediately. The courts on the one hand should not encourage such a practice; but, on the other, cannot also travel beyond its jurisdiction to interfere with the proceeding which is otherwise genuine. The courts cannot also lose sight of the fact that in certain matters, both civil proceedings and criminal proceedings would be maintainable.’</div><div style=\"text-align: justify;\">12. In Rallis India Ltd. v. Poduru Vidya Bhushan12, this Court expressed its views on this point as under: (SCC p. 93, para 12)</div><div style=\"text-align: justify;\">‘12. At the threshold, the High Court should not have interfered with the cognizance of the complaints having been taken by the trial court. The High Court could not have discharged the respondents of the said liability at the threshold. Unless the parties are given opportunity to lead evidence, it is not possible to come to a definite conclusion as to what was the date when the earlier partnership was dissolved and since what date the respondents ceased to be the partners of the firm.’”</div><div style=\"text-align: justify;\">15. We are in respectful agreement with the above observations. In the present case, reference to the complaint (a copy of which is Annexure P-7) shows that as per the case of the complainant, the cheques which were the subject-matter of the said complaint were towards the partial repayment of the dues under the loan agreement (Para 5 of the complaint).</div><div style=\"text-align: justify;\">16. As is clear from the above observations of this Court, it is well settled that while dealing with a quashing petition, the court has ordinarily to proceed on the basis of averments in the complaint. The defence of the accused cannot be considered at this stage. The court considering the prayer for quashing does not adjudicate upon a disputed question of fact.</div><div style=\"text-align: justify;\">17. In Rangappa v. Sri Mohan13, this Court held that once issuance of a cheque and signature thereon are admitted, presumption of a legally enforceable debt in favour of the holder of the cheque arises. It is for the accused to rebut the said presumption, though accused need not adduce his own evidence and can rely upon the material submitted by the complainant. However, mere statement of the accused may not be sufficient to rebut the said presumption. A post-dated cheque is a well-recognised mode of payment14.</div><div style=\"text-align: justify;\">18. Thus, the question has to be answered in favour of the respondent and against the appellant. Dishonour of cheque in the present case being for discharge of existing liability is covered by Section 138 of the Act, as rightly held by the High Court.</div><div style=\"text-align: justify;\">19. Accordingly, we do not find any merit in this appeal and the same is dismissed. Since we have only gone into the question whether on admitted facts, case for quashing has not been made out, the appellant will be at liberty to contest the matter in trial court in accordance with law.</div><div style=\"text-align: justify;\">———</div><div style=\"text-align: justify;\">† Arising out of SLP (Crl.) No. 5410 of 2014. From the Judgment and Order dated 8-5-2014 of the High Court of Delhi in WP (Crl.) No. 1170 of 2011</div><div style=\"text-align: justify;\">1 Sampelly Satanarayana Rao v. Indian Renewable Energy Development Agency Ltd., 2014 SCC OnLine Del 2932 : (2014) 212 DLT 689</div><div style=\"text-align: justify;\">2 Indus Airways (P) Ltd. v. Magnum Aviation (P) Ltd., (2014) 12 SCC 539 : (2014) 5 SCC (Civ) 138 : (2014) 6 SCC (Cri) 845</div><div style=\"text-align: justify;\">3 Swastik Coaters (P) Ltd. v. Deepak Bros., 1997 Cri LJ 1942 : 1996 SCC OnLine AP 1003</div><div style=\"text-align: justify;\">4 Balaji Seafoods Exports (India) Ltd. v. Mac Industries Ltd., (1999) 1 CTC 6 : 1998 SCC OnLine Mad 704</div><div style=\"text-align: justify;\">5 Shanku Concretes (P) Ltd. v. State of Gujarat, 2000 Cri LJ 1988 : 1999 SCC OnLine Guj 366</div><div style=\"text-align: justify;\">6 Supply House v. Ullas, 2006 Cri LJ 4330 : 2006 SCC OnLine Ker 533</div><div style=\"text-align: justify;\">7 Magnum Aviation (P) Ltd. v. State, (2010) 172 DLT 91 : (2010) 118 DRJ 505 : 2010 SCC OnLine Del 2910</div><div style=\"text-align: justify;\">8 Mojj Engg. Systems Ltd. v. A.B. Sugars Ltd., (2008) 154 DLT 579 : 2008 SCC OnLine Del 1117</div><div style=\"text-align: justify;\">9 HMT Watches Ltd. v. M.A. Abida, (2015) 11 SCC 776 : (2015) 4 SCC (Cri) 552</div><div style=\"text-align: justify;\">10 M.A. Abida v. HMT Watches Ltd., 2014 SCC OnLine Ker 3842 : (2014) 2 KLJ 40</div><div style=\"text-align: justify;\">11 Suryalakshmi Cotton Mills Ltd. v. Rajvir Industries Ltd., (2008) 13 SCC 678 : (2009) 3 SCC (Cri) 824</div><div style=\"text-align: justify;\">12 Rallis India Ltd. v. Poduru Vidya Bhushan, (2011) 13 SCC 88 : (2012) 3 SCC (Civ) 269 : (2012) 1 SCC (Cri) 778</div><div style=\"text-align: justify;\">13 Rangappa v. Sri Mohan, (2010) 11 SCC 441 : (2010) 4 SCC (Civ) 477 : (2011) 1 SCC (Cri) 184</div><div style=\"text-align: justify;\">14 Goaplast (P) Ltd. v. Chico Ursula D’Souza, (2003) 3 SCC 232 : 2003 SCC (Cri) 603</div>', 'f1b4ecbb35521e4d3224385e31663299.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:20:51', '2021-01-21 23:28:49'),
(106, 'kBarPC1PxiIlgvJl8vmVbVKs7', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Code of Criminal Procedure. Section 482', '<div><b>Quashing Criminal Proceedings. Mere breach of Agreement does not constitute fraud under Section 420 IPC. The intention to cheat must be present from the inception Criminal proceedings quashed. ARCI v. Nimra Cerglass Technics (P) Ltd., (2016) 1 SCC 348</b></div><div><div style=\"text-align: justify;\"><br></div><div style=\"font-weight: bold; text-align: justify;\"><b style=\"font-size: 0.875rem;\">Paragraphs:</b><span style=\"font-size: 0.875rem; font-weight: 400;\">&nbsp;</span></div><p style=\"text-align: justify;\"></p><p><span style=\"font-size: 0.875rem;\">13. The legal position is well settled that when a prosecution at the initial stage is asked to be quashed, the test to be applied by the court is, as to whether uncontroverted allegations as made in the complaint establish the offence. The High Court being superior court of the State should refrain from analysing the materials which are yet to be adduced and seen in their true perspective. The inherent jurisdiction of the High Court under Section 482 CrPC should not be exercised to stifle a legitimate prosecution. The power under Section 482 CrPC is to be used sparingly only in rare cases. In a catena of cases, this Court reiterated that the powers of quashing criminal proceedings should be exercised very sparingly and quashing a complaint in criminal proceedings would depend upon the facts and circumstances of each case. (Vide State of Haryana v. Bhajan Lal2, State of T.N. v. Thirukkural Perumal3 and CBI v. Ravi Shankar Srivastava4.)&nbsp;<br></span><span style=\"font-size: 0.875rem;\">14. In the light of the well-settled principles, it is to be seen whether the allegations made in the complaint filed against ARCI and its officers for the alleged failure to develop extruded ceramic honeycomb as per specifications disclose offences punishable under Sections 419 and 420 IPC. It is to be seen that whether the averments in the complaint make out a case to constitute an offence of cheating.&nbsp;<br></span><span style=\"font-size: 0.875rem;\">15. The essential ingredients to attract Section 420 IPC are: (i) cheating; (ii) dishonest inducement to deliver property or to make, alter or destroy any valuable security or anything which is sealed or signed or is capable of being converted into a valuable security; and (iii) mens rea of the accused at the time of making the inducement. The making of a false representation is one of the essential ingredients to constitute the offence of cheating under Section 420 IPC. In order to bring a case for the offence of cheating, it is not merely sufficient to prove that a false representation had been made, but, it is further necessary to prove that the representation was false to the knowledge of the accused and was made in order to deceive the complainant.<br></span><span style=\"font-size: 0.875rem;\">16. The distinction between mere breach of contract and the cheating would depend upon the intention of the accused at the time of alleged inducement. If it is established that the intention of the accused was dishonest at the very time when he made a promise and entered into a transaction with the complainant to part with his property or money, then the liability is criminal and the accused is guilty of the offence of cheating. On the other hand, if all that is established is that a representation made by the accused has subsequently not been kept, criminal liability cannot be foisted on the accused and the only right which the complainant acquires is the remedy for breach of contract in a civil court. Mere breach of contract cannot give rise to criminal prosecution for cheating unless fraudulent or dishonest intention is shown at the beginning of the transaction. In S.W. Palanitkar v. State of Bihar5, this Court held as under: (SCC p. 250, para 21)&nbsp;<br></span><span style=\"font-size: 0.875rem;\">“21. … In order to constitute an offence of cheating, the intention to deceive should be in existence at the time when the inducement was made. It is necessary to show that a person had fraudulent or dishonest intention at the time of making the promise, to say that he committed an act of cheating. A mere failure to keep up promise subsequently cannot be presumed as an act leading to cheating.”</span><span style=\"font-size: 0.875rem;\">The above view in Palanitkar case5 was referred to and followed in Rashmi Jain v. State of U.P.6<br></span><span style=\"font-size: 0.875rem;\">17. Various clauses in the agreement indicate that the technology transfer agreement, 1999 was only experimental in nature and ARCI shall endeavour to achieve the performance as per the specifications. In the agreement, there was no commitment on the part of ARCI to provide extruded ceramic honeycombs as per expected specifications.&nbsp;<br></span><span style=\"font-size: 0.875rem;\">22. By an analysis of the terms and conditions of the agreement between the parties, the dispute between the parties appears to be purely of civil nature. It is a settled legal proposition that criminal liability should not be imposed in disputes of civil nature. In Anil Mahajan v. Bhor Industries Ltd.8, this Court held as under: (SCC p. 231, paras 6-7)<br></span><span style=\"font-size: 0.875rem;\">“6. … A distinction has to be kept in mind between mere breach of contract and the offence of cheating. It depends upon the intention of the accused at the time of inducement. The subsequent conduct is not the sole test. Mere breach of contract cannot give rise to criminal prosecution for cheating unless fraudulent, dishonest intention is shown at the beginning of the transaction.</span><span style=\"font-size: 0.875rem;\">* * *<br></span><span style=\"font-size: 0.875rem;\">8. The substance of the complaint is to be seen. Mere use of the expression ‘cheating’ in the complaint is of no consequence. Except mention of the words ‘deceive’ and ‘cheat’ in the complaint filed before the Magistrate and ‘cheating’ in the complaint filed before the police, there is no averment about the deceit, cheating or fraudulent intention of the accused at the time of entering into MoU wherefrom it can be inferred that the accused had the intention to deceive the complainant to pay. … We need not go into the question of the difference of the amounts mentioned in the complaint which is much more than what is mentioned in the notice and also the defence of the accused and the stand taken in reply to notice because the complainant’s own case is that over rupees three crores was paid and for balance, the accused was giving reasons as above-noticed. The additional reason for not going into these aspects is that a civil suit is pending inter se the parties for the amounts in question.”<br></span><span style=\"font-size: 0.875rem;\">23. In Indian Oil Corpn. v. NEPC India Ltd.9, this Court observed that civil liability cannot be converted into criminal liability and held as under: (SCC pp. 748-49, paras 13-14)<br></span><span style=\"font-size: 0.875rem;\">“13. While on this issue, it is necessary to take notice of a growing tendency in business circles to convert purely civil disputes into criminal cases. This is obviously on account of a prevalent impression that civil law remedies are time consuming and do not adequately protect the interests of lenders/creditors. Such a tendency is seen in several family disputes also, leading to irretrievable breakdown of marriages/families. There is also an impression that if a person could somehow be entangled in a criminal prosecution, there is a likelihood of imminent settlement. Any effort to settle civil disputes and claims, which do not involve any criminal offence, by applying pressure through criminal prosecution should be deprecated and discouraged. In G. Sagar Suri v. State of U.P.10 this Court observed: (SCC p. 643, para 8)<br></span><span style=\"font-size: 0.875rem;\">‘8. … It is to be seen if a matter, which is essentially of a civil nature, has been given a cloak of criminal offence. Criminal proceedings are not a short cut of other remedies available in law. Before issuing process a criminal court has to exercise a great deal of caution. For the accused it is a serious matter. This Court has laid certain principles on the basis of which the High Court is to exercise its jurisdiction under Section 482 of the Code. Jurisdiction under this section has to be exercised to prevent abuse of the process of any court or otherwise to secure the ends of justice.’<br></span><span style=\"font-size: 0.875rem;\">14. While no one with a legitimate cause or grievance should be prevented from seeking remedies available in criminal law, a complainant who initiates or persists with a prosecution, being fully aware that the criminal proceedings are unwarranted and his remedy lies only in civil&nbsp; law, should himself be made accountable, at the end of such misconceived criminal proceedings, in accordance with law. One positive step that can be taken by the courts, to curb unnecessary prosecutions and harassment of innocent parties, is to exercise their power under Section 250 CrPC more frequently, where they discern malice or frivolousness or ulterior motives on the part of the complainant. Be that as it may.”<br></span><span style=\"font-size: 0.875rem;\">24. The learned counsel for the respondent submitted that any defence to be taken by the appellants is to be raised only during the course of trial and is not to be raised in the initial stage of the prosecution. In support of his contention, the learned counsel placed reliance upon Trisuns Chemical Industry v. Rajesh Agarwal11, Rajesh Bajaj v. State (NCT of Delhi)12, P. Swaroopa Rani v. M. Hari Narayana13 and Iridium India Telecom Ltd. v. Motorola Inc.14 The learned counsel for the respondent further submitted that when the Magistrate has taken cognizance of an offence and the power of the High Court to interfere is only to a limited extent, the High Court cannot substitute its view for the summoning order passed by the Magistrate. In support of this contention, the learned counsel placed reliance upon the decisions of this Court in Fiona Shrikhande v. State of Maharashtra15, Bhushan Kumar v. State (NCT of Delhi)16 and Nagawwa v. Veeranna Shivalingappa Konjalgi17.<br></span><span style=\"font-size: 0.875rem;\">25. The above decisions reiterate the well-settled principles that while exercising inherent jurisdiction under Section 482 CrPC, it is not for the High Court to appreciate the evidence and its truthfulness or sufficiency inasmuch as it is the function of the trial court. The High Court’s inherent powers, be it, civil or criminal matters, is designed to achieve a salutary public purpose and that a court proceeding ought not to be permitted to degenerate into a weapon of harassment or persecution. If the averments in the complaint do not constitute an offence, the Court would be justified in quashing the proceedings in the interest of justice.<br></span><span style=\"font-size: 0.875rem;\">28. In the result, the impugned order1 is set aside and this appeal is allowed. The criminal proceedings against Appellants 1 to 3 in CC No. 840 of 2008 on the file of the IInd Metropolitan Magistrate at Cyberabad, are quashed</span></p></div><div>1 Criminal Petition No. 7901 of 2008, decided on 17-3-2009 (AP)<br>2 1992 Supp (1) SCC 335 : 1992 SCC (Cri) 426<br>3 (1995) 2 SCC 449 : 1995 SCC (Cri) 387<br>4 (2006) 7 SCC 188 : (2006) 3 SCC (Cri) 233<br>5 (2002) 1 SCC 241 : 2002 SCC (Cri) 129<br>6 (2014) 13 SCC 553 : (2014) 5 SCC (Cri) 751<br>7 International Advanced Research Centre for Powder Metallurgy v. Nimra Cerglass Technics (P) Ltd., Arbitration Petition No. 78 of 2008, order dated 8-7-2008 (Del)<br>8 (2005) 10 SCC 228 : (2006) 1 SCC (Cri) 746<br>9 (2006) 6 SCC 736 : (2006) 3 SCC (Cri) 188<br>10 (2000) 2 SCC 636 : 2000 SCC (Cri) 513<br>11 (1999) 8 SCC 686 : 2000 SCC (Cri) 47<br>12 (1999) 3 SCC 259 : 1999 SCC (Cri) 401<br>13 (2008) 5 SCC 765 : (2008) 3 SCC (Cri) 79<br>14 (2011) 1 SCC 74 : (2010) 3 SCC (Cri) 1201<br>15 (2013) 14 SCC 44 : (2014) 1 SCC (Cri) 715<br>16 (2012) 5 SCC 424 : (2012) 2 SCC (Cri) 872<br>17 (1976) 3 SCC 736 : 1976 SCC (Cri) 507<p></p></div><div><p></p><br><p></p></div>', '9206fad071af5ef92331d8959fd28c8a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:23:23', '2021-01-21 23:13:47'),
(107, 'MppbtG3cd3pj2TBvrxCh1PTuQ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Will', '<div>Earlier clause of the Will bequeathing the property absolutely shall prevail over the later clause in the same Will limiting the title to the same property. Earlier clause in the Will prevails over the later clause in the Will. </div><div>Madhuri Ghosh vs Debobrato Dutta & anr. </div><div>(2016) 10 SCC 805.</div>', '5cfad83dd8c80f3534c5883efeee73b0.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, '', '', '2020-12-02 21:23:54', '2020-12-22 19:47:10');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(108, 't7oj3uDDtMynRTBA9QQtF1uQk', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Private Unaided Educational Institutions and their Fundamental Rights. Judgment of the Supreme Court in TMA Pai case. ', '<h4 style=\"text-align: center; \"><br></h4><table class=\"table table-bordered\"><tbody><tr><td><h4 style=\"color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-weight: bolder;\"><br></span></h4><h3 style=\"text-align: center;\"><font color=\"#000000\"><b>T.M.A. Pai Foundation v. State of Karnataka.</b></font><br></h3><h4 style=\"text-align: center;\"><font color=\"#000000\">Writ Petition 317 of 1993 and connected matters decided on October 31, 2002/November 25, 2002</font></h4><h4 style=\"text-align: center;\"><font color=\"#000000\">Reported in (2002) 8 SCC 481.</font></h4><h4 style=\"text-align: center;\"></h4><h4 style=\"text-align: center;\"><font color=\"#000000\">Chief Justice B.N. Kirpal, Justice G.B. Pattanaik, Justice V.N. Khare, Justice S. Rajendra Babu, Justice Syed Shah Mohmmed Quadri, Justice Ruma Pal, Justice S.N. Variava, Justice K.G. Balakrishnan, Justice P. Venkatarama Reddi, Justice Ashok Bhan and Justice Arijit Pasayat.</font></h4><h4 style=\"color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-weight: bolder;\"><br></span></h4></td></tr></tbody></table><h4 style=\"text-align: center; \"><span style=\"background-color: rgb(255, 255, 0); font-size: 1.3125rem; text-align: left;\">Relevant paragraphs under the heading Private unaided non-minority educational institutions:</span><br></h4><h4>48. Private education is one of the most dynamic and fastest-growing segments of post-secondary education at the turn of the twenty-first century. A combination of unprecedented demand for access to higher education and the inability or unwillingness of the Government to provide the necessary support has brought private higher education to the forefront. Private institutions, with a long history in many countries, are expanding in scope and number, and are becoming increasingly important in parts of the world that relied almost entirely on the public sector.<br>49. Not only has demand overwhelmed the ability of the Governments to provide education, there has also been a significant change in the way that higher education is perceived. The idea of an academic degree as a “private good” that benefits the individual rather than a “public good” for society is now widely accepted. The logic of today\'s economics and an ideology of privatization have contributed to the resurgence of private higher education, and the establishing of private institutions where none or very few existed before.<br><span style=\"background-color: rgb(255, 255, 0);\"><b>50. The right to establish and administer broadly comprises the following rights:<br>(a) to admit students;<br>(b) to set up a reasonable fee structure;<br>(c) to constitute a governing body;<br>(d) to appoint staff (teaching and non-teaching); and<br>(e) to take action if there is dereliction of duty on the part of any employees.</b></span><br>51. A University Education Commission was appointed on 4-11-1948, having Dr S. Radhakrishnan as its Chairman and nine other renowned educationists as its members. The terms of reference, inter alia, included matters relating to means and objects of university education and research in India and maintenance of higher standards of teaching and examination in universities and colleges under their control. In the report submitted by this Commission, in paras 29 and 31, it referred to autonomy in education which reads as follows:<br>&nbsp;“University autonomy.—Freedom of individual development is the basis of democracy. Exclusive control of education by the State has been an important factor in facilitating the maintenance of totalitarian tyrannies. In such States institutions of higher learning controlled and managed by governmental agencies act like mercenaries, promote the political purposes of the State, make them acceptable to an increasing number of their population and supply them with the weapons they need. We must resist, in the interests of our own democracy, the trend towards the governmental domination of the educational process.<br>Higher education is, undoubtedly, an obligation of the State but State aid is not to be confused with State control over academic policies and practices. Intellectual progress demands the maintenance of the spirit of free inquiry. The pursuit and practice of truth regardless of consequences has been the ambition of universities. Their prayer is that of the dying Goethe: ‘More light’, or that of Ajax in the mist ‘Light, though I perish in the light.’<br>The respect in which the universities of Great Britain are held is due to the freedom from governmental interference which they enjoy constitutionally and actually. Our universities should be released from the control of politics.<br>Liberal education.—All education is expected to be liberal. It should free us from the shackles of ignorance, prejudice and unfounded belief. If we are incapable of achieving the good life, it is due to faults in our inward being, to the darkness in us. The process of education is the slow conquering of this darkness. To lead us from darkness to light, to free us from every kind of domination except that of reason, is the aim of education.”<br>52. There cannot be a better exposition than what has been observed by these renowned educationists with regard to autonomy in education. The aforesaid passage clearly shows that the governmental domination of the educational process must be resisted. Another pithy observation of the Commission was that State aid was not to be confused with State control over academic policies and practices. The observations referred to hereinabove clearly contemplate educational institutions soaring to great heights in pursuit of intellectual excellence and being free from unnecessary governmental controls.<br>53. With regard to the core components of the rights under Articles 19 and 26(a), it must be held that while the State has the right to prescribe qualifications necessary for admission, private unaided colleges have the right to admit students of their choice, subject to an objective and rational procedure of selection and the compliance with conditions, if any, requiring admission of a small percentage of students belonging to weaker sections of the society by granting them freeships or scholarships, if not granted by the Government. Furthermore, in setting up a reasonable fee structure, the element of profiteering is not as yet accepted in Indian conditions. The fee structure must take into consideration the need to generate funds to be utilized for the betterment and growth of the educational institution, the betterment of education in that institution and to provide facilities necessary for the benefit of the students. In any event, a private institution will have the right to constitute its own governing body, for which qualifications may be prescribed by the State or the university concerned. It will, however, be objectionable if the State retains the power to nominate specific individuals on governing bodies. Nomination by the State, which could be on a political basis, will be an inhibiting factor for private enterprise to embark upon the occupation of establishing and administering educational institutions. For the same reasons, nomination of teachers either directly by the department or through a service commission will be an unreasonable inroad and an unreasonable restriction on the autonomy of the private unaided educational institution.<br>54. The right to establish an educational institution can be regulated; but such regulatory measures must, in general, be to ensure the maintenance of proper academic standards, atmosphere and infrastructure (including qualified staff) and the prevention of maladministration by those in charge of management. The fixing of a rigid fee structure, dictating the formation and composition of a governing body, compulsory nomination of teachers and staff for appointment or nominating students for admissions would be unacceptable restrictions.<br>55. The Constitution recognizes the right of the individual or religious denomination, or a religious or linguistic minority to establish an educational institution. If aid or financial assistance is not sought, then such institution will be a private unaided institution. Although, in Unni Krishnan case [(1993) 1 SCC 645] the Court emphasized the important role played by private unaided institutions and the need for private funding, in the scheme that was framed, restrictions were placed on some of the important ingredients relating to the functioning of an educational institution. There can be no doubt that in seeking affiliation or recognition, the Board or the university or the affiliating or recognizing authority can lay down conditions consistent with the requirement to ensure the excellence of education. It can, for instance, indicate the quality of the teachers by prescribing the minimum qualifications that they must possess, and the courses of study and curricula. It can, for the same reasons, also stipulate the existence of infrastructure sufficient for its growth, as a prerequisite. But the essence of a private educational institution is the autonomy that the institution must have in its management and administration. There, necessarily, has to be a difference in the administration of private unaided institutions and the government-aided institutions. Whereas in the latter case, the Government will have greater say in the administration, including admissions and fixing of fees, in the case of private unaided institutions, maximum autonomy in the day-to-day administration has to be with the private unaided institutions. Bureaucratic or governmental interference in the administration of such an institution will undermine its independence. While an educational institution is not a business, in order to examine the degree of independence that can be given to a recognized educational institution, like any private entity that does not seek aid or assistance from the Government, and that exists by virtue of the funds generated by it, including its loans or borrowings, it is important to note that the essential ingredients of the management of the private institution include the recruiting students and staff, and the quantum of fee that is to be charged.<br>56. An educational institution is established for the purpose of imparting education of the type made available by the institution. Different courses of study are usually taught by teachers who have to be recruited as per qualifications that may be prescribed. It is no secret that better working conditions will attract better teachers. More amenities will ensure that better students seek admission to that institution. One cannot lose sight of the fact that providing good amenities to the students in the form of competent teaching faculty and other infrastructure costs money. It has, therefore, to be left to the institution, if it chooses not to seek any aid from the Government, to determine the scale of fee that it can charge from the students. One also cannot lose sight of the fact that we live in a competitive world today, where professional education is in demand. We have been given to understand that a large number of professional and other institutions have been started by private parties who do not seek any governmental aid. In a sense, a prospective student has various options open to him/her where, therefore, normally economic forces have a role to play. The decision on the fee to be charged must necessarily be left to the private educational institution that does not seek or is not dependent upon any funds from the Government.<br>58. For admission into any professional institution, merit must play an important role. While it may not be normally possible to judge the merit of the applicant who seeks admission into a school, while seeking admission to a professional institution and to become a competent professional, it is necessary that meritorious candidates are not unfairly treated or put at a disadvantage by preferences shown to less meritorious but more influential applicants. Excellence in professional education would require that greater emphasis be laid on the merit of a student seeking admission. Appropriate regulations for this purpose may be made keeping in view the other observations made in this judgment in the context of admissions to unaided institutions.<br>59. Merit is usually determined, for admission to professional and higher education colleges, by either the marks that the student obtains at the qualifying examination or school-leaving certificate stage followed by the interview, or by a common entrance test conducted by the institution, or in the case of professional colleges, by government agencies.<br>60. Education is taught at different levels, from primary to professional. It is, therefore, obvious that government regulations for all levels or types of educational institutions cannot be identical; so also, the extent of control or regulation could be greater vis-à-vis aided institutions.<br>61. In the case of unaided private schools, maximum autonomy has to be with the management with regard to administration, including the right of appointment, disciplinary powers, admission of students and the fees to be charged. At the school level, it is not possible to grant admissions on the basis of merit. It is no secret that the examination results at all levels of unaided private schools, notwithstanding the stringent regulations of the governmental authorities, are far superior to the results of the government-maintained schools. There is no compulsion on students to attend private schools. The rush for admission is occasioned by the standards maintained in such schools, and recognition of the fact that State-run schools do not provide the same standards of education. The State says that it has no funds to establish institutions at the same level of excellence as private schools. But by curtailing the income of such private schools, it disables those schools from affording the best facilities because of a lack of funds. If this lowering of standards from excellence to a level of mediocrity is to be avoided, the State has to provide the difference which, therefore, brings us back in a vicious circle to the original problem viz. the lack of State funds. The solution would appear to lie in the States not using their scanty resources to prop up institutions that are able to otherwise maintain themselves out of the fees charged, but in improving the facilities and infrastructure of State-run schools and in subsidizing the fees payable by the students there. It is in the interest of the general public that more good quality schools are established; autonomy and non-regulation of the school administration in the right of appointment, admission of the students and the fee to be charged will ensure that more such institutions are established. The fear that if a private school is allowed to charge fees commensurate with the fees affordable, the degrees would be “purchasable” is an unfounded one since the standards of education can be and are controllable through the regulations relating to recognition, affiliation and common final examinations.<br>62. There is a need for private enterprise in non-professional college education as well. At present, insufficient number of undergraduate colleges are being and have been established, one of the inhibiting factors being that there is a lack of autonomy due to government regulations. It will not be wrong to presume that the number of professional colleges is growing at a faster rate than the number of undergraduate and non-professional colleges. While it is desirable that there should be a sufficient number of professional colleges, it should also be possible for private unaided undergraduate colleges that are non-technical in nature to have maximum autonomy similar to a school.<br>63. It was submitted that for maintaining the excellence of education, it was important that the teaching faculty and the members of the staff of any educational institution performed their duties in the manner in which it is required to be done, according to the rules or instructions. There have been cases of misconduct having been committed by the teachers and other members of the staff. The grievance of the institution is that whenever disciplinary action is sought to be taken in relation to such misconduct, the rules that are normally framed by the Government or the university are clearly loaded against the management. It was submitted that in some cases, the rules require the prior permission of the governmental authorities before the initiation of the disciplinary proceeding, while in other cases, subsequent permission is required before the imposition of penalties in the case of proven misconduct. While emphasizing the need for an independent authority to adjudicate upon the grievance of the employee or the management in the event of some punishment being imposed, it was submitted that there should be no role for the Government or the university to play in relation to the imposition of any penalty on the employee.<br>64. An educational institution is established only for the purpose of imparting education to the students. In such an institution, it is necessary for all to maintain discipline and abide by the rules and regulations that have been lawfully framed. The teachers are like foster parents who are required to look after, cultivate and guide the students in their pursuit of education. The teachers and the institution exist for the students and not vice versa. Once this principle is kept in mind, it must follow that it becomes imperative for the teaching and other staff of an educational institution to perform their duties properly, and for the benefit of the students. Where allegations of misconduct are made, it is imperative that a disciplinary enquiry is conducted, and that a decision is taken. In the case of a private institution, the relationship between the management and the employees is contractual in nature. A teacher, if the contract so provides, can be proceeded against, and appropriate disciplinary action can be taken if the misconduct of the teacher is proved. Considering the nature of the duties and keeping the principle of natural justice in mind for the purposes of establishing misconduct and taking action thereon, it is imperative that a fair domestic enquiry is conducted. It is only on the basis of the result of the disciplinary enquiry that the management will be entitled to take appropriate action. We see no reason why the management of a private unaided educational institution should seek the consent or approval of any governmental authority before taking any such action. In the ordinary relationship of master and servant, governed by the terms of a contract of employment, anyone who is guilty of breach of the terms can be proceeded against and appropriate relief can be sought. Normally, the aggrieved party would approach a court of law and seek redress. In the case of educational institutions, however, we are of the opinion that requiring a teacher or a member of the staff to go to a civil court for the purpose of seeking redress is not in the interest of general education. Disputes between the management and the staff of educational institutions must be decided speedily, and without the excessive incurring of costs. It would, therefore, be appropriate that an Educational Tribunal be set up in each district in a State, to enable the aggrieved teacher to file an appeal, unless there already exists such an Educational Tribunal in a State — the object being that the teacher should not suffer through the substantial costs that arise because of the location of the Tribunal; if the tribunals are limited in number, they can hold circuit/camp sittings in different districts to achieve this objective. Till a specialized tribunal is set up, the right of filing the appeal would lie before the District Judge or Additional District Judge as notified by the Government. It will not be necessary for the institution to get prior permission or ex post facto approval of a governmental authority while taking disciplinary action against a teacher or any other employee. The State Government shall determine, in consultation with the High Court, the judicial forum in which an aggrieved teacher can file an appeal against the decision of the management concerning disciplinary action or termination of service.<br>65. The reputation of an educational institution is established by the quality of its faculty and students, and the educational and other facilities that the college has to offer. The private educational institutions have a personality of their own, and in order to maintain their atmosphere and traditions, it is but necessary that they must have the right to choose and select the students who can be admitted to their courses of studies. It is for this reason that in St. Stephen\'s College case [(1992) 1 SCC 558] this Court upheld the scheme whereby a cut-off percentage was fixed for admission, after which the students were interviewed and thereafter selected. While an educational institution cannot grant admission on its whims and fancies, and must follow some identifiable or reasonable methodology of admitting the students, any scheme, rule or regulation that does not give the institution the right to reject candidates who might otherwise be qualified according to, say, their performance in an entrance test, would be an unreasonable restriction under Article 19(6), though appropriate guidelines/modalities can be prescribed for holding the entrance test in a fair manner. Even when students are required to be selected on the basis of merit, the ultimate decision to grant admission to the students who have otherwise qualified for the grant of admission must be left with the educational institution concerned. However, when the institution rejects such students, such rejection must not be whimsical or for extraneous reasons.<br>66. In the case of private unaided educational institutions, the authority granting recognition or affiliation can certainly lay down conditions for the grant of recognition or affiliation; these conditions must pertain broadly to academic and educational matters and welfare of students and teachers ? but how the private unaided institutions are to run is a matter of administration to be taken care of by the management of those institutions.</h4><div><br></div>', '8d3a05b62ce941f51ca4a581888aa8d6.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-27', 1, '', '', '2020-12-02 21:24:30', '2021-02-27 17:45:21'),
(109, 'fx4pQEr3PpfcLVU7DiA4J0hnE', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code - Provision of Order 18 rule 17 to recall and examine witness can NOT be invoked to fill up the lacunae in evidence already recorded. It can be invoked only to clear ambiguity. Supreme Court. ', '<h4><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Ram Rati Vs Mange Ram Thr LRS and others.<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b><span style=\"font-size: 12pt;\">Civil Appeal 1684 of 2016 decided on February 23 2016.</span><br></b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Justice Kurian Joseph and Justice Rohinton Fali Nariman.<o:p><br></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><o:p><b><br></b></o:p></span></p><h4><b><span style=\"font-size: 1.5rem; font-family: var(--bs-font-sans-serif);\">10. Order 18 CPC deals with hearing of the suit and examination of witnesses. By an amendment introduced thereunder with effect from 1-2-1977, Rule 17-A was introduced permitting production of evidence not previously known or which could not be produced despite due diligence. It appears, the amendment only caused unnecessary protraction of the litigation, and hence, the said provision was omitted by the Code of Civil Procedure (Amendment) Act, 1999 with effect from 1-7-2002. However, Rule 17 was retained which reads as follows:</span><br></b></h4><p><b><span style=\"font-size: 1.5rem; font-family: var(--bs-font-sans-serif);\">“17. Court may recall and examine witness.—The court may at any stage of a suit recall any witness who has been examined and may (subject to the law of evidence for the time being in force) put such questions to him as the court thinks fit.”</span><br></b></p><b>11. The respondent filed the application under Rule 17 read with Section 151 CPC invoking the inherent powers of the court to make orders for the ends of justice or to prevent abuse of the process of the court. The basic purpose of Rule 17 is to enable the court to clarify any position or doubt, and the court may, either suo motu or on the request of any party, recall any witness at any stage in that regard. This power can be exercised at any stage of the suit. No doubt, once the court recalls the witness for the purpose of any such clarification, the court may permit the parties to assist the court by examining the witness for the purpose of clarification required or permitted by the court. The power under Rule 17 cannot be stretched any further. The said power cannot be invoked to fill up omission in the evidence already led by a witness. It cannot also be used for the purpose of filling up a lacuna in the evidence. “No prejudice is caused to either party” is also not a permissible ground to invoke Rule 17. No doubt, it is a discretionary power of the court but to be used only sparingly, and in case, the court decides to invoke the provision, it should also see that the trial is not unnecessarily protracted on that ground.<br></b></h4><h4><b>12. In Vadiraj Naggappa Vernekar v. Sharadchandra Prabhakar Gogate2, this principle has been summarised at paras 25, 28 and 29: (SCC pp. 414-15)<br>“25. In our view, though the provisions of Order 18 Rule 17 CPC have been interpreted to include applications to be filed by the parties for recall of witnesses, the main purpose of the said Rule is to enable the court, while trying a suit, to clarify any doubts which it may have with regard to the evidence led by the parties. The said provisions are not intended to be used to fill up omissions in the evidence of a witness who has already been examined.<br></b></h4><h4><b>28. The power under the provisions of Order 18 Rule 17 CPC is to be sparingly exercised and in appropriate cases and not as a general rule merely on the ground that his recall and re-examination would not cause any prejudice to the parties. That is not the scheme or intention of Order 18 Rule 17 CPC.<br></b></h4><h4><b>29. It is now well settled that the power to recall any witness under Order 18 Rule 17 CPC can be exercised by the court either on its own motion or on an application filed by any of the parties to the suit, but as indicated hereinabove, such power is to be invoked not to fill up the lacunae in the evidence of the witness which has already been recorded but to clear any ambiguity that may have arisen during the course of his examination.”<br></b></h4><h4><b>13. In K.K. Velusamy v. N. Palanisamy3, the principles enunciated in Vadiraj2 have been followed, holding at paras 9 and 10: (K.K. Velusamy case3, SCC pp. 281-82)<span style=\"font-size: 1.5rem; font-family: var(--bs-font-sans-serif);\">“9. Order 18 Rule 17 of the Code enables the court, at any stage of a suit, to recall any witness who has been examined (subject to the law of evidence for the time being in force) and put such questions to him as it thinks fit. The power to recall any witness under Order 18 Rule 17 can be exercised by the court either on its own motion or on an application filed by any of the parties to the suit requesting the court to exercise the said power. The power is discretionary and should be used sparingly in appropriate cases to enable the court to clarify any doubts it may have in regard to the evidence led by the parties. The said power is not intended to be used to fill up omissions in the evidence of a witness who has already been examined. (Vide Vadiraj Naggappa Vernekar v. Sharadchandra Prabhakar Gogate.)</span></b></h4><h4><span style=\"font-size: 1.5rem; font-family: var(--bs-font-sans-serif);\"><b>10. Order 18 Rule 17 of the Code is not a provision intended to enable the parties to recall any witnesses for their further examination-in-chief or cross-examination or to place additional material or evidence which could not be produced when the evidence was being recorded. Order 18 Rule 17 is primarily a provision enabling the court to clarify any issue or doubt, by recalling any witness either suo motu, or at the request of any party, so that the court itself can put questions and elicit answers. Once a witness is recalled for purposes of such clarification, it may, of course, permit the parties to assist it by putting some questions.”</b></span></h4><h4><b>14. The rigour under Rule 17, however, does not affect the inherent powers of the court to pass the required orders for ends of justice to reopen the evidence for the purpose of further examination or cross-examination or even for production of fresh evidence. This power can also be exercised at any stage of the suit, even after closure of evidence. Thus, the inherent power is the only recourse, as held by this Court in K.K. Velusamy3 at para 11, which reads as follows: (SCC p. 282)<br>“11. There is no specific provision in the Code enabling the parties to reopen the evidence for the purpose of further examination-in-chief or cross-examination. Section 151 of the Code provides that nothing in the Code shall be deemed to limit or otherwise affect the inherent powers of the court to make such orders as may be necessary for the ends of justice&nbsp; or to prevent the abuse of the process of the court. In the absence of any provision providing for reopening of evidence or recall of any witness for further examination or cross-examination, for purposes other than securing clarification required by the court, the inherent power under Section 151 of the Code, subject to its limitations, can be invoked in appropriate cases to reopen the evidence and/or recall witnesses for further examination. This inherent power of the court is not affected by the express power conferred upon the court under Order 18 Rule 17 of the Code to recall any witness to enable the court to put such question to elicit any clarifications.”<br></b></h4><h4><b>15. After surveying the various principles stated by this Court on Section 151 from 1961, in K.K. Velusamy3, they have been succinctly summarised as follows under para 12: (SCC pp. 282-83)<br>“(a) Section 151 is not a substantive provision which creates or confers any power or jurisdiction on courts. It merely recognises the discretionary power inherent in every court as a necessary corollary for rendering justice in accordance with law, to do what is “right” and undo what is “wrong”, that is, to do all things necessary to secure the ends of justice and prevent abuse of its process.<br>(b) As the provisions of the Code are not exhaustive, Section 151 recognises and confirms that if the Code does not expressly or impliedly cover any particular procedural aspect, the inherent power can be used to deal with such situation or aspect, if the ends of justice warrant it. The breadth of such power is coextensive with the need to exercise such power on the facts and circumstances.<br>(c) A court has no power to do that which is prohibited by law or the Code, by purported exercise of its inherent powers. If the Code contains provisions dealing with a particular topic or aspect, and such provisions either expressly or by necessary implication exhaust the scope of the power of the court or the jurisdiction that may be exercised in relation to that matter, the inherent power cannot be invoked in order to cut across the powers conferred by the Code or in a manner inconsistent with such provisions. In other words the court cannot make use of the special provisions of Section 151 of the Code, where the remedy or procedure is provided in the Code.<br>(d) The inherent powers of the court being complementary to the powers specifically conferred, a court is free to exercise them for the purposes mentioned in Section 151 of the Code when the matter is not covered by any specific provision in the Code and the exercise of those powers would not in any way be in conflict with what has been expressly provided in the Code or be against the intention of the legislature.<br>(e) While exercising the inherent power, the court will be doubly cautious, as there is no legislative guidance to deal with the procedural situation and the exercise of power depends upon the discretion and&nbsp; wisdom of the court, and in the facts and circumstances of the case. The absence of an express provision in the Code and the recognition and saving of the inherent power of a court, should not however be treated as a carte blanche to grant any relief.<br>(f) The power under Section 151 will have to be used with circumspection and care, only where it is absolutely necessary, when there is no provision in the Code governing the matter, when the bona fides of the applicant cannot be doubted, when such exercise is to meet the ends of justice and to prevent abuse of process of court.”<br></b></h4><h4><b>1<span style=\"font-size: 1.5rem; font-family: var(--bs-font-sans-serif);\">6. Some good guidance on invocation of Section 151 CPC to reopen an evidence or production of fresh evidence is also available in K.K. Velusamy3. To quote para 14: (SCC p. 284)</span></b></h4><h4><b>“14. The amended provisions of the Code contemplate and expect a trial court to hear the arguments immediately after the completion of evidence and then proceed to judgment. Therefore, it was unnecessary to have an express provision for reopening the evidence to examine a fresh witness or for recalling any witness for further examination. But if there is a time gap between the completion of evidence and hearing of the arguments, for whatsoever reason, and if in that interregnum, a party comes across some evidence which he could not lay his hands on earlier, or some evidence in regard to the conduct or action of the other party comes into existence, the court may in exercise of its inherent power under Section 151 of the Code, permit the production of such evidence if it is relevant and necessary in the interest of justice, subject to such terms as the court may deem fit to impose.”<br></b></h4><h4><b>17. Vadiraj and K.K. Velusamy have also found affirmation by this Court in Bagai Construction v. Gupta Building Material Store.<br></b></h4><h4><b>18. The settled legal position under Order 18 Rule 17 read with Section 151 CPC, being thus very clear, the impugned orders passed by the trial court as affirmed by the High Court to recall a witness at the instance of the respondent “for further elaboration on the left out points”, is wholly impermissible in law.</b><br></h4><p></p><p></p><p></p><p></p>', 'c63e25107ecaed31f1d2bbf7b0630634.jpeg', '085ae58ed488e248109fe52a547995a4.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-02-08', 1, '', '', '2020-12-02 21:25:57', '2023-02-08 11:03:31'),
(110, 'jGuoVdL8DAhsJvIgTY3g41ilT', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Order 23 Rule 1. Withdrawal of suit at the appellate stage. When not permissible.', '<h3>Withdrawal of suit at the appellate stage. When NOT permissible. </h3><h3>When a vested right is created in favour of the defendant in the suit by virtue of the decree, the suit cannot be withdrawn at the appellate stage so as to destroy the right. <br></h3><h3>Avenue Supermarkets Private Limited vs Nischint Bhalla and others. <br>(2016) 15 SCC 411.</h3>', 'b214bf6ca58535c8fe05a3588347b08b.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-10-29', 1, '', '', '2020-12-02 21:28:10', '2020-12-22 19:45:38'),
(111, '49ePqda5tmYarvVDh8yrP3Vp5', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'SARFAESI Act, 2002. Where the action of secured creditor is fraudulent or its claim is prima facie absurd, Civil Court jurisdiction can be invoked. Supreme Court. 8 April 2004', '<h6><b>Mardia Chemicals Ltd. v. Union of India</b></h6><p><b>Transfer Cases (C) 92-95 of 2002 decided on 8 April 2004</b></p><h6><b>Reported (2004) 4 SCC 311<br><span style=\"background-color: rgb(255, 255, 0);\">Relevant paragraphs: </span><br>51. However, to a very limited extent jurisdiction of the civil court can also be invoked, where for example, the action of the secured creditor is alleged to be fraudulent or his claim may be so absurd and untenable which may not require any probe whatsoever or to say precisely to the extent the scope is permissible to bring an action in the civil court in the cases of English mortgages. We find such a scope having been recognized in the two decisions of the Madras High Court which have been relied upon heavily by the learned Attorney General as well appearing for the Union of India, namely, V. Narasimhachariar5, AIR at pp. 141 and 144, a judgment of the learned Single Judge where it is observed as follows in para 22: (AIR p. 143)<br>“22. The remedies of a mortgagor against the mortgagee who is acting in violation of the rights, duties and obligations are twofold in character. The mortgagor can come to the court before sale with an injunction for staying the sale if there are materials to show that the power of sale is being exercised in a fraudulent or improper manner contrary to the terms of the mortgage. But the pleadings in an action for restraining a sale by mortgagee must clearly disclose a fraud or irregularity on the basis of which relief is sought: Adams v. Scott11. I need not point out that this restraint on the exercise of the power of sale will be exercised by courts only under the limited circumstances mentioned above because otherwise to grant such an injunction would be to cancel one of the clauses of the deed to which both the parties had agreed and annul one of the chief securities on which persons advancing moneys on mortgages rely. (See Ghose, Rashbehary: Law of Mortgages, Vol. II, 4th Edn., p. 784.)”</b></h6><div><br></div>', '850d75a5d6ca37f3c1fce0906d0df9c2.JPG', 'cd8385c9f9b6e0c3a0d36119e72c129a.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2004-04-08', 1, '', '', '2020-12-02 21:29:52', '2021-08-16 18:04:56'),
(112, '7ldsecieVx56D3xZ6OKNow5X0', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arbitration. Fraud. Requirements explained. Supreme Court. ', '<h3><div style=\"text-align: justify;\"><span style=\"font-size: 1.53125rem;\">Mere allegations of fraud not enough. When case of fraud is set up to wriggle out of arbitration agreement, the Court while dealing with an application under section 8 of the Act, must hold strict inquiry. Only when Court is satisfied that the allegations of fraud can be decided only by the civil court, then alone the application under section 8 should be rejected. (2016) 10 SCC 386.&nbsp;</span></div><i><br>A.Ayyaswamy vs Paramasivan</i></h3>', '381011841266396e691ac645ec8b1fc4.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-05', 1, '', '', '2020-12-02 21:31:20', '2021-01-21 22:43:13'),
(286, 'Iy3hIONUnlvNUWdvByjsU5Xjc', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Money laundering. “Proceeds of Crime”. Prosecution can be launched even if the offender is not a party to the predicate offence or there being no conviction. Karnataka High Court.', '<p><b>Money laundering. “Proceeds of Crime”. Prosecution can be launched even if the offender is not a party to the predicate offence or there being no conviction. Karnataka High Court.<br>Katta Subramaniam Naidu vs Deputy Director, Directorate of Enforcement. Criminal Petition 5698/2019 decided on 14 December 2020.<br><br>Judgment Link:<br> <a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/354332/1/CRLP5698-19-14-12-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/354332/1/CRLP5698-19-14-12-2020.pdf</a><br><br>Relevant Paragraphs:</b><br> <br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">Case law discussed. 43. In the backdrop of the analysis made by the various High Courts in the country and the interpretation placed on the crucial terms and expressions found in the PML Act, let me now proceed to deal with the issues raised by the learned counsel appearing for petitioners. The first and foremost question that need to be answered is, whether in the context of the provisions of the PML Act, prosecution initiated against the petitioners under section 3 of the PML Act and the confiscation proceedings resorted by the respondent under sections 5 and 8 of the PML Act are based on expost facto law and hit by the prohibition contained under Article 20(1) of the Constitution of India?</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">44. Petitioners appear to have put forward the plea of post facto law on the premise that the acts constituting the offences alleged against them were perpetrated prior to the amendment of the schedule to the PML Act and therefore, the action initiated against them falls within the mischief of Article 20(1) of the Constitution of India. This contention, in my view,&nbsp; in the factual setting of the case, is totally misplaced and misconceived and appears to have been canvassed by misconstruing the provisions of sections 3, 2(1)(u) and the Schedule appended to the PML Act. No-doubt, it is true that the Schedule to the PML Act was amended by Act 21 of 2009 and&nbsp; the various offences specified therein came to be included therein with effect from 1.06.2009. Nonetheless, in the instant cases, as on the date of initiation of action against petitioners, be it under section 3 or under section 5 of the PML Act, these provisions were very much there in the statute book. As already stated above, in all the cases, the prosecution under section 3 of the PML Act and adjudication proceedings under section 5 of the PML Act have been initiated against the petitioners subsequent to 1.06.2009. Therefore, the contention urged by learned counsel appearing for the petitioners that the petitioners are sought to be prosecuted on the basis of ex post facto laws is factually incorrect.</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">48. From the plain reading of section 3 read with section 2(1)(u) of the PML Act, it is clear that what is made punishable under section 3 is the activity connected with the proceeds of crime either by getting oneself involved in the process or activity connected thereto or directly or indirectly attempting to indulge or knowingly assist or knowingly be a party to the alleged activities and projecting it as untainted property, whereas the components of the offences under section 13 of the PC Act and Sections 120B, 419, 420 and other IPC offences are entirely different. The prosecution under section 3 of the PML Act, by no stretch of imagination, could be equated with the prosecution under section 13 of the PC Act or other offences specified in the Schedule namely IPC or other laws. They are distinct and separate offences. Prosecution under section 3 of PML Act is not based on the outcome of the trial of the offenders under section 13 of the PC Act. A reading of section 3 of PML Act in&nbsp; unamended form would clearly indicate that even without there being any conviction of the accused in a predicate offence and even if the offender under section 3 of the PML Act is not a party to the predicate offence, still the prosecution could be launched against him if the offender is found involved in any process or activity connected with the ‘proceeds of crime’.</span></div><i><br><b>Compiled by S. Basavaraj Advocate Daksha Legal.</b></i></p>', '67b5bb1ca5631123903ab2026e8337cb.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-14', 1, '', '', '2020-12-23 01:52:30', '2020-12-28 17:16:58');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(137, 'siTGhgMbXKINKDuNRaI2Q4ML1', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Limitation Act. Section - Sufficient Cause. Courts have to apply the provision in a meaningful manner ', '<h4>Limitation Act. Section 5. ‘Sufficient Cause’. Order of dismissal from service deprives right to livelihood. Courts have to apply the provision in a meaningful manner to subserve ends of justice. Karnataka High Court.</h4><h4><br>Suresh H.L vs The Management Sarvodaya Vidhyavardhaka and another Writ Petition 46435/2017 (S-Dis) decided on 4 November.</h4><h4><br>Judgement link: </h4><h4><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/347715/1/WP46435-17-04-11-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/347715/1/WP46435-17-04-11-2020.pdf</a></h4><p><span style=\"font-size: 1.3125rem;\"><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\"><b>Relevant paragraphs:</b> 8. Condonation of delay is discretion of the Court. Sufficient cause depends on the facts of each case. Sufficient cause means adequate cause. The party who seeks conduction of delay shall demonstrate&nbsp; that&nbsp; there&nbsp; was no negligence, or there was no inactiveness&nbsp; on&nbsp; his part. The reasons for condonation of delay must be bonafide and reasonable. Sufficient case (sufficient cause) is to be given liberal interpretation to ensure that substantial justice is done. An order of dismissal from service will have far reaching civil consequences on the petitioner, as the order of dismissal virtually amounts to deprivation of right to livelihood. In that circumstances, the Tribunal has failed to exercise jurisdiction vested in it.</span></div></span></p><h4><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">The&nbsp; Hon’ble&nbsp; Apex&nbsp; Court&nbsp; in&nbsp; the&nbsp; case&nbsp; of&nbsp; M/s.&nbsp; Katiji&nbsp; and others cited supra while considering Section 5 of the Limitation Act has held that “sufficient cause” employed by the legislature is adequately elastic to enable the courts to apply the law in a meaningful manner which subserves the&nbsp; ends&nbsp; of&nbsp; justice.&nbsp; &nbsp; Further&nbsp; the&nbsp; Hon’ble&nbsp; Apex&nbsp; Court&nbsp; has observed that while condoning the delay liberal approach is to be adopted keeping in mind the following principles:-</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(1) Ordinarily a litigant does not stand to benefit by lodging an appeal late.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(2) Refusing to condone delay can result in a meritorious matter being thrown out at the very threshold and cause of justice being defeated. Asagainst which when delay is condoned the&nbsp; highest that can happen is that a cause would be decided on merits after hearing the parties.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(3) ‘Every day’s delay must be explained’ does not mean that a pedantic approach should be made. Why not every hour’s delay, every second’s delay? The doctrine must be applied in a rational common sense pragmatic manner.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(4) When substantial justice and technical considerations are pitted against each other, cause of substantial deserves to be preferred for the other side cannot claim to have vested right in injustice being done because of a non-deliberate delay.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(5) There is no presumption that delay is occasioned deliberately, or on account of culpable negligence, or on account of malafides. A litigant does not stand to benefit by resorting to delay. In fact he runs a serious risk.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(6) It must be grasped that judiciary is respected not on account of its power to legalize injustice on technical grounds but because it is capable of removing injustice and is expected to do so.”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">Judgments in G.&nbsp; &nbsp; RAME&nbsp; &nbsp;GOWDA&nbsp; &nbsp;AND&nbsp; &nbsp; OTHERS&nbsp; &nbsp; Vs.&nbsp; &nbsp; SPECIAL&nbsp; &nbsp; LAND ACQUISITION&nbsp; OFFICER,&nbsp; BANGALORE,&nbsp; reported&nbsp; in&nbsp; (1988)&nbsp; 2SCC 142 and N.BALAKRISHNANVs.M.KRISHNAMURTHY&nbsp; &nbsp;reported&nbsp; &nbsp;in&nbsp; &nbsp;(1998) 7 SCC 123 relied on.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">10. The&nbsp; cause&nbsp; stated by the petitioner in the facts and circumstances of the case would constitute sufficient cause to condone the delay of 60 days in filing the appeal. The Tribunal failed&nbsp; to&nbsp; exercise its discretion judiciously while considering the application filed under Section 5 of the Limitation Act.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">Writ Petition allowed.</span></div><b><br>Compiled by S. Basavaraj and Sreekriti Taggarse, Daksha Legal.</b></h4>', '27652c7256d806cbbc826776731fd54c.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-04', 1, '', '', '2020-12-06 04:54:55', '2021-01-21 01:19:28'),
(138, '6QZBHAPhkvpheEORpUEtuxmtO', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka Grama Swaraj and Panchayat Raj Amendment Ordinance 2020 is retrospective ', '<h4 style=\"text-align: justify;\">Karnataka Grama Swaraj and Panchayat Raj (Amendment) Ordinance, 2020; and Karnataka Grama Swaraj and Panchayat Raj (Motion of No Confidence against Adhyaksha and Upadhyaksha of Zilla Panchayat) Rules, 2020 are retrospective in operation. Karnataka High Court.</h4><h4><br>Geetha Pandit Rao and another vs State of Karnataka and others. Writ Petition 7717/2020 &amp; Writ Petition 226494/2020 decided on 30 November 2020.</h4><h4><br><b>Judgment Link: </b></h4><h4><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350506/1/WP7717-20-30-11-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350506/1/WP7717-20-30-11-2020.pdf</a></h4><p><br></p><h4><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\"><b>Relevant Paragraphs</b>: (after thoroughly discussing case laws).&nbsp;</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">48. In order to ascertain correct position of law relating to interpretation of word “substitution”, it is relevant to consider the law declared by the Hon’ble Supreme Court in the case of VINEETA SHARMA (supra), wherein at paragraph 56 and 57 of the judgment, the Hon’ble Supreme Court, has held thus: “56. The prospective statute operates from the date of its enactment conferring new rights. The retrospective statute operates backward and takes away or impairs vested rights acquired under existing laws. A retroactive statute is the one that does not operate retrospectively. It operates in futuro. However, its operation is based upon the character or status that arose earlier. Characteristic or event which happened in the past or requisites which had been drawn from antecedent events. Under the amended section 6, since the right is given by birth, that is an antecedent event, and the provisions operate concerning claiming rights on and from the date of Amendment Act.</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">49. In view of the law declared by the Hon’ble Supreme Court with regard to ‘substitution’ in the case of VINEETA SHARMA (supra), the observation made by the Hon’ble Supreme Court in the case of SRI VIJAYALAKSHMI RICE MILLS and in the case of BHAGAT RAM (supra) are not applicable to the peculiar circumstances of these cases as the impugned amendment was procedural in nature and not substantive, as contended by the learned Senior Counsel appearing for the petitioners.</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">52. The above discussion would persuade me to deduce and infer that, the interim of the respondent-State, while amending the impugned Act and Rule was to give effect retrospectively. The respondent-State was conscious of the nature and character of the object of the Act. I have also carefully observed that, the use of word ‘substituted’ in the amended Act and Rules would subserve and support the submission of the learned Counsel appearing for the respondents.</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">54.After considering the judgments referred to above with regard to interpretation made to word ‘substitution’ and applying the same for the present case, which is procedural in nature, as the ‘vested rights’ or ‘accrued rights’ as contended by the learned counsel appearing for the petitioners, would begin from the date of their assumption of office as Member of the&nbsp; Zilla Panchayat and in that view of the matter, the contentions so advanced that the impugned amendment commences from the date of publication to the Act cannot be considered. In other words, the impugned amendment is retrospective in nature and not prospective.</span></div><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">55. In view of the law declared by the Apex Court referred to above and considering the submissions made by the learned counsel appearing for the parties, as well as looking into the intent of the legislature which amending the Act, to give effect to democratic values enshrined under Constitution of India, I found that, no public interest is involved insofar as the petitioners are concerned and on the other hand, the factum of public interest lies in favour of the members sought for non-confidence motion against the petitioners, as it is trite law that, democratic principles are the basic pillars to the golden lines runs through the provisions of the Constitution of India.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">HELD: Ordinance 2 of 2020 dated 31st March, 2020 to Karnataka Grama Swaraj and Panchayat Raj (Amendment) Ordinance, 2020; and Karnataka Grama Swaraj and Panchayat Raj (Motion of No Confidence against Adhyaksha and Upadhyaksha of Zilla Panchayat) Rules, 2020</span></div><br><b>Compiled by S. Basavaraj, Advocate, Daksha Legal.</b></h4>', '249b15a995f0f2730f75bb3dc818a2c1.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-30', 1, '', '', '2020-12-06 04:59:10', '2021-01-21 01:17:29'),
(139, 'q4bdhokqmIY72YYPEmsfKtep9', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Right of a major individual to marry person of his-her choice is a fundamental right. ', '<h3>Right of a major individual to marry person of his/her choice is a fundamental right which cannot be encroached by anybody irrespective of caste or religion. Karnataka High Court.</h3><h3><br>Judgment Link: </h3><h3><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350505/1/WPHC92-20-27-11-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350505/1/WPHC92-20-27-11-2020.pdf</a></h3><p><br></p><p><img src=\"https://dakshalegalhome.files.wordpress.com/2020/11/image-27.png?w=534\"></p><p><img src=\"https://dakshalegalhome.files.wordpress.com/2020/11/image-26.png?w=750\"><br></p>', '04ca7679a61410c40c62790fa0ae2176.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-27', 1, '', '', '2020-12-06 05:03:50', '2020-12-20 21:45:27'),
(140, 'lHFMTv01subJjM1qZsiwIpCQj', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Power of granting ad interim injunction is to preserve the subject matter of the suit', '<h4>Civil Procedure Code. Order 39 Rules 1 &amp; 2. Power of granting ad interim injunction, is to preserve the subject matter of the suit in the status quo for the time being. Supreme Court. (Judgment enclosed)</h4><h4><br><b>Judgment Link:</b><br><a href=\"https://dakshalegalhome.files.wordpress.com/2020/11/1992-1-scc-719.pdf\" target=\"_blank\">https://dakshalegalhome.files.wordpress.com/2020/11/1992-1-scc-719.pdf</a></h4><h4><br><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">Relevant paragraph:&nbsp;</b></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">4. Order 39 Rule 1(c) provides that temporary injunction may be granted where, in any suit, it is proved by the affidavit or otherwise, that the defendant threatens to dispossess the plaintiff or otherwise cause injury to the plaintiff in relation to any property in dispute in the suit, the court may by order grant a temporary injunction to restrain such act or make such other order for the purpose of staying and preventing … or dispossession of the plaintiff or otherwise causing injury to the plaintiff in relation to any property in dispute in the suit as the court thinks fit until the disposal of the suit or until further orders. Pursuant to the recommendation of the Law Commission clause (c) was brought on statute by Section 86(i)(b) of the Amending Act 104 of 1976 with effect from February 1, 1977. Earlier thereto there was no express power except the inherent power under Section 151 CPC to grant ad interim injunction against dispossession. Rule 1 primarily concerned with the preservation of the property in dispute till legal rights are adjudicated. Injunction is a judicial process by which a party is required to do or to refrain from doing any particular act. It is in the nature of preventive relief to a litigant to prevent future possible injury. In other words, the court, on exercise of the power of granting ad interim injunction, is to preserve the subject matter of the suit in the status quo for the time being. It is settled law that the grant of injunction is a discretionary relief. The exercise thereof is subject to the court satisfying that (1) there is a serious disputed question to be tried in the suit and that an act, on the facts before the court, there is probability of his being entitled to the relief asked for by the plaintiff/defendant; (2) the court’s interference is necessary to protect the party from the species of injury. In other words, irreparable injury or damage would ensue before the legal right would be established at trial; and (3) that the comparative hardship or mischief or inconvenience which is likely to occur from withholding the injunction will be greater than that would be likely to arise from granting it.</span></div></h4><h4><b style=\"font-size: 1.3125rem;\"><br>Compiled by S.Basavaraj, Advocate, Daksha Legal</b><br></h4><div><br></div>', '347073734cb5a813a7346cad3dd3995d.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-03', 1, '', '', '2020-12-06 05:07:57', '2021-01-21 00:31:27'),
(141, 'xhlZgWDekd3UGpbDWlvRDmIpC', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Power of Attorney can be revoked by the principal unless GPA is coupled with interest. ', '<h3>Contract Act, 1872. Section 202. Power of Attorney can be revoked by the principal unless the agent’s authority is coupled with interest. Supreme Court. (Judgment enclosed)</h3><p><span style=\"font-size: 24.5px; text-align: justify;\"><b><br>Judgment Link:</b>&nbsp;<br></span><a href=\"https://dakshalegalhome.files.wordpress.com/2020/11/1989-4-scc-603.pdf\" target=\"_blank\" style=\"font-size: 1.53125rem; background-color: rgb(255, 255, 255);\">https://dakshalegalhome.files.wordpress.com/2020/11/1989-4-scc-603.pdf</a><br></p><h3><div style=\"text-align: justify;\"><span style=\"font-size: 1.53125rem;\"><b>RELEVANT PARAGRAPH:&nbsp;</b></span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.53125rem;\">13. Even otherwise, under law revocation of agency by the principal immediately terminates the agent’s actual authority to act for the principal unless the agent’s authority is coupled with an interest as envisaged under Section 202 of the Indian Contract Act. When agency is revoked, the agent could claim compensation if his case falls under Section 205 or could exercise a lien on the principal’s property under Section 221. The agent’s lien on principal’s property recognised under Section 221 could be exercised only when there is no agreement inconsistent with the lien. In the present case the terms of the agreement by which the respondent was appointed as agent, expressly authorises the company to occupy the godown upon revocation of agency. Secondly, the lien in any event, in our opinion, cannot be utilised or taken advantage of to interfere with principal’s business activities.</span></div><br><b>Compiled by S.Basavaraj, Advocate, Daksha Legal</b></h3>', 'f7ab556144edeb213874d2ba36f24290.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-05', 1, '', '', '2020-12-06 05:17:40', '2021-01-21 00:34:13'),
(143, 'mPhz4cLUJ65Xkk7z6FHjjUuPb', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Motor Vehicle Act. Fraudulent. Tribunal is not bound by charge-sheet filed in criminal cases. ', '<h4>Motor Vehicle Act. Fraudulent implanting of insured vehicles. Tribunal is not bound by charge-sheet filed in criminal cases. Tribunal has to decide based on evidence when prima facie fraud is alleged. Karnataka High Court.</h4><h4><br>Mahadevi and others vs Shivaputra and another. Miscellaneous First Appeal 201689/2016 (MV) decided on 20 November 2020.</h4><h4><br>Judgment Link: </h4><h4>http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/349819/1/MFA201689-16-20-11-2020.pdf</h4><h4><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">The Karnataka High Court has expressed deep concern and anguish over the increasing cases where insured vehicles are implanted just to get compensation. In many vehicular accidents, the actual vehicle that caused accident lacks insurance policy. Many cases involve ‘hit and run’ accidents. In such cases, the “unscrupulous nexus” stages false scenario in implanting a “proxy” vehicle which is covered by insurance policy. The present case is a classic example of a clear fraud. After 103 days of the accident, brother of the deceased produces his own insured vehicle insinuating its involvement in the accident!</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">The Court noticed the earlier judgment in Sumangala and others vs Virupakshi and another MFA 30219/2011 decided on 15 June 2011. The fervent plea of the insurance company in the said case, questioning involvement of the insured vehicle as shown in the final report, was brushed aside by observing that ‘if there was any shady material which creates suspicion about the credibility of the final report, the proper course for the insurer should have been to apply to the higher authorities to get the matter investigated or at least should have challenged the final report seeking a writ of mandamus for reinvestigation”. However, the High Court in Mahadev’s case observed as follows; “”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">“‘We have, with great respect, perused the entire judgment. From a perusal of the same, we do not find any law laid down in the said judgment of universal application that in all cases where charge sheets were filed, unless Insurance Company challenges the same and obtains writ of mandamus, MACTs are required to act upon the same and proceed to come to a conclusion that the vehicles named as offending vehicles in the charge sheet, without any further proof, are to be taken as the motor vehicles involved in causing the accident, even in cases where evidence produced points to the contrary.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">‘Further, we find that in the said judgment, there is no discussion of the relevant provisions of Code of Criminal Procedure or other cognate provisions of law under which the police authorities would investigate and file charge sheets and on the probative value of the charge sheets vis-a-vis the involvement of a motor vehicle in causing the accident before the Tribunals trying the compensation cases. Experience of the recent past shows that instances of fraudulent/collusive involvement of motor vehicles duly covered by insurance policy in accident cases are burgeoning and if the insurance companies are saddled with the burden of challenging the charge sheets filed throughout the country without there being no clear legal mandate to do so, their work would be seriously crippled and they would not be able to do their insurance business without enhancing the premium, thereby further burdening the ever suffering owners of motor vehicles. Even the most liberal reading the provisions of the Motor Vehicles Act, 1988 does not spell out such a requirement.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">The question is one of fundamental importance – what is the standard of proof applicable in these proceedings? On whom is the initial burden of proving the accident or, as in this case, involvement of the offending motor vehicle cast? Is not still the standard of proof one of “preponderance of probabilities”? Is a mere charge’ sheet, which in this case is shown to be deficient in truth sufficient to tip the balance only on the premise that insurance company has not dipped deep into its pockets to challenge the charge sheet- what with the toxic nexus between the black sheep among the police, medical professionals and touts of every kind masquerading the field which has become a notorious fact of life. We are afraid, we would be muddling the field further for the already befuddled members of MACT by accepting the arguments of learned counsel for the appellants on this aspect’.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">NOTE: Fraud is a ground to question any administrative orders, quasi-judicial and even judicial verdicts. Lord Denning in one of his most celebrated judgments in Lazarus Estates Ltd v Beasley [1956] 1 Q.B. 702; [1956] 2 W.L.R. 502 held “No court in this land will allow a person to keep an advantage which he has obtained by fraud. No judgment of a court, no order of a Minister, can be allowed to stand if it has been obtained by fraud. Fraud unravels everything. The court is careful not to find fraud unless it is distinctly pleaded and proved; but once it is proved, it vitiates judgments, contracts and all transactions whatsoever…”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">The decision of the High Court has armed the Tribunals to independently assess involvement of insured vehicles when fraud is alleged and prima facie shown. The Tribunals are no longer shackled by the chargesheets filed in criminal cases.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">A path-breaking judgment in the direction of saving insurance companies from succumbing in the web of conspiracy, deceit and fraud.</span></div><b><br>Compiled and written by S. Basavaraj, Advocate, Daksha Legal.</b></h4>', '9f1d93b99a81035ded479693bc213aee.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-20', 1, '', '', '2020-12-06 05:42:37', '2021-01-21 00:03:44');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(144, 'OJqAFPmjDo2y5fncIa5T3t8Ud', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Alternative remedy is only a self imposed restraint and not a bar especially when the State act smacks of arbitrariness and legal malice', '<h4><br>Constitution of India. Article 226. Alternative remedy is only a self-imposed restraint and not a bar especially when the State act smacks of arbitrariness and legal malice. Law on the point discussed. Bombay High Court.</h4><h4><br>Kangana Ranaut vs Municipal Corporation of Greater) Mumbai and others. Writ Petition (ST) 3011/2020 decided on 27 November 2020. </h4><h4>Judgment</h4><h4><br><a href=\"https://dakshalegalhome.files.wordpress.com/2020/11/kangana_ranaut_v__state.pdf\" target=\"_blank\">https://dakshalegalhome.files.wordpress.com/2020/11/kangana_ranaut_v__state.pdf</a><a href=\"https://dakshalegalhome.files.wordpress.com/2020/11/kangana_ranaut_v__state.pdf\" target=\"_blank\"></a></h4><p><br></p><p><img src=\"https://dakshalegalhome.files.wordpress.com/2020/11/image-15.png?w=795\"><img src=\"data:image/png;base64,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', 'b09107a60cc54854c49eca60b6aaa6e2.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-27', 1, '', '', '2020-12-06 05:51:41', '2020-12-07 02:28:05');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(489, 'UjB6aOL7LJxMojN8JWslKZ1PB', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A.K. Gopalan vs State of Madras', '<h4><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">IN THE SUPREME COURT OF INDIA</span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">A.K. Gopalan vs State of Madras</span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Petition No. 13 of 1950, decided on May 19, 1950</span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Chief Justice Hiralal Kania, Justice Sayid Fazl Ali, Justice M Patanjali Sastri, Justice Meher Chand Mahajan, Justice B K Mukherejea, Justice S R Das.</span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Reported in 1950 SCR 88: AIR 1950 SC 27</span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">(1950) 51 Cri LJ 1383 </span></div><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem; background-color: rgb(255, 255, 0);\">Please see the pdf document&nbsp;</span></div></h4>', '28ba829037a5220886f5d329773fb04f.PNG', '0ca6184acb023a0cd4957cbdee5ae9a4.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '1950-05-19', 1, '', '', '2021-02-20 20:58:50', '2021-02-20 20:58:50'),
(490, 'CGbs69B6CA2S1zgnygMPQi0ki', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'IPC. Section 499. Mere use of words Boli Magane Soole Magane  by themselves do not constitute offence  unless imputations were made with the intention of undermining the reputation of the complainant. Karnataka High Court. ', '<h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><i style=\"background-color: rgb(255, 255, 0);\">Full Judgment below</i></h4><table class=\"table table-bordered\"><tbody><tr><td><p><br></p><h2 style=\"text-align: center; margin: 2pt 0cm 0.0001pt; line-height: 18pt; text-indent: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><b><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">IN THE HIGH COURT OF KARNATAKA&nbsp;<br></span></font><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">Jayappa vs Shamegowda*<br></span></font><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">Crl. Appeal No. 391 of 1983<br></span></font><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">Decided on January 11, 1983<br></span></font><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">Justice M.S. Patil and Justice M. Ramakrishna<br></span></font><font color=\"#000000\" face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\">Reported in 1983 SCC OnLine Kar 6: ILR 1985 Kar 680 at page 681</span></font></b></h2></td></tr></tbody></table><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b><br></b></span></font><b style=\"font-size: 16.6667px; font-family: \" open=\"\" sans\",=\"\" serif;=\"\" text-indent:=\"\" 18pt;\"=\"\">Justice M.S. Patil - These two appeals by special leave are directed against the judgment and order of acquittal dated 22-8-1983 passed by the Additional J.M.F.C. Tarikere, in C.C. No. 666 and 667 of 1982, respectively, whereby the Magistrate has acquitted the accused of the charge of the offence punishable under Section 500 IPC.</b><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b><br></b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>2. The appellant L.S. Jayappa being a resident of Lakkavalli in Tarikere Taluk of Chikmagalur District is a licensed money lender. Accused N.S. Shamegowda and Jayashankar are father and son and residents of Kenchikoppa village. In the year 1978, Jayappa had advanced a sum of Rs. 2000/- as loan to Shamegowda. When he failed to repay the amount borrowed, Jayappa brought Small Cause Suit No. 61/81 against him and obtained a decree and filed Execution Petition No. 12/81 and got arrested Shamegowda. But, on his undertaking to pay the amount on the next day, he was released. Thereafter, on 10-8-82, at about 12 noon, when Jayappa was standing on the pial outside his house, the accused, father and son, went upto his house and abused him saying “SOOLE MAGANE COURTININDA NINAGE KODABEKADA HANAVANNU WARRANT TARISI VASOOLI MADIDDIYA BOLI MAGANE……..”, as a result there was lot of commotion. 10 to 12 people also collected there. The P.S.I. also went there, dispersed the people. On the complaint given by him (complainant), the P.S.I. also prosecuted the two accused persons, both father and the son, for the offence punishable under Section 92(O) of the Karnataka Police Act. It is not disputed both the accused were tried of the said offence in C.C. 445/82 and on their pleading guilty they were also released on due admonition.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>3. Since according to the complainant - Jayappa, the abusive words “SOOLE MAGANE-BOLI MAGANE” were not only defamatory, but he was also much pained due to the abusive words used by the accused and the accused were guilty of the offence punishable under Section 500 IPC, he filed a complaint before the Magistrate. The learned Magistrate, after taking cognizance of the offence alleged proceeded with the trial and on the basis of the evidence before him and having regard to the fact that the accused had also pleaded guilty in the other criminal case instituted against them thought the accused had so abused the complainant Jayappa. But, he however concluded that such abusive words “SOOLE MAGANE - BOLI MAGANE” are commonly used by the villagers and, therefore, they could neither be regarded as defamatory nor they were used with such intention to defame him (complainant). In that view, he having acquitted the two accused-Respondents in these appeals, the complainant Jayappa has filed this appeal.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>4. Mr. Kadidal Manjappa, learned Counsel appearing for the appellant, vehemently argued not only the abusive words used by the accused were per se defamatory, but having regard to the background under which the accused went upto the house of the complainant Jayappa and abused him showed their intention was to defame and bring him in disrepute and the learned Magistrate was not justified in acquitting the accused. In support of his contention, he also placed reliance on some decisions of this Court as also decisions of other High Courts.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>5. Mr. Ravivarma Kumar, learned Counsel appearing for the respondents, on the other hand, argued supporting the order of acquittal passed by the Magistrate that apart from the fact that the say of the complainant the two accused had abused him using particular abusive words, as stated by him in the complaint and sworn to by him in his evidence, appears to be artificial in as much as they could not be expected to use the same abusive words simultaneously in a chorus; however vituperative the words used, the abuses by themselves cannot constitute an offence of defamation unless it is proved that the accused used those abusive words with such intention of defaming the person abused. In support of his contention, he also placed reliance on some decisions.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>‘Defamation’ as defined under Section 499 IPC means—</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>“Whoever by words either spoken or intended to be read, or by signs or by visible representations, makes or publishes any imputation concerning any person intending to harm, or knowing or having reason to believe that such imputation will harm, the reputation of such person, is said, except in the cases hereinafter excepted, to defame that person.”</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>There are various exceptions provided, but we are not concerned with any of those exceptions here in as much as the accused have not raised any such defence bringing their case under any of the exceptions provided. However, Explanation-1 under Section 499 IPC which is relevant here reads:</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>“It may amount to defamation to impute anything to a deceased person, if the imputation would harm the reputation of that person if living, and is intended to be hurtful to the feelings of his family or other near relatives.”</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>From this it also follows that any imputation of bad character to a deceased person, if the imputation would harm the reputation of that person if living, and is intended to hurt the feeling of his family or other near relatives, is defamation within the meaning of Section 499. The essence of the offence of defamation consists in its tendency to cause that description of pain which is felt by a person who knows himself to be the object of the unfavourable sentiments of his fellow creatures and those inconveniences to which a person who is the object of such unfavourable sentiments is exposed. It is not necessary that actual harm should be caused. It is sufficient if harm to the reputation of the person to whom the imputation is directed was intended. Thus, before a person is found guilty of the offence of defamation punishable under Section 500 IPC, not only the prosecution has to prove the imputations, verbal or written, made by the accused, but it also has to prove that the accused made such defamatory imputations with intention of defaming, ridiculing or undermining the reputation of the person complaining of the defamation. Although the words like “SOOLE MAGANE - BOLI MAGANE” said to have been used by the respondents-accused are grave and serious imputations in as much as they have tendency of suggesting either illegitimacy of the complainant or unchastity to the mother of the complainant, that is to say, his mother was merely a mistress of the father of the complainant and not married to him, but to say that they are per se defamatory sufficient to constitute an offence of defamation punishable under Section 500 IPC, it appears, cannot be sustained, unless it is proved that the accused intended to convey, by so publishing or publicly abusing, so as to make all others to believe literally that the complainant or his mother was so. The background and the circumstances under which such imputations were made are relevant to arrive at a conclusion whether the imputations were intended to be literally conveyed or they were only hurled as abuses. There must be something more than mere abuses from which it could be possible to infer that the imputations were made with such intention of defaming directly or indirectly the person complaining of. In the absence of any such proof or material, however, vituperative the abuses may be, the abuses by themselves may not be sufficient to constitute an offence of defamation punishable under Section 500 IPC.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>6. In the case of K.S. Nanjundaiah v. S.C. Thippanna [AIR 1952 Mysore 123.] relied upon by Mr. Kadidal Manjappa, learned Counsel appearing for the complainant-appellant, where the expression “black-marketeer” was used by the accused in relation to the complainant in a public gathering which was presided over by a Government Officer and in which besides the parties to the proceeding a large number of respectable persons of the locality were present, the expressions were held to be per se defamatory. There the circumstances proved were such as to show that the accused intended to harm the reputation of the complainant.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>In the case of Ramdhara v. Phulvatibai [1970 Crl. L.J. 286.] , where the defendant had abused the complainant in filthy language saying “Rand-Chhinal” in addition to saying she was in keeping of one Jagatram, it was held: It is of the essence of defamation that the words tend to be injurious to a person\'s character or reputation. The standard to be applied in determining whether a statement is defamatory or not is that of right-minded citizen, a man of fair average intelligence, and not that of a special class of persons whose values are not shared or approved by fair-minded members of the society generally. An imputation is defamatory, if it exposes one to disgrace and humiliation, ridicule or contempt. Proceeding further, it was observed:</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>“In the present case, if the defendants had merely littered the word “chhinal”, I would have held that the word did not convey its literal meaning, that is, a woman of easy virtue, but was only a vulgar abuse, which is not uncommon in villages when women quarrel among themselves. Mere vulgar abuse, which does not tend to lower a person addressed in the estimation of others or to bring him into obloquy, contempt or ridicule, does not amount to defamation. In such a case, the abuse is uttered merely to put an affront upon the feeling of the person abused, or as an insult to his dignity or self-respect without other persons knowing of it or without producing such an impression in their mind as its natural meaning would convey. But where words are uttered in circumstances tending to lower the person addressed in the estimation of the people present and to bring him into ridicule or contempt, they will constitute defamation and will be actionable.”</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>It is thus clear that there was a definite imputation upon the plaintiff\'s chastity in that case.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>In the case of K. Kanhai Singh v. R. Bhaskar Singh [AIR 1964 Manipur 20.] where one minor M.K. Sharangajit Singh alias Shivaji Singh and another M.K. Tutendrajit Singh were described as illegitimate half-brothers in the application made under the Guardians and Wards Act for appointment of guardian of the property of Maharaja, there being definite imputation of illegitimacy, it was held that the description of a person as illegitimate is a serious imputation to make and such an imputation affecting the reputation of the person against whom it is made, in as much as it means that the mother of the person, with reference to whom it is made was only a mistress of the person\'s father and not his married wife and it also affects the reputation of the mother of the person and the mother\'s father and the imputation harmed the reputation of the half-brothers and their mother amounting to an offence under Section 500 IPC.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>In the case of Dhruba Charan v. Dinabandhu [AIR 1966 Orissa 15.] , where the accused, who was the President of Grain Gola Co-operative Society, while presiding over a meeting, during the course of the discussion, abused the complainant who was the Sarpanch of the Grampanchayat Committee as “Sala — Chora” it was held, in the circumstances in which the abuses were hurled by a responsible person like the accused, he must have intended to defame or at least must be taken to have known that such defamatory words would necessarily injure the reputation of the complainant and lower his position in the estimation of others and as such constitute an offence punishable under Section 500 IPC. The circumstances under which the abusive words used were clear indication there, of the intention of the accused in making the imputations. In the case on hand, although there is no doubt the accused having gone upto the house of the complainant Jayappa had started abusing him in filthy words, but the way in which they were questioning the complainant abusing at the same time, about his conduct in taking warrants for the arrest in execution of the decree, showed that they were merely giving vent to their displeasure and anger by so abusing. Therefore, merely because that led to commotion, people gathered and the people also did not relish it, is no reason to hold that the accused by so abusing intended to defame the complainant or they did do so with the knowledge that they would thereby bring the complainant to disrepute, or they literally intended to convey that the complainant was illegitimate or his mother was merely a kept mistress and not married wife of the complainant\'s father.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>In the case of Jagannath Misra v. Ram Chandra Deo [AIR (32) 1945 Patna 450.] where the accused adopted a loud and insolent tone and was anxious that his remarks should b&nbsp;</b></span></font><b style=\"text-indent: 18pt; font-size: 16.6667px; font-family: \" open=\"\" sans\",=\"\" serif;\"=\"\">e heard, and cried out loudly that the complainant was not only a liar but was un-gentlemanly, barbarous and tyrannical, it was held that there was clear intention to insult the complainant. The accused ought to have known that the insult would be likely to lead to a breach of the public peace, which was avoided owing to the most commendable behaviour of the zamindar-complainant. The words used were not intended to be defamatory but amounts to insult.</b></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font face=\"Open Sans, serif\"><span style=\"font-size: 16.6667px;\"><b>In our considered view, therefore, the Magistrate was justified in acquitting the accused. The appeals therefore fail and they are accordingly dismissed.</b></span></font></h4><h4 style=\"margin: 2pt 0cm 0.0001pt; text-align: justify; text-indent: 18pt; line-height: 18pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><br></h4><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p>', '5e4545f4e277e3939585e9afb7950a1b.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '1983-01-11', 1, '', '', '2021-02-22 01:50:28', '2021-02-22 01:54:34'),
(491, 'zKtPpZ0PHEaHOow6mDOR3sJZN', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code. Rejection of plaint. Suit for cancellation of sale deed on the ground that full sale consideration had not been paid. Suit NOT maintainable. Plaint liable to be rejected. Supreme Court', '<h4>Dahiben vs Arvindbhai Kalyanji Bhnusali<br>Civil Appeal 9519/2010<br>Decided on 9 July 2020<br>Justice L.Nageswara Rao<br>Justice Indu Malhotra<br>Judgment link: <a href=\"https://main.sci.gov.in/supremecourt/2017/9337/9337_2017_34_1501_22768_Judgement_09-Jul-2020.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2017/9337/9337_2017_34_1501_22768_Judgement_09-Jul-2020.pdf</a><br>Held: 15.3 The Plaintiffs have made out a case of alleged nonpayment of a part of the sale consideration in the Plaint, and prayed for the relief of cancellation of the Sale Deed on this ground. Section 54 of the Transfer of Property Act, 1882 provides as under:<br>“54. ‘Sale’ defined.—‘Sale’ is a transfer of ownership in exchange for a price paid or promised or part-paid and partpromised.”<br>The definition of “sale” indicates that there must be a transfer of ownership from one person to another i.e. transfer of all rights and interest in the property, which was possessed by the transferor to the transferee. The transferor cannot retain any part of the interest or right in the property, or else it would not be a sale. The definition further indicates that the transfer of ownership has to be made for a “price paid or promised or part paid and part promised”. Price thus constitutes an essential ingredient of the transaction of sale.<br>In Vidyadhar v. Manikrao & Anr. (1999) 3 SCC 573 this Court held that the words “price paid or promised or part paid and part promised” indicates that actual payment of the whole of the price at the time of the execution of the Sale Deed is not a sine qua non for completion of the sale. Even if the whole of the price is not paid, but the document is executed, and thereafter registered, the sale would be complete, and the title would pass on to the transferee under the transaction. The non-payment of a part of the sale price would not affect the validity of the sale. Once the title in the property has already passed, even if the balance sale consideration is not paid, the sale could not be invalidated on this ground. In order to constitute a “sale”, the parties must intend to transfer the ownership of the property, on the agreement to pay the price either in praesenti, or in future. The intention is to be gathered from the recitals of the sale deed, the conduct of the parties, and the evidence on record.<br>In view of the law laid down by this Court, even if the averments of the Plaintiffs are taken to be true, that the entire sale consideration had not in fact been paid, it could not be a ground for cancellation of the Sale Deed. The Plaintiffs may have other remedies in law for recovery of the balance consideration, but could not be granted the relief of cancellation of the registered Sale Deed.<br>We find that the suit filed by the Plaintiffs is vexatious, meritless, and does not disclose a right to sue. The plaint is liable to be rejected under Order VII Rule 11 (a).<br></h4>', '459dc875886d415ec013f1bdd9be86ca.jpg', '371822cae74f962b27b2c75b4317d483.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-07-09', 1, '', '', '2021-02-22 20:05:29', '2021-02-22 20:07:03');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(492, 'dJQbRzbz9DYNl0fL4T37MzpYt', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Gowrishankara Swamigalu v. Sri Siddhaganga Mutt - Temporary Injunction', '<h4></h4><h4 style=\"text-align: justify;\"><span style=\"background-color: rgb(255, 255, 0);\"><i>Full Judgment below</i></span></h4><h4><table class=\"table table-bordered\" style=\"text-align: center;\"><tbody><tr><td><p><br></p><h4 style=\"text-align: center; color: rgb(0, 0, 0);\">Gowrishankara Swamigalu v. Sri Siddhaganga Mutt</h4><h4 style=\"text-align: center; color: rgb(0, 0, 0);\">M.F.A. No. 237 of 1989</h4><h4 style=\"text-align: center; color: rgb(0, 0, 0);\">Decided on 31 March 1989</h4><h4 style=\"text-align: center; color: rgb(0, 0, 0);\">Reported in 1989 SCC OnLine Kar 116 : ILR 1989 Kar 1701 : (1989) 2 Kant LJ 548 at page 1739</h4></td></tr></tbody></table></h4><h4 style=\"text-align: justify;\">Justice Shyamsundar:— This Miscellaneous First Appeal preferred under Order 43 Rule 1(r) of the Code of Civil Procedure arises out of and is directed against an order made by the Prl. Civil judge and C.J.M., Tumkur on I.A. No. 1 in O.S. 87/88 refusing to affirm an ad interim injunction granted to the plaintiff therein ensuring prevention of interference with the performance of the duties and functions by the plaintiff as Chara Jangama Pattadhikari and Uttaradhikari to the office of Mathadhipathi of a religious Mutt called Sri Siddaganga Mutt in the outskirts of Tumkur City in the neighbouring district of Tumkur.</h4><h4 style=\"text-align: justify;\">2. Upon the institution of the suit, the learned Judge had granted an ex parte injunction as aforesaid but after notice to the defendants who appeared and opposed the affirmation of the injunction besides insisting upon vacating the same, the learned Judge hearing both sides vacated the injunction and hence this appeal in which at the stage of admission itself, I have had the benefit of hearing not merely the appellant but also respondents who had successfully prevailed upon the Court below to vacate the injunction. The respondents appeared in this Court on their own, took notice of the appeal and joined issue with the appellant at the initial stage. With both sides providing all the pleadings and records that would be necessary for the disposal of the appeal, the appeal itself was heard on its merits so as to facilitate its final disposal which I propose to make by this order for which purpose I have treated this appeal as admitted as a step-in-aid for its final disposal.</h4><h4 style=\"text-align: justify;\">3. Although this appeal is but a mere proceeding arising from an interlocutory order nonetheless differs a little from the mill-of-the-run cases that are dealt with and disposed off routinely by this Court. The difference to by mind lies in the fact that the troika of parties associated in this appeal are three celibate monks and their bone of contention is an honoris causa being a position of honour i.e., the right to succeed to the title of the Mathadhyaksha of the Institution along with which marches the position of a contingent heir in waiting to step-in at the appropriate time for being inducted as the head of the institution. The appellant herein, was until deposed by the order of the second defendant dated 31-3-1988 the duly appointed heir apparent to the Headship of the Mutt and was a person waiting in the wings to step into the shoes of the Head as and when the latter stood removed from the scene in the usual course and due to natural reasons upon his demise. He was appointed as Uttaradhikari and Chara Jangama Pattadhikari by defendant No. 2 Dr. (Sri) Shivakumara Swamy, an octogenarian monk, belonging to the Lingayat community presently the Head of the Sri Siddaganga Mutt known far and wide not only for its spiritual fame but also as a centre of great learning and education. I was told that at present the institution was responsible for running and supporting 70 educational institutions under its auspices among which was a full-fledged Engineering College offering a course leading to a Degree in Engineering. It is not denied that all this was made possible by the dynamism and initiative of the octogenarian monk who, as admitted facts indicate, gave up the world to become an ascetic when he was still an young man of 20 years age and later became the Head of the institution when his own Guru passed away in the year 1941 at which time this institution although boasting of a lineage dating back to the 11th century was still a fledgling in the comity of religious institutions having then under its wing four educational institutions but after defendant Sri Shivakumara Swamigalu took over as the head of the Mutt, by constant application, devotion and assiduous labour the Swami had built-up single-handedly a great conglomerate of educational institutions which today almost matched numerically the Swami\'s advancing years.</h4><h4 style=\"text-align: justify;\">4. I have already mentioned that this appeal is by the plaintiff who is pitted against R1, a institution called Shri Siddaganga Mutt which incidentally was the first defendant in the suit and R2 is the Senior Swami - head of the first respondent institution who incidentally is the second defendant in the suit. R3 who is currently the third defendant in the Court-below is a person appointed by R-2 to fill in the office which, according to the defendants, became vacant following the removal of the plaintiff from the position of Chara Jangama Pattadhikari of the first-defendant institution. It is desirable to refer to the parties as plaintiff and defendants in the course of the order and it would also be convenient to refer to the appellant as ‘Junior Pontiff’ and to the second respondent as ‘Senior Pontiff’ during the course of this order.</h4><h4 style=\"text-align: justify;\">5. As pointed out earlier the uniqueness of this appeal consists not merely in the fact that it associates with it three celibate monks who are concerned not with any office of profit but an office although temporal in nature otherwise carried with it no ostensible perquisites with which an office is generally associated unless it be for the Honours that are said to march with it. In fact a very strong argument is built by Sri Sundaraswamy appearing for the Senior Pontiff in this Court, contending that both in the suit and in the interlocutory application the plaintiff asks for an order for sustaining or to continue to glorify himself by associating the Honours that went with the position of a religious potentate and therefore the Court should not at all countenance this application, the granting of which served no useful purpose.</h4><h4 style=\"text-align: justify;\">6. Be that as it may, it is somewhat odd that for a person who has renounced the world and abdicated its temporal pleasure the plaintiff should still grieve at the loss of his position as successor to the Mathadhyaksha after he became a persona non-designata following the adhesha issued by the second defendant.</h4><h4 style=\"text-align: justify;\">7. Counsel for the appellant Sri Parthasarathy during the course of a very forceful argument sought to make out that the plaintiff was not just fighting for resuscitating lost Honours nor was he pining away recalling to his mind the accolades he commanded when he was the acknowledged Guru, but Counsel submits that the plaintiff is also interested in his dry-stick rights as one appointed to an office from which he now finds himself ousted arbitrarily by another who was in a superior hierarchy no doubt but totally blinded by prejudice and bias towards his client so that the decision to remove the plaintiff, reached and made by such a person was clearly void, otiose and invalid. Counsel says such an order is clearly non est and has necessarily to be ignored, an aspect which he commends very strongly for consideration. This argument is refuted and very keenly too by learned Counsel Sri Sundaraswamy in tandem with Sri Nandeeshwar, Sri Veerabhadrappa and Mr. Shivappa appearing for the respondents, pointing out that not merely had the plaintiff lost the opportunity of becoming the supremo of the defendant-1 Institution in due course but he had also belittled the dignity and image of the position to which he had been elevated by the Senior Pontiff in the fond hope that he would be a worthy successor to him. Counsel submits that over the years the period stretching to more than a decade, the Senior Pontiff was grieved to find the junior not making use of the opportunity afforded to him for becoming a highly adorned spiritual leader but instead found him turning into a mercenary demagogue than a religious head and when he continued to act like a vandal bent on destroying the lofty and noble values for which the institution stood for and when all advice and attempts at correcting the junior had not merely failed but had resulted only in reverberating attempts by the junior at wresting the Senior\'s position even going to the extent of plotting against the Senior\'s life, the latter had then to act and remove the junior after issuing two show cause notices calling upon him to state why action to remove him should not be taken. It is then pointed out that only one of those two notices elicited a reply more marked for its impudence than offering any logical explanation but the other having remained quiscent without any reply, the Senior had therefore to act and eject the junior from office. Basing themselves on these divergent stands both sides argued their respective cases which probably to them was of some importance or may be of seminal importance but to my mind the arguments advanced were far beyond the scope of this appeal although they may be very relevant and pertinent to be raised and contested before the trial Court where the suit is still pending.</h4><h4 style=\"text-align: justify;\">8. Although by way of a preface I have brought out the salient features of the controversy on hand, to put it however in the proper perspective it would be necessary to make further advertance to the factual back-drop to the present controversy. As mentioned earlier this indeed is a hapless litigation between three monks who had admittedly renounced the world so as to be free to pursue eternal rewards within the sublime claim of the world beyond. By hind-sight it appears to me the endeavour of the plaintiff in trying to joust with the second defendant who admittedly picked him up and put him into a position of honour from which he was later removed by the second defendant himself and has inturn resulted in the filing of the suit giving rise to this appeal is indeed most unfortunate. It appears and both sides agree that according to the tradition of the Mutt the head of the Mutt chooses and appoints at some point of time during his life time, one who will succeed him in the years to come after being carefully groomed and made proficient in Dharmic studies, rituals and methodology of performing worship to the presiding deity of the Mutt etc. Such was also the case in regard to defendant-2 who became the heir apparent of the then Senior Swami, in the year 1930 before succeeding him in the year 1941. It is not in dispute that defendant-2 was single handedly managing the institution which at the present head count runs and manages 70 educational institutions with a student strength of 4000 on its campus all of whom it is said were fed free of cost by the Mutt throughout the year. Probably feeling the need to share the responsibility and to make room eventually for some one to succeed him, it was defendant No. 2 who sighted the plaintiff, an old alumnus of the Engineering College run by the Mutt, which he entered after completing his secondary education in other institutions of the very Mutt. The plaintiff soon after acquiring the Engineering Degree joined the ranks of the teachers in his old Alma Mater, before he was chosen by defendant No. 2 to succeed him. This transition of the plaintiff from a householder to a safforn robed monk took place in the year 1975 and I was told at a mammoth function organised at a cost of several lakhs of rupees the plaintiff was installed as Chara Jangama Pattadhikari and Uttaradhikari of the ruling Mathadhipathi, none other than the second defendant. It is mentioned that amongst the several thousands of people who attended the anointing ceremony there were many dignitaries of the State including the then Chief Minister and Governor etc. and that after the ceremony the plaintiff was taken in a procession on a palanquin along with the Senior so that the people at large could pay obeisance and offerings to him. On that occasion the record shows that the plaintiff had expressed his deep sense of gratitude to the Senior Pontiff on bestowing the cardinal distinction of becoming his successor and had said in the course of speech while replying probably to the felicitations showered on him as follows:</h4><h4 style=\"text-align: justify;\">It is this man who had said that he was a child in the hands of the Guru to be led at his will, has now thrown the gauntlet at the Guru in a Court of Law. Be that as it may, it is common ground that in the next two years he was in close communion with the Senior Pontiff and was initiated by him into the ways and means of performing worship etc., and was subsequently also entrusted with small responsibilities like overseeing the massive feeding programme that went on in the Mutt day-in and day-out catering to the needs of the students and the devotees who flocked to the Mutt daily. I was told that nobody who came to the Mutt was turned away without being fed at the Mutt\'s expense and this Mutt, therefore, was famed for this kind of Dasoha (Kyakarya). The Senior had also desired the plaintiff to go to Benaras for acquiring proficiency in Sanskrit studies but the plaintiff never responded to these suggestions and instead elected to continue in the Mutt saying that he was content at getting all the training from the Senior. Nonetheless, tutors were appointed for coaching the plaintiff in Sanskrit, scriptures etc. and it transpired later that the plaintiff being not interested in this kind of serious pursuits the teachers appointed for that purpose had perforce to leave. It also came to the notice of the Senior that the plaintiff was not taking seriously the responsibilities entrusted to him and was found to illtreat students who complained about non-availabillty of food etc. He had occasion to write to the plaintiff several letters and suffice. It to refer to four such letters written on 1-9-1981, 26-9-81, 12-1-62 and 8-5-86.</h4><h4 style=\"text-align: justify;\">In the later years it turned out the plaintiff was going about holding himself out as the President of the Mutt and was accepting all Honours due to that office and this practice appears to have continued despite the Senior\'s protestations. Things appear to have come to a head when in the presence of Senior Swamiji, the Junior allowed his followers to perform ‘Lakshabilvarchane’ to which Honour only the Head of the Mutt is said to be entitled to. All this appears to have brought about a serious rift between the two. Both of them began to suspect each other of making attempts at overthrowing one other and the Senior Pontiff even suspected foul play aimed against his life. Possibly these embittered feelings were fuelled by their own coterie of followers. The plaintiff also appears to have written a letter asking the local Superintendent of Police to give protection to him and to some of the persons referred to in the letter as members of his immediate entourage. In this state of affairs some of the well-wishers of the Mutt under the then Swamiji of Sutur Mutt of Mysore met to resolve the rift between them and in consequence a document was executed by the plaintiff stating that hence forward he would act and abide by the wishes of the Senior Swamiji. That document is dated 13-5-1986. But a day earlier the Senior Pontiff went to Bangalore and executed a Trust Deed regarding the properties of the Mutt constituting himself as sole trustee making it clear that the aforesaid step had to be taken because of the prejudicial activities of the junior pontiff. The plaintiff in a belated reaction issued a press note dated 14-3-1988 in which he decried the action of the Senior and vowed to take back all the properties of the Mutt if they were wrongly alienated. His statement in that behalf is as follows:</h4><h4 style=\"text-align: justify;\">In another incident a catche of fire crackers caught fire in the Mutt both Mutt property being damaged and probably injuring some people creating an atmosphere of fear in the Mutt all of which led the Senior Pontiff to issue the two show cause notices one in the year 1987 and another in the year 1988 asking the junior to show cause why he should not be removed. The plaintiff sent a reply only to the first show cause notice but chose not to reply the second one. In his reply he denied all the allegations made against him and stated that they were all false and trumped up by people who were ill-disposed towards him and hinted that the Senior was lending his ears unjustly to those who were interested in vilifying and denegrating him. But when the second show cause notice remained unanswered the Swamiji went ahead formally deposed the plaintiff and installing in his place the third defendant as his successor and Charajangama Pattadhikari. In the second notice the plaintiff had been given three months time to choose a place of his own at Bangalore where he would elect to reside and that he would be paid a monthly pension of Rs. 3,000/- if he resided there peacefully and without any further demurrer against the authority of the Senior Pontiff. The plaintiff who never accepted these terms filed the suit in the Court-below at the end of the three month truce period and obtained an ad-interim injunction against defendants 2 and 3 from allegedly Interfering with his own position as the appointed successor and Charajangama Pattadhikari. That injunction which was later vacated by the Court has since given rise to this appeal.</h4><h4 style=\"text-align: justify;\">9. The parameters under which the grant or refusal of an injunction admits of resolution being well known, only under those parameters even the instant case has to be decided and disposed off, although it may be that this appeal and the suit in the Court-below has aroused and generated a lot of interest amongst the general public particularly amongst the Lingayat community to whom the first defendant Institution was a largely venerated sanctum of religion. But the fact that a large number of the laity following a particular faith are likely to be interested or may be perturbed or disturbed by the outcome either in the suit or in this appeal is not a factor that concerns the Court and nor should that circumstance persuade the Court to enlarge the scope of its inquiry if it was otherwise limited under law.</h4><h4 style=\"text-align: justify;\">10. In these matters of injunctions it is trite that the grant or refusal thereof is discretionary but the discretion itself has to be exercised discreetly, with care and caution and not arbitrarily or capriciously. This Court in Life Insurance Corporation v. Bangalore L.I.C. Employees Housing Co-operative Society Ltd. [ILR 1988 Kar 2817.] has laid down what factors should weigh with the Court either in making or refusing an order for injunction. Adverting to the care to be exercised the Court said:</h4><h4 style=\"text-align: justify;\">“In a case where predicting of a possible result for the plaintiff being somewhat hazardous, it would be very necessary to tread with great caution the ground for granting temporary injunction.”</h4><h4 style=\"text-align: justify;\">Apropos the norms to be adopted, the Court again said:</h4><h4 style=\"text-align: justify;\">“But at the same time, in exercising its discretion the Court must totally circumspect and exercise extreme caution mindful of the fact either grant or refusal of the remedy will cause some harm or inconvenience to one side or the other…..Despite the guidelines and well laid out principles covering exercise of this jurisdiction, Courts, regrettably, have been administering the same like the proverbial Chancellor\'s foot of yore.”</h4><h4 style=\"text-align: justify;\">It is, therefore, only proper to proceed in this case also to evaluate the right of the plaintiff for an injunction in the light of the well-marked parameters such as prima facie case, balance of convenience, irreparable loss and injury. Added to this is the circumstance that I am not the Court of the first instance but I am a Court of Appeal whose jurisdiction is circumscribed and limited to ascertaining whether the trial Court in making the impugned order had committed any error in the application of the requisite principles to the facts of the case.</h4><h4 style=\"text-align: justify;\">10. The inquiry by me should not go beyond the foregoing and certainly does not extend to substituting my views to that of the learned Civil Judge. This again is trite law and a host of decisions of this Court make the aforesaid position very clear. I may refer in passing to the decision of His Lordship the Hon\'ble Mr. Justice Govinda Bhat (as His Lordship then was) in Lakshminarasimhiah v. Yalakki Gowda [1965 (1) Mys. L.J. 370.] . Adverting to the scope of an appeal from the order of the trial Judge granting or refusing to grant an interim injunction, His Lordship said:</h4><h4 style=\"text-align: justify;\">“What the Court of appeal has to consider is simply whether or not the Judge who dealt with the matter has properly exercised the discretion which he undoubtedly possesses. The Appellate Judge is not to approach the case as if he were the trial Judge. The granting or refusing of injunction is a matter resting in the sound discretion with the trial Court and consequently no injunction will be granted whenever it will operate oppressively or inequitably or contrary to the real justice of the case.”</h4><h4 style=\"text-align: justify;\">11. The decision in Lakshminarasimhaiah\'s case [1965 (1) Mys. L.J. 370.] has been followed by Venkataswamy, J. (as His Lordship then was) in Rangamma v. Krishnappa [1968 (1) Mys. L.J. 552.] . His Lordship held:</h4><h4 style=\"text-align: justify;\">“Granting or refusing of temporary injunction rests on the sound exercise of discretion by the Court. Such exercise of discretion cannot be lightly interfered with by the Appellate Court, unless it is shown that such exercise of discretion is unreasonable or capricious. That a different view was possible on the facts and circumstances of the case by itself will not be sufficient to interfere with the order.”</h4><h4 style=\"text-align: justify;\">Both these decisions have been referred to and followed with approval by Santosh J. (now of revered memory) in Laxmimanojana v. Sujnandra. [1970 (2) Mys. L.J. 82.] His Lordship in setting out the guidelines directing the exercise of power by the Appellate Court in these matters and in setting out the circumstances under which the Court of appeal could interfere in an appeal from an interlocutory order, made the following enunciation which bears reproduction:</h4><h4 style=\"text-align: justify;\">“If the discretion has been exercised by the trial Court reasonably and in a judicial manner, the fact that the Appellate Court would have taken a different view may not justify interference with the trial Court\'s exercise of discretion; but if it appears to the Appellate Court that in exercising its discretion the trial Court has acted unreasonably or capriciously or has ignored relevant facts then it would be open to the Appellate Court to interfere with the trial Court\'s exercise of discretion.”</h4><h4 style=\"text-align: justify;\">(Emphasis supplied)</h4><h4 style=\"text-align: justify;\">13. The foregoing principles were reiterated in a more emphatic manner by Hon\'ble Justice Kalaghate (now of revered memory) in Sakharam Nanasaheb Patel v. Vithal Siddappa Chalawadi, [1968 Vol. 17 Law Reports (Mysore) 512.] wherein he laid down as:</h4><h4 style=\"text-align: justify;\">“The Appellate Court has no power to set aside the discretionary order of the trial Court on the ground that the trial Court in its view has not correctly appreciated the materials placed before it.</h4><h4 style=\"text-align: justify;\">Held that the contention that the Appellate Court had full power to consider the appeal on merits in view of the provision of Section 104 read with Section 107 of the Code of Civil Procedure could not be accepted as correct in appeals arising out of interlocutory orders which are discretionary in nature.”</h4><h4 style=\"text-align: justify;\">Mr. Sundaraswamy also placed reliance on two decisions of Supreme Court reported in A.I.R. 1960 S.C. 1156, [Printers Ltd. v. Joseph.] and AIR 1967 SC 249 [U.P. Co-op. Federation Ltd. v. Sunder Bros.] wherein their Lordships had enumerated the very principles adumbrated in the decisions of this Court referred to supra.</h4><h4 style=\"text-align: justify;\">14. I might at this juncture recall that a good bit of the argument of Mr. Parthasarathy for the appellant was devoted in persuading me to hold that even in Ecclesiastical matters principles of natural justice applied and in this case where the Senior who had made allegations and accusations against the junior, not merely proceeded to hold an inquiry but also dismissed the junior eventually, thereby contravening the principles of natural justice. The submission is that the Senior had constituted himself a Judge to inquire into the very charges he had levelled against the junior and therefore the action of the Senior Pontiff came within the doctrine of ‘Nemo judex in re sua’ i.e., no one should be a Judge in his own cause and hence thoroughly indefensible.</h4><h4 style=\"text-align: justify;\">15. But Mr. Sundaraswamy appearing for the Senior pontiff submits that these principles of natural justice and allied concepts did not apply directly to ecclesiastical matters and that our religion had at all times recognised the power of the Mahant or the religious head to remove a sishya from his office and that the said power could not be exercised by any one other than the Mahant. The ultimate submission of Sri Sundaraswamy was that the Senior Pontiff had to act because of the prevalent exigency which required the intervention of the Senior to protect the interest of the Mutt. In other words, it was said that in the existing circumstances action taken by the Senior against the junior was accordingly inevitable there being no other option at all and therefore on the principle of the doctrine of necessity the passing of the impugned order was justified. Mr. Sundaraswamy reminiscing from the legendary scripture of Mahabharatha cited the following sloka in support of the impugned action:</h4><h4 style=\"text-align: justify;\">This stanze contains the advice of Vidura to Drutarashtra to cast away Duryodhana as the planetary signs under which he was born had indicated that he would be the sole cause for the destruction of the entire Kaurava dynasty. Vidura emphasising the great peril which awaited Kauvravas advised Drutarashtra to do away with Duryodhana so that the dynasty could be saved. His meaningful advice that it was better to sacrifice the individual in the interest of the rest of the family went unheeded and the result was the total perishing of the Kauvrava dynasty. Mr. Sundaraswamy cited this sloka from the ancient scripture to show that the Senior Pontiff\'s action in casting away the junior pontiff was taken to save the institution from the profligacy of the junior. But Mr. Parthasarathy for the junior pontiff urges a more modern outlook in these matters far removed from the embers of ancient relics and relies on a passage in Tagore Law Lectures, a treatise on which Mr. Sundaraswamy had earlier relied on in support of the contention that Mahant and Mahant alone can remove the Sishya inducted by him and nobody else had the power, to contend that not enough of invigorating research had been done in these matters justifying the conferring on the Mahant such large powers. I may also add that a galore of authorities had been relied upon by both Counsel in support of and against the propositions urged by either side.</h4><h4 style=\"text-align: justify;\">16. Although very fetching the argument has been on this point, I must refrain however from adverting even slightly to the claims made on either side in this behalf since it is likely to prejudice the trial of the suit pending in the Court below. Prudence dictates and precedent enjoins that I must accept the course of steering a neutral path. For these reasons I cannot and do not propose to oversee the correctness or otherwise of the action taken to remove the plaintiff from whatever office he had held following his induction in the year 1975 and must decline to say whether the action by the Senior Pontiff was void, ab initio or merely invalid or to say in this context whether the inquiry leading to the removal of the plaintiff not being by an independent person was bad in law. I shall not also advert to the question whether an inquiry in the circumstances could have been held by somebody else at all but shall leave it to be investigated by the Court below if these questions are again mooted and joined in by both sides at the trial.</h4><h4 style=\"text-align: justify;\">17. I must, however, at this juncture advert to an alternative stand of the plaintiff touching his removal since that requires a little consideration only regards a factual aspect. It is now urged before me that the Senior Pontiff had no power at all to remove the plaintiff because his position was that of a co-adjudicator under the Canon Law or that he was an associate in holiness with the Senior. In other words it is claimed that both the plaintiff and second defendant were persons of equal authority so that the latter could not have removed the plaintiff at all in the purported exercise of his authority. This argument was repeatedly highlighted before me and it was pointed out that the learned Judge in the Court-below had in the course of his order observed that Counsel for the plaintiff had conceded very fairly that the Senior Pontiff had the power to remove the junior pontiff and hence the investigation in the case should only be limited to ascertain whether such removal was for a good cause as enjoined by the decision of the Supreme Court in Thambeeran\'s case [(1974) 1 SCC 150 : AIR 1974 SC 199.] Mr. Parthasarathy who appeared for the plaintiff in this Court and in the Court-below, having argued the application for the grant of injunction in the Court below tells me that he had not made any concession regards the existence of power or authority in the Senior to remove the junior as noted by the Judge. Counsel says that learned Judge had mistakenly assumed that such a concession had been made before him while it was not made at all. If that is so I would assume with Counsel that he had not made any such concession and the Court-below was in some error in assuming the contrary. But, it seems to me, it matters very little, since that question being very much at large, the plaintiff would undoubtedly be at liberty to urge that he was removed not only without a good cause but that the Senior Pontiff had no power or authority to depose him from office at all. I make it clear that after the matter goes back to the Court-below if the question as to the authority of the Senior Pontiff to remove the junior pontiff is raised for active consideration, the Court-below will consider the same unbriddled by whatever had been stated by it while disposing off the I.A. under reference.</h4><h4 style=\"text-align: justify;\">18. Now that I believe I have fixed the contours of this appeal and the limits within which it must be decided, I shall now consider the same in the light of the point arising herein as follows:</h4><h4 style=\"text-align: justify;\">“Whether the Court-below was justified in the facts and circumstances of the case in refusing to affirm the ad-interim injunction granted to the plaintiff?</h4><h4 style=\"text-align: justify;\">19. As pointed out earlier grant of ad-interim injunction has to course through the following slots:</h4><h4 style=\"text-align: justify;\">(i) prima-facie case,</h4><h4 style=\"text-align: justify;\">(ii) balance of convenience,</h4><h4 style=\"text-align: justify;\">(iii) irreparable injury to the plaintiff, and</h4><h4 style=\"text-align: justify;\">(iv) lastly all injunctions being absolutely discretionary in nature whether there was any overriding consideration that supported the refused of the injunction by the Court-below.</h4><h4 style=\"text-align: justify;\">It is not disputed before me that the learned Judge considered the facts obtaining from the records in accordance with the foregoing parameters. Briefly I may recall his findings: To start with the learned Judge agreed with the plaintiff that he had made out a prima facie case by commending a serious question for consideration by the Court about the propriety or legality of the order passed by the Senior Pontiff deposing him from office and held that the question commended was one which was neither casual in nature nor was it a postulate tainted by levity.</h4><h4 style=\"text-align: justify;\">20. The learned Judge dwelling next on the question of existence or otherwise of a prima facie case has, however, limited it to the question as to whether the appointment of the plaintiff as a junior pontiff had been revoked by the Senior without any good cause. It is agreed that the plaintiff could have been unseated only if there was a good cause or justification for his removal. But the learned Judge seemed to think that Counsel for the plaintiff had accepted the position regards the availability of power in the second defendant to remove the plaintiff. But I have already noted that in this Court Mr. Parthasarathy for the appellant maintained that he had not made any such concession before the learned Judge.</h4><h4 style=\"text-align: justify;\">21. Be that as it may the learned Judge next proceeded to consider the question of balance of convenience and in ruling that such balance of convenience lay more in refusing the injunction rather than granting it, he foresaw the onset of chaos in the Mutt if the plaintiff were to be given an injunction and on the basis thereof the right to exercise the concomitant privileges of the office from which he had been ousted. According to him an order in his favour would cause great problems in the administration of the Mutt, concerned as it was in running a large number of educational institutions apart from catering to the needs both spiritual and temporal of its followers. He pointed out that proximity of the two Heads to one another as at present would be ruinous to the institution and would bring about disastrous consequences. He observed in his order at para 21 as follows:</h4><h4 style=\"text-align: justify;\">“This may lead to disastrous consequences since both plaintiff and defendant No. 2 may try to act in their own way and deal with the property and manage the affairs of the Mutt in their own way. This situation would definitely cause much injury or harm to the institution, whose interest, I consider as paramount and if such an order is granted, it would have adverse effect on the administration of the Institutions connected with the first defendant\'s Mutt.”</h4><h4 style=\"text-align: justify;\">22. Turning next to the question of irreparable loss and injury that the plaintiff would suffer by refusal of the injunction, the learned Judge in the penultimate part of the Judgment says:</h4><h4 style=\"text-align: justify;\">“Now in the instant case, it is admitted in the affidavit filed in support of I.A. 1 that the second defendant has been managing the affairs of the Mutt and the innumerable institutions run by the Mutt. It was also admitted by the learned Counsel for the plaintiff that defendant No. 2 is also there as Matadhyaksha and the right of defendant No. 2 to nominate his successor and further his right to remove his successor was also not disputed by the learned Counsel for the plaintiff. In fact, Tambiran\'s case referred to above is clear on this point that the Matadhyaksha has got right to remove his successor for any good cause and in the interest of the Mutt. Now that being so, it must now be considered as to what would be the effect, if an order of injunction is granted as prayed for in I.A. No. 1. The prayer in I.A. No. 1 as already mentioned is to restrain the defendants from interfering with the exercise and performance of the duties of the plaintiff and his functions as Matadhyaksha and Chara Jangama Pattadhikari. If this order of injunction is granted definitely the plaintiff would get all the rights exercise his power and performing his duties and functions as Matadhyaksha, in which event, there will be a parallel administration, both by the plaintiff and defendant No. 2, since admittedly defendant No. 2 is already there managing and administering the Mutt\'s affairs as Matadhyaksha. Therefore, the granting of order of injunction as prayed for in I.A. No. 1 would definitely be putting the institution in such a situation that both plaintiff and second defendant would be virtually acting as Matadhyakashas in their own way, which would be definitely not in the interest of the Mutt, which has a long history. This may lead to disastrous consequences, since both plaintiff and defendant No. 2 may try to act in their own way. This situation would definitely cause much injury or harm to the institution whose interest I consider as paramount and if such an order is granted it would have adverse effects on the administration of the institutions connected with the first defendant\'s Mutt. In this view of the matter, I am of the opinion that the injury that would be caused to the first defendant Mutt would be more than the injury that would be caused to the plaintiff.”</h4><h4 style=\"text-align: justify;\">23. The question now is whether the learned Judge had gone wrong anywhere either in addressing himself to the legal position regards the grant or otherwise of an injunction or whether the views expressed by him as above were so unreasonable, unjustifiable or sufficiently capricious to call for interference at the hands of this Court.</h4><h4 style=\"text-align: justify;\">24. I am to recall that Sri Parthasarathy for the appellant expended a lot of fire power on the finding of the learned trial Judge vis-a-vis the prima facie case he found to be clearly existent. Counsel submits that having regard to the tried and established position of law the order made by the defendant being in total transgression of the principles of natural justice was void and void ab initio and the Court was, therefore, duty bound to revive the office held by the plaintiff by the issue of a temporary Injunction so that he would not suffer or experience any aberration in the enjoyment of that office. Mr. Parthasarathy read to me passages from Halsbury\'s Laws of England, Woodroff on Injunction, Wade on Administrative Law besides relying repeatedly before me on the decision of the Supreme Court in Thambiran\'s case emphasising the principle laid down therein that the junior had also recognised powers in tune with that of the Senior with whom the junior shared a holy relationship in the enjoyment of spiritual power. Mr. Sundaraswamy, the Senior Counsel, appearing for defendants 1 and 2, herein sought to contend that in these matters of religion natural justice had no role to play at all and that nobody can be expected to or be in a better position to judge the pupil than the teacher himself. Without more this being clearly a case of necessity compelling the Senior Pontiff to act in expelling the junior for good reasons and in the interest of the Institution which he heads, the action so taken was not merely justified but was well-warranted. He relied on a passage from Jakson on ‘Natural Justice’ with particular reference to professional expertise being necessary to take a particular decision and necessity spelling out the exception to the rule nemo judex in re sua. The said principle therefore had to yield to necessity. Simillar passages in Wade\'s ‘Administrative Law’, Smith\'s ‘Judicial Review of Administrative Action’ and others were relied on. Mr. Parthasarathy in turn joined in with a chain of authorities to reinforce his argument that the Senior Pontiff being literally blinded with prejudice and hatred towards the Junior was totally incapacitated in acting in the matter and much less in taking a decision to the detriment of the plaintiff. The learned Judge in the Court below was invited to record a finding on this aspect of the matter but had wisely declined to do so. I must recount again that we are still at the threshold of the trial which is yet to commence and, therefore, in this Court I should take care not to say anything that is likely to prejudice one side or the other.</h4><h4 style=\"text-align: justify;\">25. I need hardly add the existence of a prima facie case in these matters of granting injunction is really the harbinger or the all clear sign to go ahead in investigating other aspects of the question governing the grant or refusal of injunction. If there was no prima facie case at all or the case put forward was so weak and tainted having very little prospect of being accepted by the Court, further questions of balance of convenience and irreparable loss need not be considered since the plaintiff would fall at the very first stile itself. But if there was a prima facie case then other considerations governing the grant of injunction would come into play and will also have to be evaluated before granting or refusing the injunction.</h4><h4 style=\"text-align: justify;\">26. In other words the existence of a prima facie case or even a very strong prima facie case does not permit leap-frogging by the plaintiff directly to an injunction without crossing the other hurdles in between. In England before the advent of the decision in American Cynamid Co. v. Ethicon Ltd. [ILR 1976 Kar 426.] referred to and followed by this Court in L.I.C. v. Bangalore L.I.C.E.H.C.S. Ltd. the existence of a prima facie case strong enough to ensure fool-proof success ultimately of the lis was treated as the criterion for the grant of any ad interim injunction. But that view underwent a sea change following the decision in Cynamid Company v. Ethicon Limited wherein the House of Lords said, in order to ascertain whether a prima facie case did exist or not, it was not necessary to hold a mini trial at the threshold but it would be sufficient if an endeavour was made by the Court to identify that the suit claim was neither vexatious or too casual for consideration. It is in that context this Court in L.I.C. v. Bangalore L.I.C.E.H.C.S. Ltd. made the following statement at para 24:</h4><h4 style=\"text-align: justify;\">“The preventive remedy of injunction is thus granted as an instant antidote to stop or prevent the invasion of the plaintiff\'s rights in regard to which a complaint is made. The Court having regard to the expediency involved should not embark upon a nit-picking operation at that stage by holding a mini trial to lay thread-bare the case of the plaintiff to find out if a prima facie case is made out or not. It would be sufficient if the Court is assured that questions raised by the plaintiff are not vexatious or too casual, but are such as to merit serious consideration at a subsequent stage.”</h4><h4 style=\"text-align: justify;\">There is overwhelming authority for the proposition that mere existence of a prima facie case or a very strong prima facie case does not ipso facto justify the grant of an injunction (See in this connection J. Krishnamoorthy v. Bangalore Turf Club, [ILR 1975 Kar 1957.] and National Advertises v. M.S.R.T.C. [1963 (2) Mys. L.J. 356.] Therefore even granting that the plaintiff has an invincible prima facie case, he will not be entitled ex debitiae justiciae, to the grant of an injunction unmindful of other consequences. If the consequences of granting an injunction are detrimental in nature then an injunction will not be granted even though the plaintiff might have an unbeatable prima facie case. It is precisely for this reason and just as the learned Judge in the Court below did, I must also desist from pronouncing finally on the question of niceities raised and argued by both sides touching the tainted character or otherwise of the impugned order made by the Senior Pontiff in removing the junior from office. A Court, it is said, like a human being must cross a bridge only when it comes across the same and not leap blindly even before it is reached and, it being not necessary to decide all these questions at this stage, I must desist from recording a finding on all these questions as that would be forestalling the issues arising in the suit.</h4><h4 style=\"text-align: justify;\">27. Hence, it is with some reluctance I refuse to be drawn into recording my views on all these matters despite the able assistance rendered by Counsel on either side. In sum I must say that on the first of the parameters for deciding an injunction namely the existence of a prima facie case, the learned Judge in the Court below having held that such a case did exist and that finding being entirely in favour of the appellant needs little for concurrence and even so I have no hesitation in concurring with the learned Judge in holding that the plaintiff had made out a prima facie case and has certainly not come forward with any ambiatory plaint requiring no serious consideration at all.</h4><h4 style=\"text-align: justify;\">28. The next point urged for consideration is the finding of the learned Judge appropos the balance of convenience as aspect on which he has non-suited the plaintiff. The question is whether he was right in doing so. What in the context is balance of convenience and how is it to be judged are aspects dealt with in the LIC case referred to supra. Adverting to the same this Court said:</h4><h4 style=\"text-align: justify;\">“‘Balance of convenience’ in thus not something akin to a tradesman\'s scales to be manipulated abroitly but it is the resultant anticipation by the Court in an objective manner of the concomitant hardships experienced by the one vis-a-vis advantages secured by the other party subject to there being clear chances of mitigating in some manner the hardship endured pendente lite by one or the other side and the prospect of being adequately compensated should pre-eminently be the primordial factor guiding exercise of discretion one way or the other.”</h4><h4 style=\"text-align: justify;\">Therefore, the question now is whether in the final analysis taking into consideration the grievance of the plaintiff, the rights of the defendants and particularly of the first defendant institution regard being had to the fact that its administration requires a well monitored system free from hassles between those responsible for running it, would it be convenient to Injunct the defendants against the plaintiff thus providing him immunity from the alleged meddlesome conduct of defendant No. 2?</h4><h4 style=\"text-align: justify;\">29. Mr. Parthasarathy throughout the course of his argument maintained that the plaintiff was not interested in asserting any right to participate in the administration of the Mutt or its kindred institutions but he would be content if he is only allowed the use of the residential part of the Mutt for his residence as before. It is common ground and as a matter of fact the temporary injunction granted by the Court below to the plaintiff continues even now and that injunction is merely made use of by the plaintiff who stays elsewhere for visiting a room in the Mutt premises now and then, at intermittent intervals staying there for some time before returning to his abode outside the Mutt- was told even during these periodic visits the plaintiff had to be accompanied by a posse of policemen to ensure his personal safety.</h4><h4 style=\"text-align: justify;\">30. The learned Judge, as can be seen from the excerpt of his order which I have culled out herein before, felt that the grant or continuance of the injunction would result in parallel administration with both the plaintiff and defendant No. 2 vying with each other to turn the wheel of administration leading to a result which would be disastrous to the Mutt and the educational institutions it was running. Mr. Parthasarathy takes serious exception to this finding and submits that even during the earlier days when his client had no differences with the Senior his client having followed the instructions of the Senior and had attended only to such work as had been entrusted to him. Counsel says that even now he would do the same thing and be content with a role more suited to a docile pet than to the Head of the Institution responsible for catering to the needs of the followers of the Mutt.</h4><h4 style=\"text-align: justify;\">31. I am afraid it is some what difficult to assimilate into the character of the plaintiff a supine attitude likes the one envisaged by his Counsel. From the galore of documents and pleadings that have been produced in the case, there is clear indication and it is also not denied that the relations between the Senior Pontiff and the junior pontiff has been greatly strained and badly soured. In the two show cause notices issued by the Senior to the junior he has alluded to the plot engineered by the junior not merely to overthrow him but also to do away with him. There are some letters written by the Senior to the junior long before the present impasse between them came to surface, expressing displeasure at the attitude, behaviour and conduct of the plaintiff in not devoting his attention to the affairs of the Mutt with particular reference to his callous neglect in bestowing care and attention on the students that are said to reside in the Mutt whose number, I am given to understand, touched nearly 4000 and all of them had to be fed by the Mutt which, indeed was a stupendous task. It may be noted that the Senior Swamy had in the past found some reason to take umbrage at the junior\'s conduct and to pull him up. Subsequently there were serious differences with each man blaming the other for the deteriorating situation.</h4><h4 style=\"text-align: justify;\">32. It has transpired that people from all walks of life in the State and in the town of Tumkur where the Mutt is located, not to mention the Ministers, Government Officers, police officials, having intervened and negotiated with the two Swamijis had finally resulted in a settlement in the month of May, 1986, as could be seen from a docket of assurance given by the junior agreeing to bury the hatchet and to begin anew with the onset of a new dawn. But then a day or two later the Senior went to Bangalore, executed a Trust Deed under which he constituted a Trust headed by himself and others who were in his confidence and in the course of the Trust Deed adverted to the unpredictable behaviour of the junior and to his distressing conduct of late had led him to believe that an occasion had arisen to take steps to ensure the safety of the vast properties of the Mutt so that they do not fall in later years into the outstretched hands of greedy inter-meddlers. The moment the plaintiff came to know of the execution of this Trust Deed he issued a press statement warning people from meddling with the properties of the Mutt covered by the Trust Deed and swearing to take action to rescue properties of the Mutt covered by the Trust, the ushering in of which was strongly deprecated. Thereafter he appears to have taken to making a foray of trips outside the Mutt claiming himself to be the head of the Mutt without making any reference to the Senior Pontiff who was still on the scene then and is very much on the scene even now.</h4><h4 style=\"text-align: justify;\">33. Added to all this there was an incident at which a catche of explosives stored in the Mutt had been set fire to, causing extensive damage to the properties of the Mutt and injuries to the inmates as well. The hand of the junior was suspected in that behalf. He also seems to have incurred the wrath of the Senior by gathering around him a coterie of people who appear to have little or no respect for the Senior Pontiff. One amongst them was a person called Maridevaru, a journalist of Tumkur whom the plaintiff had commended to the Superintendent of Police as a close associate requiring police protection, he had written, printed and published pamphlets denegrating the Senior swami whom he referred to as ‘Dr. Shavakumar Swami’. That Maridevaru was one among the others whom the plaintiff had occasion to commend to the police for protection as a member of his immediate entourage, against the marauders from the camp of the Senior.</h4><h4 style=\"text-align: justify;\">34. I have briefly examined at random some places of material having evidentiary value bearing on the question of balance of convenience and have adverted to some of them although there is infact a galore of documents indicating the plaintiff had of late been exhibiting a panache for supplanting the Senior and holding himself out as the Mathadhyaksha. As a matter of fact in the cause title to the plaint he describes himself as Mathadhyaksha, although his Counsel does not dispute that he was anointed and appointed only as Chara Jangama Pattadhikari. Counsel submits that it is on the basis of the decision of the Supreme Court in Thambiran\'s case referred to supra that relationship between the Senior and the junior being akin to that of co-adjutors or joint associates the reference to the plaintiff as Mathadhyaksha is sought to be justified. Regards the events that are said to have taken place within the Mutt disturbing its serene atmosphere, Counsel says that his client had been unjustly blamed and maligned although he had no hand in it and nor was he responsible for any of the incidents. Likewise in regard to deifying of the plaintiff in and outside the Mutt as the Head, Counsel again says that the junior was not responsible but his followers were. He maintains that even now he would only be content with being restored to his position inside the Mutt as before and to the Senior Pontiff who was still on the scene then and is very much on the scene even now.</h4><h4 style=\"text-align: justify;\">35. Again I must remind myself herein I am to examine whether the finding of the Judge in the Court below was not justified in the view he took on the question of balance of convenience on the basis of facts and material on record. It is for that purpose I have adverted to the material available on record so that I could review his conclusions in their background.</h4><h4 style=\"text-align: justify;\">36. It is not necessary to reiterate that on any of these questions or any other question arising herein there may be the possibility of this Court taking a different view from the one which the learned Judge below had taken but it will be wrong to substitute my views to that of the learned Judge, unless it can be said that on facts there was only one view to take and the learned Judge in the Court below had omitted to take the same, but it is a different proposition altogether where two views are possible. Bearing in mind the aforesaid principle, if the finding of the learned Judge is reviewed it becomes clear that it does merit affirmance and does not warrant expressing any demurrer. I am satisfied that armed with the injunction the plaintiff, is not likely to sit quiet with his arms akimbo. The statement the plaintiff had issued after the Senior Pontiff executed the Trust Deed clearly spells out the view point of the junior and the ambitions he nurtured even when the Senior Pontiff was still there and hence in the usual course he would not have any voice in the administration of the properties of the Mutt or in its affairs. Notwithstanding the same he had still voiced a strong dissent, almost clenched his fist swearing to take action to recover the properties of the Mutt from any one who had dared to take them on transfer. As pointed out by Mr. Sundaraswamy the imperious manner in which he commanded the Superintendent of Police to take care of his satraps clearly denotes his penchance for exercising authority all of which certainly does not forebode a comfortable sojourn for the Institution if the plaintiff is armed with an injunction and sent round the Mutt premises. I should think that even the slightest prospect of an anarchial situation prevailing in the Mutt following the arming of the plaintiff with an injunction by Court should be sufficient reason to preclude its grant. There is also a clear possibility of the people at large becoming the victims of the power-play between the plaintiff and defendants. In such circumstances, prudence, if not trite principles of law laid down by eminent writers like Woodroff, Nelson, Spry etc., to whose works my attention was repeatedly drawn to, commend refusal of the Injunction as a prudent course and discretion is better exercised by refusing the Injunction sought for. In more or less similar circumstances in a dispute between two religious heads, the trial Court having refused to grant an order of injunction to prevent the first defendant from entering into the sanctum sanctorum and offering worship, this Court refused to interfere with the said order. That was the decision of Santosh, J. to which I have referred to earlier in the case of Laxmimanojana v. Sujnandra. I must in the circumstances of the case follow with respect the said decision and decline to interfere with the finding by the Judge in the Court below refusing to continue the interim injunction.</h4><h4 style=\"text-align: justify;\">37. The last of the circumstance is the question of resultant injury to the plaintiff if injunction was refused. What does he suffer and what does he lose is the question. Even if he suffers something can he not be compensated is the other question. Adverting to the latter Sri Parthasarathy submitted that his client being a celibate monk neither looks forward to nor can he look forward to any requital monetarily. But the fact remains that althougn he may not want it, it is possible to compensate him by way of damages which may be just a token or a substantial sum depending on his volition. But that he may not avail the chance of compensating himself if he succeeds in getting a decree is not reason to hold that he had suffered presently an irreparable or uncompensatable Injury. In fact the submission of Mr. Parthasarathy that his client does not require any monetary compensation is taken to its logical end it only means that he has nothing to lose if he is denied the injunction unless it be the user of a room in the Mutt premises which even now he is said to use intermittently on some days in a week. But then if he has to exercise that right by walking into the premises surrounded by a contigent of the local police, one may well ask why at all he should indulge in an exercise he cannot perform as a free agent like any other human being. If his visit to the Mutt premises has to be organised in this manner and all that he does is to go and stay there now and then for a little while and that perhaps is because he has the key to the room still in his possession as stated before the Court below, it seems to me that expending of judicial authority for granting an injunction to the plaintiff just to enable him to make sporadic visits to the Mutt premises from his place of residence elsewhere therefore appears to be only a meaningless charade and does not really serve any useful purpose. He does not suffer any inconvenience by not visiting the Mutt and nor does he stand to gain anything by his occasional visits under heavy escort. Therefore, the exercise of discretion in favour of the plaintiff would be clearly pyrrhic unattended by any tangible rewards either to the plaintiff or to any one else.</h4><h4 style=\"text-align: justify;\">38. On the contrary these visits if done under the cover of the injunction might bring in some untoward results so far as the defendants are concerned and can well be avoided by declining to grant the injunction as the plaintiff himself benefits very little. Therefore, it is after analysing the case of the plaintiff vis-a-vis the legal requirements enjoined for consideration by a Court, it becomes clear that plaintiff satisfies none of them and that being also the view of the learned Judge, I must unhesitatingly concur with him. Before parting with this topic, I must advert to a submission made by Sri Parthasarathy, learned Counsel for the appellant, criticising the Judgment of the Court below on the ground that it had failed to make an order on terms, in that, even while declining to grant injunction it should have put the other side on terms, a step Counsel submits that would have been in tune with the decision of this Court in L.I.C. v. Bangalore LIC E.H.C.S. Ltd. referred to earlier. It is true in that Judgment I did say that granting of injunction should always be made on terms so that in the ultimate disposition it turns out that granting of the injunction was unwarranted, a person who suffered the injunction should not be driven to further litigation, to reimburse himself regards loss or damage sustained in consequence of that injunction. But then in the instant case the Court has refused the injunction and what the plaintiff suffers by non-grant is an aspect which generates a lot of scepticism and doubt, therefore in such circumstances if the Court below had merely refused the injunction and not taken the precaution of soft peddling that order further by imposing some terms on the defendants to make allowance for the contigent success of the plaintiff in the suit, I do not think that any criticism could be justly levelled against the Court of having committed a default under law. In that view of the matter, it becomes clear that the last-ditch attack on the learned Judge\'s order by the plaintiff has very little to commend itself and clearly deserves to be discarded.</h4><h4 style=\"text-align: justify;\">39. There is yet another reason why I should decline the injunction as the learned Judge in the Court below did. In the records there is reference to a charge-sheet filed by the Tumkur police against the plaintiff, no doubt after the institution of the suit, alleging the commission of an unnatural offence punishable under Section 377 IPC. It is a charge-sheet filed by the police of the Karnataka State and is clearly not a myth. Presently I am given to understand that plaintiff has been enlarged by the Court on bail. But the up-shot of the whole thing is that today he is facing a charge of extreme infamy wholly incongruent and inconsistent with his image as a religious head expected to minister to the spiritual needs of his flock. It would indeed be a curious spectacle if on the crest of an injunction granted by the Court the plaintiff first rides to a conclave of his laity to receive their obeisance and the very next moment is in the dock before the Criminal Court answering the charge of having committed an offence involving moral turpitude most unbecoming of a religious pontiff. Mr. Parthasarathy says his client had been framed falsely in a vile attempt to scandalise and to denigrate him in the eyes of the public at large. But whether it is that or otherwise the truth will come out only after trial and until then while nobody can say he is guilty it can still be said that he is accused of a blasphemous criminal offence and is facing a trial in that behalf. I need hardly add that the relief of injunction being a remedy in equity must be bestowed only on those whose reputation and hands are both spotlessly clean. If not anything else, at least this circumstance should over-ride all other considerations and must lead to the affirmation of the order of the Court below in refusing to continue the ex parte injunction granted by it.<br>40. Therefore, it is and for the reasons mentioned above, I affirm the order of the Court below and make an order dismissing this appeal. Costs herein will be costs in the cause and will abide by the final result in the suit.</h4><div style=\"text-align: justify;\"><br></div>', '42fd8b18c79bdeb5c492f49a866447b5.PNG', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '1989-03-31', 1, '', '', '2021-02-22 20:45:26', '2021-02-23 00:36:36');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(122, 'Ik9cYZgQbKuIP3qt32BhnQ537', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Mohinder Singh Gill and  anr vs The Chief Election Commissioner New Delhi and anr ', '<h4 style=\"font-family: Rockwell, Corbel, \" museo=\"\" 500\",=\"\" helvetica,=\"\" arial;=\"\" font-size:=\"\" 14.4px;\"=\"\"></h4><h4 style=\"text-align: center;\"></h4><h2 style=\"text-align: center;\"><b>Mohinder Singh Gill & anr vs The Chief Election Commissioner, New Delhi and Ors. </b></h2><b style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><b style=\"font-size: 1.3125rem;\">AIR 1978 SC 851; 1978 (1) SCC 405 2</b></div></b><b><span style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Chief Justice BEG, M. HAMEEDULLAH </span></div></span><span style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Justice KRISHNAIYER, V.R.</span></div></span><span style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Justice BHAGWATI, P.N.</span></div></span><span style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Justice GOSWAMI, P.K.</span></div></span><span style=\"font-size: 1.3125rem;\"><div style=\"text-align: center;\"><span style=\"font-size: 1.3125rem;\">Justice SHINGAL, P.N.</span></div></span></b><h4 style=\"text-align: center;\"><div style=\"text-align: center;\"><br></div><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><div>Judgment - KRISHNA IYER, J.-What troubles us in this appeal, coming before a Bench of 5 Judges on a reference under Article 145(3) of the Constitution, is not the profusion of controversial facts nor the thorny bunch of lesser law, but the possible confusion about a few constitutional fundamentals, finer administrative normae and jurisdictional limitations bearing upon elections. What are those fundamentals and limitations? We will state them, after mentioning briefly what the writ petition, from which this appeal, by special leave, has arisen, is about, 279 The basics Every significant case has an unwritten legend and indelible lesson. This appeal is no exception, whatever its formal result. The message, as we will see at the end of the decision, relates to the pervasive philosophy of democratic elections which Sir Winston ChurchiU vivified in matchless words :</div><div>\"At the bottom of all tributes paid to democracy is the little man, walking into a little booth, with a little pencil, making a little cross on a little bit of paper-no amount of rhetoric or voluminous discussion can possibly diminish the overwhelming importance of the point.\" If we may add, the little, large Indian shall not be hijacked from the course of free and fair elections by mob muscle methods, or subtle perversion of discretion by men dressed in little, brief authority. For \'be you ever so high, the law is above you.</div><div>The moral may be stated with telling terseness in the words of William Pitt: \'Where laws end, tyranny begins\'.</div><div>Embracing both these mandates and emphasizing their combined effect is the elemental law and politics of Power best expressed by Benjamin Dizreeli:</div><div>\"I repeat that all power is a trust-that we are accountable for its exercise-that, from the people and for the people, all springs, and all must exist.\" (Vivien Grey, BK. VI. Ch. 7) Aside from these is yet another, bearings on the, play of natural justice, its nuances, non-applications, contours, colour and content. Natural Justice is no mystic testament of judge-made juristics but the pragmatic, yet principled, requirement of fairplay in action as the norm of a civilised justice-system and minimum of good government-crystallised clearly in our jurisprudence by a catena of cases here and elsewhere.</div><div>The conspectus of facts The historic elections to Parliament, recently held across the ,country, included a constituency in Punjab called 13- Ferozepore Parliamentary constituency. It consisted of nine assembly segments and the polling took place on March 16, 1977. According to the calendar notified by the Election Commission, the counting took place in respect of five assembly segments on March 20, 1977 and the, remaining four on the next day. The appellant and the third respondent were the principal contestants. It is stated by the appellant that when counting in all the assembly segments was completed at the respective segment headquarters, copies of the results were given to the candidates and the local tally telephonically communicated to the returning officer (respondent 2). According to the scheme the postal ballots are to arrive at the returning officer\'s headquarters at Ferozepore where they are to be counted. The final tally is made when the ballot boxes 280 and the returns duly reach the Ferozepore headquarters front the various segment headquarters. The poll proceeded as ordained, almost to the very last stages, but the completion of the counting at the constituency headquarters in Ferozepore was aborted at the final hour as the postal ballots were being counted-thanks to mob violence allegedly mobilised at the instance of the third respondent., The appellant\'s version is that he had all but won on the total count by a margin of nearly 2000 votes when the panicked opposite party havoced and halted the consummation by muscle tactics. The postal ballot papers were destroyed. The, ballot boxes from the Fazilka segment were also done away with en route, and the returning officer was terrified into postponing the declaration of the result. On account of an earlier complaint that the returning officer was a relation of the appellant, the Election Commission (hereinafter referred to as Commission) had: deputed an officer of the Commission-Shri IKK Menon-as observer of the poll process in the constituency. He was present as the returning officer who under compulsion had postponed the concluding 3 p.m.</div><div>onwards. Thus the returning officer had the company of the observer with him during the crucial stages and controversial eruptions in the afternoon of March 21.</div><div>Shortly after sunset, presumably, the returning officer who under compulsion had postponed the concluding part of the election, reported the happenings by wireless massage to the Election Commission. The observer also reached Delhi and gave a written account and perhaps an oral narration of the untoward events which marred what would otherwise have been a smooth finish Lo, the election.</div><div>Disturbed by the disruption of the declaratory part of the election, the appellant, along with a former Minister of the State, met the Chief Election Commissioner (i.e. the Commission) at about 10.30 A.M. on March 22nd, with the request that he should direct the returning officer to declare the result of the election. Later in the day, the Commission issued an order which has been characterised by the appellant as a law-less and precedentless cancellation, of the whole poll, acting by hasty hunch and without rational appraisal of facts. By the 22nd of_March, when the Election Commission made the impugned order, the bulk of the electoral results in the country bad beamed in. The gravamen of the grievance of the appellant is that while he had, in all probability, won the poll, he has been deprived of this valuable and hard-won victory by the arbitrary action of the Commission going contrary to fairplay and in negation of the basic canons of natural justice. Of course the Commission did not stop with the cancellation but followed it up a few days later with a direction to hold a fresh poll_for the whole constituency, involving all the nine segments, although there were no complaints about the polling in any of the constituencies and the ballot papers of eight constituencies were available intact with the returning officer and only Fazilka segment ballot papers were destroyed or demanded on the way, (plus the postal ballots). It must also, be mentioned here that a demand was made, according to the version, of the third respondent, for recount in one segment which was,, 281 unreasonably, turned down. The observer, in his report to the Election Commission, also mentioned that in two polling stations divergent practices were adopted in regard to testing valid and invalid votes. To be more pracise, Shri IKK Menon mentioned\' in his report that at polling station no. 8, the presiding officer\'s seal on the tag as well as the paper seal of one box was broken. But the ballot papers contained in that box were below 300 and would not have affected the result in the normal course. In another case in Jalalabad assembly segment, the assistant returning officer had rejected a number of ballot papers of a polling station on the score that they were not signed by the presiding officer. In yet another case it was reported that the ballot papers were neither signed nor stamped but were accepted by the assistant returning officer as valid, al- though the factum was not varified by Shri Menon with the assistant returning officer. Shri Menon, in his report, seems to have broadly authenticated the story of the mob creating a tense situation leading to the military being summoned. According to him only the ballot papers of Fazilka assembly segment were destroyed, not of the. other segments. Even regarding Fazilka, the result-sheet had arrived. So, far as Zira assembly segment was concerned, some documents (not the, ballot papers) had been snatched away by hooligans. The observer had asked the returning officer to send a detailed report over and above the wireless message. That report, dated March 21, reached the Commission on March 23, but, without waiting for the, report we need not probe the reasons for the hurry-the Commission issued the order cancelling the poll. The Chief Election Commissioner has filed a laconic affidavit leaving to the Secretary of the Commission to go into the details of the facts, although the Chief Election Commissioner must himself have had them within his personal ken. This aspect also need not be examined by us and indeed cannot be, for reasons which we will presently set out.</div><div>Be that as it may, the Chief Election Commissioner admitted in his affidavit that the appellant met him in his office on the morning of March 22, 1977 with the request that the returning officer be directed to declare the result. He agreed to consider and told him him off,, and eventually passed an order as mentioned above. The then Chief Election Commissioner has mentioned in his affidavit that the observer Shri Menon had apprised him of \"the various incidents and developments regarding the counting of votes in the constituency\" and also had submitted a written report. He has also admitted the receipt of the wireless message, of the returning officer. He concludes his affidavits \'that after taking all these circumstances and information including the oral representation of the 1st petitioner into account on \"2nd Much, 1977 itself I passed the order cancelling the poll in the said Parliamentary constituency. In my view this was the only proper course to adopt in the circumstances of the case and with a view to ensuring fair and free elections, particularly when even a recount bad been rendered impossible by reason of the destruction of ballot papers.\' The order of the Election Commission, resulting in the demolition of the poll already held, may be read at this stage.</div><div>282 \"ELECTION COMMISSION OF INDIA New Delhi Dated 22 March, 1977 Chaitra 1, 1899 (SAKA) NOTIFICATION S.O.-Whereas the Election Commission has received reports from the Returning Officer of 13-Ferozepore Parliamentary Constituency that the counting on 21 March, 1977 was seriously disturbed by violence; that the ballot papers of some of the assembly segments of the Parliamentary constituency have been destroyed by violence; that as a consequence it is not possible to complete the counting of the votes in the constituency and the declaration of the result cannot be made with any degree of certainty:</div><div>And whereas the Commission is satisfied that taking all circumstances into account, the poll in the constituency has been vitiated to such an extent as to effect the result of the election;</div><div>Now, therefore, the Commission, in exercise of the powers vested in it under Article 324 of the Constitution, Section 153 of the, Representation of the People Act, 1951 and all other powers enabling it so to do, cancels the poll already taken in the constituency and extends the time for the completion of the election up to 30 April, 1977 by amending its notification No. 464/77, dated 25 February, 1977 in respect of the above election as follows :- In clause (d) of item (i) of the said notification, relating to the completion of election- (a) in the existing item (i), after the words \"State of Jammu and Kashmir\", the words \"and 13-Ferozepur Parliamentary constituency in the State of Punjab\" shall be inserted; and (b) The existing item (ii) shall be renumbered as item (iii), and before the item (iii) as so renumbered, the following item shall be inserted, namely :- \"(iii) 30 April 1977 (Saturday) as the date before which the election shall be completed in \"13Ferozepur Parliamentary constituency in the State of Punjab.\" [464/77] By order Sd/- A. N. Sen, Secretary The Commission declined to reconsider his decision when the appellant pleaded for it. Shocked by the liquidation of the entire poll, the latter moved the High Court under Article 226 and sought to void the order as without jurisdiction and otherwise arbitrary and violative of any vestige of fairness. He was met by the objection, successfully urged by the respondents 1 and 3, that the High Court 283 -had no jurisdiction in view of Article 329(b) of the Constitution and the Commission had acted within its wide power under Article 324 and fairly. Holding that it had no jurisdiction to entertain the writ petition. the High Court never-the-less ]proceeded to enter verdicts on.the merits of all the issues virtually exercising even the entire ,jurisdiction which exclusively belonged to the Election Tribunal. The doubly damnified appellant has come up to this Court in appeal by special leave.</div><div>Meanwhile, pursuant to the, Commission\'s direction, a re- poll was held. Although the appellant\'s name lingered on the ballot he did not participate in the re-poll and respondent 3 won by an easy plurality although numerically those who voted were less than half of the, previous poll.</div><div>Of course, if the Commission\'s order for re-poll fails in law, the second electoral exercise has to be dismissed as a stultifying futility. Two things fall to be mentioned at this stage, but, in passing, it may be stated that the third respondent had complained to the Chief Election Commissioner that the assistant returning officer of Fazilka segment had declined the request for recount unreasonably and that an order for re-poll of the Fazilka assembly part should be made \'after giving personal hearing\'. Meanwhile, runs the request of the third respondents \'direct the returning officer to withhold declaration of result of 13 Ferozepore parliament constituency\'. We do not stop to make inference from this document but refer to it as a material factor which may be considered by the tribunal which, eventually, has to decide, the factual controversy.</div><div>The second equally relevant matter is that when a statutory functionary makes an order based on certain grounds, its validity must be judged by the reasons so mentioned and cannot be supplemented by fresh reasons in the shape of affidavit or otherwise. Otherwise, an order bad in the beginning may, by the time it comes to court on account of a challenge, get validated by additional grounds later brought ,out. We may here draw attention to the observations of Bose J. in Gordhandas Bhanji (1) \"Public orders, publicly made, in exercise of a statutory authority cannot be construed in the light of explanations subsequently given by the officer making the order of what he meant, or of what was in Ms mind, or what he intended to, do. Public orders made by public authorities are meant to have public effect and are intended to effect the actings and conduct of those to whom they are addressed and must be construed objectively with reference to the language used in the order itself.\" Orders are not like old wine becoming better as they grow older:</div><div>A Caveat.</div><div>We must, in limine, state that-anticipating our decision on the blanket ban on litigative interference during the process of the election, clamped down by Article 329(b) of the Constitution-we do not propose to enquire into or pronounce upon the factual complex or the (1) A.I.T. 1952 S.C. 16.</div><div>284 lesser legal tangles, but only narrate the necessary circumstances of the case to get a hang of the major issues which we intend adjudicating. Moreover, the scope of any actual investigation in the event of controversion in any petition under Article 226 is ordinarily limited and we have before us an appeal from the High Court dismissing a petition under Article 226 on the score that such a proceeding is constitutionally out of bounds for any court, having regard to the mandatory embargo. in Article329(b).</div><div>We should not,except in exceptional circumstances, breach the recognised, though not inflexible, boundaries of Article 226 sitting in appeal, even assuming the maintainability of such a petition. Indeed, we should have expected the High Court to have considered the basic jurisdictional issue first, and not last as it did, and avoided sallying forth into a discussion and decision on the merits, self-contra- dicting its own holding that it had no jurisdiction even to entertain the petition. The learned Judges observed :</div><div>\"It is true that the submission at serial No.</div><div>3 above in fact relates to the preliminary objection urged on behalf of respondents 1 and 3 and should normally have been dealt with & St but since the contentions of the parties on submission No. 1 are inter-mixed with the interpretation of Article 329(b) of the Constitution, we thought it proper to deal with them in the order in which they have been made.\" This is hardly a convincing alibi for the extensive per incuriam examination of facts and law gratuitously made by the Division Bench of the High Court, thereby generating apprehensions in the appellant\'s mind that not only is his petition not maintainable but he has been damned by damaging findings on the merits. We make it unmistakably plain that the election court hearing the dispute on the same subject under section 98 of the R.P. Act, 1951 (for short, the Act) shall not be moved by expressions of opinion on the merits made by the Delhi High Court while dismissing the writ petition. An obiter binds none, not even the author, and obliteration of findings rendered in supererogation must alley the appellant\'s apprehensions. This Court is in a better position than the High Court, being competent, under certain circumstances, to declare the law by virtue of its position under Article 141. But, absent such authority or duty, the High Court should have abstained from its generosity. Lest there should be any confusion about possible slants inferred from our synoptic statements, we clarify that nothing projected in this judgment is intended to be an expression of our opinion even indirectly. The facts have been set out only to serve as a peg to hang three primary constitutional issues which we will formulate a little later.</div><div>Operation Election Before we proceed further, we had better have a full glimpse of tie, constitutional scheme of elections in our system and the legislative follow-up regulating the process of election. Shri Justice Mathew in lndira Nehru Gandhi(1) summarised skeletal fashion, this scheme (1) [1976] 2 S.C.R. 347 285 following the pattern adopted by Fazal Ali, J. in Ponnuswami. [1952] INSC 2; 1952 SCR 218. He explained :</div><div>\"The concept of democracy as visualised by the Constitution presupposes the representation of the people in Parliament and state legislatures by the method of election. And, before an election machinery can be brought into operation, there are three requisites which require to be attended to, namely, (1) there should be a set of laws and rules making provisions with respect to all matters relating to, or in connection with, elections, and it should be decided as to how these laws and rules are to be made; (2). there should be an executive charged with the duty of securing the due conduct of elections; and (3) there should be a judicial tribunal to deal with disputes arising out of or in connection with elections. Articles 327 and 328 deal with the first of these requisites, article 324 with the second and article 329 with the third requisite (see N. P. Ponnuswami v. Returning Officer, Nanmakkal Constituency & Ors. [1952] INSC 2; 1952 SCR 218, 229). Article 329 (b) envisages the challenge to an election by a petition to be presented to such authority as the Parliament may, by law, prescribe. A law relating to election should contain the requisite qualifications for candidates, the method of voting, definition of corrupt practices by the candidates and their election agents, the forum for adjudication of election disputes and other cognate matters. It is on the basis of this law that the question determined by the authority to which the petition is presented. And, when a dispute is raised as regards the validity of the election of a particular candidate, the authority entrusted with the task of resolving the dispute must necessarily exercise, a judicial function, for, the process consists of ascertaining the facts relating to the election and applying the law to the facts so ascertained.\" A short description of the legislative project in some more detail may be pertinent, especially touching on the polling process in the booths and the transmission of ballot boxes from the polling stations to the returning officer\'s ultimate counting station and the crucial prescriptions regarding annuoncements and recounts and declarations. We do not pronounce upon the issues regarding the stage for and right of recount. the validity of votes or other factual or legal disputes since they fall for decision by the Election Court where the appellant has filed an election petition by way of abundant caution.</div><div>A free and fair election based on universal adult franchise is the basic; the regulatory procedures vis-a-vis the repositories of functions and the distribution of legislative, executive and judicative roles in the total scheme, directed towards the holding of free elections, are the specifics. Part XV of the Constitution plus the Representation of the People Act, 1950 (for short, the 1950 Act) and the Representation of the People Act, 1951 (for short, the Act), Rules framed there under, instructions issued and exercises prescribed, constitute the package of 286 electoral law governing the parliamentary and assembly elections in the country. The super-authority is the Election Commission, the kingpin is the returning officer, the minions are the presiding officers in the polling stations and the electoral engineering is in conformity with the elaborate legislative provisions.</div><div>The scheme is this. The President of India (Under Section 14) ignites the general elections across the nation by calling upon the People, divided into several constituencies and registered in the electoral rolls, to choose their representatives to the Lok Sabha. The constitutionally appointed authority, the Election Commission, takes over the whole conduct and supervision of the mammoth enterprise in- volving a plethora of details and variety of activities, and starts off with the notification of the time table for the, several stages of the election (Section 30). The assembly line operations then begin. An administrative machinery and technology to execute these enormous and diverse jobs is fabricated by the Act, creating officers, powers and duties, delegation of functions and location of polling stations.</div><div>The precise exercise following upon the calendar for the poll, commencing from presentation of nomination papers, polling drill and telling of votes,, culminating in the declaration and report of results are covered by specific prescriptions in the Act and the rules. The secrecy of the ballot, the authenticity of the voting paper and its later identifiability with reference to particular polling stations, have been thoughtfully provided for. Myriad other matters necessary for smooth elections have been taken care of by several provisions of the Act.</div><div>The wide canvas so spread need not engage us sensitively, since such diffusion may weaken concentration on the few essential points concerned in this case. One such aspect relates to repoll. Adjournment of the poll at any polling station in certain emergencies is sanctioned by section 57 and fresh poll in specified vitiating contingencies is authorised by section 58. The rules run into more particulars. After the votes are cast comes their counting.</div><div>Since the simple plurality of votes clinches the verdict, as the critical moment approaches, the situation is apt to hot up, disturbances erupt and destruction of ballots disrupt.</div><div>If disturbance or destruction demolishes the prospect of counting the total votes, the number secured by each candidate and the ascertainment of the will of the majority, a re-poll confined to disrupted polling stations is provided for. Section 64A chalks out the conditions for and course of such repoll, spells out the power, and repository thereof and provides for kindred matters. At this stage we may make a closer study of the provisions regarding repoll systematically and stagewise arranged in the Act. It is not the case of either side that a total repoll of an entire constituency is specificated in the sections or the rules.</div><div>Reliance is placed for this wider power upon Article 324 of the Constitution-by the Commission in its order, by the first respondent in his affidavit, by the learned Additional Solicitor General in his argument and by the third respondent through his counsel. We may therefore have to study the scheme of. article 324 and the provisions of the, Act together since they are integral to each other. Indeed, if we may mix metaphors for emphasis, the legislation made pursuant to Article 327 and that part of the Constitution specially devoted to elections must be 287 viewed as one whole picture, must be heard as an orchestrated piece and must be interpreted as one package of provisions regulating perhaps the most stressful and strategic aspect of democracy-in-action so dear to the nation and so essential for its survival.</div><div>The lis and the issues Two prefatory points need to be mentioned as some reference was made to them at the bar. Firstly, an election dispute is not like an ordinary lis between private parties. The entire electorate is vicariously, not inertly, before the court. (See [1958] INSC 45; 1959 SCR 611, 616, 622). We may, perhaps, call this species of cases collective litigation where judicial activism assures justice to the constituency, guardians the purity of the system and decides the rights of the candidates. In this class of cases, where the common law tradition is partly departed from, the danger that the active judge may become, to some extent, the prisoner of his own prejudices exists; and so, notwithstanding his powers of initiative, the parties\' role in the formulation of the issues and in the presentation of evidence and argument should be substantially maintained and- care has to be taken that the circle does not become a vicious one, as pointed out by J.A. Jolowicz in. \'Public Interest Parties and the Active Role of the Judge in Civil Litigation\' (ss. p. 276).</div><div>Therefore, it is essential that courts, adjudicating upon election controversies, must play a verily active role, conscious all the time that every decision rendered by the Judge transcends private rights and defends the constituency and the democracy of the country.</div><div>Secondly, the pregnant problem of power and its responsible exercise is one of the perennial riddles of many a modern constitutional order. Similarly, the periodical process of free and fair elections. uninfluenced by the caprice, cowardices or partisanship of hierarchical authority holding it and unintimidated by the threat, tantrum or vandalism of strong-arm tactics, exacts the embarrassing price of vigilant monitoring. Democracy digs its grave where passions, tensions and violence, on an overpowering spree, upset results of peaceful polls, and the law of elections is guilty of sharp practice if it hastens to legitimate the fruits of lawlessness. The judicial branch has a sensitive responsibility her to call to order lawless behaviour.</div><div>Forensic non-action may boomerang, for the court and the law are functionally the bodyguards of the People against bumptious power, official or other.</div><div>We now enter the constitutional zone relating to the controversy in this case. Although both sides have formulated the plural problems with some divergence, we may compress them into three cardinal questions :</div><div>1.Is Art. 329(b) a blanket ban on all manner of questions which may have impact on the ultimate result of the election, arising between two temporal termini viz., the notifi- cation by the President calling for the election and the declaration of the result by the returning officer ? Is Art. 226 also covered by this embargo and. if so, is s. 100 broad enough to accommodate every kind of objection, constitutional, legal or factual, which may have the result of invalidation of an 288 election and the declaration of the petitioner as the returned candidate and direct the organisation of any steps necessary to give full relief ? 2.Can the Election Commission, clothed with the comprehensive functions under Article 324 of the Constitution, cancel the whole poll of a constituency after it has been held, but before the formal declaration of the result has been made, and direct a fresh poll without reference to the guidelines under ss. 58 and 64(a) of the Act, or other legal prescription or legislative backing. If such plenary power exists, is it exercisable on the basis of his inscrutable \'subjective satisfaction\' or only on a reviewable objective assessment reached on the basis of circumstances vitiating a free and fair election and warranting the stoppage of declaration of the result and directions of a fresh poll not merely of particular polling stations but of the total constituency ? 3.Assuming a constitutionally vested capacity tinder Art. 324 to direct re-poll, is it exercisable only in conformity with natural justice and geared to the sole goal of a free, popular verdict if frustrated on the first occasion ? Or, is the Election Commission immune to the observance of the doctrine of natural justice on account of any recognised exceptions to the application of the said principle and unaccountable for his action even before the Election Court ? The juridical aspect of these triple questions alone can attract judicial jurisdiction. However. even if we confine ourselves to legal problematics, eschewing the political overtones, the words of Justice Holmes will haunt the Court : \"We are quiet here, but it is the quiet of a storm centre.\" The judicature must, however. be illumined in its approach by a legal sociological guidelines and a princi- pled-pragmatic insight in resolving, with jural tool and techniques s ,ind techniques. \'the various crises of human affairs\' as they reach the forensic stage and seek dispute- resolution in terms of the rule of law. Justice Cordozo felicitously set the perspective \"The great generalities of the Constitution have at content and significance that vary from age to age.\" Chief Justice Hidayatullah perceptively articulated the insight \"One must, of course, take note of the synthesized authoritative content or the moral meaning of the underlying\' principle of the, prescriptions of law, but not ignored the historic revolution of the, law itself or how it was connected in its changing moods with social requirements of a particular age.</div><div>(Judicial Methods, B. N. Rau Memorial Lecture) The old articles of the supreme lex meet new challenges of life, the old legal pillars suffer new stresses. So we have to adopt the law and develop its latent capabilities if novel situations, as here, are encountered. That is why in the reasoning we have adopted and the 289 perspective we have projected, not literal nor lexical but liberal and visional is our interpretation of the Articles of the Constitution and the provisions of the Act. Lord Denning\'s words are instructive \"Law does not stand still. It moves continually. Once; this is recongnised, then the task of the Judge is put on a higher plane. He must consciously seek to mould the law so as to serve the needs of the time. He must not be a mere, mechanic, a mere working mason, laying brick on brick, without thought to the overall design. He must be an archi- tect-thinking of the structure as a whole building for society a system of law which is strong, durable and just. It is on his work that civilised society itself depends.\" The invulnerable barrier of Art.329 (b).</div><div>Right at the forefront stands in the way of the appellant\'s progress the broad-spectrum ban of Article 329(b) which, it is claimed for the respondents, is imperative and goal- oriented. Is this Great Wall of China, set up as a preliminary bar, so impregnable that it cannot be by passed even by Art. 226 ? That, in a sense, is the key question that governs the fate of this appeal. Shri P. P. Rao for the appellant contended that, however, wide Art. 329(b) may be, it does not debar proceedings challenging, not the steps promoting election but dismantling it, taken by the Commission without the backing of legality. He also urged that his client, who had been nearly successful in the poll and had been deprived of it by an illegal cancellation by the Commission, would be left in the cold without any remedy since the challenge to cancellation of the completed poll in the entire constituency was not covered by s. 1 00 of the Act. Many subsidiary pleas also were put forward but we will focus on the two inter-related submissions bearing on Art. 329(b) and s. 100 and search for a solution. The problem may seem prickly but an imaginative application of principles and liberal interpretation of the constitution and the Act will avoid anomalies and assure justice. if we may anticipate our view which will presently be explained, section 100 (1 ) (d) (iv) of the Act will take care of the, situation present here, being broad enough, as a residual provision, to accommodate, in expression \'non-compliance\', every excess, transgression, breach or omission. And the spen of the, ban under Art. 329(b) is measured by the sweep of s. 100 of the Act.</div><div>We have to proceed heuristically now. Article 329(b) reads Notwithstanding anything in this Constitution \"(b) no election to either House of Parliament or to the House or either House of the Legislature of a State shall be called in question except by an election petition presented to such authority and in such manner as may be Provided for by or under any law made by the appropriate Legislature.\" Let us break down the prohibitory provision into its components. The sole remedy for an aggrieved party, if he wants to challenge any election, is an election petition.</div><div>And this exclusion of all other remedies 290 includes constitutional remedies like Art. 226 because of the nonobstante clause. If what is impugned is an election the ban operates provided the proceeding \'calls it in question\' or puts it in issue: not otherwise. What is the high policy animating this inhibition\'? Is there any interpretative alternative which will obviate irreparable injury and permit legal contests in between? How does S.</div><div>100 (1) (d) (iv) of the Act integrate into the scheme? Let us read s. 100 here :</div><div>\"Subject to the provisions of sub-section (2) if the High Court is of opinion- x x x (d)that the result of the election, in so far as it concerns a returned candidate, has been materially affected- x x x (iv) by any non-compliance with the provisions of the Constitution or of the Act or of any rules or orders made under this Act the High Court shall declare the election of the returned candidate to be void.</div><div>The companion provision, viz., s. 98 also may be extracted at this,star, :</div><div>\"At the conclusion of the trial of an election petition the High Court shall make an order- (a) dismissing the election petition; or (b) declaring the election all or any of the returned candidates to be void; or (e) declaring the election of all or any of the returned candidates to be void and the petitioner or any other candidate to have been duly elected.\" Now arises the need to sketch the scheme of s. 1 00 in the setting of Art.329(b). The troublesome word \'non- compliance\' holds in its fold a teleologic signification which resolves the riddle of this case in, a way. So we will address, ourselves to the meaning of meanings the values within the words and the \'project unfolded\'. This will be taken up one after the other.</div><div>At the first blush we get the comprehensive impression that every calling in question of an election save, at the end, by an election petition, is forbidden. What, then, is an election ? What is \'calling in question ? Every step from start to finish of the total process constitutes \'election\', not merely the conclusion or culmination. Can the cancella- tion of the entire poll be called a step in the process and for the progress of an election, or is it a reverse step of undoing what has been done in the progress of the election, non-step or anti-step setting at nought the process and, therefore, not a step towards the goal and hence liberated from the coils of Art. 329(b) ? And, if this act or step were to be shielded by the constitutional provision, what is an aggrieved party to do 9 This takes us to the enquiry about the ambit of S. 100 of the Act and the object of Art.</div><div>329 (b) read with Art. 324. Such is the outline of the complex issue projected before us.</div><div>291 \'The election philosophy and the principle in Ponnuswami Democracy is government by the people. It is a continual participative operation, not a cataclysmic, periodic exercise. The little man, in his multitude, marking his vote at the poll does a social audit of his Parliament plus political choice of his proxy. Although the full flower of participative Government rarely blossoms, the minimum credential of popular government is appeal to the people after every term for a renewal of confidence. So. we have adult franchise and general elections as constitutional compulsions. \'The right of election is the very essence of the constitution\' (Junius). It needs little argument to hold that the heart of the Parliamentary system is free, and fair elections periodically held, based on adult franchise, although social and economic democracy may demand much more.</div><div>Ponnuswami is a landmark case in election laws and deals with the scope, amplitude, rationale and limitations of Art.</div><div>329(b). its ratio has been consistently followed by this Court in several rulings through Durga Shankar Mehta (1) and Hari Vishnu Kamath and Khare (2) down to Indira Gandhi(3).</div><div>The factual setting in that case may throw some light on the decision itself. The appellant\'s nomination for election to the Madras Legislative Assembly was rejected by the Returning Officer and so he hurried to the High Court praying for a writ of certiorari to quash the order of rejection, without waiting for the entire elective process to run its full course and, at the end of it, when the results also were declared, to move the election tribunal for setting aside the result of the election conducted without his participation. He thought that if the election proceeded without him irreparable damage, would have been caused and therefore sought to intercept the progress of the election by filing a writ petition. The High Court dismissed it as unsustainable, thanks to Art. 329(b) and this court in appeal, affirmed that holding. Fazal Ali, J.</div><div>virtually spoke for the Court and explained the principle underlying Art. 329(b). The ambit and spirit of the bar imposed by the Article was elucidated with reference to the principle that \'it does not require much argument to show that in a country with a democratic constitution in which the legislatures have to play a very important role, it will lead to serious consequences if the elections are unduly protracted or obstructed.\' In the view of the, learned Judge, immediate individual relief at an intermediate stage when the process of election is under way has to be sacrificed for the paramount public good of promoting the completion of elections. Fazal Ali, J. ratiocinated on the ineptness of. interlocutory legal bold-ups. He posed the issue and answered it thus :</div><div>\"The question now arises whether the law of elections in this country contemplates that there should be two attacks on matters connected with election proceedings, one while they are going on by invoking the extraordinary jurisdiction of the High Court under article 226 of-the Constitution (the ordinary (1) [1955] 1 S. C. R. 267 (2) [1954] INSC 122; [1955] 1 S.C.R. 1104.</div><div>(3) [1976] 2 S.C.R. 347.</div><div>6-1114SCI/77 292 jurisdiction of the courts having been expressly excluded), and another after they have been completed by means of an election petition. In my opinion, to affirm such a position would be contrary to the scheme of Part XV of the Constitution and the Representation of the People Act, which, as I shall point out later, seems to. be that any matter which has the effect of vitiating an election should be brought up only at the appropriate stage in an appropriate manner before a special tribunal and should not be brought up at an \'intermediate stage before any court. It seems to me that under the election law, the only significance which the rejection of a nomination paper has consists in the fact that it can be used as a ground to Call the election in question. Article 329(b) was apparently enacted to describe the manner in which end the stage at which this ground, and other grounds which may be raised under the law to call the election in question, could be urged. I think it follows by necessary implication from the language of this provision that those grounds cannot be urged in any other manner, at any other stage and before any other court. If the grounds on which an election can be called in question could be raised at an earlier stage and errors, if any are rectified, there will be no meaning in enacting a provision like Article 329(b) and in setting up a special tribunal.</div><div>Any other meaning ascribed to the words used in the article would lead to anomalies, which the Constitution could not have contemplated, one of them being that conflicting views may be expressed by the High Court at the pre- polling stage and by the election tribunal, which is to be an, independent body, at the stage when the matter is brought before it.</div><div>Having thus explained the raison d\'etre of the provision, the Court proceeded to interpret the concept of election in the scheme of Part XV of the Constitution and the Representation of the People Act, 1951. Articles 327 and 328 take care of the act of laws and rules making provisions with respect to all matters relating to or in connection with, elections.\' Election disputes were also to be provided for by laws made under Article 327. The Court emphasised that Part XV of the Constitution was really a code in itself, providing the entire ground work for enacting the appropriate laws and setting up suitable machinery for the conduct of elections. The scheme of the Act enacted- by Parliament was also set out by Fazal Ali, J.\' \"Part VI deals with disputes regarding elections and provides for the manner of presentation of election petitions, the constitution of election tribunals and the trial of election petitions part VII outlines the various corrupt and illegal practises which may affect the elections, and electoral offences. Obviously, the Act is self- contained enactment so far as elections are concerned, which means that whenever we have to ascertain the true position in regard to any matter connected made thereunder. The provisions of the Act which are material to the present discussion are sections 60, 100, 105 and with elections, we have only to look at the Act and the rules 293 170, and the provisions of Chapter 11 of Part IV dealing with the form of election petitions , their contents and the reliefs which may be sought in them. Section 80, which is drafted in almost the same language as article 329(b) provides that ,no election shall be called in question except by an election petition presented in accordance with the provisions of this Part\'. Section 1 00, as we have already seen, provides for the grounds on which an election may be called in question, one of which is the improper rejection of a nomination paper, Section 105 says that \'every order of the Tribunal made under this Act shall be final and conclusive. Section 170 provides that \'no civil court shall have jurisdiction to question the legality of any action taken or of any decision given by the Returning Officer or by any other person appointed under this Act in connection with an election. \" There have been amendments to these provisions but the profile remains substantially the same. After pointing out that the Act,- in section 80, and the Constitution, in article 329(b), speak substantially the same language and inhibit other remedies for election grievances except through the election tribunal, the Court observed \"That being so, I think it will be a fair inference from the provisions of the Representation of the People Act to state that the Act provides for only one remedy, that remedy being by an election petition to be presented after the election is over, and there is no remedy provided at any intermediate stage.\" There is a non-obstante clause in Article 329 and, therefore, Article 22.6 stands pushed out where the dispute takes the form of calling in question an election, except in special situations pointed out but left unexplored in Ponnuswami.</div><div>The heart of the matter is contained in the conclusions summarised by the Court thus :</div><div>\"(1) Having regard to the important functions which the legislatures have to perform in democratic countries, it has always been recognised to be a matter of first importance that elections should be concluded as early as possible according to time schedule and all controversial matters and all disputes arising out of elections should be postponed till after the elections are over, so that the election proceedings may not be unduly retarded or protracted.</div><div>(2)In conformity with this principle, the scheme of the election law in this country as well as in England is that no significance should be attached to anything which does not affect the \"election\"; and if any irregularities are committed while it is in progress and they belong to the category or class which, under the law by which elections are governed, would have the effect of vitiating the \"election\" and enable the person effected to call it in question, they should be brought so before a special tribunal by means of an election petition 294 and not be made the subject of a dispute before any court while the election is in progress.\" After elaborately setting out the history in England and in India election legislation vis- a-vis dispute-resolution, Fazal Ali J. stated \"If the language used in article 329(b) is considered against this historical background, it should not be difficult to see why the framers of the Constitution framed that provi- sion in its present form and chose the language which had been consistently used in certain earlier legislative provisions and which bad stood the test of time.\" Likewise the Court discussed the, connotation , of the expression election\' in Article 329 and observed :</div><div>\"That word has by long usage in connection with the process of selection of proper representatives in democratic institutions, acquired both a wide and a narrow meaning. In the narrow sense, it is used to mean the final selection of a candidate which may embrace the result of the poll when there is polling or a particular candidate being returned unopposed when there is no poll. In the wide, sense, the word is used to connote the entire process culminating in a candidate being declared elected. it seems to me that the word \"election \" has been used in Part XV of the Constitution in the wide sense, that to say to connote the entire procedure, to be gone through to return a candidate to the legislature. That the word \"election\" bears this wide meaning wheneverwe talk of elections in a democratic country, is borne out bythe fact that in most of the books on the subject and in several cases dealing with the matter, one of the questions mooted is, when the election begins The rainbow of operations, covered by the compendious expression election, thus commences from the initial notification and culminates in the declaration of the return of a candidate,. The paramount policy of the Constitution-framers in declaring that no election shall be called in question except the way it is provided for in Article 329 (b) and the Representation of the People Act, 1951, compels us to read, as Fazal Ali, J. did in Pannuswami, the Constitution and the Act together as an integral scheme. The reason for postponement of election litigation to. the post-election stage is that elections poll not unduly be protracted or obstructed. The speed and promptitude in getting due representation for the electors in the- legislative bodies is the real reason suggested in the course of judgment.</div><div>Thus for everything is clear. No litigative enterprise in the High Court or other court should be allowed to hold up the on-going electoral process because the parliamentary representative for the constituence should be chosen promptly. Article 329 therefore covers \"electoral matters\".</div><div>One interesting argument, urged without success in Ponnuswami elicited a reasoning from the Court which has some bearing on the question in the present appeal. That argument was that if nomina- 295 tion was part of election a dispute as to the validity of the nomination was a dispute relating to election and could be called in question, only after the whole election was over, before the election tribunal. This meant that the Returning Officer could have no jurisdiction to decide the validity of a nomination, although section 36 of the Act conferred on him that jurisdiction. The learned Judge dismissed this argument as without merit, despite the great dailectical ingenuity in the submission. In this connection the learned Judge observed \"Under section 36 of the Representation of the People Act, 1951, it is the duty of the Returning Officer to scrutinize the nomination papers to ensure that they comply with the requirements of, the Act and decide all objections which be made to any nomination.</div><div>It is clear that unless this duty is discharged properly, any number of candidates may stand for election without complying with the provisions of the Act and a great deal of confusion may ensue. In discharging the statutory duty imposed on him, the Returning Officer does not call in question any election. Scrutiny of nomination papers is only a stage, though an important stage, in the election process. It is one of the essential duties to be performed before the election can be completed, and anything done towards the completion of the election proceeding can by no stretch of reasoning be described as questioning the election. The fallacy of the argument lies in treating a single step taken in furtherance of an election as equivalent to election. The decision of this appeal however turns not on the construction of the single word \"election\", but on the construction of the compendious expression-no election shall be called in question\" in this context and setting with due regard to the scheme of Part XV of the Constitution and the Representation of the People Act, 1951. Evidently, the argument has no, bearing on this method of approach to the question posed in this appeal, which appears to me the only correct method.\" What emerges from this perspicacious reasoning, if we may say so with great respect, is that any decision sought and rendered will not amount to \'calling in question\' an election if it subserves the progress of the election and facilitates the completion of the election. \'Ale should not slur over the quite essential observation \"-Anything done towards the completion of the election proceeding can by no stretch of reasoning be described as questioning the election. Likewise, it is fallacious to treat \'a single step taken in furtherance of an election as equivalent to election\'.</div><div>Thus, there are two types of decisions, two types of challenges. The first relates to proceedings which interfere with the progress of the election. The second accelerates the completion of the election and acts in furtherance of an election. So, the short question before us, in the light of the illumination derived from Ponnuswami, is as to whether the order for re-poll of the Chief Election Commissioner is \"anything done towards the completion of the election proceeding\' and whether the proceedings before the High Court facilitated the election process or halted its progress. The question immediately arises as to whether 296 the relief sought in, the writ petition by the present appellant amounted to calling in question the election.</div><div>This, in turn, revolves round the point as to whether the cancellation of the poll and the reordering of fresh poll is \'part of election\' and challenging it is \'calling it in question.</div><div>The plenary bar of Art. 329 (b) rests on two principles :</div><div>(1) The peremptory urgency of prompt engineering of the whole election process without intermediate interruptions by way of legal proceedings challenging the steps and stages in between the commencement and the conclusion. (2) The provision of a special jurisdiction which can be invoked by an aggrieved party at the end of the election excludes other form, the right and remedy being creatures of statutes and controlled by the Constitution. Durga Shankar Mehta(1) has affirmed this position and supplemented it by holding that, once the Election Tribunal has decided, the prohibition is extinguished and the Supreme Court\'s over-all power to interfere under Art. 136 springs into, action. In Hari Vishnu(2) this Court upheld the rule in Ponnuswami excluding any proceeding, including one under Art. 226, during the on- going process of election, understood in the comprehensive sense of notification down to declaration. Beyond the declaration comes the election petition, but beyond the decision of the Tribunal the ban of Art. 329(b) does not bind.</div><div>If \'election\' bears the larger connotation, if \'callinng in question\' possesses a semantic sweep in plain English, if policy and principle are tools for interpretation of statutes, language permitting the conclusion is irresistible\' even though the argument contra may have emotional impact and ingenious appeal, that the catch-all jurisdiction under Art. 226 cannot consider the correctness, legality or otherwise of the direction for cancellation integrated with re-poll. For, the prima facie purpose of such a re-poll was to restore a detailed Poll process and to, complete it through the salvationary effort of a repoll.</div><div>Whether in fact or law, the order is validly made within his powers or violative of natural justice can be examined later by the appointed instrumentality, viz., the Election Tribunal. That aspect will be explained presently. We proceed on the footing that re-poll in one polling station or it many polling stations for good reasons, is lawful.</div><div>This shows that re-poll in many or all segments, all- pervasive or isolated, can be lawful. We are not considering whether the act was bad for other reasons. We are concerned only to say that if the regular poll, for some reasons, has failed to reach the goal of choosing by plurality the returned candidate and to achieve this object a fresh poll (not a new election) is needed, it may still be a step in the election.- The deliverance of Dunkirk is part of the strategy of counter-attack. Wise or valid, is another matter.</div><div><br></div><div><div>On the assumption, but leaving the question of the validity of the direction for re-poll soon for determination by the Election Tribunal, we hold that a writ petition challenging the cancellation coupled with re-poll amounts to calling in question a step in \'election! and is there, fore barred by Art. 329(b). If no re-poll had been directed the legal perspective would have been very different. The mere cancel- (1) [1955] 1 S.C.R. 267.</div><div><br></div><div>(2) [1954] INSC 122; [1955] 1 S.C.R. 1104.</div><div><br></div><div>297 lation would have then thwarted the course of the election and different considerations would have come into play. We need not chase a hypothetical case.</div><div><br></div><div>Our conclusion is not a matter of textual interpretation only but a substantial assurance of justice by reading s.</div><div><br></div><div>100 of the Act as covering the whole basket of grievances of the candidates. Sri P. P. Rao contended that the Court should not deny relief to a party in the area of elections which are the life-breath of democracy and people\'s power.</div><div><br></div><div>We agree.</div><div><br></div><div>This dilemma does not arise in the wider view we take of s.</div><div><br></div><div>100 (1) (d) (iv) of the Act. Sri Rao\'s attack on the order impugned is in substance based on alleged non-compliance with a provision of the Constitution viz., Art. 324 but is neatly covered by the widely-worded, residual catch-all clause of s. 100. knowing the supreme significance of speedy elections in our system the framers of the Constitution have, by implication, postponed all election disputes to election petitions and tribunals. In harmony with this scheme s. 100 of the Act has been designedly drafted to embrace all conceivable infirmities which may be urged. To make the project fool-proof s. 100(1) (d) (iv) has been added to absolve everything left over. The Court has in earlier rulings pointed out that s. 100 is exhaustive of all grievances regarding an election. But what is banned is not anything whatsoever done or directed by the Commissioner but everything he does or directs in furtherance of the election, not contrariwise. For example, after the President notifies the nation on the holding of elections under s. 15 and the Commissioner publishes the calendar for the poll under s. 30, if the latter orders returning officers to accept only one nomination or only those which come from one party as distinguished from other parties or independents, is that order immune from immediate attack.</div><div><br></div><div>We think not. Because the Commissioner is preventing an election, not promoting it and the courts review of that order will facilitate the flow, not stop the stream.</div><div><br></div><div>Election, Wide or narrow be its connotation, means choice from a possible plurality monolithic politics not being our genius or reality, and if that concept is crippled by the Commissioner\'s act, he holds no election at all.</div><div><br></div><div>A poll is part-a vital part-of the election but with the end of the poll the whole election IS not over. Ballots have to be assembled, scrutinised, counted recount claims considered and result declared. The declaration determines the election. The conduct of the election thus ripens into the elector\'s choice only when processed, screened and sanctified, every escalatory step upto the formalised finish being unified in purpose, forward in movement, fair and free in its temper. Article 329(b) halts judicial intervention during this period, provided the act possesses the pre- requisites of \'election\' in its semantic sweep. That is to say, immunity is conferred only if the act impeached is done for the apparent object of furthering a free and fair election and the protective armour drops down if the act challenged is either unrelated to. or thwarts or taints the course of the election.</div><div><br></div><div>Having held against the maintainability of the writ petition, we should have parted with the case finally. But counsel for both the 298 candidates and, more particularly, the learned Additional Solicitor General, appearing for the Election Commission, submitted that the breadth, applitude and implications, the direction and depth of Article 324 and, equally important, the question of natural justice raised under Article 324 are of such public importance and largely fallow field going by prior pronouncements, and so strategic for our democracy and itspower process that this Court must decide the issue here and now. Article 141 empowers and obligates this Court to declare the law forthe country when the occasion asks for it. Counsel, otherwise opposing one another, insistently concurred in their request that for the working of the electoral machinery and understanding of the powers and duties vested in the functionaries constituting the infra- structure, it is essential to sketch the ambit and import of Art. 324. This point undoubtedly arises before us even in considering the prohibition under Art. 329 and has been argued fully. In any view, the Election Triburial will be faced with this issue and the law must be laid down so that there may be no future error while disposing of the, election petition or when the Commission is called upon to act on later occasion. This is the particular reason for our proceeding to decide what the content and parameters of Art. 324 are, contextually limited to situations analogous to the present.</div><div><br></div><div>We decide two questions under the relevant article, not argued, but as substantive pronouncements on the subject.</div><div><br></div><div>They are :</div><div><br></div><div>(a) What in its comprehensive connotation does the conduct\' of elections mean or, for that matter, the superintendence, direction and control\' of elections ? (b) Since the text of the provision is silent about hearing before acting, is it permissible to import into Art. 324(1) an obligation to act in accord with natural justice ? Article 324, which we have set out earlier, is a plenary provision vesting the whole responsibility for national and State elections and, therefore, the necessary powers to discharge that function. It is true that Art. 324 has to be read in the light of the constitutional scheme and the 1950 Act and the 1951 Act. Sri Rao is right to the ex-tent be insists that if competent legislative is enacted as visualized in Article 327 the Commission cannot shake himself free from the enacted prescriptions. After all, as Mathew, J. has observed in Indira Gandhi : (supra) \"In the opinion of some of the judges constituting the majority in Bharati\'s case (supra), Rule of Law is a basic structure of the Constitution apart from democracy.</div><div><br></div><div>The rule of law postulates the pervasiveness of the spirit of law throughout the whole range of government in the sense of excluding arbitrary official action in any sphere.\" (p. 523) 299 And the supremacy of valid law over the Commission argues itself. No one is an imperium in imperio in our constitutional order. It is reasonable to hold that the Commissioner cannot defy the law armed by Art. 324.</div><div><br></div><div>Likewise, his functions are subject to the norms of fairness and he cannot act arbitrarily. Unchecked power is alien to our system.</div><div><br></div><div>Even so, situations may arise which enacted law has not provided for. Legislators are not prophets but pragmatists.</div><div><br></div><div>So it is that the Constitution has made comprehensive provision in Art. 324 to take care of surprise situations.</div><div><br></div><div>That power itself has to be exercised, not mindlessly nor mala fide, nor arbitrarily nor with partiality but in keeping with the guidelines of the rule of law and not stultifying the Presidential notification nor existing legislation. More is not necessary to specify; less is insufficient to leave unsaid. Article 324, in our view, operates in areas left unoccupied by legislation and the words \'superintendence, direction and control\' as well as \'conduct of all elections\' are the broadest terms. Myriad maybes, too mystic to be precisely presaged, may call for prompt action to reach the goal of free and fair election.</div><div><br></div><div>It has been argued that this will create a constitutional despot beyond the pale of accountability; a Frank', '3dfa4f36c84f0fbe039056fc5700d1fa.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-05', 1, '', '', '2020-12-06 00:57:34', '2020-12-20 21:48:52');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(123, 'iSbx5gDK8SvdiDZQGeRZCpavx', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Kihoto Hollohan vs Zachillhu and others', '<h2 style=\"text-align: center;\"><b>Kihoto Hollohan vs Zachillhu and othrs.</b></h2><h4 style=\"text-align: center;\">(8 February 1992)</h4><h4> </h4><h4 style=\"text-align: center;\">1992 (1) SCR 686; 1992 (2) Suppl.SCC 651&nbsp;</h4><h4 style=\"text-align: center;\">Justice L.M. Sharma, Justice<span style=\"font-size: 1.3125rem;\">&nbsp;</span>M.N. Venkatachalaiah, Justice<span style=\"font-size: 1.3125rem;\">&nbsp;</span>J.S. Verma, Justice<span style=\"font-size: 1.3125rem;\">&nbsp;</span>K. Jayachandra Reddy and Justice<span style=\"font-size: 1.3125rem;\">&nbsp;</span>S.C. Agarwal&nbsp;</h4><h4 style=\"text-align: center;\"><font face=\"Rockwell, Corbel, Museo 500, Helvetica, Arial\">The Judgment of the Court was delivered by 711 (OPERATIVE CONCLUSIONS IN THE MAJORITY OPINION) [Per VENKATACHALIAH, K, JAYACHANDRA REDDY AND AGRAWAL, JJ.].</font></h4><h4 style=\"text-align: center;\"><font face=\"Rockwell, Corbel, Museo 500, Helvetica, Arial\"><br></font></h4><h4 style=\"text-align: justify; \">1. The Writ Petitions, Transfer Petitions, Civil Appeals, Special Leave Petitions and other connected matters raising common questions as to the constitutional validity of the constitution (52nd Amendment) Act, 1985, in so far as it seeks to introduce the Tenth Schedule in the Constitution of India, were heard together. Some of these matters involve investigation and determination of factual controversies and of the extent of applicability to them of the conclusions reached on the various constitutional issues. That exercise shall have to be undertaken in the individual cases separately.</h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The present judgment is pronounced in the Transfer Petition No. 40 of 1991 seeking the transfer of the Writ Petition, Rule No. 2421/90 on the file of the High Court of Guwahati to this Court.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">2. The Transfer Petition is allowed and the aforesaid Writ Petition is withdrawn to this Court for the purpose of deciding the constitutional issues and of declaring the law on the matter.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">3. For the reasons to be set out in the detailed judgment to follow, the following are the operative conclusions in the majority opinion on the various constitutional issues:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(A) That having regard to the background and evolution of the principles underlying the Constitution (52nd Amendment) Act, 1985, in so far as it seeks to introduce the Tenth Schedule in the Constitution of India, the provisions of Paragraph 7 of the Tenth Schedule of the Constitution in terms and in effect bring about a change in the operation and effect of Articles 136, 226 and 227 of the Constitution of India and, therefore, the amendment would require to be ratified in accordance with the proviso to sub-Article (2) of Article 368 of the Constitution of India.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(B) That there is nothing in the said proviso to Article 368 (2) which detracts from the severability of a provision on account of the inclusion of which the Bill containing the Amendment requires ratification from the rest of the provisions of such Bill 712 Which do not attract and require such ratification. Having regard to the mandatory language of Article 368 (2) that \"thereupon the constitution shall stand amended\" the operation of the proviso should not be extended to constitutional amendments in a Bill which can stand by themselves without such ratification.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(C) That accordingly, the Constitution (52nd Amendment) Act, 1985, in so far as it seeks to introduce the Tenth Schedule in the constitution of India, to the extent of its provisions which are amenable to the legal-sovereign of the amending process of the union Parliament cannot be overborne by the proviso which cannot operate in that area.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">There is no justification for the view that even the rest of the provisions of the constitution (52nd Amendment) Act, 1985, excluding Paragraph 7 of the Tenth Schedule become constitutionally infirm by reason alone of the fact that one of its severable provisions which attracted and required ratification under the proviso to Article 368 (2) was not so ratified.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(D) That Paragraph 7 of the Tenth Schedule contains a provision which is independent of, and stands apart from, the main provisions of the Tenth Schedule which are intended to provide a remedy for the evil of unprincipled and unethical political defections and, therefore, is a severable part.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The remaining provisions of the Tenth Schedule can and do stand independently of Paragraph 7 and are complete in themselves workable and are not truncated by the excision of Paragraph 7.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(E) That the Paragraph 2 of the Tenth Schedule to the Constitution is valid. Its provisions do not suffer from the vice of subverting democratic rights of elected Members of Parliament and the Legislatures of the States. It does not violate their freedom of speech, freedom of vote and conscience as contended.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The provisions of Paragraph 2 do not violet any rights or freedom under Article 105 and 194 of the Constitution.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The provisions are salutory and are intended to strengthen the 713 fabric of Indian parliamentary democracy by curbing unprincipled and unethical political defections.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(F) The contention that the provisions of the Tenth Schedule, even with the exclusion of Paragraph 7, violate the basic structure of the Constitution in that they affect the democratic rights of elected members and, therefore, of the principles of Parliamentary democracy is unsound and is rejected.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(G) The Speakers, Chairmen while exercising powers and discharging functions under the Tenth Schedule act as Tribunal adjucating rights and obligations under the Tenth Schedule and their decisions in that capacity are amenable to judicial review.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">However, having regard to the Constitutional Scheme in the Tenth Schedule, judicial review should not cover any stage prior to the making of a decision by the speakers/Chairmen. Having regard to the Constitutional intendment and the status of the repository of the adjudicatory power, no quia timet actions are permissible, the only exception for any interlocutory interference being cases of interlocutory disqualifications or suspensions which may have grave, immediate and irreversible repercussions and consequence.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(H) That Paragraph 6(1) of the Tenth Schedule, to the extent it seeks to impart finality to the decision of the Speakers/Chairmen is valid. But the concept of statutory finality embodied in Paragraph 6 (1) does not detract from or abrogate judicial review under Articles 136,226 and 227 of the Constitution in so far as infirmities based on violations of constitutional mandates, mala fides, non-compliance with Rules of Natural Justice and perversity, are concerned.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(I) That the deeming provision in Paragraph 6 (2) of the Tenth Schedule attracts an immunity analogous to that in Articles 122 (1) and 212 (1) of the Constitution as understood and explained in Keshav singh\'s Case (Spl. Ref., No. 1[1964] INSC 209; , [1965] 1 SCR 413) to protect the validity of proceedings from mere irregularities of procedure. The deeming provision, having regard to the words \"be deemed to be proceedings in Parliament\" or \"proceedings 714 in the Legislature of a State\" confines the scope of the fiction accordingly.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(J) That contention that the investiture of adjudicatory functions in the Speakers/Chairmen would by itself vitiate the provision on the ground of likelihood of political bias is unsound and is rejected. The Speakers/Chairmen hold a pivotal position in the scheme of Parliamentary democracy and are guardians of the rights and privileges of the House. They are expected to and do take far reaching decisions in the functioning of Parliamentary democracy. Vestiture of power to adjudicate questions under the Tenth Schedule in such a constitutional functionaries should not be considered exceptionable.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(K) In the view we take of the validity of Paragraph 7 it is unnecessary to pronounce on the contention that judicial review is a basic structure of the Constitution and Paragraph 7 of the Tenth Schedule violates such basic structure .</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The factual controversies raised in the Writ Petition will, however, have to be decided by the High Court applying the principles declared and laid down by this judgment. The Writ Petition is, accordingly,, remitted to the High Court for such disposal in accordance with law.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(Operative conclusions in the minority opinion) [Per SHARMA AND VERMA, JJ.] For the reasons to be given in our detailed judgment to follow, our operative conclusions in the minority opinion on the various constitutional issues are as follows:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">1. Para 7 of the Tenth Schedule,in clear terms and in effect excludes the jurisdiction of all courts, including the Supreme Court under Article 136 and the High Courts under Articles 226 and 227 to entertain any challenge to the decision under para 6 on any ground even of illegality or perveristy, not only at an interim stage but also after the final decision on the question of disqualification on the ground of defection.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">2. Para 7 of the Tenth Schedule, therefore, in terms and in effect, 715 makes a change in Article 136 in Chapter IV of Part V; and Articles 226 and 227 in Chapter V of Part VI of the Constitution, attracting the proviso to clause (2) of Article 368.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">3. In view of para 7 in the Bill resulting in the Constitution (Fifty-Second Amendment) Act, 1985 it was required to be ratified by the Legislature of not less than one-half of the States as a condition precedent before the Bill could be presented to the President for assent, in accordance with the mandatory special procedure prescribed in the Proviso to clause (2) of Article 368 for exercise of the constituent power. Without ratification by the specified number of State Legislatures, the stage for presenting the Bill for assent of the President did not reach and, therefore, the so-called assent of the President was non est and did not result in the Constitution standing amended in accordance with the terms of the Bill.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">4. In the absence of ratification by the specified number of State Legislatures before presentation of the Bill to the President for his assent, as required by the Proviso to clause (2) of Article 368, it is not merely para 7 but, the entire Constitution (Fifty-Second Amendment) Act, 1985 which is rendered unconstitutional, since the constituent power was not exercised as prescribed in Article 368, and therefore, the Constitution did not stand amended in accordance with the terms of the Bill providing for the amendment.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">5. Doctrine of Severability cannot be applied to a Bill making a constitutional amendment where any part thereof attracts the Proviso to clause (2) of Article 368.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">6. Doctrine of Severability is not applicable to permit striking down para 7 alone saving the remaining provisions of the Bill making the Constitutional Amendment on the ground that para 7 alone attracts the proviso to clause (2) of Article 368.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">7. Even otherwise, having regard to the provisions of the Tenth Schedule of the Constitution inserted by the Constitution (Fifty_Second Amendment) Act, 1985, the Doctrine of Severability does not apply to it.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">8.Democracy is a part of the basic structure of the Constitution and free and fair elections with provision for resolution of disputes relating to 716 the same as also for adjudication of those relating to subsequent disqualification by an independent body outside the House are essential features of the democratic system in our Constitution. Accordingly, an independent adjudicatory machinery for resolving disputes relating to the competence of Member of the House is envisaged as an attribute of this basic feature. The tenure of the Speaker who is the authority in the Tenth Schedule to decide this dispute is dependent on the continuous support of the majority in the House and, therefore,, he (the Speaker) does not satisfy the requirement of such an independent adjudicatory authority; and his choice as the sole arbiter in the matter violates an essential attribute of the basic feature.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">9. Consequently, the entire constitution (Fifty-Second Amendment) Act, 1985 which inserted the Tenth Schedule together with clause (2) in Articles 102 and 191, must be declared unconstitutional or an abortive attempt to so amend the constitution.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">10. It follows that all decisions rendered by the several Speakers under the Tenth Schedule must also be declared nullity and liable to be ignored.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">11. On the above conclusions, it does not appear necessary or appropriate to decide the remaining question urged.</span><br></h4><h4 style=\"text-align: justify; \"><font face=\"Rockwell, Corbel, Museo 500, Helvetica, Arial\"><br></font></h4><h4 style=\"text-align: justify; \"><font face=\"Rockwell, Corbel, Museo 500, Helvetica, Arial\">ORDER The Transfer Petition is allowed and the Writ Petition, Rule No. 2421 of 1990 on the file of the High Court of Guwahati is withdrawn to this Court for the purpose of deciding the constitutional issues and of declaring the law on the matter.</font></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">In accordance with the majority opinion, the factual controversies raised in the Writ Petition will, however, have to be decided by the High Court Applying the principles declared and laid down by the majority. The Writ Petition is, accordingly remitted to the High Court for such disposal in accordance with law.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">VENKATACHALIAH, J. In these petitions the constitutional validity of the Tenth Schedule of the Constitution introduced by the Constitution (Fifty-Second Amendment) Act. 1985, is assailed. These two cases were 717 amongst a batch of Writ Petitions, Transfer Petitions, civil Appeals, Special Leave Petitions and other similar and connected matters raising common questions which were all heard together. On 12.11.1991 we made an order pronouncing our findings and conclusions upholding the constitutional validity of the amendment and of the provisions of the Tenth Schedule, except for Paragraph 7 which was declared invalid for want of ratification in terms of and as required by the proviso to Article 368 (2) of the Constitution. In the order dated 12.11.1991 our conclusions were set out and we indicated that the reasons for the conclusions would follow later. The reasons for the conclusions are now set out.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">2. This order is made in Transfer Petition No. 40 of 1991 and in Writ Petition No. 17 of 1991. We have not gone into the factual controversies raised in the Writ-Petition before the Writ-Petition before the Guwahati High Court in Rule No.2421 of 1990 from which Transfer Petition No. 40 of 1991 arises. Indeed, in the order of 12th November, 1991 itself the said Writ Petition was remitted to the High Court for its disposal in accordance with law.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">3. Shri F.S. Nariman, Shri Shanti Bhushan, Shri M.C.&nbsp;</span>Bhandare, Shri Kapil Sibal, Shri Sharma and shri Bhim Singh, learned counsel addressed arguments in support of the petitions. Learned Attorney-General, Shri Soli J. Sorabjee,Shri R.K. Garg,Shri Santhosh Hegde sought to support the constitutional validity of the amendment. Shri Ram Jethmalani has attacked the validity of the amendment for the same reasons as put forward by Shri Sharma.</h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">4. Before we proceed to record our reasons for the conclusions reached in our order dated 12th November, 1991, on the contentions raised and argued, it is necessary to have a brief look at the provisions of the Tenth Schedule.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The Statement of Objects and Reasons appended to the Bill which was adopted as the Constitution (Fifty-Second Amendment) Act, 1985 says:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"The evil of political defections has been a matter of national concern. If it is not combated, it is likely to undermine the very foundation of our democracy and the principles which sustain it.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">With this object, an assurance was given in the Address by the President to Parliament that the Government intended to introduce in the current session of Parliament an anti-defection 718 Bill. This Bill is meant for outlawing defection and fulfilling the above assurance.\" On December 8, 1967, the Lok sabha had passed an unanimous Resolution in terms following:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"a high-level Committee consisting of representatives of political parties and constitutional experts be set up immediately by Government to consider the problem of legislators changing their allegiance from one party to another and their frequent crossing of the floor in all its aspects and make recommendations in this regard.\" The said Committee known as the \"Committee on Defections\" in its report dated January 7, 1969, inter-alia, observed:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"Following the Fourth General Election, in the short period between March 1967 and February, 1968, the Indian political scene was characterised by numerous instances of change of party allegiance by legislators in several States. Compared to roughly 542 cases in the entire period between the First and Fourth General Election, at least 438 defections occurred in these 12 months alone.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Among Independents, 157 out of a total of 376 elected joined various parties in this period.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">That the lure of office played a dominant part in decisions of legislators to defect was obvious from the fact that out of 210 defecting legislators of the States of Bihar, Haryana, Madhya Pradesh, Punjab, Rajasthan Uttar Pradesh and West Bengal, 116 were included in the Council of Ministers which they helped to bring into being by defections. The other disturbing features of this phenomenon were:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">multiple acts of defections by the same persons or set of persons (Haryana affording a conspicuous example); few resignations of the membership of the legislature of explanations by individual defectors, indifference on the part of defectors to political proprieties, constituency preference or public opinion; and the belief held by the people and expressed in the press that corruption and bribery were behind some of these defections\".</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(emphasis supplied) 719 The Committee on Defections recommended that a defector should be debarred for a period of one year or till such time as he resigned his seat and got himself re-elected from appointment to the office of a Minister including Deputy Minister or Speaker or Deputy Speaker, or any post carrying salaries or allowances to be paid from the Consolidated Fund of India or of the State or from the funds of Government Undertakings in public sector in addition to those to which the defector might be entitled as legislator. The Committee on Defections could not however, reach an agreed conclusion in the matter of disqualifying a defector from continuing to be a Member of Parliament/State Legislator.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Keeping in view the recommendations of the committee on Defections, the Constitution (Thirty-Second Amendment) Bill,, 1973 was introduced in the Lok Sabha on May 16, 1973.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It provided for disqualifying a Member from continuing as a Member of either House of Parliament or the State Legislature on his voluntarily giving up his membership of the political party by which he was set up as a candidate at such election or of which he became a Member after such election, or on his voting or abstaining from voting in such House contrary to any direction issued by such political party or by any person or authority authorised by it in this behalf without obtaining prior permission of such party, person or authority. The said Bill, however, lapsed on account of dissolution of the House. Thereafter, the Constitution (Forty-eight Amendment) Bill, 1979 was introduced in the Lok Sabha which also contained similar provisions for disqualification on the ground of defection.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">This Bill also lapsed and it was followed by the Bill which was enacted into the Constitution (Fifty Second Amendment) Act, 1985.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">5. This brings to the fore the object underlying the provisions in the Tenth Schedule. The object is to curb the evil of political defections motivated by lure of office or other similar considerations which endanger the foundations of our democracy. The remedy proposed is to disqualify the Member of either House of Parliament or of the State Legislature who is found to have defected from continuing as a Member of the House. The grounds of disqualification are specified in Paragraph 2 of the Tenth Schedule.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Paragraph 2(1) relates to a Member of the House belonging to a political party by which he was set up as a candidate at the election. Under 720 Paragraph 2(1) (a) such a Member would incur disqualification if he voluntarily gives up his membership of such political party. Under clause (b) he would incur the disqualification if he votes or abstains from voting in the House contrary to \"any direction\" issued by the political party to which he belongs or by any person or authority authorised by it in this behalf without obtaining, in either case, prior permission of such political party, person or authourity and such voting or abstention has not been condoned by such political party, person or authority within fifteen days from the date of such voting or abstention. This sub para would also apply to a nominated member who is a Member of a political party on the date of his nomination as such Member or who joins a political party within six months of his taking oath.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Paragraph 2(2) deals with a Member who has been elected otherwise than as a candidate set up by any political party and would incur the disqualification if he joins any political party after such election. A nominated Member of the House would incur his disqualification under sub para (3) if he joins any political party after the expiry of six months from the date on which he takes his seat.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">6. Paragraphs 3 and 4 of the Tenth Schedule, however, exclude the applicability of the provisions for disqualification under para 2 in cases of \"split\" in the original political party or merger of the original political party with another political party.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">These provisions in the Tenth Schedule give recognition to the role of political parties in the political process.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">A political party goes before the electorate with a particular programme and it sets up candidates at the election on the basis of such programme. A person who gets elected as a candidate set up by a political party is so elected on the basis of the programme of that political party. The provisions of Paragraph 2(1) (a) proceed on the premise that political propriety and morality demand that if such a person, after the election, changes his affiliation and leaves and political party which had set him up as a candidate at the election, then he should give up his Membership of the legislature and go back before the electorate. The same yard stick is applied to a person who is elected as an Independent candidate and wishes to join a political party after the election.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Paragraph 2 (1) (b) deals with a slightly different situation i.e. a variant where dissent becomes defection.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">If a Member while remaining a 721 Member of the political party which had set him up as a candidate at the election, votes or abstains from voting contrary to \"any direction\" issued by the political party to which he belongs or by any person or authority authorised by it in this behalf he incurs the disqualification. In other words, it deals with a Member who expresses his dissent from the stand of the political party to which he belongs by voting or abstaining from voting in the House contrary to the direction issued by the political party.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Paragraph 6 of the Tenth Schedule reads:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"6 (1) If any question arises as to whether a Member of a House has become subject to disqualification under this Schedule the question shall be referred for the decision of the Chairman or, as the case may be, the Speaker of such House and his decision shall be final:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Provided that where the question which has arisen is as to whether the Chairman or the Speaker of a House has become subject to such disqualification, the question shall be referred for the decision of such Member of the House as the House may elect in this behalf and his decision shall be final.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(2) All proceedings under sub-Paragraph (1) of this Paragraph in relation to any question as to disqualification of a Member of a House under this Schedule shall be deemed to be proceedings in Parliament within the meaning of Article 122 or, as the case may be, proceedings in the Legislature of a State within the meaning of Article 212.\" Paragraph 7 says:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"7. Bar of jurisdiction of courts: Notwithstanding anything in this Constitution, no court shall have any jurisdiction in respect of any matter connected with the disqualification of a Member of a House under this Schedule.\"</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">7. The challenge to the constitutional validity of the Amendment which introduces the Tenth Schedule is sought to be sustained of many grounds. It is urged that the constitutional Amendment introducing Paragraph 7 of the Tenth Schedule, in terms and in effect, seeks to make a change in Chapter IV of Part V of the Constitution in that it denudes the jurisdiction of the 722 Supreme Court under Article 136 of the Constitution of India and in Chapter V of part VI in that it takes away the jurisdiction of the High Courts under Article 226 and that, therefore, the legislative Bill, before presentation to the President for assent, would require to be ratified by the Legislature of not less than one half of the States by resolution to that effect. In view of the admitted position that no such ratification was obtained for the Bill, it is contended, the whole Amending Bill-not merely Paragraph 7- fails and the amendment merely remains an abortive attempt to bring about an amendment. It is further contended that the very concept of disqualification for defection is violative of the fundamental values and principles underlying Parliamentary democracy and violates an elected representative\'s freedom of speech, right to dissent and freedom of conscience and is, therefore, unconstitutional as destructive of a basic feature of the Indian Constitution.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It is also urged that the investiture in the Speaker or the Chairman of the power to adjudicate disputed defections would violate an important incident of another basic feature of the Constitution, viz., Parliamentary democracy. It is contended that an independent, fair and impartial machinery for resolution of electoral disputes is an essential and important incident of democracy and that the vesting of the power of adjudication in the Speaker or the Chairman-who, in the India Parliamentary system are nominees of political parties and are not obliged to resign their party affiliations after election-is violative of this requirement.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It is alternatively contended that if it is to be held that the amendment does not attract the proviso to Article 368(2), then Paragraph 7 in so far as it takes away the power of judicial review, which, in itself, is one of the basic features of the Constitution is liable to be struck down.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">8. There are certain other contentions which, upon a closer examination, raise issues more of construction than constitutionality. For instance, some arguments were expanded on the exact connotations of a \"split\" as distinct from a \"defection\" within the meaning of Paragraph 3. Then again, it was urged that under Paragraph 2(b) the expression \"any direction\" is so wide that even a direction,, which if given effect to and implemented might bring about a result which may itself be obnoxious to and violative of constitutional ideals and values would be a source of disqualification . These are,, indeed, matters of construction as to how,, in the context in which the occasion for the introduction of the Tenth Schedule arose and the high purpose it is intended to serve, the expression \"any direction\" occurring in Paragraph 723 2(b) is to be understood. Indeed, in one of the decisions cited before us (Prakash Singh Badal &amp; Ors. v. Union of India &amp; Ors., AIR 1987 Punjab and Haryana 263) this aspect has been considered by the High Court. The decision was relied upon before us. We shall examine it presently.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">9. Supporting the constitutionality of the Amendment, respondents urge that the Tenth Schedule creates a non- justiciable constitutional area dealing with certain complex political issues which have no strict adjudicatory disposition. New rights and obligations are created for the first time uno-flatu by the Constitution and the Constitution itself has envisaged a distinct constitutional machinery for the resolution of those disputes. These rights, obligations and remedies, it is urged, which are in their very nature and innate complexities are in political thickets and are not amenable to judicial processes and the Tenth Schedule has merely recognised this complex character of the issues and that the exclusion of this area is constitutionally preserved by imparting a finality to the decisions of the Speaker or the Chairman and by deeming the whole proceedings as proceedings within Parliament or within the House of Legislature of the States envisaged in Articles 122 and 212, respectively, and further by expressly excluding the Courts\' jurisdiction under Paragraph 7.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Indeed, in constitutional and legal theory, it is urged,, there is really no ouster of jurisdiction of Courts or of Judicial Review as the subject-matter itself by its inherent character and complexities is not amenable to but outside judicial power and that the ouster of jurisdiction under Paragraph 7 is merely a consequential constitutional recognition of the non-amenability of the subject-matter to the judicial power of the State, the corollary of which is that the Speaker or the Chairman,, as the case may be, exercising powers under Paragraph 6(1) of the Tenth Schedule function not as a statutory Tribunal but as a part of the State\'s Legislative Department.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It is, therefore, urged that no question of the ouster of jurisdiction of Courts would at all arise inasmuch as in the first place, having regard to the political nature of the issues, the subject-matter is itself not amenable to judicial power. It is urged that the question in the last analyses pertains to the constitution of the House and the Legislature is entitled to deal with it exclusively.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">10. It is further urged that Judicial Review - apart from Judicial Review of the legislation as inherent under a written constitution -is 724 merely a branch of administrative law remedies and is by no means a basic feature of the Constitution and that, therefore, Paragraph 7, being a constitutional provision cannot be invalidated on some general doctrine not found in the Constitution itself.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">11. On the contentions raised and urged at the hearing the questions that fall for consideration are the following:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(A) The Constitution (Fifty-Second Amendment) Act, 1985, in so far as it seeks to introduce the Tenth Schedule is destructive of the basic structure of the constitution as it is violative of the fundamental principles of Parliamentary democracy, a basic feature of the Indian constitutionalism and is destructive of the freedom of speech, right to dissent and freedom of conscience as the provisions of the Tenth Schedule seek to penalise and disqualify elected representatives for the exercise of these rights and freedoms which are essential to the sustenance of the system of Parliamentary democracy.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(B) Having regard to the legislative history and evolution of the principles underlying the Tenth Schedule, Paragraph 7 thereof in terms and in effect, brings about a change in the operation and effect of Article 136,, 226 and 227 of the Constitution of India and, therefore, the Bill introducing the amendment attracts the proviso to Article 368(2) of the constitution and would require to be ratified by the legislative of the States before the Bill is presented for Presidential assent.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(C) In view of the admitted non-compliance with proviso to Article 368(2) not only Paragraph 7 of the Tenth Schedule, but also the entire Bill resulting in the Constitution (Fifty-Second Amendment) Act, 1985, stands vitiated and the purported amendment is abortive and does not in law bring about a valid amendment.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Or whether, the effect of such non-compliance invalidates Paragraph 7 alone and the other provisions which, by themselves, do not attract the proviso do not become invalid.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(D) That even if the effect of non-ratification by the legislature 725 of the States is to invalidate Paragraph 7 alone, the whole of the Tenth Schedule fails for non- severability. Doctrine of severability, as applied to ordinary statutes to promote their constitutionality, is inapplicable to constitutional Amendments.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Even otherwise, having regard to legislative intent and scheme of the Tenth Schedule, the other provisions of the Tenth Schedule, after the severance and excision of Paragraph 7, become truncated, and unworkable and cannot stand and operate independently. The Legislature would not have enacted the Tenth Schedule without Paragraph 7 which forms its heart and core.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(E) That the deeming provision in Paragraph 6(2) of the Tenth Schedule attracts the immunity under Articles 122 and 212. The Speaker and the Chairman in relation to the exercise of the powers under the Tenth Schedule shall not be subjected to the jurisdiction of any Court.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The Tenth Schedule seeks to and does create a new and non-justiciable area of rights, obligations and remedies to be resolved in the exclusive manner envisaged by the Constitution and is not amenable to , but constitutionally immune from curial adjudicative processes.</span></h4><h4 style=\"text-align: justify; \"><font face=\"Rockwell, Corbel, Museo 500, Helvetica, Arial\">(F) That even if Paragraph 7 erecting a bar on the jurisdiction of Courts is held inoperative, the Courts\' jurisdiction is, in any event, barred as Paragraph 6(1) which imparts a constitutional `finality\'to the decision of the Speaker or the Chairman, as the case may be, and that such concept of `finality\' bars examination of the matter by the Courts.</font></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(G) The concept of free and fair elections as a necessary concomitant and attribute of democracy which is a basic feature includes an independent impartial machinery for the adjudication of the electoral disputes. The Speaker and the Chairman do not satisfy these incidents of an independent adjudicatory machinery.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">The investiture of the determinative and adjudicative jurisdiction 726 in the Speaker or the Chairman, as the case may be, would, by itself, vitiate the provision on the ground of reasonable likelihood of bias and lack of impartiality and therefore denies the imperative of an independent adjudicatory machinery. The Speaker and Chairman are elected and hold office on the support of the majority party and are not required to resign their Membership of the political party after their election to the office of the Speaker or Chairman.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(H) That even if Paragraph 7 of the Tenth Schedule is held not to bring about a change or affect Articles 136, 226 and 227 of the Constitution, the amendment is unconstitutional as it erodes and destroys judicial review which is one of the basic features of the constitution.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">12. Re: Contention(A):</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">(The Tenth Schedule is part of the constitution and attracts the same cannons of construction as are applicable to the expounding of the fundamental law. One constitutional power is necessarily conditioned by the others as the Constitution is one \"coherent document\".</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Learned counsel for the petitioners accordingly say that Tenth Schedule should be read subject to the basic features of the Constitution. The Tenth Schedule and certain essential incidents of democracy, it is urged, cannot co- exist.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">In expounding the processes of the fundamental law, the Constitution must be treated as a logical-whole. Westel Woodbury Willoughby in the \"Constitutional Law of the United States\" states:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"The Constitution is a logical whole, each provision of which is an integral part thereof, and it is, therefore,, logically proper, and indeed imperative, to construe one part in the light of the provisions of the other parts.\" [2nd Edn. Vol.1 page 65] A constitutional document outlines only broad and general principles meant to endure and be capable of flexible application to changing circumstances - a distinction which differentiates a statue from a Charter under which all statutes are made. Cooley on \"Constitutional Limitations\" says:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">727 \"Upon the adoption of an amendment to a constitution, the amendment becomes a part thereof; as much so as if it had been originally incorporated in the Constitution; and it is to be construed accordingly.\" [8th Edn. Vol. 1 page 129]</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">13. In considering the validity of a constitutional amendment the changing and the changed circumstances that compelled the amendment are important criteria. The observations of the U.S. Supreme Court in Maxwell v. Dow (44 lawyer\'s Edition 597 at page 605) are worthy of note:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"....to read its language in connection with the known condition of affairs out of which the occasion for its adoption may have arisen and then to construe it,, if there be therein any doubtful expressions, in a way so far as is reasonably possible, to forward the known purpose or object for which the amendment was adopted.....\" The report of the Committee on Defections took note of the unprincipled and unethical defections induced by considerations of personal gains said:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"....What was most heartening was the feeling of deep concern over these unhealthy developments in national life on the part of the leaders of political parties themselves. Parliament mirrored this widespread concern......\" [page 1]</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">14. It was strenuously contended by Shri Ram Jethmalani and Shri Sharma that the provisions of the Tenth Schedule constitute a flagrant violation of those fundamental principles and values which are basic to the sustenance of the very system of Parliamentary democracy. The Tenth Schedule, it is urged, negates those very foundational assumptions of Parliamentary democracy; of freedom of speech; of the right to dissent and of the freedom of conscience. It is urged that unprincipled political defections may be an evil, but it will be the beginning of much greater evils if the remedies, graver than the disease itself, are adopted. The Tenth Schedule, they say, seeks to throw away the baby with the bath-water. Learned counsel argue that \"crossing the floor\", as it has come to be called, mirrors the meanderings of a troubled conscience on issues of political 728 morality and to punish an elected representative for what really amounts to an expression of conscience negates the very democratic principles which the Tenth Schedule is supposed to preserve and sustain. Learned counsel referred to the famous speech to the Electors of Bristol, 1774, where Edmund Burke reportedly said:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"It ought to be the happiness and glory of a representative to live in the strictest union, the closest correspondence, and the most unreserved communication with his constituents. Their wishes ought to have great weight with him; their opinion, high respect; their business, unremitted attention.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It is his duty to sacrifice his repose, his pleasures, his satisfactions to theirs -and above all, ever, and in all cases, to prefer their interest to his own. But his unbiased opinion, his mature judgment, his enlightened conscience, he ought not to sacrifice to you, to any man, or to any set of men living.... Your representative owes you, not his industry only, but his judgment; and he betrays, instead of serving you, if he sacrifices it to your opinion.\" [see: Parliament Functions, Practice &amp; Procedures by JAG Griffith and Michael Ryle 1989 Edn. page 70]</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">15. Shri Jethmalani and Shri sharma also relied upon certain observations of Lord Shaw in Amalgamated Society or Railway Servants v. Osborne, [1909] UKLawRpAC 69; [1910 A.C. 87] to contend that a provision which seeks to attach a liability of disqualification of an elected Member for freely expressing his views on matters of conscience, faith and political belief are indeed restraints on the freedom of speech - restraints opposed to public policy. In that case a registered trade union framed a rule enabling it to levy contributions on the Members to support its efforts to obtain Parliamentary representation by setting up candidates at elections. It also framed a rule requiring all such candidates to sign and accept the conditions of the Labour Party and be subject to its whip. The observations in the case relied upon by learned counsel are those of Lord Shaw of Dunfermline who observed:</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">\"Take the testing instance: should his view as to right and wrong on a public issue as to the true line of service to the realm, as to the real interests of the constituency which has elected him, or even of the society which pays him, differ from the decision of the parliamentary party and the maintenance by it of its 729 policy, he has come under a contract to place his vote and action into subjection not to his own convictions, but to their decisions. My Lords, I do not think that such a subjection is compatible either with the spirit of our parliamentary constitution or with that independence and freedom which have hither-to been held to lie at the basis of representative government in the United Kingdom.\" [page 111] \"For the people having reserved to themselves the choice of their representatives, as the fence to their properties, could do it for no other end but that they might always be freely chosen, and so chosen freely act and advise, as the necessity of the commonwealth and the public good should upon examination and mature debate be judged to require.....\" [page 113] \"Still further, in regard to the Members of Parliament himself, he too is to be free; he is not to be the paid mandatory of any man, or organization of men, nor is he entitled to bind himself to subordinate his opinions on public questions to others, for wages, or at the peril of pecuniary loss; and any contract of this character would not be recognized by a Court of law, either for its enforcement or in respect of its breach...\" [page 115] It is relevant to observe here that the rule impugned in that case was struck down by the Court of Appeal - whose decision was upheld by the House of Lords - on grounds of the Society\'s competence to make the rule. It was held that the rule was beyond its powers. Lord Shaw, however, was of the view that the impugned rule was opposed to those principles of public policy essential to the working of a representative government. The view expressed by Lord Shaw was not the decision of the House of Lords in the case.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">But, the real question is whether under the Indian constitutional scheme is there any immunity from constitutional correctives against a 730 legislatively perceived political evil of unprincipled defections induced by the lure of office and monetary inducements?</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">16. The points raised in the petitions are, indeed, far-reaching and of no small importance - invoking the `sense of relevance of constitutionally stated principles to unfamiliar settings\'. On the one hand there is the real and imminent threat to the very fabric of Indian democracy posed by certain levels of political behavior conspicuous by their utter and total disregard of well recognised political proprieties and morality. These trends tend to degrade the tone of political life and, in their wider propensities, are dangerous to and undermine the very survival of the cherished values of democracy. there is the legislative determination through experimental constitutional processes to combat that evil.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">On the other hand, there are, as in all political and economic experimentations, certain side-effects and fall- out which might affect and hurt even honest dissenters and conscientious objectors. These are the usual plus and minus of all areas of experimental legislation. In these areas the distinction between what is constitutionally permissible and what is outside it is marked by a `hazy gray-line\' and it is the Court\'s duty to identify, \" darken and deepen\" the de</span><br></h4>', '735e09b77af559b9b27a9a57526b3d89.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-05', 1, '', '', '2020-12-06 01:32:18', '2021-01-21 22:17:22');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(960, 'SS71Y8uzzbcH0BcOoMXfZgQTz', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Supreme Court judgement on Telephone-tapping and subsequent developments.  ', '<h6><b>The Supreme Court considered the issue of Telephone -tapping in&nbsp;</b><b style=\"font-size: 1rem; font-family: var(--bs-font-sans-serif);\">People\'s Union for Civil Liberties (PUCL) v. Union of India, (1997) 1 SCC 301.&nbsp;</b><b style=\"font-size: 1rem; font-family: var(--bs-font-sans-serif);\">Justice Kuldip Singh and Justice S. Saghir Ahmed.&nbsp;</b></h6><h6><b>In the opening paragraph Justice Kuldip Singh observes \"Telephone-tapping is a serious invasion of an individual\'s privacy. With the growth of highly sophisticated communication technology, the right to hold telephone conversation, in the privacy of one\'s home or office without interference, is increasingly susceptible to abuse. It is no doubt correct that every Government, howsoever democratic, exercises some degree of sub rosa operation as a part of its intelligence outfit but at the same time citizen\'s right to privacy has to be protected from being abused by the authorities of the day.\"<br></b></h6><h6><b><u>Relevant paragraphs from the judgment</u>. 2. This petition — public interest — under Article 32 of the Constitution of India has been filed by the People\'s Union of Civil Liberties, a voluntary organisation, highlighting the incidents of telephone-tapping in the recent past. The petitioner has challenged the constitutional validity of Section 5(2) of the Indian Telegraph Act, 1885 (the Act), in the alternative it is contended that the said provisions be suitably read down to include procedural safeguards to rule out arbitrariness and to prevent the indiscriminate telephone-tapping.</b></h6><h6><b>Section 5(2) of the Telegraph Act, 1885&nbsp; is as under:<br></b></h6><h6><b><i>“5. (2) On the occurrence of any public emergency, or in the interest of the public safety, the Central Government or a State Government or any officer specially unauthorised in this behalf by the Central Government or a State Government may, if satisfied that it is necessary or expedient so to do in the interests of the sovereignty and integrity of India, the security of the State, friendly relations with foreign States or public order or for preventing incitement to the commission of an offence, for reasons to be recorded in writing, by order, direct that any message or class of messages to or from any person or class of persons, or relating to any particular subject, brought for transmission by or transmitted or received by any telegraph, shall not be transmitted, or shall be intercepted or detained, or shall be disclosed to the Government making the order or an officer thereof mentioned in the order:<br>Provided that press messages intended to be published in India of correspondents accredited to the Central Government or a State Government shall not be intercepted or detained, unless their transmission has been prohibited under this sub-section.”</i><br></b></h6><h6><b>4. The above provisions clearly indicate that in the event of the occurrence of a public emergency or in the interest of public safety the Central Government or the State Government or any officer specially authorised in this behalf, can intercept messages if satisfied that it is necessary or expedient so to do in the interest of:<br>(i) The sovereignty and integrity of India.<br>(ii) The security of the State.<br>(iii) Friendly relations with foreign States.<br>(iv) Public order.<br>(v) For preventing incitement to the commission of an offence.<br></b></h6><h6><b><u>Directions from the Supreme Court. </u>35. We, therefore, order and direct as under:<br>1. An order for telephone-tapping in terms of Section 5(2) of the Act shall not be issued except by the Home Secretary, Government of India (Central Government) and Home Secretaries of the State Governments. In an urgent case the power may be delegated to an officer of the Home Department of the Government of India and the State Governments not below the rank of Joint Secretary. Copy of the order shall be sent to the Review Committee concerned within one week of the passing of the order.<br>2. The order shall require the person to whom it is addressed to intercept in the course of their transmission by means of a public telecommunication system, such communications as are described in the order. The order may also require the person to whom it is addressed to disclose the intercepted material to such persons and in such manner as are described in the order.<br>3. The matters to be taken into account in considering whether an order is necessary under Section 5(2) of the Act shall include whether the information which is considered necessary to acquire could reasonably be acquired by other means.<br>4. The interception required under Section 5(2) of the Act shall be the interception of such communications as are sent to or from one or more addresses, specified in the order, being an address or addresses likely to be used for the transmission of communications to or from, from one particular person specified or described in the order or one particular set of premises specified or described in the order.<br>5. The order under Section 5(2) of the Act shall, unless renewed, cease to have effect at the end of the period of two months from the date of issue. The authority which issued the order may, at any time before the end of two-month period renew the order if it considers that it is necessary to continue the order in terms of Section 5(2) of the Act. The total period for the operation of the order shall not exceed six months.<br>6. The authority which issued the order shall maintain the following records:<br>(a) the intercepted communications,<br>(b) the extent to which the material is disclosed,<br>(c) the number of persons and their identity to whom any of the material is disclosed,<br>(d) the extent to which the material is copied, and<br>(e) the number of copies made of any of the material.<br>7. The use of the intercepted material shall be limited to the minimum that is necessary in terms of Section 5(2) of the Act.<br>8. Each copy made of any of the intercepted material shall be destroyed as soon as its retention is no longer necessary in terms of Section 5(2) of the Act.<br>9. There shall be a Review Committee consisting of Cabinet Secretary, the Law Secretary and the Secretary, Telecommunication at the level of the Central Government. The Review Committee at the State level shall consist of Chief Secretary, Law Secretary and another member, other than the Home Secretary, appointed by the State Government.<br>(a) The Committee shall on its own, within two months of the passing of the order by the authority concerned, investigate whether there is or has been a relevant order under Section 5(2) of the Act. Where there is or has been an order, whether there has been any contravention of the provisions of Section 5(2) of the Act.<br>(b) If on an investigation the Committee concludes that there has been a contravention of the provisions of Section 5(2) of the Act, it shall set aside the order under scrutiny of the Committee. It shall further direct the destruction of the copies of the intercepted material.<br>(c) If on investigation, the Committee comes to the conclusion that there has been no contravention of the provisions of Section 5(2) of the Act, it shall record the finding to that effect.</b></h6><p><span style=\"font-weight: bolder; font-family: var(--bs-font-sans-serif); font-size: 1rem;\">IT (Procedures and Safeguards for Interception, Monitoring and Decryption of Information) Rules framed in 2009 under the IT Act&nbsp;</span><b>state that only the competent authority can issue an order for the interception, monitoring or decryption of any information generated, transmitted, received or stored in any computer resource (mobile phones would count). The competent authority is once again the Union Home Secretary or State Secretaries in charge of the Home Departments.</b></p><p><b style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">The Supreme Court in a landmark decision in August, 2017 (Justice K. S. Puttaswamy (Retd.) and Anr. vs Union Of India And Others) unanimously upheld right to privacy as a fundamental right under Articles 14, 19 and 21 of the Constitution. It is a building block and an important component of the legal battles that are to come over the state’s ability to conduct surveillance. But as yet a grey area remains between privacy and the state’s requirements for security.</b><br></p><p><b>In the same year, the government also constituted a Data Protection Committee under retired Justice B.N. Srikrishna. It held public hearings across India and submitted a draft data protection law in 2018 which Parliament is yet to enact. Experts have pointed out, however, that the draft law does not deal adequately with surveillance reform.</b></p><p><b>The Personal Data Protection Bill, 2018 (enclosed as PDF) has not been enacted till today. The Statement of Objects and Reasons of the Bill reads thus;</b></p><p><b>WHEREAS the right to privacy is a fundamental right and it is necessary to protect personal data as an essential facet of informational privacy;&nbsp;</b></p><p><b>WHEREAS the growth of the digital economy has meant the use of data as a critical means of communication between persons; WHEREAS it is necessary to create a collective culture that fosters a free and fair digital economy, respecting the informational privacy of individuals, and ensuring empowerment, progress and innovation;&nbsp;</b></p><p><b>AND WHEREAS it is expedient to make provision: toprotect the autonomy of individuals in relation with their personal data, to specify where the flow and usage of personal data is appropriate, to create a relationship of trust between persons and entities processing their personal data, to specify the rights of individuals whose personal data are processed, to create a framework for implementing organisational and technical measures in processing personal data, to lay down norms for cross-border transfer of personal data, to ensure the accountability of entities processing personal data, to provide remedies for unauthorised and harmful processing, and to establish a Data Protection Authority for overseeing processing activities.</b></p><p><b>In December 2018, the Central government created a furore when it authorised 10 Central agencies to conduct surveillance — the Intelligence Bureau, the Central Bureau of Investigation, the National Investigation Agency, the Research &amp; Analysis Wing, the Directorate of Signal Intelligence, the Narcotics Control Bureau, the Enforcement Directorate, the Central Board of Direct Taxes, the Directorate of Revenue Intelligence and the Delhi Police Commissioner. In the face of criticism that it was building a ‘surveillance state’, the government countered that it was building upon the rules laid down in 2009 and the agencies would still need approval from a competent authority, usually the Union Home Secretary.</b></p><p></p><p><b>The recent alleged usage of Military grade spyware Pegasus has again created uproar in the Parliament. The matter has now reached the Supreme Court. Hopefully a comprehensive landmark judgement will be rendered by the Supreme Court on this issue.&nbsp;&nbsp;</b></p><p><b>-S.Basavaraj, Daksha Legal.&nbsp;</b></p>', '54a71e96e6e4b2507069c58f4e77556f.jpg', '7272f1acfde123195e14e9f236b6037e.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-08-16', 1, '', '', '2021-08-17 02:08:48', '2021-08-16 16:09:06'),
(365, 'fzAXguziZ8tux8PINupTNoBcQ', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A member of the Bar is expected to act first as an Officer of the Court and thereafter as the mouthpiece of his client. Karnataka High Court censures lawyer for filing contemptuous petition.', '<h4><span style=\"font-size: 0.875rem;\"><b>V. Gururaj vs Sri. Sri. Vidya Sreesha Theertharu. Writ Petition 44/2021 decided on 12 January 2021.</b></span><br><br><b>Judgment Link</b>: <br><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/359672/1/WP44-21-12-01-2021.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/359672/1/WP44-21-12-01-2021.pdf</a><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\"><b><br>Note: </b><br>This is a matter where, at the instance and on the advice of client, Advocate filed a Writ Petition before the Division Bench of the Karnataka High Court praying that his matter which is pending before the learned single judge of the High Court be heard by the bench of the Chief Justice or any other court which is constituted by the judge hailing from a different State other than Karnataka. The Hon’ble division bench found the conduct of the petitioner highly contemptuous and dismissed the same with exemplary cost of Rs. 1,00,000/-. On the conduct of the counsel, the Hon’ble Court said as follows:\r\n14. Before we part with this order, we must say something about the role of the members of the Bar. It is well settled that a member of the Bar is expected to act first as an Officer of the Court and thereafter, as the mouthpiece of his client. In this behalf, we cannot avoid temptation of what is observed in paragraph 7 of the decision of the  Apex Court in  the case of T.Arvindam vs T.V. Satyapal and another (1977) 4 SCC 467. Paragraph 7 of the said case reads thus:\r\n“7. We regret the infliction of the ordeal upon the learned Judge of the High Court by a callous party. We more than regret the circumstance that the party concerned has been able to prevail upon one lawyer or the other to present to the Court a case which was disingenuous or worse. It may be a valuable contribution to the cause of justice if counsel screen wholly fraudulent and frivolous litigation refusing to be beguiled by dubious clients. And remembering that an advocate is an officer of justice he owes it to society not to collaborate in shady actions. The Bar Council of India, we hope will activate this obligation. We are constrained to make these observations and hope that the co- operation of the Bar will be readily forthcoming to the Bench for spending judicial time on worthwhile disputes and avoiding the distraction of sham litigation such as the one we are disposing of. Another moral of this unrighteous chain litigation is the gullible grant of ex parte orders tempts gamblers in litigation into easy courts. A judge who succumbs to ex parte pressure in unmerited cases helps devalue the judicial process. We must appreciate Shri Ramasesh for his young candour and correct advocacy.”\r\n15. The Apex Court expressed displeasure about the manner in which  the party concerned  was able to prevail upon a lawyer to represent before the Court a case like this. In this case, we have before us a young member of the Bar  who should follow what is laid down by the Apex Court.  In  paragraph 7 of the aforesaid decision, when the Apex Court  said that it may be a valuable contribution to the  cause  of justice if the Advocates screen wholly fraudulent and frivolous litigations refusing to be beguiled by dubious clients. We hope and trust that the learned counsel appearing for the petitioner has learnt a lesson and he will hereafter follow what the Apex Court expects the members of the Bar to follow.</span></div>\r\n<p></p><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">Compiled by S. Basavaraj, Advocate, Daksha Legal</b><br></div><p></p><p></p></h4><h4></h4>', '077fd401c147688c090bdec15ced6d88.png', 'e4ca25324968f17abff41412af2e5684.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-01-21', 1, '', '', '2021-01-22 06:03:28', '2021-01-22 16:54:32'),
(120, 'Ef83EOrNKTXlNewvVrSHxAXSl', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Negotiable Instruments Act. Share brokerage is based on contract of agency. When cheque is issued, liability of owner of shares to pay commission cannot be denied on the ground of losses suffered. Karnataka High Court.     ', '<p><b>M/s. Networth Stock Broking Limited vs Shanthala.Criminal Appeal 335/2017 decided on 23 November 2020.</b><br><br><b>Judgment Link: </b><br>http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/351239/1/CRLA335-17-23-11-2020.pdf<br><br><b>Relevant paragraphs: <br><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem; font-weight: 400;\">8. Complainant claims that it was liasioning between the accused and share broker. Further the transaction according to complainant and accused is not the first one which is one among umpteen number of transactions entered into between the complainant and the accused. It is not disputed that in the past there are instances wherein the shares were sold and made to purchase through mediation of the accused and also payments were made for choice.</span></div></b><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">9 &amp; 13. The rule of agency is based on two principles (1) whatever a person can do by himself he can do through another. (2) He who does an act through another does it by himself. Certain regular transactions involving a person who is being represented, person representing the former and the third parties may very well be akin to agency when the binding nature of the liability/duty on the person who is so presented by his representative. Thus the person so represented is principal and who represents is agent.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">15. Agency may be expressed or implied agency. Expressed agency is one wherein two parties agree for transaction where one will be acting as agent of another and person so acting as agent for valid acts bind the principal. When agent exercises authority or enters into transaction it will be authority by virtue of authority given by principal and benefit or loss principal is entitled to. Infact many of the principles are similar to that of law of partition. As a matter of fact contract of agency is considered as very partnership is concerned as extension of partnership and the implied authority of an agent.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">Appeal allowed.</span></div></p>', '858e642fbfe7bc819e649592e5b5d5f9.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-05', 1, '', '', '2020-12-05 23:48:40', '2021-01-21 22:39:15'),
(125, 'HB1WdZ0SUH046jCIpD55jxkSz', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Accused, after obtaining bail absconds and proclaimed by Court as ‘absconding accused’. He is not entitled for anticipatory bail. Karnataka High Court.', '<h4></h4><h3><span style=\"font-size: 1.75rem; font-family: var(--bs-font-sans-serif);\">Chandru vs State of Karnataka. </span></h3><h3><span style=\"font-size: 1.75rem; font-family: var(--bs-font-sans-serif);\">Criminal Petition 6734/2020&nbsp;</span>decided on 4 December 2020. </h3><h3>Justice M.G. Uma</h3><h3></h3><h4><span style=\"text-align: justify; font-size: 1.3125rem; font-family: var(--bs-font-sans-serif); -webkit-tap-highlight-color: transparent; -webkit-text-size-adjust: 100%;\">4.</span><span style=\"text-align: justify; font-size: 1.3125rem; font-family: var(--bs-font-sans-serif); -webkit-tap-highlight-color: transparent; -webkit-text-size-adjust: 100%;\"><b> </b>Admittedly, at the initial stage, this petitioner was granted bail in the present case subject to conditions. It is also admitted that the petitioner has not appeared before the trial Court as directed by the Court while granting bail. It is also admitted that the proclamation under Section 82 of Cr.P.C. is already issued and NBW is pending against the petitioner. Now the question arises as to whether at this stage, the petitioner once again can invoke Section 438 of Cr.P.C. seeking anticipatory bail in this regard.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">It is relevant to mention the decision of the Hon’ble Apex Court in the case of State of Madhya Pradesh vs. Pradeep Sharma reported in (2014) 2 SCC 171 wherein, the Court referred to its earlier judgment in the case of Lavesh vs. State (NCT of Delhi) reported in (2012) 8 SCC 730 extracted paragraph 12 therein and held as under:</span></h4><h4 style=\"text-align: justify;\"><i><b>“16. Recently, in Lavesh v.&nbsp; State (NCT of Delhi), this Court (of which both of us were parties) considered the scope of granting relief under Section 438 vis-à-vis a person who was declared as an absconder or proclaimed offender in terms of Section 82 of the Code. In para 12, this Court held as under:<br></b></i></h4><h4 style=\"text-align: justify;\"><i><b>12. From these materials and information, it is clear that the present appellant was not available for interrogation and investigation and was declared as ‘absconder’. Normally, when the accused is ‘absconding’ and declared as a ‘proclaimed offender’, there is no question of granting anticipatory bail. We reiterate that when a person against whom a warrant had been issued and is absconding or concealing himself in order to avoid execution of warrant and declared as a proclaimed offender in terms of Section 82 of the Code he is not entitled to the relief of anticipatory bail.</b></i></h4><h4 style=\"text-align: justify; \"><b style=\"font-size: 1.3125rem;\">7</b><span style=\"font-size: 1.3125rem;\">. It is clear from the above decision that if anyone is declared as an absconder/proclaimed offender in terms of Section 82 of the Code, he is not entitled to the relief of anticipatory bail.”In view of the above, the position of law is clear on the subject. The petitioner was already granted bail and he had not complied with the conditions imposed in the said order. The petitioner is already proclaimed as an absconding accused and NBW is issued against him. Therefore, the petitioner is not entitled to seek the discretionary relief of anticipatory bail under Section 438 of Cr.P.C. at this stage.</span><br></h4><h4 style=\"text-align: justify; \"><span style=\"font-size: 1.3125rem;\">Hence, the petition is dismissed.</span></h4>', 'b88a330bf83a068f445bd6bd6c5efa23.JPG', '76d822ac5ae72c00df27b813c37bda86.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-01-30', 1, '', '', '2020-12-06 03:59:58', '2023-01-30 17:05:41'),
(126, 'Hj5pfiWj0SFSwLpjky0v5rnvH', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Karnataka High Court directs State Election Commission to hold elections for 198 Wards of BBMP at the earliest', '<p style=\"box-sizing: inherit; -webkit-font-smoothing: antialiased; margin: 32px auto; max-width: calc(66.6667vw - 28px); overflow-wrap: break-word;\"><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\"><b>Karnataka High Court directs State Election Commission to hold elections for 198 Wards of BBMP at the earliest. Govt directed to notify reservations.<br></b></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\"><b>M Shivaraju and another vs The State of Karnataka and another. Writ Petition 10216 OF 2020 (LB-BMP) PIL C/W Writ Petition 11077 OF 2020 (LB-BMP) PIL and Writ Petition 1892 OF 2020 (LB-BMP) PIL decided on 4 December 2020.</b><br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\"><br><b>Judgment Link:</b><br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">https://karnatakajudiciary.kar.nic.in/noticeBoard/WP-10216-of-2020-%20BBMP-Elections.pdf</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\"><br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\"><br><b>ORDER </b><br>(i) We direct the State Government to publish the final&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">notification of reservations as per clause (c) of sub-section&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">(1) of Section 21 of the said Act of 1976 for 198 Wards as&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">per the delimitation notification dated 23rd June, 2020. We&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">grant time of one month from today to publish the final notification, though, as per the assurance given by the&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">Government, as recorded in the order dated 22nd&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">September 2020, the same was to be published within two&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">weeks from 22nd September 2020;&nbsp;<br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">(ii) We direct the State Election Commission to hold election of&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">BBMP as expeditiously as possible by publishing the&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">election programme within a maximum period of six weeks&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">from the date on which final reservation Notification is&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">published;<br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">(iii) We make it clear that elections shall be held for 198 Wards&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">as per the notification of delimitation of Wards already&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">published on 23rd June, 2020;<br></span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">(iv) The petitions are allowed on the above terms with no&nbsp;</span></font><font color=\"#1e1e1e\" face=\"Crimson Text, Baskerville Old Face, Garamond, Times New Roman, serif\"><span style=\"font-size: 15.75px;\">orders as to the costs.</span></font></p>', '178a0d6a9451c8ca39b6827e8516a5a4.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-04', 1, '', '', '2020-12-06 04:10:41', '2021-01-21 22:03:12'),
(366, 'OEiq17RA9hcoNdTiDB9hlf23A', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Land grabbing charges against H.D.Kumarasway. Karnataka High Court warns initiation of contempt proceedings against the Government officials.', '<p><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">On a Contempt of Court Petition (CCC 674/2020) filed by the Samaj Parivartana Samudaya, alleging inaction on the part of the Government officials to implement the earlier order of the Karnataka High Court, the Division Bench headed by the Hon’ble Chief Justice warned the Government officials that it would initiate contempt of court proceedings if the earlier order is not implemented.</span></div><div style=\"text-align: justify;\"><br></div><b>The Court heard the submissions of Mr. A.R.Goutham, Advocate for S. Basavaraj, Advocate, Daksha Legal.&nbsp;</b><br><br><b>Facts of the case. Samaj Parivarthan Samudaya – <br></b></p><div style=\"text-align: justify;\"><b><span style=\"font-size: 0.875rem; font-weight: 400;\">SPS had filed a Public Interest Litigation in Writ Petition 49/2020 seeking directions to the Government of Karnataka to take appropriate action against H.D. Kumaraswamy, D.C. Thammanna and Savithramma for violating various provisions of law dealing with agrarian reforms in the State of Karnataka and also for illegally grabbing lands. SPS also sought a direction to the State Government to implement the order of the Lokayukta in this regard. Hon’ble Court disposed the Writ Petition on 14:1:2020 recording the undertaking of the State Government that it would take action within three months.</span></b></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">The Karnataka Lokayukta’s order dated 5:8:2014 related to major land grabbing involving around 200 Acres of land (including 110 Acres of Gomala Land) by H.D. Kumaraswamy, the former Chief Minister of Karnataka, his close relatives and associates D.C. Thammanna, the former Minister for transportation and his sister- in law Savithramma.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">In the relevant portion of the Lokayukta Order, it has been mentioned that Survey No. 7,8,9,10,16 and 17 in Kethaganahalli Village of Bidadi Hobli in Ramanagara Taluk comprising of village common lands in total measuring 110 acres and 32 guntas of Government Pasture Lands (Gomala Land) which the Karnataka State Government had earmarked for public usage such as Lake, Burial Ground and to persons belonging to Scheduled Tribe (ST), and Scheduled Caste (SC), for irrigation purpose has been encroached by various persons.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">The encroachment of the granted lands by H.D. Kumaraswamy, D.C. Thammanna and Savitramma is reflected in the letter of the Assistant Commissioner, Ramanagara dated 25:8:2014 under the subject “Ex-Chief Minister Shri H.D. Kumaraswamy, other family members and his close relative MLA Maddur Shri D.C. Tammanna, his family members have grabbed 200 Acres of land including 110 Acres of Gomal lands that needs to be restored to Govt.”. The Assistant Commissioner enclosed a detailed 10 page report entitled the same as the subject of the said letter.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">The order of the Hon’ble High Court having not been implemented, SPS approached the Court on the contempt side. The Hon’ble Court expressed its displeasure today over the inaction on the part of the Government and warned that if the order is not complied with in letter and spirit, appropriate contempt of court proceedings would be initiated against the officials concerned.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 0.875rem;\">The matter is adjourned to 16 February 2021.</span></div><p></p>', '74f1b276e83b800f1ee238b28339f202.png', 'f5afb0560d8d6ffc43e18943bee9da11.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-01-21', 0, '', '', '2021-01-22 06:06:21', '2021-01-22 15:08:45'),
(2559, 'RbQ1DGFvwqSIFy1MmB9JiRBaS', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'The specified value and suit valuation in IPR suits below Rs. 3 lakhs shall be examined by the Courts to ensure it is not arbitrary or unreasonable and the suit is not undervalued. Karnataka High Court. ', '<p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Bangalore Blues Entertainment India Private Limited Vs One Ikigaii Edutech Private Limited and others.<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Miscellaneous First Appeal 6392 of 2022 decided on 2 January 2023.<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Justice Ravi V. Hosmani.</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>4. In said suit plaintiff filed IA no.1 for temporary\r\ninjunction under Order XXXIX Rules 1 and 2 of CPC in respect of\r\nbuilding by name \'Swamy Legato\' constructed over land bearing\r\nnew Sy.no.20./7, old Sy.no.20/4, Kadubisanahalli village,\r\nMarthahalli Outer Ring road, Bengaluru - insofar as 4th floor with\r\nsuper built up area of 7454 sq.ft., 5th floor with super built up area\r\nof 4064 sq. ft. and terrace open area of 3390 sq.ft. with four car\r\npark spaces in basement and 7 car par spaces on ground floor of\r\nsaid building (for short \'suit property\').</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>5. Said application said application was opposed by\r\ndefendant no.1. On consideration, trial Court passed impugned\r\norder allowing I.A.no.1 and restraining defendants from interfering\r\nwith possession of plaintiff over suit property. Challenging same\r\nthis appeal is filed.</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>18. From contentions urged, only point that arises for\r\nconsideration is:</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>\"Whether impugned order passed by trial Court\r\nallowing I.A.no.1 filed by plaintiff under Order\r\nXXXIX Rules 1 and 2 of CPC calls for\r\ninterference?\" <br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>19. Since, maintainability of suit before Civil Court as suit\r\nwould lie before Commercial Court is urged, same is take up for\r\nconsideration upfront. There is no dispute about fact that lease\r\nagreement between plaintiff and defendant no.1 was for exclusive\r\nuse of suit premises for commercial purposes. But, this Court in\r\nFine Footwear Pvt. Ltd. (supra), held that unless both of twin\r\nrequirements existed, dispute would not be a ‘commercial dispute’.\r\nTherefore, whether ‘specified value’ as per Section 12 is more than\r\nRs.3,00,000/-, is required to be determined.</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>22. In view of clear recital in lease agreement that suit\r\nproperty was being used for running Bar and Restaurant, first\r\nrequirement would be met. Further as per Section 12(1)(c) of C.C.\r\nAct, specified value of suit in respect of immovable property, would\r\nbe market value of such immovable property as on date of filing\r\nsuit. Explanation to Section 2(1)(c)(a) of C.C. Act states that\r\ncommercial dispute shall not cease to be a commercial dispute\r\nmerely because it involves \"any other relief pertaining to\r\nimmovable property.\"</b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>\r\n23. Admittedly, monthly rental value of suit premises, as\r\nper lease agreement is Rs.7,88,955/-, which would be more than\r\nRs.3,00,000/-, therefore, prima facie both requirements appear to\r\nbe met. <br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">27. One of main concerns addressed in Vishal Pipes Ltd.,\r\n(supra) was avoiding deliberate undervaluation to maintain suit\r\nbefore Civil Court and forum hunting, which was sought to be\r\ncurtailed by directing all matters concerning commercial disputes to\r\nbe filed only before Commercial Court, even if ‘specified value’ was\r\nless than Rs.3 Lakhs and requiring its examination by Commercial\r\nCourt. But possibility of such determination process itself, clogging\r\n‘Commercial Courts’ affecting timeline for disposal of commercial\r\ndisputes cannot be lost sight of. Hon’ble Supreme Court in Ambalal </span><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">Sarabhai Enterprises Ltd. has cautioned about ill-effects of\r\nclogging of Commercial Courts.\r\n</span></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><b><br></b></span></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><b>28. At same time, when CC Act does not bar suit with\r\nspecified value below Rupees Three Lakhs being filed before Civil\r\nCourt, instead of compelling all suits involving Commercial disputes\r\nfrom being filed before Commercial Courts, it would be appropriate\r\nto adopt procedure evolved by this Court in CRP.no.545/2022\r\ndisposed of on 13.12.2022.\r\n</b></span></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><b><br></b></span></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">29. In said petition, while deciding legality of rejection of\r\ndefendant’s contention about lack of jurisdiction of Civil Court, this\r\nCourt directed plaintiff to specifically state in plaint ‘specified value’\r\nas per provisions of CC Act, which trial Court would verify while\r\ndeciding its jurisdiction, before proceeding to entertain suit and to\r\nreturn it for re-presentation before Commercial Court, in case, it\r\nwas not. Such measure would prevent Commercial Courts from\r\nbeing clogged with determination of ‘specified value’ and would also\r\nbe in tune with Fine Footwear Pvt. Ltd. (supra).</span><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b><span lang=\"EN-US\">31. Until determination of specified value of subject matter\r\nof suit as per Section 12 of CC Act, suit cannot be held to be not\r\nmaintainable by referring to rental value etc. of suit premises,\r\nwhich would not be as per method of assessment provided under\r\nSection 12 of CC Act. Therefore, answer to point under </span><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\">consideration would be subject to determination of \'specified value\'\r\nby Trial Court.</span></b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1rem;\"><b><br></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b>ORDER</b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b>i. Appeal is disposed of directing plaintiff to\r\nplead regarding specified value of suit,\r\nwithin 15 days from today. Trial Court is\r\ndirected to determine whether same would\r\nbe below threshold limit specified in CC Act\r\nand consequently decide on its jurisdiction\r\nto entertain suit, as expeditiously as\r\npossible therefrom after providing\r\nopportunity to defendants also, but not later\r\nthan 30 days.\r\n</b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b><br></b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><b>ii. In case, suit is held not maintainable,\r\ninterim injunction would stand vacated with\r\nliberty to plaintiff to seek said relief before\r\nCommercial Court. </b></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><o:p></o:p></span></p>', '8cc17446fafef109c9b181bfb558cb76.JPG', 'ce0d8f364723945a1f6a2cd48b9454fe.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-01-13', 1, '', '', '2023-01-12 15:32:40', '2023-01-13 07:01:57'),
(2558, 'jiFI8QtucR4jGEld3bKYKFP1M', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Valuation of Suit. Suit for specific performance. Only value of the property shown in the agreement has to be considered for the purpose of jurisdiction. Karnataka High Court.', '<p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Husensab Vs Basayya and another.<o:p></o:p></b></span></p><p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span lang=\"EN-US\"><b>Civil Revision Petition 100033 of 2019 decided on 30 September 2020.<o:p></o:p></b></span></p><p><span lang=\"EN-US\" style=\"font-size: 12pt; font-family: Calibri, sans-serif;\"><b>Justice Suraj Govindaraj</b></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b>5. On the basis of the submissions made by Sri.Mrutyunjay Tata Bangi, learned counsel for the petitioner, the questions which would arise for determination are: </b></font></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b>(1) Whether the Plaintiff is free to value the Suit in any manner it deems fit and just, by making payment of the court fee could such a plaintiff change the jurisdiction of the Court?</b></font></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b> (2) Whether in a suit for specific performance, it is only the value of the property shown in the said agreement that would have to be considered for the purpose of jurisdiction or would any other item like cost of issuance of legal notice be included so as to increase the valuation. </b></font></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b>(3) What would be the role of the Court in the event of an artificial increase in the valuation altering the jurisdiction of the Court? Provisions of Order VII Rule 10 & 10A, 10B, Civil Procedure Code, Section 40 and 50 of the Karnataka Court Fees and Suits Valuation Act are noticed. </b></font></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b>9.5 ….a party cannot by artificially inflating the valuation or undervaluing the Suit be allowed to file a particular suit before a Court which would in the absence of such incorrect valuation not have any jurisdiction to try the matter. Merely because the Plaintiff is willing to pay higher court fee by inflating the valuation, he cannot be permitted to do so since the hierarchy of the Court dictates that particular Suit with particular valuation would have to be filed and tried by a particular Court, thus, giving rise to a vested right to the defendant that the Suit of particular nature of particular valuation would be tried by that particular Court only and not by any other Court. Paragraphs 10.2, 10.3, 10.4 & 10.5 … where the Suit is for a specific performance of contract of sale, the fee shall be computed on the amount of consideration. In the present case, apart from the valuation made as regards the consideration under the agreement of sale, the Plaintiff has added another item, namely the cost of issuance of legal notice to totally value the Suit at Rs.5,01,000/-. It is only by the addition of the relief, in this instance, towards legal notice, namely Rs.1,000/- that the valuation came to be increased in such a manner that the jurisdiction of the Court itself came to be changed. This in my considered opinion is not permissible. Paragraphs </b></font></span></p><p><span lang=\"EN-US\" style=\"\"><font face=\"Calibri, sans-serif\"><b>11.1 & 11.2 The Court would have to carefully examine the mode and methodology of the valuation made by the Plaintiff, more particularly when such a valuation would have the impact of altering the jurisdiction of the Court. The court cannot merely on the basis of the of the Plaintiff being willing to make payment of the court fee permit such a plaintiff to value the Suit at his whims and fancies and make payment of the stamp duty on that basis. The Court while dealing with the same and more so on an application under Order VII Rule 10 of the CPC would have to determine the valuation. The Court would also have to separate the main relief from the ancillary relief in order to ascertain the valuation for the purpose of jurisdiction and that for payment of court fee separately and come to a finding that it is competent to take up the matter and that the Suit has been filed in a proper and competent court.</b></font></span><br></p>', '2d93a71c9cf94fe63020263291b91c0e.JPG', '2864f39a220f913d4ebc78d07b9d7048.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-01-12', 1, '', '', '2023-01-12 10:21:45', '2023-01-12 10:23:44');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(142, 'jVQs8M5gWcOh6WfAIoGArFeQ9', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Consent Divorce. Parties can be represented by their parents or siblings as GPA holders. ', '<h4 style=\"text-align: justify;\">Aditya Jagannath and another vs NIL . M.F.A.No.4453/2020 (FC) decided on 10 November 2020.</h4><h4 style=\"text-align: justify;\">Judgment Link: <a href=\"https://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-4453-2020.pdf\" target=\"_blank\">https://karnatakajudiciary.kar.nic.in/noticeBoard/MFA-4453-2020.pdf</a></h4><h4 style=\"text-align: justify;\">HELD: 26. Permission is granted to the second appellant to be represented through her Power of Attorney holder, who is none other than her father on the strength of the Special Power of Attorney executed by her.</h4><h4 style=\"text-align: justify;\">Relevant paragraphs: 16. In recent times, we find that the parties who seek for dissolution of their marriage by a decree of divorce by mutual consent do so after long negotiation and discussion, some times they, being located at different parts of the globe, through skype, telephonically or use of other forms of technology, such as whatsapp calls, video conferencing etc. On account of the parties residing in different parts of the country or across the globe and owing to constraints of job or other constraints, such as illness etc., it may not be possible for both parties to sign and verify the pleadings and jointly present the petition for dissolution of their marriage by mutual consent before the Court of Law. This is so in the instant case. In such circumstances, one of the parties to the petition may avail of the facility of appointing a Power of Attorney/agent, in whom the party has full trust and confidence to represent her or him in a proceeding to be filed as in the instant case before the Family Court or any other Court seeking matrimonial or any other relief. Therefore, the provisions of the various enactments must be harmoniously read and interpreted, so as to make it conducive for availing or taking recourse through appointment of a Power of Attorney holder, to represent a party in a proceeding. This is particularly, as in the instant case, where parties are seeking dissolution of their marriage by a decree of divorce by mutual consent. Moreover, in such cases, a party can carefully think over the matter and appoint a person in whom the party would have full trust and confidence to be as her or his Power of Attorney holder. It is on the strength of such a document of Power of Attorney that the Power of Attorney holder would represent a party to jointly file a petition for dissolution of their marriage through mutual consent on behalf of the executor or Power of Attorney. The Family Court may insist on satisfying itself that indeed the parties have an intention that they should seek a decree of divorce by mutual consent and in order to fully satisfy itself, the Court may, apart from examining the Power of Attorney holder representing any party, also through video conferencing, (which is now widely being used on account of the Covid-19 pandemic), examine the parties including the party who is represented through the Power of Attorney holder. That merely because one of the parties would file the petition seeking dissolution of marriage by mutual consent jointly with the other party, through a Power of Attorney, one cannot ignore the fact that the Court must satisfy itself about the genuineness of the petition filed by the parties seeking dissolution of their marriage by a decree of divorce by mutual consent irrespective of whether it is filed through a Power of Attorney. In fact, the filing of such a petition is an exception to what has been stated in Section 23 of the Act. Even so, the Court ought not to be pedantic but must apply a flexible procedure which is in accordance with law and not a procedure, but not one which is incongruent in law.</h4><h4 style=\"text-align: justify;\">17. In fact, recently, the Hon’ble Supreme Court in the case of Amardeep Singh vs. Harveen Kaur [(2017) 8 SCC 746] while considering Section 13B(2) of the Act, which stipulates a cooling off period of six months which is also a period of locus poenitentiae, after filing a petition of divorce under Section 13B(1) of the Act, so as to give an opportunity to the parties to rethink over the decision and thereafter, to confirm their decision six months later, has made the said provision less rigid and more pro-litigants by bearing in mind the changed circumstances and peculiarities of the case. Nevertheless, in the said case, it has been observed that the period of six months should be waived owing to the circumstances of the particular case, the exigencies of the situation and bearing in mind the interest of the parties so that justice would be subserved in the matter. In this regard, the Hon’ble Supreme Court has observed that the period mentioned in Section 13B(2) could be construed to be as directory and not mandatory and it would be open to the Court to exercise its discretion in the facts and circumstances of each case, where there are no possibilities of parties to reconcile, cohabit and there are no chances of alternative rehabilitation.</h4><h4 style=\"text-align: justify;\">18. A reading of the above would clearly indicate that the Hon’ble Supreme Court has also made it flexible in the context of representation of the parties by their close relatives, partners or siblings or any other person in whom they have complete trust to be appointed as a Power of Attorney holder. In fact, as already noted, the Court can always satisfy itself about the genuineness of the intention of the parties who approach the Court either by themselves or through a Power of Attorney holder by way of video conferencing, so that any doubts about the genuineness of the petition being filed before the Court is removed.</h4><h4 style=\"text-align: justify;\">19. On a perusal of the aforesaid observations of the Hon’ble Supreme Court, it is clearly permissible for the parties to be represented by their partners or siblings in a proceeding filed under Section 13B(1) of the Act or any other similar provision in any other enactment, which provides for dissolution of marriage by a decree of divorce by mutual consent.</h4><h4 style=\"text-align: justify;\">20… Moreover, for the sake of satisfying and genuineness of the petition, the Family Court could always resort to video conferencing through the medium of which, both the parties could appear apart from the Power of Attorney holder of the second appellant appearing for her, so as to completely satisfy itself about the genuineness of the petition filed by the parties just as presently in this appeal, the appellants have both appeared through video conferencing, first appellant from Bengaluru and the second appellant from Toranto, Canada.</h4><h4 style=\"text-align: justify;\">26. Permission is granted to the second appellant to be represented through her Power of Attorney holder, who is none other than her father on the strength of the Special Power of Attorney executed by her.</h4><h4 style=\"text-align: justify;\">27. Further, in order to satisfy itself, the Family Court is at liberty to direct the parties especially the second appellant to appear through video conference or skype, before the Court and if such a direction is issued, the second appellant shall comply with the said direction.</h4><h4 style=\"text-align: justify;\">Judgments cited/relied on: </h4><h4 style=\"text-align: justify;\">Komal S. Padukone vs. Principal Judge, Family Court [ILR 1999 KAR 2811], </h4><h4 style=\"text-align: justify;\">Harshada Bharat Deshmukh vs. Bharat Appasaheb Deshmukh [AIR 2018 Bombay 148], </h4><h4 style=\"text-align: justify;\">Sudha Ramalingam vs. Registrar General, High Court of Judicature at Madras [AIR 2015 (NOC) 266 (MAD)], </h4><h4 style=\"text-align: justify;\">Kunhi Purayil Mukundan Naveen vs. Anjalika Dinesh [AIR 2011 (KER) 186], </h4><h4 style=\"text-align: justify;\">Dasam Vijay Rama Rao vs. M.Sai Sri [ALD-2015-4-757], </h4><h4 style=\"text-align: justify;\">Amardeep Singh vs. Harveen Kaur [(2017) 8 SCC 746], </h4><h4 style=\"text-align: justify;\">Komal S. Padukone vs. Principal Judge, Family Court at Bangalore City [ILR 1999 KAR 2811], </h4><h4 style=\"text-align: justify;\">Harshada Bharat Deshmukh vs. Bharat Appasaheb Deshmukh [AIR 2018 Bombay 148], </h4><h4 style=\"text-align: justify;\">Sudha Ramalingam vs. Registrar General, High Court of Judicature at Madras [AIR 2015 (NOC) 266 (MAD.)], </h4><h4 style=\"text-align: justify;\">Dasam Vijay Rama Rao vs. M.Sai Sri [ALD-2015-4-757].</h4><h4 style=\"text-align: justify;\"><br></h4><h4 style=\"text-align: justify;\"><br></h4>', '9d7a80e3fe8ff4763954442dffab0baf.PNG', '258799343ade26b4f083a5f5e03ca2ce.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-10', 1, '', '', '2020-12-06 05:39:56', '2021-08-22 00:17:20'),
(129, 'sUGsyKQOarZB6QzVL7TIO0Jkh', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'MMDR Act Offences causing serious ecological imbalance must be met with stringent actions. ', '<h4><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">MMDR Act. Offences causing serious ecological imbalance must be met with stringent actions. Mere compounding not enough. Supreme Court.Jayant Etc. vs The State of Madhya Pradesh. Criminal Appeal 824-825/2020 decided on 3 December 2020.</b></div><br><b>Judgment Link: </b></h4><h4><a href=\"https://main.sci.gov.in/supremecourt/2020/12111/12111_2020_34_1502_24918_Judgement_03-Dec-2020.pdf\" target=\"_blank\">https://main.sci.gov.in/supremecourt/2020/12111/12111_2020_34_1502_24918_Judgement_03-Dec-2020.pdf</a></h4><h4><br><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">Relevant Paragraphs:&nbsp;</b></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">11. Now so far as the submission on behalf of the private appellants ­violators that in view of the fact that violators were penalty determined by the appropriate authority forcompounding the offences/violations, there cannot be any</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">further criminal proceedings for the offences under Sections 379 and 414 IPC and Sections 4/21 of the MMDR Act and the reliance placed on Section 23A of the MMDR Act is concerned, it is true that in the present case the appropriate authority determined the penalty under Rule 53 of the 1996 Rules/Rule 18 of the 2006 Rules, which the private appellants ­violators paid and therefore the bar contained in sub­section 2 of Section 23A of the MMDR Act will be attracted. Section 23A as it stands today has been brought on the Statute in the year 1972 on the recommendations of the Mineral Advisory Board which provides that any offence punishable under the MMDR Act or any rule made thereunder may, either before or after the institution of the prosecution, be compounded by the person authorised under section 22 to make a complaint to the court with respect to that offence, on payment to that person, for credit to the Government, of such sum as that person may specify. Sub­section 2 of Section 23A further provides that where an offence is compounded under sub­section (1), no proceeding or further proceeding, as the case may be, shall be taken against the permitted to compound the violation in exercise of powers under Rule 53 of the 1996 Rules or Rule 18 of the 2006 Rules and the violators accepted the decision and deposited the amount of penalty determined by the appropriate authority for compounding the offences/violations, there cannot be any further criminal proceedings for the offences under Sections 379 and 414 IPC and Sections 4/21 of the MMDR Act and the reliance placed on Section 23A of the MMDR Act is concerned, it is true that in the present case the appropriate authority determined the penalty under Rule 53 of the 1996 Rules/Rule 18 of the 2006 Rules, which the private </span>appellants violators<span style=\"font-size: 1.3125rem;\">&nbsp;paid&nbsp;</span><span style=\"font-size: 1.3125rem;\">and therefore the bar contained in sub­section 2 of Section 23A of the MMDR Act will be attracted. However, our above conclusions are considering the provisions of Section 23A of the MMDR Act, as it stands today. It might be true that by permitting the violators to compound the offences under the MMDR Act or the rules made thereunder, the&nbsp;</span><span style=\"font-size: 1.3125rem;\">State may get the revenue and the same shall be on the principle of person who causes the damage shall have to compensate the damage and shall have to pay the penalty like the principle of polluters to pay in case of damage to the environment. However, in view of the large scale damages being caused to the nature and as observed and held by this Court in the case of Sanjay (supra), the policy and object of MMDR Act and Rules are the result of an&nbsp;</span><span style=\"font-size: 1.3125rem;\">increasing awareness of the compelling need to restore the serious ecological imbalance and to stop the damages being caused to the nature and considering the observations made by this Court in the aforesaid decision, reproduced hereinabove, and when the violations like this are increasing and the serious damage is caused to the nature and the earth and it also affects the ground water levels etc. and it causes severe damage as observed by this Court in the case of Sanjay (supra), reproduced hereinabove, we are of the opinion that the violators cannot be&nbsp;</span><span style=\"font-size: 1.3125rem;\">permitted to go scot free on payment of penalty only. There must be some stringent provisions which may have deterrent effect so that the violators may think twice before committing such offences and before causing damage to the earth and the nature. It is the duty cast upon the State to restore the ecological imbalance and to stop damages being caused to the nature. As observed by this Court in the case of Sanjay (supra), excessive instream sand ­and ­gravel mining from river beds and like resources causes the degradation of rivers. It is further observed that apart&nbsp;</span><span style=\"font-size: 1.3125rem;\">from threatening bridges, sand mining transforms the riverbeds into large and deep pits, as a result, the groundwater table drops leaving the drinking water wells on the embankments of these rivers dry. Even otherwise, sand/mines is a public property and the State is the custodian of the said public property and therefore the State should be more sensitive to protect the environment and ecological balance and to protect the public property the State should always be in favour of taking very stern action against the violators who are creating serious ecological&nbsp;</span><span style=\"font-size: 1.3125rem;\">imbalance and causing damages to the nature in any form. As the provisions of Section 23A are not under challenge and Section 23A of the MMDR Act so long as it stands, we leave the matter there and leave it to the wisdom of the legislatures and the concerned States.</span></div></h4><h4><div style=\"text-align: justify;\"><b><br></b></div><span style=\"font-size: 1.3125rem;\"><b>Compiled by S. Basavaraj, Advocate, Daksha Legal, Bengaluru</b></span><br></h4>', '8db76a722db42871176784c7d4a8200b.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-03', 1, '', '', '2020-12-06 04:25:21', '2021-01-21 21:54:47'),
(130, 'zU5eGhYrkd2aaVUzlednXrVeS', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'NDPS Act, Detention of accused beyond 180 days must satisfy condition', '<h4>NDPS Act, 1985. Detention of accused beyond 180 days must satisfy two conditions – reporting progress of investigation and specific reason for detention beyond 180 days. Mere application for extension of time is not enough. Karnataka High Court.<br>Magoola John vs State of Karnataka. Criminal Petition 5935/2020 decided on 26 November 2020.<br><br><b>Judgment Link: </b></h4><h4><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350690/1/CRLP5935-20-26-11-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350690/1/CRLP5935-20-26-11-2020.pdf</a></h4><h4><br><b>Relevant paragraphs: </b><br><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">11.Be that as it may. Even as could be seen from Section 36(A)(4) proviso indicates that if any person has been charged for the offence under the said Act for the purpose of filing of the charge sheet is 180 days time has been provided. Proviso to the said Section enables the Investigating Agency, if within 180 days if it is not possible to complete the investigation, then it can move the application before the Special Court for extension of&nbsp; the said period up to one year. But in order to file an&nbsp; application it has to fulfill two conditions. The first&nbsp; condition is that the prosecution has to indicate the progress of the investigation made till that date and the second condition is the specific reason for detention of the accused beyond the said period of 180 days. But&nbsp; on&nbsp; perusal of the application filed by the learned Public Prosecutor, no such reasons have been assigned except stating that, for the purpose of filing of the charge sheet, FSL report is an important document and when the charge sheet cannot filed and the FSL report has also not come, as such 180 days has to be extended.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">12. Be that as it may. Even as could be seen from the records, the said application has been filed&nbsp; on&nbsp; 4.9.2020 and immediately thereafter the Court has issued the notice to the accused for his reply and the order sheet indicates that he has filed his objections to the said application on 9.9.2020 and even at that time also no order has been passed by the trial Court either extending the time&nbsp; or&nbsp; giving any reasons on the application filed under Section 167(2) of Cr.P.C. When the time of 180 days is going to be expired on 6.9.2020, before that or on the same day, the Court could have passed an order either extending of time&nbsp; or otherwise. When an application has been filed for the purpose of extension of time on 4.9.2020 and the accused was admittedly in judicial custody, the trial Court ought to have taken into consideration the statutory right&nbsp; available to the accused and it could have been expedited on&nbsp; or before 6.9.2020. When the Court has not exercised its power on the application filed under Section 36(A)(4) of NDPS Act for extension, then the statutory right which has been there to the accused accrues immediately after 180 days and if an application has been filed by the accused&nbsp; and if it is pending, then the right will be there to get him released on bail.</span></div></h4><h4><span style=\"font-size: 1.3125rem;\"><br><b>Compiled by S. Basavaraj, Advocate, Daksha Legal</b></span><br></h4>', '71523184420aedb4e8046e62b3a2f695.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-11-26', 1, '', '', '2020-12-06 04:36:30', '2021-01-21 17:16:25'),
(153, 'NwvGcCfeb9mKryG5nCk4vzI5c', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Specific Relief Act. Section 28. Executing Court can rescind the agreement of sale and anull the decree for specific performance', '<h3>Specific Relief Act. Section 28. Executing Court can rescind the agreement of sale and anull the decree for specific performance- Karnataka High Court.</h3><h4><br>Specific Relief Act, 1963 – Section 28(1) – Rescission of Contract – Parameters – Sale Agreement annulled at execution stage.T.L. Rajagopal v. S.N. Shivakumar, 2014 SCC OnLine Kar 10072 : ILR 2014 KAR 4035 : (2014) 3 KCCR 2182 : (2014) 4 AIR Kant R 701 : (2014) 6 Kant LJ 423 : (2014) 4 ICC 275 : AIR 2015 (NOC 433) 160, at page 4052 :</h4><h4><br><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">HELD: </b><span style=\"font-size: 1.3125rem;\">Decree for specific performance being in the nature of a preliminary decree, the Court after passing of the said decree does not become functus officio. It retains the jurisdiction to conclude the further steps to be taken in the suit. The decree holder chooses to file an execution petition for getting the sale deed registered through the Court when the defendant who suffered the decree fails to obey the same. Though called ‘execution proceedings’, it is nothing but continuation of the original suit. In a suit for partition, after the preliminary decree is passed, to give effect to the preliminary decree, it is necessary to initiate final decree proceedings. But in a suit for specific performance it is called as ‘execution proceedings’. Thus when the Court that passed the decree for specific performance and the Court executing the said decree are one and the same, Section 28 of the Act gives equal opportunity to the parties to the suit. If the plaintiff/decree holder for any reason is unable to deposit the balance sale consideration, he is given a right to apply to the Court that passed the decree seeking extension of time to deposit the money and the Court is vested with the power to grant such extension. At the same time when the plaintiff commits default in making payment, a right is conferred upon the defendant/judgment debtor to approach the Court under Section 28 of the Act seeking rescission of the contract. Here again the Court has the discretion to rescind the contract notwithstanding the fact that the decree has attained finality.</span></div></h4><h4><br><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">Judgment</b><span style=\"font-size: 1.3125rem;\">:</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">KUMAR, J.:— This writ petition is preferred by the defendant/judgment debtor challenging the order passed by the Executing Court dismissing his application under Section 28(1) of the Specific Relief Act, 1963 (Hereinafter referred to as ‘The Act’ for short).</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">2. For the purpose of convenience, the parties are referred as per their original rank in the suit.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">3. The plaintiff filed a suit for a decree of specific performance of the agreement of sale dated 16.08.1997 against the defendant alleging that the defendant had agreed to sell the schedule property in his favour for Rs. 4,60,000/-. Under the said agreement a sum of Rs. 1,75,000/- was paid as advance by him. The balance sale consideration of Rs. 2,85,000/- had to be paid at the time of registration of the sale deed. He was constrained to file the suit when the defendant failed to execute the sale deed in his favour as agreed. Though duly served with the suit summons, the defendant did not contest the suit and therefore, the decree came to be passed on 26.03.2003 directing the defendant to receive the balance sale consideration from the plaintiff and to execute the registered sale deed failing which he was reserved the liberty of taking steps to get the sale deed executed and registered through the Court Commissioner by depositing the balance sale consideration amount after the appeal time is over.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">4. After the decree, the plaintiff issued a notice to the defendant expressing his readiness to pay the balance sale consideration and called upon the defendant to receive the consideration and execute the sale deed. The defendant did not oblige. Therefore, the plaintiff filed Ex. No. 34/2003 to execute the decree.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">5. The record shows that the judgment debtor/defendant, to stall the execution proceedings not only filed an application under Order XXI Rule 97 of CPC but also got filed another application under the same provision through his daughter-in-law. However these applications came to be dismissed by the Executing Court. Thereafter, the defendant/judgment Debtor filed I.A. 7 under Section 28 of the Act on 08.03.2011 for rescission of the contract and dismissal of the execution petition.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">6. It is the defendant/judgment debtor’s case that the suit came to be decreed exparte on 26.03.2003 and the time to file an appeal against the exparte decree expired on 25.04.2003. The decree is silent as to the outer limit within which the plaintiff should deposit the balance sale consideration from 25.04.2003 and therefore the exparte decree passed in favour of the plaintiff/decree holder is a nullity being contrary to the provisions of Section 28 of the Act. Further the decree holder has not deposited the balance amount till date and therefore, the alleged contract of sale agreement needs to be rescinded and cancelled in the interest of justice and equity. The decree is not executable. The plaintiff/decree holder filed objections to I.A. 7 and sought its dismissal contending that since the defendant/Judgment Debtor failed to comply with the decree, he initiated the execution proceedings well in time and the question of depositing the amount would arise only at the time of the execution of the registered sale deed.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">7. The executing Court, after considering the rival contentions and taking note of the decisions relied on by the parties, has dismissed the I.A. holding that no time limit is prescribed in the decree for depositing the balance sale consideration, by the plaintiff. After passing of the decree, the decree holder has filed the execution case only after issuing notice to the judgment debtor stating that he is ready with the balance sale consideration. The defendant did not reply to the notice nor came forward to comply with the decree. Nor has the judgment debtor filed any appeal against the exparte judgment and decree. On the other hand, he got an application filed through his son seeking stay of the further proceedings in the execution petition and another application through one Parvathi under Order XXI Rule 97 of CPC to stall the execution of the proceedings. The Decree holder in fact has deposited the balance sale consideration in the Court on 14.07.2011. The judgment debtor has not come to the Court with clean hands and therefore he is not entitled to the discretionary relief.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">8. The present writ petition is filed against the above order passed by the executing Court.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">9. Learned Counsel for the defendant/judgment Debtor assailing the impugned order argued that, under the terms of the decree, the plaintiff was expected to deposit the balance sale consideration after expiration of the time prescribed for filing an appeal and therefore, the executing Court could not have held that no time is fixed for payment of the sale consideration. Secondly, it was argued that even after filing of the execution petition, balance sale consideration was not deposited and it was deposited only after the Judgment debtor filed I.A. 7 under Section 28 of the Act. The plaintiff/decree holder had not even filed an application seeking extension of time to deposit the balance sale consideration. The decree is dated 26.03.2003 and the balance sale consideration is deposited nearly 8 years thereafter i.e., on 14.07.2011. In view of these circumstances, it was urged that the agreement entered into by the parties is to be rescinded in terms of Section 28 of the Act and execution petition be dismissed. :</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">10. Per contra, Learned Counsel for the plaintiff/decree holder arguing in support of the impugned order submitted that, as no time is fixed in the decree, the decree holder, after passing of the decree, issued notice expressing his readiness and willingness to pay the balance sale consideration and obtain the sale deed. When this request was not acceded to, the decree holder was constrained to file the execution petition within five months, which conduct clearly demonstrates that, he was ready to perform his part of the contract. The execution petition was stalled by the judgment debtor by filing applications after applications through his daughter-in-law as well as the son for which the decree holder cannot be blamed. In fact, the decree holder has deposited the amount on 14.07.2011. I.A. 7 is not maintainable on the execution side and it ought to have been filed in the original suit itself as is clear from the provisions of Section 28 of the Act.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">11. In the light of the aforesaid facts and rival contentions, the points that arise for my consideration in this writ petition are as under:—</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">1. Whether an application U/s. 28 of the Act is maintainable on the original side or in the execution proceedings initiated by the decree holder to execute the decree?</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">2. Whether the Judgment debtor has made out a case for rescission of the contract as provided U/s. 28 of the Act?</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">12. In order to answer the above questions, it is necessary to have a look at Section 28 of the Act which deals with rescission of contracts for sale or lease of immovable property in certain circumstances when already specific performance has been decreed by the Court. The said provision reads thus:—</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">“28. Rescission in certain circumstances of contracts for the sale or lease of immovable property, the specific performance of which has been decreed. —</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(1) Where in any suit a decree for specific performance of a contract for the sale or lease of immovable property has been made and the purchaser or lessee does not, within the period allowed by the decree or such further period as the court may allow, pay the purchase money or other sum which the court has ordered him to pay, the vendor or lessor may apply in the same suit in which the decree is made, to have the contract rescinded and on such application the court may, by order, rescind the contract either so far as regards the party in default or altogether, as the justice of the case may require.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(2) Where a contract is rescinded under subsection (1), the court:—</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(a) shall direct the purchaser or the lessee, if he has obtained possession of the property under the contract, to restore such possession to the vendor or lessor, and</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(b) may direct payment to the vendor or lessor of all the rents and profits which have accrued in respect of the property from the date on which possession was so obtained by the purchaser or lessee until restoration of possession to the vendor or lessor, and if the justice of the case so requires, the refund of any sum paid by the vendee or lessee as earnest money or deposit in connection with the contract.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(3) If the purchaser or lessee pays the purchase money or other sum which he is ordered to pay under the decree within the period referred to in sub-section (I), the court may, on application made in the same suit, award the purchaser or lessee such further relief as he may be entitled to, including in appropriate cases all or any of the following reliefs, namely:</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(a) the execution of a proper conveyance or lease by the vendor or lessor;</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(b) the delivery of possession, or partition and separate possession, of the property on the execution of such conveyance or lease.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(4) No separate suit in respect of any relief which may be claimed under this section shall lie at the instance of a vendor, purchaser, lessor or lessee, as the case may be.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">(5) The costs of any proceedings under this section shall be in the discretion of the court.”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">13. Therefore, to invoke the above provision, the person who has obtained a decree for specific performance ought to have failed to pay the money or other sum which the Court has ordered him to pay, within the period allowed by the decree or such further period as the Court may allow. In such an event the person who has suffered the decree has a right to apply to the Court in the same suit in which the decree was passed to have the contract rescinded. On such an application being made, the Court may by order rescind the contract either so far as regards the party in default or altogether, as the justice of the case may require. Once such an order for rescission of contract is made, the Court shall direct the purchaser or the lessee, if, he has obtained the possession of the property under the contract, to restore such possession to the vendor or lessor and also may direct payment to the vendor or lessor to pay the rents and profits which have accrued in respect of the property from the date on which the possession was obtained by the purchaser or lessee until restoration of possession to any vendor or lessor, and if the justice of the case so requires, the refund of any sum paid by the vendee or lessee or earnest money or deposit in connection with the contract.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">14. The question whether an application under Section 28 of the Act is to be made in the same suit in which the decree is passed, has been the subject matter of interpretation by various High Courts in the country. In view of divergent opinion expressed by various High Courts, the Apex Court had an occasion to consider the same in the case of Ramankutty v. Avara1 where in para 6 it is held as under.“6. The question then emerges is whether it should be on the original side or execution side. Section indicates that it should be “in the same suit”. It would obviously mean in the suit itself and not in the execution proceedings. It is equally settled law that after passing the decree for specific performance, the Court does not cease to have any jurisdiction. The court retains control over the decree even after the decree has been passed. It was open to the court to exercise the power under Section 28(1) of the Act either for extension of time or for rescinding the contract as claimed for. Since the execution application has been filed in the same court in which the original suit was filed, namely, the court of first instance, instead of treating the application on the execution side, it should have as well been numbered as an interlocutory application on the original side and disposed of according to law. In this view, we feel that the Andhra Pradesh High Court is not correct. The High Court, therefore, is not right in dismissing the application treating of transferring it on the original side for dealing with it according to law.”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">15. The Apex Court in the case of V.S. Plalanichamy Chettiar Firm v. C. Alagappan2 has reiterated above position of law in para 16 of the judgment:“16. In view of the decision of this Court in Ramankutty Guptan’s case (1994) AIR SCW 1533) when the trial Court and the executing Court are same, executing Court can entertain the application for extension of time though the application is to be treated as one filed in the main suit. On the same analogy, the vendor judgment—holder can also seek rescission of the contract of sale or take up this plea in defence to bar the execution of decree. One of the ground on which the trial Court dismissed the execution application was that the decree holder did not pay the balance of consideration as per the sale agreement and also did not pay within the time stipulated by the Court in the decree.”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">16. Again in the case of Chanda (Dead) through LRs. v. Rattni3. at para 10 the Apex Court has held that:“10. The decree for specific performance has been described as a preliminary decree. The power under Section 28 of the Act is discretionary and the Court cannot ordinarily annul the decree once passed by it. Although the power to annul the decree exists yet Section 28 of the Act provides for complete relief to both the parties in terms of the decree. The Court does not cease to have the power to extend the time though the trial Court had earlier directed in the decree that payment of balance price to be made by certain date and on failure suit to stand dismissed. The power exercisable under this Section is discretionary.”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">17. In the light of the ratio laid down in the aforementioned judgments, the law on the point can be said to be fairly settled: A decree for specific performance being in the nature of a preliminary decree, the Court after passing of the said decree does not become functus officio. It retains the jurisdiction to conclude the further steps to be taken in the suit. The decree holder chooses to file an execution petition for getting the sale deed registered through the Court when the defendant who suffered the decree fails to obey the same. Though called ‘execution proceedings’, it is nothing but continuation of the original suit. In a suit for partition, after the preliminary decree is passed, to give effect to the preliminary decree, it is necessary to initiate final decree proceedings. But in a suit for specific performance it is called as ‘execution proceedings’. Thus when the Court that passed the decree for specific performance and the Court executing the said decree are one and the same, Section 28 of the Act gives equal opportunity to the parties to the suit. If the plaintiff/decree holder for any reason is unable to deposit the balance sale consideration, he is given a right to apply to the Court that passed the decree seeking extension of time to deposit the money and the Court is vested with the power to grant such extension. At the same time when the plaintiff commits default in making payment, a right is conferred upon the defendant/judgment debtor to approach the Court under Section 28 of the Act seeking rescission of the contract. Here again the Court has the discretion to rescind the contract notwithstanding the fact that the decree has attained finality.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">18. Specific performance being a discretionary relief, the Court has ample power to do justice between the parties, if anyone of them were to not act in terms of the decree. As such the contention that an application under Section 28 of the Act ought to be filed in the suit and not in execution proceedings cannot be accepted. I.A. 7 filed under Section 28 of the Act by the defendant/judgment debtor in the execution proceedings seeking rescission of contract therefore is perfectly maintainable and it is to be treated as an interlocutory application filed in the suit for specific performance itself.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">19. Admittedly, the defendant/judgment debtor was duly served with the summons in the suit for Specific Performance. He appeared through an Advocate, sought for time but did not file the written statement or participate in the proceedings. Therefore, the suit of the plaintiff/decree holder came to be decreed exparte and the operative portion of judgment of the Trial Court reads as under:—“The suit is decreed with costs.The defendant is directed to receive balance sale consideration of Rs. 2,85,000-00 from the plaintiff and to execute and register the sale deed in favour of the plaintiff at his costs in pursuance of the sale agreement dated 16.08.1997 with respect to suit property.Failure on the part of the defendant to execute the sale deed the plaintiff is at liberty to take steps to get the sale deed executed and registered through the Court Commissioner by depositing the balance sale consideration amount after the appeal time is over.”(Underlining by me)</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">20. What the plaintiff has to do if the defendant were to not obey the decree passed by the Court is therefore, clearly spelt out in the judgment of the Trial Court. The plaintiff was given the liberty to take steps to get the sale deed executed and registered through the Court by depositing the balance sale consideration after the time prescribed for filing the appeal expired. In other words, the plaintiff had to deposit the balance sale consideration only after expiry of the appeal period.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">21. The judgment and decree was delivered on 26.03.2003 and an appeal against the said decree ought to have been filed within 30 days, but the defendant admittedly has not chosen to file any appeal. After expiry of the appeal period, without depositing the balance consideration in Court, the plaintiff issued a legal notice calling upon the defendant to receive the balance sale consideration and execute the sale deed. The defendant did not reply. Then the execution proceedings came to be initiated. The balance consideration was not deposited either before or along with the execution petition.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">22. The Judgment debtor/defendant entered appearance, in the execution case. Then he filed I.A. 7 under Section 28(1) of the Act seeking rescission of the contract on the ground of non-deposit of the amount in terms of the decree. Thereafter, the balance sale consideration came to be deposited on 14.07.2011 by the decree holder. The plaintiff/decree holder was expected to file an application under Section 28(1) of the Act seeking extension of time to deposit the amount by showing sufficient cause for the lapse on his part. Till date no such application is filed by the plaintiff/decree holder.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">23. If the defendant was at fault, he was not willing to obey the decree, if the plaintiff had deposited the money after the expiry of the appeal period as stipulated in the decree or at least on the day he filed the execution petition, that would have been sufficient to demonstrate his bona fides. The balance sale consideration of Rs. 2,85,000/- had to be deposited on the date of the suit or the date of the decree or at least on the date of filing of the execution petition. But the plaintiff/decree holder appears to have woken up after seeing the averments in I.A. under Section 28 of the Act and made up his mind to deposit the money on 14.07.2011 which is nearly 8 years after the passing of the decree and 14 years from the date of the agreement.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">24. The subject matter of the suit is an immovable property situated in Tiptur Town. The value of the immovable properties situated in towns and cities is multiplying every year. The plaintiff/decree holder who had the benefit of the decree also had the benefit of having Rs. 2,85,000/- with him for 14 long years and did not even seek extension of time to deposit the said amount. Today if the Court were to direct the defendant/judgment debtor to execute the sale deed for a consideration which he should have received 14 years ago, it would cause great hardship and irreparable injury, as the said amount would be of no value at all. In that view of the matter, the contract of sale requires to be rescinded and consequently, the decree for specific performance also requires to be annulled.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">25. Where a contract is rescinded under sub-Section (1) of Section 28 of the Act, if the justice of the case so requires, the Court can as provided under Section 28 (2)(b) of the Act order for refund of any sum paid by the vendee or lessee as earnest money or deposit in connection with the contract. Similarly Section 65 of the Contract Act, 1872 also casts an obligation on the person who has received an advantage under void agreement or contract that becomes void, to restore it or make compensation for it, to the person from whom he received it. Therefore the defendant/judgment debtor shall refund the advantage/earnest money received from the plaintiff/decree holder under the agreement i.e., a sum for Rs. 1,75,000/- together with interest @ 18% p.a. from the date of receipt of amount till the date of payment, if he wants the rescission of the contract.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">26. In the result I pass the following:</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">ORDERThe writ petition is allowed. The impugned order is hereby set-aside and I.A. filed under Section 28 of the Specific Relief Act is allowed.The agreement of sale dated 16.08.1997 is rescinded and the decree for specific performance dated 26.03.2003 is annulled subject to the condition that the defendant/judgment debtor shall refund earnest money of Rs. 1,75,000/- received under the agreement to the plaintiff/decree holder with interest @ 18% p.a. from the date of receipt of the said amount till the date of payment, within three months from this day.In the event of the defendant/judgment debtor failing to pay the amount to the plaintiff/decree holder or deposit the same in the Court within 3 months from the date of receipt of this order, the order of this Court rescinding the agreement stands vacated and order of the executing Court on I.A. 7 stands restored.———</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">1. (1994) 2 SCC 642 : AIR 1994 SC 16992. (1999) 4 SCC 702 : AIR 1999 SC 9183. (2007) 14 SCC 26 : AIR 2007 SC 1514</span></div></h4>', 'bc68711d537bfadd3b98e53515350f25.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-10-01', 1, '', '', '2020-12-07 03:02:28', '2021-01-20 23:26:33');
INSERT INTO `judgements` (`judgement_id`, `judgement_key`, `judgement_category_key`, `judgement_title`, `judgement_desc`, `judgement_img`, `judgement_attachment`, `judgement_author`, `judgement_date`, `judgement_status`, `judgement_bookmark`, `judgement_like`, `judgement_date_added`, `judgement_date_updated`) VALUES
(131, '89gfIoXBRwkVoaz4JFaBRSS4p', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Motor Vehicle Act Insurance policy commences from the time of making payment and not from issuance of policy', '<h4>Motor Vehicle Act. Insurance policy commences from the time of making payment and not from issuance of policy. In the absence of contract fixing time, policy commences from 00.00 hours midnight (next day). Karnataka High Court.</h4><h4><br>Sudharshan vs Subash and another. Miscellaneous First Appeal 31894/2012 decided on 2 December 2020.</h4><h4><br><b>Judgment Link: </b></h4><h4><a href=\"http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350758/1/MFA31894-12-02-12-2020.pdf\" target=\"_blank\">http://judgmenthck.kar.nic.in/judgmentsdsp/bitstream/123456789/350758/1/MFA31894-12-02-12-2020.pdf</a></h4><h4><br><div style=\"text-align: justify;\"><b style=\"font-size: 1.3125rem;\">Relevant Paragraphs:</b><span style=\"font-size: 1.3125rem;\">&nbsp;</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">25. Therefore, as per Section 64VB of the Act above stated, the provision is very clear that soon after the receipt of the payment of premium by the owner and received by the Insurance Company then the contract of insurance begins between them. Issuance of policy is consequent effect after receipt of premium. If there is a specific contract is made between the insurer and the insured that the risk is to be covered from that point of time itself is concerned, then that shall be specifically stated in the Insurance Policy and it is a specific contract between the insurer and insured so far as time of commencement of risk. If there is no specific contract stating to cover the risk from that particular point of time then generally in the Insurance Policy it is stated that the Insurance Policy commences from 00.00 hours by&nbsp; mentioning&nbsp; the&nbsp; next&nbsp; day&nbsp; date&nbsp; commencing&nbsp; from 00.00 hours (mid night) on next date. Therefore, where there is no specific contract of mentioning time between insurer and insured regarding mentioning of time so as to cover the risk then generally the policy commences from 00.00 hours (mid night) by mentioning the date of the next day. In absence of mentioning specific time of commencement of covering risk, therefore upon considering this and applying the&nbsp; same in&nbsp; the&nbsp; present facts and circumstances and by following the legal provision enshrined under Section 64VB of the Act it can be safely held that from the time of making payment of premium itself covering risk starts.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">Cases referred: Yellamma vs.&nbsp; Bhy Sukhadev Singh&nbsp; and another [2006 (3)&nbsp; KCCR 1842], Oriental Insurance Co.Ltd., v. Dharam Chand and others [2011 Kant, M.A.C.138 (SC)], National Insurance Co.Ltd., v. Smt.Bhadramma&nbsp; and&nbsp; others [ILR 2009 KAR 3332], Sunita Rati’s case&nbsp; [AIR&nbsp; 1998&nbsp; SC&nbsp; 257], New India Insurance Company v. Bhagwati Devi and others [(1998) 6 Supreme Court Cases 534], National Insurance Co. Ltd. v. Jikubkai Nathuji Dabhi, [(1997) 1 SCC 66], National Insurance Co.Ltd., v. Sobina Iakai and others [2007 (3) T.A.C.&nbsp; 19 (S.C)], New India Assurance Co.Ltd., v. Harshadbhai Amrutbhai Modhiya and another [(2006) 5 Supreme Court Cases&nbsp; 192], New India Assurance Co.Ltd., vs. C.M.Jaya and others [AIR 2002 SC 651]</span></div><br><b>Compiled by S. Basavaraj, Advocate, Daksha Legal.</b></h4>', '5f290f551aeeb6d1843421c5ac749c0a.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-02', 1, '', '', '2020-12-06 04:38:39', '2021-01-21 01:37:10'),
(132, 'VzbBse4PKDTviqTPTzoIM7DGk', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Service Law. Employee of a Gram Panchayat cannot be removed on acts of misconduct without enquiry. Karnataka High Court.', '<h4 style=\"text-align: justify; \"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1.3125rem; -webkit-tap-highlight-color: transparent; -webkit-text-size-adjust: 100%;\">S.K. Shankarappa vs The Panchayath Development Officer and another.&nbsp;</span></h4><h4 style=\"text-align: justify; \"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1.3125rem; -webkit-tap-highlight-color: transparent; -webkit-text-size-adjust: 100%;\">Writ Petition 48068/2018 decided on 21 October 2020.</span></h4><h4 style=\"text-align: justify; \"><span style=\"font-family: var(--bs-font-sans-serif); font-size: 1.3125rem; -webkit-tap-highlight-color: transparent; -webkit-text-size-adjust: 100%;\">Justice M. Nagaprasanna.<br></span></h4><h4><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">8…“Whether a permanent employee of the Panchayat can be removed on acts of misconduct without holding a departmental enquiry?”</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">12 &amp; 13. Sections 113 (3) of the Karnataka Gram Swaraj and Panchayat Raj Act, 1993 noticed. The afore-extracted provision of law, no doubt empowers the Gram Panchayat to reduce in rank, remove or dismiss any employee appointed by it. But this cannot clothe the Gram Panchayat with the power to remove a permanent employee on grounds of misconduct, without holding an enquiry and giving reasonable opportunity to defend himself as the allegations made would remain allegations until it is substantiated by a process known to law failing which, it would amount to removal of an employee on the basis of suspicion.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">14. It is trite law that any amount of suspicion cannot take the place of proof and proof can be arrived at only if a procedure to arrive at is followed. Thus, conduct of a departmental enquiry in the wake of the allegations of misconduct is mandatory and cannot be obviated or circumvented in any manner.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">15. Though the employee of a Gram Panchayat is not a civil servant in its true sense and would not get the protection of Article 311(2) of the Constitution of India nonetheless, a Gram Panchayat being a State under Article 12 of the Constitution of India and is bound by the rigors of Article 14 of the Constitution of India.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">16. Therefore, even if a provision bestows power upon the employer to remove an employee for misconduct under any statute without holding an enquiry, natural justice and reasonable opportunity of defence will have to be read into such statutes failing which, the very exercise of such power and the manner of its exercise becomes blatantly arbitrary. More so, when an action under the statute is likely to result in loss of livelihood or cast a stigma on such employee. If the aforesaid interpretation is not given to such statutes, it would be giving absolute, unbridled and unguided power to the employer to dismiss an employee which would not stand the test of Article 14 of the Constitution of India.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">17. An instrumentality, agency or any other authority under Article 12 of the Constitution of India must act fairly, justly and reasonably as fair treatment is an essential inbuilt of principles of natural justice. It is apposite to quote the words of the Apex Court “reasonableness and non-arbitrariness pervades the entire constitutional spectrum and is a golden thread which runs through the whole fabric of the Constitution of India”. Therefore, any act of unreasonableness or unfair treatment will fall foul of the rigors of Article 14 of the Constitution of India.</span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\"><br></span></div><div style=\"text-align: justify;\"><span style=\"font-size: 1.3125rem;\">Writ Petition allowed.</span></div></h4>', 'bc9c6403e47e349121c25b7d360a69bb.jpeg', '03d14f28e874f4d71e116c4c39d8ecc4.pdf', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2023-01-21', 1, '', '', '2020-12-06 04:41:27', '2023-01-10 17:12:13'),
(2553, '0A1TaJ32cV7aTS49HeJNkIbGq', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Manufacture of Ethanol using sugarcane juice, sugar or sugar syrup is a sugar factory as defined under Clause 2(c) of the Sugarcane (Control) Order, 1966. Karnataka High Court. ', '<p class=\"MsoNormal\" style=\"margin: 0cm; font-size: 12pt; font-family: Calibri, sans-serif;\"><span la