
-- --------------------------------------------------------

--
-- Table structure for table `article`
--

DROP TABLE IF EXISTS `article`;
CREATE TABLE IF NOT EXISTS `article` (
  `article_id` int NOT NULL AUTO_INCREMENT,
  `article_key` varchar(255) NOT NULL,
  `category_key` varchar(255) NOT NULL,
  `article_title` text NOT NULL,
  `article_description` text NOT NULL,
  `article_image` varchar(255) NOT NULL,
  `article_attachment` varchar(255) DEFAULT NULL,
  `article_author` varchar(255) NOT NULL DEFAULT 'GawtOCEN1d5N6m7YcGG3NfK6L',
  `article_date` varchar(100) NOT NULL,
  `article_status` tinyint NOT NULL DEFAULT '0',
  `article_bookmark` text,
  `article_like` text,
  `article_date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `article_date_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM AUTO_INCREMENT=478 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `article`
--

INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(28, '1AkjVaZo8B4RcSXHmGaFk1VTP', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Fashion Apparel Law.  Mahima Dhanhem Advocate', '&lt;h4 style=&quot;margin-bottom: 8px; font-family: &quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;INTRODUCTION&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Fashion is a billion-dollar industry in different countries including the United States of America and India. It is a globalized industry and accounts for two percent (2%) of the world&rsquo;s Gross Domestic Product (GDP). Fashion is one of the world&rsquo;s most creative and inventive industries around the world. Its major output of global business can be seen in the United States of America whose total profit is more than 200 billion dollars in a year.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Fashion industry is fragmented, fast paced and complex. Fashion houses annually, design, manufacture, showcase and sell spring/summer and autumn/winter collections. One of the main issues that a designer will face is that owing to the industry being extremely fast paced, there is often difficulty in protecting their designs from being replicated by rival designers or counterfeiters because of the short term around time between seasons. Fashion law (interchangeably referred to as law of fashion or apparel law) is a relatively new concept and is slowly emerging as a recognized and respected area of law in many jurisdictions.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Fashion law or Apparel law encompasses legal issues around the life cycle of a garment, brand protection, consumer advertising, commercial contracts and third-party collaboration. The rise of e-commerce, social media sites, digital fashion magazines, blogs and celebrity endorsements adds another layer of legal issue. Whether a stylist, reputable designer or fashion house; one should be equipped with the finest legal knowledge in order to benefit one&rsquo;s brand, ideas and business. In the field of legal realm and regime, the term fashion has been protected and secured under the shade of intellectual property.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;WHAT IS FASHION LAW?&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Susan Scafidi, one of the pioneering founders of Fashion law, puts forward the following explanation:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&ldquo;It is a field that embraces the legal substance of style including the issues that might arise throughout the life of a garment, starting with the designer&rsquo;s original idea and continuing all the way to the consumer&rsquo;s closet..&rdquo; A more comprehensive definition of fashion law consists of providing advice on intellectual property and commercial matters to fashion houses, designers, manufacturers, distributors, modeling agencies, retailers, and photographers. It covers everything from branding, protection, and enforcement of intellectual property rights to the non-contentious commercial side of the business, such as licensing, manufacturing, and distribution contracts and agency and franchising agreements.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;ORIGIN OF FASHION LAW&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Historically, sumptuary law, trade restrictions and aspects of intellectual property, have all played their part in regulating the fashion industry. Fashion law gained momentum when, in 2000, a University of Geneva thesis entitled &ldquo;Le Droit International de la Mode&rdquo; covering the subject matter of fashion law was published. Annabelle Gauberti (French lawyer) was instrumental in spearheading the publication of a supplement entitled &ldquo;Droit du luxe&rdquo; featured in the renowned French legal magazine &ldquo;Revue Lamy Droit Des Affaires&rdquo; in May 2004.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;In 2006, Susan Scafidi an American lawyer and legal scholar was the first professor to recognize the importance of fashion law as a distinct legal field and offer a formal course on fashion law at the Fordham law school in New York city. Scafidi is now also the founder and president of the fashion law institute, non-profit organization helping designers, fashion houses and models. In 2005, when her first website counterfeitchic.com was launched Scafidi discussed examples of originality and copying in fashion, as well as doing a cultural analysis of fashion design protection. Her work on cultural appropriation and comments on fashion law were published in such magazines as the New York times, The Wall Street journal, Time, Forbes and many others.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Subsequently fashion law courses were also introduced and offered to designers at the Fashion Law Institute of Technology and Parsons school of Design. In 2010, the world&rsquo;s first academic center of its kind (dedicated to fashion law), the Fashion Law Institute, launched with the support of the support of &ldquo;Council of Fashion Designers of America (CFDA)&rdquo;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;PIRACY IN FASHION INDUSTRY&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Fashion design piracy involves unauthorized copying of original fashion designs and such act can be classified into two categories:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Knockoffs: A knockoff is a close copy of original fashion designs, mimicking its elements, but is sold under a label different from the label of the original design. Thus, it is not sold in an attempt to pass as the original.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Counterfeits: A counterfeit is a copy of the original fashion design as well as brand logo or label of that design. Counterfeit apparel is sold as an attempt to pass off as the original product. Counterfeits may also involve piracy in fashion design besides piracy in logo or label of fashion brand.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;SUBJECT MATTER IN FASHION LAW&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Articles designed by fashion designers can be protected under various categories of IP as follows:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; The sketch designed can be registered as artistic work under Copyright Act 1957;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; The article design can be well protected under the Designs Act (under class 02, 03, 05, 10 and 11 of third schedule of Designs Rules, 2000);&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; Color combination can also be protected under Copyright Act, 1957;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; Fabric or any other material used in the Article can also be protected under Designs Act, 2000 and Patents Act, 1970 (if involves inventive step and is novel);&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; Logo Designs can be protected under the Trademarks Act, 1999 when logo is part of design. For instance, Louis Vuitton handbags covered with a repeating pattern of the brand&rsquo;s well-known LV mark.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;LEGISLATIONS PROTECTING FASHION DESIGNS IN INDIA&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The IPR Regime in India provides protection to the fashion design under four legislations i.e. The Designs Act, 2000, The Indian Copyright Act, 1957, The Trademarks Act, 1999 and GI Act, 1999. From the perspective of Fashion Industry, the Acts do not protect the entire garment as a whole; rather it protects the particular/individual aspects like shape, pattern, colour etc. of the garment.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;PROTECTION UNDER DESIGNS ACT, 2000:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The Designs Act only protects registered designs not the unregistered designs. Hence, fashion designers who have not duly registered their designs cannot get the benefits of the Act. It is pertinent to note that a fashion design, which is a trademark, cannot get protection under the Designs Act.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Further, the Designs Act 2000, is so drafted to permit protection of the non-functional aspects of an object, having visual appeal, such that design that include the features of shape configuration, pattern, ornament or composition of lines or colors applied to any two dimensional or three dimensional or on both forms. Such a design right remains in force for a period of ten years, extendable subject to conditions, for a total period of 15 years.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Section 22 of The Design Act states that in the case of piracy of a registered design, the infringer shall be liable to pay the registered proprietor of the design a sum not exceeding Rs 25,000 recoverable as a contract debt; if the proprietor elects to bring a suit for the recovery of damage for any contravention of the rights conferred to him and for an injunction against repetition of it, damages may be awkward may be awarded and the person may be restrained by injunction.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;PROTECTION UNDER COPYRIGHT ACT, 1957:&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Copyright law is another legal protection under the intellectual property. In India, the Indian copyright Act, 1957 lays down the laws relating to copyrights. From the point of protection of designs in general and fashion design in particular, section 15 of the Copyright Act, 1957 is relevant. Section 15 clearly shows that Copyright Act, 1957 and Designs Act, 2000 overlap each other on the issue of design protection.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Section 15 lays down the basic framework for design and copyright protection:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;1. Designs capable of being registered under the Designs Act, 2000 and registered as per the provisions of the Act get protection under the Designs Act only. In this scenario, copyright in registered fashion design will subsist for a maximum period of fifteen years.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;2. Designs capable of being registered under the Designs Act, 2000 but not so registered get protection under the Copyright Act, 1957. Copyright in fashion design, in this context, will subsist up to fiftieth (50th) reproduction by an industrial process of the article to which design has been applied&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;3. Designs not capable of being registered under the Designs Act, 2000, as they are original artistic works, get protection under the Copyright Act, 1957. Copyright in an original artistic work automatically subsists as soon as the work comes into existence and it remains during the lifetime of the author plus sixty years, when published during the lifetime of the author.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Section 15 of The Copyright Act, 1957 provides for special provisions stating that copyright shall not subsist in any design, which is registered or capable of being registered under The Design Act, 2000. Another important parameter of this provision is that copyright in the design shall cease as soon as any article to which the design has been applied has been reproduced more than fifty times by an industrial process by the owner of the copyright or with his licence by any other person. This clause stymies the inherent protection accorded by copyright that a person enjoys merely by virtue of creation.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The original artistic work, as contrasted with the applied artistic work i.e. the design would continue to fall within the ambit of artistic work under copyright Act and shall be entitled to full period of copyright protection. The commercial/industrial manifestation of original work such as the design derived from and founded upon the original artistic work for the purpose of industrial production of furnishings would be covered by the limitations under Section 15 of the Copyright Act.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Hence, a fashion designer seeking to protect his/her creations under the Copyright Act, 1957, needs to prove:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;1. that his/her creation is an &ldquo;original artistic work&rdquo; within the meaning of the Copyright Act, 1957 and is not a &ldquo;design&rdquo; within the meaning of the Designs Act, 2000; and&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;2. that the article (e.g. garment), to which the design derived from the creation has been applied, has not been reproduced more than fifty times by an industrial process by the owner of the copyright or, with his license, by any other person.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;PROTECTION UNDER TRADEMARKS ACT, 1999:&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;A trademark is useful for a fashion design only in a situation where it is visibly integrated into design to such an extent that it becomes an element of the design. There is a growing tendency among fashion designers to incorporate a trademarked logo on the outside of the garment at the time of creation of clothing and accessory designs. In these circumstances, the logo becomes part of the design, thus trademark provides significant protection against design copying. Further, the brand names as such also become the subject matter of protection under the Trademarks Act, 1999.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;PROTECTION UNDER GEOGRAPHICAL INDICATIONS ACT, 1999:&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The fourth schedule of the GI Act provides for a classification of goods protectable under the Act. The registration of geographical indications evidently depicts the protection of fashion apparel vis-a-vis the texture and artistic value in the fabric used to create apparels and accessories. Till now about, 15 kinds of GIs have been registered in respect of textiles in India like Kasuti Embroidery from Karnataka, Kutch embroidery from Gujarat, and Sujini embroidery works from Bihar, etc.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;CASE LAWS WITH RESPECT TO FASHION LAW&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The case of Ritika Apparels v BIBA (MANU/DE/0784/2016)is another case of significance, whereby one fashion brand lifted designs belonging to another fashion house and reproduced the same design in their product thereby causing loss to the original owner of the said design, Ms. Ritu Kumar. However in this case, the defendants, BIBA went scot-free using a lacunae of the copyright law (Section 15(2) of the Copyright Act which says if a creation which is eligible to be protected under the design law has not been registered with the design authorities and has been reproduced more than fifty number of times by industrial process, it will be considered that the copyright in the same product has been lost forever).&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Since the same design was not registered under Designs Act, Ritika Apparels did not have any means of protecting the said design other than producing products having the same design less than fifty numbers of times. Thus, using the loophole existing in the IPR laws, BIBA escaped from any liability. The same case can be said to be a landmark one due to designer&rsquo;s lack of knowledge of the IPR laws of India. Had the said design be registered under the Designs Act, 2000 the same design would have been protected for a total period of 10 + 5 years. But perhaps the designer wanted to keep a monopoly on the same design for a longer period of time and thus used the copyright law which later on was turned against her thus leading to the BIBA becoming free of any liabilities.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The case of Christian Louboutin v Mr. Pawan Kumar and others is a very important one, whereby a big brand famous for its highly stylized designer shoes dealt with the selling of counterfeited products at a lesser price causing loss both to the brand name and to the financial coffers of the company. Christian Louboutin&rsquo;s Red Sole shoes are quite popular among the celebrities and the red colored high heeled shoes are quite a rage among the customers who intend to copy their favorite celebrity&rsquo;s fashion sense and style.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Louboutin&rsquo;s products are protected under the trademark laws and the goodwill and reputation of the brand existed even before the brand&rsquo;s formal entry into the Indian market. The defendants started marketing counterfeits of the much-celebrated red sole shoe, however, with different colour schemes where the soles were red, but the other parts came in different color schemes.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The plaintiff, Christian Louboutin moved to the court seeking a permanent injunction and compensation claims from the two stores (Kamal Footwear and Adara Steps) selling counterfeit products of Red Sole Shoes. The court in its judgment held the defendants liable to pay a total sum of Rs. 10.72 Lakhs, while they were injuncted permanently from selling the counterfeits again. The Judge in its judgment declared Christian Louboutin as a well-known mark, a much sought after tag for any brand owner. The infringement of Louboutin&rsquo;s mark and successful prosecution of the defendant shoe store owners are the best examples of how a designer, or a brand owner needs to protect his or her trademark.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;CONCLUSION&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;India is world&rsquo;s largest and noisiest democracy. Indian textiles and apparels have always been one of the most sought after globally. Currently, the Indian textile industry is pegged at around US$ 120 billion, and is expected to reach US$ 230 billion by 2020. It contributes approximately 2 percent to the country&rsquo;s GDP and 14 per cent to overall Index of Industrial Production (IIP). The industry has also attracted FDI worth US$ 2.55 billion during April 2000 to June 2017. Just like Indian democracy the fashion industry in India is too diverse. It is thus more relevant today that such a huge sector is not trapped in complex web of laws functioning across domains.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Unlike countries like France, where the buyers are criminally liable for buying a counterfeit product, India, currently does not have any law for the same. In India, the owners of the original products have the right of moving to court of law of appropriate jurisdiction seeking permanent injunctions and thereby preventing the counterfeiters from selling counterfeit products. The owners of the original product(s) may also move to the court seeking compensation for their losses. Currently fashion industry is majorly regulated by Intellectual Property laws &ndash; Copyright Act 1957, The Trademarks Act, 1999, Designs Act 2000, and Geographical Indications of Goods (Registration and Protection) Act, 1999, however none of the them is sufficient to deal with the sector in entirety.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;&Oslash; WEBSITES REFERRED&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://www.khuranaandkhurana.com/.../fashion-law-in-india/&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://www.candcip.com/fashion--ip&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://blog.ipleaders.in/ipr-laws-applicable-to-fashion.../&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://www.lawcrossing.com/.../Fashion-Law-An-Inside-Look/&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://www.thebalancecareers.com/fashion-law-2164606&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://en.wikipedia.org/wiki/Fashion_law&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; https://lawcorner.in/concept-of-fashion-law-and-its.../&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;&Oslash; BOOK REFERRED&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&middot; Fashion law decoded (volume 1) &ndash; Dei Beverley&lt;/span&gt;&lt;/div&gt;&lt;/h4&gt;&lt;p style=&quot;text-align: justify; margin-bottom: 8px;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 8px;&quot;&gt;&lt;i&gt;&lt;b&gt;Mahima Dhanhem&amp;nbsp;&lt;/b&gt;&lt;/i&gt;&lt;/h4&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot; segoe=&quot;&quot; ui=&quot;&quot; historic&quot;,=&quot;&quot; &quot;segoe=&quot;&quot; ui&quot;,=&quot;&quot; helvetica,=&quot;&quot; arial,=&quot;&quot; sans-serif;=&quot;&quot; color:=&quot;&quot; rgb(5,=&quot;&quot; 5,=&quot;&quot; 5);=&quot;&quot; font-size:=&quot;&quot; 15px;=&quot;&quot; background-color:=&quot;&quot; rgb(255,=&quot;&quot; 255,=&quot;&quot; 255);&quot;=&quot;&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;/span&gt;&lt;/div&gt;', '32f6abfcc9a6130cc46d9a027b5e90e9.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-10-08', 1, NULL, NULL, '2020-11-28 21:21:39', '2021-01-27 00:33:20'),
(31, 'YFDUysZbG8Xo4xKtGuoUkaBPb', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Ambush marketing .  Mr. Sachin Nayal Intern ', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px;&quot; segoe=&quot;&quot; ui=&quot;&quot; historic&quot;,=&quot;&quot; &quot;segoe=&quot;&quot; ui&quot;,=&quot;&quot; helvetica,=&quot;&quot; arial,=&quot;&quot; sans-serif;=&quot;&quot; color:=&quot;&quot; rgb(228,=&quot;&quot; 230,=&quot;&quot; 235);=&quot;&quot; font-size:=&quot;&quot; 15px;=&quot;&quot; background-color:=&quot;&quot; rgb(36,=&quot;&quot; 37,=&quot;&quot; 38);&quot;=&quot;&quot;&gt;&lt;h4 style=&quot;&quot;&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Meaning -Ambush marketing is the practice by which a rival company attempts to associate its products with an event that already has official sponsors. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;One of the most distinguishing features of ambush marketing is how unexpected it tends to be. For example, money is needed to host and broadcast sporting events, and companies enter into official sponsorships to help provide funding. While smaller companies cannot afford to contribute this level of funding, they still use creative tactics to get the crowd&#039;s attention. The more attention they garner, the better.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Bigger companies also engage in ambush marketing tactics to undermine official event sponsors.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Kodak Case &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Kodak&#039;s campaign during the 1984 Olympic Games. Though Fuji was the official sponsor of the games, Kodak ran an aggressive television ad campaign that created the perception that they were the official sponsors. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Types of Ambush Marketing&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Ambush marketing can be characterized into 3 types:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Direct Ambushing:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;When a brand intentionally wants to appear affiliated with an event for which it has no rights, directly attacking its rival and authorized brand, it is called direct ambush marketing. It is considered the most serious form of ambushing as it directly infringes upon the exclusive rights of usage of the aggrieved party. It may be through unauthorized use of symbols or other marketing elements by another company.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;For example, Sprints Communication Co. resorted to direct ambush marketing during the 1994 FIFA Football World Cup by using the event&#039;s official logo without permission of either FIFA (Football governing body) or Master Card who were assigned the exclusive rights for using the world cup logo.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Associative Ambushing:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;It means intentional use of such terms or imagery which portrays that the company has links to the event, without making any reference to the official sponsorship.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Incidental Ambushing:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The efforts of a brand to gain mileage out of an event simply through heavy media spend during the event, without making any direct or indirect references to the event is incidental ambushing. It is just an attempt to distract audiences from the event&#039;s official competitive sponsor, by bombarding them with their own ads.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;National Hockey League (NHL) V. Pepsi-Cola Ltd&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;National Hockey Services League, the licensing arm of NHL had entered into a contract with Coca- Cola to be the official sponsor of the NHL in 1989. Coca Cola, therefore, obtained the rights to use NHL symbols for its promotional events in Canada and USA. Through this agreement, however, Coke did not obtain &quot;any right to advertise during the broadcast, in Canada of any televised NHL games.&quot; The NHL, not the NHLS, controlled such television rights and it sold them to Molson Breweries of Canada Ltd. (Molson) in 1988 for a five-year period. Molson Breweries, in turn, sold them to Coca- Cola&#039;s main competitor Pepsi. After that, Pepsi launched a television advertising campaign that without using the NHL symbols or logos, promoted a hockey related contest. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;In deciding the case, the court noted that although the advertising done by Pepsi is aggressive, it is not unlawful according to the laws of Canada. The court noted that the NHL was, to some extent, the author of its own misfortune since its sale of the broadcast rights did not protect its official sponsor. Thus, the court found that Pepsi was not in violation of Coke&#039;s contract nor did its aggressive advertising campaign amount to the tort of passing-off under Canadian law or infringement on registered trademarks. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Indian case&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;ICC Development International Ltd v. Arvee Enterprises and Anr&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Equivalent citations: 2003 VIIAD Delhi 405, 2003 (26) PTC 245 Del, 2004 (1) RAJ 10&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The Delhi High Court had the occasion to deal with &ldquo;ambush marketing&rdquo; in the case ICC Development (International Ltd.) v. Arvee Enterprises &amp; Philips. International Cricket Council (ICC), through its event management arm, ICC (Development) International Ltd. (IDI), filed the suit seeking a permanent injunction along with an application for an interim injunction restraining Philips from publishing any advertisements associating itself with the plaintiff, passing off IDI&rsquo;s trademarks and indicia and indulging in unfair trade practice by misappropriating its publicity rights in the &ldquo;Cricket World Cup&rdquo; (&ldquo;the event&rdquo;). Philips was using the words &ldquo;Cricket World Cup&rdquo; and &ldquo;World Cup&rdquo; in its slogans and advertisement campaign offering World Cup ticket and travel packages to South Africa as prizes to customers purchasing Philips products. The plaintiff pleaded that such use, coupled with the pictorial representation of a ticket with an imaginary seat and gate number of the stadium, amounted to passing off, unfair competition and ambush marketing.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Ticket Conditions&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The contention of IDI that Philips had breached the terms of sale of the tickets, which specifically prohibited use of the tickets for promotion or as prizes for competitions, was rejected by the court because Philips had purchased the travel packages from the Indian subagent of the official tour operator of IDI, and these terms were never brought to the notice of Philips.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Passing Off&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The court held that Philips&rsquo; slogans merely showed that the purchasers of its goods might win a ticket and travel package to see the World Cup and nothing more. Admittedly, Philips had not used IDI&rsquo;s logo or mascot. The campaign may have drawn the attention of the public to the event, but there was no likelihood of confusion in the mind of the purchasing public that Philips was a sponsor or licensee. Therefore, the basic criteria for a passing off action or for unfair trading were not met.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Court Observation&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The court observed that the phrase &ldquo;ambush marketing&rdquo; is used by marketing executives only and is different from passing off. In a passing off action, there is an element of overt or covert deceit, whereas ambush marketing is opportunistic commercial exploitation of the event. The marketer does not seek to suggest any connection with an event, but gives his own brand or other insignia a larger exposure to the people attached to the event, without any authorization of the event organizer. In such cases there is no deception; therefore the defendant&rsquo;s conduct cannot be categorized as wrongful or against public interest. The court held that commercial advertising is commercial free speech and protected under Article 19 (1) (a) of the Indian Constitution. An advertisement campaign without using the logo or mascot of the plaintiff cannot be held to be unlawful. Thus, it is for the legislature to decide how far to curtail the legitimate fair competition and freedom of speech. In India no statutory or common law prohibits such an activity and the World Cup is not protected by any international treaty or domestic law, unlike the Olympic Games and its trademarks, which are protected under the Indian Emblems and Names (Prevention of Improper Use) Act, 1950.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;In view of the aforesaid, Justice S. K. Agarwal of the Delhi High Court declined to grant an interim injunction in favor of IDI, holding that Philips&rsquo; advertising campaign did not amount to passing off, unfair competition or ambush marketing.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The value and importance placed on protecting the exclusivity of events like the Soccer World Cup and the Olympic Games are amply demonstrated by the fact that the governments have enacted specific statutes, such as the Sydney 2000 Games (Indicia and Images) Protection Act, to prevent ambush marketing.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Law in India regarding Ambush Marketing&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Experiences from the past three decades have proven the fact that ambush marketing is unethical and how important is to have stringent intellectual property protection beside what is provided in for current regime At present, India has not enacted specific anti-ambush marketing laws and accordingly redress must be had to the Trade Marks Act, 1999, the Copyright Act, 1957, the Emblems and Names Act, 1950 and the common law notion of passing off.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;(1)  The Copyright Act, 1957&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The Copyright Act is a capable tool which provides a remedy in the limited set of instances of &quot;ambush marketing&quot; i.e. where logos or other original works of authorship are used without license by third parties. The Copyright Act, 1957 provides the owner of copyright privilege to enjoy the exclusive rights to reproduce, perform, publish adapt or translate, the copyrighted work and any such act undertaken without the license of the copyright owner would, generally, constitute copyright infringement. Now as per the Act infringement consist of two essential elements:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;There must be sufficient objective similarity b/w the infringing work and the copyright work,&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The infringing work must have been derived from the copyright work.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;(2)  The Emblems and Names (Prevention of improper use) Act, 1950&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The Act serves the purpose of preventing the improper use of certain emblems and names for professional &amp; commercial purpose, the restrictions provided under the Act are in regard to-&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The improper use of certain protected emblems and names; and&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The prohibition on registration of certain companies and other bodies, trademarks and designs as well as grant of patents that bear a title containing any protected emblem or name.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;In order to be protected under this legislation, an emblem or name must be notified in the official gazette and included in the schedule to the Act, while the only sports &ndash;related emblem and name currently notified and protected are &quot;the name and emblem of the international Olympic committee consisting of five interlaced rings&quot;. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;(3)  The Trademark Act, 1999&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The Trademark Act, 1999 provides that a trademark may be registered or unregistered, when the trademark is registered the registrant is granted certain privileges these are:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Title to mark established which enables the trademark owner to avoid proving his title against any infringement of the mark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;The exclusive right to use the registered trademark in relation to the goods or services in respect of which the trademark is registered&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Necessity of Legislation&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;As India is trying hard to bid for either 2028 or 2032 Olympics, the controversial practice of &#039;ambush marketing&#039; will come under scanner. No cricket lover can easily forget the instance of 1996 cricket world cup where Coca Cola was the official sponsor but its sponsorship was clearly overshadowed and ambushed by the cheeky and catchy slogan &quot;nothing official about it&quot; of Pepsi, although now times have changed and India has recently have organized the most successful cricket world cup ever both in monetary and popularity context and without any major controversy, but that is largely due to cricketing policies of I.C.C (International Cricket Council).&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Today the stakes in sports are much higher for example the broadcasting rights of the cricket world cup of 1996 was bought for an nominal amount of $ 15 million but for 2011 and 2015 cricket world cup the amount increased up to $ 1.1 billion ,the sponsors are very much concerned about their rights and interests although protection provided under trademarks act, competition law seems to be enough to deal with every situation of ambush marketing but in reality they are not enough and are not sufficient for each and every situation, lets again discuss the &quot;nothing official about it&quot; campaign by Pepsi it was more or less a spoof or parody on the official sponsor but in reality it was a smartly done act of ambush marketing, the point of determination remains whether any business/official association with the event is implied indirectly, even today a smartly done act of spoof or parody like &quot;nothing official about it&quot; will not be attract the provisions provided to attract ambush marketing.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Over the years, the nature and role of sports sponsorship has changed dramatically from altruistic patronage to calculated spend money, the expectation of concrete measurable &#039;return&#039; on &quot;investment&quot; have become of paramount concern,the laws provided under trademark, copyright infringement, passing off or unfair competition can only be a stop gap arrangement and not a permanent solution.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Although the event organizers, sponsors, sportspersons do sign contracts of exclusive sponsorship before any major event so as to protect their rights and interests, like we have seen in recently concluded cricket world cup where the rules of I.C.C prohibited players from indulging in any sort of ambush marketing but these contracts limits each of their rights to interact or associate commercially with competitors of official sponsors in-stadia and in some cases for a period of time surrounding the event. As regards the world at large they have no rights other than trademark, passing off, false advertising and unfair competition laws, as a result, the contractual restraints described above in conjunction with existing law are of very limited use in curbing ambush marketing by opportunistic actors.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;If we look at the examples of countries which have organized major events Australia (Olympic 2000),China (Olympic 2008), Canada (Winter Olympic 2010), and U.K (Olympic 2012) all of them either have passed event&ndash;specific legislation or amended existing laws to contemplate protection of the official sponsors of their major sporting events. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;A major international sporting event plays a very significant role in developing economy and sports and also in promoting tourism, these major sporting events do require sponsors and no sponsor would invest their money at the risk of tribulations of ambush marketing. They also looks for return on their money and without proper legislation it will not be easy to attract sponsors so in order to promote sports and attract major sponsors there is an urge for proper legislation.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Conclusion&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Ambush marketing is not a new phenomenon but lately due to increase in sports events at the world level, ambush marketing has been making headlines. In order to avoid ambush marketing, organizers are making an effort to make such rules or guidelines which gives them the power to take action against the wrongdoer. It is now common to make legislation before any major event for example; the London Olympics Bill, published on 15 July 2005, debated in Standing Committee, and amended on 18 October 2005. It deals in particular with regulation of advertising activities and commercial exploitation in connection with the Games and protection of the Olympic intellectual property such as the Olympic symbol, motto, and associated words. This act shall cease to be in force on 31st December 2012. The objectives of doing so are to protect the financial investment made by official sponsors and maximize the return to organizers of the event which, without official sponsorship, would be unlikely to take place. Today an obnoxious amount of money is at stake, thus one can see the hard work involved to stop the ambushers. Therefore the time has come to implement a legislation which protects the rights of the official sponsors and also infringement of the intellectual property rights.&lt;/span&gt;&lt;/h4&gt;&lt;/div&gt;', 'c3108379fc14b5646923e19caf1c8d99.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 19:28:29', '2020-12-23 03:06:45');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(29, 'YLG4A96W0ViNiBfQk3sUxo37i', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Civil Procedure Code Using interrogatories effectively to aid cross examination.   Ajay J Nandalike Advocate Bangalore ', '&lt;div class=&quot;WordSection1&quot;&gt;&lt;/div&gt;&lt;h4&gt;In the aftermath of COVID-19, courts and arbitrations are beginning to adopt virtual&lt;br&gt;hearings as a means of justice dispensation. There is some debate about&lt;br&gt;conducting cross-examination online. A view that is possible is that&lt;br&gt;cross-examination can be conducted online, however, someone from the other side&lt;br&gt;is physically present in the same room as the witness to avoid tutoring. Another&lt;br&gt;view is to have a physical hearing in respect of cross-examination but restrict&lt;br&gt;the scope of cross-examination by encouraging the use of interrogatories. In&lt;br&gt;this background, this article explores how one can use interrogatories&lt;br&gt;effectively to aid cross-examination. The benefits of an effective use of&lt;br&gt;interrogatories include restricting the scope of cross-examination, creating more&lt;br&gt;effective cross-examination, reducing superfluous questions etc.&lt;br&gt;Instances where an Interrogatories are beneficial&lt;br&gt;1.Narrowing the scope of controversy: The opponent may not&lt;br&gt;refer to certain facts in the proof affidavit or be silent in respect of some information.&lt;br&gt;It does not mean that the opponent is denying the information. In this&lt;br&gt;situation, the scope of the dispute can be reduced by asking the opponent to&lt;br&gt;admit certain facts by way of interrogatories. These admissions may not harm the&lt;br&gt;case of the opponent but may aid another party&rsquo;s narrative or may be required for&lt;br&gt;the sake of completeness. This will reduce the necessity of cross-examination&lt;br&gt;on that issue.&lt;br&gt;2.Reducing the reliance of documentary evidence in relation to certain&lt;br&gt;aspects: The witness may be relying on some voluminous documents or it may&lt;br&gt;contain detailed technical specifications. In order to avoid the court /&lt;br&gt;Arbitral Tribunal to rely on complete document, one can ask interrogatories seeking&lt;br&gt;the witness to state the relevant procedure or provide technical details or as to&lt;br&gt;which page number of the Exhibit where the details are available. This will&lt;br&gt;ensure that the cross-examination will only be restricted to those page numbers&lt;br&gt;of the Exhibits. It may also so happen that a document produced by the witness&lt;br&gt;may not at all be relevant to the matter. In such a situation, one could seek&lt;br&gt;reasons for reliance on a particular document. This will restrict the scope of&lt;br&gt;cross- examination in relation to that document.&lt;br&gt;3.Excluding aspects which the witness does not have knowledge of:&lt;br&gt;If the Legal Manager of the Company files the proof affidavit on behalf of the&lt;br&gt;Company, it is possible that he is deposing entirely on the basis of records.&lt;br&gt;However, there may be several statements in the affidavit which may not be&lt;br&gt;based on records. These need to be carefully&lt;br&gt;gleaned out and the witness can be asked to identify the source of the&lt;br&gt;statement made in the affidavit. If the witness refers to a document, then if&lt;br&gt;the document is not produced or if the document does not depict the said fact,&lt;br&gt;the fact is not proved. If the witness refers to some information obtained from&lt;br&gt;other company personnel and names such a person, then without that person&lt;br&gt;stepping into the witness box, the fact is not proved. The reference to that fact&lt;br&gt;in the proof affidavit of the witness would be hearsay evidence and cannot be&lt;br&gt;accepted. There would be no need to cross-examine the witness on those facts in&lt;br&gt;the affidavit at all.&lt;br&gt;4.Identifying the source of the information: The witness may be&lt;br&gt;making certain assertions without stating the supporting facts or producing the&lt;br&gt;supporting documents on the basis of which such statements are made. If&lt;br&gt;questions are asked in cross-examination for the first time regarding the&lt;br&gt;source, the answers may surprise the cross-examiner and one may require more&lt;br&gt;time to prepare to cross-examine further in response to such answers. It may&lt;br&gt;also result in a situation where one is not able to fully cross-examine on that&lt;br&gt;issue because of an unexpected answer. Hence, interrogatories will provide an&lt;br&gt;opportunity to prepare for such surprises.&lt;br&gt;5.Establishing timelines and dates: It is also possible to utilize&lt;br&gt;the interrogatories to establish a timeline and to organize the information in&lt;br&gt;the affidavit if it has been put in a haphazard manner. If one is required to&lt;br&gt;connect facts stated in the opponent&rsquo;s affidavit in a manner which is suitable&lt;br&gt;for one&rsquo;s case, then it is possible to do so. If the affidavit omits a crucial&lt;br&gt;link, it is possible to bring out that information in the timeline by seeking&lt;br&gt;the opponent to confirm that particular fact. Similarly, one can ask the&lt;br&gt;witness to confirm certain dates and events. If the witness intends to deny the&lt;br&gt;timeline, it will help one focus the cross-examination on that specific aspect&lt;br&gt;in the timeline which is denied. This saves considerable time during cross-examination.&lt;br&gt;6.Getting more information / better particulars relating to&lt;br&gt;technical or procedural aspects: Answer to Interrogatories may be more complete&lt;br&gt;than cross examination. Unlike depositions, interrogatories may inquire not only&lt;br&gt;into the responding party&rsquo;s present recollection, but also into the collective&lt;br&gt;knowledge available to him or her, including knowledge of his or her agents and&lt;br&gt;attorneys. One may want certain undocumented details or technicalities about&lt;br&gt;some procedure on record. This information requires reference to certain&lt;br&gt;documents which may not be on record or may be just an undocumented business&lt;br&gt;practice of the company, then it is a good idea to ask it in interrogatories.&lt;br&gt;Witness cannot say that he does not have personal knowledge or that he needs to&lt;br&gt;examine records. For instance, one can ask a question regarding the procedure&lt;br&gt;followed internally for clearing an invoice, which departments are involved,&lt;br&gt;who needs to sign off etc. This information will provide a foundation for&lt;br&gt;cross-examination on whether an invoice was improperly cleared, whether there&lt;br&gt;was waiver etc.&nbsp;&lt;br&gt;7.Evasive Witness: One of the&lt;br&gt;problems that is faced during cross-examination is the witness may not want to&lt;br&gt;reveal certain information despite being aware of the same. So, the witness may&lt;br&gt;say that the he does not have personal knowledge, he will need to refer to&lt;br&gt;document, he did not understand the question etc., or he may not deliver a&lt;br&gt;complete answer. However, in an interrogatory, he cannot say so. He will have&lt;br&gt;the benefit of looking at all relevant documents, seeking information from&lt;br&gt;other persons in the company, seeking advice from counsel, technical persons&lt;br&gt;etc. Although it is possible to give an evasive answer, if care is taken to identify&lt;br&gt;what relevant facts one wants the witness to state, the witness will have to&lt;br&gt;give a yes or no answer.&lt;br&gt;8.Pinning down the&lt;br&gt;opponent&rsquo;s case: It is possible that an opponent will have multiple defences&lt;br&gt;which are taken without prejudice to one another or case may be based on&lt;br&gt;multitude of facts. When the opponent is being cross- examined, it would be&lt;br&gt;possible to give contradictory answers or misconstrue the questions or provide&lt;br&gt;caveats in some manner. In construction arbitrations, interpretations of actions&lt;br&gt;of parties revolve around what constitutes general or best engineering /&lt;br&gt;construction practice. If one is able to pin the opponent&rsquo;s case on any&lt;br&gt;particular issue by eliciting in an interrogatory as to whether they would accept&lt;br&gt;xyz as the best engineering practice and if not, the reasons for the same, one&lt;br&gt;would have a foundation to cross-examination on that issue and elicit&lt;br&gt;appropriate responses. If you are able to rebut the case of the other side with&lt;br&gt;some new information / documents, then interrogatories are an excellent place&lt;br&gt;to pin down the witness. In cross, the witness may want to clarify his&lt;br&gt;statement or say that he misunderstood the question. However, a tightly worded&lt;br&gt;interrogatory requiring an absolute answer will ensure that the opponent is&lt;br&gt;pinned to that position. While cross-examining, one can rebut the case by&lt;br&gt;producing the information / document and create contradictions.&lt;br&gt;9.&nbsp; &nbsp; &nbsp;Denied document &ndash; Before&lt;br&gt;the trial begins, parties exchange statement of admissions and denials of the&lt;br&gt;documents produced by the other party. Typically, one will deny the receipt of the&lt;br&gt;document or deny the contents of the document. If the receipt of the document&lt;br&gt;is denied, the attempt is to either to verify if the&lt;br&gt;document is referred in any other document which is admitted by the opponent or&lt;br&gt;proof of receipt is to be furnished. An interrogatory could focus on&lt;br&gt;referencing some event or action that would have been undertaken pursuant to&lt;br&gt;the denied letter so that portions of the letter can be admitted. If the content&lt;br&gt;of the document is denied, it would be beneficial to identify which portions of&lt;br&gt;the letter are admitted and which portions are denied so that the&lt;br&gt;cross-examination is restricted only to that portion. denial of basis of such&lt;br&gt;denial. If you have received the document, did you reply back to the letter and&lt;br&gt;details of the letter so replied back. You could ask under what circumstances&lt;br&gt;did you decide not to reply back to the letter. Document identification&lt;br&gt;interrogatory is useful if you intend to tie a document to a specific event.&lt;br&gt;10. Getting information not&lt;br&gt;obtainable from an individual deponent - When conducting discovery against&lt;br&gt;corporations, e.g., in a products liability case, the plaintiff may need to discover&lt;br&gt;information about every other person injured by the same product. Probably no&lt;br&gt;individual employee of the corporation would know the answer, because it would&lt;br&gt;require a search through records. An interrogatory would require the&lt;br&gt;corporation to search its records and conduct a reasonable investigation to gather&lt;br&gt;the information. It&rsquo;s often useful to have a corporate deponent designate the&lt;br&gt;person who&rsquo;s most qualified to testify on specified matters.&lt;br&gt;11. Breaking down the complex&lt;br&gt;claim &ndash; In construction arbitrations / claims, there may be complex claims&lt;br&gt;which are bunched together. For instance, idle charges may be bunched together&lt;br&gt;for the entire contract period. It would make sense to seek clarity on the&lt;br&gt;break-up of the claims, basis for the claims, what documents are being relied&lt;br&gt;on for what claim. Additionally, it would be possible to ask questions on&lt;br&gt;mitigation steps. The answers given by a witness can be tested in&lt;br&gt;cross-examination under a more thorough questioning. This will enhance the&lt;br&gt;value of the cross-examination.&lt;br&gt;12. Create contradictions &ndash;&lt;br&gt;One must bear in mind that the interrogatories are drafted with the aid of the&lt;br&gt;opponent&rsquo;s counsel. Hence it is possible that the counsel&rsquo;s thoughts and legal&lt;br&gt;correctness may gloss over the facts or assume facts which may not be true. If&lt;br&gt;the same question is asked in another context, the answer may be different in&lt;br&gt;the course of cross-examination. This is extremely risky as the witness may&lt;br&gt;stick to the counsel&rsquo;s stand. It is also advisable not to ask about incidents which&lt;br&gt;are based on personal knowledge as the counsel may add relevant details, make it&lt;br&gt;complete. Witnesses have imperfect recollections,&lt;br&gt;details of conversations may actually be different, but a counsel can bring a&lt;br&gt;sense of completeness by covering all loopholes.&lt;br&gt;Effective use&lt;br&gt;of interrogatories will not only aid the cross-examination, but also help the Arbitral&lt;br&gt;Tribunal / Civil Courts to focus on the relevant facts and reign in the cross-&lt;br&gt;examination. Interrogatories form part of the evidence of the parties and would&lt;br&gt;have a greater weightage than cross-examination. If strict time periods are&lt;br&gt;imposed on the cross-examination, then meandering around unnecessary questions can&lt;br&gt;be avoided, a lot of the necessary information can be gleaned out in interrogatories.&lt;br&gt;Typically, there is a need to establish certain background facts during cross&lt;br&gt;and this can be achieved in cross-examination. However, it is not being used effectively&lt;br&gt;due to lack of awareness of its benefits. One hopes that this article will aid&lt;br&gt;practitioners to use interrogatories effectively.&lt;br&gt;&lt;br&gt;(Ajay J Nandalike is an advocate practicing in Pragati&lt;br&gt;Law Chambers, Bangalore)&lt;/h4&gt;', 'cca4e999a46e179e7b6a5c2d9d784f31.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-01', 1, NULL, NULL, '2020-11-30 00:17:31', '2020-12-23 03:08:31'),
(32, 'GZJAGsvvdPLUnDo4uagbSitho', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Article on Trademark.  Mr. Arko Sarkar. Mr. Devashish Kumar Sahu and Mr. Soupayan Sinha Roy', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px;&quot; segoe=&quot;&quot; ui=&quot;&quot; historic&quot;,=&quot;&quot; &quot;segoe=&quot;&quot; ui&quot;,=&quot;&quot; helvetica,=&quot;&quot; arial,=&quot;&quot; sans-serif;=&quot;&quot; color:=&quot;&quot; rgb(228,=&quot;&quot; 230,=&quot;&quot; 235);=&quot;&quot; font-size:=&quot;&quot; 15px;=&quot;&quot; background-color:=&quot;&quot; rgb(36,=&quot;&quot; 37,=&quot;&quot; 38);&quot;=&quot;&quot;&gt;&lt;h4 style=&quot;&quot;&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. The Trademarks Registry was established in India in 1940 and presently it administers the Trade Marks Act, 1999 and the rules thereunder. It acts as a resource and information center and a facilitator in matters relating to trade marks in the country. The objective of Trade Marks Act, 1999 is to register trademarks applied for in the country and to provide for better protection of trade mark for goods and services and also to prevent fraudulent use of the mark. The main function of the Registry is to register trademarks which qualifies for registration under the Act and Rules.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. A good trademark, or logo, makes your particular product or service stand out. These are probably a number of trademarks which you choose to buy, just because you recognize them. A trademark is quite simply a way to create recognition for your customers. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Trademark protection gives you an exclusive rights, which means that no one else has the right to use the trademark for their goods or services, or their marketing. One of the main purposes of having a product trademarked is to protect the product from being used without permission of the source company. A trademark serves to exclusively identify a product or service with a specific company, and is a recognition of that company&rsquo;s ownership of the brand. Trademark products are generally considered a form of property.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;REGISTRATION OF TRADEMARK&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. The law considers a trademark to be a form of property. Proprietary rights in relation to a trademark may be established through actual use in the marketplace, or through registration of the mark with the trademark office of a particular jurisdiction. In some jurisdictions, trademark rights can be established through either or both means. Certain jurisdictions generally do not recognize trademark rights arising through use. If trademark owners do not hold registrations for their marks in such jurisdictions, the extent to which they will be able to enforce their rights through trademark infringement proceedings will therefore be limited. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;5. A registered trademark confers a bundle of exclusive rights upon the registered owner, including the right to exclusive use of the mark in relation to the products or services for which it is registered. The law in most jurisdictions allows the owner of a registered trademark to prevent unauthorized use of the mark in relation to products or services which are identical or &ldquo;colorfully&rdquo; similar to the &ldquo;registered&rdquo; products or services, and in certain cases, prevent use in relation to entirely dissimilar products or services. The test is always whether a consumer of the goods or services will be confused as to the identity of the source or origin.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;6. Trademark needs proper registration and it follows a procedure as to who can apply and what are the basic requirements for the same.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Who can apply for Trademark?&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;-As mentioned in Section 18 of the Act any person claiming to be proprietor of trademark used or proposed to be used by him can apply for registration.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;-Application must contain the name of the mark, goods or services, class in which goods and services fall, name and address of the applicant, period of use of Trademark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;-Any person here relates to partnership firm, association of a person, company whether incorporated or not, Trust, Central or State Government.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Steps for Registration of Trademark&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Search for name, mark and device logo intended to be applied for Trademark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Trademark application can be filed at one of the five Trademark Registration office having jurisdiction over the state or online.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Trademark registration must contain:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;A. Logo or the Trademark&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;B. Name of the trademark owner&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;C. Classification of trademark&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;D. Trademark used since date&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;E. Description of goods or services &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;PROTECTION OF TRADEMARK&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;A trademark protects a good or service offered by a company from infringement or damage of reputation by another company, and provides the owner legal recourse.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;A trademark protects a goods or service offered by a company from infringement or damage of reputation of another company. With a trademark, you have legal recourse to sue another company that uses your likeness to further their own business ventures. Thus includes both registered and unregistered trademarks. By using a sole trademark, the producer reaps the sole benefit of sales, while the consumer is satisfied.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Trademarks also protect four categories:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Generic trademarks&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Descriptive trademarks &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Suggestive trademarks&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. Arbitrary trademarks or fanciful trademarks&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;This is referred to as a &ldquo;common law&rdquo; trademark. For small geographic locations, this works well. It doesn&rsquo;t work as well as in a national setting, as companies far and wide may have similar names or logos. If you haven&rsquo;t registered a trademark, you can still use the TM logo to show you have a stake to the trademark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;7. Dispute can arise based on TM logo. However, it&rsquo;s a good starting point until you have time to register your trademark with the U.S Patent and Trademark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;8. Although trademark protection by use gives you protection via common law, trademark by registration offers more protection. This includes:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Notice to public about the trademark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. The exclusive right to use the trademark nationwide to distribute goods and services.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. The ability to bring legal action in federal court for infringement. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. The ability to obtain a trademark in foreign countries.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;5. The ability to file with U.S. Customs to prevent mock goods from coming in the countr        &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;DILUTION OF TRADEMARK&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;9. The progressive development of intellectual property law over the last century has seen to an exponential increase in the commercial and economic importance of various intellectual property rights. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;10. For better protection of trade marks for goods and services and for the prevention of the use of fraudulent marks, parliament repealed the 1958 Act and replaces it by the Trade Marks Act, 1999. Under Trade Marks Act, 1999 Trademark Dilution was introduced. Trademark dilution is a trademark law concept giving the owner of a famous well-known trademark power to forbid others from using the mark in a way that would lessen its uniqueness. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;11. Dilution of Trademark is a surface of Trademark infringement, where the owner of a well-known trademark has the power to prevent others from using their mark on the ground that it kills their uniqueness or lessen their reputation. No one has the right to copy or to misuse the well-known trademark&rsquo;s reputation. Instead, dilution protection aims to protect sufficiently strong and well-known trademarks from losing their singular association in the public mind with a particular product.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;12. Thus, the doctrine of dilution comes directly in contact with consumers. The Doctrine of Dilution was not present in the old law i.e. the Trade and Merchandise Marks Act, 1958, as in the case of section 29(4) of the Trademarks Act, 1999 by which the doctrine of dilution has been first incorporated in a statute. But the doctrine of dilution was introduced by the court much before the Act having regard to internationally recognized status.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;13. The trademark under section 29(4) should be registered and should have a reputation in India. For the application of this section, the trademark should be well-known and should have a reputation in India. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;14. Infringement in form of dilution will occur only when the person uses the mark which is:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Identical or similar to the registered trademark which already has a reputation in India&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Use is on different goods or services than those covered by registration.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;15. Infringement which is occurred if it is found the use of offending mark produces the following results:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. When the person takes unfair advantage of the reputed mark or mark having a distinctive character.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. When the mark is harmful to the distinctive mark or reputed mark.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;16. The court has already used the doctrine of dilution prior to the act. One of the famous cases, where the court used the dilution prior to the act is Daimler Benz Akiegessellschaft &amp; Anr. V. Hybo Hindustan, in which the issue was with the mark BENZ along with a three pointed human being in a ring which the defendant used or his undergarment line. The High Court, in this case, granted the injunction to the plaintiff and stated that copying of mark such as Mercedes-Benz by anyone would result in the perversion of the trademark law in India.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;17. This is the first case in India where the court restrained the defendant from using the plaintiff well-known trademark on the sole ground to avoid confusion or deception into a picture&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Exceptions to Dilution of Trademarks&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;18. Any fair use, including a nominative or deceptive fair use, or facilitation of such fair use, of a famous mark by another person other than as a designation of source for the person&rsquo;s own goods or services, including use in connection with-&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Advertising or promotion that permits consumers to compare goods or services;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Identifying and parodying, criticizing, or commenting upon the famous mark owner the goods or services.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. All forms of news reporting and news commentary.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. Any mark which includes parodies, criticism or comments. The exception of parodies was used in Louis Vuitton.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;19. Malletier S.A V. Haute Diggity Dog, LLC, where the defendant manufacture apparels for dogs under the mark &lsquo;Chewy Vuitton&rsquo; which was parody the plaintiff famous brand &lsquo;Louis Vuitton&rsquo; apparels. It was held by the court that &lsquo;Chewy Vuitton&rsquo; did not dilute the trademark &lsquo;Louis Vuitton&rsquo; because it was merely a parody of &lsquo;Louis Vuitton&rsquo;.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;20. The Doctrine of Dilution is the power given to the well-known trademark owner. This doctrine will help in stopping the fraudulent activities that happen over time and to maintain the reputation of companies. These well-known companies do help in the growth of GDP of our country and it is the duty of the government to protect these companies from other competition and other fraudulent activities. Section 29(4) is provided as a remedy independent of the infringement action. The Doctrine of dilution works on the discretion of the courts and the tests given by the courts. If the trademark infringes the tests given by the court then it is not allowed in the market to avoid confusion.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;REMEDY AVAILABLE &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;21. Remedies for trademarks that have been diluted, either by means of blurring or tarnishment, typically only offer injunctions against the plaintiff. The plaintiff will have to cease using the trademark responsible for diluting another company.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;22. The judge may require a written statement be prepared and submitted by a future date, which should detail how the plaintiff plans to remove any illegal trademarks from their products or stores. It is rare that anything other than an injunction is placed on the defendant.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;23. The remedies for trademark infringement are bit harsher than dilution. However, it is important to note that if international dilution takes place, similar remedies to trademark infringement may be required to pay by the plaintiff.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;24. If the plaintiff can prove that the defendant willfully attempted to trade based on the reputation of the plaintiff, or willfully looked to bring down the reputation of the plaintiff by copying their trademark, trademark protection laws allow stricter penalties against plaintiffs. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;25. If these things can be proven collaboratively, monetary damages may be awarded to cover court costs, forfeit profits gained as a result of dilution, and help pay for any losses suffered by the plaintiff as a result of the dilution. Trademark protection laws typically do not allow any monetary damages to be awarded for state registered trademarks, only those that are federally registered.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;PASSING OFF AND INFRINGEMENT OF TRADEMARK&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;26. Passing off is a common law tort, which can be used to enforce unregistered trademark rights. The law of passing off prevents one person from misrepresenting his goods or services as that of another. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;27. The concept of passing off has undergone changes in the course of time. At first it was restricted to the representation of one person&rsquo;s goods as of those of another. Later it was extended to business and services. Subsequently it was further extended to professions and non-trading activities. Today it is applied to many forms of unfair trading and unfair competition where the activities of one person cause damage or injury to the goodwill associated with the activities of another person or group of persons.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;28. The three fundamental elements of passing off are Reputation, Misrepresentation and Damage to goodwill. The definition of infringement of a registered trademark is given in Indian Trademarks Act of 1999, section 29 whereby, a registered trademark is said to be infringed by any person, who not being registered proprietor of the Mark or being a person authorized by the owner for its use, uses in the course of trade, a mark which is identical with, or deceptively similar to the mark in relation to goods and services in respect of which the trademark is registered.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;29. Infringement of a Trademark in India means violation of the exclusive rights granted to the registered proprietor under the Trade Marks Act, 1999 to use the same in relation to the goods or services in respect of which the trade mark is registered in Section 29 and Section 30of the Act.  &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;30. Section 29 of the Trade Marks Act, 1999 provides that a registered trademark and there is similarity of the goods or services covered by the trade mark in manner causing confusion to the general public;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Identify with Registered Mark and Similarity of goods/services&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Similarity with Registered Mark and Identity of Goods and Services&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Identity with Registered Mark having Reputation&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. Similarity of Trade Name with Registered Trade Mark&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;5. Application of Registered Mark on Labelling or Packaging etc. With knowledge that such application is without Authorization&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;6. Use of Registered Trademark in Advertising, when such use takes unfair advantage, is detrimental or against the reputation of registered trademark.  &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Certain things not amounting to infringement of Trademark has been mentioned in Section 30 of the Act and they are:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. Use of mark to indicate the kind, quality, quantity etc.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. Use of mark, which is outside the scope of Registration&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Implied Consent for use&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;4. Use of Registered Trademark in relation to parts and accessories etc.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;5. Use of Registered Trademarks identical or similar to each other.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;REMEDY FOR TRADEMARK INFRINGEMENT&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;31. A Court may grant relief of trademark infringement or for passing off .Trademark infringement relief can be provided through an injunction, damages or an account of profits, together with or without any order for the deliver-up of the infringing labels and marks for destruction or erasure.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Section 135 of the Trade Marks Act mentions the following relief of trademark infringement:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. The relief which a court may grant in any suit for infringement or for passing off referred to in Section 134 includes injunction and at the option of the plaintiff, either damages or an account of profits, together with or without any order for the delivery-up to the infringing labels and marks for destruction or erasure.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. The order of injunction under sub-section(1) may include an ex parte injunction or any interlocutory order of any of the following matters, namely:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;a. For discovery of documents&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;b. Preserving of infringing goods, documents or other evidence which are related to the subject-matter of the suit;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;c. Restraining the defendant from disposing of or dealing with his assets in a manner which may adversely affect plaintiff&rsquo;s ability to recover damages, costs or other pecuniary remedies which may be finally awarded to the plaintiff.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Notwithstanding anything contained in sub-section(1),the Court shall not grant relief by way of damages or on account of profits in any case:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;a. where in suit for infringement of a trademark, the infringement complained of is in relation to a certification trademark or collective mark; or&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;b. Where in suit for infringement the defendant satisfied the Court:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. that at the time he commenced to use the trademark complained of in the suit, he was unaware and had no reasonable ground for believing that the trademark of the plaintiff was a registered user using by way of permitted use;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. That when he became aware of the existence and nature of the plaintiff&rsquo;s right in the trademark ,he forthwith ceased to use the trademark in relation to the goods or services in respect of which it was registered; or&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;3. Where in the suit of passing off, the defendant satisfied the Court:&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;1. that at the time he commenced to use the trademark complained of in the suit he was unaware and had no reasonable ground for believing that the trademark of the plaintiff was in use;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;2. That when he became aware of the existence and nature of the plaintiff&rsquo;s trademark he forthwith ceased to use the trademark complained of. &lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;CONCLUSION&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Trademark becomes the face of the company, a company is first recognized by its consumer through its logo. In this era of brand competing against each other in an open market like India, it is important for one to be able to distinguish itself from other. Trademark also consist within itself the philosophical value upon which the company was founded and hence is a very sensitive asset of a company. A company should also be able to protect its trademark, as company earns goodwill through its operation in the market for ages and it directly gets associated with the trademark of the company, any unauthorized use of a trademark might bring down the &ldquo;face value&rdquo; of the company. Continuous breach of trademark might bring down the profits of a company. Indian law recognizes both registered and unregistered trademark and aims to protect them through enactment of Trademark act, 1999. Various remedy is available to a victim company of trademark infringement and a suit in court can be brought up to abstain others and also can claim compensation for the same.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Author:-&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Arko Sarkar, 3rd year student school of law, KIIT&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Devashish Kumar Sahoo, 3rd year student school of law, KIIT&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;white-space: pre-wrap;&quot;&gt;Soupayan Sinha Roy, 3rd year student school of law, KIIT&lt;/span&gt;&lt;/h4&gt;&lt;/div&gt;', '7100b206d851cf8f5ea1bd9a52b3e314.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 19:30:31', '2020-12-23 03:06:24');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(33, 'Zfowb2lpFHcXFas59QTUJ5Deb', 'TSUhvAg9KIuGOC5DrA7yLvekJ', ' Child Custody Mother or Father.  Nadir Modi. Advocate. Mumbai.', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: &quot; segoe=&quot;&quot; ui=&quot;&quot; historic&quot;,=&quot;&quot; &quot;segoe=&quot;&quot; ui&quot;,=&quot;&quot; helvetica,=&quot;&quot; arial,=&quot;&quot; sans-serif;=&quot;&quot; color:=&quot;&quot; rgb(228,=&quot;&quot; 230,=&quot;&quot; 235);=&quot;&quot; font-size:=&quot;&quot; 15px;=&quot;&quot; background-color:=&quot;&quot; rgb(36,=&quot;&quot; 37,=&quot;&quot; 38);&quot;=&quot;&quot;&gt;&lt;h4 style=&quot;font-family: inherit;&quot;&gt;Article by Nadir Modi, Advocate, Mumbai. 1994 (3) SCC J-42&lt;br&gt;1. Custody of child after break-up of marriage &mdash; More often custody is given to the mother when the child is below 7 years &mdash; Modern tendency &mdash; Judges show understanding and compassion and moved away from earlier pattern of judgments &mdash; Reference made to a few Indian decisions wherein custody was given to the father even when the child was below 7 years &mdash; Welfare of the minor is the paramount consideration &mdash; A note on a movie in connection with the discussion &mdash; Conclusion &mdash; Whether the custody of a minor child is to be with the father or mother is a question of fact &mdash; Approach of the Indian courts to be welcomed.&lt;br&gt;2. When marriages break up, bitter and prolonged battles often follow over the custody of minor children.&lt;br&gt;3. More often than not, the custody of minor children particularly of children under 7, is given to the mother. Questions such as whether she is psychologically fit to rear the child or whether the psychological growth of the child will be better if the custody is given to the father, raise relevant factors to which more judicial attention could be usefully given.&lt;br&gt;5. The modern tendency in child custody cases is to avoid any decisions based on any a priori assumption that for the welfare of the child the custody should be given to the mother. Increasingly judges show understanding and compassion in their decisions and have moved away from the earlier pattern of judgments which unwittingly tended in the words of Dr Arnold A. Hutschnecker to be cruel, stereotyped and void of any genuine psychological awareness of the child&rsquo;s needs or interests.&lt;br&gt;6. A few Indian decisions show how the much spoken of paramount welfare of the child has been safeguarded by the custody of minors being given to the fathers and their families.&lt;br&gt;7. In Shoib @ Shebu v. Sabir Ali1 the Allahabad High Court while conceding the entitlement of the mother the custody of her male child until he has completed the age of seven years held that the welfare of the child would be kept in view before deciding the custody. In that case in fact the son who was only 4 years of age was allowed to remain with the father and the Court without arriving at any adverse conclusions regarding the mother&rsquo;s character or conduct decided that it was in the paramount interest of the 4 year old son to allow him to remain with the father and the father&rsquo;s family.&lt;br&gt;8. In Bilkis w/o Munne Khan v. Munne Khan2, a Mohammedan wife who was living separately from her husband filed a petition for custody of her minor son aged about 21/2 years. It was found that she was residing at a distance from the husband&rsquo;s home and neglecting the child even when their relations were cordial. On these facts the court held that it was not in the interest of the welfare of the child though the child was of tender years to give his custody to the wife. Custody of the child therefore was given to the father.&lt;br&gt;9. In Y. Varalakshmi v. Kanta Durga Prasad3, the Division Bench of the Andhra Pradesh High Court gave custody of 5 year old boy to the father in the interests of the child. The child had been happily residing with the father  and his parents when the mother had applied for custody. The trial court refused custody to the mother and the appeal court upheld the refusal.&lt;br&gt;10. This decision contrasts favourably with the fictional decision in the much talked about movie, Kramer v. Kramer, where the father and not the mother was bringing up the son aged about 6 years. In the film, the husband, a young, ambitious vice-president of a company, is not aware of the emotional needs of his very attractive wife. In her quest for &rdquo;fulfilment&rdquo;, she chooses to leave her husband and her young child with seemingly no previous quarrel. She goes to California, sees a psychiatrist, enters fresh liaisons and after about two years returns to New York to sue for custody of her son. The Judge proceeds on the patently erroneous basis that it should be routine procedure to award the custody of a child to a mother, whether she is psychologically fit to rear the child or not.&lt;br&gt;11. The Judge awards the mother the custody of the child, a decision that is depicted in the film, as cruel and void of humanity. The mother is at first triumphant. But then comes a dramatic change of heart. Perhaps seeing the pain of the defeated ex-husband (or is it a flash of guilt or magnanimity), she allows the child to stay with the father.&lt;br&gt;12. This film as commented on by Dr Hutschnecker, reflects a modern trend that corrodes, if not the sanctity of marriage, then at least a deeper meaning of a commitment.&lt;br&gt;13. Why did this woman marry this particular man? His looks? His future that seemed secure? Did she use him for a start in her own life? And why did she not talk to him if she left dissatisfied? Both were educated people. Why, instead of trying to communicate and come to an understanding, did she, like an angry and irresponsible child, run away to satisfy her own selfish needs? Was it for survival or simply an ego tussle or a power play?&lt;br&gt;14. True, the man pursuing his own American dream was so busy building his career that he perhaps did not notice his wife&rsquo;s dissatisfaction. Evidently they did not communicate and thus were unaware of each other&rsquo;s needs and feelings.&lt;br&gt;15. It is the story of many people who thought they were in love, which dynamically means they move towards one another. But contrary to usual experience, when people begin to fall out of love, for whatever reasons, they move against one another. That is, they either fight or make adjustments. In the film they move away from each other &mdash; a breaking away or, symbolically death!&lt;br&gt;16. It is heartening to note that Indian Courts in many respects show a greater awareness of human needs and do not blindly or short-sightedly follow the &rdquo;mother first&rdquo; principle while deciding custody cases.&lt;br&gt;17. In Lekh Raj Kukreja v. Smt Raymon4, the Court was concerned with the question of the interim custody of a minor male child aged 11 years. The  trial court gave the custody to the mother on the ground that the minor son would then be in the company of his sister whose custody was with the mother.&lt;br&gt;18. In revision it was held that the father was the natural guardian and that the welfare of the child also demanded that he should be in the custody of his father especially as the child himself also showed an inclination to stay with the father.&lt;br&gt;19. On the same lines, in Tara Chand Mavar v. Basanti Devi5, the Division Bench of the Rajasthan High Court in appeal reversed the decision of the Family Court giving custody of a 7 year old minor son to his mother stating that sentimental considerations in favour of the mother ought not to prevail over the welfare of the minor where the father was a fit person to be a guardian and in the opinion of the Court it was in the interest of the minor son that he should be with the father and the father&rsquo;s family.&lt;br&gt;20. In Shailaja J. Erram v. Jayant V. Erram6 once again the same question was decided by a Bench of the Bombay High Court in the same manner. In this case the mother was a working woman and remained outside the home until 4 p.m. The minor &mdash; a son &mdash; expressed his desire to reside with his father. The Court found that the minor was getting his education properly and that the aged parents of the father were in a position to look after the minor for the whole of the day. In these circumstances the Court came to the conclusion that the welfare of the minor demanded that he should be with the father and his family and not with the mother.&lt;br&gt;21. It is not intended to suggest that in every case, or in most cases, it is in the interest of the minor that he should remain with the father and his family. Any such proposition would be as unjust and unsupportable as the opposite proposition viz. that in every case, or in most cases, the custody of the minor should remain with the mother.&lt;br&gt;22. There can be no general presumption to the effect either that the female of the species is deadlier than the male, or that she is more beneficient than the male when it comes to the question of the custody of these unfortunate minors.&lt;br&gt;23. In each case it is a question of fact, and should be a matter of anxious consideration for the Court as to where the welfare of the child lies. The Indian Courts&rsquo; approach has therefore to be welcomed.&lt;br&gt;&mdash;&mdash;&mdash;&lt;br&gt;1. 1986 (II) DMC 505 at 506 (All, HC)&lt;br&gt;2. 1987 (32) M.P.L.J. 430&lt;br&gt;3. (1989) 1 DMC 379&lt;br&gt;4. 1989 (38) DLT 137&lt;br&gt;5. 1989 (1) DMC 402 (Raj)&lt;br&gt;6. 1990 (2) Mah LR 492&lt;/h4&gt;&lt;/div&gt;', '548a7e156507390be6d5e97012b6c8d7.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 19:48:34', '2020-12-23 03:06:02');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(34, 'U3HdtnFtxMujU2Rndpfqs3Ytx', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Comparative advertisement.  Mr. Pawan Kumar Pandey and Dr. Ram Manohar Lohia ', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Article by Mr. Pawan Kumar Pandey, Asstt. Professor of Law, Dr. Ram Manohar Lohia National Law University, Lucknow.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Introduction&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1. &ldquo;Comparative advertisement&rdquo; has brought vast opportunities and at the same time, tremendous challenges before the present day open economy. It is nothing but a keen sense of competition and the desire to capture markets which has resulted into comparative advertising. Broadly speaking a comparative advertising can be understood as an advertising of a product or service, by comparing or drawing an analogy with similar products or services of the competitors. Mostly, the products or services are advertised comparing it with other products or services and depicting itself to possess the characteristics which &ldquo;others lack&rdquo;. Sometimes, also boasting their product, and claiming how they are &ldquo;superior&rdquo; or &ldquo;best&rdquo;. An advertiser may use packaging, shape or a style distinctive to a particular brand, while in the same literature, give it an &ldquo;ordinary&rdquo; label. It basically involves an honest and true comparison of the factors of one trader&rsquo;s products and services with those of another, so as to make an impact upon the minds of the consumers.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2. There is a thin dividing line between comparative advertising rights and wrongs. Thus, one should be wary in his approach towards the same. If, on the one hand, comparative advertising can rightfully be used as an important business strategy for the successful promotion of the products and services of a trader. On the other hand, if proper precaution is not taken, it may inescapably result into various wrongs, to name a few, commercial disparagement, trade marks infringement, passing off, and unfair trade practices, etc.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;3. Unlike the UK, USA or China, India does not have in place a specific statute regulating the area of comparative advertising. Recently enforced, the Competition Act, 2002 also does not explicitly make a mention of comparative advertising. In the scarcity of a specific legislation on the subject, the law relating to comparative advertising in India seems to be scattered. Inevitably, the law on commercial torts, free speech, trade marks, unfair  competition and the guidelines laid in several leading judgments govern the present regime of comparative advertising litigation in India.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Comparative Advertising as &ldquo;Commercial Speech&rdquo;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;4. An advertisement which tends to enlighten the consumer either by exposing the falsity or misleading nature of the claim made by the trade rival or by presenting a comparison of the merits (or demerits) of their respective products, is for the public good and hence cannot be taken to be an actionable wrong, unless it is motivated by malice and is also false. This is on account of the fact that a competitor is better equipped to make such an exposure than anyone else and hence the benefit that would flow to the society at large on account of such exposure would always outweigh the loss of business for the person affected.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;5. If two trade rivals indulge in puffery without hitting each other, the consumer is misled by both, unless there is increased awareness or governmental intervention. On the other hand, if both are restrained from either making false representations/incorrect representations/misleading representations or issuing unintended warranties (as defined as unfair trade practice under the Consumer Protection Act), then the consumer stands to gain. Similarly, permitting two trade rivals to expose each other in a truthful manner, will also result in consumer education.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;6. Supreme Court of India, way back in year 1995, in Tata Press Ltd. v. Mahanagar Telephone Nigam Ltd.1, recognised &ldquo;commercial speech&rdquo; to be included within the expression of &ldquo;freedom of speech and expression&rdquo;2. It was observed that:&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;a. &ldquo;23. &hellip;.the public at large has a right to receive the &ldquo;commercial speech&rdquo;. Article (19)(1)(a) not only guarantees freedom of speech and expression, it also protects the rights of an individual to listen, read and receive the said speech. So far as the economic needs of a citizen are concerned, their fulfilment has to be guided by the information disseminated through the advertisements. The protection of Article 19(1)(a) is available to the speaker as well as to the recipient of the speech. The recipient of &ldquo;commercial speech&rdquo; may be having much deeper interest in the advertisement than the businessman who is behind the publication. An advertisement giving information regarding a life saving drug may be of much more importance to general public than to the advertiser who may be having purely a trade consideration.&rdquo;3&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;7.  It was further observed that &ldquo;Commercial speech&rdquo; cannot be denied the protection of Article 19 (1)(a) of the Constitution merely because the same is issued by businessmen. The Supreme Court was categorical in stating, &ldquo;Advertising which is no more than a commercial transaction is, nonetheless, dissemination of information regarding the product advertised. Public at large is benefited by the information made available through the advertisement.&rdquo;4 It was also observed that &ldquo;in a democratic economy free flow of commercial information is indispensable. There cannot be honest and economical marketing by the public at large without being educated by the information disseminated through advertisements. The economic system in a democracy would be handicapped without there being freedom of &ldquo;commercial speech&rdquo;.5&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;8. Once it is accepted that free commercial speech is a fundamental right guaranteed under Article 19(1)(a), then the curtailment of the same can only be by law that would fall under Article 19(2) imposing a reasonable restriction on such a right, in the interests of the sovereignty and integrity of India, the security of the State, friendly relations with foreign States, public order, decency or morality or in relation to contempt of court, defamation or incitement to an offence.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Comparative Advertising under Trade Marks Law vis-&agrave;-vis Commercial Disparagement&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;9. As per Section 29(1) of the Trade Marks Act, 1999, &ldquo;A registered trade mark is infringed by a person who, not being a registered proprietor or a person using by way of permitted use, uses in the course of trade, a mark which is identical with, or deceptively similar to the trade mark in relation to goods or services in respect of which the trade mark is registered and in such manner as to render the use of the mark likely to be taken as being used as a trade mark&rdquo;. The expression &ldquo;in relation to any goods in respect of which the trade mark is registered&rdquo; in Section 29(1) makes it clear that there is no infringement of a mark unless the infringer uses the mark in relation to same goods covered by the registration. Therefore, sometimes, the defendant may take the following defences:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(a) that the defendant has not used plaintiff&rsquo;s trade mark and device on their products in the course of their trade nor in relation to any goods in respect of which the trade mark is registered;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(b) that the defendant has not sold their merchandise goods under the  trade mark of the plaintiff;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(c) that the defendant has not advertised their products under the plaintiff&rsquo;s trade mark; and&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(d) it is not disputed that comparative advertisements are permissible in law.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;10. But it is fundamental principle of trade mark law that the function of a trade mark is to indicate the origin of the goods to which it is applied. The expression &ldquo;in the course of trade&rdquo; has a definite connotation. In order to constitute infringement, the use complained of must be a use in the course of trade. The defendants must be dealing or selling of in some other way trading in the goods bearing the offending mark. Possession of such goods for the purpose of comparison will not amount to infringement. The right conferred by registration is a right to use the mark in the course of trade and obviously this right is infringed only when the infringer also uses the mark in the course of trade. The use &ldquo;in the course of trade&rdquo; means in the course of business. It did not mean use as a trade mark. The purpose for which the mark was applied will not prevent it constituting an infringement provided it was used in the course of trade and was capable of indicating a connection in the course of trade between the goods and the proprietor of the registered trade mark.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;11. Section 30(1) of the Trade Marks Act, 1999 in effect permits comparative advertising, stating that &ldquo;Nothing in Section 29 shall be preventing the use of registered trade mark by any person with the purposes of identifying goods or services as those of the proprietor provided the use: (a) is in accordance with the honest practices in industrial or commercial matters; and (b) is not such as to take unfair advantage of or be detrimental to the distinctive character or repute of the trade mark&rdquo;. Further, Section 29(8) of the said Act, discussing what form of advertising would amount to infringement, reads &ldquo;A registered trade mark is infringed by any advertising of that trade mark if such advertising: (a) takes unfair advantage and is contrary to honest practices in industrial or commercial matters; or (b) is detrimental to its distinctive character; or (c) is against the reputation of the trade mark&rdquo;. In effect, the provisions read together allow comparative advertising as long as the use of the registered trade mark does not amount to infringement. If an advertiser makes a consumer aware of the truth, there is nothing wrong with it. The reason for this is that a party cannot be held liable for libel when all that has been stated is the truth, which is a complete defence against any assault or challenge regardless of whether any damage is sustained as a result of it.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;12. Recently, in Paras Pharmaceuticals Ltd. v. Ranbaxy  Laboratories Ltd.6, the High Court of Gujarat was faced with a comparative advertising case in which the counsel for the appellant successfully contended that the respondents have used the mark without any license or permission from the appellant, therefore, as per the provisions of Section 29 of the Trade Marks Act, 1999 the respondents are liable for infringement. It was held in this case that, &ldquo;since the appellant&rsquo;s product is much popular amongst the general public as a pain reliever, the respondent has tried to take unfair advantage which may amount to an infringement of the Trade Mark within the meaning of Section 29(8)(a) of the Act. By taking shelter of a non-existent product violet coloured pack, if the respondent tries to establish that its product is true pain reliever than the other product, it would certainly affect the reputation of the trade mark of the appellant and to this extent, clause (c) of Section 29(8) of the Act can also be invoked for the purpose of satisfying the Court that the respondent has infringed the trade mark of the appellant.&rdquo;7&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;13. The trade marks law also finds applicability to well known unregistered marks where action of passing off can be resorted to At this juncture the difference in approach in a passing off action and one for disparagement must also be understood. In a case of passing off, the question invariably is whether the trade mark or trade dress employed by A for his product is so deceptively similar to the established mark or trade dress of B&rsquo;s product that A&rsquo;s product could be confused by or passed off to consumers as B&rsquo;s product? Here the comparison is of rival products having a similar trade mark, get-up or trade dress. Familiarity with the established mark, trade dress or get-up is presumed. Because of this familiarity the person intending to pass off his goods as those of the famous or more popular, exploits. In the case of disparagement, the one who &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;14. disparages another&rsquo;s product does not seek to make his product similar to the disparaged product, but to distinguish it from the disparaged product. The object of disparagement is to make the disparaged product appear to be as near or similar to the competitor&rsquo;s product. The comparisons, therefore, in cases of passing off and in cases of disparagement are different. Consequently, the comparison must be from the perspective of an average person with imperfect recollection but, that person must be picked from the category of users of the product allegedly sought to be disparaged or slandered.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;15. It is otherwise where a trader does not limit himself to a comparison of his goods with those manufactured by another trader and a mere statement that they are inferior in quality to his own, but goes further and makes an  untrue statement of fact about his rival&rsquo;s goods, for example, where he states that they are rotten or unmerchantable. In a case like this, an action on the case will lie, provided it can be proved that such statement was published maliciously and that special damage has ensued.8 It is not malice if the object of the trader is to push his own business. To make the act malicious it must be done with the direct object of injuring the other person&rsquo;s business. Therefore, the mere fact that it would injure that other person&rsquo;s business is no evidence of malice.9&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;16. Walton J in De Beers Abrasive Products Ltd. v. International General Electric Co. of New York Ltd.10 has summarized the law point as, &ldquo;what precisely is the law on this point? It is a blinding glimpse of the obvious to say that there must be a dividing line between statements that are actionable and those which are not; and the sole question upon a dry point of law such as we are discussing here is: where does that line lie? On the one hand, it appears to me that the law is that any trader is entitled to puff his own goods, even though such puff must, as a matter of pure logic, involve the denigration of his rival&rsquo;s goods. Thus in the well-known case of the three adjoining tailors who, put notices in their respective windows reading: &ldquo;The best tailor in the world&rdquo;, &ldquo;The best tailor in this town&rdquo;, and &ldquo;The best tailor in this street&rdquo;, none of the three committed an actionable wrong.&rdquo;11&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;17. Where, however, the situation is not that the trader is puffing his own goods, but turns to denigrate those of his rival, and then the situation is not so clear cut. Obviously the statement: &ldquo;My goods are better than X&rsquo;s&rdquo; is only a more dramatic presentation of what is implicit in the statement: &ldquo;My goods are the best in the world&rdquo;. Accordingly, such a statement would not be actionable. At the other end of the scale, if what is said is: &ldquo;My goods are better than X&rsquo;s&rdquo;, because X&rsquo;s are absolute rubbish&rdquo;, then it is established by dicta of Lord Shand in the House of Lords in White v. Mellin12, which were accepted by Walton J as stating the law, this statement would be actionable.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;18. The New International Websters&rsquo; comprehensive dictionary defines disparage/disparagement to mean, &ldquo;to speak of slightingly, undervalue, to bring discredit or dishonour upon, the act of deprecating, derogation, a condition of low estimation or valuation, a reproach, disgrace, an unjust classing or  comparison with that which is of less worth, and degradiation. The Concise Oxford Dictionary defines disparage as under, to bring discredit on, slightingly of and depreciate. McCarthy on Trade Marks and Unfair Competition (Fourth Edition, Volume 4 at 27:38) explains &ldquo;Puffing&rdquo; to be exaggerated advertising, blustering, and boasting upon which no reasonable buyer would rely and is not actionable.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;19. Finally, it is clear that between clear-cut cases of permissible comparative advertising and impermissible &ldquo;rubbishing&rdquo; of a rival&rsquo;s product there may yet be a wide field of cases and the dividing line in such cases would have to drawn based on the test whether a reasonable man would take the claim of the alleged slanderer seriously or take it with the proverbial &ldquo;large pinch of salt&rdquo; and dismiss it as mere puffery. If it is the former then, it is a case of disparagement and if it is the latter then, it is a case of mere puffery which is not actionable.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Comparative Advertising and Unfair Trade Practices&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;20. The Monopolies and Restrictive Trade Practices Act, 1969 (MRTP Act) vide Section 36-A(1)(x) provides for &ldquo;disparagement of goods of another person&rdquo; as an unfair trade practice. The said Section 36-A provides that &ldquo;unfair trade practice&rdquo; means a trade practice which, for the purpose of promoting the sale, use or supply of any goods or for the provisions of any services, adopts any unfair method or unfair or deceptive practice including any of the following practices, namely, (1) the practice of making any statement, whether orally or in writing or by visible representation which, (x) gives false or misleading facts disparaging the goods, services or trade of another person.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;21. The definition of &ldquo;unfair trade practice&rdquo; found in Section 36-A(1) of the MRTP Act, 1969, is adopted in pari materia in Section 2(1)(r) of the Consumer Protection Act, 1986. But once Section 66 of the competition act, 2002 is notified and the MRTP Commission is dissolved, a manufacturer or a stockist or a dealer, cannot invoke the provisions of the MRTP Act. But he may be able to approach the competition commission. However, he cannot invoke the provisions of the Consumer Protection Act, since that Act is intended only for the benefit of consumers and not for the benefit of manufacturers, marketers or service providers.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;22. Answering the question regarding the bar on jurisdiction of the ordinary civil court the Delhi High Court in Reckitt Benckiser (India) Limited v. Hindustan Lever Ltd.13, has made it clear that:&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;a.  &ldquo;in any event, a complaint under that the Consumer Protection Act, 1986 can only be qua a &ldquo;consumer dispute&rdquo; and that, too, by a consumer or a consumer association or the Government. It does not contemplate a complaint by a competitor. Furthermore, Section 3 of the Act also makes it clear that it shall not be in derogation of but in addition to the provisions of any other law for the time being in force. Thus, the Consumer Protection Act, 1986 does not stand in the way of the plaintiff from seeking remedies by way of this suit. Further, answering the similar question in reference to the MRTP Act, it was observed that the MRTP Act does not set-up any bar, either express or implied, to the institution of the present suit. The provisions of Section 9 of the Civil Procedure Code are clear. The plaintiff&rsquo;s right to seek the common law remedy in the civil courts has not been taken away by the enactment of the MRTP Act. The provisions of Section 4 as well as Section 12-B of the MRTP Act put the case beyond any doubt that the MRTP Act does not in any way bar the institution of a suit as the present one.&rdquo; 14&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Indian Judicial Pronouncements on Comparative Advertising&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;23. The vast majority of the viewer of the commercial advertisement on electronic media are influenced by the visual advertisements as these have a far reaching influence on the psyche of the people, therefore, discrediting the product of a competitor through commercial would amount to disparagement as has been held by the judiciary in India and abroad.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;24. In Reckitt and Colman of India Ltd. v. M.P. Ramachandran15 a learned Single Judge of the High Court of Calcutta had considered the concept of negative campaigning. The learned Judge after considering several English decisions including White v. Mellin16; Hubbuck &amp; Sons Ltd. v. Wilkinson, Heywood &amp; Clark Ltd.17; and De Beers Abrasive Products Ltd. v. International General Electric Co.18 observed as under19:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(i) A tradesman is entitled to declare his goods to be the best in the world, even though the declaration is untrue.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(ii) He can also say that his goods are better than his competitor&rsquo;s, even though such a statement is untrue.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt; (iii) For the purpose of saying that his goods are the best in the world or his goods are better than his competitor&rsquo;s he can even compare the advantages of his goods over the goods of others.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(iv) He, however, cannot while saying his goods are better than his competitors&rsquo;, say that his competitors&rsquo; goods are bad.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(v) If there is no defamation to the goods or to the manufacturer of such goods no action lies, but if there is defamation, an action lies.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;25. What is really relevant in context of such kind of advertising are conclusions (iv) and (v) mentioned above, which effectively mean that an advertiser can say that his goods are better than his competitors but he cannot say that his competitor&rsquo;s goods are bad because that would amount to slandering or defaming the competitor and its goods, which is not permissible. But if there is no derogatory reference at all to the goods or to the manufacturer, no action lies against that advertiser.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;26. The above decision of the Calcutta High Court was followed by a learned Single Judge of the Delhi High Court in Reckitt and Colman of India Ltd. v. Kiwi TTK Ltd.20. It was held that &ldquo;the general principle is that the courts will injunct an advertiser from publishing or circulating an article if the dominant purpose is to injure the reputation of the plaintiff&rdquo;21. An advertiser is not entitled to say that his competitor&rsquo;s goods are bad so as to promote his goods. If an action lies for defamation, an injunction may be granted. It was further held that though a comparative advertisement is permissible, the same shall not, in any manner, be intended to disparage or defame the product of the competitor.22&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;27. In an interesting case of Dabur India Ltd. v. Wipro Ltd.23, the defendant Wipro Limited was airing a TV commercial in respect of its product &ldquo;Wipro Sanjivani Honey&rdquo; with a view to belittle the plaintiff&rsquo;s product &lsquo;Dabur Honey&rsquo;. In the impugned advertisement it was shown that one Mrs Paradkar was shown holding a bottle of honey, which was as alleged, in fact the plaintiff&rsquo;s bottle (without the label) and the voice over was to the effect that the bottle was purchased two years ago but it has remained the same (jaisi ki waisi). In comparison one Mrs Rao purchased Wipro Sanjivani Honey, which got consumed almost immediately. Honorable Delhi High Court held that &ldquo;facts of the case suggested that the intent of the commercial was to suggest that the product of the defendant was far superior to that of the  plaintiff. It was permissible for an advertiser to proclaim that its product was the best which automatically implied that all other similar products were inferior. In comparative advertising, a consumer may look at a commercial from a particular point of view and come to a conclusion that one product is superior to the other, while another consumer may look at the same commercial from another point of view and come to a conclusion that one product is inferior to the other&rdquo;.24 It further added that &ldquo;the degree of disparagement must be such that it would tantamount to defamation. In the present case, the overall audio-visual impact did not leave an impression that the message that was sought to be conveyed by it was that Dabur Honey was being denigrated, but rather that Wipro Sanjivani Honey was better.&rdquo;25 Having found no element in the commercial which could be disapproved, the application for injunction was dismissed.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;28. Interestingly, the court suggested that a manufacturer of a product ought not to be hyper-sensitive in such matters. It is necessary to remember that market forces are far stronger than the best advertisements. If a product is good and can stand up to be counted, adverse advertising may temporarily damage its market acceptability, but certainly not in the long run.26&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;29. Again in Dabur India Ltd. v. Emami Ltd.27, where again an advertisement was attacked, the offending voice over of the advertisement was &ldquo;forget Chyawanprash in summers, eat Amritprash instead&rdquo; (Garmion mein Chyawanprash bhool jao, Himani Sona Chandi Amritprash khao). It was held that the aforesaid effort on the part of the defendant would be definitely a disparagement of the product Chayawanprash. It was clarified that &ldquo;even if there be no direct reference to the produce of the plaintiff and only a reference is made to the entire class of Chayawanprash in its generic sense, even in those circumstances disparagement is possible. For Dabur Chayawanprash is also a Chayawanprash as against which disparagement is made.&rdquo;28&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;30. The above decision can be further supported by Delhi High Court decision in Dabur India Ltd. v. Colgate Palmolive India Ltd.29, where learned single Judge took the view that the generic disparagement of a rival product without specifically identifying or pin pointing the rival product is equally objectionable. Clever advertising can indeed hit a rival product without  specifically referring to it. No one can disparage a class or genre of a product within which a complaining plaintiff falls and raise a defense that the plaintiff has not been specifically identified.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;31. In the above case, the advertisement showed a cine star stopping purchasers of Lal Dant Manjan powder and informing them of its ill effects by rubbing it on a pair of spectacles. The rubbing process left marks on the spectacles, which were termed as akin to sandpapering. The cine star was heard telling the purchaser that &ldquo;it is easy to change spectacles but not the teeth&rdquo;. The Delhi High Court found a fit case of commercial disparagement and injunction was granted. The learned Single Judge reiterated the principle that, while praising its product, an advertiser cannot describe the competitor&rsquo;s product as inferior, thereby damaging its reputation.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;32. In Karamchand Appliances (P) Ltd. v. Shri Adhikari Bros.30, the Delhi High Court was concerned with mosquito repellents ALL OUT and GOOD NIGHT. The offending advertisement showed a lady removing the ALL OUT pluggy and replacing it with GOOD NIGHT with a background voice claiming that the latter&rsquo;s turbo vapour chases the mosquitoes at double the speed. While granting an injunction, the Delhi High Court held in Paragraph 19 as&mdash;&ldquo;two propositions clearly emerge from the above pronouncements, namely, (1) that a manufacturer or a tradesman is entitled to boast that his goods are the best in the world, even if such a claim is factually incorrect, and (2) that while a claim that the goods of a manufacturer or the tradesman are the best may not provide a cause of action to any other trader or manufacturer of similar goods, the moment the rival manufacturer or trader disparages or defames the goods of another manufacturer or trader, the aggrieved trader would be entitled to seek reliefs including redress by way of a prohibitory injunction.&rdquo;31&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;33. Again, in Godrej Sara Lee Ltd. v. Reckitt Benckiser (I) Ltd.32, the Delhi High Court was concerned with an advertisement in which an insecticide by name MORTEIN was shown to be more effective in destroying cockroaches and mosquitoes than the plaintiff&rsquo;s product HIT, which had two versions, one for mosquitoes and one for cockroaches. A.K. Sikri, J., of the Delhi High Court analysed in detail, the entire case law on the subject. However, he refused injunction on the ground that the plaintiff was guilty of concealment of material facts and also on the ground that the advertisement just highlighted the product of the defendant as better than that of the competitor.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;34.  In another famous case,33 Pepsi filed suit against Hindustan Coca Cola. The impugned commercial showed that the lead actor asks a kid as to which is his favourite drink? The Kid utters the word &ldquo;Pepsi&rdquo;, which can be seen from his lip movement though the same is muted. The lead actor thereafter asks the boy to taste two drinks in two different bottles covered with lid and asks the question &ldquo;Bacchon Ko Konsi pasand aayegi?&rdquo; After taste the boy points out to one drink and says that that drink would be liked by the children because it is sweet. In his words he says. &ldquo;Who meethi hain, Bacchon ko meethi cheese pasand hai.&rdquo; He preferred the other drink which according to him tastes strong and that grown up people would prefer the same. And later the stronger one came out be &ldquo;Thums Up&rdquo;, and one which is sweet, word &ldquo;Pappi&rdquo; is written on the bottle with a globe device and the colour that of the &ldquo;Pepsi&rdquo;. It was further brought to the notice of the court that there are other commercials by the respondents where the lead actor said &ldquo;Wrong choice baby&rdquo;, and that the &ldquo;Thums Up&rdquo; is a right choice, and &ldquo;Kyo Dil Maange No More&rdquo; for the appellant&rsquo;s products. It was categorically held that by calling the Cola drink of the appellants &ldquo;Yeh Bachhon Wali Hai, Bachhon Ko Yeh Pasand Aayegi&rdquo; and &ldquo;Wrong Choice Baby&rdquo;, the respondents depicted the commercial in a derogatory and mocking manner. It can&rsquo;t be called puffing up. It was further observed that repeatedly telecasting this commercial will leave an impression on the mind of the viewers that product of the appellant i.e. &ldquo;Pepsi&rdquo; is simply a sweet thing nor meant for grown up or growing children. If they choose &ldquo;Pepsi&rdquo;, it would be a wrong choice. The message is that kids who want to grow should not drink &ldquo;Pepsi&rdquo;. They should grow up with &ldquo;Thums UP&rdquo;. Accordingly the court found disparagement of the appellant&rsquo;s product. It was held that in deciding the question of disparagement, the following factors have to be kept in mind: (i) intent of the commercial; (ii) manner of the commercial; and (iii) story line of the commercial and the message sought to be conveyed by the commercial. If the manner is ridiculing or the condemning product of the competitor then it amounts to disparaging but if the manner is only to show one&rsquo;s product better or best without derogating other&rsquo;s product then that is not actionable.34&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Conclusion&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;35. In a free market economy, the products will find their place, as water finds its level, provided the consumers are well informed. Consumer education, in a country with limited resources and a low literacy level, is possible only  by allowing a free play for the trade rivals in the advertising arena, so that each exposes the other and the consumer thereby derives a fringe benefit. Therefore, it is only on the touchstone of public interest that such advertisements are to be tested. This is why the Supreme Court held in Tata Press case that &ldquo;Public at large is benefited by the information made available through the advertisement&rdquo;. As a matter of fact the very basis of the law relating to trade marks is also the protection of public interest only, since the courts think of an unwary purchaser, who may buy a spurious product on the mistaken impression that it was brand &ldquo;x&rdquo;. The same logic should form the basis for an action in respect of disparaging advertisements also.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;36. Effective advertising delivers a message that is remembered. It can change the way the world views a product or service and can generate sales. If the market for a service or product is well-defined, comparative advertising can held the products or services distinguish itself from the competition. Nothing seems to do this more efficiently than comparative advertising. In the electronic media the disparaging message is conveyed to the viewer by repeatedly showing the commercial everyday thereby ensuring that the viewers get clear message as the said commercial leaves an indelible impression in their mind. The Indian law nowhere renders comparative advertising as illegal; however, it defines a restrictive ambit. Statutes such as the Trade Marks Act, 1999 and the provision in the Constitution on the Freedom of Speech and Expression i.e. Article 19(1)(a), coupled with the limitations governing it, provide statutory support to the subject. In the absence of a statutory provision dedicated to comparative advertising, the jurisprudence on it is well developed through renderings and decisions of the courts.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1 (1995) 5 SCC 139 : AIR 1995 SC 2438.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2 (1995) 5 SCC 139 : AIR 1995 SC 2438, 2448.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;3 (1995) 5 SCC 139 : AIR 1995 SC 2438, 2448.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;4 (1995) 5 SCC 139 : AIR 1995 SC 2438, 2448, 2447.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;5 (1995) 5 SCC 139 : AIR 1995 SC 2438, 2448.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;6 AIR 2008 Guj 94.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;7 AIR 2008 Guj 94 at 105.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;8 See Lyne v. Nicholls, (1906) 23 T.L.R. 86.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;9 see Dunlop Pneumatic Tyre Co. v. Maison Talbot, (1904) 20 T.L.R. 579.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;10 (1975) 1 WLR 972 : (1975) 2 All ER 599 cited in Reckitt Benckiser (India) Ltd. v. Hindustan Lever Ltd., (2008) 38 PTC 139 (Del) at p. 157.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;11 (1975) 1 WLR 972 : (1975) 2 All ER 599 cited in Reckitt Benckiser (India) Ltd. v. Hindustan Lever Ltd., (2008) 38 PTC 139 (Del) at p. 157.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;12 (1895) AC 154 HL(E).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;13 (2008) 38 PTC 139 (Del).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;14 (2008) 38 PTC 139 (Del) at pp. 165, 166.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;15 (1999) 19 PTC 741.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;16 1895 AC 154.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;17 (1899) 1 QB 86.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;18 1975 (2) All ER 599.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;19 Reckitt and Colman of India Ltd. v. M.P. Ramchandran, (1999) 19 PTC 741 at p. 746.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;20 (1996) PTC 16 393.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;21 (1996) PTC 16 393 at p. 398.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;22 (1996) PTC 16 393 at p. 400.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;23 (2006) 32 PTC 677 (Del).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;24 (2006) 32 PTC 677 (Del) at p. 681.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;25 (2006) 32 PTC 677 (Del)&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;26 (2006) 32 PTC 677 (Del) at p. 682.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;27 (2004) 29 PTC 1 (Del).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;28 (2004) 29 PTC 1 (Del) at p. 6.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;29 AIR 2005 Del 102.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;30 (2005) 31 PTC 1 (Del).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;31 (2005) 31 PTC 1 (Del) at 9, 10.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;32 (2006) 32 PTC 307.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;33 Pepsi Co. Inc. v. Hindustan Coca Cola Ltd., (2003) 27 PTC 305 (Del.) (DB).&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;34 Pepsi Co. Inc. v. Hindustan Coca Cola Ltd., (2003) 27 PTC 305 (Del.) (DB) at 311.&lt;/div&gt;&lt;/div&gt;', '5bbd43ac01ea695bfb9f5a21df3403e0.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:18:58', '2020-12-23 03:05:28');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(157, 'rpOh3iUJXzkRhNkCApFqFWIwR', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A note on Mareva Injunction', '&lt;h4&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;While a creditor is looking for judgment in one jurisdiction he may want to safeguard the debtor&#039;s assets located in a different jurisdiction so that at the end of the process he is able to enforce his judgment. To this end, he may want to obtain a Mareva injunction, also known as a freezing order, from the court of the jurisdiction where the assets are held. (Philip Jeyaretnam and Lau Wen Jin, (2016) 28 SAcLJ 503).&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Historical Background:&lt;/b&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The name &ldquo;Mareva Injunction&rdquo; owes its origin to a freezing order by the English court in Mareva Compania Naviera SA v International Bulkcarriers SA [1980] 1 All ER 213]. An order of injunction is issued in favour of a creditor who has a right to be paid the debt owing to him, even before he has established his right by getting judgment for it. The test is; the debt is due and owing, and there is a danger that the debtor may dispose of his assets so as to defeat it before judgment. The court has jurisdiction in a proper case to grant an interlocutory judgment so as to prevent him disposing of those assets.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;It is important to note that in the case of a Mareva, the court does not alter the substantive rights of the parties, but preserves the status quo until it has determined the action. Similar principle is reiterated by the Supreme Court in respect of temporary injunctions in Dalpat Kumar v. Prahlad Singh, (1992) 1 SCC 719 . The court held that the order of temporary injunction is in the nature of preventive relief to a litigant to prevent future possible injury. In other words, the court, on exercise of the power of granting ad interim injunction, is to preserve the subject matter of the suit in the status quo for the time being.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The objective of Mareva order is that a natural person should not step down from his living standards by reducing his assets just before the judgment or to avoid the payment. Polly Peck International Plc v Nadir AILII Citation Number: [1992] EWCA Civ 3&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Grounds for Mareva Injunction:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;1.&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem; white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;There should be an evidence of the real risk of dissipating the assets.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;2.&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem; white-space: pre;&quot;&gt;	&lt;/span&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Any alleged dishonesty must have a &ldquo;real and material&rdquo; relation to the risk of dissipation such that the necessary inference of fact may be drawn. (Yves Charles Edgar v. Accent Delight International Ltd., [2015] 5 SLR 558)&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Nature of the order. Once granted, a Mareva injunction has immediate effect on every asset of the defendant covered by the injunction. It is a method of attachment, which operates in rem in the same manner as the arrest of a ship and because any&amp;nbsp; authority which third parties may have to deal with the asset in accordance with the instructions of the defendant is revoked once such third parties have notice of the injunction. - Z Ltd vs A 1982 1 All ER 556 - referred to in Vidya Charan Shukla v. Tamil Nadu Olympic Association, 1991 SCC OnLine Mad 3.&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;In India:&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Civil Procedure Code - Section 38 says that a decree may be executed either by the Court which passed it, or by the Court to which it is sent for execution. Section 39 deals with transfer of decree. However, grant of Mareva injunction which is interlocutory in nature can be traceable to inherent powers of the court under Section 151.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Mareva injunction and Attachment before judgment.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;Order 38 Rule 5 CPC empowers the courts to attach property of the defendant pending adjudication of the suit. Attachment before judgment and Mareva injunction are similar to each other. They are granted under similar circumstances on similar grounds. However, the fundamental difference is while Mareva injunction simply restrains the defendant by injunction, attachment before judgment is a lien on the property. It is an attachment of the property by the court.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The Calcutta High Court in Popular Jute Exchange Limited vs Murlidhar Ratanlal Exports Ltd. 1998 2006 (4) CHN 381 has exhaustively explained the meaning. Mareva Injunction, the court says, is an established feature of English Law and the English Court has been categorical enough to record that there should not be any hesitation in the matter of such a grant where it appears likely that the plaintiff would recover judgment against the defendant for a certain or approximate sum and there is reason to believe that the defendant has the assets within the jurisdiction to meet the judgment but may deal with the same, so that they would not be available or traceable when the judgment is given against him.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;The concept of grant of Mareva Injunction is not different from the power of the Court to grant interlocutory or final order of an injunction and under this general power of jurisdiction to grant an ex parte injunction the English Court has developed a principle that the Court has power to restrain the defendant from removing assets from the jurisdiction pending the trial of action whenever it was just and convenient to do so. This power was originally exercised when the defendant was out of the jurisdiction but has subsequently been extended so as to be available against a defendant even though he is based within the jurisdiction. Popular Jute Exchange Limited vs Murlidhar Ratanlal Exports Ltd. 1998 2006 (4) CHN 381&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;In Mohit Bhargava v. Bharat Bhushan Bhargava, (2007) 4 SCC 795 the Supreme Court dealt with an order passed by the executing court that the documents produced by the third party be kept in safe custody of the court. The Supreme Court termed the order as within the jurisdiction of the court which passed the decree since they are only orders of restraint being issued to a person from handing over a property in his possession to the judgment-debtor along with the documents concerned and keeping the documents in safe custody. The court also termed the order as a &ldquo;freezing order&rdquo; or a &ldquo;Mareva injunction and an order akin to an Anton Piller order, that can be issued even if the property or the person concerned is outside the jurisdiction of the court.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;&lt;b&gt;Note:&lt;/b&gt; An Anton Piller Order is a form of civil search warrant that displaces the normal rules on discovery of records. It enables the Applicant to attend at the premises of the Defendant, without notice, and take possession of the records of the Defendant Anton Piller v Manufacturing Processes Ltd: CA 8 Dec 1975.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;A Mareva injunction freezes a party&rsquo;s assets to prevent it from dissipating the assets before the arbitral proceedings have concluded, and frustrating satisfaction of the eventual award if this goes against the dissipating party. A Mareva injunction also takes effect against third parties such as banks, to prevent them from assisting in the dissipation of the assets. Anton Piller orders allow a party to secure and preserve property by entering and searching the opposing party&rsquo;s premises. Such property could include documentary evidence, or items implicated in the dispute, such as counterfeit goods. Mareva injunctions and Anton Piller orders are usually sought under very urgent circumstances. For maximum efficacy, they are also typically sought ex parte without notice to the opposing party, to preclude the opposing party from pre-empting the orders by disposing of the assets or goods before the orders are granted. When such relief is sought therefore, the parties would have to approach national courts for assistance. Benoit Le Bars and Tejas Shiroor&amp;nbsp; &lsquo;Provisional Measures in Investment Arbitration: Wading through the murky waters of enforcement&rsquo; 6IJAL(2017)24&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 1.3125rem;&quot;&gt;In conclusion, the power to grant Mareva injunction, though traceable to inherent powers of the Court, such power is guided by the sound judicial principles evolved in respect of similar orders i.e. attachment before judgment and temporary injunction. The purpose of the order, as explained by the Supreme Court is to preserve the subject matter of the suit in the status quo for the time being.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify;&quot;&gt;&lt;i&gt;&lt;b&gt;Sumana Chamarthy, Advocate, Bengaluru.&amp;nbsp;&lt;/b&gt;&lt;/i&gt;&lt;/h4&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;br&gt;&lt;/div&gt;', '00c71a06346a3e4717b832f55bee29d3.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-30', 1, NULL, NULL, '2020-12-31 04:40:23', '2021-01-26 03:40:13'),
(35, 'vjkafcmBmterYBCnLLAwVOJES', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'The Rafale Deal Official Secret Act vs Right to Information Act.  Mr. Raghunandan Sriram', '&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot; segoe=&quot;&quot; ui=&quot;&quot; historic&quot;,=&quot;&quot; &quot;segoe=&quot;&quot; ui&quot;,=&quot;&quot; helvetica,=&quot;&quot; arial,=&quot;&quot; sans-serif;=&quot;&quot; color:=&quot;&quot; rgb(228,=&quot;&quot; 230,=&quot;&quot; 235);=&quot;&quot; font-size:=&quot;&quot; 15px;=&quot;&quot; background-color:=&quot;&quot; rgb(36,=&quot;&quot; 37,=&quot;&quot; 38);&quot;=&quot;&quot;&gt;&lt;h4 style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit; font-size: 0.875rem;&quot;&gt;&rdquo;The debate on the use of the Official Secrets Act, 1923 to curb the flow of information continues to rage in the corridors of power.&rdquo;&lt;br&gt;&lt;/span&gt;In September 2016, the historic arms deal for the procurement of 36 Dassault Rafale aircraft signed between the Governments of France and India, invited a lot of scepticism from various quarters. While some argued that it constituted a massive blow to the economy in terms of costs to the exchequer, others chose to focus on the revelations it would bring to the combat wing of the Indian Air Force. Doubts were raised regarding the discrepancies between the prior agreement under the UPA government, and the renegotiated agreement under the current administration. The primary bone of contention lay in the Union government&rsquo;s decision not to disclose the financial details of the agreement. The initial seeds of &ldquo;controversy&rdquo; has given way to a larger tussle between the government and the opposition, each backed by civil society organisations. The fundamental argument raised by the opposition is that the non-disclosure of information about the deal is in violation of the Right to Information Act, 2005. The government, on the other hand, has contended that such information may be legally withheld under the Official Secrets Act, 1923, in the greater interest of national security. At play here is the juxtaposition of the &ldquo;public interest&rdquo; principle and the &ldquo;protected interest&rdquo; principle.&lt;br&gt;The Official Secrets Act&lt;br&gt;The Official Secrets Act of 1923 (OSA) deals with the protection of information considered &ldquo;classified&rdquo; by the government, from being leaked to foreign powers, especially &ldquo;enemy states&rdquo;. To this effect, the Act contains numerous provisions enlisting punitive sanctions, details of trial etc. for government servants for divulging such &ldquo;official secrets&rdquo;.&lt;br&gt;&ldquo;The OSA governs all matters of secrecy and confidentiality in governance. It largely deals with matters of security and provides a framework for dealing with espionage, sedition and other assaults on the unity and integrity of the nation.&rdquo;&lt;br&gt;However, the OSA fails to define the terms &ldquo;secret&rdquo; or &ldquo;official secret&rdquo;. Therefore, an unfettered discretion has been handed over to public servants to decide what falls under the ambit of the Act. The Supreme Court in Sama Alana Abdulla v State of Gujarat held that the word &ldquo;secret&rdquo; in Clause (c) of Sub-section (1) of Section 3 of the OSA qualified official code or password and not any sketch, plan, model, article or note or other document or information, unless the latter was classified as an &ldquo;official secret&rdquo;.&lt;br&gt;The Right to Information Act&lt;br&gt;The Right to Information Act of 2005 defines the &ldquo;right to information&quot; as inclusive of the right to-&lt;br&gt;(i) inspection of work, documents, records;&lt;br&gt;(ii) taking notes, extracts or certified copies of documents or records;&lt;br&gt;(iii) taking certified samples of material;&lt;br&gt;(iv) obtaining information in the form of diskettes, floppies, tapes, video cassettes or in any other electronic mode or through printouts where such information is stored in a computer or in any other device;&lt;br&gt;Although the Act covers a wide array of subjects, a few subjects have been exempted from its purview, including but not limited to issues &ldquo;which would prejudicially affect the sovereignty and integrity of India, strategic interests of the State, relation with foreign States, information whose publication is expressly forbidden by a court of competent jurisdiction, or which would endanger the life or physical safety of any person etc.&rdquo;&lt;br&gt;However, Section 22 of the RTI Act explicitly states that &ldquo;The provisions of this Act shall have effect notwithstanding anything inconsistent therewith contained in the Official Secrets Act, 1923 (19 of 1923), and any other law for the time being in force or in any instrument having effect by virtue of any law other than this Act.&rdquo;&lt;br&gt;The aforementioned provision has been given importance in Kali Ram v State Public Information Officer cum Deputy Excise and Taxation Commissioner, and Sat Pal Kansal v Estate Officer, wherein it was held that the RTI Act can derive its power from this provision and override the OSA.&lt;br&gt;This leads us to the premise that in case of a conflict between the RTI Act and the OSA, the former shall prevail, in case a harmonious reading of the statutes is not possible.&lt;br&gt;The RTI Act further goes on to say that a &ldquo;public authority may allow access to information, if public interest in disclosure outweighs the harm to the protected interests.&rdquo;&lt;br&gt;THE CONTROVERSY&lt;br&gt;The war of words between the opposition and the ruling coalition began with the charge that the &ldquo;exorbitant&rdquo; amount spent on the procurement caused &quot;insurmountable loss&quot; of taxpayers&#039; money. The Congress alleged that the cost of each aircraft was thrice the amount that had been negotiated in the original deal.&lt;br&gt;The opposition took the matter to court, demanding the release of the information. The Supreme Court directed the Centre to provide in a sealed cover the &ldquo;details of the steps&rdquo; taken in the decision making process leading to the deal, but clarified that it did not want information on &ldquo;pricing&rdquo; and &ldquo;technical suitability&rdquo; of the fighter jets for the Indian Air Force.&lt;br&gt;This is in compliance with the powers granted to the Supreme Court and High Courts, over the functioning of the executive.&lt;br&gt;While Section 5 of the OSA was intended to deal with potential breaches of national security, the wording of the law and the colonial times in which it was implemented made it into a catch-all legal provision that converted practically every issue of governance into a confidential matter. This leads us to another pertinent contention that the opposition has tried to enunciate, that the government is arbitrarily and unilaterally taking the provision for granted and interpreting it for their own use. It is common knowledge that statutes that cater to the welfare of the masses should be liberally interpreted and this again places emphasis on the RTI Act and its provisions.  The Rafale Deal is a complex situation in this regard. The Government has used the ambiguity in the OSA provisions to portray the issue from a larger picture of national interest, thereby justifying its stance. However, the crux of the matter lies in the imperativeness of RTI having a higher say in this matter.&lt;br&gt;Precedents are an important source of validation in this regard. In the case of Union of India v Central Information Commissioner, the court held-&lt;br&gt;&ldquo;Relying on Section 22 of the Right to Information Act, the respondent has contended that the Right to Information Act overrides not only the Official Secrets Act but also all other acts which ipso facto includes Indian Evidence Act, 1872, by virtue of which no public authority can claim to deny any   information on the ground that it happens to be a &ldquo;privileged? document under the Indian Evidence Act, 1872. The respondent has sought the disclosure of the information as same would be in larger public interest, as well as, it would ensure the effective functioning of a secular and democratic country and would also check non-performance of public duty by people holding responsible positions in the future.&rdquo;&lt;br&gt;Therefore, the legal question at hand is whether there is a limit to the secrecy over information held with the State. Although national security remains an issue of paramount importance, the issue in the Rafale Deal controversy pertains to financial details rather than information about the specifics and defence-related attributes of the aircraft procured. Hence, it is plausible that the Right to Information Act will prevail over the Official Secrets Act in this case. Making information about the cost of the deal public, falls well within the constraints imposed by national security concerns, and is more to do with transparency of public expenditure, which at the end of the day belongs to the people of India.&lt;br&gt;BIBLIOGRAPHY&lt;br&gt;&lsquo;A Brief History of Defence Scams in India&rsquo;. News18. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.news18.com%2Fnews%2Findia%2Fa-brief-history-of-defence-scams-in-india-590770.html%3Ffbclid%3DIwAR13ZmZG75O8eg7qn_JOBvh3f06MOeMsipjbiHjRq0PlFmxg8N68MyqncBk&amp;h=AT1FmcnMmWZVHN-AewRCa0COdKlycRJrCp8eNJDB_gSr_lbx6Zs_bIXJcs1kYwcSzoKJOOEXRvYHD7tFz2DKoMmikNYktG4giRFBIScEU_7FroYP6Qq6STcJWBxsJ_faye9q&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.news18.com/.../a-brief-history-of-defence...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Can Narendra Modi Be Convicted of Corruption for the Renegotiated Rafale Deal?&rsquo; The Wire. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fthewire.in%2Flaw%2Fnarendra-modi-rafale-deal-corruption%3Ffbclid%3DIwAR1N6dIWVDz6ZHNL9LGugIR-Ox_c354r9OFgc_O99VQuCK9T2hTAyb3XbO0&amp;h=AT3HjBItCBjpQD5jZPf0-iS81g1y6lwoTaj9YBRbaZrvchHDPa8vhOo3VK7TopQ9Xa9hydd70BBQa9wZ6Oh3FV8rohlxo5VmiuqAYAkEze8oIwT_2KEXezvrZeECs011JG5_&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://thewire.in/law/narendra-modi-rafale-deal-corruption&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Dassault CEO&rsquo;s Interview Digs Bigger Hole for Modi Government on Rafale&rsquo;. The Wire. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fthewire.in%2Fsecurity%2Fdassault-ceos-interview-digs-bigger-hole-for-modi-government-on-rafale%3Ffbclid%3DIwAR1iLHnrXp9mnnjcve7NnYFgQZBq66oMDOLxQewPLkMEzZmRNMR_wI0Qwt8&amp;h=AT1IEjwV4tqg2rOXnDWAojAqizojwoRJZK-rQi6WKSmJtkLdmCh8VZPsRORVYNsVhoypiR5TQQufRUs0OCLs3SIvtkLkb1N4iQ1y39L0mz3b5T7LhfdR5h6Nya6uWUINHO9l&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://thewire.in/.../dassault-ceos-interview-digs...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Limits of &ldquo;Secrecy&rdquo;&rsquo;. Frontline. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.frontline.in%2Fcover-story%2Flimits-of-secrecy%2Farticle6951323.ece%3Ffbclid%3DIwAR3Ehu7vAhUpavU7DqzXDUDkld6Dq9NijhVhuUbMKwlXNxbejyS0x0afvDQ&amp;h=AT1zx8a5wYg7O6-_RIW68HeyU9mZwsYxriv-Pnp3qerCufUU4aHCjEWBEMV7FjJiE5px7nKrOlwWDYYdhB-u-7cUPWMWWk1cUKPyVzhQQwCy0i6ZXyhESemdQiFRZ_aZsUrZ&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.frontline.in/.../limits-of.../article6951323.ece&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Official Secrets Act Versus Right to Information Act - General Knowledge Today&rsquo;. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.gktoday.in%2Fgk%2Fofficial-secrets-act-versus-right-to-information-act%2F%3Ffbclid%3DIwAR2nhPjbAJGYhvt-k3kqm32PHKtv70oHk0b_bHMhkzWpXWGS-pek45-RHCo&amp;h=AT2qUDzoqGwh7-S6Q4mSKGRv-0DrI3NAF9rbObFeiwzqupyHvo56IKamQsVONXIeYcZzxbk4kEZ8XH3QBxN_12hK1cGWd8MdYIgVY-yTJtY5RbvUUfr0e_-7OiF-8Knl4Chg&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.gktoday.in/.../official-secrets-act-versus.../&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Official Secrets Act Versus Right to Information Act - General Knowledge Today&rsquo;. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.gktoday.in%2Fgk%2Fofficial-secrets-act-versus-right-to-information-act%2F%3Ffbclid%3DIwAR148L6xrmJ6bAd8Q5qJlcvPKH4HBfGNrkL0k2-hRvvlDF1A96g5QPEX0FY&amp;h=AT2qUDzoqGwh7-S6Q4mSKGRv-0DrI3NAF9rbObFeiwzqupyHvo56IKamQsVONXIeYcZzxbk4kEZ8XH3QBxN_12hK1cGWd8MdYIgVY-yTJtY5RbvUUfr0e_-7OiF-8Knl4Chg&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.gktoday.in/.../official-secrets-act-versus.../&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;SC Gives Centre 10 Days to File Affidavit Saying Price of Rafale Deal Cannot Be Shared&rsquo;. The Wire. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fthewire.in%2Flaw%2Fsc-gives-centre-10-days-to-file-affidavit-saying-price-of-rafale-deal-cannot-be-shared%3Ffbclid%3DIwAR1Qb3TJVCL-j8YW-PZDrVmG7580zTaJffhYPbaJSfQgxRMU95aJwi2bbRY&amp;h=AT15Jg1l_OFmXZhMVfvV4dhYU0W_TcVZHh9EziOU8nukaYzYNlwh0eUap-6eM75oHVINF9C3wDp3ykuIlORXGk-jJmbOsozxS5cQz2CYdTNWQu3pZTtmklqfoW9S8QztSFPp&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://thewire.in/.../sc-gives-centre-10-days-to-file...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;SC Is Over-Reaching On Rafale: It Is Now Party To The Weakening Of Institutions&rsquo;. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://swarajyamag.com/politics/sc-is-over-reaching-on-rafale-it-is-now-party-to-the-weakening-of-institutions?fbclid=IwAR0hGwyOHreUoEijp2uG95_TYnCLPt5YabbPMJpkDcExcPtYpTfbutBkXqs&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://swarajyamag.com/.../sc-is-over-reaching-on-rafale...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;Staff, Scroll. &lsquo;Rafale Jet Deal: Supreme Court Asks Centre for Pricing and Strategic Details&rsquo;. Text. Scroll.in. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://scroll.in/latest/900334/supreme-court-asks-centre-for-pricing-details-in-rafale-jet-deal?fbclid=IwAR22KyKvnIpKRFMfbJ7rWMarRrB15bpZJYDOf4MDY9fd23hF0HNMUJe0qJY&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://scroll.in/.../supreme-court-asks-centre-for...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Timeline of Bofors Scandal&rsquo;. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2FNDTV.com%2F%3Ffbclid%3DIwAR0slgQe-eBMl7z7518K_InG2NQeHg0jn4mkp3Y7FZqUZ87OLR17SkXa-Bc&amp;h=AT0_JCSyrQ4RngfiQDt5QlmNXel0vXB7YxUKoAfFokRVrp_RraTKuZbZWmdPqx2GW0B9H01nRDggHmgnhGc2eEXt97yO9J6fXgIy1dhOidoDCGMFEXK3bw5nzrH1Clp7FteE&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;NDTV.com.&lt;/a&gt;&lt;/span&gt; Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.ndtv.com%2Findia-news%2Ftimeline-of-bofors-scandal-443872%3Ffbclid%3DIwAR0U37GG-Y7TDbDu2ywda_pETEhBbZLR33Z8RvDr8OW6CTrNBQRCoCTbY_0&amp;h=AT3h4tkc9qdKKqDWJ7UnRYJ3wKovnGaU4owac7s1lwXyHHr74tOBy5QCkE9k4pS3LRc6lnyYxPlDQoa5ioYsYesLxNqBVglkSoE12S0t3q7hD8Oh7qgXhww0rAKhL0RjClMR&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.ndtv.com/.../timeline-of-bofors-scandal-443872&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;What Is Rafale Deal Controversy? All You Need To Know&rsquo;. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2FNDTV.com%2F%3Ffbclid%3DIwAR0JAaT6pjfhNzkUUG-EUBm2JeJv9yeNOqNrJ_cIWt9Sdjk4L2fMLuC2ve0&amp;h=AT0_JCSyrQ4RngfiQDt5QlmNXel0vXB7YxUKoAfFokRVrp_RraTKuZbZWmdPqx2GW0B9H01nRDggHmgnhGc2eEXt97yO9J6fXgIy1dhOidoDCGMFEXK3bw5nzrH1Clp7FteE&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;NDTV.com.&lt;/a&gt;&lt;/span&gt; Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.ndtv.com%2Findia-news%2Fwhat-is-rafale-deal-controversy-all-you-need-to-know-1810706%3Ffbclid%3DIwAR23uJP8zGz9VQ53Y1V_-7KFndbJ8a_9COGXRM0-AvPdoLN3umn80eUpoM4&amp;h=AT3-RLD0bMS_XFx8hChyZp-XZNlv9cMGyjs3NuaU3okK-w3B6aoJGHIMEJ67Qf3SUjWE2llACfvqz2DHl6QDpnshtXNcxL0tlSTl2DOz-0O9baWYV8f0m-oL07M14ukEusYO&amp;__tn__=-UK-R&amp;c[0]=AT1WlsPG4zFe8mP9JMwJYxJSdobvm_zhmOaY3UGBe6TIlmgvAYpm4rsD6ojbdKyIXPmQ4nfknbQ5zAWs4x-vsERgstc1Q5k6bTPrC8R4JPKNKjAgDe-117lDKq4pJJo2ACZpeOn2ZV5OOaqOayWdRnj-uuFtH_kVV8c&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://www.ndtv.com/.../what-is-rafale-deal-controversy...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;With Its Big Little Lies on Rafale, the Modi Govt Is Treading a Treacherous Path&rsquo;. The Wire. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://thewire.in/law/rafale-deal-modi-government-defence-procurement-law?fbclid=IwAR3H3AwWjPPeBSQ3V6m3ET8yubBJeODhJPg6GgMAREv28fx9nNvbgoSIFvU&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://thewire.in/.../rafale-deal-modi-government...&lt;/a&gt;&lt;/span&gt;.&lt;br&gt;&lsquo;Yashwant Sinha, Arun Shourie, Prashant Bhushan Move SC Seeking FIR in Rafale Deal&rsquo;. The Wire. Accessed 5 November 2018. &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://thewire.in/law/yashwant-sinha-arun-shourie-prashant-bhushan-sc-fir-rafale-deal?fbclid=IwAR24AeYvDEJbpCOLm52-G9oiDXdtwSuiPAALpNaJydghSlR20X1UN-P7ZL0&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://thewire.in/.../yashwant-sinha-arun-shourie...&lt;/a&gt;&lt;/span&gt;.&lt;/h4&gt;&lt;/div&gt;', '2d2a0db6ce213ea24f824e3c5fb88aa9.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:21:45', '2020-12-23 03:05:03');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(36, 'KtoFvsKgUcuiYyIUtFpztCah8', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Dr. Ambedkar last speech in the Constituent Assembly on adoption of the Constitution 25 November 1949.  S. Basavaraj. Advocate. Bangalore', '&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1. The Honourable Dr. B.R. Ambedkar : Sir, looking back on the work of the Constituent Assembly it will now be two years, eleven months and seventeen days since it first met on the 9th of December 1946. During this period the Constituent Assembly has altogether held eleven sessions. Out of these eleven sessions the first six were spent in passing the Objectives Resolution and the consideration of the Reports of Committees on Fundamental Rights, on Union Constitution, on Union Powers, on Provincial Constitution, on Minorities and on the Scheduled Areas and Scheduled Tribes. The seventh, eighth, ninth, tenth and the eleventh sessions were devoted to the consideration of the Draft Constitution. These eleven sessions of the Constituent Assembly have consumed 165 days. Out of these, the Assembly spent 114 days for the consideration of the Draft Constitution.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2. Coming to the Drafting Committee, it was elected by the Constituent Assembly on 29th August 1947. It held its first meeting on 30th August. Since August 30th it sat for 141 days during which it was engaged in the preparation of the Draft Constitution. The Draft Constitution as prepared by the Constitutional Adviser as a text for the Draft Committee to work upon, consisted of 243 articles and 13 Schedules. The first Draft Constitution as presented by the Drafting Committee to the Constituent Assembly contained 315 articles and 8 Schedules. At the end of the consideration stage, the number of articles in the Draft Constitution increased to 386. In its final form, the Draft Constitution contains 395 articles and 8 Schedules. The total number of amendments to the Draft Constitution tabled was approximately 7,635. Of them, the total number of amendments actually moved in the House were 2,473.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;3. I mention these facts because at one stage it was being said that the Assembly had taken too long a time to finish its work, that it was going on leisurely and wasting public money. It was said to be a case of Nero fiddling while Rome was burning. Is there any justification for this complaint? Let us note the time consumed by Constituent Assemblies in other countries appointed for framing their Constitutions. To take a few illustrations, the American Convention met on May 25th, 1787 and completed its work on September 17, 1787 i.e., within four months. The Constitutional Convention of Canada met on the 10th October 1864 and the Constitution was passed into law in March 1867 involving a period of two years and five months. The Australian Constitutional Convention assembled in March 1891 and the Constitution became law on the 9thJuly 1900, consuming a period of nine years. The South African Convention met in October, 1908 and the Constitution became law on the 20th September 1909 involving one year&#039;s labour. It is true that we have taken more time than what the American or South African Conventions did. But we have not taken more time than the Canadian Convention and much less than the Australian Convention. In making comparisons on the basis of time consumed, two things must be remembered. One is that the Constitutions of America, Canada, South Africa and Australia are much smaller than ours. Our Constitution as I said contains 395 articles while the American has just seven articles, the first four of which are divided into sections which total up to 21, the Canadian has 147, Australian 128 and South African 153 sections. The second thing to be remembered is that the makers of the Constitutions of America, Canada, Australia and South Africa did not have to face the problem of amendments. They were passed as moved. On the other hand, this Constituent Assembly had to deal with as many as 2,473 amendments. Having regard to these facts the charge of dilatoriness seems to me quite unfounded and this Assembly may well congratulate itself for having accomplished so formidable a task in so short a time.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;4. Turning to the quality of the work done by the Drafting Committee, Mr. Naziruddin Ahmed felt it his duty to condemn it outright. In his opinion, the work done by the Drafting Committee is not only not worthy of commendation, but is positively below par. Everybody has a right to have his opinion about the work done by the Drafting Committee and Mr. Naziruddin is welcome to have his own. Mr. Naziruddin Ahmed thinks he is a man of greater talents than any member of the Drafting Committee. The Drafting Committee would have welcomed him in their midst if the Assembly had thought him worthy of being appointed to it. If he had no place in the making of the Constitution it is certainly not the fault of the Drafting Committee.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;5. Mr. Naziruddin Ahmed has coined a new name for the Drafting Committee evidently to show his contempt for it. He calls it a Drafting committee. Mr. Naziruddin must no doubt be pleased with his hit. But he evidently does not know that there is a difference between drift without mastery and drift with mastery. If the Drafting Committee was drifting, it was never without mastery over the situation. It was not merely angling with the off chance of catching a fish. It was searching in known waters to find the fish it was after. To be in search of something better is not the same as drifting. Although Mr. Naziruddin Ahmed did not mean it as a compliment to the Drafting committee. I take it as a compliment to the Drafting Committee. The Drafting Committee would have been guilty of gross dereliction of duty and of a false sense of dignity if it had not shown the honesty and the courage to withdraw the amendments which it thought faulty and substitute what it thought was better. If it is a mistake, I am glad the Drafting Committee did not fight shy of admitting such mistakes and coming forward to correct them.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;6. I am glad to find that with the exception of a solitary member, there is a general consensus of appreciation from the members of the Constituent Assembly of the work done by the Drafting Committee. I am sure the Drafting Committee feels happy to find this spontaneous recognition of its labours expressed in such generous terms. As to the compliments that have been showered upon me both by the members of the Assembly as well as by my colleagues of the Drafting Committee I feel so overwhelmed that I cannot find adequate words to express fully my gratitude to them. I came into the Constituent Assembly with no greater aspiration than to safeguard the interests of he Scheduled Castes. I had not the remotest idea that I would be called upon to undertake more responsible functions. I was therefore greatly surprised when the Assembly elected me to the Drafting Committee. I was more than surprised when the Drafting Committee elected me to be its Chairman. There were in the Drafting Committee men bigger, better and more competent than myself such as my friend Sir Alladi Krishnaswami Ayyar. I am grateful to the Constituent Assembly and the Drafting Committee for reposing in me so much trust and confidence and to have chosen me as their instrument and given me this opportunity of serving the country. (Cheers)&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;7. The credit that is given to me does not really belong to me. It belongs partly to Sir B.N. Rau, the Constitutional Adviser to the Constituent Assembly who prepared a rough draft of the Constitution for the consideration of the Drafting Committee. A part of the credit must go to the members of the Drafting Committee who, as I have said, have sat for 141 days and without whose ingenuity of devise new formulae and capacity to tolerate and to accommodate different points of view, the task of framing the Constitution could not have come to so successful a conclusion. Much greater, share of the credit must go to Mr. S.N. Mukherjee, the Chief Draftsman of the Constitution. His ability to put the most intricate proposals in the simplest and clearest legal form can rarely be equalled, nor his capacity for hard work. He has been as acquisition tot he Assembly. Without his help, this Assembly would have taken many more years to finalise the Constitution. I must not omit to mention the members of the staff working under Mr. Mukherjee. For, I know how hard they have worked and how long they have toiled sometimes even beyond midnight. I want to thank them all for their effort and their co-operation.(Cheers)&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;8. The task of the Drafting Committee would have been a very difficult one if this Constituent Assembly has been merely a motley crowd, a tasseleted pavement without cement, a black stone here and a white stone there is which each member or each group was a law unto itself. There would have been nothing but chaos. This possibility of chaos was reduced to nil by the existence of the Congress Party inside the Assembly which brought into its proceedings a sense of order and discipline. It is because of the discipline of the Congress Party that the Drafting Committee was able to pilot the Constitution in the Assembly with the sure knowledge as to the fate of each article and each amendment. The Congress Party is, therefore, entitled to all the credit for the smooth sailing of the Draft Constitution in the Assembly.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;9. The proceedings of this Constituent Assembly would have been very dull if all members had yielded to the rule of party discipline. Party discipline, in all its rigidity, would have converted this Assembly into a gathering of yes&#039; men. Fortunately, there were rebels. They were Mr. Kamath, Dr. P.S. Deshmukh, Mr. Sidhva, Prof. K.T. Shah and Pandit Hirday Nath Kunzru. The points they raised were mostly ideological. That I was not prepared to accept their suggestions, does not diminish the value of their suggestions nor lessen the service they have rendered to the Assembly in enlivening its proceedings. I am grateful to them. But for them, I would not have had the opportunity which I got for expounding the principles underlying the Constitution which was more important than the mere mechanical work of passing the Constitution.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;10. Finally, I must thank you Mr. President for the way in which you have conducted the proceedings of this Assembly. The courtesy and the consideration which you have shown to the Members of the Assembly can never be forgotten by those who have taken part in the proceedings of this Assembly. There were occasions when the amendments of the Drafting Committee were sought to be barred on grounds purely technical in their nature. Those were very anxious moments for me. I am, therefore, specially grateful to you for not permitting legalism to defeat the work of Constitution-making.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;11. As much defence as could be offered to the constitution has been offered by my friends Sir Alladi Krishnaswami Ayyar and Mr.. &lt;span class=&quot;pq6dq46d tbxw36s4 knj5qynh kvgmc6g5 ditlmg2l oygrvhab nvdbi5me sf5mxxl7 gl3lb2sf hhz5lgdu&quot; style=&quot;margin: 0px 1px; height: 16px; width: 16px; display: inline-flex; vertical-align: middle; font-family: inherit;&quot;&gt;&lt;img height=&quot;16&quot; width=&quot;16&quot; alt=&quot;????&quot; src=&quot;https://static.xx.fbcdn.net/images/emoji.php/v9/t40/1/16/1f62d.png&quot; style=&quot;border: 0px;&quot;&gt;&lt;/span&gt;. Krishnamachari. I shall not therefore enter into the merits of the Constitution. Because I feel, however good a Constitution may be, it is sure to turn out bad because those who are called to work it, happen to be a bad lot. However had a Constitution may be, it may turn out to be good if those who are called to work it, happen to be a good lot. The working of a Constitution does not depend wholly upon the nature of the Constitution. The Constitution can provide only the organs of State such as the Legislature, the Executive and the Judiciary. The factors on which the working of those organs of the State depend are the people and the political parties they will set up as their instruments to carry out their wishes and their politics. Who can say how the people of India and their purposes or will they prefer revolutionary methods of achieving them? If they adopt the revolutionary methods, however good the Constitution may be, it requires no prophet to say that it will fail. It is, therefore, futile to pass any judgement upon the Constitution without reference to the part which the people and their parties are likely to play.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;12. The condemnation of the Constitution largely comes from two quarters, the Communist Party and the Socialist Party. Why do they condemn the Constitution? Is it because it is really a bad Constitution? I venture to say no&#039;. The Communist Party want a Constitution based upon the principle of the Dictatorship of the Proletariat. They condemn the Constitution because it is based upon parliamentary democracy. The Socialists want two things. The first thing they want is that if they come in power, the Constitution must give them the freedom to nationalize or socialize all private property without payment of compensation. The second thing that the Socialists want is that the Fundamental Rights mentioned in the Constitution must be absolute and without any limitations so that if their Party fails to come into power, they would have the unfettered freedom not merely to criticize, but also to overthrow the State.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;13. These are the main grounds on which the Constitution is being condemned. I do not say that the principle of parliamentary democracy is the only ideal form of political democracy. I do not say that the principle of no acquisition of private property without compensation is so sacrosanct that there can be no departure from it. I do not say that Fundamental Rights can never be absolute and the limitations set upon them can never be lifted. What I do say is that the principles embodied in the Constitution are the views of the present generation or if you think this to be an over-statement, I say they are the views of the members of the Constituent Assembly. Why blame the Drafting Committee for embodying them in the Constitution? I say why blame even the Members of the Constituent Assembly? Jefferson, the great American statesman who played so great a part in the making of the American constitution, has expressed some very weighty views which makers of Constitution, can never afford to ignore. In one place he has said:- &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    &quot;We may consider each generation as a distinct nation, with a right, by the will of the majority, to bind themselves, but none to bind the succeeding generation, more than the inhabitants of another country.&quot;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    In another place, he has said :&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    &quot;The idea that institutions established for the use of the national cannot be touched or modified, even to make them answer their end, because of rights gratuitously supposed in those employed to manage them in the trust for the public, may perhaps be a salutary provision against the abuses of a monarch, but is most absurd against the nation itself. Yet our lawyers and priests generally inculcate this doctrine, and suppose that preceding generations held the earth more freely than we do; had a right to impose laws on us, unalterable by ourselves, and that we, in the like manner, can make laws and impose burdens on future generations, which they will have no right to alter; in fine, that the earth belongs to the dead and not the living;&quot;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;14. I admit that what Jefferson has said is not merely true, but is absolutely true. There can be no question about it. Had the Constituent Assembly departed from this principle laid down by Jefferson it would certainly be liable to blame, even to condemnation. But I ask, has it? Quite the contrary. One has only to examine the provision relating to the amendment of the Constitution. The Assembly has not only refrained from putting a seal of finality and infallibility upon this Constitution as in Canada or by making the amendment of the Constitution subject tot he fulfilment of extraordinary terms and conditions as in America or Australia, but has provided a most facile procedure for amending the Constitution. I challenge any of the critics of the Constitution to prove that any Constituent Assembly anywhere in the world has, in the circumstances in which this country finds itself, provided such a facile procedure for the amendment of the Constitution. If those who are dissatisfied with the Constitution have only to obtain a 2/3 majority and if they cannot obtain even a two-thirds majority in the parliament elected on adult franchise in their favour, their dissatisfaction with the Constitution cannot be deemed to be shared by the general public.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;15. There is only one point of constitutional import to which I propose to make a reference. A serious complaint is made on the ground that there is too much of centralization and that the States have been reduced to Municipalities. It is clear that this view is not only an exaggeration, but is also founded on a misunderstanding of what exactly the Constitution contrives to do. As to the relation between the Centre and the States, it is necessary to bear in mind the fundamental principle on which it rests. The basic principle of Federalism is that the Legislative and Executive authority is partitioned between the Centre and the States not by any law to be made by the Centre but by the Constitution itself. This is what Constitution does. The States under our Constitution are in no way dependent upon the Centre for their legislative or executive authority. The Centre and the States are co-equal in this matter. It is difficult to see how such a Constitution can be called centralism. It may be that the Constitution assigns to the Centre too large a field for the operation of its legislative and executive authority than is to be found in any other federal Constitution. It may be that the residuary powers are given to the Centre and not to the States. But these features do not form the essence of federalism. The chief mark of federalism as I said lies in the partition of the legislative and executive authority between the Centre and the Units by the Constitution. This is the principle embodied in our constitution. There can be no mistake about it. It is, therefore, wrong to say that the States have been placed under the Centre. Centre cannot by its own will alter the boundary of that partition. Nor can the Judiciary. For as has been well said:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    &quot;Courts may modify, they cannot replace. They can revise earlier interpretations as new arguments, new points of view are presented, they can shift the dividing line in marginal cases, but there are barriers they cannot pass, definite assignments of power they cannot reallocate. They can give a broadening construction of existing powers, but they cannot assign to one authority powers explicitly granted to another.&quot;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The first charge of centralization defeating federalism must therefore fall.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;16. The second charge is that the Centre has been given the power to override the States. This charge must be admitted. But before condemning the Constitution for containing such overriding powers, certain considerations must be borne in mind. The first is that these overriding powers do not form the normal feature of the constitution. Their use and operation are expressly confined to emergencies only. The second consideration is : Could we avoid giving overriding powers to the Centre when an emergency has arisen? Those who do not admit the justification for such overriding powers to the Centre even in an emergency, do not seem to have a clear idea of the problem which lies at the root of the matter. The problem is so clearly set out by a writer in that well-known magazine &quot;The Round Table&quot; in its issue of December 1935 that I offer no apology for quoting the following extract from it. Says the writer :&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    &quot;Political systems are a complex of rights and duties resting ultimately on the question, to whom, or to what authority, does the citizen owe allegiance. In normal affairs the question is not present, for the law works smoothly, and a man, goes about his business obeying one authority in this set of matters and another authority in that. But in a moment of crisis, a conflict of claims may arise, and it is then apparent that ultimate allegiance cannot be divided. The issue of allegiance cannot be determined in the last resort by a juristic interpretation of statutes. The law must conform to the facts or so much the worse for the law. When all formalism is stripped away, the bare question is, what authority commands the residual loyalty of the citizen. Is it the Centre or the Constituent State ?&quot;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;17. The solution of this problem depends upon one&#039;s answer to this question which is the crux of the problem. There can be no doubt that in the opinion of the vast majority of the people, the residual loyalty of the citizen in an emergency must be to the Centre and not to the Constituent States. For it is only the Centre which can work for a common end and for the general interests of the country as a whole. Herein lies the justification for giving to all Centre certain overriding powers to be used in an emergency. And after all what is the obligation imposed upon the Constituent States by these emergency powers? No more than this &ndash; that in an emergency, they should take into consideration alongside their own local interests, the opinions and interests of the nation as a whole. Only those who have not understood the problem, can complain against it.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;18. Here I could have ended. But my mind is so full of the future of our country that I feel I ought to take this occasion to give expression to some of my reflections thereon. On 26th January 1950, India will be an independent country (Cheers). What would happen to her independence? Will she maintain her independence or will she lose it again? This is the first thought that comes to my mind. It is not that India was never an independent country. The point is that she once lost the independence she had. Will she lost it a second time? It is this thought which makes me most anxious for the future. What perturbs me greatly is the fact that not only India has once before lost her independence, but she lost it by the infidelity and treachery of some of her own people. In the invasion of Sind by Mahommed-Bin-Kasim, the military commanders of King Dahar accepted bribes from the agents of Mahommed-Bin-Kasim and refused to fight on the side of their King. It was Jaichand who invited Mahommed Gohri to invade India and fight against Prithvi Raj and promised him the help of himself and the Solanki Kings. When Shivaji was fighting for the liberation of Hindus, the other Maratha noblemen and the Rajput Kings were fighting the battle on the side of Moghul Emperors. When the British were trying to destroy the Sikh Rulers, Gulab Singh, their principal commander sat silent and did not help to save the Sikh Kingdom. In 1857, when a large part of India had declared a war of independence against the British, the Sikhs stood and watched the event as silent spectators.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;19. Will history repeat itself? It is this thought which fills me with anxiety. This anxiety is deepened by the realization of the fact that in addition to our old enemies in the form of castes and creeds we are going to have many political parties with diverse and opposing political creeds. Will Indian place the country above their creed or will they place creed above country? I do not know. But this much is certain that if the parties place creed above country, our independence will be put in jeopardy a second time and probably be lost for ever. This eventuality we must all resolutely guard against. We must be determined to defend our independence with the last drop of our blood.(Cheers)&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;20. On the 26th of January 1950, India would be a democratic country in the sense that India from that day would have a government of the people, by the people and for the people. The same thought comes to my mind. What would happen to her democratic Constitution? Will she be able to maintain it or will she lost it again. This is the second thought that comes to my mind and makes me as anxious as the first.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;21. It is not that India did not know what is Democracy. There was a time when India was studded with republics, and even where there were monarchies, they were either elected or limited. They were never absolute. It is not that India did not know Parliaments or Parliamentary Procedure. A study of the Buddhist Bhikshu Sanghas discloses that not only there were Parliaments-for the Sanghas were nothing but Parliaments &ndash; but the Sanghas knew and observed all the rules of Parliamentary Procedure known to modern times. They had rules regarding seating arrangements, rules regarding Motions, Resolutions, Quorum, Whip, Counting of Votes, Voting by Ballot, Censure Motion, Regularization, Res Judicata, etc. Although these rules of Parliamentary Procedure were applied by the Buddha to the meetings of the Sanghas, he must have borrowed them from the rules of the Political Assemblies functioning in the country in his time.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;22. This democratic system India lost. Will she lost it a second time? I do not know. But it is quite possible in a country like India &ndash; where democracy from its long disuse must be regarded as something quite new &ndash; there is danger of democracy giving place to dictatorship. It is quite possible for this new born democracy to retain its form but give place to dictatorship in fact. If there is a landslide, the danger of the second possibility becoming actuality is much greater.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;23. If we wish to maintain democracy not merely in form, but also in fact, what must we do? The first thing in my judgement we must do is to hold fast to constitutional methods of achieving our social and economic objectives. It means we must abandon the bloody methods of revolution. It means that we must abandon the method of civil disobedience, non-cooperation and satyagraha. When there was no way left for constitutional methods for achieving economic and social objectives, there was a great deal of justification for unconstitutional methods. But where constitutional methods are open, there can be no justification for these unconstitutional methods. These methods are nothing but the Grammar of Anarchy and the sooner they are abandoned, the better for us.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;24. The second thing we must do is to observe the caution which John Stuart Mill has given to all who are interested in the maintenance of democracy, namely, not &quot;to lay their liberties at the feet of even a great man, or to trust him with power which enable him to subvert their institutions&quot;. There is nothing wrong in being grateful to great men who have rendered life-long services to the country. But there are limits to gratefulness. As has been well said by the Irish Patriot Daniel O&#039;Connel, no man can be grateful at the cost of his honour, no woman can be grateful at the cost of her chastity and no nation can be grateful at the cost of its liberty. This caution is far more necessary in the case of India than in the case of any other country. For in India, Bhakti or what may be called the path of devotion or hero-worship, plays a part in its politics unequalled in magnitude by the part it plays in the politics of any other country in the world. Bhakti in religion may be a road to the salvation of the soul. But in politics, Bhakti or hero-worship is a sure road to degradation and to eventual dictatorship.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;25. The third thing we must do is not to be content with mere political democracy. We must make our political democracy a social democracy as well. Political democracy cannot last unless there lies at the base of it social democracy. What does social democracy mean? It means a way of life which recognizes liberty, equality and fraternity as the principles of life. These principles of liberty, equality and fraternity as the principles of life. These principles of liberty, equality and fraternity are not to be treated as separate items in a trinity. They form a union of trinity in the sense that to divorce one from the other is to defeat the very purpose of democracy. Liberty cannot be divorced from equality, equality cannot be divorced from liberty. Nor can liberty and equality be divorced from fraternity. Without equality, liberty would produce the supremacy of the few over the many. Equality without liberty would kill individual initiative. Without fraternity, liberty would produce the supremacy of the few over the many. Equality without liberty would kill individual initiative. Without fraternity, liberty and equality could not become a natural course of things. It would require a constable to enforce them. We must begin by acknowledging the fact that there is complete absence of two things in Indian Society. One of these is equality. On the social plane, we have in India a society based on the principle of graded inequality which we have a society in which there are some who have immense wealth as against many who live in abject poverty. On the 26th of January 1950, we are going to enter into a life of contradictions. In politics we will have equality and in social and economic life we will have inequality. In politics we will be recognizing the principle of one man one vote and one vote one value. In our social and economic life, we shall, by reason of our social and economic structure, continue to deny the principle of one man one value. How long shall we continue to live this life of contradictions? How long shall we continue to deny equality in our social and economic life? If we continue to deny it for long, we will do so only by putting our political democracy in peril. We must remove this contradiction at the earliest possible moment or else those who suffer from inequality will blow up the structure of political democracy which is Assembly has to laboriously built up.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;26. The second thing we are wanting in is recognition of the principle of fraternity. what does fraternity mean? Fraternity means a sense of common brotherhood of all Indians-if Indians being one people. It is the principle which gives unity and solidarity to social life. It is a difficult thing to achieve. How difficult it is, can be realized from the story related by James Bryce in his volume on American Commonwealth about the United States of America.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    The story is- I propose to recount it in the words of Bryce himself- that-&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;    &quot;Some years ago the American Protestant Episcopal Church was occupied at its triennial Convention in revising its liturgy. It was thought desirable to introduce among the short sentence prayers a prayer for the whole people, and an eminent  New England divine proposed the words `O Lord, bless our nation&#039;. Accepted one afternoon, on the spur of the moment, the sentence was brought up next day for reconsideration, when so many objections were raised by the laity to the word nation&#039; as importing too definite a recognition of national unity, that it was dropped, and instead there were adopted the words `O Lord, bless these United States.&quot;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;27. There was so little solidarity in the U.S.A. at the time when this incident occurred that the people of America did not think that they were a nation. If the people of the United States could not feel that they were a nation, how difficult it is for Indians to think that they are a nation. I remember the days when politically-minded Indians, resented the expression &quot;the people of India&quot;. They preferred the expression &quot;the Indian nation.&quot; I am of opinion that in believing that we are a nation, we are cherishing a great delusion. How can people divided into several thousands of castes be a nation? The sooner we realize that we are not as yet a nation in the social and psychological sense of the world, the better for us. For then only we shall realize the necessity of becoming a nation and seriously think of ways and means of realizing the goal. The realization of this goal is going to be very difficult &ndash; far more difficult than it has been in the United States. The United States has no caste problem. In India there are castes. The castes are anti-national. In the first place because they bring about separation in social life. They are anti-national also because they generate jealousy and antipathy between caste and caste. But we must overcome all these difficulties if we wish to become a nation in reality. For fraternity can be a fact only when there is a nation. Without fraternity equality and liberty will be no deeper than coats of paint.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;28. These are my reflections about the tasks that lie ahead of us. They may not be very pleasant to some. But there can be no gainsaying that political power in this country has too long been the monopoly of a few and the many are only beasts of burden, but also beasts of prey. This monopoly has not merely deprived them of their chance of betterment, it has sapped them of what may be called the significance of life. These down-trodden classes are tired of being governed. They are impatient to govern themselves. This urge for self-realization in the down-trodden classes must no be allowed to devolve into a class struggle or class war. It would lead to a division of the House. That would indeed be a day of disaster. For, as has been well said by Abraham Lincoln, a House divided against itself cannot stand very long. Therefore the sooner room is made for the realization of their aspiration, the better for the few, the better for the country, the better for the maintenance for its independence and the better for the continuance of its democratic structure. This can only be done by the establishment of equality and fraternity in all spheres of life. That is why I have laid so much stresses on them.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;29. I do not wish to weary the House any further. Independence is no doubt a matter of joy. But let us not forget that this independence has thrown on us great responsibilities. By independence, we have lost the excuse of blaming the British for anything going wrong. If hereafter things go wrong, we will have nobody to blame except ourselves. There is great danger of things going wrong. Times are fast changing. People including our own are being moved by new ideologies. They are getting tired of Government by the people. They are prepared to have Governments for the people and are indifferent whether it is Government of the people and by the people. If we wish to preserve the Constitution in which we have sought to enshrine the principle of Government of the people, for the people and by the people, let us resolve not to be tardy in the recognition of the evils that lie across our path and which induce people to prefer Government for the people to Government by the people, nor to be weak in our initiative to remove them. That is the only way to serve the country. I know of no better.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The Assembly then adjourned till Ten of the Clock on Saturday, the 26th November 1949. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Compiled by &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;S. Basavaraj &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Daksha Legal &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;+919845065416&lt;/div&gt;&lt;/div&gt;', 'a73de646d48eab5b99e99ed5e68c9130.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:23:56', '2020-12-23 03:03:10');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(37, '79GMdjXoxNZByeoRF59QKqI8U', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Cow slaughter Legal position and the Legislation in India.  S. Basavaraj. Advocate. Bangalore ', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt; &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1.Article 48 Constitution of India which deals with organisation of agriculture and animal husbandry says that &ldquo;The State shall endeavour to organise agriculture and animal husbandry on modern and scientific lines and shall, in particular, take steps for preserving and improving the breeds, and prohibiting the slaughter, of cows and calves and other milch and draught cattle.&rdquo;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2.The first enactment pursuant to Article 48 appears to be Bombay Animal Preservation Act, 1948. This Act prohibited slaughter of animals which were useful for milch, breeding or agricultural purposes. This Act was substituted by the Bombay Animal Preservation Act of 1954. In 1994, certain amendments in Section 5 of the said Act were introduced by Section 2 of the Bombay Animal Preservation (Gujarat Amendment) Act, 1994. After the amendment, the Section provided that no person shall slaughter or cause to be slaughtered any animal unless he has obtained in respect of such animal a certificate in writing from the competent authority appointed for the area that the animal is fit for slaughter. No certificate was to be granted if in the opinion of the competent authority the animal, whether male or female, is useful or likely to become useful for the purpose of draught or any kind of agricultural operations; the animal, if male, is useful or likely to become useful for the purpose of breeding; the animal, if female, is useful or likely to become useful for the purpose of giving milk or bearing offspring. However, the exemption was granted to the slaughter of any animal above the age of fifteen years for bona fide religious purposes.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;3.The Gujarat Legislature enacted the Bombay Animal Preservation (Gujarat Extension and Amendment) Act, 1961 (hereinafter, 1961 Act) whereby the Bombay Act was extended to the State of Gujarat. The Act came into force on 6 May 1961. The significant aspect was that no certificate was be granted in respect of a cow and even for religious purposes, cow was not allowed to be slaughtered. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;4.The 1961 Act was amended in 1979 by Bombay Animal Preservation (Gujarat Amendment) Act, 1979. The amendment, while retaining the ban on cow &amp; calf of a cow slaughter, provided that the Certificate could be granted in respect of a bull and bullock below the age of sixteen years. However, exemption was granted for the slaughter of any animal above the age of fifteen years other than cow, bull or bullock and bull &amp; bullock above the age of fifteen years for bonafide religious purposes. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;5.It may be noted that the Madhya Pradesh CP and Berar Animal Preservation Act 1949 imposed a total ban on the slaughter of cows and female calf of a cow. The Uttar Pradesh Prevention of Cow Slaughter Act, 1955 imposed a total ban on the slaughter of cows and her progeny which included bulls, bullocks, heifers and cows. Bihar Preservation and Improvement of Animals Act, 1956 imposed a total ban on the slaughter of all categories of animals belonging to the species of bovine cattle. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;6.The constitutional validity of the above amendment and also the Acts mentioned in paragraph 5 was upheld by a Constitution Bench of the Supreme Court in Haji Usmanbhai Hasanbhai Qureshi v. State of Gujarat (1986) 3 SCC 12. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;7.It is interesting to note that in Haji Usmanbhai Hasanbhai Qureshi one of the grounds of attack was that the total ban offended the religion of the Muslims as the sacrifice of a cow on a particular day is enjoined or sanctioned by Islam. This argument was negative by the Supreme Court by the following beautiful exposition:&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;It is part of the known history of India that the Moghul Emperor Babar saw the wisdom of prohibiting the slaughter of cows as and by way of religious sacrifice and directed his son Humayun to follow this example. Similarly, Emperors Akbar, Jehangir and Ahmad Shah, it is said, prohibited cow slaughter. Nawab Hyder Ali of Mysore made cow slaughter an offence punishable with the cutting of the hands of the offenders. Three of the members of the Gosamvardhan Enquiry Committee set up by the Uttar Pradesh Government in 1953 were Muslims and concurred in the unanimous recommendation for total ban on slaughter of cows. We have, however, no material on the record before us which will enable us to say, in the face of the foregoing facts, that the sacrifice of a cow on that day is an obligatory overt act for a Mussalman to exhibit his religious belief and idea. In the premises, it is not possible for us to uphold this claim of the petitioners.&rdquo;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;8.The Bombay Animal Preservation (Gujarat Extension and Amendment) Act, 1961 Act was further amended in 1994 by Bombay Animal Preservation (Gujarat Amendment) Act, 1994. By this amendment a total ban even on the slaughter of bull and bullock of any age was imposed.  Thus there was a total ban on the slaughter of progeny of cow.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;9.The statement of objects and reasons for the 1994 amendment makes an interesting reading and reads thus: &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;The existing provisions of the Bombay Animal Preservation Act, 1954 provides for prohibition against the slaughter of cow, calf of a cow, and the bulls and bullocks below the age of sixteen years. It is an established fact that the cow and her progeny sustain the health of the nation by giving them the life-giving milk which is so essential an item in a scientifically balanced diet. The economy of the State of Gujarat is still predominantly agricultural. In the agricultural sector, use of animals for milch, draught, breeding or agricultural purposes has great importance. It has, therefore, become necessary to emphasise preservation and protection of agricultural animals like bulls and bullocks. With the growing adoption of non-conventional energy sources like biogas plants, even waste material has come to assume considerable value. After the cattle cease to breed or are too old to do work, they still continue to give dung for fuel, manure and biogas, and therefore, they cannot be said to be useless. It is well established that the backbone of Indian agriculture is, in a manner of speaking, the cow and her progeny and have on their back, the whole structure of the Indian agriculture and its economic system.  In order to give effect to the policy of the State towards securing the principles laid down in Articles 47, 48 and clauses (b) and (c) of Article 39 of the Constitution, it was considered necessary also to impose total prohibition against slaughter of progeny of cow.&quot;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;10.The constitutional validity of this amendment imposing total ban on the slaughter of slaughter of progeny of cow was challenged before the Gujrath High Court and the High Court struck down the amendment. The matter reached the Supreme Court in State of Gujarat v. Mirzapur Moti Kureshi Kassab Jamat, (2005) 8 SCC 534. The Supreme Court reversed the judgment of the Gujrath High Court and upheld the validity of the 1994 amendment imposing the total ban. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;11.The Supreme Court relied on its earlier decision in State of W.B. v. Ashutosh Lahiri (1995) 1 SCC 189 to the effect that sacrifice of any animal by Muslims for the religious purpose on BakrI&rsquo;d does not include slaughtering of cows as the only way of carrying out that sacrifice. Slaughtering of cows on BakrI&rsquo;d is neither essential to nor necessarily required as part of the religious ceremony. The Court observed that an optional religious practice is not covered by Article 25(1) and that the cow and its progeny i.e. bull, bullocks and calves are worshipped by Hindus on specified days during Diwali and other festivals like Makar Sankranti and Gopashtmi. A good number of temples are to be found where the statue of &ldquo;Nandi&rdquo; or &ldquo;Bull&rdquo; is regularly worshipped. However, the Court did not delve further into the religious angle since none of the parries tried to build any argument either in defence or in opposition by placing reliance on religion or Article 25 of the Constitution.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;12.In the course of its judgment, the Supreme Court observed that no doubt, a cow ceases to be &ldquo;milch&rdquo; after attaining a particular age. Yet, the cow has been held to be entitled to protection against slaughter without regard to the fact that it has ceased to be &ldquo;milch&rdquo;. This constitutional position is well settled. So is the case with calves. Calves have been held entitled to protection against slaughter without regard to their age and though they are not yet fit to be employed as &ldquo;draught cattle&rdquo;. Following the same construction of the expression, it can be said that the words &ldquo;calves and other milch and draught cattle&rdquo; have also been used as a matter of description of a species and not with regard to age. Thus, &ldquo;milch and draught&rdquo; used as adjectives simply enable the classification or description of cattle by their quality, whether they belong to that species. This classification is with respect to the inherent qualities of the cattle to perform a particular type of function and is not dependant on their remaining functional for those purposes by virtue of the age of the animal. &ldquo;Milch and draught cattle&rdquo; is an expression employed in Article 48 of the Constitution so as to distinguish such cattle from other cattle which are neither milch nor draught.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;13.See the following exposition of the Court. It is estimated that a bull or bullock at every stage of life supplies 3500 kg of dung and 2000 litres of urine and whereas this quantity of dung can supply 5000 cubic feet of biogas, 80 MT of organic fertiliser, the urine can supply 2000 litres of pesticides and the use of these products in farming increases the yield very substantially. The value of the above contribution can be placed at Rs 20,000 per year to the owner. Production of various agricultural crops removes plant nutrients from the soil, they must be replenished with manures to maintain and improve fertility of the soil. There are two types of manures. The importance of organic manure as a source of humus and plant nutrients to increase the fertility level of soils has been well recognised. The organic matter content of cultivated soils of the tropics and sub-tropics is comparatively low due to high temperature and intense microbial activity. The crops remove annually large quantity of plant nutrients from soil. Moreover, Indian soils are poor in organic matter and in major plant nutrients. Therefore, soil humus has to be replenished through periodic addition of organic manure for maintaining soil productivity. Animals are the source of free availability of farmyard manure, which has all the three elements i.e. nitrogen, phosphoric acid and potash, needed in fertiliser and at the same time which preserve and enrich the fertility of the soil. In paucity of dung availability, the farmers have to depend upon chemical fertilisers. Investment in chemical fertilisers imposes heavy burden upon the economy. If there is availability of alternate source of organic manure from animals, it is required to be promoted. The recent scenario of ultramodern technology of super ovulation, embryo transfer and cloning technique will be of very much use to propagate further even from the incapable or even old animals which are not capable of working or reproducing. These animals on a large scale can be used for research programmes as well as for production of non-conventional energy sources such as biogas and natural fertilizers. At present, there are 19,362 biogas plants installed in the State during 1995-97. On an average, each adult cattle produces 4.00 kg of dung per day. Out of the total cattle strength of (1992 census) 67,85,865 the estimated dung produced is 99,07,363 tonnes.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;14.On the argument of the butchers the court observed that they are doing their business since generations, but they are not doing only the slaughter of cow class of animals. They slaughter and trade the meat of other animals like buffaloes, sheep, goats, pigs and even poultry. Beef (meat of cattle) contributes only 1.3% of the total meat groups. Proportion of demand for beef is less in the context of demand for pig, mutton and poultry meat. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;15.Shri D.P. Amin, Joint Director of Animal Husbandry, Gujarat State, filed an affidavit before the Supreme Court explaining the following. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&quot;India is predominantly an agrarian society with nearly 3/4th of her population living in seven lakh rural hamlets and villages, possesses small fragmentary holdings (54.6% below 1 hectare 18% with 1-2 hectares). Draught/pack animal contributes more than 5 crore horsepower (HP) or 33,000 megawatt electric power and shares for/in 68% of agricultural operations, transport and other draught operations. In addition to draft power, 100 million tonnes dung per year improves the soil health and is also used as raw material for biogas plant. The dung is very valuable. An old bullock gives 5 tonnes of dung and 343 pounds of urine in a year which can help in the manufacture of 20 cartloads of composed manure. This would be sufficient for manure need of 4 acres of land for crop production. The right to life is a fundamental right and it can be basically protected only with proper food and feeding and cheap and nutritious foodgrains required for feeding can be grown with the help of dung. Thus the most fundamental thing to the fundamental right of living for the human being is bovine dung. (Reference Report of National Commission on Cattle, Vol. III, pp. 1063-64). The dung cake as well as meat of bullock are both commercial commodities. If one bullock is slaughtered for its meat (slaughtering activity) can sustain the butchers&rsquo; trade for only a day. For the next day&rsquo;s trade another bullock is to be slaughtered. But if the bullock is not slaughtered, about 5000-6000 dung cakes can be made out of its dung per year, and by the sale of such dung cake one person can be sustained for the whole year. If a bullock survives even for five years after becoming otherwise useless it can provide employment to a person for five years whereas to a butcher, bullock can provide employment only for a day or two. Even utility of urine has a great role in the field of pharmaceuticals as well as in the manufacturing of pesticides. The Goseva Ayog, Government of Gujarat had commissioned study for &ldquo;Testing insecticide properties of cow urine against various insect pests&rdquo;. The study was carried out by Dr. G.M. Patel, Principal Investigator, Department of Entomology, C.P. College of Agriculture, S.D. Agricultural University, Sardar Krishi Nagar, Gujarat. The study has established that insecticide formulations prepared using cow urine emerged as the most reliable treatment for their effectiveness against sucking pest of cotton. The conclusion of the study is that dung and urine of even aged bullocks are also useful and have played a major effective role in the Indian economy.&quot;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Conclusion: Considering the cow-slaughter issue purely from the religious angle is doing complete injustice to the economic issues. The studies have shown the importance of the cattle for the agrarian activities and the overall grown of the farming sector. The focus of the present generation shall be free from the shackles of religious, parochial and fundamentalism. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Legislation in India. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;ANDHRA PRADESHTHE ANDHRA PRADESH PROHIBITION OF COW SLAUGHTER AND ANIMAL PRESERVATION ACT, 1977. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;Cow&rdquo;- includes heifer, or a calf, whether male or female of a cow.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;Calf&rdquo;- age not defined.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of &ldquo;Cow&rdquo; prohibited&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bull, bullock allowed on &lsquo;fit-for-slaughter&rsquo; certificate, to be given only if the animal is not economical or is not likely to become economical for the purpose of breeding or draught/agricultural operations.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Penal provisions:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences: cognisable&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE ASSAM CATTLE PRESERVATION ACT, 1950&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo; Cattle&rdquo; means `Bulls, bullocks, cows, calves, male and female buffaloes and buffalo calves.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;Calf&rdquo; not defined.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of all cattle allowedon &lsquo;fit-for-slaughter&rsquo; certificate, to be given if cattle is over 14 years of age or has become permanently incapacitated for work or breeding due to injury, deformity or any incurable disease.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Penal provisions:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offence:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cognisable only&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE BIHAR PRESERVATION AND IIMPROVEMENT OF ANIMALS ACT, 1955&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Bull &ndash; uncastrated male of above 3 years.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Bullock - castrated male of above 3 years.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Calf - male or female below 3 years.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cow - female above 3 years.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow and calf totally prohibited&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bull or bullock of over 15 years of age or has become permanently incapacitated for work or breeding due to injury, deformity or any incurable disease.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offence:Cognisable only&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Export of cows, calves, bulls and bullocks from Bihar is not allowed for any purpose.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE GOA , DAMAN &amp; DIU PREVENTION OF COW SLAUGHTER ACT, 1978&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cow includes cow, heifer or calf.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Age of calf not defined.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Total ban on slaughter of cow except when cow is suffering pain or contagious disease or for medical research.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Prohibition of sale of beef or beef products in any form.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to 2 years or fine up to Rs 1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Both cognisable and non-bailable.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE GOA ANIMAL PRESERVATION ACT, 1995 &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Applicable to bulls, bullocks, male calves and buffaloes of all ages.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;All the animals can be slaughtered on &lsquo;fit-for-slaughter&rsquo; certificate which is not given if the animal is likely to become economical for draught, breeding or milk (for she/buffaloes) purposes&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Prohibition of sale of beef obtained in contravention of above provisions, except beef imported from other States.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE DELHI AGRICULTURAL CATTLE PRESERVATION ACT, 1994&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Agricultural Cattle- cows of all ages, calves of cows of all ages, bulls and bullocks.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of all agricultural cattle is totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Transport or Export for slaughter is also prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Export for other purposes permitted on declaration that cattle will not be slaughtered. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Export to a State where slaughter is not banned by law will not be permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment upto five years and fine upto  Rs. 10,000, provided that normally imprisonment should not be less than 6 months and fine not less than Rs 1,000.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Burden of proof is on the accused.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Both cognisable and non-bailable.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE BOMBAY ANIMAL PRESERVATION ACT, 1954 (APPLIED TO GUJARAT )&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Applicable to bulls, bullocks, cows, calves and male/female buffalo calves.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow, calf, bull or bullock totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of buffaloes permitted on certain conditions.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE PUNJAB PROHIBITION OF COW SLAUGHTER ACT, 1955 (APPLICABLE TO HARYANA)&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE PUNJAB PROHIBITION OF COW SLAUGHTER ACT, 1955&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;(APPLICABLE TO THE STATE OF HIMACHAL PRADESH )&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;JAMMU &amp; KASHMIR - THE RANBIR PENAL CODE, 1932&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Voluntary slaughter of any bovine animal such as ox, bull, cow or calf shall be punished with imprisonment of either description which may extend to 10 years and shall also be liable to fine.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Fine may extend to five times the price of the animals slaughtered as determined by the Court.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Possession of flesh of killed or slaughtered animals is also an offence punishable with imprisonment up to 1 year and fine up to Rs 500.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE KARNATAKA PREVENTION OF COW SLAUGHTER AND CATTLE PRESERVATION ACT, 1964&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Animal - means bull, bullock, and all buffaloes.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cow &ndash; includes calf of a cow, male or female.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow, calf of a cow or calf of a she-buffalo totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bulls, bullocks and adult buffaloes permitted on &lsquo;fit-for-slaughter&rsquo; certificate provided cattle is over 12 years of age or is permanently incapacitated for breeding, draught or milk due to injury, deformity or any other cause.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Transport for slaughter to a place outside a state not permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Sale purchase or disposal of cow or calf for slaughter not permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months or fine of up to Rs1,000 or both.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Kerala Panchayat (Slaughter Houses and Meat Stalls) Rules, 1964&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Panchayat laws provide for prohibition of slaughter of useful animals in Panchayat (non-municipal) areas in the State. Under the Kerala Panchayat (Slaughter Houses and Meat Stalls) Rules, 1964, no certificate shall be granted under Rule 8 in respect of a bull, bullock, cow calf, he-buffalo or she-buffalo or buffalo calf unless the animal is over 10 years of age and is unfit for work or breeding or the animal has become permanently incapacitated for work or breeding due to injury or deformity. In 1976, the Kerala Government issued an executive order banning the slaughter of useful animals in the Municipal areas as well.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE MADHYA PRADESH AGRICULTURAL CATTLE PRESERVATION ACT, 1959.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Agricultural cattle means cows of all ages, calves of cows, bull, bullocks and all buffaloes.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow, calf of cow, bull, bullock and buffalo calf prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;However, bulls and bullocks are being slaughtered in the light of Supreme Court judgement, provided the cattle is over 15 years or has become unfit for work or breeding.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Transport or export for slaughter not permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Export for any purpose to another State where cow slaughter is not banned by law is not permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Sale , purchase, disposal of cow and its progeny and possession of flesh of cattle is prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to 3 years and  fine of Rs.5,000.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Normally imprisonment shall not be less than 6 months and fine not less than Rs 1,000.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Burden of proof is on the accused.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE MAHARASHTRA ANIMAL PRESERVATION ACT, 1976&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Cow&rsquo; includes a heifer or male or female calf of a cow.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt; Slaughter of cow totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bulls, bullocks and buffaloes allowed on fit-for-slaughter certificate, if it is not likely to become economical for draught, breeding or milk (in the case of she-buffaloes) purposes.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months and fine of up to Rs1,000.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Burden of proof is on the accused.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;MANIPUR- PROCLAMATION BY MAHARAJA - DARBAR RESOLUTION OF 1936&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;According to Hindu religion the killing of cow is a sinful act.  It is also against Manipur Custom.  I cannot allowed such things to be committed in my State.  So if any one is seen killing a cow in the State he should be prosecuted.&rdquo;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;MEGHALAYA- No legislation&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Nagland &ndash; No legislation &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE ORISSA PREVENTION OF COW SLAUGHTER ACT, 1960&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bull, bullock on fit-for-slaughter certificate if cattle is over 14 years of age or has become permanently unfit for breeding, draught.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 2 years or fine up to Rs 1,000 or both. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE PONDICHERRY PREVENTION OF COW SLAUGHTER ACT, 1968&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Cow&rsquo; includes heifer or calf.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bull or bullock permitted on &lsquo;fit-for-slaughter&rsquo; certificate provided it is over age of 15 years or has become permanently unfit for breeding or draught.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Prohibition on sale, transport of beef.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 2 years or fine up to Rs 1,000 or both. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cognisable and non-bailable.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE PUNJAB PROHIBITION OF COW SLAUGHTER ACT, 1955&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&ldquo;Cow&rdquo; includes bull, bullock, ox, heifer or calf.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt; Slaughter of cow (and its progeny) totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Export for slaughter not permitted.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Sale of beef prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 2 years or fine up to Rs 1,000 or both. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Burden of proof is on the accused.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable and non-bailable&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE RAJASTHAN BOVINE ANIMAL (PROHIBITION OF SLAUGHTER AND REGULATION OF TEMPORARY MIGRATION OR EXPORT) ACT, 1995.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Bovine&rsquo; - means and includes cow, calf, heifer, bull or bullocks.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Bull&rsquo; - means uncastrated male above 3 years&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Bullock&rsquo; - means castrated male above 3 years&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Calf&rsquo; - means castrated or uncastrated male of 3 years and below.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Cow&rsquo; - means female above 3 years; &lsquo;Heifer&rsquo; is female of 3 years or below. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of all bovine animals prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Possession sale, transport of beef and beef products is prohibited.  Export of bovine animal for slaughter is prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Custody of seized animals to be given to any recognized voluntary animal welfare agency failing which to any Goshala, Gosadan or a suitable person who volunteers to maintain the animal.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Rigorous imprisonment of not less than 1 year and up to maximum of 2 years and fine up to Rs 10,000. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Burden of proof is on the accused.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE TAMIL NADU ANIMAL PRESERVATION ACT, 1958&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Animal&rsquo; means bulls, bullocks, cows, calves; also, buffaloes of all ages.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;All Animals can be slaughtered on &lsquo;fit-for-slaughter&rsquo; certificate&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Certificate given if animal is over 10 years of age and is unfit for work and breeding or has become permanently incapacitated for work and breeding due to injury deformity or any incurable disease.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Penal Provisions:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment of up to 3 years or fine up to Rs 1,000 or both.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE UTTAR PRADESH PREVENTION OF COW SLAUGHTER ACT, 1955.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Beef&rsquo; means flesh of cow and of such bull or bullock whose slaughter is prohibited under the Act, but does not include such flesh contained in sealed containers and imported into U.P.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;&lsquo;Cow&rsquo; includes a heifer and calf. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of cow totally prohibited.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of bull or bullock permitted on &lsquo;fit-for-slaughter&rsquo; certificate provided it is over the age of 15 years or has become permanently unfit for breeding, draught and any agricultural operations.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Transport of cow outside the State not permitted for slaughter.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Prohibition on sale of beef. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Penalty provisions:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Rigorous imprisonment up to 2 years or fine up to Rs 1,000 or both.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;THE WEST BENGAL ANIMAL SLAUGHTER ACT, 1950&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;bullocks, cows calves and buffaloes of all types/ages. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ban on Slaughter :&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Slaughter of all animalspermitted on &lsquo;fit-for-slaughter&rsquo; certificate&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Certificate given if animal is over 14 years of age and unfit for work or breeding or has become permanently incapacitated for work and breeding due to age, injury, deformity, or any incurable disease. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Penal provisions:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Imprisonment up to maximum of 6 months   or fine up to Rs 1,000 or both.  &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Offences Cognisable only.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;S. BASAVARAJ,&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Daksha Legal&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Advocates&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Unit No.1, 2nd floor, &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;No.11, Jeevan Buildings (new block)&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Kumara Park East,&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Bangalore 560001&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ph: +91 080 41138502 &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Cel: 9845065416&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;email: raj@dakshalegal.com&lt;/div&gt;&lt;/div&gt;', 'a6bbcb63015c29a4108ff19bd7cc6e64.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:29:27', '2020-12-23 03:01:43');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(39, 'cjSBOM8Wfo9oFVQhX9Yah3QL1', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'SOCIAL SECURITY IN UNORGANISED SECTOR.  Mr. Vishnu Vinayak C.R ', '&lt;div class=&quot;kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;By Mr. Vishnu Vinayak C.R, 3 year LLB, Seshadripuram Law College.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Ofttimes, individuals cannot be identified by a universal definition, but can be described in a very eccentric method. These people incapable of entering the mainstream employment or organised sector due to assorted factors such as illiteracy, ignorance, establishing small size establishments which cannot be fed with sufficient capital, etc. It is estimated that three-fourth of the world population suffers from poverty, absolute insecurity in their jobs, illiteracy, and unemployment.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Security, as the name itself suggests, is a protection given by the State or certain members of the society to its people. Contingencies are inevitable in life. If people fail have a proper social security, then they will be feeble when they face adversaries. In order to avoid this situation, social security has become an important facet of every individual&rsquo;s life.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;What is an Unorganised Sector?&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Whenever an enterprise is owned by individuals/ workers who are less than ten in number and who are engaged in the production of goods or providing services in any sector, then such sector can be called as an unorganised sector. A sector can be called as unorganised/informal when the Government has made no rules and regulations to govern a sector. Entry into such sectors are not restricted at all and similarly, there exists no security with respect to employment.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Definition by Kenneth King- &ldquo;Their unorganisedity derives from their being unrecognised in government employment statistics and operating in the main act of the make shift shelters on urban waste lands, roadsides and forest fringes.&rdquo; &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;National Commission for Enterprises in the Unorganised Sector provides definition of unorganised sector as: &ldquo;The unorganised sector consists of all unincorporated private enterprises owned by individuals or households engaged in the sale and production of goods and services operated on a proprietary or partnership basis with less than ten total workers&rdquo;. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Hawkers, street vendors, fishermen, cobblers, goldsmiths, blacksmiths, carpenters, building construction workers, sweepers, and scavengers, etc. are few of the many individuals who work in unorganised sectors.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Origin&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Historically, people used to confide in their families, tribes, communities and certain authorities such as kings, lords, and church for their social security. After the industrialization era swept in, the concept of social security has changed throughout the world. The modern concept of social security dates back to the 19th century in Europe. But it was only after the World War II, that social security augmented. The Communist government was established and had a radically different economic and political ideologies. Most of the assets were in State&rsquo;s control. After the fall of the Communist Governments in Europe, there was a huge transition in the political and economic ideologies which also had a gigantic impact on the system of social security. Slowly the concept of welfare state crept in and the world started giving importance to the reduction / elimination of poverty and inequality. One such example is the implementation of United States Social Security Act, 1935.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Security (Informal Sectors) in Developed Nations&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The social security can be categorised into two:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1. Social Insurance&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2. Social Assistance.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Insurance refers to the contributory and sometimes mandatory programmes that cover the workers in the formal/informal sector and their dependants. The cover is given against major adversaries such as health issues, old age, and unemployment. Beneficiaries are required to contribute specified wages to receive the benefit of these insurances. Social insurance primarily focuses on the formal sector. However, in developed countries, the informal sector is also covered to a certain extent.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Assistance is a non-contributory and voluntary programme that focusses on covering the risks of people working in the informal sector. Technically, the beneficiaries in this sector receive help and not cover against the risks. A cover for a risk is given only in case of an insurance wherein the beneficiary contributes to be protected by contingencies. The objective of social assistance is to relieve poverty.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The social security in developed countries progressed rapidly post World War II. Social security systems in developed economies are dynamic, complex and huge, ranging from approximately 15% of GDP in the United States to almost 30% of GDP in Sweden. Countries such as U.K., Germany, and France fall under the category of &lsquo;High Spending Nations&rsquo; for social assistance whereas Ireland, Australia, Canada, Japan, and U.S.A fall under &lsquo;Medium Spending Nations&rsquo;. Singapore, Hong Kong, China and South Korea are rapidly developing economies and are equalling the developed nations. In heavily insured and assisted countries, poverty has reduced to approximately 70%, whereas in the United States it has reduced by 28%. In European countries, poverty is reduced by 40%. Belgium currently holds the highest rate of poverty reduction (74%). &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Security (Unorganised Sectors) in Developing Nations&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The social security system in most of the developing nations is very diverse as there is a huge variation in the economic, social and political setup. The colonial authorities were the first to introduce social security in many of the Asian and African countries.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;A number of developing nations claim to have developed a comprehensive scheme for the general population, which lays great emphasis on the informal sector. Almost 13 countries in Africa claim to provide social security to people in the unorganised sector. Similarly, several Asian and Latin American countries claim to provide social health insurance schemes.  An organisation called the &lsquo;Instituto Politecnico Tomas Katari (IPTK)&rsquo; is providing health insurance scheme to the informal sector workers from 1996 in Bolivia.  Mexico has formulated a scheme wherein workers in the informal sector get to access health insurance protection in exchange for a nominal annual fee. Tanzania has also started a micro health insurance scheme for its people in informal sectors. In India, numerous organisations are working to cover and protect the workers in informal sectors. Similar scenario exists even in Bangladesh, Philippines, and Sri Lanka.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The preeminence till date is only on sickness benefits. The other benefits such as social insurance pension, disability insurance is still a myth in developing countries. Unemployment is still a plague which needs to be eradicated, but no social assistance exists. There are instances wherein India has given a social assistance with respect to unemployment such as the &lsquo;Maharashtra Employment Guarantee Scheme&rsquo;, but the implementation is extremely poor.  &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Micro-financial institutions have been playing a dominant role in trying to cover and protect the informal sector within their limited expenditure. However, in all these years the States have not actively participated in protecting the informal sector through legislations or funding. The micro financing institutions are bound by their own limitations. In such circumstances, the informal sector is still gloomy.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Social Security (Unorganised Sector) in India&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The Constitution of India in its Directive Principles of State Policy state- &ldquo;State shall, within the limits of its economic capacity and development, make effective provision for securing the right to work, to education and to public assistance in cases of unemployment, old age, sickness and disablement, and in other cases of undeserved want.&rdquo;  The Centre, as well as the States, shall have the power to frame relevant legislations, schemes/programmes and establish funds as the relevant item- &ldquo;Social security and social insurance; employment and unemployment&rdquo;   is listed in the Concurrent list.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The National Commission for Enterprises in the Unorganized Sector (NCEUS) estimates that approximately 90% of the workforce are present in the informal sector. It also estimated that to cover the entire informal sector, the Central Government needs to shell out around 20,500 crores whereas the State Governments are to contribute around 4,100 crores.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Since the majority of our country&rsquo;s population lie under the informal sector, there is a constant thought process involved in trying to bring in new effective mechanisms or improve the existing ones to reduce the rate of unemployment, poverty and other social contingencies that exist in the unorganised sector. Post economic liberalization in 1991, the Central Government is constantly attempting to cover the informal sector under social insurance. The second approach taken by the Governments is by establishing social security funds.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Though insurance is an old and expeditiously growing market, the insurance companies including the state-owned companies are not targeting the informal sector. Many times, the insurance companies were unwilling to participate in the social insurance schemes. The General Insurance Corporation (GIC), once gave a statement in the media, &ldquo;this section of society (the economically poor), is not much attracted to the concept of insurance which has its base the element of probability. The weaker section looks forward to immediate benefits and does not depend on deferred ones.&rdquo; After the formation of new Government at the Centre in 2014, the Prime Minister announced two social insurance schemes- Pradhan Mantri Suraksha Bima Yojana and Pradhan Mantri Jeevan Jyoti Bima Yojana wherein the beneficiaries have to contribute a very nominal amount but the benefit they would earn would be huge in case of happening of specified event/s. These schemes were introduced to cover the people in the unorganised sector and were a huge success.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The National Social Assistance Programme covers (i) National Old Age Pension Schemes, (ii) National Family benefits schemes, (iii) National Family benefits scheme and (iv) National Maternity Benefit Scheme. Sampoorna Gramin Rozgar Yojana (SGRY) provides employment opportunities in rural areas. There are also rural schemes such as the Indira Gramin Awas Yojana and Pradhan Mantri Gramodaya Yojana. The Central Government launched the Krishi Sharmil Samajik Suraksha Yojna to cover approximately ten lakh agricultural workers.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The Ministry of Labour has framed various legislations such as: The Cine-Workers and Cinema Theatre Workers (Regulation of Employment) Rules, 1984, The Cine Workers&rsquo; Welfare Fund Act, 1981, The Iron Ore Mines, Manganese Ore Mines &amp; Chrome Ore Mines Labour Welfare Fund Act, 1976, The Beedi Workers Welfare Fund Act, 1976, The Mica Mines Labour Welfare Fund Act, 1946 and has thereby established welfare funds for Bidi-workers, limestone&rsquo;s, and dolomite mineworkers, iron ore; chrome ore and manganese ore mine workers, mica mine workers and cine workers. People working in Posts and Telegraph, Ports and Dockyards also have special welfare funds. The State Governments have also passed various legislations and have established funds depending on the type of informal sector present in their states. The local authorities such as the Municipal Corporations, Panchayats are delegated with the power to make relevant provisions for the benefit of the workers working in their jurisdiction.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Non-Government Organizations (NGOs) play a pivotal role in safeguarding the people in the unorganised sector. It is estimated that around one lakh households are covered by various NGOs throughout the country. NGOs have till now largely focussed on providing health related support. The next in line would be disability reliefs and then maternity benefits. However, in the recent years, the Governments are trying to strictly monitor the NGOs due to suspected money laundering activities but it cannot be negated that genuine NGOs contribute significantly to protect the people in informal sector voluntarily.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Unorganized Workers&rsquo; Social Security Act, 2008&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The Government of India&rsquo;s decision to pass the legislation was a giant leap in the social security system for the unorganised sector. The Central Government can formulate welfare schemes for the unorganised workers on matters relating to:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;a) Life and disability cover;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;b) Health and maternity benefits;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;c) Old age protection;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;d) Provident fund;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;e) Employment injury benefit;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;f) Housing;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;g) Educational schemes for children;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;h) Any other protection as deemed necessary by the Central Government. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Any scheme notified by the Central Government may be completely funded by the Central Government or partly by the Centre and State Governments or partly by the Centre, State, and the beneficiaries or the employers in unorganised sectors.  By virtue of this Act, the Central Government and the State Government can establish a Board known as the National Social Security Board and [Name of State] Social Security Board respectively to perform the functions stated in the Act and Rules. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Every worker in the unorganised sector will be eligible to register and obtain benefits under this Act provided he/ she has completed fourteen years of age and he/she gives a self-declaration that he/she is an unorganised worker.  Schedule I of the Act contains a list of social security schemes for the unorganised sector whereas Schedule II contains a list of legislations which can be extended to the unorganised sector.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Constraints in Developing Countries&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Developing countries face a large-scale setback when it comes to implementation of social assistance programmes to the unorganised sector. Whenever a scheme is developed, the State cannot depend on partial contributions given by the beneficiaries since the majority are unemployed and poverty stricken. The situation in India is comparatively better than African countries and other South Asian Countries. However, every developing nation faces certain other constraints such as:&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1. Fiscal Constraints&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The developed countries largely depend on their taxing regime to support social insurance and social assistance schemes. Their GDP is much higher compared to the developing nations. Also, the taxing is much higher in many developed countries which help in accumulating sufficient funds for the social security programmes.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Some of the major problems faced by people in developing nations are unemployment and poverty. In such circumstances, there is no minimum income which people in the unorganised sector are earning for them to pay taxes to the Government. Also, the taxing percentage is much lower compared to developed countries. The GDPs are yet to improve to a great extent in developing countries for the Governments to finance the social security mechanisms.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2. Political and Administrative Issues&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Most of the developing countries have a cash dominated economy wherein the record keeping is very difficult for the Governments. Black money is another major issue that the developing countries are dealing with. Even if a social security programme is introduced, it suffers from corruption and misuse by the non-poor. The implementation is not effectively designed and therefore, it fails to reach the grass root level.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Concluding Thoughts&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;It is undisputable that the developed nations are way ahead with respect to the formulation and implementation of social security programmes for the unorganised sector. The developing nations are the ones who are yet suffering from problems such as tax evasion, money launderings, oppression by the powerful and inadequate financial institutions to serve the social security segment.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;However, it is high time for the developing nations, especially a country like India, which has aspirations to attain the status of &lsquo;super power&rsquo; and &lsquo;developed nation&rsquo; to move towards a universal social security mechanism. As stated earlier, many developing nations depend on general taxes to finance the social security segment. To achieve higher tax income, the problem of tax evasion should be eliminated. Also, general taxing is bound by political discussions and differences. In India, it is a nightmare where 29 states have their respective State Governments and in matters of social security, the State Governments largely depend on the Central Government to finance the schemes.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The objective of any social security scheme for the unorganised sector should not merely be to shield the people in the informal sector. The larger objective should be to eradicate poverty and unemployment so that the beneficiaries can significantly contribute to the social security schemes and enjoy its benefits. The developing nations need a transformation of their economy, thereby increasing their GDP which automatically facilitates a higher percentage of public spending on social security. &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;BIBLIOGRAPHY&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;In bringing out this article, I have read through and utilized the contents of the following. However, the language and expression used in the article is solely mine.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;1. Ministry of Labour, Government of India available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.labour.nic.in%2Flabour-welfare%3Ffbclid%3DIwAR2tlwyj-wxFqXYQMgE-pU0VkLaCD6IkbS51QIl1DORuS7co_Tx19YvP3sY&amp;h=AT3nYndNABoV034jjGs2K66pnxyCk3xoavMCl7yYOOCaKHogdJJRf6SkW4iQodnlYgzHSaNgP2hvp3n0_mrp9YoaH2QGCmZknyGTdgbNDHDZbjhWCcXPpswv46iJEqqv-0vJ&amp;__tn__=-UK-R&amp;c[0]=AT0vNZFU2fDT7hMirxwwonFcv62rAmPFUOf2iM2crHF4WT2km18WU9mJyMqlm5MgO2rtz6WSmmccL62AFRvKcP2wAoibBgip0MrJlvshxwYnShzQtPbHhuKGFUVkZSrEQK_MbnCH-AuvriHQq0KAO6115zL34r8wmiE&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://www.labour.nic.in/labour-welfare&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2. National Commission for Enterprises in the Unorganized Sector, (Ministry of Small Scale Industries, Government of India) available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.nceuis.nic.in%2F%3Ffbclid%3DIwAR2esELZaZ2DyMECX-WOfOTEVFEFhWwHfy7eYd7xz5QnoNkLQ_ELNzV0_IQ&amp;h=AT2HJpKtJAHTxw_Aw65GNL1DNWrz7GyvkXn3QYnhVysDBCiuBYWMyAEOrMkawt0t3NQL1rNDgnj9exHwOFd4rQDmUjYHa7dK2H4ofuJsydRVD0xJuIzG93_28T8y0WgV-pIP&amp;__tn__=-UK-R&amp;c[0]=AT0vNZFU2fDT7hMirxwwonFcv62rAmPFUOf2iM2crHF4WT2km18WU9mJyMqlm5MgO2rtz6WSmmccL62AFRvKcP2wAoibBgip0MrJlvshxwYnShzQtPbHhuKGFUVkZSrEQK_MbnCH-AuvriHQq0KAO6115zL34r8wmiE&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://www.nceuis.nic.in/&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;3. Patricia Justino, Social Security in Developing Countries: Myth or Necessity? Evidence From India, University of Sussex available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fcore.ac.uk%2Fdownload%2Fpdf%2F6301572.pdf%3Ffbclid%3DIwAR0afV2tLNKP1WtBxycHk33vSFfdcFm4bA_7EvG9MRMskISHDIvqAvv1g4s&amp;h=AT08e8OlA-QORCaduIho5_8KWI_99fFK4ixraX3r9YOJtBEMwq6twouHWeb479GPP_q_4NrTU7LhQ7vzcbyF7472ja3Qj5VOwKT2SvH1eJEYlbIQagVlIynSpPuLPxViHBeA&amp;__tn__=-UK-R&amp;c[0]=AT0vNZFU2fDT7hMirxwwonFcv62rAmPFUOf2iM2crHF4WT2km18WU9mJyMqlm5MgO2rtz6WSmmccL62AFRvKcP2wAoibBgip0MrJlvshxwYnShzQtPbHhuKGFUVkZSrEQK_MbnCH-AuvriHQq0KAO6115zL34r8wmiE&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://core.ac.uk/download/pdf/6301572.pdf&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;4. Jean-Jacques Dethier, SOCIAL SECURITY- What Can Developing Countries Learn from Developed Countries?, International Food Policy Research Institute available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2Fconferences.ifpri.org%2F2020chinaconference%2Fpdf%2Fbeijingbrief_dethier.pdf%3Ffbclid%3DIwAR2XJ_uGp_3v_0TBIa8WymMGeF0ql7NaQFMHyg7IyWZxPm1Ehk2hdz8ANl0&amp;h=AT0c93qw3FgVVZylVBXCOBjxpVOndjn-CC9UJgU7-YC9hC8i1E7b1NebDc_LF1-QtM_mlQmEyaeOHdAofDe9TtElQp3W4v94yURezOYMIlBSfBocvGz84JglBPJD-EX5M6uH&amp;__tn__=-UK-R&amp;c[0]=AT0vNZFU2fDT7hMirxwwonFcv62rAmPFUOf2iM2crHF4WT2km18WU9mJyMqlm5MgO2rtz6WSmmccL62AFRvKcP2wAoibBgip0MrJlvshxwYnShzQtPbHhuKGFUVkZSrEQK_MbnCH-AuvriHQq0KAO6115zL34r8wmiE&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://conferences.ifpri.org/.../beijingbrief_dethier.pdf&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;5. World Labour Report 2000: Income security and social protection in a changing world, International Labour Office(Geneva), November 2000 available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;http://www.ilo.org/public/english/standards/relm/gb/docs/gb279/pdf/esp-7.pdf?fbclid=IwAR367vR6HWFqs25zrNqnuNeaChCg2GbgamoNUh4pqh_TW7q6YX1afIh2IWw&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://www.ilo.org/.../relm/gb/docs/gb279/pdf/esp-7.pdf&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;6. Dharam Ghai, Social security priorities and patterns: A global perspective, International Institute For Labour Studies Geneva available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fpapers.ssrn.com%2Fsol3%2Fpapers.cfm%3Fabstract_id%3D366081%26fbclid%3DIwAR1NDV7dGgMbx0YMGDwUNolWr6wjafz-51O-N0fPOIUwoNsfktm7vur74wU&amp;h=AT1fBrseQ15VzK1Oq3O79HOsvjATZ2QKLpYagdGi0x18WOkAebw9PPR9mYbh_l70cPsuMx98Kr8E5IxUPBtqQvUVnteUaVvbAnAJ_YmNRpAq74P45mB8dHDNsbywSm7RS7Z1&amp;__tn__=-UK-R&amp;c[0]=AT0vNZFU2fDT7hMirxwwonFcv62rAmPFUOf2iM2crHF4WT2km18WU9mJyMqlm5MgO2rtz6WSmmccL62AFRvKcP2wAoibBgip0MrJlvshxwYnShzQtPbHhuKGFUVkZSrEQK_MbnCH-AuvriHQq0KAO6115zL34r8wmiE&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;https://papers.ssrn.com/sol3/papers.cfm?abstract_id=366081&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;7. Sudharshan Canagarajah and S.V. Sethuraman, Social Protection and the Informal Sector in Developing Countries: Challenges and Opportunities, Social Protection Unit- Human Development Network- The World Bank, December 2001, available at &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;http://siteresources.worldbank.org/SOCIALPROTECTION/Resources/SP-Discussion-papers/Labor-Market-DP/0130.pdf?fbclid=IwAR2OTU3ljSTuFPdQoPaxSarRhFv9FjW8WIGEEkTmeZ8MFfzIH3QoqPGvVCo&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://siteresources.worldbank.org/.../Labor.../0130.pdf&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;8. Miscellaneous Internet Articles&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;a)&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;http://shodhganga.inflibnet.ac.in/bitstream/10603/71638/12/12_chapter%205%20social%20security%20and%20unorganized%20sector.pdf?fbclid=IwAR3-QhM7VloXSpo60vey6xMVwd-4ZHV9dh702qKI83_sfXLGloU0eDW8l7M&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://shodhganga.inflibnet.ac.in/.../12_chapter%205...&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;b) &lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;a class=&quot;oajrlxb2 g5ia77u1 qu0x051f esr5mh6w e9989ue4 r7d6kgcz rq0escxv nhd2j8a9 nc684nl6 p7hjln8o kvgmc6g5 cxmmr5t8 oygrvhab hcukyx3x jb3vyjys rz4wbd8a qt6c0cv9 a8nywdso i1ao9s8h esuyzwwr f1sip0of lzcic4wl py34i1dx gpro0wi8&quot; href=&quot;http://shodhganga.inflibnet.ac.in/bitstream/10603/76677/12/12_chapter%205.pdf?fbclid=IwAR30N8eCiBr4l0FE1OHUQZPolZKCCcpn0IEH7Kb9eqzvBUR2YhT7YICVEAs&quot; rel=&quot;nofollow noopener&quot; role=&quot;link&quot; tabindex=&quot;0&quot; target=&quot;_blank&quot; style=&quot;color: var(--blue-link); cursor: pointer; outline: none; list-style: none; border-width: 0px; border-style: initial; border-color: initial; padding: 0px; margin: 0px; touch-action: manipulation; text-align: inherit; display: inline; -webkit-tap-highlight-color: transparent; font-family: inherit;&quot;&gt;http://shodhganga.inflibnet.ac.in/.../12/12_chapter%205.pdf&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;', '916e9755c23931f612f611eb4bdfcc95.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:36:27', '2020-12-23 03:00:37'),
(70, 'sTtJCxdq8DjmqUz6ROJEq9AF0', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Collapse of a system called Higher Judiciary in India. S. BASAVARAJ. Advocate Bangalore ', '&lt;p class=&quot;MsoNormal&quot; style=&quot;text-align: justify; &quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Whole system is collapsing,&rsquo; said the Supreme Court of India almost few months ago about vacancies in high courts, while hearing a Public Interest Litigation on backlog of cases. The number of vacancies of High Court judges has grown to 478 out of the sanctioned strength of 1079. In other words over 45 per cent of the positions of High Court judges are vacant. Root of the problem, as we all know, is the clause in the Memorandum of Procedure (which outlines the modus operandi to be followed in appointment of judges) that gives the government the right to reject names suggested by the Supreme Court Collegium system.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Against the approved strength of 1079 judges, the 24&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;high courts are functioning with 609 judges.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The Allahabad High Court has the maximum of 82&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;vacancies against the sanctioned strength of 160 judges.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;The Punjab and Haryana High Court with 39 (sanctioned strength of 85) and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;Madras High Court with 37 (against sanctioned strength of 75) vacancies each&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;come second and third respectively.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;High Court of Judicature at Hyderabad, which at the moment functions as High&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;Court of Telangana and Andhra Pradesh, has 36 vacancies as against the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;sanctioned strength of 61 judges. Karnataka High Court has the sanctioned&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;strength of 62 judges. It has to manage three benches with the existing&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;strength of just 25 judges. It has now 37 vacancies.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;The judiciary and the government have also been engaged in a tug of war over&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;the number of vacancies at the lower courts and its impact on the backlog of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;cases.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;In a pending matter the Supreme Court expressed unhappiness over Centre&rsquo;s&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;failure to implement the collegium&rsquo;s decision on transfer and appointment of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;judges and chief justices of high courts, observing &ldquo;why there is mistrust&rdquo;,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;and asked the Attorney General to seek instruction from the government.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;In a public interest litigation regarding backlog of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;cases a three-judge bench of the Supreme Court headed by Chief Justice T S&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;Thakur with Justice A M Khanwilkar and Justice D Y Chandrachud said observed&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;that the collegium has cleared 75 names of high court judges (for transfer/&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;appointment) but they have not been approved. Supreme Court wondered where&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;these files were stuck. The bench asked &ldquo;Why there is mistrust? Judges who have&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;been transferred by the collegium have not been transferred. We don&rsquo;t want all&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;this.&rdquo;&lt;br&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The elevation process which consists of members from&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the bar and the lower courts has come to a complete standstill due to the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;hitherto shadow boxing now a open fight between the judiciary and the central&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;government. Added to this, the decision of Justice Chalameshwar not to attend&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the collegium meetings has only worsened the scenario beyond comprehension.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The poorest of the poor litigants who are waiting for&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;years together to get their cases decided at the earliest, whether it is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;eviction of a tenant or recovery of property, compensation etc have to wait for&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;another decade given the present stautsquo.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The high court judges are under the tremendous&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pressure to hear the urgent matters at the admission stage and at the same time&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to dispose the old matters. The public opinion against pendency of cases in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;courts does not take into account the inaction on the part of the Government in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;extending active co-operation. The judiciary is facing the onslaught on all the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;sides, by the general public, the central government and from within.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The situation will only get worse in the coming days.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Few more senior judges of the Karnataka High Court have retired and due to retire&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in the coming months. The strength will be reduced to such level that the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;benches of Gulburga and Dharwar have to be closed temporarily.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The Bar Council of India, the State Bar Councils and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Advocates&rsquo; Associations across the country are helplessly watching the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;drama being unfolded.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;For a common man, the temple of justice is the Courts&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of law. If the Courts are choked to the hilt, speedy justice becomes a mirage.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;That&rsquo;s the tragedy of our time.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;S. BASAVARAJ, Daksha Legal Advocates&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Unit No.1, 2nd floor, No.11, Jeevan Buildings (new block) Kumara Park East,Bangalore 560001&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Ph: +91 080 41138502&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Cel: 9845065416&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;email: raj@dakshalegal.com&lt;/span&gt;&lt;/div&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;<br />\r\n&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;o:p&gt;&amp;nbsp;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;', '676a0bed8ee5439703320ac7088998d4.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 0, NULL, NULL, '2020-12-01 21:53:28', '2021-02-01 22:13:51');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(71, 'nY2t3qlkTn22YV49WSFIlYg3e', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'CONCEPT OF MEDIATION.  Justice Anand Byrareddy. ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;by Justice Anand Byrareddy (rtd), Karnataka High Court.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(Member, Daksha Legal Social Network Groups)&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;1. What is mediation ?&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Mediation is a process in which the mediator, an external neutral to the dispute , works with the parties to find a solution which is acceptable to all of them . The most important aspect of mediation is that the mediator cannot impose a decision on the parties. The mediator controls the process, but the outcome is always in the hands of the parties. Mediation is completely voluntary, both in the decision to try it as well as to continue with it. This is best illustrated by saying that a party is free to leave the mediation table, without being needed to give reasons, at any time if it feels that it is not being served well by the process. In its focus on non-coercive and consensual processes , mediation is , thus, radically different from the formal adversarial system. Mediation creates an atmosphere of confidentiality and enables the participation of parties , with their legal counsel or just by themselves. And while attention is paid to the law in so far as it impacts on the matter, the object is to arrive at a solution acceptable to the parties which will end the dispute. It is in essence an assisted negotiation process.&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;2. A mediator opens up communication , focuses parties&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;on their long-term interests, gets them to be realistic about their case and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;its prospects , encourages them to come up with options for settlement and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;helps them to refine those options to yield an agreement that both parties see&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;as a fair and proper end to the dispute . The mediator is a facilitator :&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;moving parties from the extreme ends of the disputing spectrum to the common&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;ground of settlement.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In essence, it involves moving parties from a &ldquo; me vs. you&rdquo; approach and an &ldquo;I&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;am right you are wrong&rdquo;, attitude to a joint search for solutions to the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;dispute. The process consists of joint and separate meetings. Joint meetings&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;enable parties to give their versions of the dispute , and the opportunity to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;listen to that of the other side. Separate meetings with the mediator enable&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;parties to speak openly examine their strengths and weaknesses, voice fears and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;concerns &ndash; so as to enable forward movement to exploring options for settlement.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Conflict places blocks on communication and freedom to explore options for&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;settlement; when these blocks are removed , creative problem solving is often&amp;nbsp;the result.&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;3. When does one opt for mediation ?&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The first step is the decision to try mediation. This would primarily be based&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;on the nature of the dispute. Assuming that mediation looks attractive or at&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;least feasible, since :&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;a) it is largely a risk-free process,&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;b) you know fairly early on whether it can work, and&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;c) it is usually better to explore consensual methods before adversarial ones.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;4. The next step is to find out whether the other&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;party to the dispute is also willing. Most times , one party to a dispute is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;reluctant to suggest a settlement process to the other, for fear of being taken&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to have a weak case . This need not be a stumbling block . An institute of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Mediation can be approached which will contact the other party . If mediation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is built into a contract, that makes recourse to it almost automatic. And as&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;awareness of mediation grows there will be no devaluation of negotiating&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;positions in suggesting its use.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;5. Where a court directs parties to mediation ,in a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pending case, it becomes a mandate which must be tried.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Categories of cases suitable for reference to mediation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;All cases of a civil nature in particular the following categories, whether&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pending before a civil court or other special tribunal or fora and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pre-litigation , are suitable for the mediation process&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;i) Disputes relating to trade, commerce and contracts&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;ii) Disputes arising from strained matrimonial, familial and other personal&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;relationships;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;iii) Civil disputes between neighbourers, employer-employee, organisations such&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;as societies, associations, clubs and its members ;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;iv) All consumer disputes.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Cases which would not be suitable for reference to mediation :&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;i) Disputes which are raised in a representative capacity, involving public&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;interest or involving the interest of a large unknown number of persons;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;ii) Disputes involving the grant of authority by the Courts after an enquiry,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;such as grant of probate or letters of administration;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;iii) Disputes involving serious fraud, forgery and other such circumstances;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;iv) Disputes requiring the protection of courts during pendency and thereafter;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;v) Cases involving prosecution for criminal offences.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The above enumeration is not exhaustive. It is only&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;illustrative and is subject to just exceptions or addition &ndash; at the discretion&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of the Court concerned.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;6. Mediation however, cannot displace the adversarial&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;system, which has been built up over centuries, and is based on &lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;logic, argument&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;,&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;impartiality and subject to a hierarchy of appellate corrective opportunity.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;For a large body of cases only the standard format of litigation with its&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;substantive laws and procedural rules , alone is suitable. However, many cases&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;are not about rights or injustice, they are more about parties who have fallen&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;into conflict, caused by friction in relationships- what such parties need is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to be brought out of conflict and that is possible through mediation.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;7. Qualifications of Mediators :&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;There is no legislation governing Mediation in India. The Supreme Court of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;India in Salem Advocates Bar Association v. Union of India , (2005) 6 SCC 344,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;had approved the Model Civil Procedure Mediation Rules prepared by the Commission&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;headed by Hon. Justice M.J. Rao, the then Chairman, Law Commission of India.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;These Rules have already been adopted by most of the High Courts with&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;modifications according to the requirements of each State. According to those&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Rules, which are made part of the Mediation Training Manual of India, prepared&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;by the Mediation and Conciliation Project Committee , Supreme Court of India,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the following persons are qualified and eligible for being enlisted as&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;mediators, subject to a mandatory 40 hour training programme and participation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in a minimum number of mediations prescribed : -&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(a) Retired Judges of the Supreme Court of India;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(b) Retired judges of the High Courts;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(c) Retired Judges of the lower judiciary;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(d) Legal Practioners with atleast 15 years standing at the Bar ;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(e) Experts or other professionals, retired senior bureaucrats and senior&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;executives;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(f) Institutions which are themselves experts in mediation and have been&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;recognized as such by the High Court , provided the names of its members are approved&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;by the High Court initially or whenever there is a change in the membership.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;8. Selection of a mediator could be by consent of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;parties. Or institutions conducting mediation, can either appoint or offer a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;panel of names. It is preferable that both parties concur in the choice of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;mediator. What is needed in a mediator is integrity and competence apart from&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the necessary training and experience.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The service is offered free of cost at Centres established by the High Courts.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;A fixed fee based on the time spent on the case is charged by other&amp;nbsp;institutions. The fee is borne by the two disputing parties.&lt;/span&gt;&lt;br&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;9. Participants in the process&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;As the emphasis is on the participation of the parties they should certainly be&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;present. The presence of legal advisers is often preferred by the parties. A&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;lawyer attuned to the mediation process can help in advising his client and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;focusing on solutions.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The parties play the key role in the mediation process. They are encouraged to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;explain the factual background of the dispute, identify issues and underlying&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;interests, generate options for agreement and make a final informed decision&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;regarding settlement. Mediation is not governed by the rules of evidence and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;formal rules of procedure. But it is not a casual process . It is structured&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and formalized, with clearly identifiable stages . However, there is a degree&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of flexibility in following those stages.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In mediation , the mediator assists the parties in resolving their dispute. He&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is a guide who helps parties find their own solution. He does not sit in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;judgment. The mediator&rsquo;s personal opinion, preferences or perceptions do not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;have a bearing on the dispute resolution process.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;10. Court referred or Pre- litigation&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;A case pending in court could be referred to mediation, either at the instance&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of the court, or at the request of the parties.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;A party or both the parties could seek mediation of a dispute that has not been&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;taken to court. There is no law on pre-litigation mediation in India. Based on&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;international experience, pre-litigation mediation is the most likely to result&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in a settlement.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Mediation conducted out of the court system is with the consent of the parties&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and is to be deemed to be governed by the provisions of the Part III of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Arbitration and Conciliation Act , 1996, in the absence of legislation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;governing mediation in India. The expression &ldquo; conciliation&rdquo; as employed in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Act, is to be read as &ldquo;mediation&rdquo;, and can be referred to as private mediation.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;A Settlement reached at such a mediation is treated as a &ldquo;Settlement Agreement&rdquo;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;under the Act and is thus enforceable.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Section 442 of the Companies Act, 2013 prescribes that the Central Government&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;shall maintain a Mediation and Conciliation Panel for conducting mediation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;between parties , during the pendency of any proceedings under the Act ,before&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Central Government or the National Company Law Tribunal. Rules have also&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;been framed, inter-alia, prescribing the procedure for empanelment,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;qualifications of the mediators and the fees payable to such mediators or conciliators.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;There is an urgent need for a comprehensive law on mediation in India. There is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;some movement in that direction in the Justice SriKrishna Commission having&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;recommended such enactment , recently.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;11. Confidentiality:&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Mediation is a private process, which is not open to the public. Mediation is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;also confidential in nature, which means that statements made during mediation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;cannot be disclosed in civil proceedings or elsewhere without the written&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;consent of all parties. Any statement made or information furnished by either&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of the parties , and any document produced or prepared for the purpose of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;mediation , is inadmissible and non-discoverable ( cannot be called for ) in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;any other proceeding. Any concession or admission made during mediation cannot&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;be used in any proceeding . Further any information given by a party to the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;mediator during the mediation process, is not disclosed to the other party,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;unless specifically permitted by the first party. No record of what transpired&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;during mediation is prepared.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;text-align: left;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;12 Settlement:&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Any settlement reached in a case that is referred for mediation during the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;course of litigation is required to be reduced to writing , signed by the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;concerned parties and filed in Court for the passing of an appropriate order.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;br&gt;&lt;/div&gt;&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;13. In the event of failure to settle a dispute, referred through Court, the report of the mediator will never indicate the reason for failure , nor as to what transpired at the mediation. The mediator cannot also be called upon to testify in any proceeding, as to what transpired at the mediation.&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;( The above note has drawn liberally from his books&amp;nbsp;&ldquo;Mediation Practice &amp;amp; Law&rdquo; and &ldquo; Settle for More &ndash; The why, How and When of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Mediation &ldquo; by Shri Sriram Panchu, Senior Advocate &amp;amp; Mediator )&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;', '3cd13049074c7f1cde63e43536d072da.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:54:32', '2021-01-30 23:10:57');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(72, 'oPAOLYk08q9aQywAVyXKdXeU2', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Constitutional Morality Through the Lens of the Sabarimala Review Petition.  Sebin Sebastian P M. ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;by Sebin Sebastian P M, Intern, Daksha Legal&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;b&gt;To construe or not to construe: Dwelling&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;into the realm of Constitutional Morality through the lens of the Sabarimala&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;review petition.&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&ldquo;We the people of India give to ourselves&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;this constitution and we the people are its only keepers.&rdquo;&ndash; Nanaboy Ardeshir&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Palkhivala&lt;/span&gt;&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Abstract:&lt;/span&gt;&lt;/b&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Constitutional Morality, its true meaning, definition&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and above all the extent of its applicability has in the modern scenario as one&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;could say has stirred forth an already unclear pond of it its constituents. One&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;would beg to question as a common man how the constitution in itself whose&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;fundamental values borrowed in majority from various declaration of rights,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;whose values were in turn borrowed from the intrinsic values of various&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;religions themselves has aroused questions in terms of its interpretation of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;these principles over the other religious principles. The paper in no way&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;attempts to impress upon an individual that a particular school of thought&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;would prevail over the other however it does attempts in all integrity to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;highlight the possible setbacks and advantages the common man, the poorest and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;most helpless of the lot may face in light of the various lessons that history&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in its kind tutelage has taught us. The Sabarimala review petition in such&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;light also presents an ample ground to foster such questions of constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;importance on a matter that needs to be assessed primarily on the first principle&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;basis.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Introduction:&lt;/span&gt;&lt;/b&gt;&lt;br&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In the recently adjudicated review petition in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Honourable Supreme Court in the case of &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Kantaru Rajeevaru vs Indian Young&amp;nbsp;&lt;/i&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Lawyers Association&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt; a constitution bench presided by the Chief Justice of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;India Ranjan Gogoi the majority bench decided to keep the matters pending in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;view of the of the possibility of other questions touching upon other religious&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;practices could be later decided by a Constitution Bench. Whilst this remains&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the background of this controversial topic the crux of this analysis&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;particularly lies in an issue that was virtually framed by the majority bench&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to be adjudicated upon by the larger bench of the Supreme Court. Issue number&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(iii) states: The expression &lsquo;morality&rsquo; or &lsquo;Constitutional morality&rsquo; has not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;been defined in the Constitution. Is it over arching morality in reference to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;preamble or limited to religious beliefs or faith? There is need to delineate&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the contours of that expression, lest it becomes subjective.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn1&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[1]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;In&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Paragraph 2 the judgement quite clearly highlights the plurality of a nation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;like India and further goes on to dwell on a subject that is rather quite&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;opposed to this plurality in some aspects, the concept of constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality and the question as to whether it must be considered similar to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality as defined under articles 25 and 26 in part III of the Constitution.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In light of such statements and events it is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;beneficial to wind the clock backwards in this debate on constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality and to look into a situation that arose during the passing of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Hindu Code bill by Dr B R Ambedkar; during the initial barricade the Hindu code&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;bill in the assembly and the rather questionable conduct of the upper caste&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Hindus at the time Dr Ambedkar remarked that India lacked the constitutional&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;morality to function as a democracy.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn2&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[2]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;This&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;scathing remark for him was substantiated by the idea that India would not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;achieve the equality a true democracy deserves unless the only &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;holy-book&amp;nbsp;&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;for India remains the Indian Constitution and true morality being one that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;flows from this Constitution. Thus, Ambedkar&rsquo;s anguish towards this reaction of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the assembly of choosing religious morality over constitutional morality is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;more so vindicated when one looks back at the history of Athens and that Athens&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;was not truly overthrown by spears or conquerors but by its own citizens who&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;had no regard for constitutional morality.&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn3&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[3]&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The historian Grote defines constitutional morality&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;calling it a paramount reverence for the forms of the constitution, enforcing&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;obedience to authority and acting under and within these forms, yet combined&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;with the habit of open speech, of action subject only to definite legal&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;control, and unrestrained censure of those very authorities as to all their&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;public acts combined, too with a perfect confidence in the bosom of every citizen&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;amidst the bitterness of party contest that the forms of constitution wall not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;be less sacred in the eyes of his opponents than his own. Despite the rampant&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;use of these two rather unusually poetic words, the true meaning and extent of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitutional morality in the Indian scenario still remains a matter of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;question for various constitutional experts, and with fairly good reason; the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;supreme court itself has rarely ventured into this abstract realm up until a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;few years ago with The Constitution itself making no direct reference to any&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;standard of morality that can be applied it had a passing mention in some of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Constituent assembly debates and some certain specific speeches of Dr B R&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Ambedkar. However, this concept has recently been put to the test while&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;deciding upon various matters such as the reading down of section 377 of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Indian Penal Code, in the Triple Talaq judgement, in K S Puttaswamy vs Union of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;India, the adultery judgement and as aforementioned, the Sabarimala: Right to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;entry of women judgement in 2018.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Subsequently as the supreme court attempts to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;calibrate the meaning of two undefined words in the constitution it helps to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;put into perspective as to what other democracies perceive of this notion of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitutional morality.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;Constitutional Morality and the First&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-size: 0.875rem; font-weight: 400;&quot;&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;b&gt;Amendment in the United States&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;/b&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The US constitutional set up, under the auspices of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Supreme Court of the United States has in many a time held societal and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;subservient to the intrinsic values of the constitution, It is not at all unusual&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;for the Supreme Court to declare that moral preferences, based upon private&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;ethical values, cannot be the basis of government policy if the effect or the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;intent is to seek to impose those preferences upon other parts of society that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;do not share them. Examples of such situations have been when the court&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;outlawed the restrictions on couples of different races from getting married&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;and on unmarried couples from getting access to birth control.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn4&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[4]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;The&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Supreme Court in the case of &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Lawrence v Texas &lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;outlawed the restriction&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;on homosexual couples from engaging in mutual consensual sexual acts.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn5&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[5]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Justice&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Sandra Day O&rsquo;Conor later commented on the moral aspect of this debate saying&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&ldquo;moral disapproval of homosexuality is insufficient to satisfy even the lowest&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;level of constitutional scrutiny. We have never held that moral disapproval,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;without any other asserted state interest, is a sufficient rationale under the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Equal Protection Clause to justify a law that discriminates among groups of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;persons&rdquo; while this does not explicitly mention the term constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality, the phraseology of this opinion may be found similar to that of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;opinion of the majority bench in the case of &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Navtej Singh Johar vs Union of&amp;nbsp;&lt;/i&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;India&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt; wherein the topic of public morality and constitutional morality were&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;discussed at length.&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn6&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[6]&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The stand of the US system on the religious rights of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;persons has waxed and waned over the years, while the US Constitution ensures&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;an absolute right to believe it draws an ever so uncertain line of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;reasonability when it comes to the right to profess. The US Supreme Court in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the case of &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Reynolds v United States&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt; stated that while the laws of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;state may not interfere with religious beliefs and opinions they may so with&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;religious practices, in the interest of the Constitution a view that was later&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;affirmed by the view of the court in &lt;i&gt;Employment Division v Smith&lt;/i&gt;.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn7&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[7]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt; &lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn8&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[8]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;It is also pertinent to note that various cases of the US Supreme Court also&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;set reasonable restrictions on religious denominations in practice of their&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;religion while also in a sense respecting certain beliefs of religious&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;denominations so long as they do not hinder the functioning of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitutional machinery as seen from the case of Bowen v Roy. However,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;inasmuch as a strict position on the term constitutional morality is concerned&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the line remains blur, however on a case to case basis adherence to the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitution has been dealt with, possessing much care. Furthermore, as&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;mentioned in the dissenting judgement there have been various occasions where&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;certain principles of liberty have triumphed.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn9&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[9]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt; &lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn10&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[10]&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;Constitutional morality in the UK&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Justice Krishna Iyer once said: Not the Potomac, but&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Thames, fertilises the flow of the Yamuna, this expression was used by&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;justice Krishna Iyer to highlight the level of bearing and Influence the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;English justice system has had on the Indian Constitution. Much of the noble&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;principles thereof found in the Constitution find its earliest origins in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Magna Carta thus in such spirit it is also necessary to examine the similarity&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of application of the principle of constitutional morality. Historically, the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;standard was insisted upon in seeking behaviour consistent with the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;longstanding acceptable norms limiting the exercise of sovereign power by its&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;agents in a society ruled by law. This was true in the English environment&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;where the contours were left largely unwritten but determined by institutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;arrangements like &lsquo;Constitutional conventions&rsquo;, from which derogations were&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;frowned upon. This was invoked to address the conscience of these agents of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;sovereign in the absence of legally binding obligations requiring them to act&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in any particular way. Since they were sensitive to such peer pressure,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;compliance to the non-binding conventions and norms could be ensured.&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn11&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[11]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Hence&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;for the reasons aforementioned the Indian Constitution in its application of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Constitutional morality is more so similar to that of the US Constitution.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;b&gt;Justice Dipak Mishra&rsquo;s definition; Do definitions suffice?&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-weight: 400; text-align: left;&quot;&gt;Justice Deepak Mishra in the case of Government of NCT&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-weight: 400; text-align: left;&quot;&gt;of Delhi v Union of India and Ors attempted to draw the borders of this term by&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-weight: 400; text-align: left;&quot;&gt;stating that &ldquo;Constitutional morality, appositely understood, means the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-weight: 400; text-align: left;&quot;&gt;morality that has inherent elements in the constitutional norms and the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt; font-weight: 400;&quot;&gt;conscience of the Constitution. Any act to garner justification must possess the potentiality to be in harmony with the constitutional impulse. We may give an example. When one is expressing an idea of generosity, he may not be meeting the standard of justness. There may be an element of condescension. But when one shows justness in action, there is no feeling of any grant or generosity.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;That will come within the normative value. That is the test of constitutional justness which falls within the sweep of constitutional morality. It advocates the principle of constitutional justness without subjective exposition of generosity.&rdquo; On the basis of which, reliance was placed while construing morality in article 25(1) of the constitution in the case of Indian Young Lawyers Association v State of Kerala. However, such principle is open to the scrutiny of subjectivity and uniform application cannot be ensured and it is subject to such factors that the majority opinion in the review petition tries to question whether morality in article 25(1) can be construed as constitutional morality, and if so to what extent with constitutional morality and the rigidity with which it enforces the principles in the constitution.&lt;/span&gt;&lt;/p&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;The possible perils&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;As one observes, there happens to be a sharp&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;difference in the opinion of jurists from Dr Ambedkar to Grote as to the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;rigidity of application of Constitutional morality and thus the question does not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;end at merely defining such terms. Thus, just like the philosophy of natural&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;law goes, insofar as there persists a disagreement in terms of the restrictions&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;placed thereof the topic of Constitutional morality shall and will remain in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the abstract realm. To substantiate such a rather explicit conclusion in terms&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of the opinion of the court in terms of &lsquo;reasonable restrictions&rsquo; within the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitution I would like place reliance on a the overruling of the Habeas&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Corpus case basing it on the principles of Constitutional morality wherein what&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;was once construed as constitutionally acceptable as a reasonable restriction&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;was considered to be an erroneous reading of the constitution later on, thus&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;one could ask what is the assurance that while the meaning of the term&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;constitutional morality remains defined, the principles it contains maybe be&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;construed differently at different occasions.&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn12&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[12]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Therefore, inasmuch as Ambedkar and Grote&rsquo;s views may differ, opinions of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;interpretation may differ from Justice Chandrchyud to Justice Chandrachyud from&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;generation to generation.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;This difference of interpretation of the constituents&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of constitutional morality can be seen from the dissenting opinion of Justice&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Indu Malhotra in the very same judgement justice Dipak Mishra set out the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;applicability of which for &ldquo;Constitutional Morality in a secular polity would&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;imply the harmonisation of the Fundamental Rights, which include the right of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;every individual, religious denomination, or sect, to practise their faith and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;belief in accordance with the tenets of their religion, irrespective of whether&amp;nbsp;the &lt;/span&gt;practice&lt;span style=&quot;font-size: 12pt;&quot;&gt;&amp;nbsp;is rational or logical. While such flexibility, essentially, maybe&amp;nbsp;the nature of law in itself it is imperative for one to question that does such&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;a nature apply to the precepts and statutes of religion? Thus, as many jurists&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;opine constitutional morality may be less used as a tool, rather an excuse to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;expand its mandate of functioning merely through vast interpretation. The&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;application of constitutional morality might not limit to such interpretation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to that of article 25 but might even essentially place the relationship between&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the court and the legislature at peril. Therefore, the statements made by the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Attorney General of India, KK Venugopal stating that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&ldquo;The use of constitutional morality can be very, very&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;dangerous, and we can&#039;t be sure where it will lead us to. I hope constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality dies. As a powerful weapon that surpasses all the powers conferred on&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Supreme Court by the Constitution, Article 142 merely permits the court to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pass such decrees or orders as to do complete justice in any cause or matter&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pending before the court. But the article is treated as a &#039;&lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Kamadhenu&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&#039;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;from which unlimited powers flows to the apex court of the country.&rdquo; &lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn13&quot; style=&quot;background-color: rgb(255, 255, 255); font-size: 0.875rem;&quot;&gt;[13]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Does not all of a sudden become so much of an exaggeration after all.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;The undeniable prospects:&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Even with the possible perils off in the distance&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;there lies a glimmer of hope, that this interpretation of Constitutional&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morality may in turn vindicate the rights of so many, while its application&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;remains highly subjective, it is hard for one indeed to argue that the interpretation&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of the supreme court in cases such as that of &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Navtej Singh Johar v Union of&amp;nbsp;&lt;/i&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;India&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt; has brought meaning to the life of so many whose fundamental rights&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;were inherently oppressed by moral standards that deserve no stand in society,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;it also to brings to light the various other judgements like the KS Puttaswamy&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;judgement wherein the rights of persons were further vindicated calling forth a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;right to privacy that they have. The court in this case laid stress on the fact&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;that the use of Aadhar for commercial exploitation of data is impermissible and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;thereby reiterated and upheld the primacy of the right to privacy of its&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;citizens&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn14&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[14]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;It&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is thus in this case noteworthy to remark certain statements made by Gautam&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Bhatia a learned constitutional law scholar saying &ldquo; the constitutional process&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is an abstract one, its value is hard to communicate and clearly we have not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;done a good enough job of communicating it. But then again, I&rsquo;m not sure how to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;communicate it, because it seems to me that this is one of those things whose&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;meaning you only truly realise after you have lost it. Should keep trying,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;though. Generations change in surprising ways.&rdquo; It is also necessary for one to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;reiterate in ones mind the liberation that the Instant triple talaq judgement&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;brought to the lives of various Muslim women who were prisoners of this age-old&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;custom that vilified them. Should there be an involvement of the supreme court&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in such cases? While a strict affirmative is hard to be substantiated, it is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;also hard to argue otherwise. J Sai Deepak an advocate of the Supreme Court who&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;also argued in the Sabarimala case said and affirmed in a Rajya Sabha&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;television debate on Constitutional morality saying &ldquo;assuming for a moment that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;this situation is not an aberration, and this is indeed something that has a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;scriptural basis and is an essential part of the religion, that is when you&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;test the limits of the constitutional powers of the supreme court in terms of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;its intervention, assume for a moment that a particular religion says that the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;punishment for adultery is stoning and this is an essential aspect of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;religion as far as retaining the sanctity of marriage is concerned and it is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;established that it has a scriptural basis and there is no distortion over a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;point of time is the Supreme Court expected to sit back and endorse this&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;practice in the name of article 25(1) no I am so sorry I beg to disagree&rdquo;.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Thus, while subjectivity remains a question certain prospects of its&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;interpretation may never be denied.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt; line-height: 107%;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;Conclusion&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Based on the facts and merits of the circumstance&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;while assessing issue three that was framed in &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Kantaru Rajeevaru v Indian&amp;nbsp;&lt;/i&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;Young Lawyers Association &lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;it suffers from an error apparent and an&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;undeniable and inalienable paradox, being, an attempt to make the definition of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;morals a non- subjective matter, whose principles the court shall rely upon to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;deliver further judgements. Thus, the question as to construe or not to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;construe with all due respect to its abstract nature shall remain unanswered&lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;.&lt;/i&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;i&gt;&lt;b&gt;Satyameva Jayate.&lt;/b&gt;&lt;/i&gt;&lt;/span&gt;&lt;/p&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref1&quot;&gt;[1]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Kantaru Rajeevaru vs Indian Young Lawyers Association, 2019, MANU 1565.&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref2&quot;&gt;[2]&lt;/a&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;Vineeth Krishna E, &lt;i&gt;can you be a true democracy &amp;amp; let go of caste,&amp;nbsp;&lt;/i&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;i&gt;Ambedkar asked Indians. We are yet to reply, &lt;/i&gt;CAD India Blog, (April 30, 2018),&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify; font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.constitutionofindia.net%2Fblogs%2Fcan_you_be_a_true_democracy___let_go_of_caste__ambedkar_asked_indians__we_are_yet_to_reply%3Ffbclid%3DIwAR23Zax4JuBrzv0HE8KtOuCtSgcjdqz1Z6VeXnYLvBmDDjnv32-d7YFVN3M&amp;amp;h=AT0PeD7SWUA00vnh7CEL0kGAV6nripk_dlKP0t92zaR2gs4pdgm8zwZmRmVKl6KeJbLsXL7mpQrOdYkz8Qf6pE02ifdaSnB69zv5XvfW9ucg3771sFJUwYOcUyhrLeyNCdMNwifYlamlh0EU7GVrGw&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;https://www.constitutionofindia.net/blogs/can_you_be_a_true_democracy___let_go_of_caste__ambedkar_asked_indians__we_are_yet_to_reply&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;.&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref3&quot;&gt;[3]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;William D Guthiere, &lt;i&gt;Constitutional Morality,&lt;/i&gt; 196The North American&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Review154,154-155, 1912.&lt;/span&gt;&lt;a href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fwww.constitutionofindia.net%2Fblogs%2Fcan_you_be_a_true_democracy___let_go_of_caste__ambedkar_asked_indians__we_are_yet_to_reply%3Ffbclid%3DIwAR23Zax4JuBrzv0HE8KtOuCtSgcjdqz1Z6VeXnYLvBmDDjnv32-d7YFVN3M&amp;amp;h=AT0PeD7SWUA00vnh7CEL0kGAV6nripk_dlKP0t92zaR2gs4pdgm8zwZmRmVKl6KeJbLsXL7mpQrOdYkz8Qf6pE02ifdaSnB69zv5XvfW9ucg3771sFJUwYOcUyhrLeyNCdMNwifYlamlh0EU7GVrGw&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; text-align: left; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br&gt;&lt;/a&gt;&lt;/div&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref4&quot;&gt;[4]&lt;/a&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Lyle Denniston,&lt;b&gt; &lt;/b&gt;&lt;i&gt;Constitution Check: Does the Constitution protect&amp;nbsp;&lt;/i&gt;&lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;private moral convictions, &lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Constitution Daily Blog, (February 17, 2012),&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify; font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a href=&quot;https://constitutioncenter.org/blog/constitution-check-does-the-constitution-protect-private-moral-convictions?fbclid=IwAR1Zm4KPlAX16cGb46Gh5QMWsoaE_en174qb68_yt5-dA4dEjZEcqobEYp8&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;https://constitutioncenter.org/blog/constitution-check-does-the-constitution-protect-private-moral-convictions&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;.&lt;/span&gt;&lt;a href=&quot;https://constitutioncenter.org/blog/constitution-check-does-the-constitution-protect-private-moral-convictions?fbclid=IwAR1Zm4KPlAX16cGb46Gh5QMWsoaE_en174qb68_yt5-dA4dEjZEcqobEYp8&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; text-align: left; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br&gt;&lt;/a&gt;&lt;/div&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref5&quot;&gt;[5]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Lawrence v Texas, 2003 U.S LEXIS 5013.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref6&quot;&gt;[6]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Navtej Singh Johar v Union of India, (2018)10SCC1.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref7&quot;&gt;[7]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Employment division v Smith, 494 U.S. 872, 878 (1990).&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref8&quot;&gt;[8]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Reynolds v. United States, 98 U.S. 145, 166 (1879).&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref9&quot;&gt;[9]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Brown vs Board of Education, 347 U.S. 483.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref10&quot;&gt;[10]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Kantaru Rajeevaru v Indian Young Lawyers Association, 2019, MANU, 1965.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref11&quot;&gt;[11]&lt;/a&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Balakrishnan K, &lt;i&gt;Constitutional Morality in India: the new kid in the block, &lt;/i&gt;Bar and Bench, (February 5, 2019),&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify; font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fbarandbench.com%2Fconstitutional-morality-india-new-kid-block%2F%3Ffbclid%3DIwAR1FzmRn19Wsa5ymSynbu93_9qpzFiG3H1KphCCjtfSrKI37_cvVYAw-zso&amp;amp;h=AT0hgHI5RZWCsZPtB2HbcAVau-MwC65wVs05YsxiNtKJcgAaJNJv4DxkYOV7V0O0AesZTk9otLBBlfUTlsnZB3r-MSOdUbNow9soSPnZkQNqz3ZX1by3rD1EwhKVcTddM_7MJ8M-LoEtz7NZACIUiA&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;https://barandbench.com/constitutional-morality-india-new-kid-block/&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;.&lt;/span&gt;&lt;a href=&quot;https://l.facebook.com/l.php?u=https%3A%2F%2Fbarandbench.com%2Fconstitutional-morality-india-new-kid-block%2F%3Ffbclid%3DIwAR1FzmRn19Wsa5ymSynbu93_9qpzFiG3H1KphCCjtfSrKI37_cvVYAw-zso&amp;amp;h=AT0hgHI5RZWCsZPtB2HbcAVau-MwC65wVs05YsxiNtKJcgAaJNJv4DxkYOV7V0O0AesZTk9otLBBlfUTlsnZB3r-MSOdUbNow9soSPnZkQNqz3ZX1by3rD1EwhKVcTddM_7MJ8M-LoEtz7NZACIUiA&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; text-align: left; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br&gt;&lt;/a&gt;&lt;/div&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;text-align: left; font-size: 12pt; line-height: 107%;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref12&quot;&gt;[12]&lt;/a&gt;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;ADM Jabalpur v Shivkant Shukla&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify; font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref13&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;[13]&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;i&gt;Constitutional morality can be very dangerous&#039;: Attorney General KK Venugopal fears SC may become third Parliament chamber, &lt;/i&gt;FirstPost, (December 9, 2018),&lt;/span&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftnref13&quot; style=&quot;font-size: 0.875rem; text-align: left; background-color: rgb(255, 255, 255);&quot;&gt;&lt;br&gt;&lt;/a&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify; font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;a href=&quot;https://www.firstpost.com/india/constitutional-morality-can-be-very-very-dangerous-attorney-general-kk-venugopal-fears-sc-may-become-third-parliament-chamber-5698851.html?fbclid=IwAR2DVfy0SklPHwvTCnUsFECqOUKbv_jdFRuA2yGqwEaXMaJ8ZmkHe6PgnwU&quot; target=&quot;_blank&quot; style=&quot;font-size: 0.875rem; background-color: rgb(255, 255, 255);&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;https://www.firstpost.com/india/constitutional-morality-can-be-very-very-dangerous-attorney-general-kk-venugopal-fears-sc-may-become-third-parliament-chamber-5698851.html&lt;/span&gt;&lt;/a&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;.&lt;/span&gt;&lt;/div&gt;', 'e71583261a2715c684cfcf62c2fbc24b.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:55:47', '2021-01-30 00:32:20');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(41, '4nBcns0VleRHqEvIWQgynstVy', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Exposition of ‘Next Friend’ in law.  S. Basavaraj. Advocate. Bangalore', '&lt;h4 style=&quot;margin-right: 0in; margin-left: 0in; text-align: justify;&quot;&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Synopsis: This article talks about the concept of next friend in law. It highlights its meaning, advantages and powers a next friend enjoys in law along with how it is different from a &lsquo;guardian&rsquo;.&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;h4&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&nbsp;Introduction&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The term &lsquo;next friend&rsquo; is derived from the French words &lsquo;prochein ami&rsquo; which means &lsquo;to stand as a representative for the person who is not in a position to stand for their own&rsquo; like minor, unsound, disabled etc. This concept of next friend is a very vital part of the minor&rsquo;s life or in the lives of the unsound and disabled to bring justice for them and help them stand in the world and in courts.&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Difference between &lsquo;guardian&rsquo; and &lsquo;next friend&rsquo;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The terms guardian and next friend are very similar. Both represent the minor and act as sui juris, which means &lsquo;the one who does not suffer from a legal disability and can manage one&rsquo;s own affairs&rsquo;. A next friend is a person who represents the minor when the minor initiates the suit. A guardian is appointed by the court for the minor when he/she is sued.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;In the case of Nagaiah &amp; Anr v. Smt.Chowdamma (dead) By Lrs. &amp; Anr, 2018 (2) MLJ 242 (SC), the Court clearly explained the difference between guardian and next friend which was summed up as:&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&ldquo;The only practical difference between a &ldquo;next friend&rdquo; and a &ldquo;guardian ad litem&rdquo; is that the next friend is a person who represents a minor who commences a lawsuit; guardian ad litem is a person appointed by the court to represent a minor who has been a defendant in the suit.&nbsp; &nbsp;Before a minor commences suit, a conscious decision is made concerning the deserving adult (next friend) through whom the suit will be instituted. The guardian ad litem is appointed by the court and whereas the next friend is not. The next friend and the guardian ad litem possess similar powers and responsibilities. Both are subject to control by the court and may be&nbsp; &nbsp;removed by the court if the best interest of the minor so requires.&rdquo;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&nbsp;When is a next friend preferred?&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The concept of next friend is used in India in various laws. One of such direct use is in Civil Procedural Code,1908 (CPC).&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Order 32 of CPC&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Order 32 of CPC deals with the suit filed by or against a minor or an unsound person. Rule 1 of Order 32 provides that every suit by a minor shall be instituted in his name by a person who in such suit shall be called the next friend of the minor who does everything for the minor till the end of the litigation. According to Order 32 Rule 2A of the CPC, the court may, at any phase of the suit, request the next friend to give security for all the costs incurred or which is to be incurred by the Respondent. Rule 4(1) of Order 32 describes the qualification of a next friend for a minor. This rule says that:&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&ldquo;Any person who is of sound mind and has attained majority may act as next friend of a minor or as his guardian for the suit: Provided that the interest of such person is not adverse to that of the minor and that he is not, in the case of a next friend, a defendant, or, in the case of a guardian for the suit, a plaintiff.&rdquo;&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;As per Order 32 Rule 9 of CPC, a next friend can also be removed when his interest is adverse to the minor and starts being connected with the Defendant. He can also be removed if he is not staying in India during the pendency of the case.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;A similar view was taken by judges in various matters like Sambhoo v. Kanhaya, AIR 1922 All 332(2)(B) and Venkata Chandrasekhara Raja v. Alakarajamba Maharani, 22 Mad 187 (C) holding that only one representative must be there starting from the trial court to the highest court in order to avoid confusion by different representatives in every stage.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Though a case by minor is represented by his next friend, the next friend cannot be brought into the terms of &lsquo;Petitioner&rsquo; under Section 95 of CPC, however, the Defendant can recover damages from the next friend. The minor only remains the &lsquo;Petitioner&rsquo; as observed in Marti Satyanarayana v. Gujavarti Anjareddi, (1941) 1 MLJ 765.&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The Legislature, through its foresight, has ensured additional safeguards under such circumstances and by way of Order 32 Rule 6 - Receipt by next friend or guardian for the suit of property under decree for minor and Rule 7- Agreement or compromise by next friend or guardian for the suit , which prohibits the next friend from releasing money under a decree or compromise without the leave of the court.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Next friend explained in relation to contract law&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;A contract always needs free consent as per Section 10 of the Indian Contract Act, 1872 (&lsquo;the Act&rsquo;), but a minor does not have the full presence, ability or capacity to give a free consent. Therefore, a contract with a minor is void-ab-initio. Hence, a next friend or a legal guardian will represent them till the minor becomes a major who is competent to contract according to Section 11 of the Act.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;This has first cited in the case of Mohiri Bibi v. Dharmodas Ghosh, ILR (1903) 30 Cal 539, where the Plaintiff was a minor who mortgaged his property to the Defendant. Plaintiff later repaid only a few amounts and refused to pay the rest of the amount. So, the Plaintiff&rsquo;s next friend (his mother) instituted a suit against the Defendant that the Plaintiff had entered into a contract when he was a minor. Hence, it is not a valid contract.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The next friend can enter into any contract which is beneficial for the minor. An early case that upheld this was Great American Insurance v. Madan Lal, (1935) 37 BOMLR 461, the next friend entered a contract for insurance to protect the minor&rsquo;s property which was destroyed by fire. When the insurers told that they cannot give the money as the agreement with the minor was void, the next friend sued the insurer for recovery of the insurance money and the court held that the next friend can claim the insurance. Here the contract is beneficial to the minor; the next friend did not cheat the minor or did not take it for his own benefit.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Legal ramification and appeal in cases represented by the next friend&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The next friend has the power to take a decision on behalf of the minor until he is removed or on his death. If the next friend becomes unsound during the pending case, any other person looking after the benefit of the minor can move the application to be next friend. Instituting a suit on behalf of the minor is the biggest power given to the next friend by the Supreme Court.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;On January 15, 2018, the Supreme Court in the case of Nagaiah and Anr v. Chowdamma(dead) By Lrs., Civ. App. No. 22969 of 2017, held that there is no particular legal procedure or necessary permission to be taken for the appointment of the next friend for a minor. The Court held that the next friend need not take any permission of the court to institute a suit on behalf of the minor.&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;In the case of Raj Behari Lal &amp; Ors. v. Dr. Mahabir Prasad &amp; Ors., AIR 1956 All 310 the Court held that an appeal on behalf of the minor can be filed by the guardian appointed by the court. When the appeal is filed by the minor as Plaintiff in the previous suit, then the next friend can file the appeal on behalf of the minor. The provisions in Order 32 of the CPC shall apply in such suits. Every suit by a minor must be instituted in his name by his next friend.&nbsp;&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Conclusion&lt;br&gt;&lt;/span&gt;&lt;/font&gt;&lt;font color=&quot;#212529&quot; face=&quot;Calibri, sans-serif&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;The concept of next friend is to protect the interest of minor and bring justice to the minor or unsound person. The concept of next friend has many more advantages than a guardianship. A next friend need not take any kind of permissions or appointments unlike guardian from the court. The duty of the next friend is same as if he individually instituted the suit for himself but in the interest of the minor. The next friend has the power to move an appeal, institute a suit and has all the powers like any other individual on behalf of the minor.&lt;/span&gt;&lt;/font&gt;&lt;/h4&gt;&lt;/h4&gt;&lt;p style=&quot;margin-right: 0in; margin-left: 0in; color: rgb(33, 37, 41); text-align: justify; font-family: MyWebFont !important;&quot;&gt;&lt;br&gt;&lt;/p&gt;', '1be312c3396ee7c4a8a91b5cc47698df.PNG', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-22', 1, NULL, NULL, '2020-12-01 20:42:10', '2020-12-23 02:58:49'),
(42, '7G5HwmLYY9b3TYQAcUKRpABZb', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Prefixing alias to accused in FIRs Does it violate right to reputation guaranteed under Article 21 of the Constitution of India.  S. Basavaraj. Advoca', '&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;S.Basavaraj, advocate, Daksha Legal, Bangalore.&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;1.&lt;/span&gt;&lt;/span&gt;Few years ago, a Police Officer told me how Police add &ldquo;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;alias&lt;/i&gt;&lt;/span&gt;&rdquo; against names of few troublemaking petty criminals just to project them as anti-social elements hoping that bail would be refused by courts. It is also a fact that using&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;alias&lt;/i&gt;&lt;/span&gt;by accused themselves enhances notoriety. However, law enforcing agencies deliberately using alias in first information reports would certainly add notoriety to the accused. Flipside of the coin is violation of fundamental right to reputation which is considered in this write-up.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;2.&lt;/span&gt;&lt;/span&gt;Usage of alias in FIR is often not supported by any documentary evidence such as change of name etc. Many a times, alias name is added to an ordinary person just to make him look notorious. The Karnataka High Court has recently called upon the Police to explain how and under what circumstances &lsquo;alias&rsquo; was used against accused in a criminal case.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;3.&nbsp;&lt;/span&gt;&lt;/span&gt;Wharton&rsquo;s Law Lexicon 15th Edition defines &lsquo;alias&rsquo; as a&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;&ldquo;second name applied to a person where he has been styled or has styled himself by more names than one&rdquo;.&lt;/i&gt;&lt;/span&gt;&nbsp;Concise Oxford English Dictionary, 11thedition defends &lsquo;alias&rsquo; as a &ldquo;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;a false or assumed identity.&rdquo;&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;4.&lt;/span&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;u&gt;&lsquo;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Alias&rsquo;&lt;/i&gt;&lt;/span&gt;&nbsp;in crime world.&lt;/u&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&nbsp;Criminals use aliases, fictitious business names and dummy corporations (corporate shells) to hide their identity, or to impersonate other persons or entities in order to commit fraud. Aliases and fictitious business names used for dummy corporations have become extremely complex. However, usage of alias by persons involved in criminal activities undoubtedly enhances their notoriety. Many who became famous/notorious in Bangalore underworld had weird alias names which served their purpose for decades. Few were S Krishnamurthy alias&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Korangu&lt;/i&gt;&lt;/span&gt;, Vijay Kumar alias&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Kavala&lt;/i&gt;&lt;/span&gt;, Soma alias&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Deadly Soma&lt;/i&gt;&lt;/span&gt;&nbsp;(&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;names as shown in FIRs &ndash; persons already dead&lt;/i&gt;&lt;/span&gt;).&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;5.&lt;/span&gt;&lt;/span&gt;The above maybe cases where accused themselves used alias or did not object to usage of alias by their henchmen or Police. However, affixing alias by Police in FIRs without there being any justifiable reasons i.e. accused himself using alias or other documentary evidence such as change of name document, passport etc would be highly objectionable. Branding accused with prefix alias would seriously affect his reputation.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;6.&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;u&gt;Right to reputation &ndash; Fundamental right.&lt;/u&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&ndash; Fundamental right&lt;/span&gt;&lt;/span&gt;.The right to one&rsquo;s reputation is a fundamental right traceable to Article 21 of the Constitution of India. In&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Subramanian Swamy v. Union of India, (2016) 7 SCC 221&lt;/i&gt;&lt;/span&gt;, at para 144 the Hon&#039;ble Supreme Court reaffirmed the legal position that reputation is an inextricable aspect of right to life under Article 21 of the Constitution and that the right to reputation is a constituent of Article 21 of the Constitution. The Supreme Court relied on the its earlier judgment in&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Charu Khurana&lt;/i&gt;&lt;/span&gt;&nbsp;v.&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Union of India&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;(2015) 1 SCC 192&lt;/i&gt;&lt;/span&gt;&nbsp;which held that dignity is the quintessential quality of a personality since it is a highly cherished value and that right to honour, dignity and reputation are the basic constituents of right under Article 21. The Hon&#039;ble Supreme Court in&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Subramanian Swamy v. Union of India&nbsp;&lt;/i&gt;&lt;/span&gt;relied on several judgments, the reference to which is unnecessary here. Suffice it to say individual reputation is part of Article 21 of the Constitution of India.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;7.&nbsp;&lt;/span&gt;&lt;/span&gt;There are more than 800 judgments of the Supreme Court where accused name contain alias. It is not clear as to whether these accused really had alias or names added by Police. Few reported judgments are;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;1.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Pratap Singh alias Pikki v. State of Uttarakhand, (2019) 7 SCC 424.&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;2.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Mohmed Riyaz alias Goru (Criminal Appeal No. 144 of 2012)&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;3.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Tabrez Khan alias Guddu v. State of U.P., (2019) 4 SCC 615&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;4.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;State of H.P. v. Vijay Kumar alias Pappu (2019) 5 SCC 373&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;5.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Kishan Singh alias Actor v. State of Uttaranchal, (2019) 11 SCC 807&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;6.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Manish Solanki alias Bansi v. State of Rajasthan, (2019) 4 SCC 340&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;7.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Mohd. Akhtar alias Kari v. State of Bihar, (2019) 2 SCC 513&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;8.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Thangela Narendra alias Chinnu v. State of Karnataka (2019) 14 SCC 709&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;9.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Jitendra alias Kalla v. State (NCT of Delhi), (2019) 13 SCC 691&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;10.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;State of U.P. v. Anil Kumar alias Badka (2018) 9 SCC 492&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;11.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;State of Maharashtra v. Bandu alias Daulat (2018) 11 SCC 163&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;12.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Harpal Singh alias Chhota v. State of Punjab, (2017) 1 SCC 734&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;13.&lt;/i&gt;&lt;/span&gt;&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Harpal Singh alias Deputy v. State of Punjab (2017) 1 SCC 734&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;8.&nbsp;&lt;/span&gt;&lt;/span&gt;All these are cases involving heinous crimes. Branding accused with alias appears to be well-established rule for the Police/prosecution.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;9.&nbsp;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;u&gt;Conclusion&lt;/u&gt;&lt;/span&gt;:&nbsp;&lt;/span&gt;&lt;/span&gt;Examined from this angle and having regard to the notoriety it has gained in crime world, prefixing &lsquo;alias&rsquo; to accused by Police in FIRs certainly tarnish reputation. This is so especially when accused has no such recorded pseudo name. In their eagerness to brand accused as a notorious criminal or anti-social element, if the Police were to prefix, it would destroy reputation of the accused for all time to come since FIRs are public documents. Even if the case foisted on accused ends in acquittal or quashed by higher courts, the damage done is irreversible. It is absolutely necessary for the Police to verify antecedents of accused before affixing alias. Even if the accused discloses his name with alias, Police must verify veracity of such a claim since few want to gain notoriety by proclaiming to have alias names. Self-branding is equally dangerous. Hence the courts at the very first instance, when accused is produced, must call upon the Police to explain reason/need for usage of alias. This will prevent violation of accused&rsquo;s fundamental right to reputation protected under Article 21 of the Constitution of India.&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;S.Basavaraj&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Advocate,&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Daksha Legal&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div class=&quot;bi6gxh9e&quot; style=&quot;margin-bottom: 8px; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;span class=&quot;d2edcug0 hpfvmrgz qv66sw1b c1et5uql rrkovp55 jq4qci2q a3bd9o3v knj5qynh oo9gr5id&quot; style=&quot;line-height: 1.3333; overflow-wrap: break-word; max-width: 100%; min-width: 0px; font-size: 0.9375rem; color: var(--primary-text); word-break: break-word; font-family: inherit;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;span style=&quot;font-weight: 600;&quot;&gt;&lt;span style=&quot;font-family: inherit;&quot;&gt;&lt;i&gt;Member, Karnataka State Bar Council&lt;/i&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;', '1fb05040401057ec3fdc820342f3d9df.jpg', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:44:29', '2020-12-23 02:58:34');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(43, 'QBRMgBOfdbPk8k0WgsMfuXZx7', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'G7 Summit and its fallouts.  S. Basavaraj. Advocate. Bangalore ', '&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Article by a Daksha Legal member&lt;br&gt;&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Second week of June 2018 was full of hectic activities in the international arena, across the geographical spectrum around the world. On the one side, Mr Kim and Mr Trump were preparing to reach a deal, on other, SCO member countries were holding their annual session. In between, annual G7 summit in Canada also ended with a huge noise when Mr Trump used certain verbiage which are considered not appropriate in the diplomatic parleys and throwing the G7 summit into disarray. Mr Trump&rsquo;s reluctance to attend the G7 meeting is coincided with his insulting the Canadian hosts, snubbing the final communiqu&eacute; and leaving the Summit abruptly.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;What is G7?&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;G7 (the Group of Seven) is a group of countries composed of the seven wealthiest and the world&rsquo;s advanced economies consisting of Canada, France, Germany, Italy, Japan, the United Kingdom, and the United States. Also, both the President of the European Council and the President of the European Commission represent the EU at G7 summits. The forum offers an opportunity for G7 Leaders, Ministers and policy makers to come together each year to build consensus and set trends around some of today&rsquo;s most challenging issues like - global economic governance, international security, and energy policy, environmental issues and so on.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Conceptualized as G4, in response to the 1973 oil crisis , it become G6 in 1975 (with the inclusion of Canada). It was primarily to provide a venue for the non-Communist powers to address pressing economic concerns in the wake of oil crisis. In 1998, G7 turned into G8 with the induction of Russia into the esteemed Group. Then U.S. President Bill Clinton thought that admitting Russia to the exclusive club would lend international prestige and encourage its first post-Soviet leader, Boris Yeltsin, to consolidate democratic gains and hew more closely to the West. However, in 2014, over the issue of annexation of Crimea by Russia, the latter was suspended from the G8 and the Russia planned G8 Summit of 2014 was cancelled.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Status of G7&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Unlike the United Nations or the NATO, the G7 is not a formal institution with a charter and a secretariat nor does it have a budget or permanent staff. Instead, the presidency, which rotates annually among member states, is responsible for setting the agenda and arranging logistics. Ministers and envoys, known as sherpas , hammer out policy initiatives at meetings that precede the annual summit of national leaders . &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Importance of G7 Summits&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Over the past 40 years, the G7 has strengthened international economic and security policy, mainstreamed climate change and gender equality, brought donors together and supported disarmament programs.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The G7 has been proven to provide global leadership and play a powerful role in impacting world issues. For example, the issue of women&rsquo;s and children health were championed by Canada during the 2010 G7 presidency. The Muskoka Initiative committed G7 members to mobilize $5 billion of additional funding between 2010-2015 toward maternal, newborn, and child health. At the end of each ministerial meeting and the Leaders&rsquo; Summit, the host country publishes an outcomes document. This document can be delivered as a communiqu&eacute;, declaration, or chair&rsquo;s statement .&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;2018 Summit&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;This year, 44th G7 meeting took place during 8-9 June in the Charlevoix region of Quebec, Canada. The G7 host normally invites country leaders and representatives from international organizations to have a frank and practical discussion about a pressing challenge facing the global community. This year, Canada invited 12 countries including Bangladesh and there international organizations viz., UNO, World Bank and OECD.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Controversies surrounding G7 &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Summit of 2018 &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Steel &amp; Aluminum tariff issue: &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Mr Trump&rsquo;s unilateral imposition of steel and aluminium tariffs were the flashpoint in the G7 Summit. In March 2018, Mr Trump signed two proclamations that levied a 25 per cent tariff on steel and a 10 per cent tariff on aluminum imported from all countries except EU, Canada and Mexico, to protect domestic producers that were vital to US security. However, this exemption to three countries was ended on 31 May.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Canada is the single largest supplier of steel and aluminum to the United States. The Canadian Prime Minister, Justin Trudeau, in an immediate tit-for-tat response, announced tariffs of up to 25% on US imports equivalent to C$16.6bn, the total value of Canadian steel exports in 2017. The tariffs would cover steel and aluminium as well as orange juice, whiskey and other food products, which understandably angered Mr Trump.&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;In the G7 Summit, Mr Trump, following his &ldquo;America First&rdquo; policy, tweeted defending his imposition of tariffs. He tweeted &ldquo;Fair trade is now to be called fool trade&rdquo;; &ldquo;Based on Justin&rsquo;s false statements at his news conference, and the fact that Canada is charging massive Tariffs to our U.S. farmers, workers and companies, I have instructed our U.S. Reps not to endorse the Communique as we look at Tariffs on automobiles flooding the U.S. Market!&rdquo;; &ldquo;Sorry, we cannot let our friends, or enemies, take advantage of us on Trade anymore. We must put the American worker first!&rdquo;&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Iran&rsquo;s nuclear programme&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;G7 leaders pledged in the Summit to ensure Iran&rsquo;s nuclear program remains peaceful. However, Mr Trump&rsquo;s decision to pullout from an internationally-agreed accord was not agreed by the other G7 leaders. The G7 group including Germany, France and Britain who - along with the US - were all signatories to the 2015 nuclear accord which allowed for the lifting of sanctions on Iran, had the goal of denuclearizing Iran.By taking a contra stand, US remained isolated on this issue too.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Demand to readmit Russia to G7 &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Mr Trump said that Russia should be allowed to again attend meetings with the G7. When there is no improvement in the relation between the EU countries and Russia, the suggestion of the US President was disregarded. &lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;The US refused to sign a G7 communique &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;When the Canadian Prime Minister released the joint communiqu&eacute;, noting it had been agreed to by all seven countries, Mr Trump refused to sign it. He tweeted &ldquo;Based on Justin&rsquo;s false statements at his news conference, and the fact that Canada is charging massive Tariffs to our U.S. farmers, workers and companies, I have instructed our U.S. Reps not to endorse the Communique as we look at Tariffs on automobiles flooding the U.S. Market!&rdquo;.  He called the Canadian Premier &ldquo;dishonest and weak&rdquo;. Finally the US did not sign the joint communiqu&eacute;.&lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Parris accord&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Mr Trump didn&rsquo;t commit on honouring the Paris Accord, which was the strenuous initiative of France. However, he tweeted &ldquo;I will make my final decision on the Paris Accord next week!&rdquo;. During the meeting, the other heads of state pressed Trump to commit to remaining in the agreement, in an attempt to come to a consensus before the end of the event. The US&rsquo;s absence in the consensus shows a stark divide between the US and the other nations.  &lt;/div&gt;&lt;/div&gt;&lt;div class=&quot;o9v6fnle cxmmr5t8 oygrvhab hcukyx3x c1et5uql ii04i59q&quot; style=&quot;overflow-wrap: break-word; margin: 0.5em 0px 0px; white-space: pre-wrap; font-family: &quot;Segoe UI Historic&quot;, &quot;Segoe UI&quot;, Helvetica, Arial, sans-serif; color: rgb(228, 230, 235); font-size: 15px; background-color: rgb(36, 37, 38);&quot;&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Conclusion&lt;/div&gt;&lt;div dir=&quot;auto&quot; style=&quot;font-family: inherit;&quot;&gt;Overall, the 2018 G7 Summit exposed the US policies and selfish attitude of the US Government. Mr Trump once again proved that his self interests are paramount and nothing stands before it. Interestingly in a photo which went viral in the media  shows the tendency of the US hegemony. It is unfortunate that the countries like the US is resorting &ldquo;protectionist&rdquo; approach but at the same time want to retain the hegemony of &ldquo;world leader&rdquo; title.  The events unfolded in the G7 summit also showcase the bad diplomatic gestures and talks which are not only unhealthy, but also unfamiliar in the international relations. World order is seeing turbulence in the economic sphere and in terms of hostility ever since Mr Trump assumed office. Rather than marking his name in the world history as a President contributing to world peace and stability, Mr Trump, as international analysts opine, destroying them, which is certainly not in the interest of any country.&lt;/div&gt;&lt;/div&gt;', 'b6bd0045ba39038c18b40606f1825b31.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:47:22', '2020-12-23 02:55:49'),
(44, 'ror8dA40M37FTDFF0jE1uTzkD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A brief note on Constitution of India.   S.Basavaraj. Advocate. Bangalore ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;26:1:1950 Constitution of India came into force.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;1950-51 &ndash; Several land reforms laws were enacted.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThese laws challenged in UP, MP, Bihar High Courts. Bihar Act struck down.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;10:5:1951 - 1st Amendment to the Constitution of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndia.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;31-A. Saving of laws providing for acquisition of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nestates, etc.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n31-B. Validation of certain Acts and Regulations (Ninth Schedule to save&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nagrarian laws)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; The 1st amendment came up for challenge before the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nConstitution bench in Shankari Prasad Singh Deo vs Union of India. &ndash;( Hon&#039;ble&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCourt Judges Chief Justice Harilal Kania, Justice Patanjali Sastri, Justice&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nMukherjea, Justice Das and Justice Chandrasekhara Aiyar)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 5:10:1951 - Supreme Court rejected the contention&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat amendment to Constitution violates Article 13(2) of the Constitution of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndia. Amendment is not a &ldquo;Law&rdquo; within Article 13(2). AIR 1951 SC 458&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 20:6:1964 - 17th Amendment to Constitution.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; The amendment added 43 enactments into Ninth&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSchedule.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; One such Act was challenged in Sajjan Singh vs State&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof Rajasthan (Hon&#039;ble Judges Chief Justice Gajendragadkar, Justice K.N.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nWanchoo, Justice M. Hidayatullah, Justice Raghubar Dayal and Justice J.R.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nMudholkar&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 30:10:1964 &ndash; Judgment in Sajjan Singh case. Supreme&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCourt again rejected the contention that amendment was &ldquo;Law&rdquo; within Article&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n13(2) of the Constitution of India. However Justice J.R. Mudholkar and Justice&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nHidayatullah expressed doubt over Parliament&rsquo;s power to amend basic &ldquo;features&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the Constitution&rdquo;. AIR 1965 SC 845&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; The doubt expressed in Sajjan Singh resulted in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncreation of 11 bench of the Supreme Court in I. C. Golaknath &amp; Ors vs State&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof Punjab &amp; anr., (Hon&#039;ble Judges - Chief Justice K. Subba Rao Justice K.N.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nWanchoo, Justice M. Hidayatullah, Justice J.C. Shah, Justice S.M. Sikri,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice R.S. Bachawat, Justice V. Ramaswami, Justice J.M. Shelat, Justice&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBhargava, Justice Vishishtha, Justice G.K. Mitter, Justice C.A. Vaidyialingam)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 27:2:1967 - Supreme Court upheld 1st, 4th and 17th&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\namendment - AIR 1967 AIR 1643. Shankari Prasad overruled. &ldquo;Law&rdquo; in Article 13(2)&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nincludes amendment to Constitution of India. However using prospective&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\noverruling, earlier amendments to the constitution saved.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 4:8:1971 Parliament introduced 24th Amendment to the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nConstitution. Article 13 and Article 368 amended to include the following.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;13(4) Nothing in this article shall apply to any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\namendment of this Constitution made under Article 368.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n368 (1) Notwithstanding anything in this Constitution, Parliament may in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexercise of its constituent power amend by way of addition, variation or repeal&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nany provision of this Constitution in accordance with the procedure laid down&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin this article.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n368 (3) Nothing in Article 13 shall apply to any amendment made under this&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&bull; 20:4:1972 - 25th Amendment to the Constitution. Article 31-C was added.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;31-C. Saving of laws giving effect to certain&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndirective principles.&mdash;Notwithstanding anything contained in Article 13, no law&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngiving effect to the policy of the State towards securing the principles&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nspecified in clause (b) or clause (c) of Art. 39 shall be deemed to be void on&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe ground that it is inconsistent with, or takes away or abridges any of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrights conferred by Article 14, Article 19 or Article 31 and no law containing&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na declaration that it is for giving effect to such policy shall be called in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nquestion in any court on the ground that it does not give effect to such&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npolicy:&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Provided that where such law is made by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLegislature of a State, the provisions of this Article shall not apply thereto&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunless such law, having been reserved for the consideration of the President,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas received his assent.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n31:7:1971 &ndash; 26th Amendment to Constitution. Privy Purse abolished&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n24:5:1972 &ndash; 29th Amendment to Constitution. Kerala Land Reforms (Amendment)&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAct, 1969 and the Kerala Land Reforms (Amendment) Act, 1971 added to 9th&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSchedule.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&bull; All the above amendments challenged in Kesavananda Bharati vs State Of Kerala&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(Hon&#039;ble Judges Chief Justice Sikri, S.M. Justice Shelat, J.M., Justice K.S.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nHegde, Justice Grover, Justice A.N., Ray, Justice P.J. Reddy, Justice Palekar,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice H.R. Khanna, Justice K.K. Mathew, Justice M.H.Beg, Justice S.N.Dwivedi,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice B.K.Mukherjea, Justice Y.V. Chandrachud)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; 24:4:1973 - Judgment in Kesavananda Supreme Court&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nheld that even though 13 may not apply to constitutional amendment, there are&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nimplied limitations to amendment in the form of &ldquo;basic structure&rdquo; of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconstitution.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;31-C. Saving of laws giving effect to certain&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndirective principles.&mdash;Notwithstanding anything contained in Article 13, no law&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngiving effect to the policy of the State towards securing the principles&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nspecified in clause (b) or clause (c) of Art. 39 shall be deemed to be void on&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe ground that it is inconsistent with, or takes away or abridges any of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrights conferred by Article 14, Article 19 or Article 31 and no law containing&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na declaration that it is for giving effect to such policy shall be called in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nquestion in any court on the ground that it does not give effect to such&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npolicy:&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Provided that where such law is made by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLegislature of a State, the provisions of this Article shall not apply thereto&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunless such law, having been reserved for the consideration of the President,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas received his assent.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Article partially upheld in Kesavananda Bharati v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nState of Kerala, (1973) 4 SCC 225. Doctrine of basic structure asserted .&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;3:1:1977 - 42ndAmendment to Constitution.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Article 31-C. Saving of laws giving effect to certain&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndirective principles.&mdash;Notwithstanding anything contained in Article 13, no law&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngiving effect to the policy of the State towards securing all or any of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprinciples laid down in Part IV shall be deemed to be void on the ground that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nit is inconsistent with, or takes away or abridges any of the rights conferred&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby Article 14 or Article 19 (remaining portion already struck down in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nKesavananda Bharati.)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Provided that where such law is made by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLegislature of a State, the provisions of this Article shall not apply thereto&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunless such law, having been reserved for the consideration of the President,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas received his assent.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Article 368 (4) No amendment of this Constitution&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(including the provisions of Part III) made or purporting to have been made&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunder this article [whether before or after the commencement of Section 55 of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe Constitution (Forty-second Amendment) Act, 1976] shall be called in question&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin any court on any ground.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nArticle 368 (5) For the removal of doubts, it is hereby declared that there&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nshall be no limitation whatever on the constituent power of Parliament to amend&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby way of addition, variation or repeal the provisions of this Constitution&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunder this article.]&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&bull; Highlighted and underlined portion in Article 31-C&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand entire sub-article (4) of Article 368 challenged in Minerva Mills Ltd. v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nUnion of India, (Hon&#039;ble Judges Chief Justice Y.V.Chandrachud, Justice P.N.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBhagwati, Justice A.C. Gupta, Justice N.L. Untwalia, Justice P.S. Kailasam)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;31:7:1980 Judgment in Minerva Mills Ltd. v. Union of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndia (1980) 3 SCC 625. The portion in Article 31-C and portions in Article 368&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstruck down.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;13:11:1980 - In Waman Rao And Ors vs Union Of India&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAIR 1981 SC 271 again Article 31-B was called in question. Hon&#039;ble Judges Chief&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice Y.V. Chandrachud, Justice P.N. Bhagwati, Justice V.R. Krishna Iyer,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice V.D. Tulzapurkar and Justice A.P. Sen. Matter again led to constitution&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof 9 judges&rsquo; bench.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;11:1:2007 - Judgment in I.R. Coelho v. State of T.N.,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(Hon&#039;ble Judges Chief Justice Y.K. Sabharwal, Justice Ashok Bhan, Justice Dr.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nArijit Pasayat, Justice B.P. Singh, Justice S.H. Kapadia, Justice C.K. Thakker,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJustice P.K. Balasubramanyan, Justice Altamas Kabir and Justice D.K. Jain)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Held. Acts included in 9th schedule can be challenged&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\non the ground of violation of basic structure of the constitution.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Compiled by:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nS.Basavaraj&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nDaksha Legal&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&nbsp;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;', 'd5c3abbb987a72262087df820687d27e.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:50:23', '2020-12-23 02:55:00');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(45, 'RpZpKGiysG8ovG4tu6ia5htKX', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A brief note on Design Act 2000 with relevant case laws.   S. Basavaraj. Advocate. Bangalore ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;S.Basavaraj, Advocate, Daksha Legal.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;At the outset it is to be seen that the &ldquo;design&rdquo; does&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot include a trade mark under the Trademarks Act or property mark or an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nartistic work under the Copyright Act. Design means only the features of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;shape&rdquo;, configuration, pattern, ornament or composition of lines or colours&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplied to any article whether in two dimensional or three dimensional or in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nboth forms, by any industrial process or means, whether manual, mechanical or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nchemical, separate or combined, which in the finished article appeal to and are&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\njudged solely by the eye; but does not include any mode or principle of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconstruction or anything which is in substance a mere mechanical device. (Section&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n2(d), Design Act, 2000.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The Design Act, 2000 protects only the designs&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistered under the Act. Section 2(c) defines copyright to mean the exclusive&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nright to apply a design to any article in any class in which the design is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistered. Only those designs which are new and original deserve registration&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunder the Act. (Section-3). Hence the common law test of &lsquo;passing off&rsquo; which is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\navailable under Section 27 of the Trade Marks Act, 1999, will not apply in case&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof design. Please also note the tests are three dimensional unlike two&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndimensional in case of a trademark.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The word &lsquo;original&rsquo; is also defined as originating&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfrom the author of such design and includes the cases which though old in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthemselves yet are new in their application. (Section 2(g)). Later portion of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe definition shows that even those designs which were created long ago but&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplied recently are also considered as original.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Registration gives protection to the owner. During the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexistence of copyright in any design it shall not be lawful for any person (a)&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfor the purpose of sale to apply or cause to be applied to any article in any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nclass of articles in which the design is registered, the design or any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfraudulent or obvious imitation thereof, except with the license or written&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsent of the registered proprietor, or to do anything with a view to enable&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe design to be so applied; or (b) to import for the purposes of sale, without&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe consent of the registered proprietor, any article belonging to the class in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhich the design has been registered, and having applied to it the design or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nany fraudulent or obvious imitation thereof, or (c) knowing that the design or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nany fraudulent or obvious imitation thereof has been applied to any article in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nany class of articles in which the design is registered without the consent of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe registered proprietor, to publish or expose or cause to be published or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexposed for sale that article. (Section 22)&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;If there is any contravention, the owner can bring a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsuit for recovery of damages and the court can award the maximum damages of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nRs.50,000/-. The owner is also entitled for injunction against the repetition&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the contravention.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Any person interested can seek cancellation of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration before the Controller on any of the following grounds, namely:-&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(a) that the design has been previously registered in India; or (b) that it has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbeen published in India or in any other country prior to the date of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration; or (c) that the design is not a new or original design; or (d)&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat the design is not registrable under this Act; or (e) it is not a design at&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nall. The Controller can decide the issue either by himself or refer the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npetition for cancellation to the High Court, and the High Court shall decide&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nany petition so referred.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;When a suit is filed before the District Judge seeking&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndamages and injunction, the defendant can take every ground on which the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration of a design may be cancelled by the Controller. Where such a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndefence has been availed of as a ground of defence the suit shall be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntransferred to the High Court for decision.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Needless to say, the High Court can not only dismiss&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe suit, it can even cancel the registration of the plaintiff on the grounds&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmentioned above. When the High Court makes such a decree, it shall send a copy&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the decree to the Controller, who shall cause an entry thereof to be made in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe register of designs.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;RELEVANT CASE LAW&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;KARNATAKA HIGH COURT: Metal Impacts Private Limited v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nImpact Metals Private Limited, 2011 SCC OnLine Kar 3985: ILR 2014 KAR 6639:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(2012) 2 AIR Kant R 549: (2012) 2 KCCR 853.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;10. The purpose of the Act is protection of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nintellectual property right of the original design for a period of 10 years or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhatever further period extendable. The object behind this enactment is to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbenefit the person for his research and labour put in by him to evolve the new&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand original design. This is the sole aim of enacting this Act. Certain&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprohibitions have been engrafted in the Act so as to protect the original&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nperson who has created a new design by virtue of his own efforts by researching&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfor a long time. The protection given by the law relating to designs to those&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwho produce new and original designs, is primarily to advance industries, and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nkeep them at a high level of competitive progress. The object of design&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration is to see that the originator of a profitable design is not&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndeprived of his reward by others applying it to their goods. The purpose of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nDesigns Act is to protect novel designs devised to be applied to particular&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticles to be manufactured and marketed commercially. It is not to protect&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprinciples of operation or invention which, if profitable at all, ought to be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmade the subject matter of a patent. Nor is to prevent the copying of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndirect product of original artistic effort in producing a drawing. Indeed the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhole purpose of a design is that it shall not stand on its own as an artistic&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwork but shall be copied by embodiment in a commercially produced artefact.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThus, the primary concern is, what the finished article is to look like and not&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwith what it does and the monopoly provided for the proprietor is affected by&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\naccording not, as in the case of ordinary copyright, a right to prevent direct&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreproduction of the image registered as the design but the right, over a much&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmore limited period, to prevent the manufacturer and sale of article of a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesign not substantially different from the registered design. The emphasis,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntherefore, is upon the visual image conveyed by the manufactured article.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;11. Russel-Clarke&rsquo;s Copyright and Industrial Designs&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(1951) Edition at page 162 reads as under:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;It is said that protection will be given to any design which is new or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\noriginal. As to what distinction, if any, is to be drawn between the words new&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand original is doubtful. It may be that &lsquo;new&rsquo; means different from what has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngone before and that &lsquo;original&rsquo; has the same meaning as in the Copyright Act,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ni.e., originating from the author. It is also possible that the view advanced&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby Buckley, L.J. In Dover Ltd. v. Numberger Celluloid Waren Fabrik, (1910) 27&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nRPC 498 is the correct one. There he said that &lsquo;new&rsquo; referred to cases where&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe shape or pattern was completely new in itself whilst &lsquo;original referred to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncases where, though old in itself it was new in its application to the article&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin question.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;He said (at page 503): &lsquo;If the design be new it may be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistered under that expression. But the act of Section 49 seems to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncontemplate that it may be registered, even if it not be new, provided that it&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbe original. The explanation of this lies possibly in the fact that the novelty&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmay Consist not in the idea itself but in the way in which the idea is to be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrendered applicable to some special subject-matter. The Word &lsquo;original&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncontemplates that the person has originated something that by the exercise of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nintellectual activity he has started an idea which had not occurred to any one&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbefore, that a particular pattern or shape or ornament may be rendered&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplicable to the particular article to which he suggests that should be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplied&hellip;&hellip;&rsquo; &hellip;.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Whether a design is novel is a matter of fact to be decided&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby the eye. As already indicated, if the same shape or pattern, or one&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsubstantially similar, has previously been thought of in connection with any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle of manufacture and the idea published, or registered, then the design&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwill be deprived of its novelty. The previous idea or design, will act as an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nanticipation of the later design, and will be a bar to its protection. That the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\neye, and the eye alone, is to be the judge of Identity, and is to decide&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhether one design is or is not an anticipation of any, has been laid down time&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand time again in numberless cases. Whether a design is more useful than other&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesigns which have gone before is not to be considered. It is simply the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngeneral impression gathered by the eye that counts, and it is, therefore, impossible&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto lay down any hard and fast rule which can be followed. &hellip;&hellip;&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;According to Black&rsquo;s Law Dictionary:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;in order that there may be novelty so as to sustain a patent, the thing must&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot have been known to any one before; mere novelty of form being insufficient&rdquo;.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAccordingly, mere novelty of form or shape is insufficient. Novelty involves&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe presence of some element or new position of an old element in combination,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndifferent from anything found in any prior structure. Secondly, even in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncylindrical shape, there may be different shapes. The test is to consider and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlook at the design with an instructed eye and say whether or not such a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndifferent between the which has been published previously, and the registered&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesign as to entitle the proprietor.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;12. In Dover v. Nurnberger Celluloid Wares Fabrik&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nGebruder Wolff 1, Buckley L.J, said as under:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;Design means, therefore a conception or suggestion or idea of a shape or of a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npicture or of a device or of some arrangement which can be applied to an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle by some manual, mechanical or chemical means. It is a conception,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsuggestion, or idea, and not an article, which is the thing capable of being&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistered. It is a suggestion of form or ornament to be applied to a physical&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbody.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;13. LEGAL CONCEPTS DESIGN. The concept of design is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat a particular figure conceived by its designer in his mind and it is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreproduced in some identifiable manner and it is sought to be applied to an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle. Design means, therefore a conception or suggestion or idea of a shape&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nor of a picture or of a device or of some arrangement which can be applied to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nan article by some manual, mechanical or chemical means. A design is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnecessarily part and parcel of the article manufactured while a trade mark is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot necessarily so. Therefore, both the things are required to go together,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ni.e., the design and the design which is to be applied to an article. The idea&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis that the design has to be registered which is sought to be reproduced on any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle. Registration of design is not a defence if the impugned design has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbeen published by others prior to date of registration.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;14. NOVELTY Novelty so as to sustain a patent, the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthing must not have been known to any one before. Mere novelty of form is not&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsufficient. Novelty involves the presence of some element or new position of an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nold element in combination, different from anything found in any prior&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstructure. If the same shape or pattern, or one substantially similar, has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npreviously been thought of in connection with any article of manufacture and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe idea published, or registered, then the design will be deprived of its&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnovelty. Protection will be given to any design which is new or original. &lsquo;New&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmeans different from what has gone before and that &lsquo;original&rsquo; has the same&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmeaning as in the Copyright Act, i.e., originating from the author. &lsquo;New&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreferred to cases where the shape or pattern was completely new in itself,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhilst &lsquo;original referred to cases where, though old in itself, it was new in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nits application to the article in question. The expression that &lsquo;new&rsquo; or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lsquo;original&rsquo; has to be construed in the context Where this design has ever been&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreproduced by any other Company earlier. It is only the new and original design&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhich is new and which has not been available in the country or has not been&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npreviously registered or has not been published in India or in any other&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncountry prior to the date of registration shall be protected for a period of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nten years. It is in the nature of protection of the intellectual property&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nright.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;15. ORIGINAL The word &lsquo;original&rsquo; refers to design&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhich no previous designer had created for any purpose and &lsquo;new&rsquo; as referring&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto a design which was not in this sense original but was newly and for the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfirst time applied to the particular kind of article with reference not to the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nclassification in the third schedule of the Designs Rules, 1908 but to the kind&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof article having regard to its general character and use. The word &lsquo;original&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncontemplated that the person had originated something that by the exercise of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nintellectual activity he has started an idea which had not occurred to anyone&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbefore, that a particular pattern or shape or ornament may be rendered&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplicable to the particular article to which he suggests that it shall be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplied. &ldquo;New or original&rdquo; involve the idea of novelty either in the pattern,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nshape or ornament itself or in the way in which an old pattern, shape, or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nornament is to be applied to some special subject matter. There must be the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexercise of intellectual activity so as to originate, that is to say, suggest&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfor the first time, something which had not occurred to anyone before as to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\napplying, by some manual, mechanical, or chemical means, some pattern, shape,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nor ornament to some special subject matter to which it had not been applied&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbefore.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;16. Generally, the test for integrity and originality&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis dependent on determining the type of mental activity involved in conceiving&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe design in question. If the design is original, then the designer must have&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconceived something new. If the design is a mere trade variation of a previous&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesign, then the designer could be said to have merely keep an existing design&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin view and made some changes in its. The introduction of ordinary trade&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nvariants into an old design cannot make it new or original. The working world,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nas well as the trade world, is entitled at its will to take, in all cases, its&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nchoice or ordinary trade variants for use in any particular instance and no&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npatent and no registration of a design can prevent an ordinary workman from&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nusing or not using trade knowledge of this kind.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Design is an ideal or conception as to features of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nshape, configuration, pattern or ornament applied to an article. Although that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nidea, while still in the author&rsquo;s head, may be potentially capable of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration, in fact it must be reduced to visible form to be identifiable,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand until it is so reduced there is nothing capable or registration. It may be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nso rendered either by its being embodied in the actual article, or by its being&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nplaced upon a piece of paper in such a way that the shape or other features of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe article to be made are clear to the eye. Whenever the means of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nidentification (under some of the old Acts, provision was made whereby a mere&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nverbal description could in some cases be accepted as sufficient), as soon as&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe idea is reduced to a form which is identifiable, there is something which&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis a &ldquo;design&rdquo;, and which, if new or original, may be registered.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;In the case of Ampro Food Products v. Ashoka Biscuit&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nWorks AIR 1973 ANDHRA PRADESH 17, it is held a: under:&mdash;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;A design is necessarily part and parcel of the article manufactured while a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntrade mark is not necessarily so. In fact, the definition of &ldquo;design&rdquo; in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSection 2(5) of the Designs Act expressly states that it does not include any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntrade mark as defined in Section 2(1)(v) of the Trade and Merchandise Marks&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAct, 1958. That is why the certificate of registration of the design contains a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnote which recites. &ldquo;The novelty in the design resides in the ornamental source&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npattern which appears only on the side of the biscuit as illustrated. No claim&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis made by virtue of this registration to any right to the use as a trade mark&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof what is shown in the representation or to the exclusive use of the letters&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nappearing in the design&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The Supreme Court in the case of Bharat Glass Tube&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLtd. v. Gopal Glass Works Ltd. (2008) 10 SCC 657 : AIR 2008 SC 2520, held that:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;The concept of design is that a particular figure conceived by its designer in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhis mind and it is reproduced in some identifiable manner and it is sought to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbe applied to an article. Therefore, whenever registration is required then&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthose configuration has to be chosen for registration to be reproduced in any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle. The idea is that the design has to be registered which is sought to be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreproduced on any article. Therefore, both the things are required to go&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntogether, i.e., the design and the design which is to be applied to an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narticle.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The Delhi High Court in the case of Rotela Auto&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nComponents (P) Limited v. Jaspal Singh 2002 (24) PTC 449 (DEL), held that:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;The design is a conception, suggestion or idea of a shape and not an article.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIf it has already been anticipated, it is not new or original. If it has been&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npre-published, it cannot claim protection as publication before registration&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndefeats the proprietors rights to protection. Registration of design is not a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndefence if the impugned deign has been published by others prior to date of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistration.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The Calcutta High Court in the case of Western&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nEngineering Co. v. Paul Engineering Co., AIR 1968 CALCUTTA 109 it is held that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe underlying principles behind the law of infringement or design is that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhile the commercial exigencies require that a specific design which is novel&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand original should be protected, the monopoly of a trade in respect of a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncommon design with no special skill or originality should not be encouraged.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The Delhi High Court in the case of Glaxo Smithkline&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nConsumer Health Care v. Amigo Brushes Private Limited 2004 (28) PC 1 (DEL), was&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsidering the question whether the handle of the toothbrush could be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregistered as a &lsquo;new&rsquo; or &lsquo;original&rsquo; design under the Act. The Court held that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmaking a handle thick or thin or with sharp tapering at the end of the grip&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npart can by no stretch of reasoning be considered as &lsquo;new&rsquo; or &lsquo;novel&rsquo; design.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThey are mere trade variants.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Again the Delhi High Court in the case of Hello&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nMineral Water Private Limited v. Thermaking California Pure 2000 (20) PTC 177&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(DEL), held that insofar as the cylindrical shape is concerned, there is no&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnovelty for the novelty does not lie in just shape of this kind or the other,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nit is something more.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Again the Delhi High Court in the case of National&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nTrading Company v. Monika Chawla AIR 1994 DEL 309, held that the design will be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndeemed to be pre-published if the design is disclosed to any individual member&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof public who is not under an obligation to keep it secret. Disclosure to such&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nperson is sufficient to constitute publication of design.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;1. Bharat Glass Tube Ltd. v. Gopal Glass Works Ltd.,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(2008) 10 SCC 657, at page 676&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n40. The question of eye appeal came up for consideration in Interlego AG v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nTyco Industries Inc (1989 AC 217 : (1988) 3 WLR 678 : (1988) 3 All ER 949&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(1988) 16 RPC 343 (PC)). In that case Their Lordships have laid down important&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntest in the matter of visual appeal of the eye. It was observed as follows:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(All ER pp. 959g-960a)&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;In relation, however, to an assessment of whether a particular shape or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconfiguration satisfies the former and positive part of the definition, the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfact that an important part of the very purpose of the finished article is to appeal&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto the eye cannot be ignored. That factor was one which was conspicuously&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nabsent from the articles upon which the courts were required to adjudicate in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nTecalemit Ltd. v. Ewarts Ltd. (No. 2) (1927) 44 RPC 503, Stenor Ltd. v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nWhitesides (Clitheroe) Ltd., 1948 AC 107 : (1947) 2 All ER 241: (1948) 65 RPC 1&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n(HL) and Amp Inc. v. Utilux Pty. Ltd., 1972 RPC 103 (HL) and in the more recent&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIrish case of Allibert S.A. v. O&mdash;Connor (1981) FSR 613 in all of which the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nclaim to registration failed. It was one which was present in Kestos case,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhere the claim to the validity of the design succeeded. It is present in the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninstant case. One starts with the expectation of eye appeal, for part of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nvery purpose of the article is to have eye appeal. That was aptly expressed by&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nWhitford, J. in relation to the same subject-matter as in this appeal in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nInterlego AG v. Alex Folley (Vic) Pty. Ltd. (1987) FSR 283 (FSR at p. 298): &lsquo;I&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwould have expected a designer designing toys to have the question of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nappeal of the toy to the eye, even in the case of a functional toy, in mind. Mr&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nRylands who gave evidence for the defendants said that when designing a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfunctional toy it is necessary to have regard not only to suitability for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npurpose but to overall appearance. You have to design so that the article in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nquestion will make an immediate visual appeal to a child or to the parent or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nother person buying for a child.&rsquo; &rdquo;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n41. One has to be very cautious, unless two articles are simultaneously&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nproduced before the court then alone the court will be able to appreciate. But&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin the present case no design reproduced on glass sheets was either produced&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbefore the Assistant Controller or before the High Court or before us by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nappellant to appreciate the eye appeal. The appellant could have produced the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesign reproduced on glass sheet it manufactured in the United Kingdom or&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nGermany. That could have been decisive.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;42. Our attention was invited to Dover Ltd. v.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nN&uuml;rnberger Celluloidware Fabrik Gebr&uuml;der Wolff(1910) 27 RPC 498 (CA) This was a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncase in which the question was of the pattern or ornament of handgrip for cycle&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhandles (sic and the plaintiffs had) brought an action for infringement against&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na German firm of manufacturers, and against their London agents. The defendants&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nadmitted that they were selling cycle handles with the design resembling the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nplaintiffs&rsquo; registered design but pleaded that the plaintiffs&rsquo; registered&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndesign was not a new or original design not previously published in the United&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nKingdom and alleged that it was commonly known for many years prior to the date&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the registration. Though the Single Judge held that the design was new and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\noriginal having regard to the kind of article for which it was registered and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat it had been applied by the defendants to the cycle handles sold by them,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbut the Court of Appeal held that the design was not new or original within the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndefinition of the Patents and Designs Act, 1907 and that the defendants had not&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninfringed. Therefore, this case was decided on the question of fact and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nevidence led by the parties. In this case, Buckley, J. observed as follows:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;In my opinion, there is in this no originality. If, however, the respondents&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncounsel are right in saying that the design is the whole thing as shown in the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npicture, then, it seems to me, that the defendants have not infringed. Their&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhandle is not divided into six panels but into nine panels. Their grooves are&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nso much more shallow than the plaintiffs&rsquo; grooves as to be easily&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndistinguishable from them. Fraudulent imitation there was certainly none;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nneither was there obvious imitation either.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIn my judgment, this Act was intended to protect designs which really have some&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmerit by way of novelty or originality and not to give colour to such paltry&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand trivial claims as have been set up in this case. The appeal must, I think,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsucceed and the action be dismissed with costs.&rdquo;&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nKennedy, L.J. also took the similar view and observed as follows:&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;In the present case, as I have already said, if I rightly appreciate the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nevidence, a panelled handgrip with grooved divisions was not new, nor was the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nengine-turning of surfaces as an ornamentation of those surfaces new, for it&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhad been applied to what I may, I think, fairly call the kindred surfaces of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nknife handles and penholders, where the hand grips them. I cannot find either&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnovelty or originality in the plaintiffs&rsquo; design by reason of such a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncombination.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;43. Our attention was also invited to King Features&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSyndicate Incorporated v. O. &amp; M. Kleeman Ltd. 1941 AC 417 : (1941) 2 All&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nER 403 : (1941) 58 RPC 207 (HL) In this case also, action was brought for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nalleged infringement of certain copyright in certain drawings. It was contended&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby the defendants that they had not manufactured or imported and sold as&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nalleged by the plaintiffs and there was no infringement. Leave was granted. The&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCourt of Appeal allowed the appeal. The plaintiffs appealed to the House of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLords and the appeal was allowed. There also much turned on the question of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nevidence.&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n44. Our attention was invited to Gammeter v. Controller of Patents &amp;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nDesigns AIR 1919 Cal 887. Their Lordships discussed the concept of new and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\noriginal. In that context, it was observed as follows: (AIR p. 887)&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;A design in order to be new or original within the meaning of the Act, need&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot be new or original in the sense of never having been seen before as applied&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto any article whatever, there might be a novelty in applying an old thing to a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnew use, provided it is not merely analogous. Where the design of a metal band&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncalled the &ldquo;Novelty band&rdquo;, intended to attach a watch to the wrist, was similar&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin shape and configuration to a bracelet previously manufactured for ornamental&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npurpose.&rdquo; Their Lordships further held as follows: (AIR p. 887)&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;&hellip; Though the shape of the &lsquo;Novelty band&rsquo; by itself could not be said to be new&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand original, the application of it to a watch to be worn on the wrist was for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na purpose so different from and for a use so similar to the purpose and use of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe bracelet that the design in question might be said to be original.&rdquo;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;?S. BASAVARAJ,&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nDaksha Legal&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAdvocates&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nUnit No.1, 2nd floor,&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nNo.11, Jeevan Buildings (new block)&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nKumara Park East,&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBangalore 560001&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPh: +91 080 41138502&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCel: 9845065416&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nemail: raj@dakshalegal.com&lt;br&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;/span&gt;&lt;a href=&quot;https://l.facebook.com/l.php?u=http%3A%2F%2Fwww.dakshalegal.com%2F%3Ffbclid%3DIwAR2UpjpH3CJrXXfmR06QUR08CaRF8Iog1E5JrT3CeU5OrPUpHuQO0zvhpto&amp;h=AT3i8imZS3tP6QLFKSGmEXwYqFYjc60Nq6oB03oS_gksCJi7Qh5I256m7JWqpAaXrTujFVjJ_5P2xJOUh1IOT-XPKoNXnR7igzTL3yOiyo3PnOZMNgz-QWzit99IuzTfcsk9qBbXnj-DMNeJTtk81WqSRHkEtcKS1w&quot; target=&quot;_blank&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;www.dakshalegal.com&lt;/span&gt;&lt;/a&gt;&lt;span style=&quot;font-size:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;', '533426acb99944fda19cefa6cabe082b.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:55:16', '2020-12-23 02:53:59');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(46, 'Hzr7SwGmUg07ZUoiZG42JRC1A', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A Brief Note on Real Estate Regulatory Act.   Ms. Rahisha Sinan', '&lt;h4&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;o:p&gt;&nbsp;&lt;/o:p&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Ms. Rahisha Sinan, Intern, Daksha Legal-&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;1. The real estate regulatory act was brought in by&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe Union Parliament to regulate this sector. The State Governments are liable&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto notify the Rules under this Act within a statutory period of six months&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nwhich was stipulated in Section 84 of the Act. Measures were brought in to&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbring in transparency and accountability to the real estate sector. The Act has&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbrought in new features that primarily seek to protect the interest of the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nconsumers.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;2. Real Estate Regulatory Authorities are to be set up&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nin the state level to regulate commercial and residential transactions. The&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nRegulatory Authorities must dispose of the complaint within 60 days and the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nAppellate Tribunals will adjudicate disputes within 60 days. The disputes are&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto be settled within 120 days.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;3. Registration of Real Estate Projects&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nMandatory registration of real estate projects where the land is over 500 sq.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nmt. or where there are more than eight apartments, was brought in through the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nAct. The registration of properties includes those properties that have not&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbeen completed or have not received its completion certificate. Developers&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ncannot sell before registration.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nThe application for registration must either be approved or rejected by the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregulatory authority within 30 days from the date the application was filed.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nFailure to register with the regulatory authority will lead to a penalty of up&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto 10% of the project cost or three years imprisonment.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nIn order to register a property, the builders are required to set aside 70% of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe funds collected from buyers and place it in a separate bank account.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;4. Penal Interest Rate&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nBuilders and customers are now liable to pay interest in case of delay of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ncompletion of project or payment. This will ensure timely delivery of property&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto consumers and will ensure that developers are paid in due time. The penal&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ninterest rate will be determined by SBI&rsquo;s Marginal Cost of Lending Rate plus&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n2%.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;5. Pricing&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nA distinct feature of the Act is that builders can now only quote prices based&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\non the carpet area, not the super-built up area which serves the interest of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe buyers. The term &lsquo;carpet area&rsquo; has been defined in the Act as the usable&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\narea of an apartment.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;6. Developer&rsquo;s Duties and Liability&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nThe liability of developers in case of structural defects has been increased&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nfrom 2 years to 5 years.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nThe Act has made it mandatory for developers to publicly disclose all the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nproject details including project plan, its layout, government approvals, land&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntitle status, sub-contractors to the project, schedule for completion and so&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nforth with the State Regulatory Authority. This information must then in effect&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbe passed onto the buyers. Additionally, developers are handicapped from making&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nany changes to a plan that has been sold. Changes may only be made after&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nwritten consent is obtained from the buyer. In case of lack of after sales&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nservices, buyers have been given 1 year to approach the builders.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;7. Mandatory Registration of Real Estate Agents&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nReal estate agents who facilitate selling or purchase of properties must take&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nprior registration from the regulatory authority in order to facilitate a&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntransaction. Such agents will be issued a single registration number for each&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nState or Union Territory, which must be quoted by the agent in every sale&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nfacilitated by him.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;8. Impact on property transactions&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n&bull; The implication of the Act is a decline in the projects that were set up in&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe real estate sector. The Act has the potential to weed out those projects&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthat do not meet the standards and requirements. Stringent measures enacted&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nwill ensure that the real estate sector is regulated.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nA Cushman and Wakefield report discloses that project launches have declines 8%&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nsince RERA was enacted.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n&bull; Under RERA, all property brokers will have to register with real estate&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregulators in their states, thus sieving out the small-time players and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nconsolidating major ones&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n&bull; RERA has curbed the inflow of black money in the real estate sector by&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nputting certain measures in place.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;o:p&gt;&nbsp;&lt;/o:p&gt;&lt;/span&gt;&lt;/h4&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n&lt;br /&gt;<br />\r\n', '3dd8fdd9ebb439e5fa4a790e65dd9acc.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:56:29', '2020-12-23 02:53:12');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(47, 'huxq4DTFUcd6g0fHTK30yrHGr', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A Legal Perspective on Extra Territorial Counter terrorist operations with specific reference to the Pulwama Episode and its impact on India Pakistan ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Sumukh B Ram, Intern, Daksha Legal &lt;/span&gt;&lt;/i&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&ldquo;Lakeerain buhat ajeeb hoti hai&lt;/span&gt;&lt;/i&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;khaal pe khich jaye to khoon nikal deti&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhain&lt;/span&gt;&lt;/i&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;zameen pe khich jaye tu Sarhadain bana&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndeti hai&rdquo;&lt;/span&gt;&lt;/i&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;[Lines are very strange, when they are&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndrawn on the skin, they draw blood and when they are drawn on land they make&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nborders.]&lt;/span&gt;&lt;/i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Introduction&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;India-Pakistan Relations has been a visual representation&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the David-Goliath skirmishes of the yore Biblical accounts. Both the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncountries were part of one large subcontinent which was administered by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nColonial British authorities by way of either Direct rule by Conquest or by an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninstrument known as Doctrine of Lapse where 565 princely States were in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsuzerainty with the British Empire . Of these Princely States, some of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsignificant States were the Princely States of Mysore, Travancore, Hyderabad,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBhopal, Jodhpur and Kashmir &ndash; the last of which turned into a messy succession&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbattle and still forms a crux of the problem to this day. The Movement for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndependence of the Indian Subcontinent strictly began in 1926 in the Lahore&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSession of the Indian National Congress where &ndash; Purna Swaraj, was declared for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe first time following the draconian Rowlatt Act of 1919 and the infamous&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJallianwala Bagh Massacre of 1919. Following this there were frequent&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncommissions set up by the Colonial British Empire which included the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncontroversial Simon Commission of 1929. By this movement of Independence&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstarted to develop from other corners as well. The most noteworthy ones&#039; were&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe Indian National Congress Movement led by Mahatma Gandhi and Jawaharlal&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nNehru and Quaim-e-azad Movement led by Mohammad Ali Jinnah who headed the All&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndian Muslim League. Successive conferences were set up by the British Empire&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnotably the Round Table Conferences of 1931. 1932 and 1933 and this was&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npossible due to the British Prime Minister, Sir Clement Attlee who was&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncommitted to British-Indian Independence.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Perhaps the turning point of the Indian Freedom&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstruggle was the Quit India Movement of 1942 which was supplemented by Lord&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLinlithgow Conference of 1941 and followed by The Cripps Mission of 1944 and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLord Wavell&rsquo;s plan of 1945. By the failure of the Cripps Mission it was clear&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat the subcontinent was headed towards Partition along Sectarian Lines. The&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAIML demanded a separate nation for itself known as Pakistan which was stated&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto be a Theocratic Republic and a Dominion of India which was purported to be a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSecular Democratic Republic.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;INDIA-PAKISTAN RELATIONS&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;India-Pakistan relations refer to diplomatic bilateral&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexchanges between the sovereigns of the Republic of India and Islamic Republic&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof Pakistan. A key point to note here is the difference between the term &lt;b&gt;Indo&lt;/b&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand &lt;b&gt;India&lt;/b&gt; when referring to bilateral or international relations. It has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof late become a trend to interchange the usage between India and Indo but the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndistinction is that while using &lt;b&gt;India&lt;/b&gt; we would be referring to relations&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbetween india and another nation in the eyes of international law and the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nauspices of diplomacy but in the case of &lt;b&gt;Indo&lt;/b&gt;we would be referring to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe entire &lt;b&gt;Indo-Oceanic Plateau along with the Group of Nations &lt;/b&gt;and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntheir relations with the respective nation.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;India-Pakistan relations for the past 7 decades have&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbeen Laodicean, while the former is a flourishing democracy and home to 1.3&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbillion people of all walks of life, the latter has seen rogue militarism and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nautocratic governance. Pakistan over the past 70 years doesn&rsquo;t have a single&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPrime Minister who has completed his/her 5 years tenure as mandated by its&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nConstitution. It has seen 4 totalitarian military coups with martial law in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nplace: namely 1953 coup by Ghulam Mohammed, 1958 coup by Ayub Khan, 1977 coup&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby Zia-ul-Haq and the 1999 coup by Pervez Musharraf. India on the other hand is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe world&rsquo;s largest democracy with 900 million voters as per the ECI rolls of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe 2019 General Assembly Elections. India and Pakistan have conflicted&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnumerous including 4 full-fledged wars of 1947,1965,1971 and 1999, the third&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\none being the most devastating for Pakistan as it lost half of its territory&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand resulted in the liberation of East Pakistan and led to the creation of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBangladesh.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Legality of Extra-Territorial Counter Terrorism&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nAttacks&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Operation Neptune Spear : Killing of Osama&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBin Laden in Abottabad, Pakistan&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nline-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;On May 2, 2011, U.S. forces entered Pakistanwithout&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe Pakistani government&rsquo;s consent to capture or kill Osama Bin Laden. In the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwake of the successful U.S. military operation, the Pakistan Government&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nobjected to the unauthorized unilateral action by the United States and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncautioned that the event shall not serve as a future precedent for any state.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nFormer President Musharraf complained that the operation violated Pakistan&rsquo;s&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsovereignty. The episode implicates a host of important legal and political&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nissues.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;This &lt;i&gt;paper &lt;/i&gt;focuses on of them:&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&middot; When may one state use force in another&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate&rsquo;s territory in self-defence against members of a non-state armed group?&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&middot; What constraint does the principle of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsovereignty impose on that action?&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nline-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Non-state actors, including terrorist groups,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nregularly launch attacks against states, often from external bases. When a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate seeks to respond with force to those attacks, it must decide whether to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nuse force on the territory of another state with which it may not be in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconflict. Absent consent from the territorial state or authorization from the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nUnited Nations Security Council, international law traditionally requires the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate that suffered the armed attack to assess whether the territorial state is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunwilling or unable to unilaterally suppress the threat. Only if the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nterritorial state is unwilling or unable to eliminate the threat may the victim&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate lawfully use force. This &lt;i&gt;paper &lt;/i&gt;explores the scope of that test and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsiders what types of factors the United States might have taken into account&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin concluding that Pakistan was unwilling or unable to address the threat posed&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nby Bin Laden.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Both the Bush and Obama Administrations have taken the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nview that the United States is in an armed conflict with al Qaeda. In the U.S.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nGovernments view, al Qaeda undertook an armed attack against the United States&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\non September 11, 2001, which triggered the U.S. right of self-defence&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsistent with Article 51 of the U.N. Charter. Perhaps the most controversial&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\naspect of this position is the U.S. argument that this conflict can and does&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nextend beyond the hot battlefield of Afghanistan to wherever members of al&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nQaeda are found. For the United States (and others that adopt this position),&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nonce a state is in an armed conflict with a non-state armed group, that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconflict follows the members of that group wherever they go, as long as the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngroup&rsquo;s members continue to engage in hostilities against that state (either on&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe hot battlefield or from their new location).&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Those who support the view that armed conflicts have&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngeographic limits as a matter of international law usually begin with the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nproposition that one must determine the existence of an armed conflict based on&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe facts on the ground in a particular state. The hostilities there between a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate and an organized non-state actor must be protracted and intense for an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\narmed conflict to exist. If the level of violence is sporadic or the non-state&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nactors lack a certain level of organization, no armed conflict exists, and any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate wishing to address the threat posed by those non-state actors must use&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlaw enforcement tools.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;These contrasting positions come into high relief in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe Bin Laden case. If the U.S. conflict with al Qaeda is limited to the hot&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbattlefield of Afghanistan (and possibly Yemen, Iraq, and the border regions of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPakistan), then the United States could not lawfully have targeted Bin Laden as&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na belligerent in an armed conflict. If, alternatively, the U.S. conflict with&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nal Qaeda is not limited to hot battlefields then the United States could make a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndetermination that Bin Laden was a lawful target under the laws of armed&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconflict, even when unarmed and at home in his compound in Abbottabad. The&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nUnited States clearly made the latter determination. However, this does not end&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe inquiry about whether using force in Pakistan against Bin Laden was&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninternationally lawful.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;International law restricts the situations in which a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate may use force in the territory of another state. There are three&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsituations in which such an act is lawful: pursuant to U.N. Security Council&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nauthorization under Chapter VII of the U.N. Charter; in self-defence; or (at&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nleast in some cases) with the consent of the territorial state. Once a state&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconcludes that it has a right of self-defence, it must assess what specific&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntypes of actions it can take in response, including whether it can use force.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThe standard inquiry has three elements:&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Whether the use of force would be &lt;i&gt;necessary&lt;/i&gt;;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Whether the level of force contemplated would be &lt;i&gt;proportionate&lt;/i&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto the initial armed attack (or imminent threat thereof);&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Whether the response will be taken at a point&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsufficiently close to the armed attack (&lt;i&gt;i.e.&lt;/i&gt;, whether it would be &lt;i&gt;immediate&lt;/i&gt;).&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;In determining whether it is necessary to use force&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nagainst a non-state actor operating in another state&rsquo;s territory, the victim&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate must consider not just whether the attack was of a type that would&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrequire force in response, but also the conditions within the state from which&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe non-state actor launched the attacks. In this latter evaluation, states,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nabsent consent, employ the unwilling or unable test to assess whether the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nterritorial state is prepared to suppress the threat. If the territorial state&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis either unwilling or unable, it is reasonable for the victim state to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsider its own use of force in the territorial state to be necessary and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlawful (assuming the force is proportional and timely). If the territorial&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstate is both willing and able, the victim state&rsquo;s use of force would be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunlawful. Thus, if the United States located a senior member of al Qaeda in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nStockholm, it almost certainly would be unlawful for the United States to use&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nforce against that individual without Sweden&rsquo;s consent, because there is no&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreason to believe that the Swedish government would be unwilling or unable to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntake appropriate measures against that al Qaeda member.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Although the test is easy to state, international law&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngives the United States (or any state in a similar position) little guidance&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nabout what the unwilling or unable test requires. Considerable state practice&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsupports the existence of the test and reveals its historical roots in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nneutrality law, but neither states nor scholars have discussed what the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstandard means. What facts should the United States have considered when&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nevaluating Pakistan&rsquo;s willingness or ability to suppress the threat Bin Laden&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nposed to the United States, NATO and Afghan forces, and the security of other&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstates that have suffered al Qaeda attacks? Does international law require the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nUnited States to ask Pakistan to take measures itself before the United States&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlawfully may act? If so, how much time must the United States give Pakistan to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrespond? What if Pakistan proposes to respond to the threat in a way that the United&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nStates believes may not be adequate?&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Based on an examination of state practice, it is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npossible to ascertain a few key principles that the international community&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmight expect a state using force to follow. The principles might include&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrequirements that the acting state:&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Ask the territorial state to address the threat and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprovide adequate time for the latter to respond;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Reasonably assess the territorial state&rsquo;s control&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand capacity in the region from which the threat is emanating;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Reasonably assess the territorial state&rsquo;s proposed&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmeans to suppress the threat;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;&middot; Evaluate its own prior interactions with the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nterritorial state.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;However, an important exception to the requirement&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat the acting state request that the territorial state act arises where the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nacting state has strong reasons to believe that the territorial state is&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncolluding with the non-state actor, or where asking the territorial state to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntake steps to suppress the threat might lead the territorial state to tip off&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe non-state actor before the acting state can undertake its mission.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;In an August 2007 speech, then-Presidential candidate&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBarack Obama asserted that, if elected, his Administration would take action&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nagainst the leadership of al Qaeda in Pakistan if the United States had&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nactionable intelligence about al Qaeda targets in Pakistan and then-President&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nMusharraf failed to act. Obama later clarified his position, stating,&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&ldquo;What I said was that if we have&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nactionable intelligence against bin Laden or other key al-Qaida officials . . .&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand Pakistan is unwilling or unable to strike against them, we should strike&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthem instead&rdquo;&lt;/span&gt;&lt;/i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Based on the facts that have come to light to date,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe United States appears to have strong arguments that Pakistan was unwilling&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nor unable to strike against Bin Laden. Most importantly, the United States has&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na reasonable argument that asking the Government of Pakistan to act against Bin&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLaden could have undermined the mission. The size and location of the compound&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand its proximity to Pakistani military installations has cast strong doubt on&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPakistan&rsquo;s commitment to defeat al Qaeda. The United States seems to have&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsuspected that certain officials within the Pakistani government were aware of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBin Laden&rsquo;s presence and might have tipped him off to the imminent U.S. action&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nif they had known about it in advance. Further, it would have been reasonable&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfor the United States to question Pakistan&rsquo;s capacity to successfully raid Bin&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nLaden&rsquo;s compound, given that he was known to be a highly sophisticated and likely&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwell-protected enemy.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Pakistan might argue that it would have been able to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstage an effective mission against the compound, or that the United States at&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nleast should have constructed the mission as a joint operation, given that the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntwo countries work closely together in other intelligence and military&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncontexts. It also could point to the fact that it conducted searches for al&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nQaeda leaders in Abbottabad in 2003 and in subsequent years, and that it passed&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\non information about the 2003 search to U.S. officials. On balance, however,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPakistan&rsquo;s defence of its sovereignty in this case, while understandable from a&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npolitical perspective, seems weak as a matter of international law.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The facts and politics in this case make it unlikely&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthat Pakistan&rsquo;s defence of its sovereignty will find significant international&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsupport. Nevertheless, it would be useful as a matter of international law for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstates to agree that the unwilling or unable test is the correct test for&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsituations such as the U.S. raid against Bin Laden in Pakistan and to provide&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nadditional content to that test. Doing so potentially could serve international&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlaw&rsquo;s interests by minimizing legal disagreements at times when political and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfactual disagreements are running high.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Balakot Air Strikes : India&rsquo;s response to&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPulwama Attack&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;On 14 February 2019, a dastardly terrorist attack was&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncarried out on India&rsquo;s security personnel, in the Pulwama district of Kashmir.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThe Jaish-e-Mohammed (JeM), a United Nations (UN) designated terrorist&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\norganization, claimed responsibility for the attack. The Pulwama attack is the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlatest in a long list of attacks, attempted or executed, by the same terrorist&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\noutfit against Indian soldiers and civilians in Kashmir and elsewhere.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;On the morning of 26 February 2019, the Foreign&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSecretary, Ministry of External Affairs, Government of India issued a statement&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nclaiming that a &lt;b&gt;&ldquo;non-military pre-emptive action&rdquo; &lt;/b&gt;was undertaken by the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndian Air Force against a military camp of the JeM located in Balakot,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPakistan.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;India&rsquo;s actions have infused life into several debates&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrelating to &lt;i&gt;jus ad bellum &lt;/i&gt;as well as&lt;i&gt; Jus in Bello&lt;/i&gt;, especially&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwith respect to South Asia and non-state actors (NSAs), which hitherto were&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmerely academic in nature. This paper seeks to analyse India&rsquo;s official&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstatement, released shortly after the strikes on the JeM camp in Balakot, and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntackles two broad points of discussion arising from the wording of the official&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstatement :-&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;- &lt;i&gt;Firstly,&lt;/i&gt; the concept and relevance of the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nterminology &ldquo;non-military preemptive action&rdquo; employed by India in its official&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nstatement;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;- &lt;i&gt;Secondly&lt;/i&gt;, a state&rsquo;s right of self-defence&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nagainst non-state actors, operating out of the territory of another state, and&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndia&rsquo;s legal position on the same.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Non-military Action&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The use of the term &ldquo;non-military&rdquo;, in India&rsquo;s&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nofficial statement deserves some attention. After careful scrutiny, it can be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsupposed that such terminology seeks to serve three purposes:&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;- &lt;i&gt;Firstly,&lt;/i&gt; it seeks to clarify that the target&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the attacks was an NSA, and not the military or the civilian population of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nPakistan. This clarification manifests India&rsquo;s position that the air strikes&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsought to simply destroy the terror camps of JeM, without delving into&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nquestions of attribution and state responsibility of Pakistan for the acts of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe NSA operating from within its territory.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;- &lt;i&gt;Secondly, &lt;/i&gt;the terminology seeks to pre-empt&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand counter any arguments on the initiation of an international armed conflict&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbetween India and Pakistan through the argument that there was no engagement&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbetween the armed forces (or militaries) of the two States.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;- &lt;i&gt;Finally,&lt;/i&gt; irrespective of the initiation of an&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninternational armed conflict, declaring the specificity of the attack in the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nofficial statement (&ldquo;this non-military pre-emptive action was specifically&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntargeted at the JeM camp&rdquo;), and focusing on avoiding civilian casualties tries&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto reflect India&rsquo;s compliance with the Geneva Conventions, specifically the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprinciple of discrimination.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The phrase immediately succeeding &ldquo;non-military&rdquo; i.e.&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;preemptive action&rdquo;, however, raises issues of its own.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;Pre-emptive Action&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;The genus of the inherent right of self-defence under&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nArticle 51 is not devoid of its own species. There are three possible scenarios&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin which the right of self-defence may get triggered. These scenarios may be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunderstood in the form of a continuum. On the restrictive end, is the literal&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nunderstanding of Article 51 which relies upon the phrasing&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot;Times New Roman&quot;,serif&quot;&gt;&ldquo;&hellip;if an armed attack occurs&hellip;&rdquo;&lt;/span&gt;&lt;/i&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif&quot;&gt;&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;and triggers a State&rsquo;s right of self-defence only&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nafter an &lsquo;armed attack&rsquo; has already been carried out against it. This restricts&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nself-defence to merely a reactive right.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;In the middle lies the concept of &lsquo;anticipatory&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nself-defence&rsquo; which states that the right is not just reactionary in nature,&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbut also exists in the face of palpable and imminent danger. On the other end&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof the continuum is the right of &lsquo;preventive self-defence&rsquo;, which may even be&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninvoked to prevent vague future attacks. There exists a crucial line of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndistinction between the two concepts.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;While anticipatory self-defence recognises the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexistence of the right in the face of a manifestly specific and imminent&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nattack. The concept of preventive self-defence does not seek to rely on any&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconcrete threat of an armed attack, and operates in the realm of contingency&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand conjecture (eg. Japan&rsquo;s attack on Pearl Harbour). It is beyond debate that&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreactionary self-defence or self-defence simpliciter has a firm grounding in&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninternational law. The right of &lsquo;anticipatory self-defence&rsquo; has also, over&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntime, received recognition to some extent. However, &lsquo;preventive self-defence&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas found few supporters.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Interestingly, the phrase &lsquo;pre-emptive self-defence&rsquo;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas also been employed by multiple States and publicists. The phrase has seen&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ninconsistent application through synonymous and interchangeable usage with both&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lsquo;anticipatory&rsquo; &lt;i&gt;(Brownlie&rsquo;s Principles of Public International Law, ed. James&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCrawford, p. 750-752)&lt;/i&gt; as well as &lsquo;preventive&rsquo; self-defence. Such&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnon-uniform use of &lsquo;pre-emptive self-defence&rsquo; by international actors further&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncomplicates an already complex understanding of self-defence.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;India&rsquo;s official statement mentions that the&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;pre-emptive&rdquo; strikes were undertaken &ldquo;in the face of imminent danger&rdquo;, which&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwas based on credible intelligence that the JeM was planning another terror&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nattack against the country. It is argued that the usage of the phrase&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&ldquo;pre-emptive strikes&rdquo; hovers between two variations of the right of&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nself-defence &ndash; anticipatory and preventive. Such phraseology seems to conflate&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe right of &lsquo;anticipatory self-defence&rsquo; with the arguably unrecognised&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lsquo;preventive right of self-defence&rsquo;, and begets ambiguity regarding India&rsquo;s&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nofficial legal stance on the Balakot strikes.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot;Times New Roman&quot;,serif&quot;&gt;Furthermore, solely relying on the phrase &ldquo;imminent&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndanger&rdquo;, in the absence of any concrete evidence of the imminent threat, not&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nonly leaves the lawfulness/legality of the air strikes in doubt, but also fails&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto clear the confusion highlighted in the previous paragraph.&lt;o:p&gt;&lt;/o:p&gt;&lt;/span&gt;&lt;/p&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&', '0027fa27bb49baed74783852500fc127.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 20:59:03', '2020-12-23 02:52:32');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(48, 'M4i6fY8qXEjkJ04YNaMT9KJXp', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'A note on Triple Talaq.   Mr. Mushtaq K.Lodi.  ', '&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;By Mr. Mushtaq K.Lodi,&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Professor of Law, Legal practitioner and author of&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;book &lsquo;Islam and The West - lodi_mk@yahoo.co.in&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;1. The country is currently embroiled over the triple&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Talaq controversy with the matter now reaching the apex level at the Honourable&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Supreme court and is slated to be resolved one way or the other finally. What&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;exactly is the issue all about? And why has it reached its present level of&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;frenzy?&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;To understand this one must have an understanding of the system of marriage and&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;divorce in Muslim Law and also take a brief peek at pre-Islamic history of&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Arabia.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;2. The Muslim system of marriage and divorce is very&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;different from the secular system of marriage and divorce as also other systems&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;of marriage and divorce of other religious communities world-wide.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;3. In the first place marriage in Muslims is a&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;contract and not a sacrament unlike other religious communities. The marriage&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;document or &lsquo;Nikahnama&rsquo; contains the essential elements of a marriage contract&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;according to Muslim Law to make it valid: Offer and acceptance (in one&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;sitting), consent, dower and witnesses from both sides.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;4. The problem is not with the marriage system as such&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;but with the controversial divorce system, in particular, the Talaq system of&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;ending a marriage. There are 5 types of Talaq and presently in the Supreme&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Court only 4 types of Talaq are being mentioned of which only the triple Talaq&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;is the subject-matter of dispute. Let us examine the Talaq system for a proper&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;understanding of it in Muslim Law and practice. The Talaq is a unilateral&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;divorce which operates from the husband to the wife and not the other way&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;around.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;5. Secondly, the husband need not give any reason for&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the Talaq. It is his power to do so at any time and without ascribing any reason&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;for it. All that he needs to do is to pronounce it. Thirdly, he need not say it&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;in the presence of the wife. It can be uttered even in her absence and is valid&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;from the time it is brought to her notice. Finally, no witnesses are required&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;for issuing Talaq.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;6. With all the above ingredients it is easy to&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;understand that the Talaq gives unfettered rights to a Muslim husband over the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;wife which is not available to any other husband of any other faith or secular&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;system.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;7. The first type of Talaq is the Talq-e-Ahsan in&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;which the husband utters Talaq once which is followed by mediation by&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;representatives of the wife and husband. At the end of three months(three&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;menstrual cycles)if the mediation does not succeed and if there is no&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;resumption of cohabitation, the marriage ends automatically and the wife stands&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;divorced without the intervention of the Court. This is also known as the &lsquo;most&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;approved&rsquo; form of Talaq.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;8. The second form of Talaq is the Talaq-e-Hassan&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;(&lsquo;approved&rsquo; form of Talaq). In this form of Talaq, the husband utters Talaq&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;three times, each pronouncement being made after a gap of one month with the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;usual mediation by both parties to abort the Talaq and at the end of the third&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Talaq, if the mediation does not work, the marriage ends, provided there is no&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;resumption of cohabitation. But the difference is that the couple cannot now&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;re-marry after the third Talaq. And to remarry the original husband, the wife&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;has to undergo a rather horrendous practice of marrying another man, getting&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the second marriage consummated and then getting divorced from the second&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;husband, waiting for the mandatory three-month iddat period and then only can&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;she re-marry the original husband. This system is called &lsquo;Nikah Halala&rsquo;&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;9. The third type of Talaq is the odious triple Talaq&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;which is the subject-matter of the dispute. In this form of Talaq the husband&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;utters Talaq three times in one session and the marriage ends immediately&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;without any mediation and without any waiting period. Remember, this he can do&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;even in her absence and without offering any reason. The other type of Talaq is&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the Talaq-e-Tafweez or the delegated Talaq in which the husband delegates the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;power to issue a Talaq on his behalf to someone else, even ironically, to his&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;wife, who can then exercise it and divorce herself from her husband!&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;There is yet another type of Talaq which has not even been mentioned in the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;dispute before the Supreme Court, and that is the conditional Talaq. In this&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;form of Talaq the husband attaches a condition, which, if fulfilled, renders&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the Talaq effective immediately. The condition may be one over which the wife,&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;or even the husband, may have no control over, and yet the wife becomes a&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;victim to it.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;10. Thus, these are the 5 types of Talaq that a Muslim&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;husband enjoys the right to invoke at his whim. Now let us examine the arguments in defense of such antediluvian practices put&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;forth by the AIMPLB (All India Muslim Personal Law Board): They argue that such&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;practices are part of the Shariah, the Islamic legal system that, according&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;them, is ordained by God and therefore, according to Islamic beliefs, no mortal&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;can change it. This is a smoke screen and not based on historical facts. All&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the above systems of Talaq, including the notorious triple Talaq and the other&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;forms of divorce, including &lsquo;Khula&rsquo; and the other much maligned practice &lsquo;Nikah&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Halala&rsquo; have been in practice in pre-Islamic Arabia in several tribes in the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;period termed as the &lsquo;Jahiliyah&rsquo; (age of ignorance) by the Islamists before 620&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;A.D. These practices, quite understandably, were incorporated by Islam in its&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;nascent stage. This view is also stated by the noted scholar of Islamic Studies&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Dr.Zeenat Shoukat Ali, among others. Unfortunately, for the serious historian,&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;there is very little information and very few sources available in Arabia on&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the pre-Islamic period or &lsquo;Jahiliyah&rsquo;. One has to ferret out information from&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;the few sources available to cull this information.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;11. Therefore, if such practices were present in&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Arabia in the pre-Islamic period and the Shariah merely incorporated them they&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;are not of Divine origin as argued by the AIMPLB. And therefore, they can be&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;modified, amended, even banned as deemed fit by the current generation.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Moreover, the Shias do not allow it. If one sect of Muslims can ban it and yet&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;remain Muslims then it obviously is not so sacrosanct that it cannot be&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;removed.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;12. Even the much touted system of divorce&mdash;the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lsquo;Khula,&rsquo; which the Islamist apologists vociferously argue that it gives Muslim&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;women the right to divorce, is actually misleading. Khula is a form of divorce&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;initiated by the wife no doubt, but then it becomes effective only if the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;husband accepts her offer. And to induce the husband the wife has to offer a&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;consideration in the form of foregoing her dower in part or fully for him to&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;find it acceptable. Otherwise the Khula does not operate. It is actually a&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;system of divorce in which the Muslim wife purchases her freedom. Thus, even&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;here, the husband holds the key.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;13. In conclusion, as can be seen the scales are&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;tilted heavily in favour of the husband in the Muslim legal system. Such&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;unfettered power to divorce a wife under any form of Talaq is directly an&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;assault on Article 14, in particular, against exercise of arbitrary action as&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;enunciated by the Supreme Court in E.P.Royappa vs. The State of Tamil Nadu in&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;1974. Muslim women are in urgent need of help to deal with such patriarchal&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;systems. More so, since they are not likely to get help from within the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;community, as can be seen in the stance taken by the AIMPLB and their ilk.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Therefore the onus shifts onto the State and the social community at large to&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;help restore parity between the genders in the Muslim community.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;14. In fact there already a readymade remedy available&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;for the Supreme Court in the form of the Delhi High Court judgment in Masroor&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Ahmed Vs State of Delhi, 2007 in which the Honourable Judge decreed that the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;tripe Talaq, if uttered, is to be treated as a single Talaq to be followed by&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;mediation and it becomes effective only after the mandatory 3-month waiting&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;period. All that the Supreme Court needs to do, is to uphold this judgment and&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;give it its stamp of approval and the matter of the tripe Talaq can be resolved&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;in a simple and expeditious manner. However, the larger issue of gender parity&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;remains. A system in which the husband enjoys unfettered rights of divorcing&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;his wife without ascribing any reason or cause, and worse still, even in her&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;absence has to be done away with.&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;15. Does the Government and the Judiciary have the&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;courage to ban the iniquitous, unfair, arbitrary, capricious and gender-biased&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;system of Talaq itself?&lt;/span&gt;&lt;/h4&gt;&lt;h4&gt;&lt;br&gt;&lt;/h4&gt;', '32a22cd04c415b6dd93026f2dc3f310e.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:00:26', '2020-12-31 04:46:41');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(49, 'PnFr1GHnBDzKibgJGL7zDwaND', 'TSUhvAg9KIuGOC5DrA7yLvekJ', ' A STUDY OF THE HINDU CODE BILL WHETHER UCC SHOULD COME INTO EXISTENCE OR NOT.  C.Sai.Sumana.  ', '&lt;h4&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;By- C.Sai.Sumana, 2nd Year BBA-LLB, Symbiosis Law&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nSchool, Hyderabad.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;ABSTRACT:&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThere were several Hindu laws which got codified from the Hindu personal laws&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nin 1950&rsquo;s. as there were different views from various Hindu politicians and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmany Hindu politics. They have come to a concept of the Hindu code bills. The&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthen rulers have tried to implement a one single law Uniform Civil Code for all&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe personal laws, but Pandit Jawahar Lal Nehru, while safeguarding the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npresentation of the Hindu Code Bill rather than a uniform common code, in the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nParliament in 1954, said &quot;I don&#039;t imagine that at the present minute the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntime is ready in India for me to attempt to implement it&quot;. So the Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlaw only got codified during that time. This paper would focus on the various&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nHindu code bills like adoption act, succession act, Hindu marriage act, etc.,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthis paper would also further discuss about the difference between other&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npersonals laws and Hindu codified law and its comparative analysis. This paper&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwould also showcase the need for Uniform Civil Code as some personal laws are&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncodified and some are not. It would also explain how hindu law is better than&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nother personal laws. It would also give a conclusion with self opinion.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;RESEARCH METHODOLOGY&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;SCOPE AND OBJECTIVES OF THE STUDY&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&bull; The scope and objective of this paper is to analyze the different Hindu Code&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBills.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&bull; To further discuss about the other personal laws in comparison with the Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCode Bills.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&bull; A brief discussion on Uniform Civil Code&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;RESEARCH METHODOLOGY&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThere are two types of methods.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\no Primary data&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\no Secondary data.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;To study this project I have used both primary and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsecondary data where, the primary data is the direct source and secondary data&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis by internet source, books, journals etc.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\no I have used the class room teaching ideas as my primary source Matter&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncollected from web and books is my secondary source.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;RESEARCH QUESTIONS:&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThis paper would answer the questions:&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;1. How better is a codified law from other personal&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlaws? Example, Hindu codified law.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;2. Whether there is a need for uniform civil code or&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot?&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nHow better is a codified law rather than other personal laws?&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;The personal law framework has for a considerable&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlength of time been, and remains, a particular distinctive form of pluralist&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nIndian legitimate culture. Personal laws involve an extraordinary position in&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntoday&#039;s age and assume essential part in keeping the general public inside&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngood, civil and moral limits . The Hindu personal law is one of the best laws&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nas it is now codified for four major religions like Jainism, Buddhism, Sikhs&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand Hindus. the Hindu Law established as it is on Vedas and Smrti writings, is&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nconsidered by many individuals as of divine origin holy and unchanging and not&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto be deliled by sacriligious hands. The hindu code bills are a combine of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nseries of laws which were passed in 1950&rsquo;s. The formers of these laws are the then&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nprime minister Jawaharlal Nehru and Dr. B.R.Ambedkar. during the British times&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthere was committee formed to prepare a bill which abolished joint family&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nproperty, polygamy etc., from the society. Later after 1948 the law commission&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhas drafted a bill with eight parts in it, which spoke about: who is a Hindu,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmarriage, adoption, guardianship, join family property which included property&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nto women, succession and maintenance. all these contained 55 clauses together&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nand they named it as one bill that is the &lsquo;Hindu code bill&rsquo; but when national&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncongress party has won Nehru split this hindu code bill into various bills and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\npassed them as succession act, hindu marriage act, hindu adoption act, hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nguardianship act, Hindu maintenance act etc.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThere was a great deal of restriction to this hindu code bill and an Anti-Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nCode Bill board was framed in 1949. The Anti-Hindu-Code-Bill Committee was&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ngiven support by many lawyers and by moderate ministers. Through 1950 and 1951,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nNehru and Ambedkar made a few endeavors to get the Hindu Code Bill go into law.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nBut still, the restriction was extensive, both inside Parliament and outside&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nit.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;At present: till today only the Hindu law only the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nHindu law is codified among all the personal laws. Hindu codified law says that&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nist is applied only for Hindus and a Hindu is other than a Muslim, parsi and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nJews . The Hindu marriage act explains the details who is a Hindu, Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmarriage, nullity of marriage and divorce, jurisdiction and procedures about&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe family courts. The Hindu adoption act deals about: adoption, maintenance,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndependants, maintenance when to be a charge. The Hindu minority and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nguardianship act contains about who is a guardian, natural guardian,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ntestamentary guardian, minor, de facto guardian, welfare of minor. The Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsuccession act contains, who is a successor, who can get the property, who will&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nnot inherit the property etc. there are several upcoming laws Hindu joint&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfamily, family courts etc. on comparison of these laws with Muslim, parsi and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nChristian laws, till today those laws are not codified and there are some back&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndraws in them. The Christian law has 88 sections but still does not cover all&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe laws. The muslim law is not a codified law, when compared with the Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nlaw it has got most of the diffical provisions and discriminatory provisions in&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nit. the muslim law is different for sunni and shia . Bigamy, polygamy are still&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexists in muslim law, which is not a fair provision. This also disturbs or&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ndegrades the social and moral behaviors of other religions. This law is a kuran&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nadopted and is still being continued as a religious law. The Christian does not&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nhave the provisions of succession and marriages, it only has the procedure for&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nmarriage. For any such disputes, they rely upon Indian succession act, Indian divorce&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nact, special marriage act, etc. therefore these laws prove that a codified law&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nis much better than all other personal laws. The Hindu law is applicable to&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthose who have no religion. It considers such a person as a Hindu as Hindu&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nreligion is the major religion in the country.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Whether there is a need for Uniform Civil Code or not?&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nThe appropriation of a uniform civil code is a constitutional and goal . Every&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nState which has any claim to acculturated statute has or plans to have a&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nuniform Civil Code to oversee its natives. Such a Code is the anger of the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncircumstances and the mold of present day majority rules systems. Be the sort&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe American, the European or the Asiatic, each illuminated Government looks to&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrearrange and blend its laws of individual and property into an example of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nuniformity and harmony which can stand the test of time and fulfill the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrequests of equity and justice. In a nation like India which amid a progression&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nof hundreds of years had come to be the home of various groups of various&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nraces, statements of faith and culture, the populace now comprises of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nheterogenous areas whose personal laws, religion and feelings are so&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nexceptionally unique that unless each endeavor is made strenuously and without&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\na moment&#039;s delay to find and accentuate the purposes of agreement between them,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nonly then they can form a uniformity. In India the main problem arises when&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthere is different law for different people. the criminal always wants to&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncommit crime by changing religions and committing fraud, he may commit polygamy&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwhen he gets converted into Islamic religion, therefore there must be only one&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nsingle law for all the religions. Uniform civil code is also the best&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nadvantaged weapon to resolve the dispute between communities.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Other than having one single law this uniform civil&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\ncode will develop a consciousness among the societies and individuals. All the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwomen who have discriminatory laws as per their own respective personal laws&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nwill get a uniform platform where equity is shown. The uniform civil code is&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nthe better codified law for all the personal laws as we have already seen the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nbenefits of a codified law . there are some other cases which indicates the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nrequirement of uniform civil code like, in the case of Sayeda Khatoon&rsquo;s case :&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;', '41d3c2e2b1af44ac3813dc2e7416f977.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 0, NULL, NULL, '2020-12-01 21:01:23', '2020-12-30 17:15:30');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(73, 'Fmbzn5USSwiFE4o7tLNroGvHs', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Creamy Layer.  S. Basavaraj. Advocate. Bangalore ', '&lt;p class=&quot;MsoNormal&quot; style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Is it a real war between forward and well-educated&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;SC/ST vs poor and less fortunate SC/ST? Who will protect the really backward&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;SC/ST against their own superiors?&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;refer to the relatively forward and better educated members of the backward&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;community who are not eligible for government-sponsored educational and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;professional benefit programs and jobs. This test was hitherto not extended to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Scheduled Caste and Scheduled Tribes. This means howsoever economically&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;well-off, howsoever politically powerful, howsoever forward and better educated&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;they may be, the persons/children/family members of Scheduled Caste and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Scheduled Tribe were eligible to claim reservation. The resultant position is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;among the SC/ST category only the rich, well educated members would take all&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the opportunities depriving their poor and less educated brothers/sisters. A&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;SC/ST from village could never ever compete with SC/ST from urban elite. The&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;urban candidates are taking all the opportunities. This is the unproclaimed war&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;between rich &amp;amp; powerful SC/ST vs poor and less fortunate SC/ST.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;bench judgment of the Supreme Court in Ashoka Kumar Thakur v. Union of India, (2008)&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;6 SCC 1. The relevant para says;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;principle is introduced merely to exclude a section of a particular caste on&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the ground that they are economically advanced or educationally forward. They&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;are excluded because unless this segment of caste is excluded from that caste&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;group, there cannot be proper identification of the backward class. If the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&ldquo;creamy layer&rdquo; principle is not applied, it could easily be said that all the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;castes that have been included among the socially and educationally backward&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;classes have been included exclusively on the basis of caste.&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Court in Jarnail Singh &amp;amp; ors vs Lachhmi Narain Gupta and others, Special&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Leave Petition 30621/2011 decided on 26 September 2018 held that the Creamy&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;layer test must be applied to Scheduled Caste and Scheduled tribe also the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;reason is as follows.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;backward classes of citizens move forward so that they may march hand in hand&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;with other citizens of India on an equal basis. This will not be possible i&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;only the creamy layer within that class bag all the coveted jobs in the public&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;sector and perpetuate themselves, leaving the rest of the class as backward as&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;they always were.&rdquo;&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;only promotion or it applies to initial appointment also. There is also some&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;doubt as to if by applying creamy layer test if forward SC/ST are eliminated,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the posts will go to general category (which according to me should not happen)&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;in arms against Supreme Court judgment, seeking review or another&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;constitutional amendment to remove the basis of the Judgment. When I asked few&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;members of the Community will this move not actually against the poor and less&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;fortunate SC/ST brethren, they are silent. Our intellectuals and those who&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;support creamy layer must realise that it is not SC/ST war against the General&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;category, it is the fight by rich and powerful SC/ST against poor and less&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;fortunate SC/ST.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;The poor and less fortunate SC/ST brethren have finally got a chance to compete&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;with forward, powerful SC/ST. They must also be protected. Unfortunately there&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;is no one to educate and explain the situation let alone support them in the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;forthcoming legal fight.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Creamy Layer is the word used in Indian politics to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;However, this principle was upheld by the constitution&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;170. It is to be understood that &ldquo;creamy layer&rdquo;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;However, another Constitution Bench of the Supreme&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&ldquo;The whole object of reservation is to see that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;There is some doubt as to whether the judgment applies&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;As expected, the Cream Layer of SC/ST members are up&lt;/span&gt;&lt;/p&gt;&lt;/p&gt;<br />\r\n&lt;br&gt;', '62404045d47fed60757d04874c3431e9.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:57:52', '2021-01-29 00:18:50'),
(74, '1qSnNNlMjDHYs0GX09squ3lNu', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Cryptocurrencies and their Regulation in India.   Dishan Srinivasa Rao.', '&lt;p&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Dishan Srinivasa Rao, J.D. Candidate, Class of 2020&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;University of California, Davis School of Law, USA&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;being talked about in the news. But what exactly is a cryptocurrency? And why&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;are countries like India starting to curb down on their use? Through this&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;article, I will try to touch upon these questions. For that purpose, I have&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;divided this article into three parts. In the first part, I have described what&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;cryptocurrency and their functionality is. In the second part, I shall analyze&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the pros and cons of using cryptocurrencies. And finally, in the third, I will&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;discuss the intended regulation of cryptocurrencies in India.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;state all over the globe. India has currently created a government committee to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;finalize on a law regarding the cryptocurrencies [also referred as &lt;/span&gt;&lt;i style=&quot;font-size: 12pt;&quot;&gt;crypto&amp;nbsp;&lt;/i&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;in this article]. And the draft bill by the committee indicates some serious&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;punishments for the trade or use of cryptos. Therefore, I intend this article&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to introduce the reader to some important facts to determine for themselves the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;appropriateness of the suggested regulations.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;blockchain technology. Therefore, by understanding the functionality of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;blockchain, one can understand its application as a cryptocurrency.&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;ledger. This means, that the ledger exits [digitally] without any one person or&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;an entity controlling or maintaining it. A centralized ledger, on the other&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;hand, would be a bank. The bank makes sure that the transactions are&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;authenticated to be processed and carried out.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;your bank becomes the middle man between the two parties and authenticates&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;whether you have sufficient savings in your account to transfer the money to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the restaurant. As one knows, for using the account in the first place there&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;are some transactional costs that bank pushes on you, as a transaction fee.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;These fees could be in different forms, but, usually, the transaction fees are&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;collected for the bank to run smoothly and conduct its duties as the middle&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;man.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;gets rid of the middle man. The blockchain does the duties of the middleman,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and wherein the people who use the cryptocurrency (and who are on the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;blockchain) automatically verify each such transaction that takes place.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Therefore, the name decentralized ledger.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;digital information stored in a public database, a.k.a. the chain. To&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;illustrate further, a blockchain is the ledger, and the blocks are like ledger&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;entries. Each block holds thousands of verified transactions. And each block&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;has its own unique identification.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the transaction is verified. Since it is a digital currency, millions of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;computers rush in to check and confirm the details of the purchase, including&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the transaction&rsquo;s time, dollar/rupee amount, etc. After verification, the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;transaction will join hundreds of others like it in the block.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;verified, the block is given a unique, identifying code called a hash. Once&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;hashed, the block can be added to the blockchain.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;becomes publicly available for anyone to view.&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;b&gt;&lt;u&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nfont-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Cryptocurrencies&lt;/span&gt;&lt;/u&gt;&lt;/b&gt;&lt;br&gt;&lt;/p&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Impossible&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;to conduct fraudulent transactions&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;protocols that make transactions secure and almost impossible to fake.&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Benefits&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;of decentralized currency&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;cryptocurrencies are not controlled by any central authority, like RBI or the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;government. Therefore, the decentralized nature of the cryptocurrencies makes&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;them immune to the old ways of government control and interference.&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;No&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;transaction fees&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;transactions, for transfers are simplified through the use of public and private keys for security and privacy purposes. These transfers can be done with minimal processing fees, allowing users to avoid the steep fees charged by traditional financial institutions.&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Removal&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;of Dollar as the global currency&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;global crypto is that it could replace the use of Dollars in international transactions. money back home would lose out around 7% in the transfer. The same transaction would cost fractions less when the transfer would take place through a cryptocurrency. One has to keep in mind that the amount saved would be 7% of $80 billion dollars, which is the total amount of remittances that are sent to India. transactions, the global dominance of the US would get distributed worldwide. It would, therefore, an important agenda for governments worldwide to consider and act upon with solidarity.&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Highly&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;speculative&lt;/b&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;instability in their values. During December 2017, Bitcoin was trading at almost 20,000$/coin, but, soon the price dropped down to almost 10,000 $/coin within the matter of few months. Since the crypto is not linked to any fiat currency and since there are a limited number of bitcoins, the trading and using it as a short term investment has become highly risky. cryptocurrencies are now being used. Libra is a stable cryptocurrency soon to be introduced by Facebook. Libra like other stable currencies is linked to multiple currency investments around the world, for the purposes of maintaining a predictable and stable value of the crypto.&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;ul style=&quot;margin-top:0cm&quot; type=&quot;disc&quot;&gt;&lt;li class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 0.875rem;&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;Cryptocurrency&amp;nbsp;&lt;/span&gt;&lt;/b&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 0.875rem; line-height: 107%;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;b&gt;used for money laundering&lt;/b&gt;&lt;/span&gt;&lt;/span&gt;&lt;/div&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 0.875rem;&quot;&gt;one of the major concerns indicated by the Indian governments and others globally. Firstly, as I mentioned above, no party is anonymous is conducting transactions through Bitcoin or other cryptocurrencies as the ledger is available for the public to view. The conversion of black money to a crypto would be available for the authorities to view if they decide to. All they have to do is to match the user&rsquo;s identification in the block to the digital wallet that is owned by the user locally. Obviously there are more sophisticated in washing the black money through cryptos. I have attached the link below for anyone interested in reading about such a process. &lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;a href=&quot;https://www.facebook.com/groups/1004611326222954/#_ftn1&quot; style=&quot;font-size: 0.875rem;&quot;&gt;[&lt;/a&gt;&lt;/span&gt;&lt;/div&gt;&lt;/li&gt;&lt;/ul&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;u style=&quot;font-size: 14px;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;line-height: 14.98px;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;span style=&quot;font-weight: bolder;&quot;&gt;India&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/u&gt;&lt;p&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lt;span style=&quot;font-size: 14px;&quot;&gt;started to regulate the free trade of cryptocurrencies. These regulations are to mitigate the dangers mentioned above. Indian government is shaping up its regulations to restrict almost all transactions of cryptocurrencies. This is myopic in my opinion. exchanges that buy and sell cryptocurrencies. In that way, the government can keep a track on what kind of money is being used to buy the cryptocurrency.&amp;nbsp;&lt;/span&gt;framework for cryptocurrencies, the Reserve Bank of India (RBI) has advised&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;caution on their use and has issued three notifications that &ldquo;cautioned users,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;holders and traders on the risk of these currencies and clarified that it has&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;not given any license or authorization to any entity or company to operate such&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;schemes or deals.&rdquo;. RBI has held that cryptocurrencies are not considered legal&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;tenders in India. Cryptocurrency exchanges where one can exchange their Rupees&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to cryptocurrency like bitcoin are legal; however, the government has made it&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;very difficult for them to operate.&lt;/span&gt;&lt;/p&gt;&lt;/p&gt;&lt;/span&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;br&gt;&lt;/div&gt;&lt;span style=&quot;font-size:12.0pt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\nline-height:107%;font-family:&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 12pt;&quot;&gt;cryptocurrencies in India&lt;br&gt;&lt;/b&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;tax status of cryptocurrencies, the chairman of the Central Board of Direct&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Taxation has said that anyone making profits from Bitcoin will have to pay&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;taxes on them. Other Income Tax Department sources have suggested that&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;cryptocurrency profits should be taxed as capital gains.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;grown increasingly harsh. While technically legal, in April 2018 the Reserve&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Bank of India (RBI) banned banks and any regulated financial institutions from&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&ldquo;dealing with or settling virtual currencies&rdquo;. The sweeping regulation&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;prohibited the trade of cryptocurrencies on domestic exchanges &ndash; and gave&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;existing exchanges until 6 July 2018 to wind down.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;in implementing the banning of cryptocurrency bill- the source of money being&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;used to trade in cryptocurrencies and regulations of cryptocurrencies to&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;protect the common man. For that purpose, an interdisciplinary committee,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;chaired by the Special Secretary (Economic Affairs), was established in April&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;2017.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;legislation called The &quot;Banning of Cryptocurrency and Regulation of&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Official Digital Currency Bill 2019&quot;. The bill has still not been made&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;public, however, multiple news agencies through verified sources have stated&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;that the bill would include 10 years jail for anyone trading, selling, buying or&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;dealing in cryptocurrency. Furthermore, the bill makes holding cryptocurrencies&lt;/span&gt;&lt;/p&gt;&lt;/span&gt;&lt;span style=&quot;line-height: 107%; font-size: 16px;&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;br&gt;&lt;/div&gt;&lt;/span&gt;&lt;p&gt;&lt;/p&gt;', 'b4f4f15e53e503cc4bf90fd37886e89f.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 22:00:27', '2021-01-29 00:09:24');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(75, 'oias9rXmG3sizzgOQo3hHsvGu', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Online cyber stalking Critical Study.    S.Selvakumari. ', '&lt;p class=&quot;MsoNormal&quot; style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;b&gt;&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;h2 style=&quot;text-align: center; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;b&gt;Online/cyber stalking: Critical Study&amp;nbsp;&lt;/b&gt;&lt;/span&gt;&lt;/h2&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;text-align: center; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/p&gt;&lt;p class=&quot;MsoNormal&quot; style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Stalking is any repeated and unwanted contact with you that makes you feel unsafe. You can be stalked by a stranger, but most stalkers are people you know even an intimate partner. Stalking may get worse or become violent over time. Stalking may also be a sign of an abusive relationship.&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Someone who is stalking you may threaten your safety by clearly saying they want to harm you. Some stalkers harass you with less threatening but still unwanted contact. The use of technology to stalk, sometimes called &ldquo;cyber stalking,&rdquo; involves using the Internet, email, or other electronic communications to stalk someone. Stalking is against the law.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Cyberstalking is stalking or harassment carried out over the internet. It might target individuals, groups, or even organizations and can take different forms including slander, defamation and threats. Motives may be to control or intimidate the victim or to gather information for use in other crimes, like identity theft or offline stalking. While blame shouldn&rsquo;t be placed on cyber stalking victims, the current online landscape lends itself to creating &ldquo;easy targets.&rdquo; For example, nowadays, many social media users think nothing of publicly posting personal information, sharing their feelings and desires, publishing family photos and more.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b&gt;What is cyberstalking?&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;As mentioned, cyber stalking can take many different forms, but in the broadest sense, it is stalking or harassment that takes place via online channels such as social media, forums or email. It is typically planned and sustained over a period of time.&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Cases of cyber stalking can often begin as seemingly harmless interactions. Sometimes, especially at the beginning, a few strange or perhaps unpleasant messages may even amuse you. However, if they become systematic, it becomes annoying and even frightening.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;For example, if you&rsquo;ve received a few negative comments on Facebook and Instagram, it may upset or annoy you, but this isn&rsquo;t cyber stalking yet. For some people, such as semi-celebrities looking for attention, negative comments are actually welcomed.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;However, once you start receiving unwanted and annoying messages repeatedly and feel harassed, then the line has likely been crossed. Cyber stalkers might terrorize victims by sending unpleasant messages systematically, perhaps even several times a day. It is especially unnerving when such messages come from different accounts managed by the same person. It is probably a good idea to report this to both the website owners and law enforcement agencies.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Cyber stalking doesn&rsquo;t have to involve direct communication, and some victims may not even realize they are being stalked online. Perpetrators can monitor victims through various methods and use the information gathered for crimes like identity theft. In some cases, the line between cyberspace and real life can become blurred. Attackers can collect your personal data, contact your friends and attempt to harass you offline.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 16px;&quot;&gt;Examples of cyber stalking include:&lt;/b&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Sending unwanted, frightening, or obscene emails, text messages, or instant messages (IMs)&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Harassing or threatening you on social media&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Tracking your computer and internet use&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Using technology such as GPS to track where you are&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;How to avoid cyberstalking?&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;As with many things in life, it&rsquo;s better to be proactive than reactive when it comes to cyber stalking. Becoming a victim will be far less likely if you follow our five simple tips below. These guidelines will enable you to enjoy all the benefits of online communication while remaining completely safe.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;1) KEEP A LOW PROFILE&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Keeping a subdued online existence is tough for some people, especially those who need to use online platforms for self-promotion or business-related activities. However, many users could benefit from toning things down a little. You should always avoid posting personal details such as your address and phone number, and think carefully about revealing real-time information such as where you are and who you&rsquo;re with.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;In an ideal world, you would avoid using your real name in online profiles. While this is difficult for anything work-related, it&rsquo;s quite feasible for things like forums, message boards and certain social media accounts. For example, you can use a nickname on Instagram or Twitter.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;If you must maintain your real name and photo, be very wary about whom you accept connection requests and messages from. If it&rsquo;s not a friend, relative or colleague, do some checks before moving forward.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;In some cases, it&rsquo;s almost impossible to avoid revealing personal information and connecting with people you don&rsquo;t know, for example, on dating websites. Unfortunately, these are popular with scammers, and you may even end up chatting with a potential cyberstalker. For this reason, it&rsquo;s best to stick with reputable sites, do some research about a suitor before revealing personal information or meeting in person and report any activity that makes you feel uncomfortable to the site&rsquo;s administrators.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;2) UPDATE YOUR SOFTWARE&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Keeping your software up-to-date may not be the first thing that springs to mind when you think about cyber stalking prevention. However, regular software updates are crucial when it comes to preventing information leaks. Many updates are developed to patch security vulnerabilities and help ensure your information remains safe.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;They are especially important for mobile devices which contain valuable data and track your exact location. There are numerous cases in which cyberstalking begins when an attacker pays someone to hack your email or phone and uses the gathered information against you. Such, protecting yourself from hackers is key to cyber stalking prevention.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;3) HIDE YOUR IP ADDRESS&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Many applications and services reveal your IP address to the person with whom you&rsquo;re communicating. This may seem unimportant, but this information is directly related to your personal data. For example, your IP address is linked to the internet bill that is sent to your home and which you pay with your credit card. Cyber stalkers can begin with your IP address and use it to find your credit card data and physical address.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;To mask your IP address you can use a Virtual Private Network (VPN). This hides your real IP address and replaces it with from a location of your choice, so you could even appear to be in a different country. It also encrypts all of your internet traffic, keeping it safe from the prying eyes of hackers.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Another option is to use the Tor browser. This also encrypts your traffic, although it may raise flags for law enforcement agencies as it&rsquo;s commonly used by criminals themselves. For the ultimate in privacy and anonymity, you can combine Tor and a VPN. Note that it&rsquo;s not recommended you use a web proxy or a free VPN service, as these can often harm your online security more than they help it.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;4) MAINTAIN GOOD DIGITAL HYGIENE&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lsquo;Digital hygiene&rsquo; is a new term but represents a very important topic, especially with regard to social networks. Maintaining good digital hygiene helps protect you from cyber harassment, cyber bullying and cyber stalking.Adjusting privacy settings is one of the first steps you can take to &ldquo;clean up&rdquo; your accounts. Most social media platforms and some other types of online accounts will let you adjust who can see your profile and contact you.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;It&rsquo;s also a good idea to keep things like your timelines, feeds and message threads free from negative comments. Aside from potentially fueling more negativity from others, these can have a significant emotional impact when you re-read them. For example, psychological support is regularly provided to website moderators, as they seriously suffer from reading aggressive messages, even those that aren&rsquo;t sent to them personally.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Social media hygiene is especially important for girls and women. Studies show that although the majority of internet attacks are aimed at men, cyber stalking, in particular, is mostly aimed at women.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;5) AVOID DISCLOSING SENSITIVE INFORMATION&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Surprisingly, many people constantly share personal information about themselves, even outside of social media platforms. By filling out questionnaires or submitting applications for coupons, you are increasing the likelihood of someone getting their hand on your personal data and possibly making cyber stalking more accessible.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b&gt;What to do in case you are being cyber stalked&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Block the person&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Don&rsquo;t hesitate to apply all measures permitted by law, especially those offered by web services. If the tools are there, block anyone who you wish to stop hearing from, even if these messages are just annoying and not yet threatening. Only you can decide when this boundary has been passed.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Report to the platform involved&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;If someone is harassing or threatening you, you should block them immediately and report their behavior to the platform involved. Twitter, Facebook, LinkedIn,and many other platforms have created easy-to-use buttons to quickly report abusive behavior.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Even if you think you are rid of the perpetrator, they may come back or pursue more victims. Law enforcement agencies do not always have the technical ability to protect you from cyberstalking, but platform moderators usually respond quickly and delete attackers&rsquo; profiles.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Call the police&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;If you believe their behavior is illegal or you fear for your safety, then you should contact the police and report the cyber stalker. Even if you don&rsquo;t have enough information or evidence for them to prosecute immediately, the report will go on record and the police can offer advice about what to do if the perpetrator persists.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b&gt;LEGAL PROVISIONS ON CYBER STALKING AND ONLINE HARASSMENT&lt;/b&gt;&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;PUNISHMENT FOR CYBER STALKING AND ONLINE HARASSMENT UNDER THE INDIAN PENAL CODE&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 354 D of the Indian Penal Code which was added by the Criminal Law (Amendment) Act 2013 specifically proscribes the act of stalking as Whoever follows a person and contacts, or attempts to contact such person to foster personal interaction repeatedly, despite a clear indication of disinterest by such person, or whoever, monitors the use by a person of the Internet, email or any other form of electronic communication, or watches or spies on a person in a manner that results in a fear of violence or serious alarm or distress in the mind of such person, or interferes with the mental peace of such person, commits the offence of stalking.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; The victim can also additionally file a case of defamation (Section 499, IPC) against the offender. The section has bailed out those acts of stalking which are performed for the purpose of preventing and detecting crime by a person who has been entrusted with such responsibility by the state. Also, instances where pursuing such conduct was reasonable or where the person was authorized under any act cannot allude to the offence of stalking.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 354A of IPC punishes offence of sexual harassment with 3 years of imprisonment and/or fine.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 354C criminalises the offence of Voyeurism. It is defined as the act of capturing the image of a woman engaging in a private act, and/or disseminating said image, without her consent. The section prescribes 3 years of imprisonment for the first conviction and 7 years of imprisonment on second conviction along with fine.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 503 punishes criminal intimidation as threats made to any person with injury to her reputation, either in order to cause alarm to her, or to make her change her course of action regarding anything she would otherwise do/not do. The offences under S. 499 and S. 503 are punishable with imprisonment which may extend to two years, and/or fine.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 509 of IPC comes to your rescue if someone is constantly bugging you with derogatory verbal abuse because of your gender. The section provides that any person who utters any word or makes any sound or gesture, intending that such word, sound or gesture be heard or seen by a woman and insult her modesty, shall be punished with one-year imprisonment and/or fine.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Section 507 punishes criminal intimidation by an anonymous communication with a term which may extend to two years of imprisonment. Vengeful posting of images or videos of rape victims is punishable with imprisonment which may extend to two years and fine under section 228a of IPC.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;b&gt;&lt;br&gt;&lt;/b&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 16px;&quot;&gt;THE INFORMATION TECHNOLOGY ACT, 2008&lt;/b&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;The IT Act of 2008 does not directly deal with the offence of stalking.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Section 72 of the Act is used to deal with the offence of stalking which reads as follows: Any person who, in pursuant of any of the powers conferred under this Act, rules or regulations made thereunder, has&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; secured access to any electronic record, book, register, correspondence, information, document or other material&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; without the consent of the person concerned&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Discloses such electronic record, book, register, correspondence, information, document or other material to any other person shall be punished with imprisonment for a term which may extend to two years, or with fine which may extend to one lakh rupees, or with both.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Section 67 prohibits and punishes with imprisonment extending up to three years and fine for the first conviction and to five years and fine upon second conviction, the publication, transmission and causing of transmission of obscene content.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Section 67A has culled out a special category called material containing a &lsquo;sexually explicit act&rsquo;. The publication, transmission or causing of transmission of such material is punishable with imprisonment extending up to five years and fine for first conviction and to seven years and fine upon second conviction.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 16px;&quot;&gt;HOW TO LODGE A COMPLAINT&lt;/b&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;The Information Technology Act provides that notwithstanding anything contained in the Code of Criminal Procedure, 1973, any police officer, not below the rank of a Deputy Superintendent of Police, or any other officer of the Central Government or a State Government authorized by the Central Government in this behalf may enter any public place and search and arrest without warrant any person found therein who is reasonably suspected or having committed or of committing or of being about to commit any offence under this Act. (Section 80) Cybercrimes do not have a jurisdiction as these crimes committed without any barrier of boundaries. So, you can report a cybercrime to the cybercrime units of any city irrespective of the place where it was committed.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Cyber Cells: Cyber Cells have been established to provide redressal to the victims of cybercrime. These cells function as a part of the criminal investigation department and specifically deal with internet related criminal activity. If you do not a cyber-cell at your place of residence, then you can file an F.I.R in a local police station. You can also approach the commissioner or the judicial magistrate of your city, if by any reason you are unable to file an F.I.R. Any police station is bound to register an F.I.R., irrespective of its jurisdiction.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Online Grievance Redressal: Police is the most notorious law enforcement agency in India when it comes to dealing with women victims. Even when women have easy access to a police station, they hesitate in reporting the incident to them, under the fear of being harassed and being made to suffer additional ordeal. As a result, such crimes committed against women remain swept under the rug and women continue to bear the brunt of harassment. So, women who do not want to come out in the open can file a complaint against stalking at the National Commission for Women. The Commission takes up the matter with the police and expedites the investigation. In cases of serious offences, the commission can set up an inquiry committee to probe into the matter and conduct spot inquiry, collect evidence, and examine witnesses, summon accused and police records, etc to further the investigation.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Report to the websites: Most of the social media websites where users make their accounts provide a reporting mechanism. These websites are obliged under the IT (Intermediary Guidelines) Rules, 2011 to act within 36 hours to disable information related to offending content. The intermediary shall have to preserve such information and associated records for at least ninety days for investigation purposes. The affected person can bring to the knowledge of the intermediary, any offending content which is hosted, stored, or published on his computer system, in writing or through email signed with electronic signature.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Report to CERT: The Information Technology Amendment Act 2008 has designated the Indian Computer Emergency Response Team (CERT-IN) as the national nodal agency for tackling the issues occurring in tow with computer security threats. They issue guidelines on the procedure, prevention, reporting, and response to cyber incidents, among other functions.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;WHAT CAN BE REPORTED TO CERT?&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Both the users and System Administrators can approach CERT-IN to report about computer security incidents and vulnerabilities. CERT-IN is at your disposal to provide technical assistance if the users experience any the following violations:&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Email related issues viz. mail bombing, spamming etc.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Processing and storing data by unauthorised use of a system&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Making changes into the software characteristics, system hardware or firmware without obtaining the consent of the owner or without the knowledge or instruction of the owner&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Attempt to obtain unauthorised access to a system or data contained therein. Attempt includes both successful and failed attempt&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Disruption or denial of service&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;HOW TO REPORT INCIDENTS TO CERT-IN&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;You can report an incident to CERT by sending them an electronic mail, calling them, or filling up a form available on their website, or by fax.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Through Website: You can also report the incident on the website of CERT-IN by filling up an incident-reporting form. Try to fill all the details as it will help CERT to understand the gravity and nature of the incident and assist in recovery as desired by you.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Through Electronic Mail: The CERT-IN email address for reporting incidents is incident@cert-in.org.in?. For all other inquiries and correspondence, write to info @cert-in.org.in?.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Through Telephone and Fax: Contact CERT-In on +91-11-24368572. Incident report can be faxed to CERT-In at +91-11-24368546.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Postal Address: Indian Computer Emergency Response Team (CERT-IN), Ministry of Electronics and Information Technology, Government of India, Electronics Niketan, 6, CGO Complex, Lodhi Road, New Delhi 110003, India.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Cases of Cyberstalking:&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Seema Khanna (name changed), an employee with an embassy in New Delhi, know that web surfing would lead to an invasion of her privacy.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;In an apparent case of cyber stalking, Khanna (32) received a series of e-mails from a man asking her to either pose in the nude for him or pay Rs 1 lakh to him. In her complaint to Delhi Police, the woman said she started receiving these mails in the third week of November.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;The accused threatened Khanna that he would put her morphed pictures on display at sex websites, along with her telephone number and address. He also allegedly threatened to put up these pictures in her neighborhood in southwest Delhi. &ldquo;Initially, she ignored the mails, but soon she started receiving letters through post, repeating the same threat. She was forced to report the matter to the police,&quot; said an officer with cyber-crime cell That, however, was not the end of her ordeal. The accused mailed the woman her photographs. The woman claimed these were the same photographs which she had kept in her mail folder. The police said the accused had hacked her e-mail password which enabled him to access the pictures.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;In the Vinupriya case, the victim was a 21-year-old student from Salem who had finished her BSc in chemistry. A person had posted morphed nude and semi-nude photographs of Vinupriya on Facebook. On June 23, 2016, when the first obscene photograph appeared, she informed her parents, who then lodged a complaint with the Cyber Crime Cell. The police, either lacking the investigative skills to trace the origin of the photograph or lacking interest, told Vinupriya&rsquo;s father that they would nab the culprit in two weeks. On June 26, another obscene photograph was posted on Facebook, leaving Vinupriya traumatised. The investigating officer assumed that she must have sent those pictures to someone and now they were being posted, perhaps by a jilted lover. The questioning of Vinupriya was along those lines. It humiliated her and on June 27, she hanged herself.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;To prevent being a victim of cyber-crime, a person should quickly take action against the criminal. She should make a complaint to the Cyber Crime Investigation Cell, a branch of the Criminal Investigation Department. These cells exist in Delhi, Mumbai, Chandigarh, Hyderabad, Bengaluru, Gurgaon, Pune, Lucknow, and other major cities. As women are mainly victims of this crime, it is necessary to improve the investigative mechanism for cyber-crimes. Then only will women feel safe and empowered.&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;b style=&quot;font-size: 16px;&quot;&gt;DOs and DON&rsquo;Ts&lt;/b&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; As cyber-crimes are committed in a virtual world, it becomes difficult to collect evidence against the offender. So, do not immediately delete the photos, mails, or any other information sent by the stalker as this can help the investigators to trace the trail of his online activities and track him.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Cyber stalkers can easily hide evidence of their online activity, so preserving his evidence via printouts or screenshots can come very handy.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&middot; Report the incident to the website in question.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;File a First Information Report to enable commencement of the investigation of the cyber-crime.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;Suggestions to avoid becoming a victim of cyberstalking.&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;1. Avoid Posting Personal Data on Your Social Media Accounts&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;2. Conduct an Internet Search of Your Name Regularly&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;3. Be Mindful of Your Passwords&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;4. Beware of Emails, Texts, Phone Calls that Asks for your Personal Information&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;5. Change all Account Security If You Are Leaving a Relationship&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;6. Seek Professional Help If You Are Being Cyber stalked&lt;/div&gt;&lt;/span&gt;&lt;/h4&gt;&lt;h4 style=&quot;text-align: justify; margin-bottom: 0cm; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;&quot;&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;Written by: Adv. S.Selvakumari, Bombay High Court&lt;/span&gt;&lt;/h4&gt;', 'fbebc94358ebfacc15bf211f8bb99d43.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 22:01:37', '2021-01-28 23:00:04');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(56, 'olt9qWakaGtxzGfwT8ZcFCg08', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Article and Trademark.  Devashish Kumar Sahu and Soupayan Sinha Roy', '&lt;h4&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Trademark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n1. The Trademarks Registry was established in India in 1940 and presently it&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nadministers the Trade Marks Act, 1999 and the rules thereunder. It acts as a&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nresource and information center and a facilitator in matters relating to trade&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nmarks in the country. The objective of Trade Marks Act, 1999 is to register trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\napplied for in the country and to provide for better protection of trade mark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nfor goods and services and also to prevent fraudulent use of the mark. The main&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nfunction of the Registry is to register trademarks which qualifies for&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregistration under the Act and Rules.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n2. A good trademark, or logo, makes your particular product or service stand&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nout. These are probably a number of trademarks which you choose to buy, just&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbecause you recognize them. A trademark is quite simply a way to create&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nrecognition for your customers.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n3. Trademark protection gives you an exclusive rights, which means that no one&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nelse has the right to use the trademark for their goods or services, or their&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nmarketing. One of the main purposes of having a product trademarked is to protect&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe product from being used without permission of the source company. A&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntrademark serves to exclusively identify a product or service with a specific&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ncompany, and is a recognition of that company&rsquo;s ownership of the brand.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nTrademark products are generally considered a form of property.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;REGISTRATION OF TRADEMARK&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n4. The law considers a trademark to be a form of property. Proprietary rights&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nin relation to a trademark may be established through actual use in the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nmarketplace, or through registration of the mark with the trademark office of a&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nparticular jurisdiction. In some jurisdictions, trademark rights can be&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nestablished through either or both means. Certain jurisdictions generally do&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nnot recognize trademark rights arising through use. If trademark owners do not&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nhold registrations for their marks in such jurisdictions, the extent to which&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthey will be able to enforce their rights through trademark infringement&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nproceedings will therefore be limited.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n5. A registered trademark confers a bundle of exclusive rights upon the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregistered owner, including the right to exclusive use of the mark in relation&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto the products or services for which it is registered. The law in most&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\njurisdictions allows the owner of a registered trademark to prevent&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nunauthorized use of the mark in relation to products or services which are&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nidentical or &ldquo;colorfully&rdquo; similar to the &ldquo;registered&rdquo; products or services, and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nin certain cases, prevent use in relation to entirely dissimilar products or&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nservices. The test is always whether a consumer of the goods or services will&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbe confused as to the identity of the source or origin.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;6. Trademark needs proper registration and it follows&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\na procedure as to who can apply and what are the basic requirements for the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nsame.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nWho can apply for Trademark?&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n-As mentioned in Section 18 of the Act any person claiming to be proprietor of&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntrademark used or proposed to be used by him can apply for registration.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;-Application must contain the name of the mark, goods&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nor services, class in which goods and services fall, name and address of the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\napplicant, period of use of Trademark.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n-Any person here relates to partnership firm, association of a person, company&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nwhether incorporated or not, Trust, Central or State Government.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nSteps for Registration of Trademark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n1. Search for name, mark and device logo intended to be applied for Trademark.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n2. Trademark application can be filed at one of the five Trademark Registration&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\noffice having jurisdiction over the state or online.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nTrademark registration must contain:&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nA. Logo or the Trademark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nB. Name of the trademark owner&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nC. Classification of trademark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nD. Trademark used since date&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nE. Description of goods or services&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;PROTECTION OF TRADEMARK&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nA trademark protects a good or service offered by a company from infringement&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nor damage of reputation by another company, and provides the owner legal&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nrecourse.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nA trademark protects a goods or service offered by a company from infringement&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nor damage of reputation of another company. With a trademark, you have legal&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nrecourse to sue another company that uses your likeness to further their own&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nbusiness ventures. Thus includes both registered and unregistered trademarks.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nBy using a sole trademark, the producer reaps the sole benefit of sales, while&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe consumer is satisfied.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nTrademarks also protect four categories:&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n1. Generic trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n2. Descriptive trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n3. Suggestive trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n4. Arbitrary trademarks or fanciful trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nThis is referred to as a &ldquo;common law&rdquo; trademark. For small geographic&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nlocations, this works well. It doesn&rsquo;t work as well as in a national setting,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nas companies far and wide may have similar names or logos. If you haven&rsquo;t&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregistered a trademark, you can still use the TM logo to show you have a stake&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nto the trademark.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n7. Dispute can arise based on TM logo. However, it&rsquo;s a good starting point&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nuntil you have time to register your trademark with the U.S Patent and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nTrademark.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n8. Although trademark protection by use gives you protection via common law,&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntrademark by registration offers more protection. This includes:&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n1. Notice to public about the trademark.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n2. The exclusive right to use the trademark nationwide to distribute goods and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nservices.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n3. The ability to bring legal action in federal court for infringement.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n4. The ability to obtain a trademark in foreign countries.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n5. The ability to file with U.S. Customs to prevent mock goods from coming in&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe countr&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;DILUTION OF TRADEMARK&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n9. The progressive development of intellectual property law over the last&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ncentury has seen to an exponential increase in the commercial and economic&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nimportance of various intellectual property rights.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n10. For better protection of trade marks for goods and services and for the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nprevention of the use of fraudulent marks, parliament repealed the 1958 Act and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nreplaces it by the Trade Marks Act, 1999. Under Trade Marks Act, 1999 Trademark&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nDilution was introduced. Trademark dilution is a trademark law concept giving&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe owner of a famous well-known trademark power to forbid others from using&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nthe mark in a way that would lessen its uniqueness.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n11. Dilution of Trademark is a surface of Trademark infringement, where the&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nowner of a well-known trademark has the power to prevent others from using&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntheir mark on the ground that it kills their uniqueness or lessen their&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nreputation. No one has the right to copy or to misuse the well-known&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\ntrademark&rsquo;s reputation. Instead, dilution protection aims to protect&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nsufficiently strong and well-known trademarks from losing their singular&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nassociation in the public mind with a particular product.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\n12. Thus, the doctrine of dilution comes directly in contact with consumers.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nThe Doctrine of Dilution was not present in the old law i.e. the Trade and&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nMerchandise Marks Act, 1958, as in the case of section 29(4) of the Trademarks&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nAct, 1999 by which the doctrine of dilution has been first incorporated in a statute.&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nBut the doctrine of dilution was introduced by the court much before the Act&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nhaving regard to internationally recognized status.&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;13. The trademark under section 29(4) should be&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br /&gt;<br />\r\nregistered and should have a reputation in India. For the application of this&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&', 'd51046c3c3b80b8a613f52340b3cd88e.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:17:33', '2020-12-23 02:50:16');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(57, 'Ky58yOy5JsmSti6Ujuh1TD0B4', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Arvind Kejriwal Delhi issue. Mr. Pavan K. Varma. ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Article by Mr. Pavan K. Varma, former Indian Foreign&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Service officer and was an adviser to the Chief Minister of Bihar, Nitish&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Kumar, with cabinet rank. With effect from June, 2014 he was a Member of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Parliament until July 2016.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;have now ended their &lsquo;dharna&rsquo; in the office of the Lieutenant Governor. Even by&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the standard of vaudeville shows usual in Indian politics, the sight of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;chief minister on strike presented an amazing spectacle. Was this just another&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;of Kejriwal&rsquo;s histrionics, or something more, with which the interests of the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;people of Delhi are deeply connected?&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;million. It is, by this numerical count, larger than 180 countries in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;world. Nearly 9 million people voted in the last elections for the Delhi&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;assembly, the highest so far. Delhi is the world&rsquo;s fastest growing city, with&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;an economy the size of Hungary or Kuwait.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;However, the elected CM is virtually a cipher. He has no powers with regard to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;public order, police, and land. The Municipal Corporation of Delhi (MCD) is not&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;under him; it is a separately elected body with its own mayor. The Delhi&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Development Authority (DDA) is not under him; it reports through the LG&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;directly to the Union urban development ministry.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;instructions of the Union home ministry. The New Delhi Municipal Council (NDMC)&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is not under him; it is governed by a chairperson appointed by the central&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;government. Kejriwal claims that the citizens of Delhi pay Rs 1.5 lakh crore in&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;income tax, more than any other city; but Delhi is not even mentioned in the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;states with whom this revenue is shared.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;swept the elections, the Union home ministry issued a further notification,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;making the LG the sole authority in the transfer and posting of bureaucrats. It&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;also took away the powers of the Anti-Corruption Bureau (ACB) of the Delhi&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;government with respect to officials, employees and functionaries of central&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;government services.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;powers in matters of public order, police and services, but he was required to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;exercise them in consultation with the CM. In case the CM was not consulted,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the LG had to record reasons in writing on why he did not do so. The 2015&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;notification removed even this requirement.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;expected to function? Undoubtedly, Sheila Dikshit did, and for 15 years. That&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is a tribute to her diplomacy and administrative acumen. But she was lucky on&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;two counts: the LG was not relentlessly in confrontation mode with her, as&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;certainly appears to be the case now; and, she had far more powers over her&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;bureaucrats &ndash; including the power to write their annual confidential reportsn&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(ACRs) that all babus value.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 16px;&quot;&gt;misbehavior&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&amp;nbsp;of AAP MLAs with the chief secretary of Delhi. Politicians cannot&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;behave like hoodlums, and the fact that this incident allegedly took place at&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;midnight in the CM&rsquo;s house &ndash; and in his presence &ndash; makes it even more&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;condemnable. The matter is currently in court, and the guilty must be punished&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;under the law.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Delhi be governed? The irony &ndash; and the hypocrisy &ndash; is that both BJP and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Congress have otherwise categorically endorsed the demand of AAP for full&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;statehood for Delhi. Then BJP CM, Madan Lal Khurana, asked for this as far back&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;as 1998. BJP put this demand in its manifesto in the 1999 Lok Sabha elections.&lt;/span&gt;&lt;/div&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The Vajpayee government prepared a State of Delhi Bill in 2003 which, after&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;being introduced in the Lok Sabha, was referred to a standing committee, where&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;it has since languished.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In 2013, CM Sheila Dikshit publicly complained about the &lsquo;multiplicity of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;agencies and authorities&rsquo; operating in Delhi. The party asked for full&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;statehood for Delhi in its manifesto for the 2015 assembly elections. How then&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;can Congress, or BJP, not support the demand being made by AAP today?&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;optimally in the current situation. The Supreme Court is seized with some&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;aspects of this matter, but clearly the only solution is to give Delhi full&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;statehood. This will require an amendment to the Constitution, and all parties&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;must, in the interests of the people of Delhi, work towards this goal.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;a small area, including the Rashtrapati Bhavan, Parliament, the PM&rsquo;s residence,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and important federal offices located largely in Lutyens&rsquo; Delhi, can be put&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;under a separate authority. This is the pattern, for instance, in London, where&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;a powerful mayor runs the Greater London Authority (GLA), administering 607&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;square miles of the city and 8 million people, while a much smaller authority,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the City of London, administers a two-square mile area of just about 10,000&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;people.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;But when political parties cynically work only for immediate political gain,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;and deliberately forsake a long-term vision, the larger good suffers, and that&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is precisely what is happening with the people of Delhi.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Arvind Kejriwal and his senior ministerial colleagues&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Consider the facts. The population of Delhi is 19&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The Delhi police is not under him; it works on the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Moreover, in May 2015, after the Aam Aadmi Party (AAP)&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Under a previous notification of 1998, the LG did have&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In such a situation, how is the elected CM of Delhi&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;None of this can even remotely condone the alleged&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;However, the real issue still remains: How should&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The Congress party has shown similar double standards.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;The truth is that no elected CM of Delhi can function &lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Since Delhi is also the seat of the Union government,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Solutions are possible if the political will is there.&amp;nbsp;&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;published in Times of India 23 June 2018&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/p&gt;&lt;br&gt;', 'd7fa0c9f16cfffc4392d2e087ffb30f3.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 21:18:27', '2021-02-04 00:10:53'),
(160, '5YLfsKMqMMYHAJ5jZezxMxqGD', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Three State Organs in 1950 and 2020 – Losses and Gains.', '&lt;h4&gt;Three State Organs in 1950 and 2020 &ndash; Losses and Gains.&lt;br&gt;Mr. B.V. Acharya, Senior Advocate and former Advocate General for Karnataka Article Image&lt;br&gt;Constitution of India is hailed as one of the best federal Constitutions in the World. It has adopted parliamentary system of Government based on British model. It provides for three organs of the State viz., Legislature, Executive and Judiciary. It recognize separation of powers, though not with all rigidity. The Constitution has specified the powers, duties and responsibilities of each of the organs. Though each of the organs is equal; by its very nature, functions and power, the judiciary occupies a pre-eminent position. It has the responsibility to see that the other two organs function within the sphere earmarked to them under the Constitution. It has the power to invalidate any legislative or executive action if the same is unauthorized. However, if the judiciary and in particular the Supreme Court acts in excess of authority, there is no remedy available.&amp;nbsp;&lt;br&gt;Since the Constitution has been in force for the last 70 years, it may be worthwhile to consider the relative status and powers of these organs as it existed&amp;nbsp; at the commencement of the Constitution and as on today.&lt;br&gt;Legislature Let us first consider the position of the Legislature. By legislature, I mean the parliament, as there is not much of a change so far as State legislatives are concerned. Under the Constitution, the Parliament is empowered to legislate on subjects earmarked in List-I (Central List) and List-III (concurrent List). There has been no noticeable change in the power of the parliament in this regard.&amp;nbsp;&lt;br&gt;However, in addition to the power to legislate as stated above, the parliament is also authorized to amend the Constitution as provided by Article 368 of the Constitution.&amp;nbsp; Soon after the coming into force of the Constitution the parliament and State legislatures had enacted certain legislations by way of Land Reforms as also providing for reservation in service and admission to educational institutions for schedule castes and tribes and other backward classes. As these enactments were invalidated&amp;nbsp; by the judiciary as unconstitutional being violative of fundamental rights, the parliament with a view to validate them, brought about constitutional amendments.&amp;nbsp; These amendments to the Constitution were unsuccessfully challenged as the Supreme Court upheld the power of the parliament to amend the Constitution without any limitation on such power.&amp;nbsp;&amp;nbsp;&lt;br&gt;This position continued till about the year 1967 when, for the first time Supreme Court in the case of Golaknath ruled that the parliament had no power to amend Part-III of the Constitution which provided for Fundamental Rights. In the year 1973, in the case of Keshavananda Bharathi Vs State of Kerala (1973 (4) SCC 225) 13 Judge Bench of the Supreme Court considered the question of validity of the Kerala Land Reforms Act as also certain Constitutional Amendments effected by the parliament. The correctness or otherwise of the decision of the Court in Golaknath&rsquo;s case also came up for consideration. The controversy in the case centered round the power of the parliament to amend the Constitution. For the petitioners it was contended that the power of the parliament to amend the constitution was not unlimited and that there were implied limitations on such power.&amp;nbsp; The plea forcefully put forth was that the power does not include authority to amend the constitution which alters the basic structure / framework of the Constitution.&amp;nbsp; Respondents strongly refutedthis contention and urged that the power to amend conferred by Article 368 is without any limitation or restriction, and implying any such limitation will be doing violence to the language employed.&lt;br&gt;The court after hearing the matters for about 68 days delivered a split verdict. Seven out of 13 judges (forming the majority) ruled in favour of the petitioners and held that the power does not empower the parliament to effect such amendment which will alter the basic structure of the constitution. It in fact also struck down latter part of Section 31-C (which precluded judicial review of legislationwhich was enacted in furtherance of any of the directive principles of State Policy) on the ground that it altered the basic structure of the constitution as power of judicial review is part of it. Six of the Judges, however, strongly maintained that the power of the parliament to amend any part of the constitution is without any limitation or restriction and that it is a constituent power vested with the parliament. Naturally majority decision angered the executive so much that soon thereafter the Government deviating from the convention, passed orders appointing Justice A.N.Ray as the Chief Justice of India, superseding 3 judges senior to him viz., Justice J.M.Shelat, Justice K.S.Hegde and Justice A.N.Grover. This decision of the Government evoked strong protest from the public and in particular legal fraternity. The three superseded judges resigned, which had no effect on the firm decision of the Government.&amp;nbsp; After Justice A.N.Ray assumed office of the Chief Justice of India an attempt was made to get the majority decision in Keshavananda Bharati case reviewed and a 13 judge was constituted for the said purpose.&amp;nbsp; However, the attempt proved futile on account of strong objection by team of Advocates led by late Sri N.A.Palkhivala and on the second day,&amp;nbsp; as hearing of the review was in progress, the Chief Justice of India simply dissolved the Bench without any formal order.&amp;nbsp; Thus the majority view in Keshavananda&rsquo;s case became law of the land and continues to be so even now.&amp;nbsp; Yet another attempt to curtail Supreme Court&rsquo;s power of judicial review was thwarted by the judgment in Minerva Mills case. The net result is, the power of parliament to amend the constitution stood restricted and subsequently few amendments also stood invalidated on the basis of doctrine of basic structure.&amp;nbsp;&amp;nbsp;&lt;br&gt;Though purely on a point of law the judgment of the Supreme Court in the case of Keshavananda was considered erroneous by a section of the legal experts, the public in general welcomed the decision as it was felt that such a check on the power of the parliament to amend the constitution was quite necessary and imperative. It is widely believed that, but for this decision, by now the parliament would have amended the constitution many times and to such an extent that to-day we would not have had this constitution. In fact this decision virtually saved the constitution and in-turn the country. To-day we have this constitution only because of the decision in Keshavananda Bharati.&lt;br&gt;For the purpose of this articles, suffice it to say that w.e.f. 1973 parliament was deprived of its very important power of amendment of the constitution without any limitation on account of the decision in Keshavananda Bharati.&amp;nbsp; This is a case of loss of power of parliament and gain for the judiciary as will be explained later.&lt;/h4&gt;&lt;div&gt;&lt;br&gt;&lt;/div&gt;', '6c1bf7a22e866d0c182af19a75ec124a.jpg', '', 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2021-02-04', 1, NULL, NULL, '2021-02-04 23:51:05', '2021-02-04 12:21:18'),
(76, 'WSP7tdRpFTvQYKAW55uWJlmYO', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'Difference between waiving off and writing off loans.   Surendra Naik.', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;span style=&quot;font-size:12.0pt;line-height:107%;font-family:&lt;br /&gt;&lt;br /&gt;&lt;br /&gt;<br />\r\n&quot; times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot;&gt;-Surendra Naik. BankingSchool.Co.in.&lt;br&gt;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&lt;br&gt;&lt;div style=&quot;text-align: justify;&quot;&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;sum of Rs.10000/-from you, but he was unable to repay because of his unusual&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;financial difficulties. You have realized the situation of your friend that the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;repayment of loan is beyond his control; so you forgave the loan amount given&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to him and informed him that you have absolved him from the debt. Here you have&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;voluntarily cancelled the loan amount receivable from your friend. This is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;called waiver of loan. Let us take example of another friend who have borrowed&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;(say a sum of Rs.10000/-) from you but he was not repaying the money borrowed&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;from you. After all avenues of your recovery efforts are exhausted, you felt&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;that there is no meaning in pursuing him further for repayment because the&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;chances of recovery are remote. You gave up your recovery efforts. In the other&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;words you have written-off the money receivable from that friend. Though&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;technically, you have lost the money in both the above cases, Loan written-off&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;is not the same as loan waiver. You can understand this by taking examples of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;bank loans.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;banks is provisioning for NPA. When all avenues of recovery are exhausted and&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;chances of recovery seem bleak, a bank would use the provisions made on bad&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;loans over the years or a part of bank&rsquo;s profit, to remove such bad loans from&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the assets side of its balance sheet. This process of corrective action of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;banks to clean up their balance sheet is known as &lsquo;written-off&rsquo;. Here, we have&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to remember that the loan written-off does not mean that the borrower is&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;pardoned or got exempted from payment of his dues. If a bank is still be able&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to recover money from written off accounts at a future date same will be&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;directly credited back into profit account of the bank.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;as it is the cancellation of recovery or permanently refraining from claiming&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the dues. In this case, banks will completely give up on such loans and no&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;recovery will be made. Whenever &lsquo;Loan waiver&rsquo; relief schemes are declared by&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;the Governments, usually to the farmers who are in severe distress due to&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;abnormal conditions such as crop failures, poor monsoon, floods, earthquake,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;draught etc. that are considered as natural calamities, wherein borrowers are&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;unable to pay back to the banks. However, banks are not put to bear the losses&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;due to loan waiver. The local Governments which announced the loan waiver&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;scheme would fully or partially compensate the loan amount waived by the banks&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;to enable them to liquidate the outstanding entries of loans from their books.&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Let us take an example, one of your friends borrowed a&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;In India, the major corrective action on bad loan of&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;Loan waiver is quite different from writing off a loan&lt;/span&gt;&lt;/div&gt;&lt;/span&gt;&lt;/p&gt;', '006557d7ec459f5914c3cb49f76521b6.png', NULL, 'QhH4KbT5VxN5Saz2nC3NuAtQG', '2020-12-19', 1, NULL, NULL, '2020-12-01 22:05:03', '2021-01-28 22:58:57');
INSERT INTO `article` (`article_id`, `article_key`, `category_key`, `article_title`, `article_description`, `article_image`, `article_attachment`, `article_author`, `article_date`, `article_status`, `article_bookmark`, `article_like`, `article_date_added`, `article_date_updated`) VALUES
(77, '8zLV2FLKSypbRimuR9NsNPXOT', 'TSUhvAg9KIuGOC5DrA7yLvekJ', 'DNA Test as evidentiary value A critical analysis. Sophiya Chhabra and Siddardh Solanki.  ', '&lt;p class=&quot;MsoNormal&quot;&gt;&lt;/p&gt;&lt;p style=&quot;text-align: justify;&quot;&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Sophiya Chhabra - 2nd year Law&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;&amp;amp; Siddardh Solanki 4th year BA.LLB,&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size: 12pt;&quot;&gt;- O.P. Jindal Global University, Sonipat, Haryana&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Vishwanath R Kabadagi, 1 year Law, KLE Law College, Bangalore&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Interns &ndash; Daksha Legal&lt;br&gt;&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;DNA is proving to be a very helpful resource in the modern Indian Judiciary. In&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;fact, it is considered to be one of the most reliable evidence when it comes to&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;adjudication with respect to paternal disputes, land disputes and rape cases as&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;well. Modern science has developed a very powerful tool but is it too powerful&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;for our own good? DNA data banks are established in countries like US and UK&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;where DNA samples and DNA profiles are accessible for investigation purpose but&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;how far is this kind of data protected? Is it an intrusion to privacy? Further,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;even though DNA has been used as a conclusive proof in many cases in India but&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;how accurate is DNA evidence in the first place? This paper will try to answer&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;these questions and will also focus on the circumstances where DNA can or&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;cannot be used along with various provisions laid down in Indian Law.&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Deoxyribonucleic acid (DNA), a self-replicating material which is present in&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;nearly all living organisms as the main constituent of chromosomes. It is the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;carrier of genetic information. The fundamental and distinctive characteristics&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;or qualities of someone or something, especially when regarded as unchangeable.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;This is permanent till the person&#039;s death. &lsquo;A DNA test is a test in which someone&#039;s&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;DNA is analyzed. For example - To see if they have committed a crime or are the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;parent of a child. They take the samples of his/her hair for DNA testing. DNA&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;can be extracted from a wide range of sources, including samples of hair,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;cigarette butts, blood, razor clippings or saliva. Thus, it is relatively easy&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to obtain samples which can then be tested in a laboratory to determine any&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;genetic relationships that may be present&rsquo;.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&lsquo;Parental, forensic and genetic testing look for similarities in the genetic&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;markers between two biological samples. Because all cells in the body contain&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the same DNA, samples can be taken from almost anywhere in the body, including&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;skin, hair follicles, blood and other bodily fluids. A forensic scientist might&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;be asked to compare DNA from skin cells found underneath the fingernails of an&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;attack victim, with the DNA from a blood sample taken from a potential suspect.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;First, the DNA is isolated from the cells and millions of copies are made,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;using a method called &#039;polymerase chain reaction&#039;, or PCR.&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;PCR uses a naturally occurring enzyme to copy a specific stretch of DNA&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;repeatedly. Having lots of DNA makes the genetic code easier to analyze. The&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;DNA molecules are then split at particular locations to separate them into&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;known &#039;chunks&#039; and the code at those specific points is analyzed to create a&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;DNA fingerprint. The fingerprints from the two different samples are then&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;compared to see if they match&rsquo;.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Evidence plays a crucial role in both criminal and civil cases. In civil cases&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the burden of proof lies with the plaintiff where he/she needs to prove his/her&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;case by preponderance of the evidence. In civil cases, for instance, relating&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to determining the paternity of a child, DNA test are being heavily relied on&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;in the recent times as it provides scientifically based information. But how&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;far is this information analysed through DNA tests reliable? What if a parent&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;refuses to undergo this medical examination or what if neither of the parents&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;is alive at the time when such kind of information regarding the paternity of a&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;child is needed? Research shows DNA paternity tests can be carried out both&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;vertically, that being among the father or mother and horizontally on blood&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;relatives including siblings, grandparents, uncles and aunts . Which means,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;even when either of the parent is absent for DNA testing, in order to determine&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the paternity of the child DNA testing can be carried out on the blood&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;relatives as well. However, great caution should be taken with this alternate&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;pool for DNA testing as this type of testing can be used to determine paternity&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;of a child with a great degree of accuracy but at the same time it is not as&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;accurate as the traditional father-child testing method&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;and national context&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Under the forensic database of DNA, the DNA profiles generated from an&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;individual&rsquo;s biological samples are electronically stored in this repository&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;for comparison with profiles generated from samples obtained either from the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;scene of a crime, or from the body of a suspect. One of the main objective of&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;such database is to link individuals to the offences that are unsolved by the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;means of DNA profiling where their profiles can be used to detect the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;individuals who might have committed the crime. In civil proceedings, DNA&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;profiling can be used for instance in the matters related to missing person or&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;unidentified dead bodies, parentage testing and so on.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;profiles but in countries like UK and USA, the national DNA database retains&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;both DNA profiles as well as the DNA samples. It has been a key investigating&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;strategies in these countries in the recent times but at the same time great&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;caution is performed while using information obtained through such databases.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;However, such data banks have not yet been established in India but a bill&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;known as the DNA profiling bill was proposed by the Centre for DNA&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Fingerprinting and Diagnostics, autonomous organization funded by the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Government of India. This bill seeks to legalise DNA data banks for the benefit&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;of public good. The bill is still pending in parliament and has been elaborated&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;upon as it concerns with the privacy issues of the citizens.&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Article 20(3) of the Constitution of India gives an individual protection not&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to be a witness against himself or deny to answer any question which would lead&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to self-incrimination. Taking finger print of a person for investigation purposes&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;was contested to be of self-incriminatory nature under Article 20(3) of the&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Constitution in the case of State of Bombay v. Kathi Kalu Oghad. It was held in&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;this case that &quot;to be a witness&quot; is not equivalent to&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;&quot;furnishing evidence&quot; in its widest term and significance. Giving&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;thumb or finger impression or exhibiting parts of the body by way of&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;identification are not included in the expression &quot;to be a witness&quot;.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;Being a witness has been interpreted to mean imparting some sort of knowledge&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;in testimony. Therefore, as according this landmark judgement, providing DNA or&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;blood test by an individual for investigation purpose cannot be amount to&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;self-incrimination under Article 20(3) of the Constitution of India.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;samples goes back to 1993 where in the case of Gautam Kundu v. State of W.B , &lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the wife of the appellant conceived while she was away from the husband, at her&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;matrimonial home. On her return to her husband&rsquo;s house, she was treated with&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;cruelty due to pregnancy and was ultimately sent back home where she gave birth&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;to a female child. Later, she filed a petition under Section 125 of Cr.PC for&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;maintenance. The appellant requested for a blood test to determine paternity of&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the child. It was held that the court should very carefully examine as to what&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;would be the consequence of such a blood test: whether it will have the effect&lt;br&gt;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;of branding the child as a bastard and the mother as an unchaste woman.&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;However, in the present case, the application was merely to avoid maintenance&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;cost and therefore, the court allowed for the blood test. It was also held that&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the courts cannot order blood test as matter of course/routine. Moreover,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;wherever applications are made for such prayers in order to have roving inquiry,&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;the prayer for blood test cannot be entertained. Furthermore, there must be a&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&quot; style=&quot;font-size: 12pt; line-height: 107%;&quot;&gt;strong prima facie case and the husband must establish non-access in order to&amp;nbsp;&lt;/span&gt;&lt;span times=&quot;&quot; new=&quot;&quot; roman&quot;,serif&quot;=&quot;&qu