<!doctype html>
<html lang="en" class="no-js">
    <head>
        <title>Daksha</title>

        <meta charset="utf-8">

        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <link rel="shortcut icon" href="<?= base_url('assets/site/images/favicon.png') ?>" type="image/x-icon">  

        <!--Meta data-->
        <meta property="og:image" content="<?= base_url('uploads/kannada/' . $kannada['kannada_image']) ?>"/>
        <meta property="og:title" content="<?= esc($kannada['kannada_title']) ?>"/>

        <link href='http://fonts.googleapis.com/css?family=Lato:300,400,700,900,400italic' rel='stylesheet' type='text/css'>
        <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">

        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/bootstrap.min.css') ?>" media="screen">	
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/jquery.bxslider.css') ?>" media="screen">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/magnific-popup.css') ?>" media="screen">	
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/owl.carousel.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/owl.theme.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/ticker-style.css') ?>"/>
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/style.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/style.css') ?>" media="screen">
        <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.0/animate.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/PagingStyle.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/font-style.css') ?>" media="screen">
		<link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Trirong:wght@500&display=swap" rel="stylesheet">
    </head>
    <body>

        <!-- Container -->
        <div id="container">

            <style>
                .content-desc span{
                    font-size: 1.6rem !important;
                    line-height: 1.9 !important;
                    color: #222222 !important;
                    font-weight: inherit !important;
                    font-family: Arial, sans-serif !important;
                }
                .content-desc h4{
                    font-family: Arial, sans-serif !important;
                    line-height: 1.9 !important;
                    color: #222222 !important;
                }
                .content-desc h3{
                    font-family: Arial, sans-serif !important;
                    line-height: 1.9 !important;
                    color: #222222 !important;
                }
                .content-desc b{
                    font-family: Arial, sans-serif !important;
                    line-height: 1.9 !important;
                    color: #222222 !important;
                }
            </style>

            <!-- Header
                ================================================== -->
            <?= $this->include('partials/navbar') ?>
            <!-- End Header -->

            <!-- block-wrapper-section
                    ================================================== -->

            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                       
                        <div class="col-md-8 col-sm-8 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar large-sidebar theiaStickySidebar">

                                <div class="row daksha-widget-header">
                                    <div class="col-md-5 mb-10">
                                        <img class="img-responsive" src="<?= base_url('uploads/kannada/' . $kannada['kannada_image']) ?>" alt="">
                                    </div>
                                    <div class="col-md-7 daksha-header-title">
                                        <h1>
                                            <?= esc($kannada['kannada_title']) ?>
                                        </h1>
                                        <ul class="post-tags mb-3">
                                            <li>
                                                <i class="fa fa-clock-o"></i>
                                                <?php
                                                $mJudgementDate = new DateTime($kannada['kannada_date_updated']);
                                                $mJudgementDate = $mJudgementDate->format('d-F-Y H:i');
                                                ?>
                                                <span>
                                                    <?= esc($mJudgementDate) ?>
                                                </span>
                                            </li>
                                        </ul>
                                        <span>Share this : </span>
                                        <?php
                                        $mRedirect = base_url('kannada/view/' . $kannada['kannada_key']);
                                        $mWhatsappShare = base_url('kannada/actionRead/' . $kannada['kannada_key']);
                                        ?>
                                        <a target="_blank" href="https://www.facebook.com/sharer.php?u=<?= esc($mRedirect) ?>" class="fa fa-social fa-facebook fa-facebook-inner"></a>
                                        <a target="_blank" href="http://twitter.com/share?url=<?= esc($mRedirect) ?>" class="fa fa-social fa-twitter fa-twitter-inner"></a>
                                        <a href="whatsapp://send?text=<?= esc($mWhatsappShare) ?>" class="fa fa-social fa-whatsapp fa-twitter-inner"></a>

                                    </div>
                                </div>

                                <div class="row mt-10">
                                    <div class="col-md-12">
                                        <div class="daksha-content content-theme text-left mt-standard text-justify content-desc">
                                            <?= $kannada['kannada_data'] ?>
                                        </div>
                                        <br>
                                       <?php if ($kannada['kannada_attachment']): ?>
                                    <div class="download-pdf">
                                        <a class="mr-2" download="" href="<?= base_url('uploads/kannada/' . $kannada['kannada_attachment']) ?>">
                                           Click here to read/download the pdf
                                        </a>
                                    </div>
                                <?php endif; ?>
                                 <?php if ($kannada['kannada_attachment']): ?>
                                   <iframe width="100%" height="1000px" src="<?= base_url('uploads/kannada/' . $kannada['kannada_attachment']) ?>#toolbar=0" frameborder="0"></iframe>
                                <?php endif; ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- End sidebar -->
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer 
                    ================================================== -->
            <?= $this->include('partials/footer') ?>
            <!-- End footer -->

        </div>
        <!-- End Container -->

        <?= $this->include('partials/scripts') ?>

    </body>
</html>