<!doctype html>
<html lang="en" class="no-js">
    <head>
        <title>Daksha</title>

        <meta charset="utf-8">

        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <link rel="shortcut icon" href="<?= base_url('assets/site/images/favicon.png') ?>" type="image/x-icon">  

        <!--Meta data-->

        <meta property="og:image" content="<?= base_url('uploads/articles/' . $article['article_image']) ?>"/>
        <meta property="og:title" content="<?= esc($article['article_title']) ?>"/>

        <link href='https://fonts.googleapis.com/css?family=Lato:300,400,700,900,400italic' rel='stylesheet' type='text/css'>
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">

        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/bootstrap.min.css') ?>" media="screen">	
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/jquery.bxslider.css') ?>" media="screen">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/magnific-popup.css') ?>" media="screen">	
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/owl.carousel.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/owl.theme.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/ticker-style.css') ?>"/>
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/style.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/style.css') ?>" media="screen">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.0/animate.min.css">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/PagingStyle.css') ?>" media="screen">
        <link rel="stylesheet" type="text/css" href="<?= base_url('assets/site/css/font-style.css') ?>" media="screen">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Trirong:wght@500&display=swap" rel="stylesheet">

        <style>
            .content-desc span {
                font-size: 1.6rem !important;
                line-height: 1.9 !important;
                color: #222222 !important;
                font-weight: inherit !important;
                font-family: Arial, sans-serif !important;
            }
            .content-desc h4, .content-desc h3, .content-desc b {
                font-family: Arial, sans-serif !important;
                line-height: 1.9 !important;
                color: #222222 !important;
            }
            .daksha-content p font {
                font-family: 'Trirong', serif !important;
            }
        </style>
    </head>
    <body>

        <!-- Container -->
        <div id="container">

            <!-- Header -->
            <?php echo view('partials/navbar'); ?>
            <!-- End Header -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-md-8 col-sm-8 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar large-sidebar theiaStickySidebar">
                                <div class="row daksha-widget-header">
                                    <div class="col-md-12 daksha-header-title">
                                        <h1>
                                            <?= esc($article['article_title']) ?>
                                        </h1>
                                        <ul class="post-tags mb-3">
                                            <li>
                                                <i class="fa fa-clock-o"></i>
                                                <?php
                                                $mJudgementDate = new DateTime($article['article_date_updated']);
                                                $mJudgementDate = $mJudgementDate->format('d-F-Y H:i');
                                                ?>
                                                <span>
                                                    <?= $mJudgementDate ?>
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-lg-12 col-md-12 mb-10 col-pos">
                                        <div class="social-media-icons">
                                            <?php
                                            $mRedirect = base_url('articles/view/' . $article['article_key']);
                                            $mWhatsappShare = base_url('articles/actionView/' . $article['article_key']);
                                            ?>
                                            <a target="_blank" href="https://www.facebook.com/sharer.php?u=<?= $mRedirect ?>" class="fa fa-social fa-facebook fa-facebook-inner"></a>
                                            <a target="_blank" href="http://twitter.com/share?url=<?= $mRedirect ?>" class="fa fa-social fa-twitter fa-twitter-inner"></a>
                                            <a href="https://web.whatsapp.com/send?text=<?= $mWhatsappShare ?>" class="fa fa-social fa-whatsapp fa-twitter-inner sm-hide"></a>
                                            <a href="whatsapp://send?text=<?= $mWhatsappShare ?>" class="fa fa-social fa-whatsapp fa-twitter-inner sm-block"></a>
                                        </div>
                                        <img class="img-responsive news-internal-img" src="<?= base_url('uploads/articles/' . $article['article_image']) ?>" alt="">
                                    </div>
                                </div>
                                <div class="row mt-10">
                                    <div class="col-lg-12 col-md-12 ">
                                        <div class="daksha-content content-theme text-left mt-standard text-justify content-desc">
                                            <?= html_entity_decode($article['article_description']) ?>
                                        </div>
                                        <br>
                                    </div>
                                </div>
                                <?php if ($article['article_attachment']): ?>
                                    <div class="download-pdf">
                                        <a class="mr-2 " download="" href="<?= base_url('uploads/articles/' . $article['article_attachment']) ?>">
                                            Click here to read/download the pdf
                                        </a>
                                    </div>
                                    <iframe width="100%" height="1000px" src="<?= base_url('uploads/articles/' . $article['article_attachment']) ?>#toolbar=0" frameborder="0"></iframe>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-4 col-sm-4 sidebar-sticky">
                            <div class="row mt-standard">
                                <?php
                                $count = 0;
                                foreach (array_slice($articles, 0, 4, true) as $key => $articlelist):
                                    $count++;
                                    $mArticleKey = $articlelist['article_key'];
                                    $mArticleImage = base_url('uploads/articles/' . $articlelist['article_image']);
                                    $mArticleTitle = $articlelist['article_title'];
                                    $mArticleDesc = $articlelist['article_description'];
                                    $mArticleDate = new DateTime($articlelist['article_date']);
                                    $mArticleAuthor = $articlelist['author_name'];
                                    $mArticleDate = $mArticleDate->format('d-F-Y');
                                    $mArticleViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mArticleTitle);
                                    $mArticleViewTitle = preg_replace('/  */', '-', $mArticleViewTitle);
                                    $mArticleViewTitle = preg_replace('/\\s+/', '-', $mArticleViewTitle);
                                    $mArticleView = base_url('articles/actionView/' . $mArticleKey  . "/" . $mArticleViewTitle);
                                    if ($mArticleKey != $article['article_key']):
                                ?>
                                    <div class="col-md-12" style="margin-left: 10px !important">
                                        <a href="<?= $mArticleView ?>">
                                            <div class="card bg-card-theme-inner">
                                                <img style="width: 100%" class="img-responsive" src="<?= $mArticleImage ?>" alt="<?= esc($mArticleTitle) ?>">
                                                <div class="card-body card-body-theme">
                                                    <h5 class="card-title bg-card-theme-title">
                                                        <?= esc($mArticleTitle) ?>
                                                    </h5>
                                                    <ul class="post-tags">
                                                        <li>
                                                            <i class="fa fa-clock-o"></i>
                                                            <span>
                                                                <?= $mArticleDate ?>
                                                            </span>
                                                        </li>
                                                        <li>
                                                            <i class="fa fa-user"></i>
                                                            <span>
                                                                <?= esc($mArticleAuthor) ?>
                                                            </span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php
                                    endif;
                                endforeach;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer -->
            <?php echo view('partials/footer'); ?>
            <!-- End footer -->

        </div>
        <!-- End Container -->

        <?php echo view('partials/scripts'); ?>

    </body>
</html>