<!DOCTYPE html>
<html lang="en" class="no-js">
    <?= $this->include('partials/header') ?>
    <body>
        <!-- Container -->
        <div id="container">
            <!-- Header -->
            <header class="clearfix">
                <!-- Bootstrap navbar -->
                <nav class="navbar navbar-default navbar-static-top" role="navigation">
                    <!-- Top line -->
                    <div class="top-line">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-9">
                                    <ul class="top-line-list">
                                        <li><a href="#">Log In</a></li>
                                        <li><a href="#">Contact</a></li>
                                        <li><a href="#">Sign Up</a></li>
                                    </ul>
                                </div>	
                                <div class="col-md-3">
                                    <ul class="social-icons">
                                        <li><a class="facebook" href="#"><i class="fa fa-facebook"></i></a></li>
                                        <li><a class="twitter" href="#"><i class="fa fa-twitter"></i></a></li>
                                        <li><a class="rss" href="#"><i class="fa fa-rss"></i></a></li>
                                        <li><a class="google" href="#"><i class="fa fa-google-plus"></i></a></li>
                                        <li><a class="linkedin" href="#"><i class="fa fa-linkedin"></i></a></li>
                                        <li><a class="pinterest" href="#"><i class="fa fa-pinterest"></i></a></li>
                                    </ul>
                                </div>	
                            </div>
                        </div>
                    </div>
                    <!-- End Top line -->

                    <!-- list line posts -->
                    <div class="list-line-posts">
                        <div class="container">
                            <div class="owl-wrapper">
                                <div class="owl-carousel" data-num="3">
                                    <div class="item list-post">
                                        <img src="<?= base_url('assets/site/upload/news-posts/listw5.jpg') ?>" alt="">
                                        <div class="post-content">
                                            <a href="politics-category.html">Politics</a>
                                            <h2><a href="single-post.html">Donec odio. Quisque volutpat mattis eros. Nullam malesuada </a></h2>
                                            <ul class="post-tags">
                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="item list-post">
                                        <img src="<?= base_url('assets/site/upload/news-posts/listw4.jpg') ?>" alt="">
                                        <div class="post-content">
                                            <a href="politics-category.html">World</a>
                                            <h2><a href="single-post.html">Nullam malesuada erat ut turpis. Suspendisse urna nibh</a></h2>
                                            <ul class="post-tags">
                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="item list-post">
                                        <img src="<?= base_url('assets/site/upload/news-posts/listw3.jpg') ?>" alt="">
                                        <div class="post-content">
                                            <a href="politics-category.html">Business</a>
                                            <h2><a href="single-post.html">Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. </a></h2>
                                            <ul class="post-tags">
                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="item list-post">
                                        <img src="<?= base_url('assets/site/upload/news-posts/listw2.jpg') ?>" alt="">
                                        <div class="post-content">
                                            <a href="politics-category.html">Election</a>
                                            <h2><a href="single-post.html">Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. </a></h2>
                                            <ul class="post-tags">
                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End list line posts -->

                    <!-- Logo & advertisement -->
                    <div class="logo-advertisement">
                        <div class="container">
                            <!-- Brand and toggle get grouped for better mobile display -->
                            <div class="navbar-header">
                                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                                    <span class="sr-only">Toggle navigation</span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                    <span class="icon-bar"></span>
                                </button>
                                <a class="navbar-brand" href="#"><img src="<?= base_url('assets/site/images/Daksha-Logo.png') ?>" width="350px" style="margin-bottom: 10px; margin-top: -20px" alt=""></a>
                            </div>
                        </div>
                    </div>
                    <!-- End Logo & advertisement -->			

                    <!-- navbar list container -->
                    <div class="nav-list-container">
                        <div class="container">
                            <!-- Collect the nav links, forms, and other content for toggling -->
                            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                                <ul class="nav navbar-nav navbar-left">
                                    <li><a class="active" href="index.html">HOME</a></li>
                                    <li><a href="">BARE ACTS</a></li>
                                    <li><a href="">JUDGMENTS</a></li>
                                    <li><a href="">ARTICLES</a></li>
                                    <li><a href="">SEMINARS</a></li>
                                    <li><a href="">LAWYERS DIRECTORY</a></li>
                                    <li><a href="">CONTACT</a></li>
                                    <li><a href="">SIGN IN</a></li>
                                </ul>
                                <form class="navbar-form navbar-right" role="search">
                                    <input type="text" id="search" name="search" placeholder="Search here">
                                    <button type="submit" id="search-submit"><i class="fa fa-search"></i></button>
                                </form>
                            </div>
                            <!-- /.navbar-collapse -->
                        </div>
                    </div>
                    <!-- End navbar list container -->
                </nav>
                <!-- End Bootstrap navbar -->
            </header>
            <!-- End Header -->

            <!-- ticker-news-section -->
            <section class="ticker-news">
                <div class="container">
                    <div class="ticker-news-box">
                        <span class="breaking-news">breaking news</span>
                        <ul id="js-news">
                            <li class="news-item"><span class="time-news">11:36 pm</span>  <a href="#">Lorem ipsum dolor sit amet, consectetuer adipiscing elit.</a> Donec odio. Quisque volutpat mattis eros... </li>
                            <li class="news-item"><span class="time-news">12:40 pm</span>  <a href="#">Dëshmitarja Abrashi: E kam parë Oliverin në turmë,</a> ndërsa neve na shpëtoi "çika Mille" </li>
                            <li class="news-item"><span class="time-news">11:36 pm</span>  <a href="#">Franca do të bashkëpunojë me Kosovën në fushën e shëndetësisë. </a></li>
                            <li class="news-item"><span class="time-news">01:00 am</span>  <a href="#">DioGuardi, kështu e mbrojti Kosovën në Washington, </a> para serbit Vejvoda </li>
                        </ul>
                    </div>
                </div>
            </section>
            <!-- End ticker-news-section -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-md-2 col-sm-0 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar small-sidebar theiaStickySidebar">
                                <div class="widget review-widget">
                                    <div class="title-section">
                                        <h1><span>Review</span></h1>
                                    </div>
                                    <ul class="nav nav-pills nav-stacked review-posts-list">
                                        <?php
                                        foreach ($articles as $key => $article):
                                            $mKey = $article['article_key'];
                                            $mImage = $article['article_image'];
                                            $mTitle = $article['article_title'];
                                            $mDate = date('d-m-Y H:i:s', strtotime($article['article_date_updated']));
                                        ?>
                                            <li class="<?= $key == 0 ? 'active' : '' ?>">
                                                <a data-toggle="tab" href="#<?= esc($mKey) ?>">
                                                    <div>
                                                        <img src="<?= base_url('uploads/articles/' . $mImage) ?>" alt="">
                                                        <h2><?= esc($mTitle) ?></h2>
                                                        <span class="date">
                                                            <?= esc($mDate) ?>
                                                        </span>
                                                    </div>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7 col-sm-8 content-blocker">
                            <!-- block content -->
                            <div class="block-content">
                                <!-- single-post box -->
                                <div class="single-post-box">
                                    <div class="title-post">
                                        <h1>Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. </h1>
                                        <ul class="post-tags">
                                            <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                            <li><i class="fa fa-user"></i>by <a href="#">John Doe</a></li>
                                            <li><a href="#"><i class="fa fa-comments-o"></i><span>0</span></a></li>
                                            <li><i class="fa fa-eye"></i>872</li>
                                        </ul>
                                    </div>

                                    <div class="share-post-box">
                                        <ul class="share-box">
                                            <li><i class="fa fa-share-alt"></i><span>Share Post</span></li>
                                            <li><a class="facebook" href="#"><i class="fa fa-facebook"></i><span>Share on Facebook</span></a></li>
                                            <li><a class="twitter" href="#"><i class="fa fa-twitter"></i><span>Share on Twitter</span></a></li>
                                            <li><a class="google" href="#"><i class="fa fa-google-plus"></i><span></span></a></li>
                                            <li><a class="linkedin" href="#"><i class="fa fa-linkedin"></i><span></span></a></li>
                                        </ul>
                                    </div>

                                    <div class="post-gallery">
                                        <img src="<?= base_url('assets/site/upload/news-posts/single4.jpg') ?>" alt="">
                                        <span class="image-caption">Cras eget sem nec dui volutpat ultrices.</span>
                                    </div>

                                    <div class="post-content">
                                        <p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Phasellus hendrerit. Pellentesque aliquet nibh nec urna. In nisi neque, aliquet vel, dapibus id, mattis vel, nisi. Sed pretium, ligula sollicitudin laoreet viverra, tortor libero sodales leo, eget blandit nunc tortor eu nibh. Nullam mollis. Ut justo. Suspendisse potenti. Sed egestas, ante et vulputate volutpat, eros pede semper est, vitae luctus metus libero eu augue. Morbi purus libero, faucibus adipiscing, commodo quis, gravida id, est. Sed lectus. Praesent elementum hendrerit tortor. Sed semper lorem at felis. <a href="#">Vestibulum volutpat</a>, lacus a ultrices sagittis, mi neque euismod dui, eu pulvinar nunc sapien ornare nisl. Phasellus pede arcu, dapibus eu, fermentum et, dapibus sed, urna.</p>

                                        <p>Morbi interdum mollis sapien. Sed ac risus. Phasellus lacinia, magna a ullamcorper laoreet, lectus arcu pulvinar risus, vitae facilisis libero dolor a purus. Sed vel lacus. Mauris nibh felis, adipiscing varius, adipiscing in, lacinia vel, tellus. Suspendisse ac urna. Etiam pellentesque mauris ut lectus. Nunc tellus ante, mattis eget, gravida vitae, ultricies ac, leo. Integer leo pede, ornare a, lacinia eu, vulputate vel, nisl.</p>
                                        <p>Suspendisse mauris. Fusce accumsan mollis eros. Pellentesque a diam sit amet mi ullamcorper vehicula. Integer adipiscing risus a sem. Nullam quis massa sit amet nibh viverra malesuada. Nunc sem lacus, accumsan quis, faucibus non, congue vel, arcu. Ut scelerisque hendrerit tellus. Integer sagittis. Vivamus a mauris eget arcu gravida tristique. Nunc iaculis mi in ante. Vivamus imperdiet nibh feugiat est.</p>

                                        <blockquote>
                                            <p>Morbi interdum mollis sapien. Sed ac risus. Phasellus lacinia, magna a ullamcorper laoreet, lectus arcu pulvinar risus, vitae facilisis libero dolor a purus. Sed vel lacus. Mauris nibh felis, adipiscing varius, adipiscing in, lacinia vel, tellus. </p>
                                        </blockquote>
                                    </div>

                                    <div class="article-inpost">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="image-content">
                                                    <div class="image-place">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/single-art2.jpg') ?>" alt="">
                                                        <div class="hover-image">
                                                            <a class="zoom" href="<?= base_url('assets/site/upload/news-posts/single-art2.jpg') ?>"><i class="fa fa-arrows-alt"></i></a>
                                                        </div>
                                                    </div>
                                                    <span class="image-caption">Cras eget sem nec dui volutpat ultrices.</span>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="image-content">
                                                    <div class="image-place">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/single-art3.jpg') ?>" alt="">
                                                        <div class="hover-image">
                                                            <a class="zoom" href="<?= base_url('assets/site/upload/news-posts/single-art3.jpg') ?>"><i class="fa fa-arrows-alt"></i></a>
                                                        </div>
                                                    </div>
                                                    <span class="image-caption">Cras eget sem nec dui volutpat ultrices.</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="post-content">
                                        <p>Suspendisse mauris. Fusce accumsan mollis eros. Pellentesque a diam sit amet mi ullamcorper vehicula. Integer adipiscing risus a sem. Nullam quis massa sit amet nibh viverra malesuada. Nunc sem lacus, accumsan quis, faucibus non, congue vel, arcu. Ut scelerisque hendrerit tellus. Integer sagittis. Vivamus a mauris eget arcu gravida tristique. Nunc iaculis mi in ante. Vivamus imperdiet nibh feugiat est.</p>
                                    </div>

                                    <div class="post-tags-box">
                                        <ul class="tags-box">
                                            <li><i class="fa fa-tags"></i><span>Tags:</span></li>
                                            <li><a href="#">News</a></li>
                                            <li><a href="#">Fashion</a></li>
                                            <li><a href="#">Politics</a></li>
                                            <li><a href="#">Sport</a></li>
                                        </ul>
                                    </div>

                                    <div class="share-post-box">
                                        <ul class="share-box">
                                            <li><i class="fa fa-share-alt"></i><span>Share Post</span></li>
                                            <li><a class="facebook" href="#"><i class="fa fa-facebook"></i>Share on Facebook</a></li>
                                            <li><a class="twitter" href="#"><i class="fa fa-twitter"></i>Share on Twitter</a></li>
                                            <li><a class="google" href="#"><i class="fa fa-google-plus"></i><span></span></a></li>
                                            <li><a class="linkedin" href="#"><i class="fa fa-linkedin"></i><span></span></a></li>
                                        </ul>
                                    </div>

                                    <div class="prev-next-posts">
                                        <div class="prev-post">
                                            <div class="post-content">
                                                <h2><a href="single-post.html" title="prev post">Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. </a></h2>
                                                <ul class="post-tags">
                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    <li><a href="#"><i class="fa fa-comments-o"></i><span>11</span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="next-post">
                                            <div class="post-content">
                                                <h2><a href="single-post.html" title="next post">Donec consectetuer ligula vulputate sem tristique cursus. </a></h2>
                                                <ul class="post-tags">
                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    <li><a href="#"><i class="fa fa-comments-o"></i><span>8</span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="about-more-autor">
                                        <ul class="nav nav-tabs">
                                            <li class="active">
                                                <a href="#about-autor" data-toggle="tab">About The Autor</a>
                                            </li>
                                            <li>
                                                <a href="#more-autor" data-toggle="tab">More From Autor</a>
                                            </li>
                                        </ul>

                                        <div class="tab-content">
                                            <div class="tab-pane active" id="about-autor">
                                                <div class="autor-box">
                                                    <img src="<?= base_url('assets/site/upload/users/avatar1.jpg') ?>" alt="">
                                                    <div class="autor-content">
                                                        <div class="autor-title">
                                                            <h1><span>Jane Smith</span><a href="autor-details.html">18 Posts</a></h1>
                                                            <ul class="autor-social">
                                                                <li><a href="#" class="facebook"><i class="fa fa-facebook"></i></a></li>
                                                                <li><a href="#" class="google"><i class="fa fa-google-plus"></i></a></li>
                                                                <li><a href="#" class="twitter"><i class="fa fa-twitter"></i></a></li>
                                                                <li><a href="#" class="youtube"><i class="fa fa-youtube"></i></a></li>
                                                                <li><a href="#" class="instagram"><i class="fa fa-instagram"></i></a></li>
                                                                <li><a href="#" class="linkedin"><i class="fa fa-linkedin"></i></a></li>
                                                                <li><a href="#" class="dribble"><i class="fa fa-dribbble"></i></a></li>
                                                            </ul>
                                                        </div>
                                                        <p>
                                                            Suspendisse mauris. Fusce accumsan mollis eros. Pellentesque a diam sit amet mi ullamcorper vehicula. Integer adipiscing risus a sem. Nullam quis massa sit amet nibh viverra malesuada. 
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane" id="more-autor">
                                                <div class="more-autor-posts">
                                                    <div class="news-post image-post3">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/im4.jpg') ?>" alt="">
                                                        <div class="hover-box">
                                                            <h2><a href="single-post.html">Donec odio. Quisque volutpat mattis eros.</a></h2>
                                                            <ul class="post-tags">
                                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                            </ul>
                                                        </div>
                                                    </div>

                                                    <div class="news-post image-post3">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/im5.jpg') ?>" alt="">
                                                        <div class="hover-box">
                                                            <h2><a href="single-post.html">Nullam malesuada erat ut turpis. </a></h2>
                                                            <ul class="post-tags">
                                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                            </ul>
                                                        </div>
                                                    </div>

                                                    <div class="news-post image-post3">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/im6.jpg') ?>" alt="">
                                                        <div class="hover-box">
                                                            <h2><a href="single-post.html">Suspendisse urna nibh.</a></h2>
                                                            <ul class="post-tags">
                                                                <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- carousel box -->
                                    <div class="carousel-box owl-wrapper">
                                        <div class="title-section">
                                            <h1><span>You may also like</span></h1>
                                        </div>
                                        <div class="owl-carousel" data-num="3">
                                            <div class="item news-post image-post3">
                                                <img src="<?= base_url('assets/site/upload/news-posts/art1.jpg') ?>" alt="">
                                                <div class="hover-box">
                                                    <h2><a href="single-post.html">Donec odio. Quisque volutpat mattis eros.</a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    </ul>
                                                </div>
                                            </div>

                                            <div class="item news-post image-post3">
                                                <img src="<?= base_url('assets/site/upload/news-posts/art2.jpg') ?>" alt="">
                                                <div class="hover-box">
                                                    <h2><a href="single-post.html">Nullam malesuada erat ut turpis. </a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    </ul>
                                                </div>
                                            </div>

                                            <div class="item news-post video-post">
                                                <img src="<?= base_url('assets/site/upload/news-posts/art3.jpg') ?>" alt="">
                                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                                <div class="hover-box">
                                                    <h2><a href="single-post.html">Lorem ipsum dolor sit consectetuer adipiscing elit. Donec odio. </a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    </ul>
                                                </div>
                                            </div>

                                            <div class="item news-post image-post3">
                                                <img src="<?= base_url('assets/site/upload/news-posts/art4.jpg') ?>" alt="">
                                                <div class="hover-box">
                                                    <h2><a href="single-post.html">Donec nec justo eget felis facilisis fermentum. Aliquam </a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    </ul>
                                                </div>
                                            </div>

                                            <div class="item news-post image-post3">
                                                <img src="<?= base_url('assets/site/upload/news-posts/art5.jpg') ?>" alt="">
                                                <div class="hover-box">
                                                    <h2><a href="single-post.html">Donec odio. Quisque volutpat mattis eros.</a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End carousel box -->

                                    <!-- contact form box -->
                                    <div class="contact-form-box">
                                        <div class="title-section">
                                            <h1><span>Leave a Comment</span> <span class="email-not-published">Your email address will not be published.</span></h1>
                                        </div>
                                        <form id="comment-form">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label for="name">Name*</label>
                                                    <input id="name" name="name" type="text">
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="mail">E-mail*</label>
                                                    <input id="mail" name="mail" type="text">
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="website">Website</label>
                                                    <input id="website" name="website" type="text">
                                                </div>
                                            </div>
                                            <label for="comment">Comment*</label>
                                            <textarea id="comment" name="comment"></textarea>
                                            <button type="submit" id="submit-contact">
                                                <i class="fa fa-comment"></i> Post Comment
                                            </button>
                                        </form>
                                    </div>
                                   <!-- End contact form box -->
                                </div>
                                <!-- End single-post box -->
                            </div>
                            <!-- End block content -->
                        </div>

                        <div class="col-md-3 col-sm-4 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar large-sidebar theiaStickySidebar">
                                <div class="widget features-slide-widget">
                                    <div class="title-section">
                                        <h1><span>Featured Posts</span></h1>
                                    </div>
                                    <div class="image-post-slider">
                                        <ul class="bxslider">
                                            <li>
                                                <div class="news-post image-post2">
                                                    <div class="post-gallery">
                                                        <img src="<?= base_url('assets/site/upload/news-posts/270x240.jpg') ?>" alt="">
                                                        <div class="hover-box">
                                                            <div class="inner-hover">
                                                                <h2><a href="single-post.html">Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. </a></h2>
                                                                <ul class="post-tags">
                                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                                    <li><a href="#"><i class="fa fa-comments-o"></i><span>23</span></a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>																				
                                        </ul>
                                    </div>								
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End sidebar -->
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- list line posts section -->
            <div class="list-line-posts">
                <div class="container">
                    <div class="owl-wrapper">
                        <div class="owl-carousel" data-num="4">
                            <div class="item list-post">
                                <div class="post-content">
                                    <a href="politics-category.html">Opinion</a>
                                    <h2><a href="single-post.html">Donec odio. Quisque volutpat mattis eros. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item list-post">
                                <div class="post-content">
                                    <a href="politics-category.html">World</a>
                                    <h2><a href="single-post.html">Nullam malesuada erat ut turpis. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item list-post">
                                <div class="post-content">
                                    <a href="politics-category.html">Video</a>
                                    <h2><a href="single-post.html">Aliquam porttitor mauris sit amet orci. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item list-post">
                                <div class="post-content">
                                    <a href="politics-category.html">Elections</a>
                                    <h2><a href="single-post.html">Morbi in sem quis dui placerat ornare. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item list-post">
                                <div class="post-content">
                                    <a href="politics-category.html">Nations</a>
                                    <h2><a href="single-post.html">Morbi in sem quis dui placerat ornare. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End list line posts section -->

            <!-- feature-video-section -->
            <section class="feature-video">
                <div class="container">
                    <div class="title-section white">
                        <h1><span>Politics Original Videos</span></h1>
                    </div>

                    <div class="features-video-box owl-wrapper">
                        <div class="owl-carousel" data-num="4">
                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Lorem ipsum dolor sit consectetuer adipiscing elit. Donec odio. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Quisque volutpat mattis eros. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Nullam malesuada erat ut turpis. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede.</a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Lorem ipsum dolor sit consectetuer adipiscing elit. Donec odio. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Quisque volutpat mattis eros. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="item news-post video-post">
                                <img alt="" src="<?= base_url('assets/site/upload/news-posts/270x220.jpg') ?>">
                                <a href="https://www.youtube.com/watch?v=LL59es7iy8Q" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                <div class="hover-box">
                                    <h2><a href="single-post.html">Nullam malesuada erat ut turpis. </a></h2>
                                    <ul class="post-tags">
                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End feature-video-section -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-md-2 col-sm-0 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar small-sidebar theiaStickySidebar">
                                <div class="widget voises-widget">
                                    <div class="title-section">
                                        <h1><span>Voises</span></h1>
                                    </div>
                                    <ul class="voises-posts">
                                        <li>
                                            <img src="<?= base_url('assets/site/upload/users/av1.jpg') ?>" alt="">
                                            <p>Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. </p>
                                            <span>By Howard Kurtz</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-7 col-sm-8 content-blocker">
                            <!-- block content -->
                            <div class="block-content">
                                <!-- article box -->
                                <div class="article-box">
                                    <div class="title-section">
                                        <h1><span>Latest Articles</span></h1>
                                    </div>

                                    <div class="news-post article-post">
                                        <div class="row">
                                            <div class="col-sm-5">
                                                <div class="post-gallery">
                                                    <img alt="" src="<?= base_url('assets/site/upload/news-posts/260x220.jpg') ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-7">
                                                <div class="post-content">
                                                    <a href="politcs-category.html">Politics</a>
                                                    <h2><a href="single-post.html">Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. Cras consequat.</a></h2>
                                                    <ul class="post-tags">
                                                        <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                        <li><i class="fa fa-user"></i>by <a href="#">John Doe</a></li>
                                                        <li><a href="#"><i class="fa fa-comments-o"></i><span>23</span></a></li>
                                                        <li><i class="fa fa-eye"></i>872</li>
                                                    </ul>
                                                    <p>Donec odio. Quisque volutpat mattis eros. Nullam malesuada erat ut turpis. Suspendisse urna nibh, viverra non, semper suscipit, posuere a, pede.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>			
                                </div>
                                <!-- End article box -->

                                <!-- Pagination box -->
                                <div class="pagination-box">
                                    <ul class="pagination-list">
                                        <li><a class="active" href="#">1</a></li>
                                        <li><a href="#">2</a></li>
                                        <li><a href="#">3</a></li>
                                        <li><span>...</span></li>
                                        <li><a href="#">9</a></li>
                                        <li><a href="#">Next</a></li>
                                    </ul>
                                    <p>Page 1 of 9</p>
                                </div>
                                <!-- End Pagination box -->
                            </div>
                            <!-- End block content -->
                        </div>

                        <div class="col-md-3 col-sm-4 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar large-sidebar theiaStickySidebar">
                            <div class="widget features-slide-widget">
                                    <div class="title-section">
                                        <h1><span>Most Discussed</span></h1>
                                    </div>							
                                </div>

                                <div class="widget subscribe-widget">
                                    <form class="subscribe-form">
                                        <h1>Subscribe to RSS Feeds</h1>
                                        <input type="text" name="sumbscribe" id="subscribe" placeholder="Email"/>
                                        <button id="submit-subscribe">
                                            <i class="fa fa-arrow-circle-right"></i>
                                        </button>
                                        <p>Get all latest content delivered to your email a few times a month.</p>
                                    </form>
                                </div>
                            </div>
                            <!-- End sidebar -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer -->
            <footer>
                <div class="container">
                    <div class="footer-widgets-part">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="widget text-widget">
                                    <h1>About</h1>
                                    <p>Donec nec justo eget felis facilisis fermentum. Aliquam porttitor mauris sit amet orci. Aenean dignissim pellentesque felis. </p>
                                    <p>Morbi in sem quis dui placerat ornare. Pellentesque odio nisi, euismod in, pharetra a, ultricies in, diam. Sed arcu. </p>
                                    <a href="<?= base_url() ?>"><img src="<?= base_url('assets/site/images/daksha-logo-white.png') ?>" width="250px;" alt=""></a>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="widget tags-widget">
                                    <h1>Popular Tags</h1>
                                    <ul class="tag-list">
                                        <li><a href="#">News</a></li>
                                        <li><a href="#">Fashion</a></li>
                                        <li><a href="#">Politics</a></li>
                                        <li><a href="#">Sport</a></li>
                                        <li><a href="#">Videos</a></li>
                                        <li><a href="#">Business</a></li>
                                        <li><a href="#">Food</a></li>
                                        <li><a href="#">Travel</a></li>
                                        <li><a href="#">World</a></li>
                                        <li><a href="#">Music</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="widget posts-widget">
                                    <h1>Random Post</h1>
                                    <ul class="list-posts">
                                        <li>
                                            <img src="<?= base_url('assets/site/upload/news-posts/listw4.jpg') ?>" alt="">
                                            <div class="post-content">
                                                <a href="politics-category.html">World</a>
                                                <h2><a href="single-post.html">Pellentesque odio nisi, euismod in ultricies in, diam. </a></h2>
                                                <ul class="post-tags">
                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                </ul>
                                            </div>
                                        </li>
                                        <li>
                                            <img src="<?= base_url('assets/site/upload/news-posts/listw1.jpg') ?>" alt="">
                                            <div class="post-content">
                                                <a href="politics-category.html">Election</a>
                                                <h2><a href="single-post.html">Sed arcu. Cras consequat.</a></h2>
                                                <ul class="post-tags">
                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                </ul>
                                            </div>
                                        </li>
                                        <li>
                                            <img src="<?= base_url('assets/site/upload/news-posts/listw3.jpg') ?>" alt="">
                                            <div class="post-content">
                                                <a href="politics-category.html">Opinion</a>
                                                <h2><a href="single-post.html">Phasellus ultrices nulla quis nibh. Quisque a lectus.</a></h2>
                                                <ul class="post-tags">
                                                    <li><i class="fa fa-clock-o"></i>27 may 2013</li>
                                                </ul>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="widget flickr-widget">
                                    <h1>Flickr Photos</h1>
                                    <ul class="flickr-list">
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/1.jpg') ?>" alt=""></a></li>
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/2.jpg') ?>" alt=""></a></li>
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/3.jpg') ?>" alt=""></a></li>
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/4.jpg') ?>" alt=""></a></li>
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/5.jpg') ?>" alt=""></a></li>
                                        <li><a href="#"><img src="<?= base_url('assets/site/upload/flickr/6.jpg') ?>" alt=""></a></li>
                                    </ul>
                                    <a href="#">View more photos...</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="footer-last-line">
                        <div class="row">
                            <div class="col-md-6">
                                <p>&copy; COPYRIGHT 2020 |  Website Development:Right Turn e Design</p>
                            </div>
                            <div class="col-md-6">
                                <nav class="footer-nav">
                                    <ul>
                                        <li><a href="<?= base_url() ?>">Home</a></li>
                                        <li><a href="<?= base_url() ?>">Purchase Theme</a></li>
                                        <li><a href="<?= base_url('about') ?>">About</a></li>
                                        <li><a href="<?= base_url('contact') ?>">Contact</a></li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- End footer -->

        </div>
        <!-- End Container -->

        <?= $this->include('partials/scripts') ?>
    </body>
</html>