<?php
// File: app/Views/signin.php

// Include header partial
echo view('partials/header');
?>

<body>
    <!-- Container -->
    <div id="container">
        <!-- Header -->
        <?= view('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-4 col-sm-4 col-md-offset-4 mt-standard">
                        <div class="visible-xs visible-sm">
                            <a href="<?= base_url('signup') ?>" class="btn btn-lg btn-theme btn-block text-uppercase"><b>Subscribe to login</b></a>
                        </div>
                        
                        <div class="title-section">
                            <br>
                            <h1><span>Sign In</span></h1>
                        </div>
                        <div class="contact-form-box">
                            <form id="signupForm" action="<?= base_url('users/actionSignin') ?>" method="POST">
                                <?= csrf_field() ?> <!-- CSRF protection -->
                                <div class="row">
                                    <div class="col-md-12">
                                        <label for="mail">E-mail*</label>
                                        <input required id="mail" name="email" type="email">
                                    </div>
                                    <div class="col-md-12">
                                        <label for="website">Password*</label>
                                        <input required id="website" name="password" type="password">
                                    </div>
                                    <div class="col-md-12 mb-2">
                                        <a href="<?= base_url('users/forgotPassword') ?>">Forgot Password ?</a>
                                    </div>
                                </div>
                                <button type="submit" id="submit-contact">
                                    <i class="fa fa-paper-plane"></i> Login
                                </button>
                            </form>
                            <br>
                            <br>
                        </div>
                    </div>
                </div>
                <!-- End sidebar -->
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= view('partials/footer') ?>
        <!-- End footer -->
    </div>
    <!-- End Container -->

    <?= view('partials/scripts') ?>
</body>
</html>