<?php
// File: app/Views/seminars.php

// Include header partial
echo view('partials/header');

// Include navbar partial
echo view('partials/navbar');
?>

<section class="feature-video" style="background-color: #ffffff">
    <div class="container">
        <div class="title-section">
            <h1><span>Daksha Legal Seminars</span></h1>
        </div>

        <div class="features-video-box owl-wrapper">
            <ul class="judgements-list row" id="list" style="list-style: none !important">
                <?php foreach ($seminars as $seminar): 
                    $mVideo = $seminar['seminar_link'];
                    $mTitle = $seminar['seminar_title'];
                    $mDate = new DateTime($seminar['seminar_date_updated']);
                    $mDate = $mDate->format('d-F-Y H:i');
                    $video_id = explode("?v=", $mVideo);
                    $video_id = $video_id[1];
                    $mThumb = "http://i3.ytimg.com/vi/" . $video_id . "/hqdefault.jpg";
                ?>
                    <li class="mb-10 col-md-3">
                        <div class="item news-post video-post">
                            <img alt="" src="<?= esc($mThumb) ?>">
                            <a href="<?= esc($mVideo) ?>" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                            <div class="hover-box">
                                <h2>
                                    <a href="#">
                                        <?= esc($mTitle) ?>
                                    </a>
                                </h2>
                                <ul class="post-tags">
                                    <li><i class="fa fa-clock-o"></i><?= esc($mDate) ?></li>
                                </ul>
                            </div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</section>

<?php
// Include footer partial
echo view('partials/footer');

// Include scripts partial
echo view('partials/scripts');
?>

<script>
    $("#list").JPaging({
        pageSize: 48
    });
</script>