<!doctype html>
<html lang="en" class="no-js">
    <?= $this->include('partials/header') ?>
    <body>
        <!-- Container -->
        <div id="container">
            <!-- Header -->
            <?= $this->include('partials/navbar') ?>
            <!-- End Header -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row mt-standard">
                        <div class="col-md-12 col-sm-12">
                            <div class="widget review-widget">
                                <!-- Search form updated for CodeIgniter 4 -->
                                <form method="POST" action="<?= base_url('search/results') ?>">
                                    <?= csrf_field() ?> <!-- CSRF protection -->
                                    <div class="title-section">
                                        <div class="row mb-10">
                                            <div class="col-md-10">
                                                <input required style="width: 100%" class="form-control" type="text" name="search" placeholder="Search here">
                                            </div>
                                            <div class="col-md-2">
                                                <button type="submit" class="btn btn-default btn-block">
                                                    <i class="fa fa-search"></i> Search
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                                <div class="row">
                                    <div class="col-md-12">
                                        <ul id="list" class="list-unstyled">
                                            <?php if (!empty($results)): ?>
                                                <?php foreach ($results as $result): ?>
                                                    <?php
                                                    // Determine type and set variables accordingly
                                                    switch ($result['type']) {
                                                        case "1":
                                                            $mType = "Article";
                                                            $mImage = base_url('uploads/articles/' . $result['search_img']);
                                                            $mLink = base_url('articles/actionView/' . $result['search_key']);
                                                            break;
                                                        case "2":
                                                            $mType = "Judgement";
                                                            $mImage = base_url('uploads/judgements/' . $result['search_img']);
                                                            $mLink = base_url('judgements/actionView/' . $result['search_key']);
                                                            break;
                                                        default:
                                                            $mType = "News";
                                                            $mImage = base_url('uploads/articles/' . $result['search_img']);
                                                            $mLink = base_url('news/actionView/' . $result['search_key']);
                                                    }

                                                    // Sanitize the title
                                                    $mSearchTitle = $result['search_title'];
                                                    $mViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mSearchTitle);
                                                    $mViewTitle = preg_replace('/\s+/', '-', $mViewTitle);
                                                    ?>
                                                    <li>
                                                        <a href="<?= esc($mLink) ?>">
                                                            <div class="row">
                                                                <div class="col-md-2">
                                                                    <img src="<?= esc($mImage) ?>" class="img-responsive" alt="<?= esc($mViewTitle) ?>" />
                                                                </div>
                                                                <div class="col-md-10">
                                                                    <h5 class="bg-card-theme-title">
                                                                        <?= esc($result['search_title']) ?>
                                                                    </h5>
                                                                    <span class="badge badge-info">Found in <?= esc($mType) ?></span>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <hr>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </li>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer -->
            <?= $this->include('partials/footer') ?>
            <!-- End footer -->
        </div>
        <!-- End Container -->

        <?= $this->include('partials/scripts') ?>

        <script>
            // jQuery pagination script (unchanged as per request)
            $("#list").JPaging({
                pageSize: 5
            });
        </script>
    </body>
</html>