<!DOCTYPE html>
<html lang="en" class="no-js">
<head>
    <title>Law Updates: Latest News and Developments on Various Laws</title>
    <meta name="description" content="Stay informed with the latest news on laws, regulations, and legal developments, covering a wide range of legal topics and updates" />
    <?= $this->include('partials/header') ?>
</head>
<body>
    <!-- Container -->
    <div id="container">
        <style>
            #paging {
                margin-top: 70px !important;
            }
        </style>

        <!-- Header -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row mt-standard">
                    <div class="col-md-12 col-sm-12">
                        <div class="widget review-widget">
                            <div class="title-section">
                                <h1><span>News</span></h1>
                            </div>

                            <ul class="judgements-list row" id="list" style="list-style: none !important">
                                <?php
                                // Loop through articles
                                foreach ($articles as $article):
                                    $mArticleKey = $article['news_key'];
                                    $mArticleImage = base_url('/writable/uploads/articles/' . $article['news_image']);
                                    $mArticleTitle = esc($article['news_title']);
                                    $mArticleDate = new \DateTime($article['news_date']);
                                    $mArticleAuthor = esc($article['aurthor_name']);
                                    $mArticleDate = $mArticleDate->format('d-F-Y');
                                    $mArticleViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mArticleTitle);
                                    $mArticleViewTitle = preg_replace('/  */', '-', $mArticleViewTitle);
                                    $mArticleViewTitle = preg_replace('/\\s+/', '-', $mArticleViewTitle);
                                    $mArticleView = base_url("news/actionView/{$mArticleKey}");
                                ?>
                                    <li>
                                        <div class="col-md-3">
                                            <a href="<?= $mArticleView ?>">
                                                <div class="card card-inner bg-card-theme-inner">
                                                    <img class="img-responsive" src="<?= $mArticleImage ?>" alt="<?= $mArticleTitle ?>">
                                                    <div class="card-body card-body-theme">
                                                        <h5 class="card-title bg-card-theme-title">
                                                            <?= $mArticleTitle ?>
                                                        </h5>
                                                        <ul class="post-tags">
                                                            <li>
                                                                <i class="fa fa-clock-o"></i>
                                                                <span><?= $mArticleDate ?></span>
                                                            </li>
                                                            <li>
                                                                <i class="fa fa-user"></i>
                                                                <span><?= $mArticleAuthor ?></span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- Footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->

    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>

    <script>
        // jQuery pagination (kept as-is)
        $("#list").JPaging({
            pageSize: 48
        });
    </script>
</body>
</html>