<!DOCTYPE html>
<html lang="en" class="no-js">
    <?= $this->include('partials/header') ?>
    <body>
        <!-- Container -->
        <div id="container">
            <!-- Header -->
            <?= $this->include('partials/navbar') ?>
            <!-- End Header -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row mt-standard">
                        <div class="col-md-12 col-sm-12">
                            <div class="widget review-widget">
                                <div class="title-section">
                                    <h1><span>Lawyer Directory</span></h1>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <ul class="nav nav-pills nav-justified">
                                            <?php
                                            $count = 0;
                                            foreach ($district as $districts):
                                                $count++;
                                                $mCourtImage = $districts['district_image'] 
                                                    ? base_url('uploads/district/' . $districts['district_image'])
                                                    : base_url("assets/site/images/supreme.jpg");
                                            ?>
                                                <li class="<?= $count == 1 ? 'active' : '' ?>">
                                                    <a data-toggle="pill" href="#<?= esc($districts['district_key']) ?>">
                                                        <div class="court-card">
                                                            <div class="row">
                                                                <div class="col-md-9">
                                                                    <h5 class="card-title bg-card-theme-title">
                                                                        <?= esc($districts['district_name']) ?>
                                                                    </h5>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>

                                        <div class="tab-content">
                                            <br>
                                            <?php
                                            $count = 0;
                                            foreach ($district as $districts):
                                                $count++;
                                                // Assuming you've updated your model names and method calls
                                                $new_lawyers = model('NewLawyersModel')->getParentByCourtKey($districts['district_key']);
                                            ?>
                                                <div id="<?= esc($districts['district_key']) ?>" class="tab-pane fade <?= $count == 1 ? 'in active' : '' ?>">
                                                    <div class="row">
                                                        <?php foreach ($new_lawyers as $new_lawyer): 
                                                            $mSubCourtImage = $new_lawyer['new_lawyers_image']
                                                                ? base_url('uploads/courts/' . $new_lawyer['new_lawyers_image'])
                                                                : base_url("assets/site/images/user.png");
                                                            $mLink = base_url("district/actionView/" . $new_lawyer['new_lawyers_key']);
                                                        ?>
                                                            <div class="col-md-3">
                                                                <a href="<?= esc($mLink) ?>">
                                                                    <div class="card-court bg-card-theme-inner-court">
                                                                        <img style="height: 100px" class="img-responsive" src="<?= esc($mSubCourtImage) ?>" alt="<?= esc($new_lawyer['new_lawyers_name']) ?>">
                                                                        <div class="card-body card-body-theme">
                                                                            <h5 class="card-title bg-card-theme-title">
                                                                                <?= esc($new_lawyer['new_lawyers_name']) ?>
                                                                            </h5>
                                                                        </div>
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer -->
            <?= $this->include('partials/footer') ?>
            <!-- End footer -->
        </div>
        <!-- End Container -->

        <?= $this->include('partials/scripts') ?>
    </body>
</html>