<!DOCTYPE html>
<html lang="en" class="no-js">
<?= $this->include('partials/header') ?>
<body>

    <!-- Container -->
    <div id="container">

        <!-- navbar -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row">
                    <br/>

                    <div class="col-md-10">
                        <input class="form-control" type="text" id="myInput" placeholder="Search" title="Type in a name">
                    </div>

                    <div class="col-md-2">
                        <?php if ($sort == "Sort Alphabetically"): ?>
                            <a href="<?= site_url('lawyers/actionSort/sort') ?>" class="btn btn-block btn-default"><?= esc($sort) ?></a>
                        <?php else: ?>
                            <a href="<?= site_url('lawyers') ?>" class="btn btn-block btn-default"><?= esc($sort) ?></a>
                        <?php endif; ?>
                        <br/>
                    </div>

                    <?php foreach ($lawyers as $count => $lawyer): ?>
                        <?php if (!empty($lawyer['Lawyer_Name'])): ?>
                            <?php
                            $mImage = empty($lawyer['Image']) ? base_url('assets/site/images/user.png') : base_url('uploads/lawyers/' . $lawyer['Image']);
                            ?>
                            <div id="myModal<?= $count ?>" class="modal">
                                <!-- Modal content -->
                                <div class="modal-content">
                                    <span class="close<?= $count ?> close-icon">&times;</span>

                                    <div class="row">
                                        <br>
                                        <div class="col-md-5 modal-img">
                                            <img src="<?= esc($mImage) ?>" class="img-responsive" alt="<?= esc($lawyer['Lawyer_Name']) ?>">
                                        </div>
                                        <div class="col-md-7">
                                            <h2 class="mt-3 lawyer-name"><?= esc($lawyer['Lawyer_Name']) ?></h2>
                                            <br>
                                            <div class="badges">
                                                <span class="badge badge-primary mb-2">Phone No : <?= esc($lawyer['Phone_Number']) ?></span>
                                                <br>
                                                <?php if (!empty($lawyer['Email_Id'])): ?>
                                                    <span class="badge badge-primary mb-2">Email ID : <?= esc($lawyer['Email_Id']) ?></span>
                                                    <br>
                                                <?php endif; ?>
                                                <span class="badge badge-primary mb-2">
                                                    Practice Areas : 
                                                    <?= esc($lawyer['Practice_Areas'] ?? 'Civil') ?>
                                                </span>
                                                <br>
                                                <?php if (!empty($lawyer['Address'])): ?>
                                                    <span class="badge badge-primary mb-2">Address : <?= esc($lawyer['Address']) ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>

                    <ul id="list" style="list-style: none !important">
                        <?php foreach ($lawyers as $count => $lawyer): ?>
                            <?php if (!empty($lawyer['Lawyer_Name'])): ?>
                                <?php
                                $mImage = empty($lawyer['Image']) ? base_url('assets/site/images/user.png') : base_url('uploads/lawyers/' . $lawyer['Image']);
                                ?>
                                <li>
                                    <div class="gallery_product mb-3 col-lg-2 col-md-2 col-sm-3 col-xs-6 filter Civil">
                                        <a href="#" id="myBtn<?= $count ?>" class="zoomcard-parent">
                                            <div class="zoom-effect-container">
                                                <div class="image-card">
                                                    <img src="<?= esc($mImage) ?>" class="img-responsive" alt="<?= esc($lawyer['Lawyer_Name']) ?>">
                                                </div>
                                            </div>
                                            <div class="zoom-card">
                                                <h4 class="mt-3"><?= esc($lawyer['Lawyer_Name']) ?></h4>
                                            </div>
                                        </a>
                                    </div>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>

                </div>
                <!-- End sidebar -->
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->

    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>

    <script>
    $(document).ready(function () {
        <?php foreach ($lawyers as $count => $lawyer): ?>
            <?php if (!empty($lawyer['Lawyer_Name'])): ?>
                // Get the modal
                var modal<?= $count ?> = document.getElementById("myModal<?= $count ?>");
                // Get the button that opens the modal
                var btn<?= $count ?> = document.getElementById("myBtn<?= $count ?>");
                // Get the <span> element that closes the modal
                var span<?= $count ?> = document.getElementsByClassName("close<?= $count ?>")[0];
                // When the user clicks the button, open the modal 
                btn<?= $count ?>.onclick = function () {
                    modal<?= $count ?>.style.display = "block";
                }

                // When the user clicks on <span> (x), close the modal
                span<?= $count ?>.onclick = function () {
                    modal<?= $count ?>.style.display = "none";
                }

                // When the user clicks anywhere outside of the modal, close it
                window.onclick = function (event) {
                    if (event.target == modal<?= $count ?>) {
                        modal<?= $count ?>.style.display = "none";
                    }
                }
            <?php endif; ?>
        <?php endforeach; ?>

        function sortUnorderedList(ul, sortDescending) {
            if (typeof ul == "string")
                ul = document.getElementById("list");

            var lis = ul.getElementsByTagName("LI");
            var vals = [];

            for (var i = 0, l = lis.length; i < l; i++)
                vals.push(lis[i].innerHTML);

            vals.sort();

            if (sortDescending)
                vals.reverse();

            for (var i = 0, l = lis.length; i < l; i++)
                lis[i].innerHTML = vals[i];
        }

        window.onload = function () {
            var desc = false;
            document.getElementById("test").onclick = function () {
                sortUnorderedList("list", desc);
                desc = !desc;
                return false;
            }
        }
    });

    $('#myInput').keyup(function () {
        var value = $(this).val().toLowerCase();
        $('#list li').each(function () {
            var lcval = $(this).text().toLowerCase();
            if (lcval.indexOf(value) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    $("#list").JPaging({
        pageSize: 12
    });
    </script>

</body>
</html>