<!DOCTYPE html>
<html lang="en" class="no-js">
    <?= $this->include('partials/header') ?>
    <body>
        <!-- Container -->
        <div id="container">
            <!-- Header -->
            <?= $this->include('partials/navbar') ?>
            <!-- End Header -->

            <!-- block-wrapper-section -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12 col-sm-12 mt-standard">
                            <div class="title-section">
                                <br>
                                <h1><span>Lawyer Profile</span></h1>
                            </div>
                            <div class="contact-form-box">
                                <?php
                                $mImage = $profile['Image'] 
                                    ? base_url('uploads/lawyers/' . $profile['Image'])
                                    : "https://via.placeholder.com/800x400";
                                ?>

                                <?= form_open_multipart('home/actionLawyerProfile/' . $profile['L_id'], ['id' => 'signupForm']) ?>
                                    <div class="row">
                                        <div class="col-md-12 text-center mb-2">
                                            <img id="previewImage" height="130" width="130" class="card-img-top" src="<?= esc($mImage) ?>" alt="Article Image">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="name">Name*</label>
                                            <input value="<?= esc($profile['Lawyer_Name']) ?>" required id="name" name="name" type="text">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="experience">Experience*</label>
                                            <input value="<?= esc($profile['Experience']) ?>" required id="experience" name="experience" type="text">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="mail">E-mail*</label>
                                            <input value="<?= esc($profile['Email_Id']) ?>" required id="mail" name="email" type="email">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="mobile">Mobile*</label>
                                            <input <?= $profile['Phone_Number'] ? 'readonly' : '' ?> value="<?= esc($profile['Phone_Number']) ?>" required id="mobile" name="mobile" type="tel">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="practice">Practice Areas*</label>
                                            <textarea required id="practice" name="practice"><?= esc($profile['Practice_Areas']) ?></textarea>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="address">Address*</label>
                                            <textarea required id="address" name="address"><?= esc($profile['Address']) ?></textarea>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="image">Image*</label>
                                            <input required name="image" id="image" type="file" />  
                                        </div>
                                    </div>
                                    <button class="btn btn-lg btn-theme text-uppercase" type="submit" id="submit-contact">
                                        <i class="fa fa-paper-plane"></i> Submit
                                    </button>
                                <?= form_close() ?>
                                <br>
                                <br>
                            </div>
                        </div>
                    </div>
                    <!-- End sidebar -->
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer -->
            <?= $this->include('partials/footer') ?>
            <!-- End footer -->
        </div>
        <!-- End Container -->

        <?= $this->include('partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>