<!DOCTYPE html>
<html lang="en" class="no-js">
<head>
    <title>ವಿವಿಧ ಕಾನೂನುಗಳ ಲೇಖನಗಳು: ನಾನಾ ಕಾನೂನುಗಳ ಬಗ್ಗೆ ಲೇಖನಗಳು</title>
    <meta name="description" content="ವಿವಿಧ ಕಾನೂನುಗಳ ಬಗ್ಗೆ ಲೇಖನಗಳು: ವಿವಿಧ ಕಾನೂನುಗಳ ಬಗ್ಗೆ ಮಾಹಿತಿ ಮತ್ತು ಲೇಖನಗಳು" />
    <?= $this->include('partials/header') ?>
</head>
<body>
    <!-- Container -->
    <div id="container">
        <style>
            #paging {
                margin-top: 70px !important;
            }
        </style>

        <!-- Header -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row mt-standard">
                    <div class="col-md-12 col-sm-12">
                        <div class="widget review-widget">
                            <div class="title-section">
                                <h1><span>Kannada Articles</span></h1>
                            </div>

                            <ul class="judgements-list row" id="list" style="list-style: none !important">
                                <?php foreach ($articles as $article): ?>
                                    <?php
                                    $mArticleKey = $article['kannada_key'];
                                    $mArticleImage = base_url('uploads/kannada/' . $article['kannada_image']);
                                    $mArticleTitle = $article['kannada_title'];
                                    $mArticleDesc = $article['kannada_data'];
                                    $mArticleDate = new DateTime($article['kannada_date']);
                                    $mArticleDate = $mArticleDate->format('d-F-Y');
                                    $mArticleView = base_url('kannada/actionView/' . $mArticleKey);
                                    ?>
                                    <li>
                                        <div class="col-md-3">
                                            <a href="<?= esc($mArticleView) ?>">
                                                <div class="card card-inner bg-card-theme-inner">
                                                    <img class="img-responsive" src="<?= esc($mArticleImage) ?>" alt="<?= esc($mArticleTitle) ?>">
                                                    <div class="card-body card-body-theme">
                                                        <h5 class="card-title bg-card-theme-title">
                                                            <?= esc($mArticleTitle) ?>
                                                        </h5>
                                                        <ul class="post-tags">
                                                            <li>
                                                                <i class="fa fa-clock-o"></i>
                                                                <span>
                                                                    <?= esc($mArticleDate) ?>
                                                                </span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->

    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>

    <script>
        $("#list").JPaging({
            pageSize: 48
        });
    </script>

</body>
</html>