<!DOCTYPE html>
<html lang="en" class="no-js">
<head>
    <title>Karnataka High Court & Supreme Court Judgments: Latest Rulings</title>
    <meta name="description" content="Stay updated with the latest judgments from the Karnataka High Court and Supreme Court, offering valuable insights into legal precedents and rulings" />
    <meta property="og:title" content="Judgments">
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://www.dakshalegal.com/judgements" />
    <?= $this->include('partials/header') ?>
</head>
<body>

    <!-- Container -->
    <div id="container">

        <style>
            #paging {
                margin-top: 70px !important;
            }
        </style>

        <!-- Header -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row mt-standard">
                    <div class="col-md-12 col-sm-12">
                        <div class="widget review-widget">
                            <div class="title-section">
                                <h1><span>Judgements</span></h1>
                            </div>

                            <ul class="judgements-list row" id="list" style="list-style: none !important">
                                <?php
                                $count = 0;
                                foreach ($judgements as $key => $judgement):
                                    $count++;
                                    $mJudgementKey = $judgement['judgement_key'];
                                    $mJudgementImage = base_url('uploads/judgements/' . $judgement['judgement_img']);
                                    $mJudgementTitle = $judgement['judgement_title'];
                                    $mJudgementDesc = $judgement['judgement_desc'];
                                    $mJudgementTag = $judgement['category'];
                                    $mJudgementAuthor = $judgement['author_name'];
                                    $mJudgementDate = new DateTime($judgement['judgement_date']);
                                    $mJudgementDate = $mJudgementDate->format('d-F-Y');
                                    $mJudgementViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mJudgementTitle);
                                    $mJudgementViewTitle = preg_replace('/  */', '-', $mJudgementViewTitle);
                                    $mJudgementViewTitle = preg_replace('/\\s+/', '-', $mJudgementViewTitle);
                                    $mJudgementView = base_url("judgements/actionView/{$mJudgementKey}");
                                ?>
                                <li>
                                    <div class="col-md-3">
                                        <a href="<?= esc($mJudgementView) ?>">
                                            <div class="card card-inner bg-card-theme-inner">
                                                <img class="img-responsive" src="<?= esc($mJudgementImage) ?>" alt="<?= esc($mJudgementTitle) ?>">
                                                <div class="card-body card-body-theme">
                                                    <h5 class="card-title bg-card-theme-title">
                                                        <?= esc($mJudgementTitle) ?>
                                                    </h5>
                                                    <ul class="post-tags">
                                                        <li>
                                                            <i class="fa fa-clock-o"></i>
                                                            <span><?= esc($mJudgementDate) ?></span>
                                                        </li>
                                                        <li>
                                                            <i class="fa fa-user"></i>
                                                            <span><?= esc($mJudgementAuthor) ?></span>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <!-- Commented out TOP Judgement label -->
                                                <!--<span class="top-stories-theme">TOP Judgement</span>-->
                                            </div>
                                        </a>
                                    </div>
                                </li>
                                <?php endforeach; ?>
                            </ul>

                        </div>
                    </div>
                </div>
                <!-- End sidebar -->
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->

    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>

    <script>
        // Initialize JPaging plugin for pagination
        $("#list").JPaging({
            pageSize: 48
        });
    </script>

</body>
</html>