<!doctype html>
<html lang="en" class="no-js">
    <title>Legal Insights: Articles, Bare Acts, Judgements & News</title>
    <meta name="description" content="Welcome to our comprehensive lawyers' website offering articles, bare acts, judgments, and news, providing valuable legal resources and updates" />
    <?= view('partials/header'); ?>
    <body>

        <!-- Container -->
        <div id="container">

            <!-- Header
                ================================================== -->
            <?= view('partials/navbar'); ?>
            <!-- End Header -->
          <style>
            .white-color li {
                color: white !important;
            }
          </style>

            <!-- heading-news-section2
                    ================================================== -->
            <section class="heading-news2">

                <div class="container">

                    <div class="row" style="margin-top: 25px">

                        <?php
                        $count = 0;
                        foreach (array_slice($judgements, 0, 2, true) as $key => $judgement):
                            $count++;
                            $mJudgementKey = $judgement['judgement_key'];
                            $mJudgementImage = base_url('uploads/judgements/' . $judgement['judgement_img']);
                            $mJudgementTitle = $judgement['judgement_title'];
                            $mJudgementDesc = $judgement['judgement_desc'];
                            $mJudgementTag = $judgement['category'];
                            $mJudgementAuthor = $judgement['author_name'];
                            $mJudgementDate = new DateTime($judgement['judgement_date']);
                            $mJudgementDate = $mJudgementDate->format('d-F-Y');
                            $mJudgementViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mJudgementTitle);
                            $mJudgementViewTitle = preg_replace('/  */', '-', $mJudgementViewTitle);
                            $mJudgementViewTitle = preg_replace('/\\s+/', '-', $mJudgementViewTitle);
                            $mJudgementView = base_url('judgements/actionView/') . $mJudgementKey;
                            ?>

                            <div class="col-md-4">
                                <a href="<?= $mJudgementView ?>">
                                    <div class="card bg-card-theme-banner">
                                        <img class="img-responsive" src="<?= $mJudgementImage ?>" alt="<?= $mJudgementTitle ?>">
                                        <div class="card-body card-body-theme">
                                            <h5 style="color: #ffffff !important" class="card-title bg-card-theme-title">
                                                <?= $mJudgementTitle ?>
                                            </h5>
                                            <ul class="post-tags white-color">
                                                <li>
                                                    <i class="fa fa-clock-o"></i>
                                                    <span>
                                                        <?= $mJudgementDate ?>
                                                    </span>
                                                </li>
                                                <li>
                                                    <i class="fa fa-user"></i>
                                                    <span>
                                                        <?= $mJudgementAuthor ?>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                        <span class="top-stories-theme">Judgement</span>
                                    </div>
                                </a>
                            </div>

                        <?php endforeach; ?>

                        <?php
                        $count = 0;
                        foreach (array_slice($articles, 0, 1, true) as $key => $article):
                            $count++;
                            $mArticleKey = $article['article_key'];
                            $mArticleImage = base_url('uploads/articles/' . $article['article_image']);
                            $mArticleTitle = $article['article_title'];
                            $mArticleDesc = $article['article_description'];
                            $mArticleDate = new DateTime($article['article_date']);
                            $mArticleAuthor = $article['author_name'];
                            $mArticleDate = $mArticleDate->format('d-F-Y');
                            $mArticleViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mArticleTitle);
                            $mArticleViewTitle = preg_replace('/  */', '-', $mArticleViewTitle);
                            $mArticleViewTitle = preg_replace('/\\s+/', '-', $mArticleViewTitle);
                            $mArticleView = base_url('articles/actionView/' . $mArticleKey);
                            ?>

                            <div class="col-md-4">
                                <a href="<?= $mArticleView ?>">
                                    <div class="card bg-card-theme-banner">
                                        <img class="img-responsive" src="<?= $mArticleImage ?>" alt="<?= $mArticleTitle ?>">
                                        <div class="card-body card-body-theme">
                                            <h5 style="color: #ffffff !important" class="card-title bg-card-theme-title">
                                                <?= $mArticleTitle ?>
                                            </h5>
                                            <ul class="post-tags white-color">
                                                <li>
                                                    <i class="fa fa-clock-o"></i>
                                                    <span>
                                                        <?= $mArticleDate ?>
                                                    </span>
                                                </li>
                                                <li>
                                                    <i class="fa fa-user"></i>
                                                    <span>
                                                        <?= $mArticleAuthor ?>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                        <span class="top-stories-theme">Article</span>
                                    </div>
                                </a>
                            </div>

                        <?php endforeach; ?>

                    </div>
                </div>

            </section>
            <!-- End heading-news-section -->

            <section class="ticker-news">

                <div class="container">
                    <div class="ticker-news-box">
                        <span style="font-size: 17px" class="breaking-news">News</span>
                        <ul id="js-news">
                            <?php
                            $count = 0;
                            foreach (array_slice($news, 0, 4, true) as $key => $new):
                                $count++;
                                $mArticleKey = $new['news_key'];
                                $mArticleImage = base_url('uploads/articles/' . $new['news_image']);
                                $mArticleTitle = $new['news_title'];
                                $mArticleDesc = $new['news_description'];
                                $mArticleDate = new DateTime($new['news_date']);
                                // $mArticleAuthor = $new['aurthor_name'];
                                $mArticleDate = $mArticleDate->format('d-F-Y');
                                $mArticleViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mArticleTitle);
                                $mArticleViewTitle = preg_replace('/  */', '-', $mArticleViewTitle);
                                $mArticleViewTitle = preg_replace('/\\s+/', '-', $mArticleViewTitle);
                                $mArticleView = base_url('news/actionView/' . $mArticleKey);
                                ?>
                                <li class="news-item">
                                    <span style="font-size: 17px" class="time-news"><?= $mArticleDate ?></span> 
                                    <a href="<?= $mArticleView ?>" style="font-size: 17px">
                                        <?= $mArticleTitle ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>

            </section>

            <!-- block-wrapper-section
                    ================================================== -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">

                        <div class="col-md-9 col-sm-8 sidebar-sticky">
                            <!-- sidebar -->
                            <div class="sidebar small-sidebar theiaStickySidebar">

                                <div class="widget review-widget">
                                    <div class="row">

                                        <?php
                                        $count = 0;
                                        unset($judgements[0]);
                                        unset($judgements[1]);
                                        foreach (array_slice($judgements, 0, 6, true) as $key => $judgement):
                                            $count++;
                                            $mJudgementKey = $judgement['judgement_key'];
                                            $mJudgementImage = base_url('uploads/judgements/' . $judgement['judgement_img']);
                                            $mJudgementTitle = $judgement['judgement_title'];
                                            $mJudgementDesc = $judgement['judgement_desc'];
                                            $mJudgementTag = $judgement['category'];
                                            $mJudgementAuthor = $judgement['author_name'];
                                            $mJudgementDate = new DateTime($judgement['judgement_date']);
                                            $mJudgementDate = $mJudgementDate->format('d-F-Y');
                                            $mJudgementViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mJudgementTitle);
                                            $mJudgementViewTitle = preg_replace('/  */', '-', $mJudgementViewTitle);
                                            $mJudgementViewTitle = preg_replace('/\\s+/', '-', $mJudgementViewTitle);
                                            $mJudgementView = base_url('judgements/actionView/') . $mJudgementKey;
                                            ?>

                                            <div class="col-md-6">
                                                <a href="<?= $mJudgementView ?>">
                                                    <div class="card bg-card-theme">
                                                        <img class="img-responsive" src="<?= $mJudgementImage ?>" alt="<?= $mJudgementTitle ?>">
                                                        <div class="card-body card-body-theme">
                                                            <h5 class="card-title bg-card-theme-title">
                                                                <?= $mJudgementTitle ?>
                                                            </h5>
                                                            <ul class="post-tags">
                                                                <li>
                                                                    <i class="fa fa-clock-o"></i>
                                                                    <span>
                                                                        <?= $mJudgementDate ?>
                                                                    </span>
                                                                </li>
                                                                <li>
                                                                    <i class="fa fa-user"></i>
                                                                    <span>
                                                                        <?= $mJudgementAuthor ?>
                                                                    </span>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <span class="top-stories-theme">Judgement</span>
                                                    </div>
                                                </a>
                                            </div>

                                        <?php endforeach; ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 col-sm-4 sidebar-sticky">
                            <br>
                            <div class="signupimage">
                                <a href="<?= base_url('home/signup') ?>">
                                    <img style="margin-top: 10px !important" class="img-responsive" src="<?= base_url('assets/site/images/right-signup.jpg') ?>" alt="Become A Member Get Instant Update" />
                                </a>
                            </div>
                            <br>
                        </div>
                    </div>
                    <!-- End sidebar -->
                </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- feature-video-section 
                    ================================================== -->
            <section class="feature-video">
                <div class="container">
                    <div class="title-section white">
                        <h1><span>Daksha Legal Seminars</span></h1>
                    </div>
                    <div class="features-video-box owl-wrapper">
                        <div class="owl-carousel" data-num="4">

                            <?php foreach ($seminars as $key => $seminar):
                                $mVideo = $seminar['seminar_link'];
                                $mTitle = $seminar['seminar_title'];
                                $mDateSemi = new DateTime($seminar['seminar_date_updated']);
                                $mDateSemi = $mDateSemi->format('d-F-Y H:i');
                                $video_id = explode("?v=", $mVideo);
                                $video_id = $video_id[1];
                                $mThumb = "http://i3.ytimg.com/vi/" . $video_id . "/hqdefault.jpg";
                                ?>
                                <div class="item news-post video-post">
                                    <img alt="" src="<?= $mThumb ?>">
                                    <a href="<?= $mVideo ?>" class="video-link"><i class="fa fa-play-circle-o"></i></a>
                                    <div class="hover-box">
                                        <h2>
                                            <a href="#">
                                                <?= $mTitle ?>
                                            </a>
                                        </h2>
                                        <ul class="post-tags">
                                            <li><i class="fa fa-clock-o"></i><?= $mDateSemi ?></li>
                                        </ul>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </div>

                    </div>
                </div>
            </section>
            <!-- End feature-video-section -->

            <!-- block-wrapper-section
                    ================================================== -->
            <section class="block-wrapper">
                <div class="container">
                    <div class="row">

                        <div class="col-md-12 col-sm-8 content-blocker">

                            <!-- block content -->
                            <div class="block-content">

                                <!-- article box -->
                                <div class="article-box">

                                    <div class="row">
                                        <?php
                                        $count = 0;
                                        foreach (array_slice($articles, 1, 6, true) as $key => $articleinner):
                                            $count++;
                                            $mKey = $articleinner['article_key'];
                                            $mImage = base_url('uploads/articles/' . $articleinner['article_image']);
                                            $mTitle = $articleinner['article_title'];
                                            $mDesc = $articleinner['article_description'];
                                            $mDate = new DateTime($articleinner['article_date']);
                                            $mAuthor = $articleinner['author_name'];
                                            $mDate = $mDate->format('d-F-Y');
                                            $mViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $mTitle);
                                            $mViewTitle = preg_replace('/  */', '-', $mViewTitle);
                                            $mViewTitle = preg_replace('/\\s+/', '-', $mViewTitle);
                                            $mView = base_url('articles/actionView/' . $mKey);
                                            ?>

                                            <div class="col-md-4">
                                                <a href="<?= $mView ?>">
                                                    <div class="card bg-card-theme-banner">
                                                        <img class="img-responsive" src="<?= $mImage ?>" alt="<?= $mTitle ?>">
                                                        <div class="card-body card-body-theme">
                                                            <h5 class="card-title bg-card-theme-title">
                                                                <?= $mTitle ?>
                                                            </h5>
                                                            <ul class="post-tags">
                                                                <li>
                                                                    <i class="fa fa-clock-o"></i>
                                                                    <span>
                                                                        <?= $mDate ?>
                                                                    </span>
                                                                </li>
                                                                <li>
                                                                    <i class="fa fa-user"></i>
                                                                    <span>
                                                                        <?= $mAuthor ?>
                                                                    </span>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <span class="top-stories-theme">Article</span>
                                                    </div>
                                                </a>
                                            </div>

                                        <?php endforeach; ?>

                                    </div>

                                </div>
                                <!-- End article box -->

                            </div>
                            <!-- End block content -->

                        </div>

                    </div>
            </section>
            <!-- End block-wrapper-section -->

            <!-- footer 
                    ================================================== -->
            <?= view('partials/footer') ?>
            <!-- End footer -->

        </div>
        <!-- End Container -->

        <?= view('partials/scripts') ?>

    </body>
</html>