<!DOCTYPE html>
<html lang="en">
<head>
    <title>Courts in India: Explore the Judicial System and Different Courts</title>
    <meta name="description" content="Explore a comprehensive list of courts in India, including details about different levels of judiciary and their jurisdictions across the country" />
    <?= $this->include('partials/header') ?>
</head>
<body>
    <!-- Container -->
    <div id="container">
        <!-- Header -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row mt-standard">
                    <div class="col-md-12 col-sm-12">
                        <div class="widget review-widget">
                            <div class="title-section">
                                <h1><span>Courts</span></h1>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <ul class="nav nav-pills nav-justified">
                                        <?php foreach ($courts as $index => $court): ?>
                                            <?php
                                            $courtImage = $court['court_image'] 
                                                ? base_url('uploads/courts/' . $court['court_image'])
                                                : base_url("assets/site/images/supreme.jpg");
                                            ?>
                                            <li class="<?= $index === 0 ? 'active' : '' ?>">
                                                <a data-toggle="pill" href="#<?= esc($court['court_key']) ?>">
                                                    <div class="court-card">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <img class="img-responsive" src="<?= esc($courtImage) ?>" alt="<?= esc($court['court_name']) ?>">
                                                            </div>
                                                            <div class="col-md-9">
                                                                <h5 class="card-title bg-card-theme-title">
                                                                    <?= esc($court['court_name']) ?>
                                                                </h5>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>

                                    <div class="tab-content">
                                        <br>
                                        <?php foreach ($courts as $index => $court): ?>
                                            <?php
                                            $subcourts = model('SubcourtModel')->getParentByCourtKey($court['court_key']);
                                            ?>
                                            <div id="<?= esc($court['court_key']) ?>" class="tab-pane fade <?= $index === 0 ? 'in active' : '' ?>">
                                                <div class="row">
                                                    <?php foreach ($subcourts as $subcourt): ?>
                                                        <?php
                                                        $subCourtImage = $subcourt['subcourt_image']
                                                            ? base_url('uploads/courts/' . $subcourt['subcourt_image'])
                                                            : base_url("assets/site/images/supreme.jpg");
                                                        $link = base_url("courts/actionView/" . $subcourt['subcourt_key']);
                                                        ?>
                                                        <div class="col-md-3">
                                                            <a href="<?= esc($link) ?>">
                                                                <div class="card-court bg-card-theme-inner-court">
                                                                    <img style="height: 100px" class="img-responsive" src="<?= esc($subCourtImage) ?>" alt="<?= esc($subcourt['subcourt_name']) ?>">
                                                                    <div class="card-body card-body-theme">
                                                                        <h5 class="card-title bg-card-theme-title">
                                                                            <?= esc($subcourt['subcourt_name']) ?>
                                                                        </h5>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->
    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>
</body>
</html>