<!DOCTYPE html>
<html lang="en">  
<head>
    <title>DCM</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
    <script src="<?= base_url('assets/js/jspdf.min.js') ?>"></script>

    <style>
        @page {
            size: a4 portrait; 
            margin:0;padding:0;
        } 
        td{
            font-size: 13px;
            font-weight: 500;
        }
        th{
            font-size: 14px;
        }
        img{
            margin: 10px !important
        }
    </style>
</head>
<body>
    <script type="text/php">
        if ( isset($pdf) ) {
            $x = 520;
            $y = 800;
            $text = "{PAGE_NUM} of {PAGE_COUNT}";
            $font = $fontMetrics->get_font("helvetica", "bold");
            $size = 8;
            $color = array(0,0,0);
            $word_space = 0.0;
            $char_space = 0.0;
            $angle = 0.0;
            $pdf->page_text($x, $y, $text, $font, $size, $color, $word_space, $char_space, $angle);
        }
    </script>

    <div class="logo-advertisement">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <a href="#">
                        <img src="<?= base_url('assets/site/images/Daksha-Logo.png') ?>" width="350px;" alt="Daksha Logo">
                    </a>
                    <hr>
                </div>
            </div>
        </div>
    </div>
    <section>
        <div id="content">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 content-blocker">
                        <div class="title-section">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <h1 style="text-transform: capitalize !important;font-size: 20px">
                                        <?= esc($bareact['ba_title']) ?>
                                    </h1>
                                </div>
                            </div>
                        </div>

                        <div class="image-post-slider">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="2">Contents</th>
                                    </tr>
                                    <tr>
                                        <th>Sections</th>
                                        <th>Particulars</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 0;
                                    foreach ($sections as $section):
                                        $count++;
                                        $data = json_decode($section['sec_data']);
                                        $key = $section['sec_key'];
                                    ?> 
                                    <tr>
                                        <td><b><?= esc($section['sec_title']) ?></b></td>
                                        <td><b><?= esc($section['sec_particular']) ?></b></td>
                                    </tr>

                                    <?php if ($section['sec_subtitle']): ?>
                                    <tr>
                                        <td><b><?= esc($section['sec_subtitle']) ?></b></td>
                                        <td><b><?= esc($section['sec_subparticular']) ?></b></td>
                                    </tr>
                                    <?php endif; ?>

                                    <?php
                                    $seccount = 0;
                                    foreach ($data as $value):
                                        $seccount++;
                                    ?>
                                    <tr>
                                        <td colspan="2">
                                            <div class="panel-group panel-group-theme">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <a data-toggle="collapse" href="#sec<?= $count . $seccount ?>" class="ba-anchor">
                                                            <b><?= esc($value[0]) ?></b>
                                                        </a>
                                                    </div>
                                                    <div id="sec<?= $count . $seccount ?>" class="panel-collapse collapsed">
                                                        <div class="panel-body">
                                                            <?= $value[1] ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</body>
</html>