<!DOCTYPE html>
<html lang="en" class="no-js">
<head>
    <title>Online Bare Acts: Access Law Bare Acts Easily</title>
    <meta name="description" content="Access a comprehensive collection of online bare acts, providing instant and convenient access to the legislation governing various legal domains" />
    <meta property="og:title" content="Bare Acts">
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://www.dakshalegal.com/bareacts" />
    <?= $this->include('partials/header') ?>
</head>
<body>
    <!-- Container -->
    <div id="container">
        <!-- navbar -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 content-blocker">
                        <!-- block content -->
                        <div class="block-content">
                            <!-- grid box -->
                            <div class="grid-box">
                                <div class="title-section">
                                    <h1><span>Bare Acts</span></h1>
                                </div>

                                <div class="image-post-slider">
                                    <ul class="list-group">
                                        <?php foreach ($bareacts as $bareact): ?> 
                                            <li class="list-group-item">
                                                <i class="fa fa-legal mr-2"></i>
                                                <a href="<?= base_url('bareacts/actionView/' . $bareact['ba_key']) ?>" class="ba-anchor">
                                                    <?= esc($bareact['ba_title']) ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>															
                            </div>
                            <!-- End grid box -->
                        </div>
                        <!-- End block content -->
                    </div>
                </div>
                <!-- End sidebar -->
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->
    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>
</body>
</html>