<!DOCTYPE html>
<html lang="en" class="no-js">
<?= $this->include('partials/header') ?>
<body>
    <!-- Container -->
    <div id="container">
        <!-- Navbar -->
        <?= $this->include('partials/navbar') ?>
        <!-- End Header -->

        <!-- Block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 content-blocker">
                        <!-- Block content -->
                        <div class="block-content">
                            <!-- Grid box -->
                            <div class="grid-box">
                                <div class="title-section">
                                    <div class="row">
                                        <div class="col-md-10">
                                            <h1 style="text-transform: capitalize !important;font-size: 20px">
                                                <?= esc($bareact['ba_title']) ?>
                                            </h1>
                                            <br>
                                        </div>
                                        <div class="col-md-2">
                                            <a class="badge badge-info" href="<?= base_url('bareacts/actionDowload/' . $bareact['ba_key']) ?>">Download Document</a>
                                            <br>
                                        </div>
                                    </div>
                                </div>

                                <div class="image-post-slider">
                                    <table class="table table-bordered">
                                        <tbody>
                                            <?php
                                            $count = 0;
                                            foreach ($sections as $section):
                                                $count++;
                                                $data = json_decode($section['sec_data'], true);
                                                $key = $section['sec_key'];
                                            ?>
                                                <tr>
                                                    <td>
                                                        <b><?= esc($section['sec_title']) ?></b>
                                                    </td>
                                                    <td>
                                                        <b><?= esc($section['sec_particular']) ?></b>
                                                    </td>
                                                </tr>

                                                <?php if ($section['sec_subtitle']): ?>
                                                    <tr>
                                                        <td>
                                                            <b><?= esc($section['sec_subtitle']) ?></b>
                                                        </td>
                                                        <td>
                                                            <b><?= esc($section['sec_subparticular']) ?></b>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php
                                                $seccount = 0;
                                                foreach ($data as $value):
                                                    $seccount++;
                                                ?>
                                                    <tr>
                                                        <td colspan="2">
                                                            <div class="panel-group panel-group-theme">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <a data-toggle="collapse" href="#sec<?= $count . $seccount ?>" class="ba-anchor">
                                                                            <b><?= nl2br(esc($value[0])) ?></b>
                                                                            <i class="accordion_icon fa fa-plus"></i>
                                                                        </a>
                                                                    </div>
                                                                    <div id="sec<?= $count . $seccount ?>" class="panel-collapse collapse">
                                                                        <div class="panel-body">
                                                                            <span class="panel-description">
                                                                                <?= nl2br(esc($value[1])) ?>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- End grid box -->
                        </div>
                        <!-- End block content -->
                    </div>
                </div>
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- Footer -->
        <?= $this->include('partials/footer') ?>
        <!-- End footer -->
    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>
        
    <script>
    $(document).ready(function() {
        $('.panel-heading > a').click(function () {
            $(this).find('i').toggleClass('fa-plus fa-minus')
                .closest('.panel').siblings('.panel')
                .find('i')
                .removeClass('fa-minus').addClass('fa-plus');
        });
    });
</script>
</body>
</html>