<!DOCTYPE html>
<html lang="en" class="no-js">
<?= $this->include('partials/header') ?>
<body>
    <!-- Container -->
    <div id="container">
        <!-- Header section removed for brevity -->

        <!-- block-wrapper-section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-3 col-sm-12 mt-standard">
                        <div class="title-section">
                            <br>
                            <h1><span>Payment Gateway</span></h1>
                            <button class="btn btn-theme btn-lg btn-block" id="rzp-button1">Please Renew Subscription</button>
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12 mt-standard">
                        <div class="contact-form-box">
                            <div class="row">
                                <div class="col-md-9">
                                    <img style="width: 100%" class="img-responsive" src="<?= base_url('assets/site/images/payment.jpg') ?>" alt="Payment Image">
                                </div>
                                <div class="col-md-3">
                                    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
                                    <form name='razorpayform' action="<?= base_url('users/actionVerify') ?>" method="POST">
                                        <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                                        <input type="hidden" name="razorpay_signature" id="razorpay_signature">
                                        <input type="hidden" value="<?= $user_key ?>" name="user_key" id="user_key">
                                        <?= csrf_field() ?> <!-- CSRF protection -->
                                    </form>
                                </div>
                            </div>
                            <br><br><br><br>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End block-wrapper-section -->

        <!-- Footer section removed for brevity -->
    </div>
    <!-- End Container -->

    <?= $this->include('partials/scripts') ?>

    <script>
        // Checkout details as a json
        var options = <?= $razor ?>;

        /**
         * The entire list of Checkout fields is available at
         * https://docs.razorpay.com/docs/checkout-form#checkout-fields
         */
        options.handler = function (response) {
            document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
            document.getElementById('razorpay_signature').value = response.razorpay_signature;
            document.razorpayform.submit();
        };

        // Boolean whether to show image inside a white frame. (default: true)
        options.theme.image_padding = false;

        options.modal = {
            ondismiss: function () {
                console.log("This code runs when the popup is closed");
            },
            // Boolean indicating whether pressing escape key 
            // should close the checkout form. (default: true)
            escape: true,
            // Boolean indicating whether clicking translucent blank
            // space outside checkout form should close the form. (default: false)
            backdropclose: false
        };

        var rzp = new Razorpay(options);

        document.getElementById('rzp-button1').addEventListener('click', function (e) {
            rzp.open();
            e.preventDefault();
        });
    </script>




</body>
</html>



