<!DOCTYPE html>
<html lang="en" class="no-js">
<head>
    <title>Exploring Laws: Insightful Articles on Various Legal Topics</title>
    <meta name="description" content="Explore informative articles covering various laws of India, offering insights, explanations, and analysis on diverse legal topics and legislations" />
    <?= $this->include('partials/header') ?>
</head>
<body>
    <!-- Container -->
    <div id="container">
        <style>
            #paging { margin-top: 70px !important; }
        </style>

        <!-- Header -->
        <?= $this->include('partials/navbar') ?>

        <!-- Articles Section -->
        <section class="block-wrapper">
            <div class="container">
                <div class="row mt-standard">
                    <div class="col-md-12 col-sm-12">
                        <div class="widget review-widget">
                            <div class="title-section">
                                <h1><span>Articles</span></h1>
                            </div>

                            <ul class="judgements-list row" id="list" style="list-style: none !important">
                                <?php foreach ($articles as $article): ?>
                                    <?php
                                    // Prepare article data
                                    $articleKey = $article['article_key'];
                                    $articleImage = base_url("uploads/articles/{$article['article_image']}");
                                    $articleTitle = $article['article_title'];
                                    $articleDate = (new DateTime($article['article_date']))->format('d-F-Y');
                                    $articleAuthor = $article['author_name'];
                                    $articleViewTitle = preg_replace('/[^A-Za-z0-9. -]/', '', $articleTitle);
                                    $articleViewTitle = preg_replace('/\s+/', '-', $articleViewTitle);
                                    $articleView = site_url("articles/actionView/{$articleKey}/{$articleViewTitle}");
                                    ?>
                                    <li>
                                        <div class="col-md-3">
                                            <a href="<?= esc($articleView) ?>">
                                                <div class="card card-inner bg-card-theme-inner">
                                                    <img class="img-responsive" src="<?= esc($articleImage) ?>" alt="<?= esc($articleTitle) ?>">
                                                    <div class="card-body card-body-theme">
                                                        <h5 class="card-title bg-card-theme-title">
                                                            <?= esc($articleTitle) ?>
                                                        </h5>
                                                        <ul class="post-tags">
                                                            <li>
                                                                <i class="fa fa-clock-o"></i>
                                                                <span><?= esc($articleDate) ?></span>
                                                            </li>
                                                            <li>
                                                                <i class="fa fa-user"></i>
                                                                <span><?= esc($articleAuthor) ?></span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <?= $this->include('partials/footer') ?>
    </div>

    <?= $this->include('partials/scripts') ?>

    <script>
        $("#list").JPaging({
            pageSize: 48
        });
    </script>
</body>
</html>