<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <style>
        .card-body {
            overflow-x: scroll;
        }
        .paginate_button {
            background: #001d36 !important;
            padding: 4px 12px;
            color: white !important;
            margin: 23px 10px;
            border-radius: 10px;
            position: relative;
            top: 10px;
        }
    </style>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Extend User Subscription
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table id="example" class="table table-responsive-sm table-hover table-outline mb-0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Email</th>
                                                        <th>End Date</th>
                                                        <th>Plan</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($users)): ?>
                                                        <?php foreach ($users as $i => $user): ?>
                                                            <tr>
                                                                <td><?= $i + 1 ?></td>
                                                                <td><?= esc($user['user_email']) ?></td>
                                                                <td>
                                                                    <?= date('d-m-Y', strtotime($user['user_date_updated'])) ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($user['user_plan'] == 1): ?>
                                                                        <span class="badge badge-success">JUNIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                                                                    <?php elseif ($user['user_plan'] == 2): ?>
                                                                        <span class="badge badge-success">SENIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                                                                    <?php else: ?>
                                                                        <span class="badge badge-success">DONORS AND PROMOTORS</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/users/actionExtend/' . $user['user_key']) ?>" class="badge badge-success btn-danger mb-1">Extend</a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>
        
        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>