<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <style>
        .card-body {
            overflow-x: auto;
        }
        .pagination {
            justify-content: center;
            margin-top: 20px;
        }
        .pagination .page-item.active .page-link {
            background-color: #001d36;
            border-color: #001d36;
        }
        .pagination .page-link {
            color: #001d36;
        }
    </style>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Users
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/users/addUser') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
    <?= $this->include('admin/partials/alerts') ?>
    <table class="table table-responsive-sm table-hover table-outline mb-0">
        <thead>
            <tr>
                <th>Sl No</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Joining Date</th>
                <th>Plan</th>
                <th>Payment Status</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($users)): ?>
                <?php foreach ($users as $i => $user): ?>
                    <tr>
                        <td><?= $pager['startNum'] + $i ?></td>
                        <td><?= esc($user['user_name']) ?></td>
                        <td><?= esc($user['user_email']) ?></td>
                        <td><?= esc($user['user_mobile']) ?></td>
                        <td><?= esc($user['user_date_added']) ?></td>
                        <td>
                            <?php if ($user['user_plan'] == 1): ?>
                                <span class="badge badge-success">JUNIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                            <?php elseif ($user['user_plan'] == 2): ?>
                                <span class="badge badge-success">SENIOR ADVOCATES (BELOW 10 YEARS EXP)</span>
                            <?php else: ?>
                                <span class="badge badge-success">DONORS AND PROMOTORS</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($user['user_payment_status'] == 1): ?>
                                <span class="badge badge-success">Paid</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Not Paid</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($user['user_status'] == 1): ?>
                                <span class="badge badge-success">Enabled</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Disabled</span>
                            <?php endif; ?>
                        </td>
                        <td>
    <div class="d-flex flex-nowrap overflow-auto">
        <?php if ($user['user_status'] == 0 || $user['user_payment_status'] == 0): ?>
            <a href="<?= base_url('admin/users/actionEnable/' . $user['user_key']) ?>" class="btn btn-sm btn-success mr-1">Enable</a>
        <?php else: ?>
            <a href="<?= base_url('admin/users/actionDisable/' . $user['user_key']) ?>" class="btn btn-sm btn-warning mr-1">Disable</a>
        <?php endif; ?>
        
        <a href="<?= base_url('admin/users/edit/' . $user['user_key']) ?>" class="btn btn-sm btn-info mr-1">Edit</a>
        
        <!-- <button type="button" class="btn btn-sm btn-primary mr-1" data-toggle="modal" data-target="#changepassword-<?= $user['user_key'] ?>">
            Change Password
        </button> -->
        
        <a onclick="return confirm('Are you sure you want to delete this user?')" href="<?= base_url('admin/users/actionDelete/' . $user['user_key']) ?>" class="btn btn-sm btn-danger mr-1">
            <i class="fa fa-trash"></i> Delete
        </a>
        
        <a href="<?= base_url('admin/users/sendReminderLink/' . $user['user_key']) ?>" class="btn btn-sm btn-secondary mr-1">Reminder</a>
    </div>
</td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <!-- Improved Pagination -->
    <nav aria-label="Page navigation" class="mt-4">
        <ul class="pagination justify-content-center">
            <?php
            $surroundCount = 2;
            $startPage = max(1, $pager['currentPage'] - $surroundCount);
            $endPage = min($pager['lastPage'], $pager['currentPage'] + $surroundCount);
            ?>
            
            <?php if ($pager['currentPage'] > 1): ?>
                <li class="page-item">
                    <a class="page-link" href="<?= base_url('admin/users?page=' . ($pager['currentPage'] - 1)) ?>" aria-label="Previous">
                        <span aria-hidden="true">&laquo;</span>
                    </a>
                </li>
            <?php endif; ?>
            
            <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                <li class="page-item <?= ($i == $pager['currentPage']) ? 'active' : '' ?>">
                    <a class="page-link" href="<?= base_url('admin/users?page=' . $i) ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
            
            <?php if ($pager['currentPage'] < $pager['lastPage']): ?>
                <li class="page-item">
                    <a class="page-link" href="<?= base_url('admin/users?page=' . ($pager['currentPage'] + 1)) ?>" aria-label="Next">
                        <span aria-hidden="true">&raquo;</span>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </nav>
</div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>
        
        <!-- ... (modal for changing password remains the same) ... -->
    </body>
</html>