<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Tags
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/tags/addTag') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Tag</th>
                                                        <th>Tag Status</th>
                                                        <th>Date Added</th>
                                                        <th>Date Updated</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($tags)): ?>
                                                        <?php
                                                        $count = 0;
                                                        foreach ($tags as $tag):
                                                            $count++;
                                                        ?>
                                                            <tr>
                                                                <td><?= $count ?></td>
                                                                <td><?= esc($tag['category']) ?></td>
                                                                <td>
                                                                    <?php if ($tag['category_status'] == 1): ?>
                                                                        <a href="#" class="badge badge-secondary">Active</a>
                                                                    <?php else: ?>
                                                                        <a href="#" class="badge badge-secondary">Disabled</a>
                                                                    <?php endif ?>
                                                                </td>
                                                                <td><?= esc($tag['category_date_added']) ?></td>
                                                                <td><?= esc($tag['category_date_updated']) ?></td>
                                                                <td>
                                                                    <?php if ($tag['category_status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/tags/actionEnable/' . $tag['category_key']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/tags/actionDisable/' . $tag['category_key']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif ?>
                                                                    <a href="<?= base_url('admin/tags/actionEditTag/' . $tag['category_key']) ?>" class="badge badge-success"><i class="fa-sharp fa-solid fa-pen-to-square"></i></a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/tags/actionDeleteTag/' . $tag['category_key']) ?>" class="badge badge-danger"><i class="fa-solid fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="6">Tags not found.</td>
                                                        </tr>
                                                    <?php endif ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>