<!DOCTYPE html>
<html lang="en">
    <style>
        .card-body {
            overflow-x: scroll;
        }
        .paginate_button {
            background: #001d36 !important;
            padding: 4px 12px;
            color: white !important;
            margin: 23px 10px;
            border-radius: 10px;
            position: relative;
            top: 10px;
        }
    </style>
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    News
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/news/add') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table id="example" class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Tag</th>
                                                        <th>Title</th>
                                                        <th>Image</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($news)): ?>
                                                        <?php
                                                        $count = 1;
                                                        foreach ($news as $new):
                                                        ?>
                                                            <tr>
                                                                <td><?= $count++ ?></td>
                                                                <td><?= esc($new['category']) ?></td>
                                                                <td><?= esc($new['news_title']) ?></td>
                                                                <td>
                                                                    <a class="badge badge-primary" target="_blank" href="<?= base_url('writable/uploads/article/' . $new['article_image']) ?>"><i class="fa-solid fa-eye"></i></a>
                                                                </td>
                                                                <td>
                                                                    <?php if ($new['news_status'] == 1): ?>
                                                                        <a href="#" class="badge badge-secondary">Active</a>
                                                                    <?php else: ?>
                                                                        <a href="#" class="badge badge-secondary">Disabled</a>
                                                                    <?php endif ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($new['news_status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/news/actionEnable/' . $new['news_key']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/news/actionDisable/' . $new['news_key']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif ?>
                                                                    <a href="<?= base_url('admin/news/actionEdit/' . $new['news_key']) ?>" class="badge badge-primary"><i class="fa-sharp fa-solid fa-pen-to-square trigger"></i></a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/news/actionDelete/' . $new['news_key']) ?>" class="badge badge-danger"><i class="fa-solid fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="10">News not found.</td>
                                                        </tr>
                                                    <?php endif ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>

        <?= $this->include('admin/partials/scripts') ?>
        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>