<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    New lawyers List
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/newlawyers/add') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Name</th>
                                                        <th>Phone</th>
                                                        <th>Year of experience</th>
                                                        <th>Area of practice</th>
                                                        <th>Office address</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($new_lawyers)): ?>
                                                        <?php
                                                        $count = 1;
                                                        foreach ($new_lawyers as $cat):
                                                        ?>
                                                            <tr>
                                                                <td><?= $count++ ?></td>
                                                                <td><?= esc($cat['new_lawyers_name']) ?></td>
                                                                <td><?= esc($cat['new_lawyers_phone']) ?></td>
                                                                <td><?= esc($cat['new_lawyers_exp']) ?></td>
                                                                <td><?= strip_tags($cat['new_lawyers_are_p']) ?></td>
                                                                <td><?= strip_tags($cat['new_lawyers_office']) ?></td>
                                                                <td>
                                                                    <?php if ($cat['new_lawyers_status'] == 1): ?>
                                                                        <a href="#" class="badge badge-secondary">Active</a>
                                                                    <?php else: ?>
                                                                        <a href="#" class="badge badge-secondary">Disabled</a>
                                                                    <?php endif ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($cat['new_lawyers_status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/newlawyers/actionEnable/' . $cat['new_lawyers_key']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/newlawyers/actionDisable/' . $cat['new_lawyers_key']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif ?>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/newlawyers/actionDelete/' . $cat['new_lawyers_key']) ?>" class="badge badge-danger"><i class="fa-solid fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="10">Sub Courts not found.</td>
                                                        </tr>
                                                    <?php endif ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>