<!DOCTYPE html>
<html lang="en">
<head>
    <style>
        .over-flow-of-body {
            overflow-x: scroll;
        }
        .paginate_button {
            background: #001d36 !important;
            padding: 4px 12px;
            color: white !important;
            margin: 23px 10px;
            border-radius: 10px;
            position: relative;
            top: 10px;
        }
    </style>
    <?= $this->include('admin/partials/header') ?>
</head>
<body class="c-app">
    <?= $this->include('admin/partials/sidenav') ?>
    <div class="c-wrapper c-fixed-components">
        <?= $this->include('admin/partials/navbar') ?>
        <div class="c-body">
            <main class="c-main">
                <div class="container-fluid">
                    <div class="fade-in">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-md-6">
                                                Lawyers
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body over-flow-of-body">
                                        <?= $this->include('admin/partials/alerts') ?>
                                        <table id="example" class="table table-responsive-sm table-hover table-outline mb-0">
                                            <thead>
                                                <tr>
                                                    <th>Sl No</th>
                                                    <th>Image</th>
                                                    <th>Name</th>
                                                    <th>Experience</th>
                                                    <th>Practice Areas</th>
                                                    <th>Mobile</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if (!empty($lawyers)): ?>
                                                    <?php foreach ($lawyers as $index => $lawyer): ?>
                                                        <?php if ($lawyer['Lawyer_Name']): ?>
                                                            <?php
                                                            $mImage = $lawyer['Image'] 
                                                                ? base_url('uploads/lawyers/' . $lawyer['Image'])
                                                                : base_url('assets/site/images/user.png');
                                                            ?>
                                                            <tr>
                                                                <td><?= $index + 1 ?></td>
                                                                <td><img width="30" height="30" src="<?= esc($mImage) ?>" /></td>
                                                                <td><?= esc($lawyer['Lawyer_Name']) ?></td>
                                                                <td><?= esc($lawyer['Experience']) ?></td>
                                                                <td><?= esc($lawyer['Practice_Areas']) ?></td>
                                                                <td><?= esc($lawyer['Phone_Number']) ?></td>
                                                                <td>
                                                                    <a href="#" class="badge badge-secondary">
                                                                        <?= $lawyer['Status'] == 1 ? 'Active' : 'Disabled' ?>
                                                                    </a>
                                                                </td>
                                                                <td>
                                                                    <?php if ($lawyer['Status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/lawyers/actionEnable/' . $lawyer['L_id']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/lawyers/actionDisable/' . $lawyer['L_id']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="10">Lawyers not found.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <?= $this->include('admin/partials/footer') ?>
        </div>
    </div>
    <?= $this->include('admin/partials/scripts') ?>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
</body>
</html>