<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Add Bare Act Section
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/sections') ?>">Bare Act Sections List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <?= form_open_multipart('admin/sections/actionAddSection', ['id' => 'articleForm']) ?>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="bareact">Bare Act:</label>
                                                            <select required class="form-control" name="bareact">
                                                                <option selected value="" disabled>Select Bare Act</option>
                                                                <?php foreach ($bareacts as $bareact): ?>
                                                                    <option value="<?= $bareact['ba_key'] ?>"><?= $bareact['ba_title'] ?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input required name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="particular">Particulars:</label>
                                                            <input required name="particular" id="particular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="subtitle">Sub Title:</label>
                                                            <input name="subtitle" id="subtitle" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="subparticular">Sub Particulars:</label>
                                                            <input name="subparticular" id="subparticular" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <table id="myTable" class="table order-list table-responsive-sm table-hover table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>Title</th>
                                                                    <th>Content</th>
                                                                    <th></th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <textarea required name="data[1][]" class="form-control" rows="5"></textarea>
                                                                    </td>
                                                                    <td>
                                                                        <textarea required name="data[1][]" class="form-control" rows="5"></textarea>
                                                                    </td>
                                                                    <td>
                                                                        <a class="deleteRow"></a>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <td colspan="5" style="text-align: left;">
                                                                        <input type="button" class="btn btn-info btn-block" id="addrow" value="Add Another Section" />
                                                                    </td>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            <?= form_close() ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                var counter = 2;

                $("#addrow").on("click", function () {
                    var rowCount = $('#myTable tr').length;
                    var count = rowCount;
                    var newRow = $("<tr>");
                    var cols = "";

                    cols += '<td><textarea name="data[' + counter + '][]" class="form-control" rows="5"></textarea></td>';
                    cols += '<td><textarea name="data[' + counter + '][]" class="form-control" rows="5"></textarea></td>';

                    cols += '<td><input type="button" class="ibtnDel btn btn-danger"  value="Delete"></td>';
                    newRow.append(cols);
                    $("table.order-list").append(newRow);
                    counter++;
                });

                $("table.order-list").on("click", ".ibtnDel", function (event) {
                    $(this).closest("tr").remove();
                    counter -= 1
                });
            });

            function calculateRow(row) {
                var price = +row.find('input[name^="price"]').val();
            }

            function calculateGrandTotal() {
                var grandTotal = 0;
                $("table.order-list").find('input[name^="price"]').each(function () {
                    grandTotal += +$(this).val();
                });
                $("#grandtotal").text(grandTotal.toFixed(2));
            }
        </script>
    </body>
</html>