<!DOCTYPE html>
<html lang="en">
    <?= include('admin/partials/header') ?>
    <body class="c-app">
        <?= include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Lawyer
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/newlawyers') ?>">Lawyer List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php if (!empty($new_lawyers)): ?>
                                                <?php
                                                $courtKey = $new_lawyers['new_lawyers_district_key'];
                                                $mTitle = $new_lawyers['new_lawyers_name'];
                                                $mPhone = $new_lawyers['new_lawyers_phone'];
                                                $mExp = $new_lawyers['new_lawyers_exp'];
                                                $mArea = $new_lawyers['new_lawyers_are_p'];
                                                $image = $new_lawyers['new_lawyers_image'];
                                                $desc = $new_lawyers['new_lawyers_desc'];
                                                $subcourtkey = $new_lawyers['new_lawyers_key'];
                                                ?>
                                            <?php endif; ?>

                                            <?= include('admin/partials/alerts') ?>
                                            <form id="articleForm" method="POST" action="<?= base_url('admin/newlawyers/actionUpdate/' . $new_lawyers_key) ?>" enctype="multipart/form-data">
                                                <img id="previewImage" height="400" class="card-img-top" src="<?= base_url('uploads/courts/' . $image) ?>" alt="Court Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="exampleFormControlInput1">Image</label>
                                                            <input name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="title">Lawyer:</label>
                                                            <select class="form-control" name="court" id="court" required="">
                                                                <option selected="" disabled="" value="">Select District</option>
                                                                <?php foreach ($new_lawyers as $key => $new_lawyer): ?>
                                                                    <option value="<?= $new_lawyer['district_key'] ?>" <?= ($district_key == $new_lawyer['district_key']) ? 'selected' : '' ?>>
                                                                        <?= $new_lawyer['district_name'] ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-">
                                                        <div class="form-group">
                                                            <label for="title">Name:</label>
                                                            <input value="<?= $mTitle ?>" required="" name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-">
                                                        <div class="form-group">
                                                            <label for="title">Phone:</label>
                                                            <input value="<?= $mPhone ?>" required="" name="phone" id="phone" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-">
                                                        <div class="form-group">
                                                            <label for="title">Experience:</label>
                                                            <input value="<?= $mExp ?>" required="" name="exp" id="exp" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Area of Experience:</label>
                                                            <input value="<?= $mArea ?>" required="" name="area_of_exp" id="area_of_exp" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Address:</label>
                                                            <textarea class="form-control" name="description" id="editor" required="required"><?= html_entity_decode($desc) ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= include('admin/partials/footer') ?>
            </div>
        </div>
        <?= include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>