<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <!-- /.row-->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Kannada Article
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/kannada') ?>">Articles List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <?php
                                            if (!empty($article)) {
                                                $title = $article['kannada_title'];
                                                $desc = $article['kannada_data'];
                                                $image = $article['kannada_image'];
                                                $attach = $article['kannada_attachment'];
                                                $date = $article['kannada_date'];
                                                $articlekey = $article['kannada_key'];
                                            } else {
                                                $categoryname = set_value('category');
                                            }
                                            ?>
                                            <?= form_open_multipart('admin/kannada/actionUpdate/' . $articlekey, ['id' => 'articleForm']) ?>
                                                <img id="previewImage" height="400" class="card-img-top" src="<?= base_url('uploads/kannada/' . $image) ?>" alt="Article Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="image">Image</label>
                                                            <input name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="date">Date</label>
                                                            <input value="<?= $date ?>" required name="date" id="date" type="date" class="form-control" />
                                                        </div>  
                                                    </div>
                                                     <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="attachment">
                                                                Attachment 
                                                                <?php if ($attach): ?>
                                                                    - <a download href="<?= base_url('uploads/kannada/' . $attach) ?>" class="badge badge-info">Download Attachment</a>
                                                                <?php endif; ?>
                                                            </label>
                                                            <input name="attachment" id="attachment" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input value="<?= $title ?>" required name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="editor">Content:</label>
                                                            <textarea class="form-control" name="description" id="editor" required><?= html_entity_decode($desc) ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            <?= form_close() ?>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col-->
                            </div>
                            <!-- /.row-->
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <!-- CoreUI and necessary plugins-->
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>