<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body>
        <?= $this->include('admin/partials/navbar') ?>
        <div class="container-fluid">
            <div class="row">
                <?= $this->include('admin/partials/sidebar') ?>
                <main role="main" class="col-md-9 ml-sm-auto col-lg-10 pt-3 px-4 mb-2">
                    <?= $this->include('admin/partials/alerts') ?>
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                        <h1 class="h2">Edit Category</h1>
                        <div class="btn-toolbar mb-2 mb-md-0">
                            <a href="<?= base_url('admin/category') ?>" class="btn btn-sm btn-outline-primary">List Categories</a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <form id="categoryForm" method="POST" action="<?= base_url('admin/category/actionUpdateCategory/' . $category['category_key']) ?>" enctype="multipart/form-data">
                                    <?= csrf_field() ?>
                                    <div class="card-body">
                                        <?php
                                        $categoryname = $category['category'] ?? old('category');
                                        $categorykey = $category['category_key'] ?? '';
                                        ?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="category">Category Name</label>
                                                    <input value="<?= esc($categoryname) ?>" required type="text" class="form-control" id="category" name="category">
                                                </div>  
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-outline-dark btn-block">Update Category</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>

        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>