<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Bare Act
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/bareacts') ?>">Bare Acts List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?php
                                            $title = $parent['ba_title'] ?? set_value('title');
                                            $doc = $parent['ba_document'] ?? '';
                                            $date = $parent['ba_date'] ?? '';
                                            $baKey = $parent['ba_key'] ?? '';
                                            ?>
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <form id="articleForm" method="POST" action="<?= base_url('admin/bareacts/actionUpdateBareact/' . $baKey) ?>" enctype="multipart/form-data">
                                                <?= csrf_field() ?>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input value="<?= esc($title) ?>" required name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="docdate">Document date</label>
                                                            <input value="<?= esc($date) ?>" required name="docdate" id="docdate" type="date" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="image">Document</label>
                                                            <input name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                        <?php if ($doc): ?>
                                                            <a download href="<?= base_url('uploads/bareacts/' . $doc) ?>" class="badge badge-primary mb-2">Download uploaded document</a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                var counter = 2;

                $("#addrow").on("click", function () {
                    var rowCount = $('#myTable tr').length;
                    var count = rowCount - 1;
                    var newRow = $("<tr>");
                    var cols = "";

                    cols += '<td><input hidden name="section[' + count + '][]" value="" /><textarea name="section[' + count + '][]" class="form-control" rows="5"></textarea></td>';
                    cols += '<td><textarea name="section[' + count + '][]" class="form-control" rows="5"></textarea></td>';

                    cols += '<td><a class="ibtnDel btn btn-sm btn-danger text-white"><i class="fa fa-trash"></i></a></td>';
                    newRow.append(cols);
                    $("table.order-list").append(newRow);
                    counter++;
                });

                $("table.order-list").on("click", ".ibtnDel", function (event) {
                    $(this).closest("tr").remove();
                    counter -= 1
                });
            });
        </script>
    </body>
</html>