<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Edit Article
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/articles') ?>">Articles List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <?php
                                            if (!empty($article)) {
                                                $categoryKey = $article['category_key'];
                                                $title = $article['article_title'];
                                                $desc = $article['article_description'];
                                                $image = $article['article_image'];
                                                $attach = $article['article_attachment'];
                                                $authorKey = $article['article_author'];
                                                $date = $article['article_date'];
                                                $articlekey = $article['article_key'];
                                            } else {
                                                $categoryname = set_value('category');
                                            }
                                            ?>
                                            <form id="articleForm" method="POST" action="<?= base_url('admin/articles/actionUpdateArticle/' . $articlekey) ?>" enctype="multipart/form-data">
                                                <?= csrf_field() ?>
                                                <img id="previewImage" height="400" class="card-img-top" src="<?= base_url('uploads/articles/' . $image) ?>" alt="Article Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="image">Image</label>
                                                            <input name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="category">Tag</label>
                                                            <select required class="form-control" id="category" name="category">
                                                                <?php if (!empty($categories)): ?>
                                                                    <option selected disabled>Select Tag</option>
                                                                    <?php foreach ($categories as $cat): ?>
                                                                        <option value="<?= $cat['category_key'] ?>" <?= ($cat['category_key'] == $categoryKey) ? 'selected' : '' ?>><?= $cat['category'] ?></option>
                                                                    <?php endforeach; ?>
                                                                <?php else: ?>
                                                                    <option selected disabled>No Tags</option>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="author">Author</label>
                                                            <select required class="form-control" id="author" name="author">
                                                                <?php if (!empty($authors)): ?>
                                                                    <option selected disabled>Select Author</option>
                                                                    <?php foreach ($authors as $author): ?>
                                                                        <option value="<?= $author['author_key'] ?>" <?= ($author['author_key'] == $authorKey) ? 'selected' : '' ?>><?= $author['author_name'] ?></option>
                                                                    <?php endforeach; ?>
                                                                <?php else: ?>
                                                                    <option selected disabled>No Authors</option>
                                                                <?php endif; ?>
                                                            </select>
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="date">Date</label>
                                                            <input value="<?= $date ?>" required name="date" id="date" type="date" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="attachment">
                                                                Attachment 
                                                                <?php if ($attach): ?>
                                                                    - <a download href="<?= base_url('uploads/articles/' . $attach) ?>" class="badge badge-info">Download Attachment</a>
                                                                <?php endif; ?>
                                                            </label>
                                                            <input name="attachment" id="attachment" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input value="<?= $title ?>" required name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="editor">Content:</label>
                                                            <textarea class="form-control" name="description" id="editor" required><?= html_entity_decode($desc) ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>