<!DOCTYPE html>
<html lang="en">
    <style>
        .card-body {
            overflow-x: scroll;
        }
        .paginate_button {
            background: #001d36 !important;
            padding: 4px 12px;
            color: white !important;
            margin: 23px 10px;
            border-radius: 10px;
            position: relative;
            top: 10px;
        }
    </style>
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Bare Acts
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/bareacts/addBareact') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table id="example" class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Title</th>
                                                        <th>Image</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($bareacts)): ?>
                                                        <?php foreach ($bareacts as $count => $bareact): ?>
                                                            <tr>
                                                                <td><?= $count + 1 ?></td>
                                                                <td><?= esc($bareact['ba_title']) ?></td>
                                                                <td>
                                                                    <a download="" class="badge badge-primary" target="_blank" href="<?= base_url('uploads/bareacts/' . $bareact['ba_document']) ?>"><i class="fa-solid fa-download"></i></a>
                                                                </td>
                                                                <td>
                                                                    <?php if ($bareact['ba_status'] == 1): ?>
                                                                        <span class="badge badge-secondary">Active</span>
                                                                    <?php else: ?>
                                                                        <span class="badge badge-secondary">Disabled</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($bareact['ba_status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/bareacts/actionEnable/' . $bareact['ba_key']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/bareacts/actionDisable/' . $bareact['ba_key']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif; ?>
                                                                    <a href="<?= base_url('admin/bareacts/actionEditBareact/' . $bareact['ba_key']) ?>" class="badge badge-primary"><i class="fa-sharp fa-solid fa-pen-to-square"></i></a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/bareacts/actionDeleteBareact/' . $bareact['ba_key']) ?>" class="badge badge-danger"><i class="fa-solid fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="10">Bareacts not found.</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>
        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>