<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Authors
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/authors/add') ?>">Add New</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <table class="table table-responsive-sm table-hover table-outline mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No</th>
                                                        <th>Name</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (!empty($authors)): ?>
                                                        <?php foreach ($authors as $count => $author): ?>
                                                            <tr>
                                                                <td><?= $count + 1 ?></td>
                                                                <td><?= esc($author['author_name']) ?></td>
                                                                <td>
                                                                    <?php if ($author['author_status'] == 1): ?>
                                                                        <span class="badge badge-secondary">Active</span>
                                                                    <?php else: ?>
                                                                        <span class="badge badge-secondary">Disabled</span>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td>
                                                                    <?php if ($author['author_status'] == 0): ?>
                                                                        <a href="<?= base_url('admin/authors/actionEnable/' . $author['author_key']) ?>" class="badge badge-warning text-white">Enable</a>
                                                                    <?php else: ?>
                                                                        <a href="<?= base_url('admin/authors/actionDisable/' . $author['author_key']) ?>" class="badge badge-danger text-white">Disable</a>
                                                                    <?php endif; ?>
                                                                    <a href="<?= base_url('admin/authors/actionEdit/' . $author['author_key']) ?>" class="badge badge-primary"><i class="fa-sharp fa-solid fa-pen-to-square"></i></a>
                                                                    <a onclick="return confirm('Are you sure?')" href="<?= base_url('admin/authors/actionDelete/' . $author['author_key']) ?>" class="badge badge-danger"><i class="fa-solid fa-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="10">Authors not found.</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>
        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });
        </script>
    </body>
</html>