<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Add User
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/users') ?>">Users List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <?= form_open_multipart('admin/users/actionAdd', ['id' => 'articleForm']) ?>
                                                <div class="row mt-3">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="name">Name</label>
                                                            <input class="form-control" required id="name" name="name" type="text">
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="mail">Email</label>
                                                            <input class="form-control" required id="mail" name="email" type="email">
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="plan">Plan</label>
                                                            <select class="form-control" name="plan" required>
                                                                <option disabled selected value="">Select Plan</option>
                                                                <option value="4" <?= ($plan ?? '') == "studentPlan" ? 'selected' : '' ?>>STUDENTS</option>
                                                                <option value="1" <?= ($plan ?? '') == "juniorPlan" ? 'selected' : '' ?>>JUNIOR ADVOCATES (BELOW 10 YEARS EXP)</option>
                                                                <option value="2" <?= ($plan ?? '') == "seniorPlan" ? 'selected' : '' ?>>SENIOR ADVOCATES (ABOVE 10 YEARS EXP)</option>
                                                                <option value="3" <?= ($plan ?? '') == "donorsPlan" ? 'selected' : '' ?>>DONORS AND PROMOTORS</option>
                                                            </select>
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="mobile">Mobile:</label>
                                                            <input class="form-control" required id="mobile" name="mobile" type="tel">                       
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="password">Password:</label>
                                                            <input class="form-control" required id="password" name="password" type="password">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="confirm_password">Confirm Password:</label>
                                                            <input class="form-control" required id="confirm_password" name="confirm_password" type="password">
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            <?= form_close() ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>