<!DOCTYPE html>
<html lang="en">
    <?= $this->include('admin/partials/header') ?>
    <body class="c-app">
        <?= $this->include('admin/partials/sidenav') ?>
        <div class="c-wrapper c-fixed-components">
            <?= $this->include('admin/partials/navbar') ?>
            <div class="c-body">
                <main class="c-main">
                    <div class="container-fluid">
                        <div class="fade-in">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    Add Kannada Article
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <a class="badge badge-info" href="<?= base_url('admin/kannada') ?>">Kannada Articles List</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <?= $this->include('admin/partials/alerts') ?>
                                            <form id="articleForm" method="POST" action="<?= base_url('admin/kannada/actionAdd') ?>" enctype="multipart/form-data">
                                                <?= csrf_field() ?>
                                                <img id="previewImage" height="400" class="card-img-top" src="https://via.placeholder.com/800x400" alt="Article Image">
                                                <div class="row mt-3">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="image">Image</label>
                                                            <input required name="image" id="image" type="file" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="date">Date</label>
                                                            <input required name="date" id="date" type="date" class="form-control" />
                                                        </div>  
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label for="attachment">Attachment:</label>
                                                            <input class="form-control" name="attachment" id="attachment" type="file">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="title">Title:</label>
                                                            <input required name="title" id="title" type="text" class="form-control" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label for="editor">Content:</label>
                                                            <textarea class="form-control" name="description" id="editor" required></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?= $this->include('admin/partials/footer') ?>
            </div>
        </div>
        <?= $this->include('admin/partials/scripts') ?>

        <script>
            $(document).ready(function () {
                $('#example').DataTable();
            });

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#previewImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#image").change(function () {
                readURL(this);
            });
        </script>
    </body>
</html>