<!DOCTYPE html>
<html lang="en" class="no-js">
    <?= $this->include('partials/header') ?>
    <body>
        <div id="container">
            <?= $this->include('partials/navbar') ?>

            <section class="block-wrapper">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12 col-sm-12 mt-standard">
                            <div class="title-section">
                                <br>
                                <h1><span>Sign Up</span></h1>
                            </div>
                            <div class="contact-form-box">
                                <form id="signupForm" action="<?= base_url('users/actionAdd') ?>" method="POST">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="name">Name*</label>
                                            <input required id="name" name="name" type="text">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="mail">E-mail*</label>
                                            <input required id="mail" name="email" type="email">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="website">Plan*</label>
                                            <select name="plan" required>
                                                <option disabled selected value="">Select Plan</option>
                                                <option <?= $plan == "studentPlan" ? 'selected' : '' ?> value="4">STUDENTS</option>
                                                <option <?= $plan == "juniorPlan" ? 'selected' : '' ?> value="1">JUNIOR ADVOCATES (BELOW 10 YEARS EXP)</option>
                                                <option <?= $plan == "seniorPlan" ? 'selected' : '' ?> value="2">SENIOR ADVOCATES (ABOVE 10 YEARS EXP)</option>
                                                <option <?= $plan == "donorsPlan" ? 'selected' : '' ?> value="3">DONORS AND PROMOTORS</option>
                                                <option <?= $plan == "generalPlan" ? 'selected' : '' ?> value="5">General Public</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="mobile">Mobile*</label>
                                            <input required id="mobile" name="mobile" type="tel">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="password">Password*</label>
                                            <input required id="password" name="password" type="password">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="confirm_password">Confirm Password*</label>
                                            <input required id="confirm_password" name="confirm_password" type="password">
                                        </div>
                                    </div>
                                    <button class="btn btn-lg btn-theme text-uppercase" type="submit" id="submit-contact">
                                        <i class="fa fa-paper-plane"></i> Submit
                                    </button>
                                </form>
                                <br>
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <?= $this->include('partials/footer') ?>
        </div>

        <?= $this->include('partials/scripts') ?>
    </body>
</html>