<?php

namespace App\Models;

use CodeIgniter\Model;

class UsersModel extends Model
{
    protected $table = 'users';
    
    protected $primaryKey = 'user_id';
    protected $allowedFields = ['user_name', 'user_email', 'user_password', 'user_mobile', 'user_key', 'user_status', 'user_payment_status', 'user_date_updated'];

    protected $session;

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
    }

    public function getAllParent()
    {
        try {
            return $this->orderBy('user_id', 'DESC')->findAll();
        } catch (\Exception $e) {
            log_message('error','for data' . $e->getMessage());
            return [];
        }
    }
   
    public function getAllApproved()
    {
        $mSessionKey = $this->session->get('session_key');
        $query = $this->where('user_status', 1);
        if ($mSessionKey) {
            $query->where('user_key !=', $mSessionKey);
        }
        return $query->findAll();
    }

    public function getAllApprovedBySearch($mSearch)
    {
        $mSessionKey = $this->session->get('session_key');
        $query = $this->where('user_status', 1)
                      ->like('user_name', $mSearch);
        if ($mSessionKey) {
            $query->where('user_key !=', $mSessionKey);
        }
        return $query->findAll();
    }

    public function checkUser($param)
    {
        return $this->where('user_email', $param)->first();
    }

    public function getUserByEmail($param)
    {
        return $this->where('user_email', $param)->first();
    }

    public function addUser($data)
    {
        log_message('info', 'User Added: ' . $data['user_email']);
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function authenticateUser($mUserName, $mPassword)
    {
        $user = $this->where('user_email', $mUserName)
                     ->where('user_password', $mPassword)
                     ->where('user_status', 1)
                     ->where('user_payment_status', 1)
                     ->first();

        if ($user) {
            $this->setSession($user);
            return true;
        }
        return false;
    }

    public function getParentByKey($param)
    {
        return $this->where('user_key', $param)->first();
    }

    public function getParentByKeyForFavs($param)
    {
        return $this->where('user_key', $param)->findAll();
    }

   public function updateParentByKey($param, $data)
{
    // Filter the data array to only include allowed fields
    $data = array_intersect_key($data, array_flip($this->allowedFields));

    if (empty($data)) {
        log_message('error', 'Update failed: No valid fields to update');
        return false;
    }

    try {
        $result = $this->where('user_key', $param)->set($data)->update();
        if ($result === false) {
            log_message('error', 'Update failed: ' . print_r($this->db->error(), true));
        }
        return $result;
    } catch (\Exception $e) {
        log_message('error', 'Update failed: ' . $e->getMessage());
        return false;
    }
}
    public function deleteParentByKey($param)
    {
        return $this->where('user_key', $param)->delete();
    }

    public function setSession($data)
    {
        $this->session->set([
            'session_id' => $data['user_id'],
            'session_name' => $data['user_name'],
            'session_email' => $data['user_email'],
            'session_mobile' => $data['user_mobile'],
            'session_key' => $data['user_key'],
            'session_payment' => $data['user_payment_status']
        ]);
    }
}