<?php

namespace App\Models;

use CodeIgniter\Model;

class SubcourtModel extends Model
{
    protected $table = 'subcourts';
    protected $primaryKey = 'subcourt_id';
    protected $allowedFields = ['subcourt_name', 'subcourt_key', 'subcourt_court_key', 'subcourt_status', 'article_like','subcourt_image','subcourt_desc'];

    protected $db;
    protected $session;

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
        $this->session = \Config\Services::session();
    }

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->select('subcourts.*, courts.*')
                    ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                    ->orderBy('subcourt_id', 'DESC')
                    ->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->select('subcourts.*, courts.*')
                    ->where('subcourt_status', 1)
                    ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                    ->orderBy('subcourt_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        $subcourts = $this->select('subcourts.*, courts.*')
                          ->where('subcourt_status', 1)
                          ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                          ->findAll();

        return array_filter($subcourts, function($value) {
            return !empty($value['article_like']);
        });
    }

    public function getParentByKey($param)
    {
        return $this->select('subcourts.*, courts.*')
                    ->where('subcourt_key', $param)
                    ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                    ->orderBy('subcourts.subcourt_id')
                    ->first();
    }

    public function getParentByTitle($param)
    {
        return $this->select('subcourts.*, courts.*')
                    ->like('subcourt_name', $param)
                    ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                    ->first();
    }

    public function getAllParentByTitle($param)
    {
        return $this->select('subcourts.*, courts.*')
                    ->like('subcourt_name', $param)
                    ->join('courts', 'courts.court_key = subcourts.subcourt_court_key')
                    ->findAll();
    }

    public function getParentByCourtKey($param)
    {
        return $this->where('subcourt_court_key', $param)
                    ->orderBy('subcourts.subcourt_id')
                    ->findAll();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('subcourt_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('subcourt_key', $param)->delete();
    }
}