<?php

namespace App\Models;

use CodeIgniter\Model;

class SectionModel extends Model
{
    protected $table = 'sections';
    protected $primaryKey = 'sec_id';
    protected $allowedFields = ['sec_key', 'sec_ba_key', 'sec_title', 'sec_desc'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent(array $data): int|bool
    {
        $this->db->table($this->table)->insert($data);
        if ($this->db->affectedRows() > 0) {
            return $this->db->insertID();
        }
        return false;
    }

    public function getAllParent(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->join('bareacts', 'bareacts.ba_key = sections.sec_ba_key')
            ->orderBy('sec_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('ba_status', 1)
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllParentByChildKey(string $key): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('sec_ba_key', $key)
            ->orderBy('sec_id', 'ASC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getParentByKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('sec_key', $param)
            ->orderBy('sec_id')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function updateParentByKey(string $param, array $data): bool
    {
        return $this->db->table($this->table)
            ->where('sec_key', $param)
            ->update($data);
    }

    public function deleteParentByKey(string $param): bool
    {
        $result = $this->db->table($this->table)
            ->where('sec_key', $param)
            ->delete();

        return $this->db->affectedRows() > 0;
    }
}