<?php

namespace App\Models;

use CodeIgniter\Model;

class NewsModel extends Model
{
    protected $table = 'news';
    protected $primaryKey = 'news_id';
    protected $allowedFields = ['news_key', 'category_key', 'news_author', 'news_title', 'news_content', 'news_status'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent(array $data): int|bool
    {
        $this->db->table($this->table)->insert($data);
        if ($this->db->affectedRows() > 0) {
            return $this->db->insertID();
        }
        return false;
    }

    public function getAllParent(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->orderBy('news_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('news_status', 1)
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->orderBy('news_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllTopParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('news_status', 1)
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->get();

        $data = $query->getResultArray();
        if (empty($data)) {
            return false;
        }

        return array_filter($data, fn($value) => !empty($value['article_like']));
    }

    public function getParentByKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('news_key', $param)
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->orderBy('news.news_id')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('news_title', $param)
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getAllParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('news_title', $param)
            ->join('categories', 'categories.category_key = news.category_key')
            ->join('authors', 'authors.author_key = news.news_author')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getParentByCategoryKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('category_key', $param)
            ->orderBy('news.news_id')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function updateParentByKey(string $param, array $data): bool
    {
        return $this->db->table($this->table)
            ->where('news_key', $param)
            ->update($data);
    }

    public function deleteParentByKey(string $param): bool
    {
        $result = $this->db->table($this->table)
            ->where('news_key', $param)
            ->delete();

        return $this->db->affectedRows() > 0;
    }
}