<?php

namespace App\Models;

use CodeIgniter\Model;

class NewsModel extends Model
{
    protected $table = 'news';
    protected $primaryKey = 'news_id';
    protected $allowedFields = ['news_title', 'news_key', 'category_key', 'news_author', 'news_status', 'article_like'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->select('news.*, categories.*, authors.*')
                    ->join('categories', 'categories.category_key = news.category_key')
                    ->join('authors', 'authors.author_key = news.news_author')
                    ->orderBy('news_id', 'DESC')
                    ->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->select('news.*, categories.*, authors.*')
                    ->where('news_status', 1)
                    ->join('categories', 'categories.category_key = news.category_key')
                    ->join('authors', 'authors.author_key = news.news_author')
                    ->orderBy('news_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        $news = $this->select('news.*, categories.*, authors.*')
                     ->where('news_status', 1)
                     ->join('categories', 'categories.category_key = news.category_key')
                     ->join('authors', 'authors.author_key = news.news_author')
                     ->findAll();

        return array_filter($news, function($value) {
            return !empty($value['article_like']);
        });
    }

    public function getParentByKey($param)
    {
        return $this->select('news.*, categories.*, authors.*')
                    ->where('news_key', $param)
                    ->join('categories', 'categories.category_key = news.category_key')
                    ->join('authors', 'authors.author_key = news.news_author')
                    ->orderBy('news.news_id')
                    ->first();
    }

    public function getParentByTitle($param)
    {
        return $this->select('news.*, categories.*, authors.*')
                    ->like('news_title', $param)
                    ->join('categories', 'categories.category_key = news.category_key')
                    ->join('authors', 'authors.author_key = news.news_author')
                    ->first();
    }

    public function getAllParentByTitle($param)
    {
        return $this->select('news.*, categories.*, authors.*')
                    ->like('news_title', $param)
                    ->join('categories', 'categories.category_key = news.category_key')
                    ->join('authors', 'authors.author_key = news.news_author')
                    ->findAll();
    }

    public function getParentByCategoryKey($param)
    {
        return $this->where('category_key', $param)
                    ->orderBy('news.news_id')
                    ->findAll();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('news_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('news_key', $param)->delete();
    }
}