<?php

namespace App\Models;

use CodeIgniter\Model;

class NewLawyersModel extends Model
{
    protected $table = 'new_lawyers';
    protected $primaryKey = 'new_lawyers_id';
    protected $allowedFields = [
        'new_lawyers_name', 
        'new_lawyers_key', 
        'new_lawyers_district_key', 
        'new_lawyers_status',
        'new_lawyers_phone',
        'new_lawyers_exp',
        'new_lawyers_are_p',
        'new_lawyers_office',
        'new_lawyers_image'
    ];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->select('new_lawyers.*, district.*')
                    ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                    ->orderBy('new_lawyers_id', 'DESC')
                    ->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->select('new_lawyers.*, district.*')
                    ->where('new_lawyers_status', 1)
                    ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                    ->orderBy('new_lawyers_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        $lawyers = $this->select('new_lawyers.*, district.*')
                        ->where('new_lawyers_status', 1)
                        ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                        ->findAll();

        return array_filter($lawyers, function($value) {
            return !empty($value['article_like']);
        });
    }

    public function getParentByKey($param)
    {
        return $this->select('new_lawyers.*, district.*')
                    ->where('new_lawyers_key', $param)
                    ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                    ->orderBy('new_lawyers.new_lawyers_id')
                    ->first();
    }

    public function getParentByTitle($param)
    {
        return $this->select('new_lawyers.*, district.*')
                    ->like('new_lawyers_name', $param)
                    ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                    ->first();
    }

    public function getAllParentByTitle($param)
    {
        return $this->select('new_lawyers.*, district.*')
                    ->like('new_lawyers_name', $param)
                    ->join('district', 'district.district_key = new_lawyers.new_lawyers_district_key')
                    ->findAll();
    }

    public function getParentByCourtKey($param)
    {
        return $this->where('new_lawyers_district_key', $param)
                    ->orderBy('new_lawyers.new_lawyers_id')
                    ->findAll();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('new_lawyers_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('new_lawyers_key', $param)->delete();
    }
}