<?php

namespace App\Models;

use CodeIgniter\Model;

class LawyersModel extends Model
{
    protected $table = 'lawyers';
    protected $primaryKey = 'L_id';
    protected $allowedFields = ['Lawyer_Name', 'Email_Id', 'Phone_Number', 'Experience', 'Practice_Areas', 'Address', 'Image', 'Status', 'Timestamp'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->where('Status', 1)->findAll();
    }

    public function getAllParentBySorting()
    {
        return $this->where('Status', 1)
                    ->orderBy('Lawyer_Name', 'ASC')
                    ->findAll();
    }

    public function getAllParentBySortingForAdmin()
    {
        return $this->orderBy('Lawyer_Name', 'ASC')->findAll();
    }

    public function getParentByMobile($param)
    {
        return $this->where('Phone_Number', $param)->first();
    }

    public function getParentByKey($param)
    {
        return $this->find($param);
    }

    public function updateParentByKey($param, $data)
    {
        return $this->update($param, $data);
    }

    public function deleteParentByKey($param)
    {
        return $this->delete($param);
    }
}