<?php

namespace App\Models;

use CodeIgniter\Model;

class KannadaModel extends Model
{
    protected $table = 'kannada';
    protected $primaryKey = 'kannada_id';
    protected $allowedFields = [
        'kannada_key',
        'kannada_date',
        'kannada_title',
        'kannada_data',
        'kannada_image',
        'kannada_attachment',
        'kannada_date_added',
        'kannada_date_updated',
        'kannada_status'
    ];

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->orderBy('kannada_id', 'DESC')->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->where('kannada_status', 1)
                    ->orderBy('kannada_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        return $this->where('kannada_status', 1)->findAll();
    }

    public function getParentByKey($param)
    {
        return $this->where('kannada_key', $param)
                    ->orderBy('kannada_id', 'ASC')
                    ->first();
    }

    public function getParentByTitle($param)
    {
        return $this->like('article_title', $param)->first();
    }

    public function getAllParentByTitle($param)
    {
        return $this->like('article_title', $param)->findAll();
    }

    public function getParentByCategoryKey($param)
    {
        return $this->where('category_key', $param)
                    ->orderBy('kannada_id', 'ASC')
                    ->findAll();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('kannada_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('kannada_key', $param)->delete();
    }
}