<?php

namespace App\Models;

use CodeIgniter\Model;

class JudgementModel extends Model
{
    protected $table = 'judgements';
    protected $primaryKey = 'judgement_id';
    protected $allowedFields = ['judgement_key', 'judgement_category_key', 'judgement_author', 'judgement_title', 'judgement_desc', 'judgement_status'];

    public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

    public function addParent(array $data): int|bool
    {
        $this->db->table($this->table)->insert($data);

        if ($this->db->affectedRows() > 0) {
            return true;
        }
        return false;
    }

    public function getAllParent(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->orderBy('judgement_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('judgement_status', 1)
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->orderBy('judgement_id', 'ASEC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getAllTopParentForSite(): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('judgement_status', 1)
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->get();

        $data = $query->getResultArray();
        if (empty($data)) {
            return false;
        }

        return array_filter($data, fn($value) => !empty($value['article_like']));
    }

    public function getParentByKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('judgement_key', $param)
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('judgement_title', $param)
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->get();

        return $query->getRowArray() ?: false;
    }

    public function getAllParentByTitle(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->like('judgement_desc', $param)
            ->join('categories', 'categories.category_key = judgements.judgement_category_key')
            ->join('authors', 'authors.author_key = judgements.judgement_author')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function getParentByCategoryKey(string $param): array|bool
    {
        $query = $this->db->table($this->table)
            ->select('*')
            ->where('judgement_category_key', $param)
            ->orderBy('judgement_id', 'DESC')
            ->get();

        return $query->getResultArray() ?: false;
    }

    public function updateParentByKey(string $param, array $data): bool
    {
        return $this->db->table($this->table)
            ->where('judgement_key', $param)
            ->update($data);
    }

    public function deleteParentByKey(string $param): bool
    {
        $result = $this->db->table($this->table)
            ->where('judgement_key', $param)
            ->delete();

        return $this->db->affectedRows() > 0;
    }
}