<?php

namespace App\Models;

use CodeIgniter\Model;

class CourtModel extends Model
{
    protected $table = 'courts';
    protected $primaryKey = 'court_id';
    protected $allowedFields = ['court_name', 'court_key', 'court_status', 'article_like'];

    public function addParent($data)
    {
        return $this->insert($data) ? $this->getInsertID() : false;
    }

    public function getAllParent()
    {
        return $this->orderBy('court_id', 'DESC')->findAll();
    }

    public function getAllParentForSite()
    {
        return $this->where('court_status', 1)
                    ->orderBy('court_id', 'DESC')
                    ->findAll();
    }

    public function getAllTopParentForSite()
    {
        $courts = $this->where('court_status', 1)->findAll();
        return array_filter($courts, function($value) {
            return !empty($value['article_like']);
        });
    }

    public function getParentByKey($param)
    {
        return $this->where('court_key', $param)
                    ->orderBy('court_id', 'ASC')
                    ->first();
    }

    public function getParentByTitle($param)
    {
        return $this->like('court_name', $param)->first();
    }

    public function getAllParentByTitle($param)
    {
        return $this->like('court_name', $param)->findAll();
    }

    public function updateParentByKey($param, $data)
    {
        return $this->where('court_key', $param)->set($data)->update();
    }

    public function deleteParentByKey($param)
    {
        return $this->where('court_key', $param)->delete();
    }
}